<?php 
/*
 * login.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */
session_start();
require_once("servidor.php");
require($entradaFILE.'headerHome.php');
require($entradaFILE.'menuHome.php');
?>

<center>
<h2>GeoThms - Geometry Framework</h2>
</center>


<?php
require($entradaFILE.".gttu.php");

// coloca os valores de utilizador e senha nas variveis de Sesso
$_SESSION['dbregular']=$dbregular;
$_SESSION['dbregpass']=$dbregpass;

// faz a ligao ao servidor - como utilizador "regular"
@ $ligacao = mysqli_connect($servidorMySQL,$dbregular,$dbregpass,$databaseName);

// Obtm do formulrio o nome e senha do utilizador GeoThms
$vUsername = $_POST['username'];
$vPassword = $_POST['password'];

if (!$ligacao) {
    echo gettext("Error: Unable to connect to MySQL\n");
    echo gettext("Debugging errno: ").mysqli_connect_errno().PHP_EOL;
    echo gettext("Debugging error: ").mysqli_connect_error().PHP_EOL;
//    echo "<meta http-equiv='refresh' content='3; url=".$entradaURL."index.php' />";
    exit;
}
else {
    // Vai verificar se  um utilizador registado
    // cria uma pesquisa
    $sqlUser = "SELECT name,type,userId
                  FROM users
                 WHERE username='$vUsername'
                   AND passwd=sha1('$vPassword')";
    
    $resultadoUser = mysqli_query($ligacao,$sqlUser);
    
    $ncamposUser = mysqli_num_rows($resultadoUser);
    
    if ($ncamposUser == 0) {
        echo "<h3>Error: username or password</h3>";
        echo "<meta http-equiv='refresh' content='2; url=connect.php' />";
    }
    else {
        $linhaUser = mysqli_fetch_assoc($resultadoUser);
        
        $vName   = $linhaUser['name'];
        $vType   = $linhaUser['type'];
        $vUserId = $linhaUser['userId'];
        
        echo '<h1>Connected to the database GeoThms</h1>';
        
        // ==================================================
        // Vai preencher os dados na tabela de acessos (logs)
        // ==================================================
        $vUserId=addslashes($vUserId);
        $timeLogin=time();
        
        $sqlLogs = "INSERT INTO logs
                      (userId,timeLogin,websystem)
                    VALUES
                      ($vUserId,$timeLogin,'GeoThms')";
        
        $resultadoLogs = mysqli_query($ligacao,$sqlLogs);
        
        if (!$resultadoLogs) {
            echo "<p>Erro: Logs</p>";
            echo "<p>$sqlLogs</p>";
            exit;
        }
        
        
        //
        // separa por tipo de utilizador
        // 
        // utilizador "Contributer" 
        //  Pode consultar os dados
        //  Pode modificar os seus dados pessoais
        //  Pode modificar os dados, nem introduzir novos dados
        if ($vType=="Contributer") {
            $_SESSION['utilizador']=$dbcontrib;
            $_SESSION['senha']=$dbctrbpass;
            $_SESSION['username']=$vUsername;
            $_SESSION['tipoUtilizador']="administrator";
            echo "<meta http-equiv='refresh' content='2; url=contributers.php?name=$vName&type=$vType' />";
        }
        
        // utilizador "Administrator" 
        //  tem acesso ao interface de adminstrao (e s a esse)
        elseif ($vType=="Administrator") {
            $_SESSION['utilizador']=$vUsername;
            $_SESSION['senha']=$vPassword;
            $_SESSION['username']=$vUsername;
            echo "<meta http-equiv='refresh' content='1; url=admins.php?name=$vName&type=$vType' />";
        }
        // utilizador "Anonymous" 
        //  Pode consultar os dados
        //  No pode modificar os seus dados pessoais
        //  No pode modificar os dados, nem introduzir novos dados
        // A diferena entre o utilizador annimo e o regular  feito no ficheiro "users.php"
        elseif ($vType=="Anonymous") { 
            $_SESSION['utilizador']=$dbregular;
            $_SESSION['senha']=$dbregpass;
            $_SESSION['username']=$vUsername;
            $_SESSION['tipoUtilizador']="anonymous";	 
            echo "<meta http-equiv='refresh' content='1; url=users.php?name=$vName&type=$vType' />";
        }
        // utilizador regular
        //  Pode modificar os seus dados pessoais
        //  Pode consultar os dados
        //  No pode modificar os dados, nem introduzir novos dados
        else { 
            $_SESSION['utilizador']=$dbregular;
            $_SESSION['senha']=$dbregpass;
            $_SESSION['username']=$vUsername;
            $_SESSION['tipoUtilizador']="regular";
            echo "<meta http-equiv='refresh' content='1; url=users.php?name=$vName&type=$vType' />";
        }
    }
}

?>

<?php
require($entradaFILE."footer.php");
?>
