<?php
/*
 * auxFunctions.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */


function get_random_word($min_length, $max_length) {
  // grab a random word from dictionary between the two lengths
  // and return it 
  // generate a random word
  $word = "";
  $dictionary = "/etc/dictionaries-common/words"; // Lista de palavras
  $fp = fopen($dictionary, "r");
  $size = filesize($dictionary);

  // go to a random location in dictionary
  srand ((double) microtime() * 1000000);
  $rand_location = rand(0, $size);
  fseek($fp, $rand_location);
  
  // get the next whole word of the right length in the file
  while (strlen($word)< $min_length || strlen($word)>$max_length)
    {
      if (feof($fp))
	fseek($fp, 0); // if at end, go to start
      $word = fgets($fp, 80); // skip first word as it could be partial
      $word = fgets($fp, 80); // the potential password
    };
  $word=trim($word); // trim the trailing \n from fgets
  return $word;
}


?>