<?php
session_start();

/*
 * Scrapbook/scrapbook.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */


// ======================================
// Bloco de Notas - Guardar & Seleccionar
// ======================================

  /*

  Uma tabela contendo uma só linha e cujo propósito é ser encaixada
  numa tabela maior.

  Uma linha com oito colunas.

  Contém as funções do bloco de notas.
  
  -> $nameCallingForm - contém o nome do formulário global

     $pathToScrapbook - contém o caminho desde o formulário de chamada
     até o Bloco de Notas

     $saveActive - 1, se a componente "guardar" deve estar activa
                   0, no caso contrário

     $selectActive - idem para a componente "select"

     $deleteActive - idem para a componente "delete"
  

  <- $pCodeTmpIdName - (na selecção) o identificador da construção
     pertencente ao bloco de notas seleccionada.

  */

// obtém a informação referente ao Número de Identificação do
// utilizador, esta informação é importante em várias secções.
$pUsername = $_SESSION['username'];

$sqlUserId = "SELECT userId
                FROM users
               WHERE username='$pUsername'";

$resultadoUserId = mysqli_query($ligacao,$sqlUserId);

$linhaUserId = mysqli_fetch_assoc($resultadoUserId);
$pUserId=trim($linhaUserId['userId']);

echo "<table border=1 width='100%'>\n";
echo "<tr>\n";
// 1 coluna "título"
echo "<td width='12.5%' colspan='1'>
       <span class='ficha'>Scrapbook</span>
      </td>\n";
$pDrawerId=3; // GCLC
$pDrawerName='GCLC';
// ======================================
// Bloco de Notas - Guardar
// ======================================
// 3(=1+2)colunas - Guardar
if ($saveActive==1) {
  echo "<form action='$pathToScrapbook/saveIntoScrapbook.php' method='post'>";
  echo "<input type='hidden' name='UserId' value='$pUserId'>"; 
  echo "<td width='37.5%' colspan='3' align='center'>
         <input type='submit' value='Save'>
         <input type='text' name='NewNameScrapbook'  MAXLENGTH='20'>
         <span class='ficha'>
          name (max 20 chars)
         </span>
        </td>";
  echo "</form>";
 }
 else {
   echo "<td width='37.5%' colspan='3' align='center'>
          &nbsp; 
         </td>"; 
 }

// ======================================
// Bloco de Notas - Seleccionar
// ======================================
// 2(=1+1)colunas - Seleccionar
if ($selectActive==1) {
  echo "<form action='$pathToScrapbook/selectFromScrapbook.php' method='post'>"; 
  // para poder voltar ao ficheiro de chamada
  echo "<input type='hidden' name='nameCallingForm' value='$nameCallingForm'>";
  
  // vai verificar se existem construções no bloco de notas do utilizador
  // não faz a distinção entre codeTmp e codeTmpProver
  $sqlSelectScrapbook = "SELECT codeTmpId,code,name 
                           FROM codeTmp  
                          WHERE userId=$pUserId 
                            AND name!='temporary'"; 
  $resultadoSelectScrapbook = mysqli_query($ligacao,$sqlSelectScrapbook);
  
  $nlinhasSelectScrapbook = mysqli_num_rows($resultadoSelectScrapbook);
  
  if ($nlinhasSelectScrapbook==0) {// Bloco de Notas vazio
    echo "<td width='25%' colspan='2' align='center'>
       <span class='ficha'>Empty Scrapbook
       </span>
      </td>\n";
  }
  else { // vai permitir seleccionar as construções existentes no
	 // bloco de notas
    
    //   $linhaSelectScrapbook =
    //   mysqli_fetch_assoc($resultadoSelectScrapbook);
    
    $pCodeTmpName=trim($linhaSelectScrapbook['name']);
    $codeTmpId=trim($linhaSelectScrapbook['codeTmpId']);
    
    echo "<td width='25%' colspan='2' align='center'>
          <span class='entrada'>
           <SELECT NAME='CodeTmpIdName'>";
    while ($linhaSelectScrapbook = mysqli_fetch_assoc($resultadoSelectScrapbook)){
      $pCodeTmpName=trim($linhaSelectScrapbook['name']);
      $pCodeTmpIdAux=trim($linhaSelectScrapbook['codeTmpId']);
      
      
      if ($codeTmpId==$pCodeTmpIdAux)
	print "<option selected>$pCodeTmpIdAux - $pCodeTmpName</option>\n"; 
      else
	print "<option>$pCodeTmpIdAux - $pCodeTmpName</option>\n"; 
    };
    echo " </SELECT></span>
           &nbsp;<input type='submit' value='Select'>
          </td>\n";
  }
  echo "</form>";
 }
 else {
   echo "<td width='25%' colspan='2'>&nbsp;</td>\n";
 }
   
// ======================================
// Bloco de Notas - Apagar
// ======================================
// 2(=1+1)colunas - Apagar
if ($deleteActive==1) {
  echo "<form action='$pathToScrapbook/deleteFromScrapbook.php' method='post'>";
  
  // vai verificar se existem construções no bloco de notas do utilizador
  $sqlDeleteFromScrapbook = "SELECT codeTmpId,code,name
                               FROM codeTmp
                              WHERE userId=$pUserId
                                AND name!='temporary'";

  $resultadoDeleteFromScrapbook = mysqli_query($ligacao,$sqlDeleteFromScrapbook);
  
  $nlinhasDeleteFromScrapbook = mysqli_num_rows($resultadoDeleteFromScrapbook);
  
  if ($nlinhasDeleteFromScrapbook==0) {// Bloco de Notas vazio
    echo "<td width='25%' colspan='2' align='center'>
       <span class='ficha'>Empty Scrapbook
       </span>
      </td>";
  }
  else { // vai permitir seleccionar as construções existentes no bloco de notas 
    
    //   $linhaSelectScrapbook = mysqli_fetch_assoc($resultadoSelectScrapbook);
    
    $pCodeTmpName=trim($linhaDeleteFromScrapbook['name']);
    $codeTmpId=trim($linhaDeleteFromScrapbook['codeTmpId']);
    
    echo "<td width='25%' colspan='2' align='center'>\n";
    echo "<span class='entrada'>
           <SELECT NAME='CodeTmpIdName'>";
    while ($linhaDeleteFromScrapbook = mysqli_fetch_assoc($resultadoDeleteFromScrapbook)){
      $pCodeTmpName=trim($linhaDeleteFromScrapbook['name']);
      $pCodeTmpIdAux=trim($linhaDeleteFromScrapbook['codeTmpId']);
      
      
      if ($codeTmpId==$pCodeTmpIdAux)
	print "<option selected>$pCodeTmpIdAux - $pCodeTmpName</option>\n"; 
      else
	print "<option>$pCodeTmpIdAux - $pCodeTmpName</option>\n"; 
    };
    echo "  </SELECT></span>    
            &nbsp;<input type='submit' value='Delete'>
          </td>";
  }
  echo "</form>";
 }
 else {
   echo "<td width='25%' colspan='2'>&nbsp;</td>";
 }
//
// fim da tabela
//
echo "</tr>\n";
echo "</table>\n";




?>