<?php
session_start();
/*
 * Scrapbook/functionsScrapbook.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

function scrapbook_get_code($scrapbookMode,$pCodeTmpId,$ligacao,&$pCode,&$pDrwPrvId) {
  /* 
   -> $pCodeTmpId - identificador contendo a informação do identificador do cod. temp.
      $ligação - informação da ligação à bd
   <- $pCode - o código
      $pDrwPrvId - o identificador do DGS ou ATP (conforme os casos)
  */

  // Não faz a escolha entre ATP e DGS (de momento)
  // get the figure's code

  $sqlCodeTmp = "SELECT code,codeTmpId,drawerId
                   FROM codeTmp
                  WHERE codeTmpId=$pCodeTmpId";
    
  $resultadoCodeTmp = mysqli_query($ligacao,$sqlCodeTmp);
  $linhaCodeTmp = mysqli_fetch_assoc($resultadoCodeTmp);
  $pCode      = trim($linhaCodeTmp['code']);
  $pPrvDrwId     = trim($linhaCodeTmp['drawerId']);
}

function scrapbook_delete($pCodeTmpId,$ligacao) {
  /* 
   Apaga todo uma entrada do bloco de notas
   
   -> $pCodeTmpId - identificador do utilizador
      $ligacao - ligação à base de dados.
  */

  // Apaga todo o conteúdo do bloco de notas (para um dado
  // utilizador).
  $sqlDeleteCodeTmp = "DELETE 
                         FROM codeTmp
                        WHERE codeTmpId='$pCodeTmpId'";


  $resultadoDeleteCodeTmp = mysqli_query($ligacao,$sqlDeleteCodeTmp);
  

  if (!$resultadoDeleteCodeTmp) {
    echo "<p>Error: info not deleted</p>";
  }
  else {
    echo "<p>Info deleted from the scrapbook</p>";
  }
}

function scrapbook_save($pUserId,$nameCodeTmp,$ligacao) {
  /* 

  Assume-se que o código a guardar está na tabela CodeTmp:

  -) Novo resultado: é o último código "temporary" deste utilizador.

    *) Nesse caso atribue-se um nome (!="temporary") ao código na
    tabela de códigos temporários.

    *) guarda-se o código numa nova posição "temporary", isto para
    salvaguardar o "modus operandi" da página de avaliação dos
    códigos temporários.

    *) incrementa-se o valor de "$nameCodeTmp"  
  
  -) Actualizar um resultado existente: o nome escolhido é igual a um
  já existente na tabela, nesse caso procede-se à sua actualização,
  utilizando para tal o último código "temporary" desse utilizador.


  -> $pUserId - o nome do presente utilizador
  $nameCodeTmp - o nome escolhido
  
  <- A tabela convinientemente modificada.
  */
  
  
  // obtém o identificador para o último código temporário para este
  // utilizador;

  // Iniciamos a transacção
  @mysqli_query("BEGIN");

  

  $sqlMaxCodeTmpId = "SELECT MAX(codeTmpId) 
                        FROM codeTmp 
                       WHERE name='temporary' 
                         AND userId='$pUserId'"; 


  $resultadoMaxCodeTmpId = mysqli_query($ligacao,$sqlMaxCodeTmpId);

  $linhaMaxCodeTmpId = mysqli_fetch_assoc($resultadoMaxCodeTmpId);
  $codeTmpIdTemporary = trim($linhaMaxCodeTmpId['MAX(codeTmpId)']);


  // Vai verificar se o nome escolhido já existe
  $sqlNewOrUpdate = "SELECT codeTmpId
                       FROM codeTmp
                      WHERE name='$nameCodeTmp'";

  $resultadoNewOrUpdate = mysqli_query($ligacao,$sqlNewOrUpdate);

  $nlinhasNewOrUpdate = mysqli_num_rows($resultadoNewOrUpdate);

  // Se já existe faz-se a actualização desse mesmo resultado, caso
  // não existe, transforma-se o resultado "temporary" num resultado
  // do bloco de notas

  if ($nlinhasNewOrUpdate!=0) {

    $linhaNewOrUpdate = mysqli_fetch_assoc($resultadoNewOrUpdate);
    $codeTmpId=trim($linhaNewOrUpdate['codeTmpId']);
  
    // vai-se buscar o resultado à tabela de códigos temporários (é o
    // último desse tipo).
    
    $sqlCodeTmp = "SELECT code,figure,drawerId,proverId
                     FROM codeTmp 
                    WHERE codeTmpId=$codeTmpIdTemporary";
    

    $resultadoCodeTmp = mysqli_query($ligacao,$sqlCodeTmp);
    

    $linhaCodeTmp = mysqli_fetch_assoc($resultadoCodeTmp);
    $codeTmp = trim($linhaCodeTmp['code']);
    $figure = addslashes($linhaCodeTmp['figure']);
    $drawerId = trim($linhaCodeTmp['drawerId']);
    
    // e procede-se à actualização do código do bloco de notas com o
    // nome escolhido
    $sqlUpdateScrapbook = "UPDATE codeTmp 
                              SET code='$codeTmp',
                                  figure='$figure',
                                  drawerId=$drawerId
                            WHERE codeTmpId='$codeTmpId'";

 
    $resultadoUpdateScrapbook = mysqli_query($ligacao,$sqlUpdateScrapbook);

    if (!$resultadoUpdateScrapbook) {
      // cancelamos a transacção
      @mysqli_query("ROLLBACK");
      echo "Error: problem in the scrapbook, not updated";
      exit;
    }

  }
  else { 
    // Neste caso trata-se de inserir um nove resultado no bloco de
    // notas, 1) mudança no nome do código temporário, que deixa de
    // ser "temporary"; 2) inserção do código numa nova posição
    // "temporary"; 3) actualização do valor de $codeTmpId.
    
    // 1 - mudança do nome
    $sqlChangeName = "UPDATE codeTmp 
                         SET name='$nameCodeTmp'
                       WHERE codeTmpId=$codeTmpIdTemporary";

    $resultadoChangeName = mysqli_query($ligacao,$sqlChangeName);
    
    if (!$resultadoChangeName) {
      // cancelamos a transacção
      @mysqli_query("ROLLBACK");
      echo "Error: new problem not saved in the scrapbook";
      exit;
    }

    // 2 - (re)inserção do código numa nova posição "temporary"
    
    $sqlReInsert = "INSERT 
                      INTO codeTmp 
                           (code,drawerId,figure,username,userId) 
                    SELECT code,drawerId,figure,username,userId 
                      FROM codeTmp 
                     WHERE userId='$pUserId'
                       AND codeTmpId=$codeTmpIdTemporary";
    
    $resultadoReInsert = mysqli_query($ligacao,$sqlReInsert);
    
    if (!$resultadoReInsert) {
      // cancelamos a transacção
      @mysqli_query("ROLLBACK");
      echo "Error: new problem not saved in the scrapbook";
      exit;
    }    

    // 3 - actualização do valor de $codeTmpId
    $nameCodeTmp++;

  }
  // Tudo está bem, termina a transacção.
  
  @mysqli_query("COMMIT");

}

?>