<?php
/*
 * Registry/dataValid.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */


function filled_out($form_vars) {
    // test that each variable has a value
    foreach ($form_vars as $key => $value) {
        if (!isset($key) || ($value == '')) 
            return false;
    } 
    return true;
}

function filled_obligatory($form_vars) {
    // testa se "email username passwd passwd2" esto preenchidas
    $vEmail          = $form_vars['email'];
    $vUsername       = $form_vars['username'];
    $vPasswd         = $form_vars['passwd'];
    $vPasswd2        = $form_vars['passwd2'];
    if (!isset($form_vars['email']) || ($vEmail == '')) {
        echo "<p>error - email not filled</p>";
        $erro = true;
    } 
    if (!isset($form_vars['username']) || ($vUsername == '')) {
        echo "<p>error - Username not filled</p>";
        $erro = true;
    } 
    if (!isset($form_vars['passwd']) || ($vPasswd == '')) {
        echo "<p>error - Password not filled</p>";
        $erro = true;
    } 
    if (!isset($form_vars['passwd']) || ($vPasswd2 == '')) {
        echo "<p>error - Password confirmation not filled</p>";
        $erro = true;
    } 
    if (!$erro)
        return true;
    else
        return false;
}

//
// A expresso regular para os endereos foi tirada de
//
// http://www.regular-expressions.info/email.html


function valid_email($address) {
    // check if an email address is possibly valid
    if (preg_match('#^[a-zA-Z0-9._%-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,6}#',$address,$matches) {
        return true;
    }
    else {
        return false;
    }
}

?>

