<?php
session_start();
/*
 * Proofs/iInsertProof.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

require_once('../servidor.php');

$pTipoUtilizador = $_SESSION['tipoUtilizador'];
if ($pTipoUtilizador=="anonymous" || $pTipoUtilizador=="regular") { // separa por tipo de utilizador
  require($entradaFILE.'headerUsers.php');
  require($entradaFILE.'menuUsers.php');
  echo "<meta http-equiv='refresh' content='0; url=".$entradaFILE."users.php' />";
  exit;  // os regulares e o anonimo no tem acesso a esta pgina
 }
 else
  require($entradaFILE.'headerAdmins.php');
  require($entradaFILE.'menuAdmins.php');
}

?>

<center>
<h3 class="maketitle">Geometric theorems - Insert a Proof</h3>
</center>

<hr/>



<?php
require($entradaFILE.'loginDBMS.php');
?>

<?php

// No caso de erros quer-se voltar ao formulrio, ponto de entrada deste ficheiro
$URLerros = addslashes($_SERVER['HTTP_REFERER']);

echo "<p>Processing the code, please wait</p>\n";


$pThmId            = $_POST['TeoId'];
$pPrvIdNameVersion = $_POST['PrvIdNameVersion'];
$pCode             = $_POST['Code'];
$pDateSubmission   = $_POST['DateSubmission'];
$pUserInfo         = $_POST['UserInfo'];
$pBibref           = $_POST['Bibref'];

//print_r($_POST);

// Obter a Identificao do Provador de Teoremas
preg_match("([0-9]+) --([A-Za-z0-9 _.]+) --([A-Za-z0-9 _\.]*)", $pPrvIdNameVersion,$matches);

$pPrvId   = $matches[1];

// Obter a Identificao do Utilizador que est a submeter a informao
preg_match("([A-Za-z0-9 _.]+) -- ([A-Za-z0-9 _.]+) -- ([A-Za-z0-9 _.]+)",$pUserInfo,$matches);

$pUserId = $matches[1];
//$pUserName = $matches[2];
//$pUserEmail = $matches[3];


/* Formata os valores para posterior insero na Tabela
if (!get_magic_quotes_gpc())
  { $pCode           = addslashes('$pCode');
    $pBibref         = addslashes('Bibref');
  }
*/

// Comea-se por introduzir os dados gerais e depois vai-se, provador
// a provador, processar a prova e fazer a insero desta. Se houver
// erros  necessrio desfazer (i.e. transaes) a insero j
// efectuada, S no caso de tudo correr bem  que se Fecha a Transao

// Inicio da transaccao
@ mysqli_query("BEGIN");

// Insero dos dados gerais


$sqlInsertProof = 
  "INSERT INTO demonstrations
       (teoId,proverId,code,dateSubmission,userId)
        VALUES 
       ('$pThmId',$pPrvId,'$pCode','$pDateSubmission',$pUserId)";


$resultadoInsertProof = mysqli_query($ligacao,$sqlInsertProof);

//echo $sqlInsertProof."<br /><br />";

// caso haja erros na insero no chega sequer a tentar inserir a ref. bib.
if (!$resultadoInsertProof) {
  echo 'Error - Proof not inserted! (L88)';
  // TRANSAES - ROLLBACK
  @ mysqli_query("ROLLBACK"); 
  echo "<meta http-equiv='refresh' content='2; url=$URLerros' />";
  exit;
}

// Obtm o valor do demId
$sqlLastInsert = "SELECT LAST_INSERT_ID()";
$resultadoLastInsert = mysqli_query($ligacao,$sqlLastInsert);
$linhaLastInsert = mysqli_fetch_assoc($resultadoLastInsert);
$pDemId=$linhaLastInsert['LAST_INSERT_ID()'];

// vai agora inserir a referncia bibliogrfica. No caso "noref" no
// se procede a nenhuma insero

if ($pBibref != 'noref') {
  $sqlInsertTeoBibRef = "INSERT INTO bibproofs (bibrefId,demId)
                              VALUES ('$pBibref','$pDemId')";
	  
			    
  $resultadoInsertTeoBibRef = mysqli_query($ligacao,$sqlInsertTeoBibRef);
  
  //  echo $sqlInsertTeoBibRef."<br />";

  // caso haja erros na insero no chega sequer a tentar inserir a ref. bib.
  if (!$resultadoInsertTeoBibRef) { 
    echo 'Error - Proof not inserted! Bibliographic data (L112)';
    echo "<meta http-equiv='refresh' content='2; url=$URLerros' />";
    exit;
  }
}

// comea por apagar o resultado anterior


$vNameParaApagar     = 'proof'.$pUserId.'.*';
system("rm $vNameParaApagar");

// O restante processamento  dependente do provador escolhido

if ($pPrvId==2) { // GCLCprover - Area Method
  echo "<p>GCLCprover - Area Method -- Processing, please wait</p>";
  flush(); 
  require('iInsertProofGCLCprover.php');
}
elseif ($pPrvId==3) { // GCLCprover+euk2gclc 
  // ---> tenho de ver isto com mais cuidado
  echo "<p>GCLCprover+euk2gclc -- Processing, please wait</p>";
  flush(); 
  require('iInsertProofGCLCproverEuk.php');
}
elseif ($pPrvId==4) { //Coq+JNarboux - Area Method
  echo "<p>Coq+Area Method (by J. Narboux) -- Processing, please wait </p>";
  flush(); 
  require('iInsertProofCoqJN.php');
}
elseif ($pPrvId==5) { // GCLCprover Wu's Method
  echo "<p>GCLCprover - Wu's Method -- Processing, please wait.</p>";
  flush(); 
  require('iInsertProofGCLCproverWM.php');
}
elseif ($pPrvId==6) { // GCLCprover Grbner Bases Method Method
  echo "<p>GCLCprover - Wu's Method -- Processing, please wait</p>";
  flush(); 
  require('iInsertProofGCLCproverGBM.php');
}
 
// Os programas que processam a demonstrao fazem o fecho da transao.

echo "<h3>Proof sucessefull inserted</h3>";
echo "<meta http-equiv='refresh' content='2; url=".$entradaURL."Geothms/updateGeoThm.php?argumento=$pThmId' />";

?>
     
<hr/>

<p>&nbsp;</p>

<?php
  require($entradaFILE.'footer.php');
?>
