<?php
/*
 * Interaction/showResultsGCLCproverWM.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */


// Versão GCLCprover


// select the theorem name from the database
$sqlTeoName = "SELECT teoName
                 FROM theorems
                WHERE teoId='$vTeoId'";
$resultadoTeoName = mysqli_query($ligacao,$sqlTeoName);
$linhaTeoName = mysqli_fetch_assoc($resultadoTeoName);
$vTeoNameAux=trim($linhaTeoName['teoName']);

// No caso do GCLCprover pode-se mostrar também a imagem (para ajudar)
//echo "<h1> - $pCodeTmpId - </h1>";
//echo "<td align='center'>".obtemfigura($pCodeTmpId,$nThumbnail,$ligacao)."</td>\n";

// ... primeiro é necessário gerá-la e guardá-la


echo "<td width='100%' colspan='6' align='center'><b>Theorem - $vTeoNameAux</b></td>";
echo "</tr>";
echo "<tr>";
echo "<td colspan='6' align='center'><hr></td>";
echo "</tr>";
// vai obter o resultado da tentativa de prova assim como as medidas
// de eficiência.
// Estão organizadas desta forma:
// status ; elimSteps ; geoSteps ; algStepsn ; nLargestPolynomial ; sTime ; computer .
//
// Por exemplo
// 1 ; 3 ; 6 ; 23 ; ; 0.001000 ; Intel(R) Pentium(R) 4.0, 3GHz, 2.0GB .
//
// no campo status tem-se
//   1 = proved (if the conjecture was proved valid)
//   0 = disproved (if the conjecture was proved invalid)
//   2 = Failed to prove the conjecture (if neither of above two)
//
//            status  ; elimStp  ; gepStp   ; algStp   ; nLargstP ; sTime     ; computer
preg_match("#([0-9]+) ; ([0-9]+) ; ([0-9]+) ; ([0-9]+) ; ([0-9]+) ; ([0-9.]+) ; ([A-Za-z0-9,. ()-]+)#",$pProofResults,$matches);

$vResult    = $matches[1];
$elimSteps  = $matches[2];  
$geoSteps   = $matches[3]; 
$algSteps   = $matches[4]; 
$totalSteps = $elimSteps+$geoSteps+$algSteps;
$nLargestPolynomial = $matches[5]; 
$sTime      = $matches[6]; 
$computer   = $matches[7]; 

if ($vResult==1) {
  echo "<tr>";
  echo "<td width='100%' colspan='6' align='center'>Proved</td>";
  echo "</tr>";
  echo "<tr>";
  echo "<td width='100%' colspan='6' align='center'>";
  echo "<a href='$vNameProofPDF'>Proof (PDF file)</a>";
  echo "</td>";
  echo "</tr>";
}
elseif ($vResult==0) {
  echo "<tr>";
  echo "<td width='100%' colspan='6' align='center'>Disproved</td>";
  echo "</tr>";
  echo "<tr>";
  echo "<td width='100%' colspan='6' align='center'>";
  echo "<a href='$vNameProofPDF'>Disproof (PDF file)</a>";
  echo "</td>";
  echo "</tr>";
}
else {
  echo "<tr>";
  echo "<td width='100%' colspan='6' align='center'><b>Failed to prove the conjecture</b></td>";
  echo "</tr>";
  echo "<tr>";
  echo "<td width='100%' colspan='6' align='center'>";
  echo "<a href='$vNameProofPDF'>Proof attempt (PDF file)</a>";
  echo "</td>";
  echo "</tr>";
}
echo "<tr>";
echo "<td colspan='6' align='center'><hr></td>";
echo "</tr>";
echo "<td width='100%' colspan='6' align='center'><b>Measures of efficiency</b></td>";
echo "</tr>";
echo "<tr>";
echo "<td colspan='6' align='center'><hr></td>";
echo "</tr>";
echo "<tr>";
echo "<td width='33.3%' colspan='2'><span class='ficha'>Largest Polynomial</span></td>";
echo "<td width='16.6%' colspan='1'>$nLargestPolynomial</td>";
echo "<td width='33.3%' colspan='2'><span class='ficha'>Time spent (seconds)</span></td>";
echo "<td width='66.7%' colspan='4' align='left'>$sTime</td>";
echo "</tr>";
echo "<tr>";
echo "<td width='33.3%' colspan='2'><span class='ficha'>Computer</span></td>";
echo "<td width='66.7%' colspan='4' align='left'>$computer</td>";
echo "</tr>";
echo "<tr>";
echo "<td colspan='6' align='center'><hr></td>";
echo "</tr>";
echo "</table>";
echo "</td>";


function obtemfigura($pCodeTmpId,$nThumbnail,$ligacao) {
  // vai agora criar uma miniatura da imagem
  
  // primeiro obtém a imagem da Base de dados.
  
  $sqlFiguraPNG = "SELECT figure 
                     FROM codeTmp 
                    WHERE codeTmpId='$pCodeTmpId'"; 
  $resultadoFiguraPNG = mysqli_query($ligacao,$sqlFiguraPNG); 
  $linhaFiguraPNG = mysqli_fetch_array($resultadoFiguraPNG); 
  $FigurePNG = $linhaFiguraPNG["figure"]; 
  
  $vNameFiguraPNG="figureDB".$pCodeTmpId.".png";
  $vNameThumbNailPNG="figureThumbnail".$pCodeTmpId.".png";
  
  // depois escreve-a num ficheiro
  ob_start();
  print $FigurePNG;
  $texfile=fopen($vNameFiguraPNG,"w");
  fwrite($texfile,ob_get_contents()); 
  fclose($texfile); 
  ob_end_clean(); 
  
  // depois converte-a numa miniatura através do programa imagemagik é
  // de notar que além da miniaturização há (eventualmente) também uma
  // conversão de formatos (jpg para png).
  system("convert -size 100x100 $vNameFiguraPNG -resize 100x100 +profile \"*\" $vNameThumbNailPNG");
  
  return("<img src='view_imageThumbnail.php?argumento=$vNameThumbNailPNG' alt='No Figure'>");
}



?>