<?php 
session_start();
/*
 * Interaction/insertCode.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

require_once('../servidor.php');
$pTipoUtilizador = $_SESSION['tipoUtilizador'];
if ($pTipoUtilizador=="anonymous" || $pTipoUtilizador=="regular") { // separa por tipo de utilizador
  require($entradaFILE.'headerUsers.php');
  require($entradaFILE.'menuUsers.php');
}
else {
  require($entradaFILE.'headerAdmins.php');
  require($entradaFILE.'menuAdmins.php');
}

// coloca o valor para a página de ajuda apropriada
$_SESSION['helpsection']='interaction';

require_once($entradaFILE.'dbLogin.php');

?>


<?php

  // carregar das funções do bloco de notas
require_once($entradaFILE."Scrapbook/functionsScrapbook.php");

// carregar funções Javascript referentes ao editor the textarea
require($entradaFILE."Interaction/functionsJavascript.php");


$argumento = $_GET['argumento'];
if (isset($_GET['figId'])) {
  $pFigureId = $_GET['figId'];
}
else {
  $pFigureId = -1; // valor por omissão...
}
$insercao  = $_POST['insercao']; // primeira vez, ou actualização


// Testa se é uma nova sessão ou se já estamos a re-introduzir código
// após uma primeira avaliação do mesmo (escolha de "re-evaluate the code")
if (!isset($argumento)) {
  // pode ser a primeira de todas ou então a escolha de um resultado da BD
  $insercao=1; // verdade
  $pFigIdTeoIdName = $_POST['FigIdTeoIdName']; // escolha de uma
					       // construção da base
					       // de dados
  
  $pCodeTmpIdName = $_SESSION['CodeTmpIdName']; // escolha de uma
						// construção do bloco
						// de notas
  
  
  
  if (isset($pFigIdTeoIdName)) { // este é o caso em que já houve
				 // escolha ("choose a figure
				 // description")
    preg_match("§([0-9]+) -- ([A-Za-z0-9 _.]+) -- ([A-Za-z0-9 _.]+) -- (GEO[0-9]+) -- ([A-Za-z0-9 _.]+)§",$pFigIdTeoIdName,$matches);
    
    $pFigureId = $matches[1];
    
    //$pUserName = $matches[2];
    //$pUserEmail = $matches[3];
    
    
    // get the figure's code
    $sqlFigCode = "SELECT code,drawerId
                     FROM figures
                    WHERE figureId='$pFigureId'";
    $resultadoFigCode = mysqli_query($ligacao,$sqlFigCode);
    $linhaFigCode = mysqli_fetch_assoc($resultadoFigCode);
    $pCode      = trim($linhaFigCode['code']);
    $pDrwId     = trim($linhaFigCode['drawerId']);
  } elseif (isset($pCodeTmpIdName)) { // o resultado vem é do bloco de notas
    
    preg_match("§([0-9]+) - ([A-Za-z0-9 _.]+)§",$pCodeTmpIdName,$matches);
    
    
    $pCodeTmpId = $matches[1];
    
    $scrapbookMode="drawer";
    scrapbook_get_code($scrapbookMode,$pCodeTmpId,$ligacao,$pCode,$pDrwId);
  } // senão (vazio) é a primeira de todas
  // este caso não é importante dado que aqui é o começo de todo o
  // processo, isto é, neste caso a textarea está vazia e, é tudo.
 }
 else {
   // no caso de ser uma re-introdução do código (escolha de
   // "re-evaluate the code"), tem-se acesso ao Identificador da figura
   // seleccionada
   
   $insercao=0; // falso
  
  // cria uma pesquisa
  $sqlDrwCodeTmp = "SELECT code,drawerId
                       FROM codeTmp
                      WHERE codeTmpId ='$argumento'";
  
  $resultadoDrwCodeTmp = mysqli_query($ligacao,$sqlDrwCodeTmp);
  //$ncamposDrwCodeTmp = mysqli_num_fields($resultadoDrwCodeTmp);
  $linhaDrwCodeTmp = mysqli_fetch_assoc($resultadoDrwCodeTmp);
  
  $pDrwId     = trim($linhaDrwCodeTmp['drawerId']);
  $pCode      = trim($linhaDrwCodeTmp['code']);
  $pCodeTmpId = $argumento;
  
}

if ($pDrwId==2) { // 2=Eukleides
  // Inicialização da janela de textarea/javascript
  
  echo "<script language=\"Javascript\" type=\"text/javascript\">\n";
  echo "editAreaLoader.init({
        id: \"DrawerCode\"	// id of the textarea to transform
          ,start_highlight: true	// it start with highlight
          ,allow_resize: \"both\"
          ,allow_toggle: false
          ,language: \"en\"
          ,syntax: \"eukleides\"  // Eukleides
      });\n";
  echo "</script>\n\n";    
}
else { // =/= GCLC (para já não há mais)
  // Inicialização da janela de textarea/javascript
  
  echo "<script language=\"Javascript\" type=\"text/javascript\">\n";
  echo "editAreaLoader.init({
        id: \"DrawerCode\"	// id of the textarea to transform
          ,start_highlight: true	// it start with highlight
          ,allow_resize: \"both\"
          ,allow_toggle: false
          ,language: \"en\"
          ,syntax: \"gclc\"  // GCLC	
      });\n";
  echo "</script>\n\n";    
} 


// cria uma pesquisa - para a lista de drawers
$sql = "SELECT drawerId,name,version
          FROM drawers";

$resultado = mysqli_query($ligacao,$sql);

$ncampos =mysqli_num_fields($resultado);


$linha = mysqli_fetch_assoc($resultado);

// uma forma bacoca de retirar o primeiro valor "No drawer selected"
$pDrawerId       = $linha['drawerId'];
$pName           = $linha['name'];
$pVersion        = $linha['version'];


echo "<!-- ficha -->";
echo "<table width='100%' bgcolor='white' cellpadding='4' cellspacing='4'>";
echo "<tr>";
echo "<td width='100%' colspan='8' align='center'><span class='titulo'>Geometric Drawer Workbench</span></td>";
echo "</tr>";
if (1) {
  echo "<form action='insertCode.php' method='post'>";
  echo "<tr>";
  //  echo "<td width='25%' colspan='2'>&nbsp;</td>";
  echo "<td width='12.5%' colspan='1' align='right'>
         <span class='ficha'>Figures Listing</span>
        </td>\n";
  // select a figure from the database
  $sqlListaBD = "SELECT figureId,figures.teoId,drawerId
                   FROM figures INNER JOIN theorems 
                     ON theorems.teoId=figures.teoId 
                  WHERE level=0
               ORDER BY figures.teoId,figureId";
  $resultadoListaBD = mysqli_query($ligacao,$sqlListaBD);
  echo "<td width='62.5%' colspan='5'>
          <span class='entrada'><SELECT NAME='FigIdTeoIdName'>";
  //   $pFigureIdAux=0;
  //   $pDrwName    ='None';
  //   $pDrwVersion =0;
  //   $pTeoIdAux   =0;
  //   $pTeoNameAux ='New Construction';
  //  print "<option selected>$pFigureIdAux -- $pDrwName -- $pDrwVersion -- $pTeoIdAux -- $pTeoNameAux</option>\n";   
  while ($linhaListaBD = mysqli_fetch_assoc($resultadoListaBD)){
    $pFigureIdAux = trim($linhaListaBD['figureId']);
    $pTeoIdAux    = trim($linhaListaBD['teoId']);
    $pDrawerIdAux = trim($linhaListaBD['drawerId']);
    // Obtém a informação acerca do Teorema e do Desenhador
    $sqlThm = "SELECT teoName
                 FROM theorems
                WHERE teoId='$pTeoIdAux'";
    $resultadoThm = mysqli_query($ligacao,$sqlThm);
    $linhaThm = mysqli_fetch_assoc($resultadoThm);
    $pTeoNameAux = trim($linhaThm['teoName']);    
    $sqlDrw = "SELECT name,version
                 FROM drawers
                WHERE drawerId=$pDrawerIdAux";
    $resultadoDrw = mysqli_query($ligacao,$sqlDrw);
    $linhaDrw = mysqli_fetch_assoc($resultadoDrw);
    $pDrwName = trim($linhaDrw['name']);
    $pDrwVersion = trim($linhaDrw['version']);

    if ($pFigureId==$pFigureIdAux)
      print "<option selected>$pFigureIdAux -- $pDrwName -- $pDrwVersion -- $pTeoIdAux -- $pTeoNameAux</option>\n"; 
    else
      print "<option>$pFigureIdAux -- $pDrwName -- $pDrwVersion -- $pTeoIdAux -- $pTeoNameAux</option>\n"; 
  };
  echo "</SELECT>";
  echo "</td>\n";
  echo "<td width='25%' colspan='2' align='center'>
          <input type='submit' value='&nbsp;&nbsp;&nbsp;choose a figure description&nbsp;&nbsp;&nbsp;'>
        </td>\n";
  echo "</tr>\n";
  echo "</form>";
 }
// linha de separação entre secções (forms)
echo "<tr>
       <td colspan='8'>
        <hr/>
       </td>
      </tr>\n";

// ================================================
// Bloco de Notas - Guardar & Seleccionar & Apagar
// ================================================

// Uma linha da tabela


// =====================================
// Introdução da barra do Bloco de Notas
// =====================================
echo "<tr>\n";
echo " <td colspan='8'>\n";
$pathToScrapbook = "../Scrapbook";
$nameCallingForm="Interaction/insertCode.php";
$scrapbookMode="drawer";
$saveActive=1;
$selectActive=1;
$deleteActive=1;
include($entradaFILE."Scrapbook/scrapbook.php");
echo " </td>\n";
echo "</tr>\n";

// ================================================
// Formulário respeitante à (re)avaliação do código
// ================================================
echo "<form enctype='multipart/form-data' action='iInsertCode.php' method='post'>";
echo "<tr>";
echo "<td width='12.5%' colspan='1'>\n";
echo "<table>\n";
echo "<tr>
       <td align='right'>
        <span class='ficha'>Code</span>
       </td>
      </tr>\n";
echo "<tr>
       <td>&nbsp;</td>
      </tr>\n";
echo "<tr>
       <td>&nbsp;</td>
      </tr>\n";
echo "<tr>\n";
echo "<td align='center'>
       <span class='ficha'>Drawer</span>";
// select a Drawer form a list of Drawers
$sql_drawer_idnameversion = "SELECT drawerId,name,version
                               FROM drawers
                              WHERE NOT(name='No drawer selected')
                           ORDER BY drawerId";
$resultado_drawer_idnameversion = mysqli_query($ligacao,$sql_drawer_idnameversion);
//echo "<td width='62.5%' colspan='5'><span class='entrada'><SELECT NAME='DrwIdNameVersion'>";
echo "<span class='entrada'><SELECT NAME='DrwIdNameVersion'>";
while ($linha = mysqli_fetch_assoc($resultado_drawer_idnameversion)){
  $pDrawerId=trim($linha['drawerId']);
  $pDrawerName=trim($linha['name']);
  $pDrawerVersion=trim($linha['version']);
  if ($pDrwId==$pDrawerId)
    print "<option selected>$pDrawerId -- $pDrawerName -- $pDrawerVersion</option>\n";
  else
    print "<option>$pDrawerId -- $pDrawerName -- $pDrawerVersion</option>\n"; 
 };
echo "</SELECT>";
echo "</td>";
echo "<input type='hidden' name='FigId' value=$pFigureId>";
echo "</tr>  ";
echo "<tr>
       <td>&nbsp;</td>
      </tr>\n";
echo "<tr>
       <td>&nbsp;</td>
      </tr>\n";
echo "<tr>
       <td align='center'>
        <input type='submit' value='&nbsp;&nbsp;&nbsp;(re)evaluate the code&nbsp;&nbsp;&nbsp;'>
       </td>
      </tr>";
echo "</table>\n";
echo "</td>\n";
echo "<td width='37.5%' colspan='3'>
       <TEXTAREA id='DrawerCode' NAME='DrawerCode' ROWS='30' COLS='60'>$pCode</TEXTAREA>
      </td>";
echo "<td width='50%' colspan='4' align='center'><img src='view_image.php?argumento=$pCodeTmpId' alt='figure - $pCodeTmpId'></td>";
echo "</tr>";
echo "<input type='hidden' name='insercao' value=$insercao>";
echo "<input type='hidden' name='CodeTmpId' value=$pCodeTmpId>";
// o identificador passa de novo para se poder identificar qual foi a
// figura escolhida
echo "</form>";
// se já foi introduzido um dado código
// então vai-se oferecer a possibilidade de passar a nova figura para a
//  secção de interacção com os provadores.
// O formulários (só com valores escondidos) de passagem para a secção
if ($pCode!="") {
   $insercao=0; // falso - não sei o que isto significa ???
   echo "<form enctype='multipart/form-data' action='insertCodeProver.php' method='post'>";
   // testar uma nova conjectura para esta figura.
   // grava-se o resultado num ficheiro e passa-se o nome do ficheiro
   // através do método POST
   // passa por ser uma re-inserção (será???)
   echo "<input type='hidden' name='insercao' value=$insercao>";

   // trata-se de uma nova figura, como tal não tem identificador
   // (ainda). Escreve um ficheiro auxiliar com o código
   $vNameAux = 'auxFig'.$pUserId.'.code';

  $filename = $vNameAux;
  $texfile=fopen($filename,"w");
  fwrite($texfile,$pCode); 
  fclose($texfile);  

  // o nome do ficheiro auxiliar
  echo "<input type='hidden' name='filename' value=$vNameAux>";
  // o identificador do programa de desenho - é necessário para se
  // proceder à conversão (se necessário) na fase de avaliação da
  // conjectura.
  echo "<input type='hidden' name='drawerId' value=$pDrawerId>";
  echo "<input type='hidden' name='novaConjectura' value='GEO0000'>";
  echo "<tr>";
  echo "<td width='100%' colspan='8' align='right'><input type='submit' value='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Go to the \"Interaction with the Provers\" section to submit a conjecture related to this Figure&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'></td>";
  echo "</tr>";
  echo "</form>";
}
echo "</table>";

?>


<?php
  require($entradaFILE.'footer.php');
?>