<?php 
session_start();
/*
 * Interaction/iInsertCodeProver.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

require_once('../servidor.php');
$pTipoUtilizador = $_SESSION['tipoUtilizador'];
if ($pTipoUtilizador=="anonymous" || $pTipoUtilizador=="regular") { // separa por tipo de utilizador
  require($entradaFILE.'headerUsers.php');
  require($entradaFILE.'menuUsers.php');
}
else {
  require($entradaFILE.'headerAdmins.php');
  require($entradaFILE.'menuAdmins.php');
}

// coloca o valor para a página de ajuda apropriada
$_SESSION['helpsection']='interaction';

require_once($entradaFILE.'dbLogin.php');
?>


<?php

echo "
<center>
<h3 class='maketitle'>Geometric theorems - Insert a Prover Code</h3>
</center>\n";

echo "<hr/>\n";

$pPrvIdNameVersion = $_POST['PrvIdNameVersion'];
$pProverCode       = $_POST['ProverCode'];
$pCodeTmpId        = $_POST['CodeTmpId']; // pode estar vazio
$insercao          = $_POST['insercao']; // insert or update
$vTeoId            = $_POST['TeoId'];

// Obtém o identificador do Provador
preg_match("#([0-9]+) --([A-Za-z0-9ö _.]+) --([A-Za-z0-9 _\.]*)#", $pPrvIdNameVersion,$matches);

$pProverId = $matches[1];

// vai obter o identificador do Desenhador 
// 2 (GCLCprover: 2,5,6) => 3 (GCLC AM, WM, GBM)
// 3 (GCLCproverEuk: 3) => 2 (Eukleides)
// 4 (COQareaMethod: 4) => 1 (No drawer selected) isto dado que a
// descrição do prover não está ligada à descrição do drawer (Eukleides)
switch ($pProverId) {
 case 2: 
   $pDrawerId=3;
   break;
 case 3:
   $pDrawerId=2;
   break;
 case 4:
   $pDrawerId=1;
   break;
 case 5:
   $pDrawerId=3;
   break;
 case 6:
   $pDrawerId=3;
   break;
 default:
   $pDrawerId=1;
 }

// Formata os valores para posterior inserção na Tabela
//$pProverCode = mysqli_real_escape_string($ligacao,$pProverCode); 


// obtêm a informação referente ao Número de Identificação do utilizador
$pUsername = $_SESSION['username'];

$sqlUserId = "SELECT userId
                FROM users
               WHERE username='$pUsername'";

$resultadoUserId = mysqli_query($ligacao,$sqlUserId);

$linha = mysqli_fetch_assoc($resultadoUserId);
$pUserId=trim($linha['userId']);



// Insere, ou actualiza, a informação na tabela do código temporário

if ( $insercao ) { // primeira vez - inserção
  $sqlInsertPrvCodeTmp = 
    "INSERT INTO codeTmp
       (drawerId,proverId,code,username,userId)
      VALUES 
       ($pDrawerId,$pProverId,\"$pProverCode\",'$pUsername','$pUserId')";
  
  $resultadoInsertPrvCodeTmp = mysqli_query($ligacao,$sqlInsertPrvCodeTmp);
  
  if (!$resultadoInsertPrvCodeTmp) {
    echo 'Error - Code not  inserted!';
  }
  else { 
    echo 'Code  inserted!';
    $sqlLastInsert = "SELECT LAST_INSERT_ID()";
    $resultadoLastInsert = mysqli_query($ligacao,$sqlLastInsert);
    $linha = mysqli_fetch_assoc($resultadoLastInsert);
    $pCodeTmpId=$linha['LAST_INSERT_ID()'];
  }
 }
 else { // outras vezes - actualização
   $sqlUpdatePrvCodeTmp = 
     "UPDATE codeTmp
          SET proverId = '$pProverId',
              code     = '$pProverCode'
        WHERE codeTmpId = '$pCodeTmpId'";
   
   $resultadoUpdatePrvCodeTmp = mysqli_query($ligacao,$sqlUpdatePrvCodeTmp);
   
   if (!$resultadoUpdatePrvCodeTmp) {
       echo 'Error - Code not updated!';
   }
   else { 
     echo 'Code updated!';
   }
 }

echo "<meta http-equiv='refresh' content='1; url=evaluateCodeProver.php?argumento=$pCodeTmpId&teoId=$vTeoId&insercao=$insercao' />";

?>

<hr/>

<p>&nbsp;</p>

<?php
  require($entradaFILE.'footer.php');
?>
