<?php 
session_start();
/*
 * Interaction/iInsertCode.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

require_once('../servidor.php');
$pTipoUtilizador = $_SESSION['tipoUtilizador'];
if ($pTipoUtilizador=="anonymous" || $pTipoUtilizador=="regular") { // separa por tipo de utilizador
  require($entradaFILE.'headerUsers.php');
  require($entradaFILE.'menuUsers.php');
}
else {
  require($entradaFILE.'headerAdmins.php');
  require($entradaFILE.'menuAdmins.php');
}

require($entradaFILE.'dbLogin.php');
?>


<center>
<h3 class="maketitle">Geometric theorems - Insert a Drawer Code</h3>
</center>

<hr/>


<?php

$pDrwIdNameVersion = $_POST['DrwIdNameVersion'];
$pDrawerCode       = $_POST['DrawerCode'];
$pCodeTmpId        = $_POST['CodeTmpId']; // pode estar vazio
$insercao          = $_POST['insercao']; // insert or update
$vFigId            = $_POST['FigId'];

// ---Validação---
// Se o código é vazio volta para trás
if ($_POST['DrawerCode']==""  || !isset($_POST['DrawerCode'])) {
  echo "Error - empty code section";
  echo "<meta http-equiv='refresh' content='1; url=insertCode.php' />";  
  exit;
}



// Obtém o identificador do Desenhador
preg_match("#([0-9]+) --([A-Za-z0-9 _.]+) --([A-Za-z0-9 _\.]*)#", $pDrwIdNameVersion,$matches);

$pDrawerId = $matches[1];


// Formata os valores para posterior inserção na Tabela
if (!get_magic_quotes_gpc())
  { $pDrawerId   = addslashes($pDrawerId);
    $pDrawerCode = addslashes($pDrawerCode);
  }

// obtêm a informação referente ao Número de Identificação do utilizador
$pUsername = $_SESSION['username'];

$sqlUserId = "SELECT userId
                FROM users
               WHERE username='$pUsername'";

$resultadoUserId = mysqli_query($ligacao,$sqlUserId);

$linha = mysqli_fetch_assoc($resultadoUserId);
$pUserId=trim($linha['userId']);

// Insere, ou actualiza, a informação na tabela do código temporário
if ( $insercao ) { // primeira vez - inserção
  $sqlInsertDrwCodeTmp = 
    "INSERT INTO codeTmp
       (drawerId,code,username,userId)
      VALUES 
       ('$pDrawerId','$pDrawerCode','$pUsername','$pUserId')";
  
  $resultadoInsertDrwCodeTmp = mysqli_query($ligacao,$sqlInsertDrwCodeTmp);

  if (!$resultadoInsertDrwCodeTmp)
    echo 'Error - Code not  inserted!';
  else { 
    echo 'Code  inserted!';
    // Isto também pode ser feito com a função SQL, "LAST_INSERT" ???
    // !!!confirmar isto!!!
    $sqlLastInsert = "SELECT LAST_INSERT_ID()";
    $resultadoLastInsert = mysqli_query($ligacao,$sqlLastInsert);
    $linha = mysqli_fetch_assoc($resultadoLastInsert);
    $pCodeTmpId=$linha['LAST_INSERT_ID()'];
  }
 }
 else { // outras vezes - actualização
   $sqlUpdateDrwCodeTmp = 
     "UPDATE codeTmp
          SET drawerId = '$pDrawerId',
              code     = '$pDrawerCode'
        WHERE codeTmpId = '$pCodeTmpId'";
   
   $resultadoUpdateDrwCodeTmp = mysqli_query($ligacao,$sqlUpdateDrwCodeTmp);
   
   if (!$resultadoUpdateDrwCodeTmp)
     echo 'Error - Code not updated!';
   else { 
     echo 'Code updated!';
   }
 }

echo "<meta http-equiv='refresh' content='1; url=".$entradaURL."Interaction/evaluateCode.php?argumento=$pCodeTmpId&figId=$vFigId&insercao=$insercao' />";

?>

<hr/>

<p>&nbsp;</p>

<?php
require($entradaFILE."footer.php");
?>
