<?php 
session_start();
/*
 * Interaction/evaluateCode.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

require_once('../servidor.php');
$pTipoUtilizador = $_SESSION['tipoUtilizador'];
if ($pTipoUtilizador=="anonymous" || $pTipoUtilizador=="regular") { // separa por tipo de utilizador
  require($entradaFILE.'headerUsers.php');
  require($entradaFILE.'menuUsers.php');
}
else {
  require($entradaFILE.'headerAdmins.php');
  require($entradaFILE.'menuAdmins.php');
}

require($entradaFILE.'dbLogin.php');

?>



<hr/>


<center>
<h3 class="maketitle">Geometric Illustration</h3>
</center>

<hr/>

<?php
// selecciona o Id de utilizador para poder escrever os ficheiros
// "personalizados"
$username = $_SESSION['username'];
// cria uma pesquisa


$sqlUserId = "SELECT userId
                FROM users
               WHERE username ='$username'";

$resultadoUserId = mysqli_query($ligacao,$sqlUserId);
$linhaUserId = mysqli_fetch_assoc($resultadoUserId);

$pUserId     = trim($linhaUserId['userId']);

$argumento = $_GET['argumento'];
$vFigureId = $_GET['figId'];
$insercao  = $_GET['insercao']; // primeira vez, ou actualização

// cria uma pesquisa
$sqlDrwCodeTmp = "SELECT code,drawerId
                    FROM codeTmp
                   WHERE codeTmpId ='$argumento'";

$resultadoDrwCodeTmp = mysqli_query($ligacao,$sqlDrwCodeTmp);
//$ncamposDrwCodeTmp = mysqli_num_fields($resultadoDrwCodeTmp);
$linhaDrwCodeTmp = mysqli_fetch_assoc($resultadoDrwCodeTmp);

$pDrwId     = trim($linhaDrwCodeTmp['drawerId']);
$pCode      = trim($linhaDrwCodeTmp['code']);
$pCodeTmpId = $argumento;


// Obtém o nome do Desenhador
$sqlDrw = "SELECT name,version
             FROM drawers
            WHERE drawerId='$pDrwId'";
$resultadoDrw = mysqli_query($ligacao,$sqlDrw);
$linhaDrw = mysqli_fetch_assoc($resultadoDrw);

$pDrwName    = trim($linhaDrw['name']);
$pDrwVersion = trim($linhaDrw['version']);


// Escreve o ficheiro "txt" referente ao código

// Os nomes dos ficheiros tem apenso o identificador de utilizador
// para desta forma permitir a escrita de ficheiros por mais do que um
// utilizador ao mesmo tempo.


$vNameCode = 'figure'.$pUserId.'.code';
$vNameErr = 'figure'.$pUserId.'.err';
$vNameErrors = 'figure'.$pUserId.'.errors';
$vNamePIC = 'figure'.$pUserId.'.pic';
$vNameTeX = 'figure'.$pUserId.'.tex';
$vNameDVI = 'figure'.$pUserId.'.dvi';
$vNamePS = 'figure'.$pUserId.'.ps';
$vNameEPSI = 'figure'.$pUserId.'.epsi';
$vNameJPG = 'figure'.$pUserId.'.jpg';

$vNameErrorProof    = 'error-proof.tex';
$vNameErrorProofTeX = 'figure'.$pUserId.'error-proof.tex';
$vNameErrorProofDVI = 'figure'.$pUserId.'error-proof.dvi';
$vNameErrorProofPS  = 'figure'.$pUserId.'error-proof.ps';
$vNameErrorProofPDF = 'figure'.$pUserId.'error-proof.pdf';

ob_start();
print $pCode."\n";
$texfile=fopen($vNameCode,"w");
fwrite($texfile,ob_get_contents()); 
fclose($texfile); 
ob_end_clean(); 


// Vai processar o código com o programa de desenho
// Consoante o programa de desenho
// 2 - Eukleides - 1.0.2
// 3 - GCLC - 5.00
// 
// Eukleides ---> figure.err
// GCLC      ---> figure.errors ---> figure.err

$syntaxErrors=0;
$semanticErrors=0;


ob_start();
if ($pDrwId==2) {
  $vMostraErros = $vNameErrors;
  system("echo '<h3>You have select the DGS Eukleides</h3>' > $vMostraErros");
  system("/usr/local/bin/eukleides $vNameCode > $vNamePIC 2> $vNameErr");
  if (file_exists($vNameErr) and filesize($vNameErr)>0) 
    system("cat $vNameErr >> $vMostraErros");
 }
elseif ($pDrwId==3) {
  $vMostraErros = $vNameErrors;
  system("echo '<h3>You have select the DGS GCLC</h3>' > $vNameErrors");
  system("/usr/local/bin/gclc $vNameCode $vNamePIC -d >> $vNameErrors");
  // erros sintácticos
  system("./syntaxErrors < $vNameErrors > $vNameErr");
  //  ob_end_clean(); 
  if (file_exists($vNameErr) and filesize($vNameErr)>0) {
    $syntaxErrors=1;
  } 
  else { // sem erros sintácticos, vai testar se há erros semânticos
    // o resultado da função "filesize" é guardada em cache, como tal
    // para uma re-utilização da mesma com alteração do tamanho do
    // ficheiro é necessário em primeiro lugar limpar a cache de
    // estado.
    clearstatcache(); 
    system("./semanticErrors < $vNameErrors > $vNameErr");
    if (file_exists($vNameErr) and filesize($vNameErr)>0) {
      $semanticErrors=1;
      // agora vai processar o ficheiro LaTeX referente a esta prova
      // Pré-processa o ficheiro error_proof.tex gerado pelo gclc 
      // pelo sed para substituir o estilo por omissão do gclc pelo estilo
      // landscape
      system("sed -e 's/{gclc_proof}/\[landscape\]{gclcproof}/g' $vNameErrorProof > $vNameErrorProofTeX");

      system("latex $vNameErrorProofTeX"); 
      system("latex $vNameErrorProofTeX"); 
      system("dvips $vNameErrorProofDVI"); 
      system("ps2pdf $vNameErrorProofPS"); 
    }
  }
}
ob_end_clean(); 


clearstatcache(); 

// Vai verificar se houve erros ou não
if  (file_exists($vNameErr) and filesize($vNameErr)>0) { // há erros 
  $file = fopen ($vMostraErros, "r");
  $contents = fread ($file, filesize ($vMostraErros));
  $contents=addslashes($contents);
  echo "<pre>".$contents."</pre>";
  //system("rm figure.err");
  if ($semanticErrors==1) {
    echo "<h3><a href='$vNameErrorProofPDF'>The processed prover output in PDF format</a></h3>";
  }
  echo "<center>\n";
  echo "<a href='".$entradaURL."Interaction/insertCode.php?argumento=$pCodeTmpId'>go back</a>\n";
  echo "</center>\n";
  // Se há erros semânticos então cria um "link" para a prova
 }
 else { // Caso não haja erros vai processar a figura
   // Vai produzir o texto LaTeX referente à Figura
   ob_start();
   print "\documentclass[12pt]{article}\n";
   // necessária em ambos os casos, no caso do GCLC só para lidar com as cores
   print "\\usepackage{pstricks}\n"; 
   print "\\usepackage{color}\n";
   if ($pDrwId==3)  
     print "\\usepackage{gclc}\n";
   print "\\pagestyle{empty}\n";
   print "\\begin{document}\n";
   print "\\input{ $vNamePIC }\n";
   print "\\end{document}\n";
   
   $texfile=fopen($vNameTeX,"w");
   fwrite($texfile,ob_get_contents()); 
   fclose($texfile); 
   
   
   system("latex $vNameTeX"); 
   system("dvips $vNameDVI -o $vNamePS"); 
   system("ps2epsi $vNamePS $vNameEPSI");
   // system("dvips -E $vNameDVI -o $vNameEPSI"); 
   system("convert $vNameEPSI $vNameJPG");
   ob_end_clean(); 
   
   // e agora a inserção da imagem
   $fp      = fopen($vNameJPG, 'r');
   $content = fread($fp, filesize($vNameJPG));
   $content = addslashes($content);
   fclose($fp);

   $sqlLastInsert = "SELECT LAST_INSERT_ID()";
   $resultadoLastInsert = mysqli_query($ligacao,$sqlLastInsert);
   $linha = mysqli_fetch_assoc($resultadoLastInsert);
   $pCodeTmpId=$linha['LAST_INSERT_ID()'];


   $sqlfigure = "UPDATE codeTmp
                    SET figure = '$content'
                  WHERE codeTmpId = $argumento";
   
   $resultadofigure = mysqli_query($ligacao,$sqlfigure);

   if (!$resultadofigure) {
     echo "Error";
     exit;
   }
   
   echo "<meta http-equiv='refresh' content='0; url=".$entradaURL."Interaction/insertCode.php?argumento=$argumento&figId=$vFigureId&insercao=$insercao' />";
 }
?>

<hr/>

<?php
require($entradaFILE.'footer.php');
?>
