<?php 
session_start();
/*
 * Geothms/validateUpdateGeoThms.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

require_once('../servidor.php');

$pTipoUtilizador = $_SESSION['tipoUtilizador'];
if ($pTipoUtilizador=="anonymous" || $pTipoUtilizador=="regular") { // separa por tipo de utilizador
  require($entradaFILE.'headerUsers.php');
  require($entradaFILE.'menuUsers.php');
  echo "<meta http-equiv='refresh' content='0; url=".$entradaURL."users.php' />";
  exit;  // os anonimos não têem acesso a esta página
}
else {
  require($entradaFILE.'headerAdmins.php');
  require($entradaFILE.'menuAdmins.php');
}
?>

<hr/>


<?php
require($entradaFILE.'dbLogin.php');
?>


<center>
<h3 class="maketitle">Geometric theorems - Insert a New Theorem</h3>
</center>


<?php
//require('insertGeoThm.php');




 // é a primeira vez ou os dados estão em "branco"
if ((!isset($_POST['ListWords']) or $_POST['ListWords']=="")) {
  echo "<form enctype='multipart/form-data' action='validateInsertGeoThm.php' method='post'>";
  echo "<!-- ficha -->";
  echo "<table width='100%' bgcolor='white' cellpadding='4' cellspacing='4' border='1'>";
  echo "<tr>";
  echo "<td align='left' width='25%'><span class='ficha'>(short) List of words to look for</span></td>"; 
  echo "<td width='75%'><span class='entrada'><input type='text' name='ListWords' size='60'></span></td>";
  echo "</tr>";
  echo "<tr>";
  echo "<td width='100%' colspan='3' align='left'><input type='submit' value='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Look for an existing problem &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'></td>";
  echo "<tr>\n";
  echo "</table>";
  echo "</form>";
}
 else { // Existem dados para validar 
  // Procurar em theorems.shortDescription,description,teoName
  
  // AFazer: procurar em figures.code,figure e em demonstrations.code,proof
  
  // AFazer: implementar uma pesquisa mais eficiente - tipo Google com
  // percentagem de semelhança
  $ListWords   = $_POST['ListWords'];

  // Vai substituir os espaços entre palavras por '%' para depois
  // poder usar o operador LIKE do SQL

  $pattern = '/[\s,]+/';
  $replacement = '%';

  $ListWords = '%'.preg_replace($pattern,$replacement,$ListWords).'%';
  
  $sqlListWords = "SELECT teoId,description,shortDescription,teoName
                     FROM theorems
                    WHERE description LIKE '%$ListWords%'
                       OR shortDescription LIKE '%$ListWords%'
                       OR teoName LIKE '$ListWords'";
  
  // ---------------------------------a continuar--------------------
  $resultadoListWords = mysqli_query($ligacao,$sqlListWords);
  
  $nlinhasListWords =mysqli_num_rows($resultadoListWords);
  
  // A procura tenta achar palavras semelhantes, caso não haja dá de
  // imediato a hipótese de introduzir a informação
  if ($nlinhasListWords==0) { 
    echo "<h2>Similar Problems not found</h2>";
    echo "<center>\n";
    echo "<table width=80% border=1>\n";
    print "<tr>\n";
    print " <td align='right'><a href=insertGeoThm.php>Insert a New Problem</a></td>\n"; 
    print "</tr>\n\n";
    print "</table>\n";
    print "</center>\n";
  }
  else {
    echo "<h2>There are similar problems already in the data base</h2>";
    // Mostra os valores, dos nomes semelhantes
    mostra_resultados($resultadoListWords);
  }
 }



?>

<?php

function mostra_resultados($resultado) {
  print "<table border=1 width=100%>\n";
  print "<tr>\n";
  print " <td colspan=5 STYLE='background:#efefff' align=right><a href=insertGeoThm.php>Insert a new Geometric Problem</a></td>\n";
  print "</tr>\n\n";
  print "<tr>\n";  
  print "</table>\n";
  print "<table border=1 width=100%>\n";
  print "<tr>\n";
  //print "<th> GeoThm Id</th><th> Name</th><th>&nbsp;</th><th>&nbsp;</th>";
  print "<th> Name</th><th>Short Description</th>&nbsp;</th><th>&nbsp;</th>";
  print "</tr>\n\n";
  while ($linha = mysqli_fetch_assoc($resultado)) {
    print "<tr>\n";
    $TeoId=trim($linha['teoId']);
    $TeoName=trim($linha['teoName']);
    $ShortDescription = trim($linha['shortDescription']);
    //  print " <td align=center>$pTeoId</td>\n"; 
    print " <td>$TeoName</td>\n";
    print " <td>$ShortDescription</td>\n";
    print " <td><a href=Forms/formGeoThm.php?argumento=$TeoId>See details</a></td>\n";
    print " <td><a href=updateGeoThm.php?argumento=$TeoId>update</a></td>\n";
    print"</tr>";
  }
  print "</table>\n";
  
}

?>

<hr>

<?php
  require_once($entradaFILE.'footer.php');
?>



