<?php 
session_start();
/*
 * Geothms/updateGeoThm.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

require_once('../servidor.php');

$pTipoUtilizador = $_SESSION['tipoUtilizador'];
if ($pTipoUtilizador=="anonymous" || $pTipoUtilizador=="regular") { // separa por tipo de utilizador
  require($entradaFILE.'headerUsers.php');
  require($entradaFILE.'menuUsers.php');
}
else {
  require($entradaFILE.'headerAdmins.php');
  require($entradaFILE.'menuAdmins.php');
}

?>


<hr/>



<?php
require($entradaFILE.'dbLogin.php');
?>


<center>
<h3 class="maketitle">Update a Geometric Problem</h3>
</center>


<hr/>

<?php

$argumento = $_GET['argumento'];

// cria uma pesquisa para obter a informao do problema, qualquer
// (eventual) referncia bibliogrfica que haja ter de ser obtida
//  parte para salguardar o caso em que no h nenhuma referncia
// bibliogrfica.
$sql = "SELECT teoId,teoName,category,description,shortDescription,
               dateSubmission,userId
          FROM theorems
         WHERE theorems.teoId='$argumento'";

$resultado = mysqli_query($ligacao,$sql);

$ncampos =mysqli_num_fields($resultado);


$linha = mysqli_fetch_assoc($resultado);

$pTeoId            = $linha['teoId'];
$pTeoName          = $linha['teoName'];
$pTeoName          = htmlspecialchars("$pTeoName", ENT_QUOTES);
//$pBibref         = $linha['bibref'];
$pCategory         = $linha['category'];
$pDateSubmission   = $linha['dateSubmission'];
$pDescription      = $linha['description'];
$pShortDescription = $linha['shortDescription'];
$pOldUserId        = $linha['userId'];

echo "<form enctype='multipart/form-data' action='uUpdateGeoThm.php' method='post'>\n";
echo "<!-- ficha -->\n";
echo "<table width='100%' bgcolor='white' cellpadding='4' cellspacing='4'>\n";
echo "<tr>\n";
echo "<td width='100%' colspan='8' align='center'>
       <span class='titulo'>$pTeoName Info</span>
      </td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td align='left' width='25%' colspan='2'>
       <span class='optional'>Theorem ID</span>
      </td>\n";
echo "<input type='hidden' name='TeoId' value='$pTeoId' size='10'>\n";
echo "<td width='75%' colspan='6'>
       <span class='entrada'>$pTeoId</span>
      </td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td align='left' width='25%' colspan='2'>
       <span class='optional'>Name of the Theorem (if any)</span>
      </td>\n";
echo "<td width='75%' colspan='6'>
       <span class='entrada'><input type='text' name='TeoName' value='$pTeoName' size='80' maxlength='80'></span>
      </td>\n"; 
echo "</tr>\n";
echo "<tr>";
echo "<td width='25%' colspan='2'>
       <span class='ficha'>Date of Submission</span>
      </td>\n";
echo "<td width='25%' colspan='2'>
       <input type='text' name='DateSubmission' value='$pDateSubmission' size='10'>
      </td>\n"; 
echo "<td width='25%' colspan='2'>
       <span class='ficha'>Contributor's Name</span>
      </td>";
// select a User form a list of users
$sqlUserId = "SELECT userId,name,email
                FROM users
               WHERE type='Contributer'
            ORDER BY name";
$resultadoUserId = mysqli_query($ligacao,$sqlUserId);
echo "<td width='25%' colspan='2'><span class='entrada'><SELECT NAME='UserInfo'>";
while ($linhaUserId = mysqli_fetch_assoc($resultadoUserId)){
  $pUserId=trim($linhaUserId['userId']);
  $pName=trim($linhaUserId['name']);
  if ($pUserId==$pOldUserId)
    print "<option SELECTED>$pUserId -- $pName</option>\n"; 
  else
    print "<option>$pUserId -- $pName</option>\n"; 
 };
echo "</SELECT>";
echo "</td>";
echo "</tr>";
echo "<td width='25%' colspan='2'>Category </td>\n";
echo "<td width='75%' colspan='6'>
       <input type='text' name='Category' value='$pCategory' size='25' value='Geometry'>
      </td>\n"; 
echo "</tr>\n";
echo "<tr>\n";
echo "<td width='25%' colspan='2'><span class='ficha'>Description</span></td>\n";
echo "<td width='75%' colspan='6'><TEXTAREA NAME='ShortDescription' ROWS='10' COLS='120'>$pShortDescription</TEXTAREA></td>\n";
echo "</tr>\n";
echo "<tr>\n"; 
echo "<td width='25%' colspan='2'><span class='ficha'>Formal Statement (LaTeX code)</span></td>\n";
echo "<td width='75%' colspan='6'><TEXTAREA NAME='Description' ROWS='10' COLS='120'>$pDescription</TEXTAREA></td>\n";
echo "</tr>\n  ";
echo "<tr>\n";
echo "<td width='25%' colspan='2'>
       <span class='optional'>Bibliographic Reference</span>
      </td>\n";

// Vai listar as vrias referncias bibliogrficas dando a hiptese,
// de as seleccionar para serem apagadas.

$sqlBibTeo = "SELECT theorems.teoId,bibrefId
                FROM theorems INNER JOIN bibtheorem
                     ON theorems.teoId=bibtheorem.teoId
               WHERE theorems.teoId='$pTeoId'";

$resultadoBibTeo = mysqli_query($ligacao,$sqlBibTeo);


$nlinhasBibTeo =  mysqli_num_rows($resultadoBibTeo);

// Dado que se pode ter mais do que uma ref. bib. a informao do nmero
// de refs bibs tem de ser passada (escondida), assim como se tem de
// etiquetar todas as diferentes refs bibs

echo "<input type='hidden' name='NumRefBibTeo' value='$nlinhasBibTeo'>\n";

if ($nlinhasBibTeo==0) { // caso no haja referncias
  print "<td width='50%' colspan='4'>&nbsp;</td>\n";
}
else { 
  $iaux=1;
  print "<td width='50%' colspan='4'>";
  while ($linhaBibTeo = mysqli_fetch_assoc($resultadoBibTeo)) {
    $pBibRefTeo = trim($linhaBibTeo['bibrefId']);
    echo "<input type='hidden' name='BibRefTeo$iaux' value='$pBibRefTeo'>\n";

    print "$pBibRefTeo\n";
    print "<input type='checkbox' name='DelBibRefTeo$iaux'> (delete)";
    if ($iaux<$nlinhasBibTeo) print "; ";
    $iaux++;
  }
  print "</td>\n";
}

// Vai agora das a hiptese de inserir uma (s uma) nova ref. bib.

// select a bibref form a list of bibrefs
$sql_bibrefId = "SELECT bibrefId
                   FROM bibrefs
               ORDER BY bibrefId";
$resultado_bibrefId = mysqli_query($sql_bibrefId,$ligacao);
echo "<td width='25%' colspan='2'>";
echo "<span class='entrada'><SELECT NAME='NewBibRefTeo'>";
while ($linha_bibrefId = mysqli_fetch_assoc($resultado_bibrefId)) {
  $pBibrefId=trim($linha_bibrefId['bibrefId']);
  print "<option>$pBibrefId</option>\n"; 
};
echo "</SELECT></span>\n";
print "<input type='checkbox' name='CheckNewBibRefTeo'> (new)";
echo "</td>\n";
echo "</tr>\n";

//
// Theorem Figure Info --- A(s) figura(s) existente(s) para este teorema
//

//
// Para j no h diviso (em ficheiros) entre DGSs
//

// cria uma pesquisa para obter a informao da figura, qualquer
// (eventual) referncia bibliogrfica que haja ter de ser obtida
// aparte para salguardar o caso em que no h nenhuma referncia
// bibliogrfica.
$sqlFig = "SELECT figureId,teoId,drawerId,code,codeXML,dateSubmission,
                  userId,figureSVG
             FROM figures
            WHERE teoId='$pTeoId'";

$resultadoFig = mysqli_query($ligacao,$sqlFig);
//$ncamposFig   = mysqli_num_fields($resultadoFig);

$nlinhasFig =  mysqli_num_rows($resultadoFig);

// Dado que se pode ter mais do que uma figura a informao do nmero
// de figuras tem de ser passada (escondida), assim como se tem de
// etiquetar todas as diferentes figuras

echo "<input type='hidden' name='NumFiguras' value='$nlinhasFig'>\n";


if ($nlinhasFig==0) {
  echo "<tr>";
  echo "<td width='100%' colspan='8' align='center'>
         <span class='titulo'>$pTeoName - No Figures</span>
        </td>\n";
  echo "</tr>";
}
else {
  echo "<tr>";
  echo "<td width='100%' colspan='8' align='center'>
         <span class='titulo'>$pTeoName - Figure Info</span>
        </td>\n";
  echo "</tr>";


  // mostra os detalhes para cada uma das imagens
  
  $nImagem=0; // inicializa contador a zero
  while ($linhaFig = mysqli_fetch_assoc($resultadoFig)) {
    
    $nImagem=$nImagem+1; // incrementa o contador de imagens
    
    if ($nImagem>1) // linha de separao entre imagens
      echo "<tr><td colspan='8'><hr></td></tr>";
    
    $pFigId                = trim($linhaFig['figureId']); 
    $pDrwId                = trim($linhaFig['drawerId']); 
    $pDrawerCode           = trim($linhaFig['code']);
    $pCodeXML              = trim($linhaFig['codeXML']);
    $pDateSubmissionDrawer = trim($linhaFig['dateSubmission']);  
    $pOldUserIdDrw         = trim($linhaFig['userId']);  
    
    // Obtm o nome do Desenhador
    $sqlDrw = "SELECT name,version
                 FROM drawers
                WHERE drawerId='$pDrwId'";
    $resultadoDrw = mysqli_query($ligacao,$sqlDrw);
    $linhaDrw = mysqli_fetch_assoc($resultadoDrw);
    
    // Obtm o identificador do Utilizador
    $sqlUsr = "SELECT name,email
                 FROM users
                WHERE userId='$pUserIdDrw'";
    $resultadoUsr = mysqli_query($ligacao,$sqlUsr);
    $linhaUsr = mysqli_fetch_assoc($resultadoUsr);
    
    
    $pDrwName    = trim($linhaDrw['name']);
    $pDrwVersion = trim($linhaDrw['version']);
    
    $pDrawerUserName   = trim($linhaUsr['name']);
    $pDrawerUserEmail  = trim($linhaUsr['email']);
    
    // O identificador da Figura tem de ser enviado (escondido)
    echo "<input type='hidden' name='FigId$nImagem' value='$pFigId'>\n";
    
    echo "<tr>";
    echo "<td width='25%' colspan='2'>
         <span class='ficha'>Drawer Name</span>
        </td>\n";
    echo "<td width='25%' colspan='2'>
         <input type='text' name='DrawerName$nImagem' value='$pDrwName' size='15'>
        </td>\n";
    echo "<td width='25%' colspan='2'>
         <span class='ficha'>Drawer Version</span>
        </td>\n";
    echo "<td width='25%' colspan='2'>
         <input type='text' name='DrawerVersion$nImagem' value='$pDrwVersion' size='5'>
        </td>\n";
    echo "</tr>";
    echo "<tr>"; 
    echo "<td width='25%' colspan='2'>
         <span class='ficha'>Date of Submission</span>
        </td>\n";
    echo "<td width='25%' colspan='2'>
         <input type='text' name='DateSubmissionDrawer$nImagem' value='$pDateSubmissionDrawer' size='10'>
        </td>\n"; 
    echo "<td width='25%' colspan='2'>
         <span class='ficha'>Contributor's Name</span>
        </td>";
    
    // select a User form a list of users
    $sqlUserDrawer = "SELECT userId,name,email
                        FROM users
                       WHERE type='Contributer'
                    ORDER BY name";
    $resultadoUserDrawer = mysqli_query($ligacao,$sqlUserDrawer);
    echo "<td width='25%' colspan='2'><span class='entrada'>
         <SELECT NAME='DrawerUserName$nImagem'>";
    while ($linhaUserDrawer = mysqli_fetch_assoc($resultadoUserDrawer)){
      $pUserDrawerId=trim($linhaUserDrawer['userId']);
      $pName=trim($linhaUserDrawer['name']);
      if ($pUserDrawerId==$pOldUserIdDrw)
	print "<option SELECTED>$pUserDrawerId -- $pName</option>\n"; 
      else
	print "<option>$pUserDrawerId -- $pName</option>\n"; 
    };
    echo "</SELECT>";
    echo "</td>";
    
    //  echo "<td width='25%' colspan='2'> 
    //          <input type='text' name='DrawerUserName$pFigId' value='$pDrawerUserName' size='25'>
    //         </td>\n"; // este tem de passar a ser uma caixa de escolha
    echo "</tr>";
    echo "<tr>";
    echo "<td width='25%' colspan='2'>
         <span class='ficha'>Bibliographic Reference(s)</span>
        </td>"; 
    
    // Vai listar as vrias referncias bibliogrficas dando a hiptese,
    // de as seleccionar para serem apagadas.
    
    $sqlBibFig = "SELECT figures.figureId,teoId,bibrefId
                  FROM figures INNER JOIN bibfigure
                       ON figures.figureId=bibfigure.figureId             
                 WHERE teoId='$pTeoId'
                   AND figures.figureId=$pFigId";
    
    $resultadoBibFig = mysqli_query($ligacao,$sqlBibFig);
    
    
    $nlinhasBibFig =  mysqli_num_rows($resultadoBibFig);
    
    // Dado que se pode ter mais do que uma ref. bib. a informao do nmero
    // de refs bibs tem de ser passada (escondida), assim como se tem de
    // etiquetar todas as diferentes refs bibs
    
    echo "<input type='hidden' name='NumRefBibFig$nImagem' value='$nlinhasBibFig'>\n";
    
    if ($nlinhasBibFig==0) { // caso no haja referncias
      print "<td width='50%' colspan='4'>&nbsp;</td>\n";
    }
    else { 
      $iaux=1;
      print "<td width='50%' colspan='4'>";
      while ($linhaBibFig = mysqli_fetch_assoc($resultadoBibFig)) {
	$pBibRefFig = trim($linhaBibFig['bibrefId']);
	echo "<input type='hidden' name='BibRefFig$nImagem-$iaux' value='$pBibRefFig'>\n";
	print "$pBibRefFig\n";
	print "<input type='checkbox' name='DelBibRefFig$nImagem-$iaux'> (delete)";
	if ($iaux<$nlinhasBibFig) print "; ";
      }
      print "</td>\n";
    }
    
    // Vai agora das a hiptese de inserir uma (s uma) nova ref. bib.
    
    // select a bibref form a list of bibrefs
    $sql_bibrefId = "SELECT bibrefId
                     FROM bibrefs
                 ORDER BY bibrefId";
    $resultado_bibrefId = mysqli_query($sql_bibrefId,$ligacao);
    echo "<td width='25%' colspan='2'>";
    echo "<span class='entrada'><SELECT NAME='NewBibRefFig$nImagem'>";
    while ($linha_bibrefId = mysqli_fetch_assoc($resultado_bibrefId)) {
      $pBibrefId=trim($linha_bibrefId['bibrefId']);
      print "<option>$pBibrefId</option>\n"; 
    };
    echo "</SELECT></span>\n";
    print "<input type='checkbox' name='CheckNewBibRefFig$nImagem'> (new)";
    echo "</td>\n";
    echo "</tr>\n";
    echo "<tr>";
    echo "<td width='25%' colspan='2'>
         <span class='ficha'>Figure</span>
        </td>\n";
    echo "<td width='75%' colspan='6'>
         <TEXTAREA NAME='DrawerCode$nImagem' ROWS='15' COLS='120'>$pDrawerCode</TEXTAREA>
        </td>\n";
    echo "</tr>";
    // fim do ciclo
  }
}
// No caso em que no haja nenhuma imagem vai-se dar a hiptese de
// inserir uma. Aps essa insero volta-se aqui para continuar o
// processo de actualizao.
echo "<tr>\n";
echo "<td width='100%' colspan='8' align='left'>
         <span class='optional'>
           <a href='".$entradaURL."Figures/insertFigure.php?teoId=$pTeoId'>Insert a New Figure</a>
         </span>
        </td>\n";
echo "</tr>\n  ";

  
//
// Theorem - Demonstraes --- A(s) provas(s) existente(s) para este teorema
//
//

// cria uma pesquisa para obter a informao da prova, qualquer
// (eventual) referncia bibliogrfica que haja ter de ser obtida 
// parte para salguardar o caso em que no h nenhuma referncia
// bibliogrfica.

// vai obter a restante informao (sem ref bib)
$sqlDem = "SELECT demId,code,dateSubmission,userId,proverId
             FROM demonstrations
            WHERE teoId='$pTeoId'";



$resultadoDem = mysqli_query($ligacao,$sqlDemPrv);

$resultadoDem = mysqli_query($ligacao,$sqlDem);
$nLinhasDem =mysqli_num_rows($resultadoDem);

// Dado que se pode ter mais do que uma figura a informao do nmero
// de figuras tem de ser passada (escondida), assim como se tem de
// etiquetar todas as diferentes figuras

echo "<input type='hidden' name='NumDemonstracoes' value='$nLinhasDem'>\n";

if ($nLinhasDem==0) { // caso em que no h provas
  echo "<tr>";
  echo "<td width='100%' colspan='8' align='center'>
         <span class='titulo'>$pTeoName - No Proofs</span>
        </td>\n";
  echo "</tr>";
}
else { // caso em que h pelo menos uma prova

  echo "<tr>";
  echo "<td width='100%' colspan='8' align='center'>
         <span class='titulo'>$pTeoName - Proofs Info</span>
        </td>\n";
  echo "</tr>";
  
  // mostra os detalhes para cada uma das demonstraes
  $nDem=0; // inicializa contador a zero
  while ($linhaDem = mysqli_fetch_assoc($resultadoDem)) {
    
    $nDem=$nDem+1; // incrementa o contador das demonstraes
    
    if ($nDem>1) // linha de separao entre as demonstraes
      echo "<tr><td colspan='8'><hr></td></tr>";

    // O restante processamento  dependente do provador escolhido
    // vai obter o nome do Provador
    $pPrvId                = trim($linhaDem['proverId']);

    // assim como a restante informao
    $pDemId                = trim($linhaDem['demId']);
    $pProverCode           = trim($linhaDem['code']);
    $pProverDateSubmission = trim($linhaDem['dateSubmission']);
    $pOldUserIdPrv         = trim($linhaDem['userId']);

    // Como s se quer o cdigo  genrico para todos os provadores


    // Obtm o nome do Provador
    $sqlPrv = "SELECT name,version
                 FROM provers
                WHERE proverId='$pPrvId'";
    $resultadoPrv = mysqli_query($ligacao,$sqlPrv);
    $linhaPrv = mysqli_fetch_assoc($resultadoPrv);
    
    // Obtm o identificador do Utilizador
    $sqlUsr = "SELECT name,email
                 FROM users
                WHERE userId='$pUserIdPrv'";
    $resultadoUsr = mysqli_query($ligacao,$sqlUsr);
    $linhaUsr = mysqli_fetch_assoc($resultadoUsr);
    
    
    $pPrvName    = trim($linhaPrv['name']);
    $pPrvVersion = trim($linhaPrv['version']);
    
    $pProverUserName   = trim($linhaUsr['name']);
    $pProverUserEmail  = trim($linhaUsr['email']);
    
    // O identificador da Demonstrao tem de ser enviado (escondido)
    echo "<input type='hidden' name='DemId$nDem' value='$pDemId'>\n";

    // a tabela
    echo "<tr>";
    echo "<tr>";
    echo "<td width='25%' colspan='2'>
           <span class='ficha'>Prover Name</span>
          </td>\n";
    echo "<td width='25%' colspan='2'>
           <input type='text' name='ProverName$nDem' value='$pPrvName' size='10'>
          </td>\n";
    echo "<td width='25%' colspan='2'>
           <span class='ficha'>Prover Version</span>
          </td>\n";
    echo "<td width='25%' colspan='2'>
           <input type='text' name='ProverVersion$nDem' value='$pPrvVersion' size='10'>
          </td>\n";
    echo "</tr>";
    echo "<tr>"; 
    echo "<td width='25%' colspan='2'>
           <span class='ficha'>Date of Submission</span>
          </td>\n";
    echo "<td width='25%' colspan='2'>
           <input type='text' name='ProverDateSubmission$nDem' value='$pProverDateSubmission' size='15'>
          </td>\n"; 
    echo "<td width='25%' colspan='2'>
           <span class='ficha'>Contributor's Name</span>
          </td>\n";

    // select a User form a list of users
    $sqlUserProver = "SELECT userId,name,email
                        FROM users
                       WHERE type='Contributer'
                    ORDER BY name";
    $resultadoUserProver = mysqli_query($ligacao,$sqlUserProver);
    echo "<td width='25%' colspan='2'><span class='entrada'>
         <SELECT NAME='ProverUserName$nDem'>";
    while ($linhaUserProver = mysqli_fetch_assoc($resultadoUserProver)){
      $pUserProver=trim($linhaUserProver['userId']);
      $pName=trim($linhaUserProver['name']);
      if ($pUserProver == $pOldUserIdPrv)
	print "<option SELECTED>$pUserProver -- $pName</option>\n"; 
      else
	print "<option>$pUserProver -- $pName</option>\n"; 
    };
    echo "</SELECT>";
    echo "</td>\n";

    echo "</tr>";


    echo "<tr>\n";
    echo "<td width='25%' colspan='2'>
       <span class='optional'>Bibliographic Reference</span>
      </td>\n";
    // Vai listar as vrias referncias bibliogrficas dando a hiptese,
    // de as seleccionar para serem apagadas.

    $sqlBibDem = "SELECT demonstrations.demId,teoId,bibrefId 
                    FROM demonstrations INNER JOIN bibproofs 
                         ON demonstrations.demId=bibproofs.demId  
                   WHERE teoId='$pTeoId'
                     AND demonstrations.demId=$pDemId";

    //print_r($sqlBibDem);
    //echo "<br";

    $resultadoBibDem = mysqli_query($ligacao,$sqlBibDem);
    
    $nlinhasBibDem =  mysqli_num_rows($resultadoBibDem);
    
    // Dado que se pode ter mais do que uma ref. bib. a informao do nmero
    // de refs bibs tem de ser passada (escondida), assim como se tem de
    // etiquetar todas as diferentes refs bibs
    
    echo "<input type='hidden' name='NumRefBibDem$nDem' value='$nlinhasBibDem'>\n";

    if ($nlinhasBibDem==0) { // caso no haja referncias
      print "<td width='50%' colspan='4'>&nbsp;</td>\n";
    }
    else { 
      $iaux=1;
      print "<td width='50%' colspan='4'>";
      while ($linhaBibDem = mysqli_fetch_assoc($resultadoBibDem)) {
	$pBibRefDem = trim($linhaBibDem['bibrefId']);
	echo "<input type='hidden' name='BibRefDem$nDem-$iaux' value='$pBibRefDem'>\n";
	print "$pBibRefDem\n";


	print "<input type='checkbox' name='DelBibRefDem$nDem-$iaux'> (delete)";
	if ($iaux<$nlinhasBibDem) print "; ";
      }
      print "</td>\n";
    }

    // Vai agora das a hiptese de inserir uma (s uma) nova ref. bib.
    
    // select a bibref form a list of bibrefs
    $sql_bibrefId = "SELECT bibrefId
                       FROM bibrefs
                   ORDER BY bibrefId";
    $resultado_bibrefId = mysqli_query($sql_bibrefId,$ligacao);
    echo "<td width='25%' colspan='2'>";
    echo "<span class='entrada'><SELECT NAME='NewBibRefDem$nDem'>";
    while ($linha_bibrefId = mysqli_fetch_assoc($resultado_bibrefId)) {
      $pBibrefId=trim($linha_bibrefId['bibrefId']);
      print "<option>$pBibrefId</option>\n"; 
    };
    echo "</SELECT></span>\n";
    print "<input type='checkbox' name='CheckNewBibRefDem$nDem'> (new)";
    echo "</td>\n";
    echo "</tr>\n";
    echo "<tr>";
    echo "<td width='25%' colspan='2'>
           <span class='ficha'>Proof Code</span>
          </td>\n";
    echo "<td width='75%' colspan='6'>
           <TEXTAREA NAME='ProverCode$nDem' ROWS='15' COLS='120'>$pProverCode</TEXTAREA>
          </td>\n";
    echo "</tr>";
  }
}
// d-se a hiptese de inserir mais uma prova
echo "<tr>\n";
echo "<td width='100%' colspan='8' align='left'>
       <span class='optional'>
         <a href='".$entradaURL."Proofs/insertProof.php?teoId=$pTeoId'>Insert a New Proof</a>
       </span>
      </td>\n";
echo "</tr>\n  ";



echo "<tr>\n";
echo "<td width='100%' colspan='8' align='left'>
       <input type='submit' value='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;update info &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'>
      </td>\n";
echo "</tr>\n  ";
echo "</table>\n";
echo "</form>\n";
?>

<hr/>

<?php
  require_once($entradaFILE.'footer.php');
?>