<?php
session_start();
/*
 * Geothms/listingGeoThms.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

require_once("../servidor.php");
$pTipoUtilizador = $_SESSION['tipoUtilizador'];
if ($pTipoUtilizador=="anonymous" || $pTipoUtilizador=="regular") {// separa por tipo de utilizador
  require($entradaFILE.'headerUsers.php');
  require($entradaFILE.'menuUsers.php');
}
else {
  require($entradaFILE.'headerAdmins.php');
  require($entradaFILE.'menuAdmins.php');
}
?>


<center>
<h2 class="maketitle">Problems List</h2>
</center>



<?php
require($entradaFILE.'dbLogin.php');
?>

<?php


 /* 
  * Só se vão seleccionar os problemas de nível zero, isto é os
  * problemas relacionados com o demonstrador de teoremas
  *
  */


// Condicional que controla se é a primeira vez ou se já é uma
// re-entrada e a consequente fixação dos valores das variáveis que
// depois vão controlar o funcionar do restante programa.
if (!isset($_POST['Nrows'])) { // Inicialização
  $modulo        = 10;
  $nPagina       = 1;
  $auxShow       = 'all';
  $auxSearch     = 'by Name';
  $valorPesquisa = ''; 
  $numPaginas    = 1; // Valor que não sei se é relevante... se não for é
		   // porque é alterado mais à frente
  // por omissão seleccionam-se todos os problemas
  $consultaSQL   = "SELECT teoId,teoName,shortDescription
                      FROM theorems
                     WHERE level=0
                  ORDER BY teoName";
}
else {
  // senão, começa por inicializar as variáveis 
  $modulo        = $_POST['Nrows'];
  $nPagina       = $_POST['nPagina'];
  $numPaginas    = $_POST['numPaginas'];
  $auxShow       = $_POST['Show'];
  $auxSearch     = $_POST['Search'];
  $valorPesquisa = $_POST['ValueSearch'];
  $consultaSQL   = $_POST['ConsultaSQL'];


  if (isset($_POST['GoTo'])) { // Vai modificar o valor da página corrente
    $auxGoto = $_POST['GoTo'];
    if ($auxGoto=='Home')
      $nPagina= 1;
    if ($auxGoto=='PgUp')
      if ($nPagina>1)
	$nPagina= $nPagina-1;
    if ($auxGoto=='PgDn')
      if ($nPagina<$numPaginas & $numPaginas>1 )
	$nPagina = $nPagina+1;
    if ($auxGoto=='End')
      $nPagina = $numPaginas;
  }

  
  // cria uma pesquisa, que: ou se mantém, ou foi alterada por invocação
  // da consulta apropriada para o efeito
  $consultaSQL=cria_pesquisa($auxShow,$auxSearch,$valorPesquisa);
  // vai colocar em sql uma pesquisa válida


}
  

// vai colocar em sql uma pesquisa válida
if ($consultaSQL!="") {
  $sql = $consultaSQL;
}
else {
  $sql = "SELECT teoId,teoName,shortDescription 
            FROM theorems 
           WHERE level=0
        ORDER BY teoName";
}

$resultado = mysqli_query($ligacao,$sql);


// O números de campos obtidos
$ncampos =mysqli_num_fields($resultado);
// O números de linhas obtidos
$nlinhas =mysqli_num_rows($resultado);


// Vai (eventualmente) modificar o número de páginas
if ($nlinhas<$modulo) {
  $nPagina = 1;
  $numPaginas = 1;
}
else {
  // calcula o divisor (inteiro) de nlinhas por módulo
  $numPaginas = ceil($nlinhas/$modulo); 
  // verifica se a página corrente não é maior do que o número de páginas
  // total
  if ($nPagina>$numPaginas) { // nesse caso coloca na última página
    $nPagina=$numPaginas;
  }
}

// echo "<center>";
// echo "<h4 class='maketitle'>$nlinhas Geometric Theorems</h4>";
// echo "</center>";

echo "<hr>";

//
// Construção da barra de opções
//
echo "<center>";
echo "<table border='1' width='100%'>\n";
print "<tr>\n"; 
//
// Opções de visualização "all/..."
//
print "<th align='center'>";
print "<table border='0'>";
print "<form action='listingGeoThms.php' method='post'>";
print "<tr>";
print "<th>
        <input type='submit' value='Show'>
       </th>";
print "<th>&nbsp;&nbsp;</th>"; 
print "<th><SELECT NAME='Show'>";
if ($auxShow=='all') {
  print "<option selected>all</option>";
}
else {
  print "<option>all</option>";
}
if ($auxShow=='with statement') {
  print "<option selected>with statement</option>";
}
else {
  print "<option>with statement</option>";
}
if ($auxShow=='with proofs') {
  print "<option selected>with proofs</option>";
}
else {
  print "<option>with proofs</option> ";
}if ($auxShow=='figures') {
  print "<option selected>with figures</option>";
}
else {
  print "<option>with figures</option>";
}
print "</SELECT></th>"; 
// todos os outro valores têem de ser passados como escondidos (6/7)
print "<input type='hidden' name='Nrows' value='$modulo'>";
print "<input type='hidden' name='nPagina' value='$nPagina'>";
print "<input type='hidden' name='numPaginas' value='$numPaginas'>";
print "<input type='hidden' name='Search' value='$auxSearch'>";
print "<input type='hidden' name='ValueSearch' value='$valorPesquisa'>";
print "<input type='hidden' name='ConsultaSQL' value='$consultaSQL'>";
print "</form>"; 
print "</tr>";
print "</table>\n";
print "</th>";
//
// Número de linhas por página
//
print "<th align='center'>";
print "<table border='0'>";
print "<tr>";
print "<form action='listingGeoThms.php' method='post'>";
print "<th><input type='submit' value='N. rows'</th>";
print "<th>&nbsp;&nbsp;</th>";
print "<th><SELECT NAME='Nrows'>";
if ($modulo==10) {
  print "<option selected>10</option>";
}
else {
  print "<option>10</option>";
}
if ($modulo==20) {
  print "<option selected>20</option>";
}
else {
  print "<option>20</option>";
}
if ($modulo==50) {
  print "<option selected>50</option>";
}
else {
  print "<option>50</option>";
}
if ($modulo==$nlinhas) {
  print "<option selected>$nlinhas</option>";
}
else {
  print "<option>$nlinhas</option>";
}
print "</SELECT></th>"; 
// todos os outro valores têm de ser passados como escondidos (6/7)
print "<input type='hidden' name='Show' value='$auxShow'>";
print "<input type='hidden' name='nPagina' value='$nPagina'>";
print "<input type='hidden' name='numPaginas' value='$numPaginas'>";
print "<input type='hidden' name='Search' value='$auxSearch'>";
print "<input type='hidden' name='ValueSearch' value='$valorPesquisa'>";
print "<input type='hidden' name='ConsultaSQL' value='$consultaSQL'>";
print "</form>"; 
print "</tr>";
print "</table>";
print "</th>";
//
// Número de páginas e de problemas
//
print "<th>";
print "<table width='100%' border='1'>";
print "<tr>\n";
print "<th>Page $nPagina of $numPaginas</th>"; 
print "</tr>\n";
print "<tr>\n";
print "<th><font size=-1>$nlinhas Problems</font></th>\n";
print "</tr>\n";
print "</table>";
print "</th>";
//
// teclas de mudança de página
//
print "<th align='center'>";
print "<table border='0'>";
print "<tr>";
print "<form action='listingGeoThms.php' method='post'>"; 
print "<input type='hidden' name='GoTo' value='Home'>";
print "<th><input type='submit' value='Home'></th>"; 
// todos os outros valores têm de ser passados como um valores escondidos
passa_todos_escondidos($auxShow,$modulo,$nPagina,$numPaginas,$auxSearch,$valorPesquisa,$consultaSQL);
print "</form>"; 
print "<th>&nbsp;&nbsp;</th>";
print "<form action='listingGeoThms.php' method='post'>"; 
print "<input type='hidden' name='GoTo' value='PgUp'>";
print "<th><input type='submit' value='Pg Up'></th>"; 
// todos os outros valores têm de ser passados como um valores escondidos
passa_todos_escondidos($auxShow,$modulo,$nPagina,$numPaginas,$auxSearch,$valorPesquisa,$consultaSQL); 
print "</form>"; 
print "<th>&nbsp;&nbsp;</th>";
print "<form action='listingGeoThms.php' method='post'>"; 
print "<input type='hidden' name='GoTo' value='PgDn'>";
print "<th><input type='submit' value='Pg Dn'></th>"; 
// todos os outros valores têm de ser passados como um valores escondidos
passa_todos_escondidos($auxShow,$modulo,$nPagina,$numPaginas,$auxSearch,$valorPesquisa,$consultaSQL); 
print "</form>"; 
print "<th>&nbsp;&nbsp;</th>";
print "<form action='listingGeoThms.php' method='post'>"; 
print "<input type='hidden' name='GoTo' value='End'>";
print "<th><input type='submit' value='End'></th>"; 
// todos os outros valores têm de ser passados como um valores escondidos
passa_todos_escondidos($auxShow,$modulo,$nPagina,$numPaginas,$auxSearch,$valorPesquisa,$consultaSQL); 
print "</form>"; 
print "</tr>";
print "</table>";
print "</th>";
//
// Pesquisas por "name/..."
//
print "<th>";
print "<table width='100%'>";
print "<tr>";
print "<form action='listingGeoThms.php' method='post'>";
// a pesquisa é, para já, só feita em termos de nomes dos teoremas
print "<th><input type='submit' value='Search'</th>";
print "<th><SELECT NAME='Search'>";
if ($auxSearch=="by Name") {
     print "<option selected>by Name</option>  ";
}
else {
  print "<option>by Name</option>  ";
}
//print "              <option>constructions used</option>  ";
//print "              <option>lemmas used</option> "; 
print "           </SELECT></th>"; 
print "</tr>"; 
print "<tr><th colspan='2' width='100%'> <input type='text' name='ValueSearch' size='20' value='$valorPesquisa'></th></tr>";
print "</table>";
// todos os outro valores têem de ser passados como escondidos
print "<input type='hidden' name='Show' value='$auxShow'>";
print "<input type='hidden' name='Nrows' value='$modulo'>";
print "<input type='hidden' name='nPagina' value='$nPagina'>";
print "<input type='hidden' name='numPaginas' value='$numPaginas'>";
print "<input type='hidden' name='ConsultaSQL' value='$consultaSQL'>";
print "</form>"; 
print "</th>";
print "</tr>\n\n";
// um último formúlario para re-inicializar valores
print "<tr>\n";
print "<form action='listingGeoThms.php' method='post'>\n";
print "<th colspan='10' align='left'>\n";
print "<input type='submit' value='reset'>\n";
print "</th>\n";
// Nenhum dos valores do formulário é passado 
print "</table>";
echo "</center>";


//print "<p>&nbsp;</p>";
echo "<hr>";
//print "<p>&nbsp;</p>";

if ($nlinhas==0) { // Não há resultados para mostrar
  print("<h2>".gettext("There are no results to show")."</h2>");
}
else { 
  // Vai mostrar os resultados por páginas (desde $inicio até $fim)
  // cabeçalho
  print "<center>";
  print "<table border=1 width=100%>\n";
  print "<tr>\n";
  //print "<th> GeoThm Id</th><th> Name</th><th>&nbsp;</th><th>&nbsp;</th>";
  print "<th> Name</th><th>Short Description</th><th>Figure</th><th>N. Figures</th><th>N. Proofs</th><th>&nbsp;</th>";
  print "</tr>\n\n";
  $inicio = 1+($nPagina-1)*$modulo;
  $fim = $nPagina*$modulo;
  if ($fim>$nlinhas) $fim=$nlinhas;
  $iaux = $inicio; 
  // Coloca o ponteiro $resultado a apontar para a 1a linha a obter (começa no 0)
  mysqli_data_seek($resultado, $iaux-1);
  // a variável $nThumbnail está relacionada com o mostrar de miniaturas das figuras.
  $nThumbnail=0;
  // começa por apagar as figuras anteriores
  system("rm figureDB*.png figureThumbnail*.png");
  while ($iaux<=$fim) {
    $linha = mysqli_fetch_assoc($resultado);
    print "<tr>\n";
    $pTeoId=trim($linha['teoId']);
    $pTeoName=trim($linha['teoName']);
    $pShortDescription=trim($linha['shortDescription']);
    //  print " <td align=center>$pTeoId</td>\n"; 
    print " <td>$pTeoName</td>\n";
    if ($pShortDescription=="")
      print " <td>&nbsp;</td>\n";
    else
      print " <td>$pShortDescription</td>\n";    
    $nThumbnail=$nThumbnail+1;
    print " <td align='center'>".obtemfigura($pTeoId,$nThumbnail,$ligacao)."</td>\n";
    print " <td align='center'>".numfiguras($pTeoId,$ligacao)."</td>\n";
    print " <td align='center'>".numprovas($pTeoId,$ligacao)."</td>\n";
    print " <td><a href=Forms/formGeoThm.php?argumento=$pTeoId>See details</a></td>\n";
    print"</tr>";
    $iaux=$iaux+1;
  }
  print "</table>\n";
  print "</center>";
  
  echo "<hr>";
  
  print "<p>&nbsp;</p>";
  
}

 
function obtemfigura($pTeoId,$nThumbnail,$ligacao) {
  // vai agora criar uma miniatura da imagem
  
  // primeiro obtém a imagem da Base de dados, dado que a selecção é
  // feita pelo identificação do teorema, vai-se obter a primeira das
  // imagens.
  
  $sqlFiguraPNG = "SELECT figure 
                                  FROM figures 
                                WHERE teoId='$pTeoId'"; 
  $resultadoFiguraPNG = mysqli_query($ligacao,$sqlFiguraPNG); 
  $linhaFiguraPNG = mysqli_fetch_array($resultadoFiguraPNG); 
  $FigurePNG = $linhaFiguraPNG["figure"]; 

  // Vai fazer o processamento num directório específico
  $vNameFiguraPNG="Imagens/figureDB".$nThumbnail.".png";
  $vNameThumbNailPNG="Imagens/figureThumbnail".$nThumbnail.".png";
  
  // depois escreve-a num ficheiro
  ob_start();
  print $FigurePNG;
  $texfile=fopen($vNameFiguraPNG,"w");
  fwrite($texfile,ob_get_contents()); 
  fclose($texfile); 
  ob_end_clean(); 
  
  // depois converte-a numa miniatura através do programa imagemagik é
  // de notar que além da miniaturização há (eventualmente) também uma
  // conversão de formatos (jpg para png).
  system("convert -size 80x80 $vNameFiguraPNG -thumbnail 80x80 -sharpen 0x2 $vNameThumbNailPNG");
  
  return("<img src='view_imageThumbnail.php?argumento=$vNameThumbNailPNG' alt='No Figure'>");
}

function numfiguras($pTeoId,$ligacao) {
  $sqlFig = "SELECT figureId
               FROM figures
              WHERE teoId='$pTeoId'";

  $resultadoFig = mysqli_query($ligacao,$sqlFig);
  $nlinhasFig   = mysqli_num_rows($resultadoFig);
  
  return($nlinhasFig);
}

function numprovas($pTeoId,$ligacao) {
  // cria uma pesquisa --- para obter o número de provas.
  $sqlDem = "SELECT demId
               FROM demonstrations
              WHERE teoId='$pTeoId'";
  
  $resultadoDem = mysqli_query($ligacao,$sqlDem);
  $nLinhasDem =mysqli_num_rows($resultadoDem);
  return($nLinhasDem);
}

function passa_todos_escondidos($auxShow,$modulo,$nPagina,$numPaginas,$auxSearch,$valorPesquisa,$consultaSQL) {
  // todos os valores têem de ser passados como escondidos (7)
  print "<input type='hidden' name='Show' value='$auxShow'>";
  print "<input type='hidden' name='Nrows' value='$modulo'>";
  print "<input type='hidden' name='nPagina' value='$nPagina'>";
  print "<input type='hidden' name='numPaginas' value='$numPaginas'>";
  print "<input type='hidden' name='Search' value='$auxSearch'>";
  print "<input type='hidden' name='ValueSearch' value='$valorPesquisa'>";
  print "<input type='hidden' name='ConsultaSQL' value='$consultaSQL'>";
}


function mostra_valores($auxShow,$modulo,$nPagina,$numPaginas,$auxSearch,$valorPesquisa,$consultaSQL) {
  print "<p>Show -- $auxShow</p>";
  print "<p>Nrows -- $modulo</p>";
  print "<p>nPagina -- $nPagina</p>";
  print "<p>numPaginas -- $numPaginas</p>";
  print "<p>Search -- $auxSearch</p>";
  print "<p>ValueSearch -- $valorPesquisa</p>";
  print "<p>ConsultaSQL -- $consultaSQL</p>";
}

// --> $auxShow,$valorPesquisa,$auxSearch
// <-- $consultaSQL
function cria_pesquisa($auxShow,$auxSearch,$valorPesquisa) {

  $selectSQL = "DISTINCT theorems.teoId,teoName,shortDescription";
  $orderbySQL = "teoName";

  switch ($auxShow) {
  case 'all':       // vai seleccionar todos os elementos
    $fromSQL = "theorems";
    $whereSQL = "level=0";
    switch ($auxSearch) {
    case 'by Name':
      $whereSQL = $whereSQL." AND teoName LIKE '%$valorPesquisa%'";
      break;
    case 'constructions used':    
      // a pesquisa devia ser feita nas figuras adestritas aos teoremas 
      // XXX Está por fazer XXX
      break;
    case 'lemmas used':  
      // a pesquisa devia ser feita nas figuras adestritas aos teoremas 
      // XXX Está por fazer XXX
      break;
    }
    break;
  case 'with statement':   // vai seleccionar só os que têem um enunciado formal
    $fromSQL = "theorems";
    $whereSQL = "level=0 AND NOT(description IS NULL)";
    switch ($auxSearch) {
    case 'by Name':
      $whereSQL = $whereSQL." AND teoName LIKE '%$valorPesquisa%'";
      break;
    case 'constructions used':    
      // a pesquisa devia ser feita nas figuras adestritas aos teoremas 
      // XXX Está por fazer XXX
      break;
    case 'lemmas used':  
      // a pesquisa devia ser feita nas figuras adestritas aos teoremas 
      // XXX Está por fazer XXX
      break;
    }
    break;
  case 'with proofs':   // vai seleccionar só os que têem uma demonstração
    $fromSQL = "theorems JOIN demonstrations 
                ON theorems.teoId=demonstrations.teoId";
    $whereSQL = "level=0";
    switch ($auxSearch) {
    case 'by Name':
      $whereSQL = $whereSQL." AND teoName LIKE '%$valorPesquisa%'";
      break;
    case 'constructions used':    
      // a pesquisa devia ser feita nas figuras adestritas aos teoremas 
      // XXX Está por fazer XXX
      break;
    case 'lemmas used':  
      // a pesquisa devia ser feita nas figuras adestritas aos teoremas 
      // XXX Está por fazer XXX
      break;
    }
    break;
  case 'with figures':   // vai seleccionar só os que têem uma figura
    $fromSQL = "theorems JOIN figures
                ON theorems.teoId=figures.teoId";
    $whereSQL = "level=0";
    switch ($auxSearch) {
    case 'by Name':
      $whereSQL = $whereSQL." AND teoName LIKE '%$valorPesquisa%'";
      break;
    case 'constructions used':    
      // a pesquisa devia ser feita nas figuras adestritas aos teoremas 
      // XXX Está por fazer XXX
      break;
    case 'lemmas used':  
      // a pesquisa devia ser feita nas figuras adestritas aos teoremas 
      // XXX Está por fazer XXX
      break;
    }
    break;
  }

  $consultaSQL = "SELECT ".$selectSQL." 
                    FROM ".$fromSQL."
                   WHERE ".$whereSQL."
                ORDER BY ".$orderbySQL;
  return($consultaSQL);
}

?>

<?php
  require($entradaFILE.'footer.php');
?>
