<?php 
session_start();
/*
 * Geothms/insertGeoThm.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

require_once('../servidor.php');
$pTipoUtilizador = $_SESSION['tipoUtilizador'];
if ($pTipoUtilizador=="anonymous" || $pTipoUtilizador=="regular") {// separa por tipo de utilizador
  require($entradaFILE.'headerUsers.php');
  require($entradaFILE.'menuUsers.php');
}
else {
  require($entradaFILE.'headerAdmins.php');
  require($entradaFILE.'menuAdmins.php');
}

// coloca o valor para a pgina de ajuda apropriada
$_SESSION['helpsection']='interaction';

require_once($entradaFILE.'dbLogin.php');

?>


<hr/>

<center>
<h3 class="maketitle">Insert a New Problem</h3>
</center>

<hr/>

<?php

$hoje=date("Y-m-d");

echo "<!-- ficha -->";
echo "<form enctype='multipart/form-data' action='iInsertGeoThm.php' method='post'>\n";
echo "<table width='100%' bgcolor='white' cellpadding='4' cellspacing='4'>\n";
echo "<tr>\n";
echo "<td width='100%' colspan='8' align='center'>
       <span class='titulo'>Geometric Problem Info</span>
      </td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td align='left' width='25%' colspan='2'>
        <span class='obligatory'>Name of the Theorem</span>
      </td>\n";
echo "<td width='75%' colspan='6'>
       <span class='entrada'><input type='text' name='TeoName' size='80' maxlength='80'></span>
      </td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td align='left' width='25%' colspan='2'>
        <span class='optional'>Informal Description</span>
      </td>\n";
echo "<td width='75%' colspan='6'>
       <span class='entrada'>
         <TEXTAREA NAME='ShortDescription' ROWS='10' COLS='120'></TEXTAREA>
       </span>
      </td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td width='25%' colspan='2'>
       <span class='optional'>Formal Statement (LaTeX code)</span>
      </td>";
echo "<td width='75%' colspan='6'>
       <TEXTAREA NAME='Description' ROWS='10' COLS='120'>\\begin{geothm}[]

\\end{geothm}</TEXTAREA>
      </td>";
echo "</tr>  ";
echo "<tr>";
echo "<td width='25%' colspan='2'>
       <span class='optional'>Category</span>
      </td>";
echo "<td width='25%' colspan='6'>
       <input type='text' name='Category' size='25' value='Geometry'>
      </td>\n"; 
echo "</tr>";
echo "<tr>\n";
echo "<td width='100%' colspan='8' align='center'>
       <span class='titulo'>Submission Info</span>
      </td>\n";
echo "</tr>\n";
// select a "Contributer" name form a list of user names
echo "<tr>\n";
echo "<td width='37.5%' colspan='3'>
       <span class='optional'>Contributor's Name</span>
      </td>\n";
$sqlUserId = "SELECT userId,username,email
                FROM users
               WHERE type='Contributer'
            ORDER BY username";
$resultadoUserId = mysqli_query($ligacao,$sqlUserId);
echo "<td width='62.5%' colspan='5'><span class='entrada'><SELECT NAME='UserInfo'>";
while ($linhaUserId = mysqli_fetch_assoc($resultadoUserId)){
  $pUserId=trim($linhaUserId['userId']);
  $pUserName=trim($linhaUserId['username']);
  $pEmail=trim($linhaUserId['email']);
  print "<option>$pUserId -- $pUserName -- $pEmail</option>\n"; 
 };
echo "</SELECT>";
echo "</td>";
echo "</tr>";
echo "<tr>";
echo "<td width='37.5%' colspan='3'><span class='opcional'>Bibliographic References (if any)) </span></td>";
// select a bibref form a list of bibrefs
$sql_bibrefId = "SELECT bibrefId
                   FROM bibrefs
               ORDER BY bibrefId";
$resultado_bibrefId = mysqli_query($ligacao,$sql_bibrefId);
echo "<td width='12.5%'><span class='entrada'><SELECT NAME='Bibref'>";
print "<option>noref</option>\n"; 
while ($linha_bibrefId = mysqli_fetch_assoc($resultado_bibrefId)){
  $pBibrefId=trim($linha_bibrefId['bibrefId']);
  if ($pBibrefId!='noref')
    print "<option>$pBibrefId</option>\n"; 
 };
echo "</SELECT></td>";
echo "<td width='25%' colspan='2'>
       Date of Submission
      </td>\n";
echo "<td width='25%' colspan='2'>
       <input type='text' name='DateSubmission' size='25' value=$hoje>
      </td>\n"; 
echo "</tr>";
echo "<tr>";
echo "<td width='100%' colspan='8'>
         &nbsp;
      </td>\n";
echo "</tr>  ";
echo "<tr>";
echo "<td width='100%' colspan='8'>
        <font size=-2>
         If you want to add a Figure, or a Proof, you should choose the update option
        </font>
      </td>\n";
echo "</tr>";
echo "<tr>";
echo "<td width='100%' colspan='8' align='center'>
       <input type='submit' value='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Insert new Theorem &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'>
      </td>\n";
echo "</tr>  ";
echo "</table>";
echo "</form>";
?>

<hr/>

<?php
  require($entradaFILE.'footer.php');
?>
