<?php 
session_start();
/*
 * Geothms/iInsertGeoThm.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

require_once('../servidor.php');
$pTipoUtilizador = $_SESSION['tipoUtilizador'];
if ($pTipoUtilizador=="anonymous" || $pTipoUtilizador=="regular") {// separa por tipo de utilizador
  require($entradaFILE.'headerUsers.php');
  require($entradaFILE.'menuUsers.php');
}
else {
  require($entradaFILE.'headerAdmins.php');
  require($entradaFILE.'menuAdmins.php');
}

// coloca o valor para a pgina de ajuda apropriada
$_SESSION['helpsection']='interaction';

require_once($entradaFILE.'dbLogin.php');

?>

 

<center>
<h3 class="maketitle">Geometric theorems - Insert a New Theorem</h3>
</center>

<hr/>

<?php
// cria uma pesquisa
$sql = "SELECT max(teoId)
          FROM theorems
      ORDER BY teoId";

$resultado = mysqli_query($ligacao,$sql);

$linha = mysqli_fetch_assoc($resultado);
$maxTeoId=trim($linha['max(teoId)']);

// retirar a componente nmerica do identificador
preg_match("GEO([0-9]+)",$maxTeoId,$matches);

// O nmeros mximo para o identificador de "theorems"
$nlinhas = $matches[1];

$nlinhas=$nlinhas+1;

require('formata_num.inc');

// Para colocar o nmeros na forma 00XX, isto  sempre com quatro
// casas decimais e com zeros  esquerda a preencher.
$nlinhas=leading_zero($nlinhas,4);

// Obtm os valores do formulrio.
// A teoId  construda automticamente GEO+n de linhas da tabela + 1
$pTeoId             = 'GEO'.$nlinhas;
$pTeoName           = $_POST['TeoName'];
$pBibRef            = $_POST['Bibref'];
$pCategory          = $_POST['Category'];
$pDateSubmission    = $_POST['DateSubmission'];
$pDescription       = $_POST['Description'];
$pShortDescription  = $_POST['ShortDescription'];

// Como obter de um campo mltipo os valores individuais atravs de exp. reg.
$pUserInfo          = $_POST['UserInfo'];

// verificar a questo do @ na 3a expresso regular

preg_match("([A-Za-z0-9 _.]+) -- ([A-Za-z0-9 _.]+) -- ([A-Za-z0-9 _.]+)",$pUserInfo,$matches);

 $pUserId = $matches[1];
//$pUserName = $matches[2];
//$pUserEmail = $matches[3];


// Verifica se o campos "obrigatrios esto preenchidos
//
// est por fazer !!!
//

// Formata os valores para posterior insero na Tabela
if (!get_magic_quotes_gpc())
  { //    $pNumeroIdentificacao = addslashes($pNumeroIdentificacao);
    $pTeoId            = addslashes($pTeoId);
    $pTeoName          = addslashes($pTeoName);
    $pUserId           = addslashes($pUserId);
    $pBibRef           = addslashes($pBibRef);	 
    $pCategory         = addslashes($pCategory);
    $pDateSubmission   = addslashes($pDateSubmission);
    $pDescription      = addslashes($pDescription);
    $pShortDescription = addslashes($pShortDescription);
  }

// Incio de uma transaco
@ mysqli_query("BEGIN");

$sqlInsertGeoTheorem = 
     "INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('$pTeoId','$pUserId','$pCategory','$pDescription','$pShortDescription','$pTeoName',
        '$pDateSubmission')";

$sqlInsertTheoremBibRef = 
     "INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('$pTeoId','$pBibRef')";

$resultadoInsertGeoTheorem    = mysqli_query($ligacao,$sqlInsertGeoTheorem);
$resultadoInsertTheoremBibRef = mysqli_query($ligacao,$sqlInsertTheoremBibRef);

if ($resultadoInsertGeoTheorem && $resultadoInsertTheoremBibRef) {
  echo 'New Theorem Inserted.'; 
  // Vai encerrar a transaco
  @mysqli_query("COMMIT");
  // Nesta altura no insere mais nada
}
else {
  echo 'Error - Theorem not inserted!';
  // Desfaz tudo
  @ mysqli_query("ROLLBACK");
  // Erro, volta atrs
  echo "<meta http-equiv='refresh' content='2; url=insertUpdateGeoThms.php' />";
  exit;
}

// est tudo bem volta para trs
echo "<meta http-equiv='refresh' content='2; url=insertUpdateGeoThms.php' />";

?>

<hr/>

<p>&nbsp;</p>

<?php
  require($entradaFILE.'footer.php');
?>
