-- MySQL dump 10.11
--
-- Host: localhost    Database: GeoThms
-- ------------------------------------------------------
-- Server version	5.0.51a-3-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES latin1 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `GeoThms`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `GeoThms` /*!40100 DEFAULT CHARACTER SET latin1 */;

USE `GeoThms`;

--
-- Table structure for table `authordrawer`
--

DROP TABLE IF EXISTS `authordrawer`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `authordrawer` (
  `authorId` int(11) NOT NULL default '0',
  `drawerId` int(11) NOT NULL default '0',
  PRIMARY KEY  (`authorId`,`drawerId`),
  KEY `relAthdrwToDrw` (`drawerId`),
  CONSTRAINT `relAthdrwToAth` FOREIGN KEY (`authorId`) REFERENCES `authors` (`authorId`),
  CONSTRAINT `relAthdrwToDrw` FOREIGN KEY (`drawerId`) REFERENCES `drawers` (`drawerId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `authordrawer`
--

LOCK TABLES `authordrawer` WRITE;
/*!40000 ALTER TABLE `authordrawer` DISABLE KEYS */;
INSERT INTO `authordrawer` VALUES (1,2),(2,3);
/*!40000 ALTER TABLE `authordrawer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authorprover`
--

DROP TABLE IF EXISTS `authorprover`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `authorprover` (
  `authorId` int(11) NOT NULL default '0',
  `proverId` int(11) NOT NULL default '0',
  PRIMARY KEY  (`authorId`,`proverId`),
  KEY `relAthPrvtoAth` (`authorId`),
  KEY `relAthPrvtoProv` (`proverId`),
  CONSTRAINT `relAthPrvtoAth` FOREIGN KEY (`authorId`) REFERENCES `authors` (`authorId`),
  CONSTRAINT `relAthPrvtoProv` FOREIGN KEY (`proverId`) REFERENCES `provers` (`proverId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `authorprover`
--

LOCK TABLES `authorprover` WRITE;
/*!40000 ALTER TABLE `authorprover` DISABLE KEYS */;
INSERT INTO `authorprover` VALUES (2,2),(3,2),(3,3),(4,4);
/*!40000 ALTER TABLE `authorprover` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authors`
--

DROP TABLE IF EXISTS `authors`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `authors` (
  `authorId` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `affiliation` text NOT NULL,
  `url` varchar(100) default NULL,
  `email` varchar(50) NOT NULL default '',
  `dateSubmission` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`authorId`,`name`,`email`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `authors`
--

LOCK TABLES `authors` WRITE;
/*!40000 ALTER TABLE `authors` DISABLE KEYS */;
INSERT INTO `authors` VALUES (1,'Christian Obrecht',' ','http://www.eukleides.org/','obrecht@altern.org','2006-02-01'),(2,'Predrag Janicic','Faculty of Mathematics\r\nStudentski trg 16\r\n11000 Belgrade\r\nSERBIA & MONTENEGRO ','http://www.matf.bg.ac.yu/~janicic','janicic@matf.bg.ac.yu','2006-02-01'),(3,'Pedro Quaresma','Department of Mathematics, \r\nSchool of Science and Technology - University of Coimbra\r\n3001-454 Coimbra, Portugal','http://www.mat.uc.pt/~pedro','pedro@mat.uc.pt','2006-04-10'),(4,'Julien Narboux','Institute for Computer Science at the TU Munich (I4), \r\nBoltzmannstrae 3, D-85748 Garching, \r\nGermany.\r\nRoom: 01.11.055','http://www.lix.polytechnique.fr/~jnarboux/area_method.html','JulienNarboux@inria.fr','2006-10-04');
/*!40000 ALTER TABLE `authors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bibfigure`
--

DROP TABLE IF EXISTS `bibfigure`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `bibfigure` (
  `bibrefId` varchar(30) NOT NULL,
  `figureId` int(11) NOT NULL,
  PRIMARY KEY  (`bibrefId`,`figureId`),
  KEY `figures` (`figureId`),
  CONSTRAINT `bibrefs` FOREIGN KEY (`bibrefId`) REFERENCES `bibrefs` (`bibrefId`),
  CONSTRAINT `figures` FOREIGN KEY (`figureId`) REFERENCES `figures` (`figureId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `bibfigure`
--

LOCK TABLES `bibfigure` WRITE;
/*!40000 ALTER TABLE `bibfigure` DISABLE KEYS */;
INSERT INTO `bibfigure` VALUES ('Chou93',1),('Zhang95',2),('Zhang95',8),('Zhang95',11),('Zhang95',12),('Zhang95',13),('Zhang95',14),('Chou93',49),('wikipediaDesarguesTheorem',52),('Chou93',53),('Chou93',54),('Chou93',55),('Chou93',56),('Matsuda04',60),('Coelho86',61),('Coelho86',62),('Chou88',67),('Chou88',68),('Chou88',69),('Chou88',97),('Chou88',99),('Chou88',100);
/*!40000 ALTER TABLE `bibfigure` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bibproofs`
--

DROP TABLE IF EXISTS `bibproofs`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `bibproofs` (
  `bibrefId` varchar(30) NOT NULL,
  `demId` int(11) NOT NULL,
  PRIMARY KEY  (`bibrefId`,`demId`),
  KEY `ch_proofs` (`demId`),
  CONSTRAINT `ch_bibrefs` FOREIGN KEY (`bibrefId`) REFERENCES `bibrefs` (`bibrefId`),
  CONSTRAINT `ch_proofs` FOREIGN KEY (`demId`) REFERENCES `demonstrations` (`demId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `bibproofs`
--

LOCK TABLES `bibproofs` WRITE;
/*!40000 ALTER TABLE `bibproofs` DISABLE KEYS */;
INSERT INTO `bibproofs` VALUES ('Zhang95',7),('Zhang95',19),('Zhang95',20),('Zhang95',21),('Chou93',22),('Chou93',27),('Chou96',28),('Zhang95',29),('Chou96',30),('Chou96',31),('wikipediaDesarguesTheorem',32),('Chou93',33),('Matsuda04',36),('Coelho86',97),('Coelho86',98),('Chou88',99),('Chou88',100);
/*!40000 ALTER TABLE `bibproofs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bibrefs`
--

DROP TABLE IF EXISTS `bibrefs`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `bibrefs` (
  `bibrefId` varchar(30) NOT NULL,
  `bibtexEntry` text NOT NULL,
  PRIMARY KEY  (`bibrefId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `bibrefs`
--

LOCK TABLES `bibrefs` WRITE;
/*!40000 ALTER TABLE `bibrefs` DISABLE KEYS */;
INSERT INTO `bibrefs` VALUES ('Chou85','@PhdThesis{Chou85,\r\nauthor = {Shang-Ching Chou},\r\ntitle = {Proving and discovering geometry theorems using Wu\'s method},\r\nschool = {The University of Texas},\r\nyear = {1985},\r\naddress = {Austin},\r\nmonth = {December}\r\n}\r\n'),('Chou88','@Book{chou88,\r\n  author =       {Shang-Ching Chou},\r\n  title =        {Mechanical Geometry Theorem Proving},\r\n  publisher =    {D.~Reidel Publishing Company},\r\n  year =         {1988}\r\n}\r\n'),('Chou93','@inproceedings{Chou93,\r\n   author    = {Chou, Shang-Ching and Gao, Xiao-Shan and Zhang, Jing-Zhong},\r\n   editor    = {Vardi, Moshe},\r\n   title     = {Automated production of traditional proofs for constructive\r\n       geometry theorems},\r\n   booktitle = {Proceedings of the Eighth Annual IEEE Symposium on Logic in Computer Science {LICS}},\r\n   pages     = {48--56},\r\n   year      = {1993},\r\n   month     = {June},\r\n   publisher = {IEEE Computer Society Press}\r\n}'),('Chou94','@Book{Chou94,\r\n  author =       {Shang-Ching Chou and Xiao-Shan Gao and Jing-Zhong Zhang},\r\n  title =        {Machine Proofs in Geometry},\r\n  publisher =    {World Scientific},\r\n  year =         {1994},\r\n  address =      {Singapore}\r\n}\r\n'),('Chou95a','@article{Chou95a,\r\n   author    = {Chou, Shang-Ching and Gao, Xiao-Shan and Zhang, Jing-Zhong},\r\n   title     = {Automated Production of Traditional Proofs in Solid Geometry},\r\n   journal   = {Journal of Automated Reasoning},\r\n   pages     = {257--291},\r\n   year      = {1995},\r\n   volume    = {14}\r\n}\r\n'),('Chou96','@article{Chou96,\r\n   author    = {Chou, Shang-Ching and Gao, Xiao-Shan and Zhang, Jing-Zhong},\r\n   title     = {Automated Generation of Readable Proofs with Geometric Invariants, {I}. Multiple and Shortest Proof Generation},\r\n   journal   = {Journal of Automated Reasoning},\r\n   pages     = {325-347},\r\n   year      = {1996},\r\n   volume    = {17}\r\n}'),('Chou96a','@article{Chou96a,\r\n   author    = {Chou, Shang-Ching and Gao, Xiao-Shan and Zhang, Jing-Zhong},\r\n   title     = {Automated Generation of Readable Proofs with Geometric Invariants, {II}. Theorem Proving With Full-Angles},\r\n   journal   = {Journal of Automated Reasoning},\r\n   pages     = {349-370},\r\n   year      = {1996},\r\n   volume    = {17}\r\n}'),('Coelho86','@ARTICLE{Coelho86,\r\n  author = {Coelho, H. and Pereira, L. M.},\r\n  title = {Automated reasoning in geometry theorem proving with {P}rolog},\r\n  journal = {Journal of Automated Reasoning},\r\n  year = {1986},\r\n  volume = {2},\r\n  pages = {329--390},\r\n  number = {4},\r\n}'),('Goldstein73','@TECHREPORT{Goldstein73,\r\n  author = {Goldstein, Ira},\r\n  title = {Elementary {G}eometry {T}heorem {P}roving},\r\n  institution = {MIT},\r\n  year = {1973},\r\n  type = {AI Lab memo},\r\n  number = {280},\r\n  month = {April}\r\n}\r\n'),('Janicic06a','@INPROCEEDINGS{Janicic06a,\r\n  author = {Jani{\\v c}i{\\\'c}, Predrag and Quaresma, Pedro},\r\n  title = {System Description: GCLCprover + GeoThms},\r\n  booktitle = {IJCAR 2006},\r\n  year = {2006},\r\n  editor = {Furbach, Ulrich and Shankar, Natarajan},\r\n  number = {4130},\r\n  series = {LNAI},\r\n  pages = {145-150},\r\n  publisher = {Springer-Verlag}\r\n}\r\n'),('Janicic06b','@INPROCEEDINGS{Janicic06b,\r\n  author = {Jani{\\v c}i{\\\' c}, Predrag and Quaresma, Pedro},\r\n  title = {Automatic Verification of Regular Constructions in Dynamic Geometry\r\n	Systems},\r\n  booktitle = {Proceedings of the ADG06},\r\n  year = {2006}\r\n}\r\n'),('Matsuda04','@article{Matsuda04,\r\n	author = {Matsuda, Noboru and Vanlehn, Kurt},\r\n	title = {Gramy: A Geometry Theorem Prover Capable of Construction},\r\n	journal = {Journal of Automated Reasoning},\r\n	year = {2004},\r\n	number = {32},\r\n	pages = {3-33},\r\n\r\n}\r\n'),('Narboux04','@inproceedings{Narboux04,\r\n   author    = {Narboux, Julien},\r\n   title     = {A Decision Procedure for Geometry in Coq},\r\n   booktitle = {Proceedings TPHOLS 2004},\r\n   year      = {2004},\r\n   publisher = {Springer},\r\n   volume    = {3223},\r\n   series    = {Lecture Notes in Computer Science}\r\n}'),('Narboux2006b','@Article{narboux2006b,\r\n  author =       {Julien Narboux},\r\n  title =        {A Graphical User Interface for Formal Proofs in Geometry},\r\n  year =         {2006},\r\n  editor =       {David Aspinall and Christoph Lth},\r\n  journal =         {the Journal of Automated Reasoning special issue on User In\r\nterface for Theorem Proving},\r\n  note =         {to appear},\r\n  url =          {\\url{http://www.lix.polytechnique.fr/Labo/Julien.Narboux/paper\r\ns/JARuitp-narboux.ps.gz}},\r\n}\r\n'),('Narboux2006c','@InProceedings{Narboux2006c,\r\n  author =       {Julien Narboux},\r\n  title =        {Mechanical Theorem Proving in {T}arski\'s geometry},\r\n  booktitle =    {Proceedings of Automatic Deduction in Geometry 06},\r\n  year =         {2006}\r\n}\r\n'),('Nevins74','@TECHREPORT{Nevins74,\r\n  author = {Nevins, Arthur J.},\r\n  title = {Plane Geometry Theorem Proving Using Forward Chaining},\r\n  institution = {MIT},\r\n  year = {1974},\r\n  type = {AI Lab memo},\r\n  number = {303},\r\n  month = {Jan},\r\n  abstract = {A computer program is described which operates on a subset of plane\r\n	geometry. Its performance not only compares favorably with previous\r\n	computer programs, but within its limited problem domain (e.g. no\r\n	curved lines nor introduction of new points), it also invites comparison\r\n	with the best human theorem provers. The program employs a combination\r\n	of forward and backward chaining with the forward component playing\r\n	the more important role. This, together with a deeper use of diagrammatic\r\n	information, allows the program to dispense with the diagram filter\r\n	in contrast with its central role in previous programs. An important\r\n	aspect of human problem solving may be the ability to structure a\r\n	problem space so that forward chaining techniques can be used effectively.}\r\n}'),('noref',''),('Quaresma06b','@TECHREPORT{Quaresma06b,\r\n  author = {Quaresma, Pedro and Janicic, Predrag},\r\n  title = {Framework for Constructive Geometry (Based on the Area Method)},\r\n  institution = {Centre for Informatics and Systems of the University of Coimbra},\r\n  year = {2006},\r\n  number = {2006/001}\r\n}\r\n'),('Quaresma06c','@TECHREPORT{Quaresma06c,\r\n  author = {Quaresma, Pedro and Janicic, Predrag},\r\n  title = {GeoThms - Geometry Framework},\r\n  institution = {Centre for Informatics and Systems of the University of Coimbra},\r\n  year = {2006},\r\n  number = {2006/002}\r\n}'),('Quaresma06d','@ARTICLE{Quaresma06d,\r\n  author = {Quaresma, Pedro and Jani{\\v c}i{\\\'c}, Predrag},\r\n  title = {Integrating Dynamic Geometry Software, Deduction Systems, and Theorem\r\n	Repositories},\r\n  journal = {Lecture Notes in Artificial Inteligence},\r\n  year = {2006},\r\n  volume = {4108},\r\n  pages = {280-294},\r\n  number = {4108},\r\n  address = {Heildelberg},\r\n  booktitle = {MKM 2006},\r\n  editor = {Borwein, J. and Farmer, W.},\r\n  publisher = {Springer-Verlag},\r\n  series = {LNAI}\r\n}'),('Tarski51','@Book{Tarski51,\r\n  author =       {Alfred Tarski},\r\n  title =        {A decision method for elementary algebra and geometry},\r\n  year =         {1951},\r\n  publisher =    {University of California Press}\r\n}\r\n'),('Tarski59','@InProceedings{Tarski59,\r\n  author =       {Alfred Tarski},\r\n  title =        {What is Elementary Geometry?},\r\n  booktitle =    {The axiomatic Method, with special reference to Geometry and P\r\nhysics},\r\n  editor =       {L. Henkin, P. Suppes and A. Tarski},\r\n  publisher =    {North-Holland},\r\n  year =         {1959},\r\n  address =      {Amsterdam},\r\n  pages =        {16--29}\r\n}\r\n'),('wikipediaDesarguesTheorem','@misc{wikipediaDesarguesTheorem,\r\n   title     = {Desargues\' theorem},\r\n   year      = {2006.},\r\n   howpublished = {From Wikipedia, the free encyclopedia},\r\n   note      = {http://en.wikipedia.org/wiki/Desargues%27_theorem}\r\n}\r\n'),('Wu78','@InCollection{Wu78,\r\n  author =       {Wen-Tsn Wu},\r\n  title =        {On the decision problem and the mechanization of theorem proving in elementary geometry},\r\n  booktitle =    {Scientia Sinica},\r\n  volume =       {21},\r\n  pages =        {157--179},\r\n  year =         {1978}\r\n}\r\n'),('Zhang95','@article{Zhang95,\r\n   author    = {Zhang, Jing-Zhong and Chou, Shang-Ching and Gao, Xiao-Shan},\r\n   title     = {Automated production of traditional proofs for theorems in Euclidean geometry\r\n       I. The Hilbert intersection point theorems},\r\n   journal   = {Annals of Mathematics and Artificial Intelligenze},\r\n   pages     = {109-137},\r\n   year      = {1995},\r\n   volume    = {13}\r\n}');
/*!40000 ALTER TABLE `bibrefs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bibtheorem`
--

DROP TABLE IF EXISTS `bibtheorem`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `bibtheorem` (
  `bibrefId` varchar(30) NOT NULL,
  `teoId` varchar(10) NOT NULL,
  PRIMARY KEY  (`bibrefId`,`teoId`),
  KEY `ch_teo` (`teoId`),
  CONSTRAINT `ch_bibrefId` FOREIGN KEY (`bibrefId`) REFERENCES `bibrefs` (`bibrefId`),
  CONSTRAINT `ch_teo` FOREIGN KEY (`teoId`) REFERENCES `theorems` (`teoId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `bibtheorem`
--

LOCK TABLES `bibtheorem` WRITE;
/*!40000 ALTER TABLE `bibtheorem` DISABLE KEYS */;
INSERT INTO `bibtheorem` VALUES ('Chou93','GEO0001'),('Zhang95','GEO0002'),('Chou96','GEO0003'),('Zhang95','GEO0005'),('Chou96','GEO0006'),('Narboux04','GEO0007'),('Chou93','GEO0008'),('Zhang95','GEO0009'),('Zhang95','GEO0010'),('Zhang95','GEO0011'),('Zhang95','GEO0012'),('Chou96','GEO0013'),('Chou96','GEO0014'),('Chou93','GEO0015'),('Chou93','GEO0016'),('Chou93','GEO0017'),('Chou93','GEO0018'),('Chou93','GEO0019'),('Chou93','GEO0020'),('Matsuda04','GEO0022'),('Coelho86','GEO0023'),('Coelho86','GEO0024'),('Chou88','GEO0025'),('Chou88','GEO0026'),('Chou88','GEO0027'),('Chou88','GEO0053'),('Chou88','GEO0055'),('Chou88','GEO0056');
/*!40000 ALTER TABLE `bibtheorem` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `codeTmp`
--

DROP TABLE IF EXISTS `codeTmp`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `codeTmp` (
  `codeTmpId` int(11) NOT NULL auto_increment,
  `code` text NOT NULL,
  `drawerId` int(11) default '0',
  `figure` blob COMMENT 'para guardar a figura em formato jpeg',
  `username` varchar(16) default '',
  `userId` int(11) NOT NULL,
  `name` varchar(20) NOT NULL default 'temporary',
  `proverId` int(11) default NULL,
  `proof` mediumblob COMMENT 'para guardar o ficheiro pdf',
  `proofResults` text COMMENT 'para guardar os resultados da prova como uma tabela HTML',
  PRIMARY KEY  (`codeTmpId`),
  KEY `relCodeTmpDrawer` (`drawerId`),
  KEY `relCodeTmpUsers` (`userId`),
  CONSTRAINT `relCodeTmpDrawer` FOREIGN KEY (`drawerId`) REFERENCES `drawers` (`drawerId`),
  CONSTRAINT `relCodeTmpUsers` FOREIGN KEY (`userId`) REFERENCES `users` (`userId`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=311 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `codeTmp`
--

LOCK TABLES `codeTmp` WRITE;
/*!40000 ALTER TABLE `codeTmp` DISABLE KEYS */;
INSERT INTO `codeTmp` VALUES (86,'point A 10 30\r\n\r\ncmark_b A',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0\0\0\0\0\0\0\0\0\0\0\0	\0\0\0?\0wRGW[]G8vDiKɺ2^[ɪtW\"\0\0#cr<nK\Z=٪~yz;ՔmH+\0dQZ?Up4i4\rrϒ\"VW','vsantos',51,'teste_p',NULL,NULL,NULL),(114,'point A 20 60\r\npoint B 70 60\r\npoint C 60 30\r\n\r\n\r\n\r\ncmark_b A\r\ncmark_b B\r\ncmark_t C\r\n\r\n\r\ndrawsegment A B\r\n\r\ndrawline A C\r\n\r\n%circle O A C\r\n\r\n\r\n%drawdashcircle O\r\n\r\n%distance D A C\r\n\r\nmidpoint C1 A C\r\nmidpoint C2 A C1\r\nmidpoint C3 C1 C\r\n\r\ncmark_t C1\r\ncmark_t C2\r\ncmark_t C3\r\n\r\nline cb C B\r\n\r\ndrawline cb\r\n%drawsegment C B\r\n\r\n\r\nparallel c3b C3 cb\r\nparallel c1b C1 cb\r\nparallel c2b C2 cb\r\n\r\ndrawline c3b\r\ndrawline c1b\r\ndrawline c2b',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0/\0\0\0\0\0\"#!\'&1X$3	\0\0\0?\01c1c	$a IEl0!NA4,8)-kVSgq:++tlyEb)ȫF\0T?js\n*	*rQf1ePw9}8ٌts6M]vgIRX\"įmXvC(VOt9O/gTôlOmӬk8%r^:00A%Ɇ(ÐC2#IsaAMgꐱ{C-oZ-Mwvs,VLslJuc0V:,S8<esf\0	V\'NI.@1c1c2YMK<XZ/͙)^|i޾j\\@S9Wo[ehqmm(KLIiѤBR!	Pi)ֵk<Ja\0Y=ٻ\0g(~AԮM[;_ʥøՍ3Lu/RUc6vojPrӻэ>7_iӥ!,-I@Y$CIXgj$Dbaa~FRH׷BϔCͲ׿5 -/}NoQrmmz`yWUtmfR}=BѢ֒\r41c1c1d7s_[G*ЉV#)__48\ZZ5ܬz1IduV1*\'I1 t[B`,5ƒC u^cT\" vYhZl\'\'P+΋J\0S*\"ST5\0fT\0sF֯m2l:ϭ)qNBZ;\0)2rݨsze\Zo顄5e^}C-M\'dOUBzG׹dÿ\n[@$ZXoIHKq:ۅX1c1c1I10AYt%aB|uHiYi*q\\R[m	R֭\'[ަ!D%sJ\nCF4l/~?2*ҏpHNQBe(Bu%U%{ֵU&1^1@oxf軎\0qm<WH?-K+:V6N]]9;is*c3X<ўS1-=KN#TTq{\\㫐0+&A4n/Ϝ|A0f&kˬ~lHmr׻\r|IoK-ũ[kO\\l>qz~ħvV:V܅\08\"ޓ7xG[Nc1c1cg=7ʃ\0:&=/s	aj`76d{Yz	]r^LsM^uneGeia2-2-\'HmFm	J\'IBuZֵc*df\0//U̡R7=n0~*#[[_V4e1ԿJUd7K\\yA[N7F4E~^_NNoZkL%\rf~e\'ga@NZlBCWkQSA	I#^M#>Q6K^\0lo[cKI;uEɵL@O邮]W^嵙J(FcZKl6x1c1c1?޾y=oB%Z\0\'(ץ~-|ӓ\\ihrǓ%X`^ب>m$ām	\ZIz#iSGW䈃ag,\nUk񲆸gBH:-+TT}OԫuO\ZR8P\0{\Z4SmZɳw>޺Ƶ9h@W8ʦ_ˊv=ui9yyq41?U\n/g^o\0+)n\0>j;=bA%\".TnƗUc1c1cxI$p dQeJ([`qa\nu}!Ye]qIm%KZoz|1ܕ(;ON?)\rӃɳ\\,ȫJ>r!9E\ne	ԕT[Z֥TJx:oŶZB^\"ӟTTl,I[9ut[a̪zAcFxL;O.:&SRZ}%sC\\b9<+>s%٘E.!^d6?;%!.S8oO2U\0=s}\0@ǛqwQX]X#X_rdzOo);c1c1c%_<*\0눘%\0(ْgƚ&{uT	{3Q7yYa2,!m\ZJm%(B%	֒kZֳɌdݛ?VpJk2}Jõ\\\\;mm}X=[Ru+uV1gh=/q!m;OSx	x}:Q:=j\r2Ԕ5rId<!1E~9iI	\r]DIOL&\'e${]4  D;--{ɰQRm.\"$=&1?צ\nGu_WI{e+ܠ-\Z-i-I1\0V \"Fh(8!\Zq0gmIqqm8iHRo=c1c*ʴ\"Uz\0{9mzW9=5Ɩm+y;RY/i]UfLHИ>_\rqWX964u}~H;r%Z(kFqI(43ҹ@5GJH\0T!Á\ro@:ѵyq9s}뭯J\\kS\0\nesewj17^Fha\rcWagI*UPf{Y<\0pB=	=#֮1C$R-\\eNliuV1cJszɥ:ŕ5xۇ^|IY%?Hy̑\r}ypޫ%`[ihU@*N\"W-=;\0>!>EXj-*j<:1(O+ć*Fc1HAȢ\nˤQ.CLIShJi:0b%+PwR\Z1f}H#YV}3Br)B*+޶J1o?R+6?Etla>2E?oBYY֒ArNÙUc)ތ\nvWi]uMz\ZKW\\$Y0ryWq~|+TJ	15_]]ceCkm^w#mRK}_vB\\^qn-Jޟd]\0\"ze\07%=;*ֺF/7	ź=*RwUc1c0aQwX	>e*`\rv{ޫYNz55(~*ջm~	h}n.=	:Ī\Ze$	E5@L|qe)0t3ic1}||>0\"c8?0sfJW\Zjw-P%TAG4[&YdvZvaC,0,tii(mДBt\'ZJukZ&1Ovn\0Y)9q+s2r>p5cLSmKԭXM[1+h=YC$+}\'ޮ<*U\0R\";lV_\"?T$֢$wL2FF|m\0mf	)lƗ{vzkh]Eʺk2Poƴm	c1}JU)\'B[*s̶̔4;qw0}4\\dLAaKÜB\'OA2<zPQmdR9{c3}gİ7=x[(&YWg^j&Dvˏxdc։xbqum*+cJ\0#z54rk\0<h^\0NOCq[}ǣNԖKWUcz~bpE&\\i$2U8_ͥM__\"m+IV\Z~Ru\n\r\"贮qP\rQ>RR+\0->kHpaC[(heN9mjvc%^.Ͻ]|QP>o礨9U1^OF\ZFJI7:43cZ}}4uV1?U\n/g^o\0+)n\0>j;=bA%\".TnƗUc1c2Dn=55Ѽ\r.is4͞712fVNq\'G3..t\n}GX\\S;tꆱ9żtNo`}Ҷ	NTdir+>زR,VZE81I10AYt%aB|uHiYi*q\\R[m	R֭\'[ަ!D%sJ\nCF4l/~?2*ҏpHNQBe(Bu%U%{ֵU&1^1@oxf軎\0qm<WH?-K+:V6N]]9;is*c3|3BThpm>˲ˀAUcV9Kڦ]xY0yNjO I4͎3{+m[4ӏX:U[5J/dݯҶ;ae̿}\ZFd]\0\"ze\07%=;*ֺF/7	ź=*RwUc1c1G[}&F6_=u\'T\rVH}fi-HlsklRV`]]mн^&|sJvX};قIp[`[C\\t\0dM;iʿWX\"\nC61ϯzo\0uLz^nlJMNU=ֺ(zD,Cl0heBZeZNM6%\r!NINkY2U_^8%5?C>rnzaU.G.ƶic:_m˿Pco(9{]/*Cqu$!-\0ߡ\03ZrR̓qZ$$5v%?=0{dXp5tЀ3\0lk0?&MFHe4d[\\[D\0^*-U}]%[Yr_{Ph5hM\'c1c3u.eNO4E5/Wſ\Z{*C?x;;[̾-vEg+!2010x#/5pǻhz>ȡ.?f+:\'gzGK(9\\%\\`s+u&YsWg,L)+R8WZ$3C}aն|J\0\07\0/SD|\0`cN߫{~o%eW|F=ݑeyܮ\na\Z\\+q,4?)ҿ?>M\0_&\0~t{ϓa^~wm\0^kt}[ʮ\'<73%K9P\\<+`KoLy4wNg*4*~UMʄ2V=$7AF(x]}5qn)Ji_&\0~t{ϓ?E:WGgɿ&7@W}P8;PSN林ʐHInxfq~0\0+rH{SD|\0)ҿ?>M\0_&\0\0ό-\\~]oE DiPdz%קL]B/<ZJ&^lDTrGrkN7Ͻyw#[z<ԝ?51ʮ3+\\>VdU䈉dͅIuI\0M1c1gJ萷+:nqf`o>PMaȰ֚\\!8#)P2QxWEjI%\Z$e&hZ%,Bҙ&:/kQ˄N-|t\0q驮G isKylṏA0Κs=8Y%O,Xwt	wsV#:bݢأܯnVT5-&s{lNp #K\\aŒb/z|gA\"7An.\ZNtjUʽ=nnǻ]vVR~^meŜX:]/r\0UJuvkUEKBOmTKrg4kz%byZ[qq!j6n%6Hrn\\c%[ԼbB\n͏w7-!Xxi**~6[ЖVulrvӭUXf\'Gfd)0}#e\0ƭHsjMn>;m<Ra;/>m/ԞA9<<itg.!vVڷtitj^ɻ_lv6\0^˙Z4wϜ3Lz_5΋>.Xiʝ?yڟ-o1_\\u#s\"Ef1!(ft!K<u<7)!{Y/Pu*-+$-y_=6Q4*=c1c1c{#ǕXrWX8br*^H׊E3LT	xF/t-.I\Z\rm\rd6s鞫0TOO=CukϙzM\'L|{ZMv9=6/ttEzw٭_~xߏ.G@9|+d36Ώ	sIԩUmO.Z͹QbCT!&Vr2)4\nެI()c%_0\0\0e곂S^s? W&eR}bkkkƙ:ڗ[ܻ86򃗼/mt?7]@i\ZX5%+ZY[;Qga@NZlBCWkQSA	I#^M#>Q6K^\04W!ƽw\'KY<(K/T.|s+#3M:tP!`!c1c1c/OSչ;ҼV@>DL*BtIN.>l;tDx1ıۊt-{h^v)};CcZ9;\0Nu.sZi}R\"\r`-4wOŋjQ&YWg^j&Dvˏxdc։xbqum*+*\'I1 t[B`,5ƒC u^cT\" vYhZl\'\'P+΋J\0S*\"ST5\0fT\0sF֯m2UG5zJ^,aod{}#C60%W8#O7Uc/z\'ymCtj\']Vz<ҕ=6p\"\ro81c1c1I10AYt%aB|uHiYi*q\\R[m	R֭\'[ަ!D%sJ\nCF4l/~?2*ҏpHNQBe(Bu%U%{ֵU&H^Ǧ75.z晳ۆ=L:j$;f`<ae%1΁XG;ǹz ]2zu8~5em6/+*|\0\\~mͻ\Z{Rݟ[pK\nh6S#p_\r\'f	F^\0*P\r)cAŌfaںX|ot~hJM=c\r9vYp\0y*jԇ6{Tö+&6	Iss3ƙWFrbemwFqJ+fE웵Vl3o칗񵯣HqsӤק{\r`tNe #T3m0x6-̪1c1c1c%_<*\0눘%\0(ْgƚ&{uT	{3Q7yYa2,!m\ZJm%(B%	֒kZֳɌR!><r.IOljpjbHɐ8[ݢk?\ZWM~n\r\\Z;\'awk]ۧ %]v3ۆR11Rd޶ߨyǈ1{m[M\0~\0B9)\\\ndfIc8MXrBU02{$џ\'D@@G+1(Wć`#$6si_\nW;W\Zݾ)Pb\Z%d;c?Y.:a)CNb5Ւ\n|@-\rQ1c1c1?޾y=oB%Z\0\'(ץ~-|ӓ\\ihrǓ%X`^ب>m$ām	\ZIz#iSGW䈃ag,\nUk񲆸g\rj|EO8:EkO0P7XGFwdkٱ\r(ҙIP\Z@QkDKjbmyϷw.3:B50uG:S;Xz\nzdXAOH/5\";eDǼ@21\nDho1C:֕oWoWhq,T|*U{W賑Mά3_u_x<Ud~k\n\05%ߏVE=Yҏ~(ܔ[_@4IƒUc1c1c$!DI(]m)!Teu%Е-juaKrW;1?;l\04cN&rG\"(Yg)R\'RURWmkZRc*~\0Vl~i\nx|dN	QSބ%ndӓm2Jv&/\"M.nW\r:4>tp1eO$i+$4Q*DEH<J]1v\n=YLͩk>L\rlU+tgP\')+ב\ZJ46\0Op٫|OpC7/CdZUƋf5k\nܫ7kYNjK|M<;y^1sӤק{\r`tNe #T3m0x6-̪1c1c1c%_<*\0눘%\0(ْgƚ&{uT	{3Q7yYa2,!m\ZJm%(B%	֒kZֳɌdݛ?VpJk2}Jõ\\\\;mm}X=[Ru+uV1)yJo<5$Juj|z1,5!D%Vzp?:wyPvRwh~}#Ϻۏ\\5<cHU~jc.+oѬ]Ti1\rIXvA*{=hϓ\"  #ȕ+C[\0n94+Pjn^OvlӱΟd嬗0@O\ZD> ]閆ic1c1c{C+R#dV|̉CiI<ϟKoCf<Vˎk!9mCfLHИ>_\rqWX964u}~H;r%Z(kFqI(43ҹ@5GJH\0T!Á\ro@:ѵyqx>\0EvG@\0Wy>9i)${<͌	k5Uz5CU&hUaf fAd`J.@e|Ta)CSR_DJ:޶5>۸(z@ Dg`#mFX	OΝjM\"Ŷuyjz)ziܺ	 BSsz7q?mgi`wz䵚F쮛Pj\r	bup5W`\"LKՂ[:f4#1c1cxI$p dQeJ([`qa\nu}!Ye]qIm%KZoz|9R\\BQY) {P0ͥ\rĭ\'GsBCYtnјJx:oŶZB^\"ӟTTl,I[9ut[a̪;WKN	RɢSaG..\09UZ/j}vvydv^}_9<sy&x68\n]B쭵nN=`Wel(vJm\0½26i\Z2\0He\rQG7&Sc:f~trqk699b`%׋ҩf٦L}mEzf+\'3%o,p%f_iu^y**^|[ ,;AJp23nF\'1c1c2o*!6B8)SZoS1&e#N!l49e8BBm	mҔ!N!:R%:RZSkZֵkZ~|{w\0	MyP\\vaKq\Zgj_Υn2W[r<^W|㊭]vwKk?\0!`֜ieo3$uF1\rIXvA*{=hϓ\"  #ȕ+C[\0n94+sȐҜZF.mZwv:$4ڛ|W6&З&+T#`6ZCqvؾ9Hy%TԻ,>l$G-J-确:\02e&_,]xΑIsO1c1cɩ~)k&\\1-?1\"9{YBJWDsaM+ֻ-9MR`^ب>m$ām	\ZIz#iSGW䈃ag,\nUk񲆸gBH:-+TT}OԫuO\ZR8P\0{\Z4SmZWoWhq,T|*U{W賑Mά3_u_x<Ud~k\n\05%ߏVE=Yҏ~(ܔ[_@4IƒU:\0ϩ]J1DUeNyْgn2F\0pYH9)xsR٘dU\Z&YGoJ-lG7olu~Ox\'9}Vo\0KeB+31V*psSR!DȎq2qº!P6[qc1c3I#9C\"+.QD;SC\r2-%N:Km*Zդ{ʒ|MwHX[چ_1m(m%i<j;PZ\ZλKuM&2U\0K(\r\04/q-e	egZJ˫\'m:eUfaںX|ot~hJM=c\r9vYp\0y*jԇ6{Tö+&6	Iss3ƙWFrbemwFqJ+fE웵Vl3o칗񵯣HqsӤק{\r`tNe #T3m0x6-̪1\'ۏMMto.j9K\\3g\rz>tՓIw:/:ygüˠKcg+&.{rzDtqo0]cd7tv09\Z\\J,t|z1c1cɿԪrsȄ۟=o*CLN*hbJcNoCHQ88OŰ@?G!mm%JP!:JIJIJRkINkZֵkY2U_^8%5?C>rnzaU.G.ƶic:_m˿Pco(9{]/*Cqu$!-\0ߡ\03ZrR̓p6<&c`eI>O\"VbP;GIomҿwB7_5|RzU>4K:ɰwN:A\\tSΆ<k%wZ\Zf4IylG=I1U(YcF\'29[\"w.kWht/Wl_D$g<pj]go?`\\#%\02|NrŖ.gH¹ͧc1cɩ~)k&\\1-?1\"9{YBJWDsaM+ֻ-9MRaBe191=0czXD.q.zZr*lN۫J[VAWy*>UE`\rv(k}\r\Z\0̩6_{یd+8*>j*?YHI&AVFl`K_pFn2Ur5aC\Zoɫ\",GqYJc|-/ \Z$cIz1gNWRLQ:n2SedYیcр#%dRn0 \n^dfY:~F	n҅l\'hv8!<%fI_UEৠ6JU=rQ2#\\|L{#pHf;ëmiV\\c1c$!DI(]m)!Teu%Е-juyIru	FIfwXV$,-C/K665(R-\nug]ӥ㦓Fc6^5Ϣ\r)؎IaV6@9fy/N>,j:Xs>~IvDOXÃi]\\\0r\n\Z!ͪ^50JɆ(ʹGsRyLlpќ؅[jѦzҮ٪Q{&~\0{.emk5c%z>6Ayq8\"z75[`q:\rs*c1$\0q驮G isKylṏA0Κs=8Y%O,Xwt	wsV#:j~#a\Z=hPWwaqmz8YCKV\n-T{)<~c1dU99Bmq!RP1%1`7cxMoFB\'hr q66m(B%BuJu)NZֵkZֵc5yۋ뽹ߍ\0>-Q\'3γʹ:`h͞vNc\'[}3yT1zۗ~ Pr_UnH\r4C[\0wCY\0fp+K+}\'{1m6x\nMbs\r	WF|iDġ_w퀎qω~)_D^nkSvB}hu`t\'O-d鄧\r:5xVJ )L3L5Gc1f#8OA&yf9Pf\\q}UQEne s&cڐD^Zlujѻ|VEa#UX>Kh1-9UKz|+_Lgj6T;-Hc1c&A1l^roڜ(_~SboBF(X(GK.U(S!HbNJCb\'ؗ:u	q=$v2\'>ԟl9Q|O\ZF%$,KO4\0C/+nTսh2UG5zJ^,aod{}#C60%W8#O7Uc*_グ~ca}ՑdzkDvt߁J,%1Ǘ\r`1Uc1c/\ZoNKR/EZmP|LjS02ltDMYh)آBcBٛfc\Zغo_eմ3oǷm#8wKq~AU\07Wx-6	H)!f\ZN&b&Lf	Ð\rKxbyuƜB1	rf!HC!\0!4[c -V%J@;\',[?,bE瞖0_3KJd25!_]?dx>4vb9$[q恙~\"Gdom8/ڴaRIRm\'faںX|ot~hJM=c\r9vYp\0y*jԇ6{Tö+&6	Iss3ƙWFrbemwFqJ+fE웵Vl3o칗񵯣HqsӤק{\r`tNe #T3m0x6-̪1c1c%Ar35%6r\r\'D嗘Vdݓ9G{t)xAm&\Z˺7J=]vF2X5{\Z#p:8q.	\ZbZ5JR&xG1Ϯq@vN=/|pg;,+lKY{Y;\rcTLYhfTS5\"ІB[mBN	N)ִZֵkZֵc&;q}w;%j$yyW\"ugL-Y^{i[Lzo3}*2W[r<^W|㊭]vwKk?\0!`֜ieo3$uF1\rIXvA*{=hϓ\"  #ȕ+C[\0n94+Pjn^OvlӱΟd嬗0@O\ZD> ]閆ic1cb=SDrnGjsV`e\Z5U|Q:_FR:f9EŦY&|\\k];uYs;v3X$µ\0Lɩ-f}(SeC(?Ԇ1d\'W՗k,L>O_v>k[O׫\Z5ۏ~AH{<$YaV0ڐDTu^Tș%d{#Z\Z\'Mm/{bӠ*<5jWӫÒK<f$HX-h\0m^V}ĩ7{ьf\rJl:f9F5\r~^T2E\"DZyhGi9DŤ8O>˗H1GBtkgV7+z52ۣ/9\'!sz!c$B(lc1c1BAꤵ\"^Ue67C&HK+dةy$)<@-7i3B*[O~\0^fc|%\"KB]ͧ','vsantos',51,'Segmento em 4 partes',NULL,NULL,NULL),(115,'point A 20 60\r\npoint B 70 60\r\n\r\ncmark_b A\r\ncmark_b B\r\n\r\ndrawsegment A B\r\n\r\npoint C 60 30\r\n\r\ncmark_t C\r\n\r\ndrawline A C\r\n\r\ncircle O1 A C\r\n\r\ncmark_t O\r\n\r\ndrawcircle O1',3,'','vsantos',51,'Segmento em 4 partes',NULL,NULL,NULL),(116,'point O 40 40\r\npoint A 20 20\r\npoint B 60 60\r\n\r\ncmark_t A\r\ncmark_t O\r\ncmark_t B\r\n\r\ncircle o O A\r\n\r\ndrawcircle o\r\n\r\ndrawsegment A O\r\ndrawsegment O B\r\n\r\ncircle o1 B O\r\n\r\ndrawcircle o1\r\n\r\nintersec2 C D o o1\r\n\r\ncmark_t C\r\ncmark_b D',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0&\0\0\0\0\0	#\0\0\0?\09s9ss)CxkTTRTTTRHdmʆ[@?3tHM\0G*Exm?\'ϵx|pF\'X?.z@U)N,*?]Ts$Kn1am?PE~ƞB#u\\8?BGY.]em\0o25ygJo)>U\0-F)G\'RmZDFYq`&l&ů0?Uqk5dZھK\nl;,1c^ZaCX0\Z1^d>ۊO&Udwiz9]a \0O:[84sEO}l_j<Ȏɧ2K\"ꪐvOB\rzc\0D3^>1sĕ˘o8[N&@yc<h50[F_]EGoE2o?1b>qwZ|wߨz\rR^3knNgעl9\'aNBnu+`!-1M4n6as9s9*6aMktbeW~$A6JjYh>rc,!f}]\'7\rc~{g#п<@Qpa\"Gd0sRk͌Sdԍk*\Z4x2*,1c0@#l ,%)=s:r|[Z]Us$mcGU/RxE\",tl|X;];D#\'?D+?,9<frVG,\0Gimxo,eё<Mb1bH9BDPζJ[O2JK:ڔۈRVz|79s9s+fwm+*w*f;:ޗ28ɀIh;BX%q2-^mN~ے%ZzüRRdX,kk\r#qn7t)v+4.s9V8n%HZ^z!iWIR}\'==|z\'n+*FnB,	Q\n	`}1	i*&>6x2ńvzfmr|MJJVKy݄M:\Z͆K0K	\ZȲPPb\rarv>F\nv::b89s:;,=16;hG\0[eYal1Dd=q=\0|mZ\"S &\"/:ˠ2ҙIʩu9Sib+!PdX\0FO_!0I[HARqD09s9Ό4\n\0}B7QH_B+ vףe{mGE*\00kC<7KR}6XnpK`[ l\\dCKƔ߾HQhd7xwqy}s9t.?GRTls/Qrtz\\d\\?#fl>)r:$دRΣ&wǯ-H%m)p9$\rhۧ\"jzI6蓵lGH\'lqF\\6\0`Ǵ C<9s9tWV\rvdP\ZC@|EfW4Jogܜal&ۋm޳7QTqn\r	B\":6EK9s9*^ŠhTΨ܇fS6\'MZlzc5MiqZş,3Me\Z$GUs9s;0ٲm2擒lD\r=xӲҭ@l[T|RgHhXy,Q<6W>vu<nEFo,ګ\0MN!Ͽ,BfiJw=TQ۷9s[=?.9˙	pqn4`e80H7eHAkP~TWBEVp1cHH <l`#c1o|)9s9sI6]d)gԴGk1xA:vH̴㘲j\'d\rJިAv9s[Թ-V%D6Z\"iSKFz]q3D@qV\r˝ԟ)P텆-:Ǳ}\0t`@0*0dhV:i9ScLݒdyjW|k}{;75\rdE*H?YX\rPiLi#-D-L?ƺzҖW;|mqkIxyi8;C68QG^x{zS}t[z(u\ZRP_H=-[tL[tz`ޯئ./UHk^`FJ\0g<#?|C]o(8\0|F^9giW\"dk97\"\0\Z n]\ZT\0lU墼pFޠbD>t{=xH\n!z\"d\Z99X2$2>aVYySun!IZz}=\'9s9ҷٞ&	sU~-%Z&@1uY3!CKÕO9t\0Z\'Yk0\Z-	wW40I9\"­yȄ+\'#enEqI.\rl~!СI\0\Zj	~\0di3UԷ#-d}U!Jsj]+:Uh46-J^auq iu o8OZOvco2\0]h1o1_È>=\ZעzՆ,+k:8>ނ\n*`v9(RtrF!>94T̼ڔۭ8!)HZ}OGPTT>rq\0LrWΓ)q^<D4uGZK&tƽ!9dGGңxvx<[x<«ӶSZYLR5\'F_~o=3JRO#:0}euPm*Zֵx\'T|}d:C깽HRlq5K5\n<[9e|p$〰axs;+N\Z4r)]D(IXI_)(R\0})ZUNĩ>uؽG}Gc9}{@-\0nд8_IO{:1\0/9ĎΏzdYߙBb*mcg<ؐ,u|a\0G:d\\\\NG$ᝑ\\2نRKn1hWmȱ\0\\>ۭG`h@JL#eIs8ဃj:**,-S/j-C\'\0>JRO[^} Re\\Jíc(Fjs;ht6-Gj|Dj1p><ǥFJYBJ)0!џc:\\\n*sD+04?&phؑlo<KhT_ɚ^Zɰߊ~|mlƒ.\'d\'yKY*sհhiU9st~\Zx~1KXq!\r\0V$`a$pVBSLLCHKG]} qy+iog!*H,XFc$3~&zMbYw3\n_!#u:H0U|0aߞHOq-}qn+3|^eO]\0鯵}G=d>`=F;GQ>T9sIlOؑcȎդ#\Z1QpǼ^%+$c:Θ8&8T+¹%c\0*\"ګdK7\0Elnkt|\n>UjJ3UyV,-V\Z2fM]k\Z&sʻS9s+[_Mo-%iE#SB4qC)ET03\ZG5=6QgK;&U_5\ZMyح38%!3g\nѢ[\'P\'a:Ux4,1{<&x0lmf<u(Q^/{}q\0՞jVMC1_\Z\'9Ε~[gKfʹW<u׿g.[x\rM4v_+icUs9&؟#Ǒ!HG\r)==(35b\"x9.JVIbu0p3pLq pWsٵw.r2HH`Z#n[[{]Do<@ab`pPPQV*2v2Jn4	iyX m\0tS)G$w\\eԟd6LJ6\'ͅu<֌~_7%(iR7BbcQ6|ϙL+hRX|9s[AоbBzxf)OLtX^bkn\0u27}EZKm-kZJꔵ^)T}<}<Pf?_$s_ÜS\nտ+nvycJ-x1%܍Ph$k`J53L3Q-AoóBM\\156[\"HP6+?#c/^Xk񺻜9&؟#Ǒ!HG\r)==(35b\"x9.JVIbu0p3pLq pWsٵw.r2HH`Z#n[[{]Do<@ab`pPPQ;	\'0ӳH<xMk<qk	o(1ZuE:{*{>w/Ӂ˯7H!K\r47h]o;hH!\\,CaʧՉ=O1%nN%V\"%\"H_ssN[Yf+7l.:ffޯ&YJSEƮ:\">AteBի0trXRעCm-	<TLp#\0 0|(i>yywng0d\0oج8	-*\ZvV\n3hjŜD.g,uiLbG(\0\n0 3l403IdaE!iiJP<9Βz!-߽N H}TsIf)YC;9i+NsIlOؑcȎդ#\Z1QpǼ^%+$c:Θ8&8T+¹lڻWW$IZV[^-ܽ.\"JzI7 0\00U8(((IpkTiZ{Mf-{r%}/Y[ q5Jsɘ|{S7u9ss\0G3y\\\"ӺcM6cJkb5{C]I6[u;J05*>+2\Zw}\'K)iֳrZnR}^㥸w9sE	lYb$9Q62fd\'㥢}+d$@$)yƜJ|xVVz.%^fNvNW3=2C]a\04?HQd3%{u\09&؟#Ǒ!HG\r)==(35b\"x9.JVIbu0p3pLq pWsٵw.r2HH`Z#n[[{]Do<@ab`pPPQ9tH󷲶w3ܪ\nP-J\rnG\"7Aڄr--e Vs|Z$͚-]HNKtL4,@HJKJHBi˯<BT>}=Qo,\0ZQ2ejX%n?Lby ;\rKStQQU0rqf(5?9$Ǟ	Mȿ0\n+B2l=\'Ks\\68Eҫ~>FK]~{Dl\';|`#F7PlH(ch؊*V2v26nH	i0yX,	(q\0hG$w[yү}4&<\rZB8iIA{qrRK3郁˂cK\\+6ͫuup0+*BD`%u\".\"$ yM^S9s}=Iq-#bjmz׏-i?Gw\r,CkuF덣gzs\0LJ	*t-h@`Ju$I|R\0=WG|:4ڟ\0 !<l\rQl_=kSn^1\0U\Z86JH\0&r~Hğ~lgIhdD\n1yPZm<stVf9	CVФ2S8.r:\'̤@DH>N1R\'Z\\L8KebJ?w\ZL[8uFu]o2~]dy\0e.o&{ΰF!qؽ^m]˫\\R$-V-ۯVn^plq%=$xXbjx*fs:Vh\\@\\by ѝT܅\r&G,`㐇O!1e(U<O\'E7㡮_DiȷQe%p@xlzt.G\"Tlsh7jIɀ)(5%nIKhv7PU08!xkf>JWhacHtOy,k\'4<cOfFI1Z<,\0-is9ЯopzÙq]c:l6JYHy!+CrzLKw\Z$ik42Ыs<\02Kf٢\nOxg>\\<NL&QAzTMg\"M,f9s-|Nz>YRT&,- 169bhCC&>  aNO9Rsz\Z`(55=[.T`p\rhձ%q#dEv-!+d:*NU#JLpݛjNEv\0>̃Ξ\Z[\\E\0Y#QXX.6Vul9c\Z\0$e\'d9\0EӻíBơk\0\07\0٧=y\n#򸺟9Δ+qW<*0ݤeo7P}|Gwj~>\'%R`I~<kYǱv#NMB3Vl[uw73*߯2;Gc#ČW#!*PQY !@(\0pφhF0\"!-)E(gHVa-ZZq*BጧPRtSŊ.NB%1^mG\\`SْWmA\0޳ktQK8DgepYp`WM\\9wK*.=o8lR*`l{gX&\ZrDԔVɧ65j]w| a|i<|nRcv4slK9Ǒ1`%2cdH.f@àL<$Rvzz\n)cD+`\'5==\"D,Dhm%%$Ee\nt}m*q=RN|܇ʍ\nK\r~fKw,ܿ!ۄ|NǇg5Ew}1f=\r#XjNFj\'\0C|Zd\\h\ZMb֫ݤ$O\0(@Uf:\ZH+Vs\\EToGEqg?BU9D5=\ZDIDtz٥\0Z,]qU\\9Δ+qW<*0ݤeo7P}|Gwj~>\'%R`I~<kYǱv#NMB3Vl[uw73*߯2;Gc#ČW#!*PQ9汀__j?f 4:ܴT.Q\r7&RKiEn<H6i^̭\0GjoKNav\ri<Hd1n9adrL_Ho4|V\\}\nrdvJ3*)fJ\raڞ	kA>̨Ƽez:(~iG;1htm!!/Q-Tmu~B@f%n;O˞\'rI8G x-AFmOI$<22έ\r)OsUϯ7߫1zwzVՠZQJw\\\\	{@riݜƟQ,sAw4o,ED2?k<8뭮b;ŬsXHy䤼\03/Û%m//1GF/@*?-(^$zxd:Bp} Ǘ>zR:j.sIOP~cG5]&Fҁ3kCjYMxz6EYR*\"T:?5as);\rV⯞>xTaIo23H3\nw	}NK$.?=<&y	?>ֳcFA2f3u&o\Z-gUa_*dwgǅGG\\FBUa 5>s;,zD-f&,Hd0r&! Ҕ%<\Z_Ƹ%y?Pq\0#4<ց QBznB}\0_q=*P||Iec\\aa8 1{ȥ~9.!GamH!Lރ_,<0uW\0Oy\naơ\01O$F߉Ǟϙbkow\0|BnV0b4(c07r*\"FWÔqRmYH߭seV`.˕ݳR&KfSuh1DŒ<C,tĬO&Q[>-\n_<\ZY	eFWHr(F,PɫT\0Ŗ4өҦJDj҆$ྫn:Sv_<|vceAf}gאC%IH]$~zyL~}gǩ؍95\ndYgYm)L4[ό~XTg/2\\AAFj|9s|+MIخv`*){=vE_\"VfX翏qaN\06Z\0OHTУ۠El)Z<,l]*Bll$TlQrpx\0=9s:7:^/бKvoJm\"\' _o=\n)U+DH<\0ZMds=aU\n7i60[Tfi7}y]!ڟϴ9rT$@G租!\'qzӓP&L՛&unELʬ7L}`H#+J$fs9sU~\'爿w/ɫi_KKfȾy[a]udCʡd)U_#9s|kr^Z5L,r0#\'@͂d<$!͎(-F}]By!¾yϔ\',333UOOHzK@/MM|ݰT˫kjdLmZ{X?}-HS]5)\\3mVꕦ}9a\0b\"\08elScFA2f3u&o\Z-gUa_*dwgǅGG\\FBUa 5>s9s;ua03\Z%9FFfYRO>\"dPflU22:+F\nQR%H.YGl*J[HqE~~,:c	\n#u,4@\Z9s9(_Iּ4cf4``\n܈5h6jTVnBlYP\rh,I0x¾Lf7䭼.W]&G\0FK[MpenqcqT|JҴ=\n^дfu;s9s>ly>o@0%HCn7&,Dؼc\0\ne\\<Uu˾\'N8.ثuh?F4Ot9AZ`:$n\"~hV Bfl6e\\.6s9s´L摬Ӧ\Z-pMJ-Hğ/K\'JFHҐv9Aa\rV&Vt+>|J`C:^[w6+:R=5憸\ZIӪwl^&i`B^Y>= 1 (9ss<B<\00L}ASĔQ/)0nCM48⒄󻦅;7HJۑDV|&᥾>@E	/_Z:\0Jצ2̋1(Rno8yL֑F\0a ^@! AP6-^[Uc ys9sMKyzusEcGdȸ&f4<M.Ւ>*2:KCجՈ_n`MG\0+\"Y7\r&\00`WLgИ5GpA%΃bI3Lu<qrHu)ݤna\Z$ʒ4]&gF2g+$>$I2<q.9؆\r\0ujlUƬ,9V:6,b+ei3\Z%]w0\rfEՎ\0O6%IPe\0#Y?!.MzDOIEK)ک_xTlp#/\0^}=|6T[LFO·\"^1Pa6Wh`wk.qʇF9s9s9vZn%WWu\0Rbev\nX_ZJ\"Pr۟o\0_2ÐxөOԚ<f`Lќ6$V\0]})>>7DFجIcd)Dҗ\'oadލi[7z\0=bzTnl YF!v]Nq#EיL2_RRcRUe|Q̳sѵh&׋n_@}M%[6{M>ڄeđ/k\0;?!D҅y\\a0wE-ˉT)C^ xZS<έj[R9s9s','vsantos',51,'Circunferncia em 3 ',NULL,NULL,NULL),(119,'point O 40 40\r\npoint A 20 20\r\npoint B 60 60\r\n\r\ncmark_t A\r\ncmark_t O\r\ncmark_t B\r\n\r\ncircle o O A\r\n\r\ndrawcircle o\r\n\r\ndrawsegment A O\r\ndrawsegment O B\r\n\r\n%midpoint O_1 O B\r\n%midpoint O_2 O A\r\n\r\n%cmark_b O_1\r\n%cmark_b O_2\r\n\r\n%circle o_1 A O_1\r\n%circle o_2 B O_2\r\n\r\n%drawdashcircle o_1\r\n%drawdashcircle o_2\r\n\r\n%intersec2 C D o_1 o_2\r\n\r\n%cmark_t C\r\n%cmark_t D\r\n\r\n%line cd C D\r\n\r\n%drawline cd\r\n\r\ncircle o_3 B O\r\n\r\ndrawdashcircle o_3\r\n\r\nintersec2 E F o_3 o\r\n\r\ncmark_t E\r\ncmark_t F\r\n\r\n%line ef E F\r\n\r\n%drawline ef\r\n\r\ncircle o_4 A O\r\n\r\ndrawdashcircle o_4\r\n\r\nintersec2 G H o_4 o\r\n\r\ncmark_t G\r\ncmark_t H\r\n\r\n%line gh G H\r\n%drawline gh',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0\'\0\0\0\0\0\0	\"#\'\0\0\0?\01c1cȃΘo*CzwL9s~krvU7QL\\,{Z%s\rIݴ[VyZH:B.?y=mӨRyeA%yFwp)Z4MNڱl#vhx(4] *X+\'P˗J3,0I>vHE~x҇e+Mc,2L{LurS$dI˒J[^h\"z|IH{Ռm-UfSiCqHXI Mu\nZҞvT P>q25>7A;yGYLj.SȶbM9{e\'jА/Fg_atlWhO!/ݸIm/_fT_RTo>C\0_*7ѫxWֹ\ZݱZx((%EboW\0[-Sa.M{T}f-Jҡjc6n+Ղ%\"ghRQo<kՌc1c1ctFk59GuRٺ\r5X5 E:}C[uNT%֤\na7Z/Viԉ:sĳk\'Qk$^nڎi^+=Z-$W\\IC(vG<i.P/Qe]L{BTHd;ɴĽ:\\{KmGo{1c7<7Y.YӫUN*/\0u,+:\0aY̰;F͂$.zw*B/L-^v	@\0,5[֎:\':\np\"by5QBcO;UU{q-dCpYVi8_`?PtZTԐZƫLmeJR\"Y\"}=ﱌc1c15cx\0?y,k\06Gȕnj+I\"uT\'~mgc&lU\nřE\nH`f=uwnzD]^D{&ߕ٨#Y3rԥҩS[C_L~c1euQ\\lkmqx<\nj;aEd.b\"T\'mkU2zj;\ZnG`\\\"Xbh`!Ԟ\ZEZDZRLAc8\\s0H-[\r\'1c1c	]zzRjܭXWW_(B&le\0͵UUGG:mIonl|S\0ϓq\rY^18m{dl1c?}wczqΗǼ8C%c1c@VD\'GiU&.*3DV]UDɻ)4\"Yc\ZY+oJ=\0c;yJKFj}9FRK0@SF+OJSTAcX5FEVƭj^l(PXTNa\nxtqc1c޸_ۆJ}\'w+l={27Q<%8siGkWJ<=\rHOgrVe5>JүIҒt4TɚzjK\ZrB#c1c1ս3zU)c>K\rv@uWtbQ;11Y:.c!^ҕ{5,61c1c+ji:qsPB^\0,VtȺ#4U>8ܾ}wO.ݪN-#׬1c1c&KlGi$3G	$6E0&ɾ,,G./ Ubly{bmӚ~Q&GUF00V:ހEkI/N1c3o{Vy1V	-٬8>etB=Z7Iۭ6{Ē[^nL~5oSnw#s5o}tz]L<~nr~~V\r\Zt̤o.1c1cWmMOP;v誠o^U3i^el\\w\\Fa9OSeX#[c1d>t֒t9g::Xdæ\\5f9\n3mQTU1ysյ>$\'=+ԃޮO^Z^?]GERBUF#VozzAu.+v1ב}ab\\0>{✦hf85R\'Qe*6|fRMJvO/,4ݴ7NvW\'fqzysԂ]}ٙߕ#/JeO>^doRU.$%|<xa8}f`mH^1վA7Ar[J\"˸p6Fjc3xXNAqFƚ]6Gz,,tarND#/R, yG#M6=7a!8&q@Ơvnٟfz\r{xvsyQ-(c)]=*-57ɭZ\'é\0Pldq\r\"wo61c2=]疎wa]Z8?Xh\n,BYiuuO\'\\omyo6*_R cApD>ƍF9~b?=f]|m1d9;nC?]}a:|ZՖJ3\'_|# uU5\"ww;Q\\*fVmu5OQ A<x9+|>y}Guzm<Ryeϑ ZO_xJx>zKJ#}?Y~j!)Qιe{\0uHf}IHQ*JXhF 6(2{?2>NgN!1b\0ctm\'t6yukWǇAQzF\\]:mܽwU9Z=_RdOc.@ӂ]^ZN0zW<=JLay\\n:ks+Wj!E|7s%	Y^ԃ}]SIިX(i}#hc1מ}O	@ǎ4*\Z)[d[A\\_]MdBj	$,cUۭFpOGfkNǠcǗ]}sbV3;Ƹiʢ\n`l{CZ%k8skS?]vޅ؃\0	zTDu.uPZ(ȫ50e92lߧSN1s₢*yq\ZH̻Z1<++˒j>\'gc3z%#Օ:r©;}$x\0;G@3\0`\'\'bawjfDs7*Kj8V6\nv~k\Z6ܖFe	:(v(+/w*-B?t~MI\ZHw;1Nˬߝ\0h]vsYv0/\0@_Muޢ{d^=[1c|Я0`\ZOY\\5{U(k$͹1rYUWHk\0&ف Jubaq\0cʩzm/>}`\0Ȓ\rۢ\ZXR+ej]`.H[!ڝ֏n̜y7򚠔h$\n\Z64,\rra|ė;MIkacw\ZI4XBmwyMmpOPH	.Oμif\0<ov\r}xMX1c!ȧIM\rװa3zU+s$Am|6seZeqU??@\ro\Zut}ϴUD$wtû_Q\niRn=ks[q=+\\;L}$oْV۫Wl\n׼@%xL@,\r^)&4n1gw4C.l<oe,_Or~\0YaY?b]w*cwygthyoEOfU\0a_]->`#tCzX8O&S\Z\0g.\r p=ߢ1ؚ0kU+JWTȺ0S*Sm\"=4>WA\Z\\ϦEo<qOpMS?2SyEѾ~`tqN.$_S1c\r>E<ԚJhn	ҩ[  \02k-We4?lC,Ӎ-eRsyg,w3]z]`tn8>x:jhAUh5X4\Z-K\ngq$.uw<;mb<^z\n,];,iAIh^1c/T\0wwE(گ6T*Od:bpQI5ƣcSj˿\\;eG\\8\'h-KxN$72_#\nY~a\\q.)&1d.}y˵{:3dur&ŬHczO!z[.\\Q{jЏ!uhcC}OO!5&afVH|m\0UYM4KYT,t~Y烹n^u600OhZlUZ\rV#ME¯Y{u+#^nklX7J5|]fE2ΠSo^/4+r*_b\"5g)?_m|\0ѝtpW1[*sh\0gOMJ`͘4f	~/vy`\'?fcu))hE#\\kN\Z2)Ԭ\ZSXh`\rz1f\\Ќ <{Y9mx1C\0gpARYɶ ImMrwRrXl;\"4#=RHfLcԿp OV!{L|wʿsCdZmVV-s;j%rkOuB?nQwP9MF\"s~%	h{Ȗrjh6`ّs&DyĒYO$c\nw\rNM Ѻ\'8u\",E&⥭9n\rШ>[7\0p(DQIqSUV-v8\060v\Z`<eiI0\0pDPf,<Ǿ{c!ȧIM\rװa3zU+s$Am|6seZeqU??@o,ܷnkKј\'B4XZ6*EiaW,=deL(=?֫~^|>ƐLhG-7*]dx1B&tu~&BčوRݹ7i.4VcEV܃@O4n[af~锾fwv<$*5.v=$/IM}m~ɹA047/@ج\0f.g64nqn}!]Y%[kz,+2٧kJ~upPse{{f\07s+Dܶ\0Cu`H%z9ki٣l̟D5K\'`܅X_5XiBZw}6*k&>擉VּaQ7~{W.XMVR=\0T_<ĂxxKI&Jz,\ZNmŊ$ޗڪ.\\k0SGs.oZiKŖ\'-Ċ8\"i\03+	g\Z=ҭK[XאxoKiZXeUfСW>v+w-Bۈ*6n\r.i\"z53˗9LNB\"fWN]AƤ{ؖș\0eXE[_nSRՑ<+tݵ%uE#*Ӟ\r>E<ԚJhn	ҩ[  \02k-We4?lC,Ӎ-eRsyg,w3]z]`tn8>x:jhAUh5X4\Z-K\ngq$cUpxCw54a0<Y;uV\\2MF0r)ýhH\"9=&xwXf]|9bOvHmw}6]͵=1}?Waՙ\\TOy`nTVi==mkC%,7EMNeKc1%M&{!a}m`1zodCC\0wi k\ZệOON{SVjU+c14Zku\nuNtEZw9ZR̛ㅾ.;xڣsZjNٵ}OKս-wI$m7.,fIfDo_ A}sqe.\0JQE֟GU	4#2nK,3ٗL1-V(1$9PC(\nLQ9#ϦN9KMmr&G&mq\"86x}z w7o}лa5WXu*Ԗs\Zpx)t}if_x6yq&]{?6Ju]Pҧg*!<iSԏW]hHeZHԕ Ādq7͌\ZqCs^xB	SdSMIn*\0 6_@9yVSC`28U*@7r[s5ץf\rF烡\Z,VfVUAA4ynJ1bTAZ2WSA6,BatrGHf=HM}+o\raZ<ЩwowǮImm6]ߏow_wc6yzV]$!(Hƺ^ضO\rt\nh<JzaUY\\CO!USV*U+\nQHVF8K/p\r4aM5!sb̚Ū<Zl)7.O˸* DKBs0>uV5Q	,?\rPoͭ,>QmiTWwҴ$ġJ0q	YNK2Ujh~\\ufK1ͭD&ˆ&2	2\"_UtƲ7>8jۍ$%uݡO0Jᇆ1c4~hj}#֗ګ,%\0;6KI\na[W;Z	l# \n9QyI߱>jP9tu~ӓ\0Yq\'o\"?q E=}Ӌz^^Q\\C#ښ׎-ݦ.^(r䋐Qw11;ݪ\\~Mj`ӟc\0w<WG&^X?<vfq}t#EլЃbj\Zh4Z(&x\"8ۭI_1eVt2 ־r=?>Z= xr\"-M7&,Ƒjqүj|+Z,m6du&ІFc`\\^*eє埑-xoVG.\"]zSY.`iɚ<iix5v;oЫe嬛Jx7yPbZ4Lج1m1oKn,/0htII)_k̮C*ϳ|2%D>o}<DlƝ,+	٧A1c\\pcGbrt?FEd! \nxqzˀ$&L\Z2e:\n5	_9p\Z7cwCݸ\r<GiՊ6<GAݐ^o$,:OoX\"tRNMJ\Z.x%tљp\ZAK8l0xK&bƚ)H{c1kcn6FW\0dh9pxn[vԦ%ءFԅ_֛)zH4hT6\\d9;]oR?_n@P4Ci¤2Zt	,2-kJl yf=N\nkiClxR:b_RQ\nle:9\01cV>oWo!oW(%qI\0>|돴k\0ioV>Aȇb\0翖1}ø1A9b\0#\nJ2pא<A8=eQMKT&\r2	][J\Z{cq=w \\G>\r^\'A,t5KԆ$<眩&TĲ瓷ZlR)-HV,+5,PvJpڨj f	96\0u࣢(;ײɟwuIUu+lo?֗ϧJ\0RibPun:.ͬ]ZTGz+[Vl!#_OdI$OL7Nr~7;T$cB=\rj.Ds΁$y9\06WSrsm%غe}.Q\07A,ԂНlH3ezʇT\0ҷ;௼[w6_@>ޏ`TmFkӟJu=dR]%!o鼒oqǮyikyen[EB_\n(=]Ӿ\r@o^rEшu.֥jSQɜÜtH^Éqct #\r\"ȩĐ@(,ѫU:E!.%\'H1c*$}q_DX)b==XԺ+cZvJ:>i-V1c+phPrX.7C¨R$5ON:YpDR\"IFLWVRF\0A\"x]?h3Cy׺	PKE]R!%O9*I-1,猌;\n\ng7sl\"Ie?Yp\'ȅ(Yl*J啫$dP=u]Et\\ZQЫ w,5 y62ɩ֪xʶ`ɐiX:\0/nwbl(n[+]&UJ65u3aϠ]>3S6xǦ9\rPʧHdn]80tˎu|\\9EW2d5xlvT(^_`=\"Ӑ_+E1D2d%<M߆hM6}3\0޹+;>}\nkh3;A[f:Mr4N\0sӺPS:k*CĿZ~_|ۗ|(.N׸uzNi2\r%/ /thZA Vy0IN*KF^.jK<&\"RE5+2{*,5ظ7MIT0<1<QCC1kzy릚i鯞kyg&1cT\0\Zp>M=}c^CՎfBeg\'ݬRQ7}ac\\pcGbrt?FEd! \nxqzˀ$&L\Z2e:\n5	sz@F}oνמ\0OX\n*%$j?I*y9RLie\'oeohا<cݲ;Z-cz~F1@:9b6+4‰?-̻oK,ү۝uTUz*VdW6F1\'w>y}u6#ˑKՐ԰3tFHهmt!Y.K,H\'TbM	Exy|\0AUP\Z8~\0r/3ThO>E/P_m\\]:ݤP0UK [bkzWqnqTPu;ΥUU١#.?}؏ۆ\"0S1QDDo4zow\05`L꾹eJ0T|*\rTkٖ/OU+h*\roi1c1ZӭJ{W#mY#a£b}F+ Bcxf_5)־synOMрܧ0Y<Ӻ.cVZva+t*r$֤G,c+phPrX.7C¨R$5ON:YpDR\"IFLWVRF\0A\"x]?h3Cy׺	PKE]R!%O9*I-1,c_}dmn햻Ptؘ6kd:T]R:q/\rqRoǴU*牚^T\Zb}1eJiz=}N|LĴ#Oe{%\0@,\"K9}\'l$GStKkc1cP;q{>vW,MO\'ּFETm	7K3|SMז];IW74)14hsHLZ1B@C<[oy\\pcGbrt?FEd! \nxqzˀ$&L\Z2e:\n5	sz@F}oνמ\0OX\n*%$j?I*y9RLie\'oeohا<cE8X=Gݹ\0E+[lA#5dcjp]?	0\no4&-pATQͪ~[kƉwf̤GIn:S7F{\'\Z-6cR>n뢷A5z[vkjf^ӕ	{\"KZc䜯j]U&:^*?-JŋR-\\2T\'PX -Xˁ8!hac=5c1cy\rY:kXٗ~3#9Tm΍~Q\\3\0X2xk,`>[q3Cj\\ˡ/grJ^dɵPk58hl7ŸWϾr4~oC}u8}~QWA)#THbISyʒeKLK,y;{+{E91\0,iC1hgkW;~c2ctʑ(! GaC?ɽ2]>5Pȉ_Άr>duӺS`1-Pȓ%,w;iaAAj?TU2kn@_3O`\\]f]Q7v5P]^0h\\ۜ%jw9NLQ\n 6z;k31c1cu~kX|A}fXoXk	!Xbh$q@@+h\ZHw6ad^4ﯜ?+R*עz~P#z/lvi)k`sv?aϣQgnh\0c1%M|E88w \\n_}U+*Pi\nl:mGʹeg2DeЮOyK=Zн|ET^*\0Bm|z].\"sy7na+A\\\n,\'gθ:bho2)ɐ%ʵbDUJmcs.ycqc1c3W[8ڑVlKI`Ɛ6J(c+٬`$\np8,o1k5.p&EYnL ڍmu\Zt-J_ygh新,>T #V>r\r]j[iBX7$(xfI7_d|cCX</>΍*-;T\Z274[i**O^tսVPTViRG\0{Zoߺbc?DCkT+/[܇-00?jYISQEKtmR\rTwF>Q>O<vbu˕f Edoj l9?\">r<ZV\\L+ Ns||KGCъuiːDVykXU6󿰕hܟN1c1c2?9sޞ;γYZPQvnRzoH^(TOsPt*sΫ]s{\n+M%F\0[^O,Vo ZƐ_j]k(\\\"8*ӌfp(_F~5g~[KS_OFgmmNig8}Ď`!PH\r,sH鬰<mSC4[k$RǶɦ͌gz~c߷wޜ|\08O; EujVyg\'vzD_թ,@U m~M\Z~kO˴FU\\8r#j>YalLZlug;KƮ7(mF\01ZzbV3/_j7\'9ӠX_\no?lw휭v6R-Hh	\'\05J*u,^<b\0hG(aC<QzGc1c1cbL1k `xaqn9A)\ZI\"B@GSEɦm=&\\b5:+3{!ζwp4\"1W\nmGHkB=]vŴ{0-d6Y#l^ft9?L^{\raF \"h4%{)_/\n|s{qIm^;xN(ԏ&@XT/X>ؤ|a ;)Ogv+i}M{VOUNz\"xuDH#Ɯ-h皧2t^%T4YwSlu0Z,Iؘ1c1c1c3iH\"XyXy%MHMv}tv<rpwMo\0E/\rq訹Ւx\Z\Z~cTWzPzlȭazB!,>1c1c1c1c+7b2_:\rӵslYL5N䈦;iPKZ>S%!vVa(!XH=<HMuM4t5<31c1c1c2/]	25֨V.qP9cou>Tc%mFjeOR75,	9<ڏ[E-WUrZ˅M}r!Ƿs/]|g.\nqFRٷD1c1c1c1et+yx!uͫ,+tzMQ5A8RؚU񔭬v6\0<թUՋ1c1c','vsantos',51,'Hexgono',NULL,NULL,NULL),(120,'point O 40 40\r\npoint A 20 20\r\n\r\ncircle o O A\r\n\r\ndrawcircle o\r\n\r\ncmark_b O\r\ncmark_t A\r\n\r\nline oa O A\r\n\r\ndrawline oa\r\n\r\nmidpoint O_1 O A\r\n\r\ncmark_b O_1\r\n\r\ncircle o1 A O_1\r\ndrawdashcircle o1\r\n\r\nset_equal o1 oa\r\n\r\nintersec E oa o1 \r\ncmark_t E',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0\'\0\0\0\0\0\0	\"#\0\0\0?\0\0=n\r\naI7k9.KYv/6.W&t4oSnZX-nx6Zm52̙ݏjz-dc{(ÔWc3j޼󡙦g\\\\ȧU9ZʹM9l4ªWoDDDDDDDDDDDDDDDDEplh0V\nN^ɻYrZ˱yivb3zpBmw\"xl	Fad\"fdð{*1v[(sQ*<l,oIBmeb-SEvث鴚\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"64+m\'{/dݬ-eؼ۴w1\\ѽLq!k`ۑjJY#02yG3T2kaM{л-[Re6J7$s!g6Ĳѩ\"vrlUMb{v\Znr\\^m]Lhަ8[pmȵz%^,ke<#5&^h]-\\sʏ2%msbYr؋hy]c*zm&=n\r\naI7k9.KYv/6.W&t4oSnZX-nx6Zm52̞cLvC/E^4.eԮj9GMp6Yͱ,ylEjvݮܱz6DDDDDDDDDDDDDDDDXݷƃmzE웵%vn+:\Z77-|,7xr-^W6`ffO1&jMl;	c\ZejW5̦BDnp\\,ؖ\\\"5;D^nnX튽^I\"\"\"\"\"\"\"\"\"\"\"\"\"\"\",OnۃcARw\"MK]ͻKsɝ\rn^\rDś`Mb3\'q5C&WE+yQSdcx\"M8.rslK.^[m\Z/7k,v^M\'m[l);ޑ{&g%k.ݥ۹Άc_\r/܋WUͰX&Yb8[heƅlڕG<)Pn&ۜ99%/-Nۖ;bWh۶`Hv䵗bnrgCF1ۆnE*f,X,1DPɭa42UcBQmJ棞Ty(X7m˗[FhWi4DDDDDDDDDDDDDDDEplh0V\nN^ɻYrZ˱yivb3zpBmw\"xl	Fad\"fdð{*1v[(sQ*<l,oIBmeb-SEvث鴚\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"64+m\'{/dݬ-eؼ۴w1\\ѽLq!k`ۑjJY#02yG3T2kaM{л-[Re6J7$s!g6Ĳѩ\"vrlUMꙖB	>Rzӣjg\rV0B 523.\'O$g=ÿ/f6~ín_gL<JkNmuj;;@tF8x;	z7叵u#-1G u)zc?C}|gk\'Cm[/?y:2\0Vk8޿Kɲ\n=lNאY0)+y%D#Lb%J\0\\s1矏:\r_Ar\0P#_gؐ$rC^TϱF}\0~.H{%e\0^0v*g[puxT݉I)47ouw@op@;*4H0/|$	zH?_~=8UoU]y3g.V9OpO)C454?k\r[ֺN[#<&=n\r\naI7k9.KYv/6.W&t4oSnZX-nx6Zm52̞cLvC/E^4.eԮj9GMp6Yͱ,ylEjvݮܱz6DDDDDDDDD\\&вJ>~gHdWY=-v޸ZևYJP!Db+Eߠ0z!oygϦlb;x=vo32rrCr\\ibyۘZܛ&<u7X$!Ji\rWHG2+,GotDDEZUKtBX\\g^mjp/\Z`1}u<5s#7ZXcM\'C\'-AtÌOb+Ebܑㄳ\\c1nyK!fOHaan7_Y1QӹDHẄH+ڄ6~Eg~YSH2\'R=n\r\naI7k9.KYv/6.W&t4oSnZX-nx6Zm52̞cLvC/E^4.eԮj9GMp6Yͱ,ylEjvݮܱz6DDDDDDDDDS濺\0guuMµ)G\rZHu[{\"fPdCDJڌAUϫ_=;\nŲq<G\nZ<8~~͜a5q㛚hoiw{oAL\"\"\"\"ᴌ֋LEh}uۜ.edFwC\'0dZh<erK5uA^Mվb={y:~1뽿b|ǫ4{l^)b:8tEs컽{&W@7Eh.uK+z\"Pd;uc|]*ggZ8[heƅlڕG<)Pn&ۜ99%/-Nۖ;bWhp޶[-.Ek-\n}-m׸S]ճ9|T{f֤!crqOܘfZoR5#hśb>&8,؉Z؃X\r\Z1vx1\0#~o^es~_ܖCW#Uhӏf)\0mM.$kR]r{uo!Ȳ	cy\0pXhp9j%_lX\\\'DDDDDDDDEZ%)Bq}-[m*&P*Tn7y`aG`4:4언\\,SGش=Ew~Hک<б\0̕OKKemVI}f}|EO\"DDDDDEplh0V\nN^ɻYrZ˱yivb3zpBmw\"xl	Fad\"fdð{*1v[(sQ*<l,oIBmeb-SEvثL048\".RPEK8̈7O5m\\u>R~xE`۳͌\r-`NFC\0Rߴ|Jwl\0V	~24s$pRDDDDDDDDE83=\\o,ni-B\"	88\rC\rǐ*ni]TAb{v\Znr\\^m]Lhަ8[pmȵz%^,ke<#5&^h]-\\sʏ2%msbYr؋hy]c*zm&?6\\utivjWs2\'f:kǤ!Jb]hht?[\Z+ZgoDy[?+o/%GVM4F(~|aydcFsVDDDDDDDE	OǱF5=InX\ZD)^Ijnv\\3Ӝ<K+4iIj?a~[V\\\n>Ӷ\nL!\0H<w<\'m[l);ޑ{&g%k.ݥ۹Άc_\r/܋WUͰX&Yb8[heƅlڕG<)Pn&ۜ99%/-Nۖ;bWhJɾ\0~\rxzȅV7>ɚA|bx&es,rDDDDDDDE)wy+lǇ[EI;nrdYga YpFhξlꜢwG ܕDDDDDY	̄ul9\0?h(V\ZXaƒZc-&\rr\\Nf&0ɓ\Z2e˥Igo6v%twڛ%[-R Nev2\0(Σog\0c*TJb7fN\0SߝĨ}B46?)\'h\\t(6XXZ87ڧXoqXo.HIÏgNkt&\rTflalq?F*TDDDDY	̄ul9\0?h(V\ZXaƒZc-&\rr\\Nf&0ɓ\Zrb48>ga#?eʶ}VrK3\ZdZY̱CcpcYц\rKѶDD^ZsةX-\0B YX/y{R~;Ǿ{a Zܾ_*}&mZ^$C③7/_Ӓ#<vn5oW}hDDDDDDE*>WyJC+P2pxă5&dYu\'K֝DDDDY	̄ul9\0?h(V\ZXaƒZc-&\rr\\Nf&0ɓ\Zrb48>ga#?eʶ}VrK3\ZdZY̱CcpcYц\rKѶDDDR2Y;фGi1RwX䩳}\0Bd%یOwHCxB\"\"\"\"\"\"\"QiƲO.q}{ϳty\0bsmߎ4y}3μ\Z=`Dt\"\"\",o<6mJ$,Yb)eȊN*͢iP):+=X1xDy\0ǽ.Qtϡvy_znaM\ZX5}Ss\nlZM^oxXd|\n-.N\"\"\"\")WRK\nX,ʊ[x{ar f3#wz)qy\0\\o}4\0Y>G>}Ugcˍy>9K*Sjëa?Ή\'}}Pq\'m[l);ޑ{&g%k.ݥ۹Άc_\r/܋WUͰX&Y!i۶?HmKv*h3+Ts}79)Q<i2?@lq^-e\nJ1~0|nYisEX!ƈ;l#^N,rO-dwЫt\"\"\"\"9\\Vq\0f~\0!ݾ\nT NqgV\n3\0,Hεd\\g2TDDDDDDE\'UߏB]nFmp0kc˜K*i/HS]-م!r3_tk3[iFS2A찚]._v~\'?+vGԼlDXE+q)`*M\Zv׸o-\\[=\\n.*\\&gM:$?pX;aʏqz\"x]Xݙi\nDWd<;EvZRbر<\r]C2&D̗\0əGْ;qʿX#C1{OkUޭB\Z9D&V\\>/%\\SmQ=ٵP0ǕK8.3۶`Hv䵗bnrgCF1ۆnE*f,X,1DPɭa42UcBQmJ棞Ty(X7m˗[FhWi4DDDDY٣cZδ7f-s\'{N-*c	v?L5,n\0\rƎ6~si#;3ʳL\\\'S\nHے^p2\'\"Sʐߔ미k-kS{:]rSGҮsCBdsŜ>L	M>>S!I\\fPu6햛KHI7}wؾgR鳫\'3at3Yyeuq\ZnnmFg5,`xфDYnՆbaۅ.Z#٪fs#:CȂ89^۸ffᘬڪg#Es.4\'RNv4N\';Hsj%Lpr_pgly$9Md<ڈHջ}8\"fdð{*1v[(sQ*<l,oIBmeb-SEvث鴚\"\"\"\"\"~᛹,ms6z\rMY(;u.L܊ɻO/Ǝ˒1$laڔ:_6׵\"\"\"\"\"\"/Ce?AIn\\<T9FՀFWk痓l!ϋ:q95)ER2~v]NN\0~stJt<2/<J:!K@fh%\Z7mP뺕*TT$x{-vƿ\nkŘY7!|q}*A^3.C1\0dcWpt\":.<v9ƹS%TC~T\09tEplh0V\nN^ɻYrZ˱yivb3zpBmw\"xl	FadBamLZ~ty.Ta/Ѳl2.hc]?n ,`-ڧ\n-\Z=CC3{ZpsM33Gʚ/\'9B:Dt4#	;@\rfr&%*ecjDDDDE$\\J6oݶR}׺oE\0[=Bm0V=7	gnIu1NU\"\"\"\"\"\")_ۥ16Ig2sBLrznM{3ϴ)Q<9RzPl4ydQƬ߸..Ջ/o>f%<Q1cD6q*xEplh0V\nN^ɻYrZ˱yivb3zpBmw\"xl	Fad\"fdð{*1v[(sQ*<l,oIBmeb-SEvثo0ͩ琦\ZX%p\0t\n[96a]/.I7k?nzhV4nMu7wށ\Zv3VvG:M1%iT\'nDDDDE0}\'yseEwf<.n</5=z@p*OE 6~ytp}J@ULR*U`}땱CN%#]}mzya8G57m;c H돔1f?4ɎK&Td8HDGݑzaYCX?^>2xCT1b4C	A}sLa\"y\r8˝wϟ6+Fھr첥HeȪ<.Z%<k@d	n\Zqqbtn\Z+7nb}hky~z^M	T?hXwvMV3HyTk5+G3T2kaM{л-[Re6J7$s!g6Ĳѩ\"vrlUM){(,ɕ{RKCe\",Df#5%|v;%ogs|9pGHrD *4ן28p>[:I.8=֜4uz+B1[%*_ll=>8Z\n?ݻ]s֪|&Da1#zs2~ٱ\\xMk$}&1\0A%S}2 :\"YVCޒ~vi\0|ft`V\nH2`[Q?,N9\0޻zUo뗠!ѻe)G\0pԳ\r/=h5~/6	Uq HfZW\'M)uȥ$y 3AavԈ}m7~,=2\0̗g7:K\0jk#XvY\Z|ODR<7Ϣ4f!WgN17ٓHRýN}YX;i*DDEz\'\ZI\04؉Y,gjTڸxO.vI޶2S\"t72sƳoۼO		q*O\"BZ*8V9a$	jRH%$Uʭ4Y.(敤UJ\"\"\"\"\"\"\",\'1XlۜV>S|˶;\"H(bEthglF$mikЃp,PBG6{m\0YMg+Rߍ,hI-cPA\'fdɍs~^X1b\Zv@ug\00[>9%fS؍2-R,Xs!81hݞQ5>[gΐ>d9.цCM`-p0NmՃa\\+$*;].0Yݵ6ջq¡2b~zx5(tq&[G1-n򪛑\ZwcV=n_lXA*W쵢\nߏC&ȹ)v4R_}yNwϾz]\0nO\Z(W\r\0>٣i69!5F\\\07||}y0cU;fVҫLZG\rNk\0\'vxՁQ]~<\0|쇣c7\"G=#z\n\"\")J4MfMVǑmT!48 ʚǺhE j#҇9>!NI,.P_<\\~ۻn0fHfx!]]s抙 5W1˚VHN{թDDDDDDDE<hVr/=@gY 7HSl$\\\'C%ho_l-,;qyfz\'2=GlZo#?-ZhqcE\ZIk5ʅr	;5c&LkӴ=wH*Y,Ok0\ZijfF2c\rOfF4e.Fۑgd/=݉~(FY;hg`Wl$7A<d),a3/|fb0ַ$6YsLrxotiԷ:}Z+eՙ=OIo5}b$~Xo3:X_٫%tNW#tj(DzT\"YH\"dƅ\Z@\nY2Ib\0у`0NQad˗%؎n<7]y29U`؜F-飼o[CǸRbJnGLsq$F`Vi:Vr\'<x.Nlz.󟦶>|d7	\ZgM6g#,03z}nyrjjnoSNƓ0CB?)#lu石8[%ܢ2˜$@2x:\\ʗ$El8ft?d3^J덼Rlq]7>{ϲUdt4}*TZ]A\r6pF=࢐A+\0uɭMWl,/,\r;N :ϳDrUFdhs,v9k4aFRtmrB{uUm%\Z)\\3&oA\"=I(V_N,6^ MM8Dř\'o>fNm`,k{-XdPy !պ%LxPQ\rsya`w#{f~L]+~Y.+s{ſ`&C	Tsz)8`:_qA\rzTv\\f\\w)hZ0\Zn\\~z%cwY/ѳ}~$3eDaGNaGM9맻cGͷ±e3et\0$_Wݷ\'>$6FW<%zWOy!9X,5[\0Z<]<|wrr2ztr88|8999y9<<<gjs!#ty=G?\0ir3\noƇ4XqI\\W Y2dưB&\"{zs^/Uf<828?O0=`\Z	1-\0fE9Py0>YWkez\0|@a	rHLI}fAltΖnhXa-h~ta\",[E&`s1o2RUb`b`ǵK\rhmyP&\"w6`r~@2amL\Z_R<l~w2Ci(G.Dh_Y	gDDDDDDDDDDDDE\ZH]Fm\0\09i\\j[ōi%v2`*$bc1w/,CNӈq\"3\\gg$=0j{EE\Zd86=>5`є]nE׾m·\\A|JX~{gVbmĻJ\\^?fX瓍d0ۑSh[TCmL䛣̽c\"GXr9:ܫ^flU^6[xfyX\\DX^[	#y$\\aߡYb6%Wy~K=_^6Yj~iP3!/FNBX>Ԛ^<jzт|Y.E/9\nS@\n1۽\\{y鸑Z\\yޝgjs!#ty=G?\0ir3\noƇ4XqI\\W Y2dƹܿ/,\r;N :ϳDrUFdhs,v9k4aFRtmT։{\0ҴA	(;7.&=\Z&SQ','vsantos',51,'Tangente  circunf.',NULL,NULL,NULL),(122,'% Definio dos dois pontos\r\n\r\npoint A 10 10\r\npoint B 90 60\r\n\r\n% Definio da recta\r\n\r\nline ab A B\r\n\r\n% Desenho dos dois pontos\r\ncmark_b A\r\ncmark_b B\r\n\r\n% Desenho da recta\r\ndrawline ab',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0)\0\0\0\0\0\0\0	\"48v\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0臭t缫}Q͓SMx&7.T1M⹆g/ru?L1%;_E\nT)ZΑK˸h3P(QQL΍iR*T\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0.=깛{vwlhl[-NՈ.tusST̫kM~W仮_ʏpچ{jsc:qНgۇ_\ZCw=YK!鱸|;%uc1S^Mëb413\r=խJ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0&<8&LXYvLR]m񣰅:4,8)-kW|={*T?qOa|N2COug-[a,kVҦff83Y2}/`k/DhZl=jl8tc3ЙQd9L:-|rm\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0#9%USZv-<鵓,gVy#u635(%^jA;=݂Tm6z֞e7$Ass\"\rMJPQe?Ƴzgt!\r\riJ\'ġO%(BSJR<)<<<\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0WmslŦӠjhq:VvCQS+n̚,&l؅\"SH\n/}W8ܾbY|?ZZ8Cq\'8M8/z=LOW\ZKU>י =n5חrfXj6\ZIlǏ?Y_K5mEݞYqqb.Ge-\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	U#+oU˨\0h\Z\\ޡc]EL\\{9_{f=>|a-_P\ZW`TwhDcamOJ䈍n,6=}TTwGZȔp\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\00knj}+rY:*=Fspiy\\6;Qey.srSZ.2||W\'}z~eXXm7ƪ\Z؞>.5|J)ϸ֖YO/ScY<O;j%\r-ld ֱ\Zy#0i}?ހ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0Lș2C1bEe2Iu#Ǝ$>,T㮸^\'}N_mv*ʥKsy[2g*-9{,i/ę=kvy,V]+eeSaM̬l5Ⱥ]/{/A&9N(kjrXGE5mKbM2D\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0tQu.gX~;Q]aU;|֗S*¯5q_y7y)ңOC&JtS8(S_ޗW^<WIo\\YpUvm\Zj/]nhyE}QX!mm%JP!>%B|)B<JROyyy@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0rm3f-6SCҶӶ%J^H}[vdYg3f>(ʟ:DxP~S첹΃7-.Ǐ9Ʈmoq~K)zg\"}b\"Znϔ`yt,^2QKf<y]qj,VZˋFv\";)oD\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0aa[Y*!ɰ(!23\'N%mǉ$v~Lmmn!\nWGtW<ܫ}͗Q5-CǬW^L/U:s~_\"3X{|:Z5vV2(-k}ͶQx-ڟ#Xl{4=B(\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0a;M<nVtUvzl>v%Yf\n\\)j墦\\;_Od\0\0**y$Ѫ1wcQwÛWKpNa;x{\'5}Kc]cR9ǻlO3\\md9tȶs}\'̹6[NʢWo֗m9sNA[Y@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0yL_TA3&͘QC=&T/)Ǎ-uhiRP}L;ܬjX?;2̓d!|(TzN%UݍlQŅ]1G|g2\"{tLKΏؘ:,AcaUמdy-ߟK6\\wv=ui!mm|EuϮǫrI򥘪N/tYZ-tI]S+hv;Wr8ysTT9\\`\njO&vVs\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0t\02wݮΩ74c~ڇv,]>ls$EN\\g3~=\"\0R9OzTm\ZmG&+f*[e®QT?\Zz\nNd1\\;!FMn!!Жm)B!	ĥJ|)JS%>yyyx}\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0nwe-E7#DcVVCK7\Z3J%hKyUY,gȍ&He&o>z*>+1/f7{>Ĳ\0?Z:uO?imȍUKyeP?Kϸ=γIMs\r<2ݞuem{gɶ/%\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0/k>~Ewt7:UԺ,^\\G]:xѫyMg\'hIEeBau΢vL\\*~y\"/IiE,?2g\"St4EJ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\02ΩٹyZoc15xuKr;Kj*U6lzj-TV5&HScb>;g{#M|zb_K\\+	[a^7e,}k)LU^[ìi}j׼xO/ScY<O;j%\r-ld ֱ\Zy#0i}?ހ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0<ɑ+J>Th0 ~dٳj4Hq#4ʕ%!񣲅\r4JIwO5c^LyRoeHӟnq|SjtkSOkMpkKӷV8y:,X]egXôt9qo^\nTif}fG͚UeUy>Gg&e>THۀ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\'O)ysI9\'}b&ϙ90nbDT%s?>lW3/+\0YץFayQmf|rbii}ն]*\0J@J\Z5ò\ZhdBBm	mҔ!OB<JP>ySyyy\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0yYkmBQr4Lm5ed4q4V.l_2|`\"dYrk}>kkzZfc}K/u[܈޵[kԿUq>c.1Hs4,l,_>OC-ZVZ1YY|bYi(р\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0tW|L}Q͝K^%ɮ9ySGi\r\Zfr|\rVY|^݄/fX*kR/k[r\".TX/+[{J9(u=WCIZؔ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0,ꝛqkwef3C[?MGT(08z(vSfǦEcRn߭:6#}\r;>Ǧ%°OնcyڻRֲ$_:_ƛ֭{/ogn\\6?fRPOb\r]Mkןb3\r}}\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0̙$FgM1D3JzLR^R\Z;([M!N8>pNTS]5Ǜ&TXߍ9V56A&4fܷ\rG;uaQcVz\0/`l;GC\0`ZlUFVaWdq٥VU\\ǟSy~{fPceK\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0t\02wݮΩ74c~ڇv,]>ls$EN\\g3~=\"\0R9OzTm\ZmG&+f*[e®QT?\Zz\nNd1\\;!FMn!!Жm)B!	ĥJ|)JS%>yyyx}\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0nwe-E7#DcVVCK7\Z3J%hKyUY,gȍ&He\'5wO\\|}\'|nRe2GHw?{jq\n9\0c\ZnQsJW6E>ݽךr~{gj5;;YzKkt	iZA6Y&<t5wz;?#9ۢ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0&MWrov{F>MvO@[tمj+e3i[ɪsSe?̠=ŋU\'\n&A	͗`lHZl9|ukYkh5OMNXQ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0]ԻVLZA&Uv7tH\"?M,\'O]%j%^H>..fŻ%I-2OЎm;7d[8v$Fvw4)f57#[.ɦFKh!5[CWg+|fE-Tx|j,8̰o\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0<&D*|Qf}!ČҞ*TcƎﺴ4HS)(O\'/{j	ğwUfc89Zm c丛۽\neM\ZV8F+Xjzs4q?}d=L@shv-uUVgs\r&CH#;v\\=\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\"?0L,O%QW[f\Z_j4yڼ-06\\xWW_.Sz)wT{(-5_<Ϲ%]75W\0@+q{sѪ\'ex#YZ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0%bZoеx܍(~CYY\r/<h*D.K-!Wg̱\"4,H!\\D8ľE\0h<e\"6V/CO\0KD%=1|\0D?2osNV~63:UOOnyͽw!{\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0D=k_=[=*lmmC95EpNfh~0;>{e滮|\ZJNvVwUjsJ9gwTa,ȩtz%DH:\ZU*\Z*~ֶ\rR}Fڷ4U-ѷYwlܻ(LY-&BBm	mҔ!OB<JP>ySyyy\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0o\0d@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','anonymous',39,'linha',NULL,NULL,NULL),(142,'point O 40 40\r\npoint A 20 20\r\npoint B 60 60\r\n\r\ncmark_t A\r\ncmark_t O\r\ncmark_t B\r\n\r\ncircle o O A\r\n\r\ndrawcircle o\r\n\r\ndrawsegment A O\r\ndrawsegment O B\r\n\r\nmidpoint O_1 O B\r\nmidpoint O_2 O A\r\n\r\ncmark_b O_1\r\ncmark_b O_2\r\n\r\ncircle o_1 A O_1\r\ncircle o_2 B O_2\r\n\r\ndrawdashcircle o_1\r\ndrawdashcircle o_2\r\n\r\nintersec2 C D o_1 o_2\r\n\r\ncmark_t C\r\ncmark_t D\r\n\r\nline cd C D\r\n\r\ndrawline cd\r\n\r\ncircle o_3 B O\r\n\r\ndrawdashcircle o_3\r\n\r\nintersec2 E F o_3 o\r\n\r\ncmark_t E\r\ncmark_t F\r\n\r\nline ef E F\r\n\r\ndrawline ef\r\n\r\ncircle o_4 A O\r\n\r\ndrawdashcircle o_4\r\n\r\nintersec2 G H o_4 o\r\n\r\ncmark_t G\r\ncmark_t H\r\n\r\n%line gh G H\r\n%drawline gh',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0#\0\0\0\0\0\0\0\0\0\0\0\0	\n\0+\0\0\0\0\0	#!1\"$&\0\0\0?\0á|\'kc\nA>\\xF%+c1h&s8ѓO/4z<<==Vyz.@Rm#Oi}=XԊ<I\'t(C^䁶#W\nu]nŞ$͛L!7ΗZ֣u9Zs6\rezTĒ}@\rUBH;c/(u\Z$PR4[U8Fvsa<$t8Mu<<=tbWB#Οʬ˕EX0\rb9C\"]\0Om9q]fS[V28%	jp5vlundXWVAi#-Ơƕ@_>3Q2MuĻ\rK\rUMbM}dyTUWpef@ToydsǨn\0MT2\\t\nhTr`F\r,)II$RǼ{hL~ bby~4jhvNsX<b+_$\n\rOgJ]нyyy\Z,/V@Ga,քiu&ѫUP-ǖk؎yLs9SOڄ	dCZz>6ϑ#uo\Z+t`Q]2Bu@E+[}G\nFPhҺG+Tz(uUA9Rfb>ř>i{Ǳ&,ɼmyyy瞊Nb(ՠYT:_kG4YDrG\\W5Rp_gf@tZUwto44ԾrfŌ/T띒K3	1Y\0q};X&\09k>YaI4HH]M1鶹λku38q}yy簙-\\qU-B)kEl̗K(\nDR@DIk4Xk_\Z*EݩS\'O)&|a2º~c4Yt/~e~E^yy.yN7\Z׺_Z)\rG\Z6ݍMcvD\r +;fI\\xm}Ww%)!*_uJssVs5tZwKEҖ0K~yyyy9e	Mehe:I94m7}s:9Ǫ*jsQܹV8&\"AVo	a.sJym!TBՔÀ\ni*bF|\"5\06BS4M\"*$v\Z)9uM1 1pyy&KW9\\zKPZ[!`9s%A xEG(`9BE,{Ǿ-d V,FwjT1E\"rJI9Lߘ$Vyߙo_Qoy瞁l\nFRsV!!SZ5vm\'@=皆[:ӆ۹g%rlUU4V73گW\'FѮwz7ύ	jh8XSO_@dyyyy瞀r-kIx?]alp=Qf큡F@YLXWzDO_AӧhS֑{tK)L\'.GW}ENcՖT bJKM6]al+ڛOEaJlxAO>a\"i<=j+P\0jKZ+d,.d$\ZYG(R\" Hx\\ѥ@\nŜZhUR.J?(:xW@.II33	 {-\n-=u5$Vy5v}y!_|K*Ih*Bȃf_X	PWK#e_6T:%RO\Z\ZHNVEf7ZEZ\"G:\':U\n:RCm<jbgb&k*r@`tҿEf*_meJVoiuAWdx	q]\n\r@?Q \0eVЎQ95?,T	]6|`C?]\"]5:uB[emyQ8I(Q\'3<%(z?K\"ZhSUVkY\ZaO_Pn&F0CQOhf@F(ㅲi0LĀI216M,kj\n5<K 3D3M𭜷4O_L42,.s$ayK7*VFS9AI؝\"/FZ)xWL_mXva\r	]BkHSZ	y<16KT_F#Yщ[F2`QaBʝ$\\edt֬.n}$v}wos=M3g8ɮo\0wmv6q<=^wr>OSR\nV\"+^t%Ku	7^\'Z`v-QwR\0/8wZM]g)Ě4zKC0cY5Q)13m&o<a2Z7\0&ZR֊˙.:	4*9F0#Q$)c=4ik&?1g<ֿ\Z54UTR9,N1/RLeui\'%.^z|yպukt^>dBjlhzH)q-M)5\"\r؜-_G^D5/nj{+X7ԤӚ\'5H*4\n;GoVKFb4#a<\'BUE1\rqBEK{n4YW-j (KYO^1PhR6/\0=X\\:M+E1mO5^cVV*,ZA$/;r^k>M70+bG\"|\'53\'%&<эqk+yy~|5އ?Rߟ흙u>cEo_\'n=[l7t\rҎ9BȺzgFo\"gDKQ)]U6,LfoǸrQ)j,UKFWlmX3<Vk5ҨS1/}VԴpNU^ڍܧlju$t,uڭyy簙-\\qU-B)kEl̗K(\nDR@DIk4Xk_\Z*EݩS\'O)&|a2º~c4Yt/~e~E^B.ԟt9uC#](|sƙn#^ا8^CF엞yn{PG(}gu,jҞ/IxUn955E\\U:dz>˴r>~8߻z\Zh8nU!M,DR(,;t-~+ubM[<<#\n\0F83B2	hIxHw)M-Mvl5}e˴:|\0˷rN>ѻy=R4eBŷ)]5**ZFldu|\\O^lqxgrt-\rXp./]$R\0` 67\"9\"/<|Ժu./Ĳ.,xd`\0$\Z&w	\n`Owowpfu>S_7\Z-ЪVEM:DJ\"^Zo	[J=/JB2qԶ{vQul\0@g-.|km<I]aL]Jt=j+P\0jKZ+d,.d$\ZYG(R\" Hx\\۵ػ3Kza^<OF|9b?[UcO\\{Cn\rMmZYLbu,5HEM=s!!diJ80Y)e0C3KǮ~y{_AIs.mkUd+5脔\Z^E4zLNєI%V&V\"fxqIl~/vu.r cϰ9PDlP!RkSIZL\0M&<<<W:\0QZ1Y}W=k`exTt扃26ηԉGK5}\"\ZdYUʕ}!R*T\ny]#6\n\\ax9o߮35]zw(rߠt%d5uWVo܁ʼI(#\"K캲	Ү/#\"{[Ӫ\na^k-jY/WYdZH9B<,RigqmvH\\m_/ګgX[xݵC7I3#@MB\nD&][AwWzEQ}vw+-`WMWeMZ^Wa\r1UE?uMS[$ ̪hMK$z,u?72YD(C&μ\\fҹiط+=ܬTlܢZ1XjwT/ Q,55\0~HBN<2<{6G AqTҠ4E{aQZ6\"T5GdxZZrm+J^NëhPk`o<<<=Xn*5ڮw-e(N||b4Rə+PU{a.\"ec,nϩ<B-D޷g\ZhtK<[K\0[+CsK^ĕlUUS\0r[!6L_4Bhךm:ڠjfVc)Y\0VP&g\\~c]R)W7mnc\0,wL*w$	es>syB;w~ygAIXv$P5pЯI\\\0[~61ϼտ\'ժnft+smuHjO}R_YJ&%=CpjE-h㠐S@<\"c0ieHHI\"=msSVc+sk;SEUH*sF\'O)&rc	<Rz񊬷]tfwkd[pR)WoVs^ĖM0[S^¦Jyyyy&Aqhiw8\"ъ!h0Fh$A.=\n˨-!mQҕo}aV:eK\0녫$,\\iu`2\\ҲfO<k*ou{\\E&1-ΫfMhnJ\"-adֲJI=Qr|zYhg/<qUzVFה[iV_;4qOZr(y7X83\Z튑Nھ_Wfkp+?g<nfFW}m( Mƻ+󞷜z8;Ј+[l,PzzYyg4zR\Z.hrF䖪\'Mոn  d簙-\\qU-B)kEl̗K(\nDR@DIk؁Xk_ښ*EݩSǂ1:xW@.II3Lߘ$t/tG?T}ee~ƬQXy;;E}*Wh6w%=t<*|MjWL6K9%m`~kݛ_Bc\0m\"ѬY\rBNHV$Oyyyy瞯\Z>itg \rl_a`SnS$lr: [#ZHŁ=}RDh5=4sN=$j}\rk♄ImƔ\03\\y4I4HH]M1鶹λku38q}y絻:Ъ\Z5漢N=٥xz@!Cɼr&qlTu{5[X\093t24\n iDIn5\\Ϝ{Ўq~ߠg`JrwvAUӐ)I-uMtc$!nN1)<瞍zB\\[s;?J{_I\\{+&u8uӉ\r5( Nw{;}[_S#Iλ_=Wn)Gw`o?xiw\Z\Z_]Y]{4=>/ܽ`Z6l/5C~?7kl#f\\γk\'z	h3욕g\\#Lo✛TPɟˊ\\k0KŀL\r	s)m\nl2]xLJ{i4R@%JjdN9{>;JȀɫ\r`mLPh\'lA#|o3`eTϣF_ (DyRȍLltߪ8kuހK|PJP.2\0i\0q;&鷶0_4[pU.&DUlbc:cS)K:BE[>b{2 i~yyy碮393kȕeIf_Pɯ(qL?b6	duګfSgƾYr6F;jp32b!=q.{m1y缧Y8=\n&I,\n$r|ɬ\'j$1\nlżr\"\"h$ri&49}v6](ʨ\r̞;/nh%etdsHh-7z0ΗCc`Ol7ynN*y(ӭAf\0vi^%f>➵i PoIqg5||`O}rk!g.L@ig.v˾ٍ_!oƝ[L	A4 jir·٭Wq^\rPW^p\0_M\\Tem~XZ1&K	Ew0.:\'F.IYlc0%cNgsfk1a7m֪5ͬVHY+MA5xF!sh-Lo2z;\\`b3.*,KmmRg8sɰtG8CzF~\0Bid}e`8O\"=^C\nZax_5U:Z[jkyr}0vZ4c0F4+K$Yֲc+skSEUH*s]й%$Ϝ&XWPof~+<R̷(<kU/bs ҭW]4!Hc22G\0iqY#G?,tt5@ޛ;\'15E\"rWS2*kW\\n:&g\'u#6ٔue*=;T\ZS<78KWV:n/)`yy)nDQ[6{#[.?EUMf`\'sC\0ǊOW{͜K2N/NėY{wCwc~kχMt<G33g_}#y$X]}ƺiog\Z뮺9l18=\n?\'ˁu`\\h*VPyGia(U;%KͶK1^Vu3hIPGGsЧB\0=+}GZj*\nK:\n_JÁt4hmz1`,iT{dYtAϛv7\Z\ZӪdv{n;UĎPUgQe6lg,X6,;ɟ*g\".T/>\\kCe3+Ԛ^\']G<S||ҏI=}יz}\Zyr/~.aA?SUn@tvp՚4QY\0)\'=]n5Hy/Dk7=^9=2-ǝjd\Z1oW3@ު8ȗ\']0.vUWI(2HCHvAgK\Z6Qӕ%r`ȵb\rSqu.Z\"u&,ay|\r a`h?zW)o5AUʓN{_F4O8}>bN2UWPS\nJ3H_c%=CpjE-h㠐S@<\"c0ieHHI\"=msFc+skSEUH*s]й%$Ϝ&XWPof~+<R̷(<7H^MsEi}9Y\04`#zGm[ =e0^W-n\0fVޯk~]WMWc)̌=z-x}W.ײ&A\'=Mp\n|̭o-\ry1U #{}1GִCWc{^ૈQ[:_՜\0>v\'yy瞂x\0Qv9whKafT~p\'i2J@mP$i[{XxGXќf#Uo{`\0\'Z}X̸@~SFֻ,72\0L#6@\\T}Z+<|a)R-&nw\ZQѬM[-fnnWVEu6*Htz-?zJր|䕘owR~֮| c/o[V-Wg0\0p-ԝF(e\"\"ZuVdoJD$ִ|\0ӘT-4;45DiEX@P|=E.R79}z\0أٖ3*3ev\0G?(:i!ڵ*&&[oB;EodߤZS몊vfCѿZɂbC\\]:5F˥~yh/1wn/vK_t:s\Z|уW3:\r\0B-ҁ^]`; 5k:ɵ%ҋp(HwBú\n{\nSݫ*z6QxRl\n\r/oĺRU66	Vn&+Tu+66Fb`1foBlVRfJd V,FwjT1E\"rJI9Lߘ$Vyߙo_QoySsd䕇6P-E,9Z#Q5X[n[	j57\'w\Zǖ\ri\ZΎHV\\m/aȮjND~=L9\0ʇ\0<<Wn&QzWӰ\ZxeMdRˍ36v\0=s׹lC]?$B1[b|S޽^vhOPOgW\r%rx?Ŷ/srȑ\\u닙9>m&9=o)kihj#z5N9݋Xhd\0\Z~̴]mW)4\nn7{d\rsI$T>.]T_~m-_;? $51\\ݯ>\nf֚xӤP+\n>m,][:Ъ\Z5漢N=٥xz@!Cɼr&qlTu{5[X\093t24\n iDIn5\\Ϝ{Ўq~ߞ(V9U2=+l@XtTJ6,66~)gƌTD)	HY\0y a]O0t9?@Y(˭܋sl$cU\\].t\Z`y1	-VRVѽ|g2\"׺EK`lZS8W/mK*뗯HS꼷-$Ai:瞌PS̔Ul;\0\0\ZKM ӗT80Kk *Y٬#XakLهNY=wX*!00\0T2c00l}>k0!#V\n@\'pϤ)0I$$4{4[mk6\',;)X!TEs>qdvsfFίKrǇ;kKyzrt#/9_x\nHd|:6MMkΘawqǤ-cy\0/VKGUb*e}\n&\n̼Y658t\"25\0;]\0O<SĢ޾ct3|W93	e跩Ɉ#fNCP܈!U\njcX4WYfmޜB\0x-Qd1?7Q]_W,#[/TeqvuTͳRM4Bhךm:ڠjfVc)Y\0VP&g\\~c]R)W7mnc\0,wL*w$	es>syB;w~ݿ-ׇ9uɢ}\\TjLrn䯞U+&/6O]</j^E:}I\rN)jOvZDV\ZØ1[vCe7{OlV\nN|VUn?S>C>pr\0L1VjEw:dP3PhV\'#EaO5>%+{=\0?\0ƒ}4ĕ,E0b(cclH5ʅpvk35dZ/6aӺs~g]c+?&J>HL9G10`̱O52ū)t4硎yխ_Ӑ_pw15LM.\0E~M%]g;ivA.\0s\Z+Vo,3ҺM5\ZwK+˜So5@`²\'jc\0V<B\0:ׯ5̗uV\nӵ`F-Kl\\DtN!	sV#\rz琬A$z\n5;t\r+-m8]^v({I\0]\Z_4ϟ:\ns~\"[GfHC6WqLWk.`Gk j}ᜰ.)(F%<&M,6v;+ձ=ߑPj]\0vhe7X Ϟ/!o̽Cу-[sXPU\0RS%iSd=_G=3fjƝUU[\r\Z^Qm[TY~\0ҼJ}=k \nA9bL8lk*E:j~^=|\0N\Z^]nU$7\Zgzr=Gc`yMNLkm3stV1#*X+rҰ*)e퉯<J$z{̓!sU\rkˋhE0T;	G&iq0uoK\0[L:+|ex9[߹;欔{X-VzfUdsjRr<LهNY=wX*!00\0T2c00l}>k0wyꖚ764?SUst\n\0zJuO.C: ގ\'SXʟ6<Wߥ+t^w[gA^;ث5w_[n_$猁xP̪cE=_Z8IH6G\"ۢkqٚh=E@+G6V!i6.i{xw,2ΜӜQZme]wVD~7-]lzc?{\\\\*T*e\\SŬk+pm3.\n\rpQm&Gmtvxy?X|bE>b>OԨᵗ\\\'hWZ[a>^EKmr[#{ҍk5s)֬u/{@?=4Z<%*{Ǽ\0TΑ<{#^KxҮY|K>Ix!m\0˪]c~oI_U@9vů7o)NМD,dQIAM*}K\'	]j#Mf\n84YޒZTEؙ*t+j4u\nCҐ؇ed13MnȲ\0\r1\n 9ƉePPmJ=p5k^\\Χ7U5E6@&\".oKG!?Kqع^TlwDu?U_Qe3BiI`mtĘiW7mnc\0,wL*w$	es>syB;wtC{*wLtF;6-&bU)a ny-o䖭\ZF}C)JW*6{m\0%iiˉ*X`P%ؐk\n,fk0ȸBw#Ļ-=Ko-||~\\tZs~bqX99fҬPVJ9f?x;\'{=[<dַOP0\\(9WV\"\'Gy${K;Hn13}s(r\n!uM rv$+B~)Gk<<v(tý)bUC\\85^LZ\r~L--yw`ⓩ<&$Giw\'<k:>9(\"ҝzMK;W*_Rj0n)VjQ*ݘ[1SϞ{X0rGɞ(5&qivTi\0i<Z0z:@RЭB2SRt`f(`VxDUWIj֭X7LѲ7c(tfm_gS9.vҥ@0-MV(\ZG꨷<GܣML}cy!SnG2PN|O<y_VJ\0<\ZGRFWť:ʜg\rōy9\nki,Ըּ:A3POAmmqk$^{Nu(+[}mβ{	Ϊ9m\rlU[,6@HL[gY7ƭ>g~Kcw*\0>\\\n\"$u0Ď.dۗm\"2BRq\n	qyl7aQO,õT?⯠nV]:XwP9_>;׻Jq:A߻[P[Vتur`;G4xIx}]z3AO2RYWl_i-7LN\\IR\\(1-v6ă\\Wgf3XaE^3f;0]gu1bds괄|\\ØD|-PS#Y,ZKMޏkYAKEg~ɽs\']Iᷰy@wbnѬai`$\rx˶\'o~^Ck\\>YQj2ǻɬJuE͡*5|eЅr.\r/s+Ei-γbAv։i\0\\++jqX%N<q&L\r\0\npͫUk\'mۡBґ#/|F=޼imHo.w[z\Z}8:{W	am|YTZ	\0ZjCq\\Η\Z]2Zxov^yCiޓ69;w/CKזV+jb7b\Z41\"5lrY7fAlIDǞyT[VזؙW|gJ%yW/]P-s>9W,q7\0c\0	ZDŁ/z\nڥ.ӣ4Rܔ跉t[:+Y*sڗȲ?,foQ*{t&\01k.7lF.}&+=Թ*rDB24ןz6(ࡩ%US\';\r{}+@_<r`ZYz`2,r^\\گ=]*iˮ%(!j?<\\	S`-O<1	dRX\\X˷i{I\rbX	瞃ۗ9Y>;aX^ZRf,F[R#naD\'w\0\0\"pJ\0vZVzG~_DWt_Pcv	ac@K^{\"AбJZm00=BrMG˚tnϠz7Ozq}?{\r2s])9\ZItNL^3f;0]gu1bds괄|\\ØD|-PS#Y,ZKMyp;84WNgXzj99QйFujI-i\nJ%5a$EV9KMRjѠK|#n/*Ckѻ)mIzvk,bQH(V_M!RVӟt=UA&󾌧\ZM~f11#cYKo\n4\'v$Ls4MlDkQm/,v}Ծqwۢ+֩אe5ģ2\rB6f&HkFmEbtY(dUї2+(_niv< {uZa<we q~Z_\ZVU\nm:oE4{MbeZ.o%aExC	~aR`\\6UUQVYά׋S\nsiX##&l8A{iʹBY7^M۠9սcu${_2m@@\"\ZzD*`BX0þ~yRE:ɦc?J}.50c.4[A4x)4\0CY| e<Vm\0\0cV[߇Y`Ȣi6@EcǾg\'B_W/l趤\rN3+q9wL0`!P\nYh=bY<ks?mi>|JڲBlu]R$yx?\rlB\Z1GЎgTq\0^%s^sʾn|\nn10\nw}\\g^WhhiE㸞y瞬9GRMM;5o]9ly:mpU1)u\'B[P/Sd!%7u$,zbŬ@\nŜZhUR.J?(:xW@.II33	 {-\n-WV[jbx\"\Z-bd)0ם	H]1گ=uCUl(Y3%(g9-NetMY0XnwKz:N%~iӔrgn~nCoN%ar WA}tA[-\renHuWB\r*DNy瞮*[ugE5-9rVı;i̡= 8\rYe!ѷ+j+i.+Lyz,YSXp{9cbM\'ٿh[Vh=Y\'95A$yq.DzZKDl*Tkq5zᤱ7r®:}&nvIßg]`Пnɸdƕ^Y伖(ۺ]Qd3ev2HK_Jr;^-^WI8sTrK/E^DeWZyGRda23Gmۗ\0h[X7Ws̮sSF0\\joG+\'c=L0.\"9[@vYaR%G{x5DYGt ˭X0QVk{|:{7zLk38-#V\ns-#vk\rP\0\'Fclxe*	7ؼQ0}Lo-rR_jݵ+J}92ӥ庠? \\me	͂`08>2lUte͎^YƱ*We=~9k	#@\\\09fA}k&?1g<ֿ\Z54UTR9,N1/RLeui\'%.^zf/k5heKj9AákUֹuNfk%҉Sln}:Tu|b6M-)8͞wѝ+ӳ=Ө1`eoԷ:/(M_#&a[/B2: ;MR,)SYda#DJMe`EǢsugUBà\'͈`NԻRIjh1ZC^)VX)7kM^J)d<Ot(l\Z\nKf6R)V4\r-*̉pCJ^M꬏jbZ6*c+=e+gv6#k{s`8J`A(IZ{yzԳ\'.XerNyPŷe{4dˑvVb-3F\n|틇xEZNߋ0<յ p؛e^G^mdKp&ZO:\\+\r>I)&کL^wnMƓ%4}\"Z%䵙Eڋ!-[F\nZPcAjJ,4Nx]Y{*%v[*֣*: 	q:8nܸu;@ݮz6pyܻU֟R¢a[^)ϣYN)a	N]C[4e\rC8[N=vES	&ծJeϡ!][c%Yx#dAJk=x\0ALkN,`tTVT9t<8b,2Lv^E`nxZkTDk+ؽo౫%Aݎu**zQۤ\"/WoS>_jN݄lVLlzVtXV\\ʋ{v(U@m^Sw<5Kckt͘Gxj+P\0jKZ+d,.d$\ZYG(R\" Hx\\8zGƊjp>=I۠P.GgU|¾^ULtоgaG{)&5{i}~i95ت\\z?#3CQ]E콞>Hd^cmh&\n&v]ĝ5Iϩu%N\0YnMH\nyPiLֶm4Ȕ#CڍnW__^De$AZ8Qsgi/}6$6rem;gy^*<^Yeerϴ{6l1\rr]Pm6Jj꺁wiO]Fل$G>KѺh.z:Jh.[ʓ}YV\ZNCm}\Z/Su$U*M|<G,J|L	B@sn ?D`^^HA-)s.g.,/7y絫>j*=0\Z9,)ęc)ɴ;D;of\"Fś,RLՈ>?-ѭjZ(gazw,yKĀ4|]/rԎT9m-׵7\0sTrK/E^DeWZyGRda23Gmۗ\0h[X7W?<ⲎW.	tK-6F+w~:2ӎ;B*\ZeXN\ri=Ry~GWx뢸ga`mĳoXn̘E{Ӥ8Oɺ˂$4~{jşQ0S*l6Hpm3O`H1&\"?=EgWJ\'Ҩr\nxZ\0lS8ny?p	ٖF+H0b)bҩ=R7AYdd1\Zu`30unG\r5;:XP\Z<u]UQdMZy.i[cZ4hyl-dSo}Tb2y}$DFV.;2Me:yb()JμXx,.W0m^\Z\ZtSd+c{)N:f=bSm?-U=$ap:i	/ɒ Ss<ێΗy8I0ڼ}<!挰YB\r.M!Hw}x\"}=\"i3i{ﶺaSh֯\r\\.c=:~zeWN\\uUBbߚW,a&dR֥묏yy7PJwv*ЪV*MqI2GhPZFd_\"0b2\"$\\*/T3h?nJ_cЩcWI*li%m\'@c>Ztq<\'ۻrn4,qg{ry/%.nYj݌0R҃rWU6`6xZ??־r: nrm@4>)Tfvq6kV*C@EiNKL?;yn7HVMjbȧfKh(0tJ\0D$\0iR_9c<	o&LoNt%Xs,\\WY쉅If\"9%rY	`\"qW\'YaV@CƐ6+298Qxd94M*\0ztW<8m\rٓ(bztq07YpD_fwۯmXI\06[ L h->U)\\Ⱥ\r[B͡\Z2V6Tѐ8$E쉜95Ĵ+vI=PJGf<(g``ݤ&6)s.[&zԲZ7\0&ZR֊˙.:	4*9F0#Q$)c=4ik&?1g<ֿ\Z54UTR9,N1/RLeui\'%.^z|h/9Z[C_K+[oLuzU@s^ZFs@Uf)RX{MA. 4<CA\\}aBl6ν-zJ&~R\0C*}p!}-<<G>˺\Z\\lgE(,g׋wB%=ϥGumlĩ\0Ovi2XJ/l^KY]m.ݨջ$`9/DmlA$G9u{k\"Wej<QGySˀ[GSWd<WtyL&%\n,Ěتq&z!9bsv:=*gq]3e3s\Z\'5כGU?RFJ[7Phi38$do]wSxd$Ch\rWsD~K-KKuN.L:L	iջ\nqD6FGɟk[oXJз^Ttsj;mFO>A2Ǉ|\\z\Z\'4<\Z(yݭ-&JmFn@2$I*G0eǒ+\"(p NMj@\\n^Z1]vP0VwDfxSPm؉^НeaXrW]35T3\Z@جfiF,Rbxm63\\~u\\3[0PrNY7fL`㽉LYǜ\\çeM}@yD?nbm\'MElX#T7JڛI\"=K6p̛]0PL<n~\0S;#r)zF_֣?NZL\nW+7!=O5\\veFRP*Uj%=TTJY  땵Hy\nrdz-ȞivY$	W5R\"VX\\qH)Q14PE$A$KﶹKY19ѩ]ڕ9~Qbt񈮁h\\gf,+73I?A)wB[[;\\Mۇ9ۧSG8Ub:sl2nVW6gTʥZA\"˨U\'rgH]e+gRXЕ!O\0ҩ#\Z-ۖʈeǖVVKTǶՠ-UB2yyiYS7X,^~Q;\0Vj,PYN%p\0&fr\"7jw|ϟ;Emi_9u)E5TJ\0.Zmt!$ux=,g7KSJ9ݶhLUn[4ިʧҸ?%KhBV)zM˫tItpXgTk5HG9u{k\"Wej<QGySˀ[GSWly虇vӏ[!9W(՘=I}:]LKǗRc2՜hޛ(.\'KGMF0vHSE*Ԡs^o8\'tddRBη?UZDZ&ơkJ.t+UnO-u,$b5[!)bM?lcdꄕ2w[sjb\"<26}`\"ǛtI&6:k={ȰW[8+JFfʆcHM(ŊLRC<2omk~=Oκ+vKaf\nIߜK6Ɍ\\w=:I8t\"IH;׶YzWМtv\\_6v˭㥨Щ) OnkkUT$l1tH&$A1P?圛K5Vn`3vnWQ֋]VPe\\p)l.q0Ť9`@ƺa2Z7\0&ZR֊˙.:	4*9F0#Q$)c=<}	Ͽ浝.闽\\m^i t\01.ӘҖeFEZ?Lጦ_C6\\G&[#zX:ݺYq}a|:\'&*A؀&rVţ|\\ÞJnkOCLE3\Z0bv7a8uexSH`\\\0<<=}%\0Lqˇ$\'TWa~ue1dzm?>}F@mbj,03c] ô7=O3oe\'OuF9g<9O	_ny~j>5u;nq=/_<<͟UBd=+\ZṾTZA)]by\ZQ-HQ+a^@b%@Z.Jvڄj\"i跩U٨6+f:j)_W[7}3ǹ WB!)[rSBiiءQ_Vp*ېLO`0&nPCjĽJ.La9R\r`[Ϥo:$.c\\>OwmvNtn_jg\"	\rLꤡe[2 &%y%%2즕W,Ǟ7	Tvς_	`(63JO~fjѕ죾V^+\\C\"yj`#Dzח[SȔכ^hja>5L:zV\\LMi/tk\Z|xj\r\n~5NWNd[Ł۠&n+ 0Ds]9v/GJE0s4sMb\\iqt+2)lЫ#ty\'EBr3R\\`)`̚7O*n3F*<RBEr_OU#X[B\09zse+!lTu]W⪰{,l,``Bi1v>k&?1g<ֿ\Z54UTR9,N1/RLeui\'%.^z|<<<\'HTNR:ѫag\nDj)-qA{UV\nʥ²M[nYŻunǵ𠡓u?DKtWEC-.b򪜃_*%Djx=n_OlXQ*6kM{_x0lӹVAK*-cB&qlogyn=:CgYGbh^bVѡl!K<h-nWq̾*\"\\\r0zao{\Z_V\'~\n]5Rk\r|i_iko!pb``*i\"vʍE=B520YMn-d%;.?M2qvm3Տ1)9;`oDvb9U~$eǢiM~g0	WշUmo/se&	|KiK_V&yx\'/Yjë*7$Oq-h<+i^{Җސ5v4|tÄmUv=fHWlYjvUٖVDz꧁eC͍v^nn4cDNYJ#vй+\0w[Nq+d^I:RE)]t+N6*0#+ܱ\0=m}Dݯ*?]wwRgbu_B\\ \0[bV:&sd*/9缹~gCsD\\u-]%Ee<V+_46IIy7l~y&KW9\\zKPZ[!`9s%A xEG(`9BE,{Ǿ-d V,FwjT1E\"rJI9Lߘ$Vyߙo_Qoyyyyg5^>{3щnTL讍)?qCadaHg;#AfzY\070\0v6`X̀Y=fOd=ߌnTRj]ΟVyeЎǑ,rN:m:4#Kbt/\n덡K+qdiS\Zlm!6Gs<*1ˏ+%>|^`Rݒe9-Wlj빻Vqp)pW.=mW2a}+z}]a\Z:a:e}0BӠŅY&m󟦻\\bz >Q=r?_Cbe]N\'Wq.w.Oiw\0<dXyh<57ӫcc\rA\0=B61́ћ~$Kne\\ǵ;:%wymvU/gy9^\"\nirfa\"Ȓi4H:žC8UG/Km<Uu[%S؆!h)Tє#\\i]fȱ|j6~=Oκ+vKaf\nIߜK6Ɍ\\w=:I8t\"IH;׶Y<%=CpjE-h㠐S@<\"c0ieHHI\"=msFc+skSEUH*s]й%$Ϝ&XWPof~+<R̷(<<<<WM|_FNyF.5$oV8y$ڳLڰhe5@jCfI5!1woc:&[\001x_PIިUu5u,o~cO~`	E|iO0	S84lEcLܝ	ỵ~\0R/ѦG<ђ&oRN\'bd$\"r5WVA+~&5AA ߛm6coGuϪߥ+i`}mpV;o\'ß_kGV-ȜGBɆY%LUv_ލt9WtI흟ܖPa?I[Ӭ;mVЩ(Pu~v1M#HX]tM5ƺiƺ馺\Z뮺\\c1c=瞄>\'lKt\rvZQyi0_zEA1wSAiY82r$J6AaX+譈U	Xkv%|#3PC1\rka\0&b&)!7M6l5ʿ`{];%$o%zvd\n.;؞$Ŝy:~M\\$٤CV,y{	W5R\"VX\\qH)Q14PE$A$KﶹKY19ѩ]ڕ9~Qbt񈮁h\\gf,+73I?A)wB[[yyyyy&z;#[ k*n~|ZSե}8U|9L>fù	UG}=^\\3%&e\\wF^؊wT6j&m$T^޳HK<;5iθkPgPA-kĔkN\ZLgI49xrm\0P)W7mnc\0,wL*w$	es>syB;w~ydsǨn\0MT2\\t\nhTr`F\r,)II$RǼ{ib2>: :[L͘ե0#H8jm8鸜m|ܲ/;=4zqyyyyz/PJ^҉-Y.Z؀b\"bᒗ(W	UWVPvkk4Օ@!֔-Ѫ\Z &H()T85\0\\\0ÆPqGic=^W%~ۦ֭tʍUJ. EgvkOwdlY,0_<qUzVFה[iV_;4qOZr(y7X83\Z튑Nھ_Wfkp+?g<nfFW}m( Mƻ+󞷜z8;<%=CpjE-h㠐S@<\"c0ieHHI\"=msSVc+sk;SEUH*sF\'O)&rc	<Rzyyyyϯz;VȜ]f.7[C`QU+Iw_(a-ࢂRM!TT\'SQ#.3\0j!IE@R9휰cV\n6[]\ncfe,y蓳[FCW%j\rÔr;uyoj6j\\V\Zbjve/On薬C	mj1S9<R*eh3ULFhAlڙ!Aٲ,S&r]<ƝUU[\r\Z^Qm[TY~\0ҼJ}=k \nA9bL8lk*E:j~^=|\0N\Z^]nU$7\Zgzr=Gc`o<Lr\r	BrKAM\0Qr\") \"	$X}MZɏl@Y5MU\"ԩc<b+_$Ɍ&XWPofzD	K]-\0yyyy	\\^e`5.q(U@jZj#;C0­7KSFƥen*c%w>y瞏\n	>+z6&D?vmmR	_^\05Uq\"`y絻:Ъ\Z5漢N=٥xz@!Cɼr&qlA=jVwoђ[sUB՘^SH^zlkvŎY<a2Z7\0&ZR֊˙.:	4*9F0#Q$)c=0G\Zv{ k}WCFP]9o-/H8lu4dm%JZ܈iXO','vsantos',51,'Pentgono-teste2',NULL,NULL,NULL),(152,'point A 20 60\r\npoint B 70 80\r\npoint C 30 50\r\n\r\n\r\nline ab A B\r\n\r\ncircle o C A\r\n\r\nline ac C A\r\n\r\nintersec2 A C_2 ac o\r\n\r\ncircle o1 C_2 C\r\n\r\nintersec2 C C_3 ac o1\r\n\r\nline c3b C_3 B\r\n\r\n\r\nparallel c2b C_2 c3b\r\nparallel c1b C c2b\r\n\r\nintersec E ab c2b\r\nintersec F ab c1b\r\n\r\n\r\ncmark_b A\r\ncmark_b B\r\ncmark_lb C\r\n\r\ndrawline ac\r\n\r\ndrawdashcircle C A\r\ndrawdashcircle C_2 C\r\n\r\ncmark_lb C_2\r\ncmark_lb C_3\r\n\r\ncolor 255 0 0\r\n\r\ndrawdashsegment C_3 B\r\ndrawdashsegment C_2 E\r\ndrawdashsegment C F\r\n\r\n\r\ncmark_lt E\r\ncmark_lt F\r\n\r\ncolor 0 0 0\r\n\r\ndrawsegment A B',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0C\0\0\0\"\0\0\0\0\0\0\0\0\0\0\0\0	\n\0(\0\0\0\0\0\0!	\"#%\0\Z\0\0\0\0\0\0\0\0\0\0\0\0\0+\0\0\0\0\0\0\0!\"1A$a#%2Q\0\0\0?\0\0dի۲O۬L܎`?O`vg#]k$_8zotK#w\ZuWUl4kyEmPz5eJ+1+I(BxM==v$S6U3٬-n\n\0@Y!Ul&![J\"Hq}~=Gy|;&1c1c1c1c<.\Zyn-Iz\0 _\Z_\rMD?ٯz\0\0C\0OSҩfU`z\n~\'>i=ߩ+\\o\rջhGɹA$D_Wftkc\n`AVZYHySɪ:(.e*=Vڝt_X2:)_Is:x-0mٍ/oiX/6#X:h]Ec17E[[v2;q44nE^a\'Ʉ`]\n|Xi@nP7OyOT@eJYq!^p8\0j{|nIArsEY5J\rFo:Yۯ@@HR\\\0߶H_M4\0/_=ξ ǐ:Rkt[qN2F7@\\o*.)^S!^9/Q`WxFt\0hvޟxVx΄@県}xy%2!Do\0Uzr_=i\0Sz?<QF:\"+c6~ctW+_Lmy7)SymgSV\nۍ%SђZj˷۩[U[Ա%*.I]a9c/3PV\\^E~q[9@䨹Jc:bڶ:aMp\0\'KҩSU͗c\01\\\'۔W{kWgb:uUl#En/5VRX\Z,t(%]ŷ31[nsJR\reKm[Eo\nI\nmsUѕqW@o-_^Ej\nGU-Sڈ}<cfb1DdnN*y(ӭAf\0vi^%f>➵i PoI{翟?yI1q|jqaomvV>y\'t̍p.a7y*Q@vW3[yB;~F4Bhךm:ڠjfVc)Y\0VP&{{H\\m_/ګgX[xݵC7I3#@MB\nD&]{Ў_wtMc1c1jHrjz~3bV:ݢWQV$2]|M.\"A\'`r	/l>ٗE\ZkV(g\\*Bճ(`T² ^_^>{xMwP6kmtWFikJܪk6maXQKL9Z\'tΣ9pXF\0m	{ۭ ABSk.O2> Vֹnۈ,W[*辱}u_}aOOh|Ri[i	r d}Vi\'tÎOa2\0U8żz/Q`WxFt\0hvޟxVx΄@県}xy%2!tKUՑ2:0*VR GFMF(גuZ3ikӣ>]l.ʮ[*W]0f;wЂW+õK4Nn\\ZZ/+cGBtdoSl\0[?-\ZxX(~+kU3*|cXq@\rUVʬ^f=;I6.>hoq7)=ˬM9rnwc%cS(Ybmkp)s,1m2Կs\\&TU^jm.}>QofQac3|[xG1hg7ܿsQq_qwyəyuu\\[NbtPNw˹\"T*<L^W]^C?ĺPj{SvOjo`|96IFB:\rJZN¥59>?_[W0l̽tm\',hAH9couփ^B샻hw6n=yn6Sہ	RY5oIк]ֿ\n[ne_+=(o\02g݇Fm/m\\\0sNvEk6\0h*\ZNAM6\\RQBV)(|\'jU廛?E!BE1/#EXiT~ɷ>1\"%h֡+Ut\0*\0\0ۧFwYVӧE^_c[u1k-ݏ3qc=H#\"1b##w\ZuWUl4kyEmPz5eJ+1+I(BxM==vIDĔ덫U{k{o\0sf;dh{w	AV҈kz߾zw+7qUzVFה[iV_;4qOZr(y7X=ϟo2E:j~^=|\0N\Z^]nU$7\Zg޷ބwmc2Òq7_32eKHG}k\Z$E9I6#QHaa\"}b<oarbI<IgBOvA_\"%_>j[O@w^*λ;GP)h〫W0wn+)\ZzZr&#?w6:%Ŭw~Qeb7>lIB/\0=:]cbp8wVi?\\ ?=c?\' 0%C\0A*^,*enDns\Zsӡw;bknzm{gyc*2^?CU7tSh}kya\ZjBłݖoԎzw}+u[\"eul8r46Jך:=R^ō4XIu\Z.KIo`^~[*Bx\0޿zbwPwKDSJwQ0q\0:+t\Z\nXإ&~md55T˫t+uhHV2,_4->\0~}TKexX	R¾[.v{uoTwSr4AO|ۭ_yΪ_涗w+ukmu^K[6EzD/Xܾ]\0x?C_>f$\"ʞ9_(0~b6׭sTZ2ԹkRa*myUm\\Jf@JY5\ZJqE.MqsI$p$ɤQEK,kqǦokkm{~%0trºӈPAXQk,eс;e(y.cxK_$`HPM4bUBۜc~(nch8Srds=nVr?iG+UuC5Yߢp\\=Y,/NQ7w_-ɾSjʞ?Cu-\nhkO]3BÜmM~ESee\0\0\'ċy\r}\\1UǕ6JK96tgwZCۖ1S.ה5~F\rٙ\'Ze5ͷ\0C$<G\0	hkh?F6m4!\'x_B6iڭUCQBT(ha14u=ZT˥絃n:0#gH;o%}\ZםXYҹ{BCT? Ŕ׫XݩL*3.U@N9j|\Z/NlCpn;umz>B볇.ϥ.w-U8/PKc˓c1c1i^Uѯ5uA,՗+ĬSֲ\0$\nM)4|o5&1S6U3٬-n\n\0@Y!Ul&![J\"Hq}~=Gy|;{ugbopzK6qեL\n+;FE#uM3]C9-z{]S׺;w{Tyq;245V_l,Vce8Qdպ?._|_F\\}N(XNҵt`\0hM(KԺK59 ]vs\0JЍXyEMRC4(͒Ao4ve[-7J>;TVJ4#ܴEZ[V߄uA8ɵ\0~i&b_S\0,v&\\m&u˅6\"B<۞\ZyZ3QSkʫjbV[2P(GS((wͲgIɦG&io{o{{{0S65ۣ@ٚ啕`:AyS\r\04#x_gI;h<2ɯuRAcҨ,ǠzU?|٧><ZWӚ{+\rصV랺jR졬Ҵ$fYw8aKQ!s@݂%فaPgT)oUe*jk\n1ʺ\'HQz?5:2ϻ!\ZTM+Mqc`\0Fgܾ%5}MG5rYտEuV4:&wWI5J3YE$IdsǨn\0MT2\\t\nhTr`F\r,)II$RǼ{FJ\0[k\0~BA>^	JgC49Uhjc>?u9rՒHߥrvRMn-?UY\Z,9?>4]ͲD,Rǣ\Z\"7Y^CD^N剑RRKq]I>՜u+1vSȖK./N\\^9dTŜ4.7tfgXS+l	kMNV>U+0$\"G^&%羬5&4J:VF1	뗎=#oﶾyl5Wҿp֥\ZJPnOʑmVիՕnWhzƮJB뺽5ejA|8^VǲeB:#VZ͡\rn1FͿH\04|xP2E#݇\\A=-j~T|(تCɀȖd~̸s}Y-p\Z;qUVY1OlDKy׌jrPhE鬭5z2g/PL(dDYTPjJmUJSf07(t.O̥$KI<սtkyYon,X*y%lƺE\0%kV}|Ƶ\ZEXzPԙ3h;]իeTg\Zm,M1eF1DcF1DcF~wHI78m}M4v}5]uv|<}3\'Tr46|gt.	ab2˼))H7\\g6\"TìWrѾm$vN\0O}zA>\0D;ɒhqbtv&TRY+d<Ҿ_6ƙC}J懁z*[rwPky=ӛuo]Xӈj-HP$\0㼻l`x\0\0#@ACE#\n(#<:iEE鯞yLINھ_Wfkp+?g<nfFW}m( Mƻ+<q`o#w\ZuWUl4kyEmPz5eJ+1+I(BxM==v$S6U3٬-n\n\0@Y!Ul&![J\"Hq}~=Gy|;&ʦIJ_w\0\\C]5O0G\Zk2b2rKܸ,TJC.r,Wm]mt]}mu]|{|}}<eI\0@\ZuVI-DIԾs?\"\"`Y@26rZ.΃X<SOVY7Y{eoFRy)\0rkY`z8`s/d^;Et[W>u/),omsKe1cenNNt:J7JVH:D6\0+H߭}mcdR&n\0yuk\\mhBz \0&5\ZXgDxøJzFg4I\0$ks\"*o(t?Xɐ?d~KL+MV\0һRXNQ\'	Bt@}k]ծ|֛Y7_Q(6\ZEv$m@6M\"o- 2yX)/lZ5;KFBZr<s*yVѷ>Pа Hȝ9r!?TZ5I*4o\\ɺ*º-A|\\6:8G8RdtV#u՛	\'>I??Ϡ!Tf *I$\0|O䙡@+MagTEVA\"FMko\\F5ah!`kVS,R\Z,3]UwVY&s(UmԶ{DN!ETIjx\\vkEJ&eG==1ն:I\nMl3K?$2	jڶ0\'ƫm\\:\'DKw8h=ZraOfJ)c-z2^MWbFhxCoeUBbSFe^B0+s+S![[cY:eY/u#Y:]-W7ci[MjWc_خӢoX{|Jڼ3ț+E<>*uWo0Fb丽-U`6%\rc-L(1c1c1ԏo0m	\ZJ@/?A1WӰY+{hZ{QjO+/s%V3>ՔYunX?=O8{\0d}vC\"^X1:Ъ\Z5漢N=٥xz@!Cɼr&|my$ϝl[Ѻ\r575Js}HZɫ-T]d2Tȩ2>:ڻmStL\'}ನ0Ǻjok&*.=7w\\˭٪ Vz>^c{-_*\0to\Z$Vk蔒є,r~yh\\sjMu4l5C}=t%c:zTuWwuc֌w^pZ[x?4m-b%-\nsnv{	|덫U{k{o\0sf;dh{w	AV҈kz߾zw+&%đt,\\$(?Jg*+F&Vf_WvWJ:訋QCtZcdfVSΚ5\ri<Qڟ܋rRvOq@?ih!^h{B7hD[iwMoTfECʵ\Z\'il췪myq`\"(ţʺ`-$\0(QއR;qPd襗V|{_G6\\%i,l\'=s!=:M://4uZ].qMC= rֶ]7(W/GUB#tv]`]k\0Q<EկLNTW\"/^);9ߚҫKvMj4z~ܗm7dnmOO{y$C(EOk,3C.$Rǿi$rioyZ3c)^l?V\\^WM\Z[.EJ%(wOw-G܊9DGSr\r\r^ieJ>@kVu+Ez!=Zy72k,4Ik`(<L571]x\",qɫ&2YoTn^ؗm<\'Λ-\'HT1n\\Mǁ\Z\n.-%$0wEC](>xYǦ)VTsܒ<V3yQ͟\'hV_{xÝc.Nr1b#\"1b#\"1b#!-xIk]g,du)7vsㄢBBBg)eX+^;N_G\0942OayR{fHJ֩g[<Pv@3$zYB\nˡ;i+1]!)*x\'E]5Ưvev/Vmv\ngC[?\n9HTk(ǥx(#q\0+.ymJtFp3ݯ̥+.J\n1vZCSr\\C@=¼ea78hDK#w\ZuWUl4kyEmPz5eJ+1+I(BxM==vIDĔ덫U{k{o\0sf;dh{w	AV҈kz߾zw+7qUzVFה[iV_;4qOZr(y7X=ϟo2E:j~^=|\0N\Z^]nU$7\Zg޷ބwjNcsT֓Ia@Rh1dVc?uD>=~Z$M(ADT\0,9-n:*C3EZ\0]m=`XZge,n\\ɷ7٭$1S\ngD:֜Ԑ\0\\K\0-SGȪ<mhqZJuW^\r6[lSn^S.uQLn\nYN&S7+k_\"7vs\"gVF\ZO&U4_iƯTv6cٛۊ՛9C_]՛\\VuZdMܾ=[0E21;3g+wo:	ᒕLZuyXWa\\jbū%KkMd䬑ss/.q{ buش$\"A 21#F3H	1*\r$vb\0ysyPޫ#vIŻ0:IX8?Mg;HIN0EmlޯZ,\nXXTg]W- ~&Ugyۢ[Rߎج9<~!E1rܵueuy{,U|~U#Hh+jo	hpm2#]#s/I2o4HM_6y2|\0=\0:\'~?{Xel!UAwbBUPXT(\0\01g1b#\"1b#\"1b#\"GmD7hFRVHU:ƢJz9`8RoͶ6Px\r\'-4CG:<V>:\\=BIuN(Ƭ k`ZVt;` JͺZRL5TIg\0cUCֲ\0iE02rGHfx_Q=QqoS]iФc+3/ٯlOr;I#VCe%=Th^h$ߤVrn6\\>Gd(IK	T*\\,J,?w8$?J{MKwj^^:V,E4y4z\rˡ%5uPkXm\\\"Q;ƻcH3Lֻ\"oڐfΦl9}K{:MFd/EB)JgieuIȄQEK!<dϻ(^Q5ȑT!`juq\r|AexF$kR\\[EвŒGד;Eqg\nZI\"ٝ9Of5	V@ilt[K,um.uΔkuJF#ǍK{jhâ=mBU}ZlW;MJCK/-ݦׅu{?:>w_5uǽ5Z橋\0v˒;Eyڿs]p;{a*NN2ӡ~o(^qrCYL>͔\Zlo}&hJ;݂9|ES>=n{QWnw=NP,e͆wD&G\Z]dL\'Ey}:\rn°䯐fjf4Xq!$ҌX$3&ɦm*\0ztW<8m\rٓ(bztq07YpD_fwۯmX*UPY؅Agb\031bI$n,uصQB=e٩U55g|)-h5&1\"-Wӵ|܏)HSUEH13~O<2\'\0QI&bj.ӭv.zUVpyLsoO]QMI3?6ҁ( r+@Ttg~t.f5Ȫ^Z$se)m)7\0]XL:[2djy]pk-tVZGgIaVݒإEzr,C/-BKTwnbePȾ-}άݿuRU*}co9L<\rU!tiWmeg	K[Vx;EudͶ10c\"1b#\"1b#\"1b#\"1b#3YWmh[X镮D#Y	f!tvhi+F[y7ԗ:o%=CpjE-h㠐S@<\"c0ieHHI\"=m}D3	cc9myJqo g(n|.[<;;W=a#EOtEe\\7iDcFr,VN*,5\nÒBrc5G0\0pJ1b&i{\"e\0ztW<8m\rٓ(bztq07YpD_fwۯmXI}:\rn°䯐fjf4Xq!$ҌX$3&ɦm+깿Ble赖L8Z$UeDs[U2yi}ݱSTwqrxh6U!R[fc{3\nќRB)bf t,z8yqVUf4e7&|վV}\Z,\"(Fpa	UaU&ZӬt\0ywBWSxspu;lD\'Gu+Eo6JNzaMJ.R\nh\0A^_\0\'hx8ڏ#Cbx/.Iyor9k+hYG <\ZEp~^\r}̞]XP1S~\0\0[w\'!u\r_sO/E)׎FGYff1e1DcF1DcF1DcF1DcF1D4NZ;DhyO4(أzs駄l&AKA4tZS{.6OMv/RW.*o8o[aJhMdhEf! &s7oaиH\'<㭠/5[{¦f7݌1}SS	S{\Z%eUbc-gy\\9E;#m3$cv(ڷУ>]dN0piE\rxl4*}!\06s^w\r_=InYPdݥ&br/[KI0-YzbU\0f1=q5c0MQSGjyh@DoɋXbƃ*`\">+oy7=/⊧[16cAg(Ow{V/}qmx|8nYh[fԑ52QttCJUg0W[;ՇY__g婨tjHr%;>sҁSH6h%WO1,V~ %V^=)/Єה@Zh	:TbV\rKZPr@Fhb=4SҨ@O\\G_S\\\0X$&\ZqrLB=bi4Q\"Pu\0?:y-(9\'[~q,&0Qq&,.an& <^ڱg:9\n+b\'{Bu\Z݅a_!t9Pib#C8IIHgMM=U\0?:y-(9\'[~q,&0Qq&,.an& <^ڱg(\"1b#\"1b#\"1b#\"1b#\"1b#\"1b#\"1b#9\n+b\'{Bu\Z݅a_!t9Pib#C8IIHgMM=2~=Oκ+vKaf\nIߜK6Ɍ\\w=:I8t\"IH;׶YE؉^НeaXrW]35T3\Z@جfiF,Rbxm6s~=Oκ+vKaf\nIߜK6Ɍ\\w=:I8t\"IH;׶Y&1c1c1c1c1c1c1cE؉^НeaXrW]35T3\Z@جfiF,Rbxm6zLoZ1VnyUuN+׬dɅzm>h3IoXV{Ʉv/+V^r7qUzVFה[iV_;4qOZr(y7X=ϟo2E:j~^=|\0N\Z^]nU$7\Zg޷ބwmc1c1c1c1c1c1c1i^Uѯ5uA,՗+ĬSֲ\0$\nM)4|o5&1S6U3٬-n\n\0@Y!Ul&![J\"Hq}~=Gy|;ƝUU[\r\Z^Qm[TY~\0ҼJ}=k \nA9bO|>~6]덫U{k{o\0sf;dh{w	AV҈kz߾zw+b#\"1b#\"1b#\"1b#\"1b#\"1b#\"1b#\"27qUzVFה[iV_;4qOZr(y7X=ϟo$LINھ_Wfkp+?g<nfFW}m( Mƻ+<q`o#w\ZuWUl4kyEmPz5eJ+1+I(BxM==v$S6U3٬-n\n\0@Y!Ul&![J\"Hq}~=Gy|;&1c1c1c1c1c1c1cƝUU[\r\Z^Qm[TY~\0ҼJ}=k \nA9bO|>~6]c>~y.-0s[2?%U͙VЙ(VrJ}.H*LP\rJ\ZH5fd\"','vsantos',51,'Segmento em 3 partes',NULL,NULL,NULL),(153,'point A 40 40\r\npoint B 80 40\r\n\r\nline ab A B \r\n\r\nperp a A ab\r\n\r\ncircle o A B\r\n\r\n%intersec2 B E o ab\r\n\r\nintersec2 A\' A\'\' o a\r\n\r\ncircle o1 B A\r\n\r\nintersec2 A1 B1 o o1\r\n\r\nline a1b1 A1 B1\r\n\r\n%drawline a1b1\r\n\r\nintersec C ab a1b1\r\n\r\ncircle o2 C A\'\'\r\n\r\nintersec2 E\' E o2 ab\r\n\r\ncircle o3 A E\r\ncircle o4 B E\'\r\n\r\nintersec2 D F o3 o4\r\nintersec2 G H o4 o\r\n\r\ncircle o5 G B\r\nintersec2 I J o5 o3\r\n\r\ncmark_lt A\r\ncmark_rt B\r\n\r\ndrawline ab\r\ndrawline a\r\ndrawdashcircle o\r\ndrawdashcircle o1\r\ndrawdashcircle o2\r\n\r\n\r\ndrawdashsegment A1 B1\r\n\r\ncmark_lt E\r\ncmark_b C\r\ncmark_rt F\r\ncmark_t G\r\ncmark_lb I\r\n\r\ncolor 0 255 0\r\ndrawdashcircle o3\r\ndrawdashcircle o4\r\ndrawdashcircle o5\r\n\r\ncolor 255 0 0\r\ndrawsegment A F\r\ndrawsegment F B\r\ndrawsegment A I\r\ndrawsegment I G\r\ndrawsegment G B\r\n\r\n%cmark_t A1\r\n%cmark_t B1\r\n%cmark_lt A\'\r\n%cmark_lt A\'\'',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0C\0\"\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\07\0\0\0X!#7x	\"$1%&AQa\0\0\0\0\0\0\0\0\0\0\07\0\0\0\0\0\0!1\"#A$%2Qa34BCDRT\0\0\0?\0\0yǞy1yycyǞy1y>4Y1d|b<KS@\0Y%} q\01G\0\0>^\0.1yycyǞy1yycyǞy1yycyǞy1yycyǞy1yycyǞy1yycyǞy3;_\0Ml#~\0\0[7{\0,_GǞy1yycyǞy1yycyǞy1yycyǞy1yycyǞy1yycyǞy1yycy5˵D{;_\0Ml#~cycOc7ڭ)4@&X]$9(|z5r5Ôـ0AϤ[V2{j\nے.**{+bN&\"rVF@Lp{\ZM;x3Y*=ײ*i{h)Ɯreb6EX48\\_z:1d\0:b}7b/W_6n2|qidL\\A9~RmoSs$3daGT}.\0BZV2t\0(\0qa%g}<KDS9OJ%&g{\"PݴpT|g)\" C.K۴y&E|;܄QHIp*]+uK5\Z#&w4ՌƄea~@).-2=:9\'[Ull|eP7\n:>r#8ZITw	$KI.ͯYv:XQ1FڼK$ Iv=iϦHeh]θc;yǞy1yycyǞy1yycyǞy1yycyǞy1yycy諻B4.,j4TZh]®><*Q$Y,C$Y**ؑ\"b F2U\ZhQ{3@fdpm:)5]fT۹lXͺ0is\0.5aٵY822hSFwk5Ȯ}\r_Ej!*u%[\"\0̶y۾Sq\\_9W&=4RD:(=s\0pr c^\0l:\n3<놖(7g=Z۾\\\nvp;\nM~GufXfH|Mњlsh|w+)?Fw\ZXm(MW4\'rUc˴$	\Zi4U:gHe?,ʫyj\'\n]YWMsTi1`XaoWƟد\"=;ˤt}&E\n=uFSB<Aq㑄̷_[Mn4-iXkfN=^ʏn2lm Dk& O\0z8ݽg엮\rXDpP|L)\'&oK N#&sXOO˸*ܗ9jcdg:}RCNNC9yْ	c<Ϥ,=?Əb˻]6Wjq1:jLW1m;	ο\'#OBd	H;\0\"=QIRvse(	(pG0stג+	.2Um7V#tL_|~/lUqE|=Xy|롳4Hr4ԋc[(θ}E;An1<c=u&ͮ]bUZpI\\MDI0*My]2HS8f-o0\"O<G\Z^]VR/.6Z+,\00~h75TBÞMby9{vAZS@l):7sѫtq\"Q2b\nP!jۺNv#s|t{Ap~lvSOq;CMLK`gfx:vjCӍ%Je|@~ksaq>ۦ;$@AӮ9v|ֈ_012NIZ-_N$*cl\ZJV[ߕ%3jBdAt-ڠ84M\0-;{Ȭz!LCJ#5p\rJ4{C#!X\07AmcJ$\0\0K!>R煺qA[u;IN(B\\Ð9XPC<N9Ϧ<EKi&kg\\9{	:TpDI,_\0;%dM5Vzmlqi>9Xjq{cTEwtn/WS<Ak״KkEʩR]OM,VKzj$gfsGׁ|a!-fc`|}&K\ZmxЭ4TUgv51Z^|]rhf[ɢqM\r1\\ќV6Aj31J|#7`|s)%k:k ֕=mSyWi\0d`%ߞcyǞy1yycyǞy1yycyǞy1瞍-\ralxȟ᮱p{˛xZhjViX\'jJ~v\nJo_4]!f5csoYe U`ZZ+4̫B!$ϵ|J~wMb7RͣQohjQ󖺸p}*\0M\\<\rRZGPUzE	rpBXa9L&5̦1bYlX$ư,\'yzwdm1a?]<ڍϐǍD&#ux3U-[+\\Ҽ=yGn7.ccuϹBaKJ`nKnId&X3&fH<\\Yyzt\Z8Sܻ8Ԣ.tk撛ak93.fvfrt0u﷬Frx=R,݋f	_^}tbV97cIjjLh~Z*՗78nT=Jz`cs,r4񕵢]x:!ȺRTW\r=UT౑jW.tme(_W,.UP(WB5+4,=./45͒]#81\0kf\0q/kwٿGe<<1Pώ4pFǗ4x;Ť|x>=\r,&-|{F}#y$X]}ƺiog\Z뮺9l18<g}彷ETSTp:_\ZM#.\r@/Z4ŷT;>U\\>JBr\'G@LܹOXǮغMCQ+CqUȉT?X>f\'ӕ~ϑ$L]B@U];Nk_krӚhfiJK:W|_`M{tBaA#>ת̧c\".7u	kmw3/,hVK,i;KP:TD;JTuQ3zvOo;)L;&60(!0rU`et\nmx~UU6v{`B-^2}rr%\\svZwZ\0!ٜԗGDƳ%E;z\'NL%~\nY(S]Zşqqycyǹ&.EBǪJ}VY#q	7#bi,}lLu-7ק~-;\\czG1]u)}͋s{a?*2=\";\Z\"Nf4*	G]N:Ϋ֟=~PO}6u6sbq\\qet&!h8n=+\0ja4ib5NEkg\ntz=E%ʹ1ڷpb$,sk,0W:\n^ZvfX:Q,4>em/yͺHHukU\"b-+bdDǠ,oA*OgU,ZRgy1Ϊ/%SM8	uݰD-fFxbd^ec3ǽe}9X_>_|kz\Z(V1\\ʼ0cH8~t˻Z,_}̺7쵯6<ByYg[jl<ojV@Y.V?8V^(O]2%vJPaj\"Jq%V\n#!n0jT?3 e]dG9<Q\ZvXL$Tr=SWVa_̭fCAQKŐERr69	>cyǞy1yycyǞy1yy=BfXF&íQ1\\w5\ZؾkAր1MmIg-vb$|X&=t~OQ=ݛ+?JQiյY<9jxJa=SMf6QQh1:{Njy*W}_s~s3*ר7`Q1TeקZsl<kR(YQ]z4}.n~/7|;9kE1q0ijsjE3bsc<~w.|7`mReJ6}bmɃ4zj.Yv#\nn֪e(jv\n6itwWzӑNDC^JwꗲCIC0!kK_:TZ痕,)*}+u!$ͺaHLui/|r{e1D\njut/!L3i((XƆ4;-,oy6tdxYvkؿ؜cgY0lȢ\r2ywǞy3;_\0Ml#~\0\0[7{\0,_GǞ{ᖩԴolXhq8S2lv)[p\'fwc\"ҹ-PމbPm3h#\'khTs5В(x-Tf;Ws}ۤkU:<JJl\'#d`\\BdZ9}rb{;]t6\0Ϋvl*uWނx=\n)\\aeV,N:5=wQ!:%TmV+1G/V+ݽrZGPA+BHH=SZĲ\nR5nޤyDe|:!0I!4f϶\'\Z JWJM+e\Zlcpedծ0*\Z]Kc\r$NU[WlK>)rŬE6RԽV9jϚ\"vr&,)PW9QR`[=j^4Cz*5E:+;5ft=[(U-\n쵫~;G8,2y8bHfx\\=F~6W,\nҬfhjm9,` h9O좤\\l_Toz[c<<<1]-4ֺ*Wn׷X:HSW=fp	Y\Zf@VjA=VUdNRu,=XVE$Q5$[g]ͼ(g\0d_jjf;uXz\"$%{>KG]Jb7\neHҹeyRʹqUH5Q)Xyk5yF^GlYV\ZXyf0n+V4h\r8A&ﶹf󎏦vҭcYS|}2[)	4F\0\"(҉Q:<Nm~Y!/<zKY.r	\n[E@rK2<EQJY \"	#)7}vϻ~mCEnpMt\ZZ><(@ˏHRĮjw²겧VZey\n\\`\n\Z49$C&-fIm b!I`-XHMǞy1yycyǞy1yYwtF\"cV#n۶b\Z:VmMZ^ٜ*J)M<xQxk/ue6W$9|i\ZΏQQLJu8t<קܣ	xW֪Hl6viCpPnc{Er资6:_CLUړuVZ_1<c޹f9$|I9LT4YmLЍM<6MuϱpAT._9~75F\rcm֡#նG\r}0P2{@zkP!\0	W1]yqNߢɶkf#$ra-r+,ݣJz%aXc֒R#YxyK\'\"m1F~\"a@? q,G\0i\'c\Z.nrk\0&fg\0F\"Ha2Ffb3MeZ&H~F\"H̿`X	E1咻Y\Z3,o iu\\	d&l,oGy]]t;m3K])0ɜ\0bh;)&E8J\'9AdIS\Z\nЅcI.7A\rfiGl,͓fsd|؆,i2-߸3:Y,M͢!w,cӵ(\0j$E$tƥvnQmzƞǢZѻcTYY^czâVm&\nCIai>=?O\\&f)#ˇ4T)@&IYRr\'LL6 ?M҇	&=$I:;{6yt5B OfE/gf5~<_7||YKPօ!2\rk&_\0>KH\r/VP,\"\\1ڤմ~Uw@eI\0ΏYghtS5ڥBaH$̟O$Q<ii͓ALis_\0\'H\\kC5˵D{Za`=%:Z114?MfLę1r&#㘟R]ih>(D4f%2HǕGh!>g0>HfG5ͶmQ4SYcU	\0\")2 `ݎ٨juE]A\"\n?9wT޲Q6\"mfQ.,1}l{D{dK\n ]-9wnzқ5Ӫų*|ca\\Z@oҀckGV4wJ`r} \nR${@R3lZfH`\'G9\ZrۢCt\':ZUVɺ_aRL>`~To.:UոT6\'ݖ\"\r5s_=:H꼐ń&3wx\nf#\ZhjN;$!؝$M]]wmw}qm]6lgq8R{b-eK*ekcTz؇\nAY1j9GeW`))Рsi[Kjl+-z@Ѱ+ckX4fm\'\'w24ȁKMnđjKaQХ\0I`|~1Zɫ\n.uUs-q[~z JCbϲy[\'?M(-_<A	 XJy\"(d4C19M$]#9o\'тi/Ӌ}3\0Bȏc(e\0G$d\"1Ls3&`=G%1@#\"!axp\Z,\\<O}eC6ǿM$k˾mqP|ݟF]ꝾΩiUGap]RMƫdXo.9KXD\r֠ER1\\ZhgP}\rQf4&5I7<&	QL}4Zc3aqJ#<=3(*;okj/Oϱ;02>Z![F\ZEU;-ծm*P_t@J+N(\Z2@\r{N;0i$ȲzGWEW\"Fjz[Ihބ	0}: CGrT;[  fhJ#B7	V>nkY\0цch*f9qKM8ܑJڻ.FﮱK<iِmHMcI~RzN]g+(qA3緥Ek)cH<Qr[&\\H;meVQ/4߾Ţ^ۆ\']Nek+lFu55H!d#46=:LN_MLm/h}Y ië|ȮC\ngzQBIrr RyAϭL}!Tif\rqsgep`҉iqha$&00ҡ?*U,A$xP\"H㦟2LGsLvS؃bUL~ ~E0 __@^E^\"DݘвLQO=k9TZ \rA7k\0k\\qE&7x=aY5۳JBrK\r40ENO>ΫDJ#LGYZ\Z&E;!\0/>9)3n[#ȇ\ZAc21;0f,,jlӡ2PӖ1Tm.! t($#=	IL]:05L\"Q\ZՊܦ[o[$6?yK4®TQ\\l:hE?\'	㬑Ic\0mj\nV>>u-(QS\"=&\0nV\'SqsޞҭҔkaQpE,5}҅ec^֜39N-^{oD)1ݒ)XQ[Zid$]&imyms; F	k_$ ZaXwڃ)`\'EJR[=ϕ6Db~=%?DZ53N]vR`v[G/dXk(8_i.Jr!tk\\Xad,nQ3<^Dm\rd4دc-ċQ:ӌ敺qO$lAmT*ߢW-WR<&5\n\nN,\'ix`O-W#ꌜp+D99#ZڼEnJx4enO\r*+xLw\'DuuP<<1<c<-kU\"\Zh.솓DrʉFseW\"uu\\g+61wF>y~{{.X9*O?V0j&B-.cvi\re0pŧ\"Mc_Ͷv5_Ͷ?1?O<<V-<ةic=$^.v&V(T\ngQc](r- X z6Inq{<\\v-\nWOW++CI^\nѦer!WקB)xk%M۾ i`ٓh\0wƟ_aw)oPWVd6,QO璲ߟWZ(#OhսJf3!EXs\r_w*0hJvL.lXguӤUE-xխ6ZˉIk\'@50JcaxhW\nզ.N[+`Y\ZU&^i̱Zqk9ә,Fia1(XG1a̻C铝)T^% fHԷX͹)HE?nt?AZpz@Fhit[@\n Hrdq()%K1D˝ue$$3M,_waf0ZV꽒	e}q%Pn`\0z]\Zkj{͊T6ڦMd:`&/`~uZMN<<<fwٿGe?e]-\ZI,Ѩ(.ld]UKF^k\ZMaZյ	T\0kf\0q/kLyBxj]&I3v}iX\0&e!Hӷ)}LV9Ү*TpkdQR?T+MntEuͭakC\nZ l2ѱ$kk<|gX9!=%]7XY#95λ&c::λk83z5kXJ\\mqtMIa&~8 UP(Y?=\\ll+	DSBRAXնX#Mk|dxJ(0\'ײ`=/	CRY:H.w:g!&?I7=\0.|4~MƓA.E4yMv|cmsS|rP_%	WbR&6E+=~Q|tJ`Y;	ClEYDMC-4$,ܕi[4k‟/bIat\'@6_}k&s*	2ΩGD=GQ}ϘX;_?9$WsCm9ɲJl{p2N>iڅoT<k	)5:ZT/+r[RݬUOjIV䦭aTI\0U۝Z>[d:ۿK/,z9}ؘZ]MmbqRh hQ2URIdlm&l$ɕ/-#b-fbJ]f^pK-˚86˟j戮\nnR_Pq~;N`k.Pc\\kyF+4L~0\0c Z`YMs4>ǿ\\Uָ6¾XrZ}Xek;ɶl^JSQjye] oۤ0}rȸX#S+=oߝWt6;\nU\r]Q{ggG+cJ?@9FZnw֝ \\D2okU`_Ж@K\"ARŕtMA<N:p5qhKuFz1y1yzepP6a@.Y%7<4oIY>i@ն.I \Zf]4#6-EAC>EljD 9Kd\n@\"A$fw_ZwӼXݠ(o:Vd1\r\\^آ*e8d>A ($fpFǤf輳\0Q9(1ibBL[nޛ|V\Z2k$ARucE\\E +UYIiؓI۱\ZW5+/8-o-՚cEcl`]\"USe3X%v?ZL*=4ÑJoVw1jduNT01YO.y\0em+h>T\nG״75r/Y5UrSZ^3:?a&[ZlY$556d,Tis=Tp˕ȨYڛ\rF_\rRiو	+b[9\0a!]·kLk_2<1\'sm=v\"bh)f{ϝ1>:~hJz)#7L^B+5>T-W*&#V9H(j6b#0S4rǶo&)CWQVEs{$r5qREtDޅy^4TjpԊz=IyycyǞy2.u[AsE=/NR	\n9\0pH(\\V*R.d}[tZ_7ʇ>)UA;\\V,\0Q e\"|Ǚfy6l՗(j	tMÉ E [-xed9#t?i|ՋR9W\0Ǟy1瞩{N\\t1\\8z\ZI`,, Вh!\\\'oӍ.+lu{4I7W-\n7xդLv>{U?vuK+\'D#@$᫃h),Q!\ZaSmO4g]v|\0 R]c\Zuia:X\Zp8Obof1`^f-E\'۴>\rpNUZ^Iaohm\\u\Zu+.ܳLzeEj>pnX-)ЪZu,Ue<<c<ϸ7PܚH6mdDæ־OwW/\ZTXEFC,M!?tm\Zwoqlv;FٍYI8Ү5+4-\r!%jCeTn<?b<]o,Z\"\ZX+o,ķUyj%D#;nD[c̓GǞy1繎`z4E:\\1FT4kyfM5\0zߘ\0C8߆e9W1<dzvPGӝIVsyDAxq$*\'YdL!Xs3\0\0!,;֣?d{ӬU8]dTSH{:XFgϽ[[^nܶGyסKXSSk`q;k{-_o$e5hޟZknŻ\'gΑ7WI@U+9whV{Nkl<gz\rjL}+V+\n\\Ν[2kK;3aĄ_\ZHIM[`I0V;ϥ\0XvR\0#p,}Z?JLTQ^tpqcZըri`y{n;fu\ZஅkRԖŶDk`ӓmK\"]KhmTk[oK~5Z\rTEgkK\\[;}^ҩ7CVǭ[8^u%y}\"Ҏ>\nVVث!=DN-5Fz<%E	pk	+UsЎ\"o906\Z;|bs֡LfIG$-	#~\rFMP#<J/*T߯qPl=uR?<>K=	zpl4$ÛXAY̫7\ZnnT*]QKAQ\"\n^@I2\"vGY`L	s\ZDt!z4a;A>av+&dYx[[Rd]y7Qi>CW--ZH#SVQM!ڛ\r\rX\Z\0bmNMscOS?Q\"kk/4~o>ީ.qҐ\Z9W.Jg%i,\\C)ţ>2ߝ7M4=95}7lmmmmsqvs83g߯1<c<D]L0dWG|dfnTLI\ZXj\rF_5_=R\\Mk>-Rȉ8\ZcByeHU%)RڍRVHW`8fd\"Vتe\nyII_lчvUA4Zh}yO$QP-Q/8*\0=[Ki\\}QuN;rÍQE=cfͰ0e=ZSe(YUe4\rVNCQYo:eY^H5-S	M	\0yRhC,QVNL?@u[ArZhrge$u\'fTyӛ1Gkظͺ#fItPu:j`6>qO#\"qzcE謚g\0Bam{ЎIs~JhECN#tZVqIذHb)]dՌ16:T:J\':\n \\p\"Ddr.\0\\gǞy1yyc(tƟl]Ԕ\\Px1Kh{\ZYԄ>c@3~CdXXBDtyWOz?Rs,S){+k@9m^Cj:d֢Oȕϯo1<cjάO4Sd;9GPtˠv|&uZ66cl\'P[->͝\"3㥒&GMcrVS{\0Զ\'Ι`*;$@0̒_ѢH[bUMeY$9t6V(MMHl{plqN)E屰qn>~7xT#\0Z`YXza^d3Sr \'lcb\'biL>VRK3\0`F9)\"\"9fg()@-*RKd)b#f8=<<1>1MK*E늻_a\n1q~\n/9C1mB>5VGaA}\0v.XW=&)Zn-=B۫Rd0Y1):& 1ӑdXnVW#m4E<E^Iaѽ5U>h#ilL<*%~d=jE,1SWiߨWK%Jz:QOh\\ʹdX;}j,aXnFC梆\0&#UԋTP(jE-g͖Z]8^(쑘*2~楕g\r--\n\0RNb&^1%״Kjq;񯫧~a(scenZڧ)Ǜl bsz\nMNfZ%ZurJMD1U\'2My2`,龿}%svڅfMX:ow\Z7,WC-UwXfԢ%Q<\"G_5AԱP\n7W*ټhd:-x:H,ܭn*p1-v{`뗟bÿTaY[4]>%xȶWO2HV6\039\0;B?ۧ!fGtKA	<vɬrX	mFIe]^yaU/_%!ĹHSћ-(jVQH2X=km*ui\ZY5?G\\5=ν|GvIu\nTxR^|WH&aG;#{ڞ\0։jE\rP\0|%co1A((+UNxB}bލm=#MEe	$Y|gh`5ysBǆm91UeFj-2x% m~\\vF\0T+ v3c鉶q3\ZJZגWukdڒ)jq	A&QJ3N`DtObsٰ2H0nR|j\\ubj<ɬ=_C+`_Ϗ=rc)Ƕkg[9(gHWiW^#aa9[u&kPF$XdM\0>{˟T1p34nyA=!;bSXsѲk\Z11؉STGeJNx\\y\07i{\0d\n)oDl\n\'!m#n+<JqI1{t?\\`!@(\0pӆhFA\"!1m	\"4	<RžɮmfBR3SmjJAM@^br=$ShY`x\nsᅱ.S-IsQ$fDx 0(0((ka;\n̫i]$ȏ[@Z$ְ[A]bXTFx?*4$8\\-Wr˔]N?Xnkmm2ovU{}Q\rkw)nh}T>f̙Da&9a/\'m\0bZ)/zf,ycyǞy3)|9!/u~lM vF\'z%	p?3fNA@OI4HH]M1鶹λku38qB]wK\Z\\Gm$]7Af4Y#&\rMeIlc9w8+Ёrnr o5wǧW쳖 M[}ɣ}+9I3U{x+l&X+}]yEZ5$F1Нt䧹~bWm*dҲ$71حUf{*tfl;IOO6ϞykydOi[kPv +Yhe\'edSXowաS9~zA^FPcQJ#!}9UﶇUƒ{\Zq@D-=G-Kc<<<1_ض|mW+Ts]OS_kq(7X|o8hЩ&3h\0	r]OaOw®w%U\rms5T QIHATjEqhb}\\S9Kfo߿O/?R\0@|v?!&WQ\'Sٔ#I{\0|g|521mYs8[ 5Ϸht+^^j#%WЬr\\+0	*4U-ijE\0+R*ibGfrr\\[neWDY,V?}M~1=t-9DBѶlhF\'jEoG$F1@\0P3ڨ͐˨8Q5ZTM7Xꖅ\n2gnU	UhNجTOlk0%HeڐժD\"Jc>k֣X/y͔\nQZ?`65)D\0I[dp}.o߿O/?R\0#g~e?S9Kfo߿O/?R\0=D|PA|e	zQ ]}\\ן6\0#z-N̐YPϟ	rWcS9K՜\0]Ƚs\"\0 3`2/H̿_=qhallWٗ?S\0?|:Z.rz:*ZtB )k\Z$8ei4t*M@\Zp4{9$*7D^m۬#;l6}gI$?f|!FYyp:ԭKcWv\nnzg\\jIC4oZkQ%W߿2_ޛ-\\/[6D$coBPl\rnȷ7A?PZKhG9*m*,F:\\J^j\0#Pq8`M#Mt\ZwS9K~e?F\" F\"\"\"\"\"\"\"\"8DG\"?1ZfưɌc\nM3#32\"2)\"))mvHPPjK2_#EjInqۍZQOy~e?s{D*\'1ɜhtߒc@YxYj13%&!R7:K㙻u*(!ko@^⁙\ZeGe5țK!Kǌ`I\0\0*2]ꋛ˟!ڤP\nP+G@U2RIxIݘ~ś90XX+r6Dֱ6W߿2_ӡ=pF=Nms]xTX2)\n`UPK&Sjacvv*]e鮨 	k\n\\LVa1+2fjj۰Z\\*\r%!6KM 1$Q\"Ө[*=#e\\6IFP\0ƿz4z~lD=fkm78]λk3m39qg=SIh]Rߙ]-#\0}$j`dd( XY+JG.ڇ].K\ZY5bja`fD0<~)ind>%}?kŔ*͛֩u,l<H`\n+FV-4\\i<C>Y\'XjI}4[j^Qʶ6ٸsP;GVi01+^q Ԣ<aA$zCmym FKtR=:dLRpl,|(.|fs4}ĸq~}\0\">_nW\Z9Sy$lk$ɮ$ߗyd?R\00<͌TNZu|]ұY9%@\r0l,wc],.ݧ[3ZZB `D\Ze޳} [,]UzW?H|lpm(Æ\'oP|8_j=SU,K]%Q-L>L㈵M2*^cz`Q:\ZVlYlLs;i-%!#{`\0s43\\8γIr&s}6\0C|eM~5CWaa~T7Q5LN>,[xknRѪuZmm{QȪUlnb\\3CE75\'Ӧ\nBUycftC4XMBջMe6\0\'U쭚^k40DXߢ8Ph3]:beM|c`\n]ϐ\'|\\_l\Zų[=W@kih*˝]!YP%W51tG]Vuz.5G.عWړl); *̾,8d&lNdm\norBNX嬯%히><PV_\\Z: &ҰUiZt	 jI|ZC0{\'yZvl*W؉}VZ3Kk]SC}H&u[U(u:u{\r}=wŃۭ\\Y_O=\0R\0o߿O/[<wS9K~e?h=\0R\0o߿O/1#WƐTm{*j<oح^%+LIm/(+Ys8:J؉%A$y3o߿O/S&]PkϾL5dԓ8\nLnp<)Dx	Sp˂5TŖ޿k\0K\"P?oI0p^g\"Y*@[?:bѷdȢx37d-0T_\0~G)y7̧re{;\0\r)\0}߿2_c:S/2K3 4Kg<{bՙ-=)Vhw,q+Io?`ߤ\07`\0>\0T<hX|i	Fz3yc9QlđTFݟ~G)y{;\0\r)\0}߿2_c4G\0~G)y7̧r糿߿2_#v`g]vx_UUXwПG}6ߟ9댱_ks}&9UAU$H۽s2m4iv0h((\\(C\ZGR\Z{+]\"&|1e@ڂYn|Tİz?6*)g^\Z#oۆ-1y{?O[L%kTVH9OAT.}uѺKuq\Z@AE>\\%okҮZ3Nh1E8Q[b߳	6CnΰF.u	nz/Q_ToHUԸ^\"b85]\0P}\Z5u\'iJ6w!01mm`]jScz<\\<c<<|tSm1J-`ߚ2>>Vf=; j-Z%S~Nՠ_Ma{A,b:g4f5:u:\0E?`GE8\rM;}as_V)V+3nJ;RDII:hi!w-l>[8yWN<l,P={%%}N\0tXΡ672iNM8\Z1C	jWyݜ=@R[32PGqp\0 ϡL!R}]Ei8΄O}ƐA4xc~7\n)(hY4[`Koƿ{Jࢌ|ǖ@j\rv]ˎ:f%HD\nX}z9Y=hIYRFv:^jnb1uT6/\ZfZVw\'z(Խwt`ϣ-!XvaS#Z$FM\r]V]ʧ4B>a;X]jGSd\Zs??֓ZhJ%(H.RXB#=9-REdl	9\nRr*RByW<\"Eq8q6a1!ΟǪ.PZBo&aTg;mEcw\00L \Z\nt:=l~tW</j4ZlcZU모=U؃m.\\Rj!Tp9LtkTihŔmyiu\ZL\ZsYkj`x6KQ0V9\02-,.Gqv\0:`g\ro`%Wdlc2@\re`	\"XfE>Mi\rA-	k\"+h9Dex\0D]i?urXY\ZSCqW6[Kmi6X*kn\nϻ<LDtuԡw>\ZmՃ+Ag\"f]sɶE&kQ\0GdVK}˥#1I7nW$B=ޣ~,똵u5\r.DDذE~Wf& y.f}{%Q;a\"NSY]ǏB\'Jܠ\0((|Z#IPh+\ru2,d/=?\r}dܕ9gَh1#E2	.JI5βE42rǾλǾk6qWmASL15wbm}ߌb\\ʌnl>X%!>5P\'iFMUJ@VJ(?P.s$#ߞ|\0GY[v>:@\Zˈ=x!z#*m(HAMjՄSb YjY\r[zM#iSnΞֿf)X(ǈD2CQ3\rRq\ZZa}>eEHH\r<KYQsz)F{Ibk(7=j8dŁb]\n}	4U۫}(kjIE:m\0h:TT\"(U_Xz_LٽrX.t}+-n[;jYdUjbO\'c#E@36Hقr(*d\\IlHbgXx%cn-˒`	p5AG<\Z ƶ\01e\"c#J)[@X2 5,M\0jbC<ޙ량$-7](I$liziqk3mc\\c9qzȶrb(\nMGRSUJÆҵߡ1֚[1TPɶY=}A?Y`CP8j9.ic\"`lIS$R8Dx1g}g\rGQ*٩,SkL)RJ_9DQƍn[Ioyi67u&h<ꖆW0\\ƥҶlz)Oufur\\NJHliƍވS5ꝉykyk*S_լ\Z=uhåu@]Zubj5Si+Semݩx@z?GfuUoeE]yeVnl]`JI\Z%\0MAҺ%3,VKc<<<12v[;Sk:sB^Z2Mz\'#@.M=h=|Z`kN-__Q:ʯP=:IܱnB(1tClxrȰT>cyǳw\"RwU|Ӌew\"qI+qrhuTaCLzGћEjrSYf3fetSCO	\nh)5j5X5.Y``1f$\"C10C3Ny=	V1K@MNKBV0\n$Ml 0(!J,leBk5<dȭ6$pH]5&|n\"V\0n+_g^3״ԾG\"\r[[ڪ8.IXEI^L,)Rb{\r#EׯE{b\nWxKȮUjdRƲt0n[Y{-K]Y5kbHڶk \'^\\ڂ~\0=K+<<`(o\Z^aKDꗑsmddgE+zڨZS5T1Ev\0p=\0&z/.#\Zǿ5bZXl#acO}>4mWP*\n	o7l\0mNsbxJBg#P28BELũhD_LXMȮ:2\\ \r^׳Sh)Ҹ$_4aT[nc\0l\"Hg2%|~C(VlQV@z~GM*5ށz/<Ыf]\\QF[{&Tx0dX8A\r\06^VKl=!f4Z2fe?#3,E:iՒǽ<c\n3@d~\"g \\\'V5	DBQ7\nb(1grF@${0kq0yfat,Őc6h^`\ZG;a&\0C\0p\0(H}]Yzڡ[⩲i8+)0VJBFT\nq֬,@ U0v!A[P<.k\"L\"i8vځk+E0ap҅)Z& FME>1@@.rM{|~4B)1[+,a6	u55[!_m\rj*5<Z9JYdmc;87ѻ=XFb,m~X\"A?l,K;n?{61?VJEUp](ں{P#v+5K+UQ,=2c¥9	QRySxB%>cqZ[\Z6&XϏ|GH]vTiB+({֊v&Cao?>>:=M\'a\r]bA@aRM8+A$H4Ąa#yxI6b\Z鯵Wm5\\fYXi0hHQ.]Q.g榲ՏuŻbԦAy+	\n%k>UH1O<r=L8+ɤ4ʰYM	eֲwM4\Z6r!Vrk}lWCۻC\\\r+Ih^GbRd],՛m#q+6,V+kV}Eˣ{Www-\\0ʚIk5i?ڏ6r۵S@x]fP1Ya3)ď9]v%?jڟ:L5{ݪ̏S\nZuU>Bbɘ8xvH?=FCTNQ5W\ZQ-nϬ0a9[˹D8*k7=9|yc!µ/	%d=R\'c(hh	LT\'ej!n>ڻԐe@Bf^A\0eat R<g:Is>O*(pg.kjI/8ő3\'\ZԔ9Q*!\r\ZEw{E\rȬsY5?Y)\0kl}y}͓dH/M[Wekن-DT5llSঠmeqfS<yz	od\r)68b\Zf1Ƌ]m<g}V3\0Ḩ)ˌ`(\r(	SIO@\0f[)x\\(((uΌb[*dAA)sK7|l(m:\nÉ]ƨ0Lt.各1\\ʭK\0aTdt+ǃJ:obîW-سJl\ncZPU*ϣgjq\n闥R\066S^UҳE/JBKN~qزY<Բ<kD\Z:bȦR4n``λqcC/(ʜqFhWǛh`0uNQc掅<Ya-ǔq_2h,C{{tIԫQc* `C\Z!@PE #Pz|<1<c<Vb/fФ\'/pޙg_wR][2ml%S/4ix׿@(Yh̉KQjQQ`vq=S|`s$$6<ٹ^׆vMi\n1,B*:.EXS1jD֞tSi(,st$\Ze\\1G<<gzEY:zg-UQ<5A&$B9$wZcwe`\"е\rh\rnl\nvvо=6@H<\n559*uu~mFS!Á^cѫ͹WH(kRxqBQI*,eק偀5K;&xXV*	PrdQa@OPXE\"Q)qIFz\'\rb[:f]M6,!~\'F,r&!)\r-y0kEZ[׃lڮw\Ze1C@;\Zunk)ٷVZ)єV]VR$6x&is1z\'1Cִi܆[u`I/r;1\")`Ah\Z^9S@1ڻ\nj\"`v`a%r]Y[lKֶyfyc3Xa#Z\"(0!	Xf_I\"=G&mou\\]g8T/].BQy:G+|JdZϖ6*g\0kf\0q/k\'Γ^\"M<]Ų*8˺vՆ#7*:n:ʟ:F!a{(GQvk k/T6&R|%IwO71dC?#v4,)W\0r8XNVH\0ȱ.Ɉxi|c}5#r\Z˾HBqI	m\rd0$@,1i\"8u;-\n;t&	#8<$WtIW:fICsXl`W閕t&#;\ZSm!&otV{<NcmE0B֪z}~حK\nt`3\"8tyzk[ZN\\H	\rPZװ[G\"F_̵\0gҧ~X kSlLWYg\n\n@~yko馚m8]umsks819=zf\"&fxs133GfhX\nI8A<ŘasF0\n4{LA$6C\0C4Q8ȿԀ\\.[[W۶T~j>7)Zɣhh\ZK\0\0/-uc]W9N֕`٥[:G6j_}{T07JDg\na(VubLG\\#ǥT5jGm[)FtuvzXW۵Y;$y֌kZr$wU_i\\JR\ZѮ6\n*T1N5w5h3^zqAKs!q?62`q\rf	yА͞M\"X\Z;C{ri :UjTH\Z\"`q1LSlC_|U$u2j\0#Ȉ\"mgy՛2oheytZ}h.7kVJ=픤&ڍW09dX_x?;c\\y+]k96Mt<FcXfLH{d\"Jg.{\0g\")5	8_([o]=ꎃf#\ryYyW<3/(*Ί%Gy]7casxyۮͱ&lhLkݜȠ)p6Z~ aNݯQNJ!6bQ̐>&g~Gڕ]8ꓴ!Ǜ6%R6gC+1cmO<۳Ǟy1}VXկJ_4`vzPw+4P}3#8F\raݮV٬*z\ZYX2&eP_ZL\0f&&9{\Zzkuf6yB.$Ke]ff8jbbb&?KG4[$SGIwMq\0q3\0}\0t#\'Wi$A$˻]qu5m3p!dI֖L|R\'\"Zo\Z1]eOyWV-@)FhJ\0qAx(t*Ը?GBbDc	:qQ/0$)We`Q%\"ablaUY\n6^V *zqO5\njYFZţjYe4bEeJq}lQmdlcLl=v}IcU\r3/d-v_zBhJ|ǲ	;+]>ҪڕIMNUM,5<1}uP)bZ5 `㕋?4&_%ot<\'oӥy]rrꎋ{baZ?:rcutvFu̩c84\'Z##sgU\\1}ab\Zhf\rlaVXs\'\0aē4Pž<6j]q[Y@eWZ/#\'u*,ӢwbSݬm)䑌1<c<<=Tnbu(Xkl¸I`]Y̅ 7C	/\"X\\9y\\?SdϞc*N\"|%dU,NֳhPfUoQ:\r#՛Rk|\'uAj&#t׬WX.;&fW-}i\rvUpeRO2·ꆱa#*\0htMM$}dMuMickk붻kg]83<zLqIfK̎Im6	#HaM}t$Y&\r`9u}j%ϐd­5e`RyJCU4wkPJX*kת[?*Pn\0{䃈M8ZhhߘZDR}OLQF5Z^MvS\rVl3!S.`68l`(k_V<2G\Z-UxZ(UC	|mD0ƸPc;&cIaR4~It܉1%\0l\0-U5lKɄ\0l:6Xe$sLIɤo}bxh)bMdX:I{뾛c:s3zm.>O׺;Z5\"2@6}rs\\s/k-}=#\"X|wsXuVu{=}US#\Z0j+*(udBI\0,5mMsbHFc8GlX\r<4*̀llOl\n	-\ZM$/ҵN!@Xn)bRZC+m]j\"9/gB\\l5YafrľZ :枡b\\DHz*%{}ZXcd\Z=Ѐźi\'іE?\\ch4\Zgh3{mk.l$=O\0hDIDp,!!c7ԿG`e.M45,&-&\ZL\ZC&1c3\0>^\0.MtJtP3Z͕!{O\ne삒aeB%BD r:)rN_\0Ml#~O``.&LrH8a;Mv]8ǽ`laֱ#c\0\0\"HȦDF&Hb\"\"ff\"3C)@LcBZd`@\0bHF&fb#0kS+]Ymo/%*t6PSY9z\0KlO*ZҳsFzW\\NDo>!lLP`q!x|Cq#]5\\|S[+n\'_Kw˪!r.<me%=2tT*k\"*vl),ik|S;/je7^,dkcI(}[*s4bNwrNfzVՊmMƱzt;V\Z;JgK}hbQlZ>Ɨk-KsWdUf6mNt45T:jVik%-[Ata,e%@\r?zLZmTLtZwIJN\'Df#Igi\"	4rZ2^DĠ:y+W*o]Gapo,![DKܶDǂ&H☭!N.\0k\0ĝlvQGn\0e\'+0\rRVP*b>`5~eŮ9d]!WlmRVV=~oX_גO;IrW6Fr~com5QAAYx?]{\0\0T\\х|Cӟ\nǮ5*o4^\"Z˅9UN@mqR[~\\\0\0\0~;\0\'\0(1,Orn<I)%0&& +Hg=&\ZK&t}v\n1{Y-o_Y/<\"&;jLd^1-+\\aWD_9pw?\0\\\0<%\0\0p?Rle2Iʅߢ1K}i~R[B`Y2h\\R-z!C#kCW>+UVe>Ⱥ3\n`@g,[kqgْu\\7NP\"\n?Ɗǝ\nv{V!U1<U-Z.CR]KZu:}jtCQZm5Me.a@F)u&$a4)c:vg͇Y7Bd_]+W*_\"m{X*J\Zz_ VxGx->n[R>̨2Q나<ar0ZpP>MgWCM\\7u:JX-u:}T\0DrSmqe0޽zݜw)qEݗ!qW򫨃YO|v<b~84]2mݧS_^hq!S\Z.R3ubLQ×GSf=&kjArqz5Jvٝ|./SXt*)6`&dN`ɖA[{m.Pu+VvIaNv=\Zӯ0dp\nt̌<nόyjMYkENat#\0~\ZETCHNMH>)9W	}X59	*s\Zm\"a7VǬR4PpQa=E3Y]WAW:ڍ25@={1~Ax=ϰ-:aYGY4!TlYzKｰ&.=M$~A[k\\dGm1s\0wu<`WX|M6/=}iOClYMWRXfuj,\r	fXed	H(J(wEŤoy#T6]kj%I,_$\")u\Z늬6_2wnm9)Wc\"6.5UYAwji~-ҳ\n8bfRc$+M6A\0ז`H]fii.Xܒ鬻,S!Wֻޞ=G-ʅ\\4kR\n+zWu7J[p>;%JNBVgc ln)}{;OׇLA\'A_6v3rkZjzfr,nK=`/f`tCar>mV$6gc.-vȞ	t+@|&νV	u$gk8t7yDXS瞣q瞦{\\ב\0%J	.\Zj\'!\ZzEj@\'ٌԩ<>37մ\'1+\\:Yft܁H_rmod&\"~EZmu-q(xN=/Η\"CAF*uцki}-!\naŴebiXP+Jh<1<c<<<1F(Bb&(h%xh9b]M}ssD0Uy;0pBeWU.΍>!.\n45A)5W5Cl+qUi]2uغ3g]Y\"HvLsCǆhW*XwN9lnt.\'ȋ\Z,=}a4!5VuS\nZ@Q$O1yՎueeOYz[zxcq8uTr:T˙g%$b\0v$qXTvГ\0BFszyC$@b(~W2V-V6ǃ)Yw\'zu>x:pHz+hI:BШt%Vj,ZeWr\Z]yticG|c:}?gvq}]A/sRO+	hK8H\0>lOHΛg:8e}*vX٩Vk_]Mbzi6z$3=vk\ZvP]b.\Zi9_&\0~,sqZ,yK-d \'X?N0h#\r/M7I.EMUZR]x\"DFEKGH7u75˵D{ZR	f\'ZXUT,$.%R#W#\'vΝm}>M*N?yW0HI-8\\FbNyϺ|GST,$g:LuP9qeT	*<z{ns{UfT%ǉaK%ŕʗL6/5h,;p:RuButGvwQsgі[NHLjP?oRT&il\0hD!rA,q\"K `sQ@tmvES ?!5o-\Zg~h=UevhL	@<ǤOˮ7X;i$ri龛g]69qy=7lt*C!QA[DZV^\'`!%`b-wE爌օ\\oBD8|hS+z)2fƱdwjDU2}l\Z|tAi?q7MUF9O>l+D^yc޾J\ZSvKh{\rAbC6t\r]hjWԚv[]^yꋰ$̥d\"uߕ4Ld#,ᅚT5z#WGNgwHJ-w`<;شV*zU23b]:Z+9RM$jsra`nO*v\0]5$PepX0BbO*M-Twz`#Vy\"QzC~e=Ah\nY3@y/.bߞX0-b|h5~;+kԎw]\\>c?Gmi${I5m\0͵8\0gǣi9ŊjuV[	=G82,=ɸ&<c]2(|f,fN\\[Z)E)жF%сغCظs%/B*!--VMKʇ}ϣcZYI>IܬfO_ky889?3k~A5ym:6|9F܍%Q84ͷeYt;k&̫xFT$:xMŔRe#%h\nؙx6dFd(k1l_R\rWD[\"\"3>b8y瞡qA0,d\Z@3b^ɾ\0aKq&8M1٤XA>\0iOzNkm/i{/Kٛܒ[aH\\\0U}sze,#%r.Nbe#S^=~5JR缬2ebe>}m5QFCNB+KZnjCAE701V[yl5MvAn::DfMjsHV\0Щ,1ɼ5JHW۴ವψ4S\0WCy\rj/n/ݯh\ZCq/]\nb5\0uc==*inzE\rrQ50`fxR#D0_GG/AUV6ZLWZ:dS(hJ15EÝtї3k` WR1x|ͳ\02SqW\\42V_.܎sǯh\rK\0RfEӗ2e&+t^.|NlǢ,ϦlUX\'K-:[*IRPiDћ2m\"t]\r1yycyǞy1yycy5_qVUdXW\n3GøfئЊ} b\")c:qfl_\Z$:\r1`tkTa>hu{mkwFV]W\'aUn]!Vg)vi*u\Zϫ,Cn6K͗@\r4\0\\\'焑tn_-uլtb\ZOz.ﶴܬ&xXr/j6qQtjOwˑZniz5\rwID\rߒd,vjȇ!ź>2%}Lv2*FHYQ:En[+C+5}I[>C}5	5H\0e\nJn<T[eVz$F]+vi2nCfR[\rHp-[=UD7U7[k}OUK_&5+nlԙ_60CC[~bW,ŧR\n6Bb:buryO5@p+=tI`{W]2._1\\1lϔaaEk\'A&2<g\0魛|\0]#\0kf\0q/k)\"\0Э6`0[Kإf%M!Ho9E8K#;}P&k腭lʻ_2#i{o)W*GryMєDěiw8$\\]]cy9Vշ%,(YUy9QtSح\"/&APYFr\"N!S.&Q!3jE*I,V+e\'z	[=̾3եFy \0cOԡow86qP\Z	ɬp@6ΒDi,Ri{붹3 0`bŰDLfDbDf&&&&br\r\0j\0lYA\0fD`f\n&&&br\rκM+hH4U7Rd^W,շ+TփQ)Qf9f!\"&Z	wl\n^YLhW}W<AG\rzLcdp^t*	uzJBk}\"l9\',%ʌ1*	`6r;-ÆM#d?tNMtviiV=qټ{Sqэ8J\rیcr]^@ͯdKyG-iN;).Xkp:gZ[-:\ZVݕ*~¨푲>.׭wB8ƍ[:ʑs\\U%\nU*\"]\n\\,y,GKثkmjt5u@*uwi}>:8b\Z;ww%)CK}u%cyǞy1yyV^.4u\n]Y얋3PQЧ_ÆSAYs1띷\\cԩCݻSojXR\'W\noV60]fǋRz۾w+ 	Jf+ˬsTuv2#C_oqVZv4vc˵\ZəYyI*:b׉;Ǖ.zccwfRCH∕\Zq\"LRtLM8hk]1Ji:fAƋEgIGLl04m!m%öE\0?mL\n~b3v^o]g׍IY[b	Vzq\\+6=U%n.6QUVW\rCT6e\'ys\'\nkھ,G^˃TTDhH+v:lg0Q%~i%bؑM/}I	Y$M}ܮuXuw6[f6+ua\n7=t@VI{qpAiwѶ;Zi\rEL\\KYues5oueo$2/Ӯ\nT+NeFYWYpP32*B*RJdb#S31ڕ+ЩVE\n*RR2R)Yb(dEk\")fgZչ6FX,\rz%0Ns\rz4IDb*wItd0U\ZMR<Q.cK1]Ek)0䘾S\"aU=t+Ym%ؖ hhr&|PWCuBEJǴ1XWt?Z\nUkd0&Ǘ><<1<c<<<1<c<<=2Z7\0&ZR֊˙.:	4*9F0#Q$)c=>c34ߑW-q[v6SS\0^/ުJ١U֌iH)PfwJ\ZU^y縷\\~Csm_:GS[8tm.Psqh|ǘ蝊t`+JHƆdB(}:%Û*vZeU3.<-Sh;\Z9c)\Zo\ZG.iEnMuEa]`٥mŴLr\Z\nA@{lW\03 +{@\n*~mSi-֥e6@Dk-084rv1k7ɢ(H*cEsn@|[ҡ}!UNlCz2<VD-K[Q%yqIKA5qo+%\'A4F񕊫v :V	:3HĤXl0B\"	qHťSh|\0:JTs\'T=O0qU;u]`G͔_}X?\"_Q_-67vdUnA-O0l5IWyJDtWݱ,g\0魛|\0]#{7Wֻ0l\\Icez[U|ƾ$:̯S\ZIp#b4M<lv[tN\0noteznanmx;({L5Nȩ\nBdz͵^n()54}1ߝ=7M8}lkkq3qcsc}^a_ϒ	¨NU[P<\Z\ZɺvIn4RW̫r;ݺAY:cQ6DU|ΕpQ\raH;YFbm-7\n_\\9v,UNB=;.aAuwfsQ׹=Mxk&Z{,֫ҍ9Zsv\rcv_;T_E2]!9\ZIٟȊ8IOZY\Zyh`HQQMDM\Zaa83Bw_(Q#Ǹѧ=x2\Z<>qښn,f_сfd02ȥBj\\\ZMdWM-}1Zu	1ͱTƲ)dWc_\ZIચkJZ}~jNa9Q4)\"I*Ş-SWV+cnvʦ\0=Mdd\\֣Y5*\nI*F2,<|J.^\\\\]9A͊[;?BG8{SF,Φiwu)E,JuǞJ*+C,]\r1fBé.,)=-J`,tCb%<Un+rynTKA/atV&YF|_ڙ3l`ix{g׾yB*]\"WUʘrAoD§c2v<s:-4,)+h\Z=70U;tChdZ~ڤZlBn>UO\0(W&e稃!Цw\Z9^;!\':(S:B+hK|㺚PNzo(fxC7C_qN}R-ԇ8ev5( %GdVsrK$Fpֳ\n}faaU%v\'\\%w¶!J4WFI\\,\r\ZH	\ngҡ)YFS6t^\'>5Uk\\^ߓ	\r\r-qQ(lͪQ&ϭ),,t\Zo5=Wwu==wǖ~[hVKܵ+?rrܻ.{	1@hZ5\0`Bs©[9!`<Zk%=ڱ!++Ƶ?\nL)$hoR݅@j;ZhE@:B6`;螇ͩ02ϙĺX ^?R}6\\-!X]eCLQKtTd&8amw&FCAv{\n\'n3P)ҰDC,z3&! XBJc*Q\'}uMh\"z\"V?Ǔ\07n\Z3VF})ol\r[tD2AUc\ZeezJ*?lIV٢PՅv4a*uAs+֐Ly\"-s#\\Z~JuӲlQ!*d\"a@\r\\zRJ2J0RU>%mWhט@-ցX4lT*+Էgd)|YbD薛|z\ZC5jo*ZϊTjN4{9Vղ<1<c<<<1<c<','vsantos',51,'Pentgono',NULL,NULL,NULL),(154,'%Definio de trs pontos\r\n\r\npoint A 10 10\r\npoint B 40 10\r\npoint C 20 40\r\n\r\n%Definio de trs rectas\r\n\r\nline ac A C\r\nline cb C B\r\nline ab A B\r\n\r\n%Desenho do tringulo\r\n\r\ncmark_lt A\r\ncmark_rt B\r\ncmark_lt C\r\n\r\ndrawsegment A C\r\ndrawsegment C B\r\ndrawsegment A B\r\n\r\n%Construo das mediatrizes do tringulo\r\n\r\ncircle o C A\r\ncircle o1 A C\r\n\r\nintersec2 A1C A2C o o1\r\nline c A1C A2C\r\n\r\ncircle o2 C B\r\ncircle o3 B C\r\n\r\nintersec2 C1B C2B o2 o3\r\nline b C1B C2B\r\n\r\ncircle o4 B A\r\ncircle o5 A B\r\n\r\nintersec2 B1A B2A o4 o5\r\nline a B1A B2A\r\n\r\n\r\n%Desenho das mediatrizes\r\n\r\ndrawline c\r\ndrawline b\r\ndrawline a\r\n\r\n%Centro da circunferncia circunscrita ao tringulo, \r\n%que passa pelos trs vrtices do tringulo\r\n\r\nintersec O a b\r\n\r\ncmark_lt O\r\n\r\ncircle oa O A\r\n\r\ncolor 255 0 0\r\ndrawcircle oa',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0C\0\"\0\0\0\0\0\0\0\0\0\0\0\0	\n\0/\0\0\0\0\0\0\0#8Wx	\"&4\0\Z\0\0\0\0\0\0\0\0\0\0\0\0\0\05\0\0\0\0\0\0\0!\"12A#BQRab$346FTUV\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\00,^;cg9b#OYglݶάk6t&\"ܷXU9IRDS\'/IP[0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\062j³uM)!UHNZXJ-eɪ\\TPa7k,X75$*0)*ֻXGBEs,.,z>\\ǑO<֓[|rS!啀7Nbc\0u)ꅪP^sj\0L2gNm.\")t*\r6\0!+UPqm]WK&6=n;rr%ùvạ̊Pt\0\0\0\0\0\0\0\0\0\0\'/IP[07kf@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0D5ikveaYMH:O&$r\'-v,}rZB.*BAt[);#iGZkoXSjd<FL~Z\\\"ߝPJK֮c_	VL5ViǺMwSYX\\KDxSESh,IV9lKKaeӞ#J]*dkЎYqQvK5:IFm-]Ĩ	*1H(lN9\nŻiSiuKV ii	Z2nY6Qh;pۓ.˷.e.\0\0\0\0\0\0\0\0\0\0\0\0\0\0N^|;ֶaD	o}(\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\062j³uM)!UHNZXJ-eɪ\\TPL? IYr-5Necr-MNi\'Zl島--NxWЏ\'a)t_yDm>HZMm\nvTmLV9\\ӫԤ[B[izcA0ɝ;鴺wXЫ4ڌc4VbBŷQu],([opȗۇ2UC~?#g{.T]`F.QKWq*nrv\n3;#SghnP\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0&Aw\0l(?_Q\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0M.VhvV$ݴl8tbnINZG rmw*Uk-MT\"$E\"6$yŭ&;*6C+n{ŮR-TK-j1\0 edΝ\\}%f<{u8U/$N7H4U:\ZւɤhAd]9_B<ҦMߏ`-z˷hX#QkJ8#v><[6PbQlfS(X8.ev÷9ܻpQ~\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0;{M\0Zم\'/IP[0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0h]&-n+0Ii\Zg\\pܒBYA>叮TQ[EHH.e\0Dsg,]VV:(8= TTkZ&~[;mYt}vJ57F8eAfye`<Әyx=:JE:j)e\\9ӺnKgu]\nM63HJf),[uUɲEFۇܜp]ps(uT8wB:fwE-/b-%\Zw&N\'(Hi 758zf+\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0wk\n N^|;ֶaD\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0MճnkiaV37l/WZr%:*6SS6,Kf*&yFR8v7Sbq4x%5~\\(M2YW5BI#3I:6Rɦfξ\0J3xYip+k^Iho*ht5I?JЃg-il,s¾y;	KL\0sZ3n*.i~FAi(׍7rq9E]F;I푩34}Xxm5U\"աhZI\Zu\rZ\n!UяA6Y_\"S8t2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\07kf@&Aw\0l\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0P:Zv!WaJtIج2[UZfq:\n_Tfmp/tLNz5]a[o޸aRB:ect<tfo\\	]ϗUloW$9x:*\n`\'{x~*+/}ι߶N1ŗTݳ(?RU(5jmNWY\'XD`LdF ك9I	w9n~:W-ZDuGmQҭmlQ!-\\h8y_*OX=F\0nƱo4rSf\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0(?_Qwk\n \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\Z#}U\ZWb~4A͊ UUVanwuN&f>g\rJgW$9x:*\n`\'{x~*+/}ι߶N1ŗTݳ(e8Xj<#p[b8ԻciwX-3u!4BWsk{{7\r\0ah顴C&#DlnrJS ݻ>[\ZGëtY*U\n\rM֠i*$kP錛80bا96A2uCN9ވ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0(?_Qwk\n \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\Z#}U\ZWb~4A͊ UUVanwuN&f>g\rJ@nsY5\Z55.#Z]=\'KLc~.7AFfuuZߝ{hC^kGslwׇ:m\"qgYldYuJy]2*R[P4uq5K(f	tM\\Db\r1lS :ΧyӜoFUt4;o]-gPMJUR\n)NvB,liygv\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0(?_Qwk\n \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0j,Vdi]UXxҝs6+VUVYk#ef΂W8Du4K]*=9^<\Z*5>\05|Ȭ\\n[:G~8]RWṿtVNz5]a[o޸aRB:ect<tfo\\	]ϗUlooFUt4;o]-gPMJUR\n)NvB,liygw`T*\Z56ZTV\"XA@C0K2l#lb?u;Μ7z \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0UF/p^a¬#+-Esj(?ۦ\Z+(t{,QĪQfib#b?9%cųV.?&/2cn7J#XU#dhЉ3ҬF>5G{=LCy\ZWQ`YĵmMKnf\r{4	@BU\"E@G}:hyVs&pN\n8-ek\"8|k5{ƒ=>2I:=5Qd\'xIIm00\r6_U	qm&imgZ=KL\nܮ}#^ViƷ%eĪz:ofcGƐ5d|^5}4%<7b\"ڐ\nB?KfDɫFo}(yWeSgpk$n\Zzt̍3f=֍pvͽ&-(J\09e*ecKxpjݶS8\\2YmSBrNcwpCs1y/|9/L?G\0\0\0ϤLO;ߜDn`0sd\\uG#θkX#!5\rUe5RBA*2+UlIP2?)	㩥TS/1Mމ-tL^V0Qt</\"bB)s3fEwQw|_yeXM	~nfsU1ͮ	1+.#j}<_5*\0iL\\|yFǕxY˥%mj\0Z7XVJ\Z_g3$V1)duvO[d4xvSI*_~&ڲL,LOq%gF{_v]T]NklF}7}O5MثeVen*\0\0F\08#PduϪ;#JBƔ>Xd\nb\n3Y-6tBN\'_:Q-k/ƺU߽pƥtKǤiy(ߎ.X[mHs\rhtTmNњ?MUdV.7W|_-slc.O+fQ~PPkp=jRN:Xa.ɳA-sd\'T9:sʽbtEvlIIJ7JAWp%)nE[#o:,Sy@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\00.gFcqw9$\\8մڬU/Qsgh6Ax[,PtI֍\Z5sc+<*WUqmּ]U2;%hZԎEg*V̟&l3yѯUV<ӛ-ߛfd1qѺ\\ue:#\\uo*{J:M\ZlTފV(]؎\0,OiwZJe\\V9ٱVTkLFWiΙ@çԊ=_9FSICqɐlU;r䃵䥦%,Nn~vY٫\r]٩&=zҽXNFwM;-+Y͎z9eXVb-̿5}~G08jծJy\"HhnZ2Xgܺ-Bg*,H~~o\r6IQ|u\rhU._LWKҵ\'z6Fe6;z/cR1STY*E.v*ҭqӎWtx\\/\0_Z)fzQν쯚?o\"d<}\"ʱ4;=jdO*Wݯ}Gg7Rbj}lnu˵m3ttRn%ahHmABgY@|\nv\Z\'+fFݲ%?FkGI5i*{X88n\0\0\0>َWQNzb:|էWh7LEPnf.+ΤwhE=(cIAJbZiRV١#5NtIBqi۩.]L$$:XT%zdǟW0ѣBEzI\0\Z3T[E~)HIvj+l;TOLn:ffсb\ZZ^]Sv>ə[bV}5w3qsY9<jr~K)nKZNٮ,IZSg~*<ŧk/$j\\%it˭E\'^fe[	Im2EIL\r/o|UF]aW$9x:*\n`\'{x~*+/}ι߶N1ŗTݳ(/EIuS2ײ:̫b4Cmn]<+bnOnSNfXľ궴6jg^f\r̻qF۞nݿX\0k5]۸k}1j]GLzNǐp\\n!+굍ʽbtEvlIIJ7JAWp%)nE[#o:,Sy*R[P4uq5K(f	tM\\Db\r1lS :ΧyӜD6\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\02|BLQzjtkD!/`ioju?1}DǳuGIrei&J2EFQsiZGP햆JHMT3Y\"9y+;\rV(zt_%LJ+w)\"ܦ>5[hh%/crn<pw.M7SlY޸a,|[~pLalJbB~0rf*,\'(G)P)R6##ټH4jАNeR Dipk%JW\0>7?DΫ16]+/?0qwTI#v>g-bȓiƭ>_~hr>Ѭ𶸂=D:̕zOP*TPR\'{}q;mLMG*+hM[p3񴴮%Xyq}<U-3Ol6m[êz!騷E;{*dM2E>OLH~~o\r6IQ|u\rhU._LWKҵ\'z6\nxPU__?iTMt4b+ߡZ8\'OEWVZ̪B.-9s\0\0M>hFGxw<61R4ђq*_G˭-^3r*eTAdΕDbz96:LMBnNzD!=l&yY\"+	IMhٳvQă\rRa~UGkϑM^DXԺzbTk-!GehʭA˄sg4ji\'.!<.\n(gݯ9hұ~Rbj}l=]WtU΃oۢt(,D]:E$+i\Z#}U\ZWb~4A͊ UUVanwuN&f>g\rJ@nsY5\Z55.#Z]=\'KLc~.7AFfuuZߝ{hC^kGslwׇ:m\"qgYldYuJy]2*R[P4uq5K(f	tM\\Db\r1lS :ΧyӜ\rG\ZEkk[59~sl1>X)vhg[uddl,^t\'솿SQ5MT\"*BMD^&r9^1{Ҙy(k&JERTMT)N)PJrLSs1{w{6\\0ۃU}?\0{nRd\r*a[E^+*-\'jY|>n>GTr7R-YyXDlVY7ߊE0M߆m5Eqsv&UӫE~O$58x|\0S\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\00lŞ<C9鯐Y+U!\\+B!ΨXi-K+:qq4xo\"n#9sX4\nVQINzM\"f9OHF#(vC%h$S\0*B\"<B?QezQ~J2-\Zcq\r՜tHOt\0AhGʱ\";KX}պ(+Ո[,x%>f^JiUjj\'\nJH=)V\Z8IieܼlO˓vt3#hhfP\"&w*5MjBǚ@-|Ox~Zt?Zc<a Im6~:G[{\nS\\2XNW)SIΛ̼nOq{/ï4*?&qVaoЭ֫L~Uc!ӊ8L5h?3E{vg%!dRzT\'Whr^*;ptJrj1V%$\ny)ɉ%GDD6pJI2nKJ(\\n#9sX4\nVQINzM\"f9OHF#(vC%h$S\0*B^Ovs\"h]\0Ɋ#lƷ\0[upS6HW;]9*&f˟^e^%46KlMw?C)9\n]+4=}+`7]q@FجKr|lՀ<:\ZUa-TK`I^VYgkSʇQwr*[d:4Q *J֨HZgvgFdyDZwTphL7YSA&TG,ߑZLʿx3&\\X\Za:yJ:_n82]Y\Z˫R%y.l\0پhv\'޻GM\rZ7fΡ$$ctwR0Y>]FE7Q#;[P*WIJ3݅~2>:mzk!HY(\Z=`bN\n\rO`9ltܜ.B{+$M!;DV.+֚ѳgm:*\Zx\0\0*&;!m=G\"ͤpkD_*Ԛa&F^&C])6A=r9vuQrԍ}\r^tt\rnZB\nJ\\ǷYx{?=[J7~m5躿_}4Z|Nly=zkFXnգ\nel>\0qV\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0p%^<徶OTni݂uO೧g7ڠQ4G%;v&C)2\\NJ ǋ@\"G?9ߧ]g$G1tȃY+c\04K=N5W]O1LڼaVs7s޵xܜ)xU+ſn00ٙ\"uo|=Z??3-ʥ)azVSܦzdLԿO͈ū0[\0mue|Sy7!)TUȩql\Z&DɫK[;+\nnFY:17$PVa#y9kϻc*t&pqRITDsg,]VV:(8= TTkZ&~[;mYt}vJ57F8eAfye`<Әyx=:JE:j)e\\9ӺnKgu]\nM63HJf),[uUɲEFۇܜp]ps(uT89GNs7[\\3V39ƔwΌZ+<}5{=ژ!KļiR߼mt.vZJ\"j4)[I$Tl5g6{ehdtA5!_Q7kf@Sev5Xv|2q*trmĖ[ɺtܹ7g#\Z7V~7\\J^V5{#``\\3{5(Ԫ޽NQbfq:EQsD1]]*M\0x^W>KXز$|n~ɼ<:ϽmcфepK\ZH Sv^|c0%:S83Pm::^ϛ^~6\Znմ(L@IF13}>IOח1Qz-\\>1jQCӢ-ZdU[I19CG-9̷{tヹrnV6e^oZF*|eN..s>kl֧։.7e鸃>#C7v\nGΎ9MW\"o38z{.} S`o|ZǲȆ/[Cvޙk\ZO=N_׹k>*ZiXL+\'M¬Nfw~%L~d>ϯo*\0\'xE6ܓ|<_rDd\'Q?fKV_gUV\0N*\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0آ,\0lE^IBhE:\rh_G[$ѧYaZ<ҝU؛nBˤ\"%rCJ	*:򖿪 Uvn!y?ţ_F.崓%pUY#ʽ**0fF,J(:H3tQ\\͢i2>oWPSg?7=9HelS17:|sn]jE]z;MSzF\rkT\\o\rhXnWp۬H<2o8O٦7DW:iSNZgҪ36EkM\\ϋU֜3W[mKBJֶB\0U+5[_֌Q׳,<~c^ο\Zǵd+ȚKMkj#QM>#6chGS,]E\Z\\^6Tw$fwCFLaݴWb\"Bڌc4Vl4X8.eFۇܜp]ps(uT?M{&\0k_h37wkZ\0fwoֵ{M\0Zم#-ϊ~Mo8qΊ#r+YINHQUb4S7\n^w{&\0k_\Z M\0ֿهC;\05\0t֚vXJ^h5MLv~=L,5d]JFrUJd6]T^<s35	9]WyHBwkg\\%$W5f1uGlT5I1mVM\0ֿىzjDNKxǦ%oƱRdvV\\#U9[TI?p.Av@QDV\"tlKyɩwIK͹.7Rl4bJu䴫qRY<kU])6-7NȮkZ:k/.kfr;\rIe^WQVQ֝GA\nHoQPxrv:䜧g-a\"^rafYCZڳVVme^s~gӴ%\"&Qv]y)p+v\"hGN#JifHOSYjWTnf*v:w<kܬ\nѲW˟乙g]h]yng٪kn鯇|BXs\'Mb²i^ͼ#D6ϛO7[Oev5Xv|2q*trmĖ[ɺtܹ7FNHް}G5I*$[\0&ugZeѯ\nl\rkXY4W%cP	H(\ZfqAOߩ-sܨϳk<- Q)%d ޾j\n:E#>rTuGIrei&J2EFQsiZGP햆JHMT3Y\"9y+;\rV(zt_%LJ+w)\"ܦ>5[hh%/crn<pw.M*R>twQRoɝ~Yֳtk.{Z=D7MUz>@3Z|LkF}YmqzHu+!TU	(󗊤N\0v\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0&v\0\'=cqtxGn\\0qv!2:ZfCq\n37h˪67Sj\rӔX<~xwTt۶\\2Mr%I|AbXZVRj^PPkp=jRN:Xa.ɳA-sd\'T9:sʽbtEvlIIJ7JAWp%)nE[#o:,Sy;YF)]O֠tVS4B1!UoϒporLl>CD-L ]W}oUī2:24C+DLKW>V:]W\'q5wQz[N{RZUnm4=hlzdbrG$jSe!3iuw*4ҥ)H)AX՛B1vf/cߵUk`oEk,*SR!nk$vIk\'VEz\rC}\'I~\nz	zRmffBtۡFGvv˛8pr\nQlĵWM`ƛ1~\r-~:ʱ{\";՝+=yKp-\\UYk	y3l͖x41(Z<,]^zjh˯]/M_\0V;\0\n|%jf*&\\FAȳC:]Y3vLDP9O/yj:*ꮍ02w11=Oh/nǪmFڭ,!벷WFehh8\'xۆ>l 4K\"YőDITJtL)P)r;tPhro*g~^|;ֶaDMfw&\0«_M_\0V\rqW\Z~U[5VMU\0RQdb v	dH参g!1$8.W16Y](bURDc\",~l\nA\'-04۪ȫ6<t[V[FzzJњh<97~wZ\0X0Zm2*>p7	g9H~6Q$*HVoRU5Z<m_i#{ǫ^R]uH[ZkÈ=GYKm<s,dzERs3c@Juii}^;TAnv/](y7N秥]=zba7lG5O7Iq-B}+5lLx<NcO\'8O%f8#B4JG!<b^KmUb㜷xJyP3fwgFhqPftJNGh(X:|uQGb0UTUDXTEUXUUV#}nNlFlv뮵mǖ{,ٝY٥ffd\0\0\0\0\0uGIrei&J2EFQsiZGP햆JHMT3Y\"@)2W;Owv\Z;TPKV8pV:REAL}NjKN_-d:x\\y\'`|X>{-\0:?ೇg]r6ص{,n\nz\0EL5h?3E{vg%!dRzT\'Whr^*;pvxۈ6\\\r4DiRSFHټj:m+SZ	ʃk$B\'3/%s|waõENiWn$T۔m\r~$\02n^6MӧɺXU7v\nGΎ9MW\"o38z{.} S`o|ZǲȆ/[\ZfqAOߩ-sܨϳk<- Q)%d ޾j\n:E#>rT\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0bX&~VFXNk/J+fY05켑\\dPlʭ*Q\"ZDrI)Z2_SZiyK\\z_M)wf Mqf#.(X,u-Rٕer]nUg䲪])ݯش<W];QR%5;m9QU#Mm<!V3n8ekk|Wů&21:u\\^L^= 3xI&dC\"p}Zgȵ8DNcGmw2\'V!Hdc?1PxuFL?z*}I^Dwosϭ{=orߥGlN>?pq\'\'?q23\\K|gudi[eg	pq-deqZ\\3hܚ}v\\G! h*Bk8MT)XoC&	y[zznSd:6gFz0ȧ,#69TՀz2[]ms][ߔ-~	n:Os3_t񸵤ճm̭\\\\.\\_s#_3r\00\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0uGIrei&J2EFQsiZGP햆JHMT3Y\"@)2W;Owv\Z;TPKV8pV:REAL}NjKN_-d:x\\y\'`|X>{-\0:?ೇg]r6ص{,n\nz\0EL5h?3E{vg%!dRzT\'Whr^*;pvxۈ6\\\r4DiRSFHټj:m+SZ	ʃk$B&ͻŊޙ	sz0Pv\\\'6BFf HJiT͒}\\pYE\\nv\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','vsantos',51,'Circuncentro',NULL,NULL,NULL),(158,'area 0 0 100 100\r\n\r\npoint A 30 20\r\npoint B 70 20\r\npoint C 40 20\r\n\r\nline ab A B\r\n\r\ncircle O B A\r\n\r\nperp cc C ab\r\n\r\nintersec2 A1 B1 O cc\r\n\r\ndrawcircle O\r\n\r\nline ca1 C A1\r\n\r\ncircle O1 A1 B\r\ndrawdashcircle O1\r\n\r\nline aa1 A A1\r\n\r\ncircle O2 A A1\r\n\r\nintersec2 AA1 AA2 O2 O1\r\n\r\ndrawdashline ca1\r\ndrawdashcircle O2\r\ndrawline ab\r\n\r\n\r\ncmark_t A\r\ncmark_t B\r\ncmark_t C\r\ncmark_t A1\r\ncmark_t AA1\r\ncmark_t AA2\r\ndrawsegment A B',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\01\0\0\0\0\0\0W	X!$\"#%\'1\0\0\0?\0\01c1͕mJwk[(\ZȒ`u2f۪U	~MgLE4{1c1c1c1c1^z&4gWPIZ_jPJ_}Me\00A{L)aи\0*KՌc1c1c1c1dh:kzӬTZWv`(|_jDoiCWw\r,|81c1c1c1c13Q)Ns`\nfabߠ:ik1r5ښ9U Md1LUZh6Eb1c1c1c1c\"96S;iB2ҝ]-hjFb`Қxx!ia1c$8<Q{_ҟ9Q߸T3}R5Ddb~YBn7O4ZE\0=>eAbxOT]oTjK>[é.2\Z愤Vc	fv%-??x=8{^zu\')HXqNó+xf	v4Iw]toc+9`dBPC\"49#Ϧ@ŶMmKG&k{{1c1c1c@x&\0VO0p5KD#̓t87b}̋V{y+3?R?:/C9uո蒤a?Υ-t}BE&\r?\\1:oMu$Kx=abɿndV:Ƅb(IC*q]JTmNЭuSR)\0 2U⿁ii5Z&&\rh1AC眧r$׹?6Quv!9:JW堀I~1E\0dGӓ\Z?Gp?S),Gњi,_f*_տGy\0y6NVҢ\0K32)I\"H9]?kC5MbZ[+[_Uq@	&S1\\ץXAaĬBȐП|a\0,wXN%ٯ:^mgOGWpC[.IgdGzmK2&b։-gAZKnu\rl\\O>D_L(;sQ_Drž^r+f2ӚtZݏ[Q4{X]2XW<GUEWZPn1c1c1g/s9eӠ+tzMEŢmvÍ`>\"\0.245i4n[}d$b)ewN;=:HYuε\\ksO[ZΆol6XQRʙuz7s\n	o\0E7;i.)Fʿj9<I$sk\n,sd+j1dk\"K{@?7ocQHXoW{`\0NQl*j1,)h#3Lq-2?&CJ2XJ<\0m}\0׹KRl]KmTUw~r(wv_vAK5&85E[;n{.QhWV=_0֖ݷ.s/uNWdWآhBUc1c1Z2*.එb=wXj\Z\\߬[ɢvRNƒ-Q%z*/+xJS{OAg.<*/zrR3GvtK֯衱-_Y6\ruڊ1cMUJv+4/F3,:k|IiU_$\0<Lƹz<c2q98j.XM~}=S꽕TʢL-eoM6LRrȞmkAdݽLnUl>\\-I.ov${^!&7di)%=iȹo::\rc1c1΃|\ZW2lWŁL9J;2OXWj-.\rfGPtͩ40hmt3-ZNCYlndЀ**lȽPR(]X#P1cP=ҪkSmھ܈8FGd#辩=(ar\"R|/i5!1WdLEj1cddsE>%|W9P-}֙51`f\ZflܞL.\ZLZ:5Ҫ\nl-R2GfmwV*F3PnŪlL(Xzc1cgΉt\"!>R{5$OWUPr:Ĵ,V3\\]-U]m̹*HTE>SYrKh}Vټk@,\'X\\YI3qaSkY&v1=IRmqc1^+J3PcjQtbh{}It辦b[nDR[A4L?|$ηJ]MmX1c.z:H9ٯK[ظ5cKf*umM|HԤ2\nhV\Z#!	c˯@OǾ{=c1c.i޿_Eun;Kj|49!!g9mW\"` vS\r6EѼ~M\nnwI^NYX7-X Q\\diю:c1domk2/qYE(Fw/獝J(\\IX/K3f[81c̨2Wܵ`[;oZ-SVɣ%@Na\ZfMJ%lP6Pf/\0\r7Gc14#)KAO<0$ɿqy{{C8KкS1ڥ˷f<×b,fҾyv\ZHim	9NR4-1c_\'f8k+нA%.]45@\n\ZW{&ɍIB=c1c9}J~Yh$XW-t,cPz2=v}8g\Z_I<O}}7]rޔ۪r+X[se!f\\b2~q\05ıHSfQY#8aұd\Zc1ͽ*nWZۄ\rNtO64ٽWSrNЩmj,;0m$5Qc1dWC[JOYjRbr  YȋuKm^Ԇ\\yY31cwx7Vhz1\\uֆrY/VHH1\\H~KNPY\\o<DT1c=F\0RZ\Zk%&L	 ;aN bLGǼ連m%*Ԡ\0j#ET.VhWN֐ZB0B\Z3WU-@6=v<jp^c1dW5ZHjQT$ %/G/fCmid6l\\\Z_\0j1c1nw$z[(\'sKLFi9Es+UB\rj2<6\Zy1c\0UNF%/{p+~a\\uu#Ukq_En\0VSVWP،ľ馑qqǮiikkkkyyygc1c%\\lu$Wzu^014M0:C0s*xw1lbIqc\"]^\rQdp_Or\n.q؄ˤ1_p]*ox,#E,p1޵oMO}D7H{sgSgG-߾HWXsi/Eg6]Hk\\r9a8uN\ZIu\'I\'}\0}OIjP˴.EMdc*6m$8|\0Ʌa9km}&/\nM^G};im,oo>\ryEQy	|mG,2G#iP$U~7\"br)\'&R5&y3]\0˂M\\-\'\\˦{=߉skf=x830_NFB<-|n0a٩]._ҸǇu|gD3ڲz_+[ߓd&jKMxםvnOh4WPu/$Ա2VOl=\nz+Cd{>3&Ab]yQqUЩ=*2内iGnKy4f@M0m;c@g`L՚\n ߢ_흒jKy_ecuBLwƯ\r\"1c1t`Kfns`C0F\0нAU$adJ6ZUlkqXS4T!&\n&Of3\"3}}Z+o-J̆jDZ\\V=cz5:hQ8^Q=p=lgNrvv*gb?f6bҷeߙ\r5.nN	]	N\'NmgG5ksG5BI~5U\Z{Cipr\"-JlXnI2vc7qk:0Tِ!\"sH\\sKJN,TgYQ?@Х?BF.UKt\Zڴ^.UzzYԈ)\'I8b<<O$]o=&}#0]l@GuZ[\\߮(u^zʱbQ͋ԞXM7\0KQ{J\\v]gVEAm&<Cj\'K*uHOgV&lb2`1AdPyw먿eEK7?ٓ?R:0J4TSzl`\r\'_D)H<wcV{<6j/Ť|TZ\Z:11znǫd6\\y@9s[qc1c\"\n\ZgUMjzͻWғ;}\'\"D[[o%&0F*̀bɜhY%B:]s=A&Je$V[yP\nRHn`} g|(XBGx/eKh|$l%$ |)<Zͯ/uDIW+  XDH\0** UPjŠ\0`\08Gzi1cORGʩ&BUy-rfSf7͠bLVVK!<M%6dbUL(kO|9M`yC\"-]p_DFLvΫkawmþNMvݪ*W$I>W+?jJ(_}tw+#(wgO*}:$/Cs!:k&x\0\\y:Bzb!#E\"=m:0,;*k\":}H\'e1zj5i&{ok1c1:mjK]YRvѣGjހo9wS:v$ccl\nfLE1$]m/Dz3	DY4`Ϙ|챚Yۯ\0Z.WZV3Zg4fAey\nln1ϣ^/_s$Z;fjZ3Ωk<ދ6C*Hab~qc1JU&PKݹ,<_.ZW,W9a͖ovpt1ZՋS>;͚t>pcm/e6R:tl8r\n5]V+54n=ګy{\\ڛЩ$QԹ5+#\04a.,L֞?X<ųuڿN<Ns%W-Y.$Ͻ[7E?{Nٻ\\6!H:fg>Kb1d8^Ս\';\'D\'ǨtkhQTIc%ɲjhV/gtJ?td\Z9	[yb٠qPzsmmE/!1=Ukb&{\rC+WXoкՈ6\nkN*Pܖ\\s)!p9r<֑},u..	1k^jK)lfH~*F5`)k2}ƒri\Z-{\rRr,J+OxwgGm\0z!\"9Y@ ܻ򚕅\0[V$ຶIߕtnvJG6*3԰oCgb3I,˟st^9-s)V{RXˠ)\0}P\"+i՝^4m%~tӮta?3Z{c`%{^%aQ9H4/=¬5A/K\0Aܧx0\n\'=MJA	9ĔYM_٬nI݅rv뵩Ĺ[lY48Oh1c2	LCwZN(\nz$Ek{޷Y:2-,eWj$yPPQPc3o⮮(\\7>.AJ\nO\\F	oM+YԈj8?oZ\"R`\Z>zg$\Z;%2լZ1X%²X-8k[,th$C>qX<z}X\'8/Zf\Zk\Z*B5n8c`o	cdDQٱd3-3٣YP+ѣW\05L.\"wPږeoL+7K!+wv)_\nn%3\nջ|VW}،8PΡbn\"؊\0S3AZ\0F.ܖ cSs^\ZfD1)r^CMX#1͝>_2>!ʼ\0V:ַ+UsjJ]sKӵrӯ,9Z,֚]_ڿҸwr-gv1HGtq\\Wi\'?1[9(|zeJLG&ٕqTA1zXٻ+VPm \0*;;?vgiʤ/V;\\kWK1cBiv/;s[@\ZMS.Sg\Z9X]emWb0mh6\"Hٴv1dxOl;WCz\ZS*6©́X쟧`d1Sj4d\\E;̵(+sme9ж[5ZCQ\0 Mb\ZƫYk+\n[1E\0с]V2ZR{BZTzAa2FƺɅΣS+z׮)-T*7YW91\n~q[[_!TyL8m\ZloZ{]Hn3og1fQc2:]ksWJ*JH;5?dQ-ATx}o5e^_en8~lQ]hh=ca}dzNED ;\'	<jɚs:#a+a8~غ\'Pbf}Nc3*;Wc|,<_S,qCե}XOXD3<n{}u>f6`_qBOxb΂ϚDi7Og|1Yɻ;=kfWZK\\P@~#CwOQ,\'d,\Zn;\r`YZ1c1NY`:&/tSQ+4	vM\nfXb\0mYqtZII;^1c\nWSDtpmbGzWv[jI\nH]:/owmvXGIoi{믞yy 	i=2؋|oɑTtZgLLYOk0&_iT:DX\Ze*_t1cxhb87l(zmR,mVuMu%ǆ-^k3 \n,=ER\0\nHS}\r8^uoarPk|\'K8veu.N)^\n2 _tYfIh-TZ]hXU--<E*\\JL\'޵ZV[YLYQ\0$Tn!ob=YT^QV1cD~azo@fۢBgzy!P\0V^}pBxXx+h|M\'?1-1Q^~9bw>B)Z+&07CU۶\"E:j/<8S-I	MBHQ31\\{|}4_+GMnjzdڬg w^\Z/eb\0ӛ&\rO=sVZuGI%hb\\Q\0\0G@HP\r#aF8xc(bH]5_=c2=ߺq<{/Pkr뷱:7+o::=XMqV\'<Rrx\'[et2nS0_M	16	p9|FL\Z]Hw.X\"dKx~>FvH-u=;BE 2Yޣfwkoyxһ9$>D!uR\n=Ϧ.g8$&*K\rPs8v{oXj7*k]Y=sh8o|BfMOu=gAcp4mКsX\Z=~y0ОE]<0,\0 \nI80w$ys\ZW>[ܛT;{=6,[$IZ2,(\nbmn1ÿgw~ngPWLֵ\Z/<Li^,=Ln墂?k:.|H0	zߩ(;vӗpjHk2s:/k>|gm{+UC:;WW+oANRz,}HT6Ynmy_WC4_^罡L<j>= \">*tcdzu?O8m\0Z4I~yj<VPA\'j6[ܵz&Fx:ȔuI{7fbi]}M]samX>Jtal\0#l30T,ϑ~at=\\Ut	׊EKF]aóD^\ZzD%:˘7O1>XA쪗VuoZl4;6D\"_j\rӸ/ąu1c0\'_K7te1\'[(mQoNs x*0mj,o^0e%K t\nUvt;_g\nTn\0\nu9v\Z]j_LWꪰºsˉ)z}qH4־4??7pޛ_Zè:Ձ-ͦl|\'\"K?o텶P\n1\"kiNYlk=Qc3&疍{lH\02=%4UC`.b6*i16_)\'pXȏϿa?{?\0=_w~\0/ֿn~\'\0w\0S\0/G>ǮcWG_AH-۔<Ѷ{A \"A(̓j\ZPՖ51sCрB\"\\ϨFy\'$0$2km1c3\'OUt^~%}B>KJ$?Y\"W;=X?Qyu5!Wu4|E)X1c>S穪lLK_bDF*)3l*_u`y(68`I7uüւGsG뾉\r7u=OYMrCB^N|\\P=)zF|٪*!>|c1/:Aw~0;|\\cuFIeO=fp#Fkm{O8&arkF簝Sk+\0ҽKiȏϭoC~XW2ptjO:V/%ىf;\0\n9&͍X,@FcBUzL-Fe]Xq6M{7QQd8Myrr䀗࿋_,<1\0c\nԩM[@}0\'WuC2atլ@Du\'<\Zjuj0\rsjJ}.XT>%KPj55±R J$P\".I&Aoy1c MZx˝lT}E(LaUzFYӥz5H\\ⴸY-;FnՄmYպPHM9v&ubI	>8>FxVNҲ}VpEq	\rWdM1c{VXZ\Zv6\n9n	i~kSwxflfMiqriн7(0~o$Z6wG]ࣛFE<zTqc bTIۼv*ϊWVJQ[z=WB(b7>%xR\"c}M}c=v}tM|mm]u_=m<}<3{dpĊWY>p]Zp=d>}8>*PaXT4i˒nc2	ơko&7+\'ح/ILYĉ}[I!/Eli+{,Gѹh7*{^TdN٪XOb4u#HJ޸}λh9F5wnʷeR܁H^,>PlpChr[j8+v5m8F\Z.1\rykzĠ.ջD݁=n~NO1}jjGFGpTX\")fϭ]SkZ]x)s!p`wx=5@6)U;7IUj)KǑQ3q]&Tl\"ȾT>yЫI{Vt!e%;b%Ujk܃42O^.I1d#SQ8\nE[Um\ndi7՗^Qm`<i䢗}\0A4YrDK1~Cvks\r;ٝyq9\0$[iԀ&*.rc&p/iѤ>v\Z6)w]Oh[:ж6OB!;%n~)hPs\rS{S~1c0ZW7pyXm>uPο@6 {\0eo\rbhn!?YZwW{?YZwW{XӃנv?;Q[?˝K۷\Z}|XE^WD{I,]@3As)/:\Z\0Cvߝh-\0{ɯko<=gͿQ^i]Cti,0:o\0C*1;}\"s1||eU[O$d}<x_\0#@Awg@\Z-aQFDqM\"(X]5=	\0\'>8{ggu˾(g_}\r+)Sn-T7Xt;rkN\0P<A%d)=܉\0P\n6ݾ?&/bUY6d:VOPt/Hnc`C׭ߝ6U?Atu;;Gώ?^\0bsWئ?d\')	\0\'>8{gcGώ?^\0b{_zo_C>}g`_vFD\0\0~>HjTqi5񫕒~6j֎sWئ?d\')	\0\'>8{gfjYǹP}\0Gah 8.;7ڵzvކSUyh\n^<w^{T\"!R\\厝sIґ!1v;|\\t0daFMQ+%fZ|}S\nh+0+Mĭd/{zb6rPq@-Ǽ]ʽwU~$$\"؁8t¼(ծ&_`ui=V:.&棱#/C$p\0>AZRշXdcN#F!,=1_FD8\0l&DV~Yfxu.?3%˔4r\'#%-M֡m623ڐ𨫫EپYpʗ^k4l0[\\MCgf# f1tk0WΜUuKݐ;]RB \r7>]nD\Z^G>\r={7NzJo;զxMJ1Dr\Zi9lxGRQ\"\'\\iիU4uHx\0!b\Z;>U&iھ8,$T|\"\0\Z\01cC>H=+KYUqӕׯ{]q2w]\'Y?/ڭ*k&YU,MŽ\"Xx	YauxM=I#MMw6|sɌdAT\\i.EH=/\0آ+nlBVD</?uQ`NW{Uζ-1O!6SR4Ѡ`l-IZʪ[KOH3,}r9YϮXJe+}z/Ci8l?Yy\r}I&5>17ڋos;WxrM?9:às*6x`BE\0l\"	:1S:[~>-iB\Zb^BꅉÔ	w~\rkƄ9\"hR~|@T|oX8QW>t݁QƢ%Y_PbG|HJ3\n=үiTHo\r~DTTq6MJOȢ,aʎ9Ј\"](\r܎VUܣ补pn]Ni2~_CՏl(z^q8Fi+\r96r*Z.y+ibv\"}%5FϬ/[%̬VgǱ}`h#1c19e	Mehe$Xm$M6M_u_}o=|ȗEzizrBkdNm)d\rVKz\'.&W*R\Zp;19G;T[]*k=<E{4:L,W\n[+lB+d(Vt[^.\0LXvP\\66*#\\Zw\rE-8uv\n\nی1DcZMݼ̮Dv|Ӱs>.oqSg)RY\0i}H]MJ{Ez֝;5M6oi93<:&$\0s;; giBVkZHAgOy$^{&/ΎW`o0Ez0\\}%ms5P.9;\ny	\Z\0EC0X1U@./oe竌HuwLQ˫#5Zq$p*Yn3i#8V*P`1\'`-igkތ9DTM/9i0V\0Sq^\0l6>F@>KZw3oWv\nz$?OW[8u	5v\n)T2o)#aKԺ<RO<Ұ],>O}^\\U^aQ9ߙ>NgY9N_WATdڿƐ9OI{ۉE7)(:X}h}QkՉz<MPKaj稦ݩ%T3LPdoc1c2 _1?\nH8딒5}Fe!F0 vw4<&?Q[~1c8<@v#=/Wi#`|1Gn\0 ZNQZ\0+Sن`٘NwqH}BЖ܍ ydWW.Ÿk<VFrf3攟7g:EIE~D<LDWhcMxmrz{fA}趟&[\r8>F=g\\l$W{<j>bXK,B@yʙ[8ZNExh}5_WҞU0ϯ}O[?VM6acu6DHAQ2\0K9O.E0ŮK,kzk{<We]klZKTo\Zx>+h3\rZg[ld^MRI;XgJ^ͥ}qN:_Sh._>iqr:xK (T5_QXh\\_-5V`jLs3|9RsqYUPW+EH#E3nĩdBٺ|71Վ͛燰pH1c1cL;77+]#:[weZ=mFW\Zg^4Ժm24)Z{\"WCPik\"/vG@ꞻQGIV^V1\n$aؕE[8@BD\r=qc`y_+#|\0Ӻ0ZE܂>s\ryVܾv#ڷB_pu``}HQ_/v9FO\\I;\0\nUwUrE[2eqiKW$0h,qk>iZxjmUvܫNՖFw@5\r祈LBA+Ds#=$LNTwh.NJѨ傡KS\'%U@e׃cO#IId|Oӡ\rngXIj̋;f-KgP3?}O\Z?jk炟_tNo4\\נK+ټ^d]%xܗ<4<Ŗfd){/ˍi,۞AvLDv.|dwYk\\n:FWY8c1c1ǠqwsZ>|K/nl(LZxvְwkE/Os \\*֚__)TVXT\'#*$$@XF\r,<icwk{W(LE ],o*}C6j%$\nZHHu^s.˯r-kFtٌ\0g8MԢ?E1c&cϬnmb` wA*moKzp	%=s-Mگh<!YbjT07atݮxxzz(tr**{]5_j?<נ]jj#ePzIz\n@Z^j!c\rq1Zi緌c1c1d 	v4YMm]G%d7ZGafᒫ٣w^\'S^Mw1cd}%d\"k{O:nR2?!r5%]&7,iNQy鄧3Xt~oG?o~Z?)?~C?~kFofI{p:*1=co|)FXEz\Z6Jlix`%rʨPw}[Gm\Z0fU%\"6uCWGVO(eb\0m!/#Oc1c1','vsantos',51,'Paralela',NULL,NULL,NULL),(160,'point A 30 20\r\npoint B 60 20\r\npoint C 40 40\r\n\r\nline ab A B\r\n\r\ncircle o C A\r\n\r\ncircle o1 A C\r\n\r\n\r\nintersec2 D A1 o1 ab\r\n\r\ncircle o2 D A\r\n\r\nintersec2 E F o2 o\r\n\r\ncolor 255 0 0\r\nline cf C F\r\ndrawline cf\r\n\r\ncolor 0 0 0\r\ncmark_t A\r\ncmark_t B\r\ncmark_t C\r\ncmark_t D\r\ncmark_t F\r\n\r\ndrawline ab\r\ndrawdashcircle o\r\ndrawdashcircle o1\r\ndrawdashcircle o2',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0C\0\0\"\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\01\0\0\0\0\0\0VX	!\"$%12\0\0\0\0\0\0\0\0\0\0\0\0\0\0/\0	\0\0\0\0\0\0\0SaU!1AQq2Cb\0\0\0?\0\0\"\"\0\" 3˾X{Q;6>\\\rt9U1a`4ɺ\Z\r,]w~RL\"]Pi{\n@`e_w.e+\0.6m7ioCR+f\\zE3o;\0$|a&0,ѼfLrN>ᭆU\r}F4{=aߠGE2\ZB2[{b[M9,j?gZ\rjS`nu:^r]soT貣l+%lrb8@3m2@yqX\\93@Q5&\\eeӾWTF0;%rq;Ya/F<\\d7\ZwW:D$<N\ZurazkJ,U\"g-\0lD-0y<c7~\"޻UXCt&A]X-[F:3)\\uQ\ZyBMI̮y^={QRwM`(4ڢlkЦCPe>@;6ckG	iV0\n (,ʉ@\nraK;Yulz]aS_~NsvDnFfgAt\'\\b+\ZλL# be\0(YG`C%6wL`iC_]V[͎)p*̇IP\'ō:Û\nc\rI2$fLYQ6dFyNMXeEkWKl6(2Ϡ\0r#\Zb&²\Zv\nVE/\ZFӡliuDMkkzdCX7cX <6)4fVHҡXSX\"\"\0\" \"\"\0\" \"\"\0\" \"\"\0\" \"\"\0?m8Yxʤ,\rR&s~Y1l=@!B+4/v:q@tar޷}@k4	j-2T<`.rHVGǟ\\TCf\nrha\\f\Z^4hǇ;1bEebi#Ǝx5\r2-cm48qYQ08b,<`M7m8a8q@\0DDD@Uyɚ[ck;ѪfTdkhit,e\'oc\"\\f\rGQ^۩mIdQǛi63x\Z\0,1\n[x	1\Z[.3E#-XJTSp3xl_ϨYzt<$-? dN n]_I\02^h\Z[,8v(qC̎DI@Qad\"8YÈS#:yQi\\ͼː=TD@\0DDD@\0DDD@\0DDD@\0DDD@Cv5ugݧ*6;Ŭ\rg#(5ڠn;\\rXCFk8998:M\n5\'^፫x!jfVNJ4MvCW_=kAQ@㍑*?r,ZiC${bo\Z V]cIѪNl&D܉Ǝkmfb\n%0y	\0DDD@\0DD5mnYm=ѻ5xV-ԍy,k8YBw0\n_ekl\\1=gJn5̊jG4LʆSȉ,\"ɊlV@flXB0\ZD@\0DDD@\0DDD@\0DDD@Dr4,23.qos<~\0@?}hqYtMW1R}D?:iS:iT@ǃ,Qsͻ\\ǅIP\0y/Oy/KDx;5<۵xTQX-0rs=7W`͍;xǰ81.\0	ztc%F47A{\\nǐD	AuE=19lRvcs`0aAk{_kuuDt\0aa2(\Zf̆G.|-֛m޿]xl1,͔SET2Y9<h_Jnh۶jXX=?kҿ+QesxZktuDyǨb;Q\0xJ%j7N%Ad7g?Gz[;ǊU,YVNQy#lob\\Nb<MM\\n1R}FE-Tq.y}wpCn]EA?;Rvxy7%̧5yĒd%ɋx}iƷK۷f9V_k5]<ɠڰFb3y^B\"b<2uhqYv\n4\r\rZ^c.0x\0Ν7>(\n˔FO1bÊ˲$:-9d$mŪ{9\Zū/}wcvAV5cXDf4y!&mEװqGk3vtVUm6{fV=>{_!G48ƻxviznWk6&Z%C<ME6s\'mkEj.}-ƷgV\Zכ6mdu9J6Ŗ%ܬa̜\';md=9x+l=BJ-s]T\"xplת.fkݞZ	Eι(WCzvQ\'GV{c͢mmR.\nPwوXaCQS#/e5_՗4UE\rQ^TUE~H(rVШȍ>cDsbr#Q~P(ƽa5>8=k[v_˜av~͋_oیV~!q3ck<$\0J܊;jia\njvn9r75&Ar>o[n72e\Z;-f<MN<۵xTQQfc\0!.~9nKthmObe9󟰜H%F=7N	,\r1h&03j\r!aM3(R5k[C\"gb)SMmtǝZ cgiݮc¤*[*\Z\0\0X@Ve-O\n{$ͪW`YdW$`/4d	d|l\0},}Y5iΠ]Tf@6݊&{y\n0\rv8:weHtmٴc5uF;=>ϰ-\Z\n~0Y Un0ja+)͇\n3aL cBf_5B,jɂ\"\"Щ(򪪰DDRumքei\Z~UI}X\Z@muZs[Fsf/?eheȨjࡃ,f*M\n0MaUq6pelc5xk0f\n;:iQcAj]\\Rj*/QV_9\\+Ȑ蔇_5톭r/QU\"@?}x@?}ꖈwjnv\n&!<O0_z!<O0_zwj.yk>`4\0S4\0ShqYv\n&!<O0_z!<O0_zwj.yk>`4\0S4\0ShqYv\n&!<O0_z!<O0_zwj.yk>`4\0S4\0ShqYv\n&!<O0_z!<O0_zwj.yk>`4\0S4\0ShqYv\n&!<O0_z!<O0_zwj.yk>`4\0S4\0ShqYv\n&!<O0_z!<O0_zwj.yk>`4\0SLMBV&;QO-8X5/<ÌrYc<q5#U#BU_HU\0dthƫ-5C5UN<:EC<˜*l,r,<<<<??>P<O_dx0h[lSI6!P<O_dP<O_dxm&<Oy@5?!}Xu 1\ZI̫t\0ŤP%`;<CChѣ0X3Lzؒe5ǻvKPH0ʾڎElTA7P	&A\\SVk\'TqÄ5?UkpZ\0O҂U,\ZsH=MXveO_b8 >h<8Y`AgI&cͤLev;N?:\\׵[2Jh5 ]+`+oك75]\nPعPUFk\Zez|\0X1ZHmbA@1YcDL08xq.WcwY\Z>grEn%pEQs{6,\ZLxNw0L~,(#\"}֯U__u~6U_4뼩}==VGWMu~Jk!P<O_dP<O_dx\Z&cͤH#S2\'#S2)%xm&<Oy@5?!}X`2vI3B+\rYlHIeZ7B\"|	\04H7vZZ\ZeDgl3huˎ3ē7Mc[iJ%-v\r?:S6V9uM.i_ǉ:I\"F\n8M&R(c[e4agm9&wI603nk{^aa׽Ep<Xʠtؐm#KR0jVG;Q5|l\Zk_VZV7]#A\0ltm\0&WfE+=P^D5\n8bWcMX{]Rv*-v\rg3g\0;x;>t)ތH9\"A5^\0p񧀑`tP7/ncUkJSP3NAj7&<4F9(z\"7uI/ڪ\'#S2\'#S2*5gjpӻW)lYU+R6Yi8N1aIN7ʫE?%XI7͞xoti>\0LI\0LJ`gm9&wI6!P<O_ddMq2;%Lv4j&;d>˰2m^o,u10,3ǜyfʶܛ\"{CmX:_/G{(S9hn\Zk-GBS\\pf$rxvh/y&<Oƺ\'z7.5tmٵ\rh)VqD?:p?Ζ܆j|iJ@e?0-(T]A:w]a]I\0;i\rbx<FY|:ј)[BeTy]\ZE]KW*a+	5xaƆ`m-d(lLMJ]w<BQ͌`Ds죸w[\ZL%\"^y%.5bl`fsBEw˝,.UsCsUaUWURM9\n\nCK1OF+UZSqPV6Plj{4.\"H)QٴxD`2eMJ-l\"<_2E.V?7l0 $6m\'C<y\Z鐾<<y\Z鐾L,0 $_n1}?<rM6m\'C<y\Z鐾<<y\Z鐾L,0 $_n1}?<rM6m\'C<y\Z鐾<<y\Z鐾L,0 $_n1}?<rM6m\'C<y\Z鐾<<y\Z鐾L,0 $_n1}?<rM6m\'C<y\Z鐾<<y\Z鐾L,0 $_n1}?<rM6m\'C<y\Z鐾<<y\Z鐾L,0 $_n1}?f-&̝QCw,9o\'b̛,r弳j&s9a\\?Ǟxq$@ZAJ؋Ve0sU*VHsU?QSD]O<.Bd(eJL<h1[3gN1bD:-ng8h\ZV41lڿzm\r{4F7L)dnd&(dN\'?ι\0Li2id[T85Y1:uQc\"E-rv8gݶ}.H`ǢnMy^H\nGk])q;1.\"uuΙhyKJE.:sSaTBw(\\4{Aҥ~XiVkf|X\039_ @)aW>C+`xJq\0<YLB\Zp,UpXp2y\"8sSDDy	\r!ó,<ZZ\0~[I\n$bieEg+ *f֛;v+\0&Mj&2hi5Px͢vSkA+[ ]xݫn#a#5*))ŪUkq[.D<ADev=fK%`\r_3]bxV&9F<Jg	\"rrqI\"b$1.;N^iB{\nJn+\\/i[h/_).\"`=KlURq+I?L]`+эϸwܵzjU	[4^:d`#cߤU%Sg3?MFBlUځx \rx97.68xeXg\\q9<X<s\\s<rH7;\r\'9F[8UiSE`~nP#e37`Y/5=FK`jt~\nK]jZ1&)Լto s	/ZS} %ϛP/D@B-Fee\rhe\rqZXY͹aύϟnbǉ.@BMa \ri@$j{ER8nޮŌ7gWF,yrFrtB*hqpFn\\|3f!۳w j\0d;d|QzeF|5Nu޾#h\'z&t=qsZ\Z!D@\0DDD@\0DDD@\0DD\"OipLgַ\\GBpZV=o{VL;rtE\\qv>o&H	q#}$u@1b63]U0 n%HB</]X\Z_H\Z\n L6`\rן\Z8cןx~U`\nִCC.ֵ-_}z\ZÅqRwa9>݆o[l\"lHШ+֬610&\'Ly&u9Nc>dXiּV[RdVmU@nZk5fB/[5a>`R[CҍS^=O̆ZayYyq6i9s˜sǞ2ǞxP]_9jYN|xb\0>D9\0Ř ~Tr\0k<\0Mנu-\nf!#|ݹы!mGPWHJ#:u\"Z`(cL{m\\45?EwQv?Su#aǎ3>M-9n@{,@Ѩ\" .@(($y!#324SaKIn2.fӸgycmG^%TQlPuʃkjD)H\0Kl4{|Yl1+)>%G٭gwՀ;bv4l\0O`1TW|8n#$7\')3-F뭆D,Ǵ C\rtelb7\"BC!)dM5(\"l;XcW^U\'_́ceQt&OƩf_m&ujչ,\"V](L\nMjx)%:^i-y]-?nG8C6B\Z @CUu* !E	uiA땭VO4\\˖z3YVDWc(#&\0Q{2vys}~k#\'0^h,om$Εܚs1<r㌸\"q{X6I|TN^M@vVm3yj1˝O2la\nspն=~b\'yo}\\\n	;b13ZfmZiԦA%&$tf3,\"\"\0\" \"\"\0\" \"\"\0\" H꜇#{}{K^yr7uyfgYysysYs<Bo\0]k_PBW9tmGUG4f+9C\00S.`dGL pqOy:m}PY_ޑzJ_Ly\r7T/&aЮΓU욌,LdcwoS~SZ2S~SZ2(]M_MkD\"\0(]M_Mk|u7\0e5(\r|O+H=|K24:o.an@gXdhLy0*[}ߥֿS~SZ2#\0K>k9U+.km8NvX7%ZWhqVu-a=\'5Վͱ͞4GXC}1\"zHLuֱqr*t.Y(SfD24Eqqʪ_txBNϲjSmH:AS{vN.\Z;TxO-\r\0AB1dG0ڛDujŬ4n~t|\0W=߯GˈG\0{,	_>zϫHV\n2ZMO	dDmUR{p߉x,ebM |.k}koTƕF\00Ջ  8=nfkfǂ\rMhy\ZG8~;`oX(ShuD{ӗiR\0Ơս9&,25\Z\r-x\"P:3>ӠXc\nQ9}3\"\' /X	ecb-Ox)-;y\'`\0\0H8j|QBrg&JsBvܑ*dڏu0oUz@$]K$׵\rbmg2^T[%-s~2|2>_ѣd`nsJKlkwEgrdE(<q-eO<^ɘ6.Y{_7h	kWĶcv1ݕVov+g([\ZxD*P\rMki\0@u^`͖mqf=-\Z:Մf䢤|\0ij+lŦXfD5\rǍihk!\0K}pfQkٺCjӬߦj6꥚Gx3,kpѿ(]M_Mk@L}%IfG@L%uqqs*$c)aL|ZxUҜ3<W*\0_7ohiҫKhc/xۖTn٬ͪS7:-Kw)P\ne$Ř~iO옗v\Zi۵@MwX̳VUZEcޭO5YˈwBo\0]k_SKw)@hYKw)O./즵eIG0t}>M>d}=}W]\rwyrf8oqrvNIGID=kiL/!d9\"ƓXdS|ZW5|pa\\9J7S~SZ2S~SZ2(]M_MkD\"\0(]M_Mk|u7\0e5(\r;u7\0e5)ߥֿ4B,ߥֿS~SZ2S~SZ2(]M_MkD\"\0(]M_Mk|u7\0e5(\r;u7\0e5)ߥֿ4B,ߥֿS~SZ2S~SZ2(]M_MkD\"\0(]M_Mk|u7\0e5(\r;u7\0e5+n>!]l4Ge\"&\0g7le-d<܈\nSe;C훽73\Z9݃_L;`!B;Y~,]A&֊뼭jI0_\Z8V(VU:sXb<6uHH%d5IP#P݉D@Fv*lkVnI\'_\ZVA\'\"kےqͅiWgH8í9y(_؎?R|p/a>.͏\0+\0?~ӚAƶl@;i\r얦|7rd{3O@lhD/^\"0F1xDDD@Pg-:z㤵/jX-@E=s/{zbF2	6`EyPvvEVD<$ʞBtv$1e{Q\r\Zi:\n\Z&DF)c\"_(\" \".RA$h0Rsn,Gr\\d\rG+.Ȑb,8\0S`p5m7Et2-}X2\0kO9-vc4N[q\"07syQtAU]Ci25.ϰ98؟b1xWGZ^0!/$D@\0DDD@\0DDD@\0DDPXiVtF^ueL@Yubڏ\"^ԃ5\r|+YcŤ\ZPw_Z2Z@g\"{/38%e|n %Pl2(ahmsU#4Φ\ZnJ˓sVVwleAʦD|%dui0\n>WR/04,\" ,%68.k}V$ur!ke1II٢.~kd~$l,2@tj{_O%2OtaCPړĔFh0KHH${.zrE)I\"*(e#\',fq\0Pe5cIQp0h\" \nwK\\(Z@ag;^.\'GZ_@3^gs*8*\0<f6ӯ+YO5rΟ\\9$I͈8|&\\2tć;X$ʑl0xN:x7<sYqt\r*]J\r*e:FXеvDAI,dwN)\0t(\Z(PC6\0pC @qǌ0|v@\Z6Fى854veoq㾈\"\"\0ϻR]Wi :\rRɆb%6!J֩\Z^\ZDXGg3l\n[؄ȽHO2.r8xpx䈱y6t`ó_H>.keG|f?IF컚NQo!++8ucU\"?91K=S	|v:k\0YX6.D@\0DDD@\0DDD@\0DDD@X^hO&̬3pjVД&A݉2moW\0˕\ndjF$[(ϖwuuݑNdNÙd5=Z`TȞ1ˎGꥎTÜnly&;a*slꉛx?mN.\0yAl]\royS\"Э\Z_Mte\Z=P\Z*2NvT=G05E-i=iD닋%y3EI(zTcƷμD@Jlʙ`X&Wl0mR$#Ua\n`kc(fICek\Z^],soC?4205a\"y[E\0\"8bb!50 +].hх%1i_lcdUqrmFrCVߑi?[*\"/el\n,Ϋx$ݴ5tt$T)D%)#Òϟ6SF\nf*T[b;\r`e~ڍI\\ۣtEyq-esb$tEp_MLI\\uf0ڽ:P	݊Kk_Ko-krGt	\nݵnV!\\dXEG-<TT\0D\nalgD֏6z5ۢV6Β3=ZuLجvLb!f\"\"\0z.bo<WTJ pDoeO&N{C;|s$<Xq\0\n.{lkֽe-ksL9yM5\\a܈Bđ1.ZS]gD+-e9xKT5\"*M)GrMɼYv\0b`Amӫ@Ǥ(}Y8gۮ5*]]j+]}\'M&\"QyFq+Vl5Sm665H \"\"\0\" \"\"\0\" \"\"\0\" \"\"\0x`cagqm狍dۘ<qxˎ9i)Ltd6C乄scoiq>xmk1qD@KT MVNxAn .H&u0LD_D\"z|br8d͖DI!>C\'O2\ZDeʐȐ<fYe\" \"\"u\ZY[.\Z^flc`>޳\n!	pYalqk\0DDD@\0DDD@\0DDD@\0DD','vsantos',51,'Paralela',NULL,NULL,NULL),(167,'%% Example 3.12 of J.-Z. Zhang et. al., Automated production of \r\n%% traditional proofs\r\n%%\r\n%% Pedro Quaresma 22/2/2006\r\n%%\r\n%% Version - Full drawing\r\n\r\npoint A 50 50 \r\npoint B 80 50\r\npoint C 70 90\r\n\r\n% Definition of the equilateral triangle AB_1C\r\n\r\ncircle ac A C\r\ncircle ca C A\r\n\r\nintersec2 B2 B_1 ca ac\r\n\r\n% Definition of the equilateral triangle ABC_1\r\n\r\ncircle ab A B\r\ncircle ba B A\r\n\r\nintersec2 C_1 C2 ab ba\r\n\r\n% Definition of the equilateral triangle A_1BC\r\n\r\ncircle bc B C\r\ncircle cb C B\r\n\r\nintersec2 A2 A_1 bc cb\r\n\r\n% Definition of line C_1 C\r\nline cc1 C C_1\r\n\r\n% Definition of line A_1 A\r\nline aa1 A A_1\r\n\r\n% Definition of line B_1 B\r\nline bb1 B B_1\r\n\r\n% Intersection of AA1, BB1 and CC1\r\n\r\nintersec O aa1 bb1\r\nintersec O_1 bb1 cc1\r\n\r\ncmark_b A\r\ncmark_b B\r\ncmark_t C\r\n\r\ncmark_lt B_1\r\ncmark_lt A_1\r\ncmark_lt C_1\r\n\r\ncmark_lb O\r\n\r\ndrawsegment A C\r\ndrawsegment A B\r\ndrawsegment C B\r\n\r\ndrawsegment A B_1\r\ndrawsegment B_1 C\r\n\r\ndrawsegment A C_1\r\ndrawsegment B C_1\r\n\r\ndrawsegment C A_1\r\ndrawsegment B A_1\r\n\r\ndrawsegment C C_1\r\ndrawsegment A A_1\r\ndrawsegment B B_1\r\n\r\n\r\n% light blue\r\ncolor 0 0 255\r\ndrawdashcircle ac\r\ndrawdashcircle ca\r\n% violet\r\ncolor 255 0 0\r\ndrawdashcircle ab\r\ndrawdashcircle ba\r\n% brown\r\ncolor 0 255 0\r\ndrawdashcircle bc\r\ndrawdashcircle cb',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0C\0J\"\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\04\0\0\0\0\0!\"#	$%&\'1AV(2Q\0\0\0\0\0\0\0\0\0\0\0\0\0\04\0\0\0\0!\"1#2A$3Q%a4BSqCRb\0\0\0?\0\0y玎y玎y玎R,]SuVD֑̲%AwΖuµ)\\-j8\rs~a%~ChvJ6VBl+4.ɊI6qMoGgI4Yks.\noz<!e4WA٫^#ZJ1>&N|T;\0VoǸ\0(N*|g48ȚVB&σ,c3.dRwira<;˽bhҐc-orP:?rpO$d]E?Och암o`Grd̔Z2ȷ Ժ\'72|]N\\ޏt.<gHÇdC?+@I<:s<=[DVNnuE)wNN(+BA	>H51Hk6͏K~\r=K#	O_%{eRǲ@w?gë#UuNo\n]pJB؉JMFئPVSC؃Ա$x4R8Q(32(R#av)Ǟ-hmwm{xG#nۖh=(4!ӸC]wGWj	?^\0<Ժ맞y㣧y㣧y㣧y㣧y㣧y㣧y㣧y㣧5B-X]ۙ\nXd\Z*ÏrD\'٬h.%6dPqǼumWzF96_k\"x#)\'[vq.Oգ=D)N\'P_&q+Eew3yגQ;ffqdҫtu+H1mo@80֞9njY:+ߨWjH!+ek!`^\\qjg<\'.7UJFEN\rӢ?zdN02vGQtƁ\n٣1!}MZׄ\0S@Z\Z9|RnFJ9l(k>1+X_\0g6!Wȷ7:yIԽ<<<?Uq\n*s`C#qG=F\rvdه+gVk\'	=>ٲṪIn,&^3Ř23KQ:\"q. !jp1*Im75|\'\0<\\zUco`_tvuvN^+0nڋ2\ZZ闦;qWc\"ᾟӹY\0IՅ(Y(b<I,㼫9fiae>>?V{ݽU;G\0\0o>\04ЋN.\0ٵjQR1\0NYٴkǓo\0AmۜFϩ\0lgp{DV}/!\rOs+i5&qZSʨFkH\0vm`xY`3}äA\ZKulRq}#W _\"hekNfG=M=IDսhCVx^on.)y̟נS/M\Z<>]oO|ࣅ;_@M}|\0%!A#?JgZsމ)\\EAXvzBGUQ\Z \ZDC`hqH4!6}m\\Ɉ\\j^ohUJŃso{ItZ&Biש(vXk!NTזԩ4hMrHI3NY\0\r&I4ASgyM^i>Cdq㒴i_;j4/}3O%/ӏo%V/4nRʞ\0@$v\"{nnWRͪ9HSsf#On\\Bق<Mgc\'\"F\nG+bu.fi!#͕<>삶\0aC$p>j3n5Sqx^7UJKt\ZZ܋꽇mdݼǰaX\'oUJ\\7h)KKTW\\$,~;كO/fm̓\0M\'	\" 5)(iY\n8ܙ\"܍m3&:Ǧ1r![x9lѧ39=~ҁf?dwfOPgs;w^I0#S*HhHxx)M=}vl5\Z	*K-qW ]lU^D؂ؙ\r\"N,gK!lFwsɰm_Ie=תF}Zq\Z*D\"hŌH52I-$\nR\0ǔf|J\ri\n,+e,|o\"I#̛c\\9^SRs޲ɳFi(+H뚠S=\0ya߯Y,eó\0H=D5\rVSXz$[	\"ub35mijc0Bn4a1<KD*]+G_5?U1Z@<!Rn>hV,΅_Q	k|@9u0GQ*R\\{\rEWn̦D#D	&Ce\'4U\01[5VHM/~2mM\nrtM	33?5Vgۦ\\)7,<֪I\'o)^UeB){fS+ǦcU3|@4*^;Ǳ=L^qy;L<-Tu4\'XBzJQmC9UE*ԡv=z\\@Ibm$=\rTm\"%8>m$3Bg3\0O\\PCDӜ,E:űſuI}~Z{8Rc_eic,3m{UBT8/.~&.ҬRx琭nWnac]U%qI\rOWڼG!G\n};6O;eO-F[w*k7jm/%g#\"\'0Gve_Ỳ{{;nyYS;\\{ 5P9_ߞs_oe7kg^t^!g:.A\"ZgHVPO{GaIVRĸEEc Pi;#!J\rTbD|9ۍ-Wv~#)zZ\n}}ﶮƜZl nۯٗVX*Sh|b\0ķ]y9oIY>^tM\\Ѻmr-~R4^1{^-=(F4g>n*~+,V\nx~o秐Vg-j묳4R\nri\\olͮfyϑ?KSŧnT{!P?^<QMp7Kْۗ6*r\0o! )3CM8IMdfCRuIS)dk[-В-l̫lد$C?h>y\0پʇ8:԰-iʽٞYm|Alu<7>U84|Z2MX<2SV$4>Lțʛhay$]Céa|`00M\0TrE\Z	Vͥb5#Mώ&uD$}yd87-R&sɳ^3<u`YPbB\"RҐ;q<)ڍ9s	k\Z&j>SIҩҌC(d%AFybK!_qf^ǒ05us6[jMQ͈1>q_l8\Z$1@Iڞ I3_[y\Z񜜤,}8qڶlPi`~Zj<?1NHd޷\rif#@V-/yK<K6a{#жlDJm4ӯJ$\\6}QoMym٭o*b1uv%yc.>\r$qxH;bHeh]1>~C<miҳv&ZS=BYBI<\Z46k9yN?e)#KJ_:\na=\n+\Z+MVzWy::z$J湽l?+:yXk59L/H6ZXe?K}\0c1ԩM+|EAwƖ.QdλsY\Z_5`\rS̴$F=TY:Ҽ#yPT(k5ڢfVmP\n-omiyX\r1\nNSlHR?떻rNa.rjJQG͋`rӚMpe\"R8^/X]s\"IHV+?cbZ0	`ҏWl.\Z\\u	ǌ\Zݱ*Yl\\~i8joW/ϪEbˮH?pjVkFαdVFXh{$5Gv=pTvwy}I<<ko/55ե[f;Y[jH,g7p[!FWK*;/|\nNe}CZtgLLiZ79BT]zJٚ**U X)n\\-)3SۣUI=gnC.u3k:\'%&0@IAfb=GOPK=.<z[3V-\ZY	|.~ϐTۙNdZSZ[Rݒ(+6<?&lXzہ/\Z[YWC?֋?sUT/MXlYd\\xWmRTkDʮ}XZ}FZDO\rݚVCcBiŨj0>_\0U^TSwc/s A˲|wY	j\'ą_e0F5vVt,qeȶ8C%?;Þ-i,vy:xb!*D4BfR|_ƞg#s ڙ^ӅU2\0vA.ۣq,mȏDT*|T:.վam~5C5\0Q#X3\0YI7Yt0JMe{9%hHfiC%W6!Y-[M5T8ݾGI(_M)B;E;Φ]b35kLZ6a0ob$?`6{ow7b8XόBL(Qhp>ϟю\"-ٝ\"io	eI@$FiHR \"\ZU)F8~ֺJ/\r]Dy+R<]cԅ|RbUmɶ\0v;SE뤱6ob㥰PJݧ\\j>$fny/r9;EeA \Z	7A튻fb$\'x۟&)Z2K#rj-bhLIdW\0S`Fbw~_GH zՌ9ΒmSO#ňb|+$ÿpK(UΧpI=&h卉~6 1y~x=N\\g~2|{@|&#R~p,|d[m\r&ie,I$oڒWWmBTH]4A8\\7=1ƚzI$pǜQRI$tqMymcci%M=5}Ƹq23Uw,\0\0	$}fTVweDU,*{\0I$\0s׻疺rPlHNkT42tard7eqonSRK5Lpji-7B{)$j>7@zh:YuK!H`݈,()L\ZΘZ\Z\ntxi Ճ-Ԃ~Q_ldLC_)wJAGЩДer1>i=\\6Pk*<+\0ulNlk\0ǈ{l7RX	?I\'lcPʭmjoKf 7llgSI(g;%16<xm y$`֐̂ptIb]4lՇgJx/wafƛ\Z**U\n\0h\\驖Eu\\JVCUѩ[=/=	ݲU)SD6iJjV2Zb)Z.HKKaD>^πFSf#+8VM^ߝ\0>g׶!-3_k>)1G.̬@-PPz~c@$f-	TbJ^cp͢:9GPl0Ռ\"&֬ʹ|o|&5sUm !~=Tjtߐ_]-xVN&!M\0T8Ss\nZfHf\0_~]슣j_ZD.c{MH坁Թ\0Yi)?~11+YҒuD=ғfGS\0*C)\0 ܀~?P?^t[:c])?CK)b[:	+*k78@nSF0*ԏ(|wwJQ)5^xqWn\\`&pۦ:Iиg o3ԗG\\ĭ	j,e\0]U{!TAS4]5ؙ$eI^H\rJruk4eX8G`Mg˧FGÕZ-ȭ)想D~Ԛo_P+U\'粁3!cjf|dtc-{24Kjg1=G2:\0<<aQ0҅R|\'Y~}\'\\b,AZ/$*=&\0цF3 MH/U;;mi+\nQO	ut4R^]gFxJQNS^n(~C/sdc+wJJ\ZLJ4x˧yq Q)1λc2SӪ_\\-\'=:c=9EVY^Ʊ2`úùw;\0~R=3r^Y\'pªwE\rl%Mɻ\Zi4\"}\Z\"lGkZ\nfPxwE1Cn[Oǋ)gH؉\\q:,PZ*5̸\"uJ@籀;\rFQC}s&ch(XR+fI?H;>I\0#\\{g2i8=xi1zzF8/ڕʡ~Bkku:v4\'~ntuh}&47oY	xedZ\'sÿUɰHk\r?ɧ9L,KCDðRo\\We_EOȨhTMl;M1Q5MǴX#Ho.OZe[fR}śAHگ+q+sŸ$o\0ohXΰϩa*h!}Va1Zf$@d$PAI\"=s2G֩fy}{`|~Di	ewuc!\"\'I«w3nڒtt>G1-Ti?\ZR=)zvhJ,n!B3$D<P}f3.S	M]ՐZNq.tOh+I.юGE	{#\rx>f-RhtO33-bpVhͪ0Zf葤[@ݬ+!mU9D9?Igmh}4u&L-8r\0+6e:ux\\@-N=sNm3AqÙ ۺίO\n3U_.*J0ks\rvEyo1,~L߬T]\rsUBId>!_\rnH/g:c\"A/ZvySo#@馭166QR\"}GZ;KCXB5	=MWn/I L	5jolw0eQڷys&FMNC3;ITԁ֧ {\0`ooh{\0yCԽ<<OLY_+eO[j*c`U7C^ҧ5,IzdRdD;k0b!9fSN2ɒEi],yڞ,UAWrܳR\0wf?T?\0{^zzEHku(:v8BȪS.Nl|^Fha\ZҨ$oZomT^p{vM?Ӷ_.	*z<({jv(\nT**P	m6	nՆE_+!`w0i͜8362f @Y@\0=`טQq-2q3IV~\r6~SdkDWusre3[N*/e;3ڣԬ)TbOw⽔=GP{/x,Lעκj1L&,H\0\"Z1YFS_IiPh]MNުrn̈́Y׺LGN=JKYMZ[ƭ:\"vm,+b.}BÚ蹎6xf22iNxXBf1ʏM)jV*?RGvIH!O\"\0ȯY i6uǽM3]VfBXnB#ñRVr-k2Knr]%D:=~Q\\CTYC@(+Yki=EϿsZ)#6l+{T@TnFjdN^UmT:T!0koA4m~GǾӥ\Z*Bo_nsFPI.e\0٪L?f	z-RI,k1#KJ+!cr\'o\r#%良?Nl()\\fKuj/VcS\"%&\ZmR4s*2@O8:,^ܙg*~.qKYgJXĺU!Mg\0k*OJt=*7D~ZA#!~0T#fuZ!kluj\"׭f\ZD+P\r9M7Zv&;É;V	\'dAHFE݊@51< וw^juC&eEgv\n31\n;b{\0\0H\0科tVYʗ葌bZڵ`\")gbA$i+5iU;.tkKlNE~E\0_zUvg¤=71si_\rAJa	Kҫocd,mƂDChL3xք7WB%0\'TZ:nQMv~=m!$Y*y=mMtgKGq6>RwHckyʵg}KBJ\Z\"֥\0y)[+yG EĳĤeK&.tGЛed,H2jS꫖3cR{iD$Ps\' jL_]3FPϙ}\"`Bh{h\n<]~ =]3o,%,;5C@#T#\Z]LMhX\\GӶ:\0c1*g-24\0Lm)%<鼙7:8XV\':R੤B8lBHʂxؘ<}>4/TPqǣ͢k2G\"5;SeCޘα\\8ˤEH[mgxWzI9-o>UezIdr/4vsZ퉓h+!\Z} Q2	̱So#YhN?گk4+@C\\ڧMz3Ǌ)ۧ|8M8y^:\'%<5x:D]<#U)sړ696\ZhSM\r|\"([=Ϯcò1Hlk!XIS+w\"jORiV@N|͎M<QC\\[QV$<$<E\'X`n-C@~9[.n2i\Z-AdYssHA\\kq3<F{cͯH_o]?\"[jb?Ja?x_SAfϰTD~;˂^}\'<ڂkkj=m7#Q+1=:.s\Zѳ17݈>Xۓr\0Zٸ̷]^еr\0mWLqyl5ܴ<PMK5!HAefw|\Z2B$祧Y83N1kaicxϿC#-͈ɚ\'eQ%mO$6`S[H^P=;UUүaa=4>O!M1]A)yt/lb tk%E;u%ӟoV]><y3*ZWjM>ΟmkT4qEgM\r\'qv%#yJjləv{zߛ==6n-MוW~4\\2V|J\ZV߫&kĶrz/֙4ntr,>|\r07PWOG<HKÚLQ;gMJ%6\Zq]]E|0OC&b}^E?ltvpΡ@*Ц{ ƞ48柒bjAx?h݅`U¬4_;ѝ2=[fzu}Z@;=rgRnB;Ѥtwe.hFjΐaY\r(dMagxݚS=y	\ZZ[fv*|1&z\rȆұpR0$2QbUWT+՜&k%\0lOcvl1}9ƾG\0Д\0o\0X?=ePxf$\rl.\nå;p%-zUQ#~K>n\\h߾?fi\r5_ϐ㕼,<wzܿ(A$up9aױs|̾Trtj/ԾzfQ;VEbay,LL޳oW&@k)8]aE`Yl\rZӍd:\rJ?1epoˉ<}w\0ً0u\r\ZM\n釗2I\"0֐0ohkGNfIyQ6聕:(|ѝU؟52\'|)$綼q(n\"oO\'\"K*KL!MVר+_os+ZIbǺ{M\ZNR\'LcB:8ei\0AIsZl%;CvfhM>*@ n$h\0.t\0(HA7W_\0d`>ԑ?:Q.t1מj;-(\0vBJUUgGC~ԁ iXyRx@CJ((/z\niqA\"~g֎\rd/OjǿAe.૳ւ_rϬ]ʻ9,t]~ʺ$@[=PuH>Hp\n%?μ>u\"meI\nGlIq$h$ieM1wBi]\0XSsRywCsU{s%h5Zb5	W5pjk>t5.Ht*E1ui5TRR	om>r=)y(pmƪGz<*0\Zoѵ\Z˗(h]jjşgXS-N[vuVAIQ 2;o(i)L.z$-4\nƨC\0zF<VumX=uwc	R]\\$2`b5k0Zɍ%YOOcbt5Uɞ!m\0cC\'Y%+lR.M${=\0kpܣ-J	I>4sn~F->Bm3\'-$~]\Z9\Z\rW(6@jr[~|kޝw ozf)ROX)gk[W)DX\']z>vLθi-KS*!n>OeZ\\}5\r/jgy`d--ܯrT_npώ8[醜Xy~;/_q|\0e\n7Enz2𡺝\\d`M3*;ܑ\Zv\0f @xm/Zގ&v~aj^˿>Cut6w=!BW+ VI	x׌Xx^?2rv]NsvtL.Kڱ[5.ږ2w9㥏b\0o(~JI\0$׿o\0C<zy:::LrZ6l,WWh;:FWa?b1hP򓓜TC	P93h+5\nXl3K0rN\Zxk{BB9]Y=hhC|7g-UMJkY\\הXf%/#CЬ/Of֟vK\0nDӂ\n䴢7Z%)78A#){Fo=?H[	<0J̀#ȫ\0=~zYe&EFF!TCl;HSqH*}R\nk(B#Rb-nǿ;2_)T*䃱{::T#QZ՘DڳpWZ4V6Po#W91}u\ZIݮ3ǱO1Wp\0ҳ+?HJ	|mҀ\nF6;TۛfB*tاE=.aƳй)+-S~VF*`x)9	z7-Ҕui<k\ZUcͥR8Qs#71!}YK;a.\rC;i\\B(\0,7	=5_B<\'?fD`t~RܿM7%}sNU{<\"j3o$x̭6t[|bptC9=;w=T7;qvVnb9CZN=y8ZHSQfWks,2S`,U0.k6{&?*/\\{՞[NNvb	\\ҶZ\n\\D&a:\\$ğ99T_4?z2>6zBdsGtA6[=\0$ST`	Jie;o/y)_J@BPݔuZ9_\'	pu,Q\ZZyZd&~_;]9~Vw*lnMWƇJ929߆&kuϺH71\ZwFuhբwjDϕv5md6A5dP,:5 FKJraZQco)WT> T\"cʵC5˭<3%tBJ5.(&י2Pddb\0ѡ/\\i8&qD}6r](]}ƺ9u*tiΪ&µ膟\\͆ecy<Y6b8+KǈW^hgPf/u#(z~IQi+i7Tk>sa-ǠR9Z3&T~爞.	WI\nY+ds\0焰i,i	dM7i5\r>AVCٲ_#>\0ϕȖ)mvd\\vA_P.ywh)c򫼛dr\rh:<= qq*G$b\"q}6h\']vhfm)5I4m7:8ϻٛ|qؗySsH\0FeĩyY8pMoϩmr\rÈC)}Ħ*@f`;Ef`۾rY^Z`ǝWnM]=$ZieLVuQvPygH{z5n).L3r]Q9No҈t]n2ӽ-r=vwƖ\'b;b*vzU@	M]M0>,pg7{93{K07\\cCmrGJFFUi\0VUTUIN\\v̫T,(-fj6>pE0A&>tSE1Ѣ`g\\Q@*٬S&g\ZST]k3iL&ߑi\'E\07x7uO.sՉ4nI-/ƞO+-f[izթ5ғ޺Ow[\\4\0m,VgK\"$>m3^{\r	Vqɉi#jgdYS&I&SKpc!fm)Nf6*LnN\rak%j͇BC8Q匁I!4-}vQk#2JRU.U	_fS|m>V\ZifVFk:wɻ\nl͋D!-XN+F\rsWĿ-\\_وz?%t\0Ɩ38jP\0_ߏwJ<;mq6MCY\0ܿ>GoԾ]ʚ;s!,?S~Mwߦc2b]C(x;qr#k4&vEM./us)m̪ĺJqk㞠!YED-򩪷ֻH)\\U\r;mU2d$C8I(3QXM]w]}HEWy%:a\0*L%bs#2$w\nK3d:[شe4oV\\_#g%N7qE{ppVe%T=<^e8bXv*~? @0Ha6qmuXy;9ȳ1gVOrݛP.*VMScc[`iiu+}3jY\rҁ	7<NhRvOdE(yf_U&2+\\ui<|<xM9WsNmʍc\Ze1bmvm*]\nw\"uoSav]6Ls^r(\0CLjs\ZtnJ&wlVKE{%a>AUԹ#*)$q~]EȎS)ch_\ryX8MxߚFS5U>0-m|7-7.v\0Ix,[`Oe\nP\\peX!Ln\ZhټUYu`=tJMòQpY}SG/޺Bɒ?MmJBR׆E̟?ZnJE^O<1]Ws<q{rxHM,TSg9Tǰ35㧩JW\rB,|J(z^m+SXcw>8@XOJakbp^NFmqM\\W(w}UaDI7KUIjt6>oǎێ6Ub\'%9\ṋ rܐN7rX+#tR+u`Z9?}!Uu;:eW`\rx=س^\03g=\'ŵν[i̚E6UzwlC4[\"U4IW0FZ9K6Iqv4f[[11,cͰ6ɶ#`ѿ4i\rD-y,^NMYCj~̨f.ln	b,\\m~	m\0%orŭps6G_ZvrJKF>3lh=&}X;1WI#8a\\r\ZVnIG]qWуU\'=mg\"3m0T\0*~eVrYt7ul&Mr.X߯~|c]AT(c! #+Gr2aN8)Fکd-M\'Vl\Zt0/xfN\0r4S/yى:Ǻ\'ѺۂMu3raץc%y\r6ho+۷G5iuxG06Zi93RBt%Va\\UՓJ#<5si[`IH2\rS:\'m(XO\nMLV1\0Jpf!T\0]i$ZKAF-H\Z1\Z\"e[I#̶N\'Ij@0ͪ\'>B97fy=33<u{3ڪr,CLgU&<Д,ȝwRӲ}B<zy::{f5^\\C>/a\0})]DǕvXd\"%<o&Q@$T0A$&<鴓O<mqCz$IimϩJ}aSu!KPJBfY;Jʳ\"i\\5Kѩ\rovMJk2 zM< } ꪨ^Ԓ76o;_#ퟌ¾dѥurḄ\nl֥mNqj׮[\Z.K`MP-gfBٹ5ॺc%u6$VUG`b2ӸSdɤI	B)DHf4T0,r5i)?Gza]7o6څۋmXt{WZjãӏ!%uqde7kxDLz&3i*u5kW)q㓎5^KCӫbĸ6׊ϑG#F|t\\:kU۲ַ2OQYi.g2fKaϔkө-ED5	3wV!H3\\6fmzM]۲+݃<*425J	n>R.~MNYffdZU,evcvբꊲ4k$o[2<^d݆#?lUoʺrX\n\".=er_8#6/D\'=j;UR|kx35S8ΛeIC\\3MԴ4(ݟP%H(ѷhƻke#\ZktB;ж}m1]Y^[&%*@UtIb+1rn|zl\Z\"0G)k TcՋ]d\0\rƫ`2ZxL!$(,sC&͌m\0qzlwԧN\Z\"%y#vfO97&|YLkX;3Elp#]\Z4;;qeV;fNa}h9Ny8[VTg1s?~Ov\nM2ZL+^A~M..sDQ3m!4đ$$e&ٳ|S1wfsoj4Ŝ2c&R;nc/7,ڙhcJ`ݧF涛K/kNs)M%)\"RNsE\n(\n\n\0\0\0L)BS\'83IF2E)Is@s\0\0\0uKSE8\0>AX`auQɞqm@jNf`P[9݄YyꚈꛫqZ/`NQd8H19fAMiVɋw4cQ/D횵9>D[~1K_53\nU*\'ɪa\'AN:HVBc4S]XaWM?3U^>n5MK*(*;\0y3EwgfUUY(:&L#K֎\'$j0fX %eN	NY0]0H d+|kxo%+(q24R͒Vh)i6tsGZ\n $;H|UFT9c0K˺=E٧6oaf%ڲmeK\"[6[^І}ٽ 46m,AVA^<mRߘG*e*PU&	~9ܛUo8}BGe}jnnx;jcag2l:X17 5VʪOU=M<^2VܮҚ]3h_I<qWrhgȵN/:nKw\"ս|ZYצ\'Y$OY\"bRdDؓ#egRV!9!9ud\0ժ	8Mj42Ay\r\"KMMKZ}1<[F]u%YcZg!(L5]\'B;.	=rs\0qB&I!F:p0iF8k7\0-P2_tpFO(x<tʻo#frc/.-Yt{>їFV\nw.\';WԴwL_\"kSF{l.t1iam$>\")YS:. \0\"(|$3w\Z®⑳]TEtjXԫZÑ\r8oTL@|4yaf)6LQ<\'feiU@Ykx?RHy+2ӛf}Yꅲ^IJc\Zq76]f=7t`я^o{4Џ,pA{<oPZy%M5\\gmc9/ꋹlU	~eny`WʋZ$s\0i]+\\ښJM+,|סjt{\"ɸty\ZI踸S\'g-[̐m?S>w,wc,@Ir\nʣy5Up;t.%i\rh5	&nq\\.K/ /$\ZT(\ZW*;ITVF`ytԩ{v ~_ցrU_)&|>ݲXVEh ,y)MViUlUrŉJ1ŴCmo=H|%E,9\0/,#E0\r۵LKk&Y5xQ\"C@i:欺uZ%z\ZI4jLqXPNi(+Nk{nsoXо=m\r/\\2ԭH糈=s_ڲsز݃*0=	yZ=W^zmj-^mCQ_*EBk*K`\0F}X(m~g9*|\0J}ۤ\\;xQSP;:Ӣ+^(>R%\Z`ḹg+X{ڑ*w \\Z>1!(̀\'AJ)5KԆ$f6\ZTĲޯV|YlSU]ݭVXA(u	~ӟ\\OBȆYvzvی񓨤YIY)7P+X c{5næ㼵dז\r9֑-6ZJҢΈH 7[.X2CSRSj\\|\\2I%Cd60?:,fAk=$鿀?9:v!&iF&O<ncU1^K	֠&iZ|{	\"R|#VW\'i3K7\\BRWOs	$EkȘ^_KS&t(-io(cQ${fWP\\Ct\Z$٢ypU]\n@ω䀶:N1ԑelմ*MMuj\0\'!$x%!Gxx})WLIr5x8fQ_]L22V\rm}dmyqzYy]}_n~WV0>a2~E{[Fi]	L䆱ʆmJ\rV֙$U:Ak8eCG+\r&sJct{$XjO\riwNx\0	2xn<7H9~؞`«2jG6Y.l8g%i\'$\nY5C(R>бM2`}\'M&hrŒ\"E]vА<XMuv56=\'FPUDB&sUExsj.ҿA`uL*Og̐K03ݠiP>Cn_	2XУF 9DL׏|NBY|wt\rӃҪTv |597!<y٧)j\Z\n\'zҏ:\Z2o9<ۧ}B\ZE[8kZ+=nkTHRm\ra; $ĸ+Р|sG6I1-VTWbdw۳7s(O_b?<~m)0.i&itM)7>yufS]3A4Z+ա[|[*tE;Y0!`Y^^kjb8Jr9/K%&Ӣ9\'5lVpEjv_% ZS]r{=^y玎W+@4djg;}2V%}LYƤBAH+=v%\Z;u]5M5M5\Z뮸ƺ뮸kkc1c icҖˢV`4:[+nf Vj%bov_Z>T?gP\'%\'AwsaFbRt\0|WONkm5>>SrPћ2KqgjlS30XyZY63yVyUtmc~̨JWxH7z=3HuQ5<;kMR=>sKJf=\ZN|$Vu]J;H!+>V\0nn^뫭u6BRPآ$}0&&l#aB;PVA!4q^h9Զy0OݔX\"j%M?57/RdG*>Ɍ*iOҿ$h78}\0GŊ\'1]3El-6j\0/9*a:tlՁ:Ҹi/X,!CM@\\lhJ̈́v\n,&b0<%C?brsLhjlU2S䭁FWDds|=x]?!mƹ7N\0/]ɡ5*uɻɖޭc}U}./>7&]!U=C:5mxBnRc;~.VWxX5VR\\xkE46K.b_.Iݾs٩vPVy<=;]o㥬?+-İIn4=	NF=PޣP7#U\\d/4SlpkL%:4q\rέWGŬ3̖z	0jXO⤯v\n4>۾]EV?]yCK|\rM{ON\ZyrZ`c֕U}pi<Ϻt)Oua5T5#g\\ضJ.\n22/ͫz9H!\n\Z{I)RcS {GYթbzXZ.\"X)krg.?o~o9-Ri]LH0uv!gi@u9kbR]C;J\Zi&>}s\0F3\n7r:)P|H+:9Ƥp^|4V>\\h\0tU0!BtCBoZx?#G7ɻG	9[\0lDz+83\0MHs/oqX\0oz}E,LoW(r7B KFas+\'6-;mT$ qElkL[%~qZrn^U[7ٖBѻ=Y\":?\rVɰ`ƿV.:keiD#FKЩ2aJ0,&J,uFe<%LTml=\\{$+W>@}?PITJ*#![	`%\0fÃt25om.gR\r;okf3fcx\\|-Ȑ}?ReX\'XD\\dMX6QI#I-R\"}٦4\06\"ayvb\'.ͮbH=tE[!iiXQ+V;+`!NY$5v\nxmq:glcmǎRnP{L}/x&jQ8F\"J/6lB/VE(z{1ď8,sk]\"ؘF]yx-jZ9$ib\0e\'.\\̐f5B\n9lXC_`Ą\0uP9.m)Ԫy\Z:8NlWS}TNet_$Ki\Z+*olTΫب`r:\r6sNH]+e]`\Zw6A)\rTbo-4SE\"Q\n1:>)`;*8pLο\0]YM.;w%RU|t4۫-evn#|x\\6qpz;,^{ØͯȨ.oaITst\r6/w\0 Oo?h\ZZBbt1yZ6sE8{s*\n3~z\\9׎iGz릚i5M55M5]uƺ1c1/<\Zm~phX3aA\\,l	?WnpK%^bm\r9C7Đ;t[ԫt`\"Y贋9tg6;:?$k\r\\TBPgDQ(ϏRWѺfc4SC$́HtN?A1TwZXc6-}25:ke-Ec;۪E6ݎfoQ(\rjzN9(3I{mktn43ZCsH,8_ݯ&EUueHr4yN[-\\ZLv[@vCef\'wC5!w)or~JE<p/}\0\nV\0&JkR露\\nV&lZg/lln=\nh{N{ЭAWm͘/x;\\6[.*)a`\'dY=,yVjX[B/IM<ajj*[Q2%gMjG%yi&k\\8BTHfBQ1kDٻ0|S\\N֒cY\"\Zi\0J˖v&S Ƌ	۞D|QzZ$%uUc)z\rUT	.:(9ܙ\"nL^PJN^h,$8>Q3mLQd)%$,$PbG\0j\'?YͤB]Wd%ـ~jltpju\nL8.o\rܷ3L1m}zf̺ݸyvŗaރF[YsNU5뫘]+ƨf̿gF:\\)Eæi+Pr<Yy9}C2lvk\0*#CE]F*rmxVCRr+U\\qd4>4I\Z\\1Ei^sUÌO=tYC\\c-K*1CF~G)ߺ].O(Lŝ%9e,ɇ$#)B04EgÊli0:WDW=q܄\'q߃Vm#z{b&Th\\2}~7}OE&\\}o竺%QDZNIGG]Xee%YXA:JJʨӬJ\n:\n Rx)L58[Zhb!렲JtXА[FD\nIw	_Z=*[]2SHZC2\'XMksYDǾY4?R۾*RؽtW-\Z<KZ%ZL+<S\rmi4ӌw%Ϊ\Z8:\ZC^V,T;-J_n`lb1 ?ZCgX1s^t.Uڑ]\040yٻ*k4±+qB=ymzhl*]GALB3Sol$.^ة=0\r\Z;9I\'D#]3$H<;4c0(ZN\0@eܑ<.өApb\Z^ǆmP]@VX\Zw5dj\nK]\rʠcLD_	ڵv&\r+un5gdX*#e2hƙ5&a͐%\0]ަq:RίziBŻ)B~:R<wƋ!/[/5ǑbȖmQE=k}<zHRIA M	]chMvM6]ι=G]Ϙ-s\\pְaCj|ubG?]-l%!\0F:`B|9V½2Z	\0U-B)kEl̗\0JQr\") \"	$h}>7LsG^Xk#:h{_ݻ>.F&@uJMӃF˱rd?UaRK/-jil\'G+!6%aCfEJqbWauRƹ&v.>ګ?%^YB<DBxbr0L];x٥|fb{`֋4ɭMoW/SsTXp,{^|<kf41,f#7Lj+bY@b2\\E.\"01)w|kpoH\n]%)573qWSӕ˫F\')}:-:[ѥF.<7{F㸼[cۍ̷ךܵCF\ZۏRv6\r)14hsHLZ1B@C<[oc9=~7u$_7NivpYڦdgj2jDBnZnDJU{Vh\0j\Z# \n2p`di;Hc}v;Gf=X4F_+k±eӜcNyrrKgi6V|cHDiDMؙo^SIg%\0kVٞDQUWirLzYN^l\n1`ԊICMMoz~&k\095_tOȾژO<\0Y6+r2}B.|}vVؤĕgvu:;?70(FtE̩dzBIEW>Xۓr\0Zٸ̷]^еr\0mWLqyl5ܴ<PMK5?(塖nƾ+(j\"s\"e|t%#ɪ|T9TT9.Mkg瞀8bkRVutmEY	@O,eaQV@sקg@.4b{=$^Rǫ$v	\0b\Z;V0AZC8IʊQY!=ms<-~l^iRƚn@\0]\"| Ēu}g=,W[V+s]^%\"΄>ZŬ&٬I#\\@LmⅡTu{\'==YEؔ!YJgZ$EKӵ&Q::|v|RT_#w]7.w~ETv;?ts&͎ZP@ȭ:\'Y[p3Z9ߵxm_SmbVLL+w.@-Eqǔs5a+Q븘T*!tf76͟:~}O|V\\{BϋZ\n\0gJH\0\",Z+`fܷ,B\"3/{R_SpYtVMW58G?n%rPl\\/43X\0\ZF27&IF͘ӰӠNGʊx|vz\\A3ACFØs~2uhr7	5\'BpRGbY󩶟#eOǭo5mG81\'h##)\0V0  AGnϢ4CVz<tfBv%hTY]YXVϙ]#z_k&vZͶiS8ehM3FbVY)Q$@XsBD1M9~@Ջ\r\"ာ(WjO.nXqO>2iQ839fW7hmr9ysJ 1ѻxw!A߰ݼIeN_bC0ǓCK+|%rmU̴gDaDJPyݝ$Vaӈ+: u	+r&J7H(i4%mL!,bs9\\\nޮi-}3<\'׈e}-/?U:JZ|V`=(㼄.R~\0ѭۧu[g6!EX Z\n3*Z!ĮTg\03t E_DvVӺe+kslyP$(x\nWZSceU,c<^ar>Mpe=m{z\Z-MlO\r0ey0`9.~؇hy#-7|3\\isJrU`vOv֫;)t,SY\'[j*_,JCu`̺iA8kEGl<6K<b5HWl|5M\Z<\\~Aj%Q]\Zi<L=Ĩk ~#XkZ#wE@#Lo&rB5j4QiH0$,\n$%$&Y& eid9|\0j\rRDXx\n@q#4\ZGŦ1Ǧk}1{;I|c:j÷e2,ڣʚ,\ZQځSo{/rܦ,)r;bYwV|]驅׿hӪ#޳dvmq~Iv>˖6\\oh%ҭfCOKG\0;F)ˎl\rh\no\"`yv2I,nUWRОE\nx\0#@ACE\n(k#<:iCE1׹.G||3x.;7WK4VaǙ\'rǻb\0; $ J=c٪kU9uan_E{+ydČJVoZ<d3D\0#VZqƲMgih½ʯvoJ0Vt,=*,\r\"bT:9VQm\\C9XPC<N9Ϧ<EKi&kg\\9ANKJ@{{	zU؏ Ă\\/zJ!^ͪMxͶiSȓe)ˎ-y瞷3M\n^		j*Rb-u2\n]6i%w#^d0{͈1rk9Hq0lqOsS`WZwlf-\Z|}>~}qSh<L &-flc8]38\\\'1!Wi-2	γT&>w,[\nj8iw\\\'*3iop=yF՞e]MRaTd[bdֻ|bwK+7[_!V`U1+Cx;!IRB0a Cٷ}J~K4W3/;˫g]\r`F\0u:Y42+X(* 41\0wo\0}?㧞y]K5)4]5SضRNOW,|~65dm{kfo+Zsϫ\Zם9sGA9pCR	h\"d	Ҿ܀1~ܔ1[WB[	S%<kNǱf쥩~AS>?yh&cqp?&wG5h-Qi̝bTZO<GOFǯӭDIZzܠ×XUl>v<PmqvK\0\\<\rZRY7hb 7}v\"=LMH5m1&v\\q\Z<W\'TMɚPr ;NJn%_9WZwZG+=Ws<YΦҋJHJܟ ^\0	`8+\0ǏM Htxt?4\\ƸǪ}tGzFk%:ɶ4繖T\Z\0\Z\r91\0Z;@*mO?<n)/,ka\r8gLsJ:%D\"ӕr舞rJpIMfQS	?iR]e	t<XXQz;y[><vD[͖M\n-LR>lʍk_5SOtruX2N/n!P;\"H G2*A<r+%Nppt;}sHdޡc=d\nÿӷZ َ`d3a`6z厪$Sq_;]ߊ\\iaONMHgf͹%^m&C;\';sލGY\ZV淚]Ӷ\\aj75pM{mL<)}_;\ZsEF\\¥gykh~;9g;9|Yr?)κ>ۥy{&Z=Z\'C9MEh/7v0KjF(b\n\\ӟ۫YٴU5~nf\0Eq6B)JyA_\Zd+)VX>&\"*aN/`Y;tty6ߎ>Fn0]/׺asݟ:Q!ٮVqoO=Gpq 6X>cj8y>URZo,.*\"\09\\`|Mt-UjqLWX\\U|iȦL㋙]\'iVqi2d\'M;o\0\'6FG2evv>\\6mVJs/]41m#إ\nJdboG\"?)<TGE	ݞ5+Q%Qq똾7=ul; u[].̛4q#V,D?mjI&W~XOAͻmG%}<vm_wgܙ[@01n|Z:>\0~A,#M6̹ιn/?VtY)Fg|4ndpJy}<=GWrGyf˿ZKmn8{Y/mځzIMzW.&[;jMeB%\r!cquha|G%L q|\\Bق]|F_&a]theƜ[9]t=|kg_9oɮ`_?KAL~+HvV\nf40k`\0ܒg(\0g|3;>pA GNe=*A  \0~[OS{`ih֋NrIWTx,<!SEYRE#&Ks-ft:kK*RXU =?L\r`VƒA\0$=4h9\0l\0\0<\05\0ퟑ!|\0ޠv_7yG\n۳o^=Э\0k}gêŔ(fc57Ƚmc͠Syc\Z¨f$kEbjcʫq=\reoSbF؝5>CEBI.\05\0ퟑ!|\0w\\\\Oux	7XWiMVUV\\y}wRB\0䯷UfnYyvӽ:ZIJHԭj9h;؅DUP	$vʗgFo[Zγ5,$Agv!UA$	g5f\ZMWۑi@-Z~ZUĘ\"֯2,O[E)\'c.*؉xbUVfc#\'Lg4-z^T1Ԏ~-݂аktJoΞmpwjv^!JO>(9~FVe|וu0.=@;.{KkiyM&L.G+M$UN:ߺmLaM]mEX \0*U-\rq\"\\gMk\r4EL^:eI&~A84	NvXʲ0?_\n3\'+HNqL^\\!l\'r\0ll%C&dk/M,mG2 @8bJPTTiUUIW\\<k]=qi4,J4qϘ\"mga`ci(ZB\\I*6TԄ,PmI\"P9QDTrmZhj>~8\\i!TxD/B)85.m!A&}rqMGFfΙ\nmt\'zW-2fԤ3~%ҳ\ZR|6eZvr6SD6\r9)5rO͟lyW7MO\0.wԡ5ZU\\ Zo\rb\ru-cA~Gv*a~\'sj%leףƐ*\0ε䋺,\\׽eB.s~)[l\\|5\n\0*uӺ/P*`gwg=[_,u{2*Ð1PEl([[Bgѯg`uobXC d\\23)OVTWhZ ՊiXcB\'\0ssї}s=+~9mԾM\\=Tߏ.XB\r}<ԹlPg&|Yx<eK5Z׵[֥VѢZ!\0zDĴX]R\rKHSk7_7TN&^ac`Z-k\rJ5ݱx;M䞇Q$f͏7g ʕFjw}/}fD>Lf=w$\0\0vUJ\0\0t<zάV>?^$*[N}P2!갩-r6M5i!\ZM1S\00-lV{K4XEQV@-=d2Ήj_Te\0{hUJp흵R!=M6g- ͬ\0m:D7Q	󟏤ތ?RXɚˑ}D.y[y=#}iXH̫Wyb?B&gǂ\0o\"[F4\Zk{\Zc\\cc>?LcL\09s>~S.oƵzuM98.lm\Z8Zh5\r80B_\0kwzr&_QG4J6̪9Tըw@ݞb[\'72K[F0-YR\nݱ%J#M&aJpާx4y4mQg&c#)jmՆ2@٫*U8iYL<E~L䟐J3ORQ)SM\'I@\\94B2\n7q$D$	/$<Nʄ\nA-ULI4=5aAX4R{\ni4(HfBaI,U]*Y@f٬m&XQ4DSW\'lDC:Y\\0UWq2~S]`~ 3;=Ǭѻy(!x\0g.攍~K̬%fQ޺=k]<=,MB(AUBȀXi\06\0S\ZT6;Lqm	:c}3;ݯ6#Z1&ؠXO.X30ljDYlIw8>BUуt w=2u]&,Uj1Đ~r/͚Z4`UY9QV@bz<nK5Bd\r5ܣlmjScm#1l_=$tf\\3hjtŊ-k6*2\0صÐǓ~f/nhk쬌$\0Zn\0Ob=>h\Z[\\ꎙGVl*<_\nd-WךK	3Hk\roWSñ	-hVꞮ%[t}$]m\\glgm6\\mDQڰ+beO\rObcdo+mYSFẄ́kH*کFN~*<z{,~VLStqiZY)#pO%]2UUl\\n:\\4rD|SN?aHM6p\rFwI，l&@\ZPUYCd/L܇%5GNz%PnjX>ujRET!S/{v8w=\ZѩL6iTWP(\0L[	pFzӢcbLC!f%-d(\nDf=i㣎Ó9229i3ɲ0yn-47qâu˳e2xZvӢRwV(\'mx۝3\0+Zbj1\\(*zH{ϝc^#p$٘vfN]Njh46#Bj8254cl靡\rMqklcmsOAz1.-ckEDWϰi>KZ`#R%\0U(LԼHOۙ<s\\ug~\nf*w4GƞmJU7U\0yN T`\Z]y9g ci$s뾸\0Zfo%s+$ۻ\'Anr?.]Hy ՆnOAJmL_ct\n{I!}T\Z%{مt\nZ#et/I x$U[~Y2Yl.ކuj[-$9ϟ;Nvڷ_ծ!x܀KXI77Y֓)<Dڢtv-9Xp[!-8TEKEǁQ=]y\0\0\n>[U]]ujhy&oc\ZI>ǒ|~-gl14_5=\0a3&H#m}!yAM,\"2iH]]ߗVh]RUk7\rh	}_:YMdFXНM|n?a\"*\rtfPҮvMdT߹ý\Zi%$%h>(?˕NL#q^dKR`1(4\r\r6ۈT:K(kNmex\rISPb!P6_]].V؟\Z~2mgp\0_|ÍM\"/jg<_)KSUSbl0P*@A#FFmlCW/\rp\'|mMV~J\\0\\Z`D4	T B^zEb9&ѥx^>d|5~Lt\'(XV\nn\r<Y\\`hx}Oe55*\ZBS⟋dK)[^En/[vLt;hʚ^/?BJjk4plIc|4Pҍu	N\'̷fu_k;m;;j%|kB38eCVY:*Z\'7UkOHf?*cΉλK*F/AyM>޺r:bno@v޴Jch՜F\'`a}PC(c4l}aCt<S\\ʁ\0\Zi[[^vڂxQ-4ht(T4*R7rԞo2(3s飓{\\NDoNKVvѮusV]?Zvd.;ͷӗFKZ-ER)Lq\\U3}VއJ )29r3A2D	 &\n6iQ7那!Jw	A.m)0ُ\\kc5ڞ͍\0ivAӿcE1#[E,m|tQ7I3C4\"I;n`ӳxPv\n*$Izjmm0UhmPjx\0F曈D&94ƻs=P:ņ}ধ6 :%l\'Szo;	Dk·6>@?14V	7]3ѿ\"PfkgD yեsb\\iP?ԏҞ{W	-<ɺy㣧.:^i\\<&\nvgݥsgr$.Sop|KbxG[\",E3(+2<^\ZYIL?`1lg]3C5UJCb9;j}0W0#HrM<}7\0Z}4֫b|2v+2vd`G΀<<?\ZdoFsfioZ79IDW<ZOge\\#k\\.j|\00\'C<x\\382A,{9tM3}5/L *\0F͜D #Q2g;Ɛžk>m}sU1hiE7@V-F:\rX񃮁FnŦ\n=4I&8<GXrr9s\\[Ԫ-|UgE-~lI|js-aqe|w#d՚5qQ%TRCpQXe(\r.\n*mƜ^~ߞc6U\"ޞuQf,\Zoy#p\n\0XS+k,|Zx;\"$`4a^ԓv4sj\n].o}[rֶqZ\\pd^E^&)ZDR[Nx=%K\na1,B%>\nH)$zyGԽ=SKAZ|kfԋ\'\r&hUyK6~\r><眞\Z$&ql=JiQqE0\0@xg~Cf\'/YAI+4INRyAoE]VEgBH灴ez\Zt6qt1OMlL1hshs\rhYҭoHKq%FXk4C I*=\nɈ\'Hϻ2oLD:QUVG\0!=-ӛF-:13z\nJD(Ҵhi:##㧞yy㣨)f	˼ɖ@-vQ\ZI8{9\nCeߙoJ2]C\04玸c4R`8y+û\ZwK6oh[A*6S!өvW9RP5K-;?j+4j+\\MW^u_;\\\'J>-|C<.SrЏ/E\"W*}9Dn22{j6#\r.[\0ÈȨ\"K<4W\0};\0KɾI.aSBmsaqF+sߪ	F/(64ޯGѴҒ~if-eq>-,,5VMXb	ѰUo9p9Ꮅ,P6%Q:EM*\r }Li\\7&Lwc3a3)[-<&B4xΌ<}=A4儯9snnMiH}[(UxZeD&Du~+\n6t^Ky֗jsjތY\"̯^\"ў8s׵+v=o\0Ofnۧ|/}cL\0,R)__+lOARhIE4d|ifNJ[C\rx%FF:wk|\"yuuUE3O\'},GZo<3:|;Z=\ZmRH*Q#u^UNiQVWovΆx*2|_*V:f/.Ss>J_@yD^}ɳ\"Q%TW/ͱ\0;Щ;2m<E\0LEΟ!?U/-R\nOl޽bzܫND.ʪӬӘ[zD%<@gDɘ)\"=2zvUb(lUjЬԓɀ;Q{56\\ޚ6leKkKzcF\0qz<\0uuNwt,*Jŭ+vV[kβ]dw/}h7l@aosZ^bDJ\0\rbF%	\\4Q\\i>!J_]1gލ߹f,ĳYbzyNS~\\5x$\",8@,#9$PyoOSf֥mp8]ZӴ~Z.1e4Ӈ\\N,.I\rG)B}óm-]T *1\raoϗ0͉5hva}	L!͗?7ȭi\nCL/+b_\nԆ\'vWH=.,p,D~<zy㣪Mrtj<\'an5LؖTC>q6\"Yhg4kcny$qlC47NeSC8+`tf\"Q,mdR~3Mҁ%1%}qun_!:rٸؙW9.51\Z	5]d\0%mXy}g_]QMGUSI	\Z]8<ˬ_d4mƺmЧ]V%n%+\rߖYwT<&8/lIRv<k]]5-rG$]l/=զɶ~[)9S䵭fq83)L4D.]?l/7so4${:;\"ߦoZ5y9a-&e9KFM-p6Kڊ[HLћ>Щ\r,3^+/UH0¿eTZW!fhvhpZIžG>lc80ojEI?3c7-.[#oB\r袜)o!}Vց[Ƚrɶ~Cu4k?z?L3p&!U|{.Spnf@Tf7?b}A-뽩{=<UvJlv5Þ	^-IN*aĻlZA-X6֧Ihz5mk\r[jQcp$K-NѠi՛YԜM4w_527Nk-a\0\rkܩ.eΓ@3O43ihZ-:S3\Z<J3EO~nN?\'sYY3|LX>NT=2}K򹹢c&gW<t<tu~ς\'l:L\\p	}ҙğy\"S,~b!\nFp\0&dD~G&awEJ6ć6bq\'ƻm16ǽ5v20L&bjBoY	uqeh=QC4Rn#Q4NBu{yj5gH,8LiJkg1*3%$I]ϗۖy%#)hVAiy;iXŽy)Eeu1hAa!Nlb3u#X}{Ϭ̮4͕q=e\"I:=r;RL@նo\0X`liW,L}Q3j_H>]89R,,5~+UЇ~\r5Mv%~쬖ʩbѬc	\r=L`ӡNc[5#gL9&\ZuUճiƺ\nF9SO3azk\'\nP7/Ow8WorO\Zzi&1b`|,h\0na*yFU\nAw4XjJؓ!^B	2E6S&k&wX]8\\,]i})5ee啈WJ7y/a̛o6Y\\B١{5C%H	{} J0YdZ(zCqn,][.3Ai5Yi?i\0fx^%?4p)ͦ]K^l2. \"NcXH&0DM	6y ::$-)pn[\Z\Z^mk.v1m-U3b-D}rE.K%D8p#Dq:phRiMbѣ#e5뗇ŚisB0C,Q3GZO[ڄNjvrglv㮽x\0C$s|Xg0C<GZ\ZRP==HȪ*kf]R,T\rb$0F\rd\"i\Z~I]j\n?G6i*vW+q\\&_$TduBb(#=mׁB&!%B.~YnX(\r^%[Y\r(&\Z&	22h1vx\\s8QL4o:\"<L42y\"fAPe]TEwJZ\\E96ϐ棳:/5yݶmHr0\'_>N=sO<GP~AӤv/zXujo\Zc%A_9\09gSܱ:OY 1oH+yW?P[]RD1i<9.6nmftX/S>sP8E?͢-#Mc W6\"-OE>jr\r9)jߴZ~9aߚݠqlpRUfs~[-D¹IK٬H;+jUO t=^[ʞkH^]DYAWnVWG]HK]J6iac}v5lm63駩z\r	5a\'\\TZh:IF4Ki)\Zh(65͖)9{^xkj\"	ɼthbPV޷qJ(=rT4&P\"aEg\\(7E?!M5O%\rrLkY3m<)mQk-hZZl.i(v\'O`Y]U\ZӏWP*tY=4E\0\0\0\0\0d\0w\'cOvwߪ4R(hۿҢfa9YUATtpm\'bd[P-\'\rY9d9N}O?m?AoM&h羚Ʒ=_j?\Z>(粨,@v2ŗNrgzKS	i댕WC9Q۲\"Gέ\r@RJqOa&Id1[E#c2IyX\")4SAR&Ldp5\n{ii\Z8DSF(DCgBdXb-pz:>Ʊ?{QYG&W)*3{Xѧ1+zL/fitK5>rF8\"<WG7VO`Fv/.]-[\"Oh-ړCɅ!k~{cBVO	Q߈wb7Vs*LʩK	c\"8I=Ž8C%BPbZV\\a\"@9(`玄GV>0Y0E,^у o4-2wP䏱sTO9\Z[QV)>*IWB:Y̬4XltdmN뮥f-Vpiv*.:+ުg/ɞZ!Nx,XEuVpA{{;yuORV8h(A$/+/rM:iVkۣ7js#$ڸ0|oS=Y|63y<RnHzgrOZmsee2&GBō}l\\Ԃ5W^e\'[0ba5{á!	o(X@ď$KǾg3w:5\nf|e#>Eh\\s710i#B-Xl5wbpm\\+Snx-b(#\"0YĐ)C$4{kSC&ɦMqd43E*B9\n~]Ogey|<fZq7b{ZuΏ[csj`=PJ>8o<)$Zgo1IjLgaKzv#̉%9gcP=gM:*aұss(\\|ڍawB\"0B y\" b0x\nG)}W9iRewHs#lήg2iՍW*Rh_-d\\|-\n3C/\'jïf\n]\'g-opf=&{PYuʝMM#܄;}f\r-I;\0MS|z4frnHӢ<ݥhTHJCD*X^tQh\rٹ,ۑ!`yʳ{ƪϧ5LYJ%fX&\"sX.\n;TnFJ(L&?34ɌmnvoqUՑ2*2U A{YhZBZ6\ZɃβyne zOQ[8VU:hj&_#2qY	GW:r]Ii٘Z?m@=,GaBcVMR^iθL(M/N!]\\0bJ\0]X=n}A\09IҮɬ:/պЏ;1$$,BxtrP$QrJ\\H)D- 6h_qW8\nS@-=1zr׉Q`ϓWPZ@@\"Z/6lΙ-US\r4,ݨOfZ#hlyy)r9vNiWnz{^\ZJ*Sq\rM$8lk%W\0A5R!Y+h\\qFPGhJ14)C$A$r&ͼ|a]֙%\Zrã+s,q;rYcÂJ1~.mGta<HT6Ut<qUpvİ\nGOjܤVWzJLDy~CSJy_WT=\rXmV< F5x7=fzߓtM>\0uO%Etirƣҷ)3^lD+rgsA3ϩPHr%pbP8Զjf]Ʊ<hfMu\\\0nk\0_RNкxZ\'o-*DPy[>OED\rWBZ1%o\\,,ɱc\\`_Ld53V$沵ƨxSO\Z֎\Z%?\Zkt{sfqp[ǀG(J-@Z2#\00(^l46ynU\n\\𣏕㑴K(Y|Rz#Z:vjxG]Eś[mfȲ$Ub75X2f[mAa:i)꾰-JZFK	$ĳww,ܟU.K}y=7ZYe$D2挦ϗ4Ab͞rC(g55h^=/TzyάǢ˞RlAk۵(AuT\rͣU̗^s[Oq3{K2m?>-q,i|C][l!6|Z*#5<SśN=9vc\0\n;,B@HUePHpIjDyh\'FO&xBL\04+`Oy\\;5NQPEG0CZkQE8LcHLc]4]qu1cw#lן;c[É>@G@Ŏp,A XԢ*y0훰LKv~yMޫ^:c@O,^5R4bѻXƚ\n8b/:<)öS[J\nVD\0sQ;*VvqfR{6[Hf_+hӧE%<)$kUtV===t_aJ<Ƴi6Xɲ1Q4O#.ahaݵp5T(! s LJM5؃Q͝,I6sq]iMR,M-ӓ#?f[\ZF4,VX\rfP0*\\]VBg<@QU/(\"N}An=\rg8r1N\'c^\'[oyyOU:5gWËiBly瞵.+W%fB}kUQI0İ\Zd6A3y9B<\\`M_pcͥKČ\0яБcpEM)cieUTBA̍9Yn݁31t&lQx*M(5-j?dp.JKfT֓ۖ5&jOΩ-%36->Br|XkKXaq2t#3A惮!<ߧ<RwR/U;2$ʧתL\0	uκF8ԚJ+ɎK-:͇8򼙥ѦI鶻龺mM붻c9:qgY\\T)09#@DisA<2kr,{mɮIk9ǳ=JW\ngn8q_av\"Ju.=͋P]h˗ejy:r\"<>FLqksFd>Gny >\"U͸C\\$Oܳ8:EU ~71\"O+fy㣧9[6LZn^u5v1%^vYX!s4W,v1pk	Řx~f6PgB.=vG_;)ώg6mliY+C^v&4j*ۋMm[Lg\\+L<&1ݍ8l\'V*=tC[5T:(`h[4\'\'s3i\\UKZ_1ma\"pNC10lĪej,9Ή	bZZa~1<f;W[l,oSK%R>@|ڳE@/z)CGoAQΧ4[S69d	\'ݹsiQ%GYxד\Z[^z/se(rȹ:+Gɴf-i2Z-]%0`˒Ce.u]loXRU΢ngA\'Vk`ۉ7gM^[])=YZA=^EXic\Z ]V>Ȧi_6t{}rƟ(ݢ	6$aHd.XN\"$]Λk1:cit\\>7m7\0=v:3yz!($ح1v{@U8imh猀A$]:	pkVh//u\"ÌLV^UTWI6G17R]LF]^7W9_v\\:cv~W<nlyGJJ~3^{%4DLQ9IObHX9b=94m7lm8ϽlVwA`>O]22H ${Ɵ!1K;W\nSZ%^B;۬\0~\0da[kee%nsǍTf%EZv\\M5+ԂcFb0,	 Ax,a]y(m]qkTHrk3\n8C\'V#(v\r6ˣvp8ĊT欙LuW{+3VoΩؖ\0u՗g>ܬt0Tnb͗#E?9.wTخ֮I]v6=[_A!>kgGg%-5GCJnwJ*S{׬L4yϦ.e5j81#.TNҪ\nL8YC%֎\nbs<\Z?i6kρYJl*vRJc[q۳*sp[%jk~U6)+bP0jVC\"J@=p$,u:V[`\"\nEA-/`X@T﫿:ZQEyC\Zs/tpXkʜiV5f<]+sKXgQrffQ&@Q<Kِ`NEꚽhk7v7N-t5Ҫ\niAރ2ka~c+tEt-.EIT9QnFTTy׍b4*ljxP%$B$Hx-rK<٤)FI5r4}ϑ,绊2\"iѿnt|߁;%Zg+(q0!Ui,<޳<pT俳	\"a&\0i0J~kFhPk!G0PDb-ECV1stG>}Qd\"Jʆ/RF*l&d,^MtzlWOD3O#4Nq~|ϘvFn\Z`1;G+̧`VL򋲫zLJq6\n>a)Fd`43iFIY\Zgyt>E\0\r5K5KYk\"yǬ| fS$H4u76&]<LyhuZɫk	IYgU`ZԷTWU1{`j\Z5ų\nRGŉ AJA$0Ǯɾ9Ս~oi@vV@ !.vo0u0\Z\rqﯷ=\r(!L<uxhaj\"` a]Ŋ㪬Ķjf-D7lnB9`&\\O~\Z8{7Ya\\̖OduU ՇӞsgf7ZӍ,P[`}Ϋ4ك;1%1Si/ټl5Y-~SQ&T\ZcX9i<!LbLhc]dȲFa3,kW5J~H\ZH#1Bթ0kTCUd5`ǎj՜rfzin;עN=c=0<%@\ZёPhy ܂MG$~igcDi.Gzm$I4=4v}8]5m118=\r؇kࣀ|hc`#	6	gJuh3#:\0Fh$զ$PD7f*m\0jXMy3kӞT]ma4md֫_ح|0bk,|kbu|d\\h)CbY\ZyXN.%رE)q_s7w\"̰ƛ5a\nshDT9+2ȺM<+wϚ܎F۴,}H*qYJj<<ћu:|I%vڠwI=3mEyf\0+0I9ktoV.pz`pDBLɬK-5NzB`k6ZJuWрe zA ; \0=St+˥ϛJJ_Vޑ;o$f+u<Sv 18jxĞbW \']SS2%E:	ZN7\"9I+l_yGeaԭ?feV毚x].^mLE;ڞғOS9\0_&~jαf[~=>˟{y,dL@ߧ$=m+.& D%t=jGgY7r;U}}\Z^y]M<<׮Xa\\i<QM6KkMˍwİS&1E4q˦uMvpQSZ\r6;SGw&1j^\r֌,bQ>C%,\\&{/EHƬXʍ&6n?Ba{\0=^X\'8yأ-lkњ{3o8jh/yJѻ{uW#ݢn\nPXCwZ0h\0z-8itn|8He4/V>h,B.SهÏ{1qă(y%L9Ƭ;e/%њ}W	uhKKynˀ\0QCP)f&\"aP!&\0\ZU20faF4azκ\"i{$zz;!AœR9KPbi}eTfKbdD3\n\"+]@Yl.vXj4y\n\'evT5 <Y5q̊٪I6͵+UIQR5c\0ZXf\'Blr&4-;nw7hB9f(#Nnn/2g+bn+fS<|?/n\"cW>_\0i\'=da̽ɩjo_:ä2R@\'(n\n5E\Z=.#SBٱ+\Z2,\r1ӯb:dEɤn@&4-0\\8ث	=uΨ^\0;\n^{796S籮/O֥;V3o3IV`+<[*dʔ.g4ZgVm΄E2?F*ȆhZ]NX\nY!ܺ##0*YXee I؂A=MFmѴheY*Rn(C(\"וF5bк\'iصo\08PF7~i:~7Bd\rleu6y+g]\"~}qb8s?WMd֯wH}M4m}i3l]qmcs=_CQk%3,ӞJ^_Ӕ+9\0&Nď.Ă\02M}Ϟ^2\0Yn{TG#-t_]JHU^9O`6,9]]Dv5& P4/$Eء)K_R򯞪%ԵwM}u%U`S>|ua\nhBut܉giȥ|VW?՞Y\rJnRJ}m@{YWHbR߭T]w!h\ZZU5kW\"ERK@.\0H0\Z(aaH]u1D	o)V$ߏώxs_=N-+ȕZ?rHǃ3itm:Giʦp̢IQc]nFޕhW^|{i.[M)9\0@\'zX\r#W:mA}\nl	4jƲ8A=]\Z1X\n0 Ŏ-5xI_Ʃ5^ZeZ2\ZB[RJ|[ֹ\'lؓ-:c̲|FWyU<ޒI1,AaI&] aifyXIemtMv}3q,6Eݱ[jC	*C.KOɸX؂p(hqq*Rw SH$xfqd>Mc%	l(H]H. \0\"Ƒoetz&֓$!2wӥ%UhiPoܖ-s1:V{y4}yd׭bik4Rwd<f?BtCH$[`B-f\nm5b}d\\c\Z1c11cc1|Xz.駒9&	@hb׿koHi[h}Zuq\'4[T>C;\\zC<Vc}:~#{ڷѯvu<_O<GO<GO<GOGmU\Z)ˍ}E$\0d;\0rl1f;!Z5pK55D(GiyUW&::20^ AGpA AD:7>l$⺯\\a\'bFo\Z\0AQ7K~}p(ns-;H!)pљ*ht 30\nY8\"9(ixwXMz>M%#~7,-m1[d7\nu9k:yVXsZjߒ_\n|D393͝!kmUdVl\Z`[W.?DC14_x\02vP^z[ժҒB_HЭMDSe-\0Ybű5\"8Z@v.O\'|od\ZJ}ыbL\r޸ɢ5}*ݺ]_Gn{_ B! ـ=<xxx;ccmd9ב9Dv3^Gُ;h@F6ƅnu41gʆrfWz\0t2Q院V 3+/x((\r\"u>yמY\rZw\"c@4ْueU-?G 3FmـRq!}~quI3035?J2*箉nQrȾ,\ZI1}:mgM龛c8\\3qIi5\ZZG\nEY1sU0Ǧv\r]v}$olmXRjGc]Y2sv=#lXkGʴm6`IGG&\0Wd>}YY#\r0n	q\']u5qT)$\0\\2WAGl܆\\̠xFBFbSmTL$9敕irXɗ{!⫟oe-;Ab=RvloiY;?95>YwYY釩E\Z\ZRmhoՅwTV\0a5ƸLɷg|<\"ܞ|+LNn(i9~3zŻ6h\'K7J#ʉTFQPcFh5߬Aוxi$E`?YWWUunsJ*f1kNp5{!\Z]+\Zच>竷%DJiQ6S\Zhinp8\ZSNu\Z\rU+)ϱ/|1Uk`eZ)&*X~tvqJR<`!mtWmqh1n-j ?㛏vaz2ȫ+`BP碹QxE\Za5 =u(b]c8H]u\Z=$I$I$I\'~?St=GO=YHΓRFԑq|jPOgZgɝb\0!sdĸ\\EB;BDN\0bAC}4Rg(]\0s<}O-{\r:o\\ymU8̽PŇn{<ʼe0\r#_[7rVȝP\0oR6l֥\0X1m98\06\n!ǋ\\ILg8ZB\rq].gʊN[M ^nL683颩r\n1ՆǱ\'ؙTxR<8 qZM@mB\"hG:]xܕؠY?7r&O)֖8V|dD05Gǲa\"ye h׼<\\߄UQ^n\\<usZ;	Hl2)Xxԩ?$@(Gq36K<>x	fUZgGwyQى%\\yMBY*{ozEU}/J^<GrXMՎy玎y玎y玎y玎y玎y玎\n~ڕjԉ5]n\'IZ&qdpg]sA,[ggT9G\\nSaT1ܮGQp#Yǭ|&So艨!\02UBۘo>tF7g\\\nߏ)DUgՍ5j+>m6Da_Vdo$*{\0*ISAө\n\0\ZɺR`Y0$*EVuמ>ZjD8`mAkE\nlrQ}SjlrYgq6G؉?Pz신)S2%3ida8M-K)l`X䈐J\"=-vlba!ܿ1~*S@ʒG`B;\nP\0cj]EXt\rwa=bjk⴦)$iXmg\rM+|.{U.x^xڪ~\\$,Nw稺\0\ZwH͊_gޒn\\/i	\nL@XL,Jqz)5tuzrd۷M\0e6 5ǈWS90mXp_갏}\Z1[\')]\"F[F|pU4_o=$\0b\ZlO\n0 }vQ^h˨n|U51ZGX8Q2X\"Z:gQAge\0?m低\0W\rVx[/4mϲWD)\"][ۉe\0?ǿ	\0pW\0qݛe\0O,SgM?e>Ά\'_~{\0?+\Z]	9BGfQ	݈qRgA(K蝖@y5Gw\nnV\r br3G.J1\\&2<V^|C(!ʕ^oDE{#l\\H%;OLxʮ5pgj߲Sr[>Q}\0`v=l@\n.۪]9m0.%-NZ\r#ƚ!\Zl5E+ag\Z\0-5w\\u|Xrg\"iByd~^Ht?	u&go[;[e7rY^âJtj05	K*0?dSGd]Ȕ:-GDZ1HX@\\n^4&sx&Q(F]V\n)d?UEb7L4	q\n5mۄ&b?#ZHs1lպo]@[AfnP!3=/%Am|q%\"ACA`84Lvfn%hj> jl1l&PNOO/BO|mZ1iw5ʏ]7pa߰o#HTyA|۫{cigMLP(TDU[uYqim;n/ȟK$u`BVjL2M$r6*9eU;vK⳩\ZND$bXH9%yW1o.Zu<Hc&X3x×41bLv-e31~/P[Nz\"<QeHSBH]<k?2~ޡZӈ>.5Uٜ>ʵazMk%θyl7ݘGǷ*C)0-Iim+%W`}e-m5\\\rbMey(+/	qcCQ6}ϝԀhNvY\0Eh$JuTprC4(ę<ή(]˒@ThBKQfbx%b<Rʦ0#ql63)K6߱6=a	Dy++KYKwZ_`\ZyXBz]~+-䀬yyH+F\Z%-v,ݛ1jn\\Fr\0;&TΈi4$hY)馵zQ\"֪S}{PJQihH95>s.MfHaI\'P)\08\"k7[攅Acr\'YM{ḻ:qGicsr5`OΆKG]@zQp5_@Ǔ\rx2xF@LVEj3O<GO<GO<GO<GO<G_','pedro',1,'example57',NULL,NULL,NULL),(179,'%% Example 3.12 of J.-Z. Zhang et. al., Automated production of \r\n%% traditional proofs\r\n%%\r\n%% Pedro Quaresma 22/2/2006\r\n%%\r\n%% Version - Full drawing\r\n\r\npoint A 50 50 \r\npoint B 80 50\r\npoint C 70 90\r\n\r\n% Definition of the equilateral triangle AB_1C\r\n\r\ncircle ac A C\r\ncircle ca C A\r\n\r\nintersec2 B2 B_1 ca ac\r\n\r\n% Definition of the equilateral triangle ABC_1\r\n\r\ncircle ab A B\r\ncircle ba B A\r\n\r\nintersec2 C_1 C2 ab ba\r\n\r\n% Definition of the equilateral triangle A_1BC\r\n\r\ncircle bc B C\r\ncircle cb C B\r\n\r\nintersec2 A2 A_1 bc cb\r\n\r\n% Definition of line C_1 C\r\nline cc1 C C_1\r\n\r\n% Definition of line A_1 A\r\nline aa1 A A_1\r\n\r\n% Definition of line B_1 B\r\nline bb1 B B_1\r\n\r\n% Intersection of AA1, BB1 and CC1\r\n\r\nintersec O aa1 bb1\r\nintersec O_1 bb1 cc1\r\n\r\ncmark_b A\r\ncmark_b B\r\ncmark_t C\r\n\r\ncmark_lt B_1\r\ncmark_lt A_1\r\ncmark_lt C_1\r\n\r\ncmark_lb O\r\n\r\ndrawsegment A C\r\ndrawsegment A B\r\ndrawsegment C B\r\n\r\ndrawsegment A B_1\r\ndrawsegment B_1 C\r\n\r\ndrawsegment A C_1\r\ndrawsegment B C_1\r\n\r\ndrawsegment C A_1\r\ndrawsegment B A_1\r\n\r\ndrawsegment C C_1\r\ndrawsegment A A_1\r\ndrawsegment B B_1\r\n\r\n\r\n% light blue\r\ncolor 0 0 255\r\ndrawdashcircle ac\r\ndrawdashcircle ca\r\n% violet\r\ncolor 255 0 0\r\ndrawdashcircle ab\r\ndrawdashcircle ba\r\n% brown\r\ncolor 0 255 0\r\ndrawdashcircle bc\r\ndrawdashcircle cb',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0C\0J\"\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\04\0\0\0\0\0!\"#	$%&\'1AV(2Q\0\0\0\0\0\0\0\0\0\0\0\0\0\04\0\0\0\0!\"1#2A$3Q%a4BSqCRb\0\0\0?\0\0y玎y玎y玎R,]SuVD֑̲%AwΖuµ)\\-j8\rs~a%~ChvJ6VBl+4.ɊI6qMoGgI4Yks.\noz<!e4WA٫^#ZJ1>&N|T;\0VoǸ\0(N*|g48ȚVB&σ,c3.dRwira<;˽bhҐc-orP:?rpO$d]E?Och암o`Grd̔Z2ȷ Ժ\'72|]N\\ޏt.<gHÇdC?+@I<:s<=[DVNnuE)wNN(+BA	>H51Hk6͏K~\r=K#	O_%{eRǲ@w?gë#UuNo\n]pJB؉JMFئPVSC؃Ա$x4R8Q(32(R#av)Ǟ-hmwm{xG#nۖh=(4!ӸC]wGWj	?^\0<Ժ맞y㣧y㣧y㣧y㣧y㣧y㣧y㣧y㣧5B-X]ۙ\nXd\Z*ÏrD\'٬h.%6dPqǼumWzF96_k\"x#)\'[vq.Oգ=D)N\'P_&q+Eew3yגQ;ffqdҫtu+H1mo@80֞9njY:+ߨWjH!+ek!`^\\qjg<\'.7UJFEN\rӢ?zdN02vGQtƁ\n٣1!}MZׄ\0S@Z\Z9|RnFJ9l(k>1+X_\0g6!Wȷ7:yIԽ<<<?Uq\n*s`C#qG=F\rvdه+gVk\'	=>ٲṪIn,&^3Ř23KQ:\"q. !jp1*Im75|\'\0<\\zUco`_tvuvN^+0nڋ2\ZZ闦;qWc\"ᾟӹY\0IՅ(Y(b<I,㼫9fiae>>?V{ݽU;G\0\0o>\04ЋN.\0ٵjQR1\0NYٴkǓo\0AmۜFϩ\0lgp{DV}/!\rOs+i5&qZSʨFkH\0vm`xY`3}äA\ZKulRq}#W _\"hekNfG=M=IDսhCVx^on.)y̟נS/M\Z<>]oO|ࣅ;_@M}|\0%!A#?JgZsމ)\\EAXvzBGUQ\Z \ZDC`hqH4!6}m\\Ɉ\\j^ohUJŃso{ItZ&Biש(vXk!NTזԩ4hMrHI3NY\0\r&I4ASgyM^i>Cdq㒴i_;j4/}3O%/ӏo%V/4nRʞ\0@$v\"{nnWRͪ9HSsf#On\\Bق<Mgc\'\"F\nG+bu.fi!#͕<>삶\0aC$p>j3n5Sqx^7UJKt\ZZ܋꽇mdݼǰaX\'oUJ\\7h)KKTW\\$,~;كO/fm̓\0M\'	\" 5)(iY\n8ܙ\"܍m3&:Ǧ1r![x9lѧ39=~ҁf?dwfOPgs;w^I0#S*HhHxx)M=}vl5\Z	*K-qW ]lU^D؂ؙ\r\"N,gK!lFwsɰm_Ie=תF}Zq\Z*D\"hŌH52I-$\nR\0ǔf|J\ri\n,+e,|o\"I#̛c\\9^SRs޲ɳFi(+H뚠S=\0ya߯Y,eó\0H=D5\rVSXz$[	\"ub35mijc0Bn4a1<KD*]+G_5?U1Z@<!Rn>hV,΅_Q	k|@9u0GQ*R\\{\rEWn̦D#D	&Ce\'4U\01[5VHM/~2mM\nrtM	33?5Vgۦ\\)7,<֪I\'o)^UeB){fS+ǦcU3|@4*^;Ǳ=L^qy;L<-Tu4\'XBzJQmC9UE*ԡv=z\\@Ibm$=\rTm\"%8>m$3Bg3\0O\\PCDӜ,E:űſuI}~Z{8Rc_eic,3m{UBT8/.~&.ҬRx琭nWnac]U%qI\rOWڼG!G\n};6O;eO-F[w*k7jm/%g#\"\'0Gve_Ỳ{{;nyYS;\\{ 5P9_ߞs_oe7kg^t^!g:.A\"ZgHVPO{GaIVRĸEEc Pi;#!J\rTbD|9ۍ-Wv~#)zZ\n}}ﶮƜZl nۯٗVX*Sh|b\0ķ]y9oIY>^tM\\Ѻmr-~R4^1{^-=(F4g>n*~+,V\nx~o秐Vg-j묳4R\nri\\olͮfyϑ?KSŧnT{!P?^<QMp7Kْۗ6*r\0o! )3CM8IMdfCRuIS)dk[-В-l̫lد$C?h>y\0پʇ8:԰-iʽٞYm|Alu<7>U84|Z2MX<2SV$4>Lțʛhay$]Céa|`00M\0TrE\Z	Vͥb5#Mώ&uD$}yd87-R&sɳ^3<u`YPbB\"RҐ;q<)ڍ9s	k\Z&j>SIҩҌC(d%AFybK!_qf^ǒ05us6[jMQ͈1>q_l8\Z$1@Iڞ I3_[y\Z񜜤,}8qڶlPi`~Zj<?1NHd޷\rif#@V-/yK<K6a{#жlDJm4ӯJ$\\6}QoMym٭o*b1uv%yc.>\r$qxH;bHeh]1>~C<miҳv&ZS=BYBI<\Z46k9yN?e)#KJ_:\na=\n+\Z+MVzWy::z$J湽l?+:yXk59L/H6ZXe?K}\0c1ԩM+|EAwƖ.QdλsY\Z_5`\rS̴$F=TY:Ҽ#yPT(k5ڢfVmP\n-omiyX\r1\nNSlHR?떻rNa.rjJQG͋`rӚMpe\"R8^/X]s\"IHV+?cbZ0	`ҏWl.\Z\\u	ǌ\Zݱ*Yl\\~i8joW/ϪEbˮH?pjVkFαdVFXh{$5Gv=pTvwy}I<<ko/55ե[f;Y[jH,g7p[!FWK*;/|\nNe}CZtgLLiZ79BT]zJٚ**U X)n\\-)3SۣUI=gnC.u3k:\'%&0@IAfb=GOPK=.<z[3V-\ZY	|.~ϐTۙNdZSZ[Rݒ(+6<?&lXzہ/\Z[YWC?֋?sUT/MXlYd\\xWmRTkDʮ}XZ}FZDO\rݚVCcBiŨj0>_\0U^TSwc/s A˲|wY	j\'ą_e0F5vVt,qeȶ8C%?;Þ-i,vy:xb!*D4BfR|_ƞg#s ڙ^ӅU2\0vA.ۣq,mȏDT*|T:.վam~5C5\0Q#X3\0YI7Yt0JMe{9%hHfiC%W6!Y-[M5T8ݾGI(_M)B;E;Φ]b35kLZ6a0ob$?`6{ow7b8XόBL(Qhp>ϟю\"-ٝ\"io	eI@$FiHR \"\ZU)F8~ֺJ/\r]Dy+R<]cԅ|RbUmɶ\0v;SE뤱6ob㥰PJݧ\\j>$fny/r9;EeA \Z	7A튻fb$\'x۟&)Z2K#rj-bhLIdW\0S`Fbw~_GH zՌ9ΒmSO#ňb|+$ÿpK(UΧpI=&h卉~6 1y~x=N\\g~2|{@|&#R~p,|d[m\r&ie,I$oڒWWmBTH]4A8\\7=1ƚzI$pǜQRI$tqMymcci%M=5}Ƹq23Uw,\0\0	$}fTVweDU,*{\0I$\0s׻疺rPlHNkT42tard7eqonSRK5Lpji-7B{)$j>7@zh:YuK!H`݈,()L\ZΘZ\Z\ntxi Ճ-Ԃ~Q_ldLC_)wJAGЩДer1>i=\\6Pk*<+\0ulNlk\0ǈ{l7RX	?I\'lcPʭmjoKf 7llgSI(g;%16<xm y$`֐̂ptIb]4lՇgJx/wafƛ\Z**U\n\0h\\驖Eu\\JVCUѩ[=/=	ݲU)SD6iJjV2Zb)Z.HKKaD>^πFSf#+8VM^ߝ\0>g׶!-3_k>)1G.̬@-PPz~c@$f-	TbJ^cp͢:9GPl0Ռ\"&֬ʹ|o|&5sUm !~=Tjtߐ_]-xVN&!M\0T8Ss\nZfHf\0_~]슣j_ZD.c{MH坁Թ\0Yi)?~11+YҒuD=ғfGS\0*C)\0 ܀~?P?^t[:c])?CK)b[:	+*k78@nSF0*ԏ(|wwJQ)5^xqWn\\`&pۦ:Iиg o3ԗG\\ĭ	j,e\0]U{!TAS4]5ؙ$eI^H\rJruk4eX8G`Mg˧FGÕZ-ȭ)想D~Ԛo_P+U\'粁3!cjf|dtc-{24Kjg1=G2:\0<<aQ0҅R|\'Y~}\'\\b,AZ/$*=&\0цF3 MH/U;;mi+\nQO	ut4R^]gFxJQNS^n(~C/sdc+wJJ\ZLJ4x˧yq Q)1λc2SӪ_\\-\'=:c=9EVY^Ʊ2`úùw;\0~R=3r^Y\'pªwE\rl%Mɻ\Zi4\"}\Z\"lGkZ\nfPxwE1Cn[Oǋ)gH؉\\q:,PZ*5̸\"uJ@籀;\rFQC}s&ch(XR+fI?H;>I\0#\\{g2i8=xi1zzF8/ڕʡ~Bkku:v4\'~ntuh}&47oY	xedZ\'sÿUɰHk\r?ɧ9L,KCDðRo\\We_EOȨhTMl;M1Q5MǴX#Ho.OZe[fR}śAHگ+q+sŸ$o\0ohXΰϩa*h!}Va1Zf$@d$PAI\"=s2G֩fy}{`|~Di	ewuc!\"\'I«w3nڒtt>G1-Ti?\ZR=)zvhJ,n!B3$D<P}f3.S	M]ՐZNq.tOh+I.юGE	{#\rx>f-RhtO33-bpVhͪ0Zf葤[@ݬ+!mU9D9?Igmh}4u&L-8r\0+6e:ux\\@-N=sNm3AqÙ ۺίO\n3U_.*J0ks\rvEyo1,~L߬T]\rsUBId>!_\rnH/g:c\"A/ZvySo#@馭166QR\"}GZ;KCXB5	=MWn/I L	5jolw0eQڷys&FMNC3;ITԁ֧ {\0`ooh{\0yCԽ<<OLY_+eO[j*c`U7C^ҧ5,IzdRdD;k0b!9fSN2ɒEi],yڞ,UAWrܳR\0wf?T?\0{^zzEHku(:v8BȪS.Nl|^Fha\ZҨ$oZomT^p{vM?Ӷ_.	*z<({jv(\nT**P	m6	nՆE_+!`w0i͜8362f @Y@\0=`טQq-2q3IV~\r6~SdkDWusre3[N*/e;3ڣԬ)TbOw⽔=GP{/x,Lעκj1L&,H\0\"Z1YFS_IiPh]MNުrn̈́Y׺LGN=JKYMZ[ƭ:\"vm,+b.}BÚ蹎6xf22iNxXBf1ʏM)jV*?RGvIH!O\"\0ȯY i6uǽM3]VfBXnB#ñRVr-k2Knr]%D:=~Q\\CTYC@(+Yki=EϿsZ)#6l+{T@TnFjdN^UmT:T!0koA4m~GǾӥ\Z*Bo_nsFPI.e\0٪L?f	z-RI,k1#KJ+!cr\'o\r#%良?Nl()\\fKuj/VcS\"%&\ZmR4s*2@O8:,^ܙg*~.qKYgJXĺU!Mg\0k*OJt=*7D~ZA#!~0T#fuZ!kluj\"׭f\ZD+P\r9M7Zv&;É;V	\'dAHFE݊@51< וw^juC&eEgv\n31\n;b{\0\0H\0科tVYʗ葌bZڵ`\")gbA$i+5iU;.tkKlNE~E\0_zUvg¤=71si_\rAJa	Kҫocd,mƂDChL3xք7WB%0\'TZ:nQMv~=m!$Y*y=mMtgKGq6>RwHckyʵg}KBJ\Z\"֥\0y)[+yG EĳĤeK&.tGЛed,H2jS꫖3cR{iD$Ps\' jL_]3FPϙ}\"`Bh{h\n<]~ =]3o,%,;5C@#T#\Z]LMhX\\GӶ:\0c1*g-24\0Lm)%<鼙7:8XV\':R੤B8lBHʂxؘ<}>4/TPqǣ͢k2G\"5;SeCޘα\\8ˤEH[mgxWzI9-o>UezIdr/4vsZ퉓h+!\Z} Q2	̱So#YhN?گk4+@C\\ڧMz3Ǌ)ۧ|8M8y^:\'%<5x:D]<#U)sړ696\ZhSM\r|\"([=Ϯcò1Hlk!XIS+w\"jORiV@N|͎M<QC\\[QV$<$<E\'X`n-C@~9[.n2i\Z-AdYssHA\\kq3<F{cͯH_o]?\"[jb?Ja?x_SAfϰTD~;˂^}\'<ڂkkj=m7#Q+1=:.s\Zѳ17݈>Xۓr\0Zٸ̷]^еr\0mWLqyl5ܴ<PMK5!HAefw|\Z2B$祧Y83N1kaicxϿC#-͈ɚ\'eQ%mO$6`S[H^P=;UUүaa=4>O!M1]A)yt/lb tk%E;u%ӟoV]><y3*ZWjM>ΟmkT4qEgM\r\'qv%#yJjləv{zߛ==6n-MוW~4\\2V|J\ZV߫&kĶrz/֙4ntr,>|\r07PWOG<HKÚLQ;gMJ%6\Zq]]E|0OC&b}^E?ltvpΡ@*Ц{ ƞ48柒bjAx?h݅`U¬4_;ѝ2=[fzu}Z@;=rgRnB;Ѥtwe.hFjΐaY\r(dMagxݚS=y	\ZZ[fv*|1&z\rȆұpR0$2QbUWT+՜&k%\0lOcvl1}9ƾG\0Д\0o\0X?=ePxf$\rl.\nå;p%-zUQ#~K>n\\h߾?fi\r5_ϐ㕼,<wzܿ(A$up9aױs|̾Trtj/ԾzfQ;VEbay,LL޳oW&@k)8]aE`Yl\rZӍd:\rJ?1epoˉ<}w\0ً0u\r\ZM\n釗2I\"0֐0ohkGNfIyQ6聕:(|ѝU؟52\'|)$綼q(n\"oO\'\"K*KL!MVר+_os+ZIbǺ{M\ZNR\'LcB:8ei\0AIsZl%;CvfhM>*@ n$h\0.t\0(HA7W_\0d`>ԑ?:Q.t1מj;-(\0vBJUUgGC~ԁ iXyRx@CJ((/z\niqA\"~g֎\rd/OjǿAe.૳ւ_rϬ]ʻ9,t]~ʺ$@[=PuH>Hp\n%?μ>u\"meI\nGlIq$h$ieM1wBi]\0XSsRywCsU{s%h5Zb5	W5pjk>t5.Ht*E1ui5TRR	om>r=)y(pmƪGz<*0\Zoѵ\Z˗(h]jjşgXS-N[vuVAIQ 2;o(i)L.z$-4\nƨC\0zF<VumX=uwc	R]\\$2`b5k0Zɍ%YOOcbt5Uɞ!m\0cC\'Y%+lR.M${=\0kpܣ-J	I>4sn~F->Bm3\'-$~]\Z9\Z\rW(6@jr[~|kޝw ozf)ROX)gk[W)DX\']z>vLθi-KS*!n>OeZ\\}5\r/jgy`d--ܯrT_npώ8[醜Xy~;/_q|\0e\n7Enz2𡺝\\d`M3*;ܑ\Zv\0f @xm/Zގ&v~aj^˿>Cut6w=!BW+ VI	x׌Xx^?2rv]NsvtL.Kڱ[5.ږ2w9㥏b\0o(~JI\0$׿o\0C<zy:::LrZ6l,WWh;:FWa?b1hP򓓜TC	P93h+5\nXl3K0rN\Zxk{BB9]Y=hhC|7g-UMJkY\\הXf%/#CЬ/Of֟vK\0nDӂ\n䴢7Z%)78A#){Fo=?H[	<0J̀#ȫ\0=~zYe&EFF!TCl;HSqH*}R\nk(B#Rb-nǿ;2_)T*䃱{::T#QZ՘DڳpWZ4V6Po#W91}u\ZIݮ3ǱO1Wp\0ҳ+?HJ	|mҀ\nF6;TۛfB*tاE=.aƳй)+-S~VF*`x)9	z7-Ҕui<k\ZUcͥR8Qs#71!}YK;a.\rC;i\\B(\0,7	=5_B<\'?fD`t~RܿM7%}sNU{<\"j3o$x̭6t[|bptC9=;w=T7;qvVnb9CZN=y8ZHSQfWks,2S`,U0.k6{&?*/\\{՞[NNvb	\\ҶZ\n\\D&a:\\$ğ99T_4?z2>6zBdsGtA6[=\0$ST`	Jie;o/y)_J@BPݔuZ9_\'	pu,Q\ZZyZd&~_;]9~Vw*lnMWƇJ929߆&kuϺH71\ZwFuhբwjDϕv5md6A5dP,:5 FKJraZQco)WT> T\"cʵC5˭<3%tBJ5.(&י2Pddb\0ѡ/\\i8&qD}6r](]}ƺ9u*tiΪ&µ膟\\͆ecy<Y6b8+KǈW^hgPf/u#(z~IQi+i7Tk>sa-ǠR9Z3&T~爞.	WI\nY+ds\0焰i,i	dM7i5\r>AVCٲ_#>\0ϕȖ)mvd\\vA_P.ywh)c򫼛dr\rh:<= qq*G$b\"q}6h\']vhfm)5I4m7:8ϻٛ|qؗySsH\0FeĩyY8pMoϩmr\rÈC)}Ħ*@f`;Ef`۾rY^Z`ǝWnM]=$ZieLVuQvPygH{z5n).L3r]Q9No҈t]n2ӽ-r=vwƖ\'b;b*vzU@	M]M0>,pg7{93{K07\\cCmrGJFFUi\0VUTUIN\\v̫T,(-fj6>pE0A&>tSE1Ѣ`g\\Q@*٬S&g\ZST]k3iL&ߑi\'E\07x7uO.sՉ4nI-/ƞO+-f[izթ5ғ޺Ow[\\4\0m,VgK\"$>m3^{\r	Vqɉi#jgdYS&I&SKpc!fm)Nf6*LnN\rak%j͇BC8Q匁I!4-}vQk#2JRU.U	_fS|m>V\ZifVFk:wɻ\nl͋D!-XN+F\rsWĿ-\\_وz?%t\0Ɩ38jP\0_ߏwJ<;mq6MCY\0ܿ>GoԾ]ʚ;s!,?S~Mwߦc2b]C(x;qr#k4&vEM./us)m̪ĺJqk㞠!YED-򩪷ֻH)\\U\r;mU2d$C8I(3QXM]w]}HEWy%:a\0*L%bs#2$w\nK3d:[شe4oV\\_#g%N7qE{ppVe%T=<^e8bXv*~? @0Ha6qmuXy;9ȳ1gVOrݛP.*VMScc[`iiu+}3jY\rҁ	7<NhRvOdE(yf_U&2+\\ui<|<xM9WsNmʍc\Ze1bmvm*]\nw\"uoSav]6Ls^r(\0CLjs\ZtnJ&wlVKE{%a>AUԹ#*)$q~]EȎS)ch_\ryX8MxߚFS5U>0-m|7-7.v\0Ix,[`Oe\nP\\peX!Ln\ZhټUYu`=tJMòQpY}SG/޺Bɒ?MmJBR׆E̟?ZnJE^O<1]Ws<q{rxHM,TSg9Tǰ35㧩JW\rB,|J(z^m+SXcw>8@XOJakbp^NFmqM\\W(w}UaDI7KUIjt6>oǎێ6Ub\'%9\ṋ rܐN7rX+#tR+u`Z9?}!Uu;:eW`\rx=س^\03g=\'ŵν[i̚E6UzwlC4[\"U4IW0FZ9K6Iqv4f[[11,cͰ6ɶ#`ѿ4i\rD-y,^NMYCj~̨f.ln	b,\\m~	m\0%orŭps6G_ZvrJKF>3lh=&}X;1WI#8a\\r\ZVnIG]qWуU\'=mg\"3m0T\0*~eVrYt7ul&Mr.X߯~|c]AT(c! #+Gr2aN8)Fکd-M\'Vl\Zt0/xfN\0r4S/yى:Ǻ\'ѺۂMu3raץc%y\r6ho+۷G5iuxG06Zi93RBt%Va\\UՓJ#<5si[`IH2\rS:\'m(XO\nMLV1\0Jpf!T\0]i$ZKAF-H\Z1\Z\"e[I#̶N\'Ij@0ͪ\'>B97fy=33<u{3ڪr,CLgU&<Д,ȝwRӲ}B<zy::{f5^\\C>/a\0})]DǕvXd\"%<o&Q@$T0A$&<鴓O<mqCz$IimϩJ}aSu!KPJBfY;Jʳ\"i\\5Kѩ\rovMJk2 zM< } ꪨ^Ԓ76o;_#ퟌ¾dѥurḄ\nl֥mNqj׮[\Z.K`MP-gfBٹ5ॺc%u6$VUG`b2ӸSdɤI	B)DHf4T0,r5i)?Gza]7o6څۋmXt{WZjãӏ!%uqde7kxDLz&3i*u5kW)q㓎5^KCӫbĸ6׊ϑG#F|t\\:kU۲ַ2OQYi.g2fKaϔkө-ED5	3wV!H3\\6fmzM]۲+݃<*425J	n>R.~MNYffdZU,evcvբꊲ4k$o[2<^d݆#?lUoʺrX\n\".=er_8#6/D\'=j;UR|kx35S8ΛeIC\\3MԴ4(ݟP%H(ѷhƻke#\ZktB;ж}m1]Y^[&%*@UtIb+1rn|zl\Z\"0G)k TcՋ]d\0\rƫ`2ZxL!$(,sC&͌m\0qzlwԧN\Z\"%y#vfO97&|YLkX;3Elp#]\Z4;;qeV;fNa}h9Ny8[VTg1s?~Ov\nM2ZL+^A~M..sDQ3m!4đ$$e&ٳ|S1wfsoj4Ŝ2c&R;nc/7,ڙhcJ`ݧF涛K/kNs)M%)\"RNsE\n(\n\n\0\0\0L)BS\'83IF2E)Is@s\0\0\0uKSE8\0>AX`auQɞqm@jNf`P[9݄YyꚈꛫqZ/`NQd8H19fAMiVɋw4cQ/D횵9>D[~1K_53\nU*\'ɪa\'AN:HVBc4S]XaWM?3U^>n5MK*(*;\0y3EwgfUUY(:&L#K֎\'$j0fX %eN	NY0]0H d+|kxo%+(q24R͒Vh)i6tsGZ\n $;H|UFT9c0K˺=E٧6oaf%ڲmeK\"[6[^І}ٽ 46m,AVA^<mRߘG*e*PU&	~9ܛUo8}BGe}jnnx;jcag2l:X17 5VʪOU=M<^2VܮҚ]3h_I<qWrhgȵN/:nKw\"ս|ZYצ\'Y$OY\"bRdDؓ#egRV!9!9ud\0ժ	8Mj42Ay\r\"KMMKZ}1<[F]u%YcZg!(L5]\'B;.	=rs\0qB&I!F:p0iF8k7\0-P2_tpFO(x<tʻo#frc/.-Yt{>їFV\nw.\';WԴwL_\"kSF{l.t1iam$>\")YS:. \0\"(|$3w\Z®⑳]TEtjXԫZÑ\r8oTL@|4yaf)6LQ<\'feiU@Ykx?RHy+2ӛf}Yꅲ^IJc\Zq76]f=7t`я^o{4Џ,pA{<oPZy%M5\\gmc9/ꋹlU	~eny`WʋZ$s\0i]+\\ښJM+,|סjt{\"ɸty\ZI踸S\'g-[̐m?S>w,wc,@Ir\nʣy5Up;t.%i\rh5	&nq\\.K/ /$\ZT(\ZW*;ITVF`ytԩ{v ~_ցrU_)&|>ݲXVEh ,y)MViUlUrŉJ1ŴCmo=H|%E,9\0/,#E0\r۵LKk&Y5xQ\"C@i:欺uZ%z\ZI4jLqXPNi(+Nk{nsoXо=m\r/\\2ԭH糈=s_ڲsز݃*0=	yZ=W^zmj-^mCQ_*EBk*K`\0F}X(m~g9*|\0J}ۤ\\;xQSP;:Ӣ+^(>R%\Z`ḹg+X{ڑ*w \\Z>1!(̀\'AJ)5KԆ$f6\ZTĲޯV|YlSU]ݭVXA(u	~ӟ\\OBȆYvzvی񓨤YIY)7P+X c{5næ㼵dז\r9֑-6ZJҢΈH 7[.X2CSRSj\\|\\2I%Cd60?:,fAk=$鿀?9:v!&iF&O<ncU1^K	֠&iZ|{	\"R|#VW\'i3K7\\BRWOs	$EkȘ^_KS&t(-io(cQ${fWP\\Ct\Z$٢ypU]\n@ω䀶:N1ԑelմ*MMuj\0\'!$x%!Gxx})WLIr5x8fQ_]L22V\rm}dmyqzYy]}_n~WV0>a2~E{[Fi]	L䆱ʆmJ\rV֙$U:Ak8eCG+\r&sJct{$XjO\riwNx\0	2xn<7H9~؞`«2jG6Y.l8g%i\'$\nY5C(R>бM2`}\'M&hrŒ\"E]vА<XMuv56=\'FPUDB&sUExsj.ҿA`uL*Og̐K03ݠiP>Cn_	2XУF 9DL׏|NBY|wt\rӃҪTv |597!<y٧)j\Z\n\'zҏ:\Z2o9<ۧ}B\ZE[8kZ+=nkTHRm\ra; $ĸ+Р|sG6I1-VTWbdw۳7s(O_b?<~m)0.i&itM)7>yufS]3A4Z+ա[|[*tE;Y0!`Y^^kjb8Jr9/K%&Ӣ9\'5lVpEjv_% ZS]r{=^y玎W+@4djg;}2V%}LYƤBAH+=v%\Z;u]5M5M5\Z뮸ƺ뮸kkc1c icҖˢV`4:[+nf Vj%bov_Z>T?gP\'%\'AwsaFbRt\0|WONkm5>>SrPћ2KqgjlS30XyZY63yVyUtmc~̨JWxH7z=3HuQ5<;kMR=>sKJf=\ZN|$Vu]J;H!+>V\0nn^뫭u6BRPآ$}0&&l#aB;PVA!4q^h9Զy0OݔX\"j%M?57/RdG*>Ɍ*iOҿ$h78}\0GŊ\'1]3El-6j\0/9*a:tlՁ:Ҹi/X,!CM@\\lhJ̈́v\n,&b0<%C?brsLhjlU2S䭁FWDds|=x]?!mƹ7N\0/]ɡ5*uɻɖޭc}U}./>7&]!U=C:5mxBnRc;~.VWxX5VR\\xkE46K.b_.Iݾs٩vPVy<=;]o㥬?+-İIn4=	NF=PޣP7#U\\d/4SlpkL%:4q\rέWGŬ3̖z	0jXO⤯v\n4>۾]EV?]yCK|\rM{ON\ZyrZ`c֕U}pi<Ϻt)Oua5T5#g\\ضJ.\n22/ͫz9H!\n\Z{I)RcS {GYթbzXZ.\"X)krg.?o~o9-Ri]LH0uv!gi@u9kbR]C;J\Zi&>}s\0F3\n7r:)P|H+:9Ƥp^|4V>\\h\0tU0!BtCBoZx?#G7ɻG	9[\0lDz+83\0MHs/oqX\0oz}E,LoW(r7B KFas+\'6-;mT$ qElkL[%~qZrn^U[7ٖBѻ=Y\":?\rVɰ`ƿV.:keiD#FKЩ2aJ0,&J,uFe<%LTml=\\{$+W>@}?PITJ*#![	`%\0fÃt25om.gR\r;okf3fcx\\|-Ȑ}?ReX\'XD\\dMX6QI#I-R\"}٦4\06\"ayvb\'.ͮbH=tE[!iiXQ+V;+`!NY$5v\nxmq:glcmǎRnP{L}/x&jQ8F\"J/6lB/VE(z{1ď8,sk]\"ؘF]yx-jZ9$ib\0e\'.\\̐f5B\n9lXC_`Ą\0uP9.m)Ԫy\Z:8NlWS}TNet_$Ki\Z+*olTΫب`r:\r6sNH]+e]`\Zw6A)\rTbo-4SE\"Q\n1:>)`;*8pLο\0]YM.;w%RU|t4۫-evn#|x\\6qpz;,^{ØͯȨ.oaITst\r6/w\0 Oo?h\ZZBbt1yZ6sE8{s*\n3~z\\9׎iGz릚i5M55M5]uƺ1c1/<\Zm~phX3aA\\,l	?WnpK%^bm\r9C7Đ;t[ԫt`\"Y贋9tg6;:?$k\r\\TBPgDQ(ϏRWѺfc4SC$́HtN?A1TwZXc6-}25:ke-Ec;۪E6ݎfoQ(\rjzN9(3I{mktn43ZCsH,8_ݯ&EUueHr4yN[-\\ZLv[@vCef\'wC5!w)or~JE<p/}\0\nV\0&JkR露\\nV&lZg/lln=\nh{N{ЭAWm͘/x;\\6[.*)a`\'dY=,yVjX[B/IM<ajj*[Q2%gMjG%yi&k\\8BTHfBQ1kDٻ0|S\\N֒cY\"\Zi\0J˖v&S Ƌ	۞D|QzZ$%uUc)z\rUT	.:(9ܙ\"nL^PJN^h,$8>Q3mLQd)%$,$PbG\0j\'?YͤB]Wd%ـ~jltpju\nL8.o\rܷ3L1m}zf̺ݸyvŗaރF[YsNU5뫘]+ƨf̿gF:\\)Eæi+Pr<Yy9}C2lvk\0*#CE]F*rmxVCRr+U\\qd4>4I\Z\\1Ei^sUÌO=tYC\\c-K*1CF~G)ߺ].O(Lŝ%9e,ɇ$#)B04EgÊli0:WDW=q܄\'q߃Vm#z{b&Th\\2}~7}OE&\\}o竺%QDZNIGG]Xee%YXA:JJʨӬJ\n:\n Rx)L58[Zhb!렲JtXА[FD\nIw	_Z=*[]2SHZC2\'XMksYDǾY4?R۾*RؽtW-\Z<KZ%ZL+<S\rmi4ӌw%Ϊ\Z8:\ZC^V,T;-J_n`lb1 ?ZCgX1s^t.Uڑ]\040yٻ*k4±+qB=ymzhl*]GALB3Sol$.^ة=0\r\Z;9I\'D#]3$H<;4c0(ZN\0@eܑ<.өApb\Z^ǆmP]@VX\Zw5dj\nK]\rʠcLD_	ڵv&\r+un5gdX*#e2hƙ5&a͐%\0]ަq:RίziBŻ)B~:R<wƋ!/[/5ǑbȖmQE=k}<zHRIA M	]chMvM6]ι=G]Ϙ-s\\pְaCj|ubG?]-l%!\0F:`B|9V½2Z	\0U-B)kEl̗\0JQr\") \"	$h}>7LsG^Xk#:h{_ݻ>.F&@uJMӃF˱rd?UaRK/-jil\'G+!6%aCfEJqbWauRƹ&v.>ګ?%^YB<DBxbr0L];x٥|fb{`֋4ɭMoW/SsTXp,{^|<kf41,f#7Lj+bY@b2\\E.\"01)w|kpoH\n]%)573qWSӕ˫F\')}:-:[ѥF.<7{F㸼[cۍ̷ךܵCF\ZۏRv6\r)14hsHLZ1B@C<[oc9=~7u$_7NivpYڦdgj2jDBnZnDJU{Vh\0j\Z# \n2p`di;Hc}v;Gf=X4F_+k±eӜcNyrrKgi6V|cHDiDMؙo^SIg%\0kVٞDQUWirLzYN^l\n1`ԊICMMoz~&k\095_tOȾژO<\0Y6+r2}B.|}vVؤĕgvu:;?70(FtE̩dzBIEW>Xۓr\0Zٸ̷]^еr\0mWLqyl5ܴ<PMK5?(塖nƾ+(j\"s\"e|t%#ɪ|T9TT9.Mkg瞀8bkRVutmEY	@O,eaQV@sקg@.4b{=$^Rǫ$v	\0b\Z;V0AZC8IʊQY!=ms<-~l^iRƚn@\0]\"| Ēu}g=,W[V+s]^%\"΄>ZŬ&٬I#\\@LmⅡTu{\'==YEؔ!YJgZ$EKӵ&Q::|v|RT_#w]7.w~ETv;?ts&͎ZP@ȭ:\'Y[p3Z9ߵxm_SmbVLL+w.@-Eqǔs5a+Q븘T*!tf76͟:~}O|V\\{BϋZ\n\0gJH\0\",Z+`fܷ,B\"3/{R_SpYtVMW58G?n%rPl\\/43X\0\ZF27&IF͘ӰӠNGʊx|vz\\A3ACFØs~2uhr7	5\'BpRGbY󩶟#eOǭo5mG81\'h##)\0V0  AGnϢ4CVz<tfBv%hTY]YXVϙ]#z_k&vZͶiS8ehM3FbVY)Q$@XsBD1M9~@Ջ\r\"ာ(WjO.nXqO>2iQ839fW7hmr9ysJ 1ѻxw!A߰ݼIeN_bC0ǓCK+|%rmU̴gDaDJPyݝ$Vaӈ+: u	+r&J7H(i4%mL!,bs9\\\nޮi-}3<\'׈e}-/?U:JZ|V`=(㼄.R~\0ѭۧu[g6!EX Z\n3*Z!ĮTg\03t E_DvVӺe+kslyP$(x\nWZSceU,c<^ar>Mpe=m{z\Z-MlO\r0ey0`9.~؇hy#-7|3\\isJrU`vOv֫;)t,SY\'[j*_,JCu`̺iA8kEGl<6K<b5HWl|5M\Z<\\~Aj%Q]\Zi<L=Ĩk ~#XkZ#wE@#Lo&rB5j4QiH0$,\n$%$&Y& eid9|\0j\rRDXx\n@q#4\ZGŦ1Ǧk}1{;I|c:j÷e2,ڣʚ,\ZQځSo{/rܦ,)r;bYwV|]驅׿hӪ#޳dvmq~Iv>˖6\\oh%ҭfCOKG\0;F)ˎl\rh\no\"`yv2I,nUWRОE\nx\0#@ACE\n(k#<:iCE1׹.G||3x.;7WK4VaǙ\'rǻb\0; $ J=c٪kU9uan_E{+ydČJVoZ<d3D\0#VZqƲMgih½ʯvoJ0Vt,=*,\r\"bT:9VQm\\C9XPC<N9Ϧ<EKi&kg\\9ANKJ@{{	zU؏ Ă\\/zJ!^ͪMxͶiSȓe)ˎ-y瞷3M\n^		j*Rb-u2\n]6i%w#^d0{͈1rk9Hq0lqOsS`WZwlf-\Z|}>~}qSh<L &-flc8]38\\\'1!Wi-2	γT&>w,[\nj8iw\\\'*3iop=yF՞e]MRaTd[bdֻ|bwK+7[_!V`U1+Cx;!IRB0a Cٷ}J~K4W3/;˫g]\r`F\0u:Y42+X(* 41\0wo\0}?㧞y]K5)4]5SضRNOW,|~65dm{kfo+Zsϫ\Zם9sGA9pCR	h\"d	Ҿ܀1~ܔ1[WB[	S%<kNǱf쥩~AS>?yh&cqp?&wG5h-Qi̝bTZO<GOFǯӭDIZzܠ×XUl>v<PmqvK\0\\<\rZRY7hb 7}v\"=LMH5m1&v\\q\Z<W\'TMɚPr ;NJn%_9WZwZG+=Ws<YΦҋJHJܟ ^\0	`8+\0ǏM Htxt?4\\ƸǪ}tGzFk%:ɶ4繖T\Z\0\Z\r91\0Z;@*mO?<n)/,ka\r8gLsJ:%D\"ӕr舞rJpIMfQS	?iR]e	t<XXQz;y[><vD[͖M\n-LR>lʍk_5SOtruX2N/n!P;\"H G2*A<r+%Nppt;}sHdޡc=d\nÿӷZ َ`d3a`6z厪$Sq_;]ߊ\\iaONMHgf͹%^m&C;\';sލGY\ZV淚]Ӷ\\aj75pM{mL<)}_;\ZsEF\\¥gykh~;9g;9|Yr?)κ>ۥy{&Z=Z\'C9MEh/7v0KjF(b\n\\ӟ۫YٴU5~nf\0Eq6B)JyA_\Zd+)VX>&\"*aN/`Y;tty6ߎ>Fn0]/׺asݟ:Q!ٮVqoO=Gpq 6X>cj8y>URZo,.*\"\09\\`|Mt-UjqLWX\\U|iȦL㋙]\'iVqi2d\'M;o\0\'6FG2evv>\\6mVJs/]41m#إ\nJdboG\"?)<TGE	ݞ5+Q%Qq똾7=ul; u[].̛4q#V,D?mjI&W~XOAͻmG%}<vm_wgܙ[@01n|Z:>\0~A,#M6̹ιn/?VtY)Fg|4ndpJy}<=GWrGyf˿ZKmn8{Y/mځzIMzW.&[;jMeB%\r!cquha|G%L q|\\Bق]|F_&a]theƜ[9]t=|kg_9oɮ`_?KAL~+HvV\nf40k`\0ܒg(\0g|3;>pA GNe=*A  \0~[OS{`ih֋NrIWTx,<!SEYRE#&Ks-ft:kK*RXU =?L\r`VƒA\0$=4h9\0l\0\0<\05\0ퟑ!|\0ޠv_7yG\n۳o^=Э\0k}gêŔ(fc57Ƚmc͠Syc\Z¨f$kEbjcʫq=\reoSbF؝5>CEBI.\05\0ퟑ!|\0w\\\\Oux	7XWiMVUV\\y}wRB\0䯷UfnYyvӽ:ZIJHԭj9h;؅DUP	$vʗgFo[Zγ5,$Agv!UA$	g5f\ZMWۑi@-Z~ZUĘ\"֯2,O[E)\'c.*؉xbUVfc#\'Lg4-z^T1Ԏ~-݂аktJoΞmpwjv^!JO>(9~FVe|וu0.=@;.{KkiyM&L.G+M$UN:ߺmLaM]mEX \0*U-\rq\"\\gMk\r4EL^:eI&~A84	NvXʲ0?_\n3\'+HNqL^\\!l\'r\0ll%C&dk/M,mG2 @8bJPTTiUUIW\\<k]=qi4,J4qϘ\"mga`ci(ZB\\I*6TԄ,PmI\"P9QDTrmZhj>~8\\i!TxD/B)85.m!A&}rqMGFfΙ\nmt\'zW-2fԤ3~%ҳ\ZR|6eZvr6SD6\r9)5rO͟lyW7MO\0.wԡ5ZU\\ Zo\rb\ru-cA~Gv*a~\'sj%leףƐ*\0ε䋺,\\׽eB.s~)[l\\|5\n\0*uӺ/P*`gwg=[_,u{2*Ð1PEl([[Bgѯg`uobXC d\\23)OVTWhZ ՊiXcB\'\0ssї}s=+~9mԾM\\=Tߏ.XB\r}<ԹlPg&|Yx<eK5Z׵[֥VѢZ!\0zDĴX]R\rKHSk7_7TN&^ac`Z-k\rJ5ݱx;M䞇Q$f͏7g ʕFjw}/}fD>Lf=w$\0\0vUJ\0\0t<zάV>?^$*[N}P2!갩-r6M5i!\ZM1S\00-lV{K4XEQV@-=d2Ήj_Te\0{hUJp흵R!=M6g- ͬ\0m:D7Q	󟏤ތ?RXɚˑ}D.y[y=#}iXH̫Wyb?B&gǂ\0o\"[F4\Zk{\Zc\\cc>?LcL\09s>~S.oƵzuM98.lm\Z8Zh5\r80B_\0kwzr&_QG4J6̪9Tըw@ݞb[\'72K[F0-YR\nݱ%J#M&aJpާx4y4mQg&c#)jmՆ2@٫*U8iYL<E~L䟐J3ORQ)SM\'I@\\94B2\n7q$D$	/$<Nʄ\nA-ULI4=5aAX4R{\ni4(HfBaI,U]*Y@f٬m&XQ4DSW\'lDC:Y\\0UWq2~S]`~ 3;=Ǭѻy(!x\0g.攍~K̬%fQ޺=k]<=,MB(AUBȀXi\06\0S\ZT6;Lqm	:c}3;ݯ6#Z1&ؠXO.X30ljDYlIw8>BUуt w=2u]&,Uj1Đ~r/͚Z4`UY9QV@bz<nK5Bd\r5ܣlmjScm#1l_=$tf\\3hjtŊ-k6*2\0صÐǓ~f/nhk쬌$\0Zn\0Ob=>h\Z[\\ꎙGVl*<_\nd-WךK	3Hk\roWSñ	-hVꞮ%[t}$]m\\glgm6\\mDQڰ+beO\rObcdo+mYSFẄ́kH*کFN~*<z{,~VLStqiZY)#pO%]2UUl\\n:\\4rD|SN?aHM6p\rFwI，l&@\ZPUYCd/L܇%5GNz%PnjX>ujRET!S/{v8w=\ZѩL6iTWP(\0L[	pFzӢcbLC!f%-d(\nDf=i㣎Ó9229i3ɲ0yn-47qâu˳e2xZvӢRwV(\'mx۝3\0+Zbj1\\(*zH{ϝc^#p$٘vfN]Njh46#Bj8254cl靡\rMqklcmsOAz1.-ckEDWϰi>KZ`#R%\0U(LԼHOۙ<s\\ug~\nf*w4GƞmJU7U\0yN T`\Z]y9g ci$s뾸\0Zfo%s+$ۻ\'Anr?.]Hy ՆnOAJmL_ct\n{I!}T\Z%{مt\nZ#et/I x$U[~Y2Yl.ކuj[-$9ϟ;Nvڷ_ծ!x܀KXI77Y֓)<Dڢtv-9Xp[!-8TEKEǁQ=]y\0\0\n>[U]]ujhy&oc\ZI>ǒ|~-gl14_5=\0a3&H#m}!yAM,\"2iH]]ߗVh]RUk7\rh	}_:YMdFXНM|n?a\"*\rtfPҮvMdT߹ý\Zi%$%h>(?˕NL#q^dKR`1(4\r\r6ۈT:K(kNmex\rISPb!P6_]].V؟\Z~2mgp\0_|ÍM\"/jg<_)KSUSbl0P*@A#FFmlCW/\rp\'|mMV~J\\0\\Z`D4	T B^zEb9&ѥx^>d|5~Lt\'(XV\nn\r<Y\\`hx}Oe55*\ZBS⟋dK)[^En/[vLt;hʚ^/?BJjk4plIc|4Pҍu	N\'̷fu_k;m;;j%|kB38eCVY:*Z\'7UkOHf?*cΉλK*F/AyM>޺r:bno@v޴Jch՜F\'`a}PC(c4l}aCt<S\\ʁ\0\Zi[[^vڂxQ-4ht(T4*R7rԞo2(3s飓{\\NDoNKVvѮusV]?Zvd.;ͷӗFKZ-ER)Lq\\U3}VއJ )29r3A2D	 &\n6iQ7那!Jw	A.m)0ُ\\kc5ڞ͍\0ivAӿcE1#[E,m|tQ7I3C4\"I;n`ӳxPv\n*$Izjmm0UhmPjx\0F曈D&94ƻs=P:ņ}ধ6 :%l\'Szo;	Dk·6>@?14V	7]3ѿ\"PfkgD yեsb\\iP?ԏҞ{W	-<ɺy㣧.:^i\\<&\nvgݥsgr$.Sop|KbxG[\",E3(+2<^\ZYIL?`1lg]3C5UJCb9;j}0W0#HrM<}7\0Z}4֫b|2v+2vd`G΀<<?\ZdoFsfioZ79IDW<ZOge\\#k\\.j|\00\'C<x\\382A,{9tM3}5/L *\0F͜D #Q2g;Ɛžk>m}sU1hiE7@V-F:\rX񃮁FnŦ\n=4I&8<GXrr9s\\[Ԫ-|UgE-~lI|js-aqe|w#d՚5qQ%TRCpQXe(\r.\n*mƜ^~ߞc6U\"ޞuQf,\Zoy#p\n\0XS+k,|Zx;\"$`4a^ԓv4sj\n].o}[rֶqZ\\pd^E^&)ZDR[Nx=%K\na1,B%>\nH)$zyGԽ=SKAZ|kfԋ\'\r&hUyK6~\r><眞\Z$&ql=JiQqE0\0@xg~Cf\'/YAI+4INRyAoE]VEgBH灴ez\Zt6qt1OMlL1hshs\rhYҭoHKq%FXk4C I*=\nɈ\'Hϻ2oLD:QUVG\0!=-ӛF-:13z\nJD(Ҵhi:##㧞yy㣨)f	˼ɖ@-vQ\ZI8{9\nCeߙoJ2]C\04玸c4R`8y+û\ZwK6oh[A*6S!өvW9RP5K-;?j+4j+\\MW^u_;\\\'J>-|C<.SrЏ/E\"W*}9Dn22{j6#\r.[\0ÈȨ\"K<4W\0};\0KɾI.aSBmsaqF+sߪ	F/(64ޯGѴҒ~if-eq>-,,5VMXb	ѰUo9p9Ꮅ,P6%Q:EM*\r }Li\\7&Lwc3a3)[-<&B4xΌ<}=A4儯9snnMiH}[(UxZeD&Du~+\n6t^Ky֗jsjތY\"̯^\"ў8s׵+v=o\0Ofnۧ|/}cL\0,R)__+lOARhIE4d|ifNJ[C\rx%FF:wk|\"yuuUE3O\'},GZo<3:|;Z=\ZmRH*Q#u^UNiQVWovΆx*2|_*V:f/.Ss>J_@yD^}ɳ\"Q%TW/ͱ\0;Щ;2m<E\0LEΟ!?U/-R\nOl޽bzܫND.ʪӬӘ[zD%<@gDɘ)\"=2zvUb(lUjЬԓɀ;Q{56\\ޚ6leKkKzcF\0qz<\0uuNwt,*Jŭ+vV[kβ]dw/}h7l@aosZ^bDJ\0\rbF%	\\4Q\\i>!J_]1gލ߹f,ĳYbzyNS~\\5x$\",8@,#9$PyoOSf֥mp8]ZӴ~Z.1e4Ӈ\\N,.I\rG)B}óm-]T *1\raoϗ0͉5hva}	L!͗?7ȭi\nCL/+b_\nԆ\'vWH=.,p,D~<zy㣪Mrtj<\'an5LؖTC>q6\"Yhg4kcny$qlC47NeSC8+`tf\"Q,mdR~3Mҁ%1%}qun_!:rٸؙW9.51\Z	5]d\0%mXy}g_]QMGUSI	\Z]8<ˬ_d4mƺmЧ]V%n%+\rߖYwT<&8/lIRv<k]]5-rG$]l/=զɶ~[)9S䵭fq83)L4D.]?l/7so4${:;\"ߦoZ5y9a-&e9KFM-p6Kڊ[HLћ>Щ\r,3^+/UH0¿eTZW!fhvhpZIžG>lc80ojEI?3c7-.[#oB\r袜)o!}Vց[Ƚrɶ~Cu4k?z?L3p&!U|{.Spnf@Tf7?b}A-뽩{=<UvJlv5Þ	^-IN*aĻlZA-X6֧Ihz5mk\r[jQcp$K-NѠi՛YԜM4w_527Nk-a\0\rkܩ.eΓ@3O43ihZ-:S3\Z<J3EO~nN?\'sYY3|LX>NT=2}K򹹢c&gW<t<tu~ς\'l:L\\p	}ҙğy\"S,~b!\nFp\0&dD~G&awEJ6ć6bq\'ƻm16ǽ5v20L&bjBoY	uqeh=QC4Rn#Q4NBu{yj5gH,8LiJkg1*3%$I]ϗۖy%#)hVAiy;iXŽy)Eeu1hAa!Nlb3u#X}{Ϭ̮4͕q=e\"I:=r;RL@նo\0X`liW,L}Q3j_H>]89R,,5~+UЇ~\r5Mv%~쬖ʩbѬc	\r=L`ӡNc[5#gL9&\ZuUճiƺ\nF9SO3azk\'\nP7/Ow8WorO\Zzi&1b`|,h\0na*yFU\nAw4XjJؓ!^B	2E6S&k&wX]8\\,]i})5ee啈WJ7y/a̛o6Y\\B١{5C%H	{} J0YdZ(zCqn,][.3Ai5Yi?i\0fx^%?4p)ͦ]K^l2. \"NcXH&0DM	6y ::$-)pn[\Z\Z^mk.v1m-U3b-D}rE.K%D8p#Dq:phRiMbѣ#e5뗇ŚisB0C,Q3GZO[ڄNjvrglv㮽x\0C$s|Xg0C<GZ\ZRP==HȪ*kf]R,T\rb$0F\rd\"i\Z~I]j\n?G6i*vW+q\\&_$TduBb(#=mׁB&!%B.~YnX(\r^%[Y\r(&\Z&	22h1vx\\s8QL4o:\"<L42y\"fAPe]TEwJZ\\E96ϐ棳:/5yݶmHr0\'_>N=sO<GP~AӤv/zXujo\Zc%A_9\09gSܱ:OY 1oH+yW?P[]RD1i<9.6nmftX/S>sP8E?͢-#Mc W6\"-OE>jr\r9)jߴZ~9aߚݠqlpRUfs~[-D¹IK٬H;+jUO t=^[ʞkH^]DYAWnVWG]HK]J6iac}v5lm63駩z\r	5a\'\\TZh:IF4Ki)\Zh(65͖)9{^xkj\"	ɼthbPV޷qJ(=rT4&P\"aEg\\(7E?!M5O%\rrLkY3m<)mQk-hZZl.i(v\'O`Y]U\ZӏWP*tY=4E\0\0\0\0\0d\0w\'cOvwߪ4R(hۿҢfa9YUATtpm\'bd[P-\'\rY9d9N}O?m?AoM&h羚Ʒ=_j?\Z>(粨,@v2ŗNrgzKS	i댕WC9Q۲\"Gέ\r@RJqOa&Id1[E#c2IyX\")4SAR&Ldp5\n{ii\Z8DSF(DCgBdXb-pz:>Ʊ?{QYG&W)*3{Xѧ1+zL/fitK5>rF8\"<WG7VO`Fv/.]-[\"Oh-ړCɅ!k~{cBVO	Q߈wb7Vs*LʩK	c\"8I=Ž8C%BPbZV\\a\"@9(`玄GV>0Y0E,^у o4-2wP䏱sTO9\Z[QV)>*IWB:Y̬4XltdmN뮥f-Vpiv*.:+ުg/ɞZ!Nx,XEuVpA{{;yuORV8h(A$/+/rM:iVkۣ7js#$ڸ0|oS=Y|63y<RnHzgrOZmsee2&GBō}l\\Ԃ5W^e\'[0ba5{á!	o(X@ď$KǾg3w:5\nf|e#>Eh\\s710i#B-Xl5wbpm\\+Snx-b(#\"0YĐ)C$4{kSC&ɦMqd43E*B9\n~]Ogey|<fZq7b{ZuΏ[csj`=PJ>8o<)$Zgo1IjLgaKzv#̉%9gcP=gM:*aұss(\\|ڍawB\"0B y\" b0x\nG)}W9iRewHs#lήg2iՍW*Rh_-d\\|-\n3C/\'jïf\n]\'g-opf=&{PYuʝMM#܄;}f\r-I;\0MS|z4frnHӢ<ݥhTHJCD*X^tQh\rٹ,ۑ!`yʳ{ƪϧ5LYJ%fX&\"sX.\n;TnFJ(L&?34ɌmnvoqUՑ2*2U A{YhZBZ6\ZɃβyne zOQ[8VU:hj&_#2qY	GW:r]Ii٘Z?m@=,GaBcVMR^iθL(M/N!]\\0bJ\0]X=n}A\09IҮɬ:/պЏ;1$$,BxtrP$QrJ\\H)D- 6h_qW8\nS@-=1zr׉Q`ϓWPZ@@\"Z/6lΙ-US\r4,ݨOfZ#hlyy)r9vNiWnz{^\ZJ*Sq\rM$8lk%W\0A5R!Y+h\\qFPGhJ14)C$A$r&ͼ|a]֙%\Zrã+s,q;rYcÂJ1~.mGta<HT6Ut<qUpvİ\nGOjܤVWzJLDy~CSJy_WT=\rXmV< F5x7=fzߓtM>\0uO%Etirƣҷ)3^lD+rgsA3ϩPHr%pbP8Զjf]Ʊ<hfMu\\\0nk\0_RNкxZ\'o-*DPy[>OED\rWBZ1%o\\,,ɱc\\`_Ld53V$沵ƨxSO\Z֎\Z%?\Zkt{sfqp[ǀG(J-@Z2#\00(^l46ynU\n\\𣏕㑴K(Y|Rz#Z:vjxG]Eś[mfȲ$Ub75X2f[mAa:i)꾰-JZFK	$ĳww,ܟU.K}y=7ZYe$D2挦ϗ4Ab͞rC(g55h^=/TzyάǢ˞RlAk۵(AuT\rͣU̗^s[Oq3{K2m?>-q,i|C][l!6|Z*#5<SśN=9vc\0\n;,B@HUePHpIjDyh\'FO&xBL\04+`Oy\\;5NQPEG0CZkQE8LcHLc]4]qu1cw#lן;c[É>@G@Ŏp,A XԢ*y0훰LKv~yMޫ^:c@O,^5R4bѻXƚ\n8b/:<)öS[J\nVD\0sQ;*VvqfR{6[Hf_+hӧE%<)$kUtV===t_aJ<Ƴi6Xɲ1Q4O#.ahaݵp5T(! s LJM5؃Q͝,I6sq]iMR,M-ӓ#?f[\ZF4,VX\rfP0*\\]VBg<@QU/(\"N}An=\rg8r1N\'c^\'[oyyOU:5gWËiBly瞵.+W%fB}kUQI0İ\Zd6A3y9B<\\`M_pcͥKČ\0яБcpEM)cieUTBA̍9Yn݁31t&lQx*M(5-j?dp.JKfT֓ۖ5&jOΩ-%36->Br|XkKXaq2t#3A惮!<ߧ<RwR/U;2$ʧתL\0	uκF8ԚJ+ɎK-:͇8򼙥ѦI鶻龺mM붻c9:qgY\\T)09#@DisA<2kr,{mɮIk9ǳ=JW\ngn8q_av\"Ju.=͋P]h˗ejy:r\"<>FLqksFd>Gny >\"U͸C\\$Oܳ8:EU ~71\"O+fy㣧9[6LZn^u5v1%^vYX!s4W,v1pk	Řx~f6PgB.=vG_;)ώg6mliY+C^v&4j*ۋMm[Lg\\+L<&1ݍ8l\'V*=tC[5T:(`h[4\'\'s3i\\UKZ_1ma\"pNC10lĪej,9Ή	bZZa~1<f;W[l,oSK%R>@|ڳE@/z)CGoAQΧ4[S69d	\'ݹsiQ%GYxד\Z[^z/se(rȹ:+Gɴf-i2Z-]%0`˒Ce.u]loXRU΢ngA\'Vk`ۉ7gM^[])=YZA=^EXic\Z ]V>Ȧi_6t{}rƟ(ݢ	6$aHd.XN\"$]Λk1:cit\\>7m7\0=v:3yz!($ح1v{@U8imh猀A$]:	pkVh//u\"ÌLV^UTWI6G17R]LF]^7W9_v\\:cv~W<nlyGJJ~3^{%4DLQ9IObHX9b=94m7lm8ϽlVwA`>O]22H ${Ɵ!1K;W\nSZ%^B;۬\0~\0da[kee%nsǍTf%EZv\\M5+ԂcFb0,	 Ax,a]y(m]qkTHrk3\n8C\'V#(v\r6ˣvp8ĊT欙LuW{+3VoΩؖ\0u՗g>ܬt0Tnb͗#E?9.wTخ֮I]v6=[_A!>kgGg%-5GCJnwJ*S{׬L4yϦ.e5j81#.TNҪ\nL8YC%֎\nbs<\Z?i6kρYJl*vRJc[q۳*sp[%jk~U6)+bP0jVC\"J@=p$,u:V[`\"\nEA-/`X@T﫿:ZQEyC\Zs/tpXkʜiV5f<]+sKXgQrffQ&@Q<Kِ`NEꚽhk7v7N-t5Ҫ\niAރ2ka~c+tEt-.EIT9QnFTTy׍b4*ljxP%$B$Hx-rK<٤)FI5r4}ϑ,绊2\"iѿnt|߁;%Zg+(q0!Ui,<޳<pT俳	\"a&\0i0J~kFhPk!G0PDb-ECV1stG>}Qd\"Jʆ/RF*l&d,^MtzlWOD3O#4Nq~|ϘvFn\Z`1;G+̧`VL򋲫zLJq6\n>a)Fd`43iFIY\Zgyt>E\0\r5K5KYk\"yǬ| fS$H4u76&]<LyhuZɫk	IYgU`ZԷTWU1{`j\Z5ų\nRGŉ AJA$0Ǯɾ9Ս~oi@vV@ !.vo0u0\Z\rqﯷ=\r(!L<uxhaj\"` a]Ŋ㪬Ķjf-D7lnB9`&\\O~\Z8{7Ya\\̖OduU ՇӞsgf7ZӍ,P[`}Ϋ4ك;1%1Si/ټl5Y-~SQ&T\ZcX9i<!LbLhc]dȲFa3,kW5J~H\ZH#1Bթ0kTCUd5`ǎj՜rfzin;עN=c=0<%@\ZёPhy ܂MG$~igcDi.Gzm$I4=4v}8]5m118=\r؇kࣀ|hc`#	6	gJuh3#:\0Fh$զ$PD7f*m\0jXMy3kӞT]ma4md֫_ح|0bk,|kbu|d\\h)CbY\ZyXN.%رE)q_s7w\"̰ƛ5a\nshDT9+2ȺM<+wϚ܎F۴,}H*qYJj<<ћu:|I%vڠwI=3mEyf\0+0I9ktoV.pz`pDBLɬK-5NzB`k6ZJuWрe zA ; \0=St+˥ϛJJ_Vޑ;o$f+u<Sv 18jxĞbW \']SS2%E:	ZN7\"9I+l_yGeaԭ?feV毚x].^mLE;ڞғOS9\0_&~jαf[~=>˟{y,dL@ߧ$=m+.& D%t=jGgY7r;U}}\Z^y]M<<׮Xa\\i<QM6KkMˍwİS&1E4q˦uMvpQSZ\r6;SGw&1j^\r֌,bQ>C%,\\&{/EHƬXʍ&6n?Ba{\0=^X\'8yأ-lkњ{3o8jh/yJѻ{uW#ݢn\nPXCwZ0h\0z-8itn|8He4/V>h,B.SهÏ{1qă(y%L9Ƭ;e/%њ}W	uhKKynˀ\0QCP)f&\"aP!&\0\ZU20faF4azκ\"i{$zz;!AœR9KPbi}eTfKbdD3\n\"+]@Yl.vXj4y\n\'evT5 <Y5q̊٪I6͵+UIQR5c\0ZXf\'Blr&4-;nw7hB9f(#Nnn/2g+bn+fS<|?/n\"cW>_\0i\'=da̽ɩjo_:ä2R@\'(n\n5E\Z=.#SBٱ+\Z2,\r1ӯb:dEɤn@&4-0\\8ث	=uΨ^\0;\n^{796S籮/O֥;V3o3IV`+<[*dʔ.g4ZgVm΄E2?F*ȆhZ]NX\nY!ܺ##0*YXee I؂A=MFmѴheY*Rn(C(\"וF5bк\'iصo\08PF7~i:~7Bd\rleu6y+g]\"~}qb8s?WMd֯wH}M4m}i3l]qmcs=_CQk%3,ӞJ^_Ӕ+9\0&Nď.Ă\02M}Ϟ^2\0Yn{TG#-t_]JHU^9O`6,9]]Dv5& P4/$Eء)K_R򯞪%ԵwM}u%U`S>|ua\nhBut܉giȥ|VW?՞Y\rJnRJ}m@{YWHbR߭T]w!h\ZZU5kW\"ERK@.\0H0\Z(aaH]u1D	o)V$ߏώxs_=N-+ȕZ?rHǃ3itm:Giʦp̢IQc]nFޕhW^|{i.[M)9\0@\'zX\r#W:mA}\nl	4jƲ8A=]\Z1X\n0 Ŏ-5xI_Ʃ5^ZeZ2\ZB[RJ|[ֹ\'lؓ-:c̲|FWyU<ޒI1,AaI&] aifyXIemtMv}3q,6Eݱ[jC	*C.KOɸX؂p(hqq*Rw SH$xfqd>Mc%	l(H]H. \0\"Ƒoetz&֓$!2wӥ%UhiPoܖ-s1:V{y4}yd׭bik4Rwd<f?BtCH$[`B-f\nm5b}d\\c\Z1c11cc1|Xz.駒9&	@hb׿koHi[h}Zuq\'4[T>C;\\zC<Vc}:~#{ڷѯvu<_O<GO<GO<GOGmU\Z)ˍ}E$\0d;\0rl1f;!Z5pK55D(GiyUW&::20^ AGpA AD:7>l$⺯\\a\'bFo\Z\0AQ7K~}p(ns-;H!)pљ*ht 30\nY8\"9(ixwXMz>M%#~7,-m1[d7\nu9k:yVXsZjߒ_\n|D393͝!kmUdVl\Z`[W.?DC14_x\02vP^z[ժҒB_HЭMDSe-\0Ybű5\"8Z@v.O\'|od\ZJ}ыbL\r޸ɢ5}*ݺ]_Gn{_ B! ـ=<xxx;ccmd9ב9Dv3^Gُ;h@F6ƅnu41gʆrfWz\0t2Q院V 3+/x((\r\"u>yמY\rZw\"c@4ْueU-?G 3FmـRq!}~quI3035?J2*箉nQrȾ,\ZI1}:mgM龛c8\\3qIi5\ZZG\nEY1sU0Ǧv\r]v}$olmXRjGc]Y2sv=#lXkGʴm6`IGG&\0Wd>}YY#\r0n	q\']u5qT)$\0\\2WAGl܆\\̠xFBFbSmTL$9敕irXɗ{!⫟oe-;Ab=RvloiY;?95>YwYY釩E\Z\ZRmhoՅwTV\0a5ƸLɷg|<\"ܞ|+LNn(i9~3zŻ6h\'K7J#ʉTFQPcFh5߬Aוxi$E`?YWWUunsJ*f1kNp5{!\Z]+\Zच>竷%DJiQ6S\Zhinp8\ZSNu\Z\rU+)ϱ/|1Uk`eZ)&*X~tvqJR<`!mtWmqh1n-j ?㛏vaz2ȫ+`BP碹QxE\Za5 =u(b]c8H]u\Z=$I$I$I\'~?St=GO=YHΓRFԑq|jPOgZgɝb\0!sdĸ\\EB;BDN\0bAC}4Rg(]\0s<}O-{\r:o\\ymU8̽PŇn{<ʼe0\r#_[7rVȝP\0oR6l֥\0X1m98\06\n!ǋ\\ILg8ZB\rq].gʊN[M ^nL683颩r\n1ՆǱ\'ؙTxR<8 qZM@mB\"hG:]xܕؠY?7r&O)֖8V|dD05Gǲa\"ye h׼<\\߄UQ^n\\<usZ;	Hl2)Xxԩ?$@(Gq36K<>x	fUZgGwyQى%\\yMBY*{ozEU}/J^<GrXMՎy玎y玎y玎y玎y玎y玎\n~ڕjԉ5]n\'IZ&qdpg]sA,[ggT9G\\nSaT1ܮGQp#Yǭ|&So艨!\02UBۘo>tF7g\\\nߏ)DUgՍ5j+>m6Da_Vdo$*{\0*ISAө\n\0\ZɺR`Y0$*EVuמ>ZjD8`mAkE\nlrQ}SjlrYgq6G؉?Pz신)S2%3ida8M-K)l`X䈐J\"=-vlba!ܿ1~*S@ʒG`B;\nP\0cj]EXt\rwa=bjk⴦)$iXmg\rM+|.{U.x^xڪ~\\$,Nw稺\0\ZwH͊_gޒn\\/i	\nL@XL,Jqz)5tuzrd۷M\0e6 5ǈWS90mXp_갏}\Z1[\')]\"F[F|pU4_o=$\0b\ZlO\n0 }vQ^h˨n|U51ZGX8Q2X\"Z:gQAge\0?m低\0W\rVx[/4mϲWD)\"][ۉe\0?ǿ	\0pW\0qݛe\0O,SgM?e>Ά\'_~{\0?+\Z]	9BGfQ	݈qRgA(K蝖@y5Gw\nnV\r br3G.J1\\&2<V^|C(!ʕ^oDE{#l\\H%;OLxʮ5pgj߲Sr[>Q}\0`v=l@\n.۪]9m0.%-NZ\r#ƚ!\Zl5E+ag\Z\0-5w\\u|Xrg\"iByd~^Ht?	u&go[;[e7rY^âJtj05	K*0?dSGd]Ȕ:-GDZ1HX@\\n^4&sx&Q(F]V\n)d?UEb7L4	q\n5mۄ&b?#ZHs1lպo]@[AfnP!3=/%Am|q%\"ACA`84Lvfn%hj> jl1l&PNOO/BO|mZ1iw5ʏ]7pa߰o#HTyA|۫{cigMLP(TDU[uYqim;n/ȟK$u`BVjL2M$r6*9eU;vK⳩\ZND$bXH9%yW1o.Zu<Hc&X3x×41bLv-e31~/P[Nz\"<QeHSBH]<k?2~ޡZӈ>.5Uٜ>ʵazMk%θyl7ݘGǷ*C)0-Iim+%W`}e-m5\\\rbMey(+/	qcCQ6}ϝԀhNvY\0Eh$JuTprC4(ę<ή(]˒@ThBKQfbx%b<Rʦ0#ql63)K6߱6=a	Dy++KYKwZ_`\ZyXBz]~+-䀬yyH+F\Z%-v,ݛ1jn\\Fr\0;&TΈi4$hY)馵zQ\"֪S}{PJQihH95>s.MfHaI\'P)\08\"k7[攅Acr\'YM{ḻ:qGicsr5`OΆKG]@zQp5_@Ǔ\rx2xF@LVEj3O<GO<GO<GO<GO<G_','pedro',1,'example28',NULL,NULL,NULL),(181,'point O 40 40\r\npoint A 20 20\r\n\r\ncircle o O A\r\n\r\ncmark_t A\r\ncmark_t O\r\n\r\ndrawcircle o',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0,\0\0\0\0\0\0\0\"!%#	$13R\0\0\0?\0\01	IX8Ӧfe>68[SĚqŸȢ;HSCiRZRRֽ_|i-\\}\"_ÿUP\n7{Јڶ\0Xܬ0HkoTV9[9|\\\\z1bvn+4Bj$ao (!%ʵ^ܕW=Թc.1 y{r:غ(J%\0\"i<J^^Zu9Y\Zg_h.l^d-6;-&?,#$i*t#y4t#Ps\'Ы_FeMQ,%FplPCSs?Ǩ:\'][xH5:p8ʅYڅFS\"!S\\~Gz>Rlվ+z*Lg, +(rNiWN-<tToHgt2\\||\ZR>#8ƵN89RϺp{2\rT2dYc$%HDX͜\'m&,Ge?f1cfe;X[rd\nvU)sJAi6>Wk;ԄZ<eF{Fv5XIaԐ,<(@|II5N}j\Z+\0EUc2z>i;Etr>\"4 VuqG+}~}ǋUhu\0^\nbVdT?d\n*23ԥ\'|b3JX.vUýVpWt-!6ۉJд+JBЭiIZ*Jm*z޷o?X1dJU)I\Z\0*9~2?	{lV~Te&ޮk6g\'\r8[2=~2P£B絘z}:*Ą\ZSeko yEJB:VP$I(!ܷ1c$a)F(RZm)!Re攦iĩ!iwn-&xLpYkhZ*MrG[\rȨò8Z\"W++ejXg#[<PsuP\\lT) CD!+i֖\\mSNhNCcZݜ_W͆3,tb{AI:+})R`/S@0H7Ie?((DB8ŏp@\0 B0(a`aFav[CL6:c1cE\">gMAF[NLW¹ MH!oNs0\"FrUaR̜֫N7UA\Z6J:f8	xY(HҘ::J8(#4WֈqqZqm*7oЗAu:rBv!ĝxAB{}[gVl|rǐdީg>vIz:5WR*}&*ZAG!hzFPdFJKtJx3K8	w,1c1c#N`Ҽ)\'u=c#1X/$\0c☒29ÔBhc,D/%e:ɹ4&$aS22dDDP%\'$q+lp\0&,qGuim\nVo,BHa>&҄B[	G,\"0&\n̍_QNgd0l5Yc1c3OwL?iSIjedko:F*[90=ʥ\"Xs]1s/$	<#ӑ9fRkR\nRڔ]Sfi2F\rgYɁFh	V7G+ml=V_FmeϠolt`Pդ󞏫hL	6̤-yFoJc1c1uD4rWt:hzQ.P彤[d0=AlwZҋyuJ}zd\"xO8pj䤑\nw{SaHJ^搵hk;iiMN1c1c2QzEٽ<;p!^eΦi>yJW	 H).\"guvKOa&T:ܗlBץd%S>A}h.!lr^b3{_>0xP51cddܐ+//*`QYRG\"\0\"2FS08!)ZUݒ*P5&}h44Qeu2]R6!(1cB?pbKJDIZ[HҶi_un410ۭ}4{NǊV:\0hV(GP(}UU2ܚ[OSoOd6$PSoq%J8Db*쭨Ÿ\\n1g#{;c179+V>~Ͻ/T]փ3\noC敮wY\rzD\nxbrfQ 9̠\"0t#=:GS@VԽy55+z/.]	%BBsv;5-L|vpu1cx{k|;sh9O;YY|zlSξrqH|-qJZ/	#.!I.1!`\'\Z)M,i▖}úi=c3+]oHMSyeeVc6tYAI(]h\r~Bug┏>y?LD:a&ld;7` 		5VAYcD @6ac1O8v9\0I?A/[՞n6;MS\0\0:ghnE9ӏ\0ڀdDA;FJI^&(VY`Gc1c1zA伻IiNgABӑTA-8غP\'d8ۈg[Bҝxwh|}mmy9E\Z]2fNC=\ZmF\0Qkiai6Ny#^\\ޓ-nKOA6:W߃@e*1c1cJ>qS\\/\nOL-Q+HFP)qsv\Z)e2\0\"?]zK\"\"3箊vTrMЮ\\o\\R}M6\"1c1cIMf)9m?(~@кĎ늲D\n1sVuu]˭MoUg*ST!G+kdXbd\'N@b2u-2\\hA3SŎu|TSÏVJ;.9RzpGtHި<c1c1_FV]\n.-b\\8 {	Li Ĉ\r Htmz͜AK_Ѝu޷k]H=f\\ҁcM1^K8J9n@\"I@#|7T	\'< qH{i?	^DdY㕨RlT-!6ۉJд+JBЭiIZ*Jm*z޷o?X1c1dg4}+݄Gć	=\"At\'>猸9?A~yΣyCl]9d\\9LfcyHei}!..hq[^q\nRiZw[rNgќ:-y&\"y\0[緻p6Xxs3/ƯÖW_iBMY?!.kعE;՞*#~IVGsud%fLr-;h{#:d%vMw1c1dzMد?psC]c]cŐ	NF,ָu:A.|J]{ͺ[s&W9$cu i(d$_9I$,6$LXRrs\' Y.3O!J\Z\\3CgI_v+[>9Gv*v	cdD@a`\nxd/\'!?\'rECνbLIH)3a+\'ݑ=*i0VTPM\r^u1c2W%o>q\Zn=wK2p_%6\\)HIjj\"}\r.Ǟl=/ v#u>98,V;IפK6kC?\r	=BWQt$~1gY7	\reX#\'NM,44)/sO%$x0\nӌ*Cj|˧\\80JȀtd\Z4EAH`ۣWFJT\0aѫJݷvJZ竻)P4B;:r?\"_&s?\Z`	(I1c\'t}ɫ%\\mҵC@;j=r2hhȡ9~ṯj@PhIsd\n1\\|s5|0$,\"\"}-D!P9ͪ,85bPw^G](s	dbishH+uBa\r2BJ@\rMt?\"K]JVe(ɉYC	-1c4R&GA]jΪۧS-ip:%_AEJ&z	`l\'c%@[V*Z\\ޢ*[c\0Ő946Y2Ul%#;Θ_!\\ժM;ptl˗?9/2*/r\ZS>l\"xaF[sw^#Wc]Sಢ\r8Ua5WyOKJS}I:VӛSzG;u-BKQeY:}|e5a::5%\rSIJuZĳă\\UCҪHr\\i=8AEtc:sh\0\rSGi;)램BiUjw=٦^m}O7B:jVG[O2 s6q#<i}v>Aф}]Oaa(/aǛqJg8M C\ZS	#tV1c1c5@[}OrTbj4@܈lbp&Iٌ6F\\SrNWkNe̚*Z*-?ݑ\0:+qQ{6?ҿ%:֏.79_uzJ]عM+Z}4\0hi^V5μh6l+ڬ{HHK@AW@8FҁJP;ItZ-;1c?','vsantos',51,'teste_m',NULL,NULL,NULL),(182,'%% Example 16, Chou88, pg 109\r\n%% Gauss-point\r\narea 5 5 160 120\r\n \r\npoint A_0 70 10\r\npoint A_1 20 10\r\npoint A_2 25 40\r\npoint A_3 80 48\r\npoint A_4 56 60\r\n\r\n% point X, on A_3A_4 and A_1A_0\r\nline a3a4 A_3 A_4\r\nline a1a0 A_1 A_0\r\n\r\nintersec X a3a4 a1a0\r\n\r\n% point Y, on A_2A_3 and A_0A_4\r\nline a2a3 A_2 A_3\r\nline a0a4 A_0 A_4\r\n\r\nintersec Y a2a3 a0a4\r\n\r\n% point Z, on A_4A_3 and A_1A_2\r\nline a4a3 A_4 A_3\r\nline a1a2 A_1 A_2\r\n\r\nintersec Z a4a3 a1a2\r\n\r\n% point M_1 is the midpoint of A_1A_3\r\nmidpoint M_1 A_1 A_3\r\n\r\n% point M_2 is the midpoint of XA_2\r\nmidpoint M_2 X A_2\r\n\r\n% point M_3 is the midpoint of A_0 A_2\r\nmidpoint M_3 A_0 A_2 \r\n\r\n% point M_4 is the midpoint of YA_1\r\nmidpoint M_4 Y A_1\r\n\r\n% point M_5 is the midpoint of A_1A_4\r\nmidpoint M_5 A_1 A_4\r\n\r\n% point M_5 is the midpoint of A_0Z\r\nmidpoint M_6 A_0 Z\r\n\r\n% point I is on line M_3M_4 and on line M_1M_2\r\nline m3m4 M_3 M_4\r\nline m1m2 M_1 M_2\r\n\r\nintersec I m3m4 m1m2\r\n\r\ncmark_b A_0\r\ncmark_b A_1\r\ncmark_t A_2\r\ncmark_t A_3\r\ncmark_t A_4\r\ncmark_t X\r\ncmark_b Y\r\ncmark_b Z\r\n\r\ncmark_lt M_1\r\ncmark_t M_2\r\ncmark_b M_3\r\ncmark_b M_4\r\ncmark_b M_5\r\ncmark_b M_6\r\n\r\ncmark_b I\r\n\r\ndrawsegment A_0 A_1\r\ndrawsegment A_0 A_2\r\n%drawsegment A_0 A_3\r\ndrawsegment A_0 A_4\r\ndrawsegment A_1 A_4\r\ndrawsegment A_1 A_3\r\ndrawsegment A_2 A_3\r\n\r\ncolor 150 150 150\r\ndrawsegment A_2 X\r\ndrawsegment A_0 Z\r\ndrawsegment A_1 Y\r\n\r\ncolor 255 0 0\r\ndrawdashline I M_6\r\ndrawdashline M_3 M_4\r\ndrawdashline M_1 M_2',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0C\0\0\"\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\08\0\0\0\0!\"(1h	#$%23A&c\'CFH\0\Z\0\0\0\0\0\0\0\0\0\0\0\0\0\0+\0\0\0\0\0\0!\"#1$2AB3QT\0\0\0?\0\0yǞy3%͝g>a!,#0ZD3F}{Zn=jkvy4R_]YneK)MQ~1$ׯrZ_\Z۬Vz񐡰Ex=ic7㬴a.j\"@DH!ENI(ʻ%Rҷ̤Kcjm,9&7y1yycyǞy1yycyǞy1yycyEFεͪP$*DvJ:L,D{Phӥmi$Ľ\"NʽuE*f vf!Ts$9j	z]E,\n0Y1(bVY:5gr&.)E$Ok,O\rV^-Cbp04xڑa+5M,aFF31t`՚)g!,ߖ1atSOuo%U;T+4T!Vj)Dͼ!̤6SZ8hlrr̒4 +y,N?{x9΍%\nBeB$7hՙ{vVS ;I:WbeG0Kadx!OYVtZ+_wֲ]cu5\n9HLZ\r~>Dm,Q|~Ů݈ yjZR@/ɑ\"\\\"m4K<P}&|陈}y%m^8<2I\0rȌ%Tb @y9BhQkц:tꤑf*9F^6v2ӠU</yǞy1yycyǞy1yycyǡwTF7u[m`WdLAf?ʸi?nߍMnxA++4ǥ_sO<qA^wS	jm+%BAx\r&$[{\\fo:Un5HE|#;i@]sO_NDVgǞy1yy{wN\"(fQ߇tDT>%\\:tHii tJN4Xr#cwGv7fUaj¾[k466NANSFN0C1C6Ǭc<<<1<c=z]qyLVbYMEpLJ<abAx0ARK(7xVeE.쪪	fbTI<\0\0x,0fX3pm,GhؐUK1<\0Nv}ki&`++ ~vW1+TWNDF1(mmYZ0MjUI[h\'(s;iN=F)mJybea2.[KDW8mUX_:k54@ƹNiC}=\'`$M3%#\r6\'VHK?s c>+2G㓶v&};LWc]Fi݆dGVEin)Xk\n3KBX!1	5\n\Zj$GiVh̿fn|6\nqF$̫	M᭄\0\0-݋FL?<Uqo?Y^4_slIbdiw߷緊GwnLu/גxU# y1Gߪ;핯gT^XfiWYְ%-4[!	޹ZIRC<XF<1<c<<<1<c<<<1<c<<rݥ]bPh?esAe$`\"R\Z!!D,S.X	\0TpbWEmhs\Z(lT1iXA~mV8}v\0eYuXخ\ZUTk)Yy]\\~Y\\-FƒlX>{\0EBjBx\r%B*	5$3$rž7}vgߘǞy30v$06\nw1@LyIXLTXg#L\"R]wˋ;>nW>^̛tM?G]۠a\0WuEE-\\R&˖TKwXj0TK@:y\0UЍ-uh0_-XZ*W?Ai^3_	kmGVAg^ã`p==h19EA-mVys+Pͫ\0l[ϔ^ij5E)2V629jFc `ñs;IߞyycyǞ{f֩i۟Wi>b\"k,A\'4aMH<\"X]M6#VweDE,UTrH\nI$\0$A=Zlٱ,pWo4+bZIeR8Y݈U3žW#&pt\Z$o9$ɼFߌ59nA&V)Zb/d-?ԷWXVkxf͎:e4M	wM83	ۄьK>.ٱ\\VknاrپV~D:\"WNf=~WV✲>\r(fgRVp9Z21qWv^rEF2쨒wWC^}qJhtef)0\r͂ʾhfp\\iDٳS;^pu.tYKkag4{_ϧ-ZG\ncwI?6_\rެ:eMj9h\\90׶b܏ځNa˪6SUY(U{ciAWO,=N,L2<MxV%?#!qC>׷\rNh޽a]I+>G\"BR;\'D𤕪WbܼY&<1<c<<<1<c<<<1<c<<<1<c<Y&ivjۊ`ޙ۶\"\\1Qq;ojW\\_o֚*y#rvNM%b G]3Hا էX,GrIiWdK[<Y8>rk\r(d#hcc%~>z͚r\ZuS޸0uRP\Zh\"ˁs\r0cQy=6_c{f5?K3i2[Wэ3˯i#{nNWA]a P,=D\\Fm\"Ia%s]OMHeGs2)W:z <cE\\-ʐ\Zm7o*ˮ1,鶶gc*foK[\"YJդ\0UfM3jMZXNpX$RИe[Wك[Fq4Q{#Uн4li\"_1e\\i0;I^v\0tb%OycrOڭFt9!g\n`83y(m2.c;cz?%v;_\nك˚a+\"f.fڗUj2̜Sr嬵3A\\Xn[-jV0C`UW~D\rnR\r[s-)\r`Yl3ȓ@u$\0wUl#^6oF4eYּV)@ez~$jӘ*P֭,m-К\rVjڊ?=.6nJlZZ\'I,A[I4[kqtbfؖ[˫䲮b4kKjiuWˢÖ@#.Yɑ_.i_M-wcAP\0᫫,|xt\\c.s,R\rqYYaՙ?(ee	\n19dX_&-[UZ\rEy`-[X\'~..P%-Lbsn\\3` P\0p\"!1k0\nL;o	KoRžGmc<<<1<c<<<1<c<<<1<c<<<1<c<glj: g\\t|^Y7]ht\0ئI/kU٧Ԣ+3ZunC.b\0TIc\nRTK0ڽ-*H<9sbrn&s&ei޺-RjSݣT	@5%(0%beiu㾱]zc[\\ߝ9=) HYqCԢb&v-޾nl1}f91cjAN,v&l7,l\n&\\=EװuA{ا+tJxuI@QkD{+k._(W<<1z\0\0,yE_Gq.*]?ͥ#qoA}\"%d[}NJɏ|i$Y4(Iemt8;o$kkg\Z3s{kGAGg&ҶYQMM	lwJ5}s d0q#iU,ALsǆ\0܂jݭu\"w5C֬5}s;Ag)-GX10+hޯ7ZӐc +Hw\\1 ȽߡHF1Uc*IjZי&]}Y+rJrݳYiq \'0 2@!M 1gp(_#DbiF-U5DZ5bߖ~o\'mֆY2qg8Qc2˽7>ݻR:vmO_+MSr]b?PoP/1۔u%\\$/$aD?ۿNco\'{*9\07NG$Zb!69fk>XtãxA*vWHb`fbFHŤҧ+ϥYMZ+l!IG[l]Ugf	|u#>4sI7|ñ:oyiq:9C/$=$X7Guf2y>OXv{/\ZP\rc]QTlrI:vco$cόTX3{4F:^Exku,^WY-7}jqVEW\'bR\r=ǲ>9FhtPnW\0_ݒ\0m|ەRQ[~EW($0_/Am]&ޡQ\Z?;OpWeY\\`1rx٬g.RZ١Y\\Y9$^t>sԹڅi#h/\'y!Q)R^@\r̪ cԇ}3ЮuΩ|pjh5;{	%3]jͳrr>X]bn˚k1yycyǞy1yycyǞy1yycyǞy1yyOW355xD\n-(ryΑY5)J<nQ6]\0L_t{1*O*ߚ_4hRmyL٭#F$Mމ&a,rZ# &p\0mT7T`5XxĒa\0&YG$yc7}v>gƯ)K=O~4Q+,? sӯ:|Ҏw%t6T7tZcUoW5]*\0^TQ괴IG+MtrUջ\0ZO\\Q7\0Y5wqkwb̋GVj4V5,*v:_o].hb\roR\"Mfh>;~_9Q|m\n\'>dͅ\\U\n\\7tb˛SXPC6\0,\r7TrK\'1Zob?LmdZ:[tUٗYɦ2O:tKo\ZŮ/x}7ql!.=v:vG*7UCrNnxd\'@/\"O7qF\\hbmI\\GlM؏8.;9&~A5A>_;`\\mDheB$7%jA.]%7D!VZi?G=Zʗ7`\0Pҡ]@#˧]ůAjkd蜁\0TK\"嫄\0qAqDxq8`=\"Mt]pd+__7\0*39\r1	2`+BA΄ޢw] F!u3`dH(|wa/wו򕙅ǀMy-f3uF9e	[d{ny%욞Žm#;\nvnZ)rsu8UHH3̆ǝ㊺Yx\'q˭x$9:\Z[-D6zDue\\k\niY8%405lJlJT!_c btY/ˠ)\0,LjZϨahF}}{Q=&@caɱW\\$p˰AXX==GdCyE8?|V2::oo}+V BqQ=I|Jwh_g>,S7uXtŮ1jÂWKk\\C`keq<SH5TjaER\\)&%)[~RJ\0UX&Ӗdґ4Qo#K\"*cO		9Lhd^r5EIя<+}W-=Kɶ@O\",Y:r(#){co/bM\rof>Ago,Z[3C,}!}%DJ/?_/D<u[S|.wXvأAi}W\ZNƜrǳRuY)dx)}<kFqB\0:a+xѫ.)v˷+v2\nYk#;OhKg{=Bz_iMuc׽G{5q}Kf>amɋo,\"FMx$VPŒaKI*N_F]_!kx\"?!M\r*gLm˪vi35gɤߗ6\n@\0\0\0\0\0\0\0|wIFgGb䳻ĳ3XI$P\'~dۘ5라Z6/moSY?&bk{XO.ה~h5çN\rbV\r)Z4dlrM.hFheyc=S׬Ԏe>،הz|i|x̷ǉWկW>GW߫$_}GEn^[U8xrΘ	̸oL%9xРMU\Z)qT\\Q9@3W[:}39\0u$hA0V\"UK-dTznʠ|c<<<1<c<<<1<c<<<1<c<<<ToJ>M}mk+4}!syNҼx8\r a-Aղ!Zk1a+vn,frF[<F\ZrlA	,1|Xc1{\0bXH<hyPNEH \0Kz	JJиG\'fV0_H6hӃ-d2HO%w;6Rz!`\nv`H\0a\'\'%]k6̨\0aGH_YS#G1a9+c\rg3(zFSOn;%UI3.b{b!K6#9c=`)B5Κ*V#Jjl덢Pw\"?\\lkozvmq&\n}rn @<^Z;bۘ®]N)ݍ +LHi.sBVԤՇ\Zq\'Y8\\wL\\PŝXTU7]WFrV{ALo\r^ZO9m\"FYmÊ?8!ɧmٟoZ_T1.iHhEK\\kB^XvА/kv2Ҹ(c:޸ڗ]\n}ϩfN)̅!tZ\n!!*F|]M&lp:h~|V\0|{He6աyZ1boa]n,RQUYAQ*ĦĨhِi@(b#uFnkj	SBN޹\rF$H`2fIUxazU\'uu\\ˣ2m\'I|D;hyd:+ߺr21lcf[ҷ\0  V1khy\ZbQkf)ÝuVFsPK}ϧxǏva~#[%ى9<0\ZiozicPjkԭǜ頭12LlR\nJm61cE35ws!1jXQ<*:#݋sWV蔑.`7˵7Zҵ[z K5vGu79J7*\\|+b\0e3.F:((Y\'󩶃Czk:Z9RgƟO#{2ޅv+QPܻp\ZiV\0 TZ,WaҌ50T=]at%7$\0\"z.EX4%_Sgv{:h.؇*jmX	r,3OA\ZdV\0\0\0\0|\0\0\0~ϻK3fby,I,I$I9Yd]ACeN\ZEڞidmN÷_81|S!]\"i7K*î=a[o\rVjJp#IU:SY +JFc>)/z{DjZ֡x$k~QYbhIbthdKikc\0ժI,LEyR2I̇2QIﱺ\r;5Hm\"mcu~;9e3IqH]:K&dy#~jW:[7/s=+qPO\"E.δ9ʮg+)ŵǬV,I.B؈c\'9gݾCo-ҊxU؅8[.u	pg\\=Ԩ~nY\rwz:[TK]9Mbc>1kmYvHmnt)sz4}EѪW:%{oc#]6Mf|k3ϘǞy1yycyǞy1yycyǞy1yycyǞy1yycy\0[6RQ:JG،iv_%h``G]ҷ!Њ~sN%YU`*zeɺ2\"\r?A:Ai mg\\0UYΐH~z^NL*Z	XtrV%egV~JzZ[<-l$RϠlOs+Fx;Y\"XW*#\'?;zvEfp|C\ng^_;a53a66b2(ELo\ZU9P7Jne`$U;UԬdX\"Z~J a	$l͍ZP7\\Zyl&><#Mwt{Em0f\Z}bf5OOpykGU-\"@[-d&_-(s\\\Zej\ZYX;;מ%q	pPK!³zsoZY/խ.7h\n\Z \ZK{)Щag/-}eA+@\0:[AS&JZsznpp|0Β?h4hYpF:\'2q0\n`wJ\"XM[`c=ShZ)m:Wt!ŭ<{o/S0tC,r:CGiu.7p#C訫w[yͩ.Mq}ִ[FRiY=;J`&`]]GZ1PS]p6\"F._YGqy /huG|n>к\'\'+sE\nHb%Ѭub&5deau{V{\'ԾִviQk㵸>X]\0a-=m|Aۼr\0ԥ\0;w,vo/\"˔`PzŚt.\0*u\0*ؗ97o~ƼFV5e&֙~̎7?oĴҫ\nT6\\/W*\'ZuJ>VTlK٨R;c[ElBnJmZ֬ԞϖoZDrHȼd[20=?k+7\0{(7I44wi@_hv҅;to0ˆ\0^ҷЫ`QiEcaLڢL*ayedbmm֎ٲ6;Q\'Ԥ}P}$\"lk6vuHV	=HI¼q=Q|Yڲj wdK*;l}<Pl>!J#;$HNe^gy\"]NTCD/]H伯2lLDȺ,u)/-vf|:RǗs;9\\.\\b(:WǫN6uSnوȷ[z~KO!?/-D[/\"H-FGyXb5fY<rIz-0ֶ-KE:!C-:уfK\"veADNsq/=#T9qU\'\nHI[ΦeQ[KI*viKFLhdǘ\"$b\"\0TsA6,{mǾs+Uz+me׋vV7+^~72pU*Xt>{N=[YXo\Zj-_/BuW^օKuH*/Tc|zFlƓt:W*$t{vy0t[v!2F#%zHhXd1\nI#DK%WAd{2\Zڻ\'H8;/\Zױ\nK,Clǅ$6m\ZGl4IUs-/I`qRy6̎z\r1bVOt,fhp~i[8_3ne?ЊSq*1P[-7_,[B\0\0ˏW\ZhݭɽTUW,玑H9jk<Usf@\Z+	oV@P)uw2y٥i,B<W8A)\\:SnTbmWb\"[\0gPqӞey[RoyuwX}\0#EWGvgY{i^IQ:ڂ :.P*d\ZV|H2˾ep]Ii16qҫ#k_\01O9#f`돻0If mSɶ2\0X%}w_nc%mEVXW	C6Y]ĸXA>0LVA3OXA A #;cKX%pd*N`24\rBˁ]p`:,qkc56e\0跹HNOJ}-X!د~ҘΒyiಇ]h\\f}*n/jPWM}K+Lop+QIl`e-\Zٯ1/(i;CC}6[\\9:k.b;K5Rh>qmK1\'>2 klHM~o1%S\";:&i$pm3൘ÓOlIC,[kiI<1<\0_N\ZŶw&mQGMI}a0B17eٯXBw(Ӟ}ν`@\"2EV3sdn6Rhp¿d^r\0em4Rc:c1yycyǞy1yycyǞy1yycy;\n\n`ax-\ZdY6.˘&sRڲB̗xdZ\0vQ[qʐEt[˶2am%sL3I:˙+Bpa(\"MPָ/D.AFm1ӛ:N\rzF79GZ3mMR\r`z\02Vae:ifꬖr3ЋzP+J;FNc­-cH߂Hv\ri^y᳡ W=Tp66?+6ٿ #E9\ZeVETpZX!iH\"XyXK,]#=5}lkgsJ4($P1,@m\'{7\'3y<y$yYcAEIbR4.A3U.UQ/`fV+ŵ-V>թnV6)^RjZ`Olablv\\#5}loFuZZ6DQ*r=Q@!e:^,#]:y{uΫжO^Lä蚏:7)\"(YW<_!1Lu3u,jk!4 1 *XQig HIe}c=v}\\\\/=Sw^?ʍRzgf\n/4.As\"NT9O63U+ԥ+>\nߣhǧcYHlu\Zxg;_\"HE*b\"MW6!eWG&=1L>*>yS]ш򋝩{(b懘V)v6!1	c)C,Qb`EcX?/?˕v襨^R;5[ֳ4ܬǖi\"u[\0hf9aQ\0AAyGЭʑT9K5j͝t\n1}$e\\)n;o6L6)u7g,~I5:չV㧳|h#-[Xߩvo.]`!Xb0^7pŪ	6JC}L걛rsaw,(g<i}wV@s.=}އ>$qU?9p<H&qz>ݦqp̜e\"RNAxeׅ\nh5Y0%{4x:Wܐ>IVR<Ѽ~**UڵbtIޝ݉<[g3QwXI{}ڑy7>ys|MհO+HҴm[War.Fn4=4=58M4\\kkkk11u1c1cJ\\/?\0/pTkAk_lmW/ccؕC)r5rqծW:*L7}{3\0:tPv9GGV]\Z>cy_at訦\n5ԫ&rfH!_ ꊋ{ eB0K|aWR귲Ytg-<rmHaTyg1XOGɓ\nUU-tS}1cdSA\'mǟ8\0L{-foL1Z#*$0fySY72b;R\0؅\0˩}KʏGYVXzH~W޼+[^I+]!0M6dm!\n{sKp:y殅xkW	6fX*X5r[3f٢%r*\0֘˶A,aplIa5SlrtE\'!e/Ā8Z\Zh\"CA%vQKDseU=5@K}.vkh\r:4ަQ0n?X˚Bs\0_E^~^O\0#}wsKK2ڗNs,|ЩZUNm9R6JGl5m\'Uxۭ#frbPNb#$}ẘޓKX`.-	Ԕ?/i`w82.,mo TkZUuuK\"HY-%CKf0=]dt]iZ9i,u9GfT\0+N,.97KiytfWU?vߗ΢\0uA4k(Hم\0~9Le^O3Sm̖_vbH6:M&̍_uGK<pJN\Z]ZC#,Q@\r,,ȿP\rPbD\ra*7cԱiH\r[7V(1Dc&]3sFMA}+u\0ŘhQ7a\ZMPÖfB`EFx$n[XbopG>)e4aC$1HdV+\0ǃ΍nZ,X+Yq]b?YIتfM\"ȾAĳFkҪ 9>WʁҤT5WIH#(Bc}+ఠt#VC]f$EU^@%HQ,KQ35yVhZ}dI<h\\dn,q&lg$H\rz\0Z`F)9ڄY0H%Y%k5Pz%{Q\"3utZ%!1@lm!i=^C%O^0\"M6ƻ}k뾛kvlcmvl}6msu3gqgBɞ^xe\rȽQdM?L]WWY6/ߚRG5mA+PB _!c2j@v^A6t~ΚKt]K\'e<CnBl`fugj,BR\\Fri+N=.|ED<@\\AAb\\2sʈнRڳ[Q\nM4iqELfλ\0N]x^J<vjxUaaA,*pJ:WlMPt#&n{Ĭ><V)jVS_f\'T#]\0ƶ4T\"#F<n,C)1c=x->:q6AaLONf%j@i*d,v]JJΛzenO.]1]53]l*t56x3=ic9y~J3\'tEdUӱjr+IaC<~#~xm\ZDIa~y~B8)r@ӵHAF0+O8=69NƯZ7DnbUо{4tX#X*l\'.8g@lgUW[U-~wC\0&y\0kG8\\IZwRk^){s?uJĊ:mdQɈ9}\nfataѶ&mǺ*9Br>8ICr<UBV)Kw}Ъ߾\\\ZC#޹vȥ<o^Y=Yp-nl7\njt[T7jRfIJIr2}ݼf蠟>\'*ѹdPwejV̡9\n9HOuϻ̟NV\Zv $P\0s۟=h}>=Κ\nKYu9Xu\'UCM\\F\0l0=!іn<t ᄀBLjwݯC:2E!!k5f\'([\Z+\"U<1)f&Bti4-+ϸAO\'s6>2;6ť/5bop)pǐU\"_ߖoaq95\\oKvHmwM6]k8ϿOZA AGA yǞy1yycyǞy1yyc=gl-~2.н=N~T:j\r7`yi\ZRZXG>F\n)Ņw%ovowohkrk,&dˤ8ftaJ9QsZl1dڽ4\Z|@_C;sJtXskKV[h,a}`5܂]Y\Z\n1c-vVɩcX o_<\"Q(\\3y#TüD.\nLWdmm8҈bHtp~}\nDV5UXtռd*IlRymZs}%Xt(<*-5bx>E|h}%7U_\'=7Wϴk3H[>f.~	qPdv։흭w_i8{o;\0\'-ThYU#Z3$#cv]TB-䮂$˜sgv<z#]Bt6jY*q\09]Qm#VUTcqG!g)1&M5lg%ܓXkLhiE32L\0Y&Et#S3\"+ڠܦ״\nlk	DZ-`X1N	gjG:YX7-p(\0¬a~Uޭ,UIQ*iTڽvQN5)\\9\'i!p|軳UŮtE=~>x\'Tcm\0Mw6ɽrgL3/p5E*ھLr4:M|ɬ_\"B\\8ek\0[N[~٪{\\lz2I>ni\0$]%_ۚvmû_6?	?@\Z\Z4b\\+]{LڥK]{ZՍmRC]yÕ#fSʳz)۞A-kPbvx7,0̼KNl{MKIm)u%V\0?`!;O+=j	cEjt-]hK<#?Jrڔ՗a__3~vUnt&HX c\\&3H`k&SUwCmwaůz\Zq O1HZ19SR­jD )-\r\Z{\"6\Zk,	c}dB0]}u13|ļAa*uHs*$9qc/+#ՙf非ژ봶<.Bk_հ}?HWֵ*ʞV_UlQYB6\'#l#eˈs4Aم,gCS{\0ɞe!	mgXHX_+s{Z18ƿn@qr\'u#c&[&CL[~r\rFWU&?ֈ}3RW%\"3޿ʻ:r-n?ˊ37.j,/z>hVmҝMN;|\r>h%QP%kU:1)LXpЀ%ݠiM<f֌bVi$j­ze̕,٤bmAyaEߞz\nӞ\ZHŞ6r\\3F]am plMPaˀ$b%zhU\"|+Uג2 6|7٥7+PK]ϊikJBʪH@he񲇞y2<1<c<Qa+\'\"bX\'0kEqZ3H~2\\2Üc1oqWIvAx\"t6WP[GMq\r\rq._5Ť_5ר.Fǝ10g]\0rI;$i_?f\0<WؼۋOisI\0]Fcb%qnq|m=ЮK6%3Ja	[c4#7\re\nuiMcE&1$y|}fL{xkoXsdSAg9ΛgL_~?s*̬IVRYI >Aȡ~7iSYL׉~dvC^Lyaߋ0VxGӰD{_DVjXHV9\'Pս1t3äfL˷k\\zg^j%9\nN;c}	c]v8OdvsU[5$:8~uQ6?MgިHuƿXgzBZ`s/د=/BtRU.c,c!w)_\Zb;yruuudLɌp$e­+$L1[`j9%*fb?}z,iI\0PX%/oVf?XOK^xAgmԻ2wqE%Ghֆn$ο]pl:gm]V\Z&~닪wT;gL!VBa&붿q%1x}UAJZ5P\Z#v.d,QLԻfj+[{[^wnY|ٱgJ*Ea![*~sٲHn:2+VtQ3{hdk]f8#2$dYf756UZxB2z`ݭ&dH=]|@%\'8vLAeHƏ	abH8ž>mrG?]mss5$=vvfァl|2j|\0٣[.W]k+$ŉGhr[3M]ct\0`{Y!OLL\">9Q7\Z2IQ9Ms:َb:ȺZ}\nj>ym<3w_ba:ȭ=}g,(2U`c%(Bȋd<}ZgydJWN\"x\Z!Z	m1GRf9&fc2Ikij_`WPN\0\0zk_3m?l2)=Q8尧%@v4 qKy-_HsIh8DüM5+ouVRz<k%߯\\ra{j&_\rU7V?p_7k3Kf`GaAg_js}6a6_/cf9DiɟXmrnVN~gxws*mp\Z)l\0\'z?\Z%|b?sqtvh2S1Uʤmn*yIrqh+CMNHqv\rW`M\Zr}R/%~	 )SNF}^^c:m}!FbG$r\nl\'@m-c	4wEH\r2\Z}\Z?w}Npt :ǣ6=±Z:0 뼺IU<\r:-m`fcM3氤I4.ABvT\"yA̱k֔YWW\ZwpV*{MRy\n½qjnD%n\ngSƞ&5kgL״ñsV9H#hga]9mU\r.]-YI3U(=O#*Z8m(dq%mE-k1/U<sٿӥI,Iٺx9Ҥ\"ݔ2t6jѵ\nzzB)<1\"sՌTGC6Jϙ	n8\0C(!BAؕ4ZѻXB,qGc-KvA}[U:9@M<[~6`jU=W=םV\Z?\rӫ2+}7m(gx)6F|7^p\Z>t+emҸ\0xw3\\Zւ,۲ώ<\\\'U%11)XrV[ִЧw~Mۃָ/Nw6i4jK+S-~Cr,9	+yh\r+Mutkuʫ+N%JJz*8+,QAp鮸c)s-^ϧQO>߸ŏox\rg\\$l׫\'\\:X%Оy1yycyǞy2ѹS:]Q-Ҟ8b6\r4e\09q\nVAЎsaClY)Qf/\0^1K\0?#\'\0bCF\'\0_\'\0,4\0ei\0O<Wԋ6-[{hi홖JY5\0KObFYrgKb)BE@3?ɻ<:d%}KO4\rk{k,N!k{|osN-wqkfG\'uXU9Ry`kkiTitC+t@ZXVVk~N*%\nh6rس2-\\mhK4W;O6KfNkݹY+}Wn,־P[@[`p,&\Zms97 ԆWJ9&`d\\zU=ꑐ(\ZsHXY$Dga|9	ԯ<@iQ@GGXpn˪B30R3dӏ^Hс da*^c#*@wR2;)W`zuw*p=Hm$VajV+tcޭYVD\"[J׆DDu\nʧ%\nRi4䆱nf?kA~XV͞LƹxچY:v10j6PP4jz[@Z.(3&#`\Z,>tETrȬ 䓒D[QKW0E8b]w~+Q/g\n,v-sf$,\"&>^	݊儆[E~Pv\Z5M-[П,1i.a`G,yZmeXkuҘy4YTt{<	nEI`Mp9BnqdVZNQp<kR[úo:0Sºqr/z!(@+ԃ$@=\nSPFywѤ,[dXi@/s3Ku2lee4OmPPgbJk\nR}uWM \"\ZUѪ·qZ#jH2ED3L\0۬5i3;!L%]*n+VV\0VRAA#&k4疵ճE$,nJ$rG\"::WVV{lyǞy1yycy$ʇ)5l$gymU{$ę%TĘ&&띵\\}j\ru/ )>.ڧXvm\n8r.[ͦ6m61<_KW\0k-JB2t\Zv#/\07?X34_v:ҭnlƶS#o$5 \0كq7]M1ذ|MgX6kop6q2\r0>sMHg9qo9qϻ;%iH\'.6\0\\IH@8<뾛k=yg ^Ιmbe1>iW-_X^0f,d\0W,s:]~03i1.oyej$ιz?ssr\rzm8럷qN_P3ښ>g;ǮiBjCK\03|7ٚbƻ}Wl1+yݍΙ~靾M|<Fkt[?\rK٫\'sja56cl\"uٛ+VJiW#J,/;B5\\ϸ:/4UhAOCC\0KE%[ha]UZb0&ggu$3htX(ukX\0\0PP~Z>57*(n\0dKPWYAץTZ%|{>2_1|rk[ӽo.(Ho\0@8w+F\Z̚M4^~CLcY¾QT7SyL_e]t\Z7bٰ-c+\"\0_Z]/3\".d-z2sdiegf	N)1^\nϠת [HϹ짆%xիݙ;/\0%ylۿlۿ\0n\0WGc3\0n\0W\0^y\0\0^/\0%{Dy3;\0/\0%ylۿlۿ\0n\0WGc3\0n\0W\0^y\0\0^tnkz=>.)cF(	i2b΅+tGfrNx,\06̐]9OWuvjqF/J\\*Uo}XiC;\nuIG3!	SY6gR-{)eLѪzMoZ~Bp3|k:hɊfϘajT-ҝ6\'ݫr-r\"?s2#4X܇Y.\r0&vՅg\\\r\0ڵ `\015_1Gy1y]97:§y2\"Q8Xϫ,a1\\~39Ԝf=>f*70- 6KmSADgCxk=V0f],,!X&2>YzՁӤѻ<HbFFF╞\"8:o6-!hYץҕ%CnܮF声MFAwPֆC$۞ϰs&&V|##-daŜUn5[ʈSIQzS>Ly7&A`8LI=z_Bv-Ilۓ*Z뒛\Z5f[9E1<f̍b#icMqK2ZeD2N{54TZK-NޓzZ#$ZmZuBn6綞Y`9CK7y@QmJAҙkd2@V>h=tJ*B?WUƿ04ҙsCFpLs/RׇֺJ9c1\\9[lLF\ZR|k&rP<(h:Ff&8!<lv0G>xƺkTSIF4vVl\ZSأ(Šq^.}ӣ+<c<<<1<c<<<1YdA\'L@g\r	bI#I!L\0mǡ_ٍ@ldb0m}b;qU]R%D͏f\nL]sfMsff?ɺtV(m6WglJ &5hdX֬UAb\'PSm]A.uN%ZT7JpV®=W`G\' M[͜y','pedro',1,'gausspoint',NULL,NULL,NULL),(184,'point A 10 10\r\npoint B 60 10\r\npoint C 40 50\r\n\r\n\r\n%pontos mdios dos lados do tringulo\r\nline ab A B \r\nline bc B C\r\nline ca C A\r\n\r\ntowards O A B 0.6\r\n\r\ncircle o A O\r\n\r\nintersec2 A1 A2 ab o\r\nintersec2 A3 A4 ca o\r\n\r\n%drawdashcircle o\r\n\r\n%drawdashsegment A1 A3\r\n\r\ncircle o3 A3 A1\r\ncircle o4 A1 A3\r\n\r\nintersec2 AA A1A o3 o4\r\n\r\n%drawsegment A A1A\r\n%\r\n%\r\n\r\n\r\ntowards O1 B C 0.6\r\n\r\ncircle o5 B O1\r\n\r\nintersec2 B1 B2 bc o5\r\nintersec2 B3 B4 ab o5\r\n\r\n%cmark_t B1\r\n%cmark_t B4\r\n\r\n%drawdashcircle o5\r\n\r\n%drawdashsegment B1 B4\r\n\r\ncircle o6 B4 B1\r\ncircle o7 B1 B4\r\n\r\nintersec2 BB B1B o6 o7\r\n\r\n%drawsegment B B1B\r\n\r\nline bb B B1B\r\nline aa A A1A\r\n\r\nintersec OO aa bb\r\n\r\n%cmark_t OO\r\n\r\n%perpendiculares ao ponto de interseco\r\n\r\nperp a OO ab\r\nintersec Az ab a\r\ndrawsegment OO Az\r\n\r\nperp b OO bc\r\nintersec Bz bc b\r\ndrawsegment OO Bz\r\n\r\nperp c OO ca\r\nintersec Cz ca c\r\ndrawsegment OO Cz\r\n\r\n\r\n\r\n\r\ncmark_t A\r\ncmark_t B\r\ncmark_t C\r\n\r\n%cmark_t A1\r\n%cmark_t A3\r\n\r\n\r\n%cmark_t B1\r\n%cmark_t B2\r\n%cmark_t C1\r\n%cmark_t C2\r\n\r\ndrawsegment A B\r\ndrawsegment B C\r\ndrawsegment A C\r\n\r\n\r\n%circunferncias circunscritas\r\n\r\n\r\nmidpoint Ab A Az\r\nmidpoint Ac A Cz\r\n\r\nmidpoint Oa OO Az\r\nmidpoint Ob OO Cz\r\n\r\n%drawdashsegment Ab Oa\r\n%drawdashsegment Oa Ob\r\n%drawdashsegment Ob Ac\r\n%drawdashsegment Ac Ab\r\n\r\ndrawdashsegment Ab Ob\r\ndrawdashsegment Ac Oa\r\n\r\nline a11 Ab Ob\r\nline b11 Ac Oa\r\n\r\nintersec OOO a11 b11\r\n\r\ncmark_t OOO\r\n\r\ncircle ooo OOO Ab\r\n\r\ndrawcircle ooo',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0~\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0-\0\0\0\0\0\0X	\"\'Gx\0\0\0?\0<<<}\r2a\rQEYdUH<dմ+Nm\r[h)o#1*FֲYoN&ʘ,JN˳,qiQO\0鱯kjq\"d`ymbYܓF/\'WX\ZJG|yyyzO/9Z\0^r6kvDq7&Q30,_GN2mO0ui60%%l}pq&Tp\0WkU7UJ6gQv}\'%}Y`>lKj~:Wyyyykf3}ND,:_hU:5FOA[m:_`d_o]`7O[<,h5G%wmtrө%: NKƨό٣s&rR h.si.$/XBl_DN$u7BiʈF%\r2Lu<VL!a0\\Ngƃ\0ZJQR2!IZu+Ox;yyy{-ٷp〵h%rӒ\r7SprB$)	R֮\'#_LY]Q2VlFe,4]DgTȀee,]p)\rvX8IB`=AQAD)HZiRw=&|cgF|,Rt!MCM|vT񢤋Bg0zfY·x<<<юE9KSw]ğ^k;s@t^,񖟠9ũ%kY?FdsO\rБiJ\'Bq)Bq)JSq)9s9sߗ>	Q~:|a@\n!j*!(4p!3{$2dzQY3TۼYp8nQ\Zi(LDDuH ȅ%hZԭ=yyy瞜.\nJC){f9docP40E3rVh\ZE \'f,P;++̫\nTRq0Ar̻e|bq(A,b)h8\Zإ\'tsay籘!pp!\Zp	(L 5H ȅ)Bԭ=Uϗlׯ%N$)Ziʗ^4T}2Lufo^VL9yyy{̊/zM80c\02v{mrA%VQQrbp?KȴMt΃0[EKԌCoՕh*@q&H:uFA/,Hmi֐hhPq<G!6tj/q\"\'Ol:D4WeD#ed&xOvdLOJ+&wJ{w0.\'\r3Ap%	Tc(BR{wO<<c1%p\0\052 \"OVBP1	RֵBy+;s4;l5_}+].=#Yӎ.Q\'] txI~r]Z,[y\"yyf\\gưBJ\"|R2!JBд+Ozsy3:5Ib\nl\Zk櫲׍$_L<]~ل[ׯ\'4t=yy繵w9Y/2\'/-6\\if\"rP\\a@\\oՂ8d5P?e$i{o0:b5^^\nf԰>ob<_D:\ZGе[D7ieekAKkhڌV␕&5#K/(xϞ,:[{Je^g$ƶ%1EwYuN%cHPfY).ݞ0߮HBli:%MnxsLt=k5zm<説}VB6>߅3Ȋ=oeg?8[}f9&=>it41,ϯtښøSY?E\ZRo!m1-57MbAHVx6stigOw0\\Ngƃ\0ZJQR2!IZu+Ox;yyWoE\'͟EۧlcRK<isWA6Vo?lEb9#D2ۛ*<+bO+ƓrĒäj637\0ew+sRNs u.Lڣ`&[WꕈJMK9au(@3dRr/\\,b=r.%Z2?+ݫ=^axw%m7 OS5)$ۋ$Ody&H6YFk`ROlwϿHSbOs٨,TSF?~kZr9\'\rOEB8ŎESbRzj}UJг[ߧi9#6PVm17oL$ǧԭ.%\nȵ=Wt+\'\0\0djkz\0^tkMqJ|BP{Fj:Sk(V\ZUW[rF\r0\nXcOVEp8IB`=AQAD)HZiRw=&|cgF|,Rt!MCM|vT񢤋Bg0zfY·x<п2S=foZKuiq9tzl*j/6[C1,_wlD`v8rglW]e:cfjR3LeKYm7GQnUM?`dQϠ.2u4m梐߆*fJhlD#d36B\roN\\qSհ;YJtu\rP:fK)X\'Zq\0o>5傣\0W[~x{%TȚ^\0܌a%9m\0-+t7;e5;HEL;UjuZ-~2IXP5f\r^ķ!!3`95l!)zW}zH&΍E$D\"MQt(쨄lP,_̐ɓEdP|n=fDFph00J,e \"hWRO{{+\09!z_RhJ\\JΩ]9Yu>ع7jX&[mgioSQ5{hURߖ~,.ӖEWIjGU.ᶩ1Xio㘕RyELeK5+\\X6[|Ñ|Lgu;	jpkp%V)Aأ(\'!5RƼ,K\'qVZYꚣ?8gu{w9iZIhV&=[-/e>l2Wjde)8H`>wFeVt3;Q(KMUi\Z/6O>wt:n.|%/MX:MɆԾX#+ѮJ\rE`qTbfotYu2r?\r8$==cH?ОRIDx1?WzẑB6& b@ࢢt<3.V3XN!%	TF)!hZzJw\ZID6\\wQ\r5URƊ/Y	.l^דҊɚ]g:z<cM3?7C\nd\'[pq&\Z8\rE$vS%Z;[[/޶ƢX˻;3$(LD~Qq\'PoGW_A`0b}1f:MI#g_7nە=A[jD ix,Zdq6gy4V,ĺW-٫9juBYdZJJiÌl$s#+1Dn1ͭ	h-X<l[sR|jIjrL3z`fE}!\0{?-5Gc))WYs\\LT.V6vEE1Z=+}އ^qbq7$;O41n܍L\'33j[{g;ϿW>L![5l+ӎRK;ݰt0 <IPѨUĈ>I n_5]J\Z8e=ْ2y=(*C`7(´&	SŌ\":dB-\nVIyw<jhV2<Lo:m)D~rN¾HT͙G~\ng}(ye᷺쌧0(<}386ke*p[߽\\YmmM̜$hAO2mx~>\nM-VX>jlL6ͺdi+{|ڳXp=3:O?HD*bZ	1|9f8ftu)\"rrK܍pL!\\BKFeX3q#WPO&4nӳG\nx8^)Fn}XktRdƠ-/;6n9c3go6LS\r;KoQh@\"mYx)űfsxU^y`Jpk	d$0J( \"-ORW;>^1^T):|ˎj!j*]xRE!3KսzzQY3KCۼO[Z}|c^=f7UߩgP4}{yUV**V-\\݇ m\\89F)r./֑eյ0}k}TkܠUNIQ՛lSӉDZUbi5j:ٛa\Zw	:͚$20H8PN\Z/HCHN\02\'[P-lq%z\nrkMV1v᡻$*8x2@^x6Bb7Y,d{tuR~i+dv+3і#L^4*,SaW&S%a>{LLDעe\'#MML=mدde%$ـ޽v`h%91\rkgV;Vpq(P_1񮣤~Йpr5}Lvb?mj\nOm_\0F\0=DyyCKC|-H?.W.:SY1B|kgP\ZJդ+f<dM5?~R~I\0Elh\05<rעFV2%y8tɰ: >I/?aD}^Eff+ڈԭv6¿)&\Z#!Kho#K=ěJez!~?Ô7߿O/?S9K\0{:\0󶓩T(laũ\nxCDN%dpb\n])xwd5vjdI&2FҾ5z_D}_{i{53>?:Gq]4hBj!\0,1]6Wگ\ZfG?.q7FVe(8*_\0OFfOF+xjeAbfT3\0F*3iEwaG:y@x\0n{__`<&3a.̓?3ۤ2SzZ݈KRZT((mJ\0ܧrKixej+ \0f{9-?ϟ/\0Uc\0\0y=w)yor_ܧr)\0)yor_lxpqxa8\rJ\"oTR-=Jޥ\\;{+\ri#y&)3.ȍu$ENZ	̄=^ң)44zMg\0','vsantos',51,'Malfatti problem',NULL,NULL,NULL),(188,'%% Example 16, Chou88, pg 109\r\n%% Gauss-point\r\narea 5 5 160 120\r\n \r\npoint A_0 70 10\r\npoint A_1 20 10\r\npoint A_2 25 40\r\npoint A_3 80 48\r\npoint A_4 56 60\r\n\r\n% point X, on A_3A_4 and A_1A_0\r\nline a3a4 A_3 A_4\r\nline a1a0 A_1 A_0\r\n\r\nintersec X a3a4 a1a0\r\n\r\n% point Y, on A_2A_3 and A_0A_4\r\nline a2a3 A_2 A_3\r\nline a0a4 A_0 A_4\r\n\r\nintersec Y a2a3 a0a4\r\n\r\n% point Z, on A_4A_3 and A_1A_2\r\nline a4a3 A_4 A_3\r\nline a1a2 A_1 A_2\r\n\r\nintersec Z a4a3 a1a2\r\n\r\n% point M_1 is the midpoint of A_1A_3\r\nmidpoint M_1 A_1 A_3\r\n\r\n% point M_2 is the midpoint of XA_2\r\nmidpoint M_2 X A_2\r\n\r\n% point M_3 is the midpoint of A_0 A_2\r\nmidpoint M_3 A_0 A_2 \r\n\r\n% point M_4 is the midpoint of YA_1\r\nmidpoint M_4 Y A_1\r\n\r\n% point M_5 is the midpoint of A_1A_4\r\nmidpoint M_5 A_1 A_4\r\n\r\n% point M_5 is the midpoint of A_0Z\r\nmidpoint M_6 A_0 Z\r\n\r\n% point I is on line M_3M_4 and on line M_1M_2\r\nline m3m4 M_3 M_4\r\nline m1m2 M_1 M_2\r\n\r\nintersec I m3m4 m1m2\r\n\r\ncmark_b A_0\r\ncmark_b A_1\r\ncmark_t A_2\r\ncmark_t A_3\r\ncmark_t A_4\r\ncmark_t X\r\ncmark_b Y\r\ncmark_b Z\r\n\r\ncmark_lt M_1\r\ncmark_t M_2\r\ncmark_b M_3\r\ncmark_b M_4\r\ncmark_b M_5\r\ncmark_b M_6\r\n\r\ncmark_b I\r\n\r\ndrawsegment A_0 A_1\r\ndrawsegment A_0 A_2\r\n%drawsegment A_0 A_3\r\ndrawsegment A_0 A_4\r\ndrawsegment A_1 A_4\r\ndrawsegment A_1 A_3\r\ndrawsegment A_2 A_3\r\n\r\ncolor 150 150 150\r\ndrawsegment A_2 X\r\ndrawsegment A_0 Z\r\ndrawsegment A_1 Y\r\n\r\ncolor 255 0 0\r\ndrawdashline I M_6\r\ndrawdashline M_3 M_4\r\ndrawdashline M_1 M_2',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0C\0\0\"\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\08\0\0\0\0!\"(1h	#$%23A&c\'CFH\0\Z\0\0\0\0\0\0\0\0\0\0\0\0\0\0+\0\0\0\0\0\0!\"#1$2AB3QT\0\0\0?\0\0yǞy3%͝g>a!,#0ZD3F}{Zn=jkvy4R_]YneK)MQ~1$ׯrZ_\Z۬Vz񐡰Ex=ic7㬴a.j\"@DH!ENI(ʻ%Rҷ̤Kcjm,9&7y1yycyǞy1yycyǞy1yycyEFεͪP$*DvJ:L,D{Phӥmi$Ľ\"NʽuE*f vf!Ts$9j	z]E,\n0Y1(bVY:5gr&.)E$Ok,O\rV^-Cbp04xڑa+5M,aFF31t`՚)g!,ߖ1atSOuo%U;T+4T!Vj)Dͼ!̤6SZ8hlrr̒4 +y,N?{x9΍%\nBeB$7hՙ{vVS ;I:WbeG0Kadx!OYVtZ+_wֲ]cu5\n9HLZ\r~>Dm,Q|~Ů݈ yjZR@/ɑ\"\\\"m4K<P}&|陈}y%m^8<2I\0rȌ%Tb @y9BhQkц:tꤑf*9F^6v2ӠU</yǞy1yycyǞy1yycyǡwTF7u[m`WdLAf?ʸi?nߍMnxA++4ǥ_sO<qA^wS	jm+%BAx\r&$[{\\fo:Un5HE|#;i@]sO_NDVgǞy1yy{wN\"(fQ߇tDT>%\\:tHii tJN4Xr#cwGv7fUaj¾[k466NANSFN0C1C6Ǭc<<<1<c=z]qyLVbYMEpLJ<abAx0ARK(7xVeE.쪪	fbTI<\0\0x,0fX3pm,GhؐUK1<\0Nv}ki&`++ ~vW1+TWNDF1(mmYZ0MjUI[h\'(s;iN=F)mJybea2.[KDW8mUX_:k54@ƹNiC}=\'`$M3%#\r6\'VHK?s c>+2G㓶v&};LWc]Fi݆dGVEin)Xk\n3KBX!1	5\n\Zj$GiVh̿fn|6\nqF$̫	M᭄\0\0-݋FL?<Uqo?Y^4_slIbdiw߷緊GwnLu/גxU# y1Gߪ;핯gT^XfiWYְ%-4[!	޹ZIRC<XF<1<c<<<1<c<<<1<c<<rݥ]bPh?esAe$`\"R\Z!!D,S.X	\0TpbWEmhs\Z(lT1iXA~mV8}v\0eYuXخ\ZUTk)Yy]\\~Y\\-FƒlX>{\0EBjBx\r%B*	5$3$rž7}vgߘǞy30v$06\nw1@LyIXLTXg#L\"R]wˋ;>nW>^̛tM?G]۠a\0WuEE-\\R&˖TKwXj0TK@:y\0UЍ-uh0_-XZ*W?Ai^3_	kmGVAg^ã`p==h19EA-mVys+Pͫ\0l[ϔ^ij5E)2V629jFc `ñs;IߞyycyǞ{f֩i۟Wi>b\"k,A\'4aMH<\"X]M6#VweDE,UTrH\nI$\0$A=Zlٱ,pWo4+bZIeR8Y݈U3žW#&pt\Z$o9$ɼFߌ59nA&V)Zb/d-?ԷWXVkxf͎:e4M	wM83	ۄьK>.ٱ\\VknاrپV~D:\"WNf=~WV✲>\r(fgRVp9Z21qWv^rEF2쨒wWC^}qJhtef)0\r͂ʾhfp\\iDٳS;^pu.tYKkag4{_ϧ-ZG\ncwI?6_\rެ:eMj9h\\90׶b܏ځNa˪6SUY(U{ciAWO,=N,L2<MxV%?#!qC>׷\rNh޽a]I+>G\"BR;\'D𤕪WbܼY&<1<c<<<1<c<<<1<c<<<1<c<Y&ivjۊ`ޙ۶\"\\1Qq;ojW\\_o֚*y#rvNM%b G]3Hا էX,GrIiWdK[<Y8>rk\r(d#hcc%~>z͚r\ZuS޸0uRP\Zh\"ˁs\r0cQy=6_c{f5?K3i2[Wэ3˯i#{nNWA]a P,=D\\Fm\"Ia%s]OMHeGs2)W:z <cE\\-ʐ\Zm7o*ˮ1,鶶gc*foK[\"YJդ\0UfM3jMZXNpX$RИe[Wك[Fq4Q{#Uн4li\"_1e\\i0;I^v\0tb%OycrOڭFt9!g\n`83y(m2.c;cz?%v;_\nك˚a+\"f.fڗUj2̜Sr嬵3A\\Xn[-jV0C`UW~D\rnR\r[s-)\r`Yl3ȓ@u$\0wUl#^6oF4eYּV)@ez~$jӘ*P֭,m-К\rVjڊ?=.6nJlZZ\'I,A[I4[kqtbfؖ[˫䲮b4kKjiuWˢÖ@#.Yɑ_.i_M-wcAP\0᫫,|xt\\c.s,R\rqYYaՙ?(ee	\n19dX_&-[UZ\rEy`-[X\'~..P%-Lbsn\\3` P\0p\"!1k0\nL;o	KoRžGmc<<<1<c<<<1<c<<<1<c<<<1<c<glj: g\\t|^Y7]ht\0ئI/kU٧Ԣ+3ZunC.b\0TIc\nRTK0ڽ-*H<9sbrn&s&ei޺-RjSݣT	@5%(0%beiu㾱]zc[\\ߝ9=) HYqCԢb&v-޾nl1}f91cjAN,v&l7,l\n&\\=EװuA{ا+tJxuI@QkD{+k._(W<<1z\0\0,yE_Gq.*]?ͥ#qoA}\"%d[}NJɏ|i$Y4(Iemt8;o$kkg\Z3s{kGAGg&ҶYQMM	lwJ5}s d0q#iU,ALsǆ\0܂jݭu\"w5C֬5}s;Ag)-GX10+hޯ7ZӐc +Hw\\1 ȽߡHF1Uc*IjZי&]}Y+rJrݳYiq \'0 2@!M 1gp(_#DbiF-U5DZ5bߖ~o\'mֆY2qg8Qc2˽7>ݻR:vmO_+MSr]b?PoP/1۔u%\\$/$aD?ۿNco\'{*9\07NG$Zb!69fk>XtãxA*vWHb`fbFHŤҧ+ϥYMZ+l!IG[l]Ugf	|u#>4sI7|ñ:oyiq:9C/$=$X7Guf2y>OXv{/\ZP\rc]QTlrI:vco$cόTX3{4F:^Exku,^WY-7}jqVEW\'bR\r=ǲ>9FhtPnW\0_ݒ\0m|ەRQ[~EW($0_/Am]&ޡQ\Z?;OpWeY\\`1rx٬g.RZ١Y\\Y9$^t>sԹڅi#h/\'y!Q)R^@\r̪ cԇ}3ЮuΩ|pjh5;{	%3]jͳrr>X]bn˚k1yycyǞy1yycyǞy1yycyǞy1yyOW355xD\n-(ryΑY5)J<nQ6]\0L_t{1*O*ߚ_4hRmyL٭#F$Mމ&a,rZ# &p\0mT7T`5XxĒa\0&YG$yc7}v>gƯ)K=O~4Q+,? sӯ:|Ҏw%t6T7tZcUoW5]*\0^TQ괴IG+MtrUջ\0ZO\\Q7\0Y5wqkwb̋GVj4V5,*v:_o].hb\roR\"Mfh>;~_9Q|m\n\'>dͅ\\U\n\\7tb˛SXPC6\0,\r7TrK\'1Zob?LmdZ:[tUٗYɦ2O:tKo\ZŮ/x}7ql!.=v:vG*7UCrNnxd\'@/\"O7qF\\hbmI\\GlM؏8.;9&~A5A>_;`\\mDheB$7%jA.]%7D!VZi?G=Zʗ7`\0Pҡ]@#˧]ůAjkd蜁\0TK\"嫄\0qAqDxq8`=\"Mt]pd+__7\0*39\r1	2`+BA΄ޢw] F!u3`dH(|wa/wו򕙅ǀMy-f3uF9e	[d{ny%욞Žm#;\nvnZ)rsu8UHH3̆ǝ㊺Yx\'q˭x$9:\Z[-D6zDue\\k\niY8%405lJlJT!_c btY/ˠ)\0,LjZϨahF}}{Q=&@caɱW\\$p˰AXX==GdCyE8?|V2::oo}+V BqQ=I|Jwh_g>,S7uXtŮ1jÂWKk\\C`keq<SH5TjaER\\)&%)[~RJ\0UX&Ӗdґ4Qo#K\"*cO		9Lhd^r5EIя<+}W-=Kɶ@O\",Y:r(#){co/bM\rof>Ago,Z[3C,}!}%DJ/?_/D<u[S|.wXvأAi}W\ZNƜrǳRuY)dx)}<kFqB\0:a+xѫ.)v˷+v2\nYk#;OhKg{=Bz_iMuc׽G{5q}Kf>amɋo,\"FMx$VPŒaKI*N_F]_!kx\"?!M\r*gLm˪vi35gɤߗ6\n@\0\0\0\0\0\0\0|wIFgGb䳻ĳ3XI$P\'~dۘ5라Z6/moSY?&bk{XO.ה~h5çN\rbV\r)Z4dlrM.hFheyc=S׬Ԏe>،הz|i|x̷ǉWկW>GW߫$_}GEn^[U8xrΘ	̸oL%9xРMU\Z)qT\\Q9@3W[:}39\0u$hA0V\"UK-dTznʠ|c<<<1<c<<<1<c<<<1<c<<<ToJ>M}mk+4}!syNҼx8\r a-Aղ!Zk1a+vn,frF[<F\ZrlA	,1|Xc1{\0bXH<hyPNEH \0Kz	JJиG\'fV0_H6hӃ-d2HO%w;6Rz!`\nv`H\0a\'\'%]k6̨\0aGH_YS#G1a9+c\rg3(zFSOn;%UI3.b{b!K6#9c=`)B5Κ*V#Jjl덢Pw\"?\\lkozvmq&\n}rn @<^Z;bۘ®]N)ݍ +LHi.sBVԤՇ\Zq\'Y8\\wL\\PŝXTU7]WFrV{ALo\r^ZO9m\"FYmÊ?8!ɧmٟoZ_T1.iHhEK\\kB^XvА/kv2Ҹ(c:޸ڗ]\n}ϩfN)̅!tZ\n!!*F|]M&lp:h~|V\0|{He6աyZ1boa]n,RQUYAQ*ĦĨhِi@(b#uFnkj	SBN޹\rF$H`2fIUxazU\'uu\\ˣ2m\'I|D;hyd:+ߺr21lcf[ҷ\0  V1khy\ZbQkf)ÝuVFsPK}ϧxǏva~#[%ى9<0\ZiozicPjkԭǜ頭12LlR\nJm61cE35ws!1jXQ<*:#݋sWV蔑.`7˵7Zҵ[z K5vGu79J7*\\|+b\0e3.F:((Y\'󩶃Czk:Z9RgƟO#{2ޅv+QPܻp\ZiV\0 TZ,WaҌ50T=]at%7$\0\"z.EX4%_Sgv{:h.؇*jmX	r,3OA\ZdV\0\0\0\0|\0\0\0~ϻK3fby,I,I$I9Yd]ACeN\ZEڞidmN÷_81|S!]\"i7K*î=a[o\rVjJp#IU:SY +JFc>)/z{DjZ֡x$k~QYbhIbthdKikc\0ժI,LEyR2I̇2QIﱺ\r;5Hm\"mcu~;9e3IqH]:K&dy#~jW:[7/s=+qPO\"E.δ9ʮg+)ŵǬV,I.B؈c\'9gݾCo-ҊxU؅8[.u	pg\\=Ԩ~nY\rwz:[TK]9Mbc>1kmYvHmnt)sz4}EѪW:%{oc#]6Mf|k3ϘǞy1yycyǞy1yycyǞy1yycyǞy1yycy\0[6RQ:JG،iv_%h``G]ҷ!Њ~sN%YU`*zeɺ2\"\r?A:Ai mg\\0UYΐH~z^NL*Z	XtrV%egV~JzZ[<-l$RϠlOs+Fx;Y\"XW*#\'?;zvEfp|C\ng^_;a53a66b2(ELo\ZU9P7Jne`$U;UԬdX\"Z~J a	$l͍ZP7\\Zyl&><#Mwt{Em0f\Z}bf5OOpykGU-\"@[-d&_-(s\\\Zej\ZYX;;מ%q	pPK!³zsoZY/խ.7h\n\Z \ZK{)Щag/-}eA+@\0:[AS&JZsznpp|0Β?h4hYpF:\'2q0\n`wJ\"XM[`c=ShZ)m:Wt!ŭ<{o/S0tC,r:CGiu.7p#C訫w[yͩ.Mq}ִ[FRiY=;J`&`]]GZ1PS]p6\"F._YGqy /huG|n>к\'\'+sE\nHb%Ѭub&5deau{V{\'ԾִviQk㵸>X]\0a-=m|Aۼr\0ԥ\0;w,vo/\"˔`PzŚt.\0*u\0*ؗ97o~ƼFV5e&֙~̎7?oĴҫ\nT6\\/W*\'ZuJ>VTlK٨R;c[ElBnJmZ֬ԞϖoZDrHȼd[20=?k+7\0{(7I44wi@_hv҅;to0ˆ\0^ҷЫ`QiEcaLڢL*ayedbmm֎ٲ6;Q\'Ԥ}P}$\"lk6vuHV	=HI¼q=Q|Yڲj wdK*;l}<Pl>!J#;$HNe^gy\"]NTCD/]H伯2lLDȺ,u)/-vf|:RǗs;9\\.\\b(:WǫN6uSnوȷ[z~KO!?/-D[/\"H-FGyXb5fY<rIz-0ֶ-KE:!C-:уfK\"veADNsq/=#T9qU\'\nHI[ΦeQ[KI*viKFLhdǘ\"$b\"\0TsA6,{mǾs+Uz+me׋vV7+^~72pU*Xt>{N=[YXo\Zj-_/BuW^օKuH*/Tc|zFlƓt:W*$t{vy0t[v!2F#%zHhXd1\nI#DK%WAd{2\Zڻ\'H8;/\Zױ\nK,Clǅ$6m\ZGl4IUs-/I`qRy6̎z\r1bVOt,fhp~i[8_3ne?ЊSq*1P[-7_,[B\0\0ˏW\ZhݭɽTUW,玑H9jk<Usf@\Z+	oV@P)uw2y٥i,B<W8A)\\:SnTbmWb\"[\0gPqӞey[RoyuwX}\0#EWGvgY{i^IQ:ڂ :.P*d\ZV|H2˾ep]Ii16qҫ#k_\01O9#f`돻0If mSɶ2\0X%}w_nc%mEVXW	C6Y]ĸXA>0LVA3OXA A #;cKX%pd*N`24\rBˁ]p`:,qkc56e\0跹HNOJ}-X!د~ҘΒyiಇ]h\\f}*n/jPWM}K+Lop+QIl`e-\Zٯ1/(i;CC}6[\\9:k.b;K5Rh>qmK1\'>2 klHM~o1%S\";:&i$pm3൘ÓOlIC,[kiI<1<\0_N\ZŶw&mQGMI}a0B17eٯXBw(Ӟ}ν`@\"2EV3sdn6Rhp¿d^r\0em4Rc:c1yycyǞy1yycyǞy1yycy;\n\n`ax-\ZdY6.˘&sRڲB̗xdZ\0vQ[qʐEt[˶2am%sL3I:˙+Bpa(\"MPָ/D.AFm1ӛ:N\rzF79GZ3mMR\r`z\02Vae:ifꬖr3ЋzP+J;FNc­-cH߂Hv\ri^y᳡ W=Tp66?+6ٿ #E9\ZeVETpZX!iH\"XyXK,]#=5}lkgsJ4($P1,@m\'{7\'3y<y$yYcAEIbR4.A3U.UQ/`fV+ŵ-V>թnV6)^RjZ`Olablv\\#5}loFuZZ6DQ*r=Q@!e:^,#]:y{uΫжO^Lä蚏:7)\"(YW<_!1Lu3u,jk!4 1 *XQig HIe}c=v}\\\\/=Sw^?ʍRzgf\n/4.As\"NT9O63U+ԥ+>\nߣhǧcYHlu\Zxg;_\"HE*b\"MW6!eWG&=1L>*>yS]ш򋝩{(b懘V)v6!1	c)C,Qb`EcX?/?˕v襨^R;5[ֳ4ܬǖi\"u[\0hf9aQ\0AAyGЭʑT9K5j͝t\n1}$e\\)n;o6L6)u7g,~I5:չV㧳|h#-[Xߩvo.]`!Xb0^7pŪ	6JC}L걛rsaw,(g<i}wV@s.=}އ>$qU?9p<H&qz>ݦqp̜e\"RNAxeׅ\nh5Y0%{4x:Wܐ>IVR<Ѽ~**UڵbtIޝ݉<[g3QwXI{}ڑy7>ys|MհO+HҴm[War.Fn4=4=58M4\\kkkk11u1c1cJ\\/?\0/pTkAk_lmW/ccؕC)r5rqծW:*L7}{3\0:tPv9GGV]\Z>cy_at訦\n5ԫ&rfH!_ ꊋ{ eB0K|aWR귲Ytg-<rmHaTyg1XOGɓ\nUU-tS}1cdSA\'mǟ8\0L{-foL1Z#*$0fySY72b;R\0؅\0˩}KʏGYVXzH~W޼+[^I+]!0M6dm!\n{sKp:y殅xkW	6fX*X5r[3f٢%r*\0֘˶A,aplIa5SlrtE\'!e/Ā8Z\Zh\"CA%vQKDseU=5@K}.vkh\r:4ަQ0n?X˚Bs\0_E^~^O\0#}wsKK2ڗNs,|ЩZUNm9R6JGl5m\'Uxۭ#frbPNb#$}ẘޓKX`.-	Ԕ?/i`w82.,mo TkZUuuK\"HY-%CKf0=]dt]iZ9i,u9GfT\0+N,.97KiytfWU?vߗ΢\0uA4k(Hم\0~9Le^O3Sm̖_vbH6:M&̍_uGK<pJN\Z]ZC#,Q@\r,,ȿP\rPbD\ra*7cԱiH\r[7V(1Dc&]3sFMA}+u\0ŘhQ7a\ZMPÖfB`EFx$n[XbopG>)e4aC$1HdV+\0ǃ΍nZ,X+Yq]b?YIتfM\"ȾAĳFkҪ 9>WʁҤT5WIH#(Bc}+ఠt#VC]f$EU^@%HQ,KQ35yVhZ}dI<h\\dn,q&lg$H\rz\0Z`F)9ڄY0H%Y%k5Pz%{Q\"3utZ%!1@lm!i=^C%O^0\"M6ƻ}k뾛kvlcmvl}6msu3gqgBɞ^xe\rȽQdM?L]WWY6/ߚRG5mA+PB _!c2j@v^A6t~ΚKt]K\'e<CnBl`fugj,BR\\Fri+N=.|ED<@\\AAb\\2sʈнRڳ[Q\nM4iqELfλ\0N]x^J<vjxUaaA,*pJ:WlMPt#&n{Ĭ><V)jVS_f\'T#]\0ƶ4T\"#F<n,C)1c=x->:q6AaLONf%j@i*d,v]JJΛzenO.]1]53]l*t56x3=ic9y~J3\'tEdUӱjr+IaC<~#~xm\ZDIa~y~B8)r@ӵHAF0+O8=69NƯZ7DnbUо{4tX#X*l\'.8g@lgUW[U-~wC\0&y\0kG8\\IZwRk^){s?uJĊ:mdQɈ9}\nfataѶ&mǺ*9Br>8ICr<UBV)Kw}Ъ߾\\\ZC#޹vȥ<o^Y=Yp-nl7\njt[T7jRfIJIr2}ݼf蠟>\'*ѹdPwejV̡9\n9HOuϻ̟NV\Zv $P\0s۟=h}>=Κ\nKYu9Xu\'UCM\\F\0l0=!іn<t ᄀBLjwݯC:2E!!k5f\'([\Z+\"U<1)f&Bti4-+ϸAO\'s6>2;6ť/5bop)pǐU\"_ߖoaq95\\oKvHmwM6]k8ϿOZA AGA yǞy1yycyǞy1yyc=gl-~2.н=N~T:j\r7`yi\ZRZXG>F\n)Ņw%ovowohkrk,&dˤ8ftaJ9QsZl1dڽ4\Z|@_C;sJtXskKV[h,a}`5܂]Y\Z\n1c-vVɩcX o_<\"Q(\\3y#TüD.\nLWdmm8҈bHtp~}\nDV5UXtռd*IlRymZs}%Xt(<*-5bx>E|h}%7U_\'=7Wϴk3H[>f.~	qPdv։흭w_i8{o;\0\'-ThYU#Z3$#cv]TB-䮂$˜sgv<z#]Bt6jY*q\09]Qm#VUTcqG!g)1&M5lg%ܓXkLhiE32L\0Y&Et#S3\"+ڠܦ״\nlk	DZ-`X1N	gjG:YX7-p(\0¬a~Uޭ,UIQ*iTڽvQN5)\\9\'i!p|軳UŮtE=~>x\'Tcm\0Mw6ɽrgL3/p5E*ھLr4:M|ɬ_\"B\\8ek\0[N[~٪{\\lz2I>ni\0$]%_ۚvmû_6?	?@\Z\Z4b\\+]{LڥK]{ZՍmRC]yÕ#fSʳz)۞A-kPbvx7,0̼KNl{MKIm)u%V\0?`!;O+=j	cEjt-]hK<#?Jrڔ՗a__3~vUnt&HX c\\&3H`k&SUwCmwaůz\Zq O1HZ19SR­jD )-\r\Z{\"6\Zk,	c}dB0]}u13|ļAa*uHs*$9qc/+#ՙf非ژ봶<.Bk_հ}?HWֵ*ʞV_UlQYB6\'#l#eˈs4Aم,gCS{\0ɞe!	mgXHX_+s{Z18ƿn@qr\'u#c&[&CL[~r\rFWU&?ֈ}3RW%\"3޿ʻ:r-n?ˊ37.j,/z>hVmҝMN;|\r>h%QP%kU:1)LXpЀ%ݠiM<f֌bVi$j­ze̕,٤bmAyaEߞz\nӞ\ZHŞ6r\\3F]am plMPaˀ$b%zhU\"|+Uג2 6|7٥7+PK]ϊikJBʪH@he񲇞y2<1<c<Qa+\'\"bX\'0kEqZ3H~2\\2Üc1oqWIvAx\"t6WP[GMq\r\rq._5Ť_5ר.Fǝ10g]\0rI;$i_?f\0<WؼۋOisI\0]Fcb%qnq|m=ЮK6%3Ja	[c4#7\re\nuiMcE&1$y|}fL{xkoXsdSAg9ΛgL_~?s*̬IVRYI >Aȡ~7iSYL׉~dvC^Lyaߋ0VxGӰD{_DVjXHV9\'Pս1t3äfL˷k\\zg^j%9\nN;c}	c]v8OdvsU[5$:8~uQ6?MgިHuƿXgzBZ`s/د=/BtRU.c,c!w)_\Zb;yruuudLɌp$e­+$L1[`j9%*fb?}z,iI\0PX%/oVf?XOK^xAgmԻ2wqE%Ghֆn$ο]pl:gm]V\Z&~닪wT;gL!VBa&붿q%1x}UAJZ5P\Z#v.d,QLԻfj+[{[^wnY|ٱgJ*Ea![*~sٲHn:2+VtQ3{hdk]f8#2$dYf756UZxB2z`ݭ&dH=]|@%\'8vLAeHƏ	abH8ž>mrG?]mss5$=vvfァl|2j|\0٣[.W]k+$ŉGhr[3M]ct\0`{Y!OLL\">9Q7\Z2IQ9Ms:َb:ȺZ}\nj>ym<3w_ba:ȭ=}g,(2U`c%(Bȋd<}ZgydJWN\"x\Z!Z	m1GRf9&fc2Ikij_`WPN\0\0zk_3m?l2)=Q8尧%@v4 qKy-_HsIh8DüM5+ouVRz<k%߯\\ra{j&_\rU7V?p_7k3Kf`GaAg_js}6a6_/cf9DiɟXmrnVN~gxws*mp\Z)l\0\'z?\Z%|b?sqtvh2S1Uʤmn*yIrqh+CMNHqv\rW`M\Zr}R/%~	 )SNF}^^c:m}!FbG$r\nl\'@m-c	4wEH\r2\Z}\Z?w}Npt :ǣ6=±Z:0 뼺IU<\r:-m`fcM3氤I4.ABvT\"yA̱k֔YWW\ZwpV*{MRy\n½qjnD%n\ngSƞ&5kgL״ñsV9H#hga]9mU\r.]-YI3U(=O#*Z8m(dq%mE-k1/U<sٿӥI,Iٺx9Ҥ\"ݔ2t6jѵ\nzzB)<1\"sՌTGC6Jϙ	n8\0C(!BAؕ4ZѻXB,qGc-KvA}[U:9@M<[~6`jU=W=םV\Z?\rӫ2+}7m(gx)6F|7^p\Z>t+emҸ\0xw3\\Zւ,۲ώ<\\\'U%11)XrV[ִЧw~Mۃָ/Nw6i4jK+S-~Cr,9	+yh\r+Mutkuʫ+N%JJz*8+,QAp鮸c)s-^ϧQO>߸ŏox\rg\\$l׫\'\\:X%Оy1yycyǞy2ѹS:]Q-Ҟ8b6\r4e\09q\nVAЎsaClY)Qf/\0^1K\0?#\'\0bCF\'\0_\'\0,4\0ei\0O<Wԋ6-[{hi홖JY5\0KObFYrgKb)BE@3?ɻ<:d%}KO4\rk{k,N!k{|osN-wqkfG\'uXU9Ry`kkiTitC+t@ZXVVk~N*%\nh6rس2-\\mhK4W;O6KfNkݹY+}Wn,־P[@[`p,&\Zms97 ԆWJ9&`d\\zU=ꑐ(\ZsHXY$Dga|9	ԯ<@iQ@GGXpn˪B30R3dӏ^Hс da*^c#*@wR2;)W`zuw*p=Hm$VajV+tcޭYVD\"[J׆DDu\nʧ%\nRi4䆱nf?kA~XV͞LƹxچY:v10j6PP4jz[@Z.(3&#`\Z,>tETrȬ 䓒D[QKW0E8b]w~+Q/g\n,v-sf$,\"&>^	݊儆[E~Pv\Z5M-[П,1i.a`G,yZmeXkuҘy4YTt{<	nEI`Mp9BnqdVZNQp<kR[úo:0Sºqr/z!(@+ԃ$@=\nSPFywѤ,[dXi@/s3Ku2lee4OmPPgbJk\nR}uWM \"\ZUѪ·qZ#jH2ED3L\0۬5i3;!L%]*n+VV\0VRAA#&k4疵ճE$,nJ$rG\"::WVV{lyǞy1yycy$ʇ)5l$gymU{$ę%TĘ&&띵\\}j\ru/ )>.ڧXvm\n8r.[ͦ6m61<_KW\0k-JB2t\Zv#/\07?X34_v:ҭnlƶS#o$5 \0كq7]M1ذ|MgX6kop6q2\r0>sMHg9qo9qϻ;%iH\'.6\0\\IH@8<뾛k=yg ^Ιmbe1>iW-_X^0f,d\0W,s:]~03i1.oyej$ιz?ssr\rzm8럷qN_P3ښ>g;ǮiBjCK\03|7ٚbƻ}Wl1+yݍΙ~靾M|<Fkt[?\rK٫\'sja56cl\"uٛ+VJiW#J,/;B5\\ϸ:/4UhAOCC\0KE%[ha]UZb0&ggu$3htX(ukX\0\0PP~Z>57*(n\0dKPWYAץTZ%|{>2_1|rk[ӽo.(Ho\0@8w+F\Z̚M4^~CLcY¾QT7SyL_e]t\Z7bٰ-c+\"\0_Z]/3\".d-z2sdiegf	N)1^\nϠת [HϹ짆%xիݙ;/\0%ylۿlۿ\0n\0WGc3\0n\0W\0^y\0\0^/\0%{Dy3;\0/\0%ylۿlۿ\0n\0WGc3\0n\0W\0^y\0\0^tnkz=>.)cF(	i2b΅+tGfrNx,\06̐]9OWuvjqF/J\\*Uo}XiC;\nuIG3!	SY6gR-{)eLѪzMoZ~Bp3|k:hɊfϘajT-ҝ6\'ݫr-r\"?s2#4X܇Y.\r0&vՅg\\\r\0ڵ `\015_1Gy1y]97:§y2\"Q8Xϫ,a1\\~39Ԝf=>f*70- 6KmSADgCxk=V0f],,!X&2>YzՁӤѻ<HbFFF╞\"8:o6-!hYץҕ%CnܮF声MFAwPֆC$۞ϰs&&V|##-daŜUn5[ʈSIQzS>Ly7&A`8LI=z_Bv-Ilۓ*Z뒛\Z5f[9E1<f̍b#icMqK2ZeD2N{54TZK-NޓzZ#$ZmZuBn6綞Y`9CK7y@QmJAҙkd2@V>h=tJ*B?WUƿ04ҙsCFpLs/RׇֺJ9c1\\9[lLF\ZR|k&rP<(h:Ff&8!<lv0G>xƺkTSIF4vVl\ZSأ(Šq^.}ӣ+<c<<<1<c<<<1YdA\'L@g\r	bI#I!L\0mǡ_ٍ@ldb0m}b;qU]R%D͏f\nL]sfMsff?ɺtV(m6WglJ &5hdX֬UAb\'PSm]A.uN%ZT7JpV®=W`G\' M[͜y','pedro',1,'lixo',NULL,NULL,NULL),(193,'%% Example 16, Chou88, pg 109\r\n%% Gauss-point\r\narea 5 5 200 160\r\n \r\npoint A_0 70 10\r\npoint A_1 20 10\r\npoint A_2 25 44\r\npoint A_3 80 35\r\npoint A_4 56 60\r\n\r\n% point X, on A_3A_4 and A_1A_0\r\nline a3a4 A_3 A_4\r\nline a1a0 A_1 A_0\r\n\r\nintersec X a3a4 a1a0\r\n\r\n% point Y, on A_2A_3 and A_0A_4\r\nline a2a3 A_2 A_3\r\nline a0a4 A_0 A_4\r\n\r\nintersec Y a2a3 a0a4\r\n\r\n% point Z, on A_4A_3 and A_1A_2\r\nline a4a3 A_4 A_3\r\nline a1a2 A_1 A_2\r\n\r\nintersec Z a4a3 a1a2\r\n\r\n% point M_1 is the midpoint of A_1A_3\r\nmidpoint M_1 A_1 A_3\r\n\r\n% point M_2 is the midpoint of XA_2\r\nmidpoint M_2 X A_2\r\n\r\n% point M_3 is the midpoint of A_0 A_2\r\nmidpoint M_3 A_0 A_2 \r\n\r\n% point M_4 is the midpoint of YA_1\r\nmidpoint M_4 Y A_1\r\n\r\n% point M_5 is the midpoint of A_1A_4\r\nmidpoint M_5 A_1 A_4\r\n\r\n% point M_5 is the midpoint of A_0Z\r\nmidpoint M_6 A_0 Z\r\n\r\n% point I is on line M_3M_4 and on line M_1M_2\r\nline m3m4 M_3 M_4\r\nline m1m2 M_1 M_2\r\n\r\nintersec I m3m4 m1m2\r\n\r\ncmark_b A_0\r\ncmark_b A_1\r\ncmark_t A_2\r\ncmark_t A_3\r\ncmark_t A_4\r\ncmark_t X\r\ncmark_b Y\r\ncmark_b Z\r\n\r\ncmark_lt M_1\r\ncmark_t M_2\r\ncmark_b M_3\r\ncmark_b M_4\r\ncmark_b M_5\r\ncmark_b M_6\r\n\r\ncmark_b I\r\n\r\ndrawsegment A_0 A_1\r\ndrawsegment A_0 A_2\r\n%drawsegment A_0 A_3\r\ndrawsegment A_0 A_4\r\ndrawsegment A_1 A_4\r\ndrawsegment A_1 A_3\r\ndrawsegment A_2 A_3\r\n\r\ncolor 150 150 150\r\ndrawsegment A_2 X\r\ndrawsegment A_0 Z\r\ndrawsegment A_1 Y\r\n\r\ncolor 255 0 0\r\ndrawdashline I M_6\r\ndrawdashline M_3 M_4\r\ndrawdashline M_1 M_2',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0C\0\0\"\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0.\0\0\0\0\0	!\"V#3$4\0\Z\0\0\0\0\0\0\0\0\0\0\0\0\0\03\0\0	\0\0\0!\"1#AQ$%23UWa\0\0\0?\0<8<=(MK5:-!rQdW/2lG Y)*}^g8wkgqw]Wsɦ|VR~h0k~{r,sM5z{Ovbt9$wgFUmމ3=\"踸0,V6[T\"\\l(,D%*m\r/RZ\r;CgP~Bz\"0v/=.ܒ2+uV6Ѭ\Z]qǞyyqǞyyqǞyyqǞyyqǩ\'`٩V/嫙­ĚZziϗGRl\n幞\r:\"c~$<r=sVtX@Y%_m1X\0yc>_Vѵs/1Xx]mCPޢ|nU>gDެB7\0/!`\0=u 7Z\ZA5alǩlz؉zIQ4041<Q@<GCC1k\"(ƺGzkǦ릺]qc={˒I$I$OI$I?d<yǞyyqǞyyqǞy[FO&g\0[eD-i?n fn.b#q.~o {\r8NUmHʗs9#Lk8\\Rи&E-]}}׺G\0&6? s~}U[ ?TE0Kr<<8<<8<<8<R{\\W\0\'+^ܥvKc-&q֝;%օCeA5[e+K]PW?B:\rb<9;-Y\0/iN\"Sx#z|mܽoC.^x*T\Zkrի%ׅ!C<q1ZiMt̎}U_՗ί.GߥGS{;.Mv^6_Hn}vo7&88=\"-5(]#=5ƺG\Z馚\Z뮸ƺc1{瞻\\$I$$I?Oy<8<<8<<8<tVdqO):E(,\"N$B3qi!*\n1oђqclm8RcЀfNb{\Zڪ&U΁]27/NQ2VB<tYVl\Z\0:4@\0NL%`m2KR<8<<8<<87Њ\rkU&:sH\nɈ	^ً*tTbm*f\nwz|yI?jkH8ynŻAHYxNfBRe)]-2K\"ÌhE\0Gxsk1?LNfFeoi;ePCEeGػϥMz:\nad\Zto]];Z].|~I)X%L\0ԫ^<bph0a4:<qQ뮚GcUT**T\0\0>;JRԥGjJ֎JQسҎĳ,ĳ1$I<yqyyqyyqyyqyyr?i\rj@L	`.q2\ZXR\r\0Hئh8mW˟=Ǩ;%Xe0>ZA	lAmo$Ƹ\0M䝰A(7}uZҏV#ޭ{	zTW?/B\r-6QԸ\0dQaЙ\"vφ}1{9dyqǞyyqǞyz?7ڕn.C[`#gțuKX.64ܚ\"۵(`XN,i,&)h.fע[b]Q?Dm˛)\ne9>ȹkZe\nr@ku#FY\ZY3i2~\ZJbwL-iS%:3%3dA#E)Хz%2?E\Z/Y#[>%ڠI_,kዓyڌ(Ǵ!8nAEo{qSq;i\ZA6q*ym}筀\0\0\0\0\0@\0?sYfbK3I$|x=<<<8<<8<<8<<8<=ӿJ%3,P0hpHC#\\(lM%vK=&<~x;<㞡Ǝvt&\\Eb=,hw$k%\nƗY16Flcɜbgw,iR_OXu$GIw&qK2\\v5[[#8iugm1.Mc;툇IgLƐKzo럧q(<9e3;*QרCȮ\nt.|Ӟ=\nz?jd7AVbG_ZΆZѳ2 ^s)A	!O^^~nNTĩLShL}ߺ{m\0&zQ7SrϨMxͺgW<at8#aTh6S-S\'s[gֈovUsԟ8ե뀜\Z7ُ-w:t!pBhIzJ2X-Fتj{b2菏Cj&%{zXk7pF[ÔҴ^(YBzUv}6YSSFfC.JɉZQd{&\\n]fQ7bQhig<,Sg}2+	Ҭ>I)\rY5X1-tq˗ƛ5O۬-3ɧ!|ߐoG\\_c,ś/*Y畕\nS\00J0fٳ3%ٔ[wۖkM9sba$*YH,5TB\"\"\0@\0\0\09իVZ6}5޺Z_N7V4^VjVfz;3${>AǞyyqǞyyqǞyyqǞyyqǞyyqǞy]eJhspbx\'Iκ!1hBB2\r 2℡xc^ʈ	oe-n\"\r%l8aƚG&,9ABq\0rIILܕa,Fl\ZR$6\\R:\0+EVJ8aisMr?ze9qNhwNǔ7 sj]le\0mj8Tt[\ZIKUz5ol=ٹ8PbSxyo+빇AՇtYX{c)u´iO9-R]\09	i\\5¹C\"`hSK}p*?+h/5?$Ʋvu5kOK죯ad̬,$HNR~{P*5HnqaX0lW3#:ZܰDX}hHzBXo^NjvGA}yչP\n1X^I2 +7a8 :}v\nnD\Z~)ϓk9,NF讆N\n:ECi`m#iZFh9PMWaU<NK4&̮\ndo_B\'~se~zfzl:*љwtOJ]Fߥ^+NTj%Զq1@U@SkדZ\Z?eqHB\0.c>ƺkzw>yj@\n~?|j/g4Xyf?\0\0?T\0\0<r.<8<<8<<8u#G#Y+,)6XBi1K1i7\\uZo,=|4nxOuBKBkZ49wXf$Uн\Z^s`x)z!$#I)\Z,}VͲY5kf16!iAOOaY_r\'Ꭓ2\0\"ԏQX\nߍX\Z93Qݑ:dU?\0u_ϛk\0\0\0\0{aC<2Ӽs=iEd9w@jcuMo9e&9zP)\\ΒnfuQ/]g8<<8c\n\Z\"kV8^ZǙD:	#Meme|&ߧ4[i,[Y#]lv~ȝݪԖ[vOj4Cĳ\"vLI;YWjW&nZےn^&S?_7࿫C\"26Bi-aR.w;{BQgwg7%2dVKWOՖ7zd6#P2Z^Fj䯢=Ρ(\\KbݧD	?9GC83HH\rdkYUtK2>%YFOeɹƙ;{!8@R\ZybjëFz\n[B4fZLKV=rȻl~:#2)MY\'o0ZԕrQ3Jqx5؋S>cns\"qBբ/H5X\ZB;\ZϠad)+6-Tūl;[m3fL#hʮV4m\0{-j=md}V5|Y}b߽}8}#8bDg4NEQxUQ\0\0OVt[^SFV/J91\0\0<P@P\0>yyqǞyyqǞyyeOTVk31ҎcG	F|,\r$\Z -8,QIȆ=낚tΆTK07m<BLU }:GУ7̫Dg|N0JH8R}\'5,|&xo6:];f\\oX3ݓZX&4YCS?_f\"\Z ^h>F39caVI\0K[iֳxq1|LUoU4-R9v<#\r4ä$bc)iK_mnfKp\ny(maQEI*#Fs)gc:݌I{=*U\ZRl=f_G,gd%zieVj:6<5;;l\\xʦ囩g`̑+ӑ~G^-W76`cȼSd2^D9,-L=b}+hU31XӴMey祔eD/UP=hĽiꪦfv\0{1wct}iaf\\q륳` pdi<xj7y.<8lM2>>cI4[Osg\\=IhZkg8_1zYT|l:uY{\r\0K窟Uvn^2]W\\BMEc.Nl\0O}L\Zh+\n^sDC$ʕn;-%zn]I7.\0%_:~#ק,\"=e\\]kePޮk̺Zf)k`Rx8|eSJ}g!9oz<K5v&Rх1ptީT$jZϪ!5ϪW3e̲mSs|^ldL6ſPMɂ93قV\0eײ\\|ՠ]7\'I!H;wHt񝦃˶Ϲ~\'|\"<R#]I)=yRvF/3~YwY\\sNѧ\0imr%]ayW)l.m\"C,+,D!˦c0z|{\'LefX7jdFիl\00\0i\\,߃u׬˪Ǫ:})r<%xF\Z<\0\ZXz=0MJF䵫ܿ*YL\\2_._~){UԖ˜nF\0vwb$	yC\0jY\0OUt5.{Lhgvu7ڧFWø\0m֯]1h9JhI@os!v=WBYîOEнVTf*Ph~\0,_b\"Ԙfhʵ$i9iԭ)glB=7H?W~,2,92vMC_]J耶YZOOi-Θ:L&ǬUro9fbϽ&z[Ĳԟ!uad\rƪ[GDz\"~\rJO>W[r\0X/-M!DV:#77mڿq\n%KÏkF%^*vGktGwYRNK#ҰO|k+V9ejb&4Y!QB,|3fbYbI\'MZmMekhڥ%(OرpϬ	1Yi5UOKNHƺ`RXV\0\0O\0\\c/= 	l웩2V3!VZtC`mʺ[8Ƀ9D_3v:[JLsͮ>:y,^+[z5ap<zХ>1u\'qyyq竻NФXXm+j&\rxɞƁ\'N1+U\nzrGve[؛՝VъD1vYֺHKl+b\\wVmSh5쎉IM9!$oODvP6Yoiɯ?	gD};h2_K:K&g﮷`,q.@Zrmzݱ\\+ՠnٿf	$Ad`\0,\'	&(_潝\\3\'\'kvf&`5\"RpC,o0,_[0 sg<itf[3FPɠ[.6\Z]ᅕS8BqG؉hE-(<2U!g,yV=k06Ѓdx\"i?v~KLR׷qVO׏s\n55\"$Zd 1mg0#\'\ndُn:2E1a*8u秜$4T_f%1%$O5;wuv;ug)tU̢(J|r޳ETPǞy9S<8<<8<S(	[VɕXnҖ##m0X8YeaI!-ms]~q_2[yh6-e/w+uNure94ɻe*Bp|D/%^y(4Ae9k\ZXd;#Us%RX×ƦHq3{-&N[2,[=/ht B4EZM:_0XJߡ_78GϺL{	L.t)_l8K^kTI5rNޓJβ#~mj\nM\\;j%`g^IiC\rgNoRpPlJz~X@\'1-0V\0p$BXeA&?&7뤑ocqq)>`\Z\0mY䷌ 7TؾAIuָE\0iڹr]R*7Kv)>1b\"NƖn&J\\0w}l؛W9a4S[0yl=&N*4Nt\re!O{=Jؾ|pJ_B|nrB8em/7V4Ze_?\\~\'g\Z:@	ѝ]=eՖ_.٢T˿~93tW\0{ڠL#69v+065*El`T~75Rr(}imj-dM/i1\"̻־vɴ1,uǾy澐[+	68;%0nOH|C8J^l6W/g2XJhxQ;v?]ݙݏwfv%׳V붝F%XYgfp͚R͚(ESD\\ͬdW-|ׇBv\\?a FPMi2O$X01QMzV[$=㎬# Usw]Jfdќ\0?9Kp܅,9/Ye1ON@pHzc[)K8\0_r!qs((j@6lBE04,̃u\0j}cbktiן*-I#iJu,[o.4K6\\gm5n،(!ұuκKZ<HŌӞON^q؇\\ǻ4l;1d%\Zt.}[!Z)a,@WLNaU#2n(͝v	4wPl6%gSBB=`nEKץqJ9OZ(A0ͮ!>WOYtᴎTq9[~7=ljvV+9S\n5\\n_G%_nIKwWϺmski5$J/۹+u1B{7tTbj^3b8`^6˯!\Z|Yj{56E#tL8pRVm9>=cQ]7t&*p䞽7Nmo#t՚9b!McXL^֏ru6Rd+%\06V <R<\n|tl\'{m9u)tӦvί\\ڴ>$߳ZesnSWl[˙v\'ea9ug72֍:Ry`msFăFƏ臮T_-woҿ`qe#&]&HKCA*G^Z~W6ܾuZmAr0`i@#T0C\ZGL1M_ˣ}{isNѶBѺ].\r%MP:`d[B6.îc\\;13+h<\r9tg\'l\nׅ&&3|>qFYqgzzv9L1[=%Zf\nI\"	ǐ5	pì6ĞC˒S7a1,ڟ4,\'}ujvjBn_dw-͔6\\HdxDBPɵGvJB`Qr7xAZ+v.3\"]\Zq\"kx\Z\Zd5lЩ^|-P3:jrkT\Zw;s&Dg=3^Y6A]wR øYDIQB\"UP<UP@\0\0C]\Z4kkjW:*F/JfkG%ĳI<s<\\<Icת	Nڝ YR0rYȈA9Id $\Z\rdheEgvTDRBYU@$@\0OK[M4kF&Wc)zVʓ+;PIߞH흥1v4IO(DQ#h\'@eD7m;PP 鈴\Z˞d]9K5Q4Rq\nNgqnC.g9LjanqM:	ҿ\0\']#ϴUDPyMig(\0!Z|\'?8?u#~~t`WQCbY\\rUT4Õg~j4Ɛm*kb`l k\'\"hǫmȢv\rN4H@B#\'d\r`U\Z&hzyJ%,~λɨզ̬=ŉ:\nua`-.>ԨR(0_\03VG(bf#zO,DZ9)\n>K\0v\n=7aQ)*#LFOfu5c=Y(a>-j򘁲!+ؘ\riAg#s$|	ş_=ր\0$\0O>\0O|\0?wvTY+32bHD4zPꦔw wf{cǞyyqǼ\0.!n=Ii7熲:]Q U=M1$}L+}&Y\Zt\ZFkJˑrlVmj\n\rԩe`Ć|@CrUݶ`N*h0G;|ifߦ]jxS<ռ[NVVu:?Eo$Uur]|ej֍AZe&qE?dJqKF,rjųhut/4kKO3t.&6\nBzް\rzc=㏥h}-؈a7:VǏkm-t-/⧜I>Lߟy>_A(RMoL2j-CRIIM{ocRoC\0܍m7NkJ5Ϲzou<4ɒO/{Bco%Lч#J}yԙB(Q\0ĳ\0,Ėf }I$j/gZZQ%4gq2RN2U¢9T+mǝ%8<mA\0a]A\0Yuxh)<ro.c+m;Xʡ~U4!r2m$gp\ZI6*Od\rƟb&\n3AQCX$r2CG 2IG\\-,є3ꭀLd\"XqcgxT#yYn!L$y\\fki&\n󓳓ELz6zTxT_Szy}X&6Im[$u&2\r5h#DQlHv<˅e&{\r4=3}T` c\\Ǆ	$\0$\0>$\0y#YQUTY@$\0yg;\0QnҥQVR{?488&EsURcqЇ@ѮMVik0GDǙcKNAɢeE\n=Y8c]F;AdיufЭ?;<0o#A\nƻ*dT42jr[EgKC2X$iz)\0h,t;*)m3W6WRԏCI)\'Ko*3wi׫Wb4wc^V]]Bz:knq&眳-K3s\raW뇩G,W;<rLz.wnG5~uĵ9\Z`=>-|oW_Ͱt0\Z+]\".|啜3T!OF!Ǌ((c(a-qQEHMu8]t\\k1c0oy]GڿF>^-Jk~**Gtfo}%^V!Hų<]굇TA\'do=4Yo[RmJJbO\0Әߩd=\rHe(a͒?+L\'vӗ5SH-sQI3z릹i6Y3qgyeyd8ɾsߺ\n\n]84 v%pP#BQgHʙhIv4Y*A[P|C}9?[(Jϡci\"ڷjU;(jVDeOL>a\\I$I$$I?O5wo8^}تxi\'1Hy]U9+IvQRУud]ɿstُ#\\N?yN9{K<j&z1sƿ>q\0FHZ=z݆+E@HSaЫJ\0	`}5al-K2~\0ME[F Vrzf#ت$\0O9wYnd(2/,I\ZU9s-G 7|P8ukw\Z~9u*Q韜V3.`A:?Dðt2-olK83AJ-\"FٿZ٭ͽ6\0Jk$=~nXg̽UU9\".H`xc:G_l4s	X\"dl͝(2f{3N\'cq+PG4wyi	!XƆrهz/Zvo|i,+c+2vYɟ׷JMO41@y׮^ò^xզ5RP{;= 	sZ{![62[٠#A0K\"&/U)ayތ5i[>Ь##i\'I5.vzm+돫%``Y),`̺@s\'WD֩?\Zrm.07i#}y}̻z]3{\'\\(OЌCcF$So{|4dyeӗ[-Y\rQ	3UԵoNu\'kP@(uqb6\r4e[ X.r3\Zִ_U	̑MC!5\0hsm;rߍO6;۬ZA.;t~`5,鮺\0=ή(gQhJY\'Q\0JLTV}W3M_scӓ~6c,ُe9e3?v+]Rۏ<9<<8<<8{jY@͕=y\0%Yd`i?XpH),۞ \"6{Mhưl\Zje$0c?&)|\"IyqJ85zTIeaO]RհYçv-\n7\02LqZ%:_Ufmpʮ_ӗaKY`~j\ZV]o&fP~<zOQM9vai}9^T&Hʮv\n_ƴ2WWjFϲFf_\'<D\n[!tҬ$G\ZX\r%/+cVa(!XƑzc]#=5M4\\kƺ1ӏzޝlۮ.6Kd<@({$)R>B\nլҒEJ@@\0(F\0.Ř\'\r~-ӆ|Vz:ǎ)HG\\sJpbٙ1y}9%rK_F\"ԘiEJD-R߶ZL]$HsRoN4jQsE,@Y\n}H\0|6m;4G&<իMR9f/+R4VfbORa[[uϜ,]#I8oS큯.,zCݎg&k\0tzNJtqm`ܫkl]j&t\0ݘP>\rT4Fl;Զԉ}IҾ\'?kː׶=Go6E*=[\Z=l֋mb\0Ɂz?F磿ҙ^uu+\0}\'R^\\UZ<o7`\\%a\'>\Zֲ<\nW	]\n*ԋEG.9i<:e!~nEoamҹ~£bGZ,X(:V)b5Ekv_j}_@MR&R-W6U.r0c\'0̄ͅh^wuA]\nIZhEhSU`BQV4hqe9l˾9otM<QM]:\Zcf^+mmɖ`M.R&n<(*ʌa6	~9(Tο(\0\Z}<>Hi\nZ6_dE,z|>MI2k(2ӧʑ\'V׿e:?gP}#\rH2hيMmO^4,аe,T2%?-+tC#M_:mcrFEjKS	3<mO*V54և\Z5B p}RtKݜ.:}>L$ޏA\Z4LR	?D0~غn|b:WvZZXiOmjHuH+	ehmMFsWrmk%sj,+a􄕍Rk=}p\rm7=ҎeZwa΁WR!r׫W;D\\ϔpF/@~E\Z7:_Pػ%[)aV6V-s*uGZF*ե>`ocW*NZlt,\0V_]-Y\n(O?Gިl+=?w:[U֪V53檑\'KL\0wY__*\Z\\؟|nT\rBruYQp,+JKO[n=i o/r[tϴGw9.zd*ZOVh}+g\ZaQʖ]ZN6nDDWss.|F~ɦqVN_i	Tr&6mK^]\ZBjN dtjr׺UL#/_X\Z)ecr+4#́;OXxچK&o4iIb0<xRHz 	\")7ƞAF>BLr̕oo`IV<N{n#u=&yZ{{V\'34%#^`3׫Ә-\"`-ѠP^Yˆq\nh 5\Zy\"KMMv<|clNQ^X\ZT\nLJpEXP\n,8mPEg\Z9ϻ/=,ӚbQy_>~\0E_췤eg\0H&tEaA3@LZ|RO/{=75yqǞyyqǞyyqǞyz/gV)ľ{]M>s7RkV-\\9g#BcvD6 sgzJV|4AHRFzp\ZZBPe%Jvpk\rQb1P\nYp@uMt7L%2yTΤB؋MERZ`\'DPbOq\rjQ2nLb]%d|tZS˗NhYqYf;6\\ C-#3Sn蛚!T[;@AYQ\0]7V>R	lo\"A3EIUѮ#JeWCud1pUrO]Xynۈ[sJ@*y;<x\0c\04<q NkDH~o~*λoOfv+gО\0Q9֐2Ǝ@\02Q[ȳ5Hde\0>?5y}1sIeRY݀z9@y*BUw݅m<ע3OYK>lb[͓2,sȽrM:[5OG_[yd#BUk7h6XJQ90IMSm5]:sT0-=^2(YZuI-e\r4w3rmXc(.=F6P\"\n}z]2F}	l:HޛF_d\'0~l\"_J4ԩb.rSIuP~#+9mj/qW\']eEZo4ҮZR=1\rrS_Nw~g&b%H$cgaV}\r$4Y,1r+O4+}xT|q^3 1{jHtѡ۫ZvYmw9V8@(\Z@]qG(-u\\id+#]~t\Z]M\\ƮȢԵB,P09,\\LU$չmzg\nRh.sl	?׶΁iW\\izao0ǰM/]U$PWA\Zz*V_Vd|]֘1u?/uDj\'WR5~buzaW__i7G׳65T8|K+P&|\'ܪ5Vj{-$tf<uYgy?6byx>M\0+=nj5+=no4֚\Z:5#.]`#=;Cƾ̞)z?9唪E ],*y[GRSvs\ZfrfRLN1qǢy<ػit;BzI}F I!؁X\\3\n~YwM䄊D;}(ꑃ03}QoJz,ʏQ\0yJϴ)^xl?o@S͎Q?V|/<W_#\0>yy|@b\Zzߐ!ʄtT6rz_-xM<vs|jq\0Dv	Ы/O[Y!#r;=9DWUؒ,s/v׫}d͚barkd*\0 /[u~}w3JZ[?[ئo\rU[KH`\rfTeCiVmrHn()ceor|*xujy>g=Ujdk5q3ƻSBs,~sCg^3H\0&z=is\'OI}I6ݶ~Tz\r nQve=69wGK1֨[`rj-0eL?iȎYJQ_HrO%$5c\0X?g\0iۦگEBF_-ޔ$P\0G<rC4zMoKG,rk$HuMuMv9qg8u?p|Z^Bw̛jDm\':C:nɹřZ:awsD8YFGb5irhoΏkb0WfP&5yʓ\r3)u#	۪]PfZ	;#Cy@!H#a27M+v\'sX\0XB	N]4OߒM5_mqft};o0j~HmQqgi?m2j^y.\']H̐?8oZ\nx#2]i $ȭH\0}zZk.U}7Nʎ{g}̲D|\Z,fe*䪩Ϭ!gXy>1`d@XE49K7h\'m)4${mkqg@	j!&V5Sњ.O=fX`T|VS!.rqU\Z?7!g]dZqv7ab!ʐCár\048s84VT6h&!Q,a:Ub3?@b0CgY`lg<<8<<8<Fv;f27ul\rh	bd!8zkOL8LD\\;\'[-nhRY5nՑ1\0_LD3d~́T@R8hP\04y+uL7?=RQqVZjm?7ԟpкL\\$;iisd\ZkY-r<f&z{4c&E*[K{}!w_}ye;POvj}NUmJ]WwStHmb{V{,J0!+{|C2+v}ipSI}Iba~6DXoZr.3;Hے	l_=`T_Wki\\ZQ^E}:kۚVj*ɹvu[`%7~^aad_nqD8ruo_Auoq:ͪ}8Mt;@,	Ik \Z6\0*`rbUe\r^)5g95ԎXBk夒jPMk=s彞.OW_a89czkEc\Z}v2mѲ5wcB辽[Y1BӪ?5mO1Q돮+}Q@VMӫaXb0	.y\Z+f$u]{+M*;9H={4gKhȃW@^_0X;.*.q>FԁeKb\"&w\nɐRR՟A\"DE-A%}\0tqB|gQJfBB5zVߝܘLQW6`df}2g͎̬eZLXXhfnjN@|r9%a4;NVϖ}m^;`$\r6amZ^lͻ]-$ɴOcYSQADg6kYzD)(p\"WR]p\'1-کeG\Zq\rOPtZtKaO+_,o$Y.A0I\\ᵵI9@(?2Z+7}Q/}IGǦ馚ktMquMu5]u11c1zʄg\r\'=#|3objHRDONW_O\'vb4o}=lf)<JZ{ٍj9F0}Kh-xwkI5褒M,K?h5bfDs(>vـly$Z+ngK]JAe!I[3EE?Xae0Z/[fĲm/=a&UD@Q*\0\0\0\0sSNww7vh-Jڬԣgvf\'Ǟyyq_Q!6\rJ_r(ݪx6H&`iKvSDk?<.yJn\ZOM*Wtyua[T?Ԭ]\Z~u8o *f09.,zM1<rg&k\'NJmu]]w}smmmv86lg838q~ܩu.XoKV۪oG5)csT 249񮳄p\Z$<3ifq>ZL7O#-Gǫ}~X;qDyYMf/ɽ.wM\0&j.9}\n9)E^,;K`gTRmtZ%2ř~01I߻?]	64F+X9\0D&x&C\Zc PG8A$Kif|5NMn։zmO\\9@{*(kgWˊIVhaMZィ{8GYdVy[+ܽi3=\nI Ȃ9\Z\'qMyyr.\\O	W6ǘC~Xm>`N@.m\0P1mA-oC0.=1\"VQkg}l\0՟.u1\05M:=6Y\rˌm<W&1\"bP$m;?&&mFr%a<ٙl4ys9n==Tٶy@jxo,;oo?4{v3f*6\Z\0\0J]eQ3\nO$\rcYӭi\Z6qz竜t81_ӕGMJ6\0xB:35 M&ycp$H\0=БD,s<zMאּxM3G&ku\\msg}<͏:{*ާj֕kPaZ)*[1XFhq-ۖ6\rcwFb\r02Ћ(B9\"	$xdXM/8_=V]c)cNo4;%Aosv:bk66jj>aNz֫x7`0<VrjGbȪ+*jbεzpBBK!H>	Yu\Z~O+}~4[owgUpGUX:t6h&;\r:ܱY/p7hgV%U1:傪m4wffiAj\n23g1Ƭ]bHRe\0PY--}>NlC5ުLr, P\0n?&=\'G)ϥgཬN\"v={Nђ-͟W.=KwdkRܚOTlPst]fM=+cKŪhݦ5{!y؆k	qE9zxj`kׯ<[g\0񶂦iikby$4oG%փhQͿ\\GvD&xGk eB\0mCV<Xla&e\0r\\s~ɹC&\ZuJ.vr5Y9u+8	blQ4XI0ԄA<7_G\07OsDy\0Q?/M\0G{;\0j<\0ixt\04G\0ڏ\0n??\0\0?~q糿_G\07OsDy\0Q?/M\0G{;\0j<\0ixt\0\"^/uGC\"EOGv\"[ʺ3HzyG+ؚAۓ,eIHeMafpR=ӽ׎ت\\IjjJ\0Tir>j_US&ն>OZQ?/M\0GHϔ|kQ\0U$\\ݢ.D	6yqv\rbڭg 5v{KzIEI9zX\nck&6LxRxR)\Z<R&˾49#8MgyqǞyyqǫ9$aQ\rY*bl~K*p΂Y\nM65>n̛8sGpi[kZ\01AY::8U/oۏ1+E?8tM-[V܇G[zWu%H`jW1@ҹyww*ehm?`sb+bϳZGޣƻA[P.Nj_(e6![u+Jans.b98+|u>-7fQRQrE5+ ɘϘK]bVa|*щ#h@WET9BknR\"]ߥQ<	8Vau}C\0bl45?w<<8<<8<<8<<9&)\'\"&`brM6BGi8-J&q;GoN\rkCZc/d{>:*\ZvyKYO>zȋK^\".k80\Z͈uۅ^hz`5Y`: ]JQ2Eh<<8<<8<<8<','pedro',1,'teste',NULL,NULL,NULL),(195,'box(-1,-1,11,11)\r\nA = point(6,1)\r\nB = point(3,9)\r\nC = point(8,9)\r\nP = point(4.5,7.5)\r\n\r\na = line(B,C)\r\nb = line(A,C)\r\nc = line(A,B)\r\n\r\npa = line(P,A)\r\npb = line(P,B)\r\npc = line(P,C)\r\n\r\nD = intersection(a,pa)\r\nE = intersection(b,pb)\r\nF = intersection(c,pc)\r\n\r\ndraw(segment(A,B))\r\ndraw(segment(A,C))\r\ndraw(segment(B,C))\r\n\r\ndraw(segment(A,D))\r\ndraw(segment(B,E))\r\ndraw(segment(C,F))\r\n\r\ndraw(A)\r\ndraw(B)\r\ndraw(C)\r\ndraw(D)\r\ndraw(E)\r\ndraw(F)\r\ndraw(P)\r\n\r\nlabel(A,-90:)\r\nlabel(B,90:)\r\nlabel(C,90:)\r\nlabel(D,90:)\r\nlabel(E,0:)\r\nlabel(F,-180:)\r\nlabel(P,5:)',2,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0-\0\0\0\0\0	\"!X#$%\0\0\0?\0\0F=[_/T9w,=\\)Bz4k`1.Bj^|ס).\nU㟳 >#=\'c`%.Ui|z87F#eRh\rH8MNoK<Y6Ruc<\"z_!ޭOcDaj?\"nv~¾<~jl(ȦM.^rZM\Z)pJ`0`R7cA%sJ}nߐ*Xs-RAqPQκ\nqTf1c1g;y\'Sr٩3[0ϧV6	M*XADá>;}7$ނO%+KBڿ!\r+8跋>R0t*j_j(sVq[E%:Ukdqr%ٱJDŸ2rЎ#(V4aG	a:ڞoJ籌e5bp0VNK4+ǹ!2Dċ`A\n=	@<B--i籌c1c8Mb|ܕVEx#rΊ\"$blrV+쐖˨ZvK\0_?nƿ9YH:~d_y~|Eݤh)j=f{DpCXrdW|ZD&o8һ\r)u#s !YNڹЌ~4DZ .\'\0Nk\03ɿ\0\0Ҝg<C\0o^W\0J<!}N7~n.O{\'+zzl]ʭQE$\rTcBVlTϤ_\0;\09?/&\0w\0Js_H^M\08/)q!y7_S\0Bo5\0\0Nk\03ɿ\0\0Ҝg\0;\09?/&\0w\0Js_H^M\090XOҴMIΉ\nY15>!52,Sq~k82SXtX ks.3O:_V~[ǕyӎfBi^șkiQʹ°fz%PAޝ;T+ٽ\')qڣdCuAurm.^H0Θd\n>+Kv^Z\"Z!e+(I&RLt/E:\0H\0Iʿ<*W^v+)ج|`~.jbGn::&m)auCrn{~i9țC\nNYgS\"D&+ҙ\rwZRp\0b&C|ps[SAh&\'T@] \'#L\'<r1zw7dR#+imC7$Ц\0TmZϝxS=D<oa\\LLn:B~߰p/p/\'`1c:Mu[@h!d=X**VvlbJmeoz޲n_))cbj\ZO-T6{e/\\]%!\n̭\07`1Wwœ0m9]a9ޝ^44NLaA%ץuq68ڴ8SN*VV@\Z*_\n\Z\Z0&qQQp220a4hBue^Ms-gXtʘ;fX0͏9ޜiHR|ڷ˟yoO&ϩ՚<\nI^!08P`bCJt4n|[gq=˽vzJzvn8~Ä6@)q-OK$,ּhu)z,\r/2+Ҟ2Ch8 tIF,PmM7)ƈ!\08.uoL434Jd5iH1À !YvmNf\r!$Rt2QJF=[@<:\\e >e\\CI`*ؽT!#zJ>Ȫu(c1޹7~26md{L$VٛR6&J崨B$$6W+rMF8(<yF^4L/|gb3	~Mk@5M= YTBa\\8ZY!ZV܋7vꐄܤX҈ܥL1ߗ?|bǕi(90uHc1z.mͩǘv!:]\'#&ZG\n?#\rWɷDB/zq*V >F&gpqq|m<A(O$r\rλNnƤwKE{̴:6§jުNMƿ\rǰZa\Z^\ZLviSH}^JJ]iHH|~<4DԮJxsѣl\')jA4@ި\Z V\0O@Tmտu2.Lnһ\r)u \0p\"o9g	W5:4huK\\d~;7^ֲ-h+TVy\Z섀\rFqKSc|Vc0X=cο^ho:$)dp8ʼzVʇNfROb`.̺%<\0}Yůt>LyZJ	2j$.F\Z蛬LKw(\\X3n=~ֽxo&ʵ(O0]έ7{Ȋښ_t+	Rמ8*],3HeNc1Wsjp!j۱O=z).)(X|2PY_ҝ2O{<JT:x>z2|ft+,LC<zL	81m2cKLJt=\Z<6>yqr &TSA\rqa@F[=et9ٮ#Q:p4.]dh\nݧ\'hsMrjZ.mMV^\\W\'`n֛r.mjCl]z*[;TT`+ZZd%?mWYIm\n^w8-*%icntJ*\'7:̅br!J72x<zT$U+\rJ\Z4j]w_u\nݎ!\ZQP}ۤu|LuRn vE~Sՠ+UB	lTTs\0c;\r%-k\\1c1yO.e8ӱt)o+I]gƦgm\\IYNod}5N\'»[)P%^CT\r}8{N E>r%OTCSEBo+z}͵3E[WfnJؚ^U+ң\nێ9\\5\Z3O 0SR}*g|*_/к/=\Z|y\\9zETL]e]JcQj,;\Z!n4ڟV<{z5?ir[ЯVޏ!th*Hc4@(_~Kė&QSz@\nxZG1vOhtuTwyTUWx漪#hrݖQo-zғW+\rF	ZUb땪A\r	\rL(G\0,l286hFc3km8݄JsT܇O61l}!Ͼf;JB6?սwwG\\ͫzy5}NRJ	S 1WKs\'Z;35;ɝRo={=*=6cvZ{cxv؃Pv?+uyUfLe=h+4ݓꭺGA7^\0t	?YJ.ZOի8SmcCU$+ҍ9:$|hS[<Qvo;?׍&\ryt^c7<C޻%DIj/ThC<^X,xA9o\rXyV\"}ճ&w[SC.a*Zge[˥v]#wi\rpZ4D󔎥x3\0˙@P/2\\Y&I9$doSp\"fvfiL)8p\0s1|>8NڹЌ~4DZ .&1cɋwo&mN<ţ	Ԇ< ޙ58Q.jM\'\"!{;I\n\0F8|3B1	iL)C<@2m:ۉRoҨ~k[mRPolU)U芭n)o嶣`,\n+I\0Ւ)o|Ǒ\r\\\\˾&kqԎ\0WKA$B<s\'Y=\"SCJ|z4߼Pe\r1ikY AV7 )+K_>%+_=OǆzO!z4xm}`:$#@MZ6D\n	\nrΦEMWa2\ZM,;j涧B3uMNk@OGl1d_/[ͩbsHr\Zo0Wn<E갤\rbE)ClAgw1Jw2O;{3\Z*TҼ\0~NKpn6]2ѣ% {ȡ\Zm塆֭VG~NP{7PcB(HYռ;56j1R2cKLJt=\Z<6>yqr &TSA\rqa@F[gS\"D&+ҙ\rwZRp\0b&C|ps[SAh&\'T@] \'#LcL^SYqN<\0t]#r#DoYm)xW:m)S[MS15oOTAN֭$)&:ble\0$\ne_q\n`>M+@I/xDJKMX$偫_fva52*PFr*i|kRB^i,ݎ@v,lzv:6~	sm%1GS1&^tSHsgX<8HŐV\rE8 |n\\p\"fvfiL)8p\0s1|>8NڹЌ~4DZ .&1!x<#[j%7a)ұ1w!ͦaHs9ÎҐ8ͥo]y?jޞMwS4x8Bajp4Ǵi)+Iַc=˽vzJzvn8~Ä6@)q-OK$,ּhu)3֬K@b`GN\"X7)c>4ύe$|Ȣ<}ÝWw\nAJtN=/ĺLojI,h?R){RM2cKLJt=\Z<6>yqr &TSA\rqa@F[gS\"D&+ҙ\rwZRp\0b&C|ps[SAh&\'T@] \'#Lc&/@oEͼ8\'K;RzddkHGPDa6@WЅT1c7`hfzowg^v$`2G)\\jLGtWCn:*vYTٚk֪yl!`4eԥ֛^vuWwֻmN5MkC5A\r9Ad/\'jSsuf1GS1&^tSHsgX<8HŐV\rE8 |n\\p\"fvfiL)8p\0s1|>8NڹЌ~4DZ .&2b1\\C99\r7+b{XR\\SzQMe6 N;c2O{<JT:x>z2|ft+,LC<zL	81m%;3h\'XSG\'9m;-qv(N,:wO+n}\ZS1fQ`xix].G9N.R1dժjh QN4@!p۫,d\\ݡv\ZS!JA\0D(rώkjt#7_h1\r$ꖸvɓ\"\\S?;Hb%|jhvJl)ιJq;pkVGT1c?oJ(2G\0ʠk8]u)].z,p,yXdǷYrn?s$CPO;:ԟ+VgWMmXNCW)iKMacu>X?C\Z^\"eWK<d9q@蓋Y5jښ oTS+B\0p\'\\ *6\r}]#vь\Z~H\":>g]>GX< \\yFCV&\0(VO</2^m[ɮufWL-N撝8:%:[%i:{,++˭EK5WrKDuP;gwOYVl9hI3ceӘ7ٹB_B[4Jݥ(U?q(w `0N0ֳº[:_!t=ҫm_E,I\rߢ,utf񐯺֖Z뜇r8^<T<Jĥm\Z[_))#[GֳF\'7e%:0[q?;[w-m\\$D7!+C	1c<Wc<DuΥl=GH 9\"g,#GTG4jwކW\r%%N^<4ˮ![mhR%C1޴mgJV㭣yW;g>tF#w]~m輲̫m^?8 K|ם=0Y	ܳDՔӱ1ȕc1d[2Gqn%CW:rC0k	u#IЀu)OHi2QJF=[@<:\\e >e\\CI`*ؽT!#zJ>Ȫu(c&*\0yzߠmN8SCv)/U%7k/YJSb;tS1c?+hSJy;,=ۡvt>G\"F\">i>\rZXd\Ze[*=0V04;6/7#+7	sR8?V1~yغGK7G.3S@SaLu$Sۄ,KZ>qc15oOTAN֭$)&:ble\0$\ne_q\n`>M+@I/xDJKMX$偫_fva52*PFr*xGj徹T@IRށXxt.%+۬\\:Tƞm-oWb~Ms-gXtʘ;fX0͏9ޜiHR|ڷ˟yoO&ϩ՚<\nI^!08P`bCJt4n|[gq1c2Oq]^1ݠwێ\rJp`dGS #K50\ZqJFWi;כ% RҤ<\\SF#s39C):]*V5M}SuQ0=ObmbWkl\"Mmp{F״{޾16fZ;.Hnb\r鑓[{m#Bۏ}!_BS1c2oeJa٨D9=^.=H\"e)SiڸԙBht9Fu9TUVvɳ5UUcW1KI-0B>8iCK6)\ZfQ\\W\\N/>x+1K*oc[q|Y\\|N^f1og6	v!i]҈5ms,:p)c1c?˭\\)P$wud1~Hx92/($pŶJ5F7+q.}YCn=g6/|sZHU\r$JJIJWuf1\"\\S?;Hb%|jhvJl)ιJq;pkVGT1c1d[7\nlC\\wz\0P5.:ȗy=Pr\\8YIMIVѼuUPo\ZOf\\ShV~:qF=WAqJVWc1?H^&ڳMJtg:eLlt3isfN_kp㴤)>sism[{tx^eڷ]$NZ(01z!%:q\ZuzJt>Ju31ceӘ7ٹB_B[4Jݥ(U?q(w `0N0ֲU!}\0T\"`ܱ4@d)O/t+nL9 )H>ÒoDaԱ2b\0t]ɛS1hBth#!O7FMmuF\Zn>}^N1c1Y5yowRLB\rQ9Ϥh̴`Hlu##`턎ޖYy1(1OpU8DsOK.,ڒK2Z%-J^ԭy1Wsjp!j۱O=z).)(X|2PY_ҝ1c1c$\0SS<ѢM+d;8Cn(a \Z2RLQ6Zmjn\"׽_K¤Z85\"6Lg⦻Ek켝{yOmՙ1yO.e8ӱt)o+I]gƦgm\\IYNod}5N1c15oOTAN֭$)&:ble\0$\ne_q\ny9jPw	YS.^52?PO.XW;Ze\"<58%we8QDn$Gnkm8݄JsT܇O61l}!Ͼf;JB6?սwwG\\ͫzy5}NRJ	S 1WKs\'Z;1c1c\'pGr>˟U#X)]~\'Q$IqoZ.qL*2t~\'7LڜyGbA\rxA22komp\\\"0|qOD+Bw1c1c\"+w$uuhi\"/QUKu\rMv3\"WC	Nu`8[pwfOu9e`ȨތSK辏<6$>R\0ԣ<dh31c1cOYyGbxn!_Wv]+\\UZ$۱B1NjQbilc1c1dWS\\7/Xj	p7H:䵶W#*r,(:̉}`#\"H1c1c2Mgkޅ<Wכ+)2eXSl{>cm6oO>.BE5\0?rh\"xc~zvi0l+Kc<9-LElgHd_1g','pedro',1,'cevaeuk',NULL,NULL,NULL),(198,'% Definio dos dois pontos\r\n\r\npoint A 10 10\r\npoint B 90 40\r\n\r\n% Definio da recta\r\n\r\nline ab A B\r\n\r\n% Desenho dos dois pontos\r\ncmark_b A\r\ncmark_rb B\r\n\r\n% Desenho da recta\r\ndrawline ab\r\n\r\n%Definio do terceiro ponto\r\n\r\npoint C 40 60\r\n\r\n%Definio da segunda recta\r\n\r\nline ac A C\r\n\r\n%Desenho do terceiro ponto\r\n\r\ncmark_t C\r\n\r\n% Desenho da recta\r\ndrawline ac\r\n\r\n\r\n%Definio e desenho do circulo com centro em A\r\n\r\ncircle o A B\r\ndrawdashcircle o\r\n\r\n%Definio e desenho dos pontos de interseco \r\n%do circulo com as rectas \r\n\r\nintersec2 A1 A2 o ac\r\nintersec2 B1 B2 o ab\r\n\r\n\r\ncmark_t A1\r\n%cmark_b A2\r\n%cmark_lb B1\r\n%cmark_b B2\r\n\r\n%Definio e desenho da recta A1B\r\n\r\nline a1b A1 B\r\ndrawdashline a1b\r\n\r\n%Definio de mediatriz do segemento e desenho\r\n\r\ncircle o1 A1 B\r\ncircle o2 B A1\r\n\r\nintersec2 AA BB o1 o2 \r\n\r\nline aa AA BB\r\ndrawline aa',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0)\0\0\0\0\0	\"!#$\0\0\0?\0\09s93kS_@e489w!Ta/5̌{@XLv2d8\'$s;*$[i\nA>l\"j	2ć}\0dW\Zd3Ӝ).lsUs9s9w!}SraUc5$)L;-!dJ\'.paFǖ\\8q:GG_58V,\0TE;%כA3T%ydxѥ4K[[je<J.iks9{WM5m2<NTjI[\'`\Z_>DI1	DW[%ЕeRkI9E:qm\nnI7!DaPe$Z،=`]\0oFt~>V+>ƚ-})e\ZĺF8 EoڌRc8ǟQ\"T`:܀J&tL	ke*6lhތi.\Zn>;4!DB7/k>y@thōSTgx? ܍h_;Ȍ*+jxIᩲITwzF+l޻\rCWdǃ\r3(u5IY$g7$+kB5n;s4/]	\\[ձ=Bmvw=V?=:#:hcPw\'VL~]dLTq%e	qHME\":!R3Rqֹs\Z<!̨̎v4Zmc4y:/46N%M)O=tv:<\\E5(]_1џ2D\ZBڦ,pFf4s~0\0hy)wh_!YܥvmW6\Zf}K!:^Kŭg-aQ&gZjLId\r\\r`z|g))םZ`&6k)SsTdOqٳ_q}9s9s6T#d`Պh\\4ÌcD,\\@N(a0x@4htI-j⇠̨xͶm}\"Sw3d2%ɐex\Z^y\'6#AJ(jq_׌}ns9s9\Z\\[[\0WT2&%jHQ&$KB%0^)W\0$be5sT3〬RL8,Mԟ.)6d[dŔ:TS2|؏*U;0J϶t]x@jvܬt42vp0\"#iIժ?mwFr%\':X=ڨWEƗK{\r޾)5)ECBsCV!jŵv*d&`R\\!&#@c4l=-6\rӎbc`<6G<H(4$	^~,cinLg]ei_Wj5NG@Q:͸:\r 1BKz*araJ\rSGM5$7&.>,`>vZmm-HWg_\n3$9)&פJOBBv\Z ZY[+Q~};י2 ϕ\Z16lڍH)2IyHf<hnCM48⒄;x5%+/\".!_Bv(6y,3(Urjֈ2<Tx*1k)k<9s9s޳U@rz~`+$T4\r&>T!/;`ұľ՛Y0vrL9)M桻[Gx2ۨLc=̪F&k\0TΞT!=\0@tȕ9s9s9эoOi?߀DFurgh\ZElPJVo(?fV[&Cy<l_	SZ\"l]Q\Z	R\"`˴<AOj@x[t3u]ɢN>2+0V3W#OeoIeI\"FYe5z7!<๫eh5Uvgv^hh *H&%?<E&O\02HyS\0+\0}\\I45^_]YLV-DN D`}dKe6o\'YNZW@`bDCbU\0aIr3?$RO\0Hcu-bZ;\"oikPg9R.*^z?&Bo,?\'=xL?%q[P66m(B!>x	O%)J|ħ<<<;s9ser,]_n`${Li[\n?\ZiKA2=k=jW\\wcVs=6n(-U3\"e\ZX\\/vWnIC\r@CXT\n9s9s9s:s;&S\rAu=2_ NY$\\S5nɐܷ۩,΋$Wۄ[o7xײ*Lh4k՞=G9ݦA+3 yy>EtG\na2g.؅TEdAiQ[\Z8\0JBĶVmn8LN4I1+,ŅdF>Cb!@tZr3F|Y4gc\ZM\r3AMU\nscRt_Uha5hzh>ve>`~7e٦*]3ʝ<$ѐeF:UvΚG$4	U/DksS@kD8b0:Lb\\u˳Ȥg3j*,5Zi-`(Fs9s1Ǒ2dbĊ˲eJlG)H}!Ye]qIm%KZO3ru׆e,̎%7\02W͏\\YL*1zVk5(\0DET;\rK#\'Wܢjm.Rh\ZrGW\\4n81i+λ\"C\'dyR쇝u}79s9s9s9tkZ!jД|Ir_Oņ&|	@3Y7śh \0U.q@T!V>O6lu$2N2yLi˷ҩ>rޠ\Z?J3\nyt٥ԊlkaϱU[>^p-#=u+b\r7FV3/cbY25RY4tIsS9s9܅M&uV]ԒƊ8Gce0>8촇e*\\AYs{0G]~÷\0\'D|]Fi߉Jhe8lWrk:2o%ZMc2˶bІB[mBP\'!)ĥ)Oxyyy~s9s9s9sVds7/ny1ɳL0F=RܪKLwA9\nKY>]Ji.\06ɟk\ns,TkN|s.at\'mh\nm ]y%BnnX7aZD1AlՔ]\"\r03R8ȒD7bMcF:t.Gj\"gM9sI$VDׂ繥6c\Z&fn2妷J*pȏCQJSCMhT=eCmh}$aWI-L(_>ׯȉ9\Z2TEU&fSs9s9s9s91vD[a[Ͼ,}[Jm%KZ֯yｓ0ru}#츈7P)|.G6\0߶&2ۃ-ψ?Xx֊\0e1̏\"ʉ)cJ%ߏ&;SOǐé[O2JSnTۈR}?ar\Z(6kbb6+c\01цfnU}--_>p gY\"yY1HMiԋ]\nLճoҘ*ϾzbSJ?Մ)JS!h GiEއS9sꭂS[\0FY\"i5@x	߳%ȅ66Ƀ/aLov\'5\r;@f?eWL13\\46t߁Ϥ.D|9s9s9s9swU[|;X¢􌶒B6`٤L+y*)/\'N7<1*BBm	mҔ!OB<JP>ySyyy@-+`N*LFΎW\Zl$CCnPʈ7.iB)DF~n*^ePYuHP6gvS\rJeg@]VCi*3ksi4{MQ>*e`R\\lhOW3rWem2PV:JɎr|FswEj]3Ӊ8	F.\\\'$-f\Z<b\\3XGB3ga\0h9vQ-\"{\0E\ZVMgƘɵq攻#ֳ֥Gv5g3k>AMZ#8*]Y9{ѭōuey=.48-<!5@A9s9s9s9t\0SyC6P&@ِzxءʼ\'ߌz@*_mvcBDWMkx7=F_݁?al!,ġA*\nOg5,2&*4I&UڴEɗ^s07	 2@4F4ݨ^((u_ĬY5\0\"M?fvbwެ*lt9TڵH{{!铥ʠ`˄l+$jɔ:im?SiH^\n21w:=lָAAT/:Hq:i*Mb.Ԙ;3!Qr*`X[\Z1t\'RR0~9!S\'kG9ɓy&Hf,H&T.xB~DR\ZeZJuBTc7-w_xfZr^cp.eAŘ\0$£fR?DUC`)${r8u}&Y\\%&[Q!$x*x|aaJÃk$9}vL!nyWs9s9s9s9sT|wM)|rLH\nlHMqR_\0$GϠ\':\"+=8tvuaPysZ&VͶAЁ#U3r4ؿX%\r]1ya\rʛ[UҲDdZb3j	2̮?1r/<i6*\0Ay/ɓ\n`lZsca\r[2%5#L(<	\nV3Xδ7dA\n{v5>.{!YRFeF|;?kĩk(7I5//.\"9XrKʇ%nzK(\n\\$1u_oܾnXGUj5I,hDv?fSCHvY˄Q:jx)>Gz%y;ptOz*΅k6TvXC}|&+P\rUV3,f!mm%JP!>%B|)B<JROyyyw9s9s9s9sET+iӰ@ڝ$E,1?dVr|W\'<>pX%г<PWVggqfY:H=mBlSB\rqٳ89ћ_Dv]s~^,au[`CɼE7rsXDKɑ2uzNf@47\\T֯Uw\ZqjdC ee/ě\n[\n[O2K^{>\0$-)ZT\'{OJ405D\r9GCĎF),B}jI<Q\rŠ\0`ski`FH&{@`b}:fT입B0LsDGgCVT#d`Պh\\4ÌcD,\\@N(a0x@4htI-j⇠̨xͶm}\"Sw3d2%ɐex\Z^y\'6#AJ(jq_׌}ns9s9s9s9so<v]!aＴ,V㮸Rm	Rֵġ>z{{e\\:\0&q[|2J%23kz<\\aC/myYZt\\;5,Òw9sN>v\n!BMY:ӖcS\"<6V`9₤0>w!X[;;-\\fVv\'Ç)b \'Ag5$zUk<-JS|k|+վe_v#[D|<$׌UKɜށB)ct\nRSrA\\5X_9s9s9s9s9gv9_:[rC f):_c\"ɟF%蕿su]̹	\Z쎋O~A3\\ȍH,ʽߴ!Oa:UY1EM-U6|<<ݶzChCm-R!	(BJR<J|<<<\\9sf.eh78w,yN88D?\'5\"\Z<2UӬN-~7Uh&ȪvgF?49ݕےpCgķ8V*@;6[SӅ/\nT+p`3.xpؓeϘ`)$\n32y5Sm~s9s9s9s9s$3Wa4L)CV)u	VR\"ja^<ҊXL\r)WSon+fV4<lwֵI6Oɫa\0/X$Y3yEV\"s92cÏ\"dŉdʕ%؏\Z;SȐCLIShJx=fNX3Kьn\0e̯;:TbjQ!vL$nGND҂%V\\*Nd|qTTW	$25Lv+43Q4̕Ti/<3)f:{4r[v7<\"!#Z>yVaCR1̏\"ʉ)cJ%ߏ&;SOǐé[O2JSnTۈR}\'~x!Ye!x#\n1.GG8D:ݒי&:t@79s9s;(T`1%\08qLIǍ+jzLӥX#:-KqiJ}%w@%f9y+\'aL%\Z-ץPmVI-v:P9s9QQmNAt\0}\"5:=d*Ol6dyQ0rּ9sM4F%qH`|qi\"T9p\n6<MO<\'È`DO\"n\0NC%Rк<fӿqد׾tej!J*el!\r\riJ\'ġO%(BSJR<)<<<tJ˫\ZpLy:5ڙkNMube-<j6IJŐs\rnR-CLON.u~T@SdOtOҖ䧪wZ@g>f`H\0[%\nN8<=֛lV`OUdĲQUg\n%fJ|\\Ej-FCDvۭU׽n9O6\Zoaˋ8zx\Z,;DUP]bpjQ\Z!9>s9s9yJ>\0#L7,/W\"\"m1FGO6HD&P(q}yo	}_y\0_0%>\rkv37Qg#XwоDcq|<FSrUlOeJCYdG6,&/iP&<ΚMƚw^3s9sAUi9uQ2JzԷ;2Ѫ\Z\r!%W*.DvbkDl=4Z{RbK j3{8IN5YLJ`$b{͚s6T#d`Պh\\4ÌcD,\\@N(a0x@4htI-j⇠̨xͶm}\"Sw3d2%ɐex\Z^y\'6#AJ(jq_׌}nsس6ͨhיL[	,=CfkdJSq26a=  )ԴDԈ_l)A>8f\\Bidrlx#1H Ȣ3%SqgK]#T7aE\"GS\nUM-5>>؛ys9sF×co[fdH\Zi_Tjt\0eUڸ\'~<h#HKl7K!.~=7\nd ǎ2T/\'oH[Dpƀ\"^\".c?7EUeԹ\'ٸ^)\\$06z]tHNkJtip\"Q\'#@ShJtjWql4~<fRJ}9s9s&<8&LXYvLR]m񣰅:4,8)-kW|y\ZG8k_xɨB&´\ZH_A+NSJlYWs9Y^ e9}u?yTm*\ZZ*dNg}0iX_py]S`jͬ;\nB9&]&bsPݭmHa	1Ut#5ʃKL*cgO*mM\0:RJs\nD%#XuʯEn,H:0xU?_Ѫ>`WZkfMrP4㣜\\)5q?tIxW	ɎgjTIM+̆dX\ZxZ/_t%.-״,h.J|	ڟ1\n\0W5S#n9s\\\'O xRI0^laߗ<	(!oI%a-\\J}REs픘أ)q(vkr~crhn5q?]יZWQDc~n]in@eFHhdm!rf&Hbi䓧R`Bri{hHDknv#amxe%X<kx~&s9s97su[\'q@J#*+28A:[qI^1O%\rh2*sBz9`!!Жm)B!	ĥJ|)JS%>yyyy߮ser,]_n`${Li[\n?\ZiKA2=k=jW\\wcVs=6n(-U3\"e\ZX\\/vWnIC\r@CXT\n9so[dh\'%^1B^i5j\r払fvaݾcv+ҾUT)I{mG	Eܪj K<Phcמּ_^T1jtۦεg=D9GV.ONDI2:u&\Z5tUfp!gDڡJEe^J6M>\\eR>]J˂{VLc7=84?]76L?YzZ>!KpLs(xo`a1iL(3^{49s9s9OGgm+\\pc&mpء:τw+)5ZiE,&C\\3,J#Z\Zt}2nPhlUkf5C wO}p%W`3!rds2dǇDɒ+.ɕ*K4v_!Teu%Е-j>{]7^g?28\0˙_w6<uqf	0YԢCP6\nI/܎,_r)wW	IVj5I\n^Xqpҵ0mZ:x])H[u9syd2y\r6_a%^e\Zu8ۈR->iԫ|;1͎:M<ZcVZZ;fq*,!y:.%$>M\rl+\0GX,\09.Y]˶>GϪVJŪ|MYS_gR-$ˊ,>ל鮓14nǤD,ETmf?\\N1:\\	i+mZ?ɀ\\?7Ie\"az4\\˭i	lmևX\ZO>m3zu<=}LMH͍gVvga\0\\hٙ*u*fRVY\neV\r$![q\\yhkW9s9s9*2|wJ-I>bN_Ϥ]&:S%Sc`)l* \Z.[Zל;ߩ}D@kXG~̦%K80c.tR|8fK!v?2U/m;8PLmM{FVmIfYvBhKmB|JR%>x)<<<<9s9܅PWU;,/,.CiCK6(В`\r4y#̓\"<SX-%r^:^ra7Sяf[t`:E+7ԅ8b4HXQ6ѣabHO*hČ\"i3b(#V/4H-i٫ϩ]<;nD-{F4Z8&ZE_qnk.	ɭ~hǙWTdKoWX*g9܈O40Hǈ8KTܥ.E\"^I>n2\"Y/%j6:Xn\\ѮLUڭSlFa9s9s9t-Vb7D*$rR߈Fh4Xd_$BT|aيArQlkYI,LO%:KX,֔>fe1*}v_vL;6k/9mofcF65iMƉYiҁʜ2#P=`ҀiTgZ*1APmhEf%eKe\' /ς5$<\"NlF\0QB|Is9s9yJ>\0#L7,/W\"\"m1FGO6HD&P(q}rӸif1*Mҳ!V/G,~U{܄ALY<!\'if5f*6t=NZi;!	gdݾvo[=KҳZC^8D&m\\E S\rVcndP)v\Z;\0꾱`YUT\07@xvj4(2g($\0a}B9s9s9s&<8&LXYvLR]m񣰅:4,8)-kW|y\ZG8k_xɨB&´\ZH_A+NSJlYWs/Ul2ޟF*6\rIO2m\'eǈK\0>4q/<D)yfL!}f`{9nG$S0s*eA?16v}&)r%{9s:ol9v?\0y6YfK+YV\0EM6O\\lOV[],r|Ƃ>D\06ϣy$`~pB\\x%@pVoUJh\nb%\"1!>p?z}]uV]KR})CSi\'߮ DD{&ԧF=%46Jk*>DJ.MFz\0(HFJZco+T=}\0JS}]f>\0e@mz\\z>_[4\nl7/#hAzujnq?#u`\';Ohkjrp{lkYHkb)kq9+ӳaO1\n\\W9s9s9s웹O8%E~\\Qdy-$	gzy[giO=UBhKmB|JR%>x)<<<<9Fܴ9{G8tj۹X	5S\Zc&Ƣ;Rfc̏ZZW-՜M7Uh&ȪvgF?49ݕےpCgķ8V*@:s985DN(8 @,`E\r.y]f$(QXBޓ*K0H[\'y<u1)1aWFSǎQ$\r\r!Vϐ:j~3?ǫϞSˎ܁G(ʌ\r%.BL?\n;3l!\'O5Fl36\rMFǚRFâYivK9Dx׈MDDk0%4jF]b_nhϵJQehj`\0&rabD\"Bk<yA+ЙtVp&:SՈȈV\0NKSOY@ۏ }^eMM^:fl,(d! ,e&ps 5\r&\'%!i\"+<iQK~)>}>s9s9sO=Iٴ;g@iq1SbS>ܬDj¼y\Z=!rR88Q*dhj\'\"$ʘAUIy3Ȁ=P^O,ɓsxdɏ<$3$V]*T[b<h!N\"C\r2-%N:Km*Z|1n3-9`~dq/F12lxaQҳYD\"*m0_=Y:VSiu,Dk<r>0kwaL^u>&Sʐd<s@._MU+<Dt0wDܳ SP}_%5>Lq#5sOIBءm%~_|W?6ή;+Fr9ʦ`sIB%N!eK/QA]=G1R$6ѽx\"IzE9\"Ps2)ҝz9sD\r?T~l+6hNTB3T|Hd4*jY\nW32?Vt`a	@0eD29Fܸψ\'@CcɎo2ZUja]	mĖWȏ\"p~Uz$DP\"ZK,\ZІR3a~Mb)=\\mIs9s9s>oߥڤ1X\'A덯.pqQCZM꿰iG]\r-k/n_Q7|,#\Zf4Q\";)!e;,R(˝5<x`g#ق=<v:\'=KB5NN*T;G,![bC^ѕ|F|*h]66m(B!>x	O%)J|ħ<<<;s龑tfٙ.4R;eZB6ڝ=q?Ynv4\Z$2l>pKME/#qpGI[%V*8\\\"q)Ą<>uYu.~}Inx9M~:R\ZdI=+9g)+@6&]\ZD\0\"A\r+_i}R}s9v~6H#&npN*PLB}y\rhd%h	Kư&#~P2D5&4yCQ%2iQd}\niu+i^iJm֜Jq\nRS{jnE`XZGʬ՘4ȸ)\nZY)\"UCL<Jm̂=[Դ9s9s9΁}*LF}|zDR=j[h\rv]J\";1H5p]~j6m-k=1%5qɃ=\\^vik҇٬%OYS	1=f}&j:$ll\ZZ-^qhe˖(\"?%#F(M6{墭SPm_\nnlY]_$[y2~#^C\"$h8P-W+o=Ms_D⃂\nI\"͌4P[!5bB-24B}WϪ@\\(_y.~{e><x@m`.ROn^m\Z<\rӦ\';KJ:z\\ѕ8<}Ҁzl-Ͳ\\2.LlC#6tTjLV1<`NM/tmym.l:-ldKǍxo9s9sк[d $SW9c:OjC,м&\\p!gA5\"eKP*Z8\n{DF#nƒEr!,\0KDrb.݀p@.:&Pߟiҁ_-SWիo nT\',t,6#\ns9s9ɓy&Hf,H&T.xB~DR\ZeZJuBTe|<Zsќn5/<d!OV~lEaZZCy$aXc{)\rjqQ,W=;[/6ъEC@kSLIl\0ϳf\r+K!k\nlmYaH_g$Ù+Njw- &3ʮdbfPiieLlMIJ\\^tERO4GH$M2\0E5ȈpzrQQ͇=Q!I4*}v}[_WuW5y	sO?i݌㲸i!cl4/Q2\\~e޴}\rs-CmhL1\"$QÐb%3,ҘQhg)i~s9s9YQ@	3هڎdLxST|.XluӟBJMuo\nZKlſzp:}0E;U	tgG|)k@X+}ðl\\WZmNx_+6БeYJ5_\0fRkU1{pZ@QzՍ҇>D\r\'lD>s9s9ɻ>XTPQ]q&JגۈOЖzy(kGUvYk!\r\riJ\'ġO%(BSJR<)<<<w=~Yc49àVI965Qҗc7dzzԯ\ZhƬzmw\')~PZDg6EV=G/z5θ^6ܓƇ>%2U(!tHr~\0:mKl̗`Wa)V!^mN؟\nW\ZXǍ|iq\06mFb8Ip%Ǧ\"Lָ8Je#ޫh.8KEbB|~hꬺ?c>7<SˏOK\\AΉpMsWN2{nJ$\0h\nm`T3}^S]b_WCn\"\0P VǌߊW^{G9s9s:L~m)`*e~qCMo\ZV3Ԙ0YOT:JsƦ%\'.NNYM3plCl|sH2]cbXC5.=p\'W+ʁ/M kvqBW8R=b%y01bd#\'9s9s$3Wa4L)CV)u	VR\"ja^<ҊXL\r)W6A/ҍYttr;\\j$t+DG<fu@QGH!]űɜ~uis#z1scW`|\0\n^J$0\0Ui(Kgup%l-F\\૕\r+[FeȐ2~T!]_.`M|Q<)$/60BCio˞DY\nVʒL0%	^f>sx~yLXUQssIADHA?1zմ|h7N-+1s7FT㮴 QJ鲣$CD2C6pː3$}rIQ0![\rA94QC\"5TZz<uݒQ,z5<e`9s9s9΄o5y]n&C*ެ@\nft0>beў/n\rO4vc-&Fym*an抹LD;4`F1/V^v0˅F[Yq\"Yd͢l[Aׯ-`v қ,rq*RZԸ8\0ЯۨCZs9s;\r\\owQScxt-IQZ0ocP,o5#]~Bƕ_^=<v:\'=KB5NN*T;G,![bC^ѕ|F|*h]L1ӏL1?EE\'q$wV7lOF.f2k!Cf\')!gXFm|%~_|W?6ή;+Fr9ʦ`sIB%N!eK/QA]=G1R$6ѽx\"IzE9\"Ps2)ҝz9s9s9s38 3U|ؖ(ʔ6,Bd\"zFĦ\"99vs33{9~!nWH]Xl?\r,Q[j2 TW˔\nRz{Jc69s9sw\"%F1֝PŨy,%1ʅ5*ujf,c#űyvh6Kɠ1̍_@=Dɱue/s۟um9]F-b3t!;l?7EUeԹ\'ٸ^)\\$06z]tHNkJtip\"Q\'#@ShJtjWql4~<fRJ}9s9s9s9ПDX XSDϥ`e4Ce/FTcM\\$P2ԧ79w>f\'\n!bH@|̃>W\\)$!JHn2.-P)I;?0hiƧ/lUfʴ|HŒQWޓ9s@Q2h\0~y2&G4t3gN1bD$:,-ť)37U^~7_y.~>\0N.\"os7fL4Ug\"(]YS߲߾Y^Wi0qcIˎnX[$B\Z}ʵ˵vxNQI>a=D{GHo?5\0ܵ{)*\Zw_Ag܅߯Uiq9+7fs9s9s9s6{7%NV@G\'Ȅ.\0|caII!H:l9RRmQ_(QE\'\08AplD$iI-fyubփq+gӇR=kЪu8<2!w@c863gnS5o|9sTeٵؾA!wr&1-L?@^=\Z(o:Ϊfa.|;!o|+p,{ic1^\"Noa2n&UW;-*m	NC%RyM=Dk(ж_#$^-xVU´{~s?SMejeTP(BN7W\rXKN\Z,Y̋cJU`PJSdŌ#FxRz|=[)N8|\0֥-^\0)^}s9s9s9s\n8\'$\\pEI-42_Cõ974R.&a*(idaeYs#@ʷfb5Jwh:UY@! q\"!\"LxEgA_@\\u|aH@\0!P\\i{$#HDqqHDHZ,zïPdxXg9sțJBevFř|Ζ݅d׆:Rml	q)3.!\n<SV`\rh2k;{Vk9\\At=$TFf(DCk4`&U;`Ck}a	.>Hs|ة5V=6m`>0k:MKly2W:\0և 芫V1؏̙y9s9s9s9t_p	D.[F9:Rp@*;^:a%	EyObdѤG9sΏG#aT˜U/#iopɏ]r(sm-\r;tի({w\n@KgPmV&XWϮZa7Vf\\C&B@\0.`$%|9vwѤnKOBA{;ЬziGt9n4:<\0?Xz}F?䵢9s9s9s9s^Y;\0c\\kۥD$Gg$8a2\Zr>1x%\rsS9sgqʾǕhm%cFAza\Z3m֚<\'5BPN\rKJYtM	s','anonymous',39,'Bisseco do ngulo',NULL,NULL,NULL),(204,'%% Example 3.12 of J.-Z. Zhang et. al., Automated production of \r\n%% traditional proofs\r\n%%\r\n%% Pedro Quaresma 22/2/2006\r\n%%\r\n%% Version - Full drawing\r\n\r\npoint A 50 50 \r\npoint B 80 50\r\npoint C 70 90\r\n\r\n% Definition of the equilateral triangle AB_1C\r\n\r\ncircle ac A C\r\ncircle ca C A\r\n\r\nintersec2 B2 B_1 ca ac\r\n\r\n% Definition of the equilateral triangle ABC_1\r\n\r\ncircle ab A B\r\ncircle ba B A\r\n\r\nintersec2 C_1 C2 ab ba\r\n\r\n% Definition of the equilateral triangle A_1BC\r\n\r\ncircle bc B C\r\ncircle cb C B\r\n\r\nintersec2 A2 A_1 bc cb\r\n\r\n% Definition of line C_1 C\r\nline cc1 C C_1\r\n\r\n% Definition of line A_1 A\r\nline aa1 A A_1\r\n\r\n% Definition of line B_1 B\r\nline bb1 B B_1\r\n\r\n% Intersection of AA1, BB1 and CC1\r\n\r\nintersec O aa1 bb1\r\nintersec O_1 bb1 cc1\r\n\r\ncmark_b A\r\ncmark_b B\r\ncmark_t C\r\n\r\ncmark_lt B_1\r\ncmark_lt A_1\r\ncmark_lt C_1\r\n\r\ncmark_lb O\r\n\r\ndrawsegment A C\r\ndrawsegment A B\r\ndrawsegment C B\r\n\r\ndrawsegment A B_1\r\ndrawsegment B_1 C\r\n\r\ndrawsegment A C_1\r\ndrawsegment B C_1\r\n\r\ndrawsegment C A_1\r\ndrawsegment B A_1\r\n\r\ndrawsegment C C_1\r\ndrawsegment A A_1\r\ndrawsegment B B_1\r\n\r\n\r\n% light blue\r\ncolor 0 0 255\r\ndrawdashcircle ac\r\ndrawdashcircle ca\r\n% violet\r\ncolor 255 0 0\r\ndrawdashcircle ab\r\ndrawdashcircle ba\r\n% brown\r\ncolor 0 255 0\r\ndrawdashcircle bc\r\ndrawdashcircle cb',3,NULL,'pedro',1,'tyurytcfgh ',2,'%PDF-1.4\n%쏢\n5 0 obj\n<</Length 6 0 R/Filter /FlateDecode>>\nstream\nx+T03T0\0A(\05Ieendstream\nendobj\n6 0 obj\n23\nendobj\n4 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Parent 3 0 R\n/Resources<</ProcSet[/PDF]\n>>\n/Contents 5 0 R\n>>\nendobj\n3 0 obj\n<< /Type /Pages /Kids [\n4 0 R\n] /Count 1\n>>\nendobj\n1 0 obj\n<</Type /Catalog /Pages 3 0 R\n>>\nendobj\n2 0 obj\n<</Producer(ESP Ghostscript 815.03)\n/CreationDate(D:20070703183140)\n/ModDate(D:20070703183140)>>endobj\nxref\n0 7\n0000000000 65535 f \n0000000299 00000 n \n0000000347 00000 n \n0000000240 00000 n \n0000000126 00000 n \n0000000015 00000 n \n0000000108 00000 n \ntrailer\n<< /Size 7 /Root 1 0 R /Info 2 0 R\n/ID [(	&bP)(	&bP)]\n>>\nstartxref\n458\n%%EOF\n',' ;  ;  ;  ;  ; Intel(R) Pentium(R) 4, 3 GHz, 2 GB . '),(206,'point A 60 10\r\npoint B 30 90\r\npoint C 80 90\r\npoint P 55 75\r\n\r\nline a B C\r\nline b A C\r\nline c A B\r\n\r\nline pa P A\r\nline pb P B\r\nline pc P C\r\n\r\nintersec D a pa\r\nintersec E b pb\r\nintersec F c pc\r\n\r\ndrawsegment A B\r\ndrawsegment A C\r\ndrawsegment B C\r\n\r\ndrawsegment A D\r\ndrawsegment B E\r\ndrawsegment C F\r\n\r\ncmark_b A\r\ncmark_t B\r\ncmark_t C\r\ncmark_t D\r\ncmark_lt F\r\ncmark_rt E\r\ncmark_t P\r\n\r\nprove { equal { mult { mult { sratio A F F B } { sratio B D D C } } { sratio C E E A } } 1 }',3,NULL,'pedro',1,'cevas',2,'%PDF-1.4\n%쏢\n5 0 obj\n<</Length 6 0 R/Filter /FlateDecode>>\nstream\nx[IjvA\",dMBLYKfMtը\"LQS{B5~x7.mTݛGv_7W s&4?OFi)WvP\"m\nq_aBF+|n,	b؍4H\'d،F{{HH2<ړ7vdTsO+/cx\n9A\rc& p{hwѷWw_ǣͽGE%גZX(JB{{=vI%\0^	ևYzmxepG{ĖV e{+xdC+Ym`NCZ7ѳ&г;Rmz~#;Hi\rz|0Q{a6>}2F+*\n`.\nǩq\n=5t Jp6xlucXRHlnL\r741_0$@7ZI$LO{:4xҐn?/c	mm^<xվ k(RF%Ю]^\'+\nk;Nt*jI{\0ctzLFvnrxyeKy|]n^sJ<sJgƺ)U0@ͳIO;?z>D)@k0lY\0Q]Bo6\"V&\re\n:%B,d9fNZϔHj31τH]QV㗑=ݽGӯu7\n`RIId\\l_`nq {שgȃ~<ZO!{=6y8mIf;8sQSVs*1\0M8x▽\"K}^C LN\ZɗLUZ\\*sl,O>5ؙ`Fu^\rʺym=Ak/r٠hl2d\"D8W?΀aR\nc6#=U{&AQɈȑf83iHɌ\r4T.0c/^-#{5кE:ٍy\ZR.t[Wi8yN`Uׁpڡ;)\Z =UzHxȡ\'jH(M{$ERPanى7z2pciN!;bk.\'+3PJcBC8aw ^٤y;2	{J5&L9J0)mUKˊP\r,tm{.b^=\"ںFO\'ϩz5b\ZBUL\\?ee`_n&~yoZ	oUv5G\\.v5GիC9z^>LCQu)4Lѡd9\r,6):j#?9z\',ZB$m}ɑ&~h<zqCHUXE<%[:mHJ.Tz+y[!ex\".&Cv,31h<~B~hdOuz@\\Ԕ<\'G8cۣpLRf/WjV۽!b,\"0ຫuNIJ=\r$S1\Z;ú|O<!W%Tp\\@T\0?k1M֘[&$x	dhCHPeD\0CxESu1s2@6pLةَ\\ɃRZ5J;86VRS1]rulDH$6\r`!]ܳ:$Ӓai)zoh1ZYĻRSDS4.n, $IbJ\r>F7Q-M&S	O8kV\\AuEP\ZuG(	L«\0!n(yݩLLS+\r8*g&P-9?7bCv`ށH|ۙS8ksϥf,޹2eƊ;z0kE;L=Z2F6sTU8oɀa9j99o{0BavSzAZt\'uON9{HK\"\nASHJŢ$&B2]옧r#<zԉKnUxD+9|F	xze\'YNMDǴFUwyr6S ln	r&w+!^E4	9%QORS3a@]y?sAh\rr\"$K%ew;C~ǻNXendstream\nendobj\n6 0 obj\n2387\nendobj\n27 0 obj\n<</Length 28 0 R/Filter /FlateDecode>>\nstream\nxKoEǓ|6vWU?	CXC!8!Bā|{;͎Fy3]]_UqesmS2ߍ~o^7tb-1J6_]|zg!OoImf<\nm\'G4W56DCwlϠS\"z06P)l6ŖPR2 Lxz(%{ja*ul$}inPJ{M8nNR[/<I6V(;ϻ\r[	1S{s~=6s)M>qrͣ߄g\rysry\'C7>;sh56@Mx)yw:oL74V$=?g`Ϋ-fIDo+a8k(pAƝWPXrٶOd#zG!ݨe-CJQ}S/\\_<p}EOwKMt//\';8%nd;8rΏ\r%^@-bn\\$>pp:OKv;*G$9BA>قm`y̎vF!{o9.)rMA\\r^jhr{\'m4~z8.(y؅	 »U&Iz|^ >(nvy*:JqeVNV}wQS9HO{~II<\n+{䘰T-u5auI{<թL>(#vT,TEm\0Q\ZjB9G^3D\n\\F܃\":\Zkadˑ+~\0Sx6l9\0+lO%]V:uB oLGGҫ(B6CU2דu9ҡhmG:U椆Nt;)$&k\'k7X=qx:Tw:S>Xtx4[sCRdNqD|ߋ1>(+PD>,th9kQ*Rs7-J@̓R_]Poɋsaiq((KqBhbJkg\ra_k܏<8Awd#{\0܀F\"K%{e2z	獕vpt;\\=l:0k;_ѵxkQCPJɯDѱ\0K\\e銋W`ls\ZQ\rendstream\nendobj\n28 0 obj\n1270\nendobj\n35 0 obj\n<</Length 36 0 R/Filter /FlateDecode>>\nstream\nxZYo6~K3+@iq@>pҴ\"]خ`foT)2UuC6+)$+QYcT!ʠÓ\'7eH}Qaw0pkOj}V1hU>mVN[kkcbEQqh|n}}dW+:ٔ)s\ZGو\ni2X?iVVF֏1%_7OyJ\"l6;Q?>Po\0g[S\ZJ#,5V_>alRp]g0:VqYQp]MFi*\0C\n-GU\\h\ng01n\nN\0S\ZM}%vd	lA3\Zaԋ>{/N׆us +RbH笰IfXnRY0b^#3z==eG(ؐ&gBbTLe9#_Jnm,Nx3AhFv20б`{:Jۍ	qeqyɳ<g穔,Zt,Jn~\0/Idfl8WCcYw-ywl湤`aM1+9&ںhnp805˞ќEAviܲ$ff1j\\ܕ\Zy$9nBכ(r\rĆ-1x$s\\L},[sssԹ\'tE{s;z<]\'|\'$hO=^1^apk\"v<7]<ECG[v9}DKjKTP\"!\"k2atTpl\\$wQȫd	R33SrduoKhByJJeye]	/k<##>Fi鿥3Zmg	W07\rG&N$#\"^e??E[9Vѥ	\r>\'B\\yh.}ZBszJǼ\\\"ne=7R(~d趥ha^\nhF|tEܟ_Vdh\n\':]yk|o+īQbʔe0{}`_A0k,}&E-N.%g;eLy^M[$N %?y;p<;,͜Tcu<Qг9f|\Zq-i|	uVsnc)}<|ʕua7\"n\" fv4\"N)pW@+{ ce,nK<R.!K_K;\"6\"kQ j?2S`YM6%l	)X/$Vo}r*W\'h;Ezm7Q%E/-,96V7Sendstream\nendobj\n36 0 obj\n1600\nendobj\n4 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/ExtGState 24 0 R\n/Font 25 0 R\n>>\n/Contents 5 0 R\n>>\nendobj\n26 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/ExtGState 32 0 R\n/Font 33 0 R\n>>\n/Contents 27 0 R\n>>\nendobj\n34 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 0/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/ExtGState 44 0 R\n/Font 45 0 R\n>>\n/Contents 35 0 R\n>>\nendobj\n3 0 obj\n<< /Type /Pages /Kids [\n4 0 R\n26 0 R\n34 0 R\n] /Count 3\n>>\nendobj\n1 0 obj\n<</Type /Catalog /Pages 3 0 R\n>>\nendobj\n7 0 obj\n<</Type/ExtGState\n/OPM 1>>endobj\n24 0 obj\n<</R7\n7 0 R>>\nendobj\n25 0 obj\n<</R21\n21 0 R/R19\n19 0 R/R17\n17 0 R/R15\n15 0 R/R13\n13 0 R/R11\n11 0 R/R9\n9 0 R/R23\n23 0 R>>\nendobj\n29 0 obj\n<</Type/ExtGState\n/OPM 1>>endobj\n32 0 obj\n<</R29\n29 0 R>>\nendobj\n33 0 obj\n<</R21\n21 0 R/R19\n19 0 R/R17\n17 0 R/R15\n15 0 R/R13\n13 0 R/R11\n11 0 R/R9\n9 0 R/R31\n31 0 R/R23\n23 0 R>>\nendobj\n37 0 obj\n<</Type/ExtGState\n/OPM 1>>endobj\n44 0 obj\n<</R37\n37 0 R>>\nendobj\n45 0 obj\n<</R43\n43 0 R/R41\n41 0 R/R39\n39 0 R/R23\n23 0 R>>\nendobj\n46 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 47 0 R>>stream\nxM_lSu@S2P2ʟK׸?]+kծk{Ͻul]]EE\'&Q/D*&L$$&[y910|<TLX0{m ,t9ez{I=Kno9(9gҫW7\"K]a=o30B/O8EvPI\nbxX7̖Y嘿[ާ,)?C4T7\Zz^pd>ђi)\ZdaA^Oi4PbnNk\\\\.}z~JQuN\r)Pr4yQ\'PaQ)B\nrr;T!&Rge^X?8zPe̕4\"r\r3Fs󠉕C\'ѼzGڤwpڼJln:ř͋D|BC7ԫpw|VJZ$0%D aUU	/6bO-A2[\'xёHLL$`GIݠہKtQݏ}O>_qab<*b7>uF&5[NDMؘY5XoyZOLBTdB6wv+x͠le^p<\'6&}BڸK\ZJBW5/5ERݿXR%XR\0T $A=\'zUYʇ}<6sn\rvNNrVAo+Kuf7bl>nٴ<mܱ<@ȿ(\nendstream\nendobj\n47 0 obj\n857\nendobj\n48 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 49 0 R>>stream\nxcd`ab`ddds\r4T~H3a!nn߿\n}wn\\;*9(3=DAYS\\17(391O7$#57QOL-SpQ(VJ-N-*KM윟[PZZZXT_6Aacb&|0|];}k\neede-+Xfٲ5r|}c^柛\\ҽtiQw_>ڢ%3`82:du7sM2dͷNl;hziӚ{W94iPH&/i4\\/Oa`\0\0a~\nendstream\nendobj\n49 0 obj\n369\nendobj\n50 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 51 0 R>>stream\nx}{lSu]ۻ6e(1\"aQF`˘B$Q`s/Z\\qnn]\0Y!81hf[L1~;s>KSipiIb>XxZ& Cҡٸy+gR~uzUC\Z҂elE^RUQ^V(,RViKBѿȫR%EJRSܹNQ\ZR6\\LQ3*zZC\"/JWSvI(ɗҾGta	#Ih&1KӨ\'ʝ\rkkk	8ww6w\'0\07\Zŏc%`3U9tC\\?}`.Aaw2ulo4>AUx#rS&y|#X/rA.p8[34{Mb}6<\\>/\n\ZF:^Jrs#=BS4;QG[)s217,gq67,kxq08;|21JKNȖ{xXdw6.wCh~\02IH%Q\\T|#َF_9=d5J$!,:׎t~$`gUN=xq_9e|*qW	*S#ZobHd/7S*vpffBtR2\rXÊ\"ga\\o1opiHꂾ?{Yq<57j̠6#G0Ga@(D	`Y@҃G{|&N˧v)bG{+YDHj$I;L\'$8&tPvZyC>3l	.dvrڜ:JD\n)K>4-xC7{fI; sX.;ρ0g>@g۸lfSc^%K y\"kO>C,W0~E2a+	SYt,VbҪ\rG\'G$RVʓM׌-7CPĮ[\"w\\\"(\'lc5ZRR)s	VA%wd/K,s0rY[/VCvwn-:\\do-Jo}w\\:pre]dbc#LX:&ϘvƗAQ\04ؚ\nendstream\nendobj\n51 0 obj\n1249\nendobj\n52 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 53 0 R>>stream\nxkLSgiD=9pǌm:ĸ(\nrzsyNi؁s[eY01/ٌK^ĝܖ}{Oy~D I*(*z{Y`b691G71Wuˉ0rlLT8MC	=I{wkAuVn*Xh~mٲ|*bw~sQRUf>Mջ+,vb\Z\\\\j-{&;TW-6sQm?Ak*X[nA#/Lb)AkP׬f?!6Suqh[|D)+vuAQݝ\n218+ĀD\'Mtz##GGhE)vB{;@k>c_aA-},u?-A\n	laB\'$AhBLh;~\n_7hNI\0:\'z?nj\'GK\'P:J?BVET8ܢ\\K98\"pxc0]DbI9dԣ%s;mS3˭ C{~Dgԥjrra#;Z/QOd3r֘},urAp%Ȑ@=p#GB=qˡҪtr8_	/G|EKDW|{h?u\\,%^?ivKrnSʑEi8K\rTԣ%TbKWeJ_߀u\Zz^	4hRcQgK?bE#3Q\ZU4jF$OiXimY\"*ziÁoX$B3[Uf]~wVFņVhdgψbC z8Ь4@hEr >zB%Iv)]\ZnW\'qGK\r2jz@u9?$ HJ[($Uʪ/\0\0lDAiXUݤux;H/m\n͌UQўpEzw84*˝l|bR?àt{rQ[^<\0Z֪*$CPIګhyԇ&Sf\'lۼ͖	Oũظ+Rq\Z\\i~qn\n̍81Ƨj%pJ^l5xޠ_\"L 8t2jodD&4M_8`\rk0N|NsՃ̧{p\0*y\\KvnJ],f\rB.~JgRSF#A\r\0Ԅ\nendstream\nendobj\n53 0 obj\n1293\nendobj\n54 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 55 0 R>>stream\nxcd`ab`ddds\rT~H3a!+k7s7˒;~n._PYQᬩ`hiiZXX(\'gT)8(t+mv-(-I-ROI-K,*/ȠPİd1J#30>={%EyyV\\dfdciRt+`-.+=[?QKn.7PM`mwGIzN\'wOد3b	9ZۛV\nfr~Nd[|><<\0?_\nendstream\nendobj\n55 0 obj\n376\nendobj\n56 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 57 0 R>>stream\nx=oluǯ[2070b2iPqY$v!hRݭ+kHzzW`cP7a&ԁYLF	 $ 	xxՄ\'y\'O|1f5;ZP{Qz0zrSFiiTZ\'v86nunDP|{7m[s~\rxs3C\\#>2	3c3xT0wlj\r+PP쭫W/U;9K\n6%zyho\n3}ǱDmlvbSlxx<IeҙhIdAuY銦P,QSJٹ?.<{e`/cpx\ni	?$o\'Dn{`\'>[_|_ȔҔh)(Uk\ZvrV$A Hߍl/.l+xW[\"^<K5>|2XaHIu҂JT*bZ]^\\ֺsֳ{a,I	X:kx\Z~0paK[RJ%]Tzamڑ2i\"$&db{o	Q\rY\\Sr\"%Ee_ڲ2̔)h9y\'\rS.؞txGp݇ʏ_^9>ubdt44gB6_? 閪GD(%[bW7a7k1?}	݇vwL\'≄(J(lVI3ySQfhԍ+T\\aBFa6`^-qr|f3\nֳ	0N\nendstream\nendobj\n57 0 obj\n853\nendobj\n58 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 59 0 R>>stream\nxWyTSgH-jm{/^U\"\n @D @DdH \n\"UBkuF[ZZ;~a>t.̙3rGrΗ{y}Bl$m]=?LKZ߳/\0M{jxoؾH7mt@3t[U\Z(	;Nu8%R,E9zH\"q$\rg;H$^uǊe]qrC\Z$E1n}bT4(Z,\rIDS͜;>X\"gE	Ob	Fl\"܉O5fb-A$6[1N Xb$1`D$1xK\'(b;񂔑mlZKA/l6Bw^-JOt[*{.<M}!_]2ǯBb6nXzI\n?BF*TNN#j?P9j-zCUs!|Ғ*VURj2V.\nlE&m).?zYK[R@\nPjlPfegLc TYy}Q\'hD//C(\Z(3S2q[V*ViA=](O}rsZ:oH4H=6m0ݒG!P\npXO*a\r+ڴ9\'k:|kʡ_<}g#7BxPQZ3Y|\"dc	ՆK-f8y5\r! \ZRPԻ2Yۦo9BSܻmOeM_!on\"k1hWG᯦\"4򧟐7\rD&fM\'Btu,m.8\ZxNo7}TSL(\n\rֻWq\Zf[[:\n(PuwDP펗*11-p;T<jf8_#.J\r(~\0o&D3UBļę4\ZlhĴn\01MB#`ˬ5L3f0Jzb?quC,-T#yiF?Fn	Q\"S7~<e\n\Ze姧dkIջa;512h23<j̓ն|}w>Z !ԚT\rUu#6DrVJvjs:5<\Zn\rSC֞Eoןh5cJnKSJ#mPY,H:EUI~CE%0OFWzw]HnN2VR;F!_:oU6\Z>\0W/F[ȕkJ@?r9LǵeAYo43e!9@)u1s\0\nRԐªYJI~1+#Jbzɡ=iTg LI1>ʪkSNDvAzQ~NNE9_XЪ2DshyxBM\\YΥ$&oe1t!BHesR!UpE3Gr>M=!o?QnS`Ez=hYܭ4ɂ\'R)tt-{k)<yՆ7.fEߕJLUdz\Z#%rYTTRg4ֱx\nUrA&M@nǵcPxmmva*oB]aZ\rhنߵЄMOL\'hIM:^tND$]5ꖝy\ZDA-]\\8Y\"=54n+?F_w茹Ն\0m.˝~J)a[H(c]N0WDܱ䕮hV>w,W07||D-`	l5=O^8Sꏁ#&o n\';hyRz\ZSwFr{70P9eeV ~ 66% Z߼O3ڛB\\ͩCh\Zy.+wO<WLnfψx0`lw;<YY./W[pG@|l\"\'r}4u*KmE6=\0O$Z\rYJMDfO<3Ȟ~\\ـVZ\0-c fgVGCg~s}n0oga\"G%DΧˍFXsF[bXk[}uR+|=uW󿄻4L$(mys\Z):ry=مGqNiX&mlm[p[zG2&VzX\\t_	JFH{\Z!f\']!}`I*`7Z;PYJ4( 0%*I嫗x,UGUdx$enBJwQ!Z_섗4fܹZ\n*\Z+%Y*deLImuG+c)D%قH$y)@;U3!ފy=~\\cĻd(Yn\'nFß<|g}p|A	y.T\Z\raluE};.sPuZVCk24Sv\04b\\7ƈ^уN$`[	^â\\I{7%Zѿ￴L\\BO\Zy+J{(@Z/1u,K}qAfnVV:C!ݚ>ߊ<5oTH6*%u\'~\rxv<~\\HOpoɁ|h}mq%<:^\Z89H\rCC}BB#<P\Zs	^v՜m?zhͮ\n1	fsEyιGXlDCݟ\"\'h\Z9QʡakRk5jAĳv8V7jG,ڹ\'z;\Z/zouc4\Z5$l6tUʌ5AٙH#jO/7;vm3ZHp򿝳i^0RB޷\Zh*VURa8ۚU@	s0.jKWb\'Ǌv\nДJDwޤu07N 	Μ4:	Og7yqI1=>@qE??}Q:\ZOyDVk+/m^jo]4H*}26Kl_Knpq@,Md3_<AV`{ɽs?asԇ:Q/*#t?DARdWajl<\Z|<:Rbc&G?Cf<i8TqW\Zܴ\rO0\ZWٻ@QBPDYzvo{?\0z	2\nendstream\nendobj\n59 0 obj\n3564\nendobj\n60 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 61 0 R>>stream\nxcd`ab`dddw\r44\01UH3a!;nn%ߛ;~wn+_PYQᬩ`hiiZXX(\'gT)8(t+@v-(-I-ROI-KMj+I,````4c`b`bdd|?ڙr8cRV?aZ:%[&͜:qr|/d-0}3n9.<g00\0\0j>\\6\nendstream\nendobj\n61 0 obj\n268\nendobj\n62 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 63 0 R>>stream\nx}{lSu] :10*M`\rID#=\nlu>k(`-4&?#\"x11ނ(~rr>=?RP4M3EEut<+%>[?\'Kd(R3pt\\1\r?G)hp;=\rƪJvaK%+Wzcծ:mQR_[j/5ڭ]UzS\ZmIbDOo4u.0oEr5k+9\\j5ZBP(VҨaz=eJqʄ噇t6jCŻX<?Jcf*UE+mGG}0a`J<\"Ux`B^?pv,bUPۚ`?﵇|0E\'D\r68X,e?}B{=hbm\"OFL$cx<F\'޼k*GВ+CF2Bv\'S-v<+fbꭰ)QO`\\|#;H\Z1oЯzG*-U(uHusq0+;9N[VFYb	.FHL)vfM#*j&fÙd2?sK!m\nf&Zl6IRL嫿,_vB+g\r\Zbp(wX|M\"h	X;sr08Y%	=R~aq&;[IN+߱|<KL}2-9x/p#8)oBfs%&̲οE]I.P/^1*m<\r^mn3\'!tްƶz@~}L~Átbmr\ZAEMdۉN.{jKؗJzȺ}? \nK4H`a]V9ֺ9xk:3G,ׂk:^&kN0zm9vE2\'Oztf@vr$4SQ<Óiߩ~göݍ 8\r*]5Rz:&5{BA@y3<W1m2Q8\0u|M<FK%vS-Q236dMR͘4Ƞ\0e\nendstream\nendobj\n63 0 obj\n1212\nendobj\n64 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 65 0 R>>stream\nxT{Pu`YNvKC\'|`JR\"Sf	\'Rݻ(xc:eik1%98YǌnPk鏝ٝ> ДȠTP?\npd=>&S(M._RT\\UNKHXK.Зdҳ\rQY7TK޸Q2TR_/)NRTP\\fЗҋr%E,Z85Q/SPө8j*5DHSvz	}:huШRސ\r(>7FPMΒܚuBPZ֦>#d\rriijmJp,r0ry+#[J1BE}I\0xcth!b\'86v#+4h5\ZٍGBF)Bt7G=BhbB`7#?0vBƱY~ǃaTN!wƷn;Ԃ.ul5? ɽGVi]+͝\ZV8Ԁ(	4,2Ysf0<y*c|[*_QF`sMk/bhq).Ûp5N@aF1/}yp}(lDUl9SaQjFjͫBI|s?Ol`#ov\'~zqOhuMPYGgkPGx0gbnD\0̹jLÎ2F>W7q_~a,ai?O\"|:IDȾCg5(A_N/F|tb-J&\\_.)x4ucw܊yOoXGF1$qJANdV:hR~	N\"f3hGo5(/1Cv갸VwՆN3*l`c#9\"=bzWaB)b,v3XYbv{$WudeJ@;.3ʻl Zx1clǶ1= IX\"Axȇ+_M[\n%0ljT*P< Ehnqo⁍eNǜ#4D؄b^%ιp&+0\0M$^D0@,P@\n.ր0}\\`bEuUSfjqkVn:w)p8O9p5?Zt\Zq	13aU7ݹ]rqCHfjI8-WY唤V/gjѢ)g[yCOcNO+$akwFNdlU``6KJSuNٞP_؅z]\'Ot\nendstream\nendobj\n65 0 obj\n1367\nendobj\n66 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 67 0 R>>stream\nxcd`ab`dddu\r21TH3a!G&nnu?ԅ~7-_PYQᬩ`hiiZXX(\'gT)8(t+,v-(-I-ROI-c```4d`dbb`add?U|V3[+x>w?~foݨ{]M<1}r}߆_~Ѽ\'NC5je߾~QE}GS[kOjv/~ktn7Nm]WWw+G[_[~\r4)Y{ӏZ+ۻs<Uӻ9Rؗv>O/{Vw\\B\nۡ݇fvM	*3-iYNƾ|Փxxe`\0\0g\nendstream\nendobj\n67 0 obj\n440\nendobj\n68 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 69 0 R>>stream\nxWiTS!@%ԛM[\\ږ88RF0\" 	 I Dp@DZ[-PZVy7gGޞ{ܳ^~{y>ekCD\"ɂU띧ZG7ld;(oHEX57\rɃ)HxqANwr3gP?0U>A>ӆpqNwD9WC#\nUaE߾:a\"Eຨ%;n;>OzwTgigOQ[5Bj-BSPK1j)5rQ(wj9ZAͤ6Q(Wj5G)j5rd\ZJ\rFQ@(*MiEl\"Fvmr~Ds췭ߑ*؋u?:,qP;:JtqRh;͠1Q-1?ﰕuXhM6\ZC1rڢ-jҒp\"FSz&2GT6BBGji!tzPA8W4<mwbpn[[j1A1S[xBٳ2Xxm.Ba:,1Ҟ*X*v}T)APRp%ҙHMBn6X\r%u\n4ySe\'I9&jTfha}թ,4ܦȐ)\"G80/o5\ZYIl~g-s/h9^2SMxঘ`&d\"\"Cl\"C\'?TF\"\r^ƈ㊣4@tT:j<Gሲһց?K>@U&e?-Beä	Oe4ͷЋfq3~;Ҷ0JQ[	K?Cck\Zm-CO:٬>Ш?_sh9TВ`̏\r1=`YDF5?Z	=Z],0#y\"mZX\0/M_uЦnhh:+ML\'>fSeFWASAڭ` +G;l$?EaväִմsĎ/=%\ZA6kWg?#	2>|T/7N+\n#kz\Z	;HŚ2@\0fh:Ӓ5{5\\hg[@tc	Fgd[<#!?P/A楏=sYy}U\nz+@#Y(qדQLrd9:?D[e%C}ᑵ38vM֘X&r\\θcmŸ͢B!#ĉER$KJ\r\n&8PPqѬorrMV}5V8f,;kS57yt=N*$\n29ڕ5Bv4ܥXT\'Ȝ1Ed%.T1KQi{^^!\Z$Bsײ}{λdQ˝ژ$d	RZykRD*Є}wsO\\A+I\n΀U\"300mHۛ̸)Y]̃\Z\\RCdhUi*HbʲKjx||2L^#/y\';!.i-1kCY\rk훫ejAY!E	%7v5>F[pxaˌL|Yt0x/fp(DDE%]2OHrK\ZYѤ)GA*YwKu	PȐ͹^g\0ߘIr\\țoȔgBNf7 VpJ#6$]@bE5ƺϺ|#h5ʣO.2LzF֔~c,`6<]L]nHp:Rt2^Ҳ>ǴFAHӡss|r\rK΍l6YrL+lS\0YeUi\ZH-SINWWB@yë\\mduvBEhcuS11ffW \'?X@oɿm|RZ\rX<g	l_>0Sġ+ݔZ7M(,`U\0[\"M_Nc;-uqϙ5.2yRz:$mR1FdF|(OZw55`3uH[myW*$9Nw&$5\\tQvVF!3`)+ҋ=\'hx{p%NV\\M\nZ]B>g5q\'!Va+#\"#LjVkqaX~73_ KHKbzƶ%[O+@=#hF\'B,zQSϗ\'Yok<sEZ4Dʊ2\rPTb\"7	?{dޞɶ5QaaQQaaQ55ַ\\z\n#o51=gۋX3K\nqfQNRHy\Zc: j$%K3~)4G9f,tLAȏb.(gm6Hu΍֐Ш*-]Nl6@=&(xݠ=^9&8|_>\0\n 373yŅ0wN1.Yӝ֛,ěex09\\vgw]6RL*V`~˝Ql)RUǲdAC46noR\r9=\Z+K\r>qUm>\'UՋ+CPl/R=v,=iϭ\'?is	(|\rV5O~~`aR/Bqw\'	\r,~ Lt9U4!eW^E#nAY|SǠ!¿7c=BfMN5)WD5\ni2J>!_7DΉIa}|	!ᐂ3=Ktl3I\"be|b	;O^̾̌l=w	o\r࠙_MYd: sB0;Ij&53}_ݿSY;G1zony\"\\fbV&_jΤdg/F5EDFD4ߗgUkΉT5=GJ/[t[n?VzDM71G86ye]\Zp8>ys9\r:kk7	$<܇O\"tt+fW6.o̅0V$LZ)\\^-rT\04+1e+@-[b:Q*\":P,K3a\n/8+Y٢20b!I11eP?laJwIBJU%*>\":ywtBpZhמ@H0d)NEx<%׉?eچQR22hjY瀹w9lmGHJ%p jOKW_˱͎-h;ܧä#QuKL3w`Sl`9	2K[gA0͟(4\"m;\n^m&jSTP\";*Ѹd<ycqO4	1\rDko_B]wqwI{q8~Vи7W0S^`*>t{d(%o#9Ā(}i?bd8\\aWBԢV.w*4\06V[C|,+$br_أ&RUa⻟\Z o;0)w.@{\'6:\nendstream\nendobj\n69 0 obj\n4038\nendobj\n21 0 obj\n<</BaseFont/YWRBPR+CMMI5/FontDescriptor 20 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 1036 1037 996 0 0 0 0 0 0 0 0 0 0 0 0\n875]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n19 0 obj\n<</BaseFont/SZBQCB+CMSY6/FontDescriptor 18 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n963 380 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1222]\n/Encoding 70 0 R/Subtype/Type1>>\nendobj\n70 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n17 0 obj\n<</BaseFont/MUQRQK+CMMI6/FontDescriptor 16 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 924 927 884 998 900 0 0 0 0 0 0 0 0 0 0\n780 0 0 757]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n15 0 obj\n<</BaseFont/EFYKBB+CMMI9/FontDescriptor 14 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 771 778 734 848 756 656 0 0 0 0 0 0 0 0 0\n0 0 0 628]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n13 0 obj\n<</BaseFont/SZBQCB+CMSY9/FontDescriptor 12 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n799 285 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1028]\n/Encoding 71 0 R/Subtype/Type1>>\nendobj\n71 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n11 0 obj\n<</BaseFont/YAUXEU+TeX-cmex9/FontDescriptor 10 0 R/Type/Font\n/FirstChar 16/LastChar 33/Widths[\n614 614 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n814 814]\n/Encoding 72 0 R/Subtype/Type1>>\nendobj\n72 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n16/quotedblleft/quotedblright]>>\nendobj\n9 0 obj\n<</BaseFont/GHNQRB+CMR9/FontDescriptor 8 0 R/Type/Font\n/FirstChar 12/LastChar 121/Widths[ 571 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 400 400 0 0 285 0 0 0\n514 514 514 514 514 514 514 514 514 514 0 0 0 799 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 642 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 514 571 457 571 457 0 514 571 285 0 0 285 856 571 514\n571 0 402 405 400 0 0 0 0 542]\n/Encoding 73 0 R/Subtype/Type1>>\nendobj\n73 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n12/fi]>>\nendobj\n43 0 obj\n<</BaseFont/GKKKKC+CMSY10/FontDescriptor 42 0 R/Type/Font\n/FirstChar 54/LastChar 54/Widths[ 0]\n/Encoding 74 0 R/Subtype/Type1>>\nendobj\n74 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n54/negationslash]>>\nendobj\n41 0 obj\n<</BaseFont/WSXSQF+CMMI7/FontDescriptor 40 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 859 863 819 934 839 725 0 0 0 0 0 0 0 0 0\n727]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n39 0 obj\n<</BaseFont/GCFFPC+CMMI10/FontDescriptor 38 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 750 759 715 828 738 643 0 0 0 0 0 0 0 0 0\n642 0 0 613]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n31 0 obj\n<</BaseFont/EMLRVG+CMR6/FontDescriptor 30 0 R/Type/Font\n/FirstChar 40/LastChar 49/Widths[ 481 481 0 0 0 0 0 0\n0 611]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n23 0 obj\n<</BaseFont/QYXKNE+CMR10/FontDescriptor 22 0 R/Type/Font\n/FirstChar 40/LastChar 121/Widths[ 389 389 0 0 278 333 278 0\n500 500 500 500 0 0 500 0 0 0 278 0 0 778 0 0\n0 0 0 0 764 681 0 785 0 0 0 0 0 0 750 0\n0 778 0 0 722 0 0 0 0 0 0 0 0 0 0 0\n0 500 556 444 556 444 306 500 556 278 306 0 278 833 556 500\n556 0 392 394 389 556 528 0 0 528]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n20 0 obj\n<</Type/FontDescriptor/FontName/YWRBPR+CMMI5/FontBBox[0 -22 975 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 146\n/MissingWidth 333\n/CharSet(/A/B/C/P)/FontFile3 46 0 R>>\nendobj\n18 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY6/FontBBox[0 0 1128 432]/Flags 4\n/Ascent 432\n/CapHeight 432\n/Descent 0\n/ItalicAngle 0\n/StemV 169\n/CharSet(/periodcentered/minus/arrowright)/FontFile3 48 0 R>>\nendobj\n16 0 obj\n<</Type/FontDescriptor/FontName/MUQRQK+CMMI6/FontBBox[0 -21 944 714]/Flags 4\n/Ascent 714\n/CapHeight 714\n/Descent -21\n/ItalicAngle 0\n/StemV 141\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/S)/FontFile3 50 0 R>>\nendobj\n14 0 obj\n<</Type/FontDescriptor/FontName/EFYKBB+CMMI9/FontBBox[0 -22 823 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 123\n/MissingWidth 333\n/CharSet(/A/B/C/D/E/F/S)/FontFile3 52 0 R>>\nendobj\n12 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY9/FontBBox[0 0 970 430]/Flags 4\n/Ascent 430\n/CapHeight 430\n/Descent 0\n/ItalicAngle 0\n/StemV 145\n/CharSet(/periodcentered/minus/arrowright)/FontFile3 54 0 R>>\nendobj\n10 0 obj\n<</Type/FontDescriptor/FontName/YAUXEU+TeX-cmex9/FontBBox[0 -2957 781 45]/Flags 4\n/Ascent 45\n/CapHeight 45\n/Descent -2957\n/ItalicAngle 0\n/StemV 117\n/MissingWidth 250\n/CharSet(/quotedblleft/quotedblright/exclam/space)/FontFile3 56 0 R>>\nendobj\n8 0 obj\n<</Type/FontDescriptor/FontName/GHNQRB+CMR9/FontBBox[0 -249 833 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -249\n/ItalicAngle 0\n/StemV 124\n/MissingWidth 342\n/CharSet(/L/y/n/c/zero/o/one/d/equal/p/e/two/three/parenleft/r/g/parenright/four/s/h/five/t/i/six/fi/seven/comma/eight/l/a/nine/m/b)/FontFile3 58 0 R>>\nendobj\n42 0 obj\n<</Type/FontDescriptor/FontName/GKKKKC+CMSY10/FontBBox[0 -216 638 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -216\n/ItalicAngle 0\n/StemV 95\n/CharSet(/negationslash)/FontFile3 60 0 R>>\nendobj\n40 0 obj\n<</Type/FontDescriptor/FontName/WSXSQF+CMMI7/FontBBox[0 -20 893 713]/Flags 4\n/Ascent 713\n/CapHeight 713\n/Descent -20\n/ItalicAngle 0\n/StemV 133\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F)/FontFile3 62 0 R>>\nendobj\n38 0 obj\n<</Type/FontDescriptor/FontName/GCFFPC+CMMI10/FontBBox[0 -22 804 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 120\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F/S)/FontFile3 64 0 R>>\nendobj\n30 0 obj\n<</Type/FontDescriptor/FontName/EMLRVG+CMR6/FontBBox[0 -250 505 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 75\n/MissingWidth 416\n/CharSet(/one/parenleft/parenright)/FontFile3 66 0 R>>\nendobj\n22 0 obj\n<</Type/FontDescriptor/FontName/QYXKNE+CMR10/FontBBox[-40 -250 813 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 121\n/MissingWidth 333\n/CharSet(/y/n/c/zero/o/one/d/N/equal/p/two/e/D/f/parenleft/E/three/r/g/parenright/Q/s/h/G/t/i/six/u/j/comma/T/v/hyphen/l/a/period/colon/m/b)/FontFile3 68 0 R>>\nendobj\n2 0 obj\n<</Producer(ESP Ghostscript 815.03)\n/CreationDate(D:20070703183217)\n/ModDate(D:20070703183217)>>endobj\nxref\n0 75\n0000000000 65535 f \n0000006131 00000 n \n0000030018 00000 n \n0000006058 00000 n \n0000005548 00000 n \n0000000015 00000 n \n0000002472 00000 n \n0000006179 00000 n \n0000028466 00000 n \n0000025405 00000 n \n0000028214 00000 n \n0000025108 00000 n \n0000027997 00000 n \n0000024778 00000 n \n0000027776 00000 n \n0000024576 00000 n \n0000027555 00000 n \n0000024374 00000 n \n0000027337 00000 n \n0000024044 00000 n \n0000027122 00000 n \n0000023852 00000 n \n0000029677 00000 n \n0000026729 00000 n \n0000006220 00000 n \n0000006250 00000 n \n0000005717 00000 n \n0000002492 00000 n \n0000003834 00000 n \n0000006357 00000 n \n0000029445 00000 n \n0000026554 00000 n \n0000006399 00000 n \n0000006431 00000 n \n0000005888 00000 n \n0000003855 00000 n \n0000005527 00000 n \n0000006549 00000 n \n0000029221 00000 n \n0000026349 00000 n \n0000029000 00000 n \n0000026153 00000 n \n0000028795 00000 n \n0000025914 00000 n \n0000006591 00000 n \n0000006623 00000 n \n0000006688 00000 n \n0000007631 00000 n \n0000007651 00000 n \n0000008106 00000 n \n0000008126 00000 n \n0000009461 00000 n \n0000009482 00000 n \n0000010861 00000 n \n0000010882 00000 n \n0000011344 00000 n \n0000011364 00000 n \n0000012303 00000 n \n0000012323 00000 n \n0000015973 00000 n \n0000015994 00000 n \n0000016348 00000 n \n0000016368 00000 n \n0000017666 00000 n \n0000017687 00000 n \n0000019140 00000 n \n0000019161 00000 n \n0000019687 00000 n \n0000019707 00000 n \n0000023831 00000 n \n0000024259 00000 n \n0000024993 00000 n \n0000025297 00000 n \n0000025830 00000 n \n0000026058 00000 n \ntrailer\n<< /Size 75 /Root 1 0 R /Info 2 0 R\n/ID [(<:j85T&o)(<:j85T&o)]\n>>\nstartxref\n30129\n%%EOF\n','1 ; 3 ; 6 ; 23 ; 0.000000 ; Intel(R) Pentium(R) 4, 3 GHz, 2 GB . '),(215,'% Definio dos dois pontos\r\n\r\npoint A 10 10\r\npoint B 90 40\r\n\r\n% Definio da recta\r\n\r\nline ab A B\r\n\r\n% Desenho dos dois pontos\r\ncmark_b A\r\ncmark_rb B\r\n\r\n% Desenho da recta\r\ndrawline ab\r\n\r\n%Definio e o desenho do terceiro ponto\r\n\r\npoint C 40 60\r\n\r\ncmark_t C\r\n\r\n\r\n%Definio e desenho da circunferncia com centro em A\r\n\r\ncircle o A C\r\n\r\ndrawdashcircle o\r\n\r\n%Definio e desenho da circunferncia com centro em C\r\n\r\ncircle o1 C A\r\n\r\ndrawdashcircle o1\r\n\r\n%Definio e desenho dos pontos de interseco \r\n%da circunferncia com a recta\r\n\r\nintersec2 A1 A2 o ab\r\n\r\ncmark_t A1\r\ncmark_b A2\r\n\r\n\r\n%Definio e desenho da circunferncia \r\n\r\ncircle o2 A1 A\r\ndrawdashcircle o2\r\n\r\n%Definio e desenho dos pontos de interseco\r\n\r\nintersec2 AA BB o2 o1\r\n\r\ncmark_l BB\r\n\r\n%definio da recta - paralela a AB\r\n\r\nline cbb C BB\r\ndrawline cbb',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0,\0\0\0\0%	$#\"&46\0\0\0?\0\01c1c1c199TSߞBQ샲S=7@Z]$&Ԣ6RBM(p\ZhUcO.cϩTkCP_(V}|M>S7m=宓H0g\\P^ac1c1;!˜km:P<j]7^YC+bWu	 9bI6I|c1c1c1cjs傡)%}p=̭\r}i\ZEL?Y6$/Ͳ_^%53^x&1c1c;sq#;{e>GA-.1/TUK;E!+ټe/y$I[F}{0;X]iK2v<F?ttϻ۶k\"wCpOވ,A7s_}O{Ni/:xKI)֠],t(]DtU96B$[הU	12{)2`B%\'!Y=y=oeX1c1c1c1d3yιEg<NsW7c\\IߕE+m=ȫ[W<c1c:L.L	RAɣFE@\n嫁B<J!1\"XY4MY7l`~^~;f\'xK8[FTug\0f?7`s;G(IJ֎wIMtfu\0I\r_ۤM7aw]b$MN!nHy\nn7ID>V=67flH_mHeޙY:3ͦ͜B=4x4]|c1c1c1{#e\n@|i AnF\\rJ 3AQC,4qIz{6?k79uqZ\0MjT*ӾFU{dC$TOz=j\r\\:#Sw}ҿ93˖&æ,{]:K.I]:,=hu3ex2WUTT3I&4x׮5G:ɏ\Z$m24ęiO{F1P_Oˬ;9C)GQ[\nr<)\"٭2Sqd痵zo-m@bk`56YcTZj4)6#Nq]Ԭ-jV3&Kl tA0xH1c@\0MMF2}5|>LW\'>CMaтt}C9mR	 o⛸ǥ{4Hjo3k6;ٻrzi\'Y}|d!s\"ho/=U8Ex-{Ӂ.1O7cW^ᴋ\0:yYemY}fc1c1c\\/j\"\'BsJfWeR%זEg\02SbHl)E3ޮM|k;b{&ɕ\'sZq\'un}%\nmΒ#-yˁS\0G\\V>W*ҫUzߘV警Æ\ZzUè؂,\\r+JdTظ{L6\"j_hq	+Beqe֜a;6AFX o` #n瞈BcW}AUXz#]5؂sIfi9<sM\0e}X8-FߣzQu#azc0=y_0NqCEOkl##CxV,e4i!Üd%m,dϮ=cOh<iι\r#e]vϔ`TϼxMXa;yce,M7Y!K}L6\07X{|>hfT#Վ\\o\Z$M5D]N	iެ$V4Mۯٙ>\\v5-DV]CӀ{\nb5q5T)ݏt:+5D>F譏`<7K@.,c;Ҧd22=օsJupVI}Fbcofx66IH *9!5kPѸWdPAY?6ĻPUz;E=6sh̹Qq{eqc\'}#s>g}BT/`L\'%Z4ꊰi|gh2zv7Qׯ$#hfp+\0˷m!FNǈΟN{vqDNnߒz)[H&vIq`Im%\\xIti#%!Z류uںs˾1=cR~nj<(Up`t&&Oe&QHD$6K\'\'m̫1c1c1]5i~o#Jn%uSDn!l[*QPe]0/NaNk]|x*cuԀ<;M|(mu\0j>JVhI_<lB(,#|Ǚq~I\0=o(}G)j,mtqmp0rJ 掏0M801coOò.UsiQby3P杕TR3*:Rq,>Q\Z\0)Vag\\<r5;S_p;.T9Sc7u,VRZP/7zIV[=}EjF1Zi)̔l2VY]hy+l-bZʛWLa_8}-bS^HoE\'{ޟe\"Yެ[}4<0C2yC4o/鬔\r	sɒˏn)TL4dT\0Z$(4\"0\Z)H(%IeHo5jfUmb}žoeO.VyKcCv3t{䔭hx4ށIo:7\\J\ZԟHqfyv-aK${D䉇y$NwmϳhCvn&to]UfԍXz镓?X<ik\\/#@ǃM5&1c1c1cu{_9vDXkIϙT=.6[P*Pɳ%/\Z\\[7κFiVz:)_k$b=S`w5VS:U`:\'1c1cM\0Qz/81YLW]dJwP.X4u`@\\\ZM5h5ӈo[ԗ*ȂCU߷@֪cʺul\0oMj!1GZ6%\0ʲǽO8sCGRxZjOUwQuk.Xe.`1^\\ߢ\Z@yݙlȽ-=jn!Qgͬh\'fǾ,Ps`]3If#=xydiӺɼCX:Vߣ,N\"Py<N]{,\0gݖQ#[e}1c1c1cά)\rR\r&sbb+[kj\"7R2%?!U]tQߩ>%yvL%=jl^\0qϛ@4-4l/I{U4j2T/EzXPy &Jq^$Z4AiZkgc1c1\"L=9iZo4{2Dq0&	>7z%\Z݌\0B\"}m齻zψr8ލpuL;{/.6NSiڳSKD*;ru?_\0[V\npC\0@pcι\r@K^.֞dK\0\"v+z20{05<z t>#2ֿ-ƪVxy$=1+\r.D/^l޵\\ڌ1ɽWojAQWz\\k71۝l\0yZ_޺E}mj/a_d%M^ \0&a\n9&S`C!d4q`bm51c1c1ؘԩ4z\0 \n⥈gn|{P\0<PQj$k;&Vҭ|>>#NUn-@xc)2iHMH@Ёt>r?oFF5n21c1cιB<\00L!AbJ(7yHMmt|>>	S.{_p~7܂ͽO	iK}1q)LX<\'_zov[\ZJ+^~*a\0	鶕{Iz4sǾ9\\&VBE6M5y:U.,iԯkCm\nR,[x\0F3ƱR[ϪvU9Z#gZiZ鶛18RkɏqgXX4z{vv;VS/J8Pw-}Ât\r5>I:&ӌŧY[6ǔzFN_8EL	}8CVUY\01k]D[Ȼ[\rX۠obVo4z+=Y&ϠmRVlJY1c1c1c\";|]jBwDqYo#O.mC(\'\\$,^l*ͦU2\0^X\\>,me]Ҍsp4ѵs1t7dȒHeB\n}d-ƯS)Aͱc1cEN;@5,16ΏqK+N<$Ǯډϖج5$(m\rWA/ymayzM+y\0{׈I?b1؉Se;^54,r=ȿ&sW߳(B`!}ݒEQc\Z SָeiP-9t[WXm͝M#HX]tM5]4_<]4_<]u<_<<<<X1~[ZWHBȬZo֢.F}1E҄oD\rů\n}}+,zIt+m4\\y\rb5/Mbvk*Fz媂ܸ[q־ŵyx+vmev>{o 4n*ëksj[OWf= ŕL)PBN@ŻwC-⒯c1c1dO޺\nV\'&aޙɬ[2snYKUtbGs	&D.Spa/BLޏΩ\\GR#mG!f2m&~1d\0@v&kSWU1cO/W\\0s曢۬j \'x#UDkv3=w.<셮o5ף};nI;AJҷ`.هqJ:<V{ƌ7E_&Mo=[I6}!ٷ<_uf}	xlMܻecvN]CTԚ?A4^TVTE(s:V<Eqc@-~[ɶȒѹCPagBe9:l,&\rp\rC72]и7vP[qVmtktٓ{khz(OCJ/|D~qL,|wKҧխTnSz׶j7ka[,i-.aGZnuJ1cȺ%Dxm7:.;y^thv$CZ\0yp{N#J2\Z[>\Z30yN<SmMK+Wzhf9\\-oo<Ѓ\'ќFHV8l{UKJS%\"AI.¿5ZF/;1$TpEˬMqE\"bI}<i}L+\'YNDtk \\p\ZvGaq$<g̺ܺEzLzwmQ@V+Vx0/kR1t?Hޭ@^S%dCjʑIw&ȁ90ytCe\nYTN\\Way=p%=uv%Rt-Wؽtu%J.uͼ/+槿Om?W%ר⢙>D6kU+2A;j\\Z=AA=L3k-R;{tnΒx$밧]#3(0\n^3Dm9XhF`@(bĖax&C<[1g\\^!GPӘiO m1%Li<QEIkkXSln?=^HmA}ާ\r륾8[,qړJݯNkS|kX\r%ou?l\0vQJ\Z9h?iS\"p\0˦\Z]M4Wv[5!)-@`mͣ1co\0aޯM-Q	V5^Ril2&Pt	?ʫ!N\'ht{\rKcݼ\nWPYdi\rIyFzULzbqQlbXd%l3z}+RQhT[j#zΏh%:i̮hǉh.\nDSx3ɛ(1c1c1+ivzs\r~LFcs<\nUEK+1O\naѡ@`EHK91\rN{U:t1Vmkʩ(ktZ\n^UI.wop^)moskZn_,p=6SjN $Ho+b+\"6Ckq(Y$nܷbvs.ͺ75D̤7 8[\niIE؏=Aamu=t^Y$׹x-ԡKN$icPZTEX7]3[L&U\\b0-\"Xx	YauxM=I#MMw6|s]cZ\Z!:+qSK,9(%YC)g<emGd\"?egG8ߕPcamDlV\Zwx}COBݫ ɼö[ҼZ&mrM\0z{\0slDܯ^H\Z9d_9o~~!cmz\rqԩ\\2l{(}-+ɬk6f馑qqǮiikkkkyyyg,c1cȗԡ!+s~h81Y[g;AA*bwO%P\rJmNIǵk?DQY6;1|!;b*\\<Ml\\%+<5v(KWN&#5MVY>QLe\ZY \"	#7}vc1cnu@3A[5{B/ڟv] UuBv&LUVu.l\0cHQȊ9=	Xf]}H6HmM]v=>}:op\r\\ ,fѳ6Zp$ 2m[n|W趫,%j+h6=L\r\0Qowo\"-Nk7\'ۻWH:o8]F_,*uJ➁hMƘv(ϧqPǀ#uO.j8*μ+&,q֖ȼ$\0}]Wy<\']&kFv\nv\rU5n]buy-\ZAnM4=]o{/[mCoy^ySl-<؛#v	5?<yͩ5.Xi	K%Щ9bQuy?&\0_1c1}2E<.-ja|m|cHlU[V\rl]|\rIL2>@Wr|c{\nnCS|%4:g?3g,m,X\r[eLHʁjZG]6=Qj\\l1c1dð;*9_ΦB0rXlE\0Y鿌߯+X9՞Hb h-(Tz+GkeBСs:rDrfGI&ob(Ze1sxyC\0#Na<CEĔQ3m#<:o,˾EI&鯾2}aM|w\\\0$y \n0oKz>07,?ӮcϴRoy7+փ,j\\N>\0\"o7a쐤mᝈǭJ\r}e=I5mb\0\rMh-t$S	%+hu>n¼fN¢Ut+ao%csQXϤm9\reT)쐤j[\0d%zv\\(eLc1c1dګ*{_ 鞰\0\0\"M\0i\0(dcO:{}hOY+%<yb^;*c؄ƕkRԟMˌM̔XjEvUWTW6\nvi6==@K:Zؠ:IrPtb]8Mc2o{,/cJ<.I\Z!4$Ic<C\\i=xm%t!\ZL^;⃺9Rs,{@Syv.[\02E2	جcUz[v6\\wM\\y_]l3.XfړK\Z\"/+R;6;ݜ17@\0N~w`\"}k_Kߒ d#svg3-mV*B${1|6w֝3oW>jI\'\0a4^f1m>k[}TV︲]6I;C|ܞ#\"`!]vj !Vx=mPx7\"_H{iqqǮiikkkkyyyg,feY\rT\\+IЛoIgS*fU;T\0,I4̷?c\0䞁w04}<\0{j\n?=Xv22Z;}>~ql9O/1c1c\"?BҞt.p5UA}G2k\rvI?o-QF`3BF\rr|(ٶ!(\"kv1c5e;76Q>B3Rjl#,4?l%SkmN@VkTfl67p$H\"Y6pіV8ذ6XD!`y(IdM}h??_-ɦO׶RE\n!vw;(h6zV3֭#+wJWO~ncۏ\nޔmVmxeY&jJf<9<Q lr\':[:?&KEÏ1,5 /4c%w@7dX.T.qZRe_޸tˊZ5tE19u+g){l\"\n:?OW,3m}S+<o]:25Ы*k*;jEސ%b|_:vlY(=kY:As\\,*DզI4	hĘ&t\"*$B?b;|ݠqtk\"sz݇\'4n8x2`ɴ__IѿΗ	o7@od<of9rtkL5gR\"t_Qi&H=={Y_̨yW̊I$ҿb@cKQQ{C$O,y繙3T*Ӛm־U\"u@[0]xY4hw\0J9DD<Qɬ:kk>`ĺ,\",Ⱥ]\ZMliBUFpmg_jc3mk(|;,ֶ~fLc1c1nT>SmWUZba[z \'SbQg	o&cmv*F\\oW$:\n\ZPsB}Q׀zZXBWSk%@-~nKgS{ZV h {0\n}t-cu:IϊIjCxd\"XH鋿@PoMm#<C{GQaIE1:l}1xqo}_Ӽ\0\njk\'>84GQsñ,I{_I\rHO/٢/O5Qq[hMHU7A \"ke)71RIecuwg;t(R^uٻ2ҧuCqT~\n+[}y/Ld0l|G&ϴ|\0R}<Y7Ɯyj\\iK]ڥČmJz[0|}GW6y?ޯżL_,Wڝ,\"~$Ɣ.uȶթ#4mcԮ^	5_U	/#Od(m/I7kv1c1Tz^-ޮrhS*>±rlr*\0}gՎZ\0AN1c1c\nU$Z\0\0vϣj^-à5ԛ(\rIҰp}<+Q+1dߤv]^Ǧ+4ܓ(4Vi\0Sk+덊aWj[<<D1ov~<%dk\'HӐ}}AtV߹=f\\nQa3\r&@FcI:G	]{#\'sZq>\0?zGEgoڳN:ʽ^NkfYW&\0hs]iz%MV讱MV&&%H +C}}ho}o=}̣1_E$T־<1%,_P0G2e]FgZڭTHb(=mp[7ҧE|[muy\"tAG+]fKb?]$q5M\ZHG̟8sC폤]m:.[zpDNSHm\0\rizizkq뮚ikk릚뮺yyy1c3z-#͑J(#nTJIRyQ)˘D1I#M,3G{\0ZkǺF5p뷔tecv\0zn\'8UGvƐ<뽕1c1d\ZNіYwhR-nU̇SB`6_W\"(Wozjm}3j6gjږM!FIjRB\r``! wfݷ_<\09^}Nރu#yU4c;=;d?IH߬:Z8SK	\0󯚆g;EB{\\@Ñ9*r3Qߑ(\"+p>C=\Z\0V\"x\r5ӨhkoT1[l1L8X=\"O!lkǺz&7\\lxQ=ez<Kbj<BA|C\09c1\'7{Oi>{?˙CQ}jMnw4{,o{C$))B C<W*5CU&s\"ki54F\0X0C\0~^I;i&ya?F8#DTcUme6$]jץLrmpJ	5qcW!H,1bI/H\0,9\Zyǟg1c1,*< xfMjC%|dz8EZ~of\Z~2ˡUϯ-fZ)	@D),jI4zkdbƨV\rWe&gaJ}1c3_oքcMSm+wuse̑\n\Z[K[ӘUj(Ob*d[\'ߍGV2nϧt;{>]Qפd{	uVzxz4Vfo峸y\"|?rJWR5Jj&*q@ӡ}$]5˵j}xVOo-ǽj&%ɸ/u栃G5\\bG۔DO>WV7ATmwQ!*}\"9ےچ/N,W3\\x?cߔniITF?]48u7K7HM60Fmͮky81c#U]P9ƝbU%xPP$MXNdq`NRB<1c1cFW+lA#\'jP+F>90bܥYW!#pm΃{ThW\n(eעԺ\nҨ\\9[ \Z[.#]N1C@	+ J\Z,1c5=q/w& Jbô)\0=6l}8I}>_Jttqo\r?WV8kh\0Ψm/ה`B=K;-=LKJ=&9;3Dhމ^F49URoLx8T\ZKn+Ezm]v\0$&~;/NSyqm?ԫ4jhEZUfey\"Z(,9\'IQbydM}ܛ1EWwAU*:\Z:r>o4?\"LAN\\zARmh1cgVxzMA}F=X3F:\0LT+N{7#Py$wLc1c1f{WQֽM5HJ|KGLuƭ`UQ!}1c<NV԰}bn\n5L{WNZk\'K\0a	{4Pŧh=|^}w3y\\)WǴm{T{&]Ħ%2jĄO:\0\ZjOg>CSnZsnTYDbUf^YgW$[pW\\jڰN,re?\0cLhG]Ҿ=^IWKO0/d^H2H)V5L7~=n慿]ny|ۻ\\IWtތ^LWM^64\\vc1d?D=5fыcn>*<NRU˱m\\s\0\"mᓣ|rp1c\0r{ګiL\\jC-HmMfpi$e=\n=aJ5v3Cy1c1cB]ahXbuL6Gܵ*\03&a@C;:G+ۮ-Ҏ5kLM*,h[ZvTPEuELpU1f>uk**wMSuzFNڇ]Ua90/JEfof[;(,g$|U#Y=tv8n<>b./}:	JEZ}L_M/|V/{7Wdx{֩i(hb\\^j0˔sZ)%${DHD3VYջ}_T^/Y懏A_@s5^Y;~uKmνׇ%%<T-(Z3?1qJj٫T$kVP]}cbߌscx}k첶ddl1cD 	F_\\D,rtJ?y0Nm5k(6TڞM\nK~1c/NgBll=Ԗ-~x>p@5<	\0cjwu	7\0{src1c1gGJtO:i\0Q4P	-գĭO;҇ԍz]aZ[ȫ50^,[yV6v\0Jn,Z\0-WWl&ꎂ{q߈.%\\KZj4}13g\rq2[zb.l-_;JYخ/?#k\Z:܁)$-wػWG>9zr*$mǂ#x`\Z6]kxer.Kϛ\\޼\0Dv;ZmdQ#mԁ]w#4a#l=q?ZRU5I4{¢NB\\U<-H@$(ko&{{Mc!]9Ey\Z㭒vѺo^=Kzbʄ{瀆L/Ev]hn]6HΡ˭\'1=Mt1c!\nϥy-_\0WoW~\0\r\Zr\0I\07o#.c23V]1m_vdmn&щ\\=fLMQr2%,W361c1c3nM}S.H8Dlṣ-Tpqo9g`lBQ3Eiɮo(_T\0oGbkK{Ui+|!:չ%V^Z<.=c,%;:J׋7g{uujZbUo&.qqi0\"ֻEky#-z%%rKpSKQw^r=\0F~èڭ7}h#cB|s\ZݯՊdؽ(Z*Pؼ>tаWVbxzְlxaτM\'/\0-Σ&m	h֒or.w͑\"3\0yuN7c$e1cke_d=C=?/OJ?Xdx?N&l1cO\"֥@\\mݫ_c\ní[󦡤Au035X(1c1d\"XH鋿@PoMm#<C{GQaIE1:l}1xqo}_Ӽ\0\njk\'>84GQsñ,I{_I\rHO/٢/O5Qq[hMHU7A \"ke)71RIe_SUQgKJLzMi(,ᰧSkָUdʩVq+Cc3Y1)tx1v(8v~Wl5;n/r=\'QqU/x[ޫaJԼfc1q_U_&1v|OMvա_|*X[	U&42]Q(\Z\r1d#HSپ!X}Ż^e];πu`9\n4\0=l\rr#l##6a1c1~yw{|rLWCtxZŦ\0EMG6)\0,1]l\'`WAż7铑##NBq9%[~;AsU%G`6K\Z<?hXeOԟM|SͦJm%w3p\'\\#0I\0\r6Gs{O*jEum}M^I6y4*AZG{ye@[{C}^;ʂ/oKgӫUf=lKѺ݅ K2fUfqju~1d;<߷C$@`{_L8Qgq\\5IwW?	B\0lUN]Z 3EԋYTheד$M]X*Z0X$(E\0$4o,I{1c©U<[?ca6i_U:\n3|K\08\rv^(:bQ}81c!!^4Ue8\\6FI`gV7֪Z| %D]ۯcK1}R<c1g/_4\\\"pdsFZZrba M$f\"y%]5o5ϪP\\(_&Y?^I*_wqIġYZh6_ZsȎn~9]+z=_Y??=m{,Sn<d*zR]X@z,9%%d+N{HCuFȞ`/\rot6\"4\Z.l=S>d`ȼc[1c _D:i`JҊ7ᖛٞ)\\J9˗҅\'`%2{sպj6w}\'kήSci\\BKօN2`Y1xgHӥݚp\n7FЀUSb5U\0]lgߺgW%K!vVM\"JD͜MfZc1du:~Ou8H9\\yhM؟ۉ/ղe**kP@h=s\'փ.61c/S&uI-~D]][\0L|~nδUj@W4c1\\U+p11wY4S	=DvCsUǒhbh,)4\'M<s-/w]~\r\\dGݧFqh4ׁq|xv4Ŗ	:O}K::IzX)R4]eZ>.6Km鰗Ҹ	?\n$Mty̹1Cf*_7l1cOک򞚒*\\sۢ-w:5vW	m\0xj9Rl\'Ǒߗu>irX?Gԯaٶ% GbogI}h7Qic?P,ӑ\Z%XmcH FyIY\rRG9Ҥ62W`\0hQڬTV;#YȪQK;*b::3C[`(c1c\rOq8aۻt^MRO>K	쾻*)<\"\'QnX1ֵ-\Z;p)6NKBΡ0K׬SkiH&ųVm%IGG&moy鶾{{{ߥ(7HZarg|q/9[[ZW VGKZqX䰏,ۆ$sȄ\n\"E(icrGMemY\"=M6}6_|߶1˸fe-4*mz=}qOa*]kg8-vnѼ\\GLd}7\Zr^㏡9.\'b*<,&c^^~oEת.~>om6DSi/\\Q Χ:W1\"Mt\'i=+@s}^SU+SkjպIɠ	R\n}}G\Z?6v}s(1c1o%xPIW]ja+ﶎVBH׵t\nMME`qG41bQ &L)\\>+@UNPP+Z;냭D#6ИM_L<K\0lt΄סtVVI!%wNXӵye*RYĸJkr\\[ϯV1c1@4PĕWUzĢ9fojh1VO\Z%KEEqIiR[k\\W/ﶴ\ZrKi#kUup7O#o>@kfx6=hbot>1gTBfY+ 8xx\ngH	$=-M6mYU,ܦ+G+:s7DW%AmV)FTlRU)Oȧ*YQ{EcUVi\0QO \' xw \"O\'=̐:CB>Vߨڞԛݠ:IB/W%Ebu6nWm95L^h\"Dɳ挵RżŁ AIDEK&kkGT\0<QnFM6~(U)8㴓݉CAвџlm^08y^sWϨz>~~{pXxT\0j/HXsnK.J3RW4!͸!I\0+c<^\Zm4Dh5]z-}giyc1c2=a6>@>V+?FJA#ksO<&DXbZ˶IA+>{w8:١B-PoSp	M#\'r@tʵh^elTWXnVUFq\rA@J/S;;\r.I\\c1cDj[nkSvua>X6}LwcK7ܝTk\\ JV-hAb4c1)1mn{\Z\\0/Niu +WS#\nƎmn&kS\ZY3dnUSmyUr<\0Uwz̠iN!{-54}UU>c;r\\*\'M/w]~\r\\dGݧFqh4ׁq|xv4Ŗ	:O}K::IzX)R4]eZ>.6Km鰗Ҹ	?\n$Mty̹1Cf*_7l1c1c3ZW[\ZCo=μF4땉ͰjZ*V>qj!_8Qu^E\'rEWZ}zS0G/.Q֙\0*SlS1uhݪ5\nEFO\\U\0PzyT\'W\0>xt}\091c1ch*Zu5[\Z76RTWѭ2-jQ4s$u\'<GF ١_ɰ1dߤY^ǧx\\(5C	:iI6g6y,:G4\nM{=yx4=/\ZtITwvǃ$K\"\0@tuQX@.>ekCvMО{|3=M+4:q-k[tکSo9_uG.>E{\0	%9ryUOߥy$/X;0ux(R8KHԷ~g漭0Sk-_RhV҂Ҳ,jk]\nҽ\'-z1>bkS3gEܣ[3X*ڝ\0j)vK%+LV{a@~b1c1c>cz7zڠĎS\ncc&)Йt!Ս**NzcBM(75`~\"HBV۷8!Ͻ]Fz^6\0\Z\ZY|\nbxTtcXK^%j՟WNq5KI5KKu`\ZkkL2O϶1c1c1jN.d\nHGcR:uK!ܜ\ZF%L\0Vb\r.wƸ0]ho=l(8nSBU{(F,DJ\ZcI9|K\r&{w\ZNDex%[{~	¾O1c1J2nOW7xbYoqF3lK-q%1G\Zm-\Z%SŪoÂqJe5FԤ\'t7аԔuj}ˎȏηn~(e2>d0FsEʏK*}WUX+7*=|şBE9q[LQӍiLr=mvto^\0\'ӐA /z]l)-Pr^\'?X>q&tgt^]Z!1k]Rh\\ȱ3JOY\'4mMHtk$O[w9&p\'04+*߭fMWngua[Is|Ǔo\"xK1c<Uk6fj=Ȅ0@8w M,Q9\' !ye]5o!5\0yWC\Zٷi?GTx8l5E(\0\rWwtNEݏ8aAr5]6{k~dj?:c0{ls\nݸUD֖I/6%,YרʒMY6M0]vh1zx\\,U\\.]Y򎚺-\0WVB~t_[YϞU|uQ=2`EDiݭ4\0Bݥv_T}${1c1fZݣa>1[Caum,Է#p=r;yK>x1c2ڕaurjdeW7FAJϻkRZFy4U0\ZY\np,kZEVZDFb;D֗DP18.{3yFYٛV=B\0;u~J`\'jeTKIS&94\"RځuN]\0cOIcO;/VMث_8K?.ZcA	tEK~lqmЄRC\"nK62x[~Z4_Γpiz_{}~#oث*ٽR@3_`b7Q	\n\"\0!p~5˄55y+>{FroOKhS0OL\n\n7})(w{%vg1jmFq*G͟E?	P*/5A,elG)DG*nIPnM$hU5MPwó	a|ٰ~Ăɟk$4`<ݡĲ9͹}-Yjx}\0uE०g0V7ONU^ZjƯ`5[]&~Tv?+\01;[j]UZ>wSM҇XAZiݎ0\"}V\0إӪd9rZ屷bngu;;t	d?Q]XܓefI\0Q\nuPu5<vfm^4mI$E^%ko79>@WX	G*#RۓSm݂Ma[l/:ǫTuSE6ȴOt@o$mn3A<<\",2I$K<\Zm,4k0I,m﷚Caϼ0+m%GEd0VIC2-v,Uq+h<|c1c2{:BC-!\'񫕱:nu6\\PP5]l%T`\\+YnV5:W:Aq>д?^\rLlZ\ZF+KO4ey?V\Zf1c1doԤiޮQA[P5*PPZ88Y~xb /?ޣc1c1[6dm?@VsZo1\nHL\0&_4I$YI鷝WS(PSXe!i$\Zł,K<,CK$I&x1c1d筧8,-פҞXo>HgsN;[3keNypfS-U4c1','anonymous',39,'Paralela',NULL,NULL,NULL),(219,'% Definio dos dois pontos\r\n\r\npoint A 10 10\r\npoint B 90 40\r\n\r\n% Definio da recta\r\n\r\nline ab A B\r\n\r\n% Desenho dos dois pontos\r\ncmark_b A\r\ncmark_rb B\r\n\r\n% Desenho da recta\r\ndrawline ab\r\n\r\n%Definio do terceiro ponto\r\n\r\npoint C 40 60\r\n\r\n%Definio da segunda recta\r\n\r\nline ac A C\r\n\r\n%Desenho do terceiro ponto\r\n\r\ncmark_t C\r\n\r\n% Desenho da recta\r\ndrawline ac\r\n\r\n\r\n%Definio e desenho do circulo com centro em A\r\n\r\ncircle o A B\r\ndrawdashcircle o\r\n\r\n%Definio e desenho dos pontos de interseco \r\n%do circulo com as rectas \r\n\r\nintersec2 A1 A2 o ac\r\nintersec2 B1 B2 o ab\r\n\r\n\r\ncmark_t A1\r\n%cmark_b A2\r\n%cmark_lb B1\r\n%cmark_b B2\r\n\r\n%Definio e desenho da recta A1B\r\n\r\nline a1b A1 B\r\ndrawdashline a1b\r\n\r\n%Definio de mediatriz do segemento e desenho\r\n\r\ncircle o1 A1 B\r\ncircle o2 B A1\r\n\r\nintersec2 AA BB o1 o2 \r\n\r\nline aa AA BB\r\ndrawline aa',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0)\0\0\0\0\0	\"!#$\0\0\0?\0\09s93kS_@e489w!Ta/5̌{@XLv2d8\'$s;*$[i\nA>l\"j	2ć}\0dW\Zd3Ӝ).lsUs9s9w!}SraUc5$)L;-!dJ\'.paFǖ\\8q:GG_58V,\0TE;%כA3T%ydxѥ4K[[je<J.iks9{WM5m2<NTjI[\'`\Z_>DI1	DW[%ЕeRkI9E:qm\nnI7!DaPe$Z،=`]\0oFt~>V+>ƚ-})e\ZĺF8 EoڌRc8ǟQ\"T`:܀J&tL	ke*6lhތi.\Zn>;4!DB7/k>y@thōSTgx? ܍h_;Ȍ*+jxIᩲITwzF+l޻\rCWdǃ\r3(u5IY$g7$+kB5n;s4/]	\\[ձ=Bmvw=V?=:#:hcPw\'VL~]dLTq%e	qHME\":!R3Rqֹs\Z<!̨̎v4Zmc4y:/46N%M)O=tv:<\\E5(]_1џ2D\ZBڦ,pFf4s~0\0hy)wh_!YܥvmW6\Zf}K!:^Kŭg-aQ&gZjLId\r\\r`z|g))םZ`&6k)SsTdOqٳ_q}9s9s6T#d`Պh\\4ÌcD,\\@N(a0x@4htI-j⇠̨xͶm}\"Sw3d2%ɐex\Z^y\'6#AJ(jq_׌}ns9s9\Z\\[[\0WT2&%jHQ&$KB%0^)W\0$be5sT3〬RL8,Mԟ.)6d[dŔ:TS2|؏*U;0J϶t]x@jvܬt42vp0\"#iIժ?mwFr%\':X=ڨWEƗK{\r޾)5)ECBsCV!jŵv*d&`R\\!&#@c4l=-6\rӎbc`<6G<H(4$	^~,cinLg]ei_Wj5NG@Q:͸:\r 1BKz*araJ\rSGM5$7&.>,`>vZmm-HWg_\n3$9)&פJOBBv\Z ZY[+Q~};י2 ϕ\Z16lڍH)2IyHf<hnCM48⒄;x5%+/\".!_Bv(6y,3(Urjֈ2<Tx*1k)k<9s9s޳U@rz~`+$T4\r&>T!/;`ұľ՛Y0vrL9)M桻[Gx2ۨLc=̪F&k\0TΞT!=\0@tȕ9s9s9эoOi?߀DFurgh\ZElPJVo(?fV[&Cy<l_	SZ\"l]Q\Z	R\"`˴<AOj@x[t3u]ɢN>2+0V3W#OeoIeI\"FYe5z7!<๫eh5Uvgv^hh *H&%?<E&O\02HyS\0+\0}\\I45^_]YLV-DN D`}dKe6o\'YNZW@`bDCbU\0aIr3?$RO\0Hcu-bZ;\"oikPg9R.*^z?&Bo,?\'=xL?%q[P66m(B!>x	O%)J|ħ<<<;s9ser,]_n`${Li[\n?\ZiKA2=k=jW\\wcVs=6n(-U3\"e\ZX\\/vWnIC\r@CXT\n9s9s9s:s;&S\rAu=2_ NY$\\S5nɐܷ۩,΋$Wۄ[o7xײ*Lh4k՞=G9ݦA+3 yy>EtG\na2g.؅TEdAiQ[\Z8\0JBĶVmn8LN4I1+,ŅdF>Cb!@tZr3F|Y4gc\ZM\r3AMU\nscRt_Uha5hzh>ve>`~7e٦*]3ʝ<$ѐeF:UvΚG$4	U/DksS@kD8b0:Lb\\u˳Ȥg3j*,5Zi-`(Fs9s1Ǒ2dbĊ˲eJlG)H}!Ye]qIm%KZO3ru׆e,̎%7\02W͏\\YL*1zVk5(\0DET;\rK#\'Wܢjm.Rh\ZrGW\\4n81i+λ\"C\'dyR쇝u}79s9s9s9tkZ!jД|Ir_Oņ&|	@3Y7śh \0U.q@T!V>O6lu$2N2yLi˷ҩ>rޠ\Z?J3\nyt٥ԊlkaϱU[>^p-#=u+b\r7FV3/cbY25RY4tIsS9s9܅M&uV]ԒƊ8Gce0>8촇e*\\AYs{0G]~÷\0\'D|]Fi߉Jhe8lWrk:2o%ZMc2˶bІB[mBP\'!)ĥ)Oxyyy~s9s9s9sVds7/ny1ɳL0F=RܪKLwA9\nKY>]Ji.\06ɟk\ns,TkN|s.at\'mh\nm ]y%BnnX7aZD1AlՔ]\"\r03R8ȒD7bMcF:t.Gj\"gM9sI$VDׂ繥6c\Z&fn2妷J*pȏCQJSCMhT=eCmh}$aWI-L(_>ׯȉ9\Z2TEU&fSs9s9s9s91vD[a[Ͼ,}[Jm%KZ֯yｓ0ru}#츈7P)|.G6\0߶&2ۃ-ψ?Xx֊\0e1̏\"ʉ)cJ%ߏ&;SOǐé[O2JSnTۈR}?ar\Z(6kbb6+c\01цfnU}--_>p gY\"yY1HMiԋ]\nLճoҘ*ϾzbSJ?Մ)JS!h GiEއS9sꭂS[\0FY\"i5@x	߳%ȅ66Ƀ/aLov\'5\r;@f?eWL13\\46t߁Ϥ.D|9s9s9s9swU[|;X¢􌶒B6`٤L+y*)/\'N7<1*BBm	mҔ!OB<JP>ySyyy@-+`N*LFΎW\Zl$CCnPʈ7.iB)DF~n*^ePYuHP6gvS\rJeg@]VCi*3ksi4{MQ>*e`R\\lhOW3rWem2PV:JɎr|FswEj]3Ӊ8	F.\\\'$-f\Z<b\\3XGB3ga\0h9vQ-\"{\0E\ZVMgƘɵq攻#ֳ֥Gv5g3k>AMZ#8*]Y9{ѭōuey=.48-<!5@A9s9s9s9t\0SyC6P&@ِzxءʼ\'ߌz@*_mvcBDWMkx7=F_݁?al!,ġA*\nOg5,2&*4I&UڴEɗ^s07	 2@4F4ݨ^((u_ĬY5\0\"M?fvbwެ*lt9TڵH{{!铥ʠ`˄l+$jɔ:im?SiH^\n21w:=lָAAT/:Hq:i*Mb.Ԙ;3!Qr*`X[\Z1t\'RR0~9!S\'kG9ɓy&Hf,H&T.xB~DR\ZeZJuBTc7-w_xfZr^cp.eAŘ\0$£fR?DUC`)${r8u}&Y\\%&[Q!$x*x|aaJÃk$9}vL!nyWs9s9s9s9sT|wM)|rLH\nlHMqR_\0$GϠ\':\"+=8tvuaPysZ&VͶAЁ#U3r4ؿX%\r]1ya\rʛ[UҲDdZb3j	2̮?1r/<i6*\0Ay/ɓ\n`lZsca\r[2%5#L(<	\nV3Xδ7dA\n{v5>.{!YRFeF|;?kĩk(7I5//.\"9XrKʇ%nzK(\n\\$1u_oܾnXGUj5I,hDv?fSCHvY˄Q:jx)>Gz%y;ptOz*΅k6TvXC}|&+P\rUV3,f!mm%JP!>%B|)B<JROyyyw9s9s9s9sET+iӰ@ڝ$E,1?dVr|W\'<>pX%г<PWVggqfY:H=mBlSB\rqٳ89ћ_Dv]s~^,au[`CɼE7rsXDKɑ2uzNf@47\\T֯Uw\ZqjdC ee/ě\n[\n[O2K^{>\0$-)ZT\'{OJ405D\r9GCĎF),B}jI<Q\rŠ\0`ski`FH&{@`b}:fT입B0LsDGgCVT#d`Պh\\4ÌcD,\\@N(a0x@4htI-j⇠̨xͶm}\"Sw3d2%ɐex\Z^y\'6#AJ(jq_׌}ns9s9s9s9so<v]!aＴ,V㮸Rm	Rֵġ>z{{e\\:\0&q[|2J%23kz<\\aC/myYZt\\;5,Òw9sN>v\n!BMY:ӖcS\"<6V`9₤0>w!X[;;-\\fVv\'Ç)b \'Ag5$zUk<-JS|k|+վe_v#[D|<$׌UKɜށB)ct\nRSrA\\5X_9s9s9s9s9gv9_:[rC f):_c\"ɟF%蕿su]̹	\Z쎋O~A3\\ȍH,ʽߴ!Oa:UY1EM-U6|<<ݶzChCm-R!	(BJR<J|<<<\\9sf.eh78w,yN88D?\'5\"\Z<2UӬN-~7Uh&ȪvgF?49ݕےpCgķ8V*@;6[SӅ/\nT+p`3.xpؓeϘ`)$\n32y5Sm~s9s9s9s9s$3Wa4L)CV)u	VR\"ja^<ҊXL\r)WSon+fV4<lwֵI6Oɫa\0/X$Y3yEV\"s92cÏ\"dŉdʕ%؏\Z;SȐCLIShJx=fNX3Kьn\0e̯;:TbjQ!vL$nGND҂%V\\*Nd|qTTW	$25Lv+43Q4̕Ti/<3)f:{4r[v7<\"!#Z>yVaCR1̏\"ʉ)cJ%ߏ&;SOǐé[O2JSnTۈR}\'~x!Ye!x#\n1.GG8D:ݒי&:t@79s9s;(T`1%\08qLIǍ+jzLӥX#:-KqiJ}%w@%f9y+\'aL%\Z-ץPmVI-v:P9s9QQmNAt\0}\"5:=d*Ol6dyQ0rּ9sM4F%qH`|qi\"T9p\n6<MO<\'È`DO\"n\0NC%Rк<fӿqد׾tej!J*el!\r\riJ\'ġO%(BSJR<)<<<tJ˫\ZpLy:5ڙkNMube-<j6IJŐs\rnR-CLON.u~T@SdOtOҖ䧪wZ@g>f`H\0[%\nN8<=֛lV`OUdĲQUg\n%fJ|\\Ej-FCDvۭU׽n9O6\Zoaˋ8zx\Z,;DUP]bpjQ\Z!9>s9s9yJ>\0#L7,/W\"\"m1FGO6HD&P(q}yo	}_y\0_0%>\rkv37Qg#XwоDcq|<FSrUlOeJCYdG6,&/iP&<ΚMƚw^3s9sAUi9uQ2JzԷ;2Ѫ\Z\r!%W*.DvbkDl=4Z{RbK j3{8IN5YLJ`$b{͚s6T#d`Պh\\4ÌcD,\\@N(a0x@4htI-j⇠̨xͶm}\"Sw3d2%ɐex\Z^y\'6#AJ(jq_׌}nsس6ͨhיL[	,=CfkdJSq26a=  )ԴDԈ_l)A>8f\\Bidrlx#1H Ȣ3%SqgK]#T7aE\"GS\nUM-5>>؛ys9sF×co[fdH\Zi_Tjt\0eUڸ\'~<h#HKl7K!.~=7\nd ǎ2T/\'oH[Dpƀ\"^\".c?7EUeԹ\'ٸ^)\\$06z]tHNkJtip\"Q\'#@ShJtjWql4~<fRJ}9s9s&<8&LXYvLR]m񣰅:4,8)-kW|y\ZG8k_xɨB&´\ZH_A+NSJlYWs9Y^ e9}u?yTm*\ZZ*dNg}0iX_py]S`jͬ;\nB9&]&bsPݭmHa	1Ut#5ʃKL*cgO*mM\0:RJs\nD%#XuʯEn,H:0xU?_Ѫ>`WZkfMrP4㣜\\)5q?tIxW	ɎgjTIM+̆dX\ZxZ/_t%.-״,h.J|	ڟ1\n\0W5S#n9s\\\'O xRI0^laߗ<	(!oI%a-\\J}REs픘أ)q(vkr~crhn5q?]יZWQDc~n]in@eFHhdm!rf&Hbi䓧R`Bri{hHDknv#amxe%X<kx~&s9s97su[\'q@J#*+28A:[qI^1O%\rh2*sBz9`!!Жm)B!	ĥJ|)JS%>yyyy߮ser,]_n`${Li[\n?\ZiKA2=k=jW\\wcVs=6n(-U3\"e\ZX\\/vWnIC\r@CXT\n9so[dh\'%^1B^i5j\r払fvaݾcv+ҾUT)I{mG	Eܪj K<Phcמּ_^T1jtۦεg=D9GV.ONDI2:u&\Z5tUfp!gDڡJEe^J6M>\\eR>]J˂{VLc7=84?]76L?YzZ>!KpLs(xo`a1iL(3^{49s9s9OGgm+\\pc&mpء:τw+)5ZiE,&C\\3,J#Z\Zt}2nPhlUkf5C wO}p%W`3!rds2dǇDɒ+.ɕ*K4v_!Teu%Е-j>{]7^g?28\0˙_w6<uqf	0YԢCP6\nI/܎,_r)wW	IVj5I\n^Xqpҵ0mZ:x])H[u9syd2y\r6_a%^e\Zu8ۈR->iԫ|;1͎:M<ZcVZZ;fq*,!y:.%$>M\rl+\0GX,\09.Y]˶>GϪVJŪ|MYS_gR-$ˊ,>ל鮓14nǤD,ETmf?\\N1:\\	i+mZ?ɀ\\?7Ie\"az4\\˭i	lmևX\ZO>m3zu<=}LMH͍gVvga\0\\hٙ*u*fRVY\neV\r$![q\\yhkW9s9s9*2|wJ-I>bN_Ϥ]&:S%Sc`)l* \Z.[Zל;ߩ}D@kXG~̦%K80c.tR|8fK!v?2U/m;8PLmM{FVmIfYvBhKmB|JR%>x)<<<<9s9܅PWU;,/,.CiCK6(В`\r4y#̓\"<SX-%r^:^ra7Sяf[t`:E+7ԅ8b4HXQ6ѣabHO*hČ\"i3b(#V/4H-i٫ϩ]<;nD-{F4Z8&ZE_qnk.	ɭ~hǙWTdKoWX*g9܈O40Hǈ8KTܥ.E\"^I>n2\"Y/%j6:Xn\\ѮLUڭSlFa9s9s9t-Vb7D*$rR߈Fh4Xd_$BT|aيArQlkYI,LO%:KX,֔>fe1*}v_vL;6k/9mofcF65iMƉYiҁʜ2#P=`ҀiTgZ*1APmhEf%eKe\' /ς5$<\"NlF\0QB|Is9s9yJ>\0#L7,/W\"\"m1FGO6HD&P(q}rӸif1*Mҳ!V/G,~U{܄ALY<!\'if5f*6t=NZi;!	gdݾvo[=KҳZC^8D&m\\E S\rVcndP)v\Z;\0꾱`YUT\07@xvj4(2g($\0a}B9s9s9s&<8&LXYvLR]m񣰅:4,8)-kW|y\ZG8k_xɨB&´\ZH_A+NSJlYWs/Ul2ޟF*6\rIO2m\'eǈK\0>4q/<D)yfL!}f`{9nG$S0s*eA?16v}&)r%{9s:ol9v?\0y6YfK+YV\0EM6O\\lOV[],r|Ƃ>D\06ϣy$`~pB\\x%@pVoUJh\nb%\"1!>p?z}]uV]KR})CSi\'߮ DD{&ԧF=%46Jk*>DJ.MFz\0(HFJZco+T=}\0JS}]f>\0e@mz\\z>_[4\nl7/#hAzujnq?#u`\';Ohkjrp{lkYHkb)kq9+ӳaO1\n\\W9s9s9s웹O8%E~\\Qdy-$	gzy[giO=UBhKmB|JR%>x)<<<<9Fܴ9{G8tj۹X	5S\Zc&Ƣ;Rfc̏ZZW-՜M7Uh&ȪvgF?49ݕےpCgķ8V*@:s985DN(8 @,`E\r.y]f$(QXBޓ*K0H[\'y<u1)1aWFSǎQ$\r\r!Vϐ:j~3?ǫϞSˎ܁G(ʌ\r%.BL?\n;3l!\'O5Fl36\rMFǚRFâYivK9Dx׈MDDk0%4jF]b_nhϵJQehj`\0&rabD\"Bk<yA+ЙtVp&:SՈȈV\0NKSOY@ۏ }^eMM^:fl,(d! ,e&ps 5\r&\'%!i\"+<iQK~)>}>s9s9sO=Iٴ;g@iq1SbS>ܬDj¼y\Z=!rR88Q*dhj\'\"$ʘAUIy3Ȁ=P^O,ɓsxdɏ<$3$V]*T[b<h!N\"C\r2-%N:Km*Z|1n3-9`~dq/F12lxaQҳYD\"*m0_=Y:VSiu,Dk<r>0kwaL^u>&Sʐd<s@._MU+<Dt0wDܳ SP}_%5>Lq#5sOIBءm%~_|W?6ή;+Fr9ʦ`sIB%N!eK/QA]=G1R$6ѽx\"IzE9\"Ps2)ҝz9sD\r?T~l+6hNTB3T|Hd4*jY\nW32?Vt`a	@0eD29Fܸψ\'@CcɎo2ZUja]	mĖWȏ\"p~Uz$DP\"ZK,\ZІR3a~Mb)=\\mIs9s9s>oߥڤ1X\'A덯.pqQCZM꿰iG]\r-k/n_Q7|,#\Zf4Q\";)!e;,R(˝5<x`g#ق=<v:\'=KB5NN*T;G,![bC^ѕ|F|*h]66m(B!>x	O%)J|ħ<<<;s龑tfٙ.4R;eZB6ڝ=q?Ynv4\Z$2l>pKME/#qpGI[%V*8\\\"q)Ą<>uYu.~}Inx9M~:R\ZdI=+9g)+@6&]\ZD\0\"A\r+_i}R}s9v~6H#&npN*PLB}y\rhd%h	Kư&#~P2D5&4yCQ%2iQd}\niu+i^iJm֜Jq\nRS{jnE`XZGʬ՘4ȸ)\nZY)\"UCL<Jm̂=[Դ9s9s9΁}*LF}|zDR=j[h\rv]J\";1H5p]~j6m-k=1%5qɃ=\\^vik҇٬%OYS	1=f}&j:$ll\ZZ-^qhe˖(\"?%#F(M6{墭SPm_\nnlY]_$[y2~#^C\"$h8P-W+o=Ms_D⃂\nI\"͌4P[!5bB-24B}WϪ@\\(_y.~{e><x@m`.ROn^m\Z<\rӦ\';KJ:z\\ѕ8<}Ҁzl-Ͳ\\2.LlC#6tTjLV1<`NM/tmym.l:-ldKǍxo9s9sк[d $SW9c:OjC,м&\\p!gA5\"eKP*Z8\n{DF#nƒEr!,\0KDrb.݀p@.:&Pߟiҁ_-SWիo nT\',t,6#\ns9s9ɓy&Hf,H&T.xB~DR\ZeZJuBTe|<Zsќn5/<d!OV~lEaZZCy$aXc{)\rjqQ,W=;[/6ъEC@kSLIl\0ϳf\r+K!k\nlmYaH_g$Ù+Njw- &3ʮdbfPiieLlMIJ\\^tERO4GH$M2\0E5ȈpzrQQ͇=Q!I4*}v}[_WuW5y	sO?i݌㲸i!cl4/Q2\\~e޴}\rs-CmhL1\"$QÐb%3,ҘQhg)i~s9s9YQ@	3هڎdLxST|.XluӟBJMuo\nZKlſzp:}0E;U	tgG|)k@X+}ðl\\WZmNx_+6БeYJ5_\0fRkU1{pZ@QzՍ҇>D\r\'lD>s9s9ɻ>XTPQ]q&JגۈOЖzy(kGUvYk!\r\riJ\'ġO%(BSJR<)<<<w=~Yc49àVI965Qҗc7dzzԯ\ZhƬzmw\')~PZDg6EV=G/z5θ^6ܓƇ>%2U(!tHr~\0:mKl̗`Wa)V!^mN؟\nW\ZXǍ|iq\06mFb8Ip%Ǧ\"Lָ8Je#ޫh.8KEbB|~hꬺ?c>7<SˏOK\\AΉpMsWN2{nJ$\0h\nm`T3}^S]b_WCn\"\0P VǌߊW^{G9s9s:L~m)`*e~qCMo\ZV3Ԙ0YOT:JsƦ%\'.NNYM3plCl|sH2]cbXC5.=p\'W+ʁ/M kvqBW8R=b%y01bd#\'9s9s$3Wa4L)CV)u	VR\"ja^<ҊXL\r)W6A/ҍYttr;\\j$t+DG<fu@QGH!]űɜ~uis#z1scW`|\0\n^J$0\0Ui(Kgup%l-F\\૕\r+[FeȐ2~T!]_.`M|Q<)$/60BCio˞DY\nVʒL0%	^f>sx~yLXUQssIADHA?1zմ|h7N-+1s7FT㮴 QJ鲣$CD2C6pː3$}rIQ0![\rA94QC\"5TZz<uݒQ,z5<e`9s9s9΄o5y]n&C*ެ@\nft0>beў/n\rO4vc-&Fym*an抹LD;4`F1/V^v0˅F[Yq\"Yd͢l[Aׯ-`v қ,rq*RZԸ8\0ЯۨCZs9s;\r\\owQScxt-IQZ0ocP,o5#]~Bƕ_^=<v:\'=KB5NN*T;G,![bC^ѕ|F|*h]L1ӏL1?EE\'q$wV7lOF.f2k!Cf\')!gXFm|%~_|W?6ή;+Fr9ʦ`sIB%N!eK/QA]=G1R$6ѽx\"IzE9\"Ps2)ҝz9s9s9s38 3U|ؖ(ʔ6,Bd\"zFĦ\"99vs33{9~!nWH]Xl?\r,Q[j2 TW˔\nRz{Jc69s9sw\"%F1֝PŨy,%1ʅ5*ujf,c#űyvh6Kɠ1̍_@=Dɱue/s۟um9]F-b3t!;l?7EUeԹ\'ٸ^)\\$06z]tHNkJtip\"Q\'#@ShJtjWql4~<fRJ}9s9s9s9ПDX XSDϥ`e4Ce/FTcM\\$P2ԧ79w>f\'\n!bH@|̃>W\\)$!JHn2.-P)I;?0hiƧ/lUfʴ|HŒQWޓ9s@Q2h\0~y2&G4t3gN1bD$:,-ť)37U^~7_y.~>\0N.\"os7fL4Ug\"(]YS߲߾Y^Wi0qcIˎnX[$B\Z}ʵ˵vxNQI>a=D{GHo?5\0ܵ{)*\Zw_Ag܅߯Uiq9+7fs9s9s9s6{7%NV@G\'Ȅ.\0|caII!H:l9RRmQ_(QE\'\08AplD$iI-fyubփq+gӇR=kЪu8<2!w@c863gnS5o|9sTeٵؾA!wr&1-L?@^=\Z(o:Ϊfa.|;!o|+p,{ic1^\"Noa2n&UW;-*m	NC%RyM=Dk(ж_#$^-xVU´{~s?SMejeTP(BN7W\rXKN\Z,Y̋cJU`PJSdŌ#FxRz|=[)N8|\0֥-^\0)^}s9s9s9s\n8\'$\\pEI-42_Cõ974R.&a*(idaeYs#@ʷfb5Jwh:UY@! q\"!\"LxEgA_@\\u|aH@\0!P\\i{$#HDqqHDHZ,zïPdxXg9sțJBevFř|Ζ݅d׆:Rml	q)3.!\n<SV`\rh2k;{Vk9\\At=$TFf(DCk4`&U;`Ck}a	.>Hs|ة5V=6m`>0k:MKly2W:\0և 芫V1؏̙y9s9s9s9t_p	D.[F9:Rp@*;^:a%	EyObdѤG9sΏG#aT˜U/#iopɏ]r(sm-\r;tի({w\n@KgPmV&XWϮZa7Vf\\C&B@\0.`$%|9vwѤnKOBA{;ЬziGt9n4:<\0?Xz}F?䵢9s9s9s9s^Y;\0c\\kۥD$Gg$8a2\Zr>1x%\rsS9sgqʾǕhm%cFAza\Z3m֚<\'5BPN\rKJYtM	s','vsantos',51,'Bisseco do ngulo',NULL,NULL,NULL),(225,'%Definio de ponto\r\n\r\npoint A 10 20\r\npoint B 40 30\r\n\r\n%Desenho dos dois pontos\r\ncmark_t A\r\ncmark_t B\r\n\r\n%Definio de recta\r\nline ab A B\r\n\r\n%Desenho da recta\r\n\r\ndrawline ab\r\n\r\n%Definio de perpendicular\r\nperp ac B ab\r\n\r\n%Desenho da recta perpendicular\r\n\r\ndrawline ac',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0*\0\0\0\0\0\0\"#$&\'	\0\0\0?\0\0\0vAy[;EQI!hOyНbd7\ZCjTGٓ̥m!x~oov;o9{z%뎧wQgζݗ8bsI)[v4GC}W!qXҌo0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0lԱCQVGlԨaTDqe3~$:~v]SXve64	nS00\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0j۪}^KmI_X[O>\"|2kc۴o׽/S5\rP\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0횽V6z߯\rjuXQjmͦ\\	rSQ2֕\nƬ~{U|-71[-\\u=sr>uvjNJ۱<Δcy\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0fޖ\Z;fGuZnZ$msu) Aró-/vKrI\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0W~V\'3m~[mJf\Z*	][[ݧ~|lυJ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0lWfҶx)ֶ~WkV\"`Smnm2Ke:96V5gݧii^މh_e\\Rw\nVݍU\\V>t\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\05,gFPU7Q5*>}XB#r#k{5LߝWCi{͍&B[*L\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0#9nokWRmW09VϨHmgLv<KTmf|*T\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0fGj6M:Zi{th+ui\\.!a̩x±<ߴ<wUF=MLrKGO\\ܢϝm/p-ZRh.B`\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0٩c:7)٩Q{\\yg8Hu*Kݦli2ܦaR`\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0闱D\n/hl6ObSI)mI%ckuv].n=$NC\r:\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0y}Mz6sݾmu=W4ݞkShvtP33+gI8RpT8MKb8~z:.M,ք~Ƕ;nclLn˪Xm]B{Q5)S2qt\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0*Uv\rK5\rWܕ5%>UQE]v*uXaKqRTU@\0\0\0\0\0\0\0\0\0\0\0\06lJ\'XO80 er%͛.Bۏ$X,2uiBTL1^)Qz^Y6e~c2e}eƾ?(vF}R)Ye=81ak<ͯJeXn_{e}n\r4D2Sߍi)~]=v\0t]le]y\"2Jyn?*B@iss0i\\@\0\0\0}G!WUKMTmu;V\0\nET\0\0\0\0\0\0\0\0\0\0\0|5Pf͉][]D	lDe[qċ!e[[(J^;ك*7KbK1ףl/LfL/lXϳW+,,-ygLk\r}yL#/=c>FVߵr[%2U68o:}<YoXuEe}6ng-\\_٥,Ga5!~r:!!Жm)B(B%(BS%)Jq%81c1\0\0\04wi[=&S}Mֵ6-whIun#8Z2tZ3\'eI3dԾ\\ܶ-ӇݧӢjBhK*{c;la+Y캥ۯ!o뗵R3)A\0\0\0\0\0\0\0\0\0\0IAgg6%umtI,\'fa͗!mǋ,v~Dmmn*V&Ez/f=/a,^U12izbmc_Rz;#O>f_C\0Hofץ2^7/2MG\Z\"ZZ~)oƴqV^DӧEODlebנo<۪չ!q~wfK|LZc˔ІB[mBN0	N0)01c0r\0\0\0\0\0*Uv\rK5\rWܕ5%>UQE]v*uXaKqRTU@\0\0\0\0\0\0\0\0$jͳ$30\\sfːŉ;n?\"C6]ZP+\"wvToĖc\rFt_̙x_rm\0=16\n)=if3TVYON!\07XZ3kҙa/FzF_q{&[}`-A~kZJe^l/\"qӢuH\'6xޱb7tgm[[;JX%>k-1C_LuChCm-R!	P\'JPJRJqc1c9\0\0\0\0\0\0\0J\0Ng??OA&\\NOh6z:u\0\"\0\0\0\0\0\0\0\0bO;9+kHaa>C0\rȗ6ln<Xc$>lkuե	R2+|a{0xF{If>mEɗ-Ok\Z\0P֙\Zyc5JeCxŅ,6)ma})elu?\'6{NK~5[\':-Tz#g-.~HyU4\"_3b5\\P66m(B%BqJq)N11c1\0\0\0\0\0\0\0\ZnѴÞkzkZETˤ-	[:Lu-22j_.n[it_nf%[=sbf60Ǭv]RmډJӋ\0\0\0\0\0>|\Z3lĮ\"}Ã6W\"\\ٲ-bEۏȐ-V%Jȯ]1%{kѶ]3&^ܶ[m?LMkBOZgdiٌ+Sӈ~\rXKѵ^~ɱ@#DKP_+Ae9-֒n*כȜzt距R>荞,X\r\"uV3./Җ#|ϚLv?srBhKmBp!	!)8c1c@\0\0\0\0\0\0\0\0\0t窻\Z}Q+nJXcDAע;\nN:\0vڬ0**\0\0\0\0\0ğ>\rTvsbWVD>|a+.lrx\"mH}aJbdW`J|=.S/[-&5E\'34jJ)?_^YmzS,%r^S/H?dt~Ol%/2kILkͅN=:t[ΩdF[,]zY_lͺ}[bviKDgtŦ;k韹ܹNmm%JP!8J	J	JRc	N1c1c \0\0\0\0\0\0\0\0\0\0%_Q\03{he\'R wu.\'\'4x}GqF~{պBU\0\0\0\0IAgg6%umtI,\'fa͗!mǋ,v~Dmmn*V&Ez/f=/a,^U12izbmc_Rz;#O>f_C\0Hofץ2^7/2MG\Z\"ZZ~)oƴqV^DӧEODlebנo<۪չ!q~wfK|LZc˔ІB[mBN0	N0)01c0r\0\0\0\0\0\0\0\0\0\0\07]Vv	_`vzM]*e]@[̭&:IÙRs5/7-tjiZ7PZʭo3Jm.au[DԥLi@\0\01\'σUmؕյ$O!p`AK6\\,HqqXe҄Xc<R|$pmz6ˢTdm鉵|QIL<1~Rzq!bזy^	z6ܾה26:hjeh=_̧%\ZS-ZayNG=Ŗ^{VW<nVr؅ݚRv/]1i\Zgw.SBBm	mҔ!N!8R%8RSc1c\0\0\0\0\0\0\0\0\0\0\0\0\0JG]E_C_>\07%nz,Mgv Tk|m\'\nmVRTP\06lJ\'XO80 er%͛.Bۏ$X,2uiBTL1^)Qz^Y6e~c2e}eƾ?(vF}R)Ye=81ak<ͯJeXn_{e}n\r4D2Sߍi)yǧNy#있zŋ@߽++yUos9lB)b;a\r}3;)!\r\riJ\'	Ba)Ba)JSa)1c1`\0\0\0\0\0\0\0\0\0\0\0\0\0\02?$Ь+:9r̎CӐ\'nuxzjc%|9>q6^?Z|ol}&%O^L3o{ns^E?BgŰn&k`6lJ\'XO80 er%͛.Bۏ$X,2uiBTO_߻~w,|JQnue;;E60_8*<6i_.~qE!?<=I];fT!{M^k[esE.-	kg|~LK^Yk߶]bZAnJU֯ϭk\\aQ+s/Gاj9ChCm-R!	P\'JPJRJqc1c9\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0L3B\0o\n)t6:/&Z,bGWm\rkK\0B&{ќ٨ZXc8\0<~m6$s=*fYyUNץjAwz\'uqvꔷSzd.~qE!?<=I];fT!{M^k[esE.-	k˅Q*d[l^zkWۘc@mO,Le&$Vcῳ/|P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0$jͳ$30\\sfːŉ;n?\"C6]ZP+//[Yn\';NkpoͬeL\"}6Fʏ\rWl0K%s=HnRjWk+ٕ-{^Ws=\Z4|1V\\QfBˋo%BZysJļ,Ws{Åh.X,[c?x#s/	o/ZֹC9ιjע)z%T\n:\ZK#1\Z;YTf*Cjo}Թf=1X\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0sue#m&G=&lf,HB~D[eҥ9&ll*/|D#Dkr$|Hw}IZIٛq\'e<SY΋fbk__Fz˱ɖMr:~\Zr^Gdw[WU<ɰK>6X;9}ئtb=%.kZZY;˹#Fm%_Q\03{he\'R wu.\'\'4x}GqF~{պBU\0\0\0\0\0\0\0\0\0\0\0\0\0\0 okzck,^l\\cy\'=ZNkmGqNG6ٷ/(h63asX;Vw2YuZZQιOQWv#Aڞ6tn3$H!N\"CiRZR6}s6Wk}>gwעY>$MF;ou[-M}Qȓ2)E3sr5^#Je؎d\\]v9f}?\r{9/p2D;-+ͬ\'rt+_}+]I-5[tK#sK_G*+xR\0\ZnѴÞkzkZETˤ-	[:Lu-22j_.n[it_nf%[=sbf60Ǭv]RmډJӋ\0\0\0\0\0\0\0\0\0\0\0\00--k(g\\Y@;[IkmOI:t$v_!en-)Ns>+õy3;,܉&s|-Ervf>f(IL<N5˪\0|lo|Ѩj\0q]`{<.)vZz:º6x$kFE|ſ2V^wݪIcz{5iԴ+t7yVf(+HQt\0\0\0%]#yi{ơTJ\0=&Ļ|XGj5kNݶ)n*J\0\0\0\0\0\0\0\0\0\0\0\0{֤N]wu(;7Q\"L=kӹ|TǮvg84x1%\'X/L{tg5ܿZ~b&Po+4bG*>2V[Sj^S\0\0\0\0\0ә=2)stɺj<\rޣ?sjy?!H\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0/iFҷ{MխjmZS.Fp&el1Դg\nNʓgɩ|l[WOUEɺЖUoxmw͉WmuK\r_KB/j&*fSN.\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0%]#yi{ơTJ\0=&Ļ|XGj5kNݶ)n*J\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0}G!WUKMTmu;V\0\nET\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0y}Mz6sݾmu=W4ݞkShvtP33+gI8RpT8MKb8~z:.M,ք~Ƕ;nclLn˪Xm]B{Q5)S2qt\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0*Uv\rK5\rWܕ5%>UQE]v*uXaKqRTU@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0>}g~uBqH`.9HOY[kӛ\'?ܑ\0\r\0\0\0\0\0\0\0\0\0\0\0','anonymous',39,'Perpendicular',NULL,NULL,NULL),(232,'% Definio dos trs pontos\r\n\r\npoint A 10 10\r\npoint B 90 30\r\npoint C 40 50\r\n\r\n% Definio e desenho da recta\r\n\r\nline ab A B\r\ndrawline ab\r\n\r\n% Desenho dos trs pontos\r\ncmark_lt A\r\ncmark_lt B\r\ncmark_lt C\r\n\r\nparallel cc C ab\r\n\r\n%Desenho da recta paralela a AB\r\n\r\ndrawline cc\r\n\r\n%Definio e desenho de uma recta que passe \r\n%no ponto A e C\r\n\r\nline ac A C\r\ndrawline ac\r\n\r\n%Definio e desenho da paralela\r\n\r\nparallel bc B ac\r\ndrawline bc\r\n\r\nintersec D cc bc\r\n\r\ncmark_lt D',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\08\0\0\0\0\0\0\0!\"$23Dg#%(1X	&8Fd\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\09[ީ,wjJjzan#6ӟh/|\\kGmM+#k7MWNN奣f\"|HxуpgJYu{4quբQ*D|$\r\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0dC}Nimn&Q7~:Am|lvmV/U8G16regX{LMk\0\0\0\0\0\0\0\0\0\0*poyzpik}f\Z#7jҭ[W^ުVVlґѦ{uќܚ.:yv֠\0\0\0\0\0\0\0\0\0\0\0*SZ3gSOa)GnI9dܷcM2]Wg#9hjܔK%H,\rZJB5\Zv*:\n\nxXXhDǴM&cA&mMVȤ)2@\0\0\0\0\0\0\0\0\0Mm6-żrV=aFŷk\'n]FY\")bL]RyHZ]Vڄ,urT\rSe	戔6dt[6DSI\"\0\0\0\0\0\0\0\0\0\0\0ݪ jQ:*jCHxV\'m*3]ɛ;\nBH;gZs\0j1UNZ&vmvW\r*\0\"&s:.8Fܱ\\%$qƌkƋHhu\Z@\0\0\0\0\0\0\0\0\0OuT+1aKrQ\0Ui}Ei~wҪ,5vEJa+&l44\Zծ|αf	DE2ӊ2IGb2EU3x\n\0\0\0\0\0\0\0\0\0\0\0\0䯗cM7ƕuB!mWQRꊜ\"jn299G7f핉t\\3=2\0\nMJ\'y\no/NE<ݲbä%ICPrM=2\0\0\0\0\0\0\0\0\0\09ʯԬ*F!agGo-ĈHnݺK:rHݪ8U$meoZ]`~^̳H/tZ^Q3 m-Ps1ئP\0\0\0\0\0\0\0\0\0\0\0\0Lnknk|ۜXn;A^pu	Irmg\"lʱ륏h\0\0\0\0\0\0\0\0\0\0\0h$jC݃XDzR?vީL2rv	bjtTJպĭbE6,ĥf\0\0\0\0\0\0\0\0\0\0\0\0اu<W\'_#^\0	l#U64{Ɠ8\rdsTUQ,=3.*~\nUWk5vŴd43$#!#YH0b4jH L\0\0\0\0\0\0\0\0\0\02fmMk&\Z\Z\no!dNI$rGz%ky9U*u&֠)*R!~XAŷ#HxX0b>p4d[y4ϿǸ\0\0\0\0\0\0\0\0\0\0\0\n,UB%bIƨoͭ]LX6\"3iΕ`n7k)JbwV0j9\\lSR7mGEf+Jl	6.͔#FU:wn\"t(*{[zNZ\0\0\0\0\0\0\0\0\0\0zr5\Z9mm\\ܚm]GOt5:F~gӡe7k#)ȉi5W_-oZ\\DH_/7Q\'Tqӫ.F[2pHdVR\0\0\0\0\0\0\0\0\0\0\0^Y6ˠ\'\ZV]DXFK*r6hϝ,>5[VHPBj\Z\Z0TP]	319jat+D,n;*뵖ѐqlڐ\0\0\0\0\0\0\0\0\0\0sw}g?n)R!iTQۓpf-Ku6]ʩ$xF)PZr^E/n si-vMerk_QOo*γN+6`\09	Tih+r/$.~\r\"9r)d˖tGAE%*\0\0\0\0\0\0\0\0\0bC}Ujmn&Q7^575Amz7f/tU:eϤ9Ek6Rk6\rXǴ\0\0\0\0\0\0\0\0\0\0D\'7[iwk\\kO-?Ѕe@jOZ\\*gTRs.\radVz+ j7:IXű^i0Jfެy\'؉gkwz9)#^R)7 \'ItQǎ1	#;j3w6~,9%VXQhu<QiVK]\Z}uM[;ΖMeb.Uted\Zsӗ$)KҷE9Sw&#s/^m}גؿξ$Wom~	\0Y6\0w{o;θ\0\nF(/l\0>Djz$F6ƨ__{۷G?5OPαk!:ZQ4yK3|CjmN^*W/.LeXS\0\0\0\0\0\0\0\0r5`<Рa-sJfƟZpB`۸b\'ᬎwJ%Fe=E_T xxf_dtD<Dk4iٻ&ZfPI\"I\0\0\0\0\0\0\0\0\0a]N53l;e2UCHsL\0NIĻvsfOb]yQ!7ryapv_&^G1q^E%`k&ߥ7;%/\nuޭ!vPmuIJU+_jUmBo)Jev_k|HhEG4D5V*AF$fȓ\\WlRݲ\0/>Djz$F6ƨ__{۷G?5OPαk!:ZQ4yK3|CjmN^*W/.LeXS\0\0\0\0\0\0\0\0\0\0]wWb,4ZN5CxVmlV\rVzbu HttAk_JU\'ǩVibj:,4ZUdIIwDl\Z0[qCAT[ժp@\0\0\0\0\0\0\0E1lf-u-c;Ϥ%[,\Z\"pI3 	_lݜ+\'<1AgJ&S.,_M\0\Zyz<uyxr2nWWo$nU4:)ɷ\0ώ;/m(4t$/:ܵw *R,?J.`t$Wu.YԌig+ɷWύQX59L+T4zUjc& \Za~wiMhٖyBj:C\"fkj>oYt{33fQQò2uGhi7{Gt8Ǻ(:6B`]ag|5zD䋫0\0\0\0\0\0\0\0\0\0\0\0Jzf4.|i[T\"Nfޕua\Z.٢._>vxV##|xn߹nXFGOy#C	h0hS(RAw8&0gЭZֻFBnMɳj@\0\0\0\0\0\0tŲԵ>lhu\nry$LdZ&,N}vp;tf(&L~97Dio3a.1㧾Js3ɹ^N]Ttb&W>;콷L<rI|lHH*#|\\-lfj=gs#[7{R2y &_N>5Ebpֈ2s1P9U-dC)ؒeEWjK-09Ks\"7sc07qV3ꝒuaZSk|435ȻS1V*$P!PROkp+dE68v%##,,%Ic}]5r&^(RgC\'JjՀ\0\0\0\0\0\0\0\0\0\0\0Skq2	nsa51{-©$s,.}\'y/SYlYn*Ǯ=\0\0\0\0\0%Z.d+1kk}!*gPHɘ)LXrfY>vͲ:Q4M3qbro^gë\\-cO|f#ry#v&2HGM|w{oIDy\'ay嬓R`TsF(\"[t}/zFn6dK>A^Mw̝V|jϺe]brS3s[|Sy%=.\ZLV:)Za$s%圗zEG.oTM`\0\0^~n-(X\r3 _OΘsުP˼qE7Qȝm>DD*<ݠ\0\0\0\0\0\0\0\0\0\0\0\026bn\\_4[z,%iWSHCw\ZLBS5QW]Dp̺>稫*V]b#k#ѐPP̐f-###7dTRlѪ	 dI2\0\0\0h-ŮgyeCD[0S\"c&b`!1`ru훳dۧ#6,D4eŋɼ#O/[|gy1pُ=V__Mt\nؘʦE#6\0e%f䝅\\{NdJEGPEne3U;\Zٸڑ,y62uY+G>Ev#QʭLtUαl{ ENWĔ,j-2UZ\\Ii̗r^9SS7i\0\0\0(65zVl¶lMySıi21}$DJ?^bi2&k<䙳u;vT4\ZjK)15zv!\ZEAW!?Q7j\"\0bI{\0\0\0\0\0\0\0\0\0\0\0߬/ACF\"Zkz\Zn<Qd\\p$z5!$VjwZcA4qMHݵILft*Vݲ\\$ڤG6PAT-ݸРyo8FMk\0%Z.d+1kk}!*gPHɘ)LXrfY>vͲ:Q4M3qbro^gë\\-cO|f#ry#v&2HGM|w{oIDy\'ay嬓R`TsF(\"[t}/zFn6dK>A^Mw̝V|jϺe]brS3s[|Sy%=.\ZLV:)Za$s%圗zEG.oTM`\0\0\0\0\0鮛%1<Κ}i*.9&F\n޴Y&ǾAU[m$l)vg\\D0쌹Qii.5y^0N10,qyj,4D%/?)^Q$a9\"\0\0\0\0\0\0\0\0\0\0\0!S~JcP	ZɫL!RءMynvѩWb[%bU9r<R7zkN_3-\n|+enI\\jpRdG5w%\"D4t\rԈb\\g}n1NzDu]a8ΙGg3eK@?ctbrngȕh-ŮgyeCD[0S\"c&b`!1`ru훳dۧ#6,D4eŋɼ#O/[|gy1pُ=V__Mt\nؘʦE#6\0e%f䝅\\{NdJEGPEne3U;\Zٸڑ,y62uY+G>Ev#QʭLtUαl{ ENWĔ,j-2UZ\\Ii̗r^9SS7i\0\0\0\0\0\0+NzͰT)rvK5Q_B>\Z]EDTLT\0j(bY\'i8\rg\"g{i;NY\Zv/HHW|3!nj\0\0\0\0\0\0\0\0\0\0\0]O_~t<yd{ϗ=|o[aEiZɃ]&I{w\'$EZ#aǙ<~íxXb#z&h>|ZGFV8;\rfv.Y)ȽqC{&W>;콷L<rI|lHH*#|\\-lfj=gs#[7{R2y &_N>5Ebpֈ2s1P9U-dC)ؒeEWjK-09Ks\"7sc0\0\0\0\0\0\0\0\0\0bWqnEjnvMtT]㍲)Di\"!U\0U\0\0\0\0\0\0\0\0\0\0.vk!%5l:ZQ5gtW3|CӂjmN^H.JTXO\0ߘ#U<yb^Jb\00G:_]\'iq$wd\0e$/:\0[ *R,?ղW?\0M;^G_\Zq#|J!/nE8<Rɘfx-fsʍ+0,uQeBB\\o6:N6>eIgt4-ZZq9y\n\rY@kQPPD3F>*&.=i5cź3lmڶE$L\0\0\0\0\0\0\0\0\0\02n_-<`k,+k6ˤו;yLKs#\ZWRDMD^F*Vqc\"jxI0gShʅJAVԸ8BWWbT~	Sev/$y{\0\0\0\0\0\0\0\0	vY.gy҉C;ʿ\\lWnzr$E6xuV袢*}Nd7\ZޱͽozV[9Ě1?M#&\0;/my\'ayR`\0%⾘aȍWoD޷?Qa{v(!d>^SKJ&R)trFo|=\"QQ_͹Uw*,v돳HH*\\[Vͧ˫M),݌śظZ4^E9#g\nqx(\0`*>)))xwmIizdZZ<vAEX(\"PQ뉳Va5\0\0\0\0\0\0\0\0\0鮛%1<Κ}i*.9&F\n޴Y&ǾAU[m$l)vg\\D0쌹Qii.5y^0N10,qyj,4D%/?)^Q$a9\"\0\0\0\0\0\0]CKjtk+r$fç+ ۞I&M:]~(ʟe\0S06\rF7yzo[o޼`u&2|OnHɷ\0I^u@TX$21Ge/=gy#U$w7y|5D\00G:C_ݾ\'8qzucY6Wy҉]6\\HT{WnzrU]ʹxug,2\0;AԲMD#P;Y5m	匓xfefEfpRv{ȍ,Z=^:>Pj+r<Ǩ6m3q+,rhiife<o\0\0\0\0\0\0\0\0\07qV3ꝒuaZSk|435ȻS1V*$P!PROkp+dE68v%##,,%Ic}]5r&^(RgC\'JjՀ\0\0\0\0wFLՓKMvjw\ZI95zv񽞑a|Dg-:c\\_~fufoOȰ%T-Tn\"nҪg(Q/+3MXuŒP>EZNlm^C5BeJVk\\^=#,w^ɕ\'Y>VU]Ou#NH6&SpnO|mōd\\;_g؛,~ꞙbC9ti%.M$f);%۞UWr^:]~(̧j \0\0\0\rS(nnĭoI=VVVV6CX_SѐɆr9QVV}-	IS-\0\0\0\0\0\0\0\0\0\0ߪ[p-VwLc\"h3?\\$rmM`\'p[O\n\0$Ojh\0\0\0\0:Q5dRsݬF1{ƽRNMt^ogX~9t!xNd.(<}_asGoٛ,.~CcDs(UH~-K1wx=Oב6G$Wl_סz\"؝S9azJD8:)aϫ	§r\nx`YmqC&*v$s5tL2gNd3L??lV\ZVq\"6|arU\\~WUn\0\0\0\0\0ɻdֹl/B.9JM,Qk윶yN\nB1RIhz$ -	iӰ0Px8jn&:]f:&!1Q1qI-fɛdnղ) dL/=P\0\0\0\0\0\0\0\0\0v=emFUalPlz_9є#z$B:^x۶$Σ*w	PVh5J\ZYSbjjCr40B2\"96nղEĒ/?^z \0=iǲXjlIO[%\\U΁LuQo7\"yg%{6M˃!1U@dg\Zٸ<y6kfVWG>Yt#MLE2-\'I*;~l-~6VGMY4=æg|ogESvoVټW0Oǈ8!ow]E̚:Tpz&yb32Qf+Y[\rz8zStBm>aT*^Mɿv~uw+z~@\0\0\0\0\0\0Wn]p5(VwF5C!<rV͉rNDlNEDi5s֧}\\w-iT;yw6dۆj9D#nXUQFq5EԇR4:lxV\rj\0\0\0\0\0\0\0\0YRuNTQY*eě\"y*oЉ1K&g!HgTKlk.6sm)HgsתnZ1o5lخ5T/H̥SڵceC|ߤ&\":QW&o^m ׄW#8#U(U1sq|UYYI.ZiUНN=\0(ѓ9	\"΍PV@T7|	\'kWDEq+ڦwSIoW:UisSTaȲ^Yx^󍣓rD~}P76Fn6Gz4>A^Mf/ZټϺdAbdlSC_2m\0mzm;θΣZs\n.i21G<v˥xŋ|#O/[|g1pZ#_Qؘ(E;)d+>u}!*2\Z|H)(LXr&v:QEU\0\0\0\0\0\0\0\0nL֡c&[WU8SSpfNFH s\rZ<~hnߺnX#JNLyE)^R;wa!+FnEa|K~5&.	SЛSrI=*\0\0\0\0\0\0\0\0\0UESWa9\rM[e`0wX*ӳpГ\ZJ4m~Mg O.7g\ZFpjgǪTb{Dĥ\04ʣQKB.BWu+?r@ k\"]m򲷃Ih?bϙeՌ)`ȩnoJڭjYˬwQmE9Cel&&;콷<l5<lHH26#|lWX-g\"4Hz0}u/\Z1e!^H݉tSRaxBYnOk3/QNO$MbbŁ/pinXP\0\0\0\0\0\0\0\0\0\0S[[Mߎo[~n?U!nNwM}5Y2k69ǮZ\0\0\0\0\0\0\0\0Eq+ڦwSIoW:UisSTaȲ^Yx^󍣓rD~}P76Fn6Gz4>A^Mf/ZټϺdAbdlSC_2m\0mzm;θΣZs\n.i21G<v˥xŋ|#O/[|g1pZ#_Qؘ(E;3eSO7G(w?w`e`H+a̶bޢ;2l{wjܽF\Z`vLY7E6mMV&T[l(B&d)R>\0\0\0\0\0\0\0\0\0\0\0Ojvx͝M=;SB^e\'\'rݍ6,v]填rQ.甖 p6vj+Wckب((vmaab4blI6[\"DR\0\0\0\0\0\0;u&jY5bz;xH>\"s۳B1;/;̇b/:擋˔Ud=cm:c=SQ˧Tdr\":Ed\0|SUvqF獐)	]fdb3txJW3F^	B&^boeTF731d#/+1RQwNwS3/V|-BU-fe4)1T)SP9:.M=|t\Z-iƼjN\nnn!Ѡ@vFM$$J$~,V3^!J^hj\\\"W\n[r4h-FLE	L\0{\0\0\0\0\0\0\0\0\0\0\0\"v8F24\r!Zw&lN۔\"s$+g-\nu\"(j%tIV;kLC˹\'^4T$rplM\Z3W\Z.=\"Y֓gW°kU\0\0\0\0\0^2fZnP/{תIɮӷ\'=?Yn/	옾PE}2\Z\0TO.h33z~Ey,bhw\nuvVo9E|8·}oǩrz&}M1||V$[{,/Zw)H7WP_,>!<xTnCݛUo+-7Hd]dns&Ε1`ئL̆igV^0N$^5ЛOl.U9\nroݺ_]ޟ\0u2buRܵ;l?Zvzl_=n𴪤K);h#\'kҭJɥ\r%0<>Fuk8hG@&h⌒Q\"㘱Qk%v3>i:gl\0\0\0\0\0\0\0\0\0\0\09+꥘l\rqnPy;azUEk#f|ڽ[jNQY~ea=:=--FE&C	rZ3rWo\"͠X_ Bi+a-tܗ=6\0\0\0;u&jY5bz;xH>\"s۳B1ɋ].QyD^3:߳7X\\*|P7^7iUf3[c+?lzW+\"lHؿCbE:r{q~uuRW\rO<-پ[f_O?\"{tMUvI2k,S\rdΜfFI~حel53DEMXm	Sy7&ۥܮY\0\0\0.U|dݦW*5Y\rv@+8x;|n$EVWE#u6YӕzFPY©$|m,z<\reMDaxç\ZZMlYihچn&5\0\0\0\0\0\0\0\0\0\0\0/7Veu^s[qjbH[SHX\\O^k>/`ݮU],{@\0\0N{(ɚ{inMC^\'&|/N7,?psψec\'LrbAa˔c@kQ>װηy?!䱊9*פMUY%\nG[iț#+6/XlNhq\"tߝ]A|ogESvoVټW0Oǈ8!ow]E̚:Tpz&yb32Qf+Y[\rz8zStBm>aT*^Mɿv~uw+z~@\0\0\0\0\0cO\'_ǌ\"nMDh(yR;wcgEC&SG{w \0\0\0\0\0\0\0\0\0\0\0<jDYhn_e5`d<jc%$ÆO8EUAT6]lS˞+擯בk`/Bz儶_*\Z}jb=i}nIJtc9**먖NG~S+Dm~_b2\Z\n\nE|dd{f1jM5A$L&R^2fZnP/{תIɮӷ\'=?Yn/	옾PE}2\Z\0TO.h33z~Ey,bhw\nuvVo9E|8·}oǩrz&}M1||V$[{,/Zw)H7WP_,>!<xTnCݛUo+-7Hd]dns&Ε1`ئL̆igV^0N$^5ЛOl.U9\nroݺ_]ޟ\0\0\0\0\0\0vtLzVl@\Z}UIcױIA5	e?vAjI(j±kjvZjʭR2[5MT$34c⢣\"RٓMlsM$^{\0\0\0\0\0\0\0\0\0\0M L#\".ON\0Au\n*-#VVtn	#[LrP|\0v>OGdV[zrFz*<&̯Ye[0]Ui<GF酁so\"<Yd(S%k_egٽKOS96ZhGRhku\':jӨZ!^+0[x\0}\\&޼9\"Sb_+Չև\nR!MK}_O 4^>fUm}>3xm6W{$[ɬLwg6):s!e&abת-7Ma&NBܛnWrwd\0\0\0\0\0\0\0\0WtM\nM>4ΓvoZ,HEx*dlF6Og.Yx\"_|vF\\m\Z<h\'@eGFL85v\Z\"ORRPuf\0\0\0\0\0\0\0\0\0\0i9ka^Dkpll}7Sh)lR\0<ϝ\\̣\"uW>b=>\'t-&.X2\"3ܳ_^>h^;_0*mDO\rNAӘuZWƲ5\"q5A|g(3JVQ\\^o9~*U2HysIg>o;[?Ufb&kկSf.yHDN\0\0\0\0\0\0\0\0\0\0~jQj+evQg+hXFKKJ>\\d1bw+Jf8ns*{Cb\ZNlyYȳGĤdc哅d8~]E*Ld[Z\0\0\0\0\0\0\0\0\0\0\0\0bC}Ujmn&Q7^575Amz7f/tU:eϤ9Ek6Rk6\rXǴ\0\0\0\0\0\0\0\0\0\0\0c5/=*,\0^:F\0\0\0a\0\0\0\0\0\0\0\0\0\0\0اu<W\'_#^\0	l#U64{Ɠ8\rdsTUQ,=3.*~\nUWk5vŴd43$#!#YH0b4jH L\0\0\0\0\0\0\0\0\0\02p]l<aʥ`]sE9,;#ٸj꺣k\r/1BĻjFJET-^J00quZmؘ(F,[ ~SLM׽\0\0\0\0\0\0\0\0\0\0\0\0qZU;:hVjG5b8\'mzuڸQ\ZG	G*K~BJ\Z\rY7jFLc3iV&%9h\nYnUSk}oV2k]\0\0\0\0\0\0\0\0\0\0xZЛbR[#3n\nfH5:><y(|+4GޥkFuxEFhþR_cM*KkU~KL+\0\0\0\0\0\0\0\0\0\0\0\0','anonymous',39,'Paralelogramo',NULL,NULL,NULL),(233,'%Definio e desenho dos trs pontos \r\n\r\npoint A 30 20\r\npoint B 60 20\r\npoint C 40 40\r\n\r\ncmark_lt A\r\ncmark_lt B\r\ncmark_lt C\r\n\r\n%Definio e desenho  da recta\r\n\r\nline ab A B\r\ndrawline ab\r\n\r\n%Definio da recta paralela a AB\r\n\r\nparallel cc C ab\r\ndrawline cc\r\n\r\n%Definio de recta\r\n\r\nline ac A C\r\ndrawline ac\r\n\r\n%Definio de paralela e construo paralelogramo\r\n\r\nparallel bc B ac\r\ndrawline bc\r\n\r\nintersec D cc bc\r\ncmark_lt D',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0,\0\0\0\0\0\0WX\"#!\0\0\0?\0\0\0\0\0\0\0\0\0\0I[NOeOך152qN\\3pΑM즾UdYۇq֗[>í4^M%uj\0\0\0	72U)*{FGZ+aeMr&j-qR2:+38ꕆV@\0\0\0\0\0\0\0\0\0\0\0\0\0kw+}g^-wJ:[\'`5SSyE5Ud[\'O\\rJ)(gO<:N3XɅw{dk %0Oj+OūQ\"SfJg\'qXV%i\0\0Ht:׬l{7_EI:]Fի)X:Ȟ\n4}UTllt4sb5j(&ՓflI&ZI4i$	<f\0\0\0\0\0\0\0\0\0\0\0\0o\\}Ϭmq\0aߚBί\ZCL0qVr_:.ǭ4^M{KO:\0\0\0y<}ٰ>?aΧho3,zA}+3tZm)fKmhӐ3rɰ\0\0\0\0\0\0\0\0\0\0\0\0\0VνZIu9oONkQnfjHȶN$SPy|1ubfgPm\nn&׼@J`2Wql!ufy	WzXE̔Oh㱮&J\0\0	u/wX{,nk]vtՐu;WS׵3R1Wu<i$hED2k\Z1ѱPM&5M&3lMڵnh7A4I<x\0\0\0\0\0\0\0\0\0\0\0\0\0<޸ϷX\0MN+.ᇍ4\n_f5a&㬭4岾t]ZhJCu\0\0\0xa}n\0NfXWvf6|=J7rR:ѧ ga\0\0\0\0\0\0\0\0\0\0\0\0ܭ{P߮\r+=nrlʜ1֢MN=Wl=qI(<c:Ρb&Mx<e0B>F-M)<c]cM[앧\0\0	#7(_W^Y~)$w!\ZwV[\'kӐ:f`bCt\"x()IUQ\"\"2d6..5ccVL2jMf$j$nix\'8\0\0\0\0\0\0\0\0\0\0\0\0\0yqok>W]?~h:kyu0MYZie|{6\r-<\0\0\0Xfðp\09\0:>85<m{jn䥛.&uN@!o&\0\0\0\0\0\0\0\0\0\0\0\0\0[[:k]&\ZWz>\08cYE{)\r#\":z㔒QNC?yǞ	ՊuBŷL+؛\';^)xPa]Ű՚}\'-]aWZ2S8y=ƺ\'+O\0\0Gk$nQԾU޽ceٺR-uIVB5`^O\'1O^ק tJ\\6זDQS쒪ccDD0eɬl\\\\kTF1A60d43dͲI7jպII$Oq4\0\0\0\0\0\0\0\0\0\0\0\0\0z>}ck586*u}&aӖv=i\r*mZy\0\0\0#α͇a>s\ru;Cy|qcj_E٘xۥ+lK7\\LkFCM\0\0\0\0\0\0\0\0\0\0\0\0\0ruB~L4S}}\0*pZu5;0SU^\ZFEt)$\"~<3:olWp;w6NvS»a40OZ\Z.X6dp{Gu5nOV\0\0\0$HHܣ}^zgu\\Z봓ެkZlNbN@隕?m\rӯ,H%UFCG0`*&)Xظ֨1bmY0`ɪi6fɛdnիtA	Ih\0\0\0\0\0\0\0\0\0\0\0\0\0}jq_v\0<mT,1<My7ei-zE\ZT70\0\0\0Gcݛ|wv0ǬҾ0KﵪVٻo丙֍9</-\0\0\0\0\0\0\0\0\0\0\0\0\0\rnoڅti^QsdTfjva(4dRIE8E	x\'V)fu0vbl{	-AwVi`8w5]^jlL;\Zjܟd>\0\0\0IGRWzfHi\'OY]z<={^5+pX^YFOJaTLS&qqPcڲ`Tl͓6$ݫV&tM$<1ǌ\0\0\0\0\0\0\0\0\0\0\0\0\0#돼{Y??ax@Yc[xn:N[+E48oiiX`\0\0\0:Ǐ6ۇ6\raŏY/}fankTw%,q3\Zry_[y6\0\0\0\0\0\0\0\0\0\0\0\0\0\ZY׵]0ҽN-:j-QMUxip/<NS-a]9	LZ\n-.8<qjTkbْv5?չ>Z|\0\0\0;]!#rz/erkNzujy9z9jV*7N\'\"dU\r\"!(McbZ:69	d&ٛ&mIVM&I\'xc\0\0\0\0\0\0\0\0\0\0\0\0\0H՛ʹ\\[#bo«Q5Vz\n#*YNI.&5ڴ*H#vv\0\0\0xa}n\0NfXWvf6|=J7rR:ѧ ga\0\0\0\0\0\0\0\0\0\0\0\0-U-VvIUWmVi8,xz9̛̼$a˥pA$Ϝp֩`l{R?w3ٷhgNOG0k\'\n7vבUڌ|17Fۂ5h \0\0Ht:׬l{7_EI:]Fի)X:Ȟ\n4}UTllt4sb5j(&ՓflI&ZI4i$	<f\0\0\0\0\0\0\0\0\0\0\0\0/m}z\0A!Y\0{nxέZ׍>r6mՕ~Q]V)}ε卽P\0\0<>vn0ۿS7=f]_}Rܔ%ζi9Am`\0\0\0\0\0\0\0\0\0\0\0\0\0kU~U]hiUe(&^s/3&6.4XG3r\\Ee,I%39uX#[6m{g\"(ZſuUb6tх)Z\0\0\0;]!#rz/erkNzujy9z9jV*7N\'\"dU\r\"!(McbZ:69	d&ٛ&mIVM&I\'xc\0\0\0\0\0\0\0\0\0\0\0\0\0KwuvHca?۷\0$sVk{;Euoχ܍[ue_WU?J_j3ycokT \0\0\0:Ǐ6ۇ6\raŏY/}fankTw%,q3\Zry_[y6\0\0\0\0\0\0\0\0\0\0\0\0\0\Z_lkd0Zu~ffs7ףɸMKܺWYlK,RILx]jǾ-\r}=v{sp|1okyXM3tam n/V\0\0\0$HHܣ}^zgu\\Z봓ެkZlNbN@隕?m\rӯ,H%UFCG0`*&)Xظ֨1bmY0`ɪi6fɛdnիtA	Ih\0\0\0\0\0\0\0\0\0\0\0\0\0ۣv>Y5/c[mlՃm5]kuh\0[^eYY㪹3IY7zQG$,^$qWi>}f=G:jƷW^6}ڵVUEuZHS:ז6uB\0\0O\r:55;m=Ime^sXdamդl d\"Dek7[zkGӒ*h(d\ng,vw5.PtߖO9fnY5Xcݛ|wv0ǬҾ0KﵪVٻo丙֍9</-\0\0\0\0\0\0\0\0Yiv?K53$}\'\\^fOO/xǗey??mԧ_mԧ_mԧ_mԧ_mԧ_mԧ_mԧ_mԧ_mԧ_mԧ_mԧ_mԧ_WQLiH{zp_:!g۽mN?u`\0t;_e>tg=ǦkkܝvioֶKT:ÇZ\\Jcws-9/gg%~vyaQbgǶS/S/S/S/S/S/S/S/Bm\rP0ñYYXb⧣[M3QkO+\0Ѳg\0+AvHם=aHߒ{EOW#v:/s\\us<\'#96q}}m(w,<Ƴl.>%h@`ݤsDYAcHf(fI4qdE<1}J~}J~}J~}J~}J~}J~}J~}J~}J~}J~}J~}J~}J~}J~}J~}J~}J~}J~}J~}J~}J~}J~}J~A73j-5?klMX)Jh53\'y9qω<x\0\0\0\0o\\}Ϭmq\0aߚBί\ZCL0qVr_:.ǭ4^M{KO:\0\0\0y<}ٰ>?aΧho3,zA}+3tZm)fKmhӐ3rɰ\0\0\0\0\0\0\0\0\0\0\0\0\0VνZIu9oONkQnfjHȶN$SPy|1ubfgPm\nn&׼@J`2Wql!ufy	WzXE̔Oh㱮&J\0\0	u/wX{,nk]vtՐu;WS׵3R1Wu<i$hED2k\Z1ѱPM&5M&3lMڵnh7A4I<x\0\0\0\0\0\0\0\0\0\0\0\0\0<޸ϷX\0MN+.ᇍ4\n_f5a&㬭4岾t]ZhJCu\0\0\0xa}n\0NfXWvf6|=J7rR:ѧ ga\0\0\0\0\0\0\0\0\0\0\0\0ܭ{P߮\r+=nrlʜ1֢MN=Wl=qI(<c:Ρb&Mx<e0B>F-M)<c]cM[앧\0\0	o\\@W^;wr54B6h\\ϛ&GojrLMVώVnsmY*^66:\Z9DCQQ1LƵAtlsjɃMSI6L$v[\rM4O3@\0\0\0\0\0\0\0\0\0\0\0\0\07>g6\0S\0aogWٍo!n{ɸ+M9lc֚/pҦὥa\0\0^Xav]>s\r\05;Ky|pgi\0fa7Ei%,~kgq?\' \0\0\0\0\0\0\0\0\0\0\0\0RZڝb$Ux) ͦ+*.ݨ6\"=<\0蓔v=\n:ty=q\";#7>j3^lN@c/YS:ٿJȤ)[:xsF#\nJ4A,6NS-a]9	LZ\n-.8<qjTkbْv5?չ>Z|\0\0^wpjI\'5#ַx,^6m#77\'&Zֻa]b8kս$gy\0#R>BFVe]N7)d:Z	Uի֩!理uJ9e6[$,(hED2k\Z1ѱPM&5M&3lMڵnh7A4I<x\0\0\0\0\0\0\0\0\0\0֭%ɾHr|d묚<)vݾ)sWb\\s(<a|ξ|ξ|ξ|ξPiU^{2\r2`F[bq.Zt=]1K<T?;spӛOJ6ז+vj+*͏+0ڞ눛^7,\rcub{bT!uտ釦{e\0k+zg_:G{e\0k+zg_:G{e\0k+zg_:G{e\0k+zg_:G{e\0k+fzMy8\nMuf[TvjF,QuZ}VzK-PPԫ(jzJ.#5x\0]kٝnZeZO&߂V7d:F׭Ymu7.-,\'l\"-v-:κ^ξ|ξ|ξ|ξ|ξ|ξ|ξ|ξ|ξ|ξ|ξ|ξ|ξ|ξڂwjgeBY-&]}W]Q5z\06Um8mq`*<\0\0\0X\Zenp4U 嬶9x&%%rHόrQ.88]+3V維%6ޓ;4,<%-I^կ`^ZYxvݍf-9Ά\0\0\0$HHܣ}^zgu\\Z봓ެkZlNbN@隕?m\rӯ,H%UFCG0`*&)Xظ֨1bmY0`ɪi6fɛdnիtA	Ih\0\0\0\0\0\0\0\0\0\0\0\0\0MA|#^_<e\nC8|1R.ѭ5^᫾dx\0\0\0Gcݛ|wv0ǬҾ0KﵪVٻo丙֍9</-\0\0\0\0\0\0\0\0\0\0\0\0\0eV7LH:RZc)1`R^Qq)jی.pE~ҳ<n{j]l9óB#RԚE=Z<f,u1Whhp`\0\0Ht:׬l{7_EI:]Fի)X:Ȟ\n4}UTllt4sb5j(&ՓflI&ZI4i$	<f\0\0\0\0\0\0\0\0\0\0\0\0/n\\}7?o\n^Ф<M#>s5\"\ZU\Z0M\0\0\0y<}ٰ>?aΧho3,zA}+3tZm)fKmhӐ3rɰ\0\0\0\0\0\0\0\0\0\0\0\0\0X\Zenp4U 嬶9x&%%rHόrQ.88]+3V維%6ޓ;4,<%-I^կ`^ZYxvݍf-9Ά\0\0\0$HHܣ}^zgu\\Z봓ެkZlNbN@隕?m\rӯ,H%UFCG0`*&)Xظ֨1bmY0`ɪi6fɛdnիtA	Ih\0\0\0\0\0\0\0\0\0\0\0\0\0MA|#^_<e\nC8|1R.ѭ5^᫾dx\0\0\0Gcݛ|wv0ǬҾ0KﵪVٻo丙֍9</-\0\0\0\0\0\0\0\0\0\0\0\0\04SvM6퍶on&erhLZW9=mqiyk[UcY/3k#s\\g=\0\0\0?ithOQn/\0oCݫNbIY+KewOalhA*Qllt4sb5j(&ՓflI&ZI4i$	<f\0\0\0\0\0\0\0\0\0\0','vsantos',51,'Paralelogramo',NULL,NULL,NULL),(234,'%Definio de trs pontos\r\n\r\npoint A 40 20\r\npoint B 80 10\r\npoint C 60 50\r\n\r\n%Desenho do tringulo\r\n\r\ncmark_lt A\r\ncmark_rt B\r\ncmark_lt C\r\n\r\nline a A C\r\nline b C B\r\nline c A B\r\n\r\ndrawsegment A C\r\ndrawsegment C B\r\ndrawsegment A B\r\n\r\n%Construo das alturas do tringulo\r\n\r\nfoot C_1 B a \r\nfoot B_1 A b \r\nfoot A_1 C c \r\n\r\ndrawline B C_1\r\ndrawline A B_1\r\ndrawline C A_1\r\n\r\nline c_1 B C_1\r\nline b_1 A B_1\r\nline a_1 C A_1\r\n\r\nintersec O c_1 a_1\r\n\r\ncolor 255 0 0\r\ncmark_rt O',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0C\0\"\0\0\0\0\0\0\0\0\0\0\0\0	\n\0\'\0\0\0\0\0\0\0\0!\"	\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0!\0\0\0?\0\00000000000006u)w3tlDRΩѹl*%R.oJ	zC#<_ׅ6Ѕr_=Khjq-{oI^B=\\Vܯ¢GCaNcccccccccccccccZKm-kZ!	ԥJޒ:ԭZֵzֲfK%/!ZneP97NHSY+Ÿ5GG<vR_ggCu8ep/-CXbӍ%oi+k;sQHRv֚h@*a8hm\"<H0 hpޒ1Gii\r:S`sq`1`1`1`1`1`1`1`1`1`1`1`1`1`1`1`L]u?ߗmqބ7\"*.FօnB^yM<#XIڛrbG^B|).}a{Ĵ&4#{Yq[Cr\n\rӸcccccccccccccccZKm-kZ!	ԥJޒ:ԭZֵzֳ&\0\\ϞϞ:-x<!p&^[wP>.ŧ\ZJuW9_Jv\n!K%/!ZneP97NHSY+Ÿ5GG<vRo8CG@:\0P.QGiACٍ\Z;MM(m%	֒k9ccccccccccccccc/6+ӽoR7E3T#s\\܄y4Gd7N)\0V+R]DW&hzLhGJ9 =F~:\nwֆзZ[mkZդN-jV)ozֵ{ֵ7\Z\\\rXa,M~y\n68p7*ɾrD\"X-=r<V㲔s>{>x{F+yl:\Z-@;i+{M	^X})ۚ*B|vcG@:\0P.QGiACٍ\Z;MM(m%	֒kccccc$P\0}U⽋|nT9wEvS~\rfqAd*	\nG|5».\Zqj9$-[-wQɎxd\'<Pa)cccccccccc/6+ӽoR7E3T#s\\܄y4Gd7N)\0V+R]DW&hzLhGJ9 =F~:p00000u.	[^9˻(1	:\nCD/U<20Wz54+ƈ)\'l*7u9١ORF*`PtXLI%7h4k O_NazA\r\rdNb0p%\n2D9Ɯ4?\n|	r<rv<\\[O6ԤQ:s֥pr*XL9I{~hDN03SMSYCB:OElX8ϗub\r8Ò_EɁkwz-ջ(ajyq<2DKtV(03ccccccc+ZBqimҥkV!:ڔ[R[ڕZַZ}dE#B0\\$a.jشI[nJ\Z+NAR㵤8@is5b\0!7+[L&it%bFYGSMh@*a8hm\"<H0 hpޒ1Gii\r:Sg7ccccccc\n\\½0svPc[t@n)O^xdajUhWROUnra/XM:L5~\0Sbl_>tsx^,@n|-9رPz9b\0&0:] ۓƌ0MI@Ŏ81\n11&\"\"\r!\rM-K>Ӎ8l;dg<Jӟ9kXXn,V;t<RY<Ʉ.P-)rAbHf&Q>0bA>f]RNǃcTG)**D3a\"RQ111111ݽ	,ʳɠ+x|Zt\'PXZ̘fK}	c:۹b*Oˠy$O6C23r#E5Oj3&QwM&tD/<v ;?:;f=v94+-ڢ\\llpzķ.FɣSj\"B~Lk3\0=շ7/:jmEk?҂rRj5vM2{QR(wą~m|?F1`1`1`1`1`1`1`1`1`3|\Z\n\r(sv\nJEncX4Dkr%;_Y*{-FcOmOI\'=.VjlnЧʘC,d]ܙDJV%9}\"V&$pt悘Iveid&ѥyiƜZ7(\0O<|\0=3oV#K?\"5#2ԁkO;m2a_T`˹_c1$	RT3[pF}r3s?)\'c*#΋\"@y)Z%|չ.ЮQ#b}<cG\\\nj4fޗ6[G|&$O#1 \"dYp1Bt;0GH35W4&D4܎{[ G6\ZXc \"mB(\rjT\0h@<<ʌ\'5҈\0+R?ҼЯI>6kokUJ/]\nFW#iծlRkPDdpcAs0-$y/9VAY[ʅ#LIh=aԫW?9ʏVJq.|jviԣ<U1FJ!f:qW2Aq.6i!&vo^[j-~\\\\LReK^j	UѩCjccccccccccú􂣮J݂*!Qb\r6B\Z.\\oJKpѢXx\nX:s\rR5f\n|<&Kߍɑ	TNdl2P@я\"(Uaql\"J\0>,qGMh)Q0$gaPl֟@qol)l\Z\\gaiţa$>~\'rV]cu8)gۤYDfVڐ?tmL!t\0lM:c@(O57\nk	#73v<LҢ<LQR!\Z11H^|9OҡSҕ $:v<	:NěޮĊPmZC~8\0)>ٜ**YpZ?4Lt^lcTyB#Ci6nqD%0l+\\~sϪܦY用\nZhh\\M\'&ö{GH:bd%x1~}MBԍe@#}kB7!/<M,|mMӹ1st\0k\nmա\n{w>0ɽZޓ\Z҄{,!Q_Dcs?NEWT\0CH!7%ߤ]swNu6բ}6yBЪ\r<K\r:[9P\07f.PS\Zwq	*4nmq\n+X\'.6i!&vo^[j-~\\\\LReK^j	UѩCh)cccccccccccú􂣮J݂*!Qb\r6B\Z.\\oJKpѢXn8wG0*2`Id5K՚t)4<P+4.~7&D&!Q:DAzF=Uu(\049!F&$qDYAZ~!Iiquq?}S*?OL9UpRiHn0̭ \ZLB)U\"_璾^jʗhWr̂AXK>L1#L5\Z3oK-ģ>\'`Ƒ2C,_c1$	RT3[pF}r3s?)\'c*#΋\"@y)XbG\'{iGSoTy	5:vNӱ&\"ayh[~Յ8\'68fLL_%U:G8L::LώcZn?ƛ)LH*ZKm-kZ!	ԥJޒ:ԭZֵzֳ&\0\\ϞϞ:-x<!p&^[wP>.ŧ\ZJuW9_Jv\n!K%/!ZneP97NHSY+Ÿ5GG<vRo8CG@:\0P.QGiACٍ\Z;MM(m%	֒k9;:3U~L^x?[\0t)\r}Y2]E9t7So=Z\'a盹T+=\nkİӯ`	spNVl:nqwHN}´0ybfPrjYk&EE5;͡&T\nU0@qE]\Z=n;M111111111111Jys*]]2\nMFa,y02hͽ.lLHFcA\ZDG§F9JH?R\0s^LC(s._\\#M X^ɩ\Z5cR,nCGVxmwnGζJQ1	JH>@Ň\Z,d?U}XK;`j~uaN	뽍N?Y)ypUN8+z9rvN8{֛SR#aPc8:hsALBLI$;f2C}aKe<N-$?BѺ\0\0ZI@[~M&9tj\rxw/Nc.j6+O%aƄ$nk|j\\;Y?1[,?Y#כzpA&nG\\8-D\"Fϛj;&9Qyʵ皔2:ٌ;8b{hlu\',u6uS7\r4ok;LעMoV>Z՗ף?&sWZkO/М:s~ZݽtƘa\'ʽt&\Z&Tr,x&GrHa.{H&wGȜ4椨qz(Rm΍iETB\nvDz&1mjKQeb@+6&Ʊtwk|b46bkmskk^Ծ񖗥1Ys}/Ѷ>GF\\umm55{94xsgч~Nny|4cJ<\0ӑU2y\0#o1|6\0;3dw\\ӰMhMnP*tNVT-\'9YyeƝBbʅ#M:ۛeB\n	勍eBzIgڋ_\0,6R0)WڤmutjP6rZ\n׺z<[/:ÓDh:t}w3\\.\'d\\@3j(:J*+$	_/GvĎO	mҎPީJ;_Dju}PabMoWbE(6-!?@@knkT,-SC/p61Ī<\\yq!\n786IQ9nSGTU44{Ozq	kA&JSY~a=LX$I12aB<ֆзZ[mkZդN-jV)ozֵ{ֵ*7{wqc/c^J W*Zb}7bEv!@LaFz||k9PW	2t5Zpv-8VƱS5T\'hiƎt,\\(#ă\rƇ+\r-\Z4vaJPHJ%:FiKZ+kg34&ԛDIYfk3bf\'eec\\Վzޙt-+T:)sڔ:iZޱLL{ݓD ptb	OUkSvF<qы`\0yOG*ΰ@A!7P @TAq\\iI#ʇ-ceŴkmJNs=jW	L\"-׿w趉DL8U454 =DVIJf|{iŨB.VL#[lL)GS&;N`qᐜ\"\"X8Ai;:3U~L^x?[\0t)\r}Y2]E9t7So=Z\'a盹T+=\nkİӯ`	spNVl:nqwHN}´0ybfPrjYk&EE5;͡&T\nU0@qE]\Z=n;M111111111`,mBlte=\\&_pCo9\Z8Pzn\\@;{0?18O-)v>֣.hHStcCt=*w# w/m5x늳Aн!ٟ\0<3[H3/לN*梽5\\tǟMZ`Fj*V*`f|OT}%M]<!o+i*ҵ\"iWi+ӭ32^zA *3CS8_1_1\\YDϳ)Ng\0Wɽ`F,T΄^!P*#9%όXȑ*iR\'6Ӯ_{\0<m02;І#dYc9B71%ZйK)GDvK)1St~e=vߢvP?wf\0jB&޼jc}.&T?G=6TrM	j9-\r?rI\0uHMGkMfQ^\Z:˿Ȧ0[Q#5+qP3>ux_fssV&sڞҕɈ|LiZn4+򅴕i֙uo?zIqllugۢ떚+/5j/t1*HmBl\"76`@=\'\rY5F}L<M&WM̑\rNdtP\0я\0$(Ukql\"J\0>,qGMh)Q0$gaPl֟@qol)l\Z\\gaiţa$>~\'rV]cu8)gۤYDfVڐ?tmL!t\0lM:c@(O57\nk	#73v<LҢ<LQR!ouW^~֩/T}C!/oٞ&KH4mǫDl<w*gT-tx\Zurl?Nn	͔\\C.46T)\Zi/VO,\\l*.CMK=|d((Z g`8ʗJ&h3RiS00000000000򵡴-m*Zֵi(BKZ%)Ju[޵k{gM=<tZyB=#\0L\rb|\\N4qrD!I>;ZC;V/K{q{^B͎?\rʠro>HV)qk\\x4pt,\\(#ă\rƇ+\r-\Z4vaJPHJ%:sp2^zA *3CS8_1_1\\YDϳ)N`3LkK>0RYBT$]ޮAJ\"pGA\'m\"9媁|̨11*_f\0tz2\Z6)zFJ4ɟz烿aJCz}@.\'@r\rޟ\\GL~#>]WM՝f>%R)`g|rl[y\0H12M%ƽmlci[Dr[Fw^^ghҐku>\rWG]9ͻzU{%C71\Zl\"5\\ߝϯᬕ=̖Ea:fTb/sUU\r>\rmJҫև\"aIikS\'\\W>+bG=δ5vks&5n:q]J\0rv U\"IiKlԢBmOI\'=.VjlnЧʘC,d]ܙDJV%9}\"u_{r*ZW/<z}P-w:Aпfx,.\"ӺvMCd&\0nPةB&lcHV2ǢW <jA	+O{,BuN\",M񪕾/uVXuGz \ZpkL~#޸͏R5zt=A]HÇKڐ i2sb\Z:$O80 er%͛.Bۏ$X,2uiBTxG[=1;W[\"t&`ӊf$ojKM9R^j~EqoiF\07s]\nFԁnLwD:\Zh5;>@J\Z\'Rjo\0ѽq4gp^%kz:{/)ܚvXqEFsH1111111111ɋ_{\0<m02;І#dYc9B71%ZйK)GDvK)1StL\\?/ohB/%ϴL5roqƄ~/t.+rsnWQ#q`1`1`1`1`K_!-b@#SۙI`=F	0F)jʮN LY)wjՆcp-pA/Xju#@z}ʉzh\ZZWM5\\mA6%ķDQ3L:HptxWYg\\`8pC\nbbbL	\'DE5BD\n[/FX}\Zqhv8éyH=yu\'g?\Z9k,֢MgG:ia\nP@Jn{EdxTO#XOofgE`|vʊg <q`1`1`1`1`1`1`1`1`|hmqťJZJjR֥oIJRojVkZkY3yՋ^osc7}2m$O,bq\Z#g;)O醸d()֞sl;;(m_QMΤӯmΕ\08C8XQG\r\rGV[f4h6\r6\'ZJun111111aOUAQasn^^AvMv~!~A.Dsk%Os%xhvb,c7`IͣC0u)ɰ*M:IYr$Q/&)ވ\Z\rZD!K!bk\r\rdNb0p%\n2D9Ɯ4?\n|	r<rv<\\[O6Ԥ7ѷW\0;j,Лמ?dD}I$,sNYZ\"`<[xZt^rcT','vsantos',51,'Incentro',NULL,NULL,NULL),(236,'% Definio dos trs pontos\r\n\r\npoint A 10 10\r\npoint B 90 40\r\npoint C 50 60\r\n\r\n%Desenho dos trs pontos\r\n\r\ncmark_lt A\r\ncmark_rt B\r\ncmark_rt C\r\n\r\n%Desenho do tringulo\r\n\r\ndrawsegment A B\r\ndrawsegment B C\r\ndrawsegment A C\r\n\r\n%Bisseco dos ngulos A, B e C\r\n\r\nbis b A B C\r\nbis a C A B\r\nbis c B C A\r\n\r\n%Desenho das rectas bissectoras\r\ndrawline a\r\ndrawline b\r\ndrawline c\r\n\r\n%Ponto de interseco das bissectrizes\r\n\r\nintersec I a b\r\n\r\ncmark_rb I\r\n\r\n%Definio da circunferncia inscrita\r\n\r\nline bc B C\r\n\r\nperp i I bc\r\n\r\nintersec A1 i bc  \r\n\r\ncircle O I A1\r\n\r\ndrawcircle O',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\01\0\0\0\0\0\0\"	!#$%&b13AC\0\0\0?\01c1c6zHz\\3FĢ;``vg2^R%:RFp\'K-[]\'c1c1c1cO=/gO)ugp$ANv\"j?ttJ[ҝH,۞]YyO#jrS\r4mo \\ͺw.閔!T|̩Nmx79k{1c1c_Ѵ)/?})Z*A&N\Z\"Y\'iH/C[);\'[̯QG\nӌCtZERf2ZRŐiZP)Zƻ1c1c1c1<()cca<Jq1t!uH]/\nz7+x{R2,v=\0}86S\0t$_\"HO4ޝgTkh|)ϫ@=\"lqr3V[$\\Ͳc }q֛~ve!	zF@k@1c1cKGqeaeL}{r#\nqO	DNqo\0W6!,y1c1c1c̣vzGrYQTyS~4 u`^33&9TEmZ#63̰\Z0Z/)T\'h0<lm헑_Wirh	8;\rdc1c1c0sX7{%__icG2J7f7#Wn]<B؇CU?c1c1c1gJ7A_0.:4W$RQAKkcQx%*T5:B13/%0H˿d\'-\npWղ\"y2zzLYgq1c1c1ZyUmCR\0`X6/|ƺ#ln\'yN1c1c1[?զ4:]FYlrBEq4j F~{xH1[xirz^n{6ӒTD|a7HRXDO$)Or*>C(:J&q2p(q^!ޔ/<C[&1c1c1c&a|lDi)#mǙ{cSޖ{ޕyd-޹%(_C)c1c1c3HR wb~GiD]lAAwS3+.RP)-!?r>/|&?k^=IQ()gJi%~O&Ѕ\rz;\0-#nM׸R;Av1c1c1cmXKNH\ZVMKi1}\0\0]k2o-ڬ<q{fUI#GVGT\0٠t:88y1c1cHw<ߎfPG/2d?\r[JV/IJ1-ѬU%#j<je#%a\Zڤt>cdFՊi)	.XDi!Gl\ZF\r\ZF*\"\rW1c1c1c0y]zS-hJ?zOK~+]ROoe\0zyk?BAУ1c1cg3Q9qa˓!i{q\nUN9+=5L5N/`SûD=~Kr}0gŜ%עzC[Oem,H*:\'\\:$z\0\0d`BGF8`lqA(lhi%	Ju1c1c1c1ޫ+\0_TL:o\0ƈr>4o\0)c1c1dѻۑֲ\Z\'ٍ\"f̃4nS0ۯ(% BLn s=B\"]2LGYkpfkVEuNeswC#v):TAerT1H\na2P4䐡үW+EИ1c1c1c1\\E/AW+G^jҷi\0OzL}4R=u\'9\Ze1O1c1&\"k2pPqMML\Z4dL<L`Λ#))$ki˯m6FMקK`$wcQӺ4}K<9MVhҍ}n{2~=.I\Zl~vنy4rZwZ_`MIr8|5 vmI%$2QsҲ2e[1c1c1c16,%0BNCs&ȴjC:oޞ$_\Z\nZC8PB^u{h\\a-U\noXcF/_\0@0_Gyرc1cuLA8Iң?:Lh,ʍƏeў[,0*Dy-N߭jg%^+|7H6$^ԙ!އ&XQ\"HDIDCs<\0*Lz\0/Mc1c1c1c2`|RǦpz\0*\\{hӄ-a>-\'.̊q%{c1c%{7t^l1$=[$\'dm\ZsF:|cBi1z(\\aV.xmk5czNj-.mTF}=VF9Zȸ\nEud\rDܤՌc1c1c1c1jzGԔv3ٛ~!v*Lp.J	$C{q*islӸ1cu׎hTe9\0Q[ʑ<b\"C2)g8Ȏ>Jsy!ΨF亇o3˲ޞ,8rµs)ʪVR+\nm~UG_c	2$tTT{#\0C4!eNYc1c1c1c1c/t4X?)}v(BHr!UB4P\'ׁje)nm(|m8ѳw- >ouzt;gi^39B%>0zMj?MH^-a̔SBǄ|}>\n	1c0n\"3 sʍzOvbkPcH\"\'E\"?w>b9_sjWW+*/l\'?^J>5!h뾃Gt~?TfD.=ZiA/N91m̿l~e0sjDy=3c1c1c1c1c\"L9<Y8HJ	&%dR͞q(޺mf&Ϡ. ;-=>}+vQg|*pqspij4byħo)i>ew7ZBmZJm5`9BF YH\n	4r-<-}-ˍc3򵡴-m*Zֵi(BKZ%)Ju[޵k{d\0^\r<S0.>Xf+!E}fIFKӣ_H(ccY[,n=tU:<:zf6#,Wb{ݾYfQ<LH@c1c1c1c1c1vn4c& ~\rɊ oKng@[VKdn%1Pس1C%\"чU\'yםdf*|.i9V,FMLk@4ɒYsvZG~/Uv~/nX;p]̠)>\"7V]1_݊6$ss_L$OM.}bEݱ뉂2\nH@U͆\"B__\rKɿT6x#G{ǟ^;o|Vz-xQB~@K\0Gױc&#ejYXkU:w7ToBI*D%Ʃ-x5`!b8r10w!-ˍcNDUlgjFLH\nLduH%FT!d,D!#N7At- h3<1֦=ɒJ\\&Pןnm@̋wrh\rkц11AYhaEaBZ`qi(iYi)mJ[m	J\'Zּ1c1c1c1c1=7n|>zʨ\\V{t5ؖ-!gَ|hF\"VT6BAˇۡY*Cv8JlkTWeoNjMBwJ槵[O+8JZ	Jv,H8x<&EvXi?Ci2{KD^fC4Mxs>jwAw^m{ҒI]CM0UԄmxidK<5l;i{/=!aVEB,\r.[܊\\3y?\r̕\0t:uoTNI2ec~C\0^i\Z&yjrM/dK<DYO*]Ĳ5[brzǾS^BWniOѨVj:r%@Dh[HyN\n[[}N!;̓v\n;0Me\\G.HقKvK@I\"D\ZFŘ͌f\nT\Zl=2c/w9ELu	cX!cm7Ӛ*B3s\n5a]uGFc1c1c1c1c̷vn{QyVq5=zntᇒ100CGX-k4[DMZm2AW?-N9l!!)^9yMNB\'`\\.6wM4u*M|裉YW+ɑndUapf<atw{Ͻ\nR\nTQ2av΋X|WvKBc1@Q9A؞6}:$[^ť:9뷒۱ZuDݐA4B>WN띦՞gWG};,<wzOX}J,mR*0:T%Flp\"W|e58!s/7,lhΖ*A-~\\ē;pODcOxm\n]U?FluY1EPO8m!8)l>+m\\m=1c1c1c1c3I#9C\"+.QD;SC\r2-%N:Km*Zդ{Ɋ{T\\e&`0:__r}BEg1LEJp棧NیdU~^Y#ٜqRbܩ:T417mG<mHܨqZIt+\\3]\\K\r=$h>&۲myOTJָ4JGιĮ>f9()6iR_HV~D_Sum%;P*VdAU.\"v\0LڷucE=k2L1*p]J+̀6Tӵ/2C-;eiuu:[n68ۈRV[Jӽ);޷r>z#~XT%9a1Җ7FAXUAqbҪ6+C3kKnEyGɞA\071)c_Ϻ\0U\0щ<{{i\nj*ҟQ:uKe\"(\'.6͌c1c1cɠ@vk0< -,Pd)Puȃ!c18~I1Xϧk\Z	\0C}w1u2$W)7\0#m[7\06ܯLOkI\0e ]p_kJ^KeٟHs?mS]m\\X ]\Z1{^ߏh)d!eaV> C\08Ŷoq\'A;fAZeISZK/>N8߃=o~{$♎bsgy\nZMd!e8⴦֝[B\n[A,C!mϩjK1[ܿ?8г`Jg\\J_לao۵Hw,\r-):5KuM>v=> sZ3*CJ|SɰK\"t)Zx1\0\'ͽzV9%ڨuG:(1tsT0+\nCŶe37L:JςI4Edg\0{PrtyIJB>mINۉӭ\0&\'o٩s!g$a%]w0oqn] \r5	\n2Q%ΣFHKXLp]JQ\0\ZmPJ`D9WFb7byHt\\5v!E9Y؊9RUrr\'b	#``!L1BoHM>9:/46N%M)Nӽs/^{R^TJoIIy\\xf^oR\'ɜ^90[漙3䟔iѓ\\Oߩr.3$tXLt4цPAV%c&Ul\\xLۑkvQg|*pqspij4byħo)i>ew7ZBmZJm5`9BF YH\n	4r-<-}-ˍc1c1c1g;Yd;5z ~ŝ\\v-O}N8ڄς֏JY\0\"Bֳܴy6G%U\\\0_|Thhȍ_Ǡe!)2.$[ɩ\\}!-#!\\}PS.kA X))BNΟӭ8-BNvtKzRսj_,[$1WtMI)>BK}t䣼$ی!+cbbHe˾\\}umH\0^FyGKt%~F6$hRctuaň^JܓzavVJ[\'Xgn$JAҎ\'h;\rGDڠgx+Z]fyZNGH@Zםifm\Zt7deH+Z{aOCq.WTH㪑74Yʆ)	,	i)zy֩;ѤNgLIͻ3#),v?z穉\0$`?_ШR$Ne2\nHK-\"|\0V	.RcIcF!i\n˷cYޤP.B\'\'ކS(NKZlMZH~g\\kBSa#\0b<VB%mSDަQ\"yÜF,J/_[G6y@]x5u	Px+ƶvRۊy	Ю[7NTAFȺ\r3B%(CBC!\0HBmS\n\ZZH@IUldgDwx_rì;.k:\rXUǧz7o?jaoڐHE	ڧW-\0YjT*UxqPLeV\\%1_Bq);,Ԁ\0\0@?//<-U_KQI<]WT\"\r#PZU(!r^pt~\"<\"C^	۽pN@dY}Xey\0f8Bt0ϺJK*hw߮7z@Q7Rd0EtZƣDAn~r6Y~y\">Dv%\r)}<yPz)NytzqhOr\Zq6VG|+[8u^6,R/EG~A^)Vp؋@VrC_#!֙\\miKbЏIF1%)b=RO\\HCJXebV2kuVǁJLIͯI-ʺa&{ި/ا~>VW6cF\'JvVWy3}u*tJ~FQ3!/b p3G 2CpR|Wb@unCr9iќ\0}7t|5V6dkxݓ5*_D\"TȖPEJ/ .oT/yZ.1]zb59v+j5H\r.* yQ9k0po1c1c1cOrHHF]?	2/,kM>*5B Cm\n.g^uz5\\K[L7~wzzDJx<q ƂKj\Z N}Pha +\"Jd:].@\0#sV!Ti}vv-nbIIK,j\\f{ȕ;<Ý։D ВmDWpu|nrڗY.2;sqŢ7(c4Rm;\ry0RKR\\^IQ\'6oC)k*=n<뽻=Ф\'h~wz.^F5YIWo ۛd8;G(TdZ{4V1:;+1;R6nSL7JHY\\ƘE[פ>!b=Fmۯ<ح| d<CM%q)^_DsC/7x?,i_1!T<26m\'~)\0,nw?p\"GݖyKBE~$,6P\noʼo3\"{#שe-0:{ltd% @AQ>USޝ,:TQw{$X\Z^(Jl!Ŕ/n}KQg$_۾t\0%\\<I+^}0W4_yfA֬\Z8$^![Hu*gw~c>\'a\nb		H:0@j,MCz\\y಍Aiӭ,<c4$ߪy\nV?S-s]ct燉>#^\nRV3%53]W63eȨ!De&d셣M\"\\AD_KԁX%WgЍLhKkSs$ȅ:<ȍܺNۭ6hF>6q6`h[WbQ=4r\\a-~r[֔K!rzxwaJ^p=|1OLyl~q~N~w72M4׳{\06cٕPIG|4$п&9-~ymn%{9:g_Z/riy	c,63-CEOtzcz5Ceអ7-mE:3p!_ua^dU1ħ~[}o6dpuXZq)rBrK,15s؜2$\\C܌]vtq;?<iѐm0tmJ1_\0WF\"lE#\\L6$CXi!+TzKF;5S/ xQyT\\SlFhs˓hj\Z{fkb,4d m7uͪU *j\\t[ZA*$ۛi.sMh1c1]չU*pF-lacBF\rY&++`BET;ĩ@.z4-ErԤ?)O\nmA}\ZA[oqZ/<f2I\\Nv^jFWQV*wcv=(r*;F5Gr0EV]$uv_ R\ZeZJuBTI= yM}TOzBc%limODkKͩיh^P\Z\Z.rIA+?2c8]%RxΕ#eZ\raJIJ<8PAƑL}[lߩq3Jv[a]R\Z5.Rƚօu8@t1g:T+֫Dq:<<\0F\nc%0)Nl;*O\nN)I|q_ιEmI洊7TX@>TN*{a$3^R4)Vhߤv]-]ԠMZZB6ڝ؟Yl*^6Zp`c Z^?6#eK_M􋒜Cc9*\"+xޫtJ\nL`c!8O޵z]z.ϩ;7M)叢rI.q8AOuίR8cmD(\nmkT9>D%hSk5zjV\0ҵkZG)[ڕ{vc1cLTe\Z*z5N6c	O3T!̾k{^ڑi޷lT	yYa?`ebt6\0m}~?_s׍!>UvgpcUl\ro0ڒӪe-*\rmZ|_F\n},x5LDz,9\Z?Vi%!V_H+qm%\"^Je~?lS\r4?IRX?26k9ߗk\"J&R^^BP].ym\0eV[M	$)rL\'ҽ!<#\0]R;iJl!	e4ִFg)DHڄR	w|c1HAȢ\nˤQ.CLIShJi:\Zv[,1Ʊh/y*JQDnK:QG}͉H7ڧoU`ydabyR.=ӜEyl3;\nG+bP^;Ө%Ԩj	.L;GN?r_kw\rˇǭ-%\rZUTO 1ݽ̘?9M5RD<w#=XOHBBm	mҔ!N!:R%:RZSkZֵkZ~^fHuU)ϐ^\">!jy\'X=7nt;,[ZʇֈXޛ\0vfV,65F݁dǿ)*)凎Gb춥5Z7\\Dgg#!!&JZb\\ѣbio| A\n%L0%	ڵ4k0=~<Qny픑BqFS8w;04\\\Z)/[c\Z?;sIt|]|2u;dEOޕXAhfCr^r$ēlCm$85$\0\"hA6^m@ީv[k-<8e%Q,m4֑[vc1c1c1c2(-Wߧ89jߝ9c}4*]~\'Z<	&ӭU:j\0F&M\\{=VBhKmBt!	֒!)֒:֒kZֵkZֳ=ZJ-|:W%zLGE]X8Qֽ/	[~dagH4/<4EOH~ae[	Vb!WI!\'qX.:Wֿt!,WA~j3z/6D:E<ZRAJw!#\\\ZN?v-	Q$lU8˧Ux}r:\'~,`T!<;])5Ll؂z>XuWA8`a5fw׹kuTiF9ן\"4sI5jIoRt7Z\'C+?O`d2eVTՊ)5)Jq\"%I21]NijD/R3G+$)9#` \0v }em*VXtZQ}A`9kT\rP䐖KonB\Zcj*E<t\ZQ:0 |%V{]2k6؈2|΢y~c`d(`	x!ˋi}޶6#sCKR:޴z\Z[rQ,%xYX>18D2E;=)|c1c1c1c1{=er+\\a[tQ<Ȍ0/Ίfr.>b ʹ=x+d$9?k5zTDl<Xy!4q妥|yRL:Bjd0p6Mj]ܬJr8{&4$PMeed oK4uZ_>iXZbF.G|M[ʰ7n\0QoҡUT3FyZ&@DTjl(0$(|I\"%HȔQĐCo<)o=oTHΤTu!HAp&(K[E|o3\nm2yNd7ԁyo oQ\0{A%!vFly),4}aՉYI~p5K]Gw8iASCHߵCo\"n;Sg84[]F*\ZzoKs雴l)ܦ;+NI=Ykb $6hI^\rG7x|\Zgh#n[Z(?rPTvP\ZQbEt1}lP\0}`k?\"Դ?	䪴|32b\nS};-j\r}1xhs]iz%N)+D]b_cP⶷, Ɔ{Z8Jԭo{c1c1c1c1c0?҈8H;wN%\\qlvtM9\r?DU۶)ZU#L	Lj=8 INxJ9t:H6B7C$+yZP.Q`Pա=QIf+ֻk\\f2j--mTGg=VAew9H\nEucD$\\VᖛՒ+rReD<㵷7qZJP&#OF9h뷘hB9(<rVeY*cKDgg#!!&JZb\\ѣbio| A\n%L0%	ڵ4k0=~<Qny픑BqFS8w;04\\\Z)/[c\Z?;sIt|]|2u;dEOޕXAhfCr^r$ēlCm$85$\0\"hA6^m@ީv[k-<8e%Q,m4֑[zĨz\06__mjPn-ktאo=N\"ԗIF}ic1c1c1c1c:7K.GFtK̊+U|O4Ćd\'ӣkuJSLlP0)\" |+]	n`%)hh-VjN#Ȏu@vkX>HAPܒ;UˮKs.& D!v}fyO<\'^D0TrJ1d&bQ]ڠˬZ)Dp.)}/Hb%klPE@<Kn2Ĺ5Jc[3\0zoT2;yg \"mǒhbh2sObv}/WuWj%ϑg=ѝXf4>\ZdeΓavJ\0D$6Xa)eZ=\rs-(Gz<,Hp,dDssJd۔1pH՞垜ޏH\ZryƳMIr#e\\Jްwab_yM4ԙc|O1c1c1c1c<$8ca2(%K8ð:>,T㮸ZNF}= 8x\0׍\rNQ%\Zw0i0,E0^rw?sg?)p6 p#\r>J	,Y7$5r	\Zv\\5[lIb$q\\O^gu\'ߟd}\rpvLU걄%vWU\Zr~	TYeOGlHy\"f[k1pqpPqCÄ4dL<L`\ZLB2L0m6kߤv]-]ԠMZZB6ڝ؟Yl*^6Zp`c Z^?6#eK_M􋒜Cc9*\"+xޫtJ\nL`c!8O޵z]z.ϩ;7M)叢rI.q8AOuίR8cmD(\nmkT9>D%hSk5zjV\0ҵkZG)[ڕ{vcɣb6u+ZzgCwZCܔkp\ZS7;ϣ	aiG54+Txf	  P\0p\"!-%THVX}ZZ\\mJB1c1c1c1c\ZTS^cs_Q]o`v;h$>ޏWئz\"qŋK~SvsD}zSk\n=,n{\"D\r\ZKٮh\nP.YF-j-c&.6$?7]?θ3Z뽖Z\"rhɁg6QXGeHn,;UĪ5c{HJGBBCLĹFE,]d@-J%a-\\Jjhת`.zx}s)\"^⌧kqwb`h64R\'6_Zǌ97N5b~wZ~ZǫϿe:O,vȊ*sr̇62I&>؇ہHqTjH[&D68lӨR#aZxqvK<Xi#L1c<$9P2\nKM9#40V̼Ҕۭ86-;N?YCyǙH4ٷݶNf>S~ZJ1c1c1c1E~mUg\",{4Dmd5`	(y9Ɏ$sd JXu8wnbgW]/}\\iB%6-V|DjaNԹ3P\':UBwbJ^bF!5CZŕ1#N`Oɕmsj}ޡz?.?}̙v~s@v-n{F[{$rVI.E#;ݚ:@\nۛC\nu%.J\r\\>3F8ӃL9{.@|?z#=GqE%hR^`	zÀNs.iLZScr1c1ku^vj/NY\r!bP|jBSa^$<ֳ%%\ZlroU&1c1c1c1c0C	)0r5m	_ћZE_+KlvA[,6Ǭqrp11\00\\\0rz&ɸߝ&=r<k\'ǻ5D7u*wC,5g&i~g3nDo	+Rƈiغr>*{[çXj4?\ry~Yu.~}Iټ/iO,}ÔLw}uz{nB%@Shs]iz%N)+D]b_cP⶷, Ɔ{Z8Jԭo{c1c2^m9t^p;/mmJ\Zr,5ɢ\'zd2j_%_kKqc1c1c1c0]{̼ݲky\Z37yI	8\Z1qb=uH$*΁6g1\"/Q<̫n~h;mK\\zދLM*zd$eScL8Э1c1c&/Q2~9ә#+z#X/E7עԏZ\n˅>ˣ\\0!Ӹ1c1c1c3mJ\rnfxӪUМ倂.)/&2V#%ѷiN喏^Wo<>IR\rbwBY<Yؤ`9^ۊ2IzFsZ5\ZY+8,5v`4\ZRt!\n$*FD~d.D4sc1c1c2Η׸[Mi#(I5(Pe\rbA\Ziǚpd:v~+пվ;:]\'Eoʢc\'_w#=a:\nJ֥k{31c1c1cɊ§-vкw&)7l8PY,Myꠣ;&\"وu[1`qc1c1c&*WrǙHq* \0+{20\'\"|r=!-\n޲1c1c1c1c1c1c:W]@R6ëkkyKD|)|+(H,]1c1c1c','vsantos',51,'Circunf.Inscrita',NULL,NULL,NULL),(237,'point A 10 10\r\npoint B 60 10\r\npoint C 40 50\r\n\r\n\r\n%pontos mdios dos lados do tringulo\r\nline ab A B \r\nline bc B C\r\nline ca C A\r\n\r\ntowards O A B 0.6\r\n\r\ncircle o A O\r\n\r\nintersec2 A1 A2 ab o\r\nintersec2 A3 A4 ca o\r\n\r\n\r\ntowards O1 B C 0.6\r\n\r\ncircle o5 B O1\r\n\r\nintersec2 B1 B2 bc o5\r\nintersec2 B3 B4 ab o5\r\n\r\ncircle o6 B4 B1\r\ncircle o7 B1 B4\r\n\r\nintersec2 BB B1B o6 o7\r\n\r\n\r\n\r\nline bb B B1B\r\nline aa A A1A\r\n\r\nintersec OO aa bb\r\n\r\ncmark_t OO\r\n\r\n%perpendiculares ao ponto de interseco\r\n\r\nperp a OO ab\r\nintersec Az ab a\r\ndrawsegment OO Az\r\n\r\nperp b OO bc\r\nintersec Bz bc b\r\ndrawsegment OO Bz\r\n\r\nperp c OO ca\r\nintersec Cz ca c\r\ndrawsegment OO Cz\r\n\r\n\r\n\r\n\r\ncmark_t A\r\ncmark_t B\r\ncmark_t C\r\n\r\n\r\ndrawsegment A B\r\ndrawsegment B C\r\ndrawsegment A C\r\n\r\n\r\n%circunferncias circunscritas',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0~\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0-\0\0\0\0\0\0X	\"\'Gx\0\0\0?\0<<<}\r2a\rQEYdUH<dմ+Nm\r[h)o#1*FֲYoN&ʘ,JN˳,qiQO\0鱯kjq\"d`ymbYܓF/\'WX\ZJG|yyyzO/9Z\0^r6kvDq7&Q30,_GN2mO0ui60%%l}pq&Tp\0WkU7UJ6gQv}\'%}Y`>lKj~:Wyyyykf3}ND,:_hU:5FOA[m:_`d_o]`7O[<,h5G%wmtrө%: NKƨό٣s&rR h.si.$/XBl_DN$u7BiʈF%\r2Lu<VL!a0\\Ngƃ\0ZJQR2!IZu+Ox;yyy{-ٷp〵h%rӒ\r7SprB$)	R֮\'#_LY]Q2VlFe,4]DgTȀee,]p)\rvX8IB`=AQAD)HZiRw=&|cgF|,Rt!MCM|vT񢤋Bg0zfY·x<<<юE9KSw]ğ^k;s@t^,񖟠9ũ%kY?FdsO\rБiJ\'Bq)Bq)JSq)9s9sߗ>	Q~:|a@\n!j*!(4p!3{$2dzQY3TۼYp8nQ\Zi(LDDuH ȅ%hZԭ=yyy瞜.\nJC){f9docP40E3rVh\ZE \'f,P;++̫\nTRq0Ar̻e|bq(A,b)h8\Zإ\'tsay籘!pp!\Zp	(L 5H ȅ)Bԭ=Uϗlׯ%N$)Ziʗ^4T}2Lufo^VL9yyy{̊/zM80c\02v{mrA%VQQrbp?KȴMt΃0[EKԌCoՕh*@q&H:uFA/,Hmi֐hhPq<G!6tj/q\"\'Ol:D4WeD#ed&xOvdLOJ+&wJ{w0.\'\r3Ap%	Tc(BR{wO<<c1%p\0\052 \"OVBP1	RֵBy+;s4;l5_}+].=#Yӎ.Q\'] txI~r]Z,[y\"yyf\\gưBJ\"|R2!JBд+Ozsy3:5Ib\nl\Zk櫲׍$_L<]~ل[ׯ\'4t=yy繵w9Y/2\'/-6\\if\"rP\\a@\\oՂ8d5P?e$i{o0:b5^^\nf԰>ob<_D:\ZGе[D7ieekAKkhڌV␕&5#K/(xϞ,:[{Je^g$ƶ%1EwYuN%cHPfY).ݞ0߮HBli:%MnxsLt=k5zm<説}VB6>߅3Ȋ=oeg?8[}f9&=>it41,ϯtښøSY?E\ZRo!m1-57MbAHVx6stigOw0\\Ngƃ\0ZJQR2!IZu+Ox;yyWoE\'͟EۧlcRK<isWA6Vo?lEb9#D2ۛ*<+bO+ƓrĒäj637\0ew+sRNs u.Lڣ`&[WꕈJMK9au(@3dRr/\\,b=r.%Z2?+ݫ=^axw%m7 OS5)$ۋ$Ody&H6YFk`ROlwϿHSbOs٨,TSF?~kZr9\'\rOEB8ŎESbRzj}UJг[ߧi9#6PVm17oL$ǧԭ.%\nȵ=Wt+\'\0\0djkz\0^tkMqJ|BP{Fj:Sk(V\ZUW[rF\r0\nXcOVEp8IB`=AQAD)HZiRw=&|cgF|,Rt!MCM|vT񢤋Bg0zfY·x<п2S=foZKuiq9tzl*j/6[C1,_wlD`v8rglW]e:cfjR3LeKYm7GQnUM?`dQϠ.2u4m梐߆*fJhlD#d36B\roN\\qSհ;YJtu\rP:fK)X\'Zq\0o>5傣\0W[~x{%TȚ^\0܌a%9m\0-+t7;e5;HEL;UjuZ-~2IXP5f\r^ķ!!3`95l!)zW}zH&΍E$D\"MQt(쨄lP,_̐ɓEdP|n=fDFph00J,e \"hWRO{{+\09!z_RhJ\\JΩ]9Yu>ع7jX&[mgioSQ5{hURߖ~,.ӖEWIjGU.ᶩ1Xio㘕RyELeK5+\\X6[|Ñ|Lgu;	jpkp%V)Aأ(\'!5RƼ,K\'qVZYꚣ?8gu{w9iZIhV&=[-/e>l2Wjde)8H`>wFeVt3;Q(KMUi\Z/6O>wt:n.|%/MX:MɆԾX#+ѮJ\rE`qTbfotYu2r?\r8$==cH?ОRIDx1?WzẑB6& b@ࢢt<3.V3XN!%	TF)!hZzJw\ZID6\\wQ\r5URƊ/Y	.l^דҊɚ]g:z<cM3?7C\nd\'[pq&\Z8\rE$vS%Z;[[/޶ƢX˻;3$(LD~Qq\'PoGW_A`0b}1f:MI#g_7nە=A[jD ix,Zdq6gy4V,ĺW-٫9juBYdZJJiÌl$s#+1Dn1ͭ	h-X<l[sR|jIjrL3z`fE}!\0{?-5Gc))WYs\\LT.V6vEE1Z=+}އ^qbq7$;O41n܍L\'33j[{g;ϿW>L![5l+ӎRK;ݰt0 <IPѨUĈ>I n_5]J\Z8e=ْ2y=(*C`7(´&	SŌ\":dB-\nVIyw<jhV2<Lo:m)D~rN¾HT͙G~\ng}(ye᷺쌧0(<}386ke*p[߽\\YmmM̜$hAO2mx~>\nM-VX>jlL6ͺdi+{|ڳXp=3:O?HD*bZ	1|9f8ftu)\"rrK܍pL!\\BKFeX3q#WPO&4nӳG\nx8^)Fn}XktRdƠ-/;6n9c3go6LS\r;KoQh@\"mYx)űfsxU^y`Jpk	d$0J( \"-ORW;>^1^T):|ˎj!j*]xRE!3KսzzQY3KCۼO[Z}|c^=f7UߩgP4}{yUV**V-\\݇ m\\89F)r./֑eյ0}k}TkܠUNIQ՛lSӉDZUbi5j:ٛa\Zw	:͚$20H8PN\Z/HCHN\02\'[P-lq%z\nrkMV1v᡻$*8x2@^x6Bb7Y,d{tuR~i+dv+3і#L^4*,SaW&S%a>{LLDעe\'#MML=mدde%$ـ޽v`h%91\rkgV;Vpq(P_1񮣤~Йpr5}Lvb?mj\nOm_\0F\0=DyyCKC|-H?.W.:SY1B|kgP\ZJդ+f<dM5?~R~I\0Elh\05<rעFV2%y8tɰ: >I/?aD}^Eff+ڈԭv6¿)&\Z#!Kho#K=ěJez!~?Ô7߿O/?S9K\0{:\0󶓩T(laũ\nxCDN%dpb\n])xwd5vjdI&2FҾ5z_D}_{i{53>?:Gq]4hBj!\0,1]6Wگ\ZfG?.q7FVe(8*_\0OFfOF+xjeAbfT3\0F*3iEwaG:y@x\0n{__`<&3a.̓?3ۤ2SzZ݈KRZT((mJ\0ܧrKixej+ \0f{9-?ϟ/\0Uc\0\0y=w)yor_ܧr)\0)yor_lxpqxa8\rJ\"oTR-=Jޥ\\;{+\ri#y&)3.ȍu$ENZ	̄=^ң)44zMg\0','vsantos',51,'Malfatti 2.1',NULL,NULL,NULL),(238,'point A 10 10\r\npoint B 60 10\r\npoint C 40 50\r\n\r\n%Desenho do tringulo\r\n\r\nline ab A B\r\nline ac A C\r\nline bc B C\r\n\r\ncmark_lt A\r\ncmark_rt B\r\ncmark_t C\r\n\r\ndrawsegment A B\r\ndrawsegment A C\r\ndrawsegment B C\r\n\r\n\r\n%Pontos mdios e seus desenhos\r\n\r\nmidpoint AC A C\r\nmidpoint AB A B\r\nmidpoint BC B C\r\n\r\ncmark_t AC\r\ncmark_t AB\r\ncmark_t BC\r\n\r\nperp ac_1 AC ac\r\nperp ab_1 AB ab\r\nperp bc_1 BC bc\r\n\r\nintersec O ac_1 ab_1\r\n\r\ncmark_t O\r\n\r\ndrawsegment AC O\r\ndrawsegment BC O\r\ndrawsegment AB O\r\n\r\n%Definio das bissectrizes \r\n\r\nbis a AC A AB\r\nbis a1b A AB O\r\nbis o AB O AC\r\nbis a1c O AC A\r\n\r\nintersec I a a1c\r\n\r\ncmark_t I\r\n\r\n%Desenho e definio da circunferncia inscrita\r\n\r\nperp aa I ab\r\n\r\nintersec A1 aa ab\r\n\r\ncircle o1 I A1\r\n\r\ndrawcircle o1\r\n\r\n\r\n\r\n%Definio das bissectrizes \r\n\r\nbis a1 AB B BC\r\nbis a2b B BC O\r\nbis o2 BC O AB\r\nbis a2c O AB B\r\n\r\nintersec I1 a2c a1\r\n\r\ncmark_t I1\r\n\r\n%Desenho e definio da circunferncia inscrita\r\n\r\nperp aa1 I1 bc_1\r\n\r\nintersec A2 aa1 bc_1\r\n\r\ncircle oo I1 A2\r\n\r\ndrawcircle oo',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0}\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0:\0\0\0\0	\0\0\0\0	$X#\'7DTd!\"UY\0\0\0?\0qqq!{k9c<^Y_&V=_DhT{]#Ji;}Y}V\nV~͸Gn2j0ngGl%^.A\'	;\\Nh>=,\'cTN˂ рM<dIj|qqqqqΰ=!L\\OϡQsh	kZ*J5^YCX*j٤VX4y8o<zO#=%^e\']*7Ĺ[Y*KJitrM\"IgҗS<	tX=Eqqqq\'N~n^뭤i |FcMVu_Ht*9NGj,XFl@4̯2c*yQL̕L̿XJΒbqSLvrO)h$$NBzvR}I_8F\03&P\0@1o?\0韴|qqqquRЌl\"A_64Jxcەh~äg@nT,uF\Zf\"]]xY]\nX8%88\"Q=\Z$h92DX5Зni2ň%y&\r\r̋v~eZ4R\0MYUpL_v̏fv%χ};3u_y2P|ֻ~W;GifHS;iJ0`9xaoqqq<2dǇDɒ+.ɕ*K4v_!Teu%Е-j=wQMG3`j[Y]Q%yZ>3Vh2C/zhi*O\0Jw!)bH܏?\0h5Swdj-\06]38889i)ײ-E=~,KD;g4~˘0#l\ZqLwF4t?5ІB[mBP\'!)뤥)O]t]u]u]u?8Eey2-\Z)|A&/;GifG3KP;uJ	þ`@Bixa;bKk]Or̯ׯ6$T&VmSE-0V@E2(vH`sU888AOWr<5&ȷZ&EjeA_]ǐ(k%]݆09t:&(3rxi}=a4Vl;]ۦvXBd:NyK;O\\8C_B_=Aw$>EGRZ`x pRlzGqqs=(u)FU],%Ua\"9<V2v4g˹naY>X+kתeCV6+epnF!Tp}޲^aȱCNcUsLҧ`+\nLv)6ZjWO@~<hQ$f4`\rpҳN+%ehU}Neqκ?HE0lQZn[V)nن`-{{z&.*@:Ǫ \\\\0AQm*ga\nޫh귖h߾u\0Q+%AFӲ_2gvғYnQ+:3#eU(3ZL}eY:BRU).d3),Uyĥ-$\0m9hu>88xdɏ<$3$V]*T[b<h!N\"C\r2-%N:Km*Zzﾺﾔ)>ѢgyQ\0<hS4Q&T\rldŷ9Llc6BSssnu`^\\݅d]WYlpS@7qT)u)4.4Ƀ)i^*elTzGzi6n1qsי2 ϕ\Z16lڍH)2IyHf<hnCM48⒄S2[GPHƏRi~|_zYs(\"\Zʽʢ_Wlʙ.=څZwM)6qCjM\rjX8&3\Z^F2vzT\\\n]5Bgqq>h^J-85)fy`m:> :%rzsJ\Z9Lz	^4>ʹ85P(.]Z]}n]N!	\'@1뤑Q.P=B$_\Z]k.|jjh{6RyoC-:V$;>m\'\"˚\\hhfG! 	\rr?hګ _Yq,6If:3\ryH*Va\n_b<Yj\nTkI<r\\h^0:f\\S%4tQ\Z@%%L7<xP\'*T.̃,GkëUTڻ0t!\0Pk5\rNJ,^g2dA%O*4c?2lُ\Z$8SeJxB}Vi\nq%	ﾺ\0{r?+F\0fOQ2U Aʍ7`1IqW؞ڀ-BMk2fqˍP3>V+Zţ,wBbT5N40oRJǢ2ǮlVu{^7oLzsp\0שe\0PŎ\0&3\'[KE/4Gv~eZ4R\0MYUpL_v̏fv%χ};3u_y2P|ֻ~W;GifHS;iJ0`9xaoq=g]i\0A`8/lHdMV*AK9SҺHΏ6:΃&#:fhb2^eY,6oeHӮ3[=Nnhn6B.&AG\"^^;qFǢ	3\\aY-VX3ːՈRA`XkG-)1ؑJZ-mvIMeGe \ZhCۧ1Mkf:wOf_aZW\\+wtz!\"q2alpui-OQú%K꿌;~N1Z]]D3N*{&n;D,уSd{%4x֓\\N{l;]C{fE3?7dk+<mE34DΧah(]E6F<xp$VZ,fb<h!-1;\r%\r2-%-iKm)Bz뮰a^esM;|>_7dNi`u\rQ#jk4TϭA3.,|\0\nfM`416 w\"\\Qd@$6|W]6E}Zܗ?:/82lO5ɐDYwMX_c\nod¤*_\0Gԟ]`~Ω;a\0.Mwqu=2Qެ\'2@4i\'gَKSѺ1mX&3sԉQ#vb/vsڷ}Sַ\rEJr5q7%&rĻ6IʵGpAn֋mw%WT@EÒD؃e3\'NHq#2-eڜuա\'R|{-_jr]5I$wsVf\ZΓm }<vTx\ZP}ܰd˂Y]ɓؙwt+7j.m;1ujM~Xޓ\0Lbt\0Ì[EYukNp\0<\ru0*?/m	Miqg)b*c(\\	nYI)sB|W.4:W=:ΪNCRً\'FZ$#66$hjÒK \\T8::O}ԙ~#+W\ri&3;~J0+$[fHWTBltRG1Wz<6?,e\rmJu^=bx5_%oe0BvM!\\@D~#b\'h!/9&DƅH(IZM4A零[-ѢjʬTbs}6d}45XA/ |;	ؐd&ì\'Rɖ֯2}5d{=R9>K2BݟL WgaH1͌S}w87f;.Ȑl0kyZZeZOkq\\_iCmkZPR뮻F^ވ\nYI)|ş0V氦4p%=R4#v\r4g8s6+i)Y}#|\nr0z\0~)ʝ\'؛=Srd_<kWO&D֝nl{,e/NI=eQ^cI3%]cM?9i|V;պMkT.~A=Z\0P\rN\0Dвp\"`.7*َ̨rh9W{]3dHua--2-\'/BTj(O]]]ȇzolxp	J_þg^\'\\$ȉ?BCu\"t.kcP/EIO6>\"❸guVk+IL4WM\"I;$d?&xǡ͐ݐRFbmnǽ̩v}b.Ѩ®x=Vc)aj:HKakIה赊9HV07R_NZ8pMoz.[Ŋ(R\Z98\Ztz\n?\n]W(䇣fDH܏?\0h5Swdj-\06]38/H|+hNw\'cdP`yҦ&7i>\rzg/YqJD쳉S!\r\riJ\'O]%(BSIJR)뮺뮺뮺I9h3f$[!wu@`3תyvG9\"_VMv,h8㒏ˑ3B(>\0	g\\qy5\ZY#bJ:?\"b$V[/p񣲄1V\ZeO]%\rR!=t=\'뮹]_%RѰ*5#ݙ7q-@HA[ߞ	*cW)\ZuWTP4WPv8lFLqfB.ȉ	.$f&07^<to3.؏;\ZTgZ}\\i/9nT7;՘\r6\\#Ax\0kGR҅ɿRЎޒhkB:ﵭ)cX=<w/ ,tE4Y>lͭW3eeށU)7+ff]s<]VY6Ku_\"ݲ߼mVGUb㝣鴳#	}%yu0Nă !40a:Ly##5ߩY.a<4\'bAlbFrG-T?AyLނg;u2k6\0dso5lTH@y(2ܯζ|,XEB3Jr|ø9tmzD9kz6Vp:FSVq<D|d\'%fb^-o\\-jX̓\"YG#D5lqإ4\ZM%PwDdCldԫaɃڹgveAC8x.W菚㞋q1H|\Zpk.FSm\"X#qay#5\nDA9Ȍ\\Xh&ͱYGHQga}:n*\ZA|jP{R3&M9TڹJ|o]VfV0Bc9B/QRxSՖ:¡X{?VϜfL©:l60C%uEt\\n-_=<Vu[AVr<F]H}d&VPՙ\nZN	<g;zw% M⸩it҉PT1zVJ;37g@#疚;{IչIyKmɘ?צn,Lҕ.;;%ȭKb\\<R5X߽vrceU\nX{bPT,k\rљ=7BK̆M1?R=uсk:Ɇ?[\0lg<\ZаYl\0{IWUamKfU&_*+0K3(\"=\0Zs_(=\0?ra#%̤@wMYqtY}ݭ$n\0κ|{m1Bhj~vkh$lּqsrYu۔F>MFdM߼rmS9K{)\0=yU\'ѵ\r~r$f74aO\"=-	%1͎\0|qtn\0HwD`).W!\rܷƱBӉ2$p4h#9->,wb$P߈ap?96#\0!2Akhێ֩e+CXHs7\r( d?owu\r;XcĊ<uKY\"\n2!`|PТ?*LJ/^vbL0C$l6(#DR7\nJRKn+csX>Hu5TK0\nzer^RY,FV>S\ZX\n7adfK=!4}R\0)q~?o~_}߿yO/>߼rmS9K{p}(Om=bG\\5m&4 \n-Do5it\nDka\r9QSdtke#X-9-5_HMDi455NNVf/2[jT~N\'\0+\0\0','vsantos',51,'Malfatti 2',NULL,NULL,NULL),(241,'%Definio de trs pontos\r\n\r\npoint A 10 10\r\npoint B 40 10\r\npoint C 20 40\r\n\r\n%Definio de trs rectas\r\n\r\nline ac A C\r\nline cb C B\r\nline ab A B\r\n\r\n%Desenho do tringulo\r\n\r\ncmark_lt A\r\ncmark_rt B\r\ncmark_lt C\r\n\r\ndrawsegment A C\r\ndrawsegment C B\r\ndrawsegment A B\r\n\r\n%Construo das mediatrizes do tringulo\r\n\r\ncircle o C A\r\ncircle o1 A C\r\n\r\nintersec2 A1C A2C o o1\r\nline c A1C A2C\r\n\r\ncircle o2 C B\r\ncircle o3 B C\r\n\r\nintersec2 C1B C2B o2 o3\r\nline b C1B C2B\r\n\r\ncircle o4 B A\r\ncircle o5 A B\r\n\r\nintersec2 B1A B2A o4 o5\r\nline a B1A B2A\r\n\r\n\r\n%Desenho das mediatrizes\r\n\r\ndrawline c\r\ndrawline b\r\ndrawline a\r\n\r\n%Centro da circunferncia circunscrita ao tringulo, \r\n%que passa pelos trs vrtices do tringulo\r\n\r\nintersec O a b\r\n\r\ncmark_lt O\r\n\r\ncircle oa O A\r\n\r\ncolor 255 0 0\r\ndrawcircle oa',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0C\0\"\0\0\0\0\0\0\0\0\0\0\0\0	\n\0/\0\0\0\0\0\0\0#8Wx	\"&4\0\Z\0\0\0\0\0\0\0\0\0\0\0\0\0\05\0\0\0\0\0\0\0!\"12A#BQRab$346FTUV\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\00,^;cg9b#OYglݶάk6t&\"ܷXU9IRDS\'/IP[0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\062j³uM)!UHNZXJ-eɪ\\TPa7k,X75$*0)*ֻXGBEs,.,z>\\ǑO<֓[|rS!啀7Nbc\0u)ꅪP^sj\0L2gNm.\")t*\r6\0!+UPqm]WK&6=n;rr%ùvạ̊Pt\0\0\0\0\0\0\0\0\0\0\'/IP[07kf@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0D5ikveaYMH:O&$r\'-v,}rZB.*BAt[);#iGZkoXSjd<FL~Z\\\"ߝPJK֮c_	VL5ViǺMwSYX\\KDxSESh,IV9lKKaeӞ#J]*dkЎYqQvK5:IFm-]Ĩ	*1H(lN9\nŻiSiuKV ii	Z2nY6Qh;pۓ.˷.e.\0\0\0\0\0\0\0\0\0\0\0\0\0\0N^|;ֶaD	o}(\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\062j³uM)!UHNZXJ-eɪ\\TPL? IYr-5Necr-MNi\'Zl島--NxWЏ\'a)t_yDm>HZMm\nvTmLV9\\ӫԤ[B[izcA0ɝ;鴺wXЫ4ڌc4VbBŷQu],([opȗۇ2UC~?#g{.T]`F.QKWq*nrv\n3;#SghnP\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0&Aw\0l(?_Q\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0M.VhvV$ݴl8tbnINZG rmw*Uk-MT\"$E\"6$yŭ&;*6C+n{ŮR-TK-j1\0 edΝ\\}%f<{u8U/$N7H4U:\ZւɤhAd]9_B<ҦMߏ`-z˷hX#QkJ8#v><[6PbQlfS(X8.ev÷9ܻpQ~\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0;{M\0Zم\'/IP[0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0h]&-n+0Ii\Zg\\pܒBYA>叮TQ[EHH.e\0Dsg,]VV:(8= TTkZ&~[;mYt}vJ57F8eAfye`<Әyx=:JE:j)e\\9ӺnKgu]\nM63HJf),[uUɲEFۇܜp]ps(uT8wB:fwE-/b-%\Zw&N\'(Hi 758zf+\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0wk\n N^|;ֶaD\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0MճnkiaV37l/WZr%:*6SS6,Kf*&yFR8v7Sbq4x%5~\\(M2YW5BI#3I:6Rɦfξ\0J3xYip+k^Iho*ht5I?JЃg-il,s¾y;	KL\0sZ3n*.i~FAi(׍7rq9E]F;I푩34}Xxm5U\"աhZI\Zu\rZ\n!UяA6Y_\"S8t2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\07kf@&Aw\0l\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0P:Zv!WaJtIج2[UZfq:\n_Tfmp/tLNz5]a[o޸aRB:ect<tfo\\	]ϗUloW$9x:*\n`\'{x~*+/}ι߶N1ŗTݳ(?RU(5jmNWY\'XD`LdF ك9I	w9n~:W-ZDuGmQҭmlQ!-\\h8y_*OX=F\0nƱo4rSf\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0(?_Qwk\n \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\Z#}U\ZWb~4A͊ UUVanwuN&f>g\rJgW$9x:*\n`\'{x~*+/}ι߶N1ŗTݳ(e8Xj<#p[b8ԻciwX-3u!4BWsk{{7\r\0ah顴C&#DlnrJS ݻ>[\ZGëtY*U\n\rM֠i*$kP錛80bا96A2uCN9ވ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0(?_Qwk\n \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\Z#}U\ZWb~4A͊ UUVanwuN&f>g\rJ@nsY5\Z55.#Z]=\'KLc~.7AFfuuZߝ{hC^kGslwׇ:m\"qgYldYuJy]2*R[P4uq5K(f	tM\\Db\r1lS :ΧyӜoFUt4;o]-gPMJUR\n)NvB,liygv\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0(?_Qwk\n \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0j,Vdi]UXxҝs6+VUVYk#ef΂W8Du4K]*=9^<\Z*5>\05|Ȭ\\n[:G~8]RWṿtVNz5]a[o޸aRB:ect<tfo\\	]ϗUlooFUt4;o]-gPMJUR\n)NvB,liygw`T*\Z56ZTV\"XA@C0K2l#lb?u;Μ7z \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0UF/p^a¬#+-Esj(?ۦ\Z+(t{,QĪQfib#b?9%cųV.?&/2cn7J#XU#dhЉ3ҬF>5G{=LCy\ZWQ`YĵmMKnf\r{4	@BU\"E@G}:hyVs&pN\n8-ek\"8|k5{ƒ=>2I:=5Qd\'xIIm00\r6_U	qm&imgZ=KL\nܮ}#^ViƷ%eĪz:ofcGƐ5d|^5}4%<7b\"ڐ\nB?KfDɫFo}(yWeSgpk$n\Zzt̍3f=֍pvͽ&-(J\09e*ecKxpjݶS8\\2YmSBrNcwpCs1y/|9/L?G\0\0\0ϤLO;ߜDn`0sd\\uG#θkX#!5\rUe5RBA*2+UlIP2?)	㩥TS/1Mމ-tL^V0Qt</\"bB)s3fEwQw|_yeXM	~nfsU1ͮ	1+.#j}<_5*\0iL\\|yFǕxY˥%mj\0Z7XVJ\Z_g3$V1)duvO[d4xvSI*_~&ڲL,LOq%gF{_v]T]NklF}7}O5MثeVen*\0\0F\08#PduϪ;#JBƔ>Xd\nb\n3Y-6tBN\'_:Q-k/ƺU߽pƥtKǤiy(ߎ.X[mHs\rhtTmNњ?MUdV.7W|_-slc.O+fQ~PPkp=jRN:Xa.ɳA-sd\'T9:sʽbtEvlIIJ7JAWp%)nE[#o:,Sy@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\00.gFcqw9$\\8մڬU/Qsgh6Ax[,PtI֍\Z5sc+<*WUqmּ]U2;%hZԎEg*V̟&l3yѯUV<ӛ-ߛfd1qѺ\\ue:#\\uo*{J:M\ZlTފV(]؎\0,OiwZJe\\V9ٱVTkLFWiΙ@çԊ=_9FSICqɐlU;r䃵䥦%,Nn~vY٫\r]٩&=zҽXNFwM;-+Y͎z9eXVb-̿5}~G08jծJy\"HhnZ2Xgܺ-Bg*,H~~o\r6IQ|u\rhU._LWKҵ\'z6Fe6;z/cR1STY*E.v*ҭqӎWtx\\/\0_Z)fzQν쯚?o\"d<}\"ʱ4;=jdO*Wݯ}Gg7Rbj}lnu˵m3ttRn%ahHmABgY@|\nv\Z\'+fFݲ%?FkGI5i*{X88n\0\0\0>َWQNzb:|էWh7LEPnf.+ΤwhE=(cIAJbZiRV١#5NtIBqi۩.]L$$:XT%zdǟW0ѣBEzI\0\Z3T[E~)HIvj+l;TOLn:ffсb\ZZ^]Sv>ə[bV}5w3qsY9<jr~K)nKZNٮ,IZSg~*<ŧk/$j\\%it˭E\'^fe[	Im2EIL\r/o|UF]aW$9x:*\n`\'{x~*+/}ι߶N1ŗTݳ(/EIuS2ײ:̫b4Cmn]<+bnOnSNfXľ궴6jg^f\r̻qF۞nݿX\0k5]۸k}1j]GLzNǐp\\n!+굍ʽbtEvlIIJ7JAWp%)nE[#o:,Sy*R[P4uq5K(f	tM\\Db\r1lS :ΧyӜD6\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\02|BLQzjtkD!/`ioju?1}DǳuGIrei&J2EFQsiZGP햆JHMT3Y\"9y+;\rV(zt_%LJ+w)\"ܦ>5[hh%/crn<pw.M7SlY޸a,|[~pLalJbB~0rf*,\'(G)P)R6##ټH4jАNeR Dipk%JW\0>7?DΫ16]+/?0qwTI#v>g-bȓiƭ>_~hr>Ѭ𶸂=D:̕zOP*TPR\'{}q;mLMG*+hM[p3񴴮%Xyq}<U-3Ol6m[êz!騷E;{*dM2E>OLH~~o\r6IQ|u\rhU._LWKҵ\'z6\nxPU__?iTMt4b+ߡZ8\'OEWVZ̪B.-9s\0\0M>hFGxw<61R4ђq*_G˭-^3r*eTAdΕDbz96:LMBnNzD!=l&yY\"+	IMhٳvQă\rRa~UGkϑM^DXԺzbTk-!GehʭA˄sg4ji\'.!<.\n(gݯ9hұ~Rbj}l=]WtU΃oۢt(,D]:E$+i\Z#}U\ZWb~4A͊ UUVanwuN&f>g\rJ@nsY5\Z55.#Z]=\'KLc~.7AFfuuZߝ{hC^kGslwׇ:m\"qgYldYuJy]2*R[P4uq5K(f	tM\\Db\r1lS :ΧyӜ\rG\ZEkk[59~sl1>X)vhg[uddl,^t\'솿SQ5MT\"*BMD^&r9^1{Ҙy(k&JERTMT)N)PJrLSs1{w{6\\0ۃU}?\0{nRd\r*a[E^+*-\'jY|>n>GTr7R-YyXDlVY7ߊE0M߆m5Eqsv&UӫE~O$58x|\0S\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\00lŞ<C9鯐Y+U!\\+B!ΨXi-K+:qq4xo\"n#9sX4\nVQINzM\"f9OHF#(vC%h$S\0*B\"<B?QezQ~J2-\Zcq\r՜tHOt\0AhGʱ\";KX}պ(+Ո[,x%>f^JiUjj\'\nJH=)V\Z8IieܼlO˓vt3#hhfP\"&w*5MjBǚ@-|Ox~Zt?Zc<a Im6~:G[{\nS\\2XNW)SIΛ̼nOq{/ï4*?&qVaoЭ֫L~Uc!ӊ8L5h?3E{vg%!dRzT\'Whr^*;ptJrj1V%$\ny)ɉ%GDD6pJI2nKJ(\\n#9sX4\nVQINzM\"f9OHF#(vC%h$S\0*B^Ovs\"h]\0Ɋ#lƷ\0[upS6HW;]9*&f˟^e^%46KlMw?C)9\n]+4=}+`7]q@FجKr|lՀ<:\ZUa-TK`I^VYgkSʇQwr*[d:4Q *J֨HZgvgFdyDZwTphL7YSA&TG,ߑZLʿx3&\\X\Za:yJ:_n82]Y\Z˫R%y.l\0پhv\'޻GM\rZ7fΡ$$ctwR0Y>]FE7Q#;[P*WIJ3݅~2>:mzk!HY(\Z=`bN\n\rO`9ltܜ.B{+$M!;DV.+֚ѳgm:*\Zx\0\0*&;!m=G\"ͤpkD_*Ԛa&F^&C])6A=r9vuQrԍ}\r^tt\rnZB\nJ\\ǷYx{?=[J7~m5躿_}4Z|Nly=zkFXnգ\nel>\0qV\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0p%^<徶OTni݂uO೧g7ڠQ4G%;v&C)2\\NJ ǋ@\"G?9ߧ]g$G1tȃY+c\04K=N5W]O1LڼaVs7s޵xܜ)xU+ſn00ٙ\"uo|=Z??3-ʥ)azVSܦzdLԿO͈ū0[\0mue|Sy7!)TUȩql\Z&DɫK[;+\nnFY:17$PVa#y9kϻc*t&pqRITDsg,]VV:(8= TTkZ&~[;mYt}vJ57F8eAfye`<Әyx=:JE:j)e\\9ӺnKgu]\nM63HJf),[uUɲEFۇܜp]ps(uT89GNs7[\\3V39ƔwΌZ+<}5{=ژ!KļiR߼mt.vZJ\"j4)[I$Tl5g6{ehdtA5!_Q7kf@Sev5Xv|2q*trmĖ[ɺtܹ7g#\Z7V~7\\J^V5{#``\\3{5(Ԫ޽NQbfq:EQsD1]]*M\0x^W>KXز$|n~ɼ<:ϽmcфepK\ZH Sv^|c0%:S83Pm::^ϛ^~6\Znմ(L@IF13}>IOח1Qz-\\>1jQCӢ-ZdU[I19CG-9̷{tヹrnV6e^oZF*|eN..s>kl֧։.7e鸃>#C7v\nGΎ9MW\"o38z{.} S`o|ZǲȆ/[Cvޙk\ZO=N_׹k>*ZiXL+\'M¬Nfw~%L~d>ϯo*\0\'xE6ܓ|<_rDd\'Q?fKV_gUV\0N*\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0آ,\0lE^IBhE:\rh_G[$ѧYaZ<ҝU؛nBˤ\"%rCJ	*:򖿪 Uvn!y?ţ_F.崓%pUY#ʽ**0fF,J(:H3tQ\\͢i2>oWPSg?7=9HelS17:|sn]jE]z;MSzF\rkT\\o\rhXnWp۬H<2o8O٦7DW:iSNZgҪ36EkM\\ϋU֜3W[mKBJֶB\0U+5[_֌Q׳,<~c^ο\Zǵd+ȚKMkj#QM>#6chGS,]E\Z\\^6Tw$fwCFLaݴWb\"Bڌc4Vl4X8.eFۇܜp]ps(uT?M{&\0k_h37wkZ\0fwoֵ{M\0Zم#-ϊ~Mo8qΊ#r+YINHQUb4S7\n^w{&\0k_\Z M\0ֿهC;\05\0t֚vXJ^h5MLv~=L,5d]JFrUJd6]T^<s35	9]WyHBwkg\\%$W5f1uGlT5I1mVM\0ֿىzjDNKxǦ%oƱRdvV\\#U9[TI?p.Av@QDV\"tlKyɩwIK͹.7Rl4bJu䴫qRY<kU])6-7NȮkZ:k/.kfr;\rIe^WQVQ֝GA\nHoQPxrv:䜧g-a\"^rafYCZڳVVme^s~gӴ%\"&Qv]y)p+v\"hGN#JifHOSYjWTnf*v:w<kܬ\nѲW˟乙g]h]yng٪kn鯇|BXs\'Mb²i^ͼ#D6ϛO7[Oev5Xv|2q*trmĖ[ɺtܹ7FNHް}G5I*$[\0&ugZeѯ\nl\rkXY4W%cP	H(\ZfqAOߩ-sܨϳk<- Q)%d ޾j\n:E#>rTuGIrei&J2EFQsiZGP햆JHMT3Y\"9y+;\rV(zt_%LJ+w)\"ܦ>5[hh%/crn<pw.M*R>twQRoɝ~Yֳtk.{Z=D7MUz>@3Z|LkF}YmqzHu+!TU	(󗊤N\0v\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0&v\0\'=cqtxGn\\0qv!2:ZfCq\n37h˪67Sj\rӔX<~xwTt۶\\2Mr%I|AbXZVRj^PPkp=jRN:Xa.ɳA-sd\'T9:sʽbtEvlIIJ7JAWp%)nE[#o:,Sy;YF)]O֠tVS4B1!UoϒporLl>CD-L ]W}oUī2:24C+DLKW>V:]W\'q5wQz[N{RZUnm4=hlzdbrG$jSe!3iuw*4ҥ)H)AX՛B1vf/cߵUk`oEk,*SR!nk$vIk\'VEz\rC}\'I~\nz	zRmffBtۡFGvv˛8pr\nQlĵWM`ƛ1~\r-~:ʱ{\";՝+=yKp-\\UYk	y3l͖x41(Z<,]^zjh˯]/M_\0V;\0\n|%jf*&\\FAȳC:]Y3vLDP9O/yj:*ꮍ02w11=Oh/nǪmFڭ,!벷WFehh8\'xۆ>l 4K\"YőDITJtL)P)r;tPhro*g~^|;ֶaDMfw&\0«_M_\0V\rqW\Z~U[5VMU\0RQdb v	dH参g!1$8.W16Y](bURDc\",~l\nA\'-04۪ȫ6<t[V[FzzJњh<97~wZ\0X0Zm2*>p7	g9H~6Q$*HVoRU5Z<m_i#{ǫ^R]uH[ZkÈ=GYKm<s,dzERs3c@Juii}^;TAnv/](y7N秥]=zba7lG5O7Iq-B}+5lLx<NcO\'8O%f8#B4JG!<b^KmUb㜷xJyP3fwgFhqPftJNGh(X:|uQGb0UTUDXTEUXUUV#}nNlFlv뮵mǖ{,ٝY٥ffd\0\0\0\0\0uGIrei&J2EFQsiZGP햆JHMT3Y\"@)2W;Owv\Z;TPKV8pV:REAL}NjKN_-d:x\\y\'`|X>{-\0:?ೇg]r6ص{,n\nz\0EL5h?3E{vg%!dRzT\'Whr^*;pvxۈ6\\\r4DiRSFHټj:m+SZ	ʃk$B\'3/%s|waõENiWn$T۔m\r~$\02n^6MӧɺXU7v\nGΎ9MW\"o38z{.} S`o|ZǲȆ/[\ZfqAOߩ-sܨϳk<- Q)%d ޾j\n:E#>rT\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0bX&~VFXNk/J+fY05켑\\dPlʭ*Q\"ZDrI)Z2_SZiyK\\z_M)wf Mqf#.(X,u-Rٕer]nUg䲪])ݯش<W];QR%5;m9QU#Mm<!V3n8ekk|Wů&21:u\\^L^= 3xI&dC\"p}Zgȵ8DNcGmw2\'V!Hdc?1PxuFL?z*}I^Dwosϭ{=orߥGlN>?pq\'\'?q23\\K|gudi[eg	pq-deqZ\\3hܚ}v\\G! h*Bk8MT)XoC&	y[zznSd:6gFz0ȧ,#69TՀz2[]ms][ߔ-~	n:Os3_t񸵤ճm̭\\\\.\\_s#_3r\00\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0uGIrei&J2EFQsiZGP햆JHMT3Y\"@)2W;Owv\Z;TPKV8pV:REAL}NjKN_-d:x\\y\'`|X>{-\0:?ೇg]r6ص{,n\nz\0EL5h?3E{vg%!dRzT\'Whr^*;pvxۈ6\\\r4DiRSFHټj:m+SZ	ʃk$B&ͻŊޙ	sz0Pv\\\'6BFf HJiT͒}\\pYE\\nv\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','vsantos',51,'tttt',NULL,NULL,NULL),(242,'% Definio dos trs pontos\r\n\r\npoint A 10 10\r\npoint B 90 40\r\npoint C 50 60\r\n\r\n%Desenho dos trs pontos\r\n\r\ncmark_lt A\r\ncmark_rt B\r\ncmark_rt C\r\n\r\n%Desenho do tringulo\r\n\r\ndrawsegment A B\r\ndrawsegment B C\r\ndrawsegment A C\r\n\r\n%Bisseco dos ngulos A, B e C\r\n\r\nbis b A B C\r\nbis a C A B\r\nbis c B C A\r\n\r\n%Desenho das rectas bissectoras\r\ndrawline a\r\ndrawline b\r\ndrawline c\r\n\r\n%Ponto de interseco das bissectrizes\r\n\r\nintersec I a b\r\n\r\ncmark_rb I\r\n\r\n%Definio da circunferncia inscrita\r\n\r\nline bc B C\r\n\r\nperp i I bc\r\n\r\nintersec A1 i bc  \r\n\r\ncircle O I A1\r\n\r\ndrawcircle O\r\n\r\n\r\nline ac A C\r\n\r\nperp aaa A ac\r\n\r\n\r\nsim A2 aaa A\r\n\r\ncmark_t A2\r\n\r\n%Definio e desenho das bissectrizes \r\n%dos ngulos exteriores\r\n\r\n%bis aA C A A2\r\n\r\n%drawdashline aA',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\01\0\0\0\0\0\0\"	!#$%&b13AC\0\0\0?\01c1c6zHz\\3FĢ;``vg2^R%:RFp\'K-[]\'c1c1c1cO=/gO)ugp$ANv\"j?ttJ[ҝH,۞]YyO#jrS\r4mo \\ͺw.閔!T|̩Nmx79k{1c1c_Ѵ)/?})Z*A&N\Z\"Y\'iH/C[);\'[̯QG\nӌCtZERf2ZRŐiZP)Zƻ1c1c1c1<()cca<Jq1t!uH]/\nz7+x{R2,v=\0}86S\0t$_\"HO4ޝgTkh|)ϫ@=\"lqr3V[$\\Ͳc }q֛~ve!	zF@k@1c1cKGqeaeL}{r#\nqO	DNqo\0W6!,y1c1c1c̣vzGrYQTyS~4 u`^33&9TEmZ#63̰\Z0Z/)T\'h0<lm헑_Wirh	8;\rdc1c1c0sX7{%__icG2J7f7#Wn]<B؇CU?c1c1c1gJ7A_0.:4W$RQAKkcQx%*T5:B13/%0H˿d\'-\npWղ\"y2zzLYgq1c1c1ZyUmCR\0`X6/|ƺ#ln\'yN1c1c1[?զ4:]FYlrBEq4j F~{xH1[xirz^n{6ӒTD|a7HRXDO$)Or*>C(:J&q2p(q^!ޔ/<C[&1c1c1c&a|lDi)#mǙ{cSޖ{ޕyd-޹%(_C)c1c1c3HR wb~GiD]lAAwS3+.RP)-!?r>/|&?k^=IQ()gJi%~O&Ѕ\rz;\0-#nM׸R;Av1c1c1cmXKNH\ZVMKi1}\0\0]k2o-ڬ<q{fUI#GVGT\0٠t:88y1c1cHw<ߎfPG/2d?\r[JV/IJ1-ѬU%#j<je#%a\Zڤt>cdFՊi)	.XDi!Gl\ZF\r\ZF*\"\rW1c1c1c0y]zS-hJ?zOK~+]ROoe\0zyk?BAУ1c1cg3Q9qa˓!i{q\nUN9+=5L5N/`SûD=~Kr}0gŜ%עzC[Oem,H*:\'\\:$z\0\0d`BGF8`lqA(lhi%	Ju1c1c1c1ޫ+\0_TL:o\0ƈr>4o\0)c1c1dѻۑֲ\Z\'ٍ\"f̃4nS0ۯ(% BLn s=B\"]2LGYkpfkVEuNeswC#v):TAerT1H\na2P4䐡үW+EИ1c1c1c1\\E/AW+G^jҷi\0OzL}4R=u\'9\Ze1O1c1&\"k2pPqMML\Z4dL<L`Λ#))$ki˯m6FMקK`$wcQӺ4}K<9MVhҍ}n{2~=.I\Zl~vنy4rZwZ_`MIr8|5 vmI%$2QsҲ2e[1c1c1c16,%0BNCs&ȴjC:oޞ$_\Z\nZC8PB^u{h\\a-U\noXcF/_\0@0_Gyرc1cuLA8Iң?:Lh,ʍƏeў[,0*Dy-N߭jg%^+|7H6$^ԙ!އ&XQ\"HDIDCs<\0*Lz\0/Mc1c1c1c2`|RǦpz\0*\\{hӄ-a>-\'.̊q%{c1c%{7t^l1$=[$\'dm\ZsF:|cBi1z(\\aV.xmk5czNj-.mTF}=VF9Zȸ\nEud\rDܤՌc1c1c1c1jzGԔv3ٛ~!v*Lp.J	$C{q*islӸ1cu׎hTe9\0Q[ʑ<b\"C2)g8Ȏ>Jsy!ΨF亇o3˲ޞ,8rµs)ʪVR+\nm~UG_c	2$tTT{#\0C4!eNYc1c1c1c1c/t4X?)}v(BHr!UB4P\'ׁje)nm(|m8ѳw- >ouzt;gi^39B%>0zMj?MH^-a̔SBǄ|}>\n	1c0n\"3 sʍzOvbkPcH\"\'E\"?w>b9_sjWW+*/l\'?^J>5!h뾃Gt~?TfD.=ZiA/N91m̿l~e0sjDy=3c1c1c1c1c\"L9<Y8HJ	&%dR͞q(޺mf&Ϡ. ;-=>}+vQg|*pqspij4byħo)i>ew7ZBmZJm5`9BF YH\n	4r-<-}-ˍc3򵡴-m*Zֵi(BKZ%)Ju[޵k{d\0^\r<S0.>Xf+!E}fIFKӣ_H(ccY[,n=tU:<:zf6#,Wb{ݾYfQ<LH@c1c1c1c1c1vn4c& ~\rɊ oKng@[VKdn%1Pس1C%\"чU\'yםdf*|.i9V,FMLk@4ɒYsvZG~/Uv~/nX;p]̠)>\"7V]1_݊6$ss_L$OM.}bEݱ뉂2\nH@U͆\"B__\rKɿT6x#G{ǟ^;o|Vz-xQB~@K\0Gױc&#ejYXkU:w7ToBI*D%Ʃ-x5`!b8r10w!-ˍcNDUlgjFLH\nLduH%FT!d,D!#N7At- h3<1֦=ɒJ\\&Pןnm@̋wrh\rkц11AYhaEaBZ`qi(iYi)mJ[m	J\'Zּ1c1c1c1c1=7n|>zʨ\\V{t5ؖ-!gَ|hF\"VT6BAˇۡY*Cv8JlkTWeoNjMBwJ槵[O+8JZ	Jv,H8x<&EvXi?Ci2{KD^fC4Mxs>jwAw^m{ҒI]CM0UԄmxidK<5l;i{/=!aVEB,\r.[܊\\3y?\r̕\0t:uoTNI2ec~C\0^i\Z&yjrM/dK<DYO*]Ĳ5[brzǾS^BWniOѨVj:r%@Dh[HyN\n[[}N!;̓v\n;0Me\\G.HقKvK@I\"D\ZFŘ͌f\nT\Zl=2c/w9ELu	cX!cm7Ӛ*B3s\n5a]uGFc1c1c1c1c̷vn{QyVq5=zntᇒ100CGX-k4[DMZm2AW?-N9l!!)^9yMNB\'`\\.6wM4u*M|裉YW+ɑndUapf<atw{Ͻ\nR\nTQ2av΋X|WvKBc1@Q9A؞6}:$[^ť:9뷒۱ZuDݐA4B>WN띦՞gWG};,<wzOX}J,mR*0:T%Flp\"W|e58!s/7,lhΖ*A-~\\ē;pODcOxm\n]U?FluY1EPO8m!8)l>+m\\m=1c1c1c1c3I#9C\"+.QD;SC\r2-%N:Km*Zդ{Ɋ{T\\e&`0:__r}BEg1LEJp棧NیdU~^Y#ٜqRbܩ:T417mG<mHܨqZIt+\\3]\\K\r=$h>&۲myOTJָ4JGιĮ>f9()6iR_HV~D_Sum%;P*VdAU.\"v\0LڷucE=k2L1*p]J+̀6Tӵ/2C-;eiuu:[n68ۈRV[Jӽ);޷r>z#~XT%9a1Җ7FAXUAqbҪ6+C3kKnEyGɞA\071)c_Ϻ\0U\0щ<{{i\nj*ҟQ:uKe\"(\'.6͌c1c1cɠ@vk0< -,Pd)Puȃ!c18~I1Xϧk\Z	\0C}w1u2$W)7\0#m[7\06ܯLOkI\0e ]p_kJ^KeٟHs?mS]m\\X ]\Z1{^ߏh)d!eaV> C\08Ŷoq\'A;fAZeISZK/>N8߃=o~{$♎bsgy\nZMd!e8⴦֝[B\n[A,C!mϩjK1[ܿ?8г`Jg\\J_לao۵Hw,\r-):5KuM>v=> sZ3*CJ|SɰK\"t)Zx1\0\'ͽzV9%ڨuG:(1tsT0+\nCŶe37L:JςI4Edg\0{PrtyIJB>mINۉӭ\0&\'o٩s!g$a%]w0oqn] \r5	\n2Q%ΣFHKXLp]JQ\0\ZmPJ`D9WFb7byHt\\5v!E9Y؊9RUrr\'b	#``!L1BoHM>9:/46N%M)Nӽs/^{R^TJoIIy\\xf^oR\'ɜ^90[漙3䟔iѓ\\Oߩr.3$tXLt4цPAV%c&Ul\\xLۑkvQg|*pqspij4byħo)i>ew7ZBmZJm5`9BF YH\n	4r-<-}-ˍc1c1c1g;Yd;5z ~ŝ\\v-O}N8ڄς֏JY\0\"Bֳܴy6G%U\\\0_|Thhȍ_Ǡe!)2.$[ɩ\\}!-#!\\}PS.kA X))BNΟӭ8-BNvtKzRսj_,[$1WtMI)>BK}t䣼$ی!+cbbHe˾\\}umH\0^FyGKt%~F6$hRctuaň^JܓzavVJ[\'Xgn$JAҎ\'h;\rGDڠgx+Z]fyZNGH@Zםifm\Zt7deH+Z{aOCq.WTH㪑74Yʆ)	,	i)zy֩;ѤNgLIͻ3#),v?z穉\0$`?_ШR$Ne2\nHK-\"|\0V	.RcIcF!i\n˷cYޤP.B\'\'ކS(NKZlMZH~g\\kBSa#\0b<VB%mSDަQ\"yÜF,J/_[G6y@]x5u	Px+ƶvRۊy	Ю[7NTAFȺ\r3B%(CBC!\0HBmS\n\ZZH@IUldgDwx_rì;.k:\rXUǧz7o?jaoڐHE	ڧW-\0YjT*UxqPLeV\\%1_Bq);,Ԁ\0\0@?//<-U_KQI<]WT\"\r#PZU(!r^pt~\"<\"C^	۽pN@dY}Xey\0f8Bt0ϺJK*hw߮7z@Q7Rd0EtZƣDAn~r6Y~y\">Dv%\r)}<yPz)NytzqhOr\Zq6VG|+[8u^6,R/EG~A^)Vp؋@VrC_#!֙\\miKbЏIF1%)b=RO\\HCJXebV2kuVǁJLIͯI-ʺa&{ި/ا~>VW6cF\'JvVWy3}u*tJ~FQ3!/b p3G 2CpR|Wb@unCr9iќ\0}7t|5V6dkxݓ5*_D\"TȖPEJ/ .oT/yZ.1]zb59v+j5H\r.* yQ9k0po1c1c1cOrHHF]?	2/,kM>*5B Cm\n.g^uz5\\K[L7~wzzDJx<q ƂKj\Z N}Pha +\"Jd:].@\0#sV!Ti}vv-nbIIK,j\\f{ȕ;<Ý։D ВmDWpu|nrڗY.2;sqŢ7(c4Rm;\ry0RKR\\^IQ\'6oC)k*=n<뽻=Ф\'h~wz.^F5YIWo ۛd8;G(TdZ{4V1:;+1;R6nSL7JHY\\ƘE[פ>!b=Fmۯ<ح| d<CM%q)^_DsC/7x?,i_1!T<26m\'~)\0,nw?p\"GݖyKBE~$,6P\noʼo3\"{#שe-0:{ltd% @AQ>USޝ,:TQw{$X\Z^(Jl!Ŕ/n}KQg$_۾t\0%\\<I+^}0W4_yfA֬\Z8$^![Hu*gw~c>\'a\nb		H:0@j,MCz\\y಍Aiӭ,<c4$ߪy\nV?S-s]ct燉>#^\nRV3%53]W63eȨ!De&d셣M\"\\AD_KԁX%WgЍLhKkSs$ȅ:<ȍܺNۭ6hF>6q6`h[WbQ=4r\\a-~r[֔K!rzxwaJ^p=|1OLyl~q~N~w72M4׳{\06cٕPIG|4$п&9-~ymn%{9:g_Z/riy	c,63-CEOtzcz5Ceអ7-mE:3p!_ua^dU1ħ~[}o6dpuXZq)rBrK,15s؜2$\\C܌]vtq;?<iѐm0tmJ1_\0WF\"lE#\\L6$CXi!+TzKF;5S/ xQyT\\SlFhs˓hj\Z{fkb,4d m7uͪU *j\\t[ZA*$ۛi.sMh1c1]չU*pF-lacBF\rY&++`BET;ĩ@.z4-ErԤ?)O\nmA}\ZA[oqZ/<f2I\\Nv^jFWQV*wcv=(r*;F5Gr0EV]$uv_ R\ZeZJuBTI= yM}TOzBc%limODkKͩיh^P\Z\Z.rIA+?2c8]%RxΕ#eZ\raJIJ<8PAƑL}[lߩq3Jv[a]R\Z5.Rƚօu8@t1g:T+֫Dq:<<\0F\nc%0)Nl;*O\nN)I|q_ιEmI洊7TX@>TN*{a$3^R4)Vhߤv]-]ԠMZZB6ڝ؟Yl*^6Zp`c Z^?6#eK_M􋒜Cc9*\"+xޫtJ\nL`c!8O޵z]z.ϩ;7M)叢rI.q8AOuίR8cmD(\nmkT9>D%hSk5zjV\0ҵkZG)[ڕ{vc1cLTe\Z*z5N6c	O3T!̾k{^ڑi޷lT	yYa?`ebt6\0m}~?_s׍!>UvgpcUl\ro0ڒӪe-*\rmZ|_F\n},x5LDz,9\Z?Vi%!V_H+qm%\"^Je~?lS\r4?IRX?26k9ߗk\"J&R^^BP].ym\0eV[M	$)rL\'ҽ!<#\0]R;iJl!	e4ִFg)DHڄR	w|c1HAȢ\nˤQ.CLIShJi:\Zv[,1Ʊh/y*JQDnK:QG}͉H7ڧoU`ydabyR.=ӜEyl3;\nG+bP^;Ө%Ԩj	.L;GN?r_kw\rˇǭ-%\rZUTO 1ݽ̘?9M5RD<w#=XOHBBm	mҔ!N!:R%:RZSkZֵkZ~^fHuU)ϐ^\">!jy\'X=7nt;,[ZʇֈXޛ\0vfV,65F݁dǿ)*)凎Gb춥5Z7\\Dgg#!!&JZb\\ѣbio| A\n%L0%	ڵ4k0=~<Qny픑BqFS8w;04\\\Z)/[c\Z?;sIt|]|2u;dEOޕXAhfCr^r$ēlCm$85$\0\"hA6^m@ީv[k-<8e%Q,m4֑[vc1c1c1c2(-Wߧ89jߝ9c}4*]~\'Z<	&ӭU:j\0F&M\\{=VBhKmBt!	֒!)֒:֒kZֵkZֳ=ZJ-|:W%zLGE]X8Qֽ/	[~dagH4/<4EOH~ae[	Vb!WI!\'qX.:Wֿt!,WA~j3z/6D:E<ZRAJw!#\\\ZN?v-	Q$lU8˧Ux}r:\'~,`T!<;])5Ll؂z>XuWA8`a5fw׹kuTiF9ן\"4sI5jIoRt7Z\'C+?O`d2eVTՊ)5)Jq\"%I21]NijD/R3G+$)9#` \0v }em*VXtZQ}A`9kT\rP䐖KonB\Zcj*E<t\ZQ:0 |%V{]2k6؈2|΢y~c`d(`	x!ˋi}޶6#sCKR:޴z\Z[rQ,%xYX>18D2E;=)|c1c1c1c1{=er+\\a[tQ<Ȍ0/Ίfr.>b ʹ=x+d$9?k5zTDl<Xy!4q妥|yRL:Bjd0p6Mj]ܬJr8{&4$PMeed oK4uZ_>iXZbF.G|M[ʰ7n\0QoҡUT3FyZ&@DTjl(0$(|I\"%HȔQĐCo<)o=oTHΤTu!HAp&(K[E|o3\nm2yNd7ԁyo oQ\0{A%!vFly),4}aՉYI~p5K]Gw8iASCHߵCo\"n;Sg84[]F*\ZzoKs雴l)ܦ;+NI=Ykb $6hI^\rG7x|\Zgh#n[Z(?rPTvP\ZQbEt1}lP\0}`k?\"Դ?	䪴|32b\nS};-j\r}1xhs]iz%N)+D]b_cP⶷, Ɔ{Z8Jԭo{c1c1c1c1c0?҈8H;wN%\\qlvtM9\r?DU۶)ZU#L	Lj=8 INxJ9t:H6B7C$+yZP.Q`Pա=QIf+ֻk\\f2j--mTGg=VAew9H\nEucD$\\VᖛՒ+rReD<㵷7qZJP&#OF9h뷘hB9(<rVeY*cKDgg#!!&JZb\\ѣbio| A\n%L0%	ڵ4k0=~<Qny픑BqFS8w;04\\\Z)/[c\Z?;sIt|]|2u;dEOޕXAhfCr^r$ēlCm$85$\0\"hA6^m@ީv[k-<8e%Q,m4֑[zĨz\06__mjPn-ktאo=N\"ԗIF}ic1c1c1c1c:7K.GFtK̊+U|O4Ćd\'ӣkuJSLlP0)\" |+]	n`%)hh-VjN#Ȏu@vkX>HAPܒ;UˮKs.& D!v}fyO<\'^D0TrJ1d&bQ]ڠˬZ)Dp.)}/Hb%klPE@<Kn2Ĺ5Jc[3\0zoT2;yg \"mǒhbh2sObv}/WuWj%ϑg=ѝXf4>\ZdeΓavJ\0D$6Xa)eZ=\rs-(Gz<,Hp,dDssJd۔1pH՞垜ޏH\ZryƳMIr#e\\Jްwab_yM4ԙc|O1c1c1c1c<$8ca2(%K8ð:>,T㮸ZNF}= 8x\0׍\rNQ%\Zw0i0,E0^rw?sg?)p6 p#\r>J	,Y7$5r	\Zv\\5[lIb$q\\O^gu\'ߟd}\rpvLU걄%vWU\Zr~	TYeOGlHy\"f[k1pqpPqCÄ4dL<L`\ZLB2L0m6kߤv]-]ԠMZZB6ڝ؟Yl*^6Zp`c Z^?6#eK_M􋒜Cc9*\"+xޫtJ\nL`c!8O޵z]z.ϩ;7M)叢rI.q8AOuίR8cmD(\nmkT9>D%hSk5zjV\0ҵkZG)[ڕ{vcɣb6u+ZzgCwZCܔkp\ZS7;ϣ	aiG54+Txf	  P\0p\"!-%THVX}ZZ\\mJB1c1c1c1c\ZTS^cs_Q]o`v;h$>ޏWئz\"qŋK~SvsD}zSk\n=,n{\"D\r\ZKٮh\nP.YF-j-c&.6$?7]?θ3Z뽖Z\"rhɁg6QXGeHn,;UĪ5c{HJGBBCLĹFE,]d@-J%a-\\Jjhת`.zx}s)\"^⌧kqwb`h64R\'6_Zǌ97N5b~wZ~ZǫϿe:O,vȊ*sr̇62I&>؇ہHqTjH[&D68lӨR#aZxqvK<Xi#L1c<$9P2\nKM9#40V̼Ҕۭ86-;N?YCyǙH4ٷݶNf>S~ZJ1c1c1c1WxP]/*=]!ryẺAWh;⬪z\rRf&lH+	$ηOvYw辉X2зH9*YUށP}\nZA5d]ΏmtBU_3#g\0Չ+-yy\Z$ejL;coTď:<m?&Vѫzg$\00A2gM);WQm쒑˲OEX-$4Tvh*nm*ԗv+5rvάvV3u\Zl\\sNʍ22Iﰻ%\0\"NC,}0RꔎܔmK	xa$y82s{\"Q9̹2QhgNm_1cK|E{_ۭvQ;d48-Cz	O͇{Z̗piaT1c1c1c1}\0?VAy}aV9()еJ%:AC1ٖ\'aPYZDTT%NG>/{4M{MW~{w:Y>u?Pv7\n?W4?BVc=ҩyHsc;]	GbS~٬CMbsn!U˹;˕vc}އ^˩ssN|SJycg\\`u\'SsԎr(\'Gs{O*qIZ\"M^\Z!a44{֑oJVk{1c1m=y˦xDn+jPӗ.Ya^M;&->m{V-*Z]Cc1c1c1cɂe\\ΰѝͲMǕ8Iь7g#A$YPx(/t	96~Xx{龖\0GI߯%S&\ZUT9.\Z2vMAE+u-iweV61c1cL^eQPs2GW G&ӟ^&oEɩ4\'9}GaIuACqc1c1c1g]\ZeT9#=g[J\\2R^MdhGKn-\r{Zҝ-ֽA+Ͼx}wڒzoyߟʳIjr\".)d#\"NHj5OWpXj|#bi440BIǒT\\ϐiD>j1c1ce˝/qnʚ1:G5Q![QGZkRPoIiQf\Zăn4ӏ4u#<W|wuMZO7\0E=mO=NG:zu*u!Jf1c1c1c1oNZtFM_0SMMsoٛp	[гYV&AGv;MLE\\2b1N1c1cLUguگN2U@\0V.eNa)_NE׹+Q\0X{BZe?c1c1c1c1c1c1u>\0yJ==mWT\08ׁhv=aR	$VP3tY@1c1c1c1','vsantos',51,'exinscrito',NULL,NULL,NULL),(245,'% Definio dos dois pontos\r\n\r\npoint A 10 10\r\npoint B 90 60\r\n\r\n% Definio da recta\r\n\r\nline ab A B\r\n\r\n% Desenho dos dois pontos\r\ncmark_b A\r\ncmark_b B\r\n\r\n% Desenho da recta\r\ndrawline ab',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0)\0\0\0\0\0\0\0	\"48v\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0臭t缫}Q͓SMx&7.T1M⹆g/ru?L1%;_E\nT)ZΑK˸h3P(QQL΍iR*T\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0.=깛{vwlhl[-NՈ.tusST̫kM~W仮_ʏpچ{jsc:qНgۇ_\ZCw=YK!鱸|;%uc1S^Mëb413\r=խJ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0&<8&LXYvLR]m񣰅:4,8)-kW|={*T?qOa|N2COug-[a,kVҦff83Y2}/`k/DhZl=jl8tc3ЙQd9L:-|rm\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0#9%USZv-<鵓,gVy#u635(%^jA;=݂Tm6z֞e7$Ass\"\rMJPQe?Ƴzgt!\r\riJ\'ġO%(BSJR<)<<<\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0WmslŦӠjhq:VvCQS+n̚,&l؅\"SH\n/}W8ܾbY|?ZZ8Cq\'8M8/z=LOW\ZKU>י =n5חrfXj6\ZIlǏ?Y_K5mEݞYqqb.Ge-\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	U#+oU˨\0h\Z\\ޡc]EL\\{9_{f=>|a-_P\ZW`TwhDcamOJ䈍n,6=}TTwGZȔp\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\00knj}+rY:*=Fspiy\\6;Qey.srSZ.2||W\'}z~eXXm7ƪ\Z؞>.5|J)ϸ֖YO/ScY<O;j%\r-ld ֱ\Zy#0i}?ހ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0Lș2C1bEe2Iu#Ǝ$>,T㮸^\'}N_mv*ʥKsy[2g*-9{,i/ę=kvy,V]+eeSaM̬l5Ⱥ]/{/A&9N(kjrXGE5mKbM2D\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0tQu.gX~;Q]aU;|֗S*¯5q_y7y)ңOC&JtS8(S_ޗW^<WIo\\YpUvm\Zj/]nhyE}QX!mm%JP!>%B|)B<JROyyy@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0rm3f-6SCҶӶ%J^H}[vdYg3f>(ʟ:DxP~S첹΃7-.Ǐ9Ʈmoq~K)zg\"}b\"Znϔ`yt,^2QKf<y]qj,VZˋFv\";)oD\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0aa[Y*!ɰ(!23\'N%mǉ$v~Lmmn!\nWGtW<ܫ}͗Q5-CǬW^L/U:s~_\"3X{|:Z5vV2(-k}ͶQx-ڟ#Xl{4=B(\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0a;M<nVtUvzl>v%Yf\n\\)j墦\\;_Od\0\0**y$Ѫ1wcQwÛWKpNa;x{\'5}Kc]cR9ǻlO3\\md9tȶs}\'̹6[NʢWo֗m9sNA[Y@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0yL_TA3&͘QC=&T/)Ǎ-uhiRP}L;ܬjX?;2̓d!|(TzN%UݍlQŅ]1G|g2\"{tLKΏؘ:,AcaUמdy-ߟK6\\wv=ui!mm|EuϮǫrI򥘪N/tYZ-tI]S+hv;Wr8ysTT9\\`\njO&vVs\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0t\02wݮΩ74c~ڇv,]>ls$EN\\g3~=\"\0R9OzTm\ZmG&+f*[e®QT?\Zz\nNd1\\;!FMn!!Жm)B!	ĥJ|)JS%>yyyx}\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0nwe-E7#DcVVCK7\Z3J%hKyUY,gȍ&He&o>z*>+1/f7{>Ĳ\0?Z:uO?imȍUKyeP?Kϸ=γIMs\r<2ݞuem{gɶ/%\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0/k>~Ewt7:UԺ,^\\G]:xѫyMg\'hIEeBau΢vL\\*~y\"/IiE,?2g\"St4EJ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\02ΩٹyZoc15xuKr;Kj*U6lzj-TV5&HScb>;g{#M|zb_K\\+	[a^7e,}k)LU^[ìi}j׼xO/ScY<O;j%\r-ld ֱ\Zy#0i}?ހ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0<ɑ+J>Th0 ~dٳj4Hq#4ʕ%!񣲅\r4JIwO5c^LyRoeHӟnq|SjtkSOkMpkKӷV8y:,X]egXôt9qo^\nTif}fG͚UeUy>Gg&e>THۀ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\'O)ysI9\'}b&ϙ90nbDT%s?>lW3/+\0YץFayQmf|rbii}ն]*\0J@J\Z5ò\ZhdBBm	mҔ!OB<JP>ySyyy\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0yYkmBQr4Lm5ed4q4V.l_2|`\"dYrk}>kkzZfc}K/u[܈޵[kԿUq>c.1Hs4,l,_>OC-ZVZ1YY|bYi(р\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0tW|L}Q͝K^%ɮ9ySGi\r\Zfr|\rVY|^݄/fX*kR/k[r\".TX/+[{J9(u=WCIZؔ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0,ꝛqkwef3C[?MGT(08z(vSfǦEcRn߭:6#}\r;>Ǧ%°OնcyڻRֲ$_:_ƛ֭{/ogn\\6?fRPOb\r]Mkןb3\r}}\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0̙$FgM1D3JzLR^R\Z;([M!N8>pNTS]5Ǜ&TXߍ9V56A&4fܷ\rG;uaQcVz\0/`l;GC\0`ZlUFVaWdq٥VU\\ǟSy~{fPceK\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0t\02wݮΩ74c~ڇv,]>ls$EN\\g3~=\"\0R9OzTm\ZmG&+f*[e®QT?\Zz\nNd1\\;!FMn!!Жm)B!	ĥJ|)JS%>yyyx}\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0nwe-E7#DcVVCK7\Z3J%hKyUY,gȍ&He\'5wO\\|}\'|nRe2GHw?{jq\n9\0c\ZnQsJW6E>ݽךr~{gj5;;YzKkt	iZA6Y&<t5wz;?#9ۢ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0&MWrov{F>MvO@[tمj+e3i[ɪsSe?̠=ŋU\'\n&A	͗`lHZl9|ukYkh5OMNXQ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0]ԻVLZA&Uv7tH\"?M,\'O]%j%^H>..fŻ%I-2OЎm;7d[8v$Fvw4)f57#[.ɦFKh!5[CWg+|fE-Tx|j,8̰o\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0<&D*|Qf}!ČҞ*TcƎﺴ4HS)(O\'/{j	ğwUfc89Zm c丛۽\neM\ZV8F+Xjzs4q?}d=L@shv-uUVgs\r&CH#;v\\=\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\"?0L,O%QW[f\Z_j4yڼ-06\\xWW_.Sz)wT{(-5_<Ϲ%]75W\0@+q{sѪ\'ex#YZ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0%bZoеx܍(~CYY\r/<h*D.K-!Wg̱\"4,H!\\D8ľE\0h<e\"6V/CO\0KD%=1|\0D?2osNV~63:UOOnyͽw!{\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0D=k_=[=*lmmC95EpNfh~0;>{e滮|\ZJNvVwUjsJ9gwTa,ȩtz%DH:\ZU*\Z*~ֶ\rR}Fڷ4U-ѷYwlܻ(LY-&BBm	mҔ!OB<JP>ySyyy\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0o\0d@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','anonymous',39,'seis_2',NULL,NULL,NULL),(246,'%Definio de trs pontos\r\npoint A 30 50\r\npoint B 10 20\r\npoint C 40 10\r\n\r\n%Definio de trs rectas\r\nline ac A C\r\nline cb C B\r\nline ab A B\r\n\r\n%Desenho do tringulo\r\ncmark_lt A\r\ncmark_rt B\r\ncmark_lt C\r\n\r\ndrawsegment A C\r\ndrawsegment C B\r\ndrawsegment A B\r\n\r\n%Construo das mediatrizes do tringulo\r\n\r\nmed a A B\r\nmed b B C\r\nmed c C A\r\n\r\ncolor 255 0 0\r\n\r\n%Desenho das mediatrizes\r\n\r\ndrawdashline c\r\ndrawdashline b\r\ndrawdashline a\r\n\r\ncolor 0 0 0 \r\n\r\n%Centro da circunferncia circunscrita ao tringulo, \r\n%que passa pelos trs vrtices do tringulo\r\n\r\nintersec O a b\r\n\r\ncmark_lt O\r\n\r\ncircle oa O A\r\n\r\ncolor 255 0 0\r\ndrawcircle oa\r\n\r\n\r\n%Interseco mediatrizes com a circunferncia\r\n\r\nintersec2 A_1 A_2 a oa\r\nintersec2 B_2 B_1 b oa\r\nintersec2 C_1 C_2 c oa\r\n\r\ncmark_t A_1\r\ncmark_t B_1\r\ncmark_t C_1\r\n\r\n%Bissectrizes\r\n\r\nbis a1 C A B\r\nbis b1 A B C\r\nbis c1 B C A\r\n\r\n%drawdashline a1\r\n\r\nintersec A_3 ab c1\r\nintersec B_3 cb a1\r\nintersec C_3 ac b1\r\n\r\ncmark_t A_3\r\ncmark_t B_3\r\ncmark_t C_3\r\n\r\ndrawsegment A_1 A_3\r\ndrawsegment B_1 B_3\r\ndrawsegment C_1 C_3\r\n\r\n',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0C\0\0|\0Y\"\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\05\0\0\0\0\0\0\0\"!#\'6VWS\0\0\0\0\0\0\0\0\0\0\0\0\0\0,\0\0\0\0\0\0!\"#$12Q3ABq\0\0\0?\0<<<<_9&>ZM2{ŲP4C+ad)S(25bYH ZFBɯjҡɍ1XsLvSf\"?3&PοmT2[Ѽ\0?E:5n}k6ք\Zp#0aL\0/OY$LDǨO@.m2#78\\iSiLXvy2uGV6SB	0~%IvrlbbaXqSyӬ\0\0n248Cw9.UV&O?J\'Q%2q%rɑe\"L:RQy2c7Z^t-}?*UzfU%ZFqR{?4i.g[Qz\"\04\r^ԍ+$6\\+85WkeeC k9\\\0_9L:`@Yk,Ϋ_n0n[3d<5剞ZMw|b\ZQLUxsV}&ҹ%\n&YӸKq9LwڥCDFA<MdH/*#\"HPE9!?(\"10ux5HI&YaLJBG0,0\Zµ\0pZҟTuaz3*]y?FYȅ̚ι0yԹU06e|X71A(zT:CRjF6$-}	d`K9څiYyas@S\n\Zhő-TE!qtxG\\93f}5eּEPCtb95VhW-YlQ?kұ THVNUa{U27ı?\'GxHvmNGego/2rmXXE6c)TNMxk,AWXM!3}n0~m>rbW49&	$I`\"Q2(XDLI-\0>>;V*m/_g/V yPLI\nE*eN8@`@m<y@bΠkvw{*0Ak<fbȵPJXR\0\0Kkc\"7r>WI׬0ߦަ!C4b]A&D-(Xi3ak4d&}wIdE\nJ\"\"!D\Zĭ2^EMUGl3݄{KPz)e)x\\ct&Zᥫ\n[?4@k.~|0Zq/\"oZh\\9FΚٝ+Ȑpe\\#|) cX.UQM`UXh	:uAZajH\0DCX4(-4-5\\kO6,ێNGւ**faQ13ْ螚Xkir(*A`3,WAY]A|exlN>yYJ\\e$nY]\'UfbZ|׋t<aG\0-SěCRtZY͙?7=>1s:*D1b~_<SԱPiM*l]q=w#ٽ\\8CtvH/\njO66V.;#%%ks첁]CE\n\0\0\0a b\r(C0PAEZkz릸\'\0lP{P!,.u|Xu&V}\'=Uͅ:Xo4zFqbO8~sec\0ZA6Mg9j	:XrTG(\'AX{}@\0n*\'(Nl܉-~ϵɎ`dAP߫ae5IQ9e+Y~:S~;]ȟ?}^?B|Ĕ;?^Hx]gpv:n✪k:&~&B\"0I\'\0H\ZI.M̃$CE\0~5\0\0_16(QBvTb>\"v+%#~\"L\0=Dw#r>܃u|Ե0֪\"/行{\'_\n/õdXX\nx(RbTXa}ʉԓKiXwĻRtRvoX/|:X^I2rh՚e1BӷXif#+!j6[lD{-׆Aw?3JGP:tK	Bx:1]Ol9	~\\GuUIzA*&^{W/)HhƊĜz\r,W*K`]u L\ZS@Xg\'^9\r2uk-_܄Zr\\εf%x\\|\\g-\'y֡v?<<Fe_ژ7uZmW&i)|h2\\qUqI;\0FԪV쁾\'0gqCWr5֫OFH3&N\\\Ztd$p47Dd3	pkU(_*ńVa3MY1q?<O3][UU{j{a_EF6~zi(V],d)+ώՄRlihuKC:%?HͰU:RϲwڊV.L¹Q\\TvGuwx	ǎ]\nI\\9jmJntj:曺!Q~o`z.}c&uU}[W?6c+8x\'bӼқ<T,њ>oB5\0?2II^x*\'ƫKUߛpI}.TΊxuT7Iq\Zg֛Kb;Wh0$ߴ5%0ƚ9u	mfrNC}kkniEt4Ew7)jvl@I-#_K,\Z:	?=	7&F51]Rk+X@K-\"U5+`%JujU	+ƐpB0k1i5ǙO<F#?Ƶk1s\rkLֵ&12f93)\"\"0Qh/-a}e\ZT~Wɨ&uEԺȕ_&xZ45[o?Fs-׮wzޛ^poFyCjp>mLNfY~.}Dr*bΩ#D[.ٮs*E.l{5Vsi$KD if)V[_*\rO׮\0bk-N:ضoeZx bD\n/fTE\\cWy]UˊhZ.r9I{ϺQ`CKI\'\\Mu\ZWssonźsIrfҞ/w5@S883yZ3fC<\ZMP>6Us{hBԏ0օppmXNWRWDvr6[UΒQ!~i	Lctg\\Qͦ4-zRF=pKknk6P>d\\;X\r$3aeR\\MEOWb#dIDs+P\"#OW6&Kvʹr-{1,UJl[Fcbɧ+CpZB6YuΙH>To;U萩(en|AgvMRi/ׂWO^M_)>%ן{MN_?YgKUƪ1=PrT,=\nu$\Z2dI.=XbS8w69ԡo]@c;3e+pTRcM`=Ph6k \nVؙy\01UXuߔ8򊾡h=r!ǒ靴\r#WBxffE)X^a\0N\0w]7KD2k=QRMmKɝqemح1C=]*+$={<ނZzsa=2RF^m󀴉LFIu}RXgU*zMr^)h*s4:\'<UUx\rG~=:kV~`(y*{kAINFBqbǀGed*}hܫ<[71jƍ\ZXUV񳏰f-])\'.*5lw$KRF\0GKEjPYfB$L8YQ˦\\؉ 5YD?ũYg!)Cr!t1:$yѷVLM`D-SFV^|ﾑ鼒oqǮc]4\\gmmu]qscsc}ye[Uj89K4<Ȕ.\"M	95[$MWHđ\"\0fzQZ\nkNz	9뾄$z&z9x=Nj\n\ZLDEMu\Z6OųŁSÁ	FCn V6ѳUGMkqDӄ=y+7Vjd!^-=#90SAݗgW2z;!3[Iv+U?Ee,nlS[q%pR?X%Rԇ?zk\0sD9HiE|O V>Vڙ͚Qͷ\0aoŉ2l9Й1+,d#:\0Ns0ɾӛPKm79?MF3F&t I44yL(al	rf,==P;9K+1i3cb\"ð8	>l遶3\ZZCe <f;a\n-yLȈvX ^fqRp3YL.7gҹ@B8jzo1弲޺\\~\\cys+tO7-Ub`-9s=JKEm~E=@GwB\r=W=[i:`jZꥒ[;4\\$UVTJߨW\nIPTS}u]rӊINc]zQVJGva4q6(QXRdM $C}њuNc\Z&˃aFB<sHɨ˾BbY2#7vm=?鸚@\r	bkI%K$m4ICala[Ǒg&>\\JZѩCh%c֫ɰjh&psܪU월OUJЕ	rwtXl2^]hikB݀_%C{}M.Fv&.G2}!$r%{w}\"%+UUjn:7MgTEŕp>x\"汰꘭W5atzrX݉1DOyl=ͬ.s}쪔5q看*amYƞ~5N@Ҩ~$xU\"Ęi.07졮$춫%&ehy\0S\0e2)S%K145[?viU˫Z.Nl$1/fj1+*]lљ&٘GnwYyUlXs7\0i3mC[\0\0dW`a	1҉cƠfffffgws_E}*լ6XTr3)Et+ǀV!b\0XD%Gמ\n=XgSuh|ϐ;Y\\v~J|{*f\'՘{gGeXQzTN:`yKҙe\"Y+:&jA^aubmz}ѝ٥(8nߘ(E%g/^^t[ZB|n˭Qiuuï[@לo+g,|*GR{5/i^9NEGv@}Qr$P:U*5OJ\0=+ɍဃ5]>P2{-Hz&LpaO#JpFbg6-}jXZHxQjɮKxxy;_gSaGWK	+`+DH<bBJ!ydMXXL\"3HA7uH1pE$i>,_oP^1xϗEߗS]O]O*)\\z*Z0L܊횰ylxzaOy]{鰣XQ>uXP뵷[4b*/K0Ro>~(x5)xhcG7^lE} rPQEhNY\\@?@0YfC&Ha$7KLُ	6` p!TO,a\\Z1>)[@1qڪ$YuVc_:Pin@D\"S\Z7(urnNZVmSW6\\SVݞA,wu	KJZERegx],]󮅌G`{\Z$8)nu#=L=f2*yTq.-Uu+kM }(~C$)EWC¥ޘ<e*{m	J\'RȨ!zti\\sS8+\Z	=p\0K=Xmٍ՜ҖP.tRv8\"<H9@޳lq#n<9K(\'hZhFEi_Ow\0zo\"O@+]Ǎw?+J5HϗU0Ga|WFNn]6Le\\k|WRgd/ɞn]b+Jq8M/nbpkUW>eϾ6{4Pqt77F}=i<Ml23wɭX\\ro&iE+)\0zz;q:}6\nS$aLc R\"= bG]yx]6XM]͔p)kyuU/%bIH2a8H*]l@\0wF[hJ؋hW侍lOH)rdúeG˒f쟽-);O MF&Uisw۞w\Zc\"OVmv4ޭknH>r\0p?ͮ-6+iP\0ch74up36m|UOƾy\nh$f\r*	||.ui`[͞D}A`\"8WtX6@OuĳGhk,ٟe]Q+[{o>\ZʏWM\\aZdP$sz:b^*=\n\0MVښ|nܹY5pBD-(u0@W^R\'W<{oH:EN\"ZBsaIVY]tW4X)+m~pO2@Gex]e&z\\i5E,6C}vZ骸\"c>n[S\rɱ\'Ns\rv>:*TfMkv:ZqjY=i֦\rǮ>JͥBy[ׂ;>,ٵUW>3\Z:d+]jI4XZҭU(\\ dAMZtp@oykxxx//%K/8GD8<$^\0%iTN\"#9|yGj>qG<5b+uiAXEOz\"&DUGj^;`mz־ҭkP#%g&,oo:\"%hB`9Oc4y90		D		DLLL_a^U\\k5v+خK.KB5L5LD\'\r>GV`4iBtlPɒ6T%b5yL6u 9<<%\nT11#ˤ<k,34[miu3xnM	ĉLsk<d2Qwh6,]1{M)Rոc&M-͍sxꖙ%,Vg3&C\0rF`k22~_F7.rl\\-<wdj-XZ04[ʧ{;Iv)*۸f7.뫆9u\n*kK-r6AOAQ_\Z^Ҵ\n[KFE\r>~1YR\Z5ask]+)[*LBJ):l5AdƵ73O\nO^m%KZwb.pzkY+\'Fja`xc\\;nЯ\0T60us|.>8EEA|t}Qʜ.2JUYԹKcAd5\00cdtU&LN)k:PS;i8|*6m׷X\r܂,;쀮ϔדc\0Sx\'L4rkzV扭ZQJ=Ja&^\0NxM?._>l*\00ȓq~7rZŃc\\?\\(kt?\rı7֊P>o\0SQ]^<B:7D	\rutc:=ޝHfw^}e50GDM[ݽyCuUNP޵d{M 	lN,m=\ZgJQFekegI|}}wkY[:áZU)szz,tNjP%#e#62u?3]\0S^??Ϫ}[Mbn[e>K\"Sڲ~H$2=xOq}+\\ár꜊\n:IzE8ҶЙU$m+ /','anonymous',39,'Seis',NULL,NULL,NULL),(270,'point A 50 65\r\npoint B 45 35\r\npoint C 90 35\r\n\r\ncmark_lt A\r\ncmark_lb B\r\ncmark_rb C \r\n\r\ndrawsegment A B\r\ndrawsegment B C\r\ndrawsegment C A\r\n\r\nmed a C B\r\nmed b A C\r\nintersec O a b\r\ndrawcircle O A',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\09\0\0\0\0\0\0\0\0g!	\"$%1825Adstvw\0\0\0?\089龎Ȳa++:,]Hdy$ޓMǫ[Ln_E6]!p6:t6;˹zJȳ.m6k@;J3WՊb	\nwӱrQJ#\rez1$wgf;KR2@gr۵6$eFGP:d[Lc\"d쏶RWfe]JK!`Ykc2mjX p\\pecbQ@7:ż1U4o\r;m%8Ĳ[ۢK.R;=}EëpZadrj[C{]UШHMFq*c{@D<.g%\\cV\r$rCfDy4C68##_xF\00J3J\rK[\nE	=<{/S͕Ӆ08;gYq-U1ϷZT\rF6DAϏ\0LLehE(Bq!e\\C-HRUo89\\G\\IGî)yW1	2I A/$buM^E031Ë\"cKZJ)7\n%j.$R\n%H0@`{\r~T+5x\0$vlz.NjDH#ryWpJ\0P`dv^\'YNcfr_`yX 1c`JtMTIy%X/bqM-i~.W)DӍ!Ysw$qq*)Yc9FleLnM&@0BmX0ddϺbr}Zƀ/w豌[Z:ʵz8N0:ĺ\'wx8XJ#\r}n9Ht4mqΡ`&9PĘã}7&k$!x*y$sO2	Tױc׎wS`H[weoճZ8@ti-ZY&1T^lyО\"8agqceS3kk]ys;N:%ٌV`nTyqq#G)lWi$Rh1RuENQFH%6괬Mp	;qΗS[=pDL.؃}h|EKGCrW\Z>:rEMEYs9߯g/cW)cSE4Q2=<5HQa+,{FńdCv´ͫg\\fh:ߛ3Y?̯Ժ-?Bf[7KX[ICPpSW\\:pR2NT/7:(g\'F,#+&EXƫ<cVmŊ- 55oLf;Iډ!\"\"פJ:k1LJDHue{ˎ88i:6wO)6ʵV4bC,y8y)kSaGXVJ*\"[\Z\r=wͻls:\n57D}*OP4v#cCh݊oP0ۥ(Ⱥ;[j8q=	fjo-XkK2Dѽ&HL$`	_lƔS&\\Hv^󛇔K/᏷F2^̇K.\'$]O0C>͔zVeASAZ`mj޻5PWmu[qQ\n݊099[S%JH2@GKJK.{SzU[w}ͬnrM	9:ꉲotc=%)%ɍ+n㫕UMTJ%ډdTla&B\n^\ZRP5-mvg㬻iot2!ulqqއ&JM<~*r%bY^h졵(bB:ՠ3?.v(vV2QSkGG\n^(TCG=b\r1z.:\rmKpXۡCY!\"_oH<7-98Ouڋ1\ZTo,rn-D*iBI\ZjRSBa.8*g*y\0rIť,<*mjFHtB:@_{}P\"\"N`lZ<NΥl]wD!3{H-4#_šU[eZ&52I@үS/M蹕Σʐ1gl3T\"dm#5T5HzL.n]ɪ둓\rN1G^)(؛]*iE_F(n<he\"ccf88S3c欸ޔJo(\"uapOA\nv8U\Zڏ.vns%ĸDq9TY7jmqo\nG>l|=>ɌЎF|ni6\\rPjwlL&-c-o*U^u˶axGЖ!U/.@^Z!:B#XmwKOd!>7# TB\0Kxsbk0&\"{Mkrp20r\"l[\\e>aj;\rF-XO=9\"&yE,w^5l1H{!M1\'g!˯c;_88GuYT76-%yP>#N\\향s#dUi>t!|#U\\Gl^Eֻm>hl7(NICgآ\Z:#RT`3jWmO/\r>&AtM#T6e\"%d4*?MCq\\K-Qzŀ\"+KF$(|3D}X!__*Bib{n߷yN>8\']Q\r7OXV3՛\\jfHZ:6xQR#|Z,e\r<),%ZFq5^hwl\'g4\Zg+c`fZy\"4YYu_q?j{<oy$ExQ-om#F&;H4u$r@xĲKS}&;!	=QcqqXWAҲ<g(QVI碾[0en]m\nmbu+uRf\Z\\̛!XiN6O	q[R륺{}E^VJ<څg>6K7PUR&ؗ&l]:q;_}{8VK~)c٥O:IDTnG1}\',li-m)bR_F*GFCEEV\\ܘ/EӪIcMrl@Nu6.NtR)u	~##N89V|r\'QscĆ,w0QHBCm[/J:B|*z^9<uRR->o^ZB +Ҝ;I_-Jk7\Ze5q}Т WU2*w;ѿRWk~i	Xu\n<qq5Lf7\nyKoU7?i\Z19R83b%\rXHEQ\n[Yn6֬~4smD\0FڼZbh{)6*tEŧl1Rݤ8dIJ3+zo} +z	7\0-\0\0_Gu_B{.$2#L[1/ҨH)⠞H8Čv=sp	e1\0HK#ِe^؉gٲJ̺H*uh!b!Cqq0vZr/TADY\0O	/1\ZZ;ldiw]`\\m}\\	-~\\sa9;GwuFX7,5?\nSK;E`FZW+Vnq{\"kX[	EHekKS4ںxR|B[hi\'$!DI(]m)!Teu%Е-j=wUĀ_$HZV+/P{O*Һ8eYQ[\\ly&<vԆKeq	ۜ<>)Ǻv>^ό%Cqkj#@w&};Dݝe$yZJqBgǶkQ-ʑ3ZiݐGN!CqqrݰMZ+b*{5kcatmĥ!]>MHФO42.I*a$$MV\Z\n\n/zȷJެuT$o=yl\0Ut#\\iP֪T끗/egV<9U(><xFDqsR\09\"/{ZX4X)uT?xqH0{<!FlhbG8 \0!0\r00l;-ZBm	BR/PP,w\nsZ]=]ٲ\0XbWC䛱:5ǜmsmRt7Is:yZuy.Rܪ&8ŌD,.hwJ}e\r(\"IÕ888CzOכ~^R0Y,FImvd.\"Y͞e]Bە^z9\nƭ{[!a\'l2ʳlV7Ȗۉ9ΖwO礪g;HBNxe\"R(Ϯkp>|Z.a[\n\0vUzI+MY`mNfSOG۞yKsl2uy]+Aw媰YsBNwG29WDXbyc;>G3CvzQZ:a-jٙ)(b4Y B/I/!S	$硟O_>LD~~珢?S?dq8zGg}=~x#3N><}\'O_>LD~~珢?S?dq8zGg위)[M7d`f]gXnRATlt\ne{|.\n>SG/6O|`|`!\0g&cy`d;+=I|YyyHZ.gyOPR36): 6PVG>rq..cϿz@\nb\nqv[/uiW(߭Om0i<>H:4\\猨2f4VgCzh;;B7(X}_Ye^I=S3ݓ3Q]m*	5uʹ8>_=j}j!ȆI x۵bFqP6YF`[	~b\Z%3k$l6dsC=hѭ\"[>\rSO<qqq>V6mKZ֮!=v-jW}%)Jz+뮺뮹KeԚT/OJ3G_Q*Pzb(\'K]HEn߬hZWaҳsݴl]n^R\ZJpеShR\rDU~L\rÕf2f,i%p}@KIƱ&nIH<<4WbGX=;qQ\n^9^uT%$kҊjщ7	|VȗJ<O,9Kw\\ȯ\\)#\0BO4\ZCvdQ/ńHHMVgm\nVS^bZx݉\"83qqyGeua--2-\'/BTj(O]]]-0϶\n\ZZb̌4yYiqPRV٨Ew1gh7ChCm-R!	(BIJRJz뮺뮺뮺\\qu\ZI̷֦:XuЇ.f,IFS.Pϸ0\ZFO>[m.ӛXH<I:f	Rִ8OHI?WBdI1 ZQ2yU8sPIYx9&AH	6tÎfvH}n88ظqM\r[gt{m:df{W	&Upd_Sv3\" 6Lh5Y.G!he$*ͱ: ־o0]G\Z!C4_i(yV7M*RzBhKmBzJR%=t)뮒뮺뮺뮺qs1a6j`!f\"dt)HZ|9\0xCB-,gaiţߗ9Gk#ٹ::umb\Z)Wc#iY+Cq6C)-%fmޫFuCn>ołˣ所\0hvgil&W!+ޏnAǾ O?U>.&`\\YgN&-y;i[<,b嚋˯!n\'KLu--JZ9XP2;|r}	uy)y%ƝmJCRVvnGw\'?O3pfD\"u)P4;8pPCJR}\ni{OPOfz,\\0c9ɔ?vx^/ˠyPIl}2{p[D+5e5K/qލk]aVò|azJ(I|IpҞWf8Ӳ\'޷ۻ	w\"/-tNG|\0ú6%mS DQh&PRCBE|[88V_\0-/\0G_\0\0<?˟w\ZGp\r\0p{_CT\07\0닎88','geogeek',68,'sample01',NULL,NULL,NULL),(271,'point A 50 65\r\npoint B 45 35\r\npoint C 90 35\r\n\r\ncmark_lt A\r\ncmark_lb B\r\ncmark_rb C \r\n\r\ndrawsegment A B\r\ndrawsegment B C\r\ndrawsegment C A\r\n\r\nmed a C B\r\nmed b A C\r\nintersec O a b\r\ndrawcircle O A\r\n',2,NULL,'geogeek',68,'temporary',NULL,NULL,NULL),(278,'point O 40 40\r\npoint A 20 20\r\npoint P 80 20\r\n\r\ncircle o O A\r\n\r\ndrawcircle o\r\n\r\ncmark_b O\r\ncmark_t A\r\ncmark_t P\r\n\r\nline oa O A\r\n\r\ndrawline oa\r\n\r\nline op O P\r\n\r\ndrawdashline op\r\n\r\nmidpoint O_1 O P\r\n\r\ncmark_b O_1\r\n\r\ncircle o_1 O_1 P\r\n\r\ndrawdashcircle o_1\r\n\r\nintersec2 M N o o_1\r\n\r\ncmark_t M\r\ncmark_t N\r\n\r\nline pn P N\r\n\r\ndrawline pn\r\n\r\nline pm P M\r\n\r\ndrawline pm',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0+\0\0\0\0\0\0	!\"#$12\0\0\0?\0\01c1fsxhoK\0e)\'u-t6Ke+,_cJ{rнMhF]fR稜\"26L8X,fQ{DxD@PGɧ뷞kc1c1nɸdƕ^Y伖(ۺ]Qd3ev2HK_Jr;^-^WIg.Ӵkf&*\"sCͩPj4Un\\k0MĕJc1c1c1c̣U^N}۔.amKSL1._ N9?>Lm#i1c1cIܛ&KiYE휵Kk2۵C6Zc$#܂qMX\rh!.j]veȕl+Z<Tl|l&Qr^r-rvkU\'c1c1c1ceLOb.uO`b7NZ=Imw3~wG!EhFhc1c2ݹ7\ZL8ҳ9k<e[wKj,lnI)kAGwù*`\0C	1#\\=W+UVyQԨL)[v-v\rO1c1c1c1gX*\"f~57PYAd$ \0xS!<C.G]z*Z\\\0,hͱCJRzHgS϶rխmI\0\0\r7c1cIܛ&KiYE휵Kk2۵C6Zc$#܂qMX\rh!.j]veȕl+Z<Tl|l&Qr^r-rvkU\'c1c1c1c1=g}Otݾ_ȏn&IkGΖ?DN_XZß2=]c1c)>ۓqc+;Hy-fQutvfVdwx;Z)\r0<EQˮ],{Y-\\EkQJ\\o8KRn\\:]nm`\n^c1c1c1c1ty]|-rWwTo:6Z83B=7=Vhu	{hPbߥnBbϗH@EIOdr\\JMH\ZM4s{1cIܛ&KiYE휵Kk2۵C6Zc$#܂qMX\rh!.j]veȕl+Z<Tl|l&Qr^r-rvkU\'c1c1c1c1cYy#3\04oUyRuI뾀ն..6~-Ia=񔫵-w3I~$1cIܛ&KiYE휵Kk2۵C6Zc$#܂qMX\rh!.j]veȕl+Z<Tl|l&Qr^r-rvkU\'c1c1c1c1cws3z(S	KC<8:V6rU4\rح{h*I6hLrwFAu,+7OdLҚU~\0Ο/\rX)OF4lc2ݹ7\ZL8ҳ9k<e[wKj,lnI)kAGwù*`\0C	1#\\=W+UVyQԨL)[v-v\rO1c1c1c1c1fOI\"Zf#QiB,c۹roA镏ꦦ-<@!זIX{č621cIܛ&KiYE휵Kk2۵C6Zc$#܂qMX\rh!.j]veȕl+Z<Tl|l&Qr^r-rvkU\'c1c1c1c1c1z9A]#n,K\'2U	\r5Q	?x?Ϝy<1*+}WHJW6RYCp3rD\0JfT#`߸шr\'}5cOvi2XJ/l^KY]m.ݨջ$`9/DmlA$8sTrK/E^DeWZyGRda23Gmۗ\0h[X7W<c1c1c1c1c1c2	\0,ob|dc5;M5Ǘu\'T@myfٱKTzG4=ű2ݹ7\ZL8ҳ9k<e[wKj,lnI)kAGwù*`\0C	1#\\=W+UVyQԨL)[v-v\rO1c1c1c1cSrQBszgW:j\0I@%0(Nn~o\nfKi=/fG&G0|=(u\'mצJ<ChWA{/Vzm٧|^?<Z(Yrf8\0Xݬ~G_gYZy~M^ɩVm54ݿKrnAQC\'k0Kb1aA/ЯWoK	ĮfE$Z-M4\r_C9\0J-D\0MXhڙ2?Oű,M\0\0ةGT[mۅAQRȍOΛ]G]\0~	c;j)JAT_:@\'bD6i~M;.eUEohc˺+ɡ\'9[?XΘ%)gHS\\[ne)ٗM6e?¸6ٟ-X\0߀Z?yK4\0_Y7%ǋSTڕ[fb yc	h\'}ehe)4m$M6}7ou_|_}=LwnMƓ%4}\"Z%䵙Eڋ!-[F\nZPcAjJ,4Lc5G.atUdJUqGTu*6Aq6(9/9Jtpݹphvu]x*zn1c1c1c1c\'F.IYlc0%cNgsfTEnkU\Zk+YTS$@,&J #o4oϦlj7]=v[<7!0#:r\"Oi伶&fs1}--lI$s7goX$&%K+5\\x)Rzc2=kU/bs^iVثM%6b\",q\r4^\0O#G:k:\ZD xoML\rEp&,d_7%z0+⦵|Pd\0imYE퍶e~gf+N<Fŏ\r{?\"[i\'i9e	Mehe$Xm$M6M_u_}o=|̷%ӕ~pu|:BYYK 8/×hRV`cNNǮm?4;wnMƓ%4}\"Z%䵙Eڋ!-[F\nZPcAjJ,4Lc5G.atUdJUqGTu*6Aq6(9/9Jtpݹphvu]x*zn1c1c1c1c^aNnƵh+IMZ#[|*9$xؘ*b*p]:Yhv.`	$,tz\0G4&YL6\0ٰ0kк7K}Ztg1c֋iy\0H/Ԟg+?$$\r..n3޽cFVYc[f]x{վbMv76=?,~ߠ⋽WajhxGݽss\'et_E%;ui_?>T[^ǑO,$zs[[K!nk?D߼G9u{k\"Wej<QGySˀ[GSWt1c1c1c1 vn\\s&W*e\"[\\Ծ8-Klk#RFk2۬6kkbEKu\0VO5V[Ϩ׵h,\';$&Z)Hbx\noc3zZY[*}GmYSeZM0};ĺ0\\W3?K%NF$MG3]㣿)#׆\Z+B)՗%jW\ZYjB6[1c2=Fߺ-nQȫZBVo	WWQjl#C$̳(\\l\rR.>ٹW~`4_&j^H-͂)~\"0{i|5U\'H˩3^9ә.Ka\\JK\0$}_\nI\':i\0]	c1c1c1c*yoX.SNSX9*|Q(o5qh4B?\r\rxSY<Is-)`b^R%7\'񚪐\\:HE15v_\"a\\Z25gU9դu`13zŎj;0JS+KcFֳ+`,]!jY\0i3z\0Swb1Z46_s-[mUME3%>Bhc)1Ax,SWغQ;^^Q-J\"<os8u[UۿY>1c1e\'ۻrn4,qg{ry/%.nYj݌0R҃rWU6`6cG9u{k\"Wej<QGySˀ[GSWtI#V\n@\'pϤ)0I$$4{4[mkQG%g\Zps~?l>Q}/6Fӎ,p3+wm|v[:g>puo\n}_x1c1c1c1z7\'P֍sM1&\"/v*G.Wj	2OުlR꥜<~T\0r5Exc%kCp5ŸvJi+1V&G%qb@//x\\i}#`Mɷ珅sOEA^o}̵#e/sBmo}ҹK\r1c1wnMƓ%4}\"Z%䵙Eڋ!-[F\nZPcAjJ,4Lc5G.atUdJUqGTu*6Aq6(9/9Jtpݹphvu]x*zn)`OY̈́%sYt B$.Xc1M}r8\Z:[%E 0\"a0	Da|ۊ(O>SE$뤚m}K󭮤5>Ļa/%ݬܫPU,<YD!RqKrXO]gӞUr\0۟:N]\0:\0W&&TޚQ8LS]j	8>1c1c1c2ǸpNXL`Z\'$0#pvZbrOӉo,ZC)\02Pk:Ěb\rur[°>KUw,]0}%;}Ϣ\0c)Sq6`sJ!/dW#H	?@E\n55:p/j/`b9{ek+5A>zZʥSmofMyy>[hQB3ڻ(|SӘأVXLPbc1fMkNaNcp|)l݋6VD:ɒAW\Z%\\ތ\rXFQB2zndkmjrv΅iEn.zB3PX}ZL/PDlMe=ޖm6]6ng}CM$*!*\'ȩ3Fv}\\7Fvu>hVV/䔻[Hѽ)]\'IJ5#R\0ͼ\0$9G1%RSRc2%qD9A CB@$SEQɦGAjڄ\n5-Em(Ya%sj#Dp93BDrGy~r{w50{ҙ5Dp{W:ZA>GlVn]ֹW􌟺=y֯|{h.2>;7ΕnT^/Gs댺5-i4UJݎ*\\$9}IuSnXQuZj}mEi]a89IָRAk͎\"Y<&O4Ri1c1c1ce>f:K*St_Cm\n|\\ <˞W	7_;0:SHg>cSrB-t\\+w_!(Bߐ̾U+6i8_&*Xf8o?,ӉB\0ZN:)cET~MlgsťY*E[6%(\"]]\'v!ugV;z[WF1>RY1g}M}c=v}tM|mm]u_=m<}<0P/~Ή\0mV%X:uG}eR}|ѬUX`^Ix/	V/v-5$&rd}߶ث֛[n=J}0sr/,Z:jB8GV7&L\Z3\0mNo,z;@zjw\\?HY3taޟo%vÜuZel[+6F*t?M\0br_|Ӫ~YOg[~55\n\"P/vE_)#G-28hSk|=ߔ\\àףhE+C|蠣`ʿѹL.?M.f\"^)]=3X+)씻?uY\'Lq[4}-ZҷEZ)K\0:R+D$GeI =p81c1c1ceQO>Tۆ,-\'\"t^WՒgHBh8Ը2aԫK]]7f;ӭ{EJGjmOij.\0IvǠa(o?TGڸmefRRkZF<\ZXuc69E72\no\0\"0uӤtZjHiDjʷa_4tXB&h 4H(mJRh;BTc1Gd7=ZW\'aIY%WVܾ7nGGhQ+:XjFY\0ʑzMO쌺]ɹ1գ}z#tqM;Sb<B	\nK/cZtU\Z1gEh%lT(147?Y?R^B	S\'\0I==8\0½Sr	͡	e2叡l}QggVNd4bg\\\0d{9Sµzr\0o_ z\0?zwkM[[րp\Z,3\nR5f$-c\r~*[buu镉ڍT2\"<B؆pWlKjC0*,1c1c1c3*Di_p]h]v瀵\Zԓc)}X1tvU׷\n6zy?Q5=,#\rx_	\Z½CTbB-@q!V=ScC,2l_MLLѴqraћ5edm:E[#ZGQFS9OgXvC	;r4l|\\k8!b\rNRk>I\0£qI/hOVP64ES&iźjGNWsnGsĲهv.sEUh8\ZQz5heG*|%*TR)]\rc3u\nX\rl=Z~?`SLa\0Jf_s1\n\rv*0s[\0#D,U`;@`TT\'nӆA\0𧀰I! yc-}vCr:tJr?Vi67.D%P7b\"OA-<8\ZWu*k=ș{4rvfx7a-{_Wޭd]zkլ9^0Jn1c1c1cfb._iM=o~:_5{s}&:8\"I<M}\rgx| 1cao?=s~O׶(=͖=\'gkBAAZ1\'V\":zfU:<^šF{h4N3t;~@ƅXҁoYEV=_(t@Y)|]%e_>DmعXSnw5IDN{}[fQht1_ѐoc3*kq>-Q0,_UvrCEL#m\nyM,\0Йdm_}ynsy,2~[ק6N4a%V$Lu@AZD}NvSD},ߣ`&`cCԫi+ɀ!Uf艤m\n2ֵԮ23rI1c1c1fUY>}UrM\'ٿж<h=Y\'>\Z_$X1e\'ۻrn4,qg{ry/%.nYj݌0R҃rWU6`6|\'A\ZGO*~G>SɪZKQR;V/,!m!}RU}O{=rSyeEY.SQ;NX_1Vlϖ4Ȓ5t!hVm\\j@46aZYV5,bNlʐQ[Q},LXo8\'\n۹sRhQ\n6bZ*>v\nOkmx_5,R֋FФqG<ϣVi-trӈԴJZPa<mJ_9f5?=)b=c̵ɺ5=Yֶ<yaV}_ڬFm\"RF)նiC\r,B[!ى_\'қ͝o̨u\'\\\n/\0FG֟w,yAwFP\0I:]:\0g)/s;٪g㭒]3i/\0o?_o!02!(BJ\ZXY` yxhHmMM=1c1c1fS{\'.X2S۹\'<b=^2]Eh]pHQIf}YcOvi2XJ/l^KY]m.ݨջ$`9/DmlA$8sTrK/E^DeWZyGRda23Gmۗ\0h[X7W:X9tt:t&5]wժh*ݟ-!g r;ۊmR#X$[e_XAޟwgVTW6l3:ۅ[VTa;!rq~I+\r|ú2C=V$0X$4YZÙ1g`ZfYZuH?PMgFU֢\".4ZOήvb*Vih}fbc=}V=ǸYS#h5ũ;ueUpF)_PD,>ſ\07#p/Ɍ.&\'s>UlYChѝN&&i\Z	ARQK,I&CI֬Ku_*bfCRɛ2k_6(y59Hv.>q6-k{G\"tݜƔTR є`kq\nIw{uX:\"wZZǦsha\"G\"(xx&YauI\"=I#M}7wu|2\0j-Z΄w3+KR	uk$xU$i-NbbE_6{c1c1c(W?;SݗTgש!ssjc\'Tع5\n/,EfgY\"_v?-wV{FEEW]~xVjjXҼ\r=V-SSԿ,ќD$xd\n2c~U^x%ͺHO~^^Hߊ&u)I\\\'Z	?qBSV\\\\^/v1e\'ۻrn4,qg{ry/%.nYj݌0R҃rWU6`6cG9u{k\"Wej<QGySˀ[GSWtQkН@B^Z\"\nWxe^7Zݤ0s8HD贽&E˶.B^1k\'3[5_esZUuAmox|쿃zmc5*5n1[{+/uUB!>29akG=&Db˅b]ɸYϢ]|c&͡{Nzo0!ۇBΗP(/Si\\ʡ,tj;B Ytdߨ˂8gۭm|hrr2+.>_ƞLg!<E./#e[yOz]5C\'^\'c`aryEY| /X\\MuatXc35Pt/)?@̏xE!W;U5- ż*6zT>fb^1c1ovO@U赀Clw7|B,/zF\0\'׼u}wI}X@+s;K47o#eĈR~B?	}#x\0HbϡӾkQFM}R>-\"O#\0xJ8\0O,R4Md_?\r1b)oN.i?<JBOMH&\'m_4tzy n$5]x0t%>Pߖ]=3\n\'I&m2d,qJ,\ZHo?GS[k\Zk	 JǞA@F_?0iǞd2(uޥ@;xUU+&8s#(-#]2/\0hEz)\0\nGIU|me~7%|ˏvE1Te+ޮuʛ*g.r[IQ=e\'ۻrn4,qg{ry/%.nYj݌0R҃rWU6`6cG9u{k\"Wej<QGySˀ[GSWt2HM:hl c2j${.D]\0t<dj1)$!,ce?:\0>氈%鏠wFA_3O4}ztx 9dR\r#ǋJ.4\'{_>g-&ԓ!ZUaѹjdm\Z=Ckb\Zeo\'kEnD**ci#UP6*+yX9+1=zm*K?Z\\PZG;qXkd>[RF\"1Ib9<ziF|׹ۘڵmp\ZYdWH\"#Fu^i;Υ\02	-|t^fkLNOFeRY87@k!Q2 ;۪%]YGP\0:UmGSOxdhsڪ\0Cmk&@7bnkٶWSXD0@Y_1cF_>&t\\Uh\0\'!`:\'Xd2?7ocui>E&9}?:}~\r|J`}!d7Hz5a4b<]FT\"|m\rKc4MqK <7&)ŏ3b=ҟA^iX vƜκ~Rǯ1WJ*0|EzǨ~^I\rmS6)l:}{vC\n_Ofy1c1G~xB\rb.OWn_HDx(.{>#Ovi2XJ/l^KY]m.ݨջ$`9/DmlA$8sTrK/E^DeWZyGRda23Gmۗ\0h[X7W<c)v:_Cѝ,-ܬ7Tlt>בra6lk:gqI7tc2;gTcMsmbJ[dD;Hj1bS 9i E,SǦFNx][mRdPWj5&^h[u$EvNYGMѨ^\rʛ$/ry\0j\0Ьo<wtXR[̜NI2iHrGUG:)Zj\"]RXlcaT&^6]$@?pܿӺ7#`k4v\n.rk9J2rTde/mhaYnzm:wuoXt\ZL\"u0](7BG+7f+}\'\0J=Z֏IEٌg6]\ZBUR>o穆w6#/G[,ik-f\Z;?)P.%C7}0\"O6Ͼyi\0yPg.6-AEGT9[߇]%1zɭJعd*BB$m{t+z-^mo`4*EBklS&\0F}iʞ(muoo<=y|6WݻmNTnA?A*^x}أH􈩉2X8\0G&Z?Uof%AI~A5|DX\'=JT~)m\'O7y>j<]:8履qWna5k҃u&\'竼Qy7(sWtY).ehKN=e|7ݡb\09kzY~xRy$i\nr$\Z&)5H\0\r$}Mͷv}r_c1cu&o\\Xav\0S;LYAhK<L)(E$2o&>v,V\'ھrvR k/\",]z8BIIujzXn\Z}Bs?l۾_k,nwiQOpfKAvЅiRVv}4ϠksTrK/E^DeWZyGRda23Gmۗ\0h[X7W<cC}PXT%A\\- Rgz몙dS\'\rȳ0QrΤJ\Z)14hsHLZ1B@C<[oyF1c+NV[dPKr|H.ǎB?ݻ]g-URH1tH&$Ak̭	gv>wrmkac4Ƙ	(\\J<d(CjU\0t_ݮF(4~2	ѹcڼ}\0\Z#Ej=օ>m\ZctVtbYŔME奞(di|\ZtGy*Aq,uʗuVwE5W֪ugQu$뭛)ߦ?xlXFkB9_/(G\noTN[{w\']i\'%B[I;xLIzES}@k+\ZM}_qW;yZ_Kpy2׍WS:+iԞ2!ۖ]sah-oSw\087+i: \Z%E\0w&pob1T)4eHiwO`R9#?.^{u\nj8!mgk-ߞ{Ǳ20=}$]|6uSL]y4h&1Ѥ>uOEIvv.o-[Ӧ./??sSwzj|~k׾RָKfn=&N}m&_$rw?ǯi1c1c1c1\05.a;Qj^l=\n_BmĮȬbQ,w5^딍(Nں 3Ap%~:;ɖ{R#ʣ@Ba|ܗ\0d=<jkcXFu?9ci&&oiyiyk{g\nW\0V\ZUN؄O.w;V5^t;4@ZQ%N1ew\'S^0 ^{%Z6s_.vCej]^sB\nH\"MtkskA,O)NbjV;e,	jDДKRC\ns*yg+dSΕ{3hbEt\nù\'h`ׄ>\04!ht|.\0K}Zd1\"I] F}$Zxc˞XCB=\ZtKW4o|a脮YO|úv٧N[Z\n*\'L$oq\0G_ 7<\0O{˔nՒl}~Rrx]|u^~Iݿx/0[-C:;Ga>IszYSwce2t?A폣H2H|Ƈh	{9(6mF\Z	y)ܕY(W64\'1YgIHi+닖9{$nD6oomϱc1c1cV}C)JW*6{m\0Iid\ZrJ\"1F1mc$\ZB;5k2(/6aӺs~g]c+?fJ>HL9G10`̱O52ū)t4Ϥs*\'^Gհ^!a\Zc`h\\x^mՇpSh!qnk\05Mw2n	`wԹ\"_ӕet\\US`~DS{\Z޵g+\n;eV¼f-ik;dYF4\"g\Zxx_|;cQt W::6t2갬\0ʑs\rD-2m5nQ%DW^fWO:\ZNtttZŁ#Zw\0Vԛ2KeٓL|qyxǴzw{˖kYc|U=dCx/<q\0[+$U3׀</\r,fb yc	h\'}ehe)4m$M6}7ou_|_}=L+5\\V76JhcP@Vx5BLR^m^#M_;-ϗp3/=39$r|Ak	w՘?5Q&uw\ZҺ0+]Z;㻉XכIV\\p0ۥV݈\\{#(mc\0z1\0Eu\0~P.Yy&гNzZKZ:b2a#~}o/*O&ll#eGE̪_$M݃^,h?^lo\'O	yZAGY}75,Krh5\0ЗͿ%\roW6i)GЭ#1Aty\0y\r0Q~]\n,CGGM4M#Mc=uM4tM|]t]|]u_<]|<<<3e %sbtRoN}.\"gb:\nh5ˍ4 X\n<<z^_+dz\\>o6A?	g\nጡ>ZD  yz^CrޭE~L-m\\FXk]*2X\nWh!VEC$DI^mզ;2٦*Us7k\Z,\'Z9\'Ff#	Tk\\nakBكQuok/AhBr]u]j}k\n:%^be\0ƱJx6R$%\"I?K<c1c1cV}C)JW*6{m\0Iid\ZrJ\"1F1mc$\ZB;5k2(/6aӺs~g]c+?fJ>HL9G10`̱O52ū)t5݌fY\Zl/=ݙ~hķo&\\tWFƟ8ҁ]k0y3村ި:|߇\0oX1ۄu\0vz̟\0{_7߬o)5.O<z#[~өrΛN1Mث\0pn^mwZY[m4iS\Zo6]38vU%Q	f\\\'BFq)j/u=%p{:EBU<֥bC5kYN_9;_p{m泦r˫<[U\n~J\\r%\";;@=Q9J-B׶O?;LAlv߱n@1~3>?E+<,̧o7){]Q4ؖHBSof\0Wr>cNA*!_F}w/bڷ~Q|!H7i(]xwzFV-6oQi,5{\'g%Um9ig>w`b:lY)լSOS?@v	Q-2öꥏ1^Ntm\'G`6QiB\rr6۠G|a.jmwiYx}wMwaybY7}v#{\0mQW;sDeҺXVΊEp_tnxyWYGV\0X\"UF:4u\Z[y]?l1^;C^Vލ\\c,\nj55UJMrNRllѹgG\06 Xy]Í\r뇆^_,-OV>ïmjpeu^vt7yLaW.WϺ*eYs;%i֘%U_Yzm_cLW\nb(dV1\Z%(\'as2oMДH96ZUj]{\rah;0՞u\r揗T,/R.brC.oUjX9cVʵqF^]uPҐ\"hLR*1c1c2AO2RYWl\0\0ZKM ӗT80Kk *Y٬#XaGy/lӘ.{:Y2UZB`>.a\">)e``}a-YKѮcU]7~\Z:)\ZD5$oV8y$ڳLڰheȚ5s!TSiK*<\"f{\\Icc\nn_VoRl~CdIX\ny|5Hpd7On\0dS]J)Hz̎=E8!NePmoP\0ąs)]bdqeWN|\',UaQ_b\ZT\'ƿFYҒ_v#_;zoigpݞ\'vqJW]6f%g\0o\0OwqnHJ\Z֖rwy\rO?@%읏VCZ^vne%-X%Y_u?U-os-\Z*KAxI[n7D\rb\\yJDL`zt6[1SUW+uL_Xl/\Z$jg.[0pV\0ŉ@A1$1onhdrEV?ortƄ\n\0S/lT94*\0s9SB[m!؈^e\\ڜ)/\\\\v2`[f͟YlF՛mO4}E<	X+ 2C[HYnjO/u}mf<c\r?w\0؄rODT;+UN\'i.}$I#Y#]w}6m7o<]_}mv=o=||=2<ouwjkŕO\'dީtfUOMtL\0	ǫuz?T9Rvvrj5ߓ!dD&j|\'}ck3wKTeۜ~YyeϴgN0b\\v$)}kȕhwwo\\PZ]w9ت#dc1cV}C)JW*6{m\0Iid\ZrJ\"1F1mc$\ZB;5k2(/6aӺs~g]c+?fJ>HL9G10`̱O52ū)t5݌c3?~pѵurw.@9>;/BXL\Z2~~>1}di_:H<2MU^e?f鼬<m\n@<2>~y^}>886SP;x6}փ7Pׇ؃O,$/I3}#6o:HQ}g]r~MKС4m B?qeY61oN֫ï+Z3VK&LD*rH$825q:%a&V]0_`/W]KS5bmb$y4h_<=6֤)U\n_g;ŷ}	[l=x]GBV7\0K[Q՚RT:@\"qn/ݺ\n;21>ۧW\Z\0!#	;uA%l<^CIJk\r˜n;/WT\'{iD\rA(F\"k.](\Z)ި\"\0Cd:icI}4,mB.v]Uط)\na!o|Z=SCVy%Uբl5!z?MSI7Do	E1DGufcy]2³IV5Rnyerd8i:<Rgte_-ߙ1^u-s*un-FX,(Ҵ\0FM[83ha\"G\"(xx&YauI\"=I#M}7wu|3,1W\'n|%&L+p5uC)~o{Ǭb[/M=\r]Uc U:1[au	UUfF~#T6Sd9FD\r`bpDW(OhisMM^Ylun܅Mԣ%}lsK2 [ߧ<~a|֑DecESm_jc]UIt\nk*\ZZPGיN2\Zn*llc1cϨu<Je^m\0_i-7LN\\IR\\(1-v6ă\\Wgf3XaEf:wN`bgVi	00Z;c0FYXe.F:\'?I}t;WuA}x$ԉ<ɤ]/g믾yR:}o˞{\\?S67rh}Uښ)C|+MGߝ\0Tڿ?ߞlhXwVg~s\\W\0aC2Fɽm䓒	g?TǬrA_=\'7fZ~I%UIOSh㿟~=X<z *OǱLT:P\Zd$ԫFX!XŏD#B}~Uy\n\rRDkR`\0?U@pO\0Ͽ_?s1c1c1ɽ}[,qf 6\n>sQ(?Oܙ&D}z>~9Yc2o#YY+\'M`IXSM%1FC)t<^8,MvjWPƙ\ZKDKj]An9]Jvbcm׺5\ZaZRvYʣ!6vrv|}`!4oAq91c3tKZ\01(5ƍhwWUjmG\\v[Fh|C/zUO=5ȉ_c*D1.g	>hveh`rNt+P)F\06]C蟣/i%>se_\'jCn{W;\'I1K5|\0evr%J+H;sM+?<Ҽ <21c1c1cE\0E[(aWV@<HR[\nT2D@˛XK\ZX\Z_t	#=7֣d}}\0:4d2[*۴DP֨-i]bDUz\Zﴢ1ZyWPu%:m\ZKjumbUr:t#]`Œ\Z?\">|1*bQuyC/Gv4Yѝeۯ=5mXck}1cY.U,jOGSZ\nXVH,:E^Ӕ6I(\"XtbI?I\\c1߆Tpa\0g]>\'-bS(7$2euѭ`<**tc1c1c1c=Wj$Ӱ;˥qr,jYm]4fD8mNlӭ4<}.t&1cW7.GzeNPیp9W[hg;R~C+U~:%kFʖTaܪ{U씫WI:zYNeVֶxl)Iv)n&Ů1c?','vsantos',51,'TangenteCirc',NULL,NULL,NULL),(293,'point A 10 20\r\npoint B 20 30\r\npoint C_1 40 30\r\n\r\ncmark_t A\r\ncmark_t B\r\ncmark_t C_1\r\n\r\n\r\ndrawsegment A B\r\n\r\ntranslate C A B C_1\r\n\r\ncmark_t C\r\ncmark_t C_1',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0D\0y\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0#\0\0\0\0\0\0\0\0	V\0\0\0?\0PG>.<51x9A<8}g[\\L =ZOʼy\0-f\0:RپP_#o%>/ظ倞d?aw#,;qǟtIF>;|k4ׇ7^lZ҉fIc[,Xl\0\ZCSN5{:x]==t#Ad\"h!cELvS<;^1tc/v-Q,$P:4%\'\"=\raz? a O61P˲*Fdx`Ε}i{_*k99q=}s0\\39ghVCH@rn̅n0=u6D1N~+||\'D}ב?xuvuhJ\n=g\0&z8\0zUH`~4tJާ9HCq@ۡ]ܾs2\\2^	:g4[y\0)f?g5\\DIk{cHԋh6L\rTRմg_GN=RUYa뗪t+@]Xџ_].?qc\\!W1~t*ݵtTBrמN~ʗF\"\"\"bڹw72B.˭yZ[VP8p-4pKt/|	@\ntD1FǱ\'nrZfUKkl4.ݚT|XԴ/vvx\"\"\"\"\"&.话ss/\"N<߿ו]}ukÇCG\rH2jW0<1OKKh\Zl{?v{/ukk^x\0fB٩۵K7KKBggN\"\"\"\"\"\"rs鏯7oƽ[\\wV<JnHYm_PWDz5h5l|`q<I~uwWVKKh\Zl{?v{/ukk^x\0fB٩۵K7KKBggN\"\"\"\"\"\"\'89~0{<~5#ecQ(+wطڥT\Z\nU7̎G=','vsantos',51,'translate',NULL,NULL,NULL),(294,'point A 10 20\r\npoint B 20 20\r\n\r\ncmark_t A\r\ncmark_t B\r\n\r\nrotate C A 45 B\r\n\r\ncmark_t C',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0$\0\0\Z\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0\0\0\0\0\0\0\0\0\0\0	\0\0\0?\0I N,Ϛ``k; ]/=+JMv_-	R\0VʿN<9KS#:_OL`B5稵ecV\nUD5`7\"cFsEWX*7yg~1Ƈ-8F(Z;RbĪxlׄ⛚B;I*)0f36o*_<Qk0K]FED.v	٫PpK\rnPU1s@\"/PXli)}G)fzCh\\\0o]	V)KrvlgȏLyvio0kJ%%kpuna8w_)\rYGzAĒ:Ǥ@δ9y6<)E>b!a4/es/ըdREM\0<Xc/4swU(%U\nux6R5\ZOrGaQd>:5:ފmpbe*jZ&<G\Zr=̹VqDT])|i࿫حoG3pa\"s7]bJ~s[L5Ηr%~ݚi','anonymous',39,'Rotao',NULL,NULL,NULL),(296,'point A 10 20\r\npoint B 20 20\r\n\r\ncmark_t A\r\ncmark_t B\r\n\r\nrotate C A 45 B\r\n\r\ncmark_t C',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0\0\0$\0\0\Z\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0\0\0\0\0\0\0\0\0\0\0	\0\0\0?\0I N,Ϛ``k; ]/=+JMv_-	R\0VʿN<9KS#:_OL`B5稵ecV\nUD5`7\"cFsEWX*7yg~1Ƈ-8F(Z;RbĪxlׄ⛚B;I*)0f36o*_<Qk0K]FED.v	٫PpK\rnPU1s@\"/PXli)}G)fzCh\\\0o]	V)KrvlgȏLyvio0kJ%%kpuna8w_)\rYGzAĒ:Ǥ@δ9y6<)E>b!a4/es/ըdREM\0<Xc/4swU(%U\nux6R5\ZOrGaQd>:5:ފmpbe*jZ&<G\Zr=̹VqDT])|i࿫حoG3pa\"s7]bJ~s[L5Ηr%~ݚi','vsantos',51,'Rotao',NULL,NULL,NULL),(297,'',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0d\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\n\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','jnarboux',42,'temporary',4,'Coq\n','1 ; 0.280000 ; Intel(R) Pentium(R) 4, 3 GHz, 2 GB . '),(301,'%Definio de trs pontos\r\npoint A 40 70\r\npoint B 10 40\r\npoint C 60 30\r\n \r\n\r\n\r\n%Desenho do tringulo\r\ncmark_lt A\r\ncmark_rt B\r\ncmark_lt C\r\n\r\ndrawsegment A C\r\ndrawsegment C B\r\ndrawsegment A B\r\n\r\nline ac A C\r\nline cb C B\r\nline ab A B\r\n\r\n%Definio dos pontos mdios de cada lado \r\n%do tringulo\r\n\r\nmidpoint A_1 A B\r\nmidpoint B_1 B C\r\nmidpoint C_1 C A\r\n\r\n%Definio de trs circunferncias\r\ncircle a A A_1\r\ncircle b B B_1\r\ncircle c C C_1\r\n\r\n\r\n%Definio dos segmentos de rectas\r\n\r\nintersec2 A_2 A_3 a ac\r\nintersec2 B_2 B_3 b ab\r\nintersec2 C_2 C_3 c cb\r\n\r\n\r\nline b_1 B_2 B_1\r\nline a_1 A_1 A_3\r\nline c_1 C_1 C_2\r\n\r\n%Diviso dos segmentos em trs partes \r\n%iguais (do lado do \"vrtice B\")\r\n\r\ntowards O B_2 B 0.2\r\n\r\ncircle o O B_2\r\n\r\nintersec2 B_6 B_7 ab o\r\n\r\ncircle o_1 B_7 O\r\n\r\nintersec2 B_8 B_9 ab o_1\r\n\r\nline b8 B_9 B_1 \r\n\r\nparallel b7 B_7 b8\r\nparallel b6 B_8 b7 \r\n\r\n\r\nintersec B_10 b_1 b7\r\nintersec B_11 b_1 b6\r\n\r\n\r\n\r\n%Trisseco do ngulo B\r\n\r\nline b_2 B B_10\r\nline b_3 B B_11\r\n\r\ncolor 0 100 0\r\ndrawdashline b_2\r\ncolor 0 0 0\r\n\r\ncolor 255 0 0\r\ndrawdashline b_3\r\ncolor 0 0 0\r\n\r\n\r\n%Diviso dos segmentos em trs partes \r\n%iguais (do lado do \"vrtice A\")\r\n\r\n\r\ntowards O_1 A_1 A 0.2\r\n\r\ncircle o_1 O_1 A_1\r\n\r\nintersec2 A_6 A_7 ab o_1\r\n\r\n\r\n\r\ncircle o_2 A_6 O_1\r\n\r\nintersec2 A_8 A_9 ab o_2\r\n\r\n\r\nline a8 A_8 A_3\r\n\r\nparallel a7 A_6 a8\r\nparallel a6 A_9 a7 \r\n\r\n\r\nintersec A_10 a_1 a7\r\nintersec A_11 a_1 a6\r\n\r\n\r\n%Trisseco do ngulo A\r\n\r\nline a_2 A A_10\r\nline a_3 A A_11\r\n\r\ncolor 100 200 0\r\ndrawdashline a_2\r\ncolor 0 0 0\r\n\r\ncolor 255 0 0\r\ndrawdashline a_3\r\ncolor 0 0 0\r\n\r\n\r\n\r\n%Diviso dos segmentos em trs partes \r\n%iguais (do lado do \"vrtice C\")\r\n\r\n\r\ntowards O_2 C_1 C 0.2\r\n\r\ncircle o_2 O_2 C_1\r\n\r\nintersec2 C_6 C_7 ac o_2\r\n\r\ncircle o_3 C_7 O_2\r\n\r\nintersec2 C_8 C_9 ac o_3\r\n\r\nline c8 C_9 C_2\r\n\r\nparallel c7 C_7 c8\r\nparallel c6 C_8 c7 \r\n\r\n\r\nintersec C_10 c_1 c7\r\nintersec C_11 c_1 c6\r\n\r\n\r\n%Trisseco do ngulo C\r\n\r\nline c_2 C C_10\r\nline c_3 C C_11\r\n\r\n\r\ncolor 0 100 0\r\ndrawdashline c_2\r\ncolor 0 0 0\r\n\r\ncolor 100 200 0\r\ndrawdashline c_3\r\ncolor 0 0 0 \r\n\r\n\r\n%Interseco das trissectrizes\r\nintersec S b_3 a_3\r\nintersec R b_2 c_2\r\nintersec T a_2 c_3\r\n\r\ncmark_t R\r\ncmark_t S\r\ncmark_t T\r\n\r\ncolor 0 255 0\r\ndrawsegment S R\r\ndrawsegment R T\r\ndrawsegment T S\r\n\r\ncolor 0 0 0\r\n',3,'\0JFIF\0\0H\0H\0\0\06 Image generated by ESP Ghostscript (device=pnmraw)\n\0C\0\0C\0d\"\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0-\0\0\0\0\0!\"$	#%21A\0\0\0\0\0\0\0\0\0\0\0\0\02\0\0\0\0\0!\"1#A2Q$3Ba4bqCc\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0;\ZyY/{#2ӊy}C誛3Wcu}wz#m\Zyx-qo^yRkV&הH~Z\0g\"\0\0\0\rkQ#k\"K!7uDS>vin\Z.ȋp!]%ʍ֗%ϭ涟*Ox<~\Zgd~[.fa~<jyK[mHο\\+yi\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0@}/!]w\rыBE>C&S%F2%~r-[ehQlW߷ۍ*~ޒ5\"L.?Mq\'C.Ryr\r\\}Nd\nhRjÿ4تS5Vc+:֬,ڱ5dv_ff\Z\ZVN>8ݮMg2lgδi]1PVizL]5\09\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0,aƝ<\\\\	<B_9b\0GW:Bsr\"Y[ت*1*31\'0111111LL|LL|\0\0\0\0\0\0\0\0\0+Ʈ[۩;!yT4*bGqiuJ\'D6DLpmIo7ʈUPyY9OXbw2;0km\0ذjU̙&;꧕cEsf)RzUgV^k\r;ibؓ^\0MY(+hknf%tg\"{ڵL4L4uod0M@`\0W>3P-E6BSn5m֦ʢ5\"gv\\yj6*C\Z=e33E)\"GuMod?EH߅D_ݦci;yٱ%gUN\"٪ZZl}yR}2VҪ\0GClWȻwySig,?b=oYqX0`YY-umtXkf$0b2!É\r,VmmhJqiV\"ZE_cMXi&;=z[Δx.dxL~+\rwx2[uYff@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\"Z^63gC\"Kk2k	lN~V\"&dgqpf~,;\"޺/In(ovw1QXƵ\\zn\"5?kTg[a&(\0J~Zk,lJwիk\"9ncϭcc\'#^Y<N]KꢽwgHiϒYvcO-4fȔhZotZ:6\Zg.%bXv4	\\?Z[Kg\\VXΉR\\vW#:go	rZM5u%FɥJ\0$bEk7\\o4`1x&m\Z檨W{dq]ĕ)Oַ}Bn&Mx\0m&`GSV^=wmhUcSXUbBڏ)]\rs{貏32gl+b,_!5{_C5*JW-zۛk+@rCLҬ,f<v]/Jqmn\r#ʀ[UUG\0mˬ&evQU%eQbgUU\"\"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0aJ{:8gA#NϪQfOLfmiR-Z(56׵mj\"d	Ry)qqM_aCr\"L!bͅ)fA0Ėia]s_u{hCf]Ɛˏʳ\"kJNchc[RՄh3zX奟ݙiXN|>뮺\"\Z>N;miY5;K[ZNΪĽVeۛ&ֲ-[e;JlήPG_fDwŶj\0yJ-)R{{M:KQ-ʬE+ht!eYfYfabbf$0L|L|\0\0\0\0\0\0\0fPc<L.lۊJGS\\ҥ42?󊎦3m5rbuo8Jf5ձl[V\\}=\",+<wWbJjT}<WW*TJZәjW<f)ןZ¤Y3LǺ!|M}?DnMM3>~\"&{GwK@`V~qiAJ-i05rtG$wzʘ\ra\\XK\ZE{v|{\\\\L(44\rL,3\'jْIe6r#3-qƖ=8~nYd]2mk	%/Naoi9!s,&ɒzԳG++Be3+d*-)fzW_x	B_]VЫjc\\N5RieI@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0!-;)iAE{}%b!f㝑4f\\˭d[	UYk{6<mCasb_gr/~>%uJyF9_i×YTh[=ty+^j\Zefc=Yħsy6-wg]ޏR+>5Rg#2ۼQzj\\d4/H r)W_C3Ocj^߸f<I6nn\\f>7c:[jzr1NOb՜GS\\h]U\"CKk)jbw.L6mjTGYl23\r2$yk{if;eON}}1m6=hobt[5<g.=+fɆZ+*vέ7/ѓbkm[W\Z\ne;jȖR]U,׃N=4䶈^1s[\"!LN{stz+7?Ӗ]M>}9q[-¥ZB&+QjQ?¢*DD6:5ݷK͚5ZY16]{mywf\"9\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0+Z5uqz\\zu!%7.ONH]9j&S/&<ʈ2iG?\\O۬Ҕۭ8Hq\nRTyߩVNZo@F~;\0T^ݬex,FtŶSK_:>*E5SbQtf(Vy#4BTLm>وOkE\06@\0\0\0\0\0\01jڨrĺʑ]S;:bȍ*uv0S+#y_^W?{\Z6.B\r#lFvc9Dcy\0RI⾉W\0y~N9v8Ҙ矦6YygiuՒ\r???[*k}\0~	Һljښx--,f:!Wr\\sC1eu}i]ޚ0,331DD|AjZ뮵yDDXgfUU\rmU+\"4>EOgy;uTY[aL-6\"3Y98~Cz._4IM{vdRXLf\r*ʼe<)-9em\Zq,=2֎ufIa_,3#\\?=uʪԋ+WtIdևZl}:Uz#ǵdֶYwzӢ\'mϧJQnlYR(\0& \0\0\0\0\0\0\0\0\0\0\0\0\0\0GZ\\SŭoZ6t\nǜ6S5M|,c\ZWXAcl!ޑ4UyfMPe%VuSa}eZ-S{*}Ub-FSWJVZt/E0y*\'VnxWU61x]:Mۛxƿy]JSVjuo5pűRҷ`\\\nkkw=9:74znQWknf\0[A&fJQ[GG]q	G)~2V>\\j#-̅ط>&#c*ZarYzһ1\ZF\'-IugI[m: %Tvipv?*[둫b>쇢CG5͋gi^BۣG\rd}3Q	/\\u<zW7\nm/*tَz4y|讉]>6?K7C΢2zMzx4.hfKXVț2;}Eo2[\rϰy8\Z9 Da+UDUX\"8F\Z}\ZEO6]}m?xG3\0D \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0^Z2.nY͓ǣ>̛vvsUͻ֯M[kqer+ۏ\0Ơy+R{Χywy}yw?;\\m[[NۍZzhW:iRJ:@*N&lOZ:0}4ZD45e42 RM=n?ʬY3<ǈy!U/+ZTGO3>>,\0\032=slD*x`\0\r\0\0\0\0Z\0鿡V\0YVP7&O\0ZGs;5L\rqcoy\Zi/58#qwui]\\O=9ޕwgxeYEm9tgVHz^jnZ?n#=[\\qen,WhVh?Yy!uqHuSŶ-\n⒮\ng]]b<}\"zb\\,B%YzW.e6RR;)]]tk9̟cZ}(>M\\WC>)\\?+}\"Gt\Z\rZT)kZu=W6Ņ\\ju6<ef1&Vdk\0]\"=\rDL.f4^)mo,˽og\0,JWWfEF%w[r\'+]|N3]vS᯦˫\04@\0\0\0\0\0\0\0\0\0\0\0%<\n(Rf3[^K[m}IAS\0i>PsiUYf5n3T;+ΫfJ#PdA~r[~c2eVUoyeDTLtJCST{,HWbji)\\\r/*nў6./z>?T_\r(VŁtH.Ζ\\]j?|̇[ßieikbcVQTEu}we!\\b}~Ĉr$I׹D<ˍ\ZE[~#sD/ީj<_-\"~*HG9;En\\4*cktW7!md_	s\'USUy*aV\ZעB9KC5ѦěoIV.ٯx<Eoo1TV;3}2<!\ZiLwzF\0YIvUcE\\fFey׿&Ut\rRUW6O@\'^]I7JQ{43uXexffg#nJ\0;uꦟۦWsִOUUM}WZ$*D\0@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\";z,Z\ZKNGChyy\nm^eĩZu)6B\'xvɈhhVYbb~&&>&\'`LD1?\0Aj;-kSM.NAEtĉNJۯ.DRgrǐr%9u16ÛSH~,[cIaԩ}q*CHZz-8TY[֒ۿ\"sIl$*C[\0Ab-\rJ*#ϑS+W_\r1M3^MUxֱf\"꯮W2\\T~Չ+O+iD]yUc}M30SEq6\0-\0\0\0ZF=79|z[W6~O_273T]E\'(ǲu}޸OAZI6W-o8ONk7y\\*\\jLrg*qF:es돪-M$[)qYkS+ut9DmIx]MNʿeh6wr$d|\\[E:\ng?CJ_-MƉDӊn4ߝV5E._]<\'+ُQfy,ۙ}r}ؓ}6]~G]Yx\0\0\0\0\0\0\0:֮PSgeV٪L*Co;$8e}f~9!yhmIi}M?[>MGwp;PrEwIM+s^iظ6^ukK\r-n懔kyUb쪮ZM$N\ruO>Ek<N<\0Ws(v,>?yɳJdzrhz>%\nnKGggHu_[L]H[	/͔0Sߤ#^Pdj$;jFhpQtu2r&³P?\'8U[k99t֜^{MO.NgdYLTpjJ9.9WIF\rĉ\Z2̈́E5sb%}:_|Jf%!Kpg_|׃%^k\\EOzCg|ZBܞ^P׷>5WxLWk x?m/\\iwebyrFۆ3kJegXs^~CO\0,WUtWRB\"DD<DG-3̳LDr2?-3?&>5_k33HZYE)]5,H\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0iR;sOSޥJBsRu+B\0JB:rb&&&9@)];[hoige\",֥[\Ztz˻2c0m2ڙ}]xlT]x,uZk\rg>!ī\nth\"HGiL3!дil.MO$?/vPcS\r<{Ƈ-fYaqYuʱ|mỵ,di}i~SE\0C,j뿽~?G5VKPSrԴg~,vN?kE3-1>U_\0{%`\r<|ua^aoSO_o=7ߍWap`o>;䫰aB.ߥS޷aU«&L6ͬ>7z!mv7G%T̉ayI~ן)e,5KkWmdź=.\rGkf=mc]PthpQȞVDMUS)myZWz\rLYuh]gWa~OpfK6;s{in/E]Vl=-b{bME	Q>n[ysgJYX/=Kͣ\Z3yƲm1&5W<\ZL{QjqQ=gͽ9&],;n#4뻸iyAez..z<aeMe供_5U3Xùfզ^Psb-Wb~kUJ㪓IʄS#%]sSf[t*V_!5-g_\0w㋥V^V3,fl);w\\g^\\Mh>z*a)TZaUc\0i\0\0=.7kʖzCg\n_j3+e`x،yC̰B[}^nWPE:8pj3gm]~\\\Z2tSM|/.j[C$WZɄR,HmvzΖoڶh^vfw۱r#e]KJD.<z-z{2ں[p*iZN{0뫣;2l~ĭ<f]yϱ*WڎW~Tֳq-Mz82fBVձ0yiS(o\ZW.\ZWԿGc*vV>9y랈=Efr-[dW(V.\'\nō&-j.o.eW޾;]bz4̧hzIti_|d#m3[<LEV}Mx_nף-)E*l=yY:թ$jhtMtbG\Zx\rш/gh9z;7]2o=Eb\Z*+yDk,D2?,&V!ȽVoף[gVL^ˎތykixf\\3yY_\0$)\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0*MW7sUU\\԰TKH!,ee֗qRz13KySs泯#O\ndh@=yѥ-?]%zkj\'V%i7¡{1yy2^kU+AYE-C1;Y\r١Nj	>\"nIYV#f\"$$]d3R4=\\.q:a33Js϶omqRvLs6:},&3H!ߏ!/8O2}Sn-\nY\0\0\0\0UjUlӊm/ǝ\n\\g;Ʀ~by`WHJ_)q.09:3Ѯsi[Uu6=v*03.b5v*:ʲD,10Ej/,UJ*\n9>զIyĄئx/\";qFq:\0=t֖ξmv*U}md]nq=yxHz;WO*fDXD~O<k;ٜjOKDY?I2V_p]lo.6lac;R_mx{i#Tqx˪jz\0YzT\Z+;[tJ<|j3h\ruo^kھ:ڒ}QTEJ\"-hֳ: Wj+Gn)\"]lh8\"bŏb=\'!Mͳks]V}Щoݎ%+Vg3ZJ**>Wˋ6Fn&sEpܣM>\'Q\\GB]]$6iֺꅸ_FV021<Ӝc܇%W?C6f^Fx~\Z=^n}NM`nזQ_&\Z#K3б1=^Ҽke^*)ezli}޴haal׳-JLRծc.]7u0IL$\"Awf\\V|a_|y	NaU\0yCo9CKIU\0O;$%Iy;e|пWl	6KjFשq<z~嫲bC|g]wV_%|EjQ}ocl$9\nL簤ȅZYSF${dHKP\\E\Z+;伯uDtfR^(\':XDG_ow}/3r	?)	\0S͆O\"T;6n&S0hW5wcKjvgWU.WVYTKeDu;\\m3Yl\\ڪvѥVŞA3n9U9LZf,aۉ{Zӝ[XnY}uJ3uYdT*6ҔeXnKnj-m5VL♽#N]\Z<6[tF^ef鮪sU(u52fX=V󭴗y;խ<\'݅i~98U-T9Mg\"F_\nJ,cZ}1JjEB8e͚$nt>x4].ֳ9]ՇA\rQ`2]2J72eIȖ4\n->Ɗ9uJ/Gvj|\Zs?tDikOQl6<EVʴa٩vW͏j-Sv~~A}2`b#2q>+b4y=VxU	Ԑ3?,,cc=3;3KLɛ<+obiJϗ5	Vlhϗ-4MuMU֊\0@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\na>?ƦwUZ-,,]eߘVY\\H.^-Εf3/5wo6w..gM\\EA~lXWI<&lì\0)4eM^窂wӡ8)֛yy:˨[NnzΥhZ{ԭ\nR;oexӶy*b^;_oJj}/.oUoꅲbl^=}-޺ysjt.˼s94jgXg8;,::m-0o7Rd綗ӣ4</Lګ*J61&.u>o\nˊB2?mna5=M$CO-KGhUe\"=vKs\n\r=FY&b\Zyz\Z;BƈXYV}V򨎰֐\0Ymv*U}md]nq=yxHz;WO*fDXD~O<i>ñثǅVMmw;X=|oB!_oڏ1>K䩙ia<gǼ{82	svw.w*3m|b%}u|Jr+IEEXǼ{82	svw.w*3m|b%}u|Jr+IEEY:rھC9OkMUxḑ\'ˎԶam\'9ISd-X`xmo:s+?;/G{\r{v7!_3ҕJ6[lDJ[qM=4$ZԕY]隬-Sb+33KS+r]sSrY\n216lm4R>ȏ}閄}-Hi3Vϡ]a{E>io\"c^\\̖zΑZG=Ke[|h6~V3FӲ9kXlA]/-QVXMnSwkݽm}&n쫥^£=\\tdVKqqD6-{caNhyZw,y0\0=,#F1̯&봐Sfr\r b5I/K㺪M	l]]O%KEQ4-{(ù.1ϣ1[]dRK]4fǷY~Myn_z4ۏ=:TJ$vFS\"y\n픫\nU]ʘBb=k=VN֟즹cUUPʵH:U&;P\"§%eρFQ꣮@>dyԿua͟sGRir50aI1EMu_Tk\r&4BhOubT\'W\0KQS+Wv̱嶉mެe|:k\"-)YzZ(?1x/9~q#zo_)SU}P>CryNw-&眃ybk[mEj,쾇_4zG\0?r_`[X;	Bǧb);y)2!e=e\0ѻ.yY?R-3%/2&ֆ5֭7\ZkSm,ZZWTMULT\'z^m[k[s*w姂%Yl#]4gbƺ/U)62aϟ2=5ԼXR\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0ʷih2(WڻMurjɋ*R}:;}9ޞ3*,4*s,fxeEvTEYaUcLDɟUe~9Uc阧nus4\nkOr2(MQLHguMԨչ,d˲垇S㕐Wh3t9MMT%CK\"$a!Ԧ?S\"f{}bf\0ڝbf{|GY#Mū[7R*v䲁QexNֹW]=q_n%+ѽP?R#qv\"q91R*v4s~WC+=b},^2q.-Z|D>LLnq5G\rgBrǟYWjGlӎ\Z7Oܘr[>٦ZS{T(bw\rqm[YWhR}2rd:<龳\Z*nr>&US[AJ-V\\jl/8ոזg?^\0>=cO]d_nf\'83gHLts?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\00z\\ogEggyqաų*|~nuQoBOy**1LL|LOĜ#2ʲC++GJL?Hn1Ol?o*%îM-l5]g6gi#}U9r9.Tlzfoǯh_!ncYfg\\*M~E::%t9<p;vNY}}}>ñثǅVMmw;X=|oB!_oڏ1>K䩙ia<7W^`wRv\Z&ϤXqZzT\"ϓd4t{2J[9~yx!{xVX굫ҫ6DQٕҴeS+Lv:v7̰jWRlXٕO=rr\\9]vK;;E\\hw\nr\\1%fs9YIVƻ0s3XeeY\rvt:HLϔZKUWiYm4)NAr_E[[oOe;QXZʲc+MYKt\"ɇZlw%#\'j*TD_\r)7kaָg͌K޵A.!6BQES+e/ϋhDU_n|oulџܺd6ʤTٰ˰\Z:tڋ8-2}m4vP}塦ZBqiB{|I:SQw|iꞻͣLyOz~FzouZ_?=sQ_EIS:q[}zJ6koMǗd2ٟ<OA&$=f. ʷۣf?]UHkl?SIme\Z?AG%)u\\A\ry\0SC|OWo\rfⅧfЖi6ۨm%2]SȗޙbjTeO[ly}\0Hc漇ӏ5{w{It/h\0|+.Vxrxg>8SV;>->]΁-6nM6<uj؏:ut*Us0l(\"uuzody$\rJ9y,Niǣ89pXFv}<KeԘ\'⸗Xy+iIJť\\>HJZYǻ1l_x&?))JK)Ss^b)|^U-gjU?PYmU\Zsٝj~&ysџ6nlß3FluQeVelK4]e,\nO/yI>O螓1\0%=Kf|۽W:u\\We<6--yC7Y,y>\0[F&\\nZƱv Cl7!bk{+y v|:/~7~\'Io}%ƅ.URvYF p\Zff^co{|hU:/?)r7Z-f][~e%):P3&,7*+leS:2;V9Kǲ{R[jW-EjHY8nlM_e|Z=4N4m[,ȫM0\\-:rŵYG鉿>|K):i_M>󟑟>z4^BX_ٴöZ\r\rȝE~f_4zG\0?r_`[X;	Bǧb);y)2!e=e\0ѻ.yY?R-?Z}_M/C*Rmhaܳ]jq(f1qiUܱ?5qIUYeBy	\0\0\0\0\0\0\0\0.SĄ!R+LX˒壊Lx=)1u:ZWF3ޛd	\Z/N啃UO^β&Hq\"KmԨ?ou5[]s0*̪/gn\ZbxE\n3٢驥],ek^4C4Li~昏??hU]c}A* x]n=k_\0y}m-0/䣓b2]c!;{bڎz=;fMǑ£͢)tOgPY2j$ލW>gUWxϥ,;$ϥ_enf&f\"bf?<n39DD[34%0!f\Zfbfe\Z^/Uٴ&4zޟٓ7qi!0kwkvOa̳\\v\'%Q\\1k^_Y:DRfL\\WcJ׫<5vߧZW7=rܦ￟8\\JG<jy<*23̴,3GSyǲ\'%#?6yn&geHf[9TH۶Z ]6(2b<XعDZw{+i*JVmץqS4vkUa,\0iu̮<˰8lʏe=/egZG\r,:&^fUY42LzgEW$S/T4OK8y<mϪyE=u*k=bd[(ή>]QbO!B}ʊ˲iƛZ_Q[acϲkYm*c]Z^	L钨,~Oyv:w)\\>Z7Rj*3f+\rs7Fc\\XaSm%/ME_e\0?9x\0gCcq񚟇{[\\\0\'o3y75e|~FCe[*\\)kUUPd$!	};w};ɜ/7[jj9]i#=^\'܏AEq5\'Zݱ@|􈉮j03eG[8Ud_7\"S}D?OXiZ}ٿp5ޱpsQbWs<řunX.\ZQˁV\nndu7\Z}<w<WvMGvyT)kZydwn;Hr4R+|z\Zcӡ׆j[lY_u?\'\",תVZe~&lE|/K?$1r\ne{٧h^{^Q_e[O;\Zlc{RYz/YGbGdU{YGCT(W$q}\"\ZKkCcuH=jcp}/jㅞc/c^!~bg2<EtX=,8\"Ɔx{S/um@LL٦-Fº;LYԶ3?#!{%Y\Z),4;/ècԵn9$NZƁ[]\Z+\\_74%~(_x̜Jgf\"V%jxY-LG2dVk͝%VUe)eV[ʬptq39`\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0~;]<|xUdiYsۜG=^D-J,6~)/ԭ\0T;/[J*M5Gz7z7Bh:/w˛\'X9ۚRe7zJdln\0g?|yaz\nw[/Hμn}nL:kOFȹkHy|&>:.yoj1T\\hmMb!ZUq[leUҵLG|^m\"ۭӇ_lSM\\U4U]醴biy-\",W⻖vBdXXjv{=MmKNi=д5WFeSfus<fC=*|Ζq=}RCT\0m弊6	}1>{T$)y^QDoy]Y@f-]},p3[XԚ۴:ſ_[s%)BR%(BSĥ)<%)O>ys9ss,bec-\\+f^;YU4g	,j_QdtK_n;2n/	bדvKY6޴>[ +Jy0}29*o8Vg=sVfW-Ŵ&QaF`\ZI6ܴdTCA˃=?e,itrelM5،\\goss}G=\rU\rkj\\W}w\\1*m8Nsck_\0+3f^*	kuKL-^e-v^弶/\rFg*&\Z3d\'4]5l+\r9f(ЙLhjrϙrE5j-*,RqY5&6+m`<Dh\\+|ϽvN?S}NΆ%)LTiP*ޟZScĴl*::%לGx4?5^k3\"¹We9QEY>\'oAUjj̧jUz[km]5[4mv\"x5b\\kyOBl1f_j|VCv{keU+\\kB5jYu_vkt%+yGVׯJoǯ:e_=ov۵*ccMv>XqpOY1~ͰQz,tWW~ߑpR+נ5SWk>ڲz>%i|O~I^l2	^ehbidS+	R3Kw;SuwT#|/gc\\а,!O+^gWT+eS>ei.&8`xs!H{?=^(֙OVsǞNU)b[a&HmI|xv,8eo׷W{Spb{nE1,n+2=;-ɟŔypTEV#kGimؖX_Jө<{7g>&B:zZi23q?!\0f\\_.*..RrUdȰy!fIe|*#[rrSa\r3T\'5efJrs6,uRڼB]qѾ-{YGȴ\rC,gSUg}v\r+{ӵ?\'\"aǻ)݉=}`hVT-u&asi8}\"ލ%htSYQJeIʶmۍ2kɝ<W%Ï|ifuiֵ4-YjWEQ5Ӓ~l˛2L9M?S]Skҭ]i_Z,P5BZXUv.\ZRu2_ibȓShL&ǐߒyg/id2c>dnXUǫoScQcc*z*HHa\"?Ǭ֧r-+Ӹ\0E-;_%cüOS˳%L)ORs3\0v$K.7)VSy1O-?Wc%rMů5gB:ۡhѝUnN)/Jnzm1E5w6x+/m6<Mˎᖸje2/_]im>Zn>>e!|ni-CV9ZTL{N%W\0ȟG`9e^xO/Ю}݂sP϶p+Uȍ_?/Cm\nӓT3KK\"KQKf>7G^]07֎6L5;飥dgd]_U_M+}7;kfIruMƼ[KV\'r֪U&EUgS/	\'G}DvE=f#vyn\r\nvkvL̫Zb\"I<HTI^gq^mȴ˨{ϗ?ٻ|xi/Q[Uy9=V*<:lñd:KiŕjgMI#Yo`sja![5H0?\nqhzX1>Tehlg\rǞ>햫ʬO\\47ij:an\Z+Nؤk)4SFI2x˿y]\\>kZ${\"[KwGs.6ڂCv?\0뽶CZڗJimrN\\+t:̵<ﶸx^r)<L<OJ3/nk\Z\'n\",YXJeyuhs&YPC]ӥmpފϯC_~9WGȪqGCܶfKk{g/4VUҳ5fk1&XW4֐o/#:K:Պݽ棲[@3OҖLĵyV%ib&9}Y+z_P1+\recYh=_o+ynH.^79[*\\^:T$z_6<Ky٪rK/ZZU`\0J\\4V.Њб2O]U\rV4EhghXYZy9\0;;\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0CiW5^us:\nXh5Dh*3	n,IrWYj#Őlk<*д?^UFn͹;]-<ٿљOs?]O.?V]F\nI]7&;]>=6\'X2yWdnkUvc3i)r:OTZVho̭+뱙Z#M6>W핎7oʳ.\\+JwjTfɢ57ZZfkGvƯKqukMP9cYKb.S/˳:Usab2Cj;o_CQy&5\Zɶ/4-ùq{K[YoQR?@_uJoAHcm-\03ktR\"DiyMj5rf~DdzM3#.iբ(Pį\Z&\Z8!\"Fa\r4vPXa!ZBm	Byq.yQ͋g_}ͪ|JehTʯO)]^;,{<-%U芳;/W\\ZͿ窝\ZYx폩^w[\r7{ԌWVKom-/m\Z]C_.Dܴm:>)9|s-GNKn\\4[e=*\ZS[u.GVpSpkJ]fk-74:z\Z[&{\Zƞ[JRTk4ILIJTHd݉>_6[GS7w#ô|\Z+\\ձ#7~>µCDhkU++}TtEkňOi<kt\\zeJdŋ\"ny̙=7NT=e3/ZB;]mQ}*R줱?uuig}n53USm`3<Vk1\"\';v}6JyuZ=tTX.1yd5Ϊ^S{g]!jEblPߕuo}Yyd]:^X#\'ԥ]\'ڵK+qg^]3v㟲ϲD+\nxmʑ]Ņ(TSa\\ )O@癛Whu5̬Yh>2S37ޯj;$p+I^\r+-1<y59?jF?S\nlԼĈѶz42p9Oymɼ[T30~K-Y`氹8:Ȕɓ~Y_Vv(Tu?!]F\rC?k\nSb}-7886{MeiZf1__[~D~b骳g:46ѯ;L7sMI5tY\Z_eC\Z^y?[Nj\"%LgG=-4-7X4B*N١[kv8,23[N\Z^==-{&%vv\Z>5^rSQRsRU5#%jZ8Qَ+)J׽P88n%+BЮ)B%hR{ԩ*Oyԫ;yӑ}UUUUaUbUb!Ub8X\"\"\"\"\"\"8}_}]u=]km/eX.;̳L44+{O\'Y!n;<;rV-u;HbU*!6vg%+\\fKW_^툋^a*}LO`eU]֖Bذ\rĞQט2L\Zqe;؞ޚ4\0<ʟm-Vmi|\rF͸hifb}m]Ňc\Z_KmG[2QAk;[ZVEq,KWrq\\{+%&ږ9ڟ=.P35pS`h49+nt-Y*-=}~צGB\"Sr_7h/\\7=xv+OM5Fklem-eKi+ԍeuESZި%Wکo*nca=3[J%ɖk9	띀(Rގ]5|F)OƏm\r7O~Ujf\\rzuf]mR_0#DwnBfDݽQ]mD$Y%Glv&BėKIz4YRّC+C>ӭ-.6%\\nh7Q=5VZR,Tū[TGͯ=ftcuVYNemaYzծWUyYӛiv^Uj!^SI-⾅ؓ\\9M22zt#ίD)ؔí#T\0Jl~\0!%A\0\'_ͤ\\Vho>D_+6Num}nL]6ulLۑc&5v\rl)D\\(-:\n)mĮ®+\0cEA]M-/CWdړ.{]n\\NAS<D]%ubc5>XJSrV{<ӣE鉭j[]U3V/HHSǊiߔnd]/}q~L)60Yiה3\\☸i`4XRhe<؆8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0VzK-}R޿!s֒7ë9bgޢ4tz\0au3ALbVWSUY5__+If,80hc24v\ZmZB[m	Jy{A\ry꩙f]clķnY+\\7?+uUQ}ʹ5cF|8ŭiŊg]&գk@\0\0\0\0\0)2WʅG	Ry]V2..g:q*(HY(kܕ\'Ǜ_09o.Q`\\DEWlMeU}ͦtkTk*4\0XyR/7r-J[qqS.L4\n<ҮWfCk-5H{г0fh3h[۸\\4CC[[u_1)m\'1=\rL</okukuVVKqx$_~]t{|޹VxM8<і*x>f*T쇘F)Vv?4o7	݇|eۈ~c#CkB>9B|U큗9yזrq/oSD~=ś~ܩjZV櫪g|&/+ĝ_\0qnW7>,IY=%Vvs䎖#ʿ65oaELFkTG~/%@0~2ʅW/ٱح%A2_^i$Qmjuu\0ύcS7=֚,vV*6ibZ-|j39?s\\C]B$Qu[ުƟYi=|\0\\)m\ZK+siھ=5;/f>Wmӵoj;(}c3<yM\r.d\\W]ZsW~Ys+k]|қ}tilJ\r\0Lzt/q+̾v~RxVufbQbw\0-<u|>^ui0F̴s4k)\rt7;\"v7W~%[FșW6	ZW,W9S\n_5jZKjBcYco~ͪԞ[\'8vO̬^mu\Z*.7dKia5M5̗ťokQm/0~rk8xxFjXV+bs(v!hŞb&ޫR%+Kk(:ncz/QWvSd3zjc,˵EcqMK{ő+;\Z;H/16RGOCO]TSm0mz*ć-˝q^=<9~gfV\\a+fܖRmsyzoYذq+&\"EhR*~ڦ3^\'U:XE_מ6R}n+Y\0DmѽM:+1U\Zegfj[3Mufd~~Wo5^/>ieڗLk[j6TRW	5=k)SS{{%u6\'|&\ZKoS_sUr+gh~܉;ߐ7V<߾wu{\0]Ə,om+cy6	\rԔȬS+u4?,=fn-.CG\\ϭfnYR1CJƟN\"ƯMUk]bEu}ZMޤߖ*]U6ub#USYMЬҽe=К(.Ь7S*+Ii/hUx>z*؎e\0\r\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0D.[ŋdI!1<v^}R[e[Ju6kWGRhn]\\]=y1#NmrTy.1s~uq2mǕu(Y9Q!o:}RJkTW-b˝+~\"M/ϕԣsx4[lJZVIey?4h;\ZM}+22Rb;Ij:;Ǝdg!{fJP	J)Jyĥ)O>JSϧ8s9s>\0G5E5%|J42-c33˻33?2G䶷ۣc\"Զ4|Ԣї2EiZt͚I^V2\0\0\0UG\'{>MJ08x]aَ*\"\0?c\0伆Rm;Kd_W==UafZ7+9%.-O=2qβRxNUZcZII,LE12[D#5Y\'C~Zc~b\"c\0gn9X\r2<Uu.`[X2-!ǰ˅-IeN}<W\0k+ޙ75-\'\".oubeF弉!(y!!Iη4ol/gy]%\'ncyi_@j5;mU/+juu^\0΍I;ϡmӨC:6n%+m֞hZΥhZ{ԩ*R;ΔwdmsoWɯ{>ktewJbUoUMWGeNK*TG<W,K[#JDegt5+g:|{@!Yq-<J;z֗\rHJIMkyIMǥT4qΆ2ފ֞$:O~\nΦ2$FH[e.ǫ]4\"ҲZ^FT[[z̕f߫e̎\\6N^oH0P|[kң}Xf,l]oV.M}u]]z2lYjEPWڞΒ̞Rne][5/lk;JNz^Am귵[V@T9E5.3uwḙr%0;g/!;soO.%ElXthehYg\0+-EWG1*?L\'~@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0QW׻]΂3M;P6&$Vj:FfEe<䖭c3|R=%DaY֙ڝ_Xvdmr5SSz$GcY:L2l9U6lzZMqs,?$OqRy\0Ε_t\\LP8tEo_2\0w3کeh]и|&ͬ<q{3-N|gٛWNF<7WJ5mt\0Z0@\0\0\0\0rhFK9^o7q*_cO\\J엟m訏4#Ss͝2\\gҦɾv?7rծOW;J:.?}w;ȫD\n\0Mst-˭.,JSQu٫;+VA>ӘTa1)	μ\"LJpN\0\0\0\0LG~$S.ƕKH~<M<캕6/66N%Hq\nRaܝ5X1jj~;dP?UV]o:;|r=Kulb\\O,0ʮt	މ6[\\Y\raԭyZq*BЮ\\;u=ZhnyTɪ=]b-UVZ־*ʻJ؜-DT*곈ж,wEza=Btmʣނ7غ6?iSXHeƗ3?q\\]rſ	磹޳A$y+;F\0\']qXZʿUV2R5**DMf3T:P-[3*F{g\"Ʋk/AnS>LLĎGfOeH];2NڹH[Nkg&^,Ǻ1Mv]MQ]WlCUmo9KH}JLK֑1FƊvJD1Ѣذ/b}.M#C=|n\"P.Qxʢgm#_Щ:*xqHGU6 ^*=&RGfftMˣr|}\r=E{s\0Wi1ܒ-\r,\0HZcyK/G͇MGkl!idH\'o4rzK~g\nlrm1yl*4/h#Mo5KqUm4Kԫ/rD[LDjNgƮ]DMQ\r.e(eD g9tz:-=l{\nz,ZrcdIՅdƝa	n&L9-Ėu\nG3ehVVabbb\0,+:2D,+D&\Z&bb\0N\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0-\0Ջ&WZuF\0Ǟ-_u+oy:>g\0\'̪2G33|G3̕\"Snmu.VLF5\'L3~P~;W	,=_T/d$@1F&n\0]$hڦuv	ʶ_\ZɌLb]8쉷5Sș%U=*YMCԴرdDS]Ȳ:ӝYy#ozs|m|cy\r?MSN+>_5kUiU{_Yц\0\0\0\0\0ڱ\\i.th檡8۪=Y-uS-,<{HCG]ֺlC׷u爘d?K:#ưrqĩjl7:\"]WXKV_f?x9Sy)xYqW5}\\zמ?]<qb{sNg~W\0,\0\0\0\0\0\0\0u_eRqRzujC[y[yӈZRAiIɮ+s&eL. 3\ZT\Z|ىa~zimFb_%Dn|y&d>7+fS[I/\0<)ѣM#KĖTmi-=zնmk5YuhϢDi)ѩ;]Mv#hͦkf#K#::+DOh^d5-2>uSkT;1rܸqW\rj~\"\"F]dvJKI0&ɩ6SwP]F{xznH^eoe\Z*jSuUdZЬ%ѣseGY[+gڷ\Z93LunD\'9mAKy?<Ǘ:,ڥIԙ\0f.\ZoQ<l3Aylu5iܜ9_Ʒ~Mmk~xg&\'S23>~[30GKY-Yb,s1?35k5n4LYj2D\\;KMQ^\\j̿>K3yf;Gf˱ÕZÌGl/kgq3B¹5_ؿֵ7*kfLya\rzN1S_ӪLI~bD\"k-~ŊKxswh4\"q6W&>-UIolcMd9K-ŕߍ&3$G}-yƝmJmԕ]Oy?LLsOL~&?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0)IIyd\0ӕZoVn2m*cj7~vi窵Qca6+\"4^z4Ul.ΰ=d??LyOv-[JVCjub3PxƎr?T_ӈne4\\1d,\0E	Mm5^?FiO\ZŽ.z1y%Uٳ]rRb{ݞ\0\0\0\0\0\0\0\0Ff]n/g43iwL/⺴vZ\\PֵrTd=&K~Ky4R4$OPqVVRBqb=nj麬Gԗh74Sgmui5#qfa\r<=ҽ-laߺGtcO10\0\'\0\0\0\0\0\0\0\0\017u\Zk,[8i]r4S#8LaH7&7\"4Kc-dSHkɕYjo=GwI9yG0wuyc%nrN`T1uOֿ&dԿ_mZlR3T+jǝiQ2ܘ`k@:Tr3lKb#\\y:GEU_|ݞՕY.>VTG#O~U_N+Y\Z89C4s+lCפBE|MUofn8%BIm]nFښmIgCwlVfVzԵey̏)bOWFeh~f\'bef&G%+JhZz\\⒤⒤⒮w;y}@HUw5puX~;!Bvί*)\\1fϜ.#|יlcUuGz0l^1aSiGM+~53B\0\0>)_>:Obmخ:]&Ί<U鮫\\SÑ_iUi=m	m)pgfC̈\ZqZq\nBך%&[;s3cMS=,h1CY̶[=<ͯ4Cg\"cQɌJb,{Nڼ&SW\0J4-~u6\\dtDǩk3g/cu(&WDN1c$ƭahgi]_ArM.\n\rU+1U\nVVhrzbk\';$+SklOeD(FerY`r\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0O\'!\'=UάVڮ|H3cYD1>\0UG\\d*]<61*vIMŤz	m|3Q}{Wlܗ\0%c1WYKmH;\"٦.Bylg4QTE5kX=3KU]2\Z&q&ivׯS5[.o_j(JwiGP\0-\0\0\0\0\0\0\0c뛕df\Zd2v2ј*Kq\\ݏe>duM$YtK\nnb$%&dKfC+iJ\0wf#ҷnZkWb手ffA{fм+vᥡg8iOye>W=Z69fIJL܆9\'Jw]mimm]#GZ9Vbc\0eheYZ!c11O\0\0\0\0\0\0\0\0\0\0sZZcL#-kf}ؔ˭:Df?nc+9j!T#q]S\n	iNzZF%Ou*K}]T	O2efҝf{\rb-4W\"*Z޲uL\"<?6bk&$91gк+ݎaJuf׫$<ؕSflسUdKj׊ڦ%!,FeQ<_nNfkyV߈e#Y8-E{oH͔[$5˗	HH~2$ʛbρ<Qjמ4=w\"[E9zW}$uuU؊Wbڋbv\rsãº<~abU&&\0\0=.g9ioAqMgC}m2!k۩C쯈uO8%\\UehVVVebb~&&>&\'cNYUՑ]eYZ!VY%f&bbbbbxzwEo(*$\\m=m)ʏ\"\\oKտT\"3Kӷ:fV756xh)iRf/\"M9^4.#sMDnr5&{ŐSsEWq,|ُ6$wS.]\\wT2+6b\"C1;xZYժ\"DSu?r)Vgfyd-_ՖSyYW-ec\\\\zM|cg|*vQJokksSQz5\\_IY&|Ck/?1ٿb#:Dh-NLN7iE!|fi9W{]1d|LL]VBLVʼKLץ^bb9%\ZztsMة3% r\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0.^\'\rVK\\Tr73Ic;/odԦc,ɮ\rnh,WzTyRXif[iIn<q?Yn|2_,nN-ӉzfzG+_W6\Z+Vm;>7ϱX:xRkyvOWTLj-iɕ>Ld^.nL8~TzW$\0kD\"U#\n\n\Zt]Fz,ktjYu5?23\0\0\0\0\0\0\06ۭPZu\nmJVۍ=Jд+JдRUΥIyw9Ɉ&\'&\'HHvf-=+!	a:HϭǠGua<%^_vɏ&Vnl٨JZRMnxc&[Z$vXYn9999\0 \0\0\0\0\0\0\0\0\0\0\0GuK]7TWŦڳ6s)m?GfAl\nXf֪dn{JEk]9꛺y3lbKmǶLiv9ƦˎÛP\"IAF1N%c\nw_4碍vY:̱鶧j[bL$<ܐҴK\Z,+TafV\0/\0\0\0\0\0\"7,f3f,xd/m7?\'r7g_ըƺR BG Fcrȏ]Uוʴ2D2\Z\"c K/*]a4:7\r,2DLq1Q+M[{%bJPzkݔnm,#?d=vE--LΖaE_$:_cQ9cHzV5 \\TZWN&MVv\Z\\wFtSU1c5PB[/mݦ{{Ǝ&bV]b%Z*jfmwb+^aCM5ZVVd\'GHVW\0	\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','vsantos',51,'Morley',NULL,NULL,NULL),(302,'linethickness 0.3\r\nfontsize 12\r\n\r\n%Definio de dois pontos\r\n\r\npoint A 20 20\r\npoint B 60 60\r\n\r\ncolor 255 0 0 \r\ncmark_lb A\r\n\r\ncolor 0 0 0\r\n\r\ncmark_t B\r\n\r\n%Definio de recta \r\nline ab A B\r\n\r\n%Definio de ponto mdio\r\nmidpoint ab A B\r\n\r\ncmark_t O\r\n\r\n%Definio de circunferncia centro O e raio A\r\ncircle o O A\r\n\r\ndrawcircle o\r\n\r\ndrawdashsegment A B\r\n\r\n\r\n%Definio de circunferncia de centro B e raio O\r\ncircle o1 B O\r\n\r\ndrawdashcircle o1\r\n\r\n%Definio de pontos de interseco das circunferncias \r\nintersec2 C D o o1\r\n\r\ncolor 255 0 0 \r\ncmark_rb C\r\ncmark_lt D',3,NULL,'pedro',1,'tesyte',NULL,NULL,NULL);
/*!40000 ALTER TABLE `codeTmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `codeTmpProver`
--

DROP TABLE IF EXISTS `codeTmpProver`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `codeTmpProver` (
  `codeTmpId` int(11) NOT NULL auto_increment,
  `code` text,
  `proverId` int(11) NOT NULL default '0',
  `proof` mediumblob COMMENT 'para guardar o ficheiro pdf',
  `proofResults` text COMMENT 'para guardar os resultados da prova como uma tabela HTML',
  `username` varchar(16) default '',
  `userId` int(11) NOT NULL,
  `name` varchar(10) NOT NULL default 'temporary',
  PRIMARY KEY  (`codeTmpId`),
  KEY `relCodeTmpProver` (`proverId`),
  KEY `relCodeTmpProverUsers` (`userId`),
  CONSTRAINT `relCodeTmpProver` FOREIGN KEY (`proverId`) REFERENCES `provers` (`proverId`),
  CONSTRAINT `relCodeTmpProverUsers` FOREIGN KEY (`userId`) REFERENCES `users` (`userId`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `codeTmpProver`
--

LOCK TABLES `codeTmpProver` WRITE;
/*!40000 ALTER TABLE `codeTmpProver` DISABLE KEYS */;
/*!40000 ALTER TABLE `codeTmpProver` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `computer`
--

DROP TABLE IF EXISTS `computer`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `computer` (
  `computerId` int(11) NOT NULL auto_increment,
  `CPUBrand` varchar(30) NOT NULL default '',
  `CPUType` varchar(30) NOT NULL default '',
  `speed` float NOT NULL default '0',
  `RAM` float NOT NULL default '0',
  PRIMARY KEY  (`computerId`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COMMENT='Computer Specification';
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `computer`
--

LOCK TABLES `computer` WRITE;
/*!40000 ALTER TABLE `computer` DISABLE KEYS */;
INSERT INTO `computer` VALUES (1,'Intel(R)','Pentium(R) 4',3,2);
/*!40000 ALTER TABLE `computer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `demonstrations`
--

DROP TABLE IF EXISTS `demonstrations`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `demonstrations` (
  `demId` int(11) NOT NULL auto_increment,
  `code` mediumtext NOT NULL,
  `codeXML` mediumtext NOT NULL,
  `dateSubmission` date NOT NULL default '0000-00-00',
  `proverId` int(11) NOT NULL default '0',
  `userId` int(11) NOT NULL default '0',
  `teoId` varchar(10) NOT NULL default '0',
  `proof` mediumblob,
  `status` varchar(60) NOT NULL default 'Not proved',
  `proofXML` mediumblob COMMENT 'Código XML bzipado',
  PRIMARY KEY  (`demId`),
  KEY `relDmsPrv` (`proverId`),
  KEY `relDmsUsr` (`userId`),
  KEY `relDmsTeo` (`teoId`),
  CONSTRAINT `relDmsPrv` FOREIGN KEY (`proverId`) REFERENCES `provers` (`proverId`),
  CONSTRAINT `relDmsTeo` FOREIGN KEY (`teoId`) REFERENCES `theorems` (`teoId`),
  CONSTRAINT `relDmsUsr` FOREIGN KEY (`userId`) REFERENCES `users` (`userId`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `demonstrations`
--

LOCK TABLES `demonstrations` WRITE;
/*!40000 ALTER TABLE `demonstrations` DISABLE KEYS */;
INSERT INTO `demonstrations` VALUES (7,'point A 60 10\r\npoint B 30 90\r\npoint C 80 90\r\npoint P 55 75\r\n\r\nline a B C\r\nline b A C\r\nline c A B\r\n\r\nline pa P A\r\nline pb P B\r\nline pc P C\r\n\r\nintersec D a pa\r\nintersec E b pb\r\nintersec F c pc\r\n\r\ndrawsegment A B\r\ndrawsegment A C\r\ndrawsegment B C\r\n\r\ndrawsegment A D\r\ndrawsegment B E\r\ndrawsegment C F\r\n\r\ncmark_b A\r\ncmark_t B\r\ncmark_t C\r\ncmark_t D\r\ncmark_lt F\r\ncmark_rt E\r\ncmark_t P\r\n\r\nprove { equal { mult { mult { sratio A F F B } { sratio B D D C } } { sratio C E E A } } 1 }','<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE figure SYSTEM \"GeoCons.dtd\">\n<?xml-stylesheet href=\"GeoConsNL.xsl\" type=\"text/xsl\"?>\n\n<figure>\n	<define>\n		<fixed_point x=\"60.000000\" y=\"10.000000\">A</fixed_point>\n		<fixed_point x=\"30.000000\" y=\"90.000000\">B</fixed_point>\n		<fixed_point x=\"80.000000\" y=\"90.000000\">C</fixed_point>\n		<fixed_point x=\"55.000000\" y=\"75.000000\">P</fixed_point>\n	</define>\n\n	<construct>\n		<ruler><new_line>a</new_line><point>B</point><point>C</point></ruler>\n		<ruler><new_line>b</new_line><point>A</point><point>C</point></ruler>\n		<ruler><new_line>c</new_line><point>A</point><point>B</point></ruler>\n		<ruler><new_line>pa</new_line><point>P</point><point>A</point></ruler>\n		<ruler><new_line>pb</new_line><point>P</point><point>B</point></ruler>\n		<ruler><new_line>pc</new_line><point>P</point><point>C</point></ruler>\n		<intersection><new_point>D</new_point><line>a</line><line>pa</line></intersection>\n		<intersection><new_point>E</new_point><line>b</line><line>pb</line></intersection>\n		<intersection><new_point>F</new_point><line>c</line><line>pc</line></intersection>\n	</construct>\n\n	<draw>\n		<segment><point>A</point><point>B</point></segment>\n		<segment><point>A</point><point>C</point></segment>\n		<segment><point>B</point><point>C</point></segment>\n		<segment><point>A</point><point>D</point></segment>\n		<segment><point>B</point><point>E</point></segment>\n		<segment><point>C</point><point>F</point></segment>\n	</draw>\n\n	<labels>\n		<point_label direction=\"270\"><point>A</point></point_label>\n		<point_label direction=\"90\"><point>B</point></point_label>\n		<point_label direction=\"90\"><point>C</point></point_label>\n		<point_label direction=\"90\"><point>D</point></point_label>\n		<point_label direction=\"135\"><point>F</point></point_label>\n		<point_label direction=\"45\"><point>E</point></point_label>\n		<point_label direction=\"90\"><point>P</point></point_label>\n	</labels>\n\n	<conjecture>\n		<prove proof_level=\"1\" proof_limit=\"10000\">\n			<equality>\n				<expression>\n					<mult>\n						<expression>\n							<mult>\n								<expression>\n									<segment_ratio><segment><point>A</point><point>F</point></segment><segment><point>F</point><point>B</point></segment></segment_ratio>\n								</expression>\n								<expression>\n									<segment_ratio><segment><point>B</point><point>D</point></segment><segment><point>D</point><point>C</point></segment></segment_ratio>\n								</expression>\n							</mult>\n						</expression>\n						<expression>\n							<segment_ratio><segment><point>C</point><point>E</point></segment><segment><point>E</point><point>A</point></segment></segment_ratio>\n						</expression>\n					</mult>\n				</expression>\n				<expression>\n					<number>1.000000</number>\n				</expression>\n			</equality>\n		</prove>\n	</conjecture>\n\n</figure>','2006-04-04',2,1,'GEO0001','%PDF-1.4\n%쏢\n5 0 obj\n<</Length 6 0 R/Filter /FlateDecode>>\nstream\nx[IjvA\",dMBLYKfMtը\"LQS{B5~x7.mTݛGv_7W s&4?OFi)WvP\"m\nq_aBF+|n,	b؍4H\'d،F{{HH2<ړ7vdTsO+/cx\n9A\rc& p{hwѷWw_ǣͽGE%גZX(JB{{=vI%\0^	ևYzmxepG{ĖV e{+xdC+Ym`NCZ7ѳ&г;Rmz~#;Hi\rz|0Q{a6>}2F+*\n`.\nǩq\n=5t Jp6xlucXRHlnL\r741_0$@7ZI$LO{:4xҐn?/c	mm^<xվ k(RF%Ю]^\'+\nk;Nt*jI{\0ctzLFvnrxyeKy|]n^sJ<sJgƺ)U0@ͳIO;?z>D)@k0lY\0Q]Bo6\"V&\re\n:%B,d9fNZϔHj31τH]QV㗑=ݽGӯu7\n`RIId\\l_`nq {שgȃ~<ZO!{=6y8mIf;8sQSVs*1\0M8x▽\"K}^C LN\ZɗLUZ\\*sl,O>5ؙ`Fu^\rʺym=Ak/r٠hl2d\"D8W?΀aR\nc6#=U{&AQɈȑf83iHɌ\r4T.0c/^-#{5кE:ٍy\ZR.t[Wi8yN`Uׁpڡ;)\Z =UzHxȡ\'jH(M{$ERPanى7z2pciN!;bk.\'+3PJcBC8aw ^٤y;2	{J5&L9J0)mUKˊP\r,tm{.b^=\"ںFO\'ϩz5b\ZBUL\\?ee`_n&~yoZ	oUv5G\\.v5GիC9z^>LCQu)4Lѡd9\r,6):j#?9z\',ZB$m}ɑ&~h<zqCHUXE<%[:mHJ.Tz+y[!ex\".&Cv,31h<~B~hdOuz@\\Ԕ<\'G8cۣpLRf/WjV۽!b,\"0ຫuNIJ=\r$S1\Z;ú|O<!W%Tp\\@T\0?k1M֘[&$x	dhCHPeD\0CxESu1s2@6pLةَ\\ɃRZ5J;86VRS1]rulDH$6\r`!]ܳ:$Ӓai)zoh1ZYĻRSDS4.n, $IbJ\r>F7Q-M&S	O8kV\\AuEP\ZuG(	L«\0!n(yݩLLS+\r8*g&P-9?7bCv`ށH|ۙS8ksϥf,޹2eƊ;z0kE;L=Z2F6sTU8oɀa9j99o{0BavSzAZt\'uON9{HK\"\nASHJŢ$&B2]옧r#<zԉKnUxD+9|F	xze\'YNMDǴFUwyr6S ln	r&w+!^E4	9%QORS3a@]y?sAh\rr\"$K%ew;C~ǻNXendstream\nendobj\n6 0 obj\n2387\nendobj\n27 0 obj\n<</Length 28 0 R/Filter /FlateDecode>>\nstream\nxKoEǓ|6vWU?	CXC!8!Bā|{;͎Fy3]]_UqesmS2ߍ~o^7tb-1J6_]|zg!OoImf<\nm\'G4W56DCwlϠS\"z06P)l6ŖPR2 Lxz(%{ja*ul$}inPJ{M8nNR[/<I6V(;ϻ\r[	1S{s~=6s)M>qrͣ߄g\rysry\'C7>;sh56@Mx)yw:oL74V$=?g`Ϋ-fIDo+a8k(pAƝWPXrٶOd#zG!ݨe-CJQ}S/\\_<p}EOwKMt//\';8%nd;8rΏ\r%^@-bn\\$>pp:OKv;*G$9BA>قm`y̎vF!{o9.)rMA\\r^jhr{\'m4~z8.(y؅	 »U&Iz|^ >(nvy*:JqeVNV}wQS9HO{~II<\n+{䘰T-u5auI{<թL>(#vT,TEm\0Q\ZjB9G^3D\n\\F܃\":\Zkadˑ+~\0Sx6l9\0+lO%]V:uB oLGGҫ(B6CU2דu9ҡhmG:U椆Nt;)$&k\'k7X=qx:Tw:S>Xtx4[sCRdNqD|ߋ1>(+PD>,th9kQ*Rs7-J@̓R_]Poɋsaiq((KqBhbJkg\ra_k܏<8Awd#{\0܀F\"K%{e2z	獕vpt;\\=l:0k;_ѵxkQCPJɯDѱ\0K\\e銋W`ls\ZQ\rendstream\nendobj\n28 0 obj\n1270\nendobj\n35 0 obj\n<</Length 36 0 R/Filter /FlateDecode>>\nstream\nxZYo6~K3+@iq@>pҴ\"]خ`foT)2UuC6+)$+QYcT!ʠÓ\'7eH}Qaw0pkOj}V1hU>mVN[kkcbEQqh|n}}dW+:ٔ)s\ZGو\ni2X?iVVF֏1%_7OyJ\"l6;Q?>Po\0g[S\ZJ#,5V_>alRp]g0:VqYQp]MFi*\0C\n-GU\\h\ng01n\nN\0S\ZM}%vd	lA3\Zaԋ>{/N׆us +RbH笰IfXnRY0b^#3z==eG(ؐ&gBbTLe9#_Jnm,Nx3AhFv20б`{:Jۍ	qeqyɳ<g穔,Zt,Jn~\0/Idfl8WCcYw-ywl湤`aM1+9&ںhnp805˞ќEAviܲ$ff1j\\ܕ\Zy$9nBכ(r\rĆ-1x$s\\L},[sssԹ\'tE{s;z<]\'|\'$hO=^1^apk\"v<7]<ECG[v9}DKjKTP\"!\"k2atTpl\\$wQȫd	R33SrduoKhByJJeye]	/k<##>Fi鿥3Zmg	W07\rG&N$#\"^e??E[9Vѥ	\r>\'B\\yh.}ZBszJǼ\\\"ne=7R(~d趥ha^\nhF|tEܟ_Vdh\n\':]yk|o+īQbʔe0{}`_A0k,}&E-N.%g;eLy^M[$N %?y;p<;,͜Tcu<Qг9f|\Zq-i|	uVsnc)}<|ʕua7\"n\" fv4\"N)pW@+{ ce,nK<R.!K_K;\"6\"kQ j?2S`YM6%l	)X/$Vo}rJƉm*zt\0FŖs|fnH&wZ/Wendstream\nendobj\n36 0 obj\n1599\nendobj\n4 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/ExtGState 24 0 R\n/Font 25 0 R\n>>\n/Contents 5 0 R\n>>\nendobj\n26 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/ExtGState 32 0 R\n/Font 33 0 R\n>>\n/Contents 27 0 R\n>>\nendobj\n34 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 0/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/ExtGState 44 0 R\n/Font 45 0 R\n>>\n/Contents 35 0 R\n>>\nendobj\n3 0 obj\n<< /Type /Pages /Kids [\n4 0 R\n26 0 R\n34 0 R\n] /Count 3\n>>\nendobj\n1 0 obj\n<</Type /Catalog /Pages 3 0 R\n>>\nendobj\n7 0 obj\n<</Type/ExtGState\n/OPM 1>>endobj\n24 0 obj\n<</R7\n7 0 R>>\nendobj\n25 0 obj\n<</R21\n21 0 R/R19\n19 0 R/R17\n17 0 R/R15\n15 0 R/R13\n13 0 R/R11\n11 0 R/R9\n9 0 R/R23\n23 0 R>>\nendobj\n29 0 obj\n<</Type/ExtGState\n/OPM 1>>endobj\n32 0 obj\n<</R29\n29 0 R>>\nendobj\n33 0 obj\n<</R21\n21 0 R/R19\n19 0 R/R17\n17 0 R/R15\n15 0 R/R13\n13 0 R/R11\n11 0 R/R9\n9 0 R/R31\n31 0 R/R23\n23 0 R>>\nendobj\n37 0 obj\n<</Type/ExtGState\n/OPM 1>>endobj\n44 0 obj\n<</R37\n37 0 R>>\nendobj\n45 0 obj\n<</R43\n43 0 R/R41\n41 0 R/R39\n39 0 R/R23\n23 0 R>>\nendobj\n46 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 47 0 R>>stream\nxM_lSu@S2P2ʟK׸?]+kծk{Ͻul]]EE\'&Q/D*&L$$&[y910|<TLX0{m ,t9ez{I=Kno9(9gҫW7\"K]a=o30B/O8EvPI\nbxX7̖Y嘿[ާ,)?C4T7\Zz^pd>ђi)\ZdaA^Oi4PbnNk\\\\.}z~JQuN\r)Pr4yQ\'PaQ)B\nrr;T!&Rge^X?8zPe̕4\"r\r3Fs󠉕C\'ѼzGڤwpڼJln:ř͋D|BC7ԫpw|VJZ$0%D aUU	/6bO-A2[\'xёHLL$`GIݠہKtQݏ}O>_qab<*b7>uF&5[NDMؘY5XoyZOLBTdB6wv+x͠le^p<\'6&}BڸK\ZJBW5/5ERݿXR%XR\0T $A=\'zUYʇ}<6sn\rvNNrVAo+Kuf7bl>nٴ<mܱ<@ȿ(\nendstream\nendobj\n47 0 obj\n857\nendobj\n48 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 49 0 R>>stream\nxcd`ab`ddds\r4T~H3a!nn߿\n}wn\\;*9(3=DAYS\\17(391O7$#57QOL-SpQ(VJ-N-*KM윟[PZZZXT_6Aacb&|0|];}k\neede-+Xfٲ5r|}c^柛\\ҽtiQw_>ڢ%3`82:du7sM2dͷNl;hziӚ{W94iPH&/i4\\/Oa`\0\0a~\nendstream\nendobj\n49 0 obj\n369\nendobj\n50 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 51 0 R>>stream\nx}{lSu]ۻ6e(1\"aQF`˘B$Q`s/Z\\qnn]\0Y!81hf[L1~;s>KSipiIb>XxZ& Cҡٸy+gR~uzUC\Z҂elE^RUQ^V(,RViKBѿȫR%EJRSܹNQ\ZR6\\LQ3*zZC\"/JWSvI(ɗҾGta	#Ih&1KӨ\'ʝ\rkkk	8ww6w\'0\07\Zŏc%`3U9tC\\?}`.Aaw2ulo4>AUx#rS&y|#X/rA.p8[34{Mb}6<\\>/\n\ZF:^Jrs#=BS4;QG[)s217,gq67,kxq08;|21JKNȖ{xXdw6.wCh~\02IH%Q\\T|#َF_9=d5J$!,:׎t~$`gUN=xq_9e|*qW	*S#ZobHd/7S*vpffBtR2\rXÊ\"ga\\o1opiHꂾ?{Yq<57j̠6#G0Ga@(D	`Y@҃G{|&N˧v)bG{+YDHj$I;L\'$8&tPvZyC>3l	.dvrڜ:JD\n)K>4-xC7{fI; sX.;ρ0g>@g۸lfSc^%K y\"kO>C,W0~E2a+	SYt,VbҪ\rG\'G$RVʓM׌-7CPĮ[\"w\\\"(\'lc5ZRR)s	VA%wd/K,s0rY[/VCvwn-:\\do-Jo}w\\:pre]dbc#LX:&ϘvƗAQ\04ؚ\nendstream\nendobj\n51 0 obj\n1249\nendobj\n52 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 53 0 R>>stream\nxkLSgiD=9pǌm:ĸ(\nrzsyNi؁s[eY01/ٌK^ĝܖ}{Oy~D I*(*z{Y`b691G71Wuˉ0rlLT8MC	=I{wkAuVn*Xh~mٲ|*bw~sQRUf>Mջ+,vb\Z\\\\j-{&;TW-6sQm?Ak*X[nA#/Lb)AkP׬f?!6Suqh[|D)+vuAQݝ\n218+ĀD\'Mtz##GGhE)vB{;@k>c_aA-},u?-A\n	laB\'$AhBLh;~\n_7hNI\0:\'z?nj\'GK\'P:J?BVET8ܢ\\K98\"pxc0]DbI9dԣ%s;mS3˭ C{~Dgԥjrra#;Z/QOd3r֘},urAp%Ȑ@=p#GB=qˡҪtr8_	/G|EKDW|{h?u\\,%^?ivKrnSʑEi8K\rTԣ%TbKWeJ_߀u\Zz^	4hRcQgK?bE#3Q\ZU4jF$OiXimY\"*ziÁoX$B3[Uf]~wVFņVhdgψbC z8Ь4@hEr >zB%Iv)]\ZnW\'qGK\r2jz@u9?$ HJ[($Uʪ/\0\0lDAiXUݤux;H/m\n͌UQўpEzw84*˝l|bR?àt{rQ[^<\0Z֪*$CPIګhyԇ&Sf\'lۼ͖	Oũظ+Rq\Z\\i~qn\n̍81Ƨj%pJ^l5xޠ_\"L 8t2jodD&4M_8`\rk0N|NsՃ̧{p\0*y\\KvnJ],f\rB.~JgRSF#A\r\0Ԅ\nendstream\nendobj\n53 0 obj\n1293\nendobj\n54 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 55 0 R>>stream\nxcd`ab`ddds\rT~H3a!+k7s7˒;~n._PYQᬩ`hiiZXX(\'gT)8(t+mv-(-I-ROI-K,*/ȠPİd1J#30>={%EyyV\\dfdciRt+`-.+=[?QKn.7PM`mwGIzN\'wOد3b	9ZۛV\nfr~Nd[|><<\0?_\nendstream\nendobj\n55 0 obj\n376\nendobj\n56 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 57 0 R>>stream\nx=oluǯ[2070b2iPqY$v!hRݭ+kHzzW`cP7a&ԁYLF	 $ 	xxՄ\'y\'O|1f5;ZP{Qz0zrSFiiTZ\'v86nunDP|{7m[s~\rxs3C\\#>2	3c3xT0wlj\r+PP쭫W/U;9K\n6%zyho\n3}ǱDmlvbSlxx<IeҙhIdAuY銦P,QSJٹ?.<{e`/cpx\ni	?$o\'Dn{`\'>[_|_ȔҔh)(Uk\ZvrV$A Hߍl/.l+xW[\"^<K5>|2XaHIu҂JT*bZ]^\\ֺsֳ{a,I	X:kx\Z~0paK[RJ%]Tzamڑ2i\"$&db{o	Q\rY\\Sr\"%Ee_ڲ2̔)h9y\'\rS.؞txGp݇ʏ_^9>ubdt44gB6_? 閪GD(%[bW7a7k1?}	݇vwL\'≄(J(lVI3ySQfhԍ+T\\aBFa6`^-qr|f3\nֳ	0N\nendstream\nendobj\n57 0 obj\n853\nendobj\n58 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 59 0 R>>stream\nxWyTSgH-jm{/^U\"\n @D @DdH \n\"UBkuF[ZZ;~a>t.̙3rGrΗ{y}Bl$m]=?LKZ߳/\0M{jxoؾH7mt@3t[U\Z(	;Nu8%R,E9zH\"q$\rg;H$^uǊe]qrC\Z$E1n}bT4(Z,\rIDS͜;>X\"gE	Ob	Fl\"܉O5fb-A$6[1N Xb$1`D$1xK\'(b;񂔑mlZKA/l6Bw^-JOt[*{.<M}!_]2ǯBb6nXzI\n?BF*TNN#j?P9j-zCUs!|Ғ*VURj2V.\nlE&m).?zYK[R@\nPjlPfegLc TYy}Q\'hD//C(\Z(3S2q[V*ViA=](O}rsZ:oH4H=6m0ݒG!P\npXO*a\r+ڴ9\'k:|kʡ_<}g#7BxPQZ3Y|\"dc	ՆK-f8y5\r! \ZRPԻ2Yۦo9BSܻmOeM_!on\"k1hWG᯦\"4򧟐7\rD&fM\'Btu,m.8\ZxNo7}TSL(\n\rֻWq\Zf[[:\n(PuwDP펗*11-p;T<jf8_#.J\r(~\0o&D3UBļę4\ZlhĴn\01MB#`ˬ5L3f0Jzb?quC,-T#yiF?Fn	Q\"S7~<e\n\Ze姧dkIջa;512h23<j̓ն|}w>Z !ԚT\rUu#6DrVJvjs:5<\Zn\rSC֞Eoןh5cJnKSJ#mPY,H:EUI~CE%0OFWzw]HnN2VR;F!_:oU6\Z>\0W/F[ȕkJ@?r9LǵeAYo43e!9@)u1s\0\nRԐªYJI~1+#Jbzɡ=iTg LI1>ʪkSNDvAzQ~NNE9_XЪ2DshyxBM\\YΥ$&oe1t!BHesR!UpE3Gr>M=!o?QnS`Ez=hYܭ4ɂ\'R)tt-{k)<yՆ7.fEߕJLUdz\Z#%rYTTRg4ֱx\nUrA&M@nǵcPxmmva*oB]aZ\rhنߵЄMOL\'hIM:^tND$]5ꖝy\ZDA-]\\8Y\"=54n+?F_w茹Ն\0m.˝~J)a[H(c]N0WDܱ䕮hV>w,W07||D-`	l5=O^8Sꏁ#&o n\';hyRz\ZSwFr{70P9eeV ~ 66% Z߼O3ڛB\\ͩCh\Zy.+wO<WLnfψx0`lw;<YY./W[pG@|l\"\'r}4u*KmE6=\0O$Z\rYJMDfO<3Ȟ~\\ـVZ\0-c fgVGCg~s}n0oga\"G%DΧˍFXsF[bXk[}uR+|=uW󿄻4L$(mys\Z):ry=مGqNiX&mlm[p[zG2&VzX\\t_	JFH{\Z!f\']!}`I*`7Z;PYJ4( 0%*I嫗x,UGUdx$enBJwQ!Z_섗4fܹZ\n*\Z+%Y*deLImuG+c)D%قH$y)@;U3!ފy=~\\cĻd(Yn\'nFß<|g}p|A	y.T\Z\raluE};.sPuZVCk24Sv\04b\\7ƈ^уN$`[	^â\\I{7%Zѿ￴L\\BO\Zy+J{(@Z/1u,K}qAfnVV:C!ݚ>ߊ<5oTH6*%u\'~\rxv<~\\HOpoɁ|h}mq%<:^\Z89H\rCC}BB#<P\Zs	^v՜m?zhͮ\n1	fsEyιGXlDCݟ\"\'h\Z9QʡakRk5jAĳv8V7jG,ڹ\'z;\Z/zouc4\Z5$l6tUʌ5AٙH#jO/7;vm3ZHp򿝳i^0RB޷\Zh*VURa8ۚU@	s0.jKWb\'Ǌv\nДJDwޤu07N 	Μ4:	Og7yqI1=>@qE??}Q:\ZOyDVk+/m^jo]4H*}26Kl_Knpq@,Md3_<AV`{ɽs?asԇ:Q/*#t?DARdWajl<\Z|<:Rbc&G?Cf<i8TqW\Zܴ\rO0\ZWٻ@QBPDYzvo{?\0z	2\nendstream\nendobj\n59 0 obj\n3564\nendobj\n60 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 61 0 R>>stream\nxcd`ab`dddw\r44\01UH3a!;nn%ߛ;~wn+_PYQᬩ`hiiZXX(\'gT)8(t+@v-(-I-ROI-KMj+I,````4c`b`bdd|?ڙr8cRV?aZ:%[&͜:qr|/d-0}3n9.<g00\0\0j>\\6\nendstream\nendobj\n61 0 obj\n268\nendobj\n62 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 63 0 R>>stream\nx}{lSu] :10*M`\rID#=\nlu>k(`-4&?#\"x11ނ(~rr>=?RP4M3EEut<+%>[?\'Kd(R3pt\\1\r?G)hp;=\rƪJvaK%+Wzcծ:mQR_[j/5ڭ]UzS\ZmIbDOo4u.0oEr5k+9\\j5ZBP(VҨaz=eJqʄ噇t6jCŻX<?Jcf*UE+mGG}0a`J<\"Ux`B^?pv,bUPۚ`?﵇|0E\'D\r68X,e?}B{=hbm\"OFL$cx<F\'޼k*GВ+CF2Bv\'S-v<+fbꭰ)QO`\\|#;H\Z1oЯzG*-U(uHusq0+;9N[VFYb	.FHL)vfM#*j&fÙd2?sK!m\nf&Zl6IRL嫿,_vB+g\r\Zbp(wX|M\"h	X;sr08Y%	=R~aq&;[IN+߱|<KL}2-9x/p#8)oBfs%&̲οE]I.P/^1*m<\r^mn3\'!tްƶz@~}L~Átbmr\ZAEMdۉN.{jKؗJzȺ}? \nK4H`a]V9ֺ9xk:3G,ׂk:^&kN0zm9vE2\'Oztf@vr$4SQ<Óiߩ~göݍ 8\r*]5Rz:&5{BA@y3<W1m2Q8\0u|M<FK%vS-Q236dMR͘4Ƞ\0e\nendstream\nendobj\n63 0 obj\n1212\nendobj\n64 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 65 0 R>>stream\nxT{Pu`YNvKC\'|`JR\"Sf	\'Rݻ(xc:eik1%98YǌnPk鏝ٝ> ДȠTP?\npd=>&S(M._RT\\UNKHXK.Зdҳ\rQY7TK޸Q2TR_/)NRTP\\fЗҋr%E,Z85Q/SPө8j*5DHSvz	}:huШRސ\r(>7FPMΒܚuBPZ֦>#d\rriijmJp,r0ry+#[J1BE}I\0xcth!b\'86v#+4h5\ZٍGBF)Bt7G=BhbB`7#?0vBƱY~ǃaTN!wƷn;Ԃ.ul5? ɽGVi]+͝\ZV8Ԁ(	4,2Ysf0<y*c|[*_QF`sMk/bhq).Ûp5N@aF1/}yp}(lDUl9SaQjFjͫBI|s?Ol`#ov\'~zqOhuMPYGgkPGx0gbnD\0̹jLÎ2F>W7q_~a,ai?O\"|:IDȾCg5(A_N/F|tb-J&\\_.)x4ucw܊yOoXGF1$qJANdV:hR~	N\"f3hGo5(/1Cv갸VwՆN3*l`c#9\"=bzWaB)b,v3XYbv{$WudeJ@;.3ʻl Zx1clǶ1= IX\"Axȇ+_M[\n%0ljT*P< Ehnqo⁍eNǜ#4D؄b^%ιp&+0\0M$^D0@,P@\n.ր0}\\`bEuUSfjqkVn:w)p8O9p5?Zt\Zq	13aU7ݹ]rqCHfjI8-WY唤V/gjѢ)g[yCOcNO+$akwFNdlU``6KJSuNٞP_؅z]\'Ot\nendstream\nendobj\n65 0 obj\n1367\nendobj\n66 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 67 0 R>>stream\nxcd`ab`dddu\r21TH3a!G&nnu?ԅ~7-_PYQᬩ`hiiZXX(\'gT)8(t+,v-(-I-ROI-c```4d`dbb`add?U|V3[+x>w?~foݨ{]M<1}r}߆_~Ѽ\'NC5je߾~QE}GS[kOjv/~ktn7Nm]WWw+G[_[~\r4)Y{ӏZ+ۻs<Uӻ9Rؗv>O/{Vw\\B\nۡ݇fvM	*3-iYNƾ|Փxxe`\0\0g\nendstream\nendobj\n67 0 obj\n440\nendobj\n68 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 69 0 R>>stream\nxWyXȌĩ[m{U\\k[o^VY\" Y|	 I ,DpAEZ[-XZVvZ>=P{{\'3O23}ߟ$l5mF$vHHFd+oq\0ɂG)E;uƌ.sB|\\DD?.kGǍwP?_k熇F.÷+(\ZuEQAݷ+|B}G3\'M2DQj5zZHRI;\ZEyPKuRj*ZNQ+T/7H9Q3Qrj RahJ%c$:xD>_oaCLCD?fz9P7z\'O`ʾ3z:iLNb_0yoovS\\z[PY%edV^hcah-QV]q<(aN4)󴙐98+[Ӈ\ZA.ഝ;UB\ZDCl53LelqtjggKgVpfP`ZTfg_\Z$C;|E׷Nj.Rѿ^>sB\Z$/\\/Z\ZUѐXl\\\rn;|9#&oW9)x$#)6Z$oR$&5v21Օƒ}10P?d28M6=U˅_\0̺ɇp*Nr*.w4j0,nIfqH!2^gs$laqTy>ha8RyzmPY\"1c@XFY ySv1#yW];Q\raޕHGGZx4Z$VS\rXu Yspz4CK3?8u&Sbj)&tNb5\"0t\Zb2:nqCqmáJ4.3Uxpn^\rL!dq\nZmC0l2(D]H:+3CZKX|k;ٚ5m\\|2q 76G&Ѓq\r0ןE\'~*?nT/+O\Z*\nzC֏\n5[7	ۥP3H\0fp:JvҒ|pWo_tc1hFobۖ<#ö#?P/AYfP]tV1dr8\nW\Z2],/v6uVjwhUT	D\Z2pSLĚ#lDL1Kо]).(^~8vpFqIq;ADT+\Z͟-)%^!פo5TAh\ZƺoUc{b~LpER$lPCd{G}q~4ނJTb)z{P^Lx\"GCyEklť[_RG{ǝA#8:\'-6it1IɄ̥\ZoEމ\Zф}LwsʝO\\E\'JNU\" 0wadt.$ANfTެ)ѥK\Zw4*\rY`,ЩԐ$e$nJ||2T_c/e;3!.y\'(\n1+Cm6TsW\nQY!E\n	%F7vĂSG4?A{1oh^{~ɂBEr8xT(fq XXF=2OK&k\Zh\\GRC _۽KǧzzPȐ\r_g\0]{ߜJrf&ޚɩ΄XoDA^<v[lHĆGjLuM>mG,L+s+>; =܊Xs07szc9M.s0;!%\'xH8e}LGB%k0kkZ_|\\N+)2]4-$4黒5վ Rڠ*_YD浝vkln*>,7VdtL*wG(5وJsaڽZ\rݿ9E<MY_s׆LFQKPKiy+\'%dS=IXw\\H#gHM!0ŐaqW7J鐴8\'(BVid!>8EК+7*?oj6!ip+oz	Z8Ǧ]X;L)uΨ\'54(rY;-&̀EDL/|LcՎ>\np27U~+j\rG8=?JSBaV[L|ܡŹ°oYW\ZvqQ&#ݦ+A3\'c0ǝ9\\E\r#b,A޽Ó/?v\\/\\hKӢ +4BSg\\&/.>]k*¢*jj**lo\r&(i`={|eD`Ԣ:\"tPC4#z6H|SȚ3~94G\ry#f,uTQ{$c(6Pu΍OШ*-].L6@=Ð&(y[=^\'8xO!\0\n 373yŅN8wv)\\ӟ2X\"ƛex+3;\\_b$ߡ;߰~U>>/?\\KVӏdqh\nlڴx303lYj.5VMDWϯ٭\0Z~BA3_,t6zb>x~`k#qsyn?i-Gltǟy7]mjxwN`aRݡ\0xg,~ B9U<!e^EOl|)fїy/n:iN\nJߌ5ڕa\\((ezd(yrNI\n+K\0t t;ndgr]H䫸\r.HŒgOyΒ<`dfdC||fp]MRT\rhG%@扇Ibp0{qmhp%	gwHpYY^4|>5Ut&%+=k\"}1/(.\"2$x<P\\yNR9R~98;Rt?YD9,i9p#Fן4V[i3C<WbitKY[+VXeI}gpsNaW6*o-̂e0&[)\\A#zX4k)vd+-_:B@LWIrBb;w^U28L{ιx-*1dSE#Y$]%TϬ/T@71xJHٽC:DΟCPz89&=%{+*vkAʿ<x>Əܗĝ\"|ex;{?܂~z>HN(</؛U9V\n6X[ o/h\0SkvuyFۭҦn]v1.:JòG7yy.,O\0a\nIh1J_n.n\n>Fgl6 jbpmqR8/ݧuYܞ\Z[^ 绶9\rF]vŢևKw`qohhIfSQ`.ޗtd &#y?yP~\"҅6p؇\\eAԢV!ڧr+W\Z\0`l+?-t`	<\"^qhfIU	ˈ^Rtc^ܾ}/:R?k\nendstream\nendobj\n69 0 obj\n4118\nendobj\n21 0 obj\n<</BaseFont/YWRBPR+CMMI5/FontDescriptor 20 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 1036 1037 996 0 0 0 0 0 0 0 0 0 0 0 0\n875]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n19 0 obj\n<</BaseFont/SZBQCB+CMSY6/FontDescriptor 18 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n963 380 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1222]\n/Encoding 70 0 R/Subtype/Type1>>\nendobj\n70 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n17 0 obj\n<</BaseFont/MUQRQK+CMMI6/FontDescriptor 16 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 924 927 884 998 900 0 0 0 0 0 0 0 0 0 0\n780 0 0 757]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n15 0 obj\n<</BaseFont/EFYKBB+CMMI9/FontDescriptor 14 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 771 778 734 848 756 656 0 0 0 0 0 0 0 0 0\n0 0 0 628]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n13 0 obj\n<</BaseFont/SZBQCB+CMSY9/FontDescriptor 12 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n799 285 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1028]\n/Encoding 71 0 R/Subtype/Type1>>\nendobj\n71 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n11 0 obj\n<</BaseFont/YAUXEU+TeX-cmex9/FontDescriptor 10 0 R/Type/Font\n/FirstChar 16/LastChar 33/Widths[\n614 614 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n814 814]\n/Encoding 72 0 R/Subtype/Type1>>\nendobj\n72 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n16/quotedblleft/quotedblright]>>\nendobj\n9 0 obj\n<</BaseFont/GHNQRB+CMR9/FontDescriptor 8 0 R/Type/Font\n/FirstChar 12/LastChar 121/Widths[ 571 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 400 400 0 0 285 0 0 0\n514 514 514 514 514 514 514 514 514 514 0 0 0 799 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 642 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 514 571 457 571 457 0 514 571 285 0 0 285 856 571 514\n571 0 402 405 400 0 0 0 0 542]\n/Encoding 73 0 R/Subtype/Type1>>\nendobj\n73 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n12/fi]>>\nendobj\n43 0 obj\n<</BaseFont/GKKKKC+CMSY10/FontDescriptor 42 0 R/Type/Font\n/FirstChar 54/LastChar 54/Widths[ 0]\n/Encoding 74 0 R/Subtype/Type1>>\nendobj\n74 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n54/negationslash]>>\nendobj\n41 0 obj\n<</BaseFont/WSXSQF+CMMI7/FontDescriptor 40 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 859 863 819 934 839 725 0 0 0 0 0 0 0 0 0\n727]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n39 0 obj\n<</BaseFont/GCFFPC+CMMI10/FontDescriptor 38 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 750 759 715 828 738 643 0 0 0 0 0 0 0 0 0\n642 0 0 613]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n31 0 obj\n<</BaseFont/EMLRVG+CMR6/FontDescriptor 30 0 R/Type/Font\n/FirstChar 40/LastChar 49/Widths[ 481 481 0 0 0 0 0 0\n0 611]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n23 0 obj\n<</BaseFont/WRPRDT+CMR10/FontDescriptor 22 0 R/Type/Font\n/FirstChar 40/LastChar 121/Widths[ 389 389 0 0 278 333 278 0\n500 500 500 500 500 0 500 0 0 0 278 0 0 778 0 0\n0 0 0 0 764 681 0 785 0 0 0 0 0 0 750 0\n0 778 0 0 722 0 0 0 0 0 0 0 0 0 0 0\n0 500 556 444 556 444 306 500 556 278 306 0 278 833 556 500\n556 0 392 394 389 556 528 0 0 528]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n20 0 obj\n<</Type/FontDescriptor/FontName/YWRBPR+CMMI5/FontBBox[0 -22 975 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 146\n/MissingWidth 333\n/CharSet(/A/B/C/P)/FontFile3 46 0 R>>\nendobj\n18 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY6/FontBBox[0 0 1128 432]/Flags 4\n/Ascent 432\n/CapHeight 432\n/Descent 0\n/ItalicAngle 0\n/StemV 169\n/CharSet(/periodcentered/minus/arrowright)/FontFile3 48 0 R>>\nendobj\n16 0 obj\n<</Type/FontDescriptor/FontName/MUQRQK+CMMI6/FontBBox[0 -21 944 714]/Flags 4\n/Ascent 714\n/CapHeight 714\n/Descent -21\n/ItalicAngle 0\n/StemV 141\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/S)/FontFile3 50 0 R>>\nendobj\n14 0 obj\n<</Type/FontDescriptor/FontName/EFYKBB+CMMI9/FontBBox[0 -22 823 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 123\n/MissingWidth 333\n/CharSet(/A/B/C/D/E/F/S)/FontFile3 52 0 R>>\nendobj\n12 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY9/FontBBox[0 0 970 430]/Flags 4\n/Ascent 430\n/CapHeight 430\n/Descent 0\n/ItalicAngle 0\n/StemV 145\n/CharSet(/periodcentered/minus/arrowright)/FontFile3 54 0 R>>\nendobj\n10 0 obj\n<</Type/FontDescriptor/FontName/YAUXEU+TeX-cmex9/FontBBox[0 -2957 781 45]/Flags 4\n/Ascent 45\n/CapHeight 45\n/Descent -2957\n/ItalicAngle 0\n/StemV 117\n/MissingWidth 250\n/CharSet(/quotedblleft/quotedblright/exclam/space)/FontFile3 56 0 R>>\nendobj\n8 0 obj\n<</Type/FontDescriptor/FontName/GHNQRB+CMR9/FontBBox[0 -249 833 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -249\n/ItalicAngle 0\n/StemV 124\n/MissingWidth 342\n/CharSet(/L/y/n/c/zero/o/one/d/equal/p/e/two/three/parenleft/r/g/parenright/four/s/h/five/t/i/six/fi/seven/comma/eight/l/a/nine/m/b)/FontFile3 58 0 R>>\nendobj\n42 0 obj\n<</Type/FontDescriptor/FontName/GKKKKC+CMSY10/FontBBox[0 -216 638 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -216\n/ItalicAngle 0\n/StemV 95\n/CharSet(/negationslash)/FontFile3 60 0 R>>\nendobj\n40 0 obj\n<</Type/FontDescriptor/FontName/WSXSQF+CMMI7/FontBBox[0 -20 893 713]/Flags 4\n/Ascent 713\n/CapHeight 713\n/Descent -20\n/ItalicAngle 0\n/StemV 133\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F)/FontFile3 62 0 R>>\nendobj\n38 0 obj\n<</Type/FontDescriptor/FontName/GCFFPC+CMMI10/FontBBox[0 -22 804 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 120\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F/S)/FontFile3 64 0 R>>\nendobj\n30 0 obj\n<</Type/FontDescriptor/FontName/EMLRVG+CMR6/FontBBox[0 -250 505 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 75\n/MissingWidth 416\n/CharSet(/one/parenleft/parenright)/FontFile3 66 0 R>>\nendobj\n22 0 obj\n<</Type/FontDescriptor/FontName/WRPRDT+CMR10/FontBBox[-40 -250 813 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 121\n/MissingWidth 333\n/CharSet(/y/n/c/zero/o/one/d/N/equal/p/two/e/D/f/parenleft/E/three/r/g/parenright/Q/four/s/h/G/t/i/six/u/j/comma/T/v/hyphen/l/a/period/colon/m/b)/FontFile3 68 0 R>>\nendobj\n2 0 obj\n<</Producer(ESP Ghostscript 815.03)\n/CreationDate(D:20070530183126)\n/ModDate(D:20070530183126)>>endobj\nxref\n0 75\n0000000000 65535 f \n0000006130 00000 n \n0000030104 00000 n \n0000006057 00000 n \n0000005547 00000 n \n0000000015 00000 n \n0000002472 00000 n \n0000006178 00000 n \n0000028547 00000 n \n0000025484 00000 n \n0000028295 00000 n \n0000025187 00000 n \n0000028078 00000 n \n0000024857 00000 n \n0000027857 00000 n \n0000024655 00000 n \n0000027636 00000 n \n0000024453 00000 n \n0000027418 00000 n \n0000024123 00000 n \n0000027203 00000 n \n0000023931 00000 n \n0000029758 00000 n \n0000026808 00000 n \n0000006219 00000 n \n0000006249 00000 n \n0000005716 00000 n \n0000002492 00000 n \n0000003834 00000 n \n0000006356 00000 n \n0000029526 00000 n \n0000026633 00000 n \n0000006398 00000 n \n0000006430 00000 n \n0000005887 00000 n \n0000003855 00000 n \n0000005526 00000 n \n0000006548 00000 n \n0000029302 00000 n \n0000026428 00000 n \n0000029081 00000 n \n0000026232 00000 n \n0000028876 00000 n \n0000025993 00000 n \n0000006590 00000 n \n0000006622 00000 n \n0000006687 00000 n \n0000007630 00000 n \n0000007650 00000 n \n0000008105 00000 n \n0000008125 00000 n \n0000009460 00000 n \n0000009481 00000 n \n0000010860 00000 n \n0000010881 00000 n \n0000011343 00000 n \n0000011363 00000 n \n0000012302 00000 n \n0000012322 00000 n \n0000015972 00000 n \n0000015993 00000 n \n0000016347 00000 n \n0000016367 00000 n \n0000017665 00000 n \n0000017686 00000 n \n0000019139 00000 n \n0000019160 00000 n \n0000019686 00000 n \n0000019706 00000 n \n0000023910 00000 n \n0000024338 00000 n \n0000025072 00000 n \n0000025376 00000 n \n0000025909 00000 n \n0000026137 00000 n \ntrailer\n<< /Size 75 /Root 1 0 R /Info 2 0 R\n/ID [(F4P9m{6kq`)(F4P9m{6kq`)]\n>>\nstartxref\n30215\n%%EOF\n','Proved','BZh91AY&SYq\0_tcG ``(U\01Jh\0\0\0h\0\0\Z`&F\0F&&	\Zbi`&F\0F&&	\Zbi`&F\0F&&	\Zbi&IF=OSMSjizJQ\r=M\0hr;BRN\"{,&LXF%dXf#QYgԉY,ɘA \n	GaI\"Zֆԙr.;\01SsTfy \nN=30\Z3̨<u8!hXGr{\ne;9y5~?ePAyz:ıg\0:twz:9uRbRI*BBQPf-+2\r\Z\Zi$*!	LGA>=[1WKO4켇w\\܎M4Q\\(k%pQV6cVQRb܈!$Àc -?%\r2b	e5,FbVQl0b-QPM	\"DBQ- :IjTI3^uo;lA`0VR\0jEX1BDdwo,-%dgOGګG4k]vȿ`{ɛ~D>]߸qxCh!2qXs\n-m<O??_2<pe\\jh5n\\It_\n+}ynKke\0軶WW?.0[ʿBޫ{\n\\\n^v\\wR{+ap`.kz|kxqrFJ0X2`C^70WQ.?(^t*.u[˘ثsI=طrt*NRb,\"20Un..wOy/U:z[]:t\\	x)uZԶ!\"cEBGQZ-Uīr4,dL+#YI2xh-H*\ncU@g5^z7\\E>֒u.\0EnfP4YxpmZ;	^Kf[v1j\\\\̌#EZ*<D\'+er%wkiRfRSshOzmKb:+Z}ٱ.Er%}nb/+_(>lH\nb4n '),(19,'area 5 5 90 90\r\n \r\npoint A_0 50 10\r\npoint A_1 90 10\r\npoint A_2 75 40\r\npoint A_3 55 25\r\n\r\nline a12 A_1 A_2\r\nline a03 A_0 A_3\r\n\r\nline a01 A_0 A_1\r\nline a23 A_2 A_3\r\n\r\nintersec X a12 a03\r\nintersec Y a01 a23\r\n\r\n\r\nmidpoint M_1 A_1 A_3\r\nmidpoint M_2 A_0 A_2\r\nmidpoint M_3 X Y \r\n\r\ncmark_b A_0\r\ncmark_b A_1\r\ncmark_rt A_2\r\ncmark_l A_3\r\n\r\ncmark_t X\r\ncmark_b Y\r\n\r\ncmark_b M_1\r\ncmark_r M_2\r\ncmark_rt M_3\r\n\r\ndrawsegment A_0 A_1\r\ndrawsegment A_0 A_2\r\ndrawsegment A_0 A_3\r\ndrawsegment A_1 A_2\r\ndrawsegment A_1 A_3\r\ndrawsegment A_2 A_3\r\n\r\ndrawdashsegment A_1 X\r\ndrawdashsegment A_3 X\r\n\r\ndrawdashsegment A_0 Y\r\ndrawdashsegment A_2 Y\r\n\r\ndrawline M_1 M_2\r\n\r\nprooflevel 7\r\nprove { equal { signed_area3 M_1 M_2 M_3 } { 0 } }','<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE figure SYSTEM \"GeoCons.dtd\">\n<?xml-stylesheet href=\"GeoConsNL.xsl\" type=\"text/xsl\"?>\n\n<figure>\n	<draw>\n		<area x1=\"5.000000\" y1=\"5.000000\" x2=\"90.000000\" y2=\"90.000000\"></area>\n	</draw>\n\n	<define>\n		<fixed_point x=\"50.000000\" y=\"10.000000\">A_0</fixed_point>\n		<fixed_point x=\"90.000000\" y=\"10.000000\">A_1</fixed_point>\n		<fixed_point x=\"75.000000\" y=\"40.000000\">A_2</fixed_point>\n		<fixed_point x=\"55.000000\" y=\"25.000000\">A_3</fixed_point>\n	</define>\n\n	<construct>\n		<ruler><new_line>a12</new_line><point>A_1</point><point>A_2</point></ruler>\n		<ruler><new_line>a03</new_line><point>A_0</point><point>A_3</point></ruler>\n		<ruler><new_line>a01</new_line><point>A_0</point><point>A_1</point></ruler>\n		<ruler><new_line>a23</new_line><point>A_2</point><point>A_3</point></ruler>\n		<intersection><new_point>X</new_point><line>a12</line><line>a03</line></intersection>\n		<intersection><new_point>Y</new_point><line>a01</line><line>a23</line></intersection>\n		<midpoint><new_point>M_1</new_point><point>A_1</point><point>A_3</point></midpoint>\n		<midpoint><new_point>M_2</new_point><point>A_0</point><point>A_2</point></midpoint>\n		<midpoint><new_point>M_3</new_point><point>X</point><point>Y</point></midpoint>\n	</construct>\n\n	<labels>\n		<point_label direction=\"270\"><point>A_0</point></point_label>\n		<point_label direction=\"270\"><point>A_1</point></point_label>\n		<point_label direction=\"45\"><point>A_2</point></point_label>\n		<point_label direction=\"180\"><point>A_3</point></point_label>\n		<point_label direction=\"90\"><point>X</point></point_label>\n		<point_label direction=\"270\"><point>Y</point></point_label>\n		<point_label direction=\"270\"><point>M_1</point></point_label>\n		<point_label direction=\"0\"><point>M_2</point></point_label>\n		<point_label direction=\"45\"><point>M_3</point></point_label>\n	</labels>\n\n	<draw>\n		<segment><point>A_0</point><point>A_1</point></segment>\n		<segment><point>A_0</point><point>A_2</point></segment>\n		<segment><point>A_0</point><point>A_3</point></segment>\n		<segment><point>A_1</point><point>A_2</point></segment>\n		<segment><point>A_1</point><point>A_3</point></segment>\n		<segment><point>A_2</point><point>A_3</point></segment>\n	</draw>\n\n	<draw dashed=\"yes\">\n		<segment><point>A_1</point><point>X</point></segment>\n		<segment><point>A_3</point><point>X</point></segment>\n		<segment><point>A_0</point><point>Y</point></segment>\n		<segment><point>A_2</point><point>Y</point></segment>\n	</draw>\n\n	<draw>\n		<line_pp><point>M_1</point><point>M_2</point></line_pp>\n	</draw>\n\n	<conjecture>\n		<prove proof_level=\"7\" proof_limit=\"10000\">\n			<equality>\n				<expression>\n					<signed_area3><point>M_1</point><point>M_2</point><point>M_3</point></signed_area3>\n				</expression>\n				<expression>\n					<number>0.000000</number>\n				</expression>\n			</equality>\n		</prove>\n	</conjecture>\n\n</figure>','2006-04-06',2,1,'GEO0002','%PDF-1.2\n%쏢\n5 0 obj\n<</Length 6 0 R/Filter /FlateDecode>>\nstream\nxMu[#ERX\"$k#|@>6a$~?zwAP`G̬}H\Zu?_ڥ6jݛ\"˚&	;?IRX(-QsjmʶjoQθ~\rq\nuR7?.	bN 1#ڑdOx\'oR9	Ȩ߶_VX/#X׻7lr\Z?;Flѫǻiߗo_WOď{FWVZYA$tfWcn\n\rX+A0kV/uU?ړ \")|ߛ\\LO#Y\\Jhm\04Llp;i\"|};ɱ3z!fQ_8r.pasvvֈMÜ-|O\nho0]ڇǩs\n=utM\'!4:h1Ս%T~9[=j M9FkA9B>(	Sq9\r޴oX\ZV~K\\`{-5;{q/1RFҮ]&+*Y7w=%fy1ҵFvj/\rf9ZlgJ<3%3k]yfJdiL$SyI|\'v~ntT\'R`iy@Q]CyhAzEudIptYv&̤eLDR{&L\"\ruUGώ/#=~pJu~0X\'\r2./poq\0O}wu\rk4䵞2 z9L\"yöDَgnWJc.@a\ZH21WdIϋL=]#\n[K̥2,_0vͧ;S=;(KaxRY7VvXȩ.W\rƴ/32犳3=fSD6g;N1\r)Hh`px8+̝ju9u-\\Z~4Ak)\":qjpOP)禍ޜWD\ZZD~kOh1\rKuvUsk74\'אލ	\nvN4Xy{n<v!~r?!+>uy ?oGf06aeBtƄ0G!5MiZj^Vjhkgs\rxDuFӓԼ\Z{\Z`P%c CfK5<yׯ,az[+-ծf4rAaW3z^z]CQu|H?\r!:):,Q>mSȨ6l/,냰j	;!nO6w\ru#Uy`yIt$6\\X{V)VBHA𻒋;W/q1ҴcE9U\"\"C#{Rփ:,xNM9ϣFgWsc{\Z+:HU1\\QhU%r\0,\ZXJ\0xVڡeC.DEʁ|\r,Xh*5W8&67f		A?b\'X$gYht\rhjxNս>fx._`jbqَ\\ɃQ)͖:HsPrNVRS1]rulE\"${]SˊECYHyvm|h\"TPG`I!%KWVc)`1,Ļ)Gv4{7d$SI2_P	M<XM>R(q֬HHv2|,++x`8pI*H\npEn^jw*W%WǓW]g~MZ\'o\'m)0SXz(؎EJ9U;}X;?ޑX{.5|~Εy-+zl5¿-ZB2hɼ=ژQU%s9\")sfsx770BavsUN^#=S|HukE\"]TdlBjET,Jz}7\"Y(Y滋y`8\n+	}q#NM^bUuV#ZuNn%ƲMIpcڅx#*wTd[$94Qr+R؍EqzNI$s\\jLH so^6ܪr&	@n2u^dREɛ;S!?윧endstream\nendobj\n6 0 obj\n2383\nendobj\n25 0 obj\n<</Length 26 0 R/Filter /FlateDecode>>\nstream\nxKoEǝ|m#aVpN@=ޱw8 [tUw~Ue4)#?UU>*ROwU7uLLlJ:`\\\r~v^U/u!s㵥`Cq\rAD!hyΰھOE\"XpS	=ju9V{zC߉ñ+2_5FA_(Nώec\\ѣig\"iy9dujW56fxש6}Vm?Q411gk9\'ꢺQ堉U$!?9ϿU}xS:Z<?:,4Iu,;F%\Z\'\r<UYG[9,qm,ixo+ዤ8٬Ӄxŭv9+HzE۽23]ȴίK QH7*EYʐbh\'uOf	\"O֯Z$!׿t߼iX!Üplo7HڗH}	lC<jl=d||ِ.8uJ߻ףp3\"!j3E\rh3{C#AKT0ȁAI]-!<\"mrqA!.OHm\"lz\\^ .4+n6i,AYqy+K,H#MrPLEzʤ(MiRs{XkRXq\Zۏ}I{@L>(싾g#bϞZYT%;G+e>i|DhY>8\Zu]x]|pI7\\KG]x{q]΀\r`+Xa{.`-Sczܻ7?=J==6GF\n@Mp_GANH	A^#*;n5Ys7Y~żcw\Zbڥ_!\n\"$Șbd!>)hW|JY8kV*nZ<z[ehʅ}L^K+HA4n\'tvZ2e9+Ȓ#{]܀\"s%ڲ-Rr	捕v(pw;=l:Ɩ0kO_,kZע00[cw[\0Y\\(e늳`d#lRvQ\rU{endstream\nendobj\n26 0 obj\n1263\nendobj\n31 0 obj\n<</Length 32 0 R/Filter /FlateDecode>>\nstream\nxZn6BRѥə-@it>$}iޤ@3Vj]خ0`ks8̐\ZW[>}]ukWY0udR퀢II:T\'??|:~]u:_T\'h}v>\\V\0lr@y:hBiQ\nؘ֚H9nXbRG7֣\r3^3\\/՟[4,0%lmސip[?yⒷ<^dD!:6;/~|b{؜/v3C?V/60v)s8jC0J&}9*oc5]Sn-_vAa4!#e9섇[b,j|_vZM7s \n~W̾-yᲉ9հL\ngaG-z=L<i1)ِ&τؼ\\L1urA^X%3,v\ryc0!ʑOc4m6j2d͓9ʔgfS9SYs0AY/O21A}P$M2Q`6^<EGؿ+Y!؏)t=U\'G_8+;TT{5\'f%g͇5A|N̍NV8Pt\ZDe\ZVAv\"vHW-;cg;}W-9wnFכ(rښcIs\\L}T9`9͹H|Ys}¢;Fչik|\'$hQSIͱ^epkp;oyn!z\\VS̼iȄg܋9Bbőnc!$Y񺤶D9A	TR\Z!S)(kд.S!OK	<{{P%#Lhh%V˕N܋e	G|urdƶhcd(Re2<2\n̮.G5C-iH鿣3:c#g	Wș07\rGeN[HGDu??E;9Vѥ	\r>\'B\\yh.CZBszʷ<\\\"2g)~}d趥hq^GϿ[ہ|tEܟ_Vdh\':yߴ[&gPQ*`r}`פ}.E]T.3;::َVߤ+[\rU8cȻda$ް\\ٔM_F]V58U\0=cӄ̀4x:K0Rd3f7+hGt7}#lT *~4H7S0:\0\Z\r)\rM\nH\n)h{.\"kQ$j?b)2tct`aP.q߭_Au\Z/TiEY\"mP12k\0&Ŗ5lyeɉLv;\n endstream\nendobj\n32 0 obj\n1596\nendobj\n4 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 23 0 R\n>>\n/Contents 5 0 R\n>>\nendobj\n24 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 29 0 R\n>>\n/Contents 25 0 R\n>>\nendobj\n30 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 0/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 39 0 R\n>>\n/Contents 31 0 R\n>>\nendobj\n3 0 obj\n<< /Type /Pages /Kids [\n4 0 R\n24 0 R\n30 0 R\n] /Count 3\n>>\nendobj\n1 0 obj\n<</Type /Catalog /Pages 3 0 R\n>>\nendobj\n23 0 obj\n<</R20\n20 0 R/R18\n18 0 R/R16\n16 0 R/R14\n14 0 R/R12\n12 0 R/R10\n10 0 R/R8\n8 0 R/R22\n22 0 R>>\nendobj\n29 0 obj\n<</R20\n20 0 R/R18\n18 0 R/R16\n16 0 R/R14\n14 0 R/R12\n12 0 R/R10\n10 0 R/R8\n8 0 R/R28\n28 0 R/R22\n22 0 R>>\nendobj\n39 0 obj\n<</R38\n38 0 R/R36\n36 0 R/R34\n34 0 R/R22\n22 0 R>>\nendobj\n40 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 41 0 R>>stream\nxM_lSu@S2콈P,e6&aFc5nOGtsoe[Ww?keQ		iQ7ʣ	#ӻ_y+/?9!fa;{j$Si2UbO}}</>;0=Cz|R}{߾RrJ=AHRWbXri}nts<MvgnRg#dq1t~qEfve,Wr-V_bؔ!\Z	M#=cGd82L?hI4\r /4X(HZLԌX\\..<;(Y:d(9{¼0LNMI(؊!99XRymr2/_Wu`ʌ~M,*Ȁi<hb\0q\'6i9#k^Mj7RKEA\">_![Ne؆{WyV*4Lo	BXUAUO\Z1=v ZFe}szd͗Y\n̍Eey<dH$&&-GnЭ%:EE>VDr@3Aʡ]mu:b}\Z?|/\"&l̬\Z2\'&!*2p.Yu;^EfPY8a\rI6tЭ|c\r+{\rnԇ/\'r	/\0?%-#aPψ^UVjrG.܃Cm]\'Ůc.cc_\n,Gw66߰lXXX!_X\nendstream\nendobj\n41 0 obj\n852\nendobj\n42 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 43 0 R>>stream\nxcd`ab`ddds\r4~H3a!ֹ}nP;*9(3=DAYS\\17(391O7$#57QOL-SpQ(VJ-N-*KM霟[PZZZXT_6QaCcb&|}c^柛\\ҽtiQw_>ڢ%33V/`w}D,*(ZVfͲek`82sɰn樛1eForovvIӺ56ߟsi~g_]7GSCG]z/^~	oi^p\0\0.\nendstream\nendobj\n43 0 obj\n363\nendobj\n44 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 45 0 R>>stream\nx}{lSu]׻6Y{;Pyl#@D-c\n0^]>m}ۮۺWvcSd	8Nb@AfbC@No	2/M%&P4M3_\":8!t7L-9s1c6.Ch7viV(3yU*ujeaL+]*5UZʼJeQFYҨ:=jj*fJ]MQTR^~m)j	zzʤPDJ%Q\'MՄ2Jeb#HCAEca\Zu8K^^_0-nв^x;\npIp\Z3[{?`cyI~x;G@u]>w{`,tquf{%\něrOcQz|h<jʅ:ppY4K*p127cR0^{*I3\rFP{ \Z6hvaObmmyHlЖYd6Od\\ Bfp^dݾUd/i.:(Jߗ=9^wv[m\\H#~\"DCrQIXzob(v4z-\"$s3G\\;r3c8XT^bpK|BI($UPRiZ|kE> kyIM?SϰVń05dd93퇕RbuEe	w>QfpgZD!ޫeTh435~`-`t.=x| \0^+v vZ1K31ɩ2-)b-sIC	vp\\)mR6n9g(\\]kK%OW^L;]wԁ7tWhynOA\riS_{rɂ,xEQm	~۩ro<	\'?!wƪ+8zE6i(vJ,\\+g1iG6G 5P4N6]3AvuIAD|.nkv7pB,ݭ	Kqd/KL1rY[/wvn-:\\do-&\0I1tL= e]d2\'Buۑt&y<KN\n8MM?\0捙v\nendstream\nendobj\n45 0 obj\n1244\nendobj\n46 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 47 0 R>>stream\nxklSeiak&,9\r\n8	crpeˀ:;6kq[˹<]vۨl	q}@AE1#fAIhD	&OP$y{IL$IRo-MرL,=&/\'w\Z44\rr&)$ٚ_Y[՘_[4ϼb.o.,)Th6VKcyf.IQm.T[u==++jk,vsa}?Aik_`A&s,b1Aki>PפM(2xBn&&=$жغ&.!ܒGuw+:SVcVGQ(VŮ	\0nl:XMv^R`)8 :1.Bfxܮf\Z7>.0)|ݠ;q(5w}TL\ZQިuغ\ZŎZ2P,G}5\"`]nb\'{HW>t>3D3GEs;mS- C~@ǧԥorsc#;Z7QH.Hg~\'ce&%1hYj<r3Ey/K)${=\Z;p=20r];{4{C7AU1D/1[q.6G|CDW|sh?묂\\,%\nn?i꒤~KrnSʐ\rE8K\rTԣTlǋWfJ^߀u\Zz^	$hc}R#1gK?dE#3\Z1\nU;4jf$O_ak^|*vi#oP$BS+ټf]~wH+c\"CG40#3gDqAx`sq꣺抢d9J DFqIR\rbw2\rwWp\r2jz@t8?$ HJk8,;Uɪ/\0\0lDA_Y٨ux;Jh\'m\nMaViO\"Uq=;vM>q~z_--P\'\0_5kSDRaTsI~#T)oJRijDmuqlf˄\'4ld*<W\Z~~A	hɂ8XSZ8%fd<~o/Q&8~7~\n2\"mUPy[Q\'ң?\\e?^y3rR᧛ROp¥DLľH	u1\nendstream\nendobj\n47 0 obj\n1288\nendobj\n48 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 49 0 R>>stream\nxcd`ab`ddds\r~H3a!+o\n~7n(_PYQᬩ`hiiZXX(\'gT)8(t+t-(-I-ROI-K,*/d1J	+1>{VtW9V[]V:{<FZg`_tE⢼E+W.^B?QKn.74\\&퓦ϝ\"+O=_ygŪ\'6vs475(w[M9҅?Ⱦ|m3xx\0L\nendstream\nendobj\n49 0 obj\n370\nendobj\n50 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 51 0 R>>stream\nx=Q]lUcbX[hI!TO4&h@6<Mvi]hidw;33wghk)-b*Ә\Z@Hx Rドфxg5;99|(4	(6y%^:mbl+]yUŶ]CH4\rE|G|;;7|-cCA\ZZ{VBchFuː\ZZV]x<5364q7sߙ@6^lccsRt`dpx6dӲԔ-Yq,M[sivttwh\0H3%82	D8;ɻ;aWlaӡ/CK3ihLS4_V*1Jdd8r0\ZDi+vlxm/x:~x\Z..KsȸjF=g\Z<opb&K×Cm\0:pxRH\\muWu4?;c0%&\ZyzBśad*=[oqq}3ر󧣥X)eN\nd\\)?l\'P;/%>z}d\0-a+Ta+\'&ON(;qWT#:Uk+ޣ}LT짍װK|k\\?/0{	w|O&ǒIYfL%EQX)GuG3^p\n|jbjjr+	0N!`li/4_FG?f<чv¿68\nendstream\nendobj\n51 0 obj\n812\nendobj\n52 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 53 0 R>>stream\nxWyTSwH+jm^X7\".Ūk  YDV!		bY\\@YTTܰj]h`bca<j3;9g受s^<dC$ih}gc}_\0X՛j[05q@t[U\Z/	\n;Nu8%\\,E8zp!q,g;H$vGe3]1rC\Z E1n}|4 R,HD~S͜;o~hy)A\"&b	Fl&܉O5b-A$6[1N FxMcwK&(xAț6N6͂% r	BP\'\n\':oؽmgwwps?zh+M^B\"G\n\Z;yL5d>f[;|Ӓ\nV@r+X|L6\"Y`]T-TJI ITKKf5A&(3S2&1x*I/оSYzBy4\"P\'R\'\\]QcIiׂTe	g>op9-|ַM$\ZԅP0v%Ji͏B<Ii+n氎ک5jіgB+i|k̡_<y{#I/>9+y24fX	Llf\\\"DQJ!˕UGQ3p̼w\r/TJ	=msϠhKEgղ|ȇN7ݨ[`U\n;(<TFr`qb$?\ZըifhӧJB*DY^ @DKsg7}TSL(\n-ѻW۾h8\r3xhM2nfZթymwxP퍕Tn7F5F5/ahm<f8|p,J\\\0\ZPjA3M։fu2tPvb@LUFՆ^\Z\rF6h4ble{~ho#`ˬULsF4?Jzb_qe]4-#yeF?FnnQ<cϛ[m?kG2\rEC^We䦦ejI{䵡mKHg|4Q%QENjH;rc/@SPjMB2Dӑ=5E\"9y%s۵EY5<㨕`*~WEVG{֞h5cJm7Ikc-Py҃D2(4zWMP^N2R\ZT;F!_W4>aUT/3P=dJtU%ft20r,\\;kK˹҃׺rȃ~b5QiѺ9jHNbAssLJ⨊Vrd)T=L\n&C⤨?MfU5@\'BZ<GQ{ 07+-(ikVx94ݾ~2*,(ϥ8*getЇ+\Z#\"oLf%CzŐWɑ;xK6\ZLWG\r1҂ȿvfrNd$K\ZU!ob;[(IP;|W+~\"W=\"HdFkSme2KX)؃W<7N@)?m*>9G9\ZK6	w-mh8ig~B5U?3wzG]gxq=OvVI{*uMr4\\Uek~5Ч;PjzE{kp69s1#jYr;/R h-e]Z+wU{ZM4++_OPWЫ!Cb;Eҭ#<\">u\\Y?x7}xu?Xe)Yxg@tO	ۯ@9d6&8])ܭQ1a~bctCH,ONSG)@Oq*9yAv+95h\ZfgkC/y+&>3\'Xx]=+-8J棟F|l!&0?)4UV\r\0<!\nI]*32h6`ۈ<˶>3Ȟ~\\EVZ\0-e ffVGCg+.\"! XYYg*)b7;DFGwrO`#,5#-c1,MKZ>:>.s㓚_}\ZKM&\\6\"t\n龿ZVG3|v>)eS,~[<[,\'ޑIxVl%WLgaa8=z~è٪W/-W(VR))!=Ս\Z	kh\Z^҈y,ҹs7ejJkb\rh2Y㭫nۤe|qxVXG\n\"Jd⊉lB$LȪx /._>l\rg2},|h~G/uг=u\'/MtPZ.	a+/ڀ~PfGxLI|jZ\riIӀN:\0؁e^G\ZMb*?ʅ|G+sM]m;\ZC_/-(b*EsehBʂR	л+LM%ҿn_PLF5dH*g53@<;HR_.R$R&poʂ\\uкzKLYd4Ws\0\r9\Z,&}c<Qx\0_eAG]̊ :0AUg6՜o{qx$F4)Ac9ϰ\Zf<!%ZqR\0JD<+mlyފ@}ֵSY5~57KՍIPkԐr(zZQq$=dK 7җ;>=lőŶK$WmB%7ɏÆf\0N}H9Hfx˩VGHUNKXlkfW8_T{y1[]bm:;\'8QĶQ~@DjEVΜ29Og7yqq1=ͼ@i8~q~-\"~tiey4	/WAͣ^ٲjƝrv&1PuQSa^ϒV^ypԥ:gnx\'u?XP3UXSY-<>z\0ѕ:T}#$EFlm&ƣ\'3cMe,f>fxî(@/S#5\"X喝Rv+C\'nlBȎ^/7^poꠈ\rfJ`+ 0)bcP\r1.7C(@\n)]`n-S}W	\nendstream\nendobj\n53 0 obj\n3558\nendobj\n54 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 55 0 R>>stream\nxcd`ab`dddw\r44\01H3a!;%k\n~n._PYQᬩ`hiiZXX(\'gT)8(t+@lu-(-I-ROI-KMj+I,````4c`b`bdd|?ڙr8cRV?aZ:%[&͜:qr|/d-0}3n9.<g00\0\0fZ\nendstream\nendobj\n55 0 obj\n262\nendobj\n56 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 57 0 R>>stream\nx}{lSuw.0@uTGoyaC6!%lH\"\Z*{Ji7ڵz{}l]Q[h\0MF\"E20!cb<Q~|{~IO#ðE%%kxI%fǴ{C9uip*=ETS\"zS\nn~E˖u5S\nCVrm0n4_VWR{te=Pgf^+1LEֿQL2#ϑE$N!%dY|V6!}d#r_lq|+(1\rv\r5#~Çp.dowxa\0¡@{ xz`傣ezasDG0G+F#]v_*y%?=b[hl}@ZB#x4$_²+jg\\\0>X\Z,@5f2\'XWi8al11\0QW\0B7@]s	}wiX%O+\ru$wq +[Kd^[XI>ΌJ^O%ve32\n\Z*P\'t>s{}7!Eඉ&vEuz:tgx\rc&N/^mZOӍw U +9~[W͊|dфk173WXSOI=.Gg~k1;haeK)Cq4W͔icS9\rYxW\Zװs s}%:-9~h\\r.{RjzH1_<\0\\vJu^Adhwq8U6;YW\'q?$Gp5~V!$EI^K罽ꕲf^\rv6y	x$9QwwʁS4Yj;mҢ^n9:횞]w5}.ǫJߐL?d[.Cr$W\\7M7\'x$;XľD[$x8G;рV>_x5!W(Ի:=G/zu`\'S}u*Me|Y:G<i{Y4[:||n5|-FC0K2\'~?I;1]˚0\"/\nendstream\nendobj\n57 0 obj\n1206\nendobj\n58 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 59 0 R>>stream\nxT{Pu`YNv+C\'|`JR\"Sf	\'Rݻ(xc:eik1%98YǌnPk&鏝ٝ> Д+?\"=4\nY!;#YϢϠ9ь)SN)**[oE%$%Ksuنlؠ,f7lЭ(խЗK%\\}I!EQl)/Jͤi+ԫT5zKM\"tPj>*hTu1xOtoZ[IP&gqnZnd-Nk}\0vjI2	z46z%8X9G-X)T}\nzK\01Bm:4@lfŕi\Z\n#!Aw}R5\\anh瑟AQ\n{>L0fNp`*\'~;@lEjf:\r˚-+@4k{ykj@d	@~@̝3qOHO1>M_/(bIE5\n፸\Z\'0Lk:0ߺv*6а05#5s٦E}bt?$_?$b6G7zrS?P}8}?\nۦz#yryEţ`<3n{K\\k&aG#O*8/\\ 	O06U\'} \\Idߣ3\ZȠi/\rx|?NS#IJ9BnR%T+v\\<:;Pqjnż<~է4%|ֵ@ hd2+AsIXDn	^\'\rӟ 4;sKPg.E]\0:,&ŹA!.L<11dq_E1H0D[1U1=C:Q\n%U6U<>aqc[ƭ,ؠ<Cibeo̅ͅes5Bs(Aʢh[7۸wU2\'Q#YlB1/[\'sI\n0\"\0BGE$PK.T˱% L>rQEgU~Y5u]BF9Co\r9T͏1m\\B̌XՍlsn\\${YZE;fĕDis9%}sd_隣D~$`hʙVSSk6~bY8s[X8;͒eniap\'v).,x~g^Wx8E!\nendstream\nendobj\n59 0 obj\n1362\nendobj\n60 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 61 0 R>>stream\nxcd`ab`dddu\r21H3a!G&u?\n~*_PYQᬩ`hiiZXX(\'gT)8(t+t-(-I-ROI-c```4d`dbb`add?U|V3[+x>w?~foݨ{]M<1}r}߆_~Ѽ\'NC5je߾~QE}GS[kOjv/~ktn7Nm]WWw+G[_[~\r4)Y{ӏZ+ۻs<Uӻ9Rؗv>O/{Vw\\B\nۡ݇fvM	*3-iYNƾ|Փxxe`\0\0}Y\nendstream\nendobj\n61 0 obj\n434\nendobj\n62 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 63 0 R>>stream\nxWiTS!@%Գ7mmš*-UqE2 )ʐM\0dNa0  \"JjzZNj7Q{{sZ{%yD\r%$Vsjd#fc8dvkx͑8aA硔X$Zb˂ȨX\'\\̙4?<P=/i_lH`_C>2`{`ld2:1Nc;=(EliU@yEQ\"\"\n\\H$v\"c/yw&Ou6}{ZC-R);zZBMR(jLyR˩\r\nj&ZEQ\0j eO9PCa#%S#1G9PP4U& ҈$EbFNv8`#20iσU\rvkpXr08tq>gaaXoUo6CSXvˢ0o-[uC[UGhb!t\n-#͚Dn:=mIhWgA֨&(tf: @n8PD#w%RxD.^e\\#0U%q]ޭ\'/=[	UM̤lkUn!G|nv誡\nNjb*+_.xsGn69z\ZnY֘\\\Zw7\\H/?J;En7Q{44a&Mx__貸*}避mB(2AG\"&/O	f#8gh=wA;XTJeQTs[0z=602Pʑh!(|\nGQ8w`T(}\"6Ҩh2bP$Џe4+3Ӌ_h2މ7FVy!OX\"%3h%~@21|!*Pt,@|1P}\'4@kٻ Ԑ8s,j,sjĘ;ݳ_|(^SPi5Q5yuPkB[5o)ӵ4ˤ#R` T`df:Ba.Jͥ!!8h*79tcopek;k;tbG͞o\r=a+`p/?!	\">zड़4/%jO骠\Z:\'+z9	t-q\'k#χ)cgFc(.߫KߣN۫CƺnbO@42Z2i>M`\rz:w\"},n*:e0WIr12?@q-#cЅtb9]iK>nE#kf+q-qQ߶M?fq+(Bۮ߉qe,3\'fCj1LlI\\um)~âY^kr%r6]\r68b;Fjof?(n1{Kdr\'jyK?,śL.M\\0U|?J(!<cD®ＬRҏ6_Je_ROWc8\ZGwсFǩ4q)D\ZeuuZ_ॾɜ*Є}-*_ݪ@p9wݮ4\Z!\'q;WTkM||b4aIr~oJld\00ιlsdWv6+ƃel(3ҕ$TmI2L^Cci+)!Bi/\nqk|!Yp/\Z;6pja\ra:ȂR=R5?F[pxmxm!FKIt0xRp8,\'K;d\'8L}y\\)GuCrfn\r^ ?s!XO=`!:}s!6亦_wgNf?0^qJ>=>,C@bŵN{4\Z-+bON2Bz֘qc\',`6>m<*df&d$Zmy9Ӂ1At|hݶ\\\\Fzu}sZnMLi	c\n!BB2]\r)8U=\ZH(t}HIdI{2Nkmn*|o6hWr[CQ\n=͖̎gZf	lp@0y[̣ݜA\Zu8,dduLe[\"li<tɠ*2\r<~RF6tQd5E?3\n|꓃֮~oqz4z/8$VzLĕrfNF-ɐ)j.]=h!d-{Bze{,.f҄7DN۩<eͼI[\'7DQQhsPZ9B\Zo5BW..dRu쌶S~b\Zd\nSqҙ5r--1ϫr_1Z$Wp\\\\q}ddB\\3g|v\'l[SQS[[Yi}ͥw\01&Q	s` ޓ{}(\'\n;gD(6dbC\\LҒ3>OE\0\r(:[*iCQYV@rA78t?*\rB̵$-36WQzK*GDkHhܖ|$XV(̞nTU3	׬Ws/@VZ/Y^ϼBH;q.gtkOL`MӫFCcwO[n/FHw*WlV@_0O4ehƱlhhm͛K3gײp}bUMjzGZۦArjjeüP~r.eѓlp֛8g@|?\\lwEoYb`w_+#Ro<ta\0qŞ/h6&nr7z%3I	;mAIs+4FWVgR!&ʘ&!MfBӯ<$z91\"K,%1A(vp+/1LHrM\n[v- dqVd=n\r`Oii*P\'?9%ӁD\n])BpW1iY\rphppQKJXV\"r@믑]\ZX_nUqc(9\'*21\Z)s_Nv=NJai5\\䋗Y~=ˏ~Sk-rtWxe=v脯Gξ_3$\\fZSp>ЕY䙄FWBsz+a,QH.[H@&QШ/;],jtA£NU1}t*ŅI\Z2a\Z\n]TM3\'x_S}v\']B K%=Oq*r;(\\\'niOBfijШ;s{s*xPRh_(-bVsI8O>39s\n3F/dnL?3k\ZkzcI/H]|pIQG[䚽u*դj`7#S*s;*Ѵd<ymqOBt1Qdko\ZF{HqmlMn[Vd,9|Ļd8#LyD(}i?M[8D+!|ZqB\\fZ%a+M5	R{0,& ͚fqa|Xtq^|ߏx+b$}$\ZIu)FH~<{7v~\0c_:\nendstream\nendobj\n63 0 obj\n4035\nendobj\n20 0 obj\n<</BaseFont/YWRBPR+CMMI5/FontDescriptor 19 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 1036 1037 996 0 0 0 0 0 0 0 0 0 0 0 0\n875]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n18 0 obj\n<</BaseFont/SZBQCB+CMSY6/FontDescriptor 17 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n963 380 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1222]\n/Encoding 64 0 R/Subtype/Type1>>\nendobj\n64 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n16 0 obj\n<</BaseFont/MUQRQK+CMMI6/FontDescriptor 15 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 924 927 884 998 900 0 0 0 0 0 0 0 0 0 0\n780 0 0 757]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n14 0 obj\n<</BaseFont/EFYKBB+CMMI9/FontDescriptor 13 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 771 778 734 848 756 656 0 0 0 0 0 0 0 0 0\n0 0 0 628]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n12 0 obj\n<</BaseFont/SZBQCB+CMSY9/FontDescriptor 11 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n799 285 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1028]\n/Encoding 65 0 R/Subtype/Type1>>\nendobj\n65 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n10 0 obj\n<</BaseFont/YAUXEU+TeX-cmex9/FontDescriptor 9 0 R/Type/Font\n/FirstChar 16/LastChar 33/Widths[\n614 614 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n814 814]\n/Encoding 66 0 R/Subtype/Type1>>\nendobj\n66 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n16/quotedblleft/quotedblright]>>\nendobj\n8 0 obj\n<</BaseFont/GHNQRB+CMR9/FontDescriptor 7 0 R/Type/Font\n/FirstChar 12/LastChar 121/Widths[ 571 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 400 400 0 0 285 0 0 0\n514 514 514 514 514 514 514 514 514 514 0 0 0 799 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 642 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 514 571 457 571 457 0 514 571 285 0 0 285 856 571 514\n571 0 402 405 400 0 0 0 0 542]\n/Encoding 67 0 R/Subtype/Type1>>\nendobj\n67 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n12/fi]>>\nendobj\n38 0 obj\n<</BaseFont/GKKKKC+CMSY10/FontDescriptor 37 0 R/Type/Font\n/FirstChar 54/LastChar 54/Widths[ 0]\n/Encoding 68 0 R/Subtype/Type1>>\nendobj\n68 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n54/negationslash]>>\nendobj\n36 0 obj\n<</BaseFont/WSXSQF+CMMI7/FontDescriptor 35 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 859 863 819 934 839 725 0 0 0 0 0 0 0 0 0\n727]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n34 0 obj\n<</BaseFont/GCFFPC+CMMI10/FontDescriptor 33 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 750 759 715 828 738 643 0 0 0 0 0 0 0 0 0\n642 0 0 613]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n28 0 obj\n<</BaseFont/EMLRVG+CMR6/FontDescriptor 27 0 R/Type/Font\n/FirstChar 40/LastChar 49/Widths[ 481 481 0 0 0 0 0 0\n0 611]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n22 0 obj\n<</BaseFont/QYXKNE+CMR10/FontDescriptor 21 0 R/Type/Font\n/FirstChar 40/LastChar 121/Widths[ 389 389 0 0 278 333 278 0\n500 500 500 500 0 0 500 0 0 0 278 0 0 778 0 0\n0 0 0 0 764 681 0 785 0 0 0 0 0 0 750 0\n0 778 0 0 722 0 0 0 0 0 0 0 0 0 0 0\n0 500 556 444 556 444 306 500 556 278 306 0 278 833 556 500\n556 0 392 394 389 556 528 0 0 528]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n19 0 obj\n<</Type/FontDescriptor/FontName/YWRBPR+CMMI5/FontBBox[0 -22 975 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 146\n/MissingWidth 333\n/CharSet(/A/B/C/P)/FontFile3 40 0 R>>\nendobj\n17 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY6/FontBBox[0 0 1128 432]/Flags 4\n/Ascent 432\n/CapHeight 432\n/Descent 0\n/ItalicAngle 0\n/StemV 169\n/CharSet(/arrowright/minus/periodcentered)/FontFile3 42 0 R>>\nendobj\n15 0 obj\n<</Type/FontDescriptor/FontName/MUQRQK+CMMI6/FontBBox[0 -21 944 714]/Flags 4\n/Ascent 714\n/CapHeight 714\n/Descent -21\n/ItalicAngle 0\n/StemV 141\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/S)/FontFile3 44 0 R>>\nendobj\n13 0 obj\n<</Type/FontDescriptor/FontName/EFYKBB+CMMI9/FontBBox[0 -22 823 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 123\n/MissingWidth 333\n/CharSet(/A/B/C/D/E/F/S)/FontFile3 46 0 R>>\nendobj\n11 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY9/FontBBox[0 0 970 430]/Flags 4\n/Ascent 430\n/CapHeight 430\n/Descent 0\n/ItalicAngle 0\n/StemV 145\n/CharSet(/arrowright/minus/periodcentered)/FontFile3 48 0 R>>\nendobj\n9 0 obj\n<</Type/FontDescriptor/FontName/YAUXEU+TeX-cmex9/FontBBox[0 -2957 781 45]/Flags 4\n/Ascent 45\n/CapHeight 45\n/Descent -2957\n/ItalicAngle 0\n/StemV 117\n/MissingWidth 250\n/CharSet(/quotedblleft/quotedblright/exclam/space)/FontFile3 50 0 R>>\nendobj\n7 0 obj\n<</Type/FontDescriptor/FontName/GHNQRB+CMR9/FontBBox[0 -249 833 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -249\n/ItalicAngle 0\n/StemV 124\n/MissingWidth 342\n/CharSet(/L/y/n/c/parenleft/three/o/four/d/parenright/p/e/five/six/fi/r/g/comma/seven/s/h/eight/t/i/nine/zero/l/a/one/equal/m/b/two)/FontFile3 52 0 R>>\nendobj\n37 0 obj\n<</Type/FontDescriptor/FontName/GKKKKC+CMSY10/FontBBox[0 -216 638 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -216\n/ItalicAngle 0\n/StemV 95\n/CharSet(/negationslash)/FontFile3 54 0 R>>\nendobj\n35 0 obj\n<</Type/FontDescriptor/FontName/WSXSQF+CMMI7/FontBBox[0 -20 893 713]/Flags 4\n/Ascent 713\n/CapHeight 713\n/Descent -20\n/ItalicAngle 0\n/StemV 133\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F)/FontFile3 56 0 R>>\nendobj\n33 0 obj\n<</Type/FontDescriptor/FontName/GCFFPC+CMMI10/FontBBox[0 -22 804 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 120\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F/S)/FontFile3 58 0 R>>\nendobj\n27 0 obj\n<</Type/FontDescriptor/FontName/EMLRVG+CMR6/FontBBox[0 -250 505 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 75\n/MissingWidth 416\n/CharSet(/parenleft/parenright/one)/FontFile3 60 0 R>>\nendobj\n21 0 obj\n<</Type/FontDescriptor/FontName/QYXKNE+CMR10/FontBBox[-40 -250 813 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 121\n/MissingWidth 333\n/CharSet(/y/n/c/parenleft/three/o/d/parenright/N/p/e/D/f/E/six/r/g/comma/Q/s/h/hyphen/G/t/i/period/u/colon/j/T/v/zero/l/a/one/equal/m/b/two)/FontFile3 62 0 R>>\nendobj\n2 0 obj\n<</Producer(ESP Ghostscript 815.01)\n/CreationDate(D:20060626235930)\n/ModDate(D:20060626235930)\n/Creator(dvips\\(k\\) 5.95a Copyright 2005 Radical Eye Software)\n/Title(proof1.dvi)>>endobj\nxref\n0 69\n0000000000 65535 f \n0000006062 00000 n \n0000029628 00000 n \n0000005989 00000 n \n0000005533 00000 n \n0000000015 00000 n \n0000002468 00000 n \n0000028076 00000 n \n0000025016 00000 n \n0000027825 00000 n \n0000024720 00000 n \n0000027608 00000 n \n0000024390 00000 n \n0000027387 00000 n \n0000024188 00000 n \n0000027166 00000 n \n0000023986 00000 n \n0000026948 00000 n \n0000023656 00000 n \n0000026733 00000 n \n0000023464 00000 n \n0000029287 00000 n \n0000026340 00000 n \n0000006110 00000 n \n0000005684 00000 n \n0000002488 00000 n \n0000003823 00000 n \n0000029055 00000 n \n0000026165 00000 n \n0000006217 00000 n \n0000005837 00000 n \n0000003844 00000 n \n0000005512 00000 n \n0000028831 00000 n \n0000025960 00000 n \n0000028610 00000 n \n0000025764 00000 n \n0000028405 00000 n \n0000025525 00000 n \n0000006335 00000 n \n0000006400 00000 n \n0000007338 00000 n \n0000007358 00000 n \n0000007807 00000 n \n0000007827 00000 n \n0000009157 00000 n \n0000009178 00000 n \n0000010552 00000 n \n0000010573 00000 n \n0000011029 00000 n \n0000011049 00000 n \n0000011947 00000 n \n0000011967 00000 n \n0000015611 00000 n \n0000015632 00000 n \n0000015980 00000 n \n0000016000 00000 n \n0000017292 00000 n \n0000017313 00000 n \n0000018761 00000 n \n0000018782 00000 n \n0000019302 00000 n \n0000019322 00000 n \n0000023443 00000 n \n0000023871 00000 n \n0000024605 00000 n \n0000024908 00000 n \n0000025441 00000 n \n0000025669 00000 n \ntrailer\n<< /Size 69 /Root 1 0 R /Info 2 0 R\n/ID [(;ʀAF:)(;ʀAF:)]\n>>\nstartxref\n29821\n%%EOF\n','Proved','BZh91AY&SYGN\0tcg``!O\\;F)%)U5\0R2l	JHJ\0)hڈ	 d\0\0\0\0\0@\0\0L\0\0\0\0\0\0\02dшi4ɈM\Zi0(\0h@hd\0a5*QGfFI OI\Z$U=)\0\Z4\0\0ɡ\0\0\0~I%ZIPC*\nVVb)a\rJJ!%6J!!U~Psi*٩U$$GaXѶ&B\n䢉(BXSOҞW8}Qq]\\!|{@GU.*	9QwP^HQ<!!Tբ1L\" Rˈ:nVcVc*[lmD+-!DPSiD(R4J^wIUUS;_fFF36-aVʶͪkEmҶl҂RK!/_uøԶ-ZYZiSeQWT˫!_EDItl/ y%ci&j(pKQ1JX)\r1,ٳ.RS4&D(IdCpR)Q6\\\0SJѣdA6p2NXs&A;#cʊtQ_QU~0}Ĉ}BT/+C_X}uҝ\ntJD\nGW֬hV٣22V\ZYMhic&,d\ZJR5}yXegj3>\'(LT3<a4ʃK_*JEB(a+\nY\'F[\Z>|@|JXm*u!Bv@@sNd<5*\\h8Tof&!48T5C\\gዏv;8S\Z}>;\\MM#2x9G\0$Fc.MF\'hEm\r!xxYkaтa3R(t&eL6z̻YXa-fƫWJ^rRr4(#f\rUs1@ى;\0YU&U26djhj̊2$V5554eM8Z5/~mh@!Ҫݑ6E=0Wi85ʑ2Ŕ0j+jJg\rc)m**a6GU]&3\ZRjL:Ξo=<T9uڬe,@	JmwGϼcNŦ5LmcVEdƖɶ,5P$UD@$EU,̢$KSU\0>4KdlZUج\rf5)2z51mj3Wi32mRmQS55ZmFSckVi4_\0TU]$Q^TRyJ**򤼃_E|T C!}\"NTJUO}+3/yף:ҥuT\nyyzEUrTT8WWIڝ]iڮN79\\θ\0\\:JҋpNֺq\'\\><}G\\zg>OG¯jOg=Ɜ}yh}>P>WZwU\\%q\\\\:΋pqDUK.D}C佞CJwU*qpˢwuI׽s[u>Z׳W/|||N!(*	\'*{OPP]4C%]~КK\0\nJl]XYlɬZɥbSb5Xb[RՒlԊ8xXOQAB&6M5$)mۀB\nTb8YX6`\Z lͦ5R!Jh*\Z(FYh*0@\Z,0b#35M,&MѩaLLUj6i-Sj&9NTƵUaYݚQ\ZmHWą(>B4LU4ґRmМ>d*/:Ak36iveW#9)I=h,t @0Șcv˓/cE5hyH:CT:ǃ$\\\n\rt2x3\'k/<LO*WQo+x\r*q`<t\n$BFR\Z!1fm!b.am42ib&e]JcP\\\rdcMҚЙ2SY+e3Fuu*w\nDT4%I \r14RDE4,l6\rB]Ƒ		(0TД+\'\'[zM	mPǸ=EBGEAF`H_,*΀=)ChlǝYQփ*Hg!Z5w\0)8<>8^ӦFtfa-9qp*xFLKt4DURa\r\\M3H^C ˘}<CPޑ>@j!a/ti>a\Z[C4+W45`ɰcH+ 䁍P	qeƋ\"rGZ!j&VMV-fvcGD1S-8re)|T	5?]\r&W-wn1u౑JDC!I\r\r*1P+!袕H\nfaz4%j݊9s	 ЭXywzױDg`N\Z`(^1	R3zZǃvG{Xf[GT!鄔\nPbEX$WDFʈ-lWɦ1ݍddt4\rv\\C.buMS`Ei`AֺUѶMGHi x)i0xsDpw\Z$l4ڤVdAc0ԴA@%6T2Fs\ZXWF#@%Y4e#, 9O:V)Z[%[Tr;we;&#GDXSfj/+JY$`/U!1Jtl&SadY\"l96LPJ4RH\"GtR2ҶUplJr:8,\\*4$*T\\0x!tuH!5EGZ=uu+u)y\\mּ\0NF_*ʸGyW9J!*%ъ0` BIPĺT2LTP\'%\Z9H0	LTe)\r*VhȦ)CJW4\n ,sWu?ξwsC]r)Zҭ}on}TZÏReVhbml!@Ūjm\Z`-@)CZ)\n䷸!!쨈{+OK?;~q@{?eDCu\nwjm!֝noEWE._UIoz^bR|Nޘt/]*o>:\"^1\"sk\\:OuΠEWkII+CC\"!\"ІKPFԉ0D\r(\n+$CIC(AjBҰUtʃOjg5dե\\}B<\Z!8|Qw^뢮w|r`jեSd5\"mJPmI&6jUe+FQ5m1fM\rM!ZQWE/rZjvqSz;\\/󿷥TGK!xQPt! CϔqtUmxQD:G:{\n#ZELB4\n\n00\r	{DڝQvEr9m\'+Q7U9G-Ht;]\\2ogX1J	\0ؾ~/zz`wOtxxtII+rڠ!TJ*j]*\"II+KtG؊5[R~r\"\0w(\"h\'zRJ$IOOCԥU!BE,Y$҉$C!X(V\09=0{fV&)/-ƶmSk4TG]4wqNU\\ =Ou$HʟKC_*dG;@e5sg\0FrHK\0H\0\0\0\nD*L\0LL&4L\0LL&4L\0LL&4\04\0\r\0CA\0\0\"`a&4\04H2hƓ\nII@j4jg2M\0z\0~<h(URhI\r,eG\\j̒Ɗ!i,42LKH[\0mJmIV*\" \"fj@nHT,~=o|\0\0(WSJ&\'S6?\'NL2p:Y+]ej,س-Ƥ+alm5\\w鐗٪R|_$yVQ+d>TQXTb74M%Fr%uI%c>^~r^ۋߧ^yo^wgl;+R_B$C$WЪ\"7}TA{Пl\'ժ1c-Zն3f0fC&-Le\ZShɉkQjL̍2Y2adh~)~\nv[\Z5LFbLLd\Z2M-\rEI~)W%ԩE֔1%6%Eg+KB%\'Ј}iUS}{{/\ZR^(OG\r\ZCJH5VvAm7IGÍ)ʨC+cfհCa6$R֓T-RkV[қȷ9!\n_ĿT~3?K_W>5eyv;ǁC{utM\r\rD^6궶cjc7g02vO7Pk,Y,vڵMG\Z\"5i6k.s.:wk-1Qըf۶;9<*Ѽ[Yj4cLY4CqnG\Z:fcpTxG=Rv67m.ҜO7WrG(NtFZls<Z9f\Z2amv7,Suèi5jk,L5j5<ݳF%ֆqIgcj6VCCdU+I26Lٷ;&C`F22Gj9*)9\rDֲ!d1.Q+\ZT=\\CE|^\'7l|e=Ҧ2WiQe**N)_EoɞP&/UQ^wU$oԟZ{Ϩ6>U\'cҖYy=*N9yu~Rjs8R܇+dX:qKUhI\'sD7x4|SVSy	_8OX#u0f{z+&Og=\'͇Ƣ3IqORI0ɭ%HZVԬU-\nBVJMRDEb#*d1\rj6hO4ܞL7G&cF|9̙ >\nF}?bWc)^dlږ^)+3p2\n%8R$̚L٘-{V0AjMAiFBd5R>G>JW0ß|	_49RÂI$<[VoB\n)QaτiK\'Jޗ@TRx5iIR3rRʥj0$(J褩KՍ׬y2bKTvjX%w9JΒh;Zd$xH)M\"jSJai/1Q}R+`B<{I_5~ܩ|_Q31aKm6i+%uqU,;BTآ[$\n]tTz\\Hk%ygH\njd@'),(20,'point A 30 32\r\npoint B 40 40\r\npoint C 48 28\r\npoint D 40 25\r\n\r\ncmark_lt A\r\ncmark_t B\r\ncmark_rt C\r\ncmark_rb D\r\n\r\n% point L\r\nline AB A B\r\nline CD C D\r\nintersec L AB CD\r\ncmark_b L\r\n\r\n% point K\r\nline AD A D\r\nline BC B C\r\nintersec K AD BC\r\ncmark_b K\r\n\r\n% point F\r\nline BD B D\r\nline KL K L\r\nintersec F BD KL\r\ncmark_b F\r\n\r\n% point G\r\nline AC A C\r\nintersec G AC KL\r\ncmark_b G\r\n\r\ndrawsegment B L\r\ndrawsegment C L\r\ndrawsegment A K\r\ndrawsegment B K\r\ndrawsegment B F\r\ndrawsegment A G\r\ndrawsegment L G\r\n\r\nprove { equal { sratio L F K F } { sratio L G G K }  }','<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE figure SYSTEM \"GeoCons.dtd\">\n<?xml-stylesheet href=\"GeoConsNL.xsl\" type=\"text/xsl\"?>\n\n<figure>\n	<define>\n		<fixed_point x=\"30.000000\" y=\"32.000000\">A</fixed_point>\n		<fixed_point x=\"40.000000\" y=\"40.000000\">B</fixed_point>\n		<fixed_point x=\"48.000000\" y=\"28.000000\">C</fixed_point>\n		<fixed_point x=\"40.000000\" y=\"25.000000\">D</fixed_point>\n	</define>\n\n	<labels>\n		<point_label direction=\"135\"><point>A</point></point_label>\n		<point_label direction=\"90\"><point>B</point></point_label>\n		<point_label direction=\"45\"><point>C</point></point_label>\n		<point_label direction=\"315\"><point>D</point></point_label>\n	</labels>\n\n	<construct>\n		<ruler><new_line>AB</new_line><point>A</point><point>B</point></ruler>\n		<ruler><new_line>CD</new_line><point>C</point><point>D</point></ruler>\n		<intersection><new_point>L</new_point><line>AB</line><line>CD</line></intersection>\n	</construct>\n\n	<labels>\n		<point_label direction=\"270\"><point>L</point></point_label>\n	</labels>\n\n	<construct>\n		<ruler><new_line>AD</new_line><point>A</point><point>D</point></ruler>\n		<ruler><new_line>BC</new_line><point>B</point><point>C</point></ruler>\n		<intersection><new_point>K</new_point><line>AD</line><line>BC</line></intersection>\n	</construct>\n\n	<labels>\n		<point_label direction=\"270\"><point>K</point></point_label>\n	</labels>\n\n	<construct>\n		<ruler><new_line>BD</new_line><point>B</point><point>D</point></ruler>\n		<ruler><new_line>KL</new_line><point>K</point><point>L</point></ruler>\n		<intersection><new_point>F</new_point><line>BD</line><line>KL</line></intersection>\n	</construct>\n\n	<labels>\n		<point_label direction=\"270\"><point>F</point></point_label>\n	</labels>\n\n	<construct>\n		<ruler><new_line>AC</new_line><point>A</point><point>C</point></ruler>\n		<intersection><new_point>G</new_point><line>AC</line><line>KL</line></intersection>\n	</construct>\n\n	<labels>\n		<point_label direction=\"270\"><point>G</point></point_label>\n	</labels>\n\n	<draw>\n		<segment><point>B</point><point>L</point></segment>\n		<segment><point>C</point><point>L</point></segment>\n		<segment><point>A</point><point>K</point></segment>\n		<segment><point>B</point><point>K</point></segment>\n		<segment><point>B</point><point>F</point></segment>\n		<segment><point>A</point><point>G</point></segment>\n		<segment><point>L</point><point>G</point></segment>\n	</draw>\n\n	<conjecture>\n		<prove proof_level=\"1\" proof_limit=\"10000\">\n			<equality>\n				<expression>\n					<segment_ratio><segment><point>L</point><point>F</point></segment><segment><point>K</point><point>F</point></segment></segment_ratio>\n				</expression>\n				<expression>\n					<segment_ratio><segment><point>L</point><point>G</point></segment><segment><point>G</point><point>K</point></segment></segment_ratio>\n				</expression>\n			</equality>\n		</prove>\n	</conjecture>\n\n</figure>','2006-04-06',2,1,'GEO0003','%PDF-1.2\n%쏢\n5 0 obj\n<</Length 6 0 R/Filter /FlateDecode>>\nstream\nxMu[#ERX\"$k#|@>6a$~?zwAP`G̬}H\Zu?_ڥ6jݛ\"˚&	;?IRX(-QsjmʶjoQθ~\rq\nuR7?.	bN 1#ڑdOx\'oR9	Ȩ߶_VX/#X׻7lr\Z?;Flѫǻiߗo_WOď{FWVZYA$tfWcn\n\rX+A0kV/uU?ړ \")|ߛ\\LO#Y\\Jhm\04Llp;i\"|};ɱ3z!fQ_8r.pasvvֈMÜ-|O\nho0]ڇǩs\n=utM\'!4:h1Ս%T~9[=j M9FkA9B>(	Sq9\r޴oX\ZV~K\\`{-5;{q/1RFҮ]&+*Y7w=%fy1ҵFvj/\rf9ZlgJ<3%3k]yfJdiL$SyI|\'v~ntT\'R`iy@Q]CyhAzEudIptYv&̤eLDR{&L\"\ruUGώ/#=~pJu~0X\'\r2./poq\0O}wu\rk4䵞2 z9L\"yöDَgnWJc.@a\ZH21WdIϋL=]#\n[K̥2,_0vͧ;S=;(KaxRY7VvXȩ.W\rƴ/32犳3=fSD6g;N1\r)Hh`px8+̝ju9u-\\Z~4Ak)\":qjpOP)禍ޜWD\ZZD~kOh1\rKuvUsk74\'אލ	\nvN4Xy{n<v!~r?!+>uy ?oGf06aeBtƄ0G!5MiZj^Vjhkgs\rxDuFӓԼ\Z{\Z`P%c CfK5<yׯ,az[+-ծf4rAaW3z^z]CQu|H?\r!:):,Q>mSȨ6l/,냰j	;!nO6w\ru#Uy`yIt$6\\X{V)VBHA𻒋;W/q1ҴcE9U\"\"C#{Rփ:,xNM9ϣFgWsc{\Z+:HU1\\QhU%r\0,\ZXJ\0xVڡeC.DEʁ|\r,Xh*5W8&67f		A?b\'X$gYht\rhjxNս>fx._`jbqَ\\ɃQ)͖:HsPrNVRS1]rulE\"${]SˊECYHyvm|h\"TPG`I!%KWVc)`1,Ļ)Gv4{7d$SI2_P	M<XM>R(q֬HHv2|,++x`8pI*H\npEn^jw*W%WǓW]g~MZ\'o\'m)0SXz(؎EJ9U;}X;?ޑX{.5|~Εy-+zl5¿-ZB2hɼ=ژQU%s9\")sfsx770BavsUN^#=S|HukE\"]TdlBjET,Jz}7\"Y(Y滋y`8\n+	}q#NM^bUuV#ZuNn%ƲMIpcڅx#*wTd[$94Qr+R؍EqzNI$s\\jLH so^6ܪr&	@n2u^dREɛ;S!?윧endstream\nendobj\n6 0 obj\n2383\nendobj\n25 0 obj\n<</Length 26 0 R/Filter /FlateDecode>>\nstream\nxKoEǝ|m#aVpN@=ޱw8 [tUw~Ue4)#?UU>*ROwU7uLLlJ:`\\\r~v^U/u!s㵥`Cq\rAD!hyΰھOE\"XpS	=ju9V{zC߉ñ+2_5FA_(Nώec\\ѣig\"iy9dujW56fxש6}Vm?Q411gk9\'ꢺQ堉U$!?9ϿU}xS:Z<?:,4Iu,;F%\Z\'\r<UYG[9,qm,ixo+ዤ8٬Ӄxŭv9+HzE۽23]ȴίK QH7*EYʐbh\'uOf	\"O֯Z$!׿t߼iX!Üplo7HڗH}	lC<jl=d||ِ.8uJ߻ףp3\"!j3E\rh3{C#AKT0ȁAI]-!<\"mrqA!.OHm\"lz\\^ .4+n6i,AYqy+K,H#MrPLEzʤ(MiRs{XkRXq\Zۏ}I{@L>(싾g#bϞZYT%;G+e>i|DhY>8\Zu]x]|pI7\\KG]x{q]΀\r`+Xa{.`-Sczܻ7?=J==6GF\n@Mp_GANH	A^#*;n5Ys7Y~żcw\Zbڥ_!\n\"$Șbd!>)hW|JY8kV*nZ<z[ehʅ}L^K+HA4n\'tvZ2e9+Ȓ#{]܀\"s%ڲ-Rr	捕v(pw;=l:Ɩ0kO_,kZע00[cw[\0Y\\(e늳`d#lRvQ\rU{endstream\nendobj\n26 0 obj\n1263\nendobj\n31 0 obj\n<</Length 32 0 R/Filter /FlateDecode>>\nstream\nxZn6BRѥə-@it>$}iޤ@3Vj]خ0`ks8̐\ZW[>}]ukWY0udR퀢II:T\'??|:~]u:_T\'h}v>\\V\0lr@y:hBiQ\nؘ֚H9nXbRG7֣\r3^3\\/՟[4,0%lmސip[?yⒷ<^dD!:6;/~|b{؜/v3C?V/60v)s8jC0J&}9*oc5]Sn-_vAa4!#e9섇[b,j|_vZM7s \n~W̾-yᲉ9հL\ngaG-z=L<i1)ِ&τؼ\\L1urA^X%3,v\ryc0!ʑOc4m6j2d͓9ʔgfS9SYs0AY/O21A}P$M2Q`6^<EGؿ+Y!؏)t=U\'G_8+;TT{5\'f%g͇5A|N̍NV8Pt\ZDe\ZVAv\"vHW-;cg;}W-9wnFכ(rښcIs\\L}T9`9͹H|Ys}¢;Fչik|\'$hQSIͱ^epkp;oyn!z\\VS̼iȄg܋9Bbőnc!$Y񺤶D9A	TR\Z!S)(kд.S!OK	<{{P%#Lhh%V˕N܋e	G|urdƶhcd(Re2<2\n̮.G5C-iH鿣3:c#g	Wș07\rGeN[HGDu??E;9Vѥ	\r>\'B\\yh.CZBszʷ<\\\"2g)~}d趥hq^GϿ[ہ|tEܟ_Vdh\':yߴ[&gPQ*`r}`פ}.E]T.3;::َVߤ+[\rU8cȻda$ް\\ٔM_F]V58U\0=cӄ̀4x:K0Rd3f7+hGt7}#lT *~4H7S0:\0\Z\r)\rM\nH\n)h{.\"kQ$j?b)2tct`aP.q߭_Au\Z/TiEY\"mP12k\0&Ŗ5lyeɉLv;\n endstream\nendobj\n32 0 obj\n1596\nendobj\n4 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 23 0 R\n>>\n/Contents 5 0 R\n>>\nendobj\n24 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 29 0 R\n>>\n/Contents 25 0 R\n>>\nendobj\n30 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 0/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 39 0 R\n>>\n/Contents 31 0 R\n>>\nendobj\n3 0 obj\n<< /Type /Pages /Kids [\n4 0 R\n24 0 R\n30 0 R\n] /Count 3\n>>\nendobj\n1 0 obj\n<</Type /Catalog /Pages 3 0 R\n>>\nendobj\n23 0 obj\n<</R20\n20 0 R/R18\n18 0 R/R16\n16 0 R/R14\n14 0 R/R12\n12 0 R/R10\n10 0 R/R8\n8 0 R/R22\n22 0 R>>\nendobj\n29 0 obj\n<</R20\n20 0 R/R18\n18 0 R/R16\n16 0 R/R14\n14 0 R/R12\n12 0 R/R10\n10 0 R/R8\n8 0 R/R28\n28 0 R/R22\n22 0 R>>\nendobj\n39 0 obj\n<</R38\n38 0 R/R36\n36 0 R/R34\n34 0 R/R22\n22 0 R>>\nendobj\n40 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 41 0 R>>stream\nxM_lSu@S2콈P,e6&aFc5nOGtsoe[Ww?keQ		iQ7ʣ	#ӻ_y+/?9!fa;{j$Si2UbO}}</>;0=Cz|R}{߾RrJ=AHRWbXri}nts<MvgnRg#dq1t~qEfve,Wr-V_bؔ!\Z	M#=cGd82L?hI4\r /4X(HZLԌX\\..<;(Y:d(9{¼0LNMI(؊!99XRymr2/_Wu`ʌ~M,*Ȁi<hb\0q\'6i9#k^Mj7RKEA\">_![Ne؆{WyV*4Lo	BXUAUO\Z1=v ZFe}szd͗Y\n̍Eey<dH$&&-GnЭ%:EE>VDr@3Aʡ]mu:b}\Z?|/\"&l̬\Z2\'&!*2p.Yu;^EfPY8a\rI6tЭ|c\r+{\rnԇ/\'r	/\0?%-#aPψ^UVjrG.܃Cm]\'Ůc.cc_\n,Gw66߰lXXX!_X\nendstream\nendobj\n41 0 obj\n852\nendobj\n42 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 43 0 R>>stream\nxcd`ab`ddds\r4~H3a!ֹ}nP;*9(3=DAYS\\17(391O7$#57QOL-SpQ(VJ-N-*KM霟[PZZZXT_6QaCcb&|}c^柛\\ҽtiQw_>ڢ%33V/`w}D,*(ZVfͲek`82sɰn樛1eForovvIӺ56ߟsi~g_]7GSCG]z/^~	oi^p\0\0.\nendstream\nendobj\n43 0 obj\n363\nendobj\n44 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 45 0 R>>stream\nx}{lSu]׻6Y{;Pyl#@D-c\n0^]>m}ۮۺWvcSd	8Nb@AfbC@No	2/M%&P4M3_\":8!t7L-9s1c6.Ch7viV(3yU*ujeaL+]*5UZʼJeQFYҨ:=jj*fJ]MQTR^~m)j	zzʤPDJ%Q\'MՄ2Jeb#HCAEca\Zu8K^^_0-nв^x;\npIp\Z3[{?`cyI~x;G@u]>w{`,tquf{%\něrOcQz|h<jʅ:ppY4K*p127cR0^{*I3\rFP{ \Z6hvaObmmyHlЖYd6Od\\ Bfp^dݾUd/i.:(Jߗ=9^wv[m\\H#~\"DCrQIXzob(v4z-\"$s3G\\;r3c8XT^bpK|BI($UPRiZ|kE> kyIM?SϰVń05dd93퇕RbuEe	w>QfpgZD!ޫeTh435~`-`t.=x| \0^+v vZ1K31ɩ2-)b-sIC	vp\\)mR6n9g(\\]kK%OW^L;]wԁ7tWhynOA\riS_{rɂ,xEQm	~۩ro<	\'?!wƪ+8zE6i(vJ,\\+g1iG6G 5P4N6]3AvuIAD|.nkv7pB,ݭ	Kqd/KL1rY[/wvn-:\\do-&\0I1tL= e]d2\'Buۑt&y<KN\n8MM?\0捙v\nendstream\nendobj\n45 0 obj\n1244\nendobj\n46 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 47 0 R>>stream\nxklSeiak&,9\r\n8	crpeˀ:;6kq[˹<]vۨl	q}@AE1#fAIhD	&OP$y{IL$IRo-MرL,=&/\'w\Z44\rr&)$ٚ_Y[՘_[4ϼb.o.,)Th6VKcyf.IQm.T[u==++jk,vsa}?Aik_`A&s,b1Aki>PפM(2xBn&&=$жغ&.!ܒGuw+:SVcVGQ(VŮ	\0nl:XMv^R`)8 :1.Bfxܮf\Z7>.0)|ݠ;q(5w}TL\ZQިuغ\ZŎZ2P,G}5\"`]nb\'{HW>t>3D3GEs;mS- C~@ǧԥorsc#;Z7QH.Hg~\'ce&%1hYj<r3Ey/K)${=\Z;p=20r];{4{C7AU1D/1[q.6G|CDW|sh?묂\\,%\nn?i꒤~KrnSʐ\rE8K\rTԣTlǋWfJ^߀u\Zz^	$hc}R#1gK?dE#3\Z1\nU;4jf$O_ak^|*vi#oP$BS+ټf]~wH+c\"CG40#3gDqAx`sq꣺抢d9J DFqIR\rbw2\rwWp\r2jz@t8?$ HJk8,;Uɪ/\0\0lDA_Y٨ux;Jh\'m\nMaViO\"Uq=;vM>q~z_--P\'\0_5kSDRaTsI~#T)oJRijDmuqlf˄\'4ld*<W\Z~~A	hɂ8XSZ8%fd<~o/Q&8~7~\n2\"mUPy[Q\'ң?\\e?^y3rR᧛ROp¥DLľH	u1\nendstream\nendobj\n47 0 obj\n1288\nendobj\n48 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 49 0 R>>stream\nxcd`ab`ddds\r~H3a!+o\n~7n(_PYQᬩ`hiiZXX(\'gT)8(t+t-(-I-ROI-K,*/d1J	+1>{VtW9V[]V:{<FZg`_tE⢼E+W.^B?QKn.74\\&퓦ϝ\"+O=_ygŪ\'6vs475(w[M9҅?Ⱦ|m3xx\0L\nendstream\nendobj\n49 0 obj\n370\nendobj\n50 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 51 0 R>>stream\nx=Q]lUcbX[hI!TO4&h@6<Mvi]hidw;33wghk)-b*Ә\Z@Hx Rドфxg5;99|(4	(6y%^:mbl+]yUŶ]CH4\rE|G|;;7|-cCA\ZZ{VBchFuː\ZZV]x<5364q7sߙ@6^lccsRt`dpx6dӲԔ-Yq,M[sivttwh\0H3%82	D8;ɻ;aWlaӡ/CK3ihLS4_V*1Jdd8r0\ZDi+vlxm/x:~x\Z..KsȸjF=g\Z<opb&K×Cm\0:pxRH\\muWu4?;c0%&\ZyzBśad*=[oqq}3ر󧣥X)eN\nd\\)?l\'P;/%>z}d\0-a+Ta+\'&ON(;qWT#:Uk+ޣ}LT짍װK|k\\?/0{	w|O&ǒIYfL%EQX)GuG3^p\n|jbjjr+	0N!`li/4_FG?f<чv¿68\nendstream\nendobj\n51 0 obj\n812\nendobj\n52 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 53 0 R>>stream\nxWyTSwH+jm^X7\".Ūk  YDV!		bY\\@YTTܰj]h`bca<j3;9g受s^<dC$ih}gc}_\0X՛j[05q@t[U\Z/	\n;Nu8%\\,E8zp!q,g;H$vGe3]1rC\Z E1n}|4 R,HD~S͜;o~hy)A\"&b	Fl&܉O5b-A$6[1N FxMcwK&(xAț6N6͂% r	BP\'\n\':oؽmgwwps?zh+M^B\"G\n\Z;yL5d>f[;|Ӓ\nV@r+X|L6\"Y`]T-TJI ITKKf5A&(3S2&1x*I/оSYzBy4\"P\'R\'\\]QcIiׂTe	g>op9-|ַM$\ZԅP0v%Ji͏B<Ii+n氎ک5jіgB+i|k̡_<y{#I/>9+y24fX	Llf\\\"DQJ!˕UGQ3p̼w\r/TJ	=msϠhKEgղ|ȇN7ݨ[`U\n;(<TFr`qb$?\ZըifhӧJB*DY^ @DKsg7}TSL(\n-ѻW۾h8\r3xhM2nfZթymwxP퍕Tn7F5F5/ahm<f8|p,J\\\0\ZPjA3M։fu2tPvb@LUFՆ^\Z\rF6h4ble{~ho#`ˬULsF4?Jzb_qe]4-#yeF?FnnQ<cϛ[m?kG2\rEC^We䦦ejI{䵡mKHg|4Q%QENjH;rc/@SPjMB2Dӑ=5E\"9y%s۵EY5<㨕`*~WEVG{֞h5cJm7Ikc-Py҃D2(4zWMP^N2R\ZT;F!_W4>aUT/3P=dJtU%ft20r,\\;kK˹҃׺rȃ~b5QiѺ9jHNbAssLJ⨊Vrd)T=L\n&C⤨?MfU5@\'BZ<GQ{ 07+-(ikVx94ݾ~2*,(ϥ8*getЇ+\Z#\"oLf%CzŐWɑ;xK6\ZLWG\r1҂ȿvfrNd$K\ZU!ob;[(IP;|W+~\"W=\"HdFkSme2KX)؃W<7N@)?m*>9G9\ZK6	w-mh8ig~B5U?3wzG]gxq=OvVI{*uMr4\\Uek~5Ч;PjzE{kp69s1#jYr;/R h-e]Z+wU{ZM4++_OPWЫ!Cb;Eҭ#<\">u\\Y?x7}xu?Xe)Yxg@tO	ۯ@9d6&8])ܭQ1a~bctCH,ONSG)@Oq*9yAv+95h\ZfgkC/y+&>3\'Xx]=+-8J棟F|l!&0?)4UV\r\0<!\nI]*32h6`ۈ<˶>3Ȟ~\\EVZ\0-e ffVGCg+.\"! XYYg*)b7;DFGwrO`#,5#-c1,MKZ>:>.s㓚_}\ZKM&\\6\"t\n龿ZVG3|v>)eS,~[<[,\'ޑIxVl%WLgaa8=z~è٪W/-W(VR))!=Ս\Z	kh\Z^҈y,ҹs7ejJkb\rh2Y㭫nۤe|qxVXG\n\"Jd⊉lB$LȪx /._>l\rg2},|h~G/uг=u\'/MtPZ.	a+/ڀ~PfGxLI|jZ\riIӀN:\0؁e^G\ZMb*?ʅ|G+sM]m;\ZC_/-(b*EsehBʂR	л+LM%ҿn_PLF5dH*g53@<;HR_.R$R&poʂ\\uкzKLYd4Ws\0\r9\Z,&}c<Qx\0_eAG]̊ :0AUg6՜o{qx$F4)Ac9ϰ\Zf<!%ZqR\0JD<+mlyފ@}ֵSY5~57KՍIPkԐr(zZQq$=dK 7җ;>=lőŶK$WmB%7ɏÆf\0N}H9Hfx˩VGHUNKXlkfW8_T{y1[]bm:;\'8QĶQ~@DjEVΜ29Og7yqq1=ͼ@i8~q~-\"~tiey4	/WAͣ^ٲjƝrv&1PuQSa^ϒV^ypԥ:gnx\'u?XP3UXSY-<>z\0ѕ:T}#$EFlm&ƣ\'3cMe,f>fxî(@/S#5\"X喝Rv+C\'nlBȎ^/7^poꠈ\rfJ`+ 0)bcP\r1.7C(@\n)]`n-S}W	\nendstream\nendobj\n53 0 obj\n3558\nendobj\n54 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 55 0 R>>stream\nxcd`ab`dddw\r44\01H3a!;%k\n~n._PYQᬩ`hiiZXX(\'gT)8(t+@lu-(-I-ROI-KMj+I,````4c`b`bdd|?ڙr8cRV?aZ:%[&͜:qr|/d-0}3n9.<g00\0\0fZ\nendstream\nendobj\n55 0 obj\n262\nendobj\n56 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 57 0 R>>stream\nx}{lSuw.0@uTGoyaC6!%lH\"\Z*{Ji7ڵz{}l]Q[h\0MF\"E20!cb<Q~|{~IO#ðE%%kxI%fǴ{C9uip*=ETS\"zS\nn~E˖u5S\nCVrm0n4_VWR{te=Pgf^+1LEֿQL2#ϑE$N!%dY|V6!}d#r_lq|+(1\rv\r5#~Çp.dowxa\0¡@{ xz`傣ezasDG0G+F#]v_*y%?=b[hl}@ZB#x4$_²+jg\\\0>X\Z,@5f2\'XWi8al11\0QW\0B7@]s	}wiX%O+\ru$wq +[Kd^[XI>ΌJ^O%ve32\n\Z*P\'t>s{}7!Eඉ&vEuz:tgx\rc&N/^mZOӍw U +9~[W͊|dфk173WXSOI=.Gg~k1;haeK)Cq4W͔icS9\rYxW\Zװs s}%:-9~h\\r.{RjzH1_<\0\\vJu^Adhwq8U6;YW\'q?$Gp5~V!$EI^K罽ꕲf^\rv6y	x$9QwwʁS4Yj;mҢ^n9:횞]w5}.ǫJߐL?d[.Cr$W\\7M7\'x$;XľD[$x8G;рV>_x5!W(Ի:=G/zu`\'S}u*Me|Y:G<i{Y4[:||n5|-FC0K2\'~?I;1]˚0\"/\nendstream\nendobj\n57 0 obj\n1206\nendobj\n58 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 59 0 R>>stream\nxT{Pu`YNv+C\'|`JR\"Sf	\'Rݻ(xc:eik1%98YǌnPk&鏝ٝ> Д+?\"=4\nY!;#YϢϠ9ь)SN)**[oE%$%Ksuنlؠ,f7lЭ(խЗK%\\}I!EQl)/Jͤi+ԫT5zKM\"tPj>*hTu1xOtoZ[IP&gqnZnd-Nk}\0vjI2	z46z%8X9G-X)T}\nzK\01Bm:4@lfŕi\Z\n#!Aw}R5\\anh瑟AQ\n{>L0fNp`*\'~;@lEjf:\r˚-+@4k{ykj@d	@~@̝3qOHO1>M_/(bIE5\n፸\Z\'0Lk:0ߺv*6а05#5s٦E}bt?$_?$b6G7zrS?P}8}?\nۦz#yryEţ`<3n{K\\k&aG#O*8/\\ 	O06U\'} \\Idߣ3\ZȠi/\rx|?NS#IJ9BnR%T+v\\<:;Pqjnż<~է4%|ֵ@ hd2+AsIXDn	^\'\rӟ 4;sKPg.E]\0:,&ŹA!.L<11dq_E1H0D[1U1=C:Q\n%U6U<>aqc[ƭ,ؠ<Cibeo̅ͅes5Bs(Aʢh[7۸wU2\'Q#YlB1/[\'sI\n0\"\0BGE$PK.T˱% L>rQEgU~Y5u]BF9Co\r9T͏1m\\B̌XՍlsn\\${YZE;fĕDis9%}sd_隣D~$`hʙVSSk6~bY8s[X8;͒eniap\'v).,x~g^Wx8E!\nendstream\nendobj\n59 0 obj\n1362\nendobj\n60 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 61 0 R>>stream\nxcd`ab`dddu\r21H3a!G&u?\n~*_PYQᬩ`hiiZXX(\'gT)8(t+t-(-I-ROI-c```4d`dbb`add?U|V3[+x>w?~foݨ{]M<1}r}߆_~Ѽ\'NC5je߾~QE}GS[kOjv/~ktn7Nm]WWw+G[_[~\r4)Y{ӏZ+ۻs<Uӻ9Rؗv>O/{Vw\\B\nۡ݇fvM	*3-iYNƾ|Փxxe`\0\0}Y\nendstream\nendobj\n61 0 obj\n434\nendobj\n62 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 63 0 R>>stream\nxWiTS!@%Գ7mmš*-UqE2 )ʐM\0dNa0  \"JjzZNj7Q{{sZ{%yD\r%$Vsjd#fc8dvkx͑8aA硔X$Zb˂ȨX\'\\̙4?<P=/i_lH`_C>2`{`ld2:1Nc;=(EliU@yEQ\"\"\n\\H$v\"c/yw&Ou6}{ZC-R);zZBMR(jLyR˩\r\nj&ZEQ\0j eO9PCa#%S#1G9PP4U& ҈$EbFNv8`#20iσU\rvkpXr08tq>gaaXoUo6CSXvˢ0o-[uC[UGhb!t\n-#͚Dn:=mIhWgA֨&(tf: @n8PD#w%RxD.^e\\#0U%q]ޭ\'/=[	UM̤lkUn!G|nv誡\nNjb*+_.xsGn69z\ZnY֘\\\Zw7\\H/?J;En7Q{44a&Mx__貸*}避mB(2AG\"&/O	f#8gh=wA;XTJeQTs[0z=602Pʑh!(|\nGQ8w`T(}\"6Ҩh2bP$Џe4+3Ӌ_h2މ7FVy!OX\"%3h%~@21|!*Pt,@|1P}\'4@kٻ Ԑ8s,j,sjĘ;ݳ_|(^SPi5Q5yuPkB[5o)ӵ4ˤ#R` T`df:Ba.Jͥ!!8h*79tcopek;k;tbG͞o\r=a+`p/?!	\">zड़4/%jO骠\Z:\'+z9	t-q\'k#χ)cgFc(.߫KߣN۫CƺnbO@42Z2i>M`\rz:w\"},n*:e0WIr12?@q-#cЅtb9]iK>nE#kf+q-qQ߶M?fq+(Bۮ߉qe,3\'fCj1LlI\\um)~âY^kr%r6]\r68b;Fjof?(n1{Kdr\'jyK?,śL.M\\0U|?J(!<cD®ＬRҏ6_Je_ROWc8\ZGwсFǩ4q)D\ZeuuZ_ॾɜ*Є}-*_ݪ@p9wݮ4\Z!\'q;WTkM||b4aIr~oJld\00ιlsdWv6+ƃel(3ҕ$TmI2L^Cci+)!Bi/\nqk|!Yp/\Z;6pja\ra:ȂR=R5?F[pxmxm!FKIt0xRp8,\'K;d\'8L}y\\)GuCrfn\r^ ?s!XO=`!:}s!6亦_wgNf?0^qJ>=>,C@bŵN{4\Z-+bON2Bz֘qc\',`6>m<*df&d$Zmy9Ӂ1At|hݶ\\\\Fzu}sZnMLi	c\n!BB2]\r)8U=\ZH(t}HIdI{2Nkmn*|o6hWr[CQ\n=͖̎gZf	lp@0y[̣ݜA\Zu8,dduLe[\"li<tɠ*2\r<~RF6tQd5E?3\n|꓃֮~oqz4z/8$VzLĕrfNF-ɐ)j.]=h!d-{Bze{,.f҄7DN۩<eͼI[\'7DQQhsPZ9B\Zo5BW..dRu쌶S~b\Zd\nSqҙ5r--1ϫr_1Z$Wp\\\\q}ddB\\3g|v\'l[SQS[[Yi}ͥw\01&Q	s` ޓ{}(\'\n;gD(6dbC\\LҒ3>OE\0\r(:[*iCQYV@rA78t?*\rB̵$-36WQzK*GDkHhܖ|$XV(̞nTU3	׬Ws/@VZ/Y^ϼBH;q.gtkOL`MӫFCcwO[n/FHw*WlV@_0O4ehƱlhhm͛K3gײp}bUMjzGZۦArjjeüP~r.eѓlp֛8g@|?\\lwEoYb`w_+#Ro<ta\0qŞ/h6&nr7z%3I	;mAIs+4FWVgR!&ʘ&!MfBӯ<$z91\"K,%1A(vp+/1LHrM\n[v- dqVd=n\r`Oii*P\'?9%ӁD\n])BpW1iY\rphppQKJXV\"r@믑]\ZX_nUqc(9\'*21\Z)s_Nv=NJai5\\䋗Y~=ˏ~Sk-rtWxe=v脯Gξ_3$\\fZSp>ЕY䙄FWBsz+a,QH.[H@&QШ/;],jtA£NU1}t*ŅI\Z2a\Z\n]TM3\'x_S}v\']B K%=Oq*r;(\\\'niOBfijШ;s{s*xPRh_(-bVsI8O>39s\n3F/dnL?3k\ZkzcI/H]|pIQG[䚽u*դj`7#S*s;*Ѵd<ymqOBt1Qdko\ZF{HqmlMn[Vd,9|Ļd8#LyD(}i?M[8D+!|ZqB\\fZ%a+M5	R{0,& ͚fqa|Xtq^|ߏx+b$}$\ZIu)FH~<{7v~\0c_:\nendstream\nendobj\n63 0 obj\n4035\nendobj\n20 0 obj\n<</BaseFont/YWRBPR+CMMI5/FontDescriptor 19 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 1036 1037 996 0 0 0 0 0 0 0 0 0 0 0 0\n875]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n18 0 obj\n<</BaseFont/SZBQCB+CMSY6/FontDescriptor 17 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n963 380 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1222]\n/Encoding 64 0 R/Subtype/Type1>>\nendobj\n64 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n16 0 obj\n<</BaseFont/MUQRQK+CMMI6/FontDescriptor 15 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 924 927 884 998 900 0 0 0 0 0 0 0 0 0 0\n780 0 0 757]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n14 0 obj\n<</BaseFont/EFYKBB+CMMI9/FontDescriptor 13 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 771 778 734 848 756 656 0 0 0 0 0 0 0 0 0\n0 0 0 628]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n12 0 obj\n<</BaseFont/SZBQCB+CMSY9/FontDescriptor 11 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n799 285 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1028]\n/Encoding 65 0 R/Subtype/Type1>>\nendobj\n65 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n10 0 obj\n<</BaseFont/YAUXEU+TeX-cmex9/FontDescriptor 9 0 R/Type/Font\n/FirstChar 16/LastChar 33/Widths[\n614 614 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n814 814]\n/Encoding 66 0 R/Subtype/Type1>>\nendobj\n66 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n16/quotedblleft/quotedblright]>>\nendobj\n8 0 obj\n<</BaseFont/GHNQRB+CMR9/FontDescriptor 7 0 R/Type/Font\n/FirstChar 12/LastChar 121/Widths[ 571 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 400 400 0 0 285 0 0 0\n514 514 514 514 514 514 514 514 514 514 0 0 0 799 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 642 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 514 571 457 571 457 0 514 571 285 0 0 285 856 571 514\n571 0 402 405 400 0 0 0 0 542]\n/Encoding 67 0 R/Subtype/Type1>>\nendobj\n67 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n12/fi]>>\nendobj\n38 0 obj\n<</BaseFont/GKKKKC+CMSY10/FontDescriptor 37 0 R/Type/Font\n/FirstChar 54/LastChar 54/Widths[ 0]\n/Encoding 68 0 R/Subtype/Type1>>\nendobj\n68 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n54/negationslash]>>\nendobj\n36 0 obj\n<</BaseFont/WSXSQF+CMMI7/FontDescriptor 35 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 859 863 819 934 839 725 0 0 0 0 0 0 0 0 0\n727]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n34 0 obj\n<</BaseFont/GCFFPC+CMMI10/FontDescriptor 33 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 750 759 715 828 738 643 0 0 0 0 0 0 0 0 0\n642 0 0 613]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n28 0 obj\n<</BaseFont/EMLRVG+CMR6/FontDescriptor 27 0 R/Type/Font\n/FirstChar 40/LastChar 49/Widths[ 481 481 0 0 0 0 0 0\n0 611]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n22 0 obj\n<</BaseFont/QYXKNE+CMR10/FontDescriptor 21 0 R/Type/Font\n/FirstChar 40/LastChar 121/Widths[ 389 389 0 0 278 333 278 0\n500 500 500 500 0 0 500 0 0 0 278 0 0 778 0 0\n0 0 0 0 764 681 0 785 0 0 0 0 0 0 750 0\n0 778 0 0 722 0 0 0 0 0 0 0 0 0 0 0\n0 500 556 444 556 444 306 500 556 278 306 0 278 833 556 500\n556 0 392 394 389 556 528 0 0 528]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n19 0 obj\n<</Type/FontDescriptor/FontName/YWRBPR+CMMI5/FontBBox[0 -22 975 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 146\n/MissingWidth 333\n/CharSet(/A/B/C/P)/FontFile3 40 0 R>>\nendobj\n17 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY6/FontBBox[0 0 1128 432]/Flags 4\n/Ascent 432\n/CapHeight 432\n/Descent 0\n/ItalicAngle 0\n/StemV 169\n/CharSet(/arrowright/minus/periodcentered)/FontFile3 42 0 R>>\nendobj\n15 0 obj\n<</Type/FontDescriptor/FontName/MUQRQK+CMMI6/FontBBox[0 -21 944 714]/Flags 4\n/Ascent 714\n/CapHeight 714\n/Descent -21\n/ItalicAngle 0\n/StemV 141\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/S)/FontFile3 44 0 R>>\nendobj\n13 0 obj\n<</Type/FontDescriptor/FontName/EFYKBB+CMMI9/FontBBox[0 -22 823 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 123\n/MissingWidth 333\n/CharSet(/A/B/C/D/E/F/S)/FontFile3 46 0 R>>\nendobj\n11 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY9/FontBBox[0 0 970 430]/Flags 4\n/Ascent 430\n/CapHeight 430\n/Descent 0\n/ItalicAngle 0\n/StemV 145\n/CharSet(/arrowright/minus/periodcentered)/FontFile3 48 0 R>>\nendobj\n9 0 obj\n<</Type/FontDescriptor/FontName/YAUXEU+TeX-cmex9/FontBBox[0 -2957 781 45]/Flags 4\n/Ascent 45\n/CapHeight 45\n/Descent -2957\n/ItalicAngle 0\n/StemV 117\n/MissingWidth 250\n/CharSet(/quotedblleft/quotedblright/exclam/space)/FontFile3 50 0 R>>\nendobj\n7 0 obj\n<</Type/FontDescriptor/FontName/GHNQRB+CMR9/FontBBox[0 -249 833 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -249\n/ItalicAngle 0\n/StemV 124\n/MissingWidth 342\n/CharSet(/L/y/n/c/parenleft/three/o/four/d/parenright/p/e/five/six/fi/r/g/comma/seven/s/h/eight/t/i/nine/zero/l/a/one/equal/m/b/two)/FontFile3 52 0 R>>\nendobj\n37 0 obj\n<</Type/FontDescriptor/FontName/GKKKKC+CMSY10/FontBBox[0 -216 638 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -216\n/ItalicAngle 0\n/StemV 95\n/CharSet(/negationslash)/FontFile3 54 0 R>>\nendobj\n35 0 obj\n<</Type/FontDescriptor/FontName/WSXSQF+CMMI7/FontBBox[0 -20 893 713]/Flags 4\n/Ascent 713\n/CapHeight 713\n/Descent -20\n/ItalicAngle 0\n/StemV 133\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F)/FontFile3 56 0 R>>\nendobj\n33 0 obj\n<</Type/FontDescriptor/FontName/GCFFPC+CMMI10/FontBBox[0 -22 804 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 120\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F/S)/FontFile3 58 0 R>>\nendobj\n27 0 obj\n<</Type/FontDescriptor/FontName/EMLRVG+CMR6/FontBBox[0 -250 505 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 75\n/MissingWidth 416\n/CharSet(/parenleft/parenright/one)/FontFile3 60 0 R>>\nendobj\n21 0 obj\n<</Type/FontDescriptor/FontName/QYXKNE+CMR10/FontBBox[-40 -250 813 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 121\n/MissingWidth 333\n/CharSet(/y/n/c/parenleft/three/o/d/parenright/N/p/e/D/f/E/six/r/g/comma/Q/s/h/hyphen/G/t/i/period/u/colon/j/T/v/zero/l/a/one/equal/m/b/two)/FontFile3 62 0 R>>\nendobj\n2 0 obj\n<</Producer(ESP Ghostscript 815.01)\n/CreationDate(D:20060627000031)\n/ModDate(D:20060627000031)\n/Creator(dvips\\(k\\) 5.95a Copyright 2005 Radical Eye Software)\n/Title(proof1.dvi)>>endobj\nxref\n0 69\n0000000000 65535 f \n0000006062 00000 n \n0000029628 00000 n \n0000005989 00000 n \n0000005533 00000 n \n0000000015 00000 n \n0000002468 00000 n \n0000028076 00000 n \n0000025016 00000 n \n0000027825 00000 n \n0000024720 00000 n \n0000027608 00000 n \n0000024390 00000 n \n0000027387 00000 n \n0000024188 00000 n \n0000027166 00000 n \n0000023986 00000 n \n0000026948 00000 n \n0000023656 00000 n \n0000026733 00000 n \n0000023464 00000 n \n0000029287 00000 n \n0000026340 00000 n \n0000006110 00000 n \n0000005684 00000 n \n0000002488 00000 n \n0000003823 00000 n \n0000029055 00000 n \n0000026165 00000 n \n0000006217 00000 n \n0000005837 00000 n \n0000003844 00000 n \n0000005512 00000 n \n0000028831 00000 n \n0000025960 00000 n \n0000028610 00000 n \n0000025764 00000 n \n0000028405 00000 n \n0000025525 00000 n \n0000006335 00000 n \n0000006400 00000 n \n0000007338 00000 n \n0000007358 00000 n \n0000007807 00000 n \n0000007827 00000 n \n0000009157 00000 n \n0000009178 00000 n \n0000010552 00000 n \n0000010573 00000 n \n0000011029 00000 n \n0000011049 00000 n \n0000011947 00000 n \n0000011967 00000 n \n0000015611 00000 n \n0000015632 00000 n \n0000015980 00000 n \n0000016000 00000 n \n0000017292 00000 n \n0000017313 00000 n \n0000018761 00000 n \n0000018782 00000 n \n0000019302 00000 n \n0000019322 00000 n \n0000023443 00000 n \n0000023871 00000 n \n0000024605 00000 n \n0000024908 00000 n \n0000025441 00000 n \n0000025669 00000 n \ntrailer\n<< /Size 69 /Root 1 0 R /Info 2 0 R\n/ID [(\\ry9o.J`I4)(\\ry9o.J`I4)]\n>>\nstartxref\n29821\n%%EOF\n','Proved','BZh91AY&SY¬\0\0_tcǿ ``}\Zj-B\0\n\0S 4M4hh\0&M4ddт0F\0&M4ddт0F\0HԏPh\rL\0\ZP)RyF\0M\0h\040@)J&@\Z4E422\0\01\r:*A\nTRbL&U,X&%0	`c\"3PDAV\\3(b~z8w\nƽ(M8%LdJ˸d*8#u$N,aM*zOf,WҭSEC\rZ}Ey|N:oؚoWԛY0usWj3bj[$]vZvE|z`b/^:)~5yvlUUJ/8 8p\n	PC\r~f8h4UT0c4AQLXFD	Ex5L5AӵHKdLA&X 5(\rq4~73COIػ|xfO&.i}szj=G\0=\nCrHnal˝[+8MVƚ[jвm4j3m6lmp4?3A.:85uBC3sώ7- *I&&R\rTC0P\nk9 vl)-!ad\r\Z6A)0CAf3 0p NcD :\rhF%1}MƍVj3BTzu HUwAq\\qeL%eJP\ZV)X;9I%J%֖R{I&>]iMV|\'/{{\Z/fp\ZAvMϐ%	$\"ѳ0͠S?64_	Uq#0kprcz%]\"|*\'ڵ\\oKZ.@w3+>L8	}nbwyӺxvxb\\YlU^^.G/t#ܛŃ;aL^w=jwr)>BYJXeSeVX1.e*tpհqdtHܪTݘYph얂pxܪ4\ZK{uC\"#)!*$!0ģC*(&%unO2\\OQf&B`n`=M<\Zi-[%beXJ\'IcjEU:T@\n%MoU-{zi$FҢlU:/rK/5rq)w4&6Z^d{Gt)Z2&4:\rXaaba9hV+/_Hx8n;}zp\\NIע#1TZ|ܹ{bȘm|unKK	61{\rwm7Rw$S	*ʎ'),(21,'point O 40 10 \r\npoint A 80 10     \r\npoint C 60 30  \r\n  \r\nonline B O A\r\n\r\nline a A C\r\nline c O C \r\nparallel b B a\r\nintersec D c b \r\n\r\ndrawline O A \r\ndrawline O C \r\ndrawline A C\r\ndrawline B D\r\n\r\ncmark_t O\r\ncmark_t A\r\ncmark_t B\r\ncmark_t C   \r\ncmark_t D   \r\n\r\n% parallel BC\' and B\'C\r\nprove { equal { sratio O A O B } { sratio O C O D  } }','<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE figure SYSTEM \"GeoCons.dtd\">\n<?xml-stylesheet href=\"GeoConsNL.xsl\" type=\"text/xsl\"?>\n\n<figure>\n	<define>\n		<fixed_point x=\"40.000000\" y=\"10.000000\">O</fixed_point>\n		<fixed_point x=\"80.000000\" y=\"10.000000\">A</fixed_point>\n		<fixed_point x=\"60.000000\" y=\"30.000000\">C</fixed_point>\n	</define>\n\n	<construct>\n		<random_point_on_line><new_point>B</new_point><point>O</point><point>A</point></random_point_on_line>\n		<ruler><new_line>a</new_line><point>A</point><point>C</point></ruler>\n		<ruler><new_line>c</new_line><point>O</point><point>C</point></ruler>\n		<parallel><new_line>b</new_line><point>B</point><line>a</line></parallel>\n		<intersection><new_point>D</new_point><line>c</line><line>b</line></intersection>\n	</construct>\n\n	<draw>\n		<line_pp><point>O</point><point>A</point></line_pp>\n		<line_pp><point>O</point><point>C</point></line_pp>\n		<line_pp><point>A</point><point>C</point></line_pp>\n		<line_pp><point>B</point><point>D</point></line_pp>\n	</draw>\n\n	<labels>\n		<point_label direction=\"90\"><point>O</point></point_label>\n		<point_label direction=\"90\"><point>A</point></point_label>\n		<point_label direction=\"90\"><point>B</point></point_label>\n		<point_label direction=\"90\"><point>C</point></point_label>\n		<point_label direction=\"90\"><point>D</point></point_label>\n	</labels>\n\n	<conjecture>\n		<prove proof_level=\"1\" proof_limit=\"10000\">\n			<equality>\n				<expression>\n					<segment_ratio><segment><point>O</point><point>A</point></segment><segment><point>O</point><point>B</point></segment></segment_ratio>\n				</expression>\n				<expression>\n					<segment_ratio><segment><point>O</point><point>C</point></segment><segment><point>O</point><point>D</point></segment></segment_ratio>\n				</expression>\n			</equality>\n		</prove>\n	</conjecture>\n\n</figure>','2006-04-06',2,1,'GEO0004','%PDF-1.2\n%쏢\n5 0 obj\n<</Length 6 0 R/Filter /FlateDecode>>\nstream\nxMu[#ERX\"$k#|@>6a$~?zwAP`G̬}H\Zu?_ڥ6jݛ\"˚&	;?IRX(-QsjmʶjoQθ~\rq\nuR7?.	bN 1#ڑdOx\'oR9	Ȩ߶_VX/#X׻7lr\Z?;Flѫǻiߗo_WOď{FWVZYA$tfWcn\n\rX+A0kV/uU?ړ \")|ߛ\\LO#Y\\Jhm\04Llp;i\"|};ɱ3z!fQ_8r.pasvvֈMÜ-|O\nho0]ڇǩs\n=utM\'!4:h1Ս%T~9[=j M9FkA9B>(	Sq9\r޴oX\ZV~K\\`{-5;{q/1RFҮ]&+*Y7w=%fy1ҵFvj/\rf9ZlgJ<3%3k]yfJdiL$SyI|\'v~ntT\'R`iy@Q]CyhAzEudIptYv&̤eLDR{&L\"\ruUGώ/#=~pJu~0X\'\r2./poq\0O}wu\rk4䵞2 z9L\"yöDَgnWJc.@a\ZH21WdIϋL=]#\n[K̥2,_0vͧ;S=;(KaxRY7VvXȩ.W\rƴ/32犳3=fSD6g;N1\r)Hh`px8+̝ju9u-\\Z~4Ak)\":qjpOP)禍ޜWD\ZZD~kOh1\rKuvUsk74\'אލ	\nvN4Xy{n<v!~r?!+>uy ?oGf06aeBtƄ0G!5MiZj^Vjhkgs\rxDuFӓԼ\Z{\Z`P%c CfK5<yׯ,az[+-ծf4rAaW3z^z]CQu|H?\r!:):,Q>mSȨ6l/,냰j	;!nO6w\ru#Uy`yIt$6\\X{V)VBHA𻒋;W/q1ҴcE9U\"\"C#{Rփ:,xNM9ϣFgWsc{\Z+:HU1\\QhU%r\0,\ZXJ\0xVڡeC.DEʁ|\r,Xh*5W8&67f		A?b\'X$gYht\rhjxNս>fx._`jbqَ\\ɃQ)͖:HsPrNVRS1]rulE\"${]SˊECYHyvm|h\"TPG`I!%KWVc)`1,Ļ)Gv4{7d$SI2_P	M<XM>R(q֬HHv2|,++x`8pI*H\npEn^jw*W%WǓW]g~MZ\'o\'m)0SXz(؎EJ9U;}X;?ޑX{.5|~Εy-+zl5¿-ZB2hɼ=ژQU%s9\")sfsx770BavsUN^#=S|HukE\"]TdlBjET,Jz}7\"Y(Y滋y`8\n+	}q#NM^bUuV#ZuNn%ƲMIpcڅx#*wTd[$94Qr+R؍EqzNI$s\\jLH so^6ܪr&	@n2u^dREɛ;S!?윧endstream\nendobj\n6 0 obj\n2383\nendobj\n25 0 obj\n<</Length 26 0 R/Filter /FlateDecode>>\nstream\nxKoEǝ|m#aVpN@=ޱw8 [tUw~Ue4)#?UU>*ROwU7uLLlJ:`\\\r~v^U/u!s㵥`Cq\rAD!hyΰھOE\"XpS	=ju9V{zC߉ñ+2_5FA_(Nώec\\ѣig\"iy9dujW56fxש6}Vm?Q411gk9\'ꢺQ堉U$!?9ϿU}xS:Z<?:,4Iu,;F%\Z\'\r<UYG[9,qm,ixo+ዤ8٬Ӄxŭv9+HzE۽23]ȴίK QH7*EYʐbh\'uOf	\"O֯Z$!׿t߼iX!Üplo7HڗH}	lC<jl=d||ِ.8uJ߻ףp3\"!j3E\rh3{C#AKT0ȁAI]-!<\"mrqA!.OHm\"lz\\^ .4+n6i,AYqy+K,H#MrPLEzʤ(MiRs{XkRXq\Zۏ}I{@L>(싾g#bϞZYT%;G+e>i|DhY>8\Zu]x]|pI7\\KG]x{q]΀\r`+Xa{.`-Sczܻ7?=J==6GF\n@Mp_GANH	A^#*;n5Ys7Y~żcw\Zbڥ_!\n\"$Șbd!>)hW|JY8kV*nZ<z[ehʅ}L^K+HA4n\'tvZ2e9+Ȓ#{]܀\"s%ڲ-Rr	捕v(pw;=l:Ɩ0kO_,kZע00[cw[\0Y\\(e늳`d#lRvQ\rU{endstream\nendobj\n26 0 obj\n1263\nendobj\n31 0 obj\n<</Length 32 0 R/Filter /FlateDecode>>\nstream\nxZn6BRѥə-@it>$}iޤ@3Vj]خ0`ks8̐\ZW[>}]ukWY0udR퀢II:T\'??|:~]u:_T\'h}v>\\V\0lr@y:hBiQ\nؘ֚H9nXbRG7֣\r3^3\\/՟[4,0%lmސip[?yⒷ<^dD!:6;/~|b{؜/v3C?V/60v)s8jC0J&}9*oc5]Sn-_vAa4!#e9섇[b,j|_vZM7s \n~W̾-yᲉ9հL\ngaG-z=L<i1)ِ&τؼ\\L1urA^X%3,v\ryc0!ʑOc4m6j2d͓9ʔgfS9SYs0AY/O21A}P$M2Q`6^<EGؿ+Y!؏)t=U\'G_8+;TT{5\'f%g͇5A|N̍NV8Pt\ZDe\ZVAv\"vHW-;cg;}W-9wnFכ(rښcIs\\L}T9`9͹H|Ys}¢;Fչik|\'$hQSIͱ^epkp;oyn!z\\VS̼iȄg܋9Bbőnc!$Y񺤶D9A	TR\Z!S)(kд.S!OK	<{{P%#Lhh%V˕N܋e	G|urdƶhcd(Re2<2\n̮.G5C-iH鿣3:c#g	Wș07\rGeN[HGDu??E;9Vѥ	\r>\'B\\yh.CZBszʷ<\\\"2g)~}d趥hq^GϿ[ہ|tEܟ_Vdh\':yߴ[&gPQ*`r}`פ}.E]T.3;::َVߤ+[\rU8cȻda$ް\\ٔM_F]V58U\0=cӄ̀4x:K0Rd3f7+hGt7}#lT *~4H7S0:\0\Z\r)\rM\nH\n)h{.\"kQ$j?b)2tct`aP.q߭_Au\Z/TiEY\"mP12k\0&Ŗ5lyeɉLv;\n endstream\nendobj\n32 0 obj\n1596\nendobj\n4 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 23 0 R\n>>\n/Contents 5 0 R\n>>\nendobj\n24 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 29 0 R\n>>\n/Contents 25 0 R\n>>\nendobj\n30 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 0/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 39 0 R\n>>\n/Contents 31 0 R\n>>\nendobj\n3 0 obj\n<< /Type /Pages /Kids [\n4 0 R\n24 0 R\n30 0 R\n] /Count 3\n>>\nendobj\n1 0 obj\n<</Type /Catalog /Pages 3 0 R\n>>\nendobj\n23 0 obj\n<</R20\n20 0 R/R18\n18 0 R/R16\n16 0 R/R14\n14 0 R/R12\n12 0 R/R10\n10 0 R/R8\n8 0 R/R22\n22 0 R>>\nendobj\n29 0 obj\n<</R20\n20 0 R/R18\n18 0 R/R16\n16 0 R/R14\n14 0 R/R12\n12 0 R/R10\n10 0 R/R8\n8 0 R/R28\n28 0 R/R22\n22 0 R>>\nendobj\n39 0 obj\n<</R38\n38 0 R/R36\n36 0 R/R34\n34 0 R/R22\n22 0 R>>\nendobj\n40 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 41 0 R>>stream\nxM_lSu@S2콈P,e6&aFc5nOGtsoe[Ww?keQ		iQ7ʣ	#ӻ_y+/?9!fa;{j$Si2UbO}}</>;0=Cz|R}{߾RrJ=AHRWbXri}nts<MvgnRg#dq1t~qEfve,Wr-V_bؔ!\Z	M#=cGd82L?hI4\r /4X(HZLԌX\\..<;(Y:d(9{¼0LNMI(؊!99XRymr2/_Wu`ʌ~M,*Ȁi<hb\0q\'6i9#k^Mj7RKEA\">_![Ne؆{WyV*4Lo	BXUAUO\Z1=v ZFe}szd͗Y\n̍Eey<dH$&&-GnЭ%:EE>VDr@3Aʡ]mu:b}\Z?|/\"&l̬\Z2\'&!*2p.Yu;^EfPY8a\rI6tЭ|c\r+{\rnԇ/\'r	/\0?%-#aPψ^UVjrG.܃Cm]\'Ůc.cc_\n,Gw66߰lXXX!_X\nendstream\nendobj\n41 0 obj\n852\nendobj\n42 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 43 0 R>>stream\nxcd`ab`ddds\r4~H3a!ֹ}nP;*9(3=DAYS\\17(391O7$#57QOL-SpQ(VJ-N-*KM霟[PZZZXT_6QaCcb&|}c^柛\\ҽtiQw_>ڢ%33V/`w}D,*(ZVfͲek`82sɰn樛1eForovvIӺ56ߟsi~g_]7GSCG]z/^~	oi^p\0\0.\nendstream\nendobj\n43 0 obj\n363\nendobj\n44 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 45 0 R>>stream\nx}{lSu]׻6Y{;Pyl#@D-c\n0^]>m}ۮۺWvcSd	8Nb@AfbC@No	2/M%&P4M3_\":8!t7L-9s1c6.Ch7viV(3yU*ujeaL+]*5UZʼJeQFYҨ:=jj*fJ]MQTR^~m)j	zzʤPDJ%Q\'MՄ2Jeb#HCAEca\Zu8K^^_0-nв^x;\npIp\Z3[{?`cyI~x;G@u]>w{`,tquf{%\něrOcQz|h<jʅ:ppY4K*p127cR0^{*I3\rFP{ \Z6hvaObmmyHlЖYd6Od\\ Bfp^dݾUd/i.:(Jߗ=9^wv[m\\H#~\"DCrQIXzob(v4z-\"$s3G\\;r3c8XT^bpK|BI($UPRiZ|kE> kyIM?SϰVń05dd93퇕RbuEe	w>QfpgZD!ޫeTh435~`-`t.=x| \0^+v vZ1K31ɩ2-)b-sIC	vp\\)mR6n9g(\\]kK%OW^L;]wԁ7tWhynOA\riS_{rɂ,xEQm	~۩ro<	\'?!wƪ+8zE6i(vJ,\\+g1iG6G 5P4N6]3AvuIAD|.nkv7pB,ݭ	Kqd/KL1rY[/wvn-:\\do-&\0I1tL= e]d2\'Buۑt&y<KN\n8MM?\0捙v\nendstream\nendobj\n45 0 obj\n1244\nendobj\n46 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 47 0 R>>stream\nxklSeiak&,9\r\n8	crpeˀ:;6kq[˹<]vۨl	q}@AE1#fAIhD	&OP$y{IL$IRo-MرL,=&/\'w\Z44\rr&)$ٚ_Y[՘_[4ϼb.o.,)Th6VKcyf.IQm.T[u==++jk,vsa}?Aik_`A&s,b1Aki>PפM(2xBn&&=$жغ&.!ܒGuw+:SVcVGQ(VŮ	\0nl:XMv^R`)8 :1.Bfxܮf\Z7>.0)|ݠ;q(5w}TL\ZQިuغ\ZŎZ2P,G}5\"`]nb\'{HW>t>3D3GEs;mS- C~@ǧԥorsc#;Z7QH.Hg~\'ce&%1hYj<r3Ey/K)${=\Z;p=20r];{4{C7AU1D/1[q.6G|CDW|sh?묂\\,%\nn?i꒤~KrnSʐ\rE8K\rTԣTlǋWfJ^߀u\Zz^	$hc}R#1gK?dE#3\Z1\nU;4jf$O_ak^|*vi#oP$BS+ټf]~wH+c\"CG40#3gDqAx`sq꣺抢d9J DFqIR\rbw2\rwWp\r2jz@t8?$ HJk8,;Uɪ/\0\0lDA_Y٨ux;Jh\'m\nMaViO\"Uq=;vM>q~z_--P\'\0_5kSDRaTsI~#T)oJRijDmuqlf˄\'4ld*<W\Z~~A	hɂ8XSZ8%fd<~o/Q&8~7~\n2\"mUPy[Q\'ң?\\e?^y3rR᧛ROp¥DLľH	u1\nendstream\nendobj\n47 0 obj\n1288\nendobj\n48 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 49 0 R>>stream\nxcd`ab`ddds\r~H3a!+o\n~7n(_PYQᬩ`hiiZXX(\'gT)8(t+t-(-I-ROI-K,*/d1J	+1>{VtW9V[]V:{<FZg`_tE⢼E+W.^B?QKn.74\\&퓦ϝ\"+O=_ygŪ\'6vs475(w[M9҅?Ⱦ|m3xx\0L\nendstream\nendobj\n49 0 obj\n370\nendobj\n50 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 51 0 R>>stream\nx=Q]lUcbX[hI!TO4&h@6<Mvi]hidw;33wghk)-b*Ә\Z@Hx Rドфxg5;99|(4	(6y%^:mbl+]yUŶ]CH4\rE|G|;;7|-cCA\ZZ{VBchFuː\ZZV]x<5364q7sߙ@6^lccsRt`dpx6dӲԔ-Yq,M[sivttwh\0H3%82	D8;ɻ;aWlaӡ/CK3ihLS4_V*1Jdd8r0\ZDi+vlxm/x:~x\Z..KsȸjF=g\Z<opb&K×Cm\0:pxRH\\muWu4?;c0%&\ZyzBśad*=[oqq}3ر󧣥X)eN\nd\\)?l\'P;/%>z}d\0-a+Ta+\'&ON(;qWT#:Uk+ޣ}LT짍װK|k\\?/0{	w|O&ǒIYfL%EQX)GuG3^p\n|jbjjr+	0N!`li/4_FG?f<чv¿68\nendstream\nendobj\n51 0 obj\n812\nendobj\n52 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 53 0 R>>stream\nxWyTSwH+jm^X7\".Ūk  YDV!		bY\\@YTTܰj]h`bca<j3;9g受s^<dC$ih}gc}_\0X՛j[05q@t[U\Z/	\n;Nu8%\\,E8zp!q,g;H$vGe3]1rC\Z E1n}|4 R,HD~S͜;o~hy)A\"&b	Fl&܉O5b-A$6[1N FxMcwK&(xAț6N6͂% r	BP\'\n\':oؽmgwwps?zh+M^B\"G\n\Z;yL5d>f[;|Ӓ\nV@r+X|L6\"Y`]T-TJI ITKKf5A&(3S2&1x*I/оSYzBy4\"P\'R\'\\]QcIiׂTe	g>op9-|ַM$\ZԅP0v%Ji͏B<Ii+n氎ک5jіgB+i|k̡_<y{#I/>9+y24fX	Llf\\\"DQJ!˕UGQ3p̼w\r/TJ	=msϠhKEgղ|ȇN7ݨ[`U\n;(<TFr`qb$?\ZըifhӧJB*DY^ @DKsg7}TSL(\n-ѻW۾h8\r3xhM2nfZթymwxP퍕Tn7F5F5/ahm<f8|p,J\\\0\ZPjA3M։fu2tPvb@LUFՆ^\Z\rF6h4ble{~ho#`ˬULsF4?Jzb_qe]4-#yeF?FnnQ<cϛ[m?kG2\rEC^We䦦ejI{䵡mKHg|4Q%QENjH;rc/@SPjMB2Dӑ=5E\"9y%s۵EY5<㨕`*~WEVG{֞h5cJm7Ikc-Py҃D2(4zWMP^N2R\ZT;F!_W4>aUT/3P=dJtU%ft20r,\\;kK˹҃׺rȃ~b5QiѺ9jHNbAssLJ⨊Vrd)T=L\n&C⤨?MfU5@\'BZ<GQ{ 07+-(ikVx94ݾ~2*,(ϥ8*getЇ+\Z#\"oLf%CzŐWɑ;xK6\ZLWG\r1҂ȿvfrNd$K\ZU!ob;[(IP;|W+~\"W=\"HdFkSme2KX)؃W<7N@)?m*>9G9\ZK6	w-mh8ig~B5U?3wzG]gxq=OvVI{*uMr4\\Uek~5Ч;PjzE{kp69s1#jYr;/R h-e]Z+wU{ZM4++_OPWЫ!Cb;Eҭ#<\">u\\Y?x7}xu?Xe)Yxg@tO	ۯ@9d6&8])ܭQ1a~bctCH,ONSG)@Oq*9yAv+95h\ZfgkC/y+&>3\'Xx]=+-8J棟F|l!&0?)4UV\r\0<!\nI]*32h6`ۈ<˶>3Ȟ~\\EVZ\0-e ffVGCg+.\"! XYYg*)b7;DFGwrO`#,5#-c1,MKZ>:>.s㓚_}\ZKM&\\6\"t\n龿ZVG3|v>)eS,~[<[,\'ޑIxVl%WLgaa8=z~è٪W/-W(VR))!=Ս\Z	kh\Z^҈y,ҹs7ejJkb\rh2Y㭫nۤe|qxVXG\n\"Jd⊉lB$LȪx /._>l\rg2},|h~G/uг=u\'/MtPZ.	a+/ڀ~PfGxLI|jZ\riIӀN:\0؁e^G\ZMb*?ʅ|G+sM]m;\ZC_/-(b*EsehBʂR	л+LM%ҿn_PLF5dH*g53@<;HR_.R$R&poʂ\\uкzKLYd4Ws\0\r9\Z,&}c<Qx\0_eAG]̊ :0AUg6՜o{qx$F4)Ac9ϰ\Zf<!%ZqR\0JD<+mlyފ@}ֵSY5~57KՍIPkԐr(zZQq$=dK 7җ;>=lőŶK$WmB%7ɏÆf\0N}H9Hfx˩VGHUNKXlkfW8_T{y1[]bm:;\'8QĶQ~@DjEVΜ29Og7yqq1=ͼ@i8~q~-\"~tiey4	/WAͣ^ٲjƝrv&1PuQSa^ϒV^ypԥ:gnx\'u?XP3UXSY-<>z\0ѕ:T}#$EFlm&ƣ\'3cMe,f>fxî(@/S#5\"X喝Rv+C\'nlBȎ^/7^poꠈ\rfJ`+ 0)bcP\r1.7C(@\n)]`n-S}W	\nendstream\nendobj\n53 0 obj\n3558\nendobj\n54 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 55 0 R>>stream\nxcd`ab`dddw\r44\01H3a!;%k\n~n._PYQᬩ`hiiZXX(\'gT)8(t+@lu-(-I-ROI-KMj+I,````4c`b`bdd|?ڙr8cRV?aZ:%[&͜:qr|/d-0}3n9.<g00\0\0fZ\nendstream\nendobj\n55 0 obj\n262\nendobj\n56 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 57 0 R>>stream\nx}{lSuw.0@uTGoyaC6!%lH\"\Z*{Ji7ڵz{}l]Q[h\0MF\"E20!cb<Q~|{~IO#ðE%%kxI%fǴ{C9uip*=ETS\"zS\nn~E˖u5S\nCVrm0n4_VWR{te=Pgf^+1LEֿQL2#ϑE$N!%dY|V6!}d#r_lq|+(1\rv\r5#~Çp.dowxa\0¡@{ xz`傣ezasDG0G+F#]v_*y%?=b[hl}@ZB#x4$_²+jg\\\0>X\Z,@5f2\'XWi8al11\0QW\0B7@]s	}wiX%O+\ru$wq +[Kd^[XI>ΌJ^O%ve32\n\Z*P\'t>s{}7!Eඉ&vEuz:tgx\rc&N/^mZOӍw U +9~[W͊|dфk173WXSOI=.Gg~k1;haeK)Cq4W͔icS9\rYxW\Zװs s}%:-9~h\\r.{RjzH1_<\0\\vJu^Adhwq8U6;YW\'q?$Gp5~V!$EI^K罽ꕲf^\rv6y	x$9QwwʁS4Yj;mҢ^n9:횞]w5}.ǫJߐL?d[.Cr$W\\7M7\'x$;XľD[$x8G;рV>_x5!W(Ի:=G/zu`\'S}u*Me|Y:G<i{Y4[:||n5|-FC0K2\'~?I;1]˚0\"/\nendstream\nendobj\n57 0 obj\n1206\nendobj\n58 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 59 0 R>>stream\nxT{Pu`YNv+C\'|`JR\"Sf	\'Rݻ(xc:eik1%98YǌnPk&鏝ٝ> Д+?\"=4\nY!;#YϢϠ9ь)SN)**[oE%$%Ksuنlؠ,f7lЭ(խЗK%\\}I!EQl)/Jͤi+ԫT5zKM\"tPj>*hTu1xOtoZ[IP&gqnZnd-Nk}\0vjI2	z46z%8X9G-X)T}\nzK\01Bm:4@lfŕi\Z\n#!Aw}R5\\anh瑟AQ\n{>L0fNp`*\'~;@lEjf:\r˚-+@4k{ykj@d	@~@̝3qOHO1>M_/(bIE5\n፸\Z\'0Lk:0ߺv*6а05#5s٦E}bt?$_?$b6G7zrS?P}8}?\nۦz#yryEţ`<3n{K\\k&aG#O*8/\\ 	O06U\'} \\Idߣ3\ZȠi/\rx|?NS#IJ9BnR%T+v\\<:;Pqjnż<~է4%|ֵ@ hd2+AsIXDn	^\'\rӟ 4;sKPg.E]\0:,&ŹA!.L<11dq_E1H0D[1U1=C:Q\n%U6U<>aqc[ƭ,ؠ<Cibeo̅ͅes5Bs(Aʢh[7۸wU2\'Q#YlB1/[\'sI\n0\"\0BGE$PK.T˱% L>rQEgU~Y5u]BF9Co\r9T͏1m\\B̌XՍlsn\\${YZE;fĕDis9%}sd_隣D~$`hʙVSSk6~bY8s[X8;͒eniap\'v).,x~g^Wx8E!\nendstream\nendobj\n59 0 obj\n1362\nendobj\n60 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 61 0 R>>stream\nxcd`ab`dddu\r21H3a!G&u?\n~*_PYQᬩ`hiiZXX(\'gT)8(t+t-(-I-ROI-c```4d`dbb`add?U|V3[+x>w?~foݨ{]M<1}r}߆_~Ѽ\'NC5je߾~QE}GS[kOjv/~ktn7Nm]WWw+G[_[~\r4)Y{ӏZ+ۻs<Uӻ9Rؗv>O/{Vw\\B\nۡ݇fvM	*3-iYNƾ|Փxxe`\0\0}Y\nendstream\nendobj\n61 0 obj\n434\nendobj\n62 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 63 0 R>>stream\nxWiTS!@%Գ7mmš*-UqE2 )ʐM\0dNa0  \"JjzZNj7Q{{sZ{%yD\r%$Vsjd#fc8dvkx͑8aA硔X$Zb˂ȨX\'\\̙4?<P=/i_lH`_C>2`{`ld2:1Nc;=(EliU@yEQ\"\"\n\\H$v\"c/yw&Ou6}{ZC-R);zZBMR(jLyR˩\r\nj&ZEQ\0j eO9PCa#%S#1G9PP4U& ҈$EbFNv8`#20iσU\rvkpXr08tq>gaaXoUo6CSXvˢ0o-[uC[UGhb!t\n-#͚Dn:=mIhWgA֨&(tf: @n8PD#w%RxD.^e\\#0U%q]ޭ\'/=[	UM̤lkUn!G|nv誡\nNjb*+_.xsGn69z\ZnY֘\\\Zw7\\H/?J;En7Q{44a&Mx__貸*}避mB(2AG\"&/O	f#8gh=wA;XTJeQTs[0z=602Pʑh!(|\nGQ8w`T(}\"6Ҩh2bP$Џe4+3Ӌ_h2މ7FVy!OX\"%3h%~@21|!*Pt,@|1P}\'4@kٻ Ԑ8s,j,sjĘ;ݳ_|(^SPi5Q5yuPkB[5o)ӵ4ˤ#R` T`df:Ba.Jͥ!!8h*79tcopek;k;tbG͞o\r=a+`p/?!	\">zड़4/%jO骠\Z:\'+z9	t-q\'k#χ)cgFc(.߫KߣN۫CƺnbO@42Z2i>M`\rz:w\"},n*:e0WIr12?@q-#cЅtb9]iK>nE#kf+q-qQ߶M?fq+(Bۮ߉qe,3\'fCj1LlI\\um)~âY^kr%r6]\r68b;Fjof?(n1{Kdr\'jyK?,śL.M\\0U|?J(!<cD®ＬRҏ6_Je_ROWc8\ZGwсFǩ4q)D\ZeuuZ_ॾɜ*Є}-*_ݪ@p9wݮ4\Z!\'q;WTkM||b4aIr~oJld\00ιlsdWv6+ƃel(3ҕ$TmI2L^Cci+)!Bi/\nqk|!Yp/\Z;6pja\ra:ȂR=R5?F[pxmxm!FKIt0xRp8,\'K;d\'8L}y\\)GuCrfn\r^ ?s!XO=`!:}s!6亦_wgNf?0^qJ>=>,C@bŵN{4\Z-+bON2Bz֘qc\',`6>m<*df&d$Zmy9Ӂ1At|hݶ\\\\Fzu}sZnMLi	c\n!BB2]\r)8U=\ZH(t}HIdI{2Nkmn*|o6hWr[CQ\n=͖̎gZf	lp@0y[̣ݜA\Zu8,dduLe[\"li<tɠ*2\r<~RF6tQd5E?3\n|꓃֮~oqz4z/8$VzLĕrfNF-ɐ)j.]=h!d-{Bze{,.f҄7DN۩<eͼI[\'7DQQhsPZ9B\Zo5BW..dRu쌶S~b\Zd\nSqҙ5r--1ϫr_1Z$Wp\\\\q}ddB\\3g|v\'l[SQS[[Yi}ͥw\01&Q	s` ޓ{}(\'\n;gD(6dbC\\LҒ3>OE\0\r(:[*iCQYV@rA78t?*\rB̵$-36WQzK*GDkHhܖ|$XV(̞nTU3	׬Ws/@VZ/Y^ϼBH;q.gtkOL`MӫFCcwO[n/FHw*WlV@_0O4ehƱlhhm͛K3gײp}bUMjzGZۦArjjeüP~r.eѓlp֛8g@|?\\lwEoYb`w_+#Ro<ta\0qŞ/h6&nr7z%3I	;mAIs+4FWVgR!&ʘ&!MfBӯ<$z91\"K,%1A(vp+/1LHrM\n[v- dqVd=n\r`Oii*P\'?9%ӁD\n])BpW1iY\rphppQKJXV\"r@믑]\ZX_nUqc(9\'*21\Z)s_Nv=NJai5\\䋗Y~=ˏ~Sk-rtWxe=v脯Gξ_3$\\fZSp>ЕY䙄FWBsz+a,QH.[H@&QШ/;],jtA£NU1}t*ŅI\Z2a\Z\n]TM3\'x_S}v\']B K%=Oq*r;(\\\'niOBfijШ;s{s*xPRh_(-bVsI8O>39s\n3F/dnL?3k\ZkzcI/H]|pIQG[䚽u*դj`7#S*s;*Ѵd<ymqOBt1Qdko\ZF{HqmlMn[Vd,9|Ļd8#LyD(}i?M[8D+!|ZqB\\fZ%a+M5	R{0,& ͚fqa|Xtq^|ߏx+b$}$\ZIu)FH~<{7v~\0c_:\nendstream\nendobj\n63 0 obj\n4035\nendobj\n20 0 obj\n<</BaseFont/YWRBPR+CMMI5/FontDescriptor 19 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 1036 1037 996 0 0 0 0 0 0 0 0 0 0 0 0\n875]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n18 0 obj\n<</BaseFont/SZBQCB+CMSY6/FontDescriptor 17 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n963 380 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1222]\n/Encoding 64 0 R/Subtype/Type1>>\nendobj\n64 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n16 0 obj\n<</BaseFont/MUQRQK+CMMI6/FontDescriptor 15 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 924 927 884 998 900 0 0 0 0 0 0 0 0 0 0\n780 0 0 757]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n14 0 obj\n<</BaseFont/EFYKBB+CMMI9/FontDescriptor 13 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 771 778 734 848 756 656 0 0 0 0 0 0 0 0 0\n0 0 0 628]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n12 0 obj\n<</BaseFont/SZBQCB+CMSY9/FontDescriptor 11 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n799 285 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1028]\n/Encoding 65 0 R/Subtype/Type1>>\nendobj\n65 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n10 0 obj\n<</BaseFont/YAUXEU+TeX-cmex9/FontDescriptor 9 0 R/Type/Font\n/FirstChar 16/LastChar 33/Widths[\n614 614 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n814 814]\n/Encoding 66 0 R/Subtype/Type1>>\nendobj\n66 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n16/quotedblleft/quotedblright]>>\nendobj\n8 0 obj\n<</BaseFont/GHNQRB+CMR9/FontDescriptor 7 0 R/Type/Font\n/FirstChar 12/LastChar 121/Widths[ 571 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 400 400 0 0 285 0 0 0\n514 514 514 514 514 514 514 514 514 514 0 0 0 799 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 642 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 514 571 457 571 457 0 514 571 285 0 0 285 856 571 514\n571 0 402 405 400 0 0 0 0 542]\n/Encoding 67 0 R/Subtype/Type1>>\nendobj\n67 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n12/fi]>>\nendobj\n38 0 obj\n<</BaseFont/GKKKKC+CMSY10/FontDescriptor 37 0 R/Type/Font\n/FirstChar 54/LastChar 54/Widths[ 0]\n/Encoding 68 0 R/Subtype/Type1>>\nendobj\n68 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n54/negationslash]>>\nendobj\n36 0 obj\n<</BaseFont/WSXSQF+CMMI7/FontDescriptor 35 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 859 863 819 934 839 725 0 0 0 0 0 0 0 0 0\n727]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n34 0 obj\n<</BaseFont/GCFFPC+CMMI10/FontDescriptor 33 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 750 759 715 828 738 643 0 0 0 0 0 0 0 0 0\n642 0 0 613]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n28 0 obj\n<</BaseFont/EMLRVG+CMR6/FontDescriptor 27 0 R/Type/Font\n/FirstChar 40/LastChar 49/Widths[ 481 481 0 0 0 0 0 0\n0 611]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n22 0 obj\n<</BaseFont/QYXKNE+CMR10/FontDescriptor 21 0 R/Type/Font\n/FirstChar 40/LastChar 121/Widths[ 389 389 0 0 278 333 278 0\n500 500 500 500 0 0 500 0 0 0 278 0 0 778 0 0\n0 0 0 0 764 681 0 785 0 0 0 0 0 0 750 0\n0 778 0 0 722 0 0 0 0 0 0 0 0 0 0 0\n0 500 556 444 556 444 306 500 556 278 306 0 278 833 556 500\n556 0 392 394 389 556 528 0 0 528]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n19 0 obj\n<</Type/FontDescriptor/FontName/YWRBPR+CMMI5/FontBBox[0 -22 975 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 146\n/MissingWidth 333\n/CharSet(/A/B/C/P)/FontFile3 40 0 R>>\nendobj\n17 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY6/FontBBox[0 0 1128 432]/Flags 4\n/Ascent 432\n/CapHeight 432\n/Descent 0\n/ItalicAngle 0\n/StemV 169\n/CharSet(/arrowright/minus/periodcentered)/FontFile3 42 0 R>>\nendobj\n15 0 obj\n<</Type/FontDescriptor/FontName/MUQRQK+CMMI6/FontBBox[0 -21 944 714]/Flags 4\n/Ascent 714\n/CapHeight 714\n/Descent -21\n/ItalicAngle 0\n/StemV 141\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/S)/FontFile3 44 0 R>>\nendobj\n13 0 obj\n<</Type/FontDescriptor/FontName/EFYKBB+CMMI9/FontBBox[0 -22 823 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 123\n/MissingWidth 333\n/CharSet(/A/B/C/D/E/F/S)/FontFile3 46 0 R>>\nendobj\n11 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY9/FontBBox[0 0 970 430]/Flags 4\n/Ascent 430\n/CapHeight 430\n/Descent 0\n/ItalicAngle 0\n/StemV 145\n/CharSet(/arrowright/minus/periodcentered)/FontFile3 48 0 R>>\nendobj\n9 0 obj\n<</Type/FontDescriptor/FontName/YAUXEU+TeX-cmex9/FontBBox[0 -2957 781 45]/Flags 4\n/Ascent 45\n/CapHeight 45\n/Descent -2957\n/ItalicAngle 0\n/StemV 117\n/MissingWidth 250\n/CharSet(/quotedblleft/quotedblright/exclam/space)/FontFile3 50 0 R>>\nendobj\n7 0 obj\n<</Type/FontDescriptor/FontName/GHNQRB+CMR9/FontBBox[0 -249 833 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -249\n/ItalicAngle 0\n/StemV 124\n/MissingWidth 342\n/CharSet(/L/y/n/c/parenleft/three/o/four/d/parenright/p/e/five/six/fi/r/g/comma/seven/s/h/eight/t/i/nine/zero/l/a/one/equal/m/b/two)/FontFile3 52 0 R>>\nendobj\n37 0 obj\n<</Type/FontDescriptor/FontName/GKKKKC+CMSY10/FontBBox[0 -216 638 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -216\n/ItalicAngle 0\n/StemV 95\n/CharSet(/negationslash)/FontFile3 54 0 R>>\nendobj\n35 0 obj\n<</Type/FontDescriptor/FontName/WSXSQF+CMMI7/FontBBox[0 -20 893 713]/Flags 4\n/Ascent 713\n/CapHeight 713\n/Descent -20\n/ItalicAngle 0\n/StemV 133\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F)/FontFile3 56 0 R>>\nendobj\n33 0 obj\n<</Type/FontDescriptor/FontName/GCFFPC+CMMI10/FontBBox[0 -22 804 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 120\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F/S)/FontFile3 58 0 R>>\nendobj\n27 0 obj\n<</Type/FontDescriptor/FontName/EMLRVG+CMR6/FontBBox[0 -250 505 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 75\n/MissingWidth 416\n/CharSet(/parenleft/parenright/one)/FontFile3 60 0 R>>\nendobj\n21 0 obj\n<</Type/FontDescriptor/FontName/QYXKNE+CMR10/FontBBox[-40 -250 813 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 121\n/MissingWidth 333\n/CharSet(/y/n/c/parenleft/three/o/d/parenright/N/p/e/D/f/E/six/r/g/comma/Q/s/h/hyphen/G/t/i/period/u/colon/j/T/v/zero/l/a/one/equal/m/b/two)/FontFile3 62 0 R>>\nendobj\n2 0 obj\n<</Producer(ESP Ghostscript 815.01)\n/CreationDate(D:20060627000041)\n/ModDate(D:20060627000041)\n/Creator(dvips\\(k\\) 5.95a Copyright 2005 Radical Eye Software)\n/Title(proof1.dvi)>>endobj\nxref\n0 69\n0000000000 65535 f \n0000006062 00000 n \n0000029628 00000 n \n0000005989 00000 n \n0000005533 00000 n \n0000000015 00000 n \n0000002468 00000 n \n0000028076 00000 n \n0000025016 00000 n \n0000027825 00000 n \n0000024720 00000 n \n0000027608 00000 n \n0000024390 00000 n \n0000027387 00000 n \n0000024188 00000 n \n0000027166 00000 n \n0000023986 00000 n \n0000026948 00000 n \n0000023656 00000 n \n0000026733 00000 n \n0000023464 00000 n \n0000029287 00000 n \n0000026340 00000 n \n0000006110 00000 n \n0000005684 00000 n \n0000002488 00000 n \n0000003823 00000 n \n0000029055 00000 n \n0000026165 00000 n \n0000006217 00000 n \n0000005837 00000 n \n0000003844 00000 n \n0000005512 00000 n \n0000028831 00000 n \n0000025960 00000 n \n0000028610 00000 n \n0000025764 00000 n \n0000028405 00000 n \n0000025525 00000 n \n0000006335 00000 n \n0000006400 00000 n \n0000007338 00000 n \n0000007358 00000 n \n0000007807 00000 n \n0000007827 00000 n \n0000009157 00000 n \n0000009178 00000 n \n0000010552 00000 n \n0000010573 00000 n \n0000011029 00000 n \n0000011049 00000 n \n0000011947 00000 n \n0000011967 00000 n \n0000015611 00000 n \n0000015632 00000 n \n0000015980 00000 n \n0000016000 00000 n \n0000017292 00000 n \n0000017313 00000 n \n0000018761 00000 n \n0000018782 00000 n \n0000019302 00000 n \n0000019322 00000 n \n0000023443 00000 n \n0000023871 00000 n \n0000024605 00000 n \n0000024908 00000 n \n0000025441 00000 n \n0000025669 00000 n \ntrailer\n<< /Size 69 /Root 1 0 R /Info 2 0 R\n/ID [(ձ7H甅r)(ձ7H甅r)]\n>>\nstartxref\n29821\n%%EOF\n','Proved','BZh91AY&SY8\0߀tg翧%j`gH\"\0(@\0\0jO%\0\0\0\0\0\0q&CMѦL@hL ɆH\0\0\0\0\0\0\0\0\r\0q&CMѦL@hL ɄI4RhOPi\'\Z\r\ZJI4#TICB\rF\0#4<Pl33%S FI(vb22bXɄiiQK1Le+1f[	Km#,e3+1kQk#bD\0#+pKQdH,Ufb\rWtvP0dj@%\r0yEr䶐MeXFFIH W܇iopѯ<`}#wx0HɑEy(+rԩjP<\\v0)ŭa׻OeIz>}+N}b-z~#]0ᄞ42G̉|.@(\0ΧJN9s\"K.8GkBīaţS\n(hBS$A*DH&.F	Yq:֮|kMMSW{ӝsmme\\[mwMkkeBes&sNDh&C8Awx\Z(0R\\P%cz>NnSC:!Q\ZjQdt\\4q0UMA\ZjDdU\r4`H,rM&2h)DJ`@d#0sd.lʐl$\\e\"UDZ#\0eK?ЅI\n&LڢpcC&@@ݶҘ25ܤBIfR)DNMQ\'YG6`X͟]\r\ZCL\0hPkoYك~C7:x?#ُ-1ˆ5/>Q\rF\rڽ\'\'{v;Ѿq^-MUT86=M#.m,vjqrfqx\\G2f<^\'Gi}εCƸ*;^qp9pG:#Ww>lI]MvwT$Ș2KbLE1XY\'_ulvvTrdylc1gm9nhjoeiǚR5\\Y33M;ٝ|NӰڜ\r;>\"DaS̍Sעl>Fյ8\\i`e2`q\r1oImf\reZsV,Xda2bh#V*U>\rpg&JneYi</;Gk\'!5I]q#HpV͛$g.op:%m(z{ȒUsl38#\Z:|ĲXG-,\rW%q#]dAȻ\\jGn^i>\"JYAO.UOOq{y䗇{bo]|&jM;\"=:^\';H[wU|ħ_irhS,L_]BB_'),(22,'point A 40 10\r\npoint B 90 10 \r\n%point C 120 10\r\nonline C A B\r\n\r\ndrawline A C\r\n \r\ncmark_b A\r\ncmark_b B\r\ncmark_b C\r\n\r\npoint A_1 25 40\r\npoint B_1 45 45\r\n%point C_1 65 50\r\nonline C_1 A_1 B_1\r\n\r\n\r\nline A_1B_1 A_1 B_1 \r\n\r\ndrawline A_1 C_1\r\ncmark_t A_1\r\ncmark_t B_1\r\ncmark_t C_1\r\n\r\nline AB_1 A B_1\r\nline AC_1 A C_1\r\nline BA_1 B A_1\r\nline BC_1 B C_1\r\nline CA_1 C A_1\r\nline CB_1 C B_1\r\n\r\ndrawsegment A B_1\r\ndrawsegment A C_1\r\ndrawsegment B A_1\r\ndrawsegment B C_1\r\ndrawsegment C A_1\r\ndrawsegment C B_1\r\n\r\n\r\nintersec P AB_1 BA_1\r\nintersec Q AC_1 CA_1\r\nintersec S BC_1 CB_1\r\ncmark_l P\r\ncmark_t Q\r\ncmark_t S\r\n\r\ncolor 255 0 0\r\ndrawline P S\r\n\r\nprove { equal { signed_area3 P Q S } 0 }','<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE figure SYSTEM \"GeoCons.dtd\">\n<?xml-stylesheet href=\"GeoConsNL.xsl\" type=\"text/xsl\"?>\n\n<figure>\n	<define>\n		<fixed_point x=\"40.000000\" y=\"10.000000\">A</fixed_point>\n		<fixed_point x=\"90.000000\" y=\"10.000000\">B</fixed_point>\n	</define>\n\n	<construct>\n		<random_point_on_line><new_point>C</new_point><point>A</point><point>B</point></random_point_on_line>\n	</construct>\n\n	<draw>\n		<line_pp><point>A</point><point>C</point></line_pp>\n	</draw>\n\n	<labels>\n		<point_label direction=\"270\"><point>A</point></point_label>\n		<point_label direction=\"270\"><point>B</point></point_label>\n		<point_label direction=\"270\"><point>C</point></point_label>\n	</labels>\n\n	<define>\n		<fixed_point x=\"25.000000\" y=\"40.000000\">A_1</fixed_point>\n		<fixed_point x=\"45.000000\" y=\"45.000000\">B_1</fixed_point>\n	</define>\n\n	<construct>\n		<random_point_on_line><new_point>C_1</new_point><point>A_1</point><point>B_1</point></random_point_on_line>\n		<ruler><new_line>A_1B_1</new_line><point>A_1</point><point>B_1</point></ruler>\n	</construct>\n\n	<draw>\n		<line_pp><point>A_1</point><point>C_1</point></line_pp>\n	</draw>\n\n	<labels>\n		<point_label direction=\"90\"><point>A_1</point></point_label>\n		<point_label direction=\"90\"><point>B_1</point></point_label>\n		<point_label direction=\"90\"><point>C_1</point></point_label>\n	</labels>\n\n	<construct>\n		<ruler><new_line>AB_1</new_line><point>A</point><point>B_1</point></ruler>\n		<ruler><new_line>AC_1</new_line><point>A</point><point>C_1</point></ruler>\n		<ruler><new_line>BA_1</new_line><point>B</point><point>A_1</point></ruler>\n		<ruler><new_line>BC_1</new_line><point>B</point><point>C_1</point></ruler>\n		<ruler><new_line>CA_1</new_line><point>C</point><point>A_1</point></ruler>\n		<ruler><new_line>CB_1</new_line><point>C</point><point>B_1</point></ruler>\n	</construct>\n\n	<draw>\n		<segment><point>A</point><point>B_1</point></segment>\n		<segment><point>A</point><point>C_1</point></segment>\n		<segment><point>B</point><point>A_1</point></segment>\n		<segment><point>B</point><point>C_1</point></segment>\n		<segment><point>C</point><point>A_1</point></segment>\n		<segment><point>C</point><point>B_1</point></segment>\n	</draw>\n\n	<construct>\n		<intersection><new_point>P</new_point><line>AB_1</line><line>BA_1</line></intersection>\n		<intersection><new_point>Q</new_point><line>AC_1</line><line>CA_1</line></intersection>\n		<intersection><new_point>S</new_point><line>BC_1</line><line>CB_1</line></intersection>\n	</construct>\n\n	<labels>\n		<point_label direction=\"180\"><point>P</point></point_label>\n		<point_label direction=\"90\"><point>Q</point></point_label>\n		<point_label direction=\"90\"><point>S</point></point_label>\n	</labels>\n\n	<draw color=\"FF0000\">\n		<line_pp><point>P</point><point>S</point></line_pp>\n	</draw>\n\n	<conjecture>\n		<prove proof_level=\"1\" proof_limit=\"10000\">\n			<equality>\n				<expression>\n					<signed_area3><point>P</point><point>Q</point><point>S</point></signed_area3>\n				</expression>\n				<expression>\n					<number>0.000000</number>\n				</expression>\n			</equality>\n		</prove>\n	</conjecture>\n\n</figure>','2006-04-06',2,1,'GEO0005','%PDF-1.2\n%쏢\n5 0 obj\n<</Length 6 0 R/Filter /FlateDecode>>\nstream\nxMu[#ERX\"$k#|@>6a$~?zwAP`G̬}H\Zu?_ڥ6jݛ\"˚&	;?IRX(-QsjmʶjoQθ~\rq\nuR7?.	bN 1#ڑdOx\'oR9	Ȩ߶_VX/#X׻7lr\Z?;Flѫǻiߗo_WOď{FWVZYA$tfWcn\n\rX+A0kV/uU?ړ \")|ߛ\\LO#Y\\Jhm\04Llp;i\"|};ɱ3z!fQ_8r.pasvvֈMÜ-|O\nho0]ڇǩs\n=utM\'!4:h1Ս%T~9[=j M9FkA9B>(	Sq9\r޴oX\ZV~K\\`{-5;{q/1RFҮ]&+*Y7w=%fy1ҵFvj/\rf9ZlgJ<3%3k]yfJdiL$SyI|\'v~ntT\'R`iy@Q]CyhAzEudIptYv&̤eLDR{&L\"\ruUGώ/#=~pJu~0X\'\r2./poq\0O}wu\rk4䵞2 z9L\"yöDَgnWJc.@a\ZH21WdIϋL=]#\n[K̥2,_0vͧ;S=;(KaxRY7VvXȩ.W\rƴ/32犳3=fSD6g;N1\r)Hh`px8+̝ju9u-\\Z~4Ak)\":qjpOP)禍ޜWD\ZZD~kOh1\rKuvUsk74\'אލ	\nvN4Xy{n<v!~r?!+>uy ?oGf06aeBtƄ0G!5MiZj^Vjhkgs\rxDuFӓԼ\Z{\Z`P%c CfK5<yׯ,az[+-ծf4rAaW3z^z]CQu|H?\r!:):,Q>mSȨ6l/,냰j	;!nO6w\ru#Uy`yIt$6\\X{V)VBHA𻒋;W/q1ҴcE9U\"\"C#{Rփ:,xNM9ϣFgWsc{\Z+:HU1\\QhU%r\0,\ZXJ\0xVڡeC.DEʁ|\r,Xh*5W8&67f		A?b\'X$gYht\rhjxNս>fx._`jbqَ\\ɃQ)͖:HsPrNVRS1]rulE\"${]SˊECYHyvm|h\"TPG`I!%KWVc)`1,Ļ)Gv4{7d$SI2_P	M<XM>R(q֬HHv2|,++x`8pI*H\npEn^jw*W%WǓW]g~MZ\'o\'m)0SXz(؎EJ9U;}X;?ޑX{.5|~Εy-+zl5¿-ZB2hɼ=ژQU%s9\")sfsx770BavsUN^#=S|HukE\"]TdlBjET,Jz}7\"Y(Y滋y`8\n+	}q#NM^bUuV#ZuNn%ƲMIpcڅx#*wTd[$94Qr+R؍EqzNI$s\\jLH so^6ܪr&	@n2u^dREɛ;S!?윧endstream\nendobj\n6 0 obj\n2383\nendobj\n25 0 obj\n<</Length 26 0 R/Filter /FlateDecode>>\nstream\nxKoEǝ|m#aVpN@=ޱw8 [tUw~Ue4)#?UU>*ROwU7uLLlJ:`\\\r~v^U/u!s㵥`Cq\rAD!hyΰھOE\"XpS	=ju9V{zC߉ñ+2_5FA_(Nώec\\ѣig\"iy9dujW56fxש6}Vm?Q411gk9\'ꢺQ堉U$!?9ϿU}xS:Z<?:,4Iu,;F%\Z\'\r<UYG[9,qm,ixo+ዤ8٬Ӄxŭv9+HzE۽23]ȴίK QH7*EYʐbh\'uOf	\"O֯Z$!׿t߼iX!Üplo7HڗH}	lC<jl=d||ِ.8uJ߻ףp3\"!j3E\rh3{C#AKT0ȁAI]-!<\"mrqA!.OHm\"lz\\^ .4+n6i,AYqy+K,H#MrPLEzʤ(MiRs{XkRXq\Zۏ}I{@L>(싾g#bϞZYT%;G+e>i|DhY>8\Zu]x]|pI7\\KG]x{q]΀\r`+Xa{.`-Sczܻ7?=J==6GF\n@Mp_GANH	A^#*;n5Ys7Y~żcw\Zbڥ_!\n\"$Șbd!>)hW|JY8kV*nZ<z[ehʅ}L^K+HA4n\'tvZ2e9+Ȓ#{]܀\"s%ڲ-Rr	捕v(pw;=l:Ɩ0kO_,kZע00[cw[\0Y\\(e늳`d#lRvQ\rU{endstream\nendobj\n26 0 obj\n1263\nendobj\n31 0 obj\n<</Length 32 0 R/Filter /FlateDecode>>\nstream\nxZn6BRѥə-@it>$}iޤ@3Vj]خ0`ks8̐\ZW[>}]ukWY0udR퀢II:T\'??|:~]u:_T\'h}v>\\V\0lr@y:hBiQ\nؘ֚H9nXbRG7֣\r3^3\\/՟[4,0%lmސip[?yⒷ<^dD!:6;/~|b{؜/v3C?V/60v)s8jC0J&}9*oc5]Sn-_vAa4!#e9섇[b,j|_vZM7s \n~W̾-yᲉ9հL\ngaG-z=L<i1)ِ&τؼ\\L1urA^X%3,v\ryc0!ʑOc4m6j2d͓9ʔgfS9SYs0AY/O21A}P$M2Q`6^<EGؿ+Y!؏)t=U\'G_8+;TT{5\'f%g͇5A|N̍NV8Pt\ZDe\ZVAv\"vHW-;cg;}W-9wnFכ(rښcIs\\L}T9`9͹H|Ys}¢;Fչik|\'$hQSIͱ^epkp;oyn!z\\VS̼iȄg܋9Bbőnc!$Y񺤶D9A	TR\Z!S)(kд.S!OK	<{{P%#Lhh%V˕N܋e	G|urdƶhcd(Re2<2\n̮.G5C-iH鿣3:c#g	Wș07\rGeN[HGDu??E;9Vѥ	\r>\'B\\yh.CZBszʷ<\\\"2g)~}d趥hq^GϿ[ہ|tEܟ_Vdh\':yߴ[&gPQ*`r}`פ}.E]T.3;::َVߤ+[\rU8cȻda$ް\\ٔM_F]V58U\0=cӄ̀4x:K0Rd3f7+hGt7}#lT *~4H7S0:\0\Z\r)\rM\nH\n)h{.\"kQ$j?b)2tct`aP.q߭_Au\Z/TiEY\"mP12k\0&Ŗ5lyeɉLv;\n endstream\nendobj\n32 0 obj\n1596\nendobj\n4 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 23 0 R\n>>\n/Contents 5 0 R\n>>\nendobj\n24 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 29 0 R\n>>\n/Contents 25 0 R\n>>\nendobj\n30 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 0/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 39 0 R\n>>\n/Contents 31 0 R\n>>\nendobj\n3 0 obj\n<< /Type /Pages /Kids [\n4 0 R\n24 0 R\n30 0 R\n] /Count 3\n>>\nendobj\n1 0 obj\n<</Type /Catalog /Pages 3 0 R\n>>\nendobj\n23 0 obj\n<</R20\n20 0 R/R18\n18 0 R/R16\n16 0 R/R14\n14 0 R/R12\n12 0 R/R10\n10 0 R/R8\n8 0 R/R22\n22 0 R>>\nendobj\n29 0 obj\n<</R20\n20 0 R/R18\n18 0 R/R16\n16 0 R/R14\n14 0 R/R12\n12 0 R/R10\n10 0 R/R8\n8 0 R/R28\n28 0 R/R22\n22 0 R>>\nendobj\n39 0 obj\n<</R38\n38 0 R/R36\n36 0 R/R34\n34 0 R/R22\n22 0 R>>\nendobj\n40 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 41 0 R>>stream\nxM_lSu@S2콈P,e6&aFc5nOGtsoe[Ww?keQ		iQ7ʣ	#ӻ_y+/?9!fa;{j$Si2UbO}}</>;0=Cz|R}{߾RrJ=AHRWbXri}nts<MvgnRg#dq1t~qEfve,Wr-V_bؔ!\Z	M#=cGd82L?hI4\r /4X(HZLԌX\\..<;(Y:d(9{¼0LNMI(؊!99XRymr2/_Wu`ʌ~M,*Ȁi<hb\0q\'6i9#k^Mj7RKEA\">_![Ne؆{WyV*4Lo	BXUAUO\Z1=v ZFe}szd͗Y\n̍Eey<dH$&&-GnЭ%:EE>VDr@3Aʡ]mu:b}\Z?|/\"&l̬\Z2\'&!*2p.Yu;^EfPY8a\rI6tЭ|c\r+{\rnԇ/\'r	/\0?%-#aPψ^UVjrG.܃Cm]\'Ůc.cc_\n,Gw66߰lXXX!_X\nendstream\nendobj\n41 0 obj\n852\nendobj\n42 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 43 0 R>>stream\nxcd`ab`ddds\r4~H3a!ֹ}nP;*9(3=DAYS\\17(391O7$#57QOL-SpQ(VJ-N-*KM霟[PZZZXT_6QaCcb&|}c^柛\\ҽtiQw_>ڢ%33V/`w}D,*(ZVfͲek`82sɰn樛1eForovvIӺ56ߟsi~g_]7GSCG]z/^~	oi^p\0\0.\nendstream\nendobj\n43 0 obj\n363\nendobj\n44 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 45 0 R>>stream\nx}{lSu]׻6Y{;Pyl#@D-c\n0^]>m}ۮۺWvcSd	8Nb@AfbC@No	2/M%&P4M3_\":8!t7L-9s1c6.Ch7viV(3yU*ujeaL+]*5UZʼJeQFYҨ:=jj*fJ]MQTR^~m)j	zzʤPDJ%Q\'MՄ2Jeb#HCAEca\Zu8K^^_0-nв^x;\npIp\Z3[{?`cyI~x;G@u]>w{`,tquf{%\něrOcQz|h<jʅ:ppY4K*p127cR0^{*I3\rFP{ \Z6hvaObmmyHlЖYd6Od\\ Bfp^dݾUd/i.:(Jߗ=9^wv[m\\H#~\"DCrQIXzob(v4z-\"$s3G\\;r3c8XT^bpK|BI($UPRiZ|kE> kyIM?SϰVń05dd93퇕RbuEe	w>QfpgZD!ޫeTh435~`-`t.=x| \0^+v vZ1K31ɩ2-)b-sIC	vp\\)mR6n9g(\\]kK%OW^L;]wԁ7tWhynOA\riS_{rɂ,xEQm	~۩ro<	\'?!wƪ+8zE6i(vJ,\\+g1iG6G 5P4N6]3AvuIAD|.nkv7pB,ݭ	Kqd/KL1rY[/wvn-:\\do-&\0I1tL= e]d2\'Buۑt&y<KN\n8MM?\0捙v\nendstream\nendobj\n45 0 obj\n1244\nendobj\n46 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 47 0 R>>stream\nxklSeiak&,9\r\n8	crpeˀ:;6kq[˹<]vۨl	q}@AE1#fAIhD	&OP$y{IL$IRo-MرL,=&/\'w\Z44\rr&)$ٚ_Y[՘_[4ϼb.o.,)Th6VKcyf.IQm.T[u==++jk,vsa}?Aik_`A&s,b1Aki>PפM(2xBn&&=$жغ&.!ܒGuw+:SVcVGQ(VŮ	\0nl:XMv^R`)8 :1.Bfxܮf\Z7>.0)|ݠ;q(5w}TL\ZQިuغ\ZŎZ2P,G}5\"`]nb\'{HW>t>3D3GEs;mS- C~@ǧԥorsc#;Z7QH.Hg~\'ce&%1hYj<r3Ey/K)${=\Z;p=20r];{4{C7AU1D/1[q.6G|CDW|sh?묂\\,%\nn?i꒤~KrnSʐ\rE8K\rTԣTlǋWfJ^߀u\Zz^	$hc}R#1gK?dE#3\Z1\nU;4jf$O_ak^|*vi#oP$BS+ټf]~wH+c\"CG40#3gDqAx`sq꣺抢d9J DFqIR\rbw2\rwWp\r2jz@t8?$ HJk8,;Uɪ/\0\0lDA_Y٨ux;Jh\'m\nMaViO\"Uq=;vM>q~z_--P\'\0_5kSDRaTsI~#T)oJRijDmuqlf˄\'4ld*<W\Z~~A	hɂ8XSZ8%fd<~o/Q&8~7~\n2\"mUPy[Q\'ң?\\e?^y3rR᧛ROp¥DLľH	u1\nendstream\nendobj\n47 0 obj\n1288\nendobj\n48 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 49 0 R>>stream\nxcd`ab`ddds\r~H3a!+o\n~7n(_PYQᬩ`hiiZXX(\'gT)8(t+t-(-I-ROI-K,*/d1J	+1>{VtW9V[]V:{<FZg`_tE⢼E+W.^B?QKn.74\\&퓦ϝ\"+O=_ygŪ\'6vs475(w[M9҅?Ⱦ|m3xx\0L\nendstream\nendobj\n49 0 obj\n370\nendobj\n50 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 51 0 R>>stream\nx=Q]lUcbX[hI!TO4&h@6<Mvi]hidw;33wghk)-b*Ә\Z@Hx Rドфxg5;99|(4	(6y%^:mbl+]yUŶ]CH4\rE|G|;;7|-cCA\ZZ{VBchFuː\ZZV]x<5364q7sߙ@6^lccsRt`dpx6dӲԔ-Yq,M[sivttwh\0H3%82	D8;ɻ;aWlaӡ/CK3ihLS4_V*1Jdd8r0\ZDi+vlxm/x:~x\Z..KsȸjF=g\Z<opb&K×Cm\0:pxRH\\muWu4?;c0%&\ZyzBśad*=[oqq}3ر󧣥X)eN\nd\\)?l\'P;/%>z}d\0-a+Ta+\'&ON(;qWT#:Uk+ޣ}LT짍װK|k\\?/0{	w|O&ǒIYfL%EQX)GuG3^p\n|jbjjr+	0N!`li/4_FG?f<чv¿68\nendstream\nendobj\n51 0 obj\n812\nendobj\n52 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 53 0 R>>stream\nxWyTSwH+jm^X7\".Ūk  YDV!		bY\\@YTTܰj]h`bca<j3;9g受s^<dC$ih}gc}_\0X՛j[05q@t[U\Z/	\n;Nu8%\\,E8zp!q,g;H$vGe3]1rC\Z E1n}|4 R,HD~S͜;o~hy)A\"&b	Fl&܉O5b-A$6[1N FxMcwK&(xAț6N6͂% r	BP\'\n\':oؽmgwwps?zh+M^B\"G\n\Z;yL5d>f[;|Ӓ\nV@r+X|L6\"Y`]T-TJI ITKKf5A&(3S2&1x*I/оSYzBy4\"P\'R\'\\]QcIiׂTe	g>op9-|ַM$\ZԅP0v%Ji͏B<Ii+n氎ک5jіgB+i|k̡_<y{#I/>9+y24fX	Llf\\\"DQJ!˕UGQ3p̼w\r/TJ	=msϠhKEgղ|ȇN7ݨ[`U\n;(<TFr`qb$?\ZըifhӧJB*DY^ @DKsg7}TSL(\n-ѻW۾h8\r3xhM2nfZթymwxP퍕Tn7F5F5/ahm<f8|p,J\\\0\ZPjA3M։fu2tPvb@LUFՆ^\Z\rF6h4ble{~ho#`ˬULsF4?Jzb_qe]4-#yeF?FnnQ<cϛ[m?kG2\rEC^We䦦ejI{䵡mKHg|4Q%QENjH;rc/@SPjMB2Dӑ=5E\"9y%s۵EY5<㨕`*~WEVG{֞h5cJm7Ikc-Py҃D2(4zWMP^N2R\ZT;F!_W4>aUT/3P=dJtU%ft20r,\\;kK˹҃׺rȃ~b5QiѺ9jHNbAssLJ⨊Vrd)T=L\n&C⤨?MfU5@\'BZ<GQ{ 07+-(ikVx94ݾ~2*,(ϥ8*getЇ+\Z#\"oLf%CzŐWɑ;xK6\ZLWG\r1҂ȿvfrNd$K\ZU!ob;[(IP;|W+~\"W=\"HdFkSme2KX)؃W<7N@)?m*>9G9\ZK6	w-mh8ig~B5U?3wzG]gxq=OvVI{*uMr4\\Uek~5Ч;PjzE{kp69s1#jYr;/R h-e]Z+wU{ZM4++_OPWЫ!Cb;Eҭ#<\">u\\Y?x7}xu?Xe)Yxg@tO	ۯ@9d6&8])ܭQ1a~bctCH,ONSG)@Oq*9yAv+95h\ZfgkC/y+&>3\'Xx]=+-8J棟F|l!&0?)4UV\r\0<!\nI]*32h6`ۈ<˶>3Ȟ~\\EVZ\0-e ffVGCg+.\"! XYYg*)b7;DFGwrO`#,5#-c1,MKZ>:>.s㓚_}\ZKM&\\6\"t\n龿ZVG3|v>)eS,~[<[,\'ޑIxVl%WLgaa8=z~è٪W/-W(VR))!=Ս\Z	kh\Z^҈y,ҹs7ejJkb\rh2Y㭫nۤe|qxVXG\n\"Jd⊉lB$LȪx /._>l\rg2},|h~G/uг=u\'/MtPZ.	a+/ڀ~PfGxLI|jZ\riIӀN:\0؁e^G\ZMb*?ʅ|G+sM]m;\ZC_/-(b*EsehBʂR	л+LM%ҿn_PLF5dH*g53@<;HR_.R$R&poʂ\\uкzKLYd4Ws\0\r9\Z,&}c<Qx\0_eAG]̊ :0AUg6՜o{qx$F4)Ac9ϰ\Zf<!%ZqR\0JD<+mlyފ@}ֵSY5~57KՍIPkԐr(zZQq$=dK 7җ;>=lőŶK$WmB%7ɏÆf\0N}H9Hfx˩VGHUNKXlkfW8_T{y1[]bm:;\'8QĶQ~@DjEVΜ29Og7yqq1=ͼ@i8~q~-\"~tiey4	/WAͣ^ٲjƝrv&1PuQSa^ϒV^ypԥ:gnx\'u?XP3UXSY-<>z\0ѕ:T}#$EFlm&ƣ\'3cMe,f>fxî(@/S#5\"X喝Rv+C\'nlBȎ^/7^poꠈ\rfJ`+ 0)bcP\r1.7C(@\n)]`n-S}W	\nendstream\nendobj\n53 0 obj\n3558\nendobj\n54 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 55 0 R>>stream\nxcd`ab`dddw\r44\01H3a!;%k\n~n._PYQᬩ`hiiZXX(\'gT)8(t+@lu-(-I-ROI-KMj+I,````4c`b`bdd|?ڙr8cRV?aZ:%[&͜:qr|/d-0}3n9.<g00\0\0fZ\nendstream\nendobj\n55 0 obj\n262\nendobj\n56 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 57 0 R>>stream\nx}{lSuw.0@uTGoyaC6!%lH\"\Z*{Ji7ڵz{}l]Q[h\0MF\"E20!cb<Q~|{~IO#ðE%%kxI%fǴ{C9uip*=ETS\"zS\nn~E˖u5S\nCVrm0n4_VWR{te=Pgf^+1LEֿQL2#ϑE$N!%dY|V6!}d#r_lq|+(1\rv\r5#~Çp.dowxa\0¡@{ xz`傣ezasDG0G+F#]v_*y%?=b[hl}@ZB#x4$_²+jg\\\0>X\Z,@5f2\'XWi8al11\0QW\0B7@]s	}wiX%O+\ru$wq +[Kd^[XI>ΌJ^O%ve32\n\Z*P\'t>s{}7!Eඉ&vEuz:tgx\rc&N/^mZOӍw U +9~[W͊|dфk173WXSOI=.Gg~k1;haeK)Cq4W͔icS9\rYxW\Zװs s}%:-9~h\\r.{RjzH1_<\0\\vJu^Adhwq8U6;YW\'q?$Gp5~V!$EI^K罽ꕲf^\rv6y	x$9QwwʁS4Yj;mҢ^n9:횞]w5}.ǫJߐL?d[.Cr$W\\7M7\'x$;XľD[$x8G;рV>_x5!W(Ի:=G/zu`\'S}u*Me|Y:G<i{Y4[:||n5|-FC0K2\'~?I;1]˚0\"/\nendstream\nendobj\n57 0 obj\n1206\nendobj\n58 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 59 0 R>>stream\nxT{Pu`YNv+C\'|`JR\"Sf	\'Rݻ(xc:eik1%98YǌnPk&鏝ٝ> Д+?\"=4\nY!;#YϢϠ9ь)SN)**[oE%$%Ksuنlؠ,f7lЭ(խЗK%\\}I!EQl)/Jͤi+ԫT5zKM\"tPj>*hTu1xOtoZ[IP&gqnZnd-Nk}\0vjI2	z46z%8X9G-X)T}\nzK\01Bm:4@lfŕi\Z\n#!Aw}R5\\anh瑟AQ\n{>L0fNp`*\'~;@lEjf:\r˚-+@4k{ykj@d	@~@̝3qOHO1>M_/(bIE5\n፸\Z\'0Lk:0ߺv*6а05#5s٦E}bt?$_?$b6G7zrS?P}8}?\nۦz#yryEţ`<3n{K\\k&aG#O*8/\\ 	O06U\'} \\Idߣ3\ZȠi/\rx|?NS#IJ9BnR%T+v\\<:;Pqjnż<~է4%|ֵ@ hd2+AsIXDn	^\'\rӟ 4;sKPg.E]\0:,&ŹA!.L<11dq_E1H0D[1U1=C:Q\n%U6U<>aqc[ƭ,ؠ<Cibeo̅ͅes5Bs(Aʢh[7۸wU2\'Q#YlB1/[\'sI\n0\"\0BGE$PK.T˱% L>rQEgU~Y5u]BF9Co\r9T͏1m\\B̌XՍlsn\\${YZE;fĕDis9%}sd_隣D~$`hʙVSSk6~bY8s[X8;͒eniap\'v).,x~g^Wx8E!\nendstream\nendobj\n59 0 obj\n1362\nendobj\n60 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 61 0 R>>stream\nxcd`ab`dddu\r21H3a!G&u?\n~*_PYQᬩ`hiiZXX(\'gT)8(t+t-(-I-ROI-c```4d`dbb`add?U|V3[+x>w?~foݨ{]M<1}r}߆_~Ѽ\'NC5je߾~QE}GS[kOjv/~ktn7Nm]WWw+G[_[~\r4)Y{ӏZ+ۻs<Uӻ9Rؗv>O/{Vw\\B\nۡ݇fvM	*3-iYNƾ|Փxxe`\0\0}Y\nendstream\nendobj\n61 0 obj\n434\nendobj\n62 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 63 0 R>>stream\nxWiTS!@%Գ7mmš*-UqE2 )ʐM\0dNa0  \"JjzZNj7Q{{sZ{%yD\r%$Vsjd#fc8dvkx͑8aA硔X$Zb˂ȨX\'\\̙4?<P=/i_lH`_C>2`{`ld2:1Nc;=(EliU@yEQ\"\"\n\\H$v\"c/yw&Ou6}{ZC-R);zZBMR(jLyR˩\r\nj&ZEQ\0j eO9PCa#%S#1G9PP4U& ҈$EbFNv8`#20iσU\rvkpXr08tq>gaaXoUo6CSXvˢ0o-[uC[UGhb!t\n-#͚Dn:=mIhWgA֨&(tf: @n8PD#w%RxD.^e\\#0U%q]ޭ\'/=[	UM̤lkUn!G|nv誡\nNjb*+_.xsGn69z\ZnY֘\\\Zw7\\H/?J;En7Q{44a&Mx__貸*}避mB(2AG\"&/O	f#8gh=wA;XTJeQTs[0z=602Pʑh!(|\nGQ8w`T(}\"6Ҩh2bP$Џe4+3Ӌ_h2މ7FVy!OX\"%3h%~@21|!*Pt,@|1P}\'4@kٻ Ԑ8s,j,sjĘ;ݳ_|(^SPi5Q5yuPkB[5o)ӵ4ˤ#R` T`df:Ba.Jͥ!!8h*79tcopek;k;tbG͞o\r=a+`p/?!	\">zड़4/%jO骠\Z:\'+z9	t-q\'k#χ)cgFc(.߫KߣN۫CƺnbO@42Z2i>M`\rz:w\"},n*:e0WIr12?@q-#cЅtb9]iK>nE#kf+q-qQ߶M?fq+(Bۮ߉qe,3\'fCj1LlI\\um)~âY^kr%r6]\r68b;Fjof?(n1{Kdr\'jyK?,śL.M\\0U|?J(!<cD®ＬRҏ6_Je_ROWc8\ZGwсFǩ4q)D\ZeuuZ_ॾɜ*Є}-*_ݪ@p9wݮ4\Z!\'q;WTkM||b4aIr~oJld\00ιlsdWv6+ƃel(3ҕ$TmI2L^Cci+)!Bi/\nqk|!Yp/\Z;6pja\ra:ȂR=R5?F[pxmxm!FKIt0xRp8,\'K;d\'8L}y\\)GuCrfn\r^ ?s!XO=`!:}s!6亦_wgNf?0^qJ>=>,C@bŵN{4\Z-+bON2Bz֘qc\',`6>m<*df&d$Zmy9Ӂ1At|hݶ\\\\Fzu}sZnMLi	c\n!BB2]\r)8U=\ZH(t}HIdI{2Nkmn*|o6hWr[CQ\n=͖̎gZf	lp@0y[̣ݜA\Zu8,dduLe[\"li<tɠ*2\r<~RF6tQd5E?3\n|꓃֮~oqz4z/8$VzLĕrfNF-ɐ)j.]=h!d-{Bze{,.f҄7DN۩<eͼI[\'7DQQhsPZ9B\Zo5BW..dRu쌶S~b\Zd\nSqҙ5r--1ϫr_1Z$Wp\\\\q}ddB\\3g|v\'l[SQS[[Yi}ͥw\01&Q	s` ޓ{}(\'\n;gD(6dbC\\LҒ3>OE\0\r(:[*iCQYV@rA78t?*\rB̵$-36WQzK*GDkHhܖ|$XV(̞nTU3	׬Ws/@VZ/Y^ϼBH;q.gtkOL`MӫFCcwO[n/FHw*WlV@_0O4ehƱlhhm͛K3gײp}bUMjzGZۦArjjeüP~r.eѓlp֛8g@|?\\lwEoYb`w_+#Ro<ta\0qŞ/h6&nr7z%3I	;mAIs+4FWVgR!&ʘ&!MfBӯ<$z91\"K,%1A(vp+/1LHrM\n[v- dqVd=n\r`Oii*P\'?9%ӁD\n])BpW1iY\rphppQKJXV\"r@믑]\ZX_nUqc(9\'*21\Z)s_Nv=NJai5\\䋗Y~=ˏ~Sk-rtWxe=v脯Gξ_3$\\fZSp>ЕY䙄FWBsz+a,QH.[H@&QШ/;],jtA£NU1}t*ŅI\Z2a\Z\n]TM3\'x_S}v\']B K%=Oq*r;(\\\'niOBfijШ;s{s*xPRh_(-bVsI8O>39s\n3F/dnL?3k\ZkzcI/H]|pIQG[䚽u*դj`7#S*s;*Ѵd<ymqOBt1Qdko\ZF{HqmlMn[Vd,9|Ļd8#LyD(}i?M[8D+!|ZqB\\fZ%a+M5	R{0,& ͚fqa|Xtq^|ߏx+b$}$\ZIu)FH~<{7v~\0c_:\nendstream\nendobj\n63 0 obj\n4035\nendobj\n20 0 obj\n<</BaseFont/YWRBPR+CMMI5/FontDescriptor 19 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 1036 1037 996 0 0 0 0 0 0 0 0 0 0 0 0\n875]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n18 0 obj\n<</BaseFont/SZBQCB+CMSY6/FontDescriptor 17 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n963 380 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1222]\n/Encoding 64 0 R/Subtype/Type1>>\nendobj\n64 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n16 0 obj\n<</BaseFont/MUQRQK+CMMI6/FontDescriptor 15 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 924 927 884 998 900 0 0 0 0 0 0 0 0 0 0\n780 0 0 757]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n14 0 obj\n<</BaseFont/EFYKBB+CMMI9/FontDescriptor 13 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 771 778 734 848 756 656 0 0 0 0 0 0 0 0 0\n0 0 0 628]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n12 0 obj\n<</BaseFont/SZBQCB+CMSY9/FontDescriptor 11 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n799 285 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1028]\n/Encoding 65 0 R/Subtype/Type1>>\nendobj\n65 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n10 0 obj\n<</BaseFont/YAUXEU+TeX-cmex9/FontDescriptor 9 0 R/Type/Font\n/FirstChar 16/LastChar 33/Widths[\n614 614 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n814 814]\n/Encoding 66 0 R/Subtype/Type1>>\nendobj\n66 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n16/quotedblleft/quotedblright]>>\nendobj\n8 0 obj\n<</BaseFont/GHNQRB+CMR9/FontDescriptor 7 0 R/Type/Font\n/FirstChar 12/LastChar 121/Widths[ 571 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 400 400 0 0 285 0 0 0\n514 514 514 514 514 514 514 514 514 514 0 0 0 799 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 642 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 514 571 457 571 457 0 514 571 285 0 0 285 856 571 514\n571 0 402 405 400 0 0 0 0 542]\n/Encoding 67 0 R/Subtype/Type1>>\nendobj\n67 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n12/fi]>>\nendobj\n38 0 obj\n<</BaseFont/GKKKKC+CMSY10/FontDescriptor 37 0 R/Type/Font\n/FirstChar 54/LastChar 54/Widths[ 0]\n/Encoding 68 0 R/Subtype/Type1>>\nendobj\n68 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n54/negationslash]>>\nendobj\n36 0 obj\n<</BaseFont/WSXSQF+CMMI7/FontDescriptor 35 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 859 863 819 934 839 725 0 0 0 0 0 0 0 0 0\n727]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n34 0 obj\n<</BaseFont/GCFFPC+CMMI10/FontDescriptor 33 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 750 759 715 828 738 643 0 0 0 0 0 0 0 0 0\n642 0 0 613]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n28 0 obj\n<</BaseFont/EMLRVG+CMR6/FontDescriptor 27 0 R/Type/Font\n/FirstChar 40/LastChar 49/Widths[ 481 481 0 0 0 0 0 0\n0 611]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n22 0 obj\n<</BaseFont/QYXKNE+CMR10/FontDescriptor 21 0 R/Type/Font\n/FirstChar 40/LastChar 121/Widths[ 389 389 0 0 278 333 278 0\n500 500 500 500 0 0 500 0 0 0 278 0 0 778 0 0\n0 0 0 0 764 681 0 785 0 0 0 0 0 0 750 0\n0 778 0 0 722 0 0 0 0 0 0 0 0 0 0 0\n0 500 556 444 556 444 306 500 556 278 306 0 278 833 556 500\n556 0 392 394 389 556 528 0 0 528]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n19 0 obj\n<</Type/FontDescriptor/FontName/YWRBPR+CMMI5/FontBBox[0 -22 975 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 146\n/MissingWidth 333\n/CharSet(/A/B/C/P)/FontFile3 40 0 R>>\nendobj\n17 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY6/FontBBox[0 0 1128 432]/Flags 4\n/Ascent 432\n/CapHeight 432\n/Descent 0\n/ItalicAngle 0\n/StemV 169\n/CharSet(/arrowright/minus/periodcentered)/FontFile3 42 0 R>>\nendobj\n15 0 obj\n<</Type/FontDescriptor/FontName/MUQRQK+CMMI6/FontBBox[0 -21 944 714]/Flags 4\n/Ascent 714\n/CapHeight 714\n/Descent -21\n/ItalicAngle 0\n/StemV 141\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/S)/FontFile3 44 0 R>>\nendobj\n13 0 obj\n<</Type/FontDescriptor/FontName/EFYKBB+CMMI9/FontBBox[0 -22 823 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 123\n/MissingWidth 333\n/CharSet(/A/B/C/D/E/F/S)/FontFile3 46 0 R>>\nendobj\n11 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY9/FontBBox[0 0 970 430]/Flags 4\n/Ascent 430\n/CapHeight 430\n/Descent 0\n/ItalicAngle 0\n/StemV 145\n/CharSet(/arrowright/minus/periodcentered)/FontFile3 48 0 R>>\nendobj\n9 0 obj\n<</Type/FontDescriptor/FontName/YAUXEU+TeX-cmex9/FontBBox[0 -2957 781 45]/Flags 4\n/Ascent 45\n/CapHeight 45\n/Descent -2957\n/ItalicAngle 0\n/StemV 117\n/MissingWidth 250\n/CharSet(/quotedblleft/quotedblright/exclam/space)/FontFile3 50 0 R>>\nendobj\n7 0 obj\n<</Type/FontDescriptor/FontName/GHNQRB+CMR9/FontBBox[0 -249 833 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -249\n/ItalicAngle 0\n/StemV 124\n/MissingWidth 342\n/CharSet(/L/y/n/c/parenleft/three/o/four/d/parenright/p/e/five/six/fi/r/g/comma/seven/s/h/eight/t/i/nine/zero/l/a/one/equal/m/b/two)/FontFile3 52 0 R>>\nendobj\n37 0 obj\n<</Type/FontDescriptor/FontName/GKKKKC+CMSY10/FontBBox[0 -216 638 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -216\n/ItalicAngle 0\n/StemV 95\n/CharSet(/negationslash)/FontFile3 54 0 R>>\nendobj\n35 0 obj\n<</Type/FontDescriptor/FontName/WSXSQF+CMMI7/FontBBox[0 -20 893 713]/Flags 4\n/Ascent 713\n/CapHeight 713\n/Descent -20\n/ItalicAngle 0\n/StemV 133\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F)/FontFile3 56 0 R>>\nendobj\n33 0 obj\n<</Type/FontDescriptor/FontName/GCFFPC+CMMI10/FontBBox[0 -22 804 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 120\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F/S)/FontFile3 58 0 R>>\nendobj\n27 0 obj\n<</Type/FontDescriptor/FontName/EMLRVG+CMR6/FontBBox[0 -250 505 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 75\n/MissingWidth 416\n/CharSet(/parenleft/parenright/one)/FontFile3 60 0 R>>\nendobj\n21 0 obj\n<</Type/FontDescriptor/FontName/QYXKNE+CMR10/FontBBox[-40 -250 813 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 121\n/MissingWidth 333\n/CharSet(/y/n/c/parenleft/three/o/d/parenright/N/p/e/D/f/E/six/r/g/comma/Q/s/h/hyphen/G/t/i/period/u/colon/j/T/v/zero/l/a/one/equal/m/b/two)/FontFile3 62 0 R>>\nendobj\n2 0 obj\n<</Producer(ESP Ghostscript 815.01)\n/CreationDate(D:20060627000135)\n/ModDate(D:20060627000135)\n/Creator(dvips\\(k\\) 5.95a Copyright 2005 Radical Eye Software)\n/Title(proof1.dvi)>>endobj\nxref\n0 69\n0000000000 65535 f \n0000006062 00000 n \n0000029628 00000 n \n0000005989 00000 n \n0000005533 00000 n \n0000000015 00000 n \n0000002468 00000 n \n0000028076 00000 n \n0000025016 00000 n \n0000027825 00000 n \n0000024720 00000 n \n0000027608 00000 n \n0000024390 00000 n \n0000027387 00000 n \n0000024188 00000 n \n0000027166 00000 n \n0000023986 00000 n \n0000026948 00000 n \n0000023656 00000 n \n0000026733 00000 n \n0000023464 00000 n \n0000029287 00000 n \n0000026340 00000 n \n0000006110 00000 n \n0000005684 00000 n \n0000002488 00000 n \n0000003823 00000 n \n0000029055 00000 n \n0000026165 00000 n \n0000006217 00000 n \n0000005837 00000 n \n0000003844 00000 n \n0000005512 00000 n \n0000028831 00000 n \n0000025960 00000 n \n0000028610 00000 n \n0000025764 00000 n \n0000028405 00000 n \n0000025525 00000 n \n0000006335 00000 n \n0000006400 00000 n \n0000007338 00000 n \n0000007358 00000 n \n0000007807 00000 n \n0000007827 00000 n \n0000009157 00000 n \n0000009178 00000 n \n0000010552 00000 n \n0000010573 00000 n \n0000011029 00000 n \n0000011049 00000 n \n0000011947 00000 n \n0000011967 00000 n \n0000015611 00000 n \n0000015632 00000 n \n0000015980 00000 n \n0000016000 00000 n \n0000017292 00000 n \n0000017313 00000 n \n0000018761 00000 n \n0000018782 00000 n \n0000019302 00000 n \n0000019322 00000 n \n0000023443 00000 n \n0000023871 00000 n \n0000024605 00000 n \n0000024908 00000 n \n0000025441 00000 n \n0000025669 00000 n \ntrailer\n<< /Size 69 /Root 1 0 R /Info 2 0 R\n/ID [(M7g!x0M)(M7g!x0M)]\n>>\nstartxref\n29821\n%%EOF\n','Proved','BZh91AY&SY.\0tgg$z`}@).q \0qj\0FH$`N\"ֵ64*Tѣh&bF\0i\0\0hRzM4\04 CbAѣh&bF\0i\0\0JE)Sh\r\0\0P2\0ijU#$ƪ\rL=S&\02&\0\0\0b\Z4IJ53QSI=Fj~\0=OS=@\0P\0~\n(+@vԒIK4Ԩ1khi6ڊ&`M1fTѤZՙPme5ede21hULɖFcZjA\0Ej)SJve%%ST5,0Y5-hʆ6[I6\n 6PB\Zf!MС8\nTWƐ5}<}O[EG}|̊oR|G>`M?R;Oc\\H<zWŏ\"x>wQO_N-	#ZL}լe+(I\Z=`fk4E$ATEye1C[<UCWn2 \".g@JDtBbb&62(BS\n)@ϼ?*\"\"))h4a>!J*\'ҪH}%D_b#ƨ?{>]t#$wD,Rw@aNp\'p_y+qHR$=]c,2WF6ơUu05XllG\\0X0@L=@*haFPxH\0hP6ls(K\"H=W3!$x<8&A8xÜ!́T)!c\"j79+J0:Exf\'@q\rdZegcFCw@(%DD$,WB0,2C2(iu1KJ\0H3lcpŚZ\"+\Z`RVDˎad6\038XmlꝽ?LOu+/2yg@Pn:<]O5ߝwULA:8j1MECTF%J Stu:JpW9*pE^ު/x={y/KPuzU}xWؕvR]vH\nc7\"00p`pG]=w\0ZWZTIb,5B`-XJ-aYƛ*g4.uбA0V`kalPW<0+-+ 9IQaLQE*THW%{;jT\ZU\ZڢTR)B(\0(\nѤ`d[ɠ\Zg)\"$(Q,l\r7^_w؂)X\nss_GV]j\Zgb6C}ʗ+-Y4,le]Zed\0C\ra) !H`	2º$se\\tfT	\0&b\"3@6	@R25\0cuR̲sCJHI\0 gji\\&L\'`lDqnXged\nթ\n3fr㓑ȑv:+N%!Mrv8\0c#2ꃎuFP(3#1Ŵ:KfkHeC8c103$d,A3$\n\n((	9DTDU\n32-Du!8)dC\nbAKz\Z4)40LqsVar0\084E4*\"\ZSl8HB))5Q̌Ʋ+kfXhKZ`ښGM:fhCpZ9qI9XRNj	E.!ٞ\\HTÜ\n\n@h0AÂaM3htC! mƈ1\0!\"Cժ02jea:4Y/Pă#jI4)Hq`(E!%CLN\0ʀptȲA]DJֈ.\'3i:7YӤtӢ\';9Do^9s۷?7)a)s;Tu͔zW1+\\UZj&\"0V,\Z`pZV#*X&QV\ZYF]8\\(;Eo{oU&}߫U.r(}[^u)SB{z;`WCtK*vNt[66Uq$&u^=q-Z$2i3Fa\"$Ș0҅hnpыa#I!UkFqcCUA9 D)HH\rPBefW`b	I	df\\4UCV6dIɌ14NeY(rW\"&S%%Gw(;\"Fq茥)z*U$\n:_|ShM\'dUt\\*n/\0U$Q0aȠ\nyoD~Ȑ$<.@Hsv@TU!PCż<OJhUq\nzj}`ePyGS]ziWwSr[=Ui)=n8K|GČ4\rJe(eh	QRIU\Z\n%K!i`&\n㺵%y!pߘ]{zToTf͌ͬͬkVk*(9*.z/ҽ+<3J1DHLjCYHV\n*\n֤T Q^a0n+nuA\\VS.Jt0WBo.(\n@]SM*NIS\"UNВwT5$d#\"\Z5*Ȇ`T`.Z˗Ei]*)Q:bC%+!-uw\'yO	#ءR]R&[Ґw{oJyPS^$H$G\\+ەT>aTy^N88yuK(޷C{sTPgqҡ{jڇqIFI=0 P\0[qD&t&\0J#J\Z-,XOK{.kz$?!EǔHEAtQr2C8*|we<Ja\0nو,*PPtRJL<UCeT	|CfefF```$fA+\"(H{M\0'),(23,'dim 100 100\r\narea 5 5 90 90 \r\n\r\npoint A 30 20\r\npoint B 70 20\r\npoint C 40 70\r\n\r\npoint X 15 55\r\npoint Y 75 10\r\n\r\nline a B C\r\nline b A C\r\nline c A B\r\n\r\nline p X Y \r\n\r\nintersec D a p\r\nintersec E b p\r\nintersec F c p\r\n\r\ndrawsegment A B\r\ndrawsegment A C\r\ndrawsegment B C\r\n\r\ndrawline p \r\n\r\ncmark_b A\r\ncmark_t B\r\ncmark_t C\r\n\r\ncmark_t D\r\ncmark_lt E\r\ncmark_rt F\r\n\r\nprove { equal { signed_area3 D E F } { 0 } }','<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE figure SYSTEM \"GeoCons.dtd\">\n<?xml-stylesheet href=\"GeoConsNL.xsl\" type=\"text/xsl\"?>\n\n<figure>\n	<draw>\n		<dimensions width=\"100.000000\" height=\"100.000000\"></dimensions>\n		<area x1=\"5.000000\" y1=\"5.000000\" x2=\"90.000000\" y2=\"90.000000\"></area>\n	</draw>\n\n	<define>\n		<fixed_point x=\"30.000000\" y=\"20.000000\">A</fixed_point>\n		<fixed_point x=\"70.000000\" y=\"20.000000\">B</fixed_point>\n		<fixed_point x=\"40.000000\" y=\"70.000000\">C</fixed_point>\n		<fixed_point x=\"15.000000\" y=\"55.000000\">X</fixed_point>\n		<fixed_point x=\"75.000000\" y=\"10.000000\">Y</fixed_point>\n	</define>\n\n	<construct>\n		<ruler><new_line>a</new_line><point>B</point><point>C</point></ruler>\n		<ruler><new_line>b</new_line><point>A</point><point>C</point></ruler>\n		<ruler><new_line>c</new_line><point>A</point><point>B</point></ruler>\n		<ruler><new_line>p</new_line><point>X</point><point>Y</point></ruler>\n		<intersection><new_point>D</new_point><line>a</line><line>p</line></intersection>\n		<intersection><new_point>E</new_point><line>b</line><line>p</line></intersection>\n		<intersection><new_point>F</new_point><line>c</line><line>p</line></intersection>\n	</construct>\n\n	<draw>\n		<segment><point>A</point><point>B</point></segment>\n		<segment><point>A</point><point>C</point></segment>\n		<segment><point>B</point><point>C</point></segment>\n		<line>p</line>\n	</draw>\n\n	<labels>\n		<point_label direction=\"270\"><point>A</point></point_label>\n		<point_label direction=\"90\"><point>B</point></point_label>\n		<point_label direction=\"90\"><point>C</point></point_label>\n		<point_label direction=\"90\"><point>D</point></point_label>\n		<point_label direction=\"135\"><point>E</point></point_label>\n		<point_label direction=\"45\"><point>F</point></point_label>\n	</labels>\n\n	<conjecture>\n		<prove proof_level=\"1\" proof_limit=\"10000\">\n			<equality>\n				<expression>\n					<signed_area3><point>D</point><point>E</point><point>F</point></signed_area3>\n				</expression>\n				<expression>\n					<number>0.000000</number>\n				</expression>\n			</equality>\n		</prove>\n	</conjecture>\n\n</figure>','2006-04-06',2,1,'GEO0006','%PDF-1.2\n%쏢\n5 0 obj\n<</Length 6 0 R/Filter /FlateDecode>>\nstream\nxMu[#ERX\"$k#|@>6a$~?zwAP`G̬}H\Zu?_ڥ6jݛ\"˚&	;?IRX(-QsjmʶjoQθ~\rq\nuR7?.	bN 1#ڑdOx\'oR9	Ȩ߶_VX/#X׻7lr\Z?;Flѫǻiߗo_WOď{FWVZYA$tfWcn\n\rX+A0kV/uU?ړ \")|ߛ\\LO#Y\\Jhm\04Llp;i\"|};ɱ3z!fQ_8r.pasvvֈMÜ-|O\nho0]ڇǩs\n=utM\'!4:h1Ս%T~9[=j M9FkA9B>(	Sq9\r޴oX\ZV~K\\`{-5;{q/1RFҮ]&+*Y7w=%fy1ҵFvj/\rf9ZlgJ<3%3k]yfJdiL$SyI|\'v~ntT\'R`iy@Q]CyhAzEudIptYv&̤eLDR{&L\"\ruUGώ/#=~pJu~0X\'\r2./poq\0O}wu\rk4䵞2 z9L\"yöDَgnWJc.@a\ZH21WdIϋL=]#\n[K̥2,_0vͧ;S=;(KaxRY7VvXȩ.W\rƴ/32犳3=fSD6g;N1\r)Hh`px8+̝ju9u-\\Z~4Ak)\":qjpOP)禍ޜWD\ZZD~kOh1\rKuvUsk74\'אލ	\nvN4Xy{n<v!~r?!+>uy ?oGf06aeBtƄ0G!5MiZj^Vjhkgs\rxDuFӓԼ\Z{\Z`P%c CfK5<yׯ,az[+-ծf4rAaW3z^z]CQu|H?\r!:):,Q>mSȨ6l/,냰j	;!nO6w\ru#Uy`yIt$6\\X{V)VBHA𻒋;W/q1ҴcE9U\"\"C#{Rփ:,xNM9ϣFgWsc{\Z+:HU1\\QhU%r\0,\ZXJ\0xVڡeC.DEʁ|\r,Xh*5W8&67f		A?b\'X$gYht\rhjxNս>fx._`jbqَ\\ɃQ)͖:HsPrNVRS1]rulE\"${]SˊECYHyvm|h\"TPG`I!%KWVc)`1,Ļ)Gv4{7d$SI2_P	M<XM>R(q֬HHv2|,++x`8pI*H\npEn^jw*W%WǓW]g~MZ\'o\'m)0SXz(؎EJ9U;}X;?ޑX{.5|~Εy-+zl5¿-ZB2hɼ=ژQU%s9\")sfsx770BavsUN^#=S|HukE\"]TdlBjET,Jz}7\"Y(Y滋y`8\n+	}q#NM^bUuV#ZuNn%ƲMIpcڅx#*wTd[$94Qr+R؍EqzNI$s\\jLH so^6ܪr&	@n2u^dREɛ;S!?윧endstream\nendobj\n6 0 obj\n2383\nendobj\n25 0 obj\n<</Length 26 0 R/Filter /FlateDecode>>\nstream\nxKoEǝ|m#aVpN@=ޱw8 [tUw~Ue4)#?UU>*ROwU7uLLlJ:`\\\r~v^U/u!s㵥`Cq\rAD!hyΰھOE\"XpS	=ju9V{zC߉ñ+2_5FA_(Nώec\\ѣig\"iy9dujW56fxש6}Vm?Q411gk9\'ꢺQ堉U$!?9ϿU}xS:Z<?:,4Iu,;F%\Z\'\r<UYG[9,qm,ixo+ዤ8٬Ӄxŭv9+HzE۽23]ȴίK QH7*EYʐbh\'uOf	\"O֯Z$!׿t߼iX!Üplo7HڗH}	lC<jl=d||ِ.8uJ߻ףp3\"!j3E\rh3{C#AKT0ȁAI]-!<\"mrqA!.OHm\"lz\\^ .4+n6i,AYqy+K,H#MrPLEzʤ(MiRs{XkRXq\Zۏ}I{@L>(싾g#bϞZYT%;G+e>i|DhY>8\Zu]x]|pI7\\KG]x{q]΀\r`+Xa{.`-Sczܻ7?=J==6GF\n@Mp_GANH	A^#*;n5Ys7Y~żcw\Zbڥ_!\n\"$Șbd!>)hW|JY8kV*nZ<z[ehʅ}L^K+HA4n\'tvZ2e9+Ȓ#{]܀\"s%ڲ-Rr	捕v(pw;=l:Ɩ0kO_,kZע00[cw[\0Y\\(e늳`d#lRvQ\rU{endstream\nendobj\n26 0 obj\n1263\nendobj\n31 0 obj\n<</Length 32 0 R/Filter /FlateDecode>>\nstream\nxZn6BRѥə-@it>$}iޤ@3Vj]خ0`ks8̐\ZW[>}]ukWY0udR퀢II:T\'??|:~]u:_T\'h}v>\\V\0lr@y:hBiQ\nؘ֚H9nXbRG7֣\r3^3\\/՟[4,0%lmސip[?yⒷ<^dD!:6;/~|b{؜/v3C?V/60v)s8jC0J&}9*oc5]Sn-_vAa4!#e9섇[b,j|_vZM7s \n~W̾-yᲉ9հL\ngaG-z=L<i1)ِ&τؼ\\L1urA^X%3,v\ryc0!ʑOc4m6j2d͓9ʔgfS9SYs0AY/O21A}P$M2Q`6^<EGؿ+Y!؏)t=U\'G_8+;TT{5\'f%g͇5A|N̍NV8Pt\ZDe\ZVAv\"vHW-;cg;}W-9wnFכ(rښcIs\\L}T9`9͹H|Ys}¢;Fչik|\'$hQSIͱ^epkp;oyn!z\\VS̼iȄg܋9Bbőnc!$Y񺤶D9A	TR\Z!S)(kд.S!OK	<{{P%#Lhh%V˕N܋e	G|urdƶhcd(Re2<2\n̮.G5C-iH鿣3:c#g	Wș07\rGeN[HGDu??E;9Vѥ	\r>\'B\\yh.CZBszʷ<\\\"2g)~}d趥hq^GϿ[ہ|tEܟ_Vdh\':yߴ[&gPQ*`r}`פ}.E]T.3;::َVߤ+[\rU8cȻda$ް\\ٔM_F]V58U\0=cӄ̀4x:K0Rd3f7+hGt7}#lT *~4H7S0:\0\Z\r)\rM\nH\n)h{.\"kQ$j?b)2tct`aP.q߭_Au\Z/TiEY\"mP12k\0&Ŗ5lyeɉLv;\n endstream\nendobj\n32 0 obj\n1596\nendobj\n4 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 23 0 R\n>>\n/Contents 5 0 R\n>>\nendobj\n24 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 29 0 R\n>>\n/Contents 25 0 R\n>>\nendobj\n30 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 0/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 39 0 R\n>>\n/Contents 31 0 R\n>>\nendobj\n3 0 obj\n<< /Type /Pages /Kids [\n4 0 R\n24 0 R\n30 0 R\n] /Count 3\n>>\nendobj\n1 0 obj\n<</Type /Catalog /Pages 3 0 R\n>>\nendobj\n23 0 obj\n<</R20\n20 0 R/R18\n18 0 R/R16\n16 0 R/R14\n14 0 R/R12\n12 0 R/R10\n10 0 R/R8\n8 0 R/R22\n22 0 R>>\nendobj\n29 0 obj\n<</R20\n20 0 R/R18\n18 0 R/R16\n16 0 R/R14\n14 0 R/R12\n12 0 R/R10\n10 0 R/R8\n8 0 R/R28\n28 0 R/R22\n22 0 R>>\nendobj\n39 0 obj\n<</R38\n38 0 R/R36\n36 0 R/R34\n34 0 R/R22\n22 0 R>>\nendobj\n40 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 41 0 R>>stream\nxM_lSu@S2콈P,e6&aFc5nOGtsoe[Ww?keQ		iQ7ʣ	#ӻ_y+/?9!fa;{j$Si2UbO}}</>;0=Cz|R}{߾RrJ=AHRWbXri}nts<MvgnRg#dq1t~qEfve,Wr-V_bؔ!\Z	M#=cGd82L?hI4\r /4X(HZLԌX\\..<;(Y:d(9{¼0LNMI(؊!99XRymr2/_Wu`ʌ~M,*Ȁi<hb\0q\'6i9#k^Mj7RKEA\">_![Ne؆{WyV*4Lo	BXUAUO\Z1=v ZFe}szd͗Y\n̍Eey<dH$&&-GnЭ%:EE>VDr@3Aʡ]mu:b}\Z?|/\"&l̬\Z2\'&!*2p.Yu;^EfPY8a\rI6tЭ|c\r+{\rnԇ/\'r	/\0?%-#aPψ^UVjrG.܃Cm]\'Ůc.cc_\n,Gw66߰lXXX!_X\nendstream\nendobj\n41 0 obj\n852\nendobj\n42 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 43 0 R>>stream\nxcd`ab`ddds\r4~H3a!ֹ}nP;*9(3=DAYS\\17(391O7$#57QOL-SpQ(VJ-N-*KM霟[PZZZXT_6QaCcb&|}c^柛\\ҽtiQw_>ڢ%33V/`w}D,*(ZVfͲek`82sɰn樛1eForovvIӺ56ߟsi~g_]7GSCG]z/^~	oi^p\0\0.\nendstream\nendobj\n43 0 obj\n363\nendobj\n44 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 45 0 R>>stream\nx}{lSu]׻6Y{;Pyl#@D-c\n0^]>m}ۮۺWvcSd	8Nb@AfbC@No	2/M%&P4M3_\":8!t7L-9s1c6.Ch7viV(3yU*ujeaL+]*5UZʼJeQFYҨ:=jj*fJ]MQTR^~m)j	zzʤPDJ%Q\'MՄ2Jeb#HCAEca\Zu8K^^_0-nв^x;\npIp\Z3[{?`cyI~x;G@u]>w{`,tquf{%\něrOcQz|h<jʅ:ppY4K*p127cR0^{*I3\rFP{ \Z6hvaObmmyHlЖYd6Od\\ Bfp^dݾUd/i.:(Jߗ=9^wv[m\\H#~\"DCrQIXzob(v4z-\"$s3G\\;r3c8XT^bpK|BI($UPRiZ|kE> kyIM?SϰVń05dd93퇕RbuEe	w>QfpgZD!ޫeTh435~`-`t.=x| \0^+v vZ1K31ɩ2-)b-sIC	vp\\)mR6n9g(\\]kK%OW^L;]wԁ7tWhynOA\riS_{rɂ,xEQm	~۩ro<	\'?!wƪ+8zE6i(vJ,\\+g1iG6G 5P4N6]3AvuIAD|.nkv7pB,ݭ	Kqd/KL1rY[/wvn-:\\do-&\0I1tL= e]d2\'Buۑt&y<KN\n8MM?\0捙v\nendstream\nendobj\n45 0 obj\n1244\nendobj\n46 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 47 0 R>>stream\nxklSeiak&,9\r\n8	crpeˀ:;6kq[˹<]vۨl	q}@AE1#fAIhD	&OP$y{IL$IRo-MرL,=&/\'w\Z44\rr&)$ٚ_Y[՘_[4ϼb.o.,)Th6VKcyf.IQm.T[u==++jk,vsa}?Aik_`A&s,b1Aki>PפM(2xBn&&=$жغ&.!ܒGuw+:SVcVGQ(VŮ	\0nl:XMv^R`)8 :1.Bfxܮf\Z7>.0)|ݠ;q(5w}TL\ZQިuغ\ZŎZ2P,G}5\"`]nb\'{HW>t>3D3GEs;mS- C~@ǧԥorsc#;Z7QH.Hg~\'ce&%1hYj<r3Ey/K)${=\Z;p=20r];{4{C7AU1D/1[q.6G|CDW|sh?묂\\,%\nn?i꒤~KrnSʐ\rE8K\rTԣTlǋWfJ^߀u\Zz^	$hc}R#1gK?dE#3\Z1\nU;4jf$O_ak^|*vi#oP$BS+ټf]~wH+c\"CG40#3gDqAx`sq꣺抢d9J DFqIR\rbw2\rwWp\r2jz@t8?$ HJk8,;Uɪ/\0\0lDA_Y٨ux;Jh\'m\nMaViO\"Uq=;vM>q~z_--P\'\0_5kSDRaTsI~#T)oJRijDmuqlf˄\'4ld*<W\Z~~A	hɂ8XSZ8%fd<~o/Q&8~7~\n2\"mUPy[Q\'ң?\\e?^y3rR᧛ROp¥DLľH	u1\nendstream\nendobj\n47 0 obj\n1288\nendobj\n48 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 49 0 R>>stream\nxcd`ab`ddds\r~H3a!+o\n~7n(_PYQᬩ`hiiZXX(\'gT)8(t+t-(-I-ROI-K,*/d1J	+1>{VtW9V[]V:{<FZg`_tE⢼E+W.^B?QKn.74\\&퓦ϝ\"+O=_ygŪ\'6vs475(w[M9҅?Ⱦ|m3xx\0L\nendstream\nendobj\n49 0 obj\n370\nendobj\n50 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 51 0 R>>stream\nx=Q]lUcbX[hI!TO4&h@6<Mvi]hidw;33wghk)-b*Ә\Z@Hx Rドфxg5;99|(4	(6y%^:mbl+]yUŶ]CH4\rE|G|;;7|-cCA\ZZ{VBchFuː\ZZV]x<5364q7sߙ@6^lccsRt`dpx6dӲԔ-Yq,M[sivttwh\0H3%82	D8;ɻ;aWlaӡ/CK3ihLS4_V*1Jdd8r0\ZDi+vlxm/x:~x\Z..KsȸjF=g\Z<opb&K×Cm\0:pxRH\\muWu4?;c0%&\ZyzBśad*=[oqq}3ر󧣥X)eN\nd\\)?l\'P;/%>z}d\0-a+Ta+\'&ON(;qWT#:Uk+ޣ}LT짍װK|k\\?/0{	w|O&ǒIYfL%EQX)GuG3^p\n|jbjjr+	0N!`li/4_FG?f<чv¿68\nendstream\nendobj\n51 0 obj\n812\nendobj\n52 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 53 0 R>>stream\nxWyTSwH+jm^X7\".Ūk  YDV!		bY\\@YTTܰj]h`bca<j3;9g受s^<dC$ih}gc}_\0X՛j[05q@t[U\Z/	\n;Nu8%\\,E8zp!q,g;H$vGe3]1rC\Z E1n}|4 R,HD~S͜;o~hy)A\"&b	Fl&܉O5b-A$6[1N FxMcwK&(xAț6N6͂% r	BP\'\n\':oؽmgwwps?zh+M^B\"G\n\Z;yL5d>f[;|Ӓ\nV@r+X|L6\"Y`]T-TJI ITKKf5A&(3S2&1x*I/оSYzBy4\"P\'R\'\\]QcIiׂTe	g>op9-|ַM$\ZԅP0v%Ji͏B<Ii+n氎ک5jіgB+i|k̡_<y{#I/>9+y24fX	Llf\\\"DQJ!˕UGQ3p̼w\r/TJ	=msϠhKEgղ|ȇN7ݨ[`U\n;(<TFr`qb$?\ZըifhӧJB*DY^ @DKsg7}TSL(\n-ѻW۾h8\r3xhM2nfZթymwxP퍕Tn7F5F5/ahm<f8|p,J\\\0\ZPjA3M։fu2tPvb@LUFՆ^\Z\rF6h4ble{~ho#`ˬULsF4?Jzb_qe]4-#yeF?FnnQ<cϛ[m?kG2\rEC^We䦦ejI{䵡mKHg|4Q%QENjH;rc/@SPjMB2Dӑ=5E\"9y%s۵EY5<㨕`*~WEVG{֞h5cJm7Ikc-Py҃D2(4zWMP^N2R\ZT;F!_W4>aUT/3P=dJtU%ft20r,\\;kK˹҃׺rȃ~b5QiѺ9jHNbAssLJ⨊Vrd)T=L\n&C⤨?MfU5@\'BZ<GQ{ 07+-(ikVx94ݾ~2*,(ϥ8*getЇ+\Z#\"oLf%CzŐWɑ;xK6\ZLWG\r1҂ȿvfrNd$K\ZU!ob;[(IP;|W+~\"W=\"HdFkSme2KX)؃W<7N@)?m*>9G9\ZK6	w-mh8ig~B5U?3wzG]gxq=OvVI{*uMr4\\Uek~5Ч;PjzE{kp69s1#jYr;/R h-e]Z+wU{ZM4++_OPWЫ!Cb;Eҭ#<\">u\\Y?x7}xu?Xe)Yxg@tO	ۯ@9d6&8])ܭQ1a~bctCH,ONSG)@Oq*9yAv+95h\ZfgkC/y+&>3\'Xx]=+-8J棟F|l!&0?)4UV\r\0<!\nI]*32h6`ۈ<˶>3Ȟ~\\EVZ\0-e ffVGCg+.\"! XYYg*)b7;DFGwrO`#,5#-c1,MKZ>:>.s㓚_}\ZKM&\\6\"t\n龿ZVG3|v>)eS,~[<[,\'ޑIxVl%WLgaa8=z~è٪W/-W(VR))!=Ս\Z	kh\Z^҈y,ҹs7ejJkb\rh2Y㭫nۤe|qxVXG\n\"Jd⊉lB$LȪx /._>l\rg2},|h~G/uг=u\'/MtPZ.	a+/ڀ~PfGxLI|jZ\riIӀN:\0؁e^G\ZMb*?ʅ|G+sM]m;\ZC_/-(b*EsehBʂR	л+LM%ҿn_PLF5dH*g53@<;HR_.R$R&poʂ\\uкzKLYd4Ws\0\r9\Z,&}c<Qx\0_eAG]̊ :0AUg6՜o{qx$F4)Ac9ϰ\Zf<!%ZqR\0JD<+mlyފ@}ֵSY5~57KՍIPkԐr(zZQq$=dK 7җ;>=lőŶK$WmB%7ɏÆf\0N}H9Hfx˩VGHUNKXlkfW8_T{y1[]bm:;\'8QĶQ~@DjEVΜ29Og7yqq1=ͼ@i8~q~-\"~tiey4	/WAͣ^ٲjƝrv&1PuQSa^ϒV^ypԥ:gnx\'u?XP3UXSY-<>z\0ѕ:T}#$EFlm&ƣ\'3cMe,f>fxî(@/S#5\"X喝Rv+C\'nlBȎ^/7^poꠈ\rfJ`+ 0)bcP\r1.7C(@\n)]`n-S}W	\nendstream\nendobj\n53 0 obj\n3558\nendobj\n54 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 55 0 R>>stream\nxcd`ab`dddw\r44\01H3a!;%k\n~n._PYQᬩ`hiiZXX(\'gT)8(t+@lu-(-I-ROI-KMj+I,````4c`b`bdd|?ڙr8cRV?aZ:%[&͜:qr|/d-0}3n9.<g00\0\0fZ\nendstream\nendobj\n55 0 obj\n262\nendobj\n56 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 57 0 R>>stream\nx}{lSuw.0@uTGoyaC6!%lH\"\Z*{Ji7ڵz{}l]Q[h\0MF\"E20!cb<Q~|{~IO#ðE%%kxI%fǴ{C9uip*=ETS\"zS\nn~E˖u5S\nCVrm0n4_VWR{te=Pgf^+1LEֿQL2#ϑE$N!%dY|V6!}d#r_lq|+(1\rv\r5#~Çp.dowxa\0¡@{ xz`傣ezasDG0G+F#]v_*y%?=b[hl}@ZB#x4$_²+jg\\\0>X\Z,@5f2\'XWi8al11\0QW\0B7@]s	}wiX%O+\ru$wq +[Kd^[XI>ΌJ^O%ve32\n\Z*P\'t>s{}7!Eඉ&vEuz:tgx\rc&N/^mZOӍw U +9~[W͊|dфk173WXSOI=.Gg~k1;haeK)Cq4W͔icS9\rYxW\Zװs s}%:-9~h\\r.{RjzH1_<\0\\vJu^Adhwq8U6;YW\'q?$Gp5~V!$EI^K罽ꕲf^\rv6y	x$9QwwʁS4Yj;mҢ^n9:횞]w5}.ǫJߐL?d[.Cr$W\\7M7\'x$;XľD[$x8G;рV>_x5!W(Ի:=G/zu`\'S}u*Me|Y:G<i{Y4[:||n5|-FC0K2\'~?I;1]˚0\"/\nendstream\nendobj\n57 0 obj\n1206\nendobj\n58 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 59 0 R>>stream\nxT{Pu`YNv+C\'|`JR\"Sf	\'Rݻ(xc:eik1%98YǌnPk&鏝ٝ> Д+?\"=4\nY!;#YϢϠ9ь)SN)**[oE%$%Ksuنlؠ,f7lЭ(խЗK%\\}I!EQl)/Jͤi+ԫT5zKM\"tPj>*hTu1xOtoZ[IP&gqnZnd-Nk}\0vjI2	z46z%8X9G-X)T}\nzK\01Bm:4@lfŕi\Z\n#!Aw}R5\\anh瑟AQ\n{>L0fNp`*\'~;@lEjf:\r˚-+@4k{ykj@d	@~@̝3qOHO1>M_/(bIE5\n፸\Z\'0Lk:0ߺv*6а05#5s٦E}bt?$_?$b6G7zrS?P}8}?\nۦz#yryEţ`<3n{K\\k&aG#O*8/\\ 	O06U\'} \\Idߣ3\ZȠi/\rx|?NS#IJ9BnR%T+v\\<:;Pqjnż<~է4%|ֵ@ hd2+AsIXDn	^\'\rӟ 4;sKPg.E]\0:,&ŹA!.L<11dq_E1H0D[1U1=C:Q\n%U6U<>aqc[ƭ,ؠ<Cibeo̅ͅes5Bs(Aʢh[7۸wU2\'Q#YlB1/[\'sI\n0\"\0BGE$PK.T˱% L>rQEgU~Y5u]BF9Co\r9T͏1m\\B̌XՍlsn\\${YZE;fĕDis9%}sd_隣D~$`hʙVSSk6~bY8s[X8;͒eniap\'v).,x~g^Wx8E!\nendstream\nendobj\n59 0 obj\n1362\nendobj\n60 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 61 0 R>>stream\nxcd`ab`dddu\r21H3a!G&u?\n~*_PYQᬩ`hiiZXX(\'gT)8(t+t-(-I-ROI-c```4d`dbb`add?U|V3[+x>w?~foݨ{]M<1}r}߆_~Ѽ\'NC5je߾~QE}GS[kOjv/~ktn7Nm]WWw+G[_[~\r4)Y{ӏZ+ۻs<Uӻ9Rؗv>O/{Vw\\B\nۡ݇fvM	*3-iYNƾ|Փxxe`\0\0}Y\nendstream\nendobj\n61 0 obj\n434\nendobj\n62 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 63 0 R>>stream\nxWiTS!@%Գ7mmš*-UqE2 )ʐM\0dNa0  \"JjzZNj7Q{{sZ{%yD\r%$Vsjd#fc8dvkx͑8aA硔X$Zb˂ȨX\'\\̙4?<P=/i_lH`_C>2`{`ld2:1Nc;=(EliU@yEQ\"\"\n\\H$v\"c/yw&Ou6}{ZC-R);zZBMR(jLyR˩\r\nj&ZEQ\0j eO9PCa#%S#1G9PP4U& ҈$EbFNv8`#20iσU\rvkpXr08tq>gaaXoUo6CSXvˢ0o-[uC[UGhb!t\n-#͚Dn:=mIhWgA֨&(tf: @n8PD#w%RxD.^e\\#0U%q]ޭ\'/=[	UM̤lkUn!G|nv誡\nNjb*+_.xsGn69z\ZnY֘\\\Zw7\\H/?J;En7Q{44a&Mx__貸*}避mB(2AG\"&/O	f#8gh=wA;XTJeQTs[0z=602Pʑh!(|\nGQ8w`T(}\"6Ҩh2bP$Џe4+3Ӌ_h2މ7FVy!OX\"%3h%~@21|!*Pt,@|1P}\'4@kٻ Ԑ8s,j,sjĘ;ݳ_|(^SPi5Q5yuPkB[5o)ӵ4ˤ#R` T`df:Ba.Jͥ!!8h*79tcopek;k;tbG͞o\r=a+`p/?!	\">zड़4/%jO骠\Z:\'+z9	t-q\'k#χ)cgFc(.߫KߣN۫CƺnbO@42Z2i>M`\rz:w\"},n*:e0WIr12?@q-#cЅtb9]iK>nE#kf+q-qQ߶M?fq+(Bۮ߉qe,3\'fCj1LlI\\um)~âY^kr%r6]\r68b;Fjof?(n1{Kdr\'jyK?,śL.M\\0U|?J(!<cD®ＬRҏ6_Je_ROWc8\ZGwсFǩ4q)D\ZeuuZ_ॾɜ*Є}-*_ݪ@p9wݮ4\Z!\'q;WTkM||b4aIr~oJld\00ιlsdWv6+ƃel(3ҕ$TmI2L^Cci+)!Bi/\nqk|!Yp/\Z;6pja\ra:ȂR=R5?F[pxmxm!FKIt0xRp8,\'K;d\'8L}y\\)GuCrfn\r^ ?s!XO=`!:}s!6亦_wgNf?0^qJ>=>,C@bŵN{4\Z-+bON2Bz֘qc\',`6>m<*df&d$Zmy9Ӂ1At|hݶ\\\\Fzu}sZnMLi	c\n!BB2]\r)8U=\ZH(t}HIdI{2Nkmn*|o6hWr[CQ\n=͖̎gZf	lp@0y[̣ݜA\Zu8,dduLe[\"li<tɠ*2\r<~RF6tQd5E?3\n|꓃֮~oqz4z/8$VzLĕrfNF-ɐ)j.]=h!d-{Bze{,.f҄7DN۩<eͼI[\'7DQQhsPZ9B\Zo5BW..dRu쌶S~b\Zd\nSqҙ5r--1ϫr_1Z$Wp\\\\q}ddB\\3g|v\'l[SQS[[Yi}ͥw\01&Q	s` ޓ{}(\'\n;gD(6dbC\\LҒ3>OE\0\r(:[*iCQYV@rA78t?*\rB̵$-36WQzK*GDkHhܖ|$XV(̞nTU3	׬Ws/@VZ/Y^ϼBH;q.gtkOL`MӫFCcwO[n/FHw*WlV@_0O4ehƱlhhm͛K3gײp}bUMjzGZۦArjjeüP~r.eѓlp֛8g@|?\\lwEoYb`w_+#Ro<ta\0qŞ/h6&nr7z%3I	;mAIs+4FWVgR!&ʘ&!MfBӯ<$z91\"K,%1A(vp+/1LHrM\n[v- dqVd=n\r`Oii*P\'?9%ӁD\n])BpW1iY\rphppQKJXV\"r@믑]\ZX_nUqc(9\'*21\Z)s_Nv=NJai5\\䋗Y~=ˏ~Sk-rtWxe=v脯Gξ_3$\\fZSp>ЕY䙄FWBsz+a,QH.[H@&QШ/;],jtA£NU1}t*ŅI\Z2a\Z\n]TM3\'x_S}v\']B K%=Oq*r;(\\\'niOBfijШ;s{s*xPRh_(-bVsI8O>39s\n3F/dnL?3k\ZkzcI/H]|pIQG[䚽u*դj`7#S*s;*Ѵd<ymqOBt1Qdko\ZF{HqmlMn[Vd,9|Ļd8#LyD(}i?M[8D+!|ZqB\\fZ%a+M5	R{0,& ͚fqa|Xtq^|ߏx+b$}$\ZIu)FH~<{7v~\0c_:\nendstream\nendobj\n63 0 obj\n4035\nendobj\n20 0 obj\n<</BaseFont/YWRBPR+CMMI5/FontDescriptor 19 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 1036 1037 996 0 0 0 0 0 0 0 0 0 0 0 0\n875]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n18 0 obj\n<</BaseFont/SZBQCB+CMSY6/FontDescriptor 17 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n963 380 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1222]\n/Encoding 64 0 R/Subtype/Type1>>\nendobj\n64 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n16 0 obj\n<</BaseFont/MUQRQK+CMMI6/FontDescriptor 15 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 924 927 884 998 900 0 0 0 0 0 0 0 0 0 0\n780 0 0 757]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n14 0 obj\n<</BaseFont/EFYKBB+CMMI9/FontDescriptor 13 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 771 778 734 848 756 656 0 0 0 0 0 0 0 0 0\n0 0 0 628]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n12 0 obj\n<</BaseFont/SZBQCB+CMSY9/FontDescriptor 11 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n799 285 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1028]\n/Encoding 65 0 R/Subtype/Type1>>\nendobj\n65 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n10 0 obj\n<</BaseFont/YAUXEU+TeX-cmex9/FontDescriptor 9 0 R/Type/Font\n/FirstChar 16/LastChar 33/Widths[\n614 614 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n814 814]\n/Encoding 66 0 R/Subtype/Type1>>\nendobj\n66 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n16/quotedblleft/quotedblright]>>\nendobj\n8 0 obj\n<</BaseFont/GHNQRB+CMR9/FontDescriptor 7 0 R/Type/Font\n/FirstChar 12/LastChar 121/Widths[ 571 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 400 400 0 0 285 0 0 0\n514 514 514 514 514 514 514 514 514 514 0 0 0 799 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 642 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 514 571 457 571 457 0 514 571 285 0 0 285 856 571 514\n571 0 402 405 400 0 0 0 0 542]\n/Encoding 67 0 R/Subtype/Type1>>\nendobj\n67 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n12/fi]>>\nendobj\n38 0 obj\n<</BaseFont/GKKKKC+CMSY10/FontDescriptor 37 0 R/Type/Font\n/FirstChar 54/LastChar 54/Widths[ 0]\n/Encoding 68 0 R/Subtype/Type1>>\nendobj\n68 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n54/negationslash]>>\nendobj\n36 0 obj\n<</BaseFont/WSXSQF+CMMI7/FontDescriptor 35 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 859 863 819 934 839 725 0 0 0 0 0 0 0 0 0\n727]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n34 0 obj\n<</BaseFont/GCFFPC+CMMI10/FontDescriptor 33 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 750 759 715 828 738 643 0 0 0 0 0 0 0 0 0\n642 0 0 613]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n28 0 obj\n<</BaseFont/EMLRVG+CMR6/FontDescriptor 27 0 R/Type/Font\n/FirstChar 40/LastChar 49/Widths[ 481 481 0 0 0 0 0 0\n0 611]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n22 0 obj\n<</BaseFont/QYXKNE+CMR10/FontDescriptor 21 0 R/Type/Font\n/FirstChar 40/LastChar 121/Widths[ 389 389 0 0 278 333 278 0\n500 500 500 500 0 0 500 0 0 0 278 0 0 778 0 0\n0 0 0 0 764 681 0 785 0 0 0 0 0 0 750 0\n0 778 0 0 722 0 0 0 0 0 0 0 0 0 0 0\n0 500 556 444 556 444 306 500 556 278 306 0 278 833 556 500\n556 0 392 394 389 556 528 0 0 528]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n19 0 obj\n<</Type/FontDescriptor/FontName/YWRBPR+CMMI5/FontBBox[0 -22 975 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 146\n/MissingWidth 333\n/CharSet(/A/B/C/P)/FontFile3 40 0 R>>\nendobj\n17 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY6/FontBBox[0 0 1128 432]/Flags 4\n/Ascent 432\n/CapHeight 432\n/Descent 0\n/ItalicAngle 0\n/StemV 169\n/CharSet(/arrowright/minus/periodcentered)/FontFile3 42 0 R>>\nendobj\n15 0 obj\n<</Type/FontDescriptor/FontName/MUQRQK+CMMI6/FontBBox[0 -21 944 714]/Flags 4\n/Ascent 714\n/CapHeight 714\n/Descent -21\n/ItalicAngle 0\n/StemV 141\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/S)/FontFile3 44 0 R>>\nendobj\n13 0 obj\n<</Type/FontDescriptor/FontName/EFYKBB+CMMI9/FontBBox[0 -22 823 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 123\n/MissingWidth 333\n/CharSet(/A/B/C/D/E/F/S)/FontFile3 46 0 R>>\nendobj\n11 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY9/FontBBox[0 0 970 430]/Flags 4\n/Ascent 430\n/CapHeight 430\n/Descent 0\n/ItalicAngle 0\n/StemV 145\n/CharSet(/arrowright/minus/periodcentered)/FontFile3 48 0 R>>\nendobj\n9 0 obj\n<</Type/FontDescriptor/FontName/YAUXEU+TeX-cmex9/FontBBox[0 -2957 781 45]/Flags 4\n/Ascent 45\n/CapHeight 45\n/Descent -2957\n/ItalicAngle 0\n/StemV 117\n/MissingWidth 250\n/CharSet(/quotedblleft/quotedblright/exclam/space)/FontFile3 50 0 R>>\nendobj\n7 0 obj\n<</Type/FontDescriptor/FontName/GHNQRB+CMR9/FontBBox[0 -249 833 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -249\n/ItalicAngle 0\n/StemV 124\n/MissingWidth 342\n/CharSet(/L/y/n/c/parenleft/three/o/four/d/parenright/p/e/five/six/fi/r/g/comma/seven/s/h/eight/t/i/nine/zero/l/a/one/equal/m/b/two)/FontFile3 52 0 R>>\nendobj\n37 0 obj\n<</Type/FontDescriptor/FontName/GKKKKC+CMSY10/FontBBox[0 -216 638 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -216\n/ItalicAngle 0\n/StemV 95\n/CharSet(/negationslash)/FontFile3 54 0 R>>\nendobj\n35 0 obj\n<</Type/FontDescriptor/FontName/WSXSQF+CMMI7/FontBBox[0 -20 893 713]/Flags 4\n/Ascent 713\n/CapHeight 713\n/Descent -20\n/ItalicAngle 0\n/StemV 133\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F)/FontFile3 56 0 R>>\nendobj\n33 0 obj\n<</Type/FontDescriptor/FontName/GCFFPC+CMMI10/FontBBox[0 -22 804 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 120\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F/S)/FontFile3 58 0 R>>\nendobj\n27 0 obj\n<</Type/FontDescriptor/FontName/EMLRVG+CMR6/FontBBox[0 -250 505 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 75\n/MissingWidth 416\n/CharSet(/parenleft/parenright/one)/FontFile3 60 0 R>>\nendobj\n21 0 obj\n<</Type/FontDescriptor/FontName/QYXKNE+CMR10/FontBBox[-40 -250 813 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 121\n/MissingWidth 333\n/CharSet(/y/n/c/parenleft/three/o/d/parenright/N/p/e/D/f/E/six/r/g/comma/Q/s/h/hyphen/G/t/i/period/u/colon/j/T/v/zero/l/a/one/equal/m/b/two)/FontFile3 62 0 R>>\nendobj\n2 0 obj\n<</Producer(ESP Ghostscript 815.01)\n/CreationDate(D:20060627000147)\n/ModDate(D:20060627000147)\n/Creator(dvips\\(k\\) 5.95a Copyright 2005 Radical Eye Software)\n/Title(proof1.dvi)>>endobj\nxref\n0 69\n0000000000 65535 f \n0000006062 00000 n \n0000029628 00000 n \n0000005989 00000 n \n0000005533 00000 n \n0000000015 00000 n \n0000002468 00000 n \n0000028076 00000 n \n0000025016 00000 n \n0000027825 00000 n \n0000024720 00000 n \n0000027608 00000 n \n0000024390 00000 n \n0000027387 00000 n \n0000024188 00000 n \n0000027166 00000 n \n0000023986 00000 n \n0000026948 00000 n \n0000023656 00000 n \n0000026733 00000 n \n0000023464 00000 n \n0000029287 00000 n \n0000026340 00000 n \n0000006110 00000 n \n0000005684 00000 n \n0000002488 00000 n \n0000003823 00000 n \n0000029055 00000 n \n0000026165 00000 n \n0000006217 00000 n \n0000005837 00000 n \n0000003844 00000 n \n0000005512 00000 n \n0000028831 00000 n \n0000025960 00000 n \n0000028610 00000 n \n0000025764 00000 n \n0000028405 00000 n \n0000025525 00000 n \n0000006335 00000 n \n0000006400 00000 n \n0000007338 00000 n \n0000007358 00000 n \n0000007807 00000 n \n0000007827 00000 n \n0000009157 00000 n \n0000009178 00000 n \n0000010552 00000 n \n0000010573 00000 n \n0000011029 00000 n \n0000011049 00000 n \n0000011947 00000 n \n0000011967 00000 n \n0000015611 00000 n \n0000015632 00000 n \n0000015980 00000 n \n0000016000 00000 n \n0000017292 00000 n \n0000017313 00000 n \n0000018761 00000 n \n0000018782 00000 n \n0000019302 00000 n \n0000019322 00000 n \n0000023443 00000 n \n0000023871 00000 n \n0000024605 00000 n \n0000024908 00000 n \n0000025441 00000 n \n0000025669 00000 n \ntrailer\n<< /Size 69 /Root 1 0 R /Info 2 0 R\n/ID [(Cދz)(Cދz)]\n>>\nstartxref\n29821\n%%EOF\n','Proved','BZh91AY&SY!֮8\0t_gg```=\0\0\0\r*~ɡhd\0##M\0q&a22bhAL\0q&a22bhAL\03JM(\0\0\04\0\0\0\0\0dɦL0Fh\0)!B =ěSz7\0zO)jГa&@;*Bċ$eWŢL1\r1\ZfT)fbJdEMV+\'OS~S!	\r؈D\ZH(\r!{\\O]LŘʯ\'|B;S\'&Xn!cNj&NV}В\\a?q_$+O\'_|pܾ]~׻Yv[fnیoTv7+TVQ7G@\n\"!UD((p٥vC^rwCOs+3ufd%Q\'2%ĸn^IݲFsk\\mwg\'\r1s\r.-\'-jlhe{Z,~ɖK.M,X}P# D&\"6a1eVpÍfcŀpݱcvlʌ[8\ZZ[7ba*6if1,S[cM9ٚ3z38rr*d\\̇9k2WleZ,V#TĲYDl\rTdO*fh_[/nYy|ڞL>Ǉo^>6v/>c\Z~o}km\\j[g擝;RsyX;~I\Z)6otH_&\';Ⱦ.~$:	z=8/韟_nr{M.U<<=NuspdSHws	^=N2$0Y+`,+	2N7֚nN{fsHy7f30N؜-5ZN.:WSA:\'Le)RŐX1bV27N\'lw&̻USy<9;]UM&10ʄ7LcMg\"6SUQ1̎d}.u;fD4Xz8xSk>kIOxUQUG-h<\\=(\'D8JV$liS1r.zjIO`J9s\\X0tLH\"w+|Bz|y6&Aw]o?蓾䪸)ԑy.䪿g\ZR1w$S	j'),(24,'point A 20 10\r\npoint B 70 10\r\npoint C 35 40\r\n\r\ndrawsegment A B\r\ndrawsegment A C\r\ndrawsegment B C\r\n\r\nmidpoint B_l B C\r\nmidpoint A_l A C\r\n\r\ndrawsegment A_l B_l\r\n\r\ncmark_b A\r\ncmark_b B\r\ncmark_t C\r\n\r\ncmark_lt A_l\r\ncmark_rt B_l\r\n\r\nprove { equal { signed_area3 A_l B_l A } { signed_area3 A_l B_l B } }','<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE figure SYSTEM \"GeoCons.dtd\">\n<?xml-stylesheet href=\"GeoConsNL.xsl\" type=\"text/xsl\"?>\n\n<figure>\n	<define>\n		<fixed_point x=\"20.000000\" y=\"10.000000\">A</fixed_point>\n		<fixed_point x=\"70.000000\" y=\"10.000000\">B</fixed_point>\n		<fixed_point x=\"35.000000\" y=\"40.000000\">C</fixed_point>\n	</define>\n\n	<draw>\n		<segment><point>A</point><point>B</point></segment>\n		<segment><point>A</point><point>C</point></segment>\n		<segment><point>B</point><point>C</point></segment>\n	</draw>\n\n	<construct>\n		<midpoint><new_point>B_l</new_point><point>B</point><point>C</point></midpoint>\n		<midpoint><new_point>A_l</new_point><point>A</point><point>C</point></midpoint>\n	</construct>\n\n	<draw>\n		<segment><point>A_l</point><point>B_l</point></segment>\n	</draw>\n\n	<labels>\n		<point_label direction=\"270\"><point>A</point></point_label>\n		<point_label direction=\"270\"><point>B</point></point_label>\n		<point_label direction=\"90\"><point>C</point></point_label>\n		<point_label direction=\"135\"><point>A_l</point></point_label>\n		<point_label direction=\"45\"><point>B_l</point></point_label>\n	</labels>\n\n	<conjecture>\n		<prove proof_level=\"1\" proof_limit=\"10000\">\n			<equality>\n				<expression>\n					<signed_area3><point>A_l</point><point>B_l</point><point>A</point></signed_area3>\n				</expression>\n				<expression>\n					<signed_area3><point>A_l</point><point>B_l</point><point>B</point></signed_area3>\n				</expression>\n			</equality>\n		</prove>\n	</conjecture>\n\n</figure>','2006-04-06',2,1,'GEO0007','%PDF-1.4\n%쏢\n5 0 obj\n<</Length 6 0 R/Filter /FlateDecode>>\nstream\nx\\˒4\r.VZ{^ȄT1<H*E^L !,{dm)w=T۲8Jwgq|q9{booolm/,sZ]n>b gBfWyfʡPL:ZW^~#hɌ1\nA%GsƨB1-43jLjYQd΂Τ(&o|7(C sEMKn/D.U\',i\0CFv̀Sd^5G~A)\"C.,-9FߊdW@&ڴ}RC/*UAvZ	iEۺV8m2,GNAlI^h,F&u$N$\0E\":2drͬZb\"9M0΍5ZKE3Pj.Y^WaՕ2suyF)Ʈ8p.I	-_лcJV¢Wo4~~Q\03r3M绱mZփhSS)&rD1ȪxRJ[v\rHM<m05s$ہ .}fôua+gDkb0\'.77(%=A^$9A~F-(u:؜]|}xϫOlξ>.m]d,ȸqZha36d4.fO Ú킴n7p.FW@zHٌ\n;`-xmq@n0@[zSux =%>1]wį*2m\\]Mmv\"%jd83ad1|Ny:T`LF7%]K۩鹝Q隕.Ǝn2v>Vn֚!*2aaYyՠZȗr<\'GA<l$V<	+L3c	\'%ߐgT=48C(ksb:#ESUbT?i#7I֑׽c7%Y{\\xE%BB`$!Q#͛5ard<.\0t@||ܚ]8<i_+&T`^*\rmK-)vHl7\\ڢ<N`lrS8/!UZZܒ*\00rC[#PGL4@bJ(\ne\n=LO9\\R\Z.+4|<,kû$גӇgHʏ~|F^Oʀ:%aaKR8d;_ֆC10FcÔD3,]v9I8EoW!Hs[sb\"nAjPi7_]**Eo,Ӭ쒲׎	*qYU\\5*U	fc%KuqdU;U95),{eOo䣘2H\0^Qt@DKX8aj\\*^\'AzlwhA XN0lh$tJu6/$]\'K^@ z:Hq>={_Huuw5c)a:ڃAihԕt9D[t`˓8J`D^ľ\'8VvI	QVEKTF|y5>E,0u=zĪ-ͯ=T`EYNj+䠝}B-m@{OHes(WT:D1\n!\09\'F(Ȓܠ\Z\n!tqROPѱ#8tn1&\'w\'Ip]+Z=AȜm-7\08U-֚\Zo=etendstream\nendobj\n6 0 obj\n1895\nendobj\n25 0 obj\n<</Length 26 0 R/Filter /FlateDecode>>\nstream\nxZKoE\'8#vwU?yH,q B\"Dlp{y^(wӯj}SJJOȕ/^R(n\nGKZoE_΄R˫qUoT6e{\\\Zk+/i(ly}Ro[ŉBrcu3,-貸(n`ƈR_<!aTIV}rz^WyR\'_ߟA輼X»7\rG[|iJ$3>IU>Z\r8D\Zct^c4\"8gX#8&8zZ\n>fz68~7coy/@A!}@?7q|+iFl*6ZxZoQ)̝h\0SP4䲴˸vB#IDO%Jb\r&nMmؚFŋ.0ؔ.J\n_}JZ\\ךp[IIqjz~&(\rxz;WO,4Wal]k	Ak\Z؏Ok%;qHsl^3CDmb@ju,R\"mr.J@F;:.z!<)=6	6!BPs\'\'䁹LaBz$BV92Qa5/E+)0t9xeoN`FB[\'\'ȜZ_f3`wmǟp]p!ߧL|~e+L>NEa[\Zk]){?wIa\rjD~?)?\'ZT_;Q- YfH+&ey!m;␺6JEjkZ!hcU$N\0\nG<QDc\",22(qikIE2.CbUUm6||=(5(gø	7F4+KeCFvŴy Bs(	SQ2$n$`֢TtĪ܅ز^,p.[9:6݋\\q\r%2y@Y\\߱uP:(H%e\0b\n1P#V3RRdѹ,$	Aܑ9$OF;-1C͒o։G߁؁}@\0\n9?X\\VTjlrv	w՛\\=@&k}hM!Ȍ$UHS\"qX]gcEfNf-4{u0L\Z;4fa\n=f,}o5|mfNE_Xw۲YZ6*9z&C\"	e͊a=hVp,;3LZgmMq\'6 ԇչ=`pĒ%Q;%L>Sx2ݻGd;QhЌȯV[Iq(c_A~R6q;롨ۜv_ؐ׍PVpG~ӕ	/WQ1x]ςſUendstream\nendobj\n26 0 obj\n1553\nendobj\n31 0 obj\n<</Length 32 0 R/Filter /FlateDecode>>\nstream\nxŖn0{S(0G4:ݐzzȞI@߾#	Y\\ئDIs2⋵[ݥlu`\nĨ1(feX~R7WGn.llrS궖j]v89%7J<yVqx|\Zϻ]\Zzɑf8k|}w2WEH\Z%8N3:XB\\崑$GZzoe)ٻ%66t\">RRIb&D\"Rkcl4`خp\n Hj؍wg	Ghmq=EE~?l`Z)g(HCJZ	/_ֽWAǨ`(Ԑ[%i2B㔫$Z@5Q)&,sEoYGpڭcs<ƫ@\'QSۮAiܗ%+ӽnΐslqmdihhh!Yl$,/r۔~9	6J=nOz﷉*.&.VD+RRʶX ɑ6lTs\"c0ʔI1c%̺36)Ymn&nm-&Ϩ=\'tv\Z\0endstream\nendobj\n32 0 obj\n663\nendobj\n4 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/ExtGState 22 0 R\n/Font 23 0 R\n>>\n/Contents 5 0 R\n>>\nendobj\n24 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/ExtGState 28 0 R\n/Font 29 0 R\n>>\n/Contents 25 0 R\n>>\nendobj\n30 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 0/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/ExtGState 34 0 R\n/Font 35 0 R\n>>\n/Contents 31 0 R\n>>\nendobj\n3 0 obj\n<< /Type /Pages /Kids [\n4 0 R\n24 0 R\n30 0 R\n] /Count 3\n>>\nendobj\n1 0 obj\n<</Type /Catalog /Pages 3 0 R\n>>\nendobj\n7 0 obj\n<</Type/ExtGState\n/OPM 1>>endobj\n22 0 obj\n<</R7\n7 0 R>>\nendobj\n23 0 obj\n<</R21\n21 0 R/R19\n19 0 R/R17\n17 0 R/R15\n15 0 R/R13\n13 0 R/R11\n11 0 R/R9\n9 0 R>>\nendobj\n27 0 obj\n<</Type/ExtGState\n/OPM 1>>endobj\n28 0 obj\n<</R27\n27 0 R>>\nendobj\n29 0 obj\n<</R21\n21 0 R/R19\n19 0 R/R17\n17 0 R/R15\n15 0 R/R13\n13 0 R/R11\n11 0 R/R9\n9 0 R>>\nendobj\n33 0 obj\n<</Type/ExtGState\n/OPM 1>>endobj\n34 0 obj\n<</R33\n33 0 R>>\nendobj\n35 0 obj\n<</R21\n21 0 R>>\nendobj\n36 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 37 0 R>>stream\nxWyTw0Vp*L?Hh\\qEv\ZZvie\r&͒D!~&$j4F=e^1?f2ՠ&g23w:ݧсH$ek6x̶$	vR4a#q+T\"`$аx)˦yxz.p[& >,$2 ^p;$>im8\r!q!=!^QQFQ51)*(:Øv-W߭ڴG8sǜEQ۩{:j95ZOyQާ&QjVQj\rZFFQ.\ZMԫx5}*%$:dDw4ϩJߡ3qL!	C\rj3~;\':52cdo5ޔo#/P$RyCP$Ra.fk.֗cQxHJ(h<ONDtc-9<[FFVj!`Ca8_2&{oZx^զh !ҖWhr&<>A7ҷ=Ŷ9v.Ő^Wy#:}i_5tjN,v\Z~rK7p$r؄#7pl洊pzX\n>k4vR_fntRj+6mJ_-wHW@MV$eb+jLˢwɨY\" \Zpxq>diwy1-m*̶HGץB8z32F$daL!8/(H,asBA3BwuGNQc\Z\ZX!\n*?_6`U[TXjw0SW>fW8F/(\'4q;Q(\ZdkS	KLA7Xy4;\0Z$VWZw$Msڠpv=[ZHbOb:N}suD`ȻzYte*^Lv\ZMCg-/Tz]^0t\0CP`.:m׆C8l7)|bE $d\rgXJ˳^,*Ol\\l.q\"#/Xbj̠1?`pؓ_Eqa*yू,??jN?Hw4\n0}\0,w848Jڬ-`}yzћ800`G9MAPԷUTWPժA:@ƣYēh\Zyh(>^+H׆nOٰ~hApލB{ޒ΢F #Ɏ2,s/O/3Ujܼ9B\\y\\PGjzTMxE2ViJ̌_J\Z+M?K\"XW+q)Yj7ʢQAQ-dbs9kYϳ*3)0it	DS-փ\r\rz+8t	wVOnT!TԝI\Z~tUo<xXUo(s&\"R|Fz|t0S\n6{WZRZU|J0@>9jHgKˋU\r	~Y\\@c@\n^^YB{I@Q\ZbKXA̲>9}):nszPܬcȃ\nr;GZ:rOe7{m8Fр6?HPo{(*;JGNgПL7*>+G/N\'sq@Q=W6Ь{jıD_OgyD(}E8^Lfݾ{\'\'ĉ9չS٪)MkyUNؚqm	X_bw(Yѥ*$Wmͬ%Z\n,c-\\zDNS^L:2Kz3Pi83>?QA>!0_XqM5m7!Ca1oPB^No&.RE;V]bƼӁ/AJڔPFdۊehtMm7M\'8*%𺍼2gF{͗.}WnŜkܩい0CgE+˅Yf/oEY,/iwEj\Z,geN~+/\'ah*&6k?S RDa/mR=dZx邜3U4z!:>?қ=͸ElX(}l?*;\Zq:Tk9xF\\ӻ!5.H!kN& 58ti0ʼ{((?D+m081	iRad*_F8iHcDf F_H\rY\"ckZR4HFm\"e*НiR(bŔ$\"=R\\޷ը?kUtĲ\"K\r#̵?_q^Sx6/6g)7Y-w\02Ҕ\\SWi9ݸS6u4\0u>xRo,׬\\[+/8i2Mv2=cnM>nJx)N9.䐴[KJ|_fگ[$g=hO.F3`=+de۾\Z\"L}@d}R\\Rb -N_Rzj8ͱ!5 viFQ{Cbu\\rIIn>⦳l}\\uTT\\\\TTu\\}}u(AHZc2eΟ=`-,\rᕽކymu9sǿ6_oJ.Κ܅O)6ⰯbI2N)`5,+A#a`WRV![\\\0&Qgj2:TE(dMD#?\nIf)iӧlSOTƥbLɎۗD!+dl.tñ(8%l<Mjj2pUn;|{;d	Wx7Vev.@ܫpϭ.ƯE]cVɗ\"2枛>iEzRR9[WOi30m<ҵc5J].N	LcjuTpk-O%W|\Z7e,pi1EE;%|ίV_}\r`lB;wU=Y4ΓIk	ǾΈny߳MvHٯ\\WF\Za@uSv0Dw8!vr6e5fk\0G~y&?SM6{\n>\\)2RxE\'AơC<{8֝I;ڸ];Em8i.WWLc:\Zs~4tDןQο>F?gքER[Q%2x\r\ru\\`\Z>R4|xi/4=\nendstream\nendobj\n37 0 obj\n3609\nendobj\n38 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 39 0 R>>stream\nxcd`ab`ddds\rT~H3a!3Qnn%߻\n~7#_PYQᬩ`hiiZXX(\'gT)8(t+-v-(-I-ROI-c```bE@V1gewEW/-.[\\r%+3\'0|\'O3t/XX]-\0[mYwY|/d-8}#n9.<f00\0\0Q_=\nendstream\nendobj\n39 0 obj\n276\nendobj\n40 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 41 0 R>>stream\nx=KhaoXVzMYAQ[J$փ ^X)ѐnjM<EAfwlMiPE\"AAĻuß,&Dk\ZnD{Զ?;W{CVX͊բ_^;\0g\"AG	3/9ju<eRrIz6(MS{ލQ\01`Pݗ@$C!4l0Q&B)[GdYt7z{?;<7ݼ^s^\"lrn(/y UWWJzqRY7`!~6\\e yw#u3tזd^\"ʤxEIf L%SE&a6-ZǓ[<\r\rO0YdՂWr^+39Ie\ZSvXɷV6sM\nא	ޗ_w~ԪzQ׋zQ\nyPXIiveN\nendstream\nendobj\n41 0 obj\n544\nendobj\n42 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 43 0 R>>stream\nxcd`ab`ddds4T~H3a!O/nn߷}7]G;9(3=DAYS\\17(391O7$#57QOL-SpQ(VJ-N-*KM[윟[PZZZ7?`5?fß*3{\'tϩ$QQQ5{些\Z:)hl?vrͲYk˭2xDU]mr^)WM7UtOM6wL\\OXy8Oy\0\0}\nendstream\nendobj\n43 0 obj\n333\nendobj\n44 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 45 0 R>>stream\nxILqӍQkM:3\Z[M]\".!Z.+)ER)`2|]YJ@+6UILb0M<A<xԃ~/B2	(J7R*]!59(rX>W\")E=Eraijhq{Z5z3m|і?L&L&vVboַ4irB2)	rTv\")QzH>HάQ:Z\"HlUvR]\\b6=q1SFÉZx\0ѱ`$>>9,{	ܝ`SCb0!& @G0=	N?-;.Bz=.tPc|&|sx&M̿WS\'t\r^X]{R4qHMsǧ\'ɂz1q3=0<UJ]0j+4dKɊ-\\/Y&-ӒB6gM#{:WV~KniԁAt@vu}7SunԤJH?J0Gh\\K!O%n/s hѤpA`	.d,\"ziy>6$aFFE&{.\'yE}\"J?@c]J;cbtO b}\\tbfv>B=N_O8Nn4}(\'s\'df(\ZUCO6lb64	\'!g\nendstream\nendobj\n45 0 obj\n780\nendobj\n46 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 47 0 R>>stream\nx%]HSa߳ya40sPaVfE)9s\'?m9k +E7]AaDP]t6ߟBE:DQb]JkZ]~Q\0&=f4Jk޶o^u]nss*n[mm\rW]vn`N9[l۳۹N]-NGGwqVg+jGBh=ڀvSD(GU-RFTedl8=-}`x`8T4F|rh<DrS;9\Z\ZbS\\=7z#jz\"8LI!m)wBRAM\'fH7@/Mz2,l(tN,fwYu<ÐbȈw2\\seeyF\"eY0z|\n@L7EUR (з_a1 <xwlkjb`InAB;|_騮LLl#jw)|xzmYz+,\r~IoH\\\'NM̤ńmN;&_rp\r[6Փ^\nX2UOwnՈ,&:`$И&l+Iʶum+CǓ0O#yyxInp% @?l+ː;xHeLiQ͸d2j2!S\nendstream\nendobj\n47 0 obj\n753\nendobj\n48 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 49 0 R>>stream\nxWyTSH-\"8j{<ZZ\"bFc  dDIH ˤ28WlaP~{:w}_hjEӴj?ρIhǋND}}*!/;|ьᔈ}Vm&+\"Sz\\-UDKb<VKh<<ʃ#Y^2/=RE4dTZ\"UP5`yHTIN:}ƜoΛʂW]IQ3\0j\rK-ާ|JmjZM-ޣg(ʕ\ZFFR<5\ZMqԳ*\ZK=G=O\'SHH+NED!OSNbK&\Zg6<c{f_F\ru+\Z6M>;r)Ӈ{m[TIx$^+ڢacK{pM\Zvj^*Pz19$&CaqN*r,AJj*׳v&J#4,OgeL ԹYpX<UdC蟫i\0ogI:	hBCP-E,U@4]y]֨JErJlPkяN$1FCzQh8uFMZfT9^\'e̥626/c:Uy	en-m5hGϝ*X?9OY3g(\r5ݭ\r\"xKMJ6ΘTScc?e>=ܣ	{ѰR5hԠݖ+}Q4͹qV,\nHx4+]w59T(Cc?x$<\Zx4Q?y\r *ŵ꺡z&QƈjI?H Wloڔ$IVd+\nmzE.-u	,v9<IhCmJM/q3+2#ƫ\nɠٞ(ڤ\n-lkkӞQ]߼Zab4tz^oG3	6q/2{\'SyX49}ƠS.6$l\n<e\0+[bG-pO%z1^H3<;}\0pZG5D	(3ߒV1LFnȭquQNaffGN8Oak!Kw\ZZ<Wf18Ѭc!s+Eȇ>P&#1ctgcM۪M{H$֗`ѝ#|LbiJ֢wݬE;jh\"4)~{ҍ.yCZJ!GɬHU]nmJXsH9VNd\"V\nٷF#_Pk߇Q)T\re\\n`7\nw`R	\nx1^[4sWqI9n\01#(}x9ZHOYVA96rTy\\u kq$Hy,\nI:1yn]a:,6,-˫K\n\nZkhmW/JM\">\n+*+XV=ֻ*zM!r(Efh%ֲ:	i@G1ʎ^3ҿm\"1Cx\"zW.-0M*ub+||%[	_Wa_J*rEqshRS[,<W8_Mi\Zޔwdƻ4$UG>	n*OG6<B+J=h7zDqk:Q``.#3m2ִm.	5u\"uڥ9+>`؋ZI]Xs75lNM[\Zyz.?\"Y<a_Qf\0ٜh	. O?ܴހ7=>^ρ#& +Z}7EwĔ늍8CC{`|fޗq	Q[e!T=XBN7HtNL\n4;0\\BJ@ހf#_2z>?_\nآs1?P.vآ\"߂tt!\"Ygh49zM	8\'\\a5ݥw\"g@$smBm蘑vDQ&\nR܂\rP<އ16\n\"OPיҁZeU\"swn1N:6pGQב\'q!تFkEEd}#ۨXhtn~>%GK`~ZۢW?Oizbp2|rr8]Ǎߜl8T5x%pao\"{e(0IEogwf3p/gB5(i7p\\wHB3KS:ڊFmtORQ?qU	],ޞ\0	F([\n3M*H%ޚ.MC;}\'rlEˉզedg}bx\\i	z\r;\rY̸Il9rD,G\\rc>l3qk\n&n\r9F`(4xJ!\ZP.e<zEjZAoДc.wh;n7_==~K\"ͪ:1\"i=cف\n \nhZ-dA.Kj6mAFT:]j&?uR>A&>2c~X.CD!J*\ZsH?;\",Wiϱ˫ߔg琴r2MYvm(ǦC6w0ɠ.ߵ3o1Ya2X-b%U<(k+k\'T&Ӄ|6а@Ѱt`@JX0C޺pE	aIOQの`064EWdUU֟CxxEfl	_#p9uC[``/V嫤@l_ Be~wiG#[6,.EG>i!\r9=hnɎ!2Hg-۪kMU1\"\rۍ3(L*`;p\Z8{\0V+i\\q	q&x$h4U\\6q~eE7*NY(x!jje|hWADܭNd7a}0qKgK,1Ua}dD^\nS^*e-4_wu˗rq{2.JEo.ze[W4({:^ҟGwEwa\rmSwilMQ.W%Gݽ5ɑ^<t|mw[%~YUt=lj?(iO~Fyh{]9~&`[bƵ{PLo-e.Cy!X]]{\r(5\nendstream\nendobj\n49 0 obj\n3630\nendobj\n21 0 obj\n<</BaseFont/HRWDMC+CMR10/FontDescriptor 20 0 R/Type/Font\n/FirstChar 46/LastChar 121/Widths[ 278 0\n500 500 500 500 500 500 0 0 0 0 278 0 0 0 0 0\n0 0 0 0 764 681 0 0 0 0 0 0 0 0 750 0\n0 778 0 0 722 0 0 0 0 0 0 0 0 0 0 0\n0 500 556 444 556 444 306 500 556 278 0 0 278 833 556 500\n556 0 392 394 389 556 528 0 0 528]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n19 0 obj\n<</BaseFont/IWRFRS+CMSY9/FontDescriptor 18 0 R/Type/Font\n/FirstChar 0/LastChar 1/Widths[\n799 285]\n/Encoding 50 0 R/Subtype/Type1>>\nendobj\n50 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered]>>\nendobj\n17 0 obj\n<</BaseFont/EKAJCL+TeX-cmex9/FontDescriptor 16 0 R/Type/Font\n/FirstChar 18/LastChar 19/Widths[ 757 757]\n/Encoding 51 0 R/Subtype/Type1>>\nendobj\n51 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n18/quotedblbase/guillemotleft]>>\nendobj\n15 0 obj\n<</BaseFont/EADSUY+CMMI5/FontDescriptor 14 0 R/Type/Font\n/FirstChar 108/LastChar 108/Widths[ 480]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n13 0 obj\n<</BaseFont/WXZQIM+CMMI6/FontDescriptor 12 0 R/Type/Font\n/FirstChar 65/LastChar 108/Widths[ 924 927 884 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 402]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n11 0 obj\n<</BaseFont/KDKGME+CMMI9/FontDescriptor 10 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 771 778 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 628]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n9 0 obj\n<</BaseFont/WNKYBP+CMR9/FontDescriptor 8 0 R/Type/Font\n/FirstChar 12/LastChar 121/Widths[ 571 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 400 400 0 799 285 0 0 0\n514 514 514 514 514 514 514 514 514 514 0 0 0 799 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 642 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 514 571 457 571 457 0 514 571 285 0 0 285 856 571 514\n571 0 402 405 400 0 0 0 0 542]\n/Encoding 52 0 R/Subtype/Type1>>\nendobj\n52 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n12/fi]>>\nendobj\n20 0 obj\n<</Type/FontDescriptor/FontName/HRWDMC+CMR10/FontBBox[0 -206 813 705]/Flags 4\n/Ascent 705\n/CapHeight 705\n/Descent -206\n/ItalicAngle 0\n/StemV 121\n/MissingWidth 333\n/CharSet(/colon/y/n/c/zero/o/one/d/N/p/two/e/D/f/E/three/r/g/Q/four/s/h/five/t/i/u/T/v/l/a/period/m/b)/FontFile3 36 0 R>>\nendobj\n18 0 obj\n<</Type/FontDescriptor/FontName/IWRFRS+CMSY9/FontBBox[0 0 712 305]/Flags 4\n/Ascent 305\n/CapHeight 305\n/Descent 0\n/ItalicAngle 0\n/StemV 106\n/CharSet(/periodcentered/minus)/FontFile3 38 0 R>>\nendobj\n16 0 obj\n<</Type/FontDescriptor/FontName/EKAJCL+TeX-cmex9/FontBBox[0 -2358 729 45]/Flags 4\n/Ascent 45\n/CapHeight 45\n/Descent -2358\n/ItalicAngle 0\n/StemV 109\n/MissingWidth 250\n/CharSet(/guillemotleft/quotedblbase)/FontFile3 40 0 R>>\nendobj\n14 0 obj\n<</Type/FontDescriptor/FontName/EADSUY+CMMI5/FontBBox[0 -11 355 694]/Flags 4\n/Ascent 694\n/CapHeight 694\n/Descent -11\n/ItalicAngle 0\n/StemV 53\n/MissingWidth 333\n/CharSet(/l)/FontFile3 42 0 R>>\nendobj\n12 0 obj\n<</Type/FontDescriptor/FontName/WXZQIM+CMMI6/FontBBox[0 -21 892 714]/Flags 4\n/Ascent 714\n/CapHeight 714\n/Descent -21\n/ItalicAngle 0\n/StemV 133\n/MissingWidth 333\n/CharSet(/A/B/C/l)/FontFile3 44 0 R>>\nendobj\n10 0 obj\n<</Type/FontDescriptor/FontName/KDKGME+CMMI9/FontBBox[0 -22 773 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 115\n/MissingWidth 333\n/CharSet(/A/B/S)/FontFile3 46 0 R>>\nendobj\n8 0 obj\n<</Type/FontDescriptor/FontName/WNKYBP+CMR9/FontBBox[0 -249 833 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -249\n/ItalicAngle 0\n/StemV 124\n/MissingWidth 342\n/CharSet(/L/y/n/c/zero/o/one/d/equal/p/e/two/three/parenleft/r/g/parenright/four/s/h/five/t/i/plus/six/fi/seven/comma/eight/l/a/nine/m/b)/FontFile3 48 0 R>>\nendobj\n2 0 obj\n<</Producer(ESP Ghostscript 815.03)\n/CreationDate(D:20080318180318)\n/ModDate(D:20080318180318)>>endobj\nxref\n0 53\n0000000000 65535 f \n0000004984 00000 n \n0000019846 00000 n \n0000004911 00000 n \n0000004401 00000 n \n0000000015 00000 n \n0000001980 00000 n \n0000005032 00000 n \n0000019512 00000 n \n0000017619 00000 n \n0000019299 00000 n \n0000017425 00000 n \n0000019084 00000 n \n0000017178 00000 n \n0000018876 00000 n \n0000017022 00000 n \n0000018637 00000 n \n0000016761 00000 n \n0000018431 00000 n \n0000016513 00000 n \n0000018130 00000 n \n0000016144 00000 n \n0000005073 00000 n \n0000005103 00000 n \n0000004570 00000 n \n0000002000 00000 n \n0000003625 00000 n \n0000005199 00000 n \n0000005241 00000 n \n0000005273 00000 n \n0000004741 00000 n \n0000003646 00000 n \n0000004381 00000 n \n0000005369 00000 n \n0000005411 00000 n \n0000005443 00000 n \n0000005475 00000 n \n0000009170 00000 n \n0000009191 00000 n \n0000009553 00000 n \n0000009573 00000 n \n0000010203 00000 n \n0000010223 00000 n \n0000010642 00000 n \n0000010662 00000 n \n0000011528 00000 n \n0000011548 00000 n \n0000012387 00000 n \n0000012407 00000 n \n0000016123 00000 n \n0000016660 00000 n \n0000016914 00000 n \n0000018046 00000 n \ntrailer\n<< /Size 53 /Root 1 0 R /Info 2 0 R\n/ID [(!u}Rʣ&,at)(!u}Rʣ&,at)]\n>>\nstartxref\n19957\n%%EOF\n','Proved','BZh91AY&SY]4Y\0	_tc翇 `P9=b$\n\0\0Q2m!101&$T\ZM\Z#F@aE*mM?Ti4&@ѐ&\0))(D=M4\04z\'jG1XHLUމXCC*2fCȳ樀,	AEPRsCvdL2HvbiYlK\rPɋs@\"c$x\"-=4櫑M<f֪r.bK{8QO䙴R?>q?>{o~5@Da8v㪤\"AVS.ŶںZ4Y-6Es\Z\0$cXe̬NC	Ox;Awnv[\r\reƶ~66ݜiɜYױn[m\rE,	(AQ6\Zlif2X4\rl3J1٘caf-mf4996ȶʧ=͡ov\'zY,&SnZ̓1ddd2+iebņ\Z;`*3 \06HA@$$rH]b Md{IBv$eN!;Y_<*Vsgz>;UN[nEӦg<WIڪvo>Yׯ7|u9$ba0L,&0vziH,RPQ$Ǚ`ʩNM5Z\\<PHs7v!w5Ϫ=>2Y!o/.\'^qܦXޥdC|J+PqQGFw8*슍V}M\\!\Z}ӬP!f{s[_%x/7RCy=>z!a\ZxCTSOGpHm%`1;g%ݪe%uwOO*˗Ad;<zd=%</FGrE8P]4Y'),(25,'point A 20 10\r\npoint B 70 10\r\npoint P 50 40\r\n\r\nline ab A B\r\n%line pa P A\r\nline pb P B\r\n\r\nonline C P A\r\nparallel pab C ab\r\nintersec D pab pb\r\n\r\nline ad A D\r\nline bc B C\r\nintersec Q ad bc\r\n\r\nline pq P Q\r\nintersec M ab pq\r\n\r\ncmark_b A\r\ncmark_b B\r\ncmark_t P\r\ncmark_t C\r\ncmark_t D\r\ncmark_r Q\r\ncmark_b M\r\n\r\ndrawsegment A B\r\ndrawsegment A P\r\ndrawsegment A D\r\ndrawsegment B C\r\ndrawsegment B P\r\ndrawsegment C D\r\ndrawsegment P M\r\n\r\nprove { equal { sratio A M M B } { 1 }  }','<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE figure SYSTEM \"GeoCons.dtd\">\n<?xml-stylesheet href=\"GeoConsNL.xsl\" type=\"text/xsl\"?>\n\n<figure>\n	<define>\n		<fixed_point x=\"20.000000\" y=\"10.000000\">A</fixed_point>\n		<fixed_point x=\"70.000000\" y=\"10.000000\">B</fixed_point>\n		<fixed_point x=\"50.000000\" y=\"40.000000\">P</fixed_point>\n	</define>\n\n	<construct>\n		<ruler><new_line>ab</new_line><point>A</point><point>B</point></ruler>\n		<ruler><new_line>pb</new_line><point>P</point><point>B</point></ruler>\n		<random_point_on_line><new_point>C</new_point><point>P</point><point>A</point></random_point_on_line>\n		<parallel><new_line>pab</new_line><point>C</point><line>ab</line></parallel>\n		<intersection><new_point>D</new_point><line>pab</line><line>pb</line></intersection>\n		<ruler><new_line>ad</new_line><point>A</point><point>D</point></ruler>\n		<ruler><new_line>bc</new_line><point>B</point><point>C</point></ruler>\n		<intersection><new_point>Q</new_point><line>ad</line><line>bc</line></intersection>\n		<ruler><new_line>pq</new_line><point>P</point><point>Q</point></ruler>\n		<intersection><new_point>M</new_point><line>ab</line><line>pq</line></intersection>\n	</construct>\n\n	<labels>\n		<point_label direction=\"270\"><point>A</point></point_label>\n		<point_label direction=\"270\"><point>B</point></point_label>\n		<point_label direction=\"90\"><point>P</point></point_label>\n		<point_label direction=\"90\"><point>C</point></point_label>\n		<point_label direction=\"90\"><point>D</point></point_label>\n		<point_label direction=\"0\"><point>Q</point></point_label>\n		<point_label direction=\"270\"><point>M</point></point_label>\n	</labels>\n\n	<draw>\n		<segment><point>A</point><point>B</point></segment>\n		<segment><point>A</point><point>P</point></segment>\n		<segment><point>A</point><point>D</point></segment>\n		<segment><point>B</point><point>C</point></segment>\n		<segment><point>B</point><point>P</point></segment>\n		<segment><point>C</point><point>D</point></segment>\n		<segment><point>P</point><point>M</point></segment>\n	</draw>\n\n	<conjecture>\n		<prove proof_level=\"1\" proof_limit=\"10000\">\n			<equality>\n				<expression>\n					<segment_ratio><segment><point>A</point><point>M</point></segment><segment><point>M</point><point>B</point></segment></segment_ratio>\n				</expression>\n				<expression>\n					<number>1.000000</number>\n				</expression>\n			</equality>\n		</prove>\n	</conjecture>\n\n</figure>','2006-04-06',2,1,'GEO0010','%PDF-1.2\n%쏢\n5 0 obj\n<</Length 6 0 R/Filter /FlateDecode>>\nstream\nxMu[#ERX\"$k#|@>6a$~?zwAP`G̬}H\Zu?_ڥ6jݛ\"˚&	;?IRX(-QsjmʶjoQθ~\rq\nuR7?.	bN 1#ڑdOx\'oR9	Ȩ߶_VX/#X׻7lr\Z?;Flѫǻiߗo_WOď{FWVZYA$tfWcn\n\rX+A0kV/uU?ړ \")|ߛ\\LO#Y\\Jhm\04Llp;i\"|};ɱ3z!fQ_8r.pasvvֈMÜ-|O\nho0]ڇǩs\n=utM\'!4:h1Ս%T~9[=j M9FkA9B>(	Sq9\r޴oX\ZV~K\\`{-5;{q/1RFҮ]&+*Y7w=%fy1ҵFvj/\rf9ZlgJ<3%3k]yfJdiL$SyI|\'v~ntT\'R`iy@Q]CyhAzEudIptYv&̤eLDR{&L\"\ruUGώ/#=~pJu~0X\'\r2./poq\0O}wu\rk4䵞2 z9L\"yöDَgnWJc.@a\ZH21WdIϋL=]#\n[K̥2,_0vͧ;S=;(KaxRY7VvXȩ.W\rƴ/32犳3=fSD6g;N1\r)Hh`px8+̝ju9u-\\Z~4Ak)\":qjpOP)禍ޜWD\ZZD~kOh1\rKuvUsk74\'אލ	\nvN4Xy{n<v!~r?!+>uy ?oGf06aeBtƄ0G!5MiZj^Vjhkgs\rxDuFӓԼ\Z{\Z`P%c CfK5<yׯ,az[+-ծf4rAaW3z^z]CQu|H?\r!:):,Q>mSȨ6l/,냰j	;!nO6w\ru#Uy`yIt$6\\X{V)VBHA𻒋;W/q1ҴcE9U\"\"C#{Rփ:,xNM9ϣFgWsc{\Z+:HU1\\QhU%r\0,\ZXJ\0xVڡeC.DEʁ|\r,Xh*5W8&67f		A?b\'X$gYht\rhjxNս>fx._`jbqَ\\ɃQ)͖:HsPrNVRS1]rulE\"${]SˊECYHyvm|h\"TPG`I!%KWVc)`1,Ļ)Gv4{7d$SI2_P	M<XM>R(q֬HHv2|,++x`8pI*H\npEn^jw*W%WǓW]g~MZ\'o\'m)0SXz(؎EJ9U;}X;?ޑX{.5|~Εy-+zl5¿-ZB2hɼ=ژQU%s9\")sfsx770BavsUN^#=S|HukE\"]TdlBjET,Jz}7\"Y(Y滋y`8\n+	}q#NM^bUuV#ZuNn%ƲMIpcڅx#*wTd[$94Qr+R؍EqzNI$s\\jLH so^6ܪr&	@n2u^dREɛ;S!?윧endstream\nendobj\n6 0 obj\n2383\nendobj\n25 0 obj\n<</Length 26 0 R/Filter /FlateDecode>>\nstream\nxKoEǝ|m#aVpN@=ޱw8 [tUw~Ue4)#?UU>*ROwU7uLLlJ:`\\\r~v^U/u!s㵥`Cq\rAD!hyΰھOE\"XpS	=ju9V{zC߉ñ+2_5FA_(Nώec\\ѣig\"iy9dujW56fxש6}Vm?Q411gk9\'ꢺQ堉U$!?9ϿU}xS:Z<?:,4Iu,;F%\Z\'\r<UYG[9,qm,ixo+ዤ8٬Ӄxŭv9+HzE۽23]ȴίK QH7*EYʐbh\'uOf	\"O֯Z$!׿t߼iX!Üplo7HڗH}	lC<jl=d||ِ.8uJ߻ףp3\"!j3E\rh3{C#AKT0ȁAI]-!<\"mrqA!.OHm\"lz\\^ .4+n6i,AYqy+K,H#MrPLEzʤ(MiRs{XkRXq\Zۏ}I{@L>(싾g#bϞZYT%;G+e>i|DhY>8\Zu]x]|pI7\\KG]x{q]΀\r`+Xa{.`-Sczܻ7?=J==6GF\n@Mp_GANH	A^#*;n5Ys7Y~żcw\Zbڥ_!\n\"$Șbd!>)hW|JY8kV*nZ<z[ehʅ}L^K+HA4n\'tvZ2e9+Ȓ#{]܀\"s%ڲ-Rr	捕v(pw;=l:Ɩ0kO_,kZע00[cw[\0Y\\(e늳`d#lRvQ\rU{endstream\nendobj\n26 0 obj\n1263\nendobj\n31 0 obj\n<</Length 32 0 R/Filter /FlateDecode>>\nstream\nxZn6BRѥə-@it>$}iޤ@3Vj]خ0`ks8̐\ZW[>}]ukWY0udR퀢II:T\'??|:~]u:_T\'h}v>\\V\0lr@y:hBiQ\nؘ֚H9nXbRG7֣\r3^3\\/՟[4,0%lmސip[?yⒷ<^dD!:6;/~|b{؜/v3C?V/60v)s8jC0J&}9*oc5]Sn-_vAa4!#e9섇[b,j|_vZM7s \n~W̾-yᲉ9հL\ngaG-z=L<i1)ِ&τؼ\\L1urA^X%3,v\ryc0!ʑOc4m6j2d͓9ʔgfS9SYs0AY/O21A}P$M2Q`6^<EGؿ+Y!؏)t=U\'G_8+;TT{5\'f%g͇5A|N̍NV8Pt\ZDe\ZVAv\"vHW-;cg;}W-9wnFכ(rښcIs\\L}T9`9͹H|Ys}¢;Fչik|\'$hQSIͱ^epkp;oyn!z\\VS̼iȄg܋9Bbőnc!$Y񺤶D9A	TR\Z!S)(kд.S!OK	<{{P%#Lhh%V˕N܋e	G|urdƶhcd(Re2<2\n̮.G5C-iH鿣3:c#g	Wș07\rGeN[HGDu??E;9Vѥ	\r>\'B\\yh.CZBszʷ<\\\"2g)~}d趥hq^GϿ[ہ|tEܟ_Vdh\':yߴ[&gPQ*`r}`פ}.E]T.3;::َVߤ+[\rU8cȻda$ް\\ٔM_F]V58U\0=cӄ̀4x:K0Rd3f7+hGt7}#lT *~4H7S0:\0\Z\r)\rM\nH\n)h{.\"kQ$j?b)2tct`aP.q߭_Au\Z/TiEY\"mP12k\0&Ŗ5lyeɉLv;\n endstream\nendobj\n32 0 obj\n1596\nendobj\n4 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 23 0 R\n>>\n/Contents 5 0 R\n>>\nendobj\n24 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 29 0 R\n>>\n/Contents 25 0 R\n>>\nendobj\n30 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 0/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 39 0 R\n>>\n/Contents 31 0 R\n>>\nendobj\n3 0 obj\n<< /Type /Pages /Kids [\n4 0 R\n24 0 R\n30 0 R\n] /Count 3\n>>\nendobj\n1 0 obj\n<</Type /Catalog /Pages 3 0 R\n>>\nendobj\n23 0 obj\n<</R20\n20 0 R/R18\n18 0 R/R16\n16 0 R/R14\n14 0 R/R12\n12 0 R/R10\n10 0 R/R8\n8 0 R/R22\n22 0 R>>\nendobj\n29 0 obj\n<</R20\n20 0 R/R18\n18 0 R/R16\n16 0 R/R14\n14 0 R/R12\n12 0 R/R10\n10 0 R/R8\n8 0 R/R28\n28 0 R/R22\n22 0 R>>\nendobj\n39 0 obj\n<</R38\n38 0 R/R36\n36 0 R/R34\n34 0 R/R22\n22 0 R>>\nendobj\n40 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 41 0 R>>stream\nxM_lSu@S2콈P,e6&aFc5nOGtsoe[Ww?keQ		iQ7ʣ	#ӻ_y+/?9!fa;{j$Si2UbO}}</>;0=Cz|R}{߾RrJ=AHRWbXri}nts<MvgnRg#dq1t~qEfve,Wr-V_bؔ!\Z	M#=cGd82L?hI4\r /4X(HZLԌX\\..<;(Y:d(9{¼0LNMI(؊!99XRymr2/_Wu`ʌ~M,*Ȁi<hb\0q\'6i9#k^Mj7RKEA\">_![Ne؆{WyV*4Lo	BXUAUO\Z1=v ZFe}szd͗Y\n̍Eey<dH$&&-GnЭ%:EE>VDr@3Aʡ]mu:b}\Z?|/\"&l̬\Z2\'&!*2p.Yu;^EfPY8a\rI6tЭ|c\r+{\rnԇ/\'r	/\0?%-#aPψ^UVjrG.܃Cm]\'Ůc.cc_\n,Gw66߰lXXX!_X\nendstream\nendobj\n41 0 obj\n852\nendobj\n42 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 43 0 R>>stream\nxcd`ab`ddds\r4~H3a!ֹ}nP;*9(3=DAYS\\17(391O7$#57QOL-SpQ(VJ-N-*KM霟[PZZZXT_6QaCcb&|}c^柛\\ҽtiQw_>ڢ%33V/`w}D,*(ZVfͲek`82sɰn樛1eForovvIӺ56ߟsi~g_]7GSCG]z/^~	oi^p\0\0.\nendstream\nendobj\n43 0 obj\n363\nendobj\n44 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 45 0 R>>stream\nx}{lSu]׻6Y{;Pyl#@D-c\n0^]>m}ۮۺWvcSd	8Nb@AfbC@No	2/M%&P4M3_\":8!t7L-9s1c6.Ch7viV(3yU*ujeaL+]*5UZʼJeQFYҨ:=jj*fJ]MQTR^~m)j	zzʤPDJ%Q\'MՄ2Jeb#HCAEca\Zu8K^^_0-nв^x;\npIp\Z3[{?`cyI~x;G@u]>w{`,tquf{%\něrOcQz|h<jʅ:ppY4K*p127cR0^{*I3\rFP{ \Z6hvaObmmyHlЖYd6Od\\ Bfp^dݾUd/i.:(Jߗ=9^wv[m\\H#~\"DCrQIXzob(v4z-\"$s3G\\;r3c8XT^bpK|BI($UPRiZ|kE> kyIM?SϰVń05dd93퇕RbuEe	w>QfpgZD!ޫeTh435~`-`t.=x| \0^+v vZ1K31ɩ2-)b-sIC	vp\\)mR6n9g(\\]kK%OW^L;]wԁ7tWhynOA\riS_{rɂ,xEQm	~۩ro<	\'?!wƪ+8zE6i(vJ,\\+g1iG6G 5P4N6]3AvuIAD|.nkv7pB,ݭ	Kqd/KL1rY[/wvn-:\\do-&\0I1tL= e]d2\'Buۑt&y<KN\n8MM?\0捙v\nendstream\nendobj\n45 0 obj\n1244\nendobj\n46 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 47 0 R>>stream\nxklSeiak&,9\r\n8	crpeˀ:;6kq[˹<]vۨl	q}@AE1#fAIhD	&OP$y{IL$IRo-MرL,=&/\'w\Z44\rr&)$ٚ_Y[՘_[4ϼb.o.,)Th6VKcyf.IQm.T[u==++jk,vsa}?Aik_`A&s,b1Aki>PפM(2xBn&&=$жغ&.!ܒGuw+:SVcVGQ(VŮ	\0nl:XMv^R`)8 :1.Bfxܮf\Z7>.0)|ݠ;q(5w}TL\ZQިuغ\ZŎZ2P,G}5\"`]nb\'{HW>t>3D3GEs;mS- C~@ǧԥorsc#;Z7QH.Hg~\'ce&%1hYj<r3Ey/K)${=\Z;p=20r];{4{C7AU1D/1[q.6G|CDW|sh?묂\\,%\nn?i꒤~KrnSʐ\rE8K\rTԣTlǋWfJ^߀u\Zz^	$hc}R#1gK?dE#3\Z1\nU;4jf$O_ak^|*vi#oP$BS+ټf]~wH+c\"CG40#3gDqAx`sq꣺抢d9J DFqIR\rbw2\rwWp\r2jz@t8?$ HJk8,;Uɪ/\0\0lDA_Y٨ux;Jh\'m\nMaViO\"Uq=;vM>q~z_--P\'\0_5kSDRaTsI~#T)oJRijDmuqlf˄\'4ld*<W\Z~~A	hɂ8XSZ8%fd<~o/Q&8~7~\n2\"mUPy[Q\'ң?\\e?^y3rR᧛ROp¥DLľH	u1\nendstream\nendobj\n47 0 obj\n1288\nendobj\n48 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 49 0 R>>stream\nxcd`ab`ddds\r~H3a!+o\n~7n(_PYQᬩ`hiiZXX(\'gT)8(t+t-(-I-ROI-K,*/d1J	+1>{VtW9V[]V:{<FZg`_tE⢼E+W.^B?QKn.74\\&퓦ϝ\"+O=_ygŪ\'6vs475(w[M9҅?Ⱦ|m3xx\0L\nendstream\nendobj\n49 0 obj\n370\nendobj\n50 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 51 0 R>>stream\nx=Q]lUcbX[hI!TO4&h@6<Mvi]hidw;33wghk)-b*Ә\Z@Hx Rドфxg5;99|(4	(6y%^:mbl+]yUŶ]CH4\rE|G|;;7|-cCA\ZZ{VBchFuː\ZZV]x<5364q7sߙ@6^lccsRt`dpx6dӲԔ-Yq,M[sivttwh\0H3%82	D8;ɻ;aWlaӡ/CK3ihLS4_V*1Jdd8r0\ZDi+vlxm/x:~x\Z..KsȸjF=g\Z<opb&K×Cm\0:pxRH\\muWu4?;c0%&\ZyzBśad*=[oqq}3ر󧣥X)eN\nd\\)?l\'P;/%>z}d\0-a+Ta+\'&ON(;qWT#:Uk+ޣ}LT짍װK|k\\?/0{	w|O&ǒIYfL%EQX)GuG3^p\n|jbjjr+	0N!`li/4_FG?f<чv¿68\nendstream\nendobj\n51 0 obj\n812\nendobj\n52 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 53 0 R>>stream\nxWyTSwH+jm^X7\".Ūk  YDV!		bY\\@YTTܰj]h`bca<j3;9g受s^<dC$ih}gc}_\0X՛j[05q@t[U\Z/	\n;Nu8%\\,E8zp!q,g;H$vGe3]1rC\Z E1n}|4 R,HD~S͜;o~hy)A\"&b	Fl&܉O5b-A$6[1N FxMcwK&(xAț6N6͂% r	BP\'\n\':oؽmgwwps?zh+M^B\"G\n\Z;yL5d>f[;|Ӓ\nV@r+X|L6\"Y`]T-TJI ITKKf5A&(3S2&1x*I/оSYzBy4\"P\'R\'\\]QcIiׂTe	g>op9-|ַM$\ZԅP0v%Ji͏B<Ii+n氎ک5jіgB+i|k̡_<y{#I/>9+y24fX	Llf\\\"DQJ!˕UGQ3p̼w\r/TJ	=msϠhKEgղ|ȇN7ݨ[`U\n;(<TFr`qb$?\ZըifhӧJB*DY^ @DKsg7}TSL(\n-ѻW۾h8\r3xhM2nfZթymwxP퍕Tn7F5F5/ahm<f8|p,J\\\0\ZPjA3M։fu2tPvb@LUFՆ^\Z\rF6h4ble{~ho#`ˬULsF4?Jzb_qe]4-#yeF?FnnQ<cϛ[m?kG2\rEC^We䦦ejI{䵡mKHg|4Q%QENjH;rc/@SPjMB2Dӑ=5E\"9y%s۵EY5<㨕`*~WEVG{֞h5cJm7Ikc-Py҃D2(4zWMP^N2R\ZT;F!_W4>aUT/3P=dJtU%ft20r,\\;kK˹҃׺rȃ~b5QiѺ9jHNbAssLJ⨊Vrd)T=L\n&C⤨?MfU5@\'BZ<GQ{ 07+-(ikVx94ݾ~2*,(ϥ8*getЇ+\Z#\"oLf%CzŐWɑ;xK6\ZLWG\r1҂ȿvfrNd$K\ZU!ob;[(IP;|W+~\"W=\"HdFkSme2KX)؃W<7N@)?m*>9G9\ZK6	w-mh8ig~B5U?3wzG]gxq=OvVI{*uMr4\\Uek~5Ч;PjzE{kp69s1#jYr;/R h-e]Z+wU{ZM4++_OPWЫ!Cb;Eҭ#<\">u\\Y?x7}xu?Xe)Yxg@tO	ۯ@9d6&8])ܭQ1a~bctCH,ONSG)@Oq*9yAv+95h\ZfgkC/y+&>3\'Xx]=+-8J棟F|l!&0?)4UV\r\0<!\nI]*32h6`ۈ<˶>3Ȟ~\\EVZ\0-e ffVGCg+.\"! XYYg*)b7;DFGwrO`#,5#-c1,MKZ>:>.s㓚_}\ZKM&\\6\"t\n龿ZVG3|v>)eS,~[<[,\'ޑIxVl%WLgaa8=z~è٪W/-W(VR))!=Ս\Z	kh\Z^҈y,ҹs7ejJkb\rh2Y㭫nۤe|qxVXG\n\"Jd⊉lB$LȪx /._>l\rg2},|h~G/uг=u\'/MtPZ.	a+/ڀ~PfGxLI|jZ\riIӀN:\0؁e^G\ZMb*?ʅ|G+sM]m;\ZC_/-(b*EsehBʂR	л+LM%ҿn_PLF5dH*g53@<;HR_.R$R&poʂ\\uкzKLYd4Ws\0\r9\Z,&}c<Qx\0_eAG]̊ :0AUg6՜o{qx$F4)Ac9ϰ\Zf<!%ZqR\0JD<+mlyފ@}ֵSY5~57KՍIPkԐr(zZQq$=dK 7җ;>=lőŶK$WmB%7ɏÆf\0N}H9Hfx˩VGHUNKXlkfW8_T{y1[]bm:;\'8QĶQ~@DjEVΜ29Og7yqq1=ͼ@i8~q~-\"~tiey4	/WAͣ^ٲjƝrv&1PuQSa^ϒV^ypԥ:gnx\'u?XP3UXSY-<>z\0ѕ:T}#$EFlm&ƣ\'3cMe,f>fxî(@/S#5\"X喝Rv+C\'nlBȎ^/7^poꠈ\rfJ`+ 0)bcP\r1.7C(@\n)]`n-S}W	\nendstream\nendobj\n53 0 obj\n3558\nendobj\n54 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 55 0 R>>stream\nxcd`ab`dddw\r44\01H3a!;%k\n~n._PYQᬩ`hiiZXX(\'gT)8(t+@lu-(-I-ROI-KMj+I,````4c`b`bdd|?ڙr8cRV?aZ:%[&͜:qr|/d-0}3n9.<g00\0\0fZ\nendstream\nendobj\n55 0 obj\n262\nendobj\n56 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 57 0 R>>stream\nx}{lSuw.0@uTGoyaC6!%lH\"\Z*{Ji7ڵz{}l]Q[h\0MF\"E20!cb<Q~|{~IO#ðE%%kxI%fǴ{C9uip*=ETS\"zS\nn~E˖u5S\nCVrm0n4_VWR{te=Pgf^+1LEֿQL2#ϑE$N!%dY|V6!}d#r_lq|+(1\rv\r5#~Çp.dowxa\0¡@{ xz`傣ezasDG0G+F#]v_*y%?=b[hl}@ZB#x4$_²+jg\\\0>X\Z,@5f2\'XWi8al11\0QW\0B7@]s	}wiX%O+\ru$wq +[Kd^[XI>ΌJ^O%ve32\n\Z*P\'t>s{}7!Eඉ&vEuz:tgx\rc&N/^mZOӍw U +9~[W͊|dфk173WXSOI=.Gg~k1;haeK)Cq4W͔icS9\rYxW\Zװs s}%:-9~h\\r.{RjzH1_<\0\\vJu^Adhwq8U6;YW\'q?$Gp5~V!$EI^K罽ꕲf^\rv6y	x$9QwwʁS4Yj;mҢ^n9:횞]w5}.ǫJߐL?d[.Cr$W\\7M7\'x$;XľD[$x8G;рV>_x5!W(Ի:=G/zu`\'S}u*Me|Y:G<i{Y4[:||n5|-FC0K2\'~?I;1]˚0\"/\nendstream\nendobj\n57 0 obj\n1206\nendobj\n58 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 59 0 R>>stream\nxT{Pu`YNv+C\'|`JR\"Sf	\'Rݻ(xc:eik1%98YǌnPk&鏝ٝ> Д+?\"=4\nY!;#YϢϠ9ь)SN)**[oE%$%Ksuنlؠ,f7lЭ(խЗK%\\}I!EQl)/Jͤi+ԫT5zKM\"tPj>*hTu1xOtoZ[IP&gqnZnd-Nk}\0vjI2	z46z%8X9G-X)T}\nzK\01Bm:4@lfŕi\Z\n#!Aw}R5\\anh瑟AQ\n{>L0fNp`*\'~;@lEjf:\r˚-+@4k{ykj@d	@~@̝3qOHO1>M_/(bIE5\n፸\Z\'0Lk:0ߺv*6а05#5s٦E}bt?$_?$b6G7zrS?P}8}?\nۦz#yryEţ`<3n{K\\k&aG#O*8/\\ 	O06U\'} \\Idߣ3\ZȠi/\rx|?NS#IJ9BnR%T+v\\<:;Pqjnż<~է4%|ֵ@ hd2+AsIXDn	^\'\rӟ 4;sKPg.E]\0:,&ŹA!.L<11dq_E1H0D[1U1=C:Q\n%U6U<>aqc[ƭ,ؠ<Cibeo̅ͅes5Bs(Aʢh[7۸wU2\'Q#YlB1/[\'sI\n0\"\0BGE$PK.T˱% L>rQEgU~Y5u]BF9Co\r9T͏1m\\B̌XՍlsn\\${YZE;fĕDis9%}sd_隣D~$`hʙVSSk6~bY8s[X8;͒eniap\'v).,x~g^Wx8E!\nendstream\nendobj\n59 0 obj\n1362\nendobj\n60 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 61 0 R>>stream\nxcd`ab`dddu\r21H3a!G&u?\n~*_PYQᬩ`hiiZXX(\'gT)8(t+t-(-I-ROI-c```4d`dbb`add?U|V3[+x>w?~foݨ{]M<1}r}߆_~Ѽ\'NC5je߾~QE}GS[kOjv/~ktn7Nm]WWw+G[_[~\r4)Y{ӏZ+ۻs<Uӻ9Rؗv>O/{Vw\\B\nۡ݇fvM	*3-iYNƾ|Փxxe`\0\0}Y\nendstream\nendobj\n61 0 obj\n434\nendobj\n62 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 63 0 R>>stream\nxWiTS!@%Գ7mmš*-UqE2 )ʐM\0dNa0  \"JjzZNj7Q{{sZ{%yD\r%$Vsjd#fc8dvkx͑8aA硔X$Zb˂ȨX\'\\̙4?<P=/i_lH`_C>2`{`ld2:1Nc;=(EliU@yEQ\"\"\n\\H$v\"c/yw&Ou6}{ZC-R);zZBMR(jLyR˩\r\nj&ZEQ\0j eO9PCa#%S#1G9PP4U& ҈$EbFNv8`#20iσU\rvkpXr08tq>gaaXoUo6CSXvˢ0o-[uC[UGhb!t\n-#͚Dn:=mIhWgA֨&(tf: @n8PD#w%RxD.^e\\#0U%q]ޭ\'/=[	UM̤lkUn!G|nv誡\nNjb*+_.xsGn69z\ZnY֘\\\Zw7\\H/?J;En7Q{44a&Mx__貸*}避mB(2AG\"&/O	f#8gh=wA;XTJeQTs[0z=602Pʑh!(|\nGQ8w`T(}\"6Ҩh2bP$Џe4+3Ӌ_h2މ7FVy!OX\"%3h%~@21|!*Pt,@|1P}\'4@kٻ Ԑ8s,j,sjĘ;ݳ_|(^SPi5Q5yuPkB[5o)ӵ4ˤ#R` T`df:Ba.Jͥ!!8h*79tcopek;k;tbG͞o\r=a+`p/?!	\">zड़4/%jO骠\Z:\'+z9	t-q\'k#χ)cgFc(.߫KߣN۫CƺnbO@42Z2i>M`\rz:w\"},n*:e0WIr12?@q-#cЅtb9]iK>nE#kf+q-qQ߶M?fq+(Bۮ߉qe,3\'fCj1LlI\\um)~âY^kr%r6]\r68b;Fjof?(n1{Kdr\'jyK?,śL.M\\0U|?J(!<cD®ＬRҏ6_Je_ROWc8\ZGwсFǩ4q)D\ZeuuZ_ॾɜ*Є}-*_ݪ@p9wݮ4\Z!\'q;WTkM||b4aIr~oJld\00ιlsdWv6+ƃel(3ҕ$TmI2L^Cci+)!Bi/\nqk|!Yp/\Z;6pja\ra:ȂR=R5?F[pxmxm!FKIt0xRp8,\'K;d\'8L}y\\)GuCrfn\r^ ?s!XO=`!:}s!6亦_wgNf?0^qJ>=>,C@bŵN{4\Z-+bON2Bz֘qc\',`6>m<*df&d$Zmy9Ӂ1At|hݶ\\\\Fzu}sZnMLi	c\n!BB2]\r)8U=\ZH(t}HIdI{2Nkmn*|o6hWr[CQ\n=͖̎gZf	lp@0y[̣ݜA\Zu8,dduLe[\"li<tɠ*2\r<~RF6tQd5E?3\n|꓃֮~oqz4z/8$VzLĕrfNF-ɐ)j.]=h!d-{Bze{,.f҄7DN۩<eͼI[\'7DQQhsPZ9B\Zo5BW..dRu쌶S~b\Zd\nSqҙ5r--1ϫr_1Z$Wp\\\\q}ddB\\3g|v\'l[SQS[[Yi}ͥw\01&Q	s` ޓ{}(\'\n;gD(6dbC\\LҒ3>OE\0\r(:[*iCQYV@rA78t?*\rB̵$-36WQzK*GDkHhܖ|$XV(̞nTU3	׬Ws/@VZ/Y^ϼBH;q.gtkOL`MӫFCcwO[n/FHw*WlV@_0O4ehƱlhhm͛K3gײp}bUMjzGZۦArjjeüP~r.eѓlp֛8g@|?\\lwEoYb`w_+#Ro<ta\0qŞ/h6&nr7z%3I	;mAIs+4FWVgR!&ʘ&!MfBӯ<$z91\"K,%1A(vp+/1LHrM\n[v- dqVd=n\r`Oii*P\'?9%ӁD\n])BpW1iY\rphppQKJXV\"r@믑]\ZX_nUqc(9\'*21\Z)s_Nv=NJai5\\䋗Y~=ˏ~Sk-rtWxe=v脯Gξ_3$\\fZSp>ЕY䙄FWBsz+a,QH.[H@&QШ/;],jtA£NU1}t*ŅI\Z2a\Z\n]TM3\'x_S}v\']B K%=Oq*r;(\\\'niOBfijШ;s{s*xPRh_(-bVsI8O>39s\n3F/dnL?3k\ZkzcI/H]|pIQG[䚽u*դj`7#S*s;*Ѵd<ymqOBt1Qdko\ZF{HqmlMn[Vd,9|Ļd8#LyD(}i?M[8D+!|ZqB\\fZ%a+M5	R{0,& ͚fqa|Xtq^|ߏx+b$}$\ZIu)FH~<{7v~\0c_:\nendstream\nendobj\n63 0 obj\n4035\nendobj\n20 0 obj\n<</BaseFont/YWRBPR+CMMI5/FontDescriptor 19 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 1036 1037 996 0 0 0 0 0 0 0 0 0 0 0 0\n875]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n18 0 obj\n<</BaseFont/SZBQCB+CMSY6/FontDescriptor 17 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n963 380 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1222]\n/Encoding 64 0 R/Subtype/Type1>>\nendobj\n64 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n16 0 obj\n<</BaseFont/MUQRQK+CMMI6/FontDescriptor 15 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 924 927 884 998 900 0 0 0 0 0 0 0 0 0 0\n780 0 0 757]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n14 0 obj\n<</BaseFont/EFYKBB+CMMI9/FontDescriptor 13 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 771 778 734 848 756 656 0 0 0 0 0 0 0 0 0\n0 0 0 628]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n12 0 obj\n<</BaseFont/SZBQCB+CMSY9/FontDescriptor 11 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n799 285 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1028]\n/Encoding 65 0 R/Subtype/Type1>>\nendobj\n65 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n10 0 obj\n<</BaseFont/YAUXEU+TeX-cmex9/FontDescriptor 9 0 R/Type/Font\n/FirstChar 16/LastChar 33/Widths[\n614 614 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n814 814]\n/Encoding 66 0 R/Subtype/Type1>>\nendobj\n66 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n16/quotedblleft/quotedblright]>>\nendobj\n8 0 obj\n<</BaseFont/GHNQRB+CMR9/FontDescriptor 7 0 R/Type/Font\n/FirstChar 12/LastChar 121/Widths[ 571 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 400 400 0 0 285 0 0 0\n514 514 514 514 514 514 514 514 514 514 0 0 0 799 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 642 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 514 571 457 571 457 0 514 571 285 0 0 285 856 571 514\n571 0 402 405 400 0 0 0 0 542]\n/Encoding 67 0 R/Subtype/Type1>>\nendobj\n67 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n12/fi]>>\nendobj\n38 0 obj\n<</BaseFont/GKKKKC+CMSY10/FontDescriptor 37 0 R/Type/Font\n/FirstChar 54/LastChar 54/Widths[ 0]\n/Encoding 68 0 R/Subtype/Type1>>\nendobj\n68 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n54/negationslash]>>\nendobj\n36 0 obj\n<</BaseFont/WSXSQF+CMMI7/FontDescriptor 35 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 859 863 819 934 839 725 0 0 0 0 0 0 0 0 0\n727]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n34 0 obj\n<</BaseFont/GCFFPC+CMMI10/FontDescriptor 33 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 750 759 715 828 738 643 0 0 0 0 0 0 0 0 0\n642 0 0 613]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n28 0 obj\n<</BaseFont/EMLRVG+CMR6/FontDescriptor 27 0 R/Type/Font\n/FirstChar 40/LastChar 49/Widths[ 481 481 0 0 0 0 0 0\n0 611]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n22 0 obj\n<</BaseFont/QYXKNE+CMR10/FontDescriptor 21 0 R/Type/Font\n/FirstChar 40/LastChar 121/Widths[ 389 389 0 0 278 333 278 0\n500 500 500 500 0 0 500 0 0 0 278 0 0 778 0 0\n0 0 0 0 764 681 0 785 0 0 0 0 0 0 750 0\n0 778 0 0 722 0 0 0 0 0 0 0 0 0 0 0\n0 500 556 444 556 444 306 500 556 278 306 0 278 833 556 500\n556 0 392 394 389 556 528 0 0 528]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n19 0 obj\n<</Type/FontDescriptor/FontName/YWRBPR+CMMI5/FontBBox[0 -22 975 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 146\n/MissingWidth 333\n/CharSet(/A/B/C/P)/FontFile3 40 0 R>>\nendobj\n17 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY6/FontBBox[0 0 1128 432]/Flags 4\n/Ascent 432\n/CapHeight 432\n/Descent 0\n/ItalicAngle 0\n/StemV 169\n/CharSet(/arrowright/minus/periodcentered)/FontFile3 42 0 R>>\nendobj\n15 0 obj\n<</Type/FontDescriptor/FontName/MUQRQK+CMMI6/FontBBox[0 -21 944 714]/Flags 4\n/Ascent 714\n/CapHeight 714\n/Descent -21\n/ItalicAngle 0\n/StemV 141\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/S)/FontFile3 44 0 R>>\nendobj\n13 0 obj\n<</Type/FontDescriptor/FontName/EFYKBB+CMMI9/FontBBox[0 -22 823 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 123\n/MissingWidth 333\n/CharSet(/A/B/C/D/E/F/S)/FontFile3 46 0 R>>\nendobj\n11 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY9/FontBBox[0 0 970 430]/Flags 4\n/Ascent 430\n/CapHeight 430\n/Descent 0\n/ItalicAngle 0\n/StemV 145\n/CharSet(/arrowright/minus/periodcentered)/FontFile3 48 0 R>>\nendobj\n9 0 obj\n<</Type/FontDescriptor/FontName/YAUXEU+TeX-cmex9/FontBBox[0 -2957 781 45]/Flags 4\n/Ascent 45\n/CapHeight 45\n/Descent -2957\n/ItalicAngle 0\n/StemV 117\n/MissingWidth 250\n/CharSet(/quotedblleft/quotedblright/exclam/space)/FontFile3 50 0 R>>\nendobj\n7 0 obj\n<</Type/FontDescriptor/FontName/GHNQRB+CMR9/FontBBox[0 -249 833 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -249\n/ItalicAngle 0\n/StemV 124\n/MissingWidth 342\n/CharSet(/L/y/n/c/parenleft/three/o/four/d/parenright/p/e/five/six/fi/r/g/comma/seven/s/h/eight/t/i/nine/zero/l/a/one/equal/m/b/two)/FontFile3 52 0 R>>\nendobj\n37 0 obj\n<</Type/FontDescriptor/FontName/GKKKKC+CMSY10/FontBBox[0 -216 638 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -216\n/ItalicAngle 0\n/StemV 95\n/CharSet(/negationslash)/FontFile3 54 0 R>>\nendobj\n35 0 obj\n<</Type/FontDescriptor/FontName/WSXSQF+CMMI7/FontBBox[0 -20 893 713]/Flags 4\n/Ascent 713\n/CapHeight 713\n/Descent -20\n/ItalicAngle 0\n/StemV 133\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F)/FontFile3 56 0 R>>\nendobj\n33 0 obj\n<</Type/FontDescriptor/FontName/GCFFPC+CMMI10/FontBBox[0 -22 804 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 120\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F/S)/FontFile3 58 0 R>>\nendobj\n27 0 obj\n<</Type/FontDescriptor/FontName/EMLRVG+CMR6/FontBBox[0 -250 505 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 75\n/MissingWidth 416\n/CharSet(/parenleft/parenright/one)/FontFile3 60 0 R>>\nendobj\n21 0 obj\n<</Type/FontDescriptor/FontName/QYXKNE+CMR10/FontBBox[-40 -250 813 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 121\n/MissingWidth 333\n/CharSet(/y/n/c/parenleft/three/o/d/parenright/N/p/e/D/f/E/six/r/g/comma/Q/s/h/hyphen/G/t/i/period/u/colon/j/T/v/zero/l/a/one/equal/m/b/two)/FontFile3 62 0 R>>\nendobj\n2 0 obj\n<</Producer(ESP Ghostscript 815.01)\n/CreationDate(D:20060627000209)\n/ModDate(D:20060627000209)\n/Creator(dvips\\(k\\) 5.95a Copyright 2005 Radical Eye Software)\n/Title(proof1.dvi)>>endobj\nxref\n0 69\n0000000000 65535 f \n0000006062 00000 n \n0000029628 00000 n \n0000005989 00000 n \n0000005533 00000 n \n0000000015 00000 n \n0000002468 00000 n \n0000028076 00000 n \n0000025016 00000 n \n0000027825 00000 n \n0000024720 00000 n \n0000027608 00000 n \n0000024390 00000 n \n0000027387 00000 n \n0000024188 00000 n \n0000027166 00000 n \n0000023986 00000 n \n0000026948 00000 n \n0000023656 00000 n \n0000026733 00000 n \n0000023464 00000 n \n0000029287 00000 n \n0000026340 00000 n \n0000006110 00000 n \n0000005684 00000 n \n0000002488 00000 n \n0000003823 00000 n \n0000029055 00000 n \n0000026165 00000 n \n0000006217 00000 n \n0000005837 00000 n \n0000003844 00000 n \n0000005512 00000 n \n0000028831 00000 n \n0000025960 00000 n \n0000028610 00000 n \n0000025764 00000 n \n0000028405 00000 n \n0000025525 00000 n \n0000006335 00000 n \n0000006400 00000 n \n0000007338 00000 n \n0000007358 00000 n \n0000007807 00000 n \n0000007827 00000 n \n0000009157 00000 n \n0000009178 00000 n \n0000010552 00000 n \n0000010573 00000 n \n0000011029 00000 n \n0000011049 00000 n \n0000011947 00000 n \n0000011967 00000 n \n0000015611 00000 n \n0000015632 00000 n \n0000015980 00000 n \n0000016000 00000 n \n0000017292 00000 n \n0000017313 00000 n \n0000018761 00000 n \n0000018782 00000 n \n0000019302 00000 n \n0000019322 00000 n \n0000023443 00000 n \n0000023871 00000 n \n0000024605 00000 n \n0000024908 00000 n \n0000025441 00000 n \n0000025669 00000 n \ntrailer\n<< /Size 69 /Root 1 0 R /Info 2 0 R\n/ID [(.;PMdIT6)(.;PMdIT6)]\n>>\nstartxref\n29821\n%%EOF\n','Proved','BZh91AY&SYe\0^\0tc翧%j`=9 \0\0\0R\0\0eM@hi\0\0\0\0\0\0\0hѡ\r0&\0hb\0ш\09F@4h!F#Cd\0BR)DCO(z=@\0\0i=@\0\0\0\0h\0\0\0\0\0(HL4h04\054\r\04ꢯ0jI/V#JdTe0P I1Eb%PeE١P0JXXb1-0,)QZhJW;%vt\'\nU /{6Lr9|@O~D.ƼA $Xn ;N` ȥ}` ;	\Z@TTZk_Gb%1bɊBn\'>eO`I$Q=>_PV1cSN)__*xdBU-Gw{_]=OG}DJ*\"&&(،`\n@܊t\'E}(?(}N_8_G\'ûN!\\R~\0(|`|ymos}zD+_s{w@0A;PG]1Pۜ=p`ᗄt:CY/wD]]<5tI	t<EbqC0q\0WK^ŕ쑠0b\0hG@!!&*b\"&YIvfrJp<$e0lr\"d[F0]_<U<d_u8ƈ˚<k){ByO4CDw\"4\'+y{=÷N!\\RyPyJyR\\\'1r\\*ogGKtInݻE-;tԖu쥴)Zf.ӅÊoqjjq;\\kӌ\Z5{mN\rpu㝬xZIoYqۯSsfs<ui˘Mڵ]jKy{J\0W_맠FoxA*}\'z9!ѡ@ E{v\' :<ӁC<ic =0,R3\'`]UHxQ4R#*3cNbnc)! p0 @L3#\n\0*$f*\")沋ĻP܌ɠp:)9:G2dH@KM)%Tð8UTD%\'D@&9%\Z(LrtPt\rv!hØIX`\0\Z)@z(VfyV`D!Ln&lVĉeAzM0p1L(\Z2J0IIC;H(t֨0HDD+f\rt-uZWKZ*xnnU{(%ΕkaT;TщLS	bXJe\r9!(`aUXKB(wC**Tz먀&jy:<)+oæn|ᣈ|vlG3:mۑ.?V_NbYƑ}Os@ϹWm?FȞ4n{k{+/?_j6b_戯R\Z]hG~؎S8^UG.nͦݠPtrvtOvao/-UP;}w{=	uǄ%e2%^5<9!Ӿ]%XYQXU0b!(HbCVDbx,2\'GCm*>z\"\'xKoklҍx=N$:X12H4)!2\nP3\"daFb \0\"lz338\n÷.ތa\\FjwK+mމ^Qm٪!rVU2V	e!%ASR̎Q-d7\nNU@ڍ:hUAH\0iZPHJIZmJ%y8|\\-$[QTKr2	^C{[D+z¼|HHB7	hK7Mu+ْJQE|(Z|[>\"?[r}pK\Zc.Xx<1:UUYFQC!.*m~PndY,,V,GSr&wó-\'DE ̥)7ss5\nGyf\",*aw\\<\n߷\na/z$5T%awwyZ},%\"{>W-)_C}0&I|ԯrE8Pe'),(26,'%% Example 3.12 of J.-Z. Zhang et. al., Automated production of \r\n%% traditional proofs\r\n%%\r\n%% Pedro Quaresma 22/2/2006\r\n%%\r\n%% Version - Prover \r\n\r\npoint A 20 10\r\npoint B 70 10\r\npoint C 90 40\r\n\r\nline ab A B\r\nparallel cd C ab\r\n\r\nline bc B C\r\nparallel ad A bc\r\n\r\nintersec D ad cd\r\n\r\n%line ac A C\r\n%line db D B\r\n\r\ndrawsegment A B\r\ndrawsegment A D\r\ndrawsegment D C\r\ndrawsegment B C\r\n\r\nexpression e { 1/3 }\r\n\r\ntowards A_1 C D e\r\ntowards B_1 D A e\r\n\r\n\r\nline AA1 A A_1\r\nline BB1 B B_1\r\n\r\nintersec A_2 AA1 BB1\r\n\r\ncmark_b A\r\ncmark_b B\r\ncmark_t C\r\ncmark_t D\r\ncmark_b A_1\r\ncmark_b B_1\r\ncmark_b A_2\r\n\r\ndrawsegment A_1 A\r\ndrawsegment B_1 B\r\n\r\n\r\nprove { equal { mult { 3 } { signed_area4 A B C D } } { mult { 13 } { signed_area3 A B A_2 } }}\r\n','','2006-04-06',2,1,'GEO0011','%PDF-1.2\n%쏢\n5 0 obj\n<</Length 6 0 R/Filter /FlateDecode>>\nstream\nxVKOAywkcό},C-(RZ(Pn\ro);1p=OC~X).\n~mϋ}q\nBb7Y`g .AZ~jbϩ<n!OUEY,,C*p~d>m(ip	44xOba+Κ-=\n:%O9I(3(E 珪6Q>wť/;\rKM<6E$+CY\"Ĕ8!S.<S*(bijå<K߇$KO|̬vܳ6P }j8Aױ`u6f?\r\rV&@e\'5&žkgC\'LvBpmU(搧\ndJ{ٮjɃP\rҪ]=qp\rBiAliYlX;-# *@~fnqw6~\ZS]4QGENAX!,;VmDF9Iч	5ե * &У$$y&z	sa~Q!x	zsW\"\0Z֮b&6m/痑۠\n!^y6m+\"Xۇame)ZRovFSju }f6OZ:Z(6wg~)\n96)\n\0|hn{Ee)I,mD0mr;/GLҾZa`\\\\J,{ؚ}tWk=foܫbwNm\\4)tM\Z{+Nzendstream\nendobj\n6 0 obj\n818\nendobj\n19 0 obj\n<</Length 20 0 R/Filter /FlateDecode>>\nstream\nx\\Ko$5>UvF@\0!peyvaa9)owҝ6F;m}U*_!Ë*ep%@\'B]t}/?Qk|@\ngooLF\"#j(t5{?	4ʠ<̮q_?jс.Rd=}\n(r2#&5𖨸t~u@?8^/,?K+Pڑ	/л;fX58൪p	@!\"S\nZJas06].Iuc1LK*<P\0Grc\n@;|$	G\0,_~-lD+)w@|HRʭG~Vώ,\0IVz殰0ܝ׋(\\Ac<rV=ƴm1HB^ӒTf+g-5fywV\r\"tpZQfiGvl>=7$!ijgIdgyMTk ]{)\ni=@^}Jز2e]R~6u(0i9k<J9S`|6_=;8sg3VRM40ힳדawE\0o)݌Sn)Mt`5Q --X/᤺K68Tv=u#Nɱ㏮/	()\0x`|egzt|y.ǣ=O: u?a\r1 ug{R[6c_l qƾdfcZY;ޚ%Vi,b#/%GWT\\M%r3=\r;D#{ÂhM cfk~XWmmv	ԀY	Gh[\ZA^UGM5k[O2=f/6t& t7WQ$Wp:B敊e6etjXc]㏗(ZpCNnZ<yìͷL8:-G\'v:\ni֊*KѣZc]EmZ;?A{r-PV|YqZ,\0j^TĨC)\ZTRzc3\ZVi$~hQ	ˎ܎fٟ7w&\\f<?i٢5ܧزd	`KJ.2;%a\0F@\ZP4®%8AP%600R0cv/fz?@@Hĉ߷kpL61?Č\rET<WHqs8mō~S\"1 O6x=\\}EǞŌ-zʾWb(h5wTЍj=Gie^!dsj6rG]TY\">KȒ0XL#W96Lgm؍Uc仒&=uU\r(}\'maEQC5\n\ZչъM:`\"@*&@6M@:C2`Ejb`\ri+O&$C\"`M\'QliIԺ\ZL$(Tɧ@Vcu	$\nby#){fjg@ZX\"d\'>z6e\"Q2.j\Zc-lmPw:M\\zڶAiR(`:FUvPgy4()\",c#):8OsK=&?`*ZUMaPk]0+ =5P(&4񪤖6u]gUɍS}{ރ4<Ĺ\ZV4s9̓HRl1Eǣ_bLJh]W󻐄qC._v9PK)eVpVѭ@\"8,x1xP.Ӎ*3=_`!\'[nv\'[͵Z{n񟢹&3̃/i]W,6]=vtE\0zm-l9l0Y{7=#]Vj5!Xs;sy[W`#vZ\\IgM/&-\Zel$$3oRF	67-\rk$H\'2=\ZHݯ.!\"UpY4	\'\"πΠsfAendstream\nendobj\n20 0 obj\n2201\nendobj\n37 0 obj\n<</Length 38 0 R/Filter /FlateDecode>>\nstream\nx\\I5uryC@a\0a|Sv{e:mWy*L$8&\"<$ї\0eNkiO;K0Lpܿ8}~tJ⬘ZꔗGߞrҜY\\\njD۩\'Xt)ix320WE3+\n\rD1͊i\Zh\0Jg}pLИ>>I͜S2}rSU!24 o1o &6LXO2\r(D˸ݯs#RF2Q{i)9c3уlD9\rȦ6ƾIӢ%I+)PD	#x8]M6Nj\\y2kH邰&4<d\r~[aiH\0uҰsacGgW4\rHV\0\r3\"Ŭӣ\'NN_<&o>z<ooP2ӥivJmfh9MaCA\ni3f_Bm˄-*xebX.׈^#yMcK4i\\ԙZBn\\CJ\\)!Itޮυߥ[Lby\0%Ogz1CE\ZcDϩYJdImj_i9y<:ӷ8_{uu[gSj\n~-#z섟;on	]tVA<1$i_n!EϵOV 4lY)m?8G67zWk*sjXO褤MogK˸*1%0dA[pX.MHER,e&XUJ- 8kDPhCBȕ&Ǳmar%Cĳ\'˱c,`9ٖ<@H$Q\n$%GZ	B.\rPb0;\0Jܣb#/C_4ԸJǾYe+&\"At\"l`uH5&q\rˊ-Xݝ^\'<	xaA	jI(ZHZ`=0Kٯ@¦@$A֓6D_&ac7\"]{0V%HЊH\"v\rȨ<,׃\0	\\Ubi/5Dg6s\rq\Z3\ZR#r9M1i@\n{-S2#o:epPvDlBgMN}dbf~F.Ya44:SE,HoSQ8Ty#	\0BklGg͹]\r_HFz\Z[=mV%ƥH<Gh/Ij/P&+aoB#!{\Z`.?mo!20Q<x!nxHưfjL:C=	IoUp@m4WVUHs@\"ͩҗhZ314j5nMʠJ%y0өF\0]?YjIuƑZZZ*ܒ\\.ӹ%#:_3:\'E\0d ʹ86.%\"&qCd}eׂ1C-Jj!.^4Q(N\"FVɟu>I#lL\'M\nH \Z* sلw\0oZe;	A}dlMxH&fK%aPwRzQ!lG]4شEze9˾\n4	\\\ni/$L[(cd	&+7atRb=8RުpڒlWH@PaF y&fCƙ&$\0\"6]Y#8\rz{\n6b+S\"ޛXêMm6$A<Pȅ&V۫̏XaJؤRѨKPxEz6/\\wHvY]brdrř !trbxX0A\"{~jal2\"5&YjL_RAٌX n+`e\r8sg_v~\"b,.wyяwтAQ@8\\\"VRz4v\nX+8b;\n*C0%#VصIf$AsT#8^y0%v\ZcY\0y|/CE-Ž|}wA\02gMKYq-rwkRw|=*y[s!~J^YdΑ\0KP:H367|dxw[B+ٱ	@WԞSԐ/!\';*ΠpI9lvm|\'W:}^0sb5yv+bendstream\nendobj\n38 0 obj\n2465\nendobj\n41 0 obj\n<</Length 42 0 R/Filter /FlateDecode>>\nstream\nx\\IvcURs_c c;i;xA<})J%\"UK%q{z-|]\ZW~_<?+\\}]ȽV=?}IHj-UN+ג\nT3Vݿ<}}|Z-~^S,8KB4\\Z)+jQ\\*:52??_φT5Z1k֤=qEXզ]Xͨ\",M@XTXCeZ7UoF&(fD4ƶkUךk)7ePmU\Zrנ`JӲ-Ą`/WkI=q4UDQj0-jU\ZڜATa\'Dׯ0Օܷt!&UDLc\"ն:BH5\rX\rro53\"t` $<\'$\nZsɈ4UXM^40Tt*akF6i*۩6ޠaנk@j5￙qV;Opt%6u%r-ell!?\0\Z\0nf!@<j6=4}rz~z\r&X\ZeRk)>yv{ꗟ~tUOw5{igXLǊJ(h٭ǷZUvMwI`n@[9j\nD|6+!0\0(L|)DWZ:F	yCv\"ߟS5*weSQ^6=`!	166\Z83-OaLMA\r`Z|$QMA2*L,tV` @ZYdZ,X-ҬVkHwV|54+r,\nQOC\ZvrUpM倮͊J0&+ר:1+*\"@TKX8P]a|NEwρU0Ka@ГtJ.;u\"l 2L^&eSteg]0~!XrhD/\ryy0i*n3\'jYDM#ο\n0)&p|(\'TE0F3DPr(\n(Eݢ!b)!\\32l_9\\E50{.;Svf{!mڷWW(?6}l%\ro|+G%m\n|-3(錟(J@Oց*\0K[\Z{w\nKHctodڢȘQ?gxЏ;i\'̳Mկ`M#tWaE3k>I\rtz.`\\JeY#A_HOFÖ֘/bUh+N\Z}\"tbC\ZZ03,dN^m\\`:\'?h\Z=7	|]oY롳o=KD${	jGa9Ղ;<Οa|CA(ѻQK-fM}PtfڄWnQWr@;:^Գ	kv;t\\D,˳ʱR{kx]𺷀 @9ӱ.akZ\ro-7wMt;`NbLu.yx+8>^4<>l̛\"xƫ΄l+#GW<,eqW&Rg P*󖆻I ʹ]sAqC7 x~[&x}Ζ#\r$υ,1!m&\nR@3O,&i׆[qa+FE<OȆ	/D6{ [	Аm,ѻ6onz&-5F̀wՐ{0KG\ZD.v&0P+]P)wSfBbhjV\"*s1 ƺ;917sER+FL}j+u0d1g/\n,~0xϦz\rOSo@-u]trA\\\nrq3<RXe6IXBAچ!qzp`AnXAQsG&O%OZ.T_\\e.CowG\r~apA>\nTr+?TR\n9#x״pa b2#3XWd	#+5pdp	nl%>(ݦ>v4X{#RAՇ2{[7䪵Edy\\zGU5At3mK}I>v;M.$kHx2dR$h˰ο%͎G8ҋX_\n$lR\nWg>,NENVXb8^,!, 5ܲ $U\\uMC?ѡ a\0$OɥVG,V=IeI袏0\'lA\"-:\"1&TvWLIwQOgr\r\"ĩW\':-s*@K~ϒ^2W+o1g&p.&Da@>w՘WNb8ۈjm\"*\"9l#ՊÓս;39;s@;ьڴ{\0Mi4m|l\0ne|B*>\"שSzĭTIJejI ?zٷ2t<}8I@dH`4Sl=ybQ|gy0֝c1v\\%^\0Օ:7ݶ=`169De:%#8\ncZ&f2tɬ+L0o#:{w={oP62Oyy6g:o&CHxCT6>e@[CTRzGm	\nO/\"Tmgt{=^!6ðQ@f\0e슘3;CLJ^>1{rg&*i≯47y$m{SaGdy.Z81$*֟{fAXN&ǖam{wa}C\ZE4F.xQ 6A[`endstream\nendobj\n42 0 obj\n3025\nendobj\n47 0 obj\n<</Length 48 0 R/Filter /FlateDecode>>\nstream\nx\\[ܶN_}hwۮ\Z$\0}HiQ4v$}$rթYI7|_\ZW~{V?+B*Uk!v0*U+LPXkxMbtͩy8$D*Ak3щ@k.iE/5U#{&g/6M~e((;7uemV5CX4mqVs{b5Iͱ֤Rx\ZnOfΓu-fݓ@p8ێriꚨ \n6v Ψ  Ѷj`g3֜I,mXԜ|P[}\"ƅ0z7i.Q *VkE*jn\ZTa8}َeצ1IoNgY#5\rIT袖ŚޜXHF!5!h/oOL1<B\nA׽\nO Zqͺ&˼W|퓬A8:(,m\'=ASu\r)Pm!U6lkF$cK̷R%	sE8\ZUWAoUZՂN;CmBj=](_pԊ\ZR(SL$R@|Q4?Ed`Pā~\'MP4rh0?39b*QIk*T%fDX\ZDW]_\r3k<*bUH,jU,֠dyTH$4q&:\ZEP$EQ1BgUޭKZ>qI]jhϬulhDUɧW&$tN?X+B0$<<S\nhEӗի1;~fl\rE]o&k$<dc:Ϥ\\+|<}\'Ѵp~9EզI*éӤS\ZvʄZ@M8zd\Z+;n߆BD3([b6IԸӌ W2M:R3вHӼ\0$:hX)i\"gI<\\ixi9y\r\0nlW\0s^TIϠL#6IV(ir9G<xV[j%\rUm7?boxs|tofi\'!~\\BrP	Ğsi%)AIFϟmDh6fny4=iclscG\\&` oL8kFK)	6Q)-V͗+ƴgL=#E^|-:vjݝQ/P$K.a\"+%i5y0	fZ6)#aq$OEk)$?SպRMs;ӱRQmo&\"?#s׵.Id.\Z!5t7JJS\rP_|N#ߨTNqj[	D.AMZ..*^%p72\\$<5ADMC>D~8/W{	`^ǟ/92aQ~ǟB6Oxu0L!	Ftoԏ]\r-NG͜twUƐP\\Yӣ\\ 8;]!n+Xlb&fLL,Q>h\" y=z$7)V\'O@ 6eV;G$98\".G1\"g+Aaf	U{nLkEz[/SX4|Qn^u	>u0*eQf>7.i%RVG ZTޤr(M-oCS(sT7\r[:ggF Kxosա6TYjEbdc6]u[z	=3SuH?Râ\Zբ]UcƸgUn-YwvkxR\\+	r×7J>}|I>P.YOM	$\".K3W@OZI*)Jd!oA\"釔MV.y\'ZZphϸH49>_$Z\n4\r1!=0nI@9٘4ZwO	q<bSWePt_wTٖ%b`Mv#¬.-Ε_\\ΨgZ+gQB/~q]H쎴Ejmdw(Xp/7mͭ?S&6lf!}6!ͻ++h&av{]x>+T;fq&؉?[_3¾,xq}eKa8ebw lt;X\'}k$UK3s\\:.܀D;e=-54)}fT`u#_)__xq*^auL8x\ZAJLQ4% aCJԞd5&cXw/8iTཀ0$vxw1?35wCBh`lx3#e?Q%}\\JJ@)(%dR2PJJ@)(%dR2p[JJp>,gD+xxI\0D)(el\rR6R{l\r^zAWMRfWDvҨIeUJ~?62endstream\nendobj\n48 0 obj\n2901\nendobj\n55 0 obj\n<</Length 56 0 R/Filter /FlateDecode>>\nstream\nx\\K6..h]T`2bxTe­bAX@Qd&$=GC[%}UIMڒ|$|>}T`D\nl~}8?RӁTXFFJl3 ]__OgđbD2yק_MNтJ$9{hgd)e{]Q)EXc #Re`Uٮp%qYW\'8ӔGC벸fJӶAJ^a%^^L;2u4ISQձÊ32ȲoNIB%?~~:rvPT#	mY0y9IS]uj?c!s=;7\'לߟ\naCɭ7*KXw#$#;;s.Lq%)5:j˒i3IvMf\r`o_L\"c\rI`.4ۉEY㺸b3}&v+S2jw#Ĥ!Nִ\nY.+DRjJ2yO~#$億$0+1zJT21Nt)	F[	m۴t U*%Up!?e$r7)\nl\Z\rlc*@`v܈ց6c_.ТC\nxrjG?MAJy>Z)qr#Qf6<)eSHi0؋xTS9y7&L]qQ`dե}y荶#L:.F=bH\0(1ekltU{\"Xx[C2џfJRk/^J/olF\\\"imⰈQ \n^՛ӛ??|㷇?[ϫ/?7_)ަ\'\rF6u\'W8.\'HZ\'V&׿;\0AtwTk-,*=(^{!㿓ZB)ɱJ=;44ZOLg~$GqL\rہ4Y*O$\'nB9k	Z͘vVSH<xȥ&NjHWnUCC\n	>YܩK\r\"i[G8=-B^\"rL*,ǿ(E>z1|43Po|gǐ3i|{)\ZA1{		ܦ?ѷɄ`I0Z?`X1\rǶ)0oڗdU,k~5!XĠ\0ch00:\nkVv1	ze0R^F[u6F\n;!%.|<it93@\n]O^\'wqykV,~#dY!:/YOxvO#)Foi(i/o<d};%\\A9Ŀ ˀ8	w߆dARVFg#;EݾW YQ_ 5!詛8+jǠDqU\Z5-blZn$rk?sVF⃃4e˾Ntzķ<6NKȗėt8U\rJ\ZZ4\Zo5Lgߪ_4ߪH؈;TϋM%e|ޝ\"c$	E%\r K:$* %8af][h#k-FZcvSS!,PPP	LQv\0&zzauל_Ɓazo2~g1[뽴3bC^m>Ai?y<Af}|<>+\Z=1?7a{Y#J<Ȭu^6ZDˬf}B\\Ya7Ľ=*%n3b}Y|@ی]?ObOkͱ/b4m[Zn+akJWLY6Or쳖iz2-@OϮaJni\n-0mGeo4b4A?r$&[nak@ˀfRR5I$l8Cm\rXf!y9~k4Sv0RZCk,{dXofl7\'+	_rqdYaew$/O\n/]0g]̉9~{p]KgL̛9:Cc1qf@IsVcVso۲/B\Zm\'S#uUf`7_YA\0L{dH=3=3=3Hzg{g{g{!xiYK\'tO{4|N%uwA4~\Z>\rsPMh\\*{>3=3f0L{ϴL{ϧ/{*We	U.j8T-.Sn.iUAQendstream\nendobj\n56 0 obj\n2581\nendobj\n59 0 obj\n<</Length 60 0 R/Filter /FlateDecode>>\nstream\nx]ͯOF|&U@\06=$9$iQ4&}EHZ,b=Ip~\n#Ra_YѿvwU/w_QZiTKtW(TӊP8?	pJA F${}s\'y}D+FUopiks^jxQ \\t\'e;d6@$C/5D6=юƶ6HZ){qCU{%c52{}Hw}%7{QNfhIg毦\r5Hҕ@0m#9>;G\'$?=PM9aYIK/85\"j2$nn~ĖF!iGwל\n,Dni#MvC9D6S1WlJIb{sg6lak2q;|38ดc8Du-p#VKxht6ĂN:Zj+eIk832VmRղTҴ\\1)fF\\vۃ kG	uxfI		QP#jzZj`*$kTg7R\n]#%jy&>Ǯaz3v5R)v5+Z)g۵9e4c8Tf[q˰gߧ Ohڜ\Z\"MF˴H%4CGC`-T.\rJZ6J3XgAt5[;;E_ݚ5\Z5ȕNo..eSbfpg.ӢJݡ]ޜRUGД*Q@5)\no{B\"3Pm`5Iʠk.|j//?*{ߋ/>W/vڮIpz0@hBOHf}chWaCǖ,\ri,/PQ_/8os.DEAD;\rȜU$A4ekE3NC\ZCHF_L_:Ha<b]9QN_U(+#B;$S]t,OoLvb@Ѧ˼LIU`ϨLsIyyQ9/i꽤 S\\,wj.`#ŷBaBD\"L\Z\Z,\"\n4G;~8:d6cxCU_aiӰ3YegXRfR5\r^s0}_˯X:mε0vd`YW}T6y7:pvu&L;eq`Ms@Xp)˗݊)˗fp	1(Ob\'q}·|ԪG{{:?Xt\0ϡ6_GEO-	^FSl9TGlٴGO(TK9K0h-QZ(*\'Sl+T>S[(\",Ɉ|o\nSc=4\0f<^]qM腍+V$A.ǩ>\rKfd=O~O@TR!p:S5yg!-#IZ\\u|wL}>Rp/\ZH\'G!AGq`vG#e6xŷygMFo@KA]7KzH;-h9\']Kx๾Z\\څA}swOMWWG[j)msGd,oQ\\<ObzkϋYy>{}\0Ͼ<o|xtQ\0K9vx (ɓ\'\n~}b_g<~>h~sT*du]?Kfd^%~g\"rs;QWe\ZkxkII1ݝ+\0q{%Nqhh\Za&i1`xtT\rWZ_\':(48gL>426Gpee11\0QlH$73%8\\1F\\9P\"(zJۉAMsf!Kh\rHYQV̪_!\Zp2\0NK|<R<	[ws#3d;fH*4,U\'MH{.0n@.UяNDfmz7SkC|2CxM\ZdlUT6$ڑ*]ϵ2ͺe J}oS?+._+rm_+ckCXs6Q27/)z`_Jd* R6M#<iJal5h7IcoR!92\" .DX3Aݽn0?}3	;nsio}#	8\n,EwEz@)ׇ\"H?bf5T,[,|?-e5Mzg9;Q{b9lVmOlm\"lYrgٶMٺԉ\"he圕xb9כ,W7io-o{հuU-\n\Zn͖~wɌ̍WǴ3z9|{Z(|\'^x~O!\r+Y&o)w\r%W8_6ohQ,?jp]ypl>m]?Ni7H\\>VWJqzWR:	&%p^{z=LxIz\r&wB43?WWs\nEyLj^8z&?2	[^ So(zN{	S5VEkjdMX/JiZrnendstream\nendobj\n60 0 obj\n2921\nendobj\n63 0 obj\n<</Length 64 0 R/Filter /FlateDecode>>\nstream\nx]Ivc+qq_c c;y@vΌdl\"R$RMIo/O\"%X>VP3d><ξh?P,{xzLZǿL*eOoߞ\\KLs^P,8۷ysãh\\B0DǷ_TbUZ>*!Rƪ͵CI=va-Qw9+Uy_p5ۢfo{gBrgK6@֙24y5t26}Ьxwy,. ,>v4p5aU4WE+0njʇ\\\n9S\"ԫc;}ӂ3m~XS߸UzlSu!)BL(׶g\n\nZoAL]U$h\'[BkNPAfSAsm7Eh_æ百zR]9LʻBT\nF<,Y`fWB2[cV_z@Bo vLkQ\\/mijOmdJSumCdۦ$\"#2T12t8=l[_,g<Ȱ)ư1W#M73ΰY˶YZIMNF)g+:*7PqfC澏vXJ]#٫^3K굋By-]h&^h+|Z3j2|G>!_\00(!YjZ]U0YC\r}s(:xk&jIBAWڷ~xz}zob|4a8ztzO?_2|zߋ>W/N^\r*80w7lNp&vBZ	o\rε4|.b|cbg/;\0Eh>-rґ@  \Z`	6-=\rF1!ʂxc/ ̸\nsf2lQ2*?%X+6e]OF6Mw|gD޽:+H-65@p	%/)a(?	\'F?AiԆfrws{{;.0u1HR0@P`Rs`ȨTWA.a~:2`MvhlzMMHYR\nٹap\"L}m_&lsC˲滶g3Cr\Zr1o^i=Eojg2	{I>[Ⱥ,}wy[y.?1\\w	CGޝ?bX罣$9o/Iy\'9ƞyw8+4=c9N;Fǫ\'?4Wy\'Q19lZ_$S-*aЪt,h8I;dB^ˣ}yu_D&Vp3Kt}%o+ $WTQ9X˙},Jn$ \r/JncU/\Z1zUE㗧|sCZu1\r!a^IrM|fIoS&#e/VN01ipÚAHTr	3帿#*NUUqcۇQvVCy wIťJQ\\ԸIDb=꯴\'֓C\r2Bɖp%K+]}Յ լgTA8vfV8{GȲj{$nJ=..s9\0{ET\".iyꉁ:rv\r:q;TWI}xd*8\r@fnBI6:\\E͈3JYQo:ZhlU3` ^p䡐vXczl\nl#\"Z֛Jxtдu)[Tط\r6a8(j6\00H,%82 fjeaLW̤Kt!GA.\Z[l{g\"H	{[^BʱJm\0F`{w-(Ѓkov=#hrpQL!yt9hr4G9QÆh(G3;hr4G9D>\nQ(Gszh(rr4+AJuk?gU3 [[ylAz3Ѓ[ bO\nӳ<\'VUjȧB0z%[ϋT:@b@W&YjٴXUS(UCn%MJgDO۳Z5~zt*\\\r FƀDo\'\"\\9o^L#iĜh[	݇G\0[j=8FRk[\\\n֭IFՊ.㤂auḰG`uQל#xSQљĪ<Wp)/gAg5\0S}5UV㼦~vV3NVũ}mVwl-2|Llu3|[k|[ı:oKrS*`]|8w\"lU6enlEL<t6÷-m+[66Dۺ%m{5zh%àۂ4p:|q\Z֣\"|cx|Ҭ鲟[\"~nkK~nb?vKwRĞjϨXQ[ڟ]K[phcvmG\Zl!Wػ||\'L*_u/׌h4OVA)d5>7endstream\nendobj\n64 0 obj\n2855\nendobj\n67 0 obj\n<</Length 68 0 R/Filter /FlateDecode>>\nstream\nx]# 3K%R*I}>]ZUnYJ9v8\'3d[$c>B5>_>د^U_RZAU){)UM*LPXkxM۫oO=~M^F[S\\PBGe^H!諮5R6WEtے)UE9֚GA?Xm]Ko7~}F9LouOM,4]R)wuL ,:P-0̡ׄ\'(DU\nC4ZU05T+4O*NgFgV֜)NgY#5[7鲕{$Zɗ1IǽM)B*iڛie=\nO̺%A`ڟTZs\nj,6B\rr5ٶyC$|3<3oBjXY\"zM|B -l,(0T	Z2U+˨g\0(Q0@Ďu:}o~d\rUShX\'A/mbBSunCdݦ$\")a!9r6\\SB	&,Egf[alc-Y$\'y𳭕w{\"7Q%qfKys0	Djp\"bnTMFFPQͼݥyyf `\rވ6zާz\'ZOI-=:Epb/UHMF7lˡ\n9HIAd&XdhP>^ޚ\'\0Mo+LP𪗯Ϟxk}1|<zŊ0s~	d\\OH7X#FJ;qsSrr<(F\"^|Pl+޹+*\\XUmNz0,+GT:oED%O9TƔ\\MىlSZءLuS[N2@^L=LI6\ZǃX\0w$1\"]|0/l$Ɔll\"rH9{&d02OQ@D1!cZU+EU#DREUb\'Lԧ(\n5r)\0\\W]6pݩj(#ޜ̬0V`P;(oʤoO4BlOc^H>$A*{Ny䲙B磾E*9N+UtQ?+Nj챼Ud\'Ԫ/\'\r*/feIq	Fx\"Rq{\n41J\nƑH+oCoK=\Zn aqDy[J+1S|}7?zJ/P1\0jFߝBgXf<(\' $&p|Ŕzm\"XLQ?\"x\0`@bfEI\'6H0俌$aTA?bEKO>8ʚc	_UoL0c0ЦϡMD`yy#pge.ή\rue:\'V^Nw,t$u*t#|3S\rhMb:\r%br1v+z_~)2|v~\Z_q`/u8+շc)߶Sוp{?u4wo+$ru޵J),l]BsЄY:V;[3pl]/+Ƌ2W7XT7V(T7H@u;ȅ\"nߕI1s\0u	@]\Z-wX˙tC55tD$t!\0=0^kS?\07m\nXqwS7s$	VA*;)H\\t/\0OXkPHska-m%] LI}heKTc_Fbg|t\0oIY\n;xXvI9l~Tg\\0)-{U,SjerEb	0	dGI1ã`9Mj,׍El~/3=KҢRbXj`\0F,s\0̣z\0~tq0\'T=xHi*rC7(7@(~xdL.d^&l;ahvSv\\ǵ\0%\\Q\rFda۰YÐͽ`v8p{R5DŻM!ȝNnm[[mŌ+mFfeٹR\"/W9m6Æ~mkhHF=Bd$dr-tnG5R@nǗAi\0YC@.?3jCk1`؟,\"c4&8Fs?z{qƟ(yܙI= oAIw9nKWީχW||i{I޾٨ojs\rwCV%^ZlG{i;A/ɥ=AIO}kvNTqnEol3\\Ct?lUJ\Z^3N`]Z$A؜e7햶p&Y2,mt	 vfixx$^}>5|RLIrJZ׵޲E:^E*Ylnv*c;Qx[{_1OlBN:^|]?>.w76ΘQ{7@rPTUS=lL56tڌlg^\rKH2rScSBEw[+l\ZXEɔlJܑ弮Cvm$w\Z\\u;]EN->ݮmIzR?~P:}:&:M\Z_>P&GsY3Rmv4w!{4SuHnTW6#fFmkg3\ZVֳt_~Uhendstream\nendobj\n68 0 obj\n2980\nendobj\n71 0 obj\n<</Length 72 0 R/Filter /FlateDecode>>\nstream\nx]K6S,r2FU,&d7E{I\r_=dL%Uw˭Vw?PO}	x}՟9JAo/+)$\'LP7oϗ+|+g}{tT+^^gdA	!)66*!Rƪ+0~0%bx	8R*FaΟ8֚t!G~[WD~?c,4V:):c\\!DH6`Y7:uJ*\\T	L;r庒8IsڛStbV\\TDGE?VWӯ~JK!NWV	j.zwgUVHcM]3Qj/J+AvFC43\"aHHH\0\'\00\n\ZBL[	)aI&fdۉ6Vvƪ%Y=Oyrb4gr.A9W̬v4D_\"JkNaj%s=֍\nhǫ,`/4u%1qBۂq&#e\\\n[{.ᄯ)f!QD8]&DZ+,8$<0gی&+Dn(Uae	b<\0c9\'p0]jMl>V]byhAoEpoxD!v>,bjە.JvvЃAE	`F-pƂ4{Gf°L0aSr\0	IxϨY~Lf\\rThoA#.?@	c!x7\0(	 s0kP H}\\Q얨p!W:խdI3)7DH\'y%c#.	tRvWĒAJwv;XҘKs\"J.,MÝ,e[|6\\;\')IsTCw\n4lV`{|5.\r_if*U;/%\ZbALYWlkD.F2uhV+P=g6M\"&Lmpz6aɱʉ>4H`i^5K=qw\0s	g25̚1`Y%`0>,f\0-	D%eLW,5ssYG\\)i#\r4e0J^\0tY	Q]cod@A;z<KDn%Ptݚ:ppPiF$ms)t͒[a:9ܲ,J@$wfyP\"<%45jPo<(Kj/)dG|X>EmY\0=\\\0[aHj%TZ[##*5ajF*\\^ƣحXbhzG{1j+pnRr$}X\Zx]yUW=DfO졽s^֝ :iY7/w.yf\rQCsZ)(9up	F݅H1T)ʿ\'P{W</Z#s5Dk\0ao:Gt3\nmԄro@.JS!$?`W)$A7^J͞$৻TwzZeAT=]VY\'l/j\r2++E5rI2Q֪ց@J5i +\"PyP~wQI5̼^EE8Y5\r6ISS* gYXQqEOAv,uEf23z;)Ŏ.U*0K06\'bUrt82#Z0U$b2!MWTZHTOsfrmtEvX<LGky~-qJƮV\'6fr6e3T|LV\'ſ/\0$XwCN\\\"ޙ)xgJ;Lab\0%~?KZ%B^0~0q>4.=;tz\ZZ?ȵ_AjU(:\"<]^E}P	k=rc:W|ގxkzȶ+\\Rܿf@ך\"d̠+t=bÃ҇Uh֪f_ruͷ70ԏ}mޏn=\'X#JvwIg$r<~#CDZSk\'\r!PP΋75ofo8Fvx1NGDG|B\n)f#uoxZhQ#f/7CYfy@ތ%̾C^\ZRG`;fg@( cمGM,%qeװ&Ѱ8ѝ2\',Wň=0O0ctWZn&C&d~4?MƍOH[ɸJqeݑbh2B\\O!qddKaF6|MS*/\\:a\Z)VjfPQh$G	\r:V47n*nd	bEä@\r/3Q80b(B:firN5Wg\"fkBw𛢝oEu\ZR&&,.7vlZvӐ~iX\"b9ՊAÒ#`WeHc[\nO2MnvIe20f7YЯH+6dpBp)uuVGJES[4Y[C·$0l&Gf8;b\"^#Pwv|CbLA%ٚ3Q,rs>\"E+p|5Eh!܈vھtcHly⦸Jq(V0#6DeY6k#6תz_%i]XO&k[&@#fi>R:GZ+[l*\"oH>eu?2OX\'ā\'L8[JxmBIP̗aCC}]Ⓟ\rP*dY(ZYi`Y6u jG\'zoMh̳:,? 3B؃/6`k(rf8(}*^0 W)X6z}>;&Jk\0s4_㆘2L(\nStL/\\J`DκQ?1ᢧ2pi5O:}m\"4Pn(&aORBU\nÂ[!;3BpqN\0v:o}O1Ca?d?\"=wa5c!>z6\"Xj8s`4n__bMendstream\nendobj\n72 0 obj\n3499\nendobj\n75 0 obj\n<</Length 76 0 R/Filter /FlateDecode>>\nstream\nx]I8_A.}!=8M7LL7pߓ&/-ɖrWD|n9RJ=pA _Ǘ|C^pTvy?rQ?_̱wJZ&`o;.Wvł+opi:4Sa\\^?~nPlR{T7]k)uѢ{4+xy$*\\W&ZX>p;Ãv޵e͵oGEZ rJ1\0Ьi~Ѽ\0GW@P!0vКWj%s=V.M?ཻׯt\nO>C=W;ׅ$^AKT_Zahy6Q)Պ5!\np4-ʓޛ\"$~e4ԅB!\r%Nݍ)gԥQN#6sAM\rzk]hӓ+q!ưҢsc\r/m cW3d\rǠƶ;Zkޭ|\nLd!dOo2j	!+xB+7!gbQΙaD\'ch\r+Y>\"N1p\\}0J_iIxmF,LC.QDzh\rEhۯ1\rN|i\Zc{lQ04=1fa3o,U\\^0U/4Ko15dp\nɼ䡃IHJZvVp\n|YvLe6Ye63=`\\ 8L\\gDh4_^-;~^+B\\70L,%\'C(!vLVIvZ;4	I̫il}Qu?jϦ`腰*ߚrDj1dPU}dr]\r\'PnA.AgvOG3=̘;rqjh IDtXg0H/晜fk,\'(RrC&XdțBjs5d\r*1uIsNpN{-7F(jŝg\Z9!\nM#Z DL;[f ύ\\xFL%m)tit]-tF]Ѕ]}d.]x	t4tEUs|ԕny0èi\":X[GLE^s?qEǥr𫊾P@3}e7	a5S-W\Z@k6نX-٣-^ v/7{*aY\'6Fha#D=U8,ֽCV)p(_d3\0{	(.L92{}2zHCQЄ!\rkB}g	nloUak7mnuԉMfD1i/*#.\0Qo?aJi3~Y8gE\'Yg;tPU3_:\"dP|R\"9ygFiG]1\n:mvd198_\'Q\nRͤ@ԡ_ls=W|DPJP_S8#QPvH*w5egB_M$\0vp	gy:(7!u	 Q\n\r\0D\\k&Gp|/ofQB\rR(O\'{f֝i4I\nveDB)`7g]H|d{s=VvsuO[$AX]ζ,tpL8XVK\\b%\rtyl\\xP3U%AxeFU8T;2XP0w\0Cg>JElnX98_qEo;&5Mzd	n%Zv\"@3i%xݙi_}bzӗ*V)ֆhί\r׭DJ}ʱgHYQIx[`48*ߑP愕,tJvag.ݑYDI9v}G#E/,v/IBrs4@CD.(pdFGPPQ8\'WԵ)Ϭ^6amS}=xUVҖ2:تm~e-Mب(N܌9d3:1]E%u^4h4|v\ZN[(Um]{7 QwvS-(xQuY[Ԕm$%26YI!=\0e*;$[l:&C*:$$\\aWao	Â֡Ǖ_{/V{,uK1ˈb\Z}tTphHQpP-Tp\\\nN[Όi;sL1KxFhN0&:xR<vY8ܰv\'J:3ٔya\'ɧ0S)7ӵޓ&:E5V!.ɍ$$pD6H\r7:]Plgճ*UDRs>ņlUrGRQΛt@aVmN{ضRA+7TpUo؛.|Leu1NY?\Z`bq%@4R`aS/ΜJ%]uVZBh%ç-t$\Z\\j\'650Q5PT\0Vg\nnM+\nlza\ni\ne3浰}Rx,OV*áVa%5>K[4/wecR6$Uj<*쵏*U0e*!~RTńGߡCBh6pE<;R>Ml)6aչ`^ӹ8dB<4#(1B~ļ<\0r;T񢻧tgęIeVtDh\\8f\\KC#!	1B&uV;^8.Ysݢ;Z8jw& d%%+1JKLqDrw1JwF>l8]F}jX<5,V9WlXwz-DZbY)^nS)K>͊øUT׫H,D	dիH2\Z<*tUcSufZg\0Bĝ?~xJe=^е@\"˻nG6	fuF݊])\rѕKW,>L)06}aNXD\"WWҰX3^âu\ZsWEJ\'ְ<EPM*<\'>	_\ZO䋈ry\'5,V~|\Z#?ţaIZWb\\=,a|V\Zx\r|F]C<QEؒC\Zûl\'W7:\Z{~EܚI{JM\nt+VSq8at+:NH))j,4Z=]Q@=t\'D(7C\"z	pQ\nSkh/pW_ڟ3K޼i\'{fۈ\nj`	R\".B46zYdq~\'&>endstream\nendobj\n76 0 obj\n3604\nendobj\n79 0 obj\n<</Length 80 0 R/Filter /FlateDecode>>\nstream\nx]I89?cUe/Dp\'0x7C\r,\\ɋ,KrUWtG-R*/	U̿Ǘ>}b/3!\'Ui!:Ŕb\'LP_ߜ/W\\)8+g}sh:y4Sa^?~a\nJ(ĎwO+͵[HWfKo.bTz28֚teQw^Ózѳeݳ>XBIu\Zr&Q3D&1Ь:\n4梹wT	L;\\%Z`\\ª A9jo:#PY۾\\$a\ni.Q \n[i¦mR\'R!4B\n8Aq+ktMMeb?\\B\Zk꒥j*RNQNBNݰH+ҫ0s_-&u]MםÞ\ZE!vt/X5_A*AƮV;|<߈]ol,ӰlxQ\rXEjy:-j*3FB&ò\"߀Błբ3J\"j@e3J%NqF.bxEV_>uހOGZp\"iohrdpu\Z3f+8mP46VM^C&Cwn	blv%X`vDqmw)Yn,a=~ƈ!g/:ia+^.`ɺiҎ3;\n6M]uJM5NWEFCAr&]u@=Zǁp\n|t̙qϵ?,13ـ!I[4\ZXXZX\Z:\rs˧&b-PĪ0k7gs\"<	`qM]/NDvcp6VՎ̌=TaP0\'\"D|h172_Ef;$E=6_\'Pna\\\Z^6u7=\rf%˦BO\"$Ov^Ӧlɩ\Zˊկ\"m\Z=x;M!EdhXd@RULqeq$@\0~s5]hGy?V	X+4w D7ǀ-#ϝ\0W)yFĊζBG\0]FJ*toezV@.ƞɀ.ڃ5z<K1@Ā?u;EG6cuu^+P7ȫQMkÐWrZѝїqgk5joWЗ;/g}}\0rmX#>8csY> zĒփM]Tͤ\0f=W\"kM	8,B{il|ݴ0\":\'2*	:~qJ{Sf	%dp6`Qi2cl\"fl\rQA,C&5	!V\nw:9if	KJG:\\LVwꠚj.;~1\ntD(?>a)+=e;gfi~FNId	^>=118_uKaFa韸&-A/.~1즗&2f\rk\'C).6D-/TD}ȈJA7kMwm{0D^b`AaPu=kr3R@$JS!?^@k)ߛgre_2d\Z1ۄ;{^d+aufMnjļ*K2/#3/F$EZ<ɱsxS{AgbWօzW뵋f]<2uVօ\0\"X­ݹyZ(օmg@g<M}n<$\'`%Az\r	97P`&VxFJ-T\"1pi3@\"q324D$NQ`ZEx$̍%[9Tf3jͅ;e	Mj!n\'sC ϯE{gQxЯly@yȱqq$DR]\\+#1ZFeة3ĮF\n4[V#>gyB@o,oEڋsWcBʂe,]n<LQ,<9w+BQL3JF[tJ+fSϗNme	]	{`CdҔ\rIyTD̆.oo\'I&: 솤\'gK8nCSm\0i}VTaK\Zcb-R@ܚwIt!Dp{\r؋l{Eg(t~ַ¥\'Cg:e{o#ILrTKsځ9&\\~f\\Na&,v\ryHqywt^|Mt=Q%(<Ck}UЩwߔ<eLiiz\r@Q\r?:-kaE%GM	rJv9\"thShnGnJpW1#Q/\r@KR=GN$ӚQ>\01IoS>TPaDl8 h\Zʠ2\rmL[cwV :gt):ah(i\r2upi5_p@~l<M!k~é\"JX+x5mL`7\nێ4|MZ}sY,0`ӟ,p|&i7-!ߢ{䷰>*ݣqnoqW1r\\lՍq^h#ys\\l~>\Zo::F0.)0c~U0\rc\'&=o_ 0_roPuDqp	3	:[XP+H;0L;>i\'\"^<rϏ>OmJf	q,\"t\Z)vr9ƷA	Լ5B\n@5!OB}d;=<4wMB-/&v\n=I(Vԓ@l>4¸-QO>o%HLEYͺzd≇Z	\0t?xJO=@Bݎ]@WxsG$xxЕ)\'N%9O9cFHv7ڿ0\\!UOs2BeDH}OH;PB5NH1xRD\0e p\ngk-!T!S\"!EfDH1EHqScR<WR죝ۿe	)YOXBڋbOHQN)7{2\"nCHÜ`by@B¤dAI\\_vޖ,qy\r@	ʓ8`o?XR7],DB1BXoDB1P7pF5mk-aBG1\"IFAaЇfJD?\\B.Q/|o8\rMC\0[{\\0SH˻whDL,AQjơ>t;Q}XkbU9Ҹqh}?<(endstream\nendobj\n80 0 obj\n3555\nendobj\n83 0 obj\n<</Length 84 0 R/Filter /FlateDecode>>\nstream\nx]I89?cU0e/Dp`&0x7C\r,\\ɋ,K(?[TKe*	/\'|?/N_τTS\nWҊ0Ac׏/=s\\q?(Tqͥ?LU!rz\0O),(;;.h1>4R6o!]bXU.QEɤXkҕE}Gy\rOFϖwc)\n!$iʙPFŔB2+ҼG GO@]P%0JE5/$KjV.wWx%)m\"u%	/PHsQJ+6m:\nQXTX5a[a^;ozo*rXS,UVV	rr2:u-e%EZq\r]ؕ^C7j1cp5h*(\nTC^1*zK_Cכkݿ&T0]/v,x\Z X6gR<A\\DUӉ0-Z?a?[WC\Z\"@b@\0TID@}!4L;[`48:HB8\'^IA&ਫ;8Lǯd\n<Ԛ=P%ٕAZX[|ʼf	r)3wL1\"FL;Pcr87V3$Cpu{Zm>)\Z^Q0\"\"TW#,XvvgU)]ǁX0)PG1\\[R@P6\"ѯ{V\0SDEDU!Ӏ8GƗV|Xf#y\Zސ95@qT8Cu{馮&c\\~t}Iej	fUX;QքKbf>C:zblLLwy\r%N`kcy[W^!a<Ʌ\'ewC;fuP,erƲbH[n-F7E)S<Y$9F2SxOx%ye_n½ךf2cGy?}x	Vh>\rBDϾ921*%ψ(tVh.%nto-ZspklE{k|˗t5@an(dhL܃^WYßɓ\nͩպQMk<Ym#|$Ď}s$sIW}ހvugwek%}1ѓP.&{kzgT9bwJ,ˍl\"<NXEݝ4D{+kM	~XH{.\\IiaD`NϨPߒ2c0& \"MUcqnho՞a>eh͹1oRUBݲ`MK\'ꦉ-@T\',)e=窻lu沁\Z/uΥr=*L4qeǇ\Z,ee]9Lveg<)>,A鵍gѓUfb3 Z/Fts=WGYPť]l9Pz}`$*RI #*L0*?. a?9 zhf6?HB.\0\ZAS7^m~f/e\n75wWHJ2$;܄=AB,I`7G&\\Hxd?zc=vAd=Įd[¯[kM0xda[BxHŒ-DGV0laT=3hafDE{rh<Cwz3̖D0+Y%xʒ\0W1Rc\\ީ@`Fi?0A`5o@_PI575\\\" {6\\pJWD>Lrl	-_&|!\n4v\"S,:EYoL]`X6y03;B)RMv*6W<q!<3H@Y]@{Ppx*^	h{hЂEk-v):jv\'mER)r[@)pF){@\r6s<+E`/ԡ){X@]\\f3nJ\"`=,CҺVf,DdYaƳ0!	yŔm}֔wO\rN/䁀ǥ+%͈dewXyK1~b:օ̶a}Z|2.t 1.({O:0S^n`;[&>issIlIsAp\n3ak ϻg!,\\Ǵ{Eؔȴ0EZbZaWeC1)2-92ٺ:-GbX|rQQSaR.v]΂°0] [bX(2,<TXv`kYcޅkl{E{0Pl|(wL*fT\Zff]IGÍ\0HL8n(4	0maޙ[	tBW`2ߚSvu|qE=E%MTEKcTfei\nAXNEU\n_i(l;\ZWHg\nnk]O#@>aOv	Klr\r6#Z{𤖰ϾWjoPqOѯKlՍ-<I/?N/1DtK<\Z\0\Z@1];ZTͻL1Hq({4 nx0`eɠ:^MN	DomJ|MV|+;dO$Bb9⧸sWfttcN0=^0tJô\Zട0(\'W	{u4O\'SĽ%νCClKؓbdvJo\"-/nY!ڍGzEY!s9}s\'#nnkQ?A(xO߷gޟӵ\"{;K8]_tNWҦdh〈{֥zyma(LL9\"z\Z}3Et`Gl!sbvw\n{|)b<wمDSSdx$eG;2ElCOXBڋ)bQN)wz2\"nCiH9 SDa F`.;Ho\\h&%b I䬷$,.YKKbƕaq7bpFMmٖɠclXVU t0ÀTr3%@.JS!87A?~-&)$]	]?;J4\"k&(@	Fr~5j*yƍA˟Pendstream\nendobj\n84 0 obj\n3544\nendobj\n87 0 obj\n<</Length 88 0 R/Filter /FlateDecode>>\nstream\nx]I89?*2\"80\\\0p	f.{RE%Yr*#ϖm)RJ}@%.RYѿ_~x)V|RRAUSWҒ.__7\\*8/K}}h:z4S%ai0%Tb;էRs-e֮)-Yɫ.++ULJ&mYԵz|ĝllY*y1\"-BRVN2h䯦4Q/*JR@<a.~wED֜^T,YXdV:g]M8[bAxҶ/7KI|uBK<Zai(UAJDbFSaUA+nyk齩,BLˇMHcM]TM[Y)B)Phթi5ta[zU|p\nXVQk篹UGSu簧FQȨ-u\"Q1_Zrތe]#4azlcfM\ZA?[,\ZdAYQ<éڢ\nÌp9ߺ\n\0\0\nu3\0EJ\"r\0]~AI4Iu@J)J\n\"P4G]a<|F W쁲/AM$Xe\nNw@׌ڀ\0VT%yOW{\",(\"V:+@=\0!VjWW_hIavj\"8tZEIL`vniΤe\ntwJP6#pm.ke8Aـ}-beozZ`g+JHH3\0xâV`\Z{[<L1.NtptSWYa.&Z!6TՌ*X{(}\"?!ѱ%CuXP Hf\'kv\ZJE NPFoT.4}ø9Sǐ1\'OO\"$Ovz/dX2TAeɪW˵l<,\\dߘ39ZcHj^Iwvs_ktʌ΋\Zq5Q7GZQ#[che֐C乓ÕK!.9ntUo=JspkhE;kxMKt5ѝ@`($L|3ֽ?\'婛cϫqy^F,y^k;ezggݯB%nJ\Z3cn\'TMv.Ψiw\n=H*i\n;aiz8a{+M~XH;/Tna@KJ(P2I%0&Evۀs3=3,s97tn2KJy\rnO`u7[ޏXRJ>z/+Uw	\rT]y_wz2Th`t5X``߻\'Ozfk<M)K=kgBDHL>VSAk3g_%,qBN/A7wMse{D5hXXUpF͕H/1T*w\rdgQ/6gq	M$e vW۳F;(7!u	D4wy&GPj[3{/SHvoo뢾?OήFZ7j$)ifWG^\n]2\'ߜ]7\")荎ob#hn12+lՋeʬ^`f#6Y}ʬˁĺ1zY]޵ӊ1+쏝%̺8&}Oa]3\ZVXM\n@4Ua\nə\nf˿qV_Aղ*Pe5Q!BlfTR/F$\n2*l[c~4\\gTH1+aTb /άY3wF̨\\0mH0[0޻|b%UʰW=C=F$yt{bt.4M:ۊŰ+dS}RfRwvNam7U{- HP.\\Llx9LZ\Z\'\naYӦ%6,4i!#?ӂdZxLQvXn1gβ\'ˇdX\n?G(Z6a),½)\ndWHKiKɶxX̗Bٵ\nm.xdThAeTP62*tbFFRvMlSIzlHsAp\n3b\'CR/·cRH=YldREr`NCpS*eRsdrKs\0\"VB0gkj6/AE9GM|J9u>\"	xhShnA!ʠP1#\Z\rְ(Ǽb%%y3Ʊ)[0	Pl\n=/wLJV@We42ĄX2L͈\0᝹@\']tsC@qI%ETEeKcT݂Wfei\nAXJbuƯմv6}3(Ls?\\]K{9wM=RW8#,[nƱfqlUue\":{𤎰>*uVwJQ(w#Ɩ/ GHg\"\'~vo\0D,]HO\n0=XQH<,\ZI#W)6HDIh$ù3Ue/DA7Sb~$ROJfؽ:3NO%CHlbI#8DL\"`􎦷@!v%aCY#\">\"O]G:3u}~6;U<G@#aږFbL8]MtFNW*ԦhL9{jymD))%:K)}SJtbJ\0Gl&bvEYa>K)=?#x]xHQJLT:?&s%)->ڹXRb|^pJ|J9w!#>!G.RJd>f벃4yv$zM1zOe(\Zd\Z|\'\Zz}`$Jl-Uw÷Xe,ِ\"Q\n9Ǜy&GPj[3{/SHh,DHUV=ʆ\n\\t3G}X)+	9Ҹe}3?+endstream\nendobj\n88 0 obj\n3384\nendobj\n91 0 obj\n<</Length 92 0 R/Filter /FlateDecode>>\nstream\nx]K6,H;z?b!\"`ÿ/nٖdI횩nږN\'d|?/?j޽|\r!\'Ui!:Ŵ+iNǗ?=_RpW*β?tri*9~4PRgg4wUWk)wmk1l*^DM__XŨ\"ueRq5ڢG􃍮-+E5q?RBH)o2zL1ɟLk,4:NoyݚW\nsT	L;\\%Z`\\UAf񅖟\\08NŇ#gr庒hD(og:\nQX>*0iͭ0?zo:rXS,U\n!d*tM[ʈK\Zk*>8n,Ť޽z{紧FQȤ\"Q1_Zre]<B%ucj$O;bufRJpz9gFt\"j*3GBՐP裘P-:\0U=\0vuM=tw\nD!H r\nE#p5-~6ʶ	b曄A\0f$,*1iA5zww=Cs~)KEYgg`{ J-jn>窚LByWuDA7J.bC1_ƠSΙt=@n0\'z)ţ/|7I52gm@gѕ_KX\r\\F\rܰmqnYK$,0zgkE=H=\nS4\'y~s38AB[>ttS׿\\DM\"q\'CH39m>\'<T~P0g(EXcB2eK(4o, ݓw	44@KýSt&a\\:9y}A澐<\rٰdɩˊշ\"m_/{aa})n61dάduN:n>jI@t{Y>֚.c2cGZ#b\r14$2!,pg@9BA]eT ] 2|ϠVrAt-	ht\n]bMtna $\nSH_+Oɖ<us\ZyaT~WKךccGG_ƜMkpv6j/߬D_.!<}4ü:4\0Jel5Ψ@=D*i\nŃiza7Wd$\"\0_u,)#x.@~/MY!9]M0-(Y<Kp3F{ܞQ*pIтRG7%ULn^ۋu-@G,)%=j$lw漁\Z/u	rf#*L6	e\Z,eej:&O}fgԍy=#S@,Id\nvmvfŅ\n|0bf$$JXDs/A7*#\Z:C\ZVvW/`D@&PTA_S^BHE$.\nЗp|Mt9Ua)A:%}(4M/ .n\\QRP_\rT7Ʈ	AX\n_T@ܚ6Pa9ؐ9z?h>\ZIОtcwnHȊ$D\ZuM\\96=]%4AM7M3zQKٜVGMlW-5zp|%2wfXVb^,VZJ.鷃VZ	ߌ\\|TNXbV0V<vzf3b鱽xfD{)%Rh8\rSJ,L$gm)%|h+-ARJPe5N\"BlR/:h:\0x$\\T:.ji:.T1$tej}J`rd:	ʺޣnxoq*E9!$dTu=2i{btԮZ4M-ߊPKdSʾfRhv%mr7U$0b6<6:N-JPLltu	S\ZI3fntzLY5h;M!X(CKD#suٔmZ|~Oj\rARK%̀JyHFXi=M!d~Db۰.v>$:$t+N)/7rT-b}?Vn\Z 85.CvHDxg\"i$#+wAh$nP4iֺ뽨wo*4aLni.@Qˍo##\\s䠏ȧ[y GL6#ssޤ[Bx6׻dyӥQIX1	PT~(s3FoKy;h,} t0ĀԄr@.JS!~4TAhm1SHͻ;aDvfLM`kͽ\'^6&}\"<_t,EϯS,lՍ-HNX\\I?N1urO<\Zmi\0-f!F.{,\'BfahXYPZȫԋj!SS5Uĺ`ʻ-ernq8|O΄\'gJ_Bs%`~hmkR̒}?y<	It޲8*v!݂#l!qyr#faN֑kܵpw~^^sAv<	oX*ty|6euD]1IʶTKimd1&񋼶%dz%q\"΄Wy΄ހr&E_	+3! nQvr&pwry\"9G?s	7(΄Guə\\IJ˙PF;r&lCXB*ř0X\nLȧ{V*\"ÙB 9 gBf,/no:*;ISۧ\0[×0gn({RM,E$$c\rа0\";$k\'<#愚\Z:@lH\Z	j	_|#@	FhQ_?Jp5{Iiز߽rendstream\nendobj\n92 0 obj\n3343\nendobj\n95 0 obj\n<</Length 96 0 R/Filter /FlateDecode>>\nstream\nx]K6,x]T`Rld\0E	#%ٖmIn߮vm;>T\ZV@|`հ^`tU^_JԒ1,׿coqM*@MHϗo/E/Jkf0l}{xrj\"jD\0^?B0´:.^c|%WA}뺣}4is$hD\\gF5RXv:vѹy->n؊\0pQrfmML16GӚ>Rv\0RWP30ډ%n\Z*UߝTv];WoC\0ۗ5G_$;V[KUZTX\n{Sꡱ7ƼNn,\0ˇ@B]ݽ	\0ӔGwk*UGo8oŤޭܦ1{cIc{L:}F؏i˹2wMWj;4\"t]EP\'+9G+{YsaDcO\'P,xP\0p|w\rm(@T-\0d=\n\0t;6yx&Gg͝)\0RW!G8Klr	4v dMB\0f$,ʡ\Z\\xݼO]4.%H Ca{ rPƨD\'ʏZT9lUoyc*2ѸՍ:XnơeۏvQ]M&Ǎ㌍?\0r5rLwK\ZtRIj3؀\\|+c:oR9[`R\n\0I\rZ#;t̬X$!q!l\ZSj6\'Ŗ=WA99}ƸKM-\ZsvĝZBmt9Ds89\"m#$BpU-I07\"p)\0py7;<5wߚ>衹D)d,S\'FMZ+Ydrż;X]&Ӈ^Lq%9ӓi<2jvPtLg)	p>)w5fy5N[}rpԠ\\k9UwD 3ˠ!dKOسeπ<rJ.pK@NJt^\'jYH82i҅5v*\rb[;@\nS#\nI,?_m֕7\'boNWGڻc^YK#֘\'f_:MW.ү}!f}2ڨMV}1љ(UhŚnQkH:\"N%{уLeT(Nf a3{+`!4Ul00%%3I:~q\rJfT=%h\nC,hőI1kr3#=$pI\\F=ĬRn\0e{#@PGL)%z1&]yu\06s9@Ye\"Lg[*37`	c̀;<Օ}04S@Yd	\nxMv̪Õ\n|X1^@3gV\0QsG͢z\nmFúP]9 \nܶ;D5i\0W7pEF?\\Q\n}\\1Q5T!w@{S:\"]J.?ݰF˿#[I0OM[wuPn0)W\r(im23.[*[^oP24~u1?h\ZYtUFuB)D\\[d}ɍBmNMjƸ5\"j?!3S#\Z)X*:e8[\'^W\"sh,q^E!źKՇn]>uJxCf,z#p҇Gj }鑚]Ϭ˘cK:iCBh\r׆H3ֆXyo7\r@ȚT6\0UP#u!:n]\0,҅H9M\0.5Ph.><х/m/T(g[{ȭJ.\ZB&JJsViDI3fi٠i*6<-F \"-XPB8}(FZJ HP9_L\nlx,W:M^\Z\\)M\nYW%B4R,\"cO,,WzEYdXZoY(3CDD%#s ٜmQ ު|O\"@f@2^${,a4㥐I!|0DذP.>v>E!zE!齝֙N,\nᴗ9*dR1=TA[cU̚ï.˞TA1fߜ\'!*F0)aGZa <ZCUz8#Fdr[s\0\"fB0gum6/Iy颜OM|N w\n\"thWjnI\"+*P9#	3M ʉd[)aE [4NIOx\\sX[o|^a$V`D,e+S\0OXM0#|%	V.993\nD\0RH0rh6\r3jzAH C\'0{<E̹*3\"B)J~[(aoycqtePuʧPB\Z<P=l\Z;XM;--\nHb	a({6OF`\'`Jj`B^-^	)ODx	M?Lxj&-%,!;VB	IW٢dS\'ᩓpJ%;oA#!-l\"Kɺ%8pUkc6l\'ĵάpzuw&&k){H:	+I*B<^!tQ\'+f:iWZ4q)m¢L2o.-i9~k^B\'LHɾk&W3a}k&Xg:fB\0[I7z;^%g4|$y\'\"5%̈́J3QLx$L(_d4!PGL!L&59Օh&8BNY7K[<)ΫS@ӭK[C;Jy9}elyQ:	T<,LN:	{m$F`H#U2_\Z]A\"AP\"o1X@+$6ƨ\'鵤_X%a~Gvӕendstream\nendobj\n96 0 obj\n3316\nendobj\n99 0 obj\n<</Length 100 0 R/Filter /FlateDecode>>\nstream\nx]K6,x]-QłI!,B;E23$ϑ_C%YR}f;:SJ\\ KW?^~zV{}B\nY*!,^[ђ˟/^7\\J/Ko}{pj:95%alJ(6i-{h1n>MjBֵGѬ9WV2*	+EcQ-nOFJIq;V%B.gFݦOh,\Z#^·>sWT\nLި(%Jn͊z_mXN՛#p³{z㪬pjODK%14Xߛ(eAJDdG(lfp1sGucb|ު)͖WV\nr(t=itaw0<1|c-&mtnM7[{L\Z!]o3*~K_MەqU{ĻP\n0]jc!?O+bn찲<jA\\DYӊ0=^(?3\"\\?ﮆ-\0E$>B*9yFP7 (謹S %@\nxU	RQ!i\0ں`y|M.A&CɁ_}c1|Phat]koXYP0j*<un^0D-KYA)Dl6F{\0{BlBQ\"sQ3JE\Z1UKM*;a8lRu&ǎ㌍;@r5LwK\Zx:bN,둫Yoel6BpMjgLjsRXi3kc80DVa5rT쉝CC L2mNt6p	\\ߋEc.سT!6v>\'i<nynS0+\'\"Ix/U/JP8 x(2\0;3S}wKO6LBƒ=!>	pɞt^ihꖣW5ߡpIa8z+Vzu,2͆LONyNkh0r,#R0|wS%f~5L5t[O\Z\\9k-ȷv`60>DR#fK>.f.$]#]8	\ZG&MhO6R!]bt ]s!]q~D!EG+ͺHL6r)jiTsn̫%kc\Z\ZK	\n\\a_`_U]Bx}m&s_wmt)ڪbM`X<\"~\'Œ&VCN*d\'a3k:E=ÚDS\00iM\Z^5wQ$~8%E%@Ϥs53Zq$l$fvEn$\\GlFMbbV)x7m\0U?=˘s.4:ije\"Bg*ӟ5`Ic̀97i+`$gi]f%(yxm#yVT@b=U=@p^>of-гUl3<<̯bG^+L1)Y\0鿺l>+!%P)p\0}	Ǘ\\ؔAc>*LW\nA۾?%	@d#%!\\\\wJF|\"快+P$A%	\r\\7C\Z_e)\\6!72BVe^cv=m5\n\\1GsJHݭ;nƱhq`&5uc\Z}rM#̦Ԉ06?Fk\nV%`{\nNn5΃m/ˑ{h8/DĬ{b%Cl[bpJxCf,̇G%=ϥ.F;ն^!5I1Ou=Ն(\rD!f\r Yko\\F5!\Zm7\0,:BuݺXs0\ZE^;]!.Dj~]}x1_^Q*N/,\n^2w[r)]jj (U#wYMjMF5sOSi!ɜn>/Z%*Šޮ@sF!wJ*w9\nxHr!˕D)J]U_0-J\"<8\"rXěI6թv?cL7[>HDPB91\nR+\"AP \"<*_*kz/E4I3^Y#	CD\rcSNB)\n18ӉE!#XřlS>@1UtX4&A\Z3`k`C_n·R#_l\nGZa <ZCUuz8#GdR[s\0f|0eum6-IbE)\"ryArDѮܒDWlUrGfNt Z\nAϢz9\\<g0A#F?\nFbbO0%ev݇m:X!((:PGTTTK?jAF.>93+c&QeSH0o6ٍ깳Ttv>&{<E̹*3\"L)r~[(aoycqtPO8yv{4lshwb	0\ZwZY,!>Plb	{O,%@N[0ObJ	~vS3ᩙpZ	9tZ\'a_Z%%:	OC$T/y\Z	an~vίXJ.\'Gj\\<T3t\'ufms52AH]wH5Gv$<IXyOR\n٘:	\']!IʶԢKi#mgٔ|siO=qc^{X8fBL_3	[]3apk&xZ$p\n	3]rF3\r1QJv)P3!2YLa4u~L̈́LR\\̈́<޹MF3a{|R.̈́DfB:\\\\RqqX	5f9i8Q:i}2h5z	{)D^Jߴ2YA^NB4@½Nt:S0RN~Ъ/A/ (7͘|68*pAFSc7TVM,!ӟendstream\nendobj\n100 0 obj\n3317\nendobj\n103 0 obj\n<</Length 104 0 R/Filter /FlateDecode>>\nstream\nx]K6,x]T`Rld\0E	#%ٖmIn߮vm;>T\ZV@|`հ^`tU^_JԒ1,׿coqM*@MHϗo/E/Jkfַ^N\'&F:/#LM̡c5ǸZRy{Է;G6G__IM@ufTS(%]O;8iKڟvk\0\0.gF&Oh$#*Zois4#eG\0 e~{5˻\rZJ/_X2ȉ붠Y5>9Kh%λp:ٽ}yQYsD:HRa念P5XEj G0Q@\Zpc[t͏@8|x\r$eK+\0@8M9yzw[LˊRuazSƺ[L:m:\Z3jw>X;\n4Gg+CxĻnf@0c!?O+B[un챒sZ9F4t\"b\n!\0 *w@@UJ\0@׼m#w hpt)\"`J Ux{p	j<&@K@kJlBf$Xy\n-NkF`@m\0+qZyPͅU=KRzPb{=B,LnUoZYMtRuOsQ7\".[ݘ&onPhw%(drܨ83\r)W#,t|QO\'+\Z63\rլɷ26&5&5\0Ԁ7RC̚E\Z\"Oi+\Z¦1fo#{BPl{(nSYHxg{[)ߔ٢1WiIYu v}NgH4\n<WɈ!&<BR^k(\rXj btKwIy(2\n\0{3SswKO.LBƒ=U|bAᾐ=\rj$ۤE&[Z%o2}xXձ7[23=9S:-Sf7EtB*r7Y!nZTa,jE\'\nG\rjSuG[;0\ZBp=\\#G8mGtjH{ʑ.t#&]x ]hҐ.es98u?Ģ#f]y\"&[yyyu4[?Ց1bym\rL|haل}p.k\"jo6o:O/d7siJR6>Pa#b[=*iHXI$lfM6\'\"yXha&IS\nSR2<\'ذdVH3]r0͂V	m?4&7=CR!	:e$lC*e\Z\r\0[^*Q;~ĔRg~snE\'Yg;\rPm3_ZvH-2t62}06X[S]#1O=<u	ĚEdGʬ:\\ɇŪ{\Z34#{&)X*a1g?|,Z0fD=xXXŎ^\0R0qmCTf)\0uzsWjđOZUQxU՘z/PC\"pJ	T۾?EX.ۅ\rk(;ﺕ3yԴWW\\P_rž0MV6Z(:sXҸ>\"5v?\\]\0*CW]\ZnOW`DQl-dўIĵM֗(n\\Ԥi[#$4\"lNc3kD`Y\\vYlh{)^ݣEDy!\"Շ.Wbu)ܫᛱ뙏J)zK]>Dpm!cGjv\r<.c)/	{F\rI7\\\"kC0t[bAr־߸6/-J kFP5o\0TIr@ԅu!K\"`4.D\0+C@]Gb<PiTΟ^Y¿>ne Q#3*Rj\Z ()U#wY˦5r&-Z#wL[elN\\cR@bP\nkoW 9;k*]η A|15+\\p6uxir4Q*D(\"dR_՗8LlEH\0}<\\)f\"fcujad!3\\(ϖ)Pp̭\nDdsE{=\"vHʗ˚xLﱄ!ҌBV&HcBAvBXg:(^n x-dJǴS}nIUA3kn1#&,{R=ĜÚ5s>Dꇨ\ZdSkkWiIbHhmW]wDmU\09\n\0յۼ&}r>59D 9*$\"	]%غC܏$̜7V@(\'^Dsl<o8A#&?\nFrO `5&n݇umzX!	NT>a):(7T?.BbƗ$~Ԃ[*K!\\o\'ˡd7819\"	&%0{<E̹*3\"B)J~[(aoycqtePuʧPB\Z<P=l\Z;XM;--\nHb	a({6OF`\'`Jj`B^-^	)ODx	M?Lxj&-%,!;VB	IW٢dS\'ᩓpJ%;oA#!-l\"Kɺ%8pUkc6l\'ĵάpzuw&&k){H:	+I*B<^!tQ\'+f:iWZ4q)m¢L2o.-i9~k^B\'LHɾk&W3a}k&Xg:fB\0[I7z;^%g4|$y\'\"5%̈́J3QLx$L(_d4!PGL!L&59Օh&8BNY7K[<)ΫS@ӭK[C;Jy9}elyQ:	T<,LN:	{m$F`H#U2_\Z]A\"AP\"o1X@+$6ƨ\'鵤$lc^_өendstream\nendobj\n104 0 obj\n3315\nendobj\n107 0 obj\n<</Length 108 0 R/Filter /FlateDecode>>\nstream\nx]K6,x]T`Rld\0E	#%?$[%۷kn[>:?U?4+X}5l}\0aջח/Ad/؛r\\\n\"PR~|kv\ZCE[^{:5\Zl3071kLqu*o]w4Mj	c}%5ۙQM?w=ߢdrn^,iO1\"\0\\T\\erlf?!ohѴf:?\"F.7j))|vb \'ۂfDwg/]XN՛C\0Fe I9NR@`}oGE{zhFczk~^7\0k 6[^I\0j٣лSblV577bF{nјQQЬ=\r&?lǿ4eݴ]ƻf+u5CBۅyh<MmWl\n,J8iAt\"hiE/?3B\0@T?w@@U@%Tp\0k;{`48hH\00%*=8Q[wP5X^gK%kJlB$Xy\n9F5#v 6dU8<S\rxƞ\0׸\"^kcr%CVVT(?jur.\"TeqSuC݁\rʶG	5J6;*N36LdHKJvΕQO\'+\Z63\rլɷ26&5&5F;Ao515DVa5rƔM	CȞ߫@@ pۜBۜ>c%Jl~Ϝ\\E]&g֭P9m>{N x(\\&#VNHIyP6\\b,Ci@/9.\r\'塈>\\(\0ll{O左zh.#>0u.{Ă}!{ZxHIk%LV7|K2[d׫c9nd0gzr6̓tZ[Rn.#\"!U\'nC,ϵѩX|ZO\Z\\9kSuG[;04l{\"\\GpP3Z%tit\\I.$]#]0F&M@.R!]lt ]K!]q~D!EG+ͺDL9hT{~̫#kc\Z\ZK\\Nղ/0l/tvvd7siNR6>PIGĔ	沗=*iHXI$laM\'\"yXha&IS\nSR2<PlXT.FsfA+ML^!͐Khh2d!f2w-/_([z?bJ)ӳM97\"̓3͝\05/M-L3\rlpz߀%\r6V䩮샑Xb\".({xm#eVT@b=U=@p^>o-гUl3\r<,bG	^\0)WcCTf)\0uzsWjđOZUQxU՘z/PC\"pJ	T۾?EX.ۅxAGQvWwu+	fiC@\r&#4}a2 \0%0*jjaKMзjU\Zט}OwlM,hv*#dk!cH\"ݭ?nFhuj&5Mc\Z&ht4\"lNc3kD`Y\\vY<:RGf#\"Շ.WbuS-3W7c3s<>?}TۆCN\Zxf]S_<=	N\"Bxo6D*\r׆X`6ʃd}3ǿqm_rJ kFP5o\0TIr@ԅu!K\"`4.D\0+C@]Gb:PiTΟ^Y¿>ne Q#3*R5@2QRF#Fyh=3m1>jMSi1ٜ]cR@3(+qQh*]η A|15+\\p6xir4Q*D(\"dR_՗8LlEH\0}<\\)f\"fcujad!3\\(ϖ)Pp̭\nDds6@ĽU;H\nDUèza7^${,a4㥐I!|0DذP.>v>E!zE!齝3Xj/;rU2\ncS}iIUAkn1#&F<\nz95k|81Q)5rdSĨ֮8KbHhmW]wDmU\09\n\0յۼ&QN|jr@sJ\\wDѮԜK\"+*P9#	3M ʉd[)aQAi Ağ\n#1rO `5&v݇umzX!)[|bS=<(wI \r(PǷr		̱_U8&pBxOC#nXϝqTcrE*?A)`}TI*~HQ=B	{}cS+\'|\'\rLpse\ZY.B8T+QPé-ݙX	|ž^ȚCvYE>zOy|Ԃ_k{W4*9mGʏPϦ3D-w$rC<[wиYOF+1df~jFm8O՟gZ(!\"8s\"OC,ĔEyqeraK~/Y֭afW,\\<d[x\'ufas\061A]HwJً=Gv,Ľy#K[ty6%:IWԮh:܄l1Y;?t\0j9~kB\'\\Hɾ.Wpa}.tb\0\"(TI7z;^_Dg|_$y\'\"O%Cc\n.<g\n.T{\n.CB*%0\n\\+\\Q(Pp!薗0yH+rW \\+0gn({M-E,$0;,kKd,0\"مFW-Y@XWES*i\rTBjnq~clIƲ߽Q?}endstream\nendobj\n108 0 obj\n3384\nendobj\n111 0 obj\n<</Length 112 0 R/Filter /FlateDecode>>\nstream\nx]K6,H;z?b!\"`ÿGK~HÒ횩nږ.|?^/?h]޽|\rBQIưE/@*B._|zJSoavEѷ^.\'&Bu_#LC̡嬳Asq1e%伹K߻5&[o\"X b2(umA?~\' kJ`Ik|܏q\02\ZL(aL[C&Iq֭i3Rr\n\0R7P11:%؆E.-:.m#N!ؾݩ8\"M5BXo%Tcc\n`)HL}P4դ47¼wJW,\0۝W@BmXI\0*Tԩ qEz]k9tcY-&}]\Z3:xk_ù^JG4_\Zn\ry_\ZDvs4\"im6p4\rZg5vx9Z8G=Xr+b\nZ1	\0\nXYkI +@\"d\nYITPdbVlnl<b(a`\n{-2%!8C|>ΔS=(E712LJE+x7T\0R,㐫:ՙu8{|:~u!\rusV緿oTHC7R\'w@hM2|Npmdqj<-,=OLwDT 3J{F$z!җ͈WΈ@\0	@uSi@Q8#K{\nSH0|)Ym8CpٺtSֿgNa.*S\\LmIe:<QNqȈ*#dceK0L\"Q2PY$}7<)\rEᢡixp4ԍ1<գ+/P	d)d2Ӣ<Yǔ2Yrc^\'%3r/A7zf+˜d4%sQݮ\'Ekt*B{C /֚.f2cG}ZA͝b1B14&k1(*%ψs\Zoka!pAVJ7]mt\"A2A;Z<AAb;_Ef?S$Uȫ\rцE^mF,E^>$Ďn}is6Rb.ϒd~Jo<vvG_f5jsi\0˴Ѱ[G$_ N0A&R]T<I3 I؋^qXhJ\"Dڛp#UrFF%\\b!wjNWk)GAs	nhў!>	ej-ebpSXXU*5\0k\\e3 \',)e=ˈ.2:wIeM\Z/uѹ휑f:؄2C\r02\ZN)S/#13O3<w	ĒD\\P0M{m#lY\\٪=*<@,*qm#ν|ܴ@VaVkXEhX\\\n_\0R0QχrHoZBH^G@%MR(妄G}(W~RշOzckNa4wQB]ն%L^?}af\\P_kMb0&@I/x(xPbԭq}TYsq;p?ܬ\0jJZkDI4F4?ݔwDݲGsI$ֵlSH]\\AM;\"3%	&L0ei	[`bp!-2wf=Eܔ\\b^,Zr	\"%\'0\Z\\\"4gɃru7o\\\"\Z<@ՐKdPؔ]\0\rD^DM$(%݋#Ttb%l(Xb꣞X~Iӥ\'3\rX\ZDWm{1BI%JaMTlJdqz2DhÐTΑCg&[Ȁ\Z%	ƮbZsUa ӄ\Z`nZcg.EGڕ[y*<B0QL}%:ET9gSbR{MURc\0۝\'Slw*H Uf6~pSH6)8\0Ğ~OM$%~̴:5ߊ`!h3h\"LI2NPL_Aa	&)`boV\'Ċ	&@fD/Q=D)fgS_G,67ڥ\'DB0Oo%J\'&ˎd\"`tv\0=dQK2`WL\0*̄Ů<ɢ#~[8L\"$ڊܱؔH&1x{sE&1SIZ~{QeC]_USg$\\ٝߖ3H|rQYSDR7z˵Db@*5\"(]I$*~$bI\rHZ\"7t}m+bAA^0ij\ZA؟\nC(1PO `&vވm:ف!10[	tbS\\Č(~Ԅ\rB}32D\0ncX073*WId[BO$YXqICv#Yx(Kmƚ HWF-.$Zx-x5˒_}!`]G,DQ5lR&[X&\"[\'l!srڐ-le<Eݑp!IP\ngoBI.x~.<I$\\8Z[ [ذD[?4º\'d$)er}BZ\\ܖ+$֡w+$D.\"Ob}LpX/ .{+Sb]+H\\$\nxmΠ$RV|?D3f>݌.L7];j7\',ZCPƙrF_.4p}.tb@Q2;ܢs,x!\\}-HΈd]v)p!s\"\\a?&s%)/f~8paG=%]ҹΪ	b,L#\'$\\(LDee&$e6 k,Mq\'^IݴɲXA^B6\rc݉da^>hj^4eQb C^WWƧT:RK)PM>ڀi%j#	[ח?yendstream\nendobj\n112 0 obj\n3351\nendobj\n115 0 obj\n<</Length 116 0 R/Filter /FlateDecode>>\nstream\nx]K6,H;z?b!\"`ÿGK~HÒ횩nږ.|?^/?h]޽|\rBQIưE/@*B._|zJSoavѷ^.\'&Bu_#LC̡嬳Asq1e%伹z׶f֤uKдTDlWFR-G==dtm^	,iwퟏ1\"\0\0\\\\F	e4L6ɟtk$:#.RҺ5zFJ@]@ʚ*#w;f_T\'d۰e|Yǥm\\}$	88\08ۗ;G_Fr^+zlT,44FNםp|p\nH(M+\0@XE9\n:ud\"TkT8n,ŤAcF{v8t:CIFZK`Cۭ!k߿R\"n[XF?~6\rAY+O9GgBBtXQC+&\0Q2V+q-i`dhSdCV#+)*ւB`uR,jq\rW\rVR@~6LaEW&]d5!g\'ٙrgEۿ2&#<\\SRhF>@wQer[r:goBQT8$3u9nx`\ni9`F\\:_<\rWVωn@?NX\'EPG)]ΕQӗJdFvOTۈD\"D=aj30 bj:\r38\nadziv^aJ:<W^8%@8k\rg.[n)EtZ%{kY:-lS\'a08ZeDlsLl9i^$*S8cbכ\'>\\46\r1zt:*al:<}bQ~#yZ3x\'Y&ZzVd&:\\e7aY/\"Slr%s\02d.hNR(baςНp>ձZ\\fQZX+5sB;F\"@7f[z!F\\{NPPm-,.*PRfAW@vV.X$\Z[&t>\ZG[K\'b>ѝ#@LaH4_Ugdus\ZyaT3ڰȫ\rrۈ瘄э/m&WJY/6Y\'Sج}_b4\rr6S==\ZV~Ĕ	撗=D*y\na3ia3{+1kM	qXH{.\\5aDJȨd\0Pߑ22uNjm4(hAn\"up3?#3$Wp\'L7\ZLn\nKJݲ|lD=%~qzEX&Y.l6P.:3LgP|F^)7e%;c$fi~.X\n	vMvd-198[0b]>gX%\0\rbٹ*j\rk\r+Xas @J&P魳}BpCBzV\n}׿ܔ1QTJ)Ru*S\rw]Tae-{I0Ou_wYm1BCS=7LƮ	P\nD%X9,uk@U\\5=7#ҡ֫\Z{h룑O7`DQl$d\\Iĵu&z\0W\'uPSwN0&lI	#3L`YZ!\\ȿlݣYD{a7%X*\\߻Hr%F%Y܇s͛\'E ,.h(@!P5)%T-36e@C.Q%*jb	%b y4Xb~b	<J\"g\"(}}t%LU[|^rCPRR{|$,!frzY޷L*Z0$l>)sd,ЙI% 2n	t7:mE9j\\U4.X황KQvh>LS:w}_NU~N딘-;#飢^pSu9DX,FvԢ)۝\n:&b;uǗh\"ܔ&Mg\n@6\'ߓl dI3NM\"X(\Z4\'CL$WzXb$؛I0\"z@<~QoƋl~E,_CKd\rvI*сPG*![I*1҉I%#H%8Bf;ݧ@1YU47@\n3ak Cǈ.·#=b3w,6%IpErḬTdy^TP;W2@4 a(BveL$\'\\Tr֔ (\rr#.J͹H$+qWʹعlmһHb;M8]w_cۊqPLF(qPz,\'BJTsX7o-|⃎aDv`HVB\0*0B(5TG%!1.\n5!}CP_|1ͻ2;Evz팣\nUvsDӃ<IDdaeǐ,]HR\"y[59ҕD>D^tͲW_X-d)%(vB~TM$[(\"Ƀb`I$[Ȝ6d{gcqQw$\\H/q.P\'BE0#.<	V6?;=$MmI$Y8BJ\\~@V&\nuhfâ\n%KȓXa_r3+>:d3v~yTxA\n7di7	_3:#郮%U5*u+d7M	֐-zq&\r%\\E_+p!\"s\\z;^_dgB_3\"*x]xJ$\\f*GuI\\IKY3$\\XQO>a	i+BW<B9tnxjcf 		\nnsYI/qYb\r\Z<Kp\'qɯWR7m,VDr0BXtw\"Yd,0$#څWMY@ȐW!E)R.$B6wZ	!R}$ac~Geendstream\nendobj\n116 0 obj\n3347\nendobj\n119 0 obj\n<</Length 120 0 R/Filter /FlateDecode>>\nstream\nx]K6,H;z?b!\"`ÿGK~HÒ횩nۖ.|?^/?h/{}.aqy닾W~|+N+\nCUG{5ܚ\n.~/fab-g47]VJΛulx5h}%hTDlwFRZzzDI;޼X?c,E\\\0z9ʨl\"?!kJ}Ki)9u\0)k~D\\URR|RĒANl݂Jf{g\Zw[h;$	9.pַ/ow*+~}SIA{#뾱J\\P>\n(դ\\ny{X\0;d)ھ	\0UЩS7m1A6)J5^A5sƲZLܺpͭ\Z3:oxk߰ù^J!\Zi/\rYm֯~Jub@h{8ocy\Z41h8Te\Zc;<-BWy\n9ЕbFG\0DEZƵyMUYȎrpf[JYtw7\\A@@6XeHE1Yk00]tI\\RV!>`cdgʩ={m\"@워PsahOK@V\0EKqo\na:=	@pHjyggr~6rvGЍty8ɝ+%\Zdǉn{@?NX\'EPG)]ΕQӗJdFvOԵE{<B3\"\"Ag`03\"(@P3t\ZgpҢ$ :u6\'6y~pJ~qx*=\\n+ݔSJ$ײt:S[R٦C3Oap2bʈ4lْ!r:ӼHTqId卿7OJC}h(l\Z\ru}6OuK3=t8T>0u\n.y*ĢFhg0*O>eLV׉\'LtʮX/\"Slr%s\02d.hNR(baςНp>ձZ\\fQZX+5yrB;F\"@7f[z!F\\{NPPm-,.*PRfAW@vV.X$\Z[&t>\ZG[K\'b>ѝ#@LaH4_Ugdus\ZyaT۰ȫ\rrۈ瘄э/m&WJY/6Y\'`w	aw)lVV1w@L+I@L`.yуL\'+y6f@6&єE7o\"U/FT䌌Jq\\b!wjNWk)GAs	nhў!>	ej-ebpSXXU*5\0k\\e je\radi@\r◺\\XvH3\rlBKx\rVߔ쌑bI\".(&ؽ6ّm,.T@l՞UtHY\n b6g^>nnZg0GD5u\"4,b͉^\0)UCCjz-o\r\nq$S#j|pSW)E^rSD5>Bn?P)jH\rU0\ZN\n!ʮjn%L^?maf\\P_kMb7n]<J(ZsXѸ>,jn!ҡ֫vxٍDh$AsM)QzG#	q4Dqnu}w\nIk:c\'0A}f$	&BS,-UrrLnrE,ٽ簈KՋeXK.o]$F#גK,yPù͓K\"YWt4G\Zr!ȋeb5yq1<pN,1CV?m%KL}3K>v{_[読T>t/9ơV(D)=tJprA3u9~R,N[&tJ@6Yot92cp̤uPc:XBV5v{*dPc,MkԥYr4OEGR&)^*?QuJ̖`QQ\n`SںpASj,`#`djҔNiuD1۝fO4nJ&3 ؓI6qďV&[,D\r\ZaM!I&	+h=,D1esL$Xt= Dx\\VRҌ7vE6J\"/l%2Ft$@#fVJtbR	A&R	YNisL$vͤ\rLX\Z,1$rOMdޛH.2L\"ދ*z:C&Ȕ\"\0$`@T,Db0E%gM	rJ}/:ѪԜDw%x&6 k$#߄u5yiWb+@>W?Uy#·!>HFd`lo%t\n҉#RL{Qr3PQ\"Pok?3_)sL6/Fhݱ^;}d$@BO$YXqICv#Yx(Kmƚ HWF-n$Zx-x5˒_}!`]G,DQ5lR&[X&\"[\'l!srڐ-le<Eݑp!FA\\H`\\8l/EZgDgkQ	p2;!pIp@a 	huuoMO\'!HR2-?\'WHCk0%WH,\\E\n۝XY_ 9@(]HVŞV,#YXxI&AWks]g$Y8}ЕA%7cfvaT9a\ZBo5D3ڞp7+pap.DbBA^ogkBkArFD%OOE.1	+Iy	6T{Ɓ?j\"\\,t.SJW;6&\\a0p0V1P0%ڀ![ȳ4wz%u&byI$(#4,Ew\'zH:Cr0]y~ДDy_\ZR_A_o\ZRH-,l/HB-4kzG6w/T}endstream\nendobj\n120 0 obj\n3375\nendobj\n123 0 obj\n<</Length 124 0 R/Filter /FlateDecode>>\nstream\nx]K6,x]T`Rld\0E	#%-YK۷kn[::CG@\r+u|i>Vj8O/\0˪w/_|P%j__7_&D&z˷\rBq5{uk<55\"\0U~/fab-gϘ6&kI%SPߺj6ԴJj\";B)Q-z=?dro^,iO1\"\0\\T^	eM6ɟՐI7FTVjZ35FJ@@\nj#wf_T\'d[Y5rRn;;%\0ʚ#/__Er+o\ZGE{4ˍ0o5?z\0z5Pb,EWR3r6zu-&&E\\S+>&pXVY[@cF:\Z7qn|f&ZK`Cۣ!ok߿R\";XF?~6{=EY+O9GgBBtXQC+&\0Q2V+kp-cdhSdGV#+)*ւB`uR,jp\rVR@~6aCW&]d5!5gO)3T={\"@712LZE+x׻T\0R,kYitq\rC?H=\nF=>k0Px\\W\0;cvw~{ئBZ(\'7@T{_Hx(&\rdtxB[X\n%zх\\5{$AfhD]YH_ǃ9,4#-o\n\0T1542{\nSD0G^yTI3.[n)EtZ%{kY::C_RN\"ZeDlsLl9y^$*S8Sbr\rכ\'>\\46\r>w:*al:<}bQ~#yZ3x\'tY&ZNZ̛\nG2.d~0֋7ۨd.sަl7TI7¡Zks1<DQ#j>cxԠ	Vhj֊\0!ܘ\Zlb<7\nJ3\"ZX;\\ХU]͓fI=Fɶ`kjtЅk,UDwb;_Ef?S$UȫކE^]F,E^>$Ďn}is6Rb.OH~W~㉾x3}B}y\nռU̝P.Ƈk~DGgL\r8)%/;zTaE6I؋^qXhJ\"D:pm#UrFF%w.@aG4;5\'EBI7Sѝ!!	ej-ebpSXXU*5\0k\\e je\radm@◦\\XvH3\rlCKx\rVߔ썑3Ogx%``dGٲPU{\n3*V;&R\0@t_8{ts=[?\"Za3aqe+lN|HL>\"uV4[hyՈ#yPJ/6&1Y\\\"pJ	T۾?EjXo.;x7Gu\ZQvWwu+	fiC6M5F(5bXZ{hJqd \0%X0*jjaGދbj)\Z׈Hm&4?]wD=G{K$_7wPKquR5McCĐ-I0ad~f,KKp2m{4hv9,kbY%֒K[I.1a8ȵ9KpK߼yrPr k꒎UC.a\\Bբ)\0ZrH,QV!VKG,w߹lGIsLsH.i j+5KqL*Q\nd?NRF46\"ײP$tJ@6[ot92cp̤uPc95>fe\Z=WF2M5v{fRtԬ]ϣi)Ŕ]WbSD(y:%fH0q(no)Tm] Q)5p2hivN}U`f3\'7dMI$8DҚV&[,D\r\ZaM!I&	+h=,D1esL$Xt= Dx\\VRҌ7vE6J\"/l%2Ft$A\'fVJtbR	AfR	YNiGsL{I*7@\n3ak$Cǈs.·#=b3w,6%IF8xo\"$Tdy^TP;W2@4 a(BveL$].*9kJHSJ^wDѪԜDw%x&6 $#߄u5GyiWb+H>W?՘y#!>I&d`lo%t\n҉#RL{/Qr3PQ\"Pok?3_*sL6/Fhݰ^;Cd9, O=G YX1$n?!Hޖhanyrte$O\'т],9uDYJ	\n]BU*je X}-<2\'\rXC\\	\"+p蝄c\'\"\\#.<	V6?;=$MmLДmϓdI3\\~@V&\nuhfâ\n%KȓXa_r3+>:d3v~yTxA\n7$/i$\nxmΠ$RV|?D3f>݌.L7];\Z7\',ZCPƙrF_.4p}.tb@Q2;ܢs,x!\\}+HΈd]v)p!s\"\\S.<~LJR^*q :\Z%F]ҹu\"bf 		\nnsYI/qYb\rZ<Kp\'qɯWR7m,VDr0BXtw\"Yd,0$څWMY@ȘW!E)4R*X!	d磾~lB~͑-տyendstream\nendobj\n124 0 obj\n3354\nendobj\n127 0 obj\n<</Length 128 0 R/Filter /FlateDecode>>\nstream\nx]I6-z]kbA(6\"#,2\0E	s$n͖~]Iu{3AV͇7	~77>{OQyz뛾\nÿ4pPzz5N NG_^[x4Y=޿T_	&l8$Y:/ޱl>!jSBtoCj0se]m(ڞõVgFņgxَIӶE/o&_j\Z#O_5Zxwӯ.mJx#_I8-$2;-_0~~H9o\\j.RLo$Fp%Hvä]>	:(ض\\E*M+ml[ij*4L[BMa\np:(>nbkhmC^΍]Pjh?zh{5FVsD1Er\Z45x\Z4Wec<{ΠE6+B\"ʈܢC+&m[dZV]UYhYiTpf[vjqiPKb%\0v\r{=rI*W5cq;y([Jo~).vT`4c<P\0Rh#\0a(Y!_i\0@{CHٿ\nQ#52$HgDng\0ÝT3h8n,T*\0DUǉQaWN9DQc\ng}<=~6FJ$z\rͅJDHȅHsmLC#@/A=A{OLx:@nm>.wH4XHPLl@ȓ^y٥XxLКFxOJxDlI~!Q0RQRdu\09b0E7^N)(NŨQiw1VPeTRDD2DS<Qp̥Ұqh[]z;&`ő@H|f;$aKY	UN;XGPJD<	eE2\ZolQ9dUEL-7w[9trqfZi/\rm>	U3!Xi2&xG,.xWÞ\rLƼ.EK\\{7Tq@?-MocA[\rTAҌ%wT`8@\0瑧YJgL@z]Ԧ2${J8*PSAN׋U_2rjh0jRj^\"%K\n~ن4OYk5X&]BPk-=JS<$[,+,߱=NasjʑǇJE^umgI72!*ʉ%HW*/ї0L\'\nTü˟\'RM!X60pzM^v+	ja7Ҍn$4̼	8LQ-^6u	O%#xBcԸiaLdt?^PtQ$JpD{ܞZ*pEֳ7\Zn*K4v)5\0U i3Ϟp53.::waDL/f휑:؅2c\rd4XS;#ycnψ8S\nfDSvd=d\\:RI2Z3<XOť~)GMOeNn\Zm0FԈhPm+K9Š\n+d.wuᇦ0 o,:GFWb	|g[pU$L \0UEp\Z53~Wu+)iz˨%CUƍХk[]lGAH5&1ir.zO bItF9ZHp:Qxe\'I#Bpݪʐ*jLc%c3dd,ď%)X*;51øG,awe+٪~Vn]\"[l%Fne+Y܇L~g+E F,t4Nu9FVe+@#j&SI]Tn^\ZSI\n\03 kx+me1}gb*c}tJL#=+IQrLChZ {d)1鱹KI!hv8KItÜTxSΑCRR\"bSNs7::3>eec<݂PJ	4^r:p^5\'q$&sd^.g91كT4F˂ XLA2Hy(zcv=,3@eA0gXLHkcC\Z\';\n&~X\\d|9:>\"{Fr0c :@?z$VDALKd<}c̃6ڄfKH7M,X拲#-}(ʎiNeD1I*N\'ˇJf(f,ni:)3ҚS\"+<^4\rRh:\"mCRtdUm\"LQHQ_E%k#ȡm=鉩9$gfG[x*igSx:7غdެi036\"Yd#R#-Js0^GQzt7%{)c6;=Zʿ(3®Wec]T8Qr2%g☍|,GYSREysPq6\\T?az(Cnmc?\n]q_cۋrVM=Ww$EOcb\\xC}o=|OUƂ2bCZ:1\05!LGTVp}GZa0]o.`lbz;Fh]^;xQU$+/JU13QU]*R||_%ҕt*^tAt-f\'*TF<fRVU͔	Q)xQVNNO{H[\\ѴI[1gQ}V|\\7/ڊmŽ՟BJQ\rkH_mhs){ʄ9<,]v3U3/ʼ\Z;:,\\˩X>@;:VƧp&Es	L}uϳ~p|P\"\\˧>;2̹>{y̭`UsV6a?D,¾k\Z7~Usq5q 4!}s ̞	vlcpk\nXKs UdI@IɈf]ɁP8r <~.U^JpRR/s@|,±+]ҹSqB\nY	9*`EqDKMX\\=;pu3y΢=nd}=(aiĶ+{0L&Cuf ::x\nFy~#FXl	BZhQ?zeR@ĥlo\0Q\'endstream\nendobj\n128 0 obj\n3638\nendobj\n131 0 obj\n<</Length 132 0 R/Filter /FlateDecode>>\nstream\nx]I$7awl.{R/K^1kR/\Z|B>/?_vW$\Z-U׿k?+iN뇗?>_QpՅ7*r<2ãL5!rz}OXPBpH%u^нc|JOWhBWլ함0=4kMkW`gFQ͇gtَiF(nLdB1WF<a.~{AD+֜T,[X5dvZ>;k`mX{s.Axӷ/.WI=EK?6Zahhԉ4jª&IAڛ3EIz~iM+kBHYE\n:\rӖ2b\"m!.~X1u4|7(|s@3C_Lf=\ZVVKD#r\Z45d\Z<Wec<xEv+2ʩڣ\n(&Cp3vhq-cdEPdb@V%#+άp#Xݯ~X-#~~\rFUT\0F5*uBbHAv-]Sy(Kc_\nbC-<.\rD+6jw7\0RhaVLC.\0tI~9f|6`ȱ\n\"-/\0\0;kn͕Q4t-W	 j/he>NIza\'ERG)JVu\"(DoTY\0،HD}f02\"m/kLMC[^*;xFaxڽK\Z9\'wDSJj\0a-Y}n~q|:RBȖM1[..!d*cc+NR)˅16~#cp\Z}Έi\\ƒFTa\\:%mo:(rT<`pƠhkpba1AIӴ3\\JS@]Xo\0t8S{	t,`v 5 Ep9?Ȫ6J1:y?c2fdW]6$Ũ immV]\rƽ6̢3k==|zstRgw-(`!=ȈGn&5y.?3fi@|_K	9]Ԯ=&KhXtX*O/M7CdRU1WN^Z\rԣ1Z{KehH`Xy%\ZDc]q0Tß#P$zE:㨮qW:&1v9/&boїl[+P~,XJ}ggm\0\\ zK^v`+	ªamm$4̼\ZYL%+KhEZj)Yw=LW*~5K㦤!h`NF5EGAE\"ɫ7K7ϰR͘+2-1oeJn]PYw]mF?cM	_8\"svtY;P3dPf||RkP=uJfc6i{F\nfDSv]|0byd!\"XOť~)G]%+1`ւԈhPfl^UXgscbvOv텐H1(߯.p/2hsZ#h7V t)J%?i_0dTǶ-xURP8eKׄ /Q Vk^M;}as?Wt:ذzz$z-$8xcw^IhGH46\\*rS	!qW612Eqٚ#̟c$6+#\\e\'&ك»=E6p:,\"{¯{E­K=0_dȽ\"9KpL|\"@ֈURITթp=\'Cժ\"y\0XqDEKۨ\"\0\"d\ro^ͣ,nAԷ\rįiލmf{3|>.7(%@ݾ7\"V4N76{knI=*s17I/WM5AV{b*IԂMSb4(sd,cp׈4SMSGZ.ezy CfjLjV]Efq5;+妎`s0Й	89܆RFZsR]ZL)bx]8u+icW]͂rW{(effc7AnCZPY)i^e1tȪϛ\'ˇsȪPPr9TS6\'o\\,ai!׍azeP+>oO7^G䍿!AMa\'o˓F]liU;ߧAO\n`k+Ɉ\r<i03vYdJ!-J總,^Pzt7o.a6`=m`S6Za۫w\n{62gk|,_CYSRκU5v\\|\rտLySʹrݤr=gq<߇Ч|(ĉ!4NYkjngpFN0p|?\'?3Q|;Q5(@C(7:D4ETy&Gpӵ?~)$m<@qsl֕e3IwKzONe0UaGQ$oTӳ`gG>Qw7Te$bE},^D:Zd1{3(REP:IiPW)vS\Z$}jQ\Z^u|@voHkѴIkr7Zg5XZ+MkvT,tdP[_E\"k{ːݙ([S>Jc4hkRxfc2<(}h;IaqJ?Jg3B2ĝ$=<L;WS~ט\r\rLO,^,=.,<rPO6ɔK1GH¦.<)@\Zx,LdJC٥Ò#XGIΛòۓ!!?5O޹&F1Z!vp۱ĔpXUO	g}2LvL\r\\\\=3d$JQQ-֮g8ʮU[33v$gF7#}ܗ.gF>\nrf,k*P..X|kx[7\'.ES5A)3F\Z˟3fOzb@Q|3/e0\08dAjmf]?MLя?cOş.}gt2Յ<Csb>JR?c6KHGg3)srccg=Yc?2ZS454IoY]\0~;c&|YK6Yff崲831H&hX\Z)83f\\:Xɾ	V2/ḣϠ\Z^]`|cn`κ?Eɢ8B.&ꋏm[c4F\ZH5.83\Z0n-]\'\'VZsVjA0]/!\rĺ^DHNHJ,<!M-WAÌhB\'|\"\ZѽGuJ)	9Ҹܿ{}wfցendstream\nendobj\n132 0 obj\n3884\nendobj\n135 0 obj\n<</Length 136 0 R/Filter /FlateDecode>>\nstream\nx]˲87XԲ*2z?`AOb6=YJɒ1Ѿ˖RGTRyGx˻חT]^b｛ͿV	~|+eNbAG~y4=0D.~boPRgWoh1m>4R6o!]ڻnVNUL*&ݽ;Y;ٲRT?c*EZ!Lzʤb&?ڻЬk\\ݼfy\\4?\rUnw**9~eNR-dnaUa#A9e/w\n{;G-/u%	ׯo&%jDVZa`7QՊu\Z!̟\nvc4a;6!&.+.Y\n!:u̖2\"6C6C7j1k#upͭ\nl-\nN\\/йz&ZWcYLf:Q	0v\\7#6/f!4(ᩔsOZ	]11(-:vXdR,h\Zג:@VDvEV-:dU7\"*nydJ,:0b(\0Em^BtZ5[2WR4)T/M1[{`@4flLz|@vɒ j#[W\Z\ZnA;ORUn8f#_>1_^qKc+g;;~OzT#\\\"u\nLn2M3V9ΤN)_3M9\'b\nPѐ4qϵA\"Huu̽I#JS@+\"s4+lE<2mv\Zk\\fN@E7nóqg/ba]i\ZLA	P04LXFGt쓝sS0m\nqQ nt8<8 ñO	\0\'a\0%L̘Kk+:+jj%WNBlIQ*-\')-x?[x,Y\'9,9w\'6?[+b-OZ,5CoeI+qJ+b0\"\0u&6]$lF#,36)5<pUosGyx7\'a^o##$3ĔTPD]kJJ7s@;>3^\\$Kj%ˑEH;lJL\Zog<Q.*JDGpX<Dh#.3-4xusxQT[Xjpm9\n\'hחo#/&/ї첶`fn\'\\SCQSbM^4p AB l!ѴaZ[p<JR!~z460\'gdT2\0E,T묍M576	.8\'sGAEZ]F)fyFgXOe1gn,K($=b@iPLRç~Rv	_8\".[/Jm>A◺n^9v6؄2\Zd:Li7<#sה$߀!;ϮR꼆d\\\\u0b[5g5qO\"RtbٹjxKA8\"ڬa3a.-2:SXUח\'w7B*\"V:a[yRfǛ/Z#2D^;T#lw;\nmUr\\B6O}FMF^޵˾Vdwj$h_+0`}$o<3o4-)Ғ	\'\'|]wzYb2KU/*3\"ܺHΈFn匀$(Z?猀\"\n}:\n(gDJ͇Eۦl7h8#\"j\"_DYn^_D\0E,5Უ$A9\"\"̼HIoU=1kMKY$+ȝW\"jFu\"^̹ܿ\"%pE,,$sE`1[	o$\n9\'a\n+^65l>o$ڋsTVv1԰mϳP/++3y8#\"rXrFkzΈsSL$,iLƗqKJuŨ	I&u \">/%uqT/L,:pցd`UA,c0`|HU6i2\rH4izc\Z\rbsC$EeD @)&Њvhu\0]@\r]`\'fp˓Ȱӎ,KI,LK1gafx+F\'8U euV7Z\"h4=*bcZa۫P;=4cX@@@ieF#e(i5%)\'	6ߨ~*6ʹlmQ`?]=_cۋo`g1g/?L_#1tL;O11@ˁ	\'P&+ݤ}@OF*0<=\Zީ&	ȗ%ت[>&C~0b߈ވe1n#REPaA,U*frr@\\`!>]	\"L0P\n?IkF0sKL!XX^nJ5o8\'bܼ	TS/XeapýM92u\"-g(Q\nBp\\rpv\'&HӗrN_$h:rc\rbS8\nD\"MD{AfT~0_r>#_e$\nͰt*?u1Aohi\\qE@=]ImM#mXLځ3FNJi?7rt6\Z&MӛuYG:]WMG;`S3pA#QxTڋGntO<wW9aq\0voHEy|a.RxH*:Up\0#L7׶nNtItL21M_0f\Z\'P(H(3L#ʊ tKnɴ`\'jkn]6gdrQ;whF2G?kL#*Gu4ri$s3죝a\Z<iD,lF)Nvf\ZrP<!Ha9#m0cٽ2bذYy>Hbɒe,.k3Bbחccb7c\rmvwĠ/!\Z4a1\nStJqaQSZb+B)AOu[Q4F5_pzhFql569؎3ge^M,ݏi\\X-2:epe8isq0/[YXD.#(tUzkwnvHfܜendstream\nendobj\n136 0 obj\n3641\nendobj\n139 0 obj\n<</Length 140 0 R/Filter /FlateDecode>>\nstream\nx]I$76;Wh+-Dp.a.{R]%#^u-R*W?POHËO@e/^~GBNQSyzۋm	0vz7+n$j6st<2£h&9L_)pHv^нc|JOQ{Z_W5W_^Xè$dҴX)2\\^G7l--\ZIU;<\'v,HE/WBYt[2\ZsņSm8nywӯ/pvJyTK_I8-,2;-;g`]j!qNU߾H\Zy\"\rJA#8).I3|tw1A/A\n+꒥\Z.NQZSaPaRF\\RM`0KƶZXmn]暁]7t95\n.8(P{23D`C׫0eЉ׏i35z\r+MNٍ\nA6Ev+\"<RGG%hVLieZVȊȡȪR FVVUpkCv1_)aΎ61TVy\0R$}@lѕKAW%8ĸ[\";znǰVaS۴Cux@vɒ +j#+\r@\"/R643#bO?>{{1Nm|Rm8<i\"H%DY\\\nSgr-n՗^[ާ\rRRhJGo1aŨkHjhtRGDߒ51&$yTjfP\"ŻJ\'vs	JenAGlI5c3j4\ZDpz\Z9s]x&_G,۹(hɓr(TR.\nU03O3n@5Lɝ}N	wzBΜEW1v#+((*v #ađ༺k#>\r,!(bH$ \0[Bc{[<3\r3.-Z,Lސ+[ˁ\r5#IjL\rtK	/PvX2AHy\'ZgHDϚ\\ɄapG!zR~Ta@0\"Bvzstxm܆w~`2pXfy(E1遫ϣC7Z`jWa;ޖаBXSlG#w]iK65*Q2omo|Q{\r!ѕ7a &jÀc~\rbK6f\na%\"uӎ\n(bn6bcI=8\n\'	𫵀@%`+_}jaޏEӓ\0ice3r<b1;}rR&FtxfDh^053yۊt%+KhEZn0ddT3\0OU,dtVB㦡Un9]POl6ɻ`ۀup>#3Tp3&LGn4ݬলDc#کa\0ju\r@2huqH\Z``B5gO8qdk@m\"u6e\Z,9 zxvOɕyZq\rH{);r̮ҍ|0bpƖG<b>sp/A7w[v8ۙ\ZְJ0׌bs:SX*X܂o(;w!!@F5=d̇J!x(\"m0>QVDTg=˧pLtL0H1|hαZdT	jsb	8^1[ǋ4GtnHVFrٞiAmzuSYL;=&B|^hoeS/bϊA\"3vpOZمELpbiVlOD=<\'F,fƲTՉ#\'5;(1bj\"FW]KV۽W\ZG\'	|ӓJasa.M0[58\Zvm\r9גc\Zbi0eZ\0w0!7J?\'7\"9JX1J ΌfҀ)Y.yT6m҃\'|ɽf$<>*JWH=÷+09IonqQڭovM@C\\uRNYpZ*Ș\nqH{*#a~\nm\'宮1CayEK^-#8ܖ3\0X֫h>lB8ofMp~@yו*&0!NGX(dm\nI4O4W)ƛ{1wʟU;	3?%Nwɝ :Ml^>yS\nY\'oai3%ޏaΔz|)e\r{36ʌmͷO9Nٓ+)/7r0K*Jf}ߕl%Yn%`fΰ<[)rƋ8RJOHqdrF8z\"8RVP)eVTX;wm.8R~tGF|,7JYSR	qDRs>n=ȍrW9[+t;˱G9S⫯7:qsִ:EYgjIX\'exJ)\Z;:@lN29))RMXn1G2<)Rn\"eg\'QܕQciRFOӤN2{&IbnɦIٙR	ѯHR(&<fRUT)	QT)\0u\'Un|E;RP#.{Rddۯ.]=\'RVRLQ\\k)OƔQѓ1ɘC\'/ɘ3*z2dLŝy5EaS2)\'\nܢOƔ)OƔ+ØRLbw@OBʒ`L[e`;_\Z\\)cSVΉztIVaVc(bbS|f7za!B*Z[*ΠX<\rlX(SzkwZ\\6iK!F6h-p;/0%k~v,N\ZňvR~tG/eRldU`rJ`,{!Af$?5m7Y6[Xaloc) ̬Jk饏d6>ؿk<?t+<-Սf_h4c)yBa|<%ILɓG;eO[X{iJJ\\L<UĤ\'Q<LJJAB1/\nM.b9>.CZܿ<QC (J\"a,%O=R\"+UIspQ= %OeZ(hi^.uL?ѐł}M֚eOLN+)m_g^_厉Nc脱&%-y(tT:0I:[c>OQXN㆐9GNf\\;.BL_k\rTq7ʖ	Az~e#AΜv7~ax}qn 5zտf#ǐh:q=rPMHVݝ\r3´ND*zq^u`à\\endstream\nendobj\n140 0 obj\n3842\nendobj\n143 0 obj\n<</Length 144 0 R/Filter /FlateDecode>>\nstream\nx]K6-HT`RlE#,(26{$-mvJtt>p\r\0_Ǘxx^`_vy? td__wqC.Ǘ?]m0d]xmϯQƣhA=b!rvyAeo.I%Шz64tF\Z\"g7JkYZF;n%e;\r\0ˢlݤ\0C2@&$q05@Xzu7\Z#w;f_R\'d[he ]70	\\H]o_T6|.AX)o#T\r}cO\n(Ռ]Ȕ^7\0 6YaDQJ5YLMR\rpuH|0TH7~0\Z\ZhmG3npFkkW/n6HFkJͤBKB^ޫ&L\Zd[+\nmX9G3pтM0!O\"QPCk%\0QaCI[([]U[Ȏ\nr@\0-좀uR1HFP}w\r0lTF@~zpegkض*%\'^1	A\"1,mvfs?iF@B6ģd\Z~}Qr@rgds|gBVvz9ziD@F˪As\nZK	OpIEtz\'v:rOur($g#&ͫU۔ZXvD>|EyCۆ~(ڻpj9¬AulwX-v*Fٔ}ʂRQ\'^t*!橰mw3V΂dkK3RnŢbs`W1T/KPN|PCK~U_!ǿM)@8OWh	9ZbsMVYY5Kp_[{LlhыdxLG/DÕJ(ݭv&򒜉B7GȆMX=GiF2R u2ꀬBM\ZQ˓&<=rv/\Z>՛<M\rl(ϋml9ȩ	梁h[EWE[VݻhX,[H	׬LVy$*ol,iBtSZc>ǣ^\nK\'ۆ/cRIv[; Ap9C\n8$Yн&Q7bm_%r`m\\,jmF7eiΗB=Fqe367ʖ}|F({VucRxz薲k|#:;##\r:H}kN0A	O*nSx\04#R+m\\A<yDz)\"ZD:Zx]#8*\\,< dXcujNFA&d_xW$g\"̴#%23?C<M!)2d6\ZBxeFj-6\0ڭ:\0_,]7[kz븦1kg0ZlCi\Zne,*`p](3>>`IA5(:U#1+>K,%tDqAhzJ<ՑJHUG\n3)VG<bօi_8t3Pڑ֌IqwpdrDYzg(Al3I_)\0)U0Ku\rq$S2\"jC_nJ?@Iį_NTp^*v?J.Bbƻ/6@]~|tO4E\0\\	kެˇEvǚU<v)	E3f++PLܾ͛Wg#ն8=SaAɺt_+mvisz6\'tڜ3X&HQ\0g9tgOB)`u.jUڜjmNYL̩ͤ)sKQ3Z4Qe9|I\Z\r`Cã䘆t9\0,#;.&;V93d6]j\"rJ N]r(̕^7lr+\'!Ir\nA2L<f7VɬcKʙʕS(rN8$<MqH~<I\"+\rN}9Ke5%F9*$i)Xp޲G/+g9Tb3/dϑ+\'oF<Wg^\\9Y0o:,̶a3N:\ZˠD\'49۴g2\\&zI@[<ԛ|-|+&L&9tJuLt$`@y|e\r\0q3Z7	3ND&Y[q:E7cƌ뗵!o]s_v^*7\n>څL1Fٓ0U^v T# 4ձ{3詻*נ%m%03kYdV$ͤs_/·#.)=\nľI\\2}ErMZaoѫw\noK\"q^Y^\0 -Ic}Kf#Ԝ55K){xpuajf.gaI{T\"($`@搖1\ndpVh$1|eK6kZ*\"֚\ZKf*\"/@&IW!JdW29%Լ%(;oɔq-Yh%\'-٘N%LS=bWsĆ%&s̞.yrdslLCs/\"E{Q0w%q5Rl/IX /<K6ʳY1&	aR?N,ם1|nablD<I[4\'ɓƤbT1yҘl)t0ɋxҘl4&~=iLθ=(I&$MPO\Z\'8?rۡ1)&1#1dJ/DF,2`(ݭv&T1+/ĕDκ:>>i]Lt 	KQ%b.PK VW\0>-Sd0p_t2?tb}c*Ju߉_﷘ǃJ$Tz$5h08X3͖AmCX}NJ7Uwg\nzBV`y̶q1qζƉ[\rewT::F@3<҈4\\:;Kg7̥;V6y69\\ 	>}^KA2\ZNlD.hIc%/K\'bFQQ$\nNmfO.C#.<^t6/dұrSJ\'Adg.7ҩ̧MS8M-D)\\:ivHafYţIZS7mЉIjecMа4sf\\2N3	VbiJ՘G*D%!ηVe!U0@j(Io&\ZOm[4F(5b\\oZ{hJqd \0%>9؏h5g^;f`?jxplTUItߏ@J4}[-Evm^ZEd~l݅^\\o}$ag{9endstream\nendobj\n144 0 obj\n3895\nendobj\n147 0 obj\n<</Length 148 0 R/Filter /FlateDecode>>\nstream\nx]ɲ$7/Բ*p%\"X6,L78Mf#,CvA:w\0o^_~gaqx狾W9\"rx;Nѣ<CioWƛG!z/#LC̡6#ޱYvJ·Qly=h%tD(Mׂ#j\rnA6X?_c-<\08zi$d&\0@l$}dLMک_xS\0HpoOc1r|s:cIIkuK9u*;3\rc흀a)%\0^әʎ#ߜEr0>+oԁi^0Op1˵0URI@8>?y$&K1tQ(FRMsd\"TC8]U\r_76\robl\ZpN`7v;_Z<Aq\":K/)5z\nUCB{\"D3gנkRoP1N9򜁫,<\nZ+	\0\nj#NE(VvV&l ;&ʡ\rheJ*͛A	wTRE1YkVw4+8\\þ~U)9ю	!W ZC]j\Z|i*?\rBFҡ>4mWє?V\Z]iwpFt=b|$-\0_x>\\5Ww~ǿ=lP!WEC7RVzm<+jB?:Z*%<uT!xR2?\n\\!ugTpȥj`a!h[q7K(o2|q24Itv/%j1hP4E&Y0`#sڃ!#VKvGe#\'\"dSl3UnjHkdk3?RnŪ7b$p1d18y9 \'|>c/K{W1?QZR#}~#\'Rp^W~M\\[bKMVYY5KpaJ	B-=TYUvp6C^%7],ЙFM5D[bumR}\'!o	?,$gP|Y|r}҂Z(<3`Q63eC3^!qP`Z.HPl#EA;W&N\Zu͌o8	̕ 6/Mz&ex@׺(̑Dho7R\Z[|3~1˸qhdm\\0ޒ2޶VKZXK}f\'dcy%7OΌF:\Z0N3Oچ\Z](%/u3	StZiFX/|ՠ@)\\<\"\rӾ%to\",&,+g*\'S߮xj5uQTE՜Q0\n%k\"ܤM\"58ϐZ͜2ū{sI߿D Z8hi2[LS\Zr\\!2ƋP˰bn\rL,(`, BK\r֤{ڬOH\\3v*\',vMzd睵e|d0C:tiLUt{%xDX3!VaCsr/A7SKLkK[Xb\\2k%hm69@J6ar	q$S2\"j!{=>3yn<󏓒0U9LT*0idv`!qIDH\'%@@+3)P/^m7Wl9ǏιZZgwsa	2%X:D) yct|J%%I1uuӇ1 ;+3H^ n(e	71d̸F+Aby<*)i0|  5;U469L6Yja m$ܼ4V\"0-2\\\0kxGm层\'=+H!~FdKKsԽ~}(Z`I	shI:#Hdjnx1u6#H%lNvz`^3F2؎aY@jVN	!WIHEh,J<A&fҁS9],drU:Ji,8Ov*!YT(3H~\nՊ)t npҁ=L|цq0/gє$!<˖wf(-Kr{#-q~@*;1bcHh}^@U TԕJbbJe{psS\ZHz+[g	wn0_DFsE^Jz, Ǉ$iޓ$ēY@j,Dv1)+R&=A8֖=YuYp\rKE5=bv,>cҡh+%B,QR7bXB-F뙥ky e3)3c0&!($$[(&9JƧ7|^MdqG2Ywcfe2Lv|{\n|oEJ˥f\n)fOz`A6RA\'?Y@Omqycx!Ɉ=\n3cCBU6ԅe9-ws/λ=*ZjG(ZZ\n{^\rSph;i~ciz V&bieD) iA)N)ee20ZY)e\ZDu[P`zHR(e2(Ю(ZDSaZѴ\Zjx<zbMkCZZW3BžZ\"Tl+5BbD4j@\"/[}+R&ct)VK,i!D	cXb>mah!cԀy9)u\r\0􀗮\"<N(ZWxiq\'NŽk̛`1?\Z.yo۬*)<9p1碸tfz\'΍sd}n\'.r0ʧS#NlΧPͧc_\'N}X>LRg1өR7SW39u*E1NB]@N<9uSt4wRv퍤M\nNl>lW^iW|`u{uɫY9yR̭R<uj{:21Oj}RM\'-R.;siCݙzR<u:Oj:8? ǡ֩&;ցlG6C%{}Tp/:,~W2[<srF~OؗSrH& 2~eC>i	L_RO˰(L.]R$V\":NC`GHBi+,wK]\rD>Ңz6 ;_̧	LufuY8m !u=_<ẙI\'Уl4xSbSgy*7R[rEu(a\0EpcF\\|	bUx3jÚQv7H~\\~\nKoOz`ձ0fk4k*Lړh/Ϸ2oޙT,x@+x7([4\0~nEԅ.z]2{Xbo)} \\y3M\nMo\Z3 FEIZBj~f)曅<o½kM,3XorZY7_46cof^_[ `&vbF6,͊0,W~TB\0*}XP(TDq\'B~`y6\Z͝s#\rR^bJZrrtT_?V=HO6Pendstream\nendobj\n148 0 obj\n3915\nendobj\n151 0 obj\n<</Length 152 0 R/Filter /FlateDecode>>\nstream\nx]ɲ$7/Բ*J4DXx;̢GI9h2+숗tuu?@O@7}	08޾x#uU/!\'@C_ߜ/Wpy62`:B7ʿ^^Bx@P30q\rg^\r;]E#hSzJ_iP(\ZG\\ͱlRx\0襖\0_=	26h#=L  eMAY#I,ls7PJ|A_c8tNNW$/pӷ.W*|\"/ÃTFp(\Z~B\r6˹3\\	S6I%Uj,\0k\06ɒ}%\rF$JT*WG\0Ct֍UCÛhcF]B\0np&+[j(&҉kR̈́BKBvPL\"k5p7=\ZQ(lG`m[8-ȂY Z\"\nʥr($\0 s\"8i<[[\0TJY]vAnL-Ҽ	T^p6L%ـQ35\0)uY{G2u8X/_N(rB6rjsU0ԇ5Ku\'U9nB2ui-,AHjVyoDɇWA	\0egs;pww~Q0tVX_[W5@NHGUQUrH*Cl%?d1P\n\\-u+*w3g67>C#-^Hgg殸Rr\r\Z^<f\rm$}Nsc9dhT6qDV(	N=rzR-rH\naH=x?#jVTtX#hXʝt+]#BS&CkRc3Ƙr\\zݹy\'\Z><^r\'wKlh5Y\"dtd\0Vn\'4bHcRXE\'3_<]RAXQoԙT @%Fշ8¾BK@R&\no.ϗ\'G-(Ճ);c&(	eCA:\\6tK:DgnHvXF19Ys\r/[ϸV\\q281)y)Y+_c\n\'UeA?S]xwncL?qqLVbeZ,\n$u	s[Iki`}DggtD\rR821]VSfH48zM8ӕ.vs\Z/J{ƛ5L~\ni:P9\'\Z|1I~V$䟛JD{Tl)fL9\"Sk̔%PC%H{O}:A`0\0ݺ6·PvibjaM\\vZ:\"LZ@҇2C\r2\ZQgYߘ홶t^%	vurdm5ud0}24qHaF**\rg8\">b9k&̐?\"ְ0ӌbsg),B[ `\r&_jPRF4\\SC0o3H	#Zy/b )R;5L7?IpY;E\nP!g~~Q9h7WOΩJZWSCQuL)\nTyȭCsxJRE%IEnӇT;+MG^4vȥ71c̰]Z+3i:BymPRZ`i:BAhmv(h(#C%X[_Rr.\\8P@QS):*D6EyqY`=c\0{iQt\'=EG&~dsKuԾ~}(\Z[noI	shI<=G\rudjnx1u2=G!lvz`\\5z<X9<jF;	![Hh(7J<AfrshR7],cr(7GP;,{*M񉛣JnJEFǁE7,}_ԡKKX`TGǲhrs^?Gp9}JN9v;_BX7z/4a&>0Z#)yUVun9^,\ZxSdKװZQ_P W5fokbĎӟ+!G$C_9޽#32d]=# u{q㬎]3i^ep<f΄L)?K?_N#l6n%*t\'mRnJzyWݪVބ1,PF?w#\"o7l\Z]Zva@픭NCvFp=d<\'=0Q^f@VR	&A*=K\r\'ŜH2`7F]6Fa&l=ɳC?O8ǅqN{yw$<\'QA?3@3`N\"Hx6P$<e?plhj!6h@I\r*K	\0	<1j\'9|g6;5gM\rzJi\'B6lqyi$ߩLA꠻!I ;P)<)<7͆{#$<y\\i7@K[\ZWLQC#PUxw珊6G\"1D6\'ӑnxɬN݊ p\n.oae{ԵێIcTOﯕ&q7Ln\nP.j_WY8^֪~\062}^-&!/>I4;}jB%ӵjuxzuhJ/MDRO֡gʮ+JNCwi!aܕy(_7(8y(@*yh\'Гy%y(\"1\rۋEg*Cu\"}(, }(PcC>]9YI{7:71C]\"+H#j!l|Γ@4c SIB$!v[x,k#$!2\'	Q\"9EZ,>\':$i9\'	ѓIB$!*`b\"Vʴ/``Z\"!}gwQ|}#!_tF\"7ANMO|>PVUOH+}x,|HEɇpʒ0brwռb׬;!3@\ZqʠwP^7r Ҹ\\mj}mƵ4bBv}jݡ6߉xJ\0;db]9E6NBJ3}%1aTʜiÙsfOz`月ֲ֥Kݑ9/e|\r2M`d	@Hd)=bq|09\'8也ȜO/a94Ő&CZ9gDk*sNٰ̂zWsHMf9\\ؙ9\'@9ނI	$!aΉSG\n35g&Dg͉$J&Y&0愭%㎍0ӌ9z@\ZL̤8]FfiQ(N0*r\').0km1+\n=L\0}QAk/I95YXJE$&5		$\'GcZyU~Uy~y$`o~\'u<endstream\nendobj\n152 0 obj\n3854\nendobj\n155 0 obj\n<</Length 156 0 R/Filter /FlateDecode>>\nstream\nx]IܶN|pòƾ*Kw|$I.n;\0pXRq\0\ZR`D\nl՟o??R=/OחB##%?W\"B1x~ᔸR F$u^_-{PHQ̊wOŒQ&CH,VOR5FdQz(m\ZS\"p$ܕ%GiʃGCkqՑ~Gv\rRٿc(4hp#)%󝽇HÛ&B VH)`\"duӟK$_^W&1]HxsX)bHX:GMfHLF=\n.2BAMٶ&fNNFMomc1]ޕW!$jh(fdɐ00q!JW*#MzCڍ<b!(0:ks{x͐j:L4<eA[\rN?)w+mR \"\r*EgΐAn\\)]:	\'4ԍPLC5(UK1zj*2fV\\;7}`.b\rjZ;\0E;-$]ISfnBKPjiJ\0V5$Uc쥚P.\\f\\I7\Zu`#N̺\nifD2XM+MF$Mp\\|[j6٫u\rDF&{\Z煑&XotZ*iYc{_Eut/J΂E \"3I8޽ 8dI\\L1Óy4\" \rA{4u&q/ugAr7Bwff#?nS \0e +eoe\n:4]k%uav\0O\0Tfڝׇ7r?Vao8|\'Ŝ+?JL\'DWQ̂6;L9NNz\rߩMC)(h;q^h\\O\0#8Cd\0ʄpU&WbMBeNqY`TsuV+yH\nQks#lQODFr+RG5*nϒ\\֫QG^n\nYH\0\"n\\2\r	)6?{pG}LQpr:A,o SA6uM\'prOKif_0hc`	mt8x9MF*I$]]rf{]U}Vjӕ2[n}<#U5\nDG,Ǖs1Ak	A덥@\'nZB$zgt{)7_b-I%14\0K\\mzHKwVi,ɸU\ZK3^f/\n} O$pCpI\\.Kg刳|lco+z$Xy<~@!Co`.fN\r(ijqckCb*%Jp*Tvr܊E2.Ҝ^03t}?!C6\ZbY3UԍA\'hzmatf0R:]|*oj0*Ou\'٩-܌mʵwnԝ֋Qla!*d*Lnԫ3\ZѴU`\nSPO>[ˏ%*j.8F\ZM\r?L?3/mP7B9_r\ZwY!LXH_\"цI}	]>S`Oߖv%JcվVnsbu?;FXi]U[VdxCou+oeUCU\nwo8Z;o!-x#|3ӶwZzƦ~AZ)oU)C徕wtEo<HF.yk!IW1Ij:<7Zz$x$xpu&I@!7-X\rIqoG]\'17x!7gB\"\n;Zw^d\r\n)y>&T [cpoЮh.ƞ1f#X1\'IvSgO̽d5E?c\nG^К28`d+]޸ވ.6D.hQ{#hq%PGݐv]#*xWy7vnhvl76zڷYQsS~|GUL_YIszɲ4/kѺiu:#fx?U1q@GGIl)Qbץ5	s/8:S>.ƽIj֨s=`܍~NVY=)?&Vόsb{0ԟt9M)Μ[kF~kx_1.4d@\nE-9{dF\\hZ[$MN\\2~e\r쮘hH9ۅD.K{s|8]fTTx.wfM!zN	EEQ~ڝ , 1wa\ZS5#@dc.> 3&R![\"k=▐hP۴[ulƍB\rX\Zik07\nf6VՖd+C@%%ۉf;#	ptD;FDfk	X05\'[Z+=2_=?}~}endstream\nendobj\n156 0 obj\n2782\nendobj\n159 0 obj\n<</Length 160 0 R/Filter /FlateDecode>>\nstream\nx]ɲ4+^vy$H(Y$Ov<չGWT@}`Y跇n+?><{q!sEտ)!x|zt  )vBg℟`s$o![\0CR<~hnVgaY[gPWZŔeL>BwOP\"1\rR\n@#zPlS.}t9:Yi&Z;U*b]@C!szz~b>IG\Z,܂\"mBl6J4Do/;SroRL \nDڦB{Q?%ztnoMz>TB*\"\0THE}Bžt-	`Jwg}w܈o\'Bq^d=O8b\\{ua1p׳?j.xz3?\r\0SBoU\0[SS{{+:	~SBofo\rB3ȩ>cK#F䀇yaܒB\ZJ}[ϼ66F0M1W\Zsx)ui[1	tѱP-kڠVH%! 8}P.&k\'VeT F( \r?/{ut%K\Z56JsD$%zTB1hP3x%Ih@\\-Ƀjd$MfdV+)/L8\"&IZ\"iI(W!jL!$_D01hd!zwG8dIiQ&s`Gm\"hOI8/3XV]1o;̄1\"tx)yN\';+y;Tuq]5&-p9(ovMe\0*5\\Nc07o~\nŐ 𣬔\0E_?!r%Ud;ߞ/-VW#$TơF-e*-xwHΠ(P:\\F)SP68,T0tױº\n+ּDJs=ؓ@Dچ=5v+N,?&HNB}Xjp`Q}ڋnjs|֑[Od;۶{ඏF\Z36&`P[4v:v.yfliiA\r&uDUpSҌ`Egh 	)4m*I6uQʙZ-C=JʚWmY	UW\Z&ڬ!W\Z\nͦTUWC29.R`4Ȝ@ض) [\n)ɧKEv[:gdsOSfm+0ԳJ@N;x+M3=%ۨԷd<yQ70	]q0NpSSa$27x(t\n\nZ%ؙ CS,v8bdnJe$>̯28(b\".:D>+ˇaUruL?\0̨(lTo6oوqevx~`̼Y~(JI%eVsUOYn:aV0	Y3ZR,x//yI53#P?kEgktsֈ\\3gtFn4(Y05(EL_\\pTɓu҉D&8|F,fB%?H}vŘXeu<V7:6aad9tIGG}ڔ(fO[kV&b}ABO,:mD:/|t$TY2~)\"_MRq̬vpQ^6O7~^~}6{\nmzz/GdS	c~ln\"iHΤh&ə4M3}njO_uU<9+əl\'ș+/g)3KgəhL1?ͱ_w5s3L1w9\r<e!9xMLBCdm9w^dRnCΤA3Y9[aǇɍ˙,39\Zw)g2e\r-9C3K,:\r9}șMʙصτDTl}hx5h[<sۘ~?݇	nwM6j#&IHF:$6jh2:{Ǌ&,hf0?\nMGh`](0&y(ڋn(Dg\'(4(U$r-M26WM&CWQ4KE!Hi\"\\u	_a|e1}Q0q!s\"m[b?\'H\'[^j}ȚS12`6͵jcܓZBXqic6%kc,y{avF\ZC\Zca[iQoO\Zc$TeIcLA;Ƹv=m)iZip2\Z+#4AhW\r~hT1U1(	Xcig*Bh\n,_R\nV͑Be\\[{Aendstream\nendobj\n160 0 obj\n2616\nendobj\n163 0 obj\n<</Length 164 0 R/Filter /FlateDecode>>\nstream\nx]K6&[,?𲻠ޏTeI!Y$pw03I\r#)[m=]3Uvst\\aD*l5>io@io/OMq^~xBSD1\"<tG?+{xE((f{xb(!S$pmaaJ4-	w%g Z>Ȩ{AJ>3Ҡõxbfh!I~=c9Y#I7N_If$Q<$1V˺QjuPFb5HL&~}3\\d̓82@\n[U]_#gpyKkwsN!4jjR(8\r!a;۫Jt/;_4\r6hLi}P`t-u![zL4<7_\0HRNHQg11G~\"C7HWoJ\n)Ñ`zB],TqXS,SnŵLFc)cs1sl1W+L\\a@w%K݌fnuߜX1sD\\BTMj*C\rpfE#6\0=\\\"!l~Y?Fa.&aBF%V\n9\07m3ؖAl3|,͎j]\nvQFyadJ/Pᕡ\"*DZVnͫ΋CYhDD1hCEǅHmhLj\ZFD4ш6E ΎX7nXo\rBwaebݩ@xީAf*~N!Z\'km˲֣.6nCqPApF>=7~?,o>)|XIQ`&D߾ r}*~hqV@j#/Im\Z*a$Aۅqi#n>Li*jEQb\\]A4\n9IW\'R3ΰa-+t{R *p{$a0 jB\'$WJ3G+\'\\6񬣬tM˽pֿpCJJ\0܉4^\0wa㘕`86M<LoڠPv[:&38KD{<a\"=4aP}t8r&I$\nE5~U}Qjә:z7ncnQyAj*H972(\'AWKO\Zky\n#18qrK圾\0GZL\rttK\\oz+bx\r\0+?zd3pb\r}+БTt$Δacc3HFRH|G\0Hc=XRʠߵ(AXX7Ĥi|Q/Qی6X{qȫPȞ\".N&>~l~\n\r\'~Lͧ[?О\'_/~1}%Sߞ|[L|\\Y6,f9H84v{\n%K9IElXg\"ȫRu2Ⱦdo9j֪}Ы3Y%pʌ2yW318f<ݾkT7m\nsF<9F3ȺeZ:1\Z\ZwWes0\"i]JW-8F#̯ؕjK\"(XZqgy`#P<O]3*jNq4g\n\nr84=!l5_ жVl4?i(cs?l+9ѵE\rftdg50Ƕ䬑kjVC6omJe}v$ic^mj{yO<qq9ӫ~$5TYSkeA6)ua&LLgE&q8ZvCinncq%=VaI7I&\\Ywk[UL2.TtL2{-}45C-}eYJ&l݅IfKYI&2&$3O&OIf@O&If2Ktds&uIC2,+\'̓I$sm~d>ehd9vdK&7Q\Zgmh	d\r*)nKe\'2	q=WV-ؖ;pf0}\"d2wGdI\'LtvdX@&;g2ґ3XF&q5d2lE&Kw>dZi$\'gt(L&E0Y\Z,z/^\';z82=(L.dFuԮU-0He&LwJ)pUʶV/❣v<(BRbWay5wIX^,//UpjqSCk;̈́.5Ylno]Hcn|.Ϻ\rqRe.civ\rezM^EFYoP&I<%ܗ%w\"z%A]nV86Ֆл,q@wCr!Kx\r|T$-G?ӊF\rJMYL;\rj\'KQ\"0\\_NjB\'۶\ZQPpE*j՜uXŮV͑!sNpendstream\nendobj\n164 0 obj\n2791\nendobj\n167 0 obj\n<</Length 168 0 R/Filter /FlateDecode>>\nstream\nx]K6%ۯX?𲻠XdR\0\0ߎf \"3$$}dْܶ5Sܖ{uutt%Tk>}xqVSw^Hn.޼V\Z)^bi]뇗>/i8%N,#Ŭz}X2D{n~)EXcAFҶ2M9,pWߟ9LS=^;##޽\rRޟuy3S4U=7[H*J V4e$ǔA}0.#I7N_If$Q<f1˺oQjuFb55%,|0Wg1\\qd4j[%D3!OMt}9K/m\0Ble1抝ޟ/\naCyԸjs(\rfmf|ɐ0Мi\'JWW*#M~Eڵ<b\\g\r\ZԹν~t3$uvؓ0\0I	= sOqOI!2\Zzt5 9C\Z\\S2|8LODkTjc*TW\ZejXq,pʹ1FkaN0wڋYR݌fn]uߜX1SD\\BTj*cpfM 6.\0=\\Ūf($[u|#:wb*YˠWb5鯘x$YhA\\-+ئ,f;lV_Yr(pT\n7ߌyᖊ<.J΢EID	3IfwĎFAQԎ\Z2&1y4\"\rA{ټxNź1v^2903!t-܎Ne%US#e?\Z:4MZ8[Rq)*@e&^踓pDc7~7s>F(e0AѷO܈df!zUBtyw.hX\n#	ڎ2GMG023=`LEru!ќ,\\\'Hz,}mI2pma=J7\rv\\8sG*t0M.YGYn31Q\0no\"GƜ}\0ܑ4^\0wc㘵`86py-X=޲A\'g$ւmꈛO,Aeo	peh	Ki\nl&Iޗ*6fPeeݣEԦ+\r}6!W\Z\nݦTxW :1r\\8vNЍFH	 ݻʭ@;|Bu?<3;\n)WmZN+0<J\0B|ɦ^\nɏ,,-̘u=_RQTAE,S-\n-O;Oqq2	ulM}dz|F7gZz\Z.|lmsFҽFnW߼e̞ܮv\'ilJAoj	9IF 97ʟݼh~|6/߰FMuw&^--21䈖LqxxH\ZUdMhX\ZQ+VEY⬁jj_,8Q}֡<}!,|\Zl\n\\jx1:ZMUrVA,)ETQs?c)6mΤ9}Ӝ٦UP~Y`aЕmY!LXjO?KaR\rpbgc0{{Oklq4V꧝ve|/Uz /؝T	LiVt4+-+jV#ck$Mo:R\\YazU4+-׬\'bݼAGU.k\"{Y\". չfE6YqB͊tM4+Bܧf^XwYhȧfEZwY]?5+?5+\\bNԬhV\ZYԬxjV\\KяܹퟚЬwY>3Q[Ժ%oQ?\"kI	:(soQm>:Nޢ>ǐf/\0k6~\"G	اlV~RlE_MGh`lCV0l.j/Χ![\\lH] [эF))@X`{y5_bo2p{$?,YTSVvGb/V\rٺ{ʚֆ?lŕ/WCOPt+(gjfk\r<Hb&6ZMDX=BD{[ZvѠu7KJgPb<799`hjvH	*jƔ;l?k[\"J6la[8aF{o$hvJ\"(˙о(Oߟ.J̡KtQ,ql]#E)EH.wul?z`ʟ	 1Ha*Sk\0m@=(ꉈiN1:dV89Bvb&GWI\'Jw+ vcܧ)#*6#g45[Gגo6ܚmh+R{}	L?\"4^}݈B\\I\"5ĆDË>jՉ#Cח$pendstream\nendobj\n168 0 obj\n2714\nendobj\n171 0 obj\n<</Length 172 0 R/Filter /FlateDecode>>\nstream\nx]I49vx_80\\X\r8_qb;=ь8*?˕U`D\nl?_z*-HY{_O׷/B##%OO\"B1x~BSD1\"s{ϟ[?s߶7KFh\"pX=͕R5\r2(U=6Md	GW~p3MyHchs/nD\Zγ\rRorF%{-qem4IUQS.\0DȪGg$^/L\"c;}\'DrX+}PDG1A\'udRE\n`2E@PN&#pĶ\ZJ>f4oC¯v9;^\Z,b;p(\r1,dQSEcA4}GoF04dKlQҭRiMvC]P`u\'s{y]fHNvЛ.($億j-szLqwLqoxpeR \"]\r\r*E\'G+ |JLG-{(\Zú%ǘ\n=6nVJ9t۟pu`.b\rjR,b.)c7Aԭ$mQs<|I%)I{2$328)Ё_UH5ҌFAU@Tjt\r]aBF%V\nχ\07	mؖAl=|$MjK2QFyadʄTĄWC-,/ݨWnC17 |jOAhd\n(:DjYcRQfIL<\Zي=+O\Zq28Zu{iН;;>`@Ɏ\n^)VߦJ\nѵiYBQFyj7X(@eF^FcW~7,RXIV`$D_?!r},vh}sf|/j%	 4t^w*hP\n#\ne8U4U[O\0#8Cd\0ʄd(JŅDSPp[8,T0Dtױú+ּDJ{=ؓaeTF{Rv;\\Գd\"Ir$$WNGUrYvN:rKp;gn>r\07dtL[(;Ǭ^;ñQo\r28\"\Z4nSGD}g).f½\rv-ҵy\rL\',<\'AdpU 1UuQʙv%CJʚP4̴pLi(wmgUAq#;}5A;}YR7tg+KzOf\n푿Lk9f0p*Kpnq)ƒ(\0`GA&Ժ>#*XB״^X,NF4/0ͥk m0=<3|z.2eSF!wn-_]ʛ90f@[H0jSX;wVZнaWX\'IJLp+\Z|k=Y@lY1kΪĘtcf\\QJ4z\rF1Z\'{aP`3&eV<BEW<m.g(>]kCG^2?h=@3^-sraDɸ1Y\'Lz0Ϩ?Wb{R\0ƒ)7	?\0uI\"AB(*TV.ݟN{=ͮgN?6IcQL<{,ϔ\"96iʟkdG}Gbxsy\Z⿿/{9ƺ	vρhä.w\Zt]~y;d\Z+0v%^Ow-[!.:\r#i3i mƂ 4j[UOliMAIaRy qA	AӐwןw^z!ȪU~ZlUp}e薻`Ay)Bd݄dOY$.i!R{Aʌwyu\' uAr/Ar ]*I 9A\rL:B}!]{	uМO{x5hHksuL x\'G}pЮhו:ׄd1H$L	F 	ºE {Nh9@{8AVdy8A6΃Z׃$=;R9Ab<@ݓ$/^M:z8N-]	-\'HAٜ \nY#TNO	iMYCcMb?БSg#o$Jص29ov-P.dq\":sǶt;O=DȠs$IlEo:=Gh::`dޒ3p03H4-;IBI/|48.HA\rF3Jd=z\ndȐj^?T4endstream\nendobj\n172 0 obj\n2566\nendobj\n175 0 obj\n<</Length 176 0 R/Filter /FlateDecode>>\nstream\nx]K8k>VRB\r.,rf\raIOɲ%ծrd[J}JeTk>?|zr_+R}\'|MӯDiO\rçHP8?=z#H)q!WLDw͵kSXU?%LLY8R5NdQ)m;\\\"p$\\K\\#4#Am[	o$m_ig\'H3麯?k4풮_Es20&B$T˻Id`/$3(e]7J(5:*#D̊H	&#	\Zps#+&m+DcF:$|Da*.`;1WzSbXL]/VM1h`iL	ٶN+Qң$Ri;mn>Р-u![/zƞL47/@\0$)\'$T99ŃG$x\'nj\"jmAV):sx=X`S2|8LOXj0kc*T\ZejYq,p͔1F[aN0wZY݌fnu]X1S˷D\\BTj*cqfE#6\0=\\źf\\I7\n1\\9ᑈ&f\\43\"sJ&3\\nf8.E-+fyYպ\"\0#ZȺJ3TB+]E*DZV؞aͣCYh(y3w;.DjkEsR;רs,$f}lG^gMlxIu#>Ƚ\\eX.LНravu*dP,d\n)PJ\n޵aYBYGyj+@e&^躓pDcw~-o>)|IQ`E? B.QQx}㘌,@j\'GNSw.hX#	e*#Dΐ(2>%ՍDsPN:\n\r=:Ȱaea-tGGR *m8=gȄzk@ jɅ9\ZԣVreuŖn:#kar//ܘR>\0w$cd=B8f:7\\xRK*qrGb%h݆I R]v)͌y	n/_pOX|M\\\'/)1b\"ARx_*`_3kKF@5w:Pf\ZlBg\Z\\]QyAj\\$N79ˇto{;Ytҕe@;.VH(ܢk1p;$WGdKʹ2NÒzv[^d荈%gw~AeR`״SwY0sS8q@@}skILuᶹFS4@&ep-w-^L^*s6kƗbŦNeއl]h;K;Xh<瓶f=,$Üb?r[/fP+fYځyA\"=Ua;ja3@@0=\0V1	,[öj4to5a[P[T쟤yui&|wz*tK*0S$\"BpIB[]2n\ZF?D7\"ؤNdِBfohiU\nrKBQS0~9;;2l?틌߮\"10B+@b*+(q\'{5kc0Vn\"bS_4A\nyW{KΤ|v}p3Ps!c;n~6N|^#\rjF^ѵ+rC_^! &>W?Q%uGӟ`\\ljoI\rUvA&fu EWǑe8]҆8;:7*&Zn\Z貸-v9#qmq-ǉ\'bݰ5Vgעnt8G$Y%S++q1~,e#~tOqB?4>q<?΢M~g܋wǹs~m&S,J\rY뢟%x?q?q>3Q=cmh	cWd*)Ɔ%#<\"U^6,fk*zEfdp=8A3}9ߔl@3XצbۑW3XFs49\'Esp>(rV\rd!yvEN\Z(rTh6\ZӽU`blr{fn\rgFox\\{KfyK::E3Q1EN=h{\'\"H)r6}$x9\'yVM/|Ns1!13DΒ9XLLI\nd-Ux1BҾ\'Y_Iހsk9/KoiUZ\\u5\r_$A\\{,/@\'KLK_L\rofYmi\rKˍ,q\ZJZFgP.0з0a.Ћ6L)Γ,оGq75V1Jm?WvUV{`(Nc`q\"5j:(ɖT`HwdH\'endstream\nendobj\n176 0 obj\n2797\nendobj\n179 0 obj\n<</Length 180 0 R/Filter /FlateDecode>>\nstream\nx]˒8m/3I`1@M7L73oz:mQ.۲uS?T\n__+R?/U_⏔V\Z)^bi(\"#Ϋ׏/|spJ\\U F$#}so-lU?7KF\"p<ͭ3k6TPU-\"E8W8Ӕ{1v^#zp)axpuuy1SUw=\'[Hû*J *2c 9#I/7&1]H8bu>(ak6j5-,z0W1\\qd4j[%D3w!WMts;Ko]\0օb|˪sϡt\Z4@z0KN;Qҽd2W4;gRC\'u`wI76f)n@rB|o5SS|M^I!2zt7v !N\r\\)r]>	ZP*B5\rK1:ԕa\ZVzctʹ1FvkaN07,])R}7ԴG/\05$Us쥚J_nY!M\n|UPJd^MoDsYO`G{MDiBz%VA̜Iĥ۲2mOBlV[WaGj5#].R	IT!Ҳ2b{wQ\"R1ǅCəh3(a1h2c{CmI]SBX$G#>qN͋i^[cA~,]Bw;ont*kdp,id\nm^)ا	^tvmZЦQR펊kއ8\0	q\'|b7Fo.-oRXIQ @ѷO<G00\Z6?#鵛$\\ЦFk*=xwxΐ(2:%ՍDsPp[8,7Dt׹º\n+{ֲDJےaeTFG2+X4b\"Ar $WRG*uH6lW;㳎\rFgdc ?E;\\29)?2330hf\0.1kpl>r[4{eB\'g$ւmꈛpIeoteЂA!	M )/5uU/ʙmZ-C3ʚׯP4,|_iW-7滂щ9Gvs~4UbNj҃[\n4zҔ5RGbtFGi]/!O95;o_i棇PR\0X!1z[0KKgK*ꂊ\r͖\nM-ߔĀwh$BC0~S\\lB]z~Fgxjz>̈́q\"0̜oꞍE2TCzr91m\'Kcb|f,aͱsB$qI$I	\\$I<Tfn[k3y}{u}{{%L̞6,tw2fmV!9IV7m3IW&3J[	Bn(n6o~Ϩ?%;,\\߂Gve0}eƨ3Gd5Lc?ɒ;@5\'쐌e]8^lޕj&T*r0;EN#,<h*yƒ?=C!&!X\"/R?HC3k!;>IsG{oW4``/7˿]`.%0F?^X3Gp.Vk7wH}ۗW{P֍ՙ+Rϐ6ϐũ;GOmF\ZW%N]S\'0G:uyN]Yg%<yx{j<.vTFzFIϱO&_>3\'䙛wnX2A9r6;#i]l<Go&dkZ;W\'TQ7Či^g\'S8^=v\\NR\'Bg?>&Ϩswʗ4J<v3&75yjdw\0E?&:=y6ߟ5M[|-MI_SfXT4yFeNMSVVOM%OMo?;5yyj<8j<oY\'s#m9k,\\6UBspvj<j,̚_wyC5y,I	\n<TPMjL:<{T%Mϳ>Ypya.OqEC<My<wAyO-OMS籢%)yjڧ&>S9m|.=e	NGs񀏃z<,)^3;j,\\MZ?1Lp;[;>:ѱy{1gfL~;M	F#Q:gc!3B8YC6xXIj.ZxYXuYn~6KT#ϙ%laĐyg:a{\r1m[}u^[-?IJpڨh닱.x\'l[rP\ZM\n*H#\08Qnᚹ2NlQx?Ŵu{8MBRMxӧ.|!{ז 5\Z.1Qvmf4xһnM;۶RYs?\\DmWQ\na\r?\r2[Apٚ9\"t^(\\\ZbnF׏/vV@!͠ח?suendstream\nendobj\n180 0 obj\n2838\nendobj\n183 0 obj\n<</Length 184 0 R/Filter /FlateDecode>>\nstream\nx]˲8\r\n`AOâfH~#%*LuҩB]~7.{}1JqNo/ڻ_Up]QzyURbWtcAɑ\Z\rW-d.*krySs1\'8ۧmƸe*ŔCqߘ>VnVHLR\nC\'GZV`[hͼZ\\H&nKO$/ҿNkL\nԈ_#Nx#/I89~P\\ֵtQDr%\nvKjᗷ;Sr/RL݃H}H7W򢵏(I{r=r&\"\n4 ׏jqIT5K/&@\\iޏ`BKbJ9.\'˅\nPB7_pl\r\nĨAvۚ휇7#b+u*)B\n7SSt^aITh7-:i5 +AVV@)\rmPLCV1TشҴ3zO>F0E1WsVkSݍ4%8v-nu4ִ.qbXbjeĪQ@~&\02^\'٣Ds@`G\\QIs|% $nK >I`V4 a\'	f2s#*fWRE:C-$۟QvBP1	!	_5\"RqENĎhAҘ\r5Jd	L\"ydv,\Z`^ buvΗc\Z+DcD/NiY|dBw}%L5[G;Ukiܲ΍jT\\:G5P)/sw\"xNHg1rwC ]ߦ_\\Sm(e;DDKyAʡ}yrx=soj\'ވ9L;6v0PưVV_\rFqG`\0Bp&_HUҗ5B9]OuwEXFXGX)/ɪZ(h0H=B$Ԛ&@f̜ʐkc_{6۟wΰՑ[ٹ2:\0,o_ຄ=>0hg1ӯ಺=^ Q^v:*tw4[dDDG=\'$ѡ\"8AbxM>g3k-\n5o^UPF\Z2e!ᑆ&n8<U\\ĐwJiecѯ\"6h*9uRɓ|B~&gp47SV-%\r0t&iUg4/Y462\06p~Ltn.z6PTD3g\r,-4.FnMda@âټѺBm4zyFvghjr3\n\ZCO={1a(@~#9r0[x ][fb=y4IbZ7Mqx\\8Irw5nEr|^\0w$X6)\nmĔ#$ЙQGو@\0&:=6Z^#ZQ:=>\rBD:҂̄oﾀhN(o;xMD7\\Zc!gm$Hn9ظ;6\'B橌\0lD4¾٧FX 2pO.9skd*Q(SĂrPE-V[>Zp9טਚkT77\r~X`u+AݸMKPug>tokM~o3VX\\;k\Zi|]J2\ZBArTg~w3_0^7@Bmޤ\Zav\'-(jnFgM&kQl,PhteEV=ԙ*P&%A&@xxը^\n,j6޹%LѭрC.XzwڧXNir\"0:xKQQ׮J8&X\"7`gb	 ;YJϟ%òdޞdN-%1dL>1~LH|\\jrωTV@XEWt(,E:hY0wM>9tFtbhqHr&h^ST8-0eY9{u蚌OW}-3Uel~^G\r[\rNTH|=%K!QٛiD|Tܷrw5&:9)0n|Dq-n\"\n1)i<2^BÜ**=UE76rJI<Z\r.C%qB$C 2P3\rJ?2\n2_X<\n;Q[ƛ{Tnd!7p(6s\\j+<cG6;ZlBGʖRIG5ߦ 4UA6E5	TV%elH*	.&g\r\ncT+`VOe#WOI]=X2[骧<-йC.M1iq$bnYѫl;6GAo\Zqh!<&KӵYūCY竺|e\0\rcG}`h{Lwcf_\rJV$uڬfUVq}\\iv)A[	W)W\"HV f	3P	^L߭~O$3Og+p_(\"=¦Lb	}~Po79ߘxN9c/φJ\n\\$_, <\ZpZpn1M8uĘ#OLOQRrgܳUJ@OV\nG\09Ob[vwt~pQ#Z96j\'b*K<[?KD\na&RV?x zx~UN}{ϸ{mrs6.8	J˟{r˿rG2qԱ	,@[A4$?\0ΗϿ({Ċl4v>zy\r(K9mW[o1!2cruhT6Q.,R*\"R*!CiYsƜ]:<=4;9;alٙ:vʹ9rc7=yM\no+D,Bӿ{<98\rcșsᶫP\rVfA?ya-tg	[7Q-D=c^	gƛ{iqf0i\0sUn-<E7|\rܷ|}DhD߯t3djBU[a	Qr{%?(_SKUvVՋg]ڲ\Z0161D!ϸ-)D&su)l\rNJH۲7$ȱsR6DҦ#מ_Lc4)eJ7f	mQ-w*]!⽹k%Uuw40f|1օܴI:HT+\"5PIMpiz%Jja:]խ{s{\\~yLQl2<5ӟ\Zcuek<M` ƧnKɌ9Ry}f\\endstream\nendobj\n184 0 obj\n3852\nendobj\n187 0 obj\n<</Length 188 0 R/Filter /FlateDecode>>\nstream\nx]I6,?\"<Pł%,H(h Q%kꮺ~dHәcjX?@w[˯D-âzEP/5 5!맗oXu2nq}OU/Q#Pjs}3s8.#TTe-mtL3!5m`B)Q/>rzDj[֜JҷS6TPZ_9M?g hWj#_T\Z|]$)\ZZ\n\Z\Z\Z,Iԟv5@@ʪG?:Cuo ߾?x\r$EK<TL\0 E2.OoLR2QQ@/\"Q*~?0XX5̉뫠&wz:ڌ<ftgcp4Cm0מ޸fu5CBd\rp1\ZfL^cwМ3-&9Yu5\"9Z8\"q|S,B\0OG)49xsPA;#S\Z,(X\"M5\0Q\"X0j{:ч;! E4!X\0	&*=,L^̻YݲY;N6\"<:#F\"^,i){L*\nşfv#k@hnύ;\ZAxG_)_	OkH!&\ra^ł\0xW)nWY*$N`D$E%LA:L\"_2d,N e\rX$Xp\\3*\"ke\ZM.NR3zI?&;gv+488q&8hp/̮Ђ(y\Z#fe1r\0uweqMPFPO%59r]>9-BCᩴ65RPPii}s[x\r~0\njsCP~|vԚ5nJ#P/GR3LY\n\Z5qF7!69a2aX4\\w~&UZeޝ~m̺%<oGpZe?K	\\!Qi^(V=QOU,C%Ԇ0%0	w\'$\Z7c:;A]fMK}l1;;ǘH%vˣm|*GE*JjBo$SGMrIYƎvnkE<\nf_* D!`PYV &΅w\\5pC+f΅\\`e<>(%j2MD~PXy/0TY%24(|JG8#iJ	E%@9d5N].Br\0H@#+!64u\n3e3PB:?#3t֙\\	Ig39^` (tuA}\Zg*q>\Z\Z,j3I\Z6\ZgfL4΍YLLG	%PtP\"B1!BMZT#Df[qאw6Z3ۘքg6?K{	CL6ZvNd	.Rt<)Q.TČMNU| k~GX^X7,[0ǞjfBe4$sCڜ6t:I[2ӭRIe0{a9v@A}kM#BVl~B=1}{W3q$oS$/~/w5k1Qgw]M&Ph.#7[\r?P13yS=o/k*ۭ}h`ǻu:iRl:!)T9a̎0VN3/ś3\\JW	hhpU6㒕3-sޏV*bU9Cvdh+Q1a(p(\"=Ӵ	%A(bdq#Ce_+&\nB,Uz\Z6[Vc\ZY,RbQzՄzTHdF7w&\\TuUbedCT]9!\"R#Re+rB_j	.zM?_xF+\'$3r\0rF.h櫞&vI{R򒮛-BVO㏙RHLP=)*(N[T\'UP\nl[i*(\\V&,IQA(rUP(\Z^},ꌝSv+(lGŨb|WW3TP(#ФTP\nߪWP**(h<~	N\"0x&:f!csaEY\r~:VI&Po	Zhǘ-4A\nk=l!czD3&UNJ2ꖠ\0HP6>,-ݔVVˌI;U-z曚MPMgW\\%%rBxJ^sAQ+WVEDbOɦCު8t~[}FG|âr}Օ殾)(v^\'ar+);~_G]]7f	+w @CmpȵJHRVW2ꡒQwC9v%nH\'uD`S<W`7SUG6Yf2oKy]by\'/ϔX\"Q:G(HkbzYBnF\']Ȉw\"ޭO0XΘ:/\\4\'ChM{>4O˭S,2CQtZϙ7PY<>g9!2%kl᭨\re&}>BpfF_B+9~>nnL;q6nKKxl6aw@#	\ng^6grG}ٜFC[{dswZ9ⱑ\rJP~#^T3bWxbLΣƙfr. ^h<397f#LH4jI܄<Ss3\r=Jg\Z-jh~UkQSjҁ\nVH֕uS2x*o9߼A?endstream\nendobj\n188 0 obj\n3071\nendobj\n191 0 obj\n<</Length 192 0 R/Filter /FlateDecode>>\nstream\nx]K6gyN%G[2U,X0;$@QpCleSVj}n`͇v</]>}KJ/\Z5R2}y당b_ň뇗?^i8%&#+xmO0%\\#1~X2pl\'HHxAh4oخv9]#ޅ~~3MU	4t_i	߈xvhyc* pD6|hOINQx\0&Bv7$Tnwͦ!F\r&\rAji/%ᒑykHjdcC!MCsJkԬ3F/A\"8~t3$)\'2R橂,Nx)6\0\r\\cs$ks]C7K@=ZŠ6Sжk0\\mu(ल1h5Pje1GLSK|	Y	2d?O9_%0\r]\"&/`ڣPrF0~V9;5>_5frF)/Wڛ1Ÿ`R	7&\'~)r,itXj0XS=!8[0Z\0 ]KG\0	NX^p)7b#J\rG	RMw.02Z7N*W^Y\\C6a5k	DF$W^ϔn[II\Zʝ	?3\0ᇫ~\Z052sÎ%<ᒡ$nhpkH˵!g×ݨp3,=tW.#qoI9,wKJ)\Z82a(q@Xd>@y:y!g\n0<]>kmˡwzP2K]z( hV8{R&Ķ|[ZfU\"*խ<UOmgroslәncvB9(%l4JgfUr$,N;Ɔl`jGߡNDL(i}U7IͻjFc]dM:ַẻ׃7C!\0=k3bcAk!{1o[	JkS&[ĝeյgZ+9Ee$焲lS(K#{Ǳ\0Z{|yrgbR3!7.P`({tpqO\n=,pLS|zMC;8+,>ҳK׳W\n\"7qBQI$p\0K}+0=V\\R\'З jH#:Bo P59BpD_DC5pӗe9C0mNXpjt#1;#;-R{.\\xLsAV[]9[{&$otL\rW-]5v7 hAv\ZғNfPFag)IuLɆ소M\rȤ\'sm-̸q!6L-`gmKFݚum,Ǭo8\'+KK.$Z^;y\0QЬϭ&w2a0eYI۠,ty+_?Y+r1Y:=%f*\\i*BqhsCp_<и?[)t@dצ?股=&R!i%g~׶E^EPzD/R,2sQb҈4 W7f	N4ooΉ.Iz:h!w72A&t\rUF,.4Zx[>d&QHV$\'شN85|I*͗1Ą\' bR:R@=I~vH6]\"GȃLpN:5dh]H_}iX}ǒTP;Bvi}BKNk[Y8w֦{>΅5P*\"s.5Bͅ6DM~Ӵ̴-Gfea)\Zj1(\r$H\0z%ٱr>ٝk:еE\Zb\n]YΩu2wn\\?:(F_)A}%\Z|sj)|NOJ*ϘS\'3/9u z,t~X|H63$(+e;B9虅JଜB8٥YlB_Gvw7ƚ;] M.ڥ2\0XHaH3`x<s\\%2{\0J\ZC68p*g=[=z^|9ͳzN-{E\Z-Xw|g؉\Z D9Pj&0IzE+:	U<\"K\nyҤ:zln/jGyp\"i\'HldrmMbI梄Kt?H톂ܕ&ׁd\"|dw=TSwYe;ȽLJ+aSrO?63dZ6[P*\nkQn^W%?,$XvCfB\nRB)N!EFd\n7)ܳXvyu{bo\"irS8YyY(67\r}Fw|s$T`mSκ%D9iF\nk.!o\\`]kHAHO*AӁ0/::\'<%Vo$$V\'!:=3-huYT֔ʞܷV8#wo٫*@΂#P[٧U9+[εA#%-|kW\'pp1l&^P`ş83AY̮\rj\0k2)ɥr\0^>αFbwfr햂CW`\n@;gORRuQR׻`/+|EfnscMM$xvLޤgC}F:4f)C?d\'LT譛>MDT\'$eC\'\rۡI~Ҡ2<h\'TPg=)9}O[7}N&lX5p	yWRi6ˋt5h_+&,:⭛Ch\"sp#㜈W򶇶gewe.D1/_:fm@\'>Џ$/.}~HUoXܘ*?,\n3t\rC\nUCNpU4-yrD[\ZJqme[<~Cfϲs#Rz\"3\"V3tn;}s:Jlմ00ջEw5/t\r郩3@]cmRstAk~Dzu[pmaۼ*jK}~Лq4<#0}?g~;z	8Uz7r\ZN[C~=m9<CwN\\ƑOHn}7|!grt[ie兣tחÿendstream\nendobj\n192 0 obj\n3649\nendobj\n195 0 obj\n<</Length 196 0 R/Filter /FlateDecode>>\nstream\nx]I$76Xv\"80ax3SLUNuLDgg\"{OR?^0\"l5?x~W?^~|!/o(hdd{O/~{	pJ\\M F$W[w^/ap(=<gb(!So8Bw\r2(U69n(DVL՝I*mtqZ^ˑ\Z\\Gi}ϥHi{-6>޿Q;)ax1jTt2$\\i^Lm3E x.HrJ<\0!~uH*׷RήnP+$$h|9bwKPJ2䷓p;߁Kd`mpY(Bh;9`TpsƝez3!F7N)^\\`|OWRDD1̐L\rwK\nCr!\'b M\'iP)bC,chYڧ\nsl\\=ܺ^)D5&S\\Zbdr\"rZW9qA?FK{炂@Ti@c\rB/6֗A\r^딵W#FQ(Ǻ m|$PN!͌8P^aUP^nʑL3_F$6|\r	VD`vZ\\+D_hƳvȖ3M\ZdùZ3QBkycMmk1]擢Fy:G^@z<|2-2>P9̣b+|F\r϶b&܆p?{F*npR[kВjk22S/K҅0f0pu힇C}\"Y063,q!RaQ@Nk*VZa:ʨ}>V&Voj7_oѮ(?\002k~R/bEx#Cue8<4r9t}r~6A:(	E@\0:]\0-N>@둱m#lSIB[FFӦG j#P\"Y=8Hn[*XL`Ȋ	L98[C2U$nWU2&QMf͉%\nm%ZZDGgЍn\n0c<m7mi+т)S]Ne\0t\0&\nA%%`)pu%9\0\n8+㒊W|dAHl*|&	kJTVOI\Z3iڲR\ncLM$ `	`\\9L>_	Fd$%\\W:rh\nREkƄVaR\nrR45\0ܪqnRs\\MRq]{/iT42(}a-S]7>Ι~%xǂXZːR\0ߓ&Fqe^2eǨuWˎǥoLk#kAd][V疪tosJUE* jG9,UM%H{#}`D5.V*}_	+&/d֡ĂJX:٤vpf-jHG5иMahdK\\39ãyoIR1.5KoRlb\nV/ϧ9vZNT/YC·H_\'W|wQE >w7PAfZŠY\Zg{+5lPq5)6`A]Q*_͕LǪ-^4]`]YcB9]Qbbą74՛YF2r7hPwiT]K2WG!?8B%R?\Zɵ׍90]\ZVk]uaa&\0.\rV[V]dLx@Y`q@H7,mB̓߅ P\n(JeCLh1lWKAC\\Y9E\\YͶdQ\"֦*Stkz xLU_\Z90e(l*q:k(ILZ͝Qs)d5~s!ݫƆ9z%x\"Ǚ˅\\X)\'\\SĹKګ8\ZJ7O\\u\0v:D\nl\\(;f3gkx)_W\'Ȗ&,:J^ОZ	^źȫ]d-ѺhK`\Zޚq!](pM65bJAkϑW%TEbPI*H|HY$։Hy*$~Ib=I\'$Z!2sHIb=I\'5@bENݴ7	\\t-[zXOF1ȡmR|KUcΊT\'&zp~l*\':XI\\=qձYO<]G~{+\"*`vyu\n!>Hյj_	ı<!y\rbS	y\0bߎ/¦=MiE`uCDykgYgL:4&\0%<RaR?Xp}_o6:X۶\Zaevg򻢈ɖAgtkvd=#/;\\rwa]ߋwt>=.C.\rC3v{\\tLmw\n*tKSg\'U\n䃍ۡIimPvOX8;qyRE\rBI.|{\\qMeW2Y(0&om)*h\'ZP.=0QxUZv=p٧J].rz`n+Aeqy聫$*~7$==pY\0z{7b.\0H6Epr[\nK,\0\"KoWUn_qw!4MQ<{ˣ)wnd^f	:eb`&\r9eIlH4c	g9YRsK8V2_P\ZE\nߘ\"h6{ˈ(o*<E\r҆[.ƥ\'zU>#P돢:zO[]O+Fw#u@}@f[`%\\!vHpy]ojȐ\Z{;endstream\nendobj\n196 0 obj\n3141\nendobj\n199 0 obj\n<</Length 200 0 R/Filter /FlateDecode>>\nstream\nx]K6[,?ew%C!aA&J	s,˲dݮttwg||DNi~ew/_|EI##%ӧ_W?CD(F^?r%H)q&LYwԟ]?K嘞^^,e=d\rGAFf9\01Ҋ˕!IWyӶw͵ҽ#Q58ӔKZI?R0}/b<ݠ	W\Zix}&jD^0J~*CCF|%bwK^aIJ=+O2Ҥv&3)#PaG5t蘂2RiΟ!X4V5(+5h7\nݫ*M;kH+⚑fߊx	k}Qa$5&s>ss6e-9G3XcsTH3#&z(/0jR^鸤Cc4q\' 32 $#Z\'!$KFE\'cc(\rEATiCW/HV RObe՝Н\n ^#1rk4>eCiJf4Ls{2C)n E@ȵE,StQ;q.sonzo1W\ndaͫojQ>GwH\np\r;\rxfY;k>^AQR/75fZ\ZgfgT\Z*\rm*mdZ idSdX8ƐulbFPiWhPB22|6h4ey@ܡ߆~7/[m7LM	Bu܇@jTƈ\'iqlHR\"Jg%	!Q28Qer2*[) \rb\\d陰i}̶%\nmMJ4ɫ)l9Dqmz-glR3@@D;\n3دυ//m\nxC`eDbAN:2U<=\"T;4}&f	kKEYE+as`23e3iڼRHCkL䙩ռu@o[Fir\'+5zOx=a!HK\Z*vH!kK!gC2\0{C6>fb(D5I֖$ 4woL\Z*E54rr_?_\nTG9#ÊXZ)!@Obf8iIPm,,u;LOT6uCA.Un}pjJ\ZTܞU?ej,Ĺ\'01+.TnpuM<RfBJX0y 8%VTy&;44\ZXLyh\\y&Y04%ݜѼPWLIĥ$)h.%F	ӝ)!\roQ_Nөd19&޸R;9Y]ͅRD58;g?]*B8=atf/chAŭiN1:X&R!jѶ3iHzo4РJwݗv1vwF!\'\n_4 `f5\Z	DTJ\nan3T^zlpu4bql-^\"#ʪ\\{=Ş=Ȱln\Z3.,&jV){ee`;W2g[zU3%4J`&Ϝ%v3Z`GFjZ`8(gi9 ohg\ZT\n4BhEQ_!6k\Z>\'G4t[R99<rtR2CJ0<@6vb\"u>-fUѿ9g]|n;ʈƘ7\\½Wd=XYFI@-ވsu\'92RG	rð-Ǽmn..Lib@Sn0mDRV➕%ͻlq~W\"9bpw4yj*1@-p@TZ58ATez*TSbxJtUQ\" XؖppѪ[~\'qba&OC,\\RiFo6VTX6vTx\n7A\Z6^PuHhvsBds\nB1~dB!./\':r[A&?2Ȅo<d][~y+r\r*`vp\n]d\nKվG< 	)PM\rp=6-R:pϏEBg?{0w{[KzCm7]`ALX\0;4E&\'ˈvkF\ZŮy]#̮i(beuα;Xvޑ/IVtDL\"hoEj{iXZI\\V<&Kker\'bKҴB<`ؖ wR!@c~ut-@/IaZ>f,`lWx\Z窬f%uE7>!o+7%\\vv6: bi\nXXЫUzs@]\n\\$ZZD^q(×ZI^0JTָ÷Kr9ߚo/sRK`15Aef	/I:.qOLwY5NN/)W~<\"V6Ie\0\\ۥE\0hr\0o!Zi._cs9`̋\'ox/q;\0ˌ|sv0˗5$׈X<[SWN8VF6L&[osF6ycx|<	qiÍWqC pos}Rz݀W7sh{=箣;}U=ZR?>5gpC5pK:Ȑ\Zgmendstream\nendobj\n200 0 obj\n3121\nendobj\n203 0 obj\n<</Length 204 0 R/Filter /FlateDecode>>\nstream\nx]I$7kXŸdax3S\\*;c&s}/>>U^w?~|\"/o(hdd\'{OO~{	pJ\\M F$W[w埞KFczyX2D{7]w0Jշ58nP#;r3$Ŵ]s^ˑ\Z\\Gi]ϥHi{-6=οI;F)ax쟆1i\\t2$Hf@4Q],P#x\0&B7$TonwM]\"0b0tq-M|+atWHN|z/1MfR!FdZD;Ac\nHC3WǢNnUÈ2`2G)\Z8CF-X{\Zo3FvYUv\nL#p\ZM<E<}\ni;\Z;H\0kL缛361fRc/#˙ex\0uԈZG3X3]A먐fF$Mkh9ʰ͢~vŊMXg\'>vo\nM\ng\'A0Sj32sD$E2]I \rSND6ϝ\'\\M<d5EjF;ѝS1c!7Ӭ\Z V1Čjb\"\ZǦ/xcrAۅq_BaЂL0&DE7Ꞝ-A5\'^M5`a<-E_h[VXf&{\\ޫ7nEuZ\rXowZad>O0Gz<d\ns<c>;)ܚ&ϐZrcQn^E\rލhsH59NHz<&h\n7~6}9rPY7Wm0|J/Ōlt.#	\0:\Z=ȶDĜr4Qh6aUUtQe|UMp*[6!%\"6tCZ]	qLnggfy2(Yh6r?Ii8\nﴷA[iCF~WF{ߍs4u(lJG!bb\Z.-DpZѝ@?%sZJs\"FB1+c$By=\\b?r3õk9s$yjm^OFNS&ռBgp>M!\0ȕ`ꑡQ\\~T_NFS-!G\rf4ߪ1⠑jUF(ޫ\0ܪ~ntg&{\rʥ9;/GS#	#U\Z#uxӥ`Nu1Hyr_ZKb\0ߓF8hܞVe18ڼբiz:bw>l5qC\"~֝^[\nwSSUȒTTd5#18LU%\ZH$\'Fz\'ƩixT.9xg23+ 8l	;f~0FF65R\ZVIT8vlk~F7gx0.U55RmR<Hƥf\ro9.%T6	ӝ)!s\ryIݨ?ԋ@a2χ\'ԮV|wQE >aW7PAfZў0:\\p14V\n 4յ\0	T뿚+n[ə4OU[$7	hP;k[}69ƇJĈ\n4 Wgf5\Z	ȇDP;WH3]Fh$h ZHDGRCU))@3rWQu1{\Ze.,L\0!jK	؄I[){g({Ϣ=({;j^h\ZPҦPe/)y6(R.LзEn{ִi|ԉ5m&[,W)_b2&q\"6D?9x[s]NH]KAMrfBuGO(9ʥgK삥dߜX9H[%(ce4^\'UVD(μdҚKHk7YҚptq]9	qlW%r\\.3,=}ZER+qb{`ױ	p(N5/d{%N<N_,I#ﯨGޟ]~NJ4͖͡]YP789\'m\Z6Ngb~?^%E|_1)ܓ}]q9o0S˯9~\rRz\\]H4̩9[/vA/6&V˽R5UW{ؔ};Ӱk&et=_ת7%bM[3{bZzـyoy@q0a+?)0|,aM`UY7j\\m?wv23{+Q#~\\\Z篞Q?!WZWEKջ\'+TZM6k\\F@\Z!/ODZS7v1x}J^\"u\\ǵ-%;5W~TcVI^x`} dR4r,ŁTĴ21\rm	\ZBwﳒ\\ńٗ1xk1- r*QcE\\__Lpr`yvM(z(AEK8^ղJ;I NܬHfg䐕\09\Z!\ZDTeIS&\nH\\\ZzI+H-R%H͋RI4I-!H+0Z@4;BGh\n\rh䲈#$G#=,!l\nn&wK%FsN=I4&TgPpJd*[+U.c^J\0DH4wV&ѐMG^GB<YdUjEH<rw\"2¥|4$ҜD?N::I4/fKa8I4\'fBhIy&\no5|ii	/wF;7hI5oB.e):՚] Ȑ\Z{ˠ5endstream\nendobj\n204 0 obj\n3149\nendobj\n207 0 obj\n<</Length 208 0 R/Filter /FlateDecode>>\nstream\nx]IF\rnb|0ol¿\'Kki7SRVWYUpA |yuGx7Ͽ!*-U__̵wV	<>vǕSoXPqݑ쎾uW%<NTE\"{OłC*qn9+dZun>in%&\\+/obTz,8֚RǫGM?X{*n\ZZ^s1P^ݸWafn0u_P%0۝CW/n0>XW\\y-!ע¾Bߊ%Ֆ[`I_TTZsv\n ZZϭet1@Lt}R45ƚܚȃ+%M)%	,<ucëH\\E|JhF#T-\"%Њ}\Z[PN`b`V0F`g3#Q..4SLI3&O$\'R䛼GNRTs%J+dG#QWׅHTׁ]O\'&,.+$|T~d&tĺc\nD\"U7v0tD\',7v|\n:N:e%]6m&Ffft{i=4\ZX.L2L\\;Pg7\r Qs#\nQLn\\[1z	qݠE/;k/BLl	K38_@gx=R(ӥyb}HqN#{b?^0Y fw;ItL<\Zޢ\"q\rW멷z+Ȧ*s?\" m[OwmH6i\Z8Qa@3\0hsxYh;Ə	x>4&g1yIœ!Agp@b	6љ`MkcEt캃 $]I܅}%^5,Ii9~Mnoۦ}]7*IFnDQ\0l@RG!QMPU812SpOդ}24ǃ9P&Ͳ\0yIdayoJŹ~O+9͔<35WJ4?bT/J\reWśWji(\"33+u@Q!H\ZcW:QW)\Z8xU\0nU?\0WYq02	\"s\"Jg	K0uOU$VQ#b}sQd׾MZ(+)R\06ad	S+ d,\ZKiDV!Sit<M|g_AN!cwqe`LW]RFͳRUj#@L2U5h#INNSCN9x3adڕX	k}6Ʉ|adJEeM9XHyHXy&Q52)՜aPkjK )7.%%	)!s\ryIݨS!E!<φǤ^jV5$?C`\r)|0gS\\riJ`Dܺ%4ʿ^2* # U}\r\n`NhGȊ nR Wg5\Zqȇ0oi+Tj۪?_؟x-c|$[H}K4*^7-瘂^=|>jNuمW.,\0?WgnM}f_?<yevў[lDqhXW^߂bv:ʒ]Ҵ0oHeT63,\\\nS0cab&Hê8\\\"{vp88-V*N9KWy%ՑjTǄ:jPaΰS	x|Ʃ29SBZrMǃN.ԥbSeۣTtH/+2>iw*sֲ9j:z3BS\\j	G=i{I$ӪUm\\-WF:iNlP\"OZ)8uaQDN9$zפ.W^x~)Wy\'W*ďi@m2j\nqRNjI94m>fb~*ˣVj\rӪBM2崪<pRG\Zhe굤0j2M$SD|B,îCz*bjܗ{	q<oV	bS*ڲTMcj۟tx\ZoTD\Zg#QQfP1ҝF3 pp@lzhTH{YG?~w3ީBE4c߲넑ٝ[IBHr	s\'\Z\\֞\\kt4#dFfRF0\Ze]fobfBm*gD:.dנ,X[Yed)ݷ`\Zŋ@!VC:\\Z3jQomIDq[dBC]v:Z&|xQS:eʍ:vRI>z*tńtDN|Ǌ8^B+\Z[I[\n-4\nxU&:R\\k:cǎ^K\r]b`F-8o4=vݩi=U8KnKoܲqk/*x>g\nn0x\nq(z40ez^>?i5o̻˫,]Ȯ\\,b(.vfPbdx2\'e5DfmIVv|y!ےgɯMYweݘ^Mt9.%k	@Og\nu ,%SP/#U[O1\\ZH0q^,jeH-Ͽ$AG胶/hTk]xJ)%#kL񌾩endstream\nendobj\n208 0 obj\n3030\nendobj\n211 0 obj\n<</Length 212 0 R/Filter /FlateDecode>>\nstream\nx]I$7;.k_!\0c\rs3@0\r\\TJ{-]3#^-RT?\\P/}byGxw@e7/_~CE5Z.}1aLP^ow(8ůW6p^/KjCssJ7o\r2wu}ڬ1=J8\\+}/naT{-i8֚ҡ9`gk?v^E}=\rZ?Ьoż3wx\0\\7\Z`_J?X7\\ItKH--H~\n	-^$47;֜M!j(BG-mBis?3A@L\"9Rijn6G\Z Vf.n޴R<kYT6\Z7T]\r6m!cq\"%tmv\'ϠԱybcjVX g3鳑.3S7ZJ_cy7ѧg(iq\ZG-rTs\\\rG-l<hme\r,TH֔w(ȴS̙bcЖ3=DҌA3,/J\rٍdAΒE>0Lyx\"vaop`SDAT \"x\r\'	Lԙ]9xgPͺCqaZ=xyX\\aWQZKc\'0!9\'%}xA8h[~\rn=<X^3-z0Or3СZ:Gִ!\r\\Iڪ1S92, 2n7.Za\"MN=@mW5>ף2S>0er6x܁|o:\Z7	W;|kK,.&$SxӧLJB4r<0M\ZԸ6>бd_`McD|P\0Nt73ڦ͛3_8cƕ:cRMR7Y&0\rJ?} Wu\0aMnu{c2],D<\0S-$0A*1o0\0.)O9	IOx0Ac<[[B!Y>yhڢAM׈R`Ȼ-zj[[S(w)eԌJq9M#Fm/O.nWn\Z7~	g}(u@Qfc7Ԕ/uRr0&\0rz9,`+	\"K\"Jo	KÔ\r#aU[t,\Zo;Er#>9(JJ0aai}A\\}c,L)EeAbq?ƩT1`PR㈬IUMn/JU\0IPgj)ѴG2\';12:1GNܖQN~̄\nrc[WbE&s^\'%vr~s#\'́KT8wLkyFugX4.l׆r#%qz[RZb92?k^NՋȦ/Ǥ^jV5i$?C0w7\nN8ZޜEhp4Vj}r못SJӸ!뿺+nZɨ-\\k\0lB9ʦF6a/t*tSz#0x5mшI CJEw7@\nTm\Z^mL7eɶB\Z%>h\"͐s90c/w[EX!x.5dV\n,mYZQ/`iE@,>s3ڹ5y擥uKɰՓ(\r\r۰bAckN\',lפ4,zmO%O\Zq\':2>REoG\Z3gS\nnF..k)\ZX#ᆂ[x\'h/=Y_I5rˍZə2z\\zF.ș\Zos|r\'Ô5%،\ZXj1&7ڊCΐh,#;+|Q0XBTH*$K%%t6IU\r%j?{\\WǠʝZacPN#NEXdW˴>տ	d̠SQ=iTO\ZIZmL\r*@CҨ4\'*@q\"Ӵev[؊B\rtAIzR|Ss_C)SjGMMO>RbOɦOL>5)+<SNMFeucIO}ԩCD4MQ8gN]8\nS[S?Bl*O`S<\ZjcP!x6AU޿{0\re~ߺ?|zZӌ3rv&D9\0rShM428[v}x?T!#/ashٝ4ThXLq~\nlxMSw{r\\	f}i<C>6H)sE,ZOKm鼁	~)QSRS~I۵썺E!y^&(j>WgnYw2\nFmjlT1TdOhocI=y&:~d×+6-\'NpMXlޚ@NyYMg8Q)P\"DkNm#\n\Z̪|5[cH@$ᲡT̥R:k\Z/!,i?0mWбhRժmv( sfYo\rW\rʇ9%6c\"ϭ\00cěF+qHߕCJx{B3D=QWmw#	[ʶn$\0X%m6q80+b.tԁqr\"}^H]6vv^rEM2sJPkpll/?Q&h?S$U\nr(v Н`K Hф[Ě,,m=\\/X8rcC]G}#Lڋ%ȒRмv0$.֑xoΛ/|op<6\'_Q~W{0l{1e-fݨVWlH>.2r![v)X8|(h_anKybūI3wp#WIUQS}mX=+/ߍ|ԏwC:aߴV5thF]}}o&$9Ҹ_?^endstream\nendobj\n212 0 obj\n3282\nendobj\n215 0 obj\n<</Length 216 0 R/Filter /FlateDecode>>\nstream\nx]K8^cUVXpX aIVɖe[5]QnR*ˇ2~0\"?/~{?ˏ/U_|-FFJ׿ko\"+B1zw \rą\\bD2y#v?zO[BbVn2\"͍0ǴdQ;.8$}$@?rę<V1kYd͑OgQ?\ZG4Oq\Z!CI]u%<L\n$9v~Ll#I_]oqvU?YaIי0zfV?+4l|__oL\"csCfR!FhLL/Ri._!AݵІãkeZnTN!R\'\"\nHQߊf%^$F1-9X	M#HW1bħeV7\\}U P\0kL瀜1$*#A4ݔ䡢dX}EYT\"]T>л3TY(85Gl\r;nk쬞؊~6!(7<K2\r\"kj@gc*cS\"E<5Z$,LY9dU#D(`.CcgpAAe/,XyCAy\r5&1Y@Qkߑ)e\r:Bvvq~H,hO1gI\ZsRl1Mh16]_o\nFa\Z[RL[n}IC윍2F2XVJFTiya	xB[\'ŜSlG#2FϩPaHRf=50nOU!rU:ݸa\Zu.%wG <Z5PBŶ\"\'6lcIfM:ь]\n(͌Iv\0U%T(5s9%(D-ݾ\n@P\nCU}0KC]_Y[\r~wp(job5\0&	CYU]Lاxl=z̝Az7 dOU.n1Grvu!0b!nfaiEI)iA}V h|$Zkit[˙a pnx1q-2%w-ŷiI¸YT81\\`Lhkñ7vHTa:0h5Qto\\	m/Q;q6QHޖvٳː`cc|g&Ӂ\ZKYfNRC3:qқ lqY#0jT3_{C>γ\0e\"QIqtj^*/Μ˧~(E$(y6q/ (_a~YF6u0d]{l#q(PH%:2uQϧ̥1%6Sypj>[N3\\g]:ZNR`B.	EvĪeﯔ\"h1ĿU\n*/W50,\r5k`@Ŵ\0	T˿+nGə4X$w\'Jo`9ț[6ƻĈu61WF~u~v_G642Oh&[O{q:Tm<\Z,RAHjuSm[\ZGi\ZVxXWyY&*5cy@\ZR#:΅\Zg>+5v_vxtFJ*5ehJў5d|ە\Z^vB\"i_\\s+,v*QvHݫ\"ԂS:+T(бYr8[Fjx^p6*\\ucI)	\0N\0al{23!]2Y>\n %&1Fx\"Ae`okO3s:!F̈́-KcU\'dL:U\'Pg,n^<ZuB%:}~:!\0Y:aҮ5x>Ȓ.NW\'Lpm:aPvVANإ|ꄽ<N8skqugruB3^uBeb\0gu\"$;:vYuB$5JN\Z\\o:a\\\'l tHu>}4(Y:ah:a}	F@VN8cҦ]6ZVpDzZ:/p1/B[+>UR}J|\'O@s	0}\0hV0P]\\\rj,!^/0\\$F5V|}r7 ,n6((Ҟ1MOHU.Jl=S._r}\n\'\n:T2oҌ$vj%Mה6<L{m㷙m<nA}]yA8;\Z>8(/Eia0xns$4<I=,:+38˖!Բz\rwֶbN%\rd흝e[{I(gě.E$=F$˩`sKp;xQmAy5g;Xj]>ѵtK(G:^?Xije՚lzc!AˋЉ-$;rzk?{v/D53Me3*WS\rp-uWTV*mǦgn3x̘vkv6f@GG\ZmZ2A>6\ZKҊ365@dn`[Mΰ:\"-JI(D:8?[V̽{uɍOj~zM[O\'shLK-;N|}\'FEjZTۓݸFݵ[Ҁ__~?Toendstream\nendobj\n216 0 obj\n2936\nendobj\n219 0 obj\n<</Length 220 0 R/Filter /FlateDecode>>\nstream\nx]ɒ4kJh_\\\0}03ȋlKRrW[|)=eU`D\nlU/^=R|\\~mųǇHtSSuA(F=}w:_8@H&Ow?[.BbV<k2Q_2Eʆ0ǴdQl\\MK;V=I$ q)\"AfJ\'zgQߞG\r\Zw8\r!a$؛Ե\\u!<L{p;!61J~|fӳ3CfC&+\nKΨ3QIe\'e|v02.1b VZp&j)\">\\204ݞ-5<8\'QU-nO7Ӄ)auoYL/2#LFؑVmG>͈Oېs7\\}0U H\0kL瀝1$*#`:;P_Ee[14)=Uxש\"\'=looM17<kMBkM\nɬ=\0[6f,0Zps9:bAi@ҒF\\3rMYvE{\"ˠ։GvުZJ͂ID^Aoa5Y.!8oJ78iyyyD9dJT^i7@\ZIiVL\"4iv\\.Hvzy([j\\{	Q,a=M3*M7|iwbuy.jk0*q\ZO5{ʹVTS9m.\\aju%C:!XJEӍhU!\nf\nbw}C>HU:73`\0d{f@I	J¿%jP	F2z#Ի֩Z,}E\r0M	g~:򭏟kQxli61ؕx	<i<S{%[![JUW	?&aj>v:Q,af7*0MչeWQ65^ߟ1E$[-n.۸L7-)?+\"Y2[%/÷=rGzqƵ*%eU\'Wôu0_#]]EbSu>X>!if_Js0%{\"zW		getr]ow=7\r.	bƦ\rURNU[7N\\z$t>F8̢rM2:$rO;}RYsl\\Dۍl@?9坎V\\3cHm*:o#6=FK6~/m$n\nRK	ںh^<\nƀje9J`.é5ķ:Su>;tD/fs|;O*L) ;%w*  kơ<׬A?ئ@[\'S}h \'|MB3iN]_$=;h9>{(D11`mϐ(eHլZy}v^G64]T\"u\0%{=`UGgP/ZA4GRCյ>aSZ\\);ɳ?xXvC8̣-\nHy\\x?oEtƎr?A{wM>P8:.HZX$~l҇Kv(pŎ8(09IicH<٭#mcNնs8~k$mn!\"2\'H>^\n9V;?$͈@涘	xc[˭1ۇGҙ<\ZύIE=M_\'xr2%ڂEߍho.tg2sXX9\r2G0n[g4?	13VP&gg;Og_\reSNry+syWx>/^~Ay2fo\nR(r\"Ո63H25Ve)\0Z,a/{z=ݼAd.0oQAtmTcd?-u]`$ƻ{~q+\Z޿k߲鄕؅KGI>:!\\Dom\0`?]wQT_\Z]`hRbIqMkvM{2lyrRSb@ߙ_\njbZ1a}\\ٖ?ޡNsP2v6T9l\ZԝʢhO%g\Z|){B8E3aOyřǋ$R4iřR4W)_XIkgkWhf8t\\yjEq\"]V^{fN8KL3mGzfNZZvc}9mKͼeŢ{[ܯA\\V}2c\'g2S;:FW	\ZL-	,Ro*-3!=nEZjދ26̷A|E3綨e^EXyyefLGO5G_Ƭ[z*ede~ui@\"NVk 5V/65[xN+H{eH	=>|endstream\nendobj\n220 0 obj\n2784\nendobj\n223 0 obj\n<</Length 224 0 R/Filter /FlateDecode>>\nstream\nx\\K6N]Y录\\EU,\rw	2(!6{-ǽ㚩j۲s\'RaD*l5?߾rVcw_Hn<?}\rFFJ7?C\"#ΫO^\\oi%.*#Lwݵ{GFcZ=n2^2Emu3T|/$X&9ydF+~}3M	bme0W71 ji	7h<67B1O>Ln+e=+iY#I]o E92D`o8 !a㨰یJJ*#Mz?)[Id`mpY(x3\Z&HwvMA4/i\\u:tgC@/xMW!28Z_t#7;|ԃQ*a%c\Z`zUbzUv1K,}Z%uplk(3kL|Q[u\Z+\Z\Z[\Zr+w.sz%#&.5+8DX{cVrp6/Y!E`85}H3C|^@r,d\Z%&IlMT&p()n)A$fi%*\'\0F1#clFcAWE$A	yAA\n70 <,f4tpТu.70ͪB9-d7jsI5^23Jr=ӏUiQvO&_C4<O9e3O*$ar\\0POyߦ#P{vxj@X?fb8Ru@ͧPg7`pHpd!hGskS:N+|L[PEn\nL;1#bg\'S`N[aJd^KU0KK媵T\nO`Vn#;`yB$5W,0E\0`vr\0lr;P]\'Xe1ů;x)ό {wfxOl;$gO`ž0dp{<1M49	@蜌1D2Hy9[֜gbS\r~HrA@.!K:qods M~XHd0V4u܋JS R7	\r1˵){uQMͳjSz\rȌ~:ھ6cxܷ\'z0T1Cv\\Dŗ=/\'%RƷMԱ7ݏ7wRL&&%\ZIlEý-3EWjS?(vfa׃[fj~M[Mlټ*tdʿP-?jRD58F\ZOWxPApY3xob\\1o)9mmb[X\Z?m(ɿ^r&다h{]|5>[k(D1\n_5 J14Ҹ7}v]2]#zkKdvW#!?\\A8hB%R\ZMUش)RsG֘{̤4s{ў7^M;Jego?W</2xVcUvt9*q\'?ϊ	%?8^<\0-z pi[*t,1ypT9pѪcΦ\Z¾RN73n\Z~w͋*N7@We֜ǖWy>SZȈIbHlϒbi5]u	V~3p_P1dC{~y#\'i%Z8>-Mƿ@DnسpR~{R~ߢu͙ʁ@6\rt&[י~R}O;hqS}r\\::Ja&K{>S9\rplKT_?-221貥h>%;DsiSl|3Y\ni|	C-؏@ӎP2o Zo^[=;/1g~Gm#j-N\r2 &bhäZbly5ֽo \"_}з:a%vcvUQdKq_{G{r_ϳϳϳ?\nK4_U8w`5KK)ιLs}&:d!ŋYCLXMA2ySv(\rtYg#\'/&D ܧ.ߑ&)9z@,YDd-8lߵn}ץ̫|Bn\rFH@3idT>m%hB49~4a&IZ\0L\\mgM~O<a\'0XNj9?mv|!g\Z8;<$u@v,%BEL,nR\0JwZ%YS͂Cl]cE,RrJnYoY)L[hO-IfױXIlHfH?6a2/\".`n&SؼzSW32$+ob_\'n,7)<H}mG\rMwGtÁۄrڗ-׿vMطǣm^!or>r7d:*f;َǣ+̗ƙNzgry`cɖsG,JG?s@l[ǎ..7q]!Qk->l2??Dܧendstream\nendobj\n224 0 obj\n2765\nendobj\n227 0 obj\n<</Length 228 0 R/Filter /FlateDecode>>\nstream\nx]I4fcf@\nhp`	fyY,K2ȨHӒ|zOT4>?+R}]icՋǇHt~S1+B1z||!H-q\"gLDwE%W\\#1@OKFYt$1V0Je\\Krm{ZeV\"eF \\u9LSkmZ<˺~D;1h6H+ںjG	\0\"`zȐ0FۇԤyVWAeDڡ8&BE>;c$	\"RӋ3Csc!6QWa=Wt^I0td+4l/&1MfR%Fd6uL蚂)RiN%#.BӅ+ݹ{J$)\'$H_q5V(;<h\'0|1yn+*tTC3R+wa^I5&^_t)`[s]49*@B%!nx%ߑ\\.q\"$lrr[K=>`jԌCetDLY3T!7`̈́,$Q3Դ	 EQH/(!!bǦXzBnF }\ZM.͊VjM@c,ɼa%4@$MI1o>lc06%Xl$gGaoaÓVsXoKT-0̠4[](1}]|	\"P\0p#uZkpWݜKX@K%Z\\׶NoV+Lc\"ܚ{StлE8U|hE\0*J`>3C=%\'wVy;6	TѶy¬m27n69ea Lc\nGj\0S\r@[aLgdڱSki\\pѽTZO5İT\\?O`er h3#JP,lQX$ r\'\0lp99Al:`Wdy<ZYY\nBG#%5һ&z2X&j\0(B#8cAէ[vB.\r-|TaK\n;:c9fnȒ7r1zz-V 4%f9-\\\':b<\r-CcL47$An8,qMZdŋ.0$	>@m?7DBPx5O>`hr@]<W,ѧ9uN;Ѳ/.5u5SGowdECS뗽2GK6	\n\n9LULVLtVC/Ge 0ܴ4sz`L;\'ޛlങJ-3?ꋝP>jL)ӟ ;O* A֌CڻFYDZ-JA-QTLs`aMB~nm%gҜ޹Hz#hMo@|U}Qb+>kA2fcjVqh$ޜ\'2e{gY~~jQw]Bߝ8XB*kosC\n 6m. њ\"5<o|<$ߝH?{D2o+I:$ߧI=|AMv+3Rn$_g1|+VueuHe)Hjjj~q:fx	6V:X)l᪰҈yG6d8i%YYlxrr(>sۙ,21JMҦ?d:O,:8ͤjYNUۅ;	-RT.7DO$+wmft\'ɶ+C0ہDmmV;N1b~v]wd5.!IQ9NDϗ&R$ZA=+,6Aܵivܵbi>!}Rf	``{pt09cv\' lWzۓ7!&r\"~Od=oH=%8{&hK|\r؟٣z2X &HNhäb5U}\"\ZԿm;_k؅MI-s[|`2No:MSMI=pT]<=C[\'q:zl<ɕS%LS!tE|iZdJ\\8>yqnkݶ.<c0d]Ҫj\rw}>3̵{B\n8g$4iĚ,b0ϖe4yS<ˊo,.~\rӢ-G0E_(i<m)0(i(}L%rLµ[\'Q/[O<8*bÜ媣\"\nLLy$~C\0nfޗ_nL`T̽&oLD1Aг=&]{	q1)+d1*b:|0|~U>`j	AApi?GZjKzQG^7H^ځDkSCYzi=Ǉ_Gmendstream\nendobj\n228 0 obj\n2661\nendobj\n231 0 obj\n<</Length 232 0 R/Filter /FlateDecode>>\nstream\nx]K$76	oz?\\w `I*I%U{f;v#R*SfSO\'	wܯ\'r}􏧟Hn/;}~[JO\Z)>=^{q9Oߝ?_i8%\"#ɳ}W\Z6y@\rOߝ?KFY{1.z\Z9kwmh%Ǐ\"IC3~u3My赴}m{-߄>yFX=gv0Dߡ2da}h/&$QJt	mRR67悑$To/Wa^\"XbшМY-i[InitW<+f%+r;A|{2k21b Z菘3GXS%!/!T{)2D4I		5H!2<ˑ&R4qFLZP,2˸^0&߇UְJɾQRIQFڙ,4;dl\'V)L3AIç>nzbg!1{	cGY<v!%=LV.c\rTfK!o1:Jw8yR75si\rN\\4H$6ht`ΓK@A,2)j2P+!c22*	|JM9\\9D;\n	6@YABAS|pur{2^֊AyDoBHjeLHnBL1#d@>Oz}6#:xMguRro.p\nOba&ƾRw_5iM]gMl1抝_XCbn\ngz<}\'	T,0z@,SwUGcӯT\\ȨZZkh)pm?r NH}@|yFk<Ǻ<ѸoɮfFvvj+M#o\0kߌ!H4̳ރ8بrzb2+@@:{p!Zl;Knd9}T].]НO^\Zt[أȉ{>&\r>$ǯHOȢ:[YC:\r@0ll\nl=DݚqMTq?2Ƥw\n*e.GbtFG\'0Ӝ<#$=eC$;2m#)cf߹&]4=g!gMgk8\r1 g9Bښtpӑniq!F,o~&]*\',J̪)9kLr\r+N	s)\\¨E:$/o	Nͣ٠&ԟbΓ6EUۆ.\"91 ;}T_. nơ5Y5kClo0kM{ѱNDWݶ3i][$=7hrz.7vAn+B#Nc\r\nr\r&լ5K$\'Y vM7xuDHgEHj]7[\r9,_o/\'Vl_XuĂ$BgT@nU\"@o,&I9+9~h-\0#)\":)f:(~[MWN2|}X.鱬}<\Z\'\nӞ\\ikEqgd}{geJ^~=HOrl?#\n\\>~ħ!82tN*Zބl-&	kjAߦ)xA\rΘʪX1]\'d7a\Z4OjǶs)]F [[6=7(.[\Z)k]5Y,svoA|69lwSt;l7d:v\\B˃DZK-uh7A˟vG@-Hv.7Od9HlIv 1ϕHvgm\ZHvE$]X)؁`pp ܝd-ɮX*tHv>QQd7\Z\\]A]PWH+dW`U]hl]mݏdW >6fnk: /oH8Ud7\Z7q\\?:ۄ6F&#@SaRŨe?Zp}CCswXg˻68	KڬyOmXhbL+<	Ȭ\n+k\'⁀qWvioi_queb4 Fr9}1ID,8U&)煙V-hiy/M4C9Di~&\Znh+ꕀ׽mw{U7v+Jv%/xpA\nm61~\";u&	BͰm8\0K}RvT)UMNaW)&[{iCP&/ERQ\0҄\"$DFx!FZrpgĶJ>kEUԶk\nS/xȩZũ\'	aj=JA@0[lBںJכc+Ѳ(/ЫED0p(T\r9{dU]`hJ!j:@\'nR˥8izc^ @u*y|{4l/6%RadWofQ!JaSZq*nWwT}(P]ep\r%ގQ7׋t|7\rAD,B,x:gB5r\\BQ#.Qw@9E9Er%mY\"tLBQ?^a/\0{\'q <Bf\\~nA(\Zu}c\\A(XA(:3EՊ]\r|x{X;úБsBQn8Eժx*y9af \\`R5{\n1Ta\0ŲW3òׂE*mR=NrT-%[XYpX,@\\]޽j9[kjkuo|6[ջ\'Dd*6Wjj[ɍ{`yւ(w&{!ҡ)+##qΤL\nerǡ\'wf%r)kAɧka}c*4ZKY+f`Quf\0:ڽNq㘲6LY+H\n~F[׷@+[uĖ)kaU\rM~p_\'ҽqវN:­9\rZ=fE77\\JV:pdH32kendstream\nendobj\n232 0 obj\n3397\nendobj\n235 0 obj\n<</Length 236 0 R/Filter /FlateDecode>>\nstream\nx]Iܶv|H3}q;yYJR.[J\\\0wmǒå@h|>}xr9\'RˊO}Ki_OOɐ.ň?Nߝ4\'r%$#}wnkx	뽄i$9{xՒQV]I A #R=]aǼz>zq)VeMG{6V^?!98ոnƩ	c$HMku!<LThk![rH*E3Cs}!ƊZ=\'(4ɍݫ*1J*.\'er>_DV̤CtYXfFs&(ST+8dakO@H$)\'\'B;K	73\'$Sb;ۤ`zQb\Z7Jer	`ZUe\Z%O	V&5ySk{rLy\r3R\'L0?4}ʬ{s>܎Foy`ֲgll[A{$ʍױOZ|Gn0h->[!ʇ\Zi\"P\0D6$B0^iî0`6cf\"`)`I1#83wacHSxWa@7@` B .FqV$l{t`eTD\01FV\nBi>+h\rH\"[jXFYQ:9QMV 5p\r&!B;01+m2\\p\n(bV9aI^λ[JY\\Yi16ޟ/\n5+䈻Og+!\Zj̨y\Zy}Ǯ!բ\",?Fcxd>#[mfۼ23R&Wq\ZL}: \nkvja7.r g-)|L jYE!\'MMUtV\'ƶՠr:C,eY1$bv3Edk\'̬޻d,,ۨ}Qq>dlClۗYz >DN\rAHHjɂȸeF]7~OVVi/K@0L< 1oVc={L6y9>2\"61LU{OZZ32Z901\\գ&l\\gmCXNVOm:{I`[-(Hza˒w%bÙRRscaA;Spb1ྦmWйGۻIcuTmT׶O~~*I:Ѿc{g#[b6\'()|}?L6Gx{\"Y[lM\"YiQ -mUM$j\"W΅D3\"]d5&MfeɖeB)dsdiH1\nԃHve\"YK%.) m뤜sJ93\"Y)	҈dud\ZxfۖqnLdwwGGuݳ_6dY̢bkan6H/HDf*dKOzlS!TkCku7/˧>kG`dL	3T̸ᵼՂpƓO_pk\rx.ǺՌ8eѭ$q}\Z9\\,*<i1a34هNSidq<ud8J\0.g\'/n7Ϊ5	sMϺ֊vuY<XN%m\rԭy>i2Y/ر3sx>nu熭ff|no瓱ÿ{D*x>F-mɈg/lai<)3-Ǧq,cxSrr\Zz~zO{.xNԵ=G(_:Qsԉ:DuzQ\'QzKuL@l В=^W/N-ؓ7\"OW(fP&;#	N\nתp\rbcs5\0*穵8$x1Z\'-2srPAAɬaGGOɫ\r\\}\\bŬct #%\0+s)/Kyp1kh<BXyS=w#yh5jmuk|6myH^$BF\ndekCLXW#gmjWs\'y]gH^rjL:0UsUgsJSJ(tOoo3-44Gy-*(NOӼΠ\\XrN7[D͋IEPVylOZX|oh-Q;nnCnR^_-)PAy*Z=f}[{+>uRdSTȆղ>:Y$p10\nn7l6ƻ#FRF;H*oYi?vTvU{RM]~nhlǖZaue5AXΣ/Rd&m86m\'LN*VmI\nZb:u1XE2\'fr8mrqږd`Ęk7]Ɏ,W3/$JlsܬC=HmW}Rb֮Yp\"tVy~h6]\\!l-^]Ih#jq5m4JSr)%M6Gԑ+1&\r(c=UsWoJHAOJt@eDF35lfvF/:לR2d\rHUkf)L>+ՔY	RBi\\o?oU\" q#˅54:~o@ƻ~]8`WmHX@L.+=1 37D	=,ʦqW2T=5TC~2i\Z5vU9Qm9~[oK:$7`Ky2_le vG/endstream\nendobj\n236 0 obj\n3014\nendobj\n239 0 obj\n<</Length 240 0 R/Filter /FlateDecode>>\nstream\nx]KvS>$Glx?\\C6KuR.{7v$KҌjJ\0FF\n#Ra|YoՏO<<Vy~KJ+LWz^?|JtE(FW:}}:_pKY ȓXw{K%TL#1AſOKFYI	b.ayۈ*WERh轫3GiCkgY~\'fc[ۚ7\n2Ҵ϶=e}HMgu%P4bhi(u?1J~\"ӛ3CsC!IA$:%@vJ#IvJ8M한U|a#Xd&\\b@*Hҝ\\SPE*$\n)ϖ.XвGL$)\'$ ?r|`s+73w(wkUfAf9Ԋv9n,yMm`;Oj\\Y0nf4gj3-\\5\"lxnr_Ǌf5ʨ8JY5ϴs J.Y@)Ҡ2EB\"{E0eƍu^wRfc\rdZ|L\n){Ne]ҮBL)1~\0-nUW@`;5:\"&ͻaa镰vJ~u^-Hvzw@ZoJp=3rwr	j@B,E2Z-6~TzJSj*wC00߀5 IrMhssi_DcRbTS\rb\r>)漻z%SL&iB\Zy6ei\\y7}#4NЖkyAXC]bLuZ*jBV<Q`x荳d1OBrOW6r7F!ѿy\nyh^KnP~N9=wʊ:ϝ\n)\rEMh8}e_oɮwf$L*Tmݚh\\\n.>1F%@Ugw.\\%QsاJ;X\\\0l>TR6HS(AD;S+cAWml\';<Isws3\Zhwg.)AZ10a\')}(6L*gCO~u\n{D5V~C_ks\n>=ש9sa\n\'T{\\1s.j&`;ϛW(/1ד9Ly ^k|<3S\"#2#t@	5͙y$3s&dlK*oRlb@o6Kj粤\ZnH/ju@pƊ[fL7>˼yJ?|y2W-+{7%1%V\\Gj\nzspfHp\0y*)y4EADQ3C9, :ͦQ\ryc*pɊDd׭=~m\rt\nS	m*bq.VI~3lM}N@&4ˀ֥ad\rsqZl?]^8k~]\\Ǹ!}nx^2\0P9yle2BS˘8QHo^p8Owf2#pC/f+u!/ZScY2:iAER5ټ_lBKGjnc[ρl7)L~?6]).CO}AGA-PA	\ZC[jf\rlH0\rLsAgMBvT\\ERzL\Z(yx_svUF!q~5 kR2x5-vA]\r;GVfIkٽ~\'JCς	Qz̻q<ѧ%VZ1f,n.f\0ji.;9!u}Pn0ݲP8`s<`6VyCBJz\'xt`eڍ^ylS<nn,oidkg̉/ʬm,<%ih\\gc0h\'l>x\nŔ(b+a8ل૙E^,B:mB5`:ŉPfe[#=vQ&WE\n\'4l߂\r%;/BlKd\\+U˓b\n/d\\O/!`2yi̐?a;b>	f0񍏘oТYrbm\'	Ӿ̐=3d[Zmk1CVӘ\rP^F:Ď5ą;zrGwlc;+ LW7q_ؕ41,u=Lx=\0pRi짱Bnx \n6@z4GrC79Oi]*ھ@yfItf<D0ڡg\"WgdkLZPSe<vV?vV{\ZsbκZemThI(iGjf{ϛH9nz\'/yĠ&H1!.`YVaאsB5vOܼ}D3;ns\Z2ݘy,A`K:֓)s{]]H}9<uVÍg\Z\"a\ZѺӋi:G\Zb발m\nVʐ\Z&%:endstream\nendobj\n240 0 obj\n2725\nendobj\n243 0 obj\n<</Length 244 0 R/Filter /FlateDecode>>\nstream\nx]K8k+ Cpˁa	f.{RCKeٮvu;f\"m9˔}Y*H\'cE?Gx鉴?Yo(42R2]=d^?|\n43q^=|S]}ᔨE F$Tݥo?1Ƥ\"aatc:+%;a4߯.q)o/F Ю-{:>߉Q?xpo0SHT׶{Wi\rHҵ6&R	V 	C!eso.IB%{\n)~wa`yuIBb0Up[2dS6w+.3)#PqC!XS%$?,EXiѽϠgHRNH\n\Z芸,nRhzpP2&_+d]#TFloL!UjaMRXMSʧ2l|j!ʷfčIY7ACi\"sL.=.ϐO!/%|AbL4F}r<܇3Cxa30Zp6%E,#f1\nfp9I\Zn\'ɗsJ5ؘ#۲l\rnHp=I2/½dmUrK\nVmz\r>)?)O4r401-0!g+*@GW0G:nԒ&saq>hn,107ź-F ưqK#ܲ&(`Qb	\n]\'?<+Wz~1nOE<Y3M<4|Gz\r,unϨq	IL\r(d̃=W]Anfk5;b_,Mg8;\0ɂ5s@sO8#KcƩ?7lz_eG.baF,9Dy%f~vLTgf&v-K/JR?j^1a-1>_(ETQSL-?^\nR&fў+X`*K)^vDmS4A\nYmwKΤ?HZ7|WviC(D11rF\Z)cЂG&Nqs/H\nѼ-UE9?;G4/ӟ.*``@\Z-h|\\(825$T%ڹ)U+Ugjpm\'L-gRuSzru5d[*e\Z)U|)JL0Me*3ٶtʣeˁs@E1;R=9t@@lcELވM_2tdvcN#D$3vXv賙]RcBù*д$楢^`[U`\"t\r~EblLkpMfDrSN~OΚf$![ͨg֌8ujF4<KV#^(^ \'/ьD.22mZlfZ0-Fn0H3B(fhҌOwf	X3%b<.\r\r	/nt:N hxb^L-0t5}LX6L)G+zIkb*xOʾ`3\'I!4RNBJ<j?ވ\"%T p[oݷ\'4K+P+\\HW\\B8-M\n,1<QWNl[<nX@\Z#t7YCN]w6˾b8;SN6\\=Mc!|>e\"m81XTs6B=.Uf}[Akhs:tkC9᪕R=PTn/a̒sԡٽώZ?<YnC7ۡ!ЬXL$uyE!o#bHޫ</|-Kؚ;*sw}].\\_OCӆ<]\'86|C,wnYRRf6Lղц\r^vaʇ:m_5Ih~Φ\roa }D~8\'ICZhSpEL/3:5=ڝpn>(ZhT^(mٔ.tPmjs[d䘑n):+%nZ*09 -s#dڹR_lǎDeۑ僛e*+JԞY>RNEndRPrN&\rd2:_;t_s\'~2\'~2\'~2\'L\\FʤiA7N]$lgS0s\' *ʦ\"cZn!2XkE`ᮂ8po(AdiTn\'`}p&	jF@>YU|]\r^4y?4nk]@zidUm\rNV깭X՛\"VշY* y?}?;DR-VF۝u[vsݎ\nÛe/<>;\nFfv\" !@/}t*ZJ$=?}\rT@f2endstream\nendobj\n244 0 obj\n2678\nendobj\n247 0 obj\n<</Length 248 0 R/Filter /FlateDecode>>\nstream\nx]ɲ8m/X23Z@`ChYU@PE7﹒\revf\rQN[=:rx}<?~| _vzշ42R2}z냽_fD(F>=HSL.1\"<G]+#AXcrz8=DWTUU%0\ZJŅ#4Q(:\\S3\"J5H	ÇRRGBk6Ɛ0F?؋ԤVV 	}<B_]0J~Q@M)g#l\'夭q2TS6_G&1\rUfR!Fl:`eshc\n=E9	\03{\"I	A!vV	^dsX`L.ce:\'Ђ٨YV$mZ|c[KCG?\nq&I焇\ZQU(d\Zy5\na!QbZ}eF4p5>*Q#0Nk/Wb@/\'6ԟB%c*=E0Hֈu\Z;=38P. `ѡjW\0^P BH3uRjjJS76T_$,F*\0x,76k%V͆c*tpmqAe8,J$\\a4eØe:f)`2i,\r3}XP!u`pMAĠBoН[|ÿD%\nL!OaGBEGMr^n--1.@1Mlm16?^u\nӜcR8OwGRMe`hAxbd\\6A=g԰WSL&YLBi`XI,R/@BAT\'j(\0L94q T֦ˌY$v,v(5ZsoY,^?^wβ88\rw3yw	l>}P\n58wT_.`bơ6YkClo`zy 3)?i(ʿZr&-l1N@8!P`JĈ=|j2-x40IC/[Լ[CGtuG@qjg oHjK)A eprX\"-eb/MDci3d\rlMg{N,\nW3˝gYn.U9@0)r\riţsdrܑ>mH⠊C𚋃sܢ[Ľ:aǽFTSDHn偛CrZ`/q\Z190@Rfa	~_cIwcۋ67W~cKA=3M5賣3o,VM^In&el3Kg+]Q8|μ[tou+\Zy]<`kIy݌Ejy]nzr\ne^.Vu\rN7k t[rLMKP[aǁgGO$@A@ʂ	;&9mTs4(OWXXNc%\\f).£sD\'\']qW1k<#nDGwlt\\p59zn:2hv&v)Ű,u jevc\ZL*kkIM\';,]~s 0a˜fځ+\0WGF:VȪ,*Y	e\"W2a\0Q\n\06>ty	LQL}k=vhVS>F;j:-Qua-(P陻sIkBMB@.\"*:#\'gsaȋ{Mٮ$T6惐*a58&HW-R`vgU\Z-PE]+Thj2D鳁UD9{/NOw̙>2stU̙6f[>n^1o<`7hbV6f\Z`F`>U	z8=\ZJVU%l\n{mE w\'ѵ;o#	zfZM\"-Imx>nxNaW_jN~idh!U^r=5(/Yy,4o[\rwN6+ѬS⭶[6x%[s2ŀYVH[,㷟O,s/vùn9t{m?vm?g|~^G	IKfYMYx>0#ِR~rVo:Y2fҬd\Z\"-\\..x,v}XCbven-*4!$zwRWhmk5\nMA.8qrqheZeJM=HgxV/؋pULni5g0{YLG},X\nzfxlc:9@7fmW^.rloCJva6xY&tGgUf8_B&o]^|}.d䕻fI%VHk\"/ݔjuq][$}\r4\0J$TvcljE+zEkL^[ڑuՊ֬MV(Z[̲iO99a1WS[<=Vي&zL4>>OH!;~\ncu<[_auFR;ONܚ|%Ў)KҒV@=E<֭(OVă$@wgt:MuMU.Uc6;i۶}Wl7Vۏ~I}?ϵ(mh\rY\Zoӧg!v5΋0ZwGt7Oeendstream\nendobj\n248 0 obj\n3013\nendobj\n251 0 obj\n<</Length 252 0 R/Filter /FlateDecode>>\nstream\nx\\KNG5; ۙ[kA;%>Uԛ(==]`jMՋ_}U/\'ĉӿI˃h>ӛǇϿ89捑]{WK?	LTU`OJ5HSwGߝ+Lywhs*T~G	Ts豀iyh_k!sFfFzfW@13JgL{oD{bahu\'p0(Pe/S3gFQ%7gW\\u<Gee7x<ߜ/0l,C$¦3sk|(p(0@LX`:>ׯpf̀\"5PWlࣶX)1&k87Y-ݬ͂\\Ygf9&&8~щ0.ZfriX_O1tГ1.GќEf\\\"f$:O\"\niGyQ?6?uca=:R\rWЮz{TŲEPkb6h\Z,u(\"G.g\\/)t\ro0+]cpڑmNϴگ#~DPK\"kBicS%\'4Ad*)zqacL	/YBE%rÊ8<)-@qؚԐy\'_)Jy56noFzR`Ng\r~tiwҾS7	sޝ/rH&@]&<Dd\rɔc>\r:\0y3ykXPN#\\WgJ-(Wp2,G5(\'hL=\n(ob7$xZ0\0m5Wf$\\T͆\ZQJx٪Hu`]z:8\'iY/:(Eu:E1Z8isx@p*~p4`MI)j-^\ZxA~H?z2uG|LC@\\J\r\nFt;Nى§peOXɬs$/&D\\Q\Z`X?-To[׏4\ZB}lr0Ul29\Zi6g-\nmnlh6lK!\rNe uj~i.a`4[7mevmcj[oAB5Q4L[Q#é	W#ϩeN-H!Ayjr\n3l2N^I7x\0<[&P\"P*6/6-I//flElܦl@\'a9c:\"E\'ioz{ޣxF\\Ga5AE!8/cP~&>Dsf[\0~{*m`nI!ghdCK\\K.ZHGP5b30\'MV.6!MV(& sK% Vs+ZȨeܽ*V֐b|NQRSсDD>0vmgSGrEGRow|L5\"lDIڜ}(ĵ>IZ7(FJ̤hɡth[>\0x\0|M95=*R\rvyЋ\nGWpäJCs\rpn{gR;*vyh.*1]EEmLPl*7Iᨷ~E/&l:nPL喜tpݼە5:Mk\Zb $`H7\" V\r.8w%\n@M{bsT= /uH}QG1:\Z)^{Z(S*kHP*\r/t#19mH%)1K8Ԡ,;RB<2{l5;n$fkpMi\ZfWiMS7itwз)qTy2RRc)α6M$J8ے^1JEnmI֌>gtPv+6zygUo-VOgU=c]}A	|sQ\0\"QC۵w2c:gJӍT,GOӚuF5&2ħnɖVbh+.#+]x7_*B$Uʠ,bUckE+j$6}׿6uHړB+Tgfm\n^S7%m\'wӔL3${]wG3FCI{n7!xAjxm-NP֜Z-\nND3stP.y,lq__]wͭ^H_aver!5\nŔwbdﾾE8;r(,뎅-r~e5x\ZڶsH0=SQU\")|p2BR1)/DΑq\'zgܪ@׌Hк\ZފrϿy*ĞSjٯ1Yg9yQendstream\nendobj\n252 0 obj\n2599\nendobj\n255 0 obj\n<</Length 256 0 R/Filter /FlateDecode>>\nstream\nxXnF͙_#@m$ 9Y\'cnp$Mb9,]]\"ZQEzSkb*6렵WeIut]\'я5UG_ɽI}:zSCǛaJ7O+\Zs$ek޼ΚӶslQV~yuyuJ;}#Kם!(zs	߷F1i.qj\\)f[S2Ems9_=@ŽͿqy><y_1;<gt!,1#lTo65?6ܸ8Lt+bmXK!0]p5Z!;FVHC2.Śބn	kt\ZV[[u=Z\'Gycx5Uϰ&n~ݮCL7@+lu%.Ab~ƅK~kV5|И8\Z<tz=s9)9̡̰7nե-vV4Й6K2w˻^+g||,?mT엎,Dn-hb2gnd\0q39cɔPЈ6&e>-%OSR5;Ȝ\n\"*\'rf2x(\nGE>k#9R7\"g=@Iy_K4&,W|ӄDn;c\n7h\nwJUs9yn5=;&9@Lx=5nS~0Wխu({Y&c(@Ǆ4v㭰{ɮ<\Zv)=Kઉܼh+ὑGj:D7aQUlTEEֻd_%-J`jrϞWMŖC	^;1,:IMKo>@(ѮW:JV-=تa\ZXl8YC͓!ɥVVnqxKF32:^!iYJg	yePyY%W$ ck	#r|ұ\"cA!D|)MXγ-;Èn(i\r=;펗+]wXz몷;\'LLˎ~U*\'\'(hv7(>`02*O\Z5Pfhehz僝(CrxEb}CH&;\r[G\0=\\khsG4N.{>N~qoo:}!pFr\'̾֣wMY[1gĒ՞M<K\n%SZFa\0=[;V2p.Kxpb$5z<4&KvO?ڟbW/c[#\"R0e>\r4t9<]~Qr+vk\ZF+5j+Bp1)6>\\Jݴpʲ/x;\r0<&Sf)K| 63nǼ4zqE>S,\"21}~}`ad $\\HXbQ,@zF e\'CF%I=\'fwg1>4}_m);2m|k͵+iBFendstream\nendobj\n256 0 obj\n1572\nendobj\n4 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 0/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 17 0 R\n>>\n/Contents 5 0 R\n>>\nendobj\n18 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 35 0 R\n>>\n/Contents 19 0 R\n>>\nendobj\n36 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 39 0 R\n>>\n/Contents 37 0 R\n>>\nendobj\n40 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 45 0 R\n>>\n/Contents 41 0 R\n>>\nendobj\n46 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 53 0 R\n>>\n/Contents 47 0 R\n>>\nendobj\n54 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 57 0 R\n>>\n/Contents 55 0 R\n>>\nendobj\n58 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 61 0 R\n>>\n/Contents 59 0 R\n>>\nendobj\n62 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 65 0 R\n>>\n/Contents 63 0 R\n>>\nendobj\n66 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 69 0 R\n>>\n/Contents 67 0 R\n>>\nendobj\n70 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 73 0 R\n>>\n/Contents 71 0 R\n>>\nendobj\n74 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 77 0 R\n>>\n/Contents 75 0 R\n>>\nendobj\n78 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 81 0 R\n>>\n/Contents 79 0 R\n>>\nendobj\n82 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 85 0 R\n>>\n/Contents 83 0 R\n>>\nendobj\n86 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 89 0 R\n>>\n/Contents 87 0 R\n>>\nendobj\n90 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 93 0 R\n>>\n/Contents 91 0 R\n>>\nendobj\n94 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 97 0 R\n>>\n/Contents 95 0 R\n>>\nendobj\n98 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 101 0 R\n>>\n/Contents 99 0 R\n>>\nendobj\n102 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 105 0 R\n>>\n/Contents 103 0 R\n>>\nendobj\n106 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 109 0 R\n>>\n/Contents 107 0 R\n>>\nendobj\n110 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 113 0 R\n>>\n/Contents 111 0 R\n>>\nendobj\n114 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 117 0 R\n>>\n/Contents 115 0 R\n>>\nendobj\n118 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 121 0 R\n>>\n/Contents 119 0 R\n>>\nendobj\n122 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 125 0 R\n>>\n/Contents 123 0 R\n>>\nendobj\n126 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 129 0 R\n>>\n/Contents 127 0 R\n>>\nendobj\n130 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 133 0 R\n>>\n/Contents 131 0 R\n>>\nendobj\n134 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 137 0 R\n>>\n/Contents 135 0 R\n>>\nendobj\n138 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 141 0 R\n>>\n/Contents 139 0 R\n>>\nendobj\n142 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 145 0 R\n>>\n/Contents 143 0 R\n>>\nendobj\n146 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 149 0 R\n>>\n/Contents 147 0 R\n>>\nendobj\n150 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 153 0 R\n>>\n/Contents 151 0 R\n>>\nendobj\n154 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 157 0 R\n>>\n/Contents 155 0 R\n>>\nendobj\n158 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 161 0 R\n>>\n/Contents 159 0 R\n>>\nendobj\n162 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 165 0 R\n>>\n/Contents 163 0 R\n>>\nendobj\n166 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 169 0 R\n>>\n/Contents 167 0 R\n>>\nendobj\n170 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 173 0 R\n>>\n/Contents 171 0 R\n>>\nendobj\n174 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 177 0 R\n>>\n/Contents 175 0 R\n>>\nendobj\n178 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 181 0 R\n>>\n/Contents 179 0 R\n>>\nendobj\n182 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 185 0 R\n>>\n/Contents 183 0 R\n>>\nendobj\n186 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 189 0 R\n>>\n/Contents 187 0 R\n>>\nendobj\n190 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 193 0 R\n>>\n/Contents 191 0 R\n>>\nendobj\n194 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 197 0 R\n>>\n/Contents 195 0 R\n>>\nendobj\n198 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 201 0 R\n>>\n/Contents 199 0 R\n>>\nendobj\n202 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 205 0 R\n>>\n/Contents 203 0 R\n>>\nendobj\n206 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 209 0 R\n>>\n/Contents 207 0 R\n>>\nendobj\n210 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 213 0 R\n>>\n/Contents 211 0 R\n>>\nendobj\n214 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 217 0 R\n>>\n/Contents 215 0 R\n>>\nendobj\n218 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 221 0 R\n>>\n/Contents 219 0 R\n>>\nendobj\n222 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 225 0 R\n>>\n/Contents 223 0 R\n>>\nendobj\n226 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 229 0 R\n>>\n/Contents 227 0 R\n>>\nendobj\n230 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 233 0 R\n>>\n/Contents 231 0 R\n>>\nendobj\n234 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 237 0 R\n>>\n/Contents 235 0 R\n>>\nendobj\n238 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 241 0 R\n>>\n/Contents 239 0 R\n>>\nendobj\n242 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 245 0 R\n>>\n/Contents 243 0 R\n>>\nendobj\n246 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 249 0 R\n>>\n/Contents 247 0 R\n>>\nendobj\n250 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /Text]\n/Font 253 0 R\n>>\n/Contents 251 0 R\n>>\nendobj\n254 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 0/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 259 0 R\n>>\n/Contents 255 0 R\n>>\nendobj\n3 0 obj\n<< /Type /Pages /Kids [\n4 0 R\n18 0 R\n36 0 R\n40 0 R\n46 0 R\n54 0 R\n58 0 R\n62 0 R\n66 0 R\n70 0 R\n74 0 R\n78 0 R\n82 0 R\n86 0 R\n90 0 R\n94 0 R\n98 0 R\n102 0 R\n106 0 R\n110 0 R\n114 0 R\n118 0 R\n122 0 R\n126 0 R\n130 0 R\n134 0 R\n138 0 R\n142 0 R\n146 0 R\n150 0 R\n154 0 R\n158 0 R\n162 0 R\n166 0 R\n170 0 R\n174 0 R\n178 0 R\n182 0 R\n186 0 R\n190 0 R\n194 0 R\n198 0 R\n202 0 R\n206 0 R\n210 0 R\n214 0 R\n218 0 R\n222 0 R\n226 0 R\n230 0 R\n234 0 R\n238 0 R\n242 0 R\n246 0 R\n250 0 R\n254 0 R\n] /Count 56\n>>\nendobj\n1 0 obj\n<</Type /Catalog /Pages 3 0 R\n>>\nendobj\n17 0 obj\n<</R16\n16 0 R/R14\n14 0 R/R12\n12 0 R/R10\n10 0 R/R8\n8 0 R>>\nendobj\n35 0 obj\n<</R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n39 0 obj\n<</R34\n34 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n45 0 obj\n<</R44\n44 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n53 0 obj\n<</R52\n52 0 R/R50\n50 0 R/R44\n44 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n57 0 obj\n<</R44\n44 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n61 0 obj\n<</R44\n44 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n65 0 obj\n<</R44\n44 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n69 0 obj\n<</R44\n44 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n73 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n77 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n81 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n85 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n89 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n93 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n97 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n101 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n105 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n109 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n113 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n117 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n121 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n125 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n129 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n133 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n137 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n141 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n145 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n149 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n153 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n157 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n161 0 obj\n<</R44\n44 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n165 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n169 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n173 0 obj\n<</R44\n44 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n177 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n181 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n185 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n189 0 obj\n<</R44\n44 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n193 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n197 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n201 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n205 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n209 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n213 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n217 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n221 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n225 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n229 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n233 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n237 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n241 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n245 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n249 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n253 0 obj\n<</R44\n44 0 R/R34\n34 0 R/R32\n32 0 R/R30\n30 0 R/R28\n28 0 R/R26\n26 0 R/R24\n24 0 R/R22\n22 0 R/R8\n8 0 R>>\nendobj\n259 0 obj\n<</R44\n44 0 R/R30\n30 0 R/R14\n14 0 R/R12\n12 0 R/R10\n10 0 R/R258\n258 0 R/R8\n8 0 R>>\nendobj\n260 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 261 0 R>>stream\nxcd`ab`ddds\r4~H3a!Ss	}]M;9(3=DAYS\\17(391O7$#57QOL-SpQ(VJ-N-*KM[霟[PZZZ\0t2\"ULځ|}c^柛\\ҽtiQw_>ڢ%33V/`w}D,*(ZVfͲek_[t\Z~00\0\0_\nendstream\nendobj\n261 0 obj\n266\nendobj\n262 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 263 0 R>>stream\nx=KhQ$CՆF(J͢JJ	IFy$;/&)imFbRw\n]0]qڅQBE3\'g졚w>::zNYku|#QVwr`|{0EF<!nnYvQH݁9tдt齂]bGC:ck$,A WI\"xcqZDYTUQtYLk\rӰQbaa\\hWoo~d\'x[Q?7h3֧\Z	V*k6-b}M0iǾ%zJ&-T28gF\'gHIg2I}%\rCN~ͼd`UK+fu9P\nb~<<6FQ\Zn}T/U*r[87ͬKΉ&\Zb{r\nendstream\nendobj\n263 0 obj\n515\nendobj\n264 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 265 0 R>>stream\nxmLSWB9*C7bW|N38ۜsɲ\n@)\"K_V(p[ZZ4s(snѸbL\\l3sC.qɾsTz\ZEӴB]\\eKL\'sӒ0=+M}inƢp8o\nm{jZB\"ՊիU:TS*ԖkuZPzS_Z5/SVVJ\'QkӖZ6j\rb}PEQTfa2N\rE͡ޠRy\nj=dT&u^N_O1ooScY)[a&u A鎺[M`:;z3GܲS/@\r	I>HaCXUt;ʼ`PsxdK(F\0\n]t>sw4!S7Ѹblz8D!&Dz<݀$Km9Iv)\"{,\ZpH~Iӕf*PMĚD-x#y%3_/Cv@m:baߓ_z[x-^q.YL6>=H4(\0T#oKnRxNtmm+q#x-x~Xx䲣W; (v=hؕW8xLM1ra5ZCTi\"Jؠ+v`ŝEɤB23ف>2!sLjqjH,|8Ad!1|\'E8йuf^\"@d6QYd{G߸rὗ8=\n(\0nസXsaMY9 =v< |ڄm|C;*yp>Kg|^ݵe?7\r83g>\"tXhg7nff8~̐#\0ѓ|\">q*=|\n\"\n٠){d%YSL2	dV1\rN9kr,}\Z4.pr|_cG\0&_V*^7:.ύVmfKfFsc: ?<\\bUH@$<1@8&٠73xd#L~|*߭.+Ǖ[.K.=?H-SЂCah;Ͷ}(5R1r4(&?$vb	mYY^\0b#@\nendstream\nendobj\n265 0 obj\n1192\nendobj\n266 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 267 0 R>>stream\nx-N_HSafKCe(Ub2)rN6SpA8)6e7E#\"R|%P/X⼜sHAc\\O8V5	˔b($e0b0r3 ;::)iT]]%ֹ$n6oys)wXt^Y~ɾ?iqz,ZvIFiΙ#d@A=G`GfQ~>!d/UHRl(\n\"O)fCx@4MSzOBI4YQ \ZbhxeeԷdݸDA\Z-@#$H@\"|\\5ڠ>ܻug~GЇNj<o`ov.B#⮰I5|D)0Ɔ74Bpvk2y	fgnR8%%0LߵC~_ M[lh;xo|&vfOX<|H!mch,jh,:?~_}Kj.0_nhpUH6B	emL:iGc!?p\nendstream\nendobj\n267 0 obj\n591\nendobj\n268 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 269 0 R>>stream\nxeT}PTL@0[ji4:5REc`D ȇ.ǲ>w[XVԤFVh&&Aidڙ&!95Ӥ3=9;ss~c$YVm=UV[ll9:8nvI<Y<S?,\rB|Kպhʲ+\r噥{\Z*k}5dg0o˼[fQ^gM\r2ofdY-it>KѲdy d[fs	ļĿ\'JRf.<&^r@&;qU\r	Ǧ[Tn(۴9x5Q	*S.}xssGamF!|A\"0C\rEa\'KQ\'Yx\rGD-,Ģ	̋b\"rx}<b,ny}\0I#B	4YfPQJȑy7᫐y7 `y\nP\nE}啐o֞9KـGd@Dbkx/ǲjYbLR<>go0w|w\nT4d\Z.*ON\ZէjN+~j;P1,GmPnZX:WNFN7zPBWX\'bMw3ómo<܂Ty/{QXQ,KI7aӼ\"hlH13dNQW^$(%f@zv\rqw:}%gh0H%1F}Fmm^gSȂ8s{f@LXGX(G4.QT01HD2(7d8 姯N~	y=!~%FG<5:{wT|^sܮ6lcXR9Ņg1\ZGC.2HM߄9lj\Z^9S!\rkǠ33SStÝ]AKRd\'Ǚ_DSu♨M$\"oC9\"L>1Oa	b%WrX?9k^`c	/:?$r`~W!1-x`RN0jz\r|??xx~.bfu8\'q߹DˋQUojnjnnZ!xx\'I\r#X4ڿ*H%Ǫjg(xG԰\Z6k-K($x$Vy尤<pҴ2-O(D/8/@ӗP<S\rQ]:UU- kZo%[ՋCd䔝JT#*[VLݭ{rsb\'71~2U!w-8dn%KE!^o41g̎uU{mxFJg!dL]Mٻgv@@S/a[_Cd\0T?Ʋ;\nͮAm QjfPփ:\r\\?E;4L2f$mzC}ȩtb..n\nendstream\nendobj\n269 0 obj\n1651\nendobj\n270 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 271 0 R>>stream\nxcd`ab`dddu\r21~H3a!]O=u?r~\"_PYQᬩ`hiiZXX(\'gT)8(t+lt-(-I-ROI-c```604b`db;!a|VL`(]i\r߯gߗ{feNݿ~}fW䀂\'EӺg}=un,c6 @|יV5Z5[}|Ǟ3P) ;K7swy7GUEg.ݠ(vIQ |}c{$bUP^vg9/PDFVnlg\\=||ӓv.o\Zۛf.[=w9}rw]y͝@M@o;/Z$s.i9Nξ	|5xxe`\0\0\"M\nendstream\nendobj\n271 0 obj\n514\nendobj\n272 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 273 0 R>>stream\nx{LSgO)xΩ:F#2upui\rN3\'elK-Ko\nJ[@WQpxI(ɒ0q^ld+~$T,ߗ|G<Lv<1@tHm>(^M	G.@;w5>C%Jqpm:alBB0P,d	El9w)fHrFarA0#L!\nqŅ%rT(*KOIMMK&D\ZIC&b-D\n%fyQސ|ihtai(#:xHL\\i9;w>k/N6tt;5&g?|\"xk؉VTo5Ow5o-EfGYvsC),S@]M5S;\0=EMĬ\"t=㱯wx	F\n([<vDW0a4	P3gCFo6thcY\ZPoY-\ZgZڮ]vlp[6~dK>YP}T`Qo0hΪi֠IQس4w`\Z~j[j=PAj0ҝa-`J _f\'srnTu]]H-g<lVr6ywRϭZƱ¡KUfmYZE`2j[+>(K$E@E\\Z{]]{H}B-SsRm0sZ\\`3>^	&#*)P9n_<]Zƨery?o%8%{M\\vdRav`2B^L\\f+\'V]i0a	|qe\\h@4\nAsW#h>PH0Re2viN.o9S>H}JfLǳL<N27VH癘-W0o:9ג3PfӋnp2i4,@hyP<8gUPL/Lɵ uz:e|e;A#XJP`Q2e:\0\'XBg3\"\'FḍުNp\"ɥ 8\nG(gm3L*RS*S)?ն/)PL巩3cjat2M8c-fcѬeJt\Z]\\Oa&e]4ZCuX\0-D7JtN&̞P,W9JG<<[eRִΔMsZ+pP^SY:v4^pt3Kk;Dnt:I|qVol:\"4#2IHb\nendstream\nendobj\n273 0 obj\n1405\nendobj\n274 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 275 0 R>>stream\nx}oL[U\0Y)Ka\Zel \rB\"FRJRV(6|Y!h&ۢK4YiKudrܛssEEa+^/Kd|VW%uf۱),܊o#j9JczŬ+ܭ[VVhכZ\Z;tU}{Y9tǌMzPWa0]:}ԭo~i1M*cAa+9v9%d+P$,32j&SUOr6ժ6$|3Ms!>\n171d`<fg/-s8̾V<|\n\\O0:)a\nf	^&iiуث[<RybRv``G{=ܸB74\n7s9&WLJsWkYkso&$aq?fcֽ՚\n\"{kp[Nzڕ!τ\'8%]_GOhv`{?i_aՈ4._vxb.ְ+7:\n^ZQQV;eQj,ywXlÓ؂/,Z$ߟ?2qaoRD_)^*ਖ}l-\rStl<ݢ\\T㡛n<!9{\n3.QqA¢ MIR`z#ɫU\'u۱퓢Æ]Z\'DhZUv𾰒Ҩ)I6`4ԟq%94jߏ\Z~]t\\6@ojh$>ׯ%s~On=.85h`@#pp~i,_]J\"q!(vt[Bm#oM\Zӭ?>ahs9`;Gm4 l26H[H5~7̦iS\"1r,ԫ1z)1![R:͌k	\nendstream\nendobj\n275 0 obj\n989\nendobj\n276 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 277 0 R>>stream\nxcd`ab`ddds\r~H3a!3Q%[~&_PYQᬩ`hiiZXX(\'gT)8(t+t-(-I-ROI-c``\0aC*&-	+1>{VtW9V[]V:{<FZg`_tE⢼E+W.^BtOl\'oz-b>s\07]\nendstream\nendobj\n277 0 obj\n270\nendobj\n278 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 279 0 R>>stream\nxW{T!\"SmgZZ_HE\"(\Z!< @\0$C!		byPAZV[[Zkpjߺkݵ~1֙}߷\rM\rqhvY5pxvxQXۗFMNho<.E3s|O\"2DZHA^)U<H&HIЁ=}1qJs<T(jܪyhTIbO2m9}uk_ZHQ3@j-ZFCRԻJjGRk(ʅrQ#5gT5z\ZKxrr4ߩC@dB9U$^!6`\"؉f3gu	ui:qhpÖ-7~7Rn9eR`4+r|J9X=1\rˁ}UY[(8lLKAw~8B3B`ݬW	f&L^+ez1RXbuܰƯDK=kg52H9zVth!@=gCPeNF0v&P!ljmYzIV%n]\nQɷFVeP*RR>	Orzs:hH/\n9P1^ޤI7L&gu?\\+PFf\ZV2S_@[KαR\rcɇOq꟬ oٳچэw\"xKKNX6ޘ\\[kg?u.5)	Ѱ25hԠݑ+}\0ׇh2}LqE \'&St|GPHcxx2rG?yM *ķ麡ZzfC\ZI~\0H Qloْ,iV$+\nk8][\r+-\n^,v9<D4vS6:ۙY]1LoQ6ķŷkO~,=h\rmp0NZ\n:PhGӭm^d#Bx>/61\"h(rF#<.6%n\n<y\0ګE9ۄ\"Gxꄱ\r![}#XZ۔ AH6d-ښ\"(3ߓRѿNBnȭIMqnQVfWNv\':ecTͼk	8#ǣX7DBV6\'߈/}MBb^huƙvԘj*4HV+yc1ۭ/?;O,ՔoCߪChƓ\"4-笩~.yczp W)XUSakN#8sht\Z\r;VAd\"^\ZٷF!_oR}f7!![[#\n+KGy+N߸\"T\Z*mޅJ%L#tE~{Q)ޝ\'{/!ǡJ9L7CDG>(BF:fe̲H1QK+kFYcY2i;f[U eN	_5{uEAvG1; (?/(*-/,lޡ_t8.F|?ػ\"pi9kھCT\n=9V@q/Z4C&G+ 0BաOI;G=*h;zH\n`*X7?\ZV5gϕݗ.\\{oYx\n+b\Z;W+hL`kHȔ\Zbi$ąM`n@zKCr+< 8D`>iU}~ܟ:aeC(ZJ_f9!Gĭ1PAL̴X۾P\')Xtl.]^?]zVJہ%˨aSx81GKbnxb4G/\'|/5آZ,!e[%CÛ^V43\'B9rUd%ZOY֣ܠ莘3v]9\".Aؽj/54vtZ&Jjבߜ1>$1zl#ԒВfKȉϋAfwN1K(ZЬwC![[+c7A^<|Jv9/-X(D?\n8\"9D3ٚ\\xp=_\0\nx|<ZM^\Z}޲}?@$seB踑v^DQ&\nR܊\rPIi<>0i6\Z\"OTP?o0%g!?Q\'/\'[U\\\\\\u\\2־VTA,A%͝O>XlyℭӢ}s߀য়ھR;#赵kT	b_bB3OAf	\Z\'W,}*\ngKbLfOb:ypV^~{Ȁj8k\n&L1wu$D335e\nnGcQ=c;ZF̪6={]zjN/%,ϗѸE[1gԞ[bn047$e\ZQt	^zOo@51Z|!BjsVHH7׭˦QTS{\\XEN+}Fܿki&~ckgƏ_nqYU_o27%TFmg]6\nmVB6duf>~h!!U=KF>3B*CKGa2T;TTOS_󤢉̒p}sbIa\Z}H?̻\"אeϵLkߖ䒴rͪ-bۂl,f@w2)سoh;b\'g`<XHTV$CXc}y=*.I2YH\ZS#P}\ZK>.QiO݇C]zy5lX*.*fj8=8їN= Y?`\"4CTgF6KvD`j)0]qFx`ш\rm\"s×KՑhuZH#tCNzjZs|h^2ˎ:SoN®<y@v\Zc:ҷ949\"@\"?xkb^G\\SQXl9Y^V\\t*a؍Ir,^?Nb\0M2#\Z;Hzَ5wQ}0Ĝq^KfI+->UQީuk}؟@ԏG^\'*œq1:ha?rs-[%D/Zǵ˼$y4\ZְZs=syPl-:^G1߉\Z,(x?/\\JYٽ.5ɑ^	3hqo\Zr~[\\*A?``D56;PLDη \"`\rlcF?ю=}KD}DaD3P.8qf0T&]L&*Dsb3ۇbKx{cwʻot}ZkpFQ\0V3\nendstream\nendobj\n279 0 obj\n3628\nendobj\n280 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 281 0 R>>stream\nxMklQt۳fD!҄t]UqXkNj;ڬODV&JH*\r!I DH#\"\Z*9?Λyߗ#i89Gc&gJ3f[ jd$=9O%/Ve%0߽@[rD쀯\\RQ)EeRXpB菐P(D9,cRE\"ʂ\'xP	!Եekw#!s䑥dYHONn>mUZ1\0퇆[[P7(ԋlR*h,v٤hq|]쫆G.2J! uA+@҉ugؙ*s!{rjF=ԱWȎ+<\nv\r$*Ѓ8`Y})ȉx|㾋ܨ{/<>=ZT^?@Ó\ZMF݂ю(^~YyJ=)U0NfJ%j?s?z?Q:{󝭻w#74et\r421&;\n\'x	\rAOs_6Hµ`G@j;\"]\\pHD+ \Z\rݡaht]UjXq=:1`дT]vKk_B#5\Z:H;YP\\5n]K+c\"I{Ghͬ<e5Z>ё^̚eeY\rC\nendstream\nendobj\n281 0 obj\n766\nendobj\n282 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 283 0 R>>stream\nx]LWR,GEWeӞ2挙_3FpXuSC8.6M>*\"ZDZeO|@[cǒ)nD2]BfFo3qj^f999Pz\Z8N.(ت\\ԫ\\jaZjw?rtast,KHq[6UUTKo*W䨔{5uUe%%JQԖUito)kjE7(44u\ro{ku:e\\S!_\\]XkhZ6%hڈel.Vv_MWMphlW6$0ʏpffǇ17pqAACiΎ%sMejzG988A>1!Wz}.4|N&W\Z \0v3ӳ<β[SfNp;9A%˿PCYj[e~H.fa\nF~Φ7uY:vAZ+Th>wyr篒\'NXjM&P[kFh8I͗ƶ] tFu)! H\"88_NߐȢO׬[BX%׈vx]*OɂK__fiE\'R$AKGKe+yWKk\\h7߱\nu\n,Bnج6.XEp*\\6e%˾rS$9I\'Fp6Z´PXx-\ZI~o\rkYn{*bcҴS̭\no8lS,[Sq~I8}f -yl,50˦.<1z|8h#Fa-bJ8MHWzjA琫78`Xi;1\raBzj|J\'2~ӭrKSD;9\"&IIȿ؂g-ptJcoǡGBp4\Z&Ћhi$h?݅q<S忎j7՘).2R}ץ/g%1O{]mbFAIkWlgo? gnOWLKWE233k\nendstream\nendobj\n283 0 obj\n1153\nendobj\n284 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 285 0 R>>stream\nxcd`ab`dddu\r21~H3a!]cOu߿	}]E+9(3=DAYS\\17(391O7$#57QOL-SpQ(VJ-N-*KM蜟[PZZZd`  Ɔ|,ʗXθuϘ~Y;Sݭ؋9;}7[wsٹ5kϿ,inewku}Cn^`C{M|\rK9 ud\'aΞ|9ontg-3=N].5mnw\rݫu,Xʮ=c<_/=o*inqq\\>l^\0$5\nendstream\nendobj\n285 0 obj\n399\nendobj\n286 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 287 0 R>>stream\nx5}Le(Z5u]Q`mAcȲ Z\nv,-/]_%Җ:fq/F\'L2Qq2ci}k?$o>/I$I\r:]Ed2O̓\nglKt>?{\nݳ_ovimښ.[kh0wOhi0tvjrszlZtmf`1AԼk$R)iBGl!(Y$QH̒;yo+J7Ҩ)ّ ѫPݶ4\r	\0=\Z8!F!#MꝀDቩM#?%%঻\ZA7\" \\I&K\\J^D\r\r0~c_	]iWF<^-(wE\'\'i2smI6/=[DJrav\nܤW*_kq)4CqC4!1tB-3{.b_U[D\0H2_[񚖲X\"Nt<MޭN\\.fGg\0\rv|;qRb㧟-7~>z\r?3n+=@6~*̠Bs\Z[6N\07?\nR,e1}>ZJ27hY)T(J\n~W(C!HDcaP\rl+K$Az<*[dц)\Z@Skjjgp3x#%2r*]D΋?Jc08o8ycjQM]GPUoڍIT<Eql3^;\rDq*|qfY9\Z\ZTq9ڎ8GI8/?vs\\\0Ȥ3Ed$>\ZG)\Z.L+/?(%TRA \nendstream\nendobj\n287 0 obj\n976\nendobj\n288 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 289 0 R>>stream\nxcd`ab`dddw\r44\01H3a!;%k\n~n._PYQᬩ`hiiZXX(\'gT)8(t+@lu-(-I-ROI-KMj+I,````4c`b`bdd|?ڙr8cRV?aZ:%[&͜:qr|/d-0}3n9.<g00\0\0fZ\nendstream\nendobj\n289 0 obj\n262\nendobj\n290 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 291 0 R>>stream\nxwt׶G)y#\'!`sC(PLuXJڒmܻ$[.6c0@|C$B	FvB^{F3sηQVH$88?NĿnHvT;l\Z.qJ,-[9\"2^0y\\Ea~ p^1~a^1PM>A~1:l/OϷa?_?y8EQSćD[T!:pyLbP0N8cssz>EKSK{j6zDfPDʅZEmfS[bjL\rSèHʎR(zFSc8\nP4NݶZjxuhܤg Am\r|gȶ!EC\r}1,yuye_1#G=J~ul{m>z3x$\"V.QLF%8I\\yM2~J̒\0t_Lh\r}Uj\\t(_)jyx+o\nꦘwr`t:\\ShPڬ)O\09Ѩ3S!DƬBu䌩m*LGiV |a:cP8O4:swrpne!b Ҝor6<&V;̽=CgpªdS`mF;]6>bvW\n.nvNkŮP|\"I_~U؄fh\rЖ`Xk4yCiJCf+RAIn} F¿z2`7U[_EFQ\'\"cqhaP2\\U)lygO\\4lyO7ob>Y5%FFN&\"Sp{J9E\\YO0Dw\'mph taEg\'l\0?\0#|;0*v~mTKٕ4N(1Kd4j$v{ֺ#ߜDX\"i\"J.hxт9ʄ\nOpQTg714fhO2%\ZT0,6Ř;M-h!6H@)T\ZcHp_.]4ARY\'+L&\'htAVL)U.:PC0Z,\\#e}I3N5c&[t{lCwWC70W>IlȰsEʒ\r=:7k`p?!ɏ|/ELW/ex~	]-A^a\\o1?Yc6<7^b2h{UiTuFZ8v\Zvz\Zؽ8i?08_V{Wѹۼ􉸹w/`%Én$Б,Q\0ݤH>K%?*-숍ܸDkY7\"ypG,Jd2.2.%+~7șغ2}MӖsoߔkv tAcE/RX6`y7c~&0{(\'b@GE!sd&Kf+C\'s.|6cD¦|hd@+m`)2˞Gp5я~SibS 0$+Mō\rVx&sҫhEe7ȫw5n<w\ZڮDWIu$/?	IRb\"|϶ERUҥjYJA.dkYJHaJR+R\Z}c=28&l0Ӗ-g%۝BḴB<q~mqךs[7:\reFȁ\n=RβGvd>Fkd$A\0	#㉘/cq[8\np\nd\n!r.E;N!3qyoAW6<1݅PLդ2\\</2d[\'W\0,Ao<g)7s3!?f[wdIV-\n٠,AmiG\ZMm^,A#SeTs{]-1Dpf̟pV*f7h:ҋrڪ*N]eUA\0	};/XHn*ZQrnlsh㴩Bȭ=+ Oݜ*kOjʯXQ5Fg-y5N/B+4nqJ0*]V(#Glw9?nHeݻ(S\0e2\\L~&_Y>0HVVNbMȎf?;	zNR`! =*eeAJ\Z}QH˩0#sEp`W~R- 3Ӌ~cMb\\da[fK4Na-@SZ._ȝo<WEĞ{i˥¤}Ku,qYAjԞ3y@Ym2\0(7D*\"\"Qzi(4\rHWS\\dYFڹ|ܬ5P͐|St`yy;pQńw1_^\'%qDac&BՆ,PB#L H~	~GpH&54衴2HFP\\JfȠJ?V|ق=W	4\Zt	ݪ)#*K6M1D\nݘ6٤=^POpd]f	@NAN![zEBG{ĸw/}ߤ=3I|o	m33ڵ_\0^b&*lOW\'0OJo73YGr9tZ}۶B2וaJ}mqfVVULY2Zz\\MT&la|+x0?_9zKyzso^E.J.iwo̶p&/΢\"WlY.䇱#jCu2Ҥ_-MzL$=]e٤EoZ𝶨\Z8-Q5~#z}P`Knr^6T2L نnҋM\nWt	d$څ.>q8,)eegq\\NqۈU\n[_D&6۫\nٛ\'oOD5%ی6qτuU짉gL ~@%1nwULFN{cQ77q1\"\\irV$X*h I-/F	l)/ޛ_^nlCtMxxttxxMtCCM\0^06n`pp+,\\ϼۏN^GyOY9s-8.8_:~h{\raH\0G|\'T$`\\:i0w!g*A/;]vL£N2}et*ő	4g2ABhGUQ*x,:=y\\,$̰t=Ii+AdsSdJ[bCvEs45hT\\gZsN2+BĢYel8\Z?d׎s_,xn/%wun),X `Bg)iiczC,lgJID!M=Õ\nC]Ie+>5gpiԇG${LEh{\\{kcͼ;.l/}ZN,V͒!x˂d?Mw҇	NA*˰%l\ZQIP8Zkhf+dYAo78=!N\0t8%{U\Z䙲+(jHV2{ -QFxH+e[O}\'_룽}l<q&[#\nSMM)890mh̳Q*_-fCKp4~иGt״g$pI2+h;qlE	(D̒(}?rm;c9Bb@N.`Z{Gamvn1VWϮV_@G/hɒ[PdU1rI0fsvy⼽ׄ9ǠD)ɸ`\"܏#\\7\rOʩ.i[{=Ӂ1\\ލuۗ*O>k|V獾;r$o]\'y0	/sowRZFzwCMǾl?ZGڹ8Cb/>3Xh}\\gc-4\Z/J}˃x=Ox\r6$Gr\r2EbXS޷\"HFB>cxwO=2dC92C6 B|+:\ru4)½8$g\r1&|BaHYgs}Wٲ* Y$9bcL@Wd}$\r\\)\n]`$u^$!Ŵy!`C^FQ_un\nendstream\nendobj\n291 0 obj\n4598\nendobj\n52 0 obj\n<</BaseFont/IWRFRS+CMSY6/FontDescriptor 51 0 R/Type/Font\n/FirstChar 0/LastChar 0/Widths[\n0]\n/Encoding 292 0 R/Subtype/Type1>>\nendobj\n292 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered]>>\nendobj\n50 0 obj\n<</BaseFont/EKAJCL+TeX-cmex7/FontDescriptor 49 0 R/Type/Font\n/FirstChar 0/LastChar 0/Widths[\n0]\n/Encoding 293 0 R/Subtype/Type1>>\nendobj\n293 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n18/quotedblbase/guillemotleft]>>\nendobj\n44 0 obj\n<</BaseFont/SZPSMN+CMMI5/FontDescriptor 43 0 R/Type/Font\n/FirstChar 97/LastChar 100/Widths[ 774 0 649 740]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n34 0 obj\n<</BaseFont/AKFFIP+CMR6/FontDescriptor 33 0 R/Type/Font\n/FirstChar 48/LastChar 50/Widths[\n611 611 611]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n32 0 obj\n<</BaseFont/AKFRHX+TeX-cmex9/FontDescriptor 31 0 R/Type/Font\n/FirstChar 16/LastChar 65/Widths[\n614 614 757 757 0 0 0 0 0 0 0 0 0 0 0 0\n814 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n899 899 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n899 899]\n/Encoding 294 0 R/Subtype/Type1>>\nendobj\n294 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n16/quotedblleft/quotedblright/quotedblbase/guillemotleft]>>\nendobj\n30 0 obj\n<</BaseFont/KDIXXB+CMR5/FontDescriptor 29 0 R/Type/Font\n/FirstChar 48/LastChar 50/Widths[\n681 681 681]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n28 0 obj\n<</BaseFont/WJAQEZ+CMMI6/FontDescriptor 27 0 R/Type/Font\n/FirstChar 65/LastChar 100/Widths[ 924 927 884 998 0 0 0 0 0 0 0 0 0 0 0\n780 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 675 0 559 642]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n26 0 obj\n<</BaseFont/UOYVVL+CMMI9/FontDescriptor 25 0 R/Type/Font\n/FirstChar 58/LastChar 83/Widths[ 285 0 0 0 0 0\n0 771 778 0 848 0 0 0 0 0 0 0 0 0 0 0\n656 0 0 628]\n/Encoding 295 0 R/Subtype/Type1>>\nendobj\n295 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n58/period]>>\nendobj\n24 0 obj\n<</BaseFont/IWRFRS+CMSY9/FontDescriptor 23 0 R/Type/Font\n/FirstChar 0/LastChar 1/Widths[\n799 285]\n/Encoding 296 0 R/Subtype/Type1>>\nendobj\n296 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered]>>\nendobj\n22 0 obj\n<</BaseFont/WNKYBP+CMR9/FontDescriptor 21 0 R/Type/Font\n/FirstChar 12/LastChar 121/Widths[ 571 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 400 400 0 799 285 0 0 0\n514 514 514 514 514 514 514 514 514 514 0 0 0 799 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 642 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 514 571 457 571 457 0 514 571 285 0 0 285 856 571 514\n571 0 402 405 400 0 0 0 0 542]\n/Encoding 297 0 R/Subtype/Type1>>\nendobj\n297 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n12/fi]>>\nendobj\n16 0 obj\n<</BaseFont/MUPHUX+CMTT10/FontDescriptor 15 0 R/Type/Font\n/FirstChar 65/LastChar 84/Widths[ 525 0 0 0 0 0 0 0 525 0 0 0 0 0 525\n525 0 525 0 525]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n14 0 obj\n<</BaseFont/SZPSMN+CMMI7/FontDescriptor 13 0 R/Type/Font\n/FirstChar 65/LastChar 100/Widths[ 859 863 819 0 0 0 0 0 0 0 0 0 0 0 0\n727 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 620 0 511 595]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n12 0 obj\n<</BaseFont/QGDFYX+CMR7/FontDescriptor 11 0 R/Type/Font\n/FirstChar 48/LastChar 49/Widths[\n569 569]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n10 0 obj\n<</BaseFont/IGZNNO+CMMI10/FontDescriptor 9 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 750 759 715 0 0 0 0 0 0 0 0 0 0 0 0\n642 0 0 613]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n258 0 obj\n<</BaseFont/GKKKKC+CMSY10/FontDescriptor 257 0 R/Type/Font\n/FirstChar 54/LastChar 54/Widths[ 0]\n/Encoding 298 0 R/Subtype/Type1>>\nendobj\n298 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n54/negationslash]>>\nendobj\n8 0 obj\n<</BaseFont/VYDTTK+CMR10/FontDescriptor 7 0 R/Type/Font\n/FirstChar 40/LastChar 121/Widths[ 389 389 0 0 278 0 278 0\n500 500 500 500 500 500 500 500 500 500 278 0 0 778 0 0\n0 0 0 0 764 681 0 785 0 0 0 0 625 0 750 0\n0 778 0 0 722 0 0 0 0 0 0 0 0 0 0 0\n0 500 556 444 556 444 306 500 556 278 0 0 278 833 556 500\n556 0 392 394 389 556 528 0 0 528]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n51 0 obj\n<</Type/FontDescriptor/FontName/IWRFRS+CMSY6/FontBBox[0 0 837 310]/Flags 4\n/Ascent 310\n/CapHeight 310\n/Descent 0\n/ItalicAngle 0\n/StemV 125\n/CharSet(/minus/periodcentered)/FontFile3 260 0 R>>\nendobj\n49 0 obj\n<</Type/FontDescriptor/FontName/EKAJCL+TeX-cmex7/FontBBox[0 -2350 795 52]/Flags 4\n/Ascent 52\n/CapHeight 52\n/Descent -2350\n/ItalicAngle 0\n/StemV 119\n/MissingWidth 250\n/CharSet(/guillemotleft/quotedblbase)/FontFile3 262 0 R>>\nendobj\n43 0 obj\n<</Type/FontDescriptor/FontName/SZPSMN+CMMI5/FontBBox[0 -22 975 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 146\n/MissingWidth 333\n/CharSet(/A/c/B/d/C/P/a)/FontFile3 264 0 R>>\nendobj\n33 0 obj\n<</Type/FontDescriptor/FontName/AKFFIP+CMR6/FontBBox[0 -139 855 665]/Flags 4\n/Ascent 665\n/CapHeight 665\n/Descent -139\n/ItalicAngle 0\n/StemV 128\n/MissingWidth 416\n/CharSet(/plus/zero/one/two)/FontFile3 266 0 R>>\nendobj\n31 0 obj\n<</Type/FontDescriptor/FontName/AKFRHX+TeX-cmex9/FontBBox[0 -2957 871 56]/Flags 4\n/Ascent 56\n/CapHeight 56\n/Descent -2957\n/ItalicAngle 0\n/StemV 130\n/MissingWidth 250\n/CharSet(/A/quotedblleft/guillemotleft/quotedblbase/at/quotedblright/exclam/space/zero/one)/FontFile3 268 0 R>>\nendobj\n29 0 obj\n<</Type/FontDescriptor/FontName/KDIXXB+CMR5/FontBBox[0 -22 601 666]/Flags 4\n/Ascent 666\n/CapHeight 666\n/Descent -22\n/ItalicAngle 0\n/StemV 90\n/MissingWidth 472\n/CharSet(/zero/one/two)/FontFile3 270 0 R>>\nendobj\n27 0 obj\n<</Type/FontDescriptor/FontName/WJAQEZ+CMMI6/FontBBox[0 -21 944 714]/Flags 4\n/Ascent 714\n/CapHeight 714\n/Descent -21\n/ItalicAngle 0\n/StemV 141\n/MissingWidth 333\n/CharSet(/A/c/B/d/C/D/P/S/a)/FontFile3 272 0 R>>\nendobj\n25 0 obj\n<</Type/FontDescriptor/FontName/UOYVVL+CMMI9/FontBBox[0 -22 823 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 123\n/MissingWidth 333\n/CharSet(/A/B/D/P/period/S)/FontFile3 274 0 R>>\nendobj\n23 0 obj\n<</Type/FontDescriptor/FontName/IWRFRS+CMSY9/FontBBox[0 0 712 305]/Flags 4\n/Ascent 305\n/CapHeight 305\n/Descent 0\n/ItalicAngle 0\n/StemV 106\n/CharSet(/minus/periodcentered)/FontFile3 276 0 R>>\nendobj\n21 0 obj\n<</Type/FontDescriptor/FontName/WNKYBP+CMR9/FontBBox[0 -249 833 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -249\n/ItalicAngle 0\n/StemV 124\n/MissingWidth 342\n/CharSet(/L/y/n/three/c/parenleft/o/d/parenright/four/p/e/five/six/plus/fi/r/g/comma/seven/s/h/eight/t/i/nine/zero/l/a/one/equal/m/b/two)/FontFile3 278 0 R>>\nendobj\n15 0 obj\n<</Type/FontDescriptor/FontName/MUPHUX+CMTT10/FontBBox[0 -11 522 623]/Flags 5\n/Ascent 623\n/CapHeight 623\n/Descent -11\n/ItalicAngle 0\n/StemV 78\n/AvgWidth 525\n/MaxWidth 525\n/MissingWidth 525\n/CharSet(/A/O/P/R/T/I)/FontFile3 280 0 R>>\nendobj\n13 0 obj\n<</Type/FontDescriptor/FontName/SZPSMN+CMMI7/FontBBox[0 -20 843 713]/Flags 4\n/Ascent 713\n/CapHeight 713\n/Descent -20\n/ItalicAngle 0\n/StemV 126\n/MissingWidth 333\n/CharSet(/A/c/B/d/C/P/a)/FontFile3 282 0 R>>\nendobj\n11 0 obj\n<</Type/FontDescriptor/FontName/QGDFYX+CMR7/FontBBox[0 -20 516 664]/Flags 4\n/Ascent 664\n/CapHeight 664\n/Descent -20\n/ItalicAngle 0\n/StemV 77\n/MissingWidth 384\n/CharSet(/zero/one)/FontFile3 284 0 R>>\nendobj\n9 0 obj\n<</Type/FontDescriptor/FontName/IGZNNO+CMMI10/FontBBox[0 -22 760 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 113\n/MissingWidth 333\n/CharSet(/A/B/C/P/S)/FontFile3 286 0 R>>\nendobj\n257 0 obj\n<</Type/FontDescriptor/FontName/GKKKKC+CMSY10/FontBBox[0 -216 638 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -216\n/ItalicAngle 0\n/StemV 95\n/CharSet(/negationslash)/FontFile3 288 0 R>>\nendobj\n7 0 obj\n<</Type/FontDescriptor/FontName/VYDTTK+CMR10/FontBBox[0 -250 813 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 121\n/MissingWidth 333\n/CharSet(/L/y/n/c/parenleft/three/o/d/parenright/N/four/p/e/five/D/six/f/E/r/seven/g/comma/Q/s/h/eight/G/t/i/period/nine/u/colon/T/v/zero/l/a/one/equal/m/b/two)/FontFile3 290 0 R>>\nendobj\n2 0 obj\n<</Producer(ESP Ghostscript 815.01)\n/CreationDate(D:20060406115938)\n/ModDate(D:20060406115938)\n/Creator(dvips\\(k\\) 5.95a Copyright 2005 Radical Eye Software)\n/Title(proof.dvi)>>endobj\nxref\n0 299\n0000000000 65535 f \n0000186783 00000 n \n0000222224 00000 n \n0000186299 00000 n \n0000177985 00000 n \n0000000015 00000 n \n0000000903 00000 n \n0000221865 00000 n \n0000217953 00000 n \n0000221440 00000 n \n0000217512 00000 n \n0000221225 00000 n \n0000217355 00000 n \n0000221003 00000 n \n0000217118 00000 n \n0000220755 00000 n \n0000216915 00000 n \n0000186831 00000 n \n0000178135 00000 n \n0000000922 00000 n \n0000003195 00000 n \n0000220419 00000 n \n0000216400 00000 n \n0000220212 00000 n \n0000216150 00000 n \n0000219987 00000 n \n0000215855 00000 n \n0000219761 00000 n \n0000215616 00000 n \n0000219542 00000 n \n0000215455 00000 n \n0000219248 00000 n \n0000215055 00000 n \n0000219021 00000 n \n0000214894 00000 n \n0000186905 00000 n \n0000178288 00000 n \n0000003216 00000 n \n0000005753 00000 n \n0000187012 00000 n \n0000178441 00000 n \n0000005774 00000 n \n0000008871 00000 n \n0000218799 00000 n \n0000214729 00000 n \n0000187108 00000 n \n0000178594 00000 n \n0000008892 00000 n \n0000011865 00000 n \n0000218559 00000 n \n0000214474 00000 n \n0000218352 00000 n \n0000214230 00000 n \n0000187215 00000 n \n0000178747 00000 n \n0000011886 00000 n \n0000014539 00000 n \n0000187344 00000 n \n0000178900 00000 n \n0000014560 00000 n \n0000017553 00000 n \n0000187451 00000 n \n0000179053 00000 n \n0000017574 00000 n \n0000020501 00000 n \n0000187558 00000 n \n0000179206 00000 n \n0000020522 00000 n \n0000023574 00000 n \n0000187665 00000 n \n0000179359 00000 n \n0000023595 00000 n \n0000027166 00000 n \n0000187772 00000 n \n0000179504 00000 n \n0000027187 00000 n \n0000030863 00000 n \n0000187890 00000 n \n0000179649 00000 n \n0000030884 00000 n \n0000034511 00000 n \n0000188008 00000 n \n0000179794 00000 n \n0000034532 00000 n \n0000038148 00000 n \n0000188126 00000 n \n0000179939 00000 n \n0000038169 00000 n \n0000041625 00000 n \n0000188244 00000 n \n0000180084 00000 n \n0000041646 00000 n \n0000045061 00000 n \n0000188362 00000 n \n0000180229 00000 n \n0000045082 00000 n \n0000048470 00000 n \n0000188480 00000 n \n0000180374 00000 n \n0000048491 00000 n \n0000051881 00000 n \n0000188598 00000 n \n0000180520 00000 n \n0000051903 00000 n \n0000055292 00000 n \n0000188717 00000 n \n0000180668 00000 n \n0000055314 00000 n \n0000058772 00000 n \n0000188836 00000 n \n0000180816 00000 n \n0000058794 00000 n \n0000062219 00000 n \n0000188955 00000 n \n0000180964 00000 n \n0000062241 00000 n \n0000065662 00000 n \n0000189074 00000 n \n0000181112 00000 n \n0000065684 00000 n \n0000069133 00000 n \n0000189193 00000 n \n0000181260 00000 n \n0000069155 00000 n \n0000072583 00000 n \n0000189312 00000 n \n0000181408 00000 n \n0000072605 00000 n \n0000076317 00000 n \n0000189431 00000 n \n0000181556 00000 n \n0000076339 00000 n \n0000080297 00000 n \n0000189550 00000 n \n0000181704 00000 n \n0000080319 00000 n \n0000084034 00000 n \n0000189669 00000 n \n0000181852 00000 n \n0000084056 00000 n \n0000087972 00000 n \n0000189788 00000 n \n0000182000 00000 n \n0000087994 00000 n \n0000091963 00000 n \n0000189907 00000 n \n0000182148 00000 n \n0000091985 00000 n \n0000095974 00000 n \n0000190026 00000 n \n0000182296 00000 n \n0000095996 00000 n \n0000099924 00000 n \n0000190145 00000 n \n0000182444 00000 n \n0000099946 00000 n \n0000102802 00000 n \n0000190264 00000 n \n0000182592 00000 n \n0000102824 00000 n \n0000105514 00000 n \n0000190383 00000 n \n0000182740 00000 n \n0000105536 00000 n \n0000108401 00000 n \n0000190491 00000 n \n0000182888 00000 n \n0000108423 00000 n \n0000111211 00000 n \n0000190610 00000 n \n0000183036 00000 n \n0000111233 00000 n \n0000113873 00000 n \n0000190729 00000 n \n0000183184 00000 n \n0000113895 00000 n \n0000116766 00000 n \n0000190837 00000 n \n0000183332 00000 n \n0000116788 00000 n \n0000119700 00000 n \n0000190956 00000 n \n0000183480 00000 n \n0000119722 00000 n \n0000123648 00000 n \n0000191075 00000 n \n0000183628 00000 n \n0000123670 00000 n \n0000126815 00000 n \n0000191194 00000 n \n0000183776 00000 n \n0000126837 00000 n \n0000130560 00000 n \n0000191302 00000 n \n0000183924 00000 n \n0000130582 00000 n \n0000133797 00000 n \n0000191421 00000 n \n0000184072 00000 n \n0000133819 00000 n \n0000137014 00000 n \n0000191540 00000 n \n0000184220 00000 n \n0000137036 00000 n \n0000140259 00000 n \n0000191659 00000 n \n0000184368 00000 n \n0000140281 00000 n \n0000143385 00000 n \n0000191778 00000 n \n0000184516 00000 n \n0000143407 00000 n \n0000146763 00000 n \n0000191897 00000 n \n0000184664 00000 n \n0000146785 00000 n \n0000149795 00000 n \n0000192016 00000 n \n0000184812 00000 n \n0000149817 00000 n \n0000152675 00000 n \n0000192135 00000 n \n0000184960 00000 n \n0000152697 00000 n \n0000155536 00000 n \n0000192254 00000 n \n0000185108 00000 n \n0000155558 00000 n \n0000158293 00000 n \n0000192373 00000 n \n0000185256 00000 n \n0000158315 00000 n \n0000161786 00000 n \n0000192492 00000 n \n0000185404 00000 n \n0000161808 00000 n \n0000164896 00000 n \n0000192611 00000 n \n0000185552 00000 n \n0000164918 00000 n \n0000167717 00000 n \n0000192730 00000 n \n0000185700 00000 n \n0000167739 00000 n \n0000170491 00000 n \n0000192849 00000 n \n0000185848 00000 n \n0000170513 00000 n \n0000173600 00000 n \n0000192968 00000 n \n0000185996 00000 n \n0000173622 00000 n \n0000176295 00000 n \n0000193087 00000 n \n0000186144 00000 n \n0000176317 00000 n \n0000177963 00000 n \n0000221658 00000 n \n0000217710 00000 n \n0000193206 00000 n \n0000193305 00000 n \n0000193659 00000 n \n0000193680 00000 n \n0000194283 00000 n \n0000194304 00000 n \n0000195584 00000 n \n0000195606 00000 n \n0000196285 00000 n \n0000196306 00000 n \n0000198045 00000 n \n0000198067 00000 n \n0000198669 00000 n \n0000198690 00000 n \n0000200183 00000 n \n0000200205 00000 n \n0000201282 00000 n \n0000201303 00000 n \n0000201661 00000 n \n0000201682 00000 n \n0000205398 00000 n \n0000205420 00000 n \n0000206274 00000 n \n0000206295 00000 n \n0000207536 00000 n \n0000207558 00000 n \n0000208045 00000 n \n0000208066 00000 n \n0000209130 00000 n \n0000209151 00000 n \n0000209501 00000 n \n0000209522 00000 n \n0000214208 00000 n \n0000214372 00000 n \n0000214620 00000 n \n0000215319 00000 n \n0000216061 00000 n \n0000216298 00000 n \n0000216830 00000 n \n0000217857 00000 n \ntrailer\n<< /Size 299 /Root 1 0 R /Info 2 0 R\n/ID [(6<IGsϏ)(6<IGsϏ)]\n>>\nstartxref\n222416\n%%EOF\n','Proved',NULL),(27,'dim 100 100\r\n\r\npoint A 10 10\r\npoint B 50 10\r\npoint C 40 70\r\n\r\nline a B C\r\nline b A C\r\nline c B A\r\n\r\nperp hA A a\r\nperp hB B b\r\n\r\nintersec H hA hB\r\n\r\ndrawsegment A B\r\ndrawsegment A C\r\ndrawsegment B C\r\n\r\ndrawline A H\r\ndrawline B H\r\n\r\ncmark_lt A\r\ncmark_rt B\r\ncmark_lt C\r\n\r\ncmark_rt H\r\n\r\ndrawdashline C H\r\n\r\nprove { equal { pythagoras_difference3 A C H  } { pythagoras_difference3 B C H } }','<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE figure SYSTEM \"GeoCons.dtd\">\n<?xml-stylesheet href=\"GeoConsNL.xsl\" type=\"text/xsl\"?>\n\n<figure>\n	<draw>\n		<dimensions width=\"100.000000\" height=\"100.000000\"></dimensions>\n	</draw>\n\n	<define>\n		<fixed_point x=\"10.000000\" y=\"10.000000\">A</fixed_point>\n		<fixed_point x=\"50.000000\" y=\"10.000000\">B</fixed_point>\n		<fixed_point x=\"40.000000\" y=\"70.000000\">C</fixed_point>\n	</define>\n\n	<construct>\n		<ruler><new_line>a</new_line><point>B</point><point>C</point></ruler>\n		<ruler><new_line>b</new_line><point>A</point><point>C</point></ruler>\n		<ruler><new_line>c</new_line><point>B</point><point>A</point></ruler>\n		<perpendicular><new_line>hA</new_line><point>A</point><line>a</line></perpendicular>\n		<perpendicular><new_line>hB</new_line><point>B</point><line>b</line></perpendicular>\n		<intersection><new_point>H</new_point><line>hA</line><line>hB</line></intersection>\n	</construct>\n\n	<draw>\n		<segment><point>A</point><point>B</point></segment>\n		<segment><point>A</point><point>C</point></segment>\n		<segment><point>B</point><point>C</point></segment>\n		<line_pp><point>A</point><point>H</point></line_pp>\n		<line_pp><point>B</point><point>H</point></line_pp>\n	</draw>\n\n	<labels>\n		<point_label direction=\"135\"><point>A</point></point_label>\n		<point_label direction=\"45\"><point>B</point></point_label>\n		<point_label direction=\"135\"><point>C</point></point_label>\n		<point_label direction=\"45\"><point>H</point></point_label>\n	</labels>\n\n	<draw dashed=\"yes\">\n		<line_pp><point>C</point><point>H</point></line_pp>\n	</draw>\n\n	<conjecture>\n		<prove proof_level=\"1\" proof_limit=\"10000\">\n			<equality>\n				<expression>\n					<pythagoras_difference3><point>A</point><point>C</point><point>H</point></pythagoras_difference3>\n				</expression>\n				<expression>\n					<pythagoras_difference3><point>B</point><point>C</point><point>H</point></pythagoras_difference3>\n				</expression>\n			</equality>\n		</prove>\n	</conjecture>\n\n</figure>','2006-04-06',2,1,'GEO0008','%PDF-1.2\n%쏢\n5 0 obj\n<</Length 6 0 R/Filter /FlateDecode>>\nstream\nxMu[#ERX\"$k#|@>6a$~?zwAP`G̬}H\Zu?_ڥ6jݛ\"˚&	;?IRX(-QsjmʶjoQθ~\rq\nuR7?.	bN 1#ڑdOx\'oR9	Ȩ߶_VX/#X׻7lr\Z?;Flѫǻiߗo_WOď{FWVZYA$tfWcn\n\rX+A0kV/uU?ړ \")|ߛ\\LO#Y\\Jhm\04Llp;i\"|};ɱ3z!fQ_8r.pasvvֈMÜ-|O\nho0]ڇǩs\n=utM\'!4:h1Ս%T~9[=j M9FkA9B>(	Sq9\r޴oX\ZV~K\\`{-5;{q/1RFҮ]&+*Y7w=%fy1ҵFvj/\rf9ZlgJ<3%3k]yfJdiL$SyI|\'v~ntT\'R`iy@Q]CyhAzEudIptYv&̤eLDR{&L\"\ruUGώ/#=~pJu~0X\'\r2./poq\0O}wu\rk4䵞2 z9L\"yöDَgnWJc.@a\ZH21WdIϋL=]#\n[K̥2,_0vͧ;S=;(KaxRY7VvXȩ.W\rƴ/32犳3=fSD6g;N1\r)Hh`px8+̝ju9u-\\Z~4Ak)\":qjpOP)禍ޜWD\ZZD~kOh1\rKuvUsk74\'אލ	\nvN4Xy{n<v!~r?!+>uy ?oGf06aeBtƄ0G!5MiZj^Vjhkgs\rxDuFӓԼ\Z{\Z`P%c CfK5<yׯ,az[+-ծf4rAaW3z^z]CQu|H?\r!:):,Q>mSȨ6l/,냰j	;!nO6w\ru#Uy`yIt$6\\X{V)VBHA𻒋;W/q1ҴcE9U\"\"C#{Rփ:,xNM9ϣFgWsc{\Z+:HU1\\QhU%r\0,\ZXJ\0xVڡeC.DEʁ|\r,Xh*5W8&67f		A?b\'X$gYht\rhjxNս>fx._`jbqَ\\ɃQ)͖:HsPrNVRS1]rulE\"${]SˊECYHyvm|h\"TPG`I!%KWVc)`1,Ļ)Gv4{7d$SI2_P	M<XM>R(q֬HHv2|,++x`8pI*H\npEn^jw*W%WǓW]g~MZ\'o\'m)0SXz(؎EJ9U;}X;?ޑX{.5|~Εy-+zl5¿-ZB2hɼ=ژQU%s9\")sfsx770BavsUN^#=S|HukE\"]TdlBjET,Jz}7\"Y(Y滋y`8\n+	}q#NM^bUuV#ZuNn%ƲMIpcڅx#*wTd[$94Qr+R؍EqzNI$s\\jLH so^6ܪr&	@n2u^dREɛ;S!?윧endstream\nendobj\n6 0 obj\n2383\nendobj\n25 0 obj\n<</Length 26 0 R/Filter /FlateDecode>>\nstream\nxKoEǝ|m#aVpN@=ޱw8 [tUw~Ue4)#?UU>*ROwU7uLLlJ:`\\\r~v^U/u!s㵥`Cq\rAD!hyΰھOE\"XpS	=ju9V{zC߉ñ+2_5FA_(Nώec\\ѣig\"iy9dujW56fxש6}Vm?Q411gk9\'ꢺQ堉U$!?9ϿU}xS:Z<?:,4Iu,;F%\Z\'\r<UYG[9,qm,ixo+ዤ8٬Ӄxŭv9+HzE۽23]ȴίK QH7*EYʐbh\'uOf	\"O֯Z$!׿t߼iX!Üplo7HڗH}	lC<jl=d||ِ.8uJ߻ףp3\"!j3E\rh3{C#AKT0ȁAI]-!<\"mrqA!.OHm\"lz\\^ .4+n6i,AYqy+K,H#MrPLEzʤ(MiRs{XkRXq\Zۏ}I{@L>(싾g#bϞZYT%;G+e>i|DhY>8\Zu]x]|pI7\\KG]x{q]΀\r`+Xa{.`-Sczܻ7?=J==6GF\n@Mp_GANH	A^#*;n5Ys7Y~żcw\Zbڥ_!\n\"$Șbd!>)hW|JY8kV*nZ<z[ehʅ}L^K+HA4n\'tvZ2e9+Ȓ#{]܀\"s%ڲ-Rr	捕v(pw;=l:Ɩ0kO_,kZע00[cw[\0Y\\(e늳`d#lRvQ\rU{endstream\nendobj\n26 0 obj\n1263\nendobj\n31 0 obj\n<</Length 32 0 R/Filter /FlateDecode>>\nstream\nxZn6BRѥə-@it>$}iޤ@3Vj]خ0`ks8̐\ZW[>}]ukWY0udR퀢II:T\'??|:~]u:_T\'h}v>\\V\0lr@y:hBiQ\nؘ֚H9nXbRG7֣\r3^3\\/՟[4,0%lmސip[?yⒷ<^dD!:6;/~|b{؜/v3C?V/60v)s8jC0J&}9*oc5]Sn-_vAa4!#e9섇[b,j|_vZM7s \n~W̾-yᲉ9հL\ngaG-z=L<i1)ِ&τؼ\\L1urA^X%3,v\ryc0!ʑOc4m6j2d͓9ʔgfS9SYs0AY/O21A}P$M2Q`6^<EGؿ+Y!؏)t=U\'G_8+;TT{5\'f%g͇5A|N̍NV8Pt\ZDe\ZVAv\"vHW-;cg;}W-9wnFכ(rښcIs\\L}T9`9͹H|Ys}¢;Fչik|\'$hQSIͱ^epkp;oyn!z\\VS̼iȄg܋9Bbőnc!$Y񺤶D9A	TR\Z!S)(kд.S!OK	<{{P%#Lhh%V˕N܋e	G|urdƶhcd(Re2<2\n̮.G5C-iH鿣3:c#g	Wș07\rGeN[HGDu??E;9Vѥ	\r>\'B\\yh.CZBszʷ<\\\"2g)~}d趥hq^GϿ[ہ|tEܟ_Vdh\':yߴ[&gPQ*`r}`פ}.E]T.3;::َVߤ+[\rU8cȻda$ް\\ٔM_F]V58U\0=cӄ̀4x:K0Rd3f7+hGt7}#lT *~4H7S0:\0\Z\r)\rM\nH\n)h{.\"kQ$j?b)2tct`aP.q߭_Au\Z/TiEY\"mP12k\0&Ŗ5lyeɉLv;\n endstream\nendobj\n32 0 obj\n1596\nendobj\n4 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 23 0 R\n>>\n/Contents 5 0 R\n>>\nendobj\n24 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 29 0 R\n>>\n/Contents 25 0 R\n>>\nendobj\n30 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 0/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 39 0 R\n>>\n/Contents 31 0 R\n>>\nendobj\n3 0 obj\n<< /Type /Pages /Kids [\n4 0 R\n24 0 R\n30 0 R\n] /Count 3\n>>\nendobj\n1 0 obj\n<</Type /Catalog /Pages 3 0 R\n>>\nendobj\n23 0 obj\n<</R20\n20 0 R/R18\n18 0 R/R16\n16 0 R/R14\n14 0 R/R12\n12 0 R/R10\n10 0 R/R8\n8 0 R/R22\n22 0 R>>\nendobj\n29 0 obj\n<</R20\n20 0 R/R18\n18 0 R/R16\n16 0 R/R14\n14 0 R/R12\n12 0 R/R10\n10 0 R/R8\n8 0 R/R28\n28 0 R/R22\n22 0 R>>\nendobj\n39 0 obj\n<</R38\n38 0 R/R36\n36 0 R/R34\n34 0 R/R22\n22 0 R>>\nendobj\n40 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 41 0 R>>stream\nxM_lSu@S2콈P,e6&aFc5nOGtsoe[Ww?keQ		iQ7ʣ	#ӻ_y+/?9!fa;{j$Si2UbO}}</>;0=Cz|R}{߾RrJ=AHRWbXri}nts<MvgnRg#dq1t~qEfve,Wr-V_bؔ!\Z	M#=cGd82L?hI4\r /4X(HZLԌX\\..<;(Y:d(9{¼0LNMI(؊!99XRymr2/_Wu`ʌ~M,*Ȁi<hb\0q\'6i9#k^Mj7RKEA\">_![Ne؆{WyV*4Lo	BXUAUO\Z1=v ZFe}szd͗Y\n̍Eey<dH$&&-GnЭ%:EE>VDr@3Aʡ]mu:b}\Z?|/\"&l̬\Z2\'&!*2p.Yu;^EfPY8a\rI6tЭ|c\r+{\rnԇ/\'r	/\0?%-#aPψ^UVjrG.܃Cm]\'Ůc.cc_\n,Gw66߰lXXX!_X\nendstream\nendobj\n41 0 obj\n852\nendobj\n42 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 43 0 R>>stream\nxcd`ab`ddds\r4~H3a!ֹ}nP;*9(3=DAYS\\17(391O7$#57QOL-SpQ(VJ-N-*KM霟[PZZZXT_6QaCcb&|}c^柛\\ҽtiQw_>ڢ%33V/`w}D,*(ZVfͲek`82sɰn樛1eForovvIӺ56ߟsi~g_]7GSCG]z/^~	oi^p\0\0.\nendstream\nendobj\n43 0 obj\n363\nendobj\n44 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 45 0 R>>stream\nx}{lSu]׻6Y{;Pyl#@D-c\n0^]>m}ۮۺWvcSd	8Nb@AfbC@No	2/M%&P4M3_\":8!t7L-9s1c6.Ch7viV(3yU*ujeaL+]*5UZʼJeQFYҨ:=jj*fJ]MQTR^~m)j	zzʤPDJ%Q\'MՄ2Jeb#HCAEca\Zu8K^^_0-nв^x;\npIp\Z3[{?`cyI~x;G@u]>w{`,tquf{%\něrOcQz|h<jʅ:ppY4K*p127cR0^{*I3\rFP{ \Z6hvaObmmyHlЖYd6Od\\ Bfp^dݾUd/i.:(Jߗ=9^wv[m\\H#~\"DCrQIXzob(v4z-\"$s3G\\;r3c8XT^bpK|BI($UPRiZ|kE> kyIM?SϰVń05dd93퇕RbuEe	w>QfpgZD!ޫeTh435~`-`t.=x| \0^+v vZ1K31ɩ2-)b-sIC	vp\\)mR6n9g(\\]kK%OW^L;]wԁ7tWhynOA\riS_{rɂ,xEQm	~۩ro<	\'?!wƪ+8zE6i(vJ,\\+g1iG6G 5P4N6]3AvuIAD|.nkv7pB,ݭ	Kqd/KL1rY[/wvn-:\\do-&\0I1tL= e]d2\'Buۑt&y<KN\n8MM?\0捙v\nendstream\nendobj\n45 0 obj\n1244\nendobj\n46 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 47 0 R>>stream\nxklSeiak&,9\r\n8	crpeˀ:;6kq[˹<]vۨl	q}@AE1#fAIhD	&OP$y{IL$IRo-MرL,=&/\'w\Z44\rr&)$ٚ_Y[՘_[4ϼb.o.,)Th6VKcyf.IQm.T[u==++jk,vsa}?Aik_`A&s,b1Aki>PפM(2xBn&&=$жغ&.!ܒGuw+:SVcVGQ(VŮ	\0nl:XMv^R`)8 :1.Bfxܮf\Z7>.0)|ݠ;q(5w}TL\ZQިuغ\ZŎZ2P,G}5\"`]nb\'{HW>t>3D3GEs;mS- C~@ǧԥorsc#;Z7QH.Hg~\'ce&%1hYj<r3Ey/K)${=\Z;p=20r];{4{C7AU1D/1[q.6G|CDW|sh?묂\\,%\nn?i꒤~KrnSʐ\rE8K\rTԣTlǋWfJ^߀u\Zz^	$hc}R#1gK?dE#3\Z1\nU;4jf$O_ak^|*vi#oP$BS+ټf]~wH+c\"CG40#3gDqAx`sq꣺抢d9J DFqIR\rbw2\rwWp\r2jz@t8?$ HJk8,;Uɪ/\0\0lDA_Y٨ux;Jh\'m\nMaViO\"Uq=;vM>q~z_--P\'\0_5kSDRaTsI~#T)oJRijDmuqlf˄\'4ld*<W\Z~~A	hɂ8XSZ8%fd<~o/Q&8~7~\n2\"mUPy[Q\'ң?\\e?^y3rR᧛ROp¥DLľH	u1\nendstream\nendobj\n47 0 obj\n1288\nendobj\n48 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 49 0 R>>stream\nxcd`ab`ddds\r~H3a!+o\n~7n(_PYQᬩ`hiiZXX(\'gT)8(t+t-(-I-ROI-K,*/d1J	+1>{VtW9V[]V:{<FZg`_tE⢼E+W.^B?QKn.74\\&퓦ϝ\"+O=_ygŪ\'6vs475(w[M9҅?Ⱦ|m3xx\0L\nendstream\nendobj\n49 0 obj\n370\nendobj\n50 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 51 0 R>>stream\nx=Q]lUcbX[hI!TO4&h@6<Mvi]hidw;33wghk)-b*Ә\Z@Hx Rドфxg5;99|(4	(6y%^:mbl+]yUŶ]CH4\rE|G|;;7|-cCA\ZZ{VBchFuː\ZZV]x<5364q7sߙ@6^lccsRt`dpx6dӲԔ-Yq,M[sivttwh\0H3%82	D8;ɻ;aWlaӡ/CK3ihLS4_V*1Jdd8r0\ZDi+vlxm/x:~x\Z..KsȸjF=g\Z<opb&K×Cm\0:pxRH\\muWu4?;c0%&\ZyzBśad*=[oqq}3ر󧣥X)eN\nd\\)?l\'P;/%>z}d\0-a+Ta+\'&ON(;qWT#:Uk+ޣ}LT짍װK|k\\?/0{	w|O&ǒIYfL%EQX)GuG3^p\n|jbjjr+	0N!`li/4_FG?f<чv¿68\nendstream\nendobj\n51 0 obj\n812\nendobj\n52 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 53 0 R>>stream\nxWyTSwH+jm^X7\".Ūk  YDV!		bY\\@YTTܰj]h`bca<j3;9g受s^<dC$ih}gc}_\0X՛j[05q@t[U\Z/	\n;Nu8%\\,E8zp!q,g;H$vGe3]1rC\Z E1n}|4 R,HD~S͜;o~hy)A\"&b	Fl&܉O5b-A$6[1N FxMcwK&(xAț6N6͂% r	BP\'\n\':oؽmgwwps?zh+M^B\"G\n\Z;yL5d>f[;|Ӓ\nV@r+X|L6\"Y`]T-TJI ITKKf5A&(3S2&1x*I/оSYzBy4\"P\'R\'\\]QcIiׂTe	g>op9-|ַM$\ZԅP0v%Ji͏B<Ii+n氎ک5jіgB+i|k̡_<y{#I/>9+y24fX	Llf\\\"DQJ!˕UGQ3p̼w\r/TJ	=msϠhKEgղ|ȇN7ݨ[`U\n;(<TFr`qb$?\ZըifhӧJB*DY^ @DKsg7}TSL(\n-ѻW۾h8\r3xhM2nfZթymwxP퍕Tn7F5F5/ahm<f8|p,J\\\0\ZPjA3M։fu2tPvb@LUFՆ^\Z\rF6h4ble{~ho#`ˬULsF4?Jzb_qe]4-#yeF?FnnQ<cϛ[m?kG2\rEC^We䦦ejI{䵡mKHg|4Q%QENjH;rc/@SPjMB2Dӑ=5E\"9y%s۵EY5<㨕`*~WEVG{֞h5cJm7Ikc-Py҃D2(4zWMP^N2R\ZT;F!_W4>aUT/3P=dJtU%ft20r,\\;kK˹҃׺rȃ~b5QiѺ9jHNbAssLJ⨊Vrd)T=L\n&C⤨?MfU5@\'BZ<GQ{ 07+-(ikVx94ݾ~2*,(ϥ8*getЇ+\Z#\"oLf%CzŐWɑ;xK6\ZLWG\r1҂ȿvfrNd$K\ZU!ob;[(IP;|W+~\"W=\"HdFkSme2KX)؃W<7N@)?m*>9G9\ZK6	w-mh8ig~B5U?3wzG]gxq=OvVI{*uMr4\\Uek~5Ч;PjzE{kp69s1#jYr;/R h-e]Z+wU{ZM4++_OPWЫ!Cb;Eҭ#<\">u\\Y?x7}xu?Xe)Yxg@tO	ۯ@9d6&8])ܭQ1a~bctCH,ONSG)@Oq*9yAv+95h\ZfgkC/y+&>3\'Xx]=+-8J棟F|l!&0?)4UV\r\0<!\nI]*32h6`ۈ<˶>3Ȟ~\\EVZ\0-e ffVGCg+.\"! XYYg*)b7;DFGwrO`#,5#-c1,MKZ>:>.s㓚_}\ZKM&\\6\"t\n龿ZVG3|v>)eS,~[<[,\'ޑIxVl%WLgaa8=z~è٪W/-W(VR))!=Ս\Z	kh\Z^҈y,ҹs7ejJkb\rh2Y㭫nۤe|qxVXG\n\"Jd⊉lB$LȪx /._>l\rg2},|h~G/uг=u\'/MtPZ.	a+/ڀ~PfGxLI|jZ\riIӀN:\0؁e^G\ZMb*?ʅ|G+sM]m;\ZC_/-(b*EsehBʂR	л+LM%ҿn_PLF5dH*g53@<;HR_.R$R&poʂ\\uкzKLYd4Ws\0\r9\Z,&}c<Qx\0_eAG]̊ :0AUg6՜o{qx$F4)Ac9ϰ\Zf<!%ZqR\0JD<+mlyފ@}ֵSY5~57KՍIPkԐr(zZQq$=dK 7җ;>=lőŶK$WmB%7ɏÆf\0N}H9Hfx˩VGHUNKXlkfW8_T{y1[]bm:;\'8QĶQ~@DjEVΜ29Og7yqq1=ͼ@i8~q~-\"~tiey4	/WAͣ^ٲjƝrv&1PuQSa^ϒV^ypԥ:gnx\'u?XP3UXSY-<>z\0ѕ:T}#$EFlm&ƣ\'3cMe,f>fxî(@/S#5\"X喝Rv+C\'nlBȎ^/7^poꠈ\rfJ`+ 0)bcP\r1.7C(@\n)]`n-S}W	\nendstream\nendobj\n53 0 obj\n3558\nendobj\n54 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 55 0 R>>stream\nxcd`ab`dddw\r44\01H3a!;%k\n~n._PYQᬩ`hiiZXX(\'gT)8(t+@lu-(-I-ROI-KMj+I,````4c`b`bdd|?ڙr8cRV?aZ:%[&͜:qr|/d-0}3n9.<g00\0\0fZ\nendstream\nendobj\n55 0 obj\n262\nendobj\n56 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 57 0 R>>stream\nx}{lSuw.0@uTGoyaC6!%lH\"\Z*{Ji7ڵz{}l]Q[h\0MF\"E20!cb<Q~|{~IO#ðE%%kxI%fǴ{C9uip*=ETS\"zS\nn~E˖u5S\nCVrm0n4_VWR{te=Pgf^+1LEֿQL2#ϑE$N!%dY|V6!}d#r_lq|+(1\rv\r5#~Çp.dowxa\0¡@{ xz`傣ezasDG0G+F#]v_*y%?=b[hl}@ZB#x4$_²+jg\\\0>X\Z,@5f2\'XWi8al11\0QW\0B7@]s	}wiX%O+\ru$wq +[Kd^[XI>ΌJ^O%ve32\n\Z*P\'t>s{}7!Eඉ&vEuz:tgx\rc&N/^mZOӍw U +9~[W͊|dфk173WXSOI=.Gg~k1;haeK)Cq4W͔icS9\rYxW\Zװs s}%:-9~h\\r.{RjzH1_<\0\\vJu^Adhwq8U6;YW\'q?$Gp5~V!$EI^K罽ꕲf^\rv6y	x$9QwwʁS4Yj;mҢ^n9:횞]w5}.ǫJߐL?d[.Cr$W\\7M7\'x$;XľD[$x8G;рV>_x5!W(Ի:=G/zu`\'S}u*Me|Y:G<i{Y4[:||n5|-FC0K2\'~?I;1]˚0\"/\nendstream\nendobj\n57 0 obj\n1206\nendobj\n58 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 59 0 R>>stream\nxT{Pu`YNv+C\'|`JR\"Sf	\'Rݻ(xc:eik1%98YǌnPk&鏝ٝ> Д+?\"=4\nY!;#YϢϠ9ь)SN)**[oE%$%Ksuنlؠ,f7lЭ(խЗK%\\}I!EQl)/Jͤi+ԫT5zKM\"tPj>*hTu1xOtoZ[IP&gqnZnd-Nk}\0vjI2	z46z%8X9G-X)T}\nzK\01Bm:4@lfŕi\Z\n#!Aw}R5\\anh瑟AQ\n{>L0fNp`*\'~;@lEjf:\r˚-+@4k{ykj@d	@~@̝3qOHO1>M_/(bIE5\n፸\Z\'0Lk:0ߺv*6а05#5s٦E}bt?$_?$b6G7zrS?P}8}?\nۦz#yryEţ`<3n{K\\k&aG#O*8/\\ 	O06U\'} \\Idߣ3\ZȠi/\rx|?NS#IJ9BnR%T+v\\<:;Pqjnż<~է4%|ֵ@ hd2+AsIXDn	^\'\rӟ 4;sKPg.E]\0:,&ŹA!.L<11dq_E1H0D[1U1=C:Q\n%U6U<>aqc[ƭ,ؠ<Cibeo̅ͅes5Bs(Aʢh[7۸wU2\'Q#YlB1/[\'sI\n0\"\0BGE$PK.T˱% L>rQEgU~Y5u]BF9Co\r9T͏1m\\B̌XՍlsn\\${YZE;fĕDis9%}sd_隣D~$`hʙVSSk6~bY8s[X8;͒eniap\'v).,x~g^Wx8E!\nendstream\nendobj\n59 0 obj\n1362\nendobj\n60 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 61 0 R>>stream\nxcd`ab`dddu\r21H3a!G&u?\n~*_PYQᬩ`hiiZXX(\'gT)8(t+t-(-I-ROI-c```4d`dbb`add?U|V3[+x>w?~foݨ{]M<1}r}߆_~Ѽ\'NC5je߾~QE}GS[kOjv/~ktn7Nm]WWw+G[_[~\r4)Y{ӏZ+ۻs<Uӻ9Rؗv>O/{Vw\\B\nۡ݇fvM	*3-iYNƾ|Փxxe`\0\0}Y\nendstream\nendobj\n61 0 obj\n434\nendobj\n62 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 63 0 R>>stream\nxWiTS!@%Գ7mmš*-UqE2 )ʐM\0dNa0  \"JjzZNj7Q{{sZ{%yD\r%$Vsjd#fc8dvkx͑8aA硔X$Zb˂ȨX\'\\̙4?<P=/i_lH`_C>2`{`ld2:1Nc;=(EliU@yEQ\"\"\n\\H$v\"c/yw&Ou6}{ZC-R);zZBMR(jLyR˩\r\nj&ZEQ\0j eO9PCa#%S#1G9PP4U& ҈$EbFNv8`#20iσU\rvkpXr08tq>gaaXoUo6CSXvˢ0o-[uC[UGhb!t\n-#͚Dn:=mIhWgA֨&(tf: @n8PD#w%RxD.^e\\#0U%q]ޭ\'/=[	UM̤lkUn!G|nv誡\nNjb*+_.xsGn69z\ZnY֘\\\Zw7\\H/?J;En7Q{44a&Mx__貸*}避mB(2AG\"&/O	f#8gh=wA;XTJeQTs[0z=602Pʑh!(|\nGQ8w`T(}\"6Ҩh2bP$Џe4+3Ӌ_h2މ7FVy!OX\"%3h%~@21|!*Pt,@|1P}\'4@kٻ Ԑ8s,j,sjĘ;ݳ_|(^SPi5Q5yuPkB[5o)ӵ4ˤ#R` T`df:Ba.Jͥ!!8h*79tcopek;k;tbG͞o\r=a+`p/?!	\">zड़4/%jO骠\Z:\'+z9	t-q\'k#χ)cgFc(.߫KߣN۫CƺnbO@42Z2i>M`\rz:w\"},n*:e0WIr12?@q-#cЅtb9]iK>nE#kf+q-qQ߶M?fq+(Bۮ߉qe,3\'fCj1LlI\\um)~âY^kr%r6]\r68b;Fjof?(n1{Kdr\'jyK?,śL.M\\0U|?J(!<cD®ＬRҏ6_Je_ROWc8\ZGwсFǩ4q)D\ZeuuZ_ॾɜ*Є}-*_ݪ@p9wݮ4\Z!\'q;WTkM||b4aIr~oJld\00ιlsdWv6+ƃel(3ҕ$TmI2L^Cci+)!Bi/\nqk|!Yp/\Z;6pja\ra:ȂR=R5?F[pxmxm!FKIt0xRp8,\'K;d\'8L}y\\)GuCrfn\r^ ?s!XO=`!:}s!6亦_wgNf?0^qJ>=>,C@bŵN{4\Z-+bON2Bz֘qc\',`6>m<*df&d$Zmy9Ӂ1At|hݶ\\\\Fzu}sZnMLi	c\n!BB2]\r)8U=\ZH(t}HIdI{2Nkmn*|o6hWr[CQ\n=͖̎gZf	lp@0y[̣ݜA\Zu8,dduLe[\"li<tɠ*2\r<~RF6tQd5E?3\n|꓃֮~oqz4z/8$VzLĕrfNF-ɐ)j.]=h!d-{Bze{,.f҄7DN۩<eͼI[\'7DQQhsPZ9B\Zo5BW..dRu쌶S~b\Zd\nSqҙ5r--1ϫr_1Z$Wp\\\\q}ddB\\3g|v\'l[SQS[[Yi}ͥw\01&Q	s` ޓ{}(\'\n;gD(6dbC\\LҒ3>OE\0\r(:[*iCQYV@rA78t?*\rB̵$-36WQzK*GDkHhܖ|$XV(̞nTU3	׬Ws/@VZ/Y^ϼBH;q.gtkOL`MӫFCcwO[n/FHw*WlV@_0O4ehƱlhhm͛K3gײp}bUMjzGZۦArjjeüP~r.eѓlp֛8g@|?\\lwEoYb`w_+#Ro<ta\0qŞ/h6&nr7z%3I	;mAIs+4FWVgR!&ʘ&!MfBӯ<$z91\"K,%1A(vp+/1LHrM\n[v- dqVd=n\r`Oii*P\'?9%ӁD\n])BpW1iY\rphppQKJXV\"r@믑]\ZX_nUqc(9\'*21\Z)s_Nv=NJai5\\䋗Y~=ˏ~Sk-rtWxe=v脯Gξ_3$\\fZSp>ЕY䙄FWBsz+a,QH.[H@&QШ/;],jtA£NU1}t*ŅI\Z2a\Z\n]TM3\'x_S}v\']B K%=Oq*r;(\\\'niOBfijШ;s{s*xPRh_(-bVsI8O>39s\n3F/dnL?3k\ZkzcI/H]|pIQG[䚽u*դj`7#S*s;*Ѵd<ymqOBt1Qdko\ZF{HqmlMn[Vd,9|Ļd8#LyD(}i?M[8D+!|ZqB\\fZ%a+M5	R{0,& ͚fqa|Xtq^|ߏx+b$}$\ZIu)FH~<{7v~\0c_:\nendstream\nendobj\n63 0 obj\n4035\nendobj\n20 0 obj\n<</BaseFont/YWRBPR+CMMI5/FontDescriptor 19 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 1036 1037 996 0 0 0 0 0 0 0 0 0 0 0 0\n875]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n18 0 obj\n<</BaseFont/SZBQCB+CMSY6/FontDescriptor 17 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n963 380 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1222]\n/Encoding 64 0 R/Subtype/Type1>>\nendobj\n64 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n16 0 obj\n<</BaseFont/MUQRQK+CMMI6/FontDescriptor 15 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 924 927 884 998 900 0 0 0 0 0 0 0 0 0 0\n780 0 0 757]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n14 0 obj\n<</BaseFont/EFYKBB+CMMI9/FontDescriptor 13 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 771 778 734 848 756 656 0 0 0 0 0 0 0 0 0\n0 0 0 628]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n12 0 obj\n<</BaseFont/SZBQCB+CMSY9/FontDescriptor 11 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n799 285 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1028]\n/Encoding 65 0 R/Subtype/Type1>>\nendobj\n65 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n10 0 obj\n<</BaseFont/YAUXEU+TeX-cmex9/FontDescriptor 9 0 R/Type/Font\n/FirstChar 16/LastChar 33/Widths[\n614 614 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n814 814]\n/Encoding 66 0 R/Subtype/Type1>>\nendobj\n66 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n16/quotedblleft/quotedblright]>>\nendobj\n8 0 obj\n<</BaseFont/GHNQRB+CMR9/FontDescriptor 7 0 R/Type/Font\n/FirstChar 12/LastChar 121/Widths[ 571 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 400 400 0 0 285 0 0 0\n514 514 514 514 514 514 514 514 514 514 0 0 0 799 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 642 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 514 571 457 571 457 0 514 571 285 0 0 285 856 571 514\n571 0 402 405 400 0 0 0 0 542]\n/Encoding 67 0 R/Subtype/Type1>>\nendobj\n67 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n12/fi]>>\nendobj\n38 0 obj\n<</BaseFont/GKKKKC+CMSY10/FontDescriptor 37 0 R/Type/Font\n/FirstChar 54/LastChar 54/Widths[ 0]\n/Encoding 68 0 R/Subtype/Type1>>\nendobj\n68 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n54/negationslash]>>\nendobj\n36 0 obj\n<</BaseFont/WSXSQF+CMMI7/FontDescriptor 35 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 859 863 819 934 839 725 0 0 0 0 0 0 0 0 0\n727]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n34 0 obj\n<</BaseFont/GCFFPC+CMMI10/FontDescriptor 33 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 750 759 715 828 738 643 0 0 0 0 0 0 0 0 0\n642 0 0 613]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n28 0 obj\n<</BaseFont/EMLRVG+CMR6/FontDescriptor 27 0 R/Type/Font\n/FirstChar 40/LastChar 49/Widths[ 481 481 0 0 0 0 0 0\n0 611]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n22 0 obj\n<</BaseFont/QYXKNE+CMR10/FontDescriptor 21 0 R/Type/Font\n/FirstChar 40/LastChar 121/Widths[ 389 389 0 0 278 333 278 0\n500 500 500 500 0 0 500 0 0 0 278 0 0 778 0 0\n0 0 0 0 764 681 0 785 0 0 0 0 0 0 750 0\n0 778 0 0 722 0 0 0 0 0 0 0 0 0 0 0\n0 500 556 444 556 444 306 500 556 278 306 0 278 833 556 500\n556 0 392 394 389 556 528 0 0 528]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n19 0 obj\n<</Type/FontDescriptor/FontName/YWRBPR+CMMI5/FontBBox[0 -22 975 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 146\n/MissingWidth 333\n/CharSet(/A/B/C/P)/FontFile3 40 0 R>>\nendobj\n17 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY6/FontBBox[0 0 1128 432]/Flags 4\n/Ascent 432\n/CapHeight 432\n/Descent 0\n/ItalicAngle 0\n/StemV 169\n/CharSet(/arrowright/minus/periodcentered)/FontFile3 42 0 R>>\nendobj\n15 0 obj\n<</Type/FontDescriptor/FontName/MUQRQK+CMMI6/FontBBox[0 -21 944 714]/Flags 4\n/Ascent 714\n/CapHeight 714\n/Descent -21\n/ItalicAngle 0\n/StemV 141\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/S)/FontFile3 44 0 R>>\nendobj\n13 0 obj\n<</Type/FontDescriptor/FontName/EFYKBB+CMMI9/FontBBox[0 -22 823 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 123\n/MissingWidth 333\n/CharSet(/A/B/C/D/E/F/S)/FontFile3 46 0 R>>\nendobj\n11 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY9/FontBBox[0 0 970 430]/Flags 4\n/Ascent 430\n/CapHeight 430\n/Descent 0\n/ItalicAngle 0\n/StemV 145\n/CharSet(/arrowright/minus/periodcentered)/FontFile3 48 0 R>>\nendobj\n9 0 obj\n<</Type/FontDescriptor/FontName/YAUXEU+TeX-cmex9/FontBBox[0 -2957 781 45]/Flags 4\n/Ascent 45\n/CapHeight 45\n/Descent -2957\n/ItalicAngle 0\n/StemV 117\n/MissingWidth 250\n/CharSet(/quotedblleft/quotedblright/exclam/space)/FontFile3 50 0 R>>\nendobj\n7 0 obj\n<</Type/FontDescriptor/FontName/GHNQRB+CMR9/FontBBox[0 -249 833 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -249\n/ItalicAngle 0\n/StemV 124\n/MissingWidth 342\n/CharSet(/L/y/n/c/parenleft/three/o/four/d/parenright/p/e/five/six/fi/r/g/comma/seven/s/h/eight/t/i/nine/zero/l/a/one/equal/m/b/two)/FontFile3 52 0 R>>\nendobj\n37 0 obj\n<</Type/FontDescriptor/FontName/GKKKKC+CMSY10/FontBBox[0 -216 638 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -216\n/ItalicAngle 0\n/StemV 95\n/CharSet(/negationslash)/FontFile3 54 0 R>>\nendobj\n35 0 obj\n<</Type/FontDescriptor/FontName/WSXSQF+CMMI7/FontBBox[0 -20 893 713]/Flags 4\n/Ascent 713\n/CapHeight 713\n/Descent -20\n/ItalicAngle 0\n/StemV 133\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F)/FontFile3 56 0 R>>\nendobj\n33 0 obj\n<</Type/FontDescriptor/FontName/GCFFPC+CMMI10/FontBBox[0 -22 804 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 120\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F/S)/FontFile3 58 0 R>>\nendobj\n27 0 obj\n<</Type/FontDescriptor/FontName/EMLRVG+CMR6/FontBBox[0 -250 505 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 75\n/MissingWidth 416\n/CharSet(/parenleft/parenright/one)/FontFile3 60 0 R>>\nendobj\n21 0 obj\n<</Type/FontDescriptor/FontName/QYXKNE+CMR10/FontBBox[-40 -250 813 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 121\n/MissingWidth 333\n/CharSet(/y/n/c/parenleft/three/o/d/parenright/N/p/e/D/f/E/six/r/g/comma/Q/s/h/hyphen/G/t/i/period/u/colon/j/T/v/zero/l/a/one/equal/m/b/two)/FontFile3 62 0 R>>\nendobj\n2 0 obj\n<</Producer(ESP Ghostscript 815.01)\n/CreationDate(D:20060627000418)\n/ModDate(D:20060627000418)\n/Creator(dvips\\(k\\) 5.95a Copyright 2005 Radical Eye Software)\n/Title(proof1.dvi)>>endobj\nxref\n0 69\n0000000000 65535 f \n0000006062 00000 n \n0000029628 00000 n \n0000005989 00000 n \n0000005533 00000 n \n0000000015 00000 n \n0000002468 00000 n \n0000028076 00000 n \n0000025016 00000 n \n0000027825 00000 n \n0000024720 00000 n \n0000027608 00000 n \n0000024390 00000 n \n0000027387 00000 n \n0000024188 00000 n \n0000027166 00000 n \n0000023986 00000 n \n0000026948 00000 n \n0000023656 00000 n \n0000026733 00000 n \n0000023464 00000 n \n0000029287 00000 n \n0000026340 00000 n \n0000006110 00000 n \n0000005684 00000 n \n0000002488 00000 n \n0000003823 00000 n \n0000029055 00000 n \n0000026165 00000 n \n0000006217 00000 n \n0000005837 00000 n \n0000003844 00000 n \n0000005512 00000 n \n0000028831 00000 n \n0000025960 00000 n \n0000028610 00000 n \n0000025764 00000 n \n0000028405 00000 n \n0000025525 00000 n \n0000006335 00000 n \n0000006400 00000 n \n0000007338 00000 n \n0000007358 00000 n \n0000007807 00000 n \n0000007827 00000 n \n0000009157 00000 n \n0000009178 00000 n \n0000010552 00000 n \n0000010573 00000 n \n0000011029 00000 n \n0000011049 00000 n \n0000011947 00000 n \n0000011967 00000 n \n0000015611 00000 n \n0000015632 00000 n \n0000015980 00000 n \n0000016000 00000 n \n0000017292 00000 n \n0000017313 00000 n \n0000018761 00000 n \n0000018782 00000 n \n0000019302 00000 n \n0000019322 00000 n \n0000023443 00000 n \n0000023871 00000 n \n0000024605 00000 n \n0000024908 00000 n \n0000025441 00000 n \n0000025669 00000 n \ntrailer\n<< /Size 69 /Root 1 0 R /Info 2 0 R\n/ID [(RK70ϭNW2V\\rp;)(RK70ϭNW2V\\rp;)]\n>>\nstartxref\n29821\n%%EOF\n','Proved','BZh91AY&SY\06\0P\0tg!j`^>\076PR*&\0\0\0\0\0DFF\0\0\0\0\0\0\0ᡓM\r2442242FM\0d1C&\Zdhiddhd&\0ɑa\nEMS\0i\Z4hhC\0\Z4aPѦA\0	z&\"\rbM\' h4\0d\0A@E(5Uj\Zqi-C*(Y(4ըq3$8diM[Pء~ґ#5S5MemNJ0T\\TI;|؜ӾWp.?¦ ɛ@,\0	CP q$6<F0xi xt?}k̧I>oGˢU+5UJJ#`OIҮ?@W :9*;Ň+~ٴ\r1bimSTLҵYj[R+Xkd*-2v9$vIᗚNK¨z|9\'}<@*\"8\0F(EE\n\0-F@\0JBD9\Z1kd:.A3+ʚ1GY+2DґZI@2!ec ,\0000\Z*c1erc&M-jMi\nBfF\Zi+L 8A	\"\n\ZA&1[V3\rN(`((pZ\"f\")ZReEbH)HͦUrT{RyytwАcw210\r>.|Bs@)/E]U+UB\'ΧOU|\'];$.v.}\'PK9/BR#;Swuw^]#:Gx\\]iߔDCxG2såtUvxV.8pZqʗ\"r~v#;},s8bxےN%<Ksn!\'9~/dw	dr&StUUKRs`),:2\rԙ&M&#\"E!ESt;B&\\mh*\nip[ZJ	`ҐAvfELebdjQr[\rѬkrN|8Qr0ɜ#C\"PBP20ABA-#2+e5X0 *fdV1lل:% TU1lۄlXaq\"J\Z6M\Zƒ:$o-q5Ww%p<xX*ļb\n2BtOEJZiKT%FrtٙɆ\ZJ]el|G(mh` ?_^1b+F\neؒB\"yQxP=S07kUC?(\'D,s|\'_=a:GoCߙBwD/Oqz\"y)</e;It\"\'[娓6{gCBv~}.j^xb]}tO^\nxljyP{TT|}%O4K&@UH2+*b#S0_TbE}ocN4cZf3==~t*tmfٙfyD/59Pܕ\\\\;w^.TUiJD4#\ZZV%3Tb22,,z.mu	z;7	o]]9)ġÅ*.gCI{z;%~w2NU;*K@jZ-Thō4)^A3mr.Ge	/ΫU!UC:׳sysz^ubB%S]%҈_S<|^ܧ\'YR)|J==qC^9D.QO\n^O^B^Oizq7ƆqG*B׮\'\'g8߀N5BWTx\"v<:<oRsIJdŦMiwݲ{}Yɗ%[Dl4,zxF\no.C^>ʆi=:<\'/JZ]P({_\"&AUB Xalje*2?]BC\0ۤ'),(28,'point A 20 10\r\npoint B 70 10\r\npoint C 90 40\r\n\r\nline ab A B\r\nparallel cd C ab\r\n\r\nline bc B C\r\nparallel ad A bc\r\n\r\nintersec D ad cd\r\n\r\nline a A C\r\nline b D B\r\n\r\nintersec O a b\r\n\r\ndrawsegment A B\r\ndrawsegment A D\r\ndrawsegment D C\r\ndrawsegment B C\r\ndrawsegment A C\r\ndrawsegment B D\r\n\r\n\r\ncmark_b A\r\ncmark_b B\r\ncmark_t C\r\ncmark_t D\r\ncmark_b O\r\n\r\nprove { equal { sratio A O O C } { 1 }  }','<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE figure SYSTEM \"GeoCons.dtd\">\n<?xml-stylesheet href=\"GeoConsNL.xsl\" type=\"text/xsl\"?>\n\n<figure>\n	<define>\n		<fixed_point x=\"20.000000\" y=\"10.000000\">A</fixed_point>\n		<fixed_point x=\"70.000000\" y=\"10.000000\">B</fixed_point>\n		<fixed_point x=\"90.000000\" y=\"40.000000\">C</fixed_point>\n	</define>\n\n	<construct>\n		<ruler><new_line>ab</new_line><point>A</point><point>B</point></ruler>\n		<parallel><new_line>cd</new_line><point>C</point><line>ab</line></parallel>\n		<ruler><new_line>bc</new_line><point>B</point><point>C</point></ruler>\n		<parallel><new_line>ad</new_line><point>A</point><line>bc</line></parallel>\n		<intersection><new_point>D</new_point><line>ad</line><line>cd</line></intersection>\n		<ruler><new_line>a</new_line><point>A</point><point>C</point></ruler>\n		<ruler><new_line>b</new_line><point>D</point><point>B</point></ruler>\n		<intersection><new_point>O</new_point><line>a</line><line>b</line></intersection>\n	</construct>\n\n	<draw>\n		<segment><point>A</point><point>B</point></segment>\n		<segment><point>A</point><point>D</point></segment>\n		<segment><point>D</point><point>C</point></segment>\n		<segment><point>B</point><point>C</point></segment>\n		<segment><point>A</point><point>C</point></segment>\n		<segment><point>B</point><point>D</point></segment>\n	</draw>\n\n	<labels>\n		<point_label direction=\"270\"><point>A</point></point_label>\n		<point_label direction=\"270\"><point>B</point></point_label>\n		<point_label direction=\"90\"><point>C</point></point_label>\n		<point_label direction=\"90\"><point>D</point></point_label>\n		<point_label direction=\"270\"><point>O</point></point_label>\n	</labels>\n\n	<conjecture>\n		<prove proof_level=\"1\" proof_limit=\"10000\">\n			<equality>\n				<expression>\n					<segment_ratio><segment><point>A</point><point>O</point></segment><segment><point>O</point><point>C</point></segment></segment_ratio>\n				</expression>\n				<expression>\n					<number>1.000000</number>\n				</expression>\n			</equality>\n		</prove>\n	</conjecture>\n\n</figure>','2006-04-05',2,1,'GEO0009','%PDF-1.2\n%쏢\n5 0 obj\n<</Length 6 0 R/Filter /FlateDecode>>\nstream\nxMu[#ERX\"$k#|@>6a$~?zwAP`G̬}H\Zu?_ڥ6jݛ\"˚&	;?IRX(-QsjmʶjoQθ~\rq\nuR7?.	bN 1#ڑdOx\'oR9	Ȩ߶_VX/#X׻7lr\Z?;Flѫǻiߗo_WOď{FWVZYA$tfWcn\n\rX+A0kV/uU?ړ \")|ߛ\\LO#Y\\Jhm\04Llp;i\"|};ɱ3z!fQ_8r.pasvvֈMÜ-|O\nho0]ڇǩs\n=utM\'!4:h1Ս%T~9[=j M9FkA9B>(	Sq9\r޴oX\ZV~K\\`{-5;{q/1RFҮ]&+*Y7w=%fy1ҵFvj/\rf9ZlgJ<3%3k]yfJdiL$SyI|\'v~ntT\'R`iy@Q]CyhAzEudIptYv&̤eLDR{&L\"\ruUGώ/#=~pJu~0X\'\r2./poq\0O}wu\rk4䵞2 z9L\"yöDَgnWJc.@a\ZH21WdIϋL=]#\n[K̥2,_0vͧ;S=;(KaxRY7VvXȩ.W\rƴ/32犳3=fSD6g;N1\r)Hh`px8+̝ju9u-\\Z~4Ak)\":qjpOP)禍ޜWD\ZZD~kOh1\rKuvUsk74\'אލ	\nvN4Xy{n<v!~r?!+>uy ?oGf06aeBtƄ0G!5MiZj^Vjhkgs\rxDuFӓԼ\Z{\Z`P%c CfK5<yׯ,az[+-ծf4rAaW3z^z]CQu|H?\r!:):,Q>mSȨ6l/,냰j	;!nO6w\ru#Uy`yIt$6\\X{V)VBHA𻒋;W/q1ҴcE9U\"\"C#{Rփ:,xNM9ϣFgWsc{\Z+:HU1\\QhU%r\0,\ZXJ\0xVڡeC.DEʁ|\r,Xh*5W8&67f		A?b\'X$gYht\rhjxNս>fx._`jbqَ\\ɃQ)͖:HsPrNVRS1]rulE\"${]SˊECYHyvm|h\"TPG`I!%KWVc)`1,Ļ)Gv4{7d$SI2_P	M<XM>R(q֬HHv2|,++x`8pI*H\npEn^jw*W%WǓW]g~MZ\'o\'m)0SXz(؎EJ9U;}X;?ޑX{.5|~Εy-+zl5¿-ZB2hɼ=ژQU%s9\")sfsx770BavsUN^#=S|HukE\"]TdlBjET,Jz}7\"Y(Y滋y`8\n+	}q#NM^bUuV#ZuNn%ƲMIpcڅx#*wTd[$94Qr+R؍EqzNI$s\\jLH so^6ܪr&	@n2u^dREɛ;S!?윧endstream\nendobj\n6 0 obj\n2383\nendobj\n25 0 obj\n<</Length 26 0 R/Filter /FlateDecode>>\nstream\nxKoEǝ|m#aVpN@=ޱw8 [tUw~Ue4)#?UU>*ROwU7uLLlJ:`\\\r~v^U/u!s㵥`Cq\rAD!hyΰھOE\"XpS	=ju9V{zC߉ñ+2_5FA_(Nώec\\ѣig\"iy9dujW56fxש6}Vm?Q411gk9\'ꢺQ堉U$!?9ϿU}xS:Z<?:,4Iu,;F%\Z\'\r<UYG[9,qm,ixo+ዤ8٬Ӄxŭv9+HzE۽23]ȴίK QH7*EYʐbh\'uOf	\"O֯Z$!׿t߼iX!Üplo7HڗH}	lC<jl=d||ِ.8uJ߻ףp3\"!j3E\rh3{C#AKT0ȁAI]-!<\"mrqA!.OHm\"lz\\^ .4+n6i,AYqy+K,H#MrPLEzʤ(MiRs{XkRXq\Zۏ}I{@L>(싾g#bϞZYT%;G+e>i|DhY>8\Zu]x]|pI7\\KG]x{q]΀\r`+Xa{.`-Sczܻ7?=J==6GF\n@Mp_GANH	A^#*;n5Ys7Y~żcw\Zbڥ_!\n\"$Șbd!>)hW|JY8kV*nZ<z[ehʅ}L^K+HA4n\'tvZ2e9+Ȓ#{]܀\"s%ڲ-Rr	捕v(pw;=l:Ɩ0kO_,kZע00[cw[\0Y\\(e늳`d#lRvQ\rU{endstream\nendobj\n26 0 obj\n1263\nendobj\n31 0 obj\n<</Length 32 0 R/Filter /FlateDecode>>\nstream\nxZn6BRѥə-@it>$}iޤ@3Vj]خ0`ks8̐\ZW[>}]ukWY0udR퀢II:T\'??|:~]u:_T\'h}v>\\V\0lr@y:hBiQ\nؘ֚H9nXbRG7֣\r3^3\\/՟[4,0%lmސip[?yⒷ<^dD!:6;/~|b{؜/v3C?V/60v)s8jC0J&}9*oc5]Sn-_vAa4!#e9섇[b,j|_vZM7s \n~W̾-yᲉ9հL\ngaG-z=L<i1)ِ&τؼ\\L1urA^X%3,v\ryc0!ʑOc4m6j2d͓9ʔgfS9SYs0AY/O21A}P$M2Q`6^<EGؿ+Y!؏)t=U\'G_8+;TT{5\'f%g͇5A|N̍NV8Pt\ZDe\ZVAv\"vHW-;cg;}W-9wnFכ(rښcIs\\L}T9`9͹H|Ys}¢;Fչik|\'$hQSIͱ^epkp;oyn!z\\VS̼iȄg܋9Bbőnc!$Y񺤶D9A	TR\Z!S)(kд.S!OK	<{{P%#Lhh%V˕N܋e	G|urdƶhcd(Re2<2\n̮.G5C-iH鿣3:c#g	Wș07\rGeN[HGDu??E;9Vѥ	\r>\'B\\yh.CZBszʷ<\\\"2g)~}d趥hq^GϿ[ہ|tEܟ_Vdh\':yߴ[&gPQ*`r}`פ}.E]T.3;::َVߤ+[\rU8cȻda$ް\\ٔM_F]V58U\0=cӄ̀4x:K0Rd3f7+hGt7}#lT *~4H7S0:\0\Z\r)\rM\nH\n)h{.\"kQ$j?b)2tct`aP.q߭_Au\Z/TiEY\"mP12k\0&Ŗ5lyeɉLv;\n endstream\nendobj\n32 0 obj\n1596\nendobj\n4 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 23 0 R\n>>\n/Contents 5 0 R\n>>\nendobj\n24 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 29 0 R\n>>\n/Contents 25 0 R\n>>\nendobj\n30 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 0/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 39 0 R\n>>\n/Contents 31 0 R\n>>\nendobj\n3 0 obj\n<< /Type /Pages /Kids [\n4 0 R\n24 0 R\n30 0 R\n] /Count 3\n>>\nendobj\n1 0 obj\n<</Type /Catalog /Pages 3 0 R\n>>\nendobj\n23 0 obj\n<</R20\n20 0 R/R18\n18 0 R/R16\n16 0 R/R14\n14 0 R/R12\n12 0 R/R10\n10 0 R/R8\n8 0 R/R22\n22 0 R>>\nendobj\n29 0 obj\n<</R20\n20 0 R/R18\n18 0 R/R16\n16 0 R/R14\n14 0 R/R12\n12 0 R/R10\n10 0 R/R8\n8 0 R/R28\n28 0 R/R22\n22 0 R>>\nendobj\n39 0 obj\n<</R38\n38 0 R/R36\n36 0 R/R34\n34 0 R/R22\n22 0 R>>\nendobj\n40 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 41 0 R>>stream\nxM_lSu@S2콈P,e6&aFc5nOGtsoe[Ww?keQ		iQ7ʣ	#ӻ_y+/?9!fa;{j$Si2UbO}}</>;0=Cz|R}{߾RrJ=AHRWbXri}nts<MvgnRg#dq1t~qEfve,Wr-V_bؔ!\Z	M#=cGd82L?hI4\r /4X(HZLԌX\\..<;(Y:d(9{¼0LNMI(؊!99XRymr2/_Wu`ʌ~M,*Ȁi<hb\0q\'6i9#k^Mj7RKEA\">_![Ne؆{WyV*4Lo	BXUAUO\Z1=v ZFe}szd͗Y\n̍Eey<dH$&&-GnЭ%:EE>VDr@3Aʡ]mu:b}\Z?|/\"&l̬\Z2\'&!*2p.Yu;^EfPY8a\rI6tЭ|c\r+{\rnԇ/\'r	/\0?%-#aPψ^UVjrG.܃Cm]\'Ůc.cc_\n,Gw66߰lXXX!_X\nendstream\nendobj\n41 0 obj\n852\nendobj\n42 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 43 0 R>>stream\nxcd`ab`ddds\r4~H3a!ֹ}nP;*9(3=DAYS\\17(391O7$#57QOL-SpQ(VJ-N-*KM霟[PZZZXT_6QaCcb&|}c^柛\\ҽtiQw_>ڢ%33V/`w}D,*(ZVfͲek`82sɰn樛1eForovvIӺ56ߟsi~g_]7GSCG]z/^~	oi^p\0\0.\nendstream\nendobj\n43 0 obj\n363\nendobj\n44 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 45 0 R>>stream\nx}{lSu]׻6Y{;Pyl#@D-c\n0^]>m}ۮۺWvcSd	8Nb@AfbC@No	2/M%&P4M3_\":8!t7L-9s1c6.Ch7viV(3yU*ujeaL+]*5UZʼJeQFYҨ:=jj*fJ]MQTR^~m)j	zzʤPDJ%Q\'MՄ2Jeb#HCAEca\Zu8K^^_0-nв^x;\npIp\Z3[{?`cyI~x;G@u]>w{`,tquf{%\něrOcQz|h<jʅ:ppY4K*p127cR0^{*I3\rFP{ \Z6hvaObmmyHlЖYd6Od\\ Bfp^dݾUd/i.:(Jߗ=9^wv[m\\H#~\"DCrQIXzob(v4z-\"$s3G\\;r3c8XT^bpK|BI($UPRiZ|kE> kyIM?SϰVń05dd93퇕RbuEe	w>QfpgZD!ޫeTh435~`-`t.=x| \0^+v vZ1K31ɩ2-)b-sIC	vp\\)mR6n9g(\\]kK%OW^L;]wԁ7tWhynOA\riS_{rɂ,xEQm	~۩ro<	\'?!wƪ+8zE6i(vJ,\\+g1iG6G 5P4N6]3AvuIAD|.nkv7pB,ݭ	Kqd/KL1rY[/wvn-:\\do-&\0I1tL= e]d2\'Buۑt&y<KN\n8MM?\0捙v\nendstream\nendobj\n45 0 obj\n1244\nendobj\n46 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 47 0 R>>stream\nxklSeiak&,9\r\n8	crpeˀ:;6kq[˹<]vۨl	q}@AE1#fAIhD	&OP$y{IL$IRo-MرL,=&/\'w\Z44\rr&)$ٚ_Y[՘_[4ϼb.o.,)Th6VKcyf.IQm.T[u==++jk,vsa}?Aik_`A&s,b1Aki>PפM(2xBn&&=$жغ&.!ܒGuw+:SVcVGQ(VŮ	\0nl:XMv^R`)8 :1.Bfxܮf\Z7>.0)|ݠ;q(5w}TL\ZQިuغ\ZŎZ2P,G}5\"`]nb\'{HW>t>3D3GEs;mS- C~@ǧԥorsc#;Z7QH.Hg~\'ce&%1hYj<r3Ey/K)${=\Z;p=20r];{4{C7AU1D/1[q.6G|CDW|sh?묂\\,%\nn?i꒤~KrnSʐ\rE8K\rTԣTlǋWfJ^߀u\Zz^	$hc}R#1gK?dE#3\Z1\nU;4jf$O_ak^|*vi#oP$BS+ټf]~wH+c\"CG40#3gDqAx`sq꣺抢d9J DFqIR\rbw2\rwWp\r2jz@t8?$ HJk8,;Uɪ/\0\0lDA_Y٨ux;Jh\'m\nMaViO\"Uq=;vM>q~z_--P\'\0_5kSDRaTsI~#T)oJRijDmuqlf˄\'4ld*<W\Z~~A	hɂ8XSZ8%fd<~o/Q&8~7~\n2\"mUPy[Q\'ң?\\e?^y3rR᧛ROp¥DLľH	u1\nendstream\nendobj\n47 0 obj\n1288\nendobj\n48 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 49 0 R>>stream\nxcd`ab`ddds\r~H3a!+o\n~7n(_PYQᬩ`hiiZXX(\'gT)8(t+t-(-I-ROI-K,*/d1J	+1>{VtW9V[]V:{<FZg`_tE⢼E+W.^B?QKn.74\\&퓦ϝ\"+O=_ygŪ\'6vs475(w[M9҅?Ⱦ|m3xx\0L\nendstream\nendobj\n49 0 obj\n370\nendobj\n50 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 51 0 R>>stream\nx=Q]lUcbX[hI!TO4&h@6<Mvi]hidw;33wghk)-b*Ә\Z@Hx Rドфxg5;99|(4	(6y%^:mbl+]yUŶ]CH4\rE|G|;;7|-cCA\ZZ{VBchFuː\ZZV]x<5364q7sߙ@6^lccsRt`dpx6dӲԔ-Yq,M[sivttwh\0H3%82	D8;ɻ;aWlaӡ/CK3ihLS4_V*1Jdd8r0\ZDi+vlxm/x:~x\Z..KsȸjF=g\Z<opb&K×Cm\0:pxRH\\muWu4?;c0%&\ZyzBśad*=[oqq}3ر󧣥X)eN\nd\\)?l\'P;/%>z}d\0-a+Ta+\'&ON(;qWT#:Uk+ޣ}LT짍װK|k\\?/0{	w|O&ǒIYfL%EQX)GuG3^p\n|jbjjr+	0N!`li/4_FG?f<чv¿68\nendstream\nendobj\n51 0 obj\n812\nendobj\n52 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 53 0 R>>stream\nxWyTSwH+jm^X7\".Ūk  YDV!		bY\\@YTTܰj]h`bca<j3;9g受s^<dC$ih}gc}_\0X՛j[05q@t[U\Z/	\n;Nu8%\\,E8zp!q,g;H$vGe3]1rC\Z E1n}|4 R,HD~S͜;o~hy)A\"&b	Fl&܉O5b-A$6[1N FxMcwK&(xAț6N6͂% r	BP\'\n\':oؽmgwwps?zh+M^B\"G\n\Z;yL5d>f[;|Ӓ\nV@r+X|L6\"Y`]T-TJI ITKKf5A&(3S2&1x*I/оSYzBy4\"P\'R\'\\]QcIiׂTe	g>op9-|ַM$\ZԅP0v%Ji͏B<Ii+n氎ک5jіgB+i|k̡_<y{#I/>9+y24fX	Llf\\\"DQJ!˕UGQ3p̼w\r/TJ	=msϠhKEgղ|ȇN7ݨ[`U\n;(<TFr`qb$?\ZըifhӧJB*DY^ @DKsg7}TSL(\n-ѻW۾h8\r3xhM2nfZթymwxP퍕Tn7F5F5/ahm<f8|p,J\\\0\ZPjA3M։fu2tPvb@LUFՆ^\Z\rF6h4ble{~ho#`ˬULsF4?Jzb_qe]4-#yeF?FnnQ<cϛ[m?kG2\rEC^We䦦ejI{䵡mKHg|4Q%QENjH;rc/@SPjMB2Dӑ=5E\"9y%s۵EY5<㨕`*~WEVG{֞h5cJm7Ikc-Py҃D2(4zWMP^N2R\ZT;F!_W4>aUT/3P=dJtU%ft20r,\\;kK˹҃׺rȃ~b5QiѺ9jHNbAssLJ⨊Vrd)T=L\n&C⤨?MfU5@\'BZ<GQ{ 07+-(ikVx94ݾ~2*,(ϥ8*getЇ+\Z#\"oLf%CzŐWɑ;xK6\ZLWG\r1҂ȿvfrNd$K\ZU!ob;[(IP;|W+~\"W=\"HdFkSme2KX)؃W<7N@)?m*>9G9\ZK6	w-mh8ig~B5U?3wzG]gxq=OvVI{*uMr4\\Uek~5Ч;PjzE{kp69s1#jYr;/R h-e]Z+wU{ZM4++_OPWЫ!Cb;Eҭ#<\">u\\Y?x7}xu?Xe)Yxg@tO	ۯ@9d6&8])ܭQ1a~bctCH,ONSG)@Oq*9yAv+95h\ZfgkC/y+&>3\'Xx]=+-8J棟F|l!&0?)4UV\r\0<!\nI]*32h6`ۈ<˶>3Ȟ~\\EVZ\0-e ffVGCg+.\"! XYYg*)b7;DFGwrO`#,5#-c1,MKZ>:>.s㓚_}\ZKM&\\6\"t\n龿ZVG3|v>)eS,~[<[,\'ޑIxVl%WLgaa8=z~è٪W/-W(VR))!=Ս\Z	kh\Z^҈y,ҹs7ejJkb\rh2Y㭫nۤe|qxVXG\n\"Jd⊉lB$LȪx /._>l\rg2},|h~G/uг=u\'/MtPZ.	a+/ڀ~PfGxLI|jZ\riIӀN:\0؁e^G\ZMb*?ʅ|G+sM]m;\ZC_/-(b*EsehBʂR	л+LM%ҿn_PLF5dH*g53@<;HR_.R$R&poʂ\\uкzKLYd4Ws\0\r9\Z,&}c<Qx\0_eAG]̊ :0AUg6՜o{qx$F4)Ac9ϰ\Zf<!%ZqR\0JD<+mlyފ@}ֵSY5~57KՍIPkԐr(zZQq$=dK 7җ;>=lőŶK$WmB%7ɏÆf\0N}H9Hfx˩VGHUNKXlkfW8_T{y1[]bm:;\'8QĶQ~@DjEVΜ29Og7yqq1=ͼ@i8~q~-\"~tiey4	/WAͣ^ٲjƝrv&1PuQSa^ϒV^ypԥ:gnx\'u?XP3UXSY-<>z\0ѕ:T}#$EFlm&ƣ\'3cMe,f>fxî(@/S#5\"X喝Rv+C\'nlBȎ^/7^poꠈ\rfJ`+ 0)bcP\r1.7C(@\n)]`n-S}W	\nendstream\nendobj\n53 0 obj\n3558\nendobj\n54 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 55 0 R>>stream\nxcd`ab`dddw\r44\01H3a!;%k\n~n._PYQᬩ`hiiZXX(\'gT)8(t+@lu-(-I-ROI-KMj+I,````4c`b`bdd|?ڙr8cRV?aZ:%[&͜:qr|/d-0}3n9.<g00\0\0fZ\nendstream\nendobj\n55 0 obj\n262\nendobj\n56 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 57 0 R>>stream\nx}{lSuw.0@uTGoyaC6!%lH\"\Z*{Ji7ڵz{}l]Q[h\0MF\"E20!cb<Q~|{~IO#ðE%%kxI%fǴ{C9uip*=ETS\"zS\nn~E˖u5S\nCVrm0n4_VWR{te=Pgf^+1LEֿQL2#ϑE$N!%dY|V6!}d#r_lq|+(1\rv\r5#~Çp.dowxa\0¡@{ xz`傣ezasDG0G+F#]v_*y%?=b[hl}@ZB#x4$_²+jg\\\0>X\Z,@5f2\'XWi8al11\0QW\0B7@]s	}wiX%O+\ru$wq +[Kd^[XI>ΌJ^O%ve32\n\Z*P\'t>s{}7!Eඉ&vEuz:tgx\rc&N/^mZOӍw U +9~[W͊|dфk173WXSOI=.Gg~k1;haeK)Cq4W͔icS9\rYxW\Zװs s}%:-9~h\\r.{RjzH1_<\0\\vJu^Adhwq8U6;YW\'q?$Gp5~V!$EI^K罽ꕲf^\rv6y	x$9QwwʁS4Yj;mҢ^n9:횞]w5}.ǫJߐL?d[.Cr$W\\7M7\'x$;XľD[$x8G;рV>_x5!W(Ի:=G/zu`\'S}u*Me|Y:G<i{Y4[:||n5|-FC0K2\'~?I;1]˚0\"/\nendstream\nendobj\n57 0 obj\n1206\nendobj\n58 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 59 0 R>>stream\nxT{Pu`YNv+C\'|`JR\"Sf	\'Rݻ(xc:eik1%98YǌnPk&鏝ٝ> Д+?\"=4\nY!;#YϢϠ9ь)SN)**[oE%$%Ksuنlؠ,f7lЭ(խЗK%\\}I!EQl)/Jͤi+ԫT5zKM\"tPj>*hTu1xOtoZ[IP&gqnZnd-Nk}\0vjI2	z46z%8X9G-X)T}\nzK\01Bm:4@lfŕi\Z\n#!Aw}R5\\anh瑟AQ\n{>L0fNp`*\'~;@lEjf:\r˚-+@4k{ykj@d	@~@̝3qOHO1>M_/(bIE5\n፸\Z\'0Lk:0ߺv*6а05#5s٦E}bt?$_?$b6G7zrS?P}8}?\nۦz#yryEţ`<3n{K\\k&aG#O*8/\\ 	O06U\'} \\Idߣ3\ZȠi/\rx|?NS#IJ9BnR%T+v\\<:;Pqjnż<~է4%|ֵ@ hd2+AsIXDn	^\'\rӟ 4;sKPg.E]\0:,&ŹA!.L<11dq_E1H0D[1U1=C:Q\n%U6U<>aqc[ƭ,ؠ<Cibeo̅ͅes5Bs(Aʢh[7۸wU2\'Q#YlB1/[\'sI\n0\"\0BGE$PK.T˱% L>rQEgU~Y5u]BF9Co\r9T͏1m\\B̌XՍlsn\\${YZE;fĕDis9%}sd_隣D~$`hʙVSSk6~bY8s[X8;͒eniap\'v).,x~g^Wx8E!\nendstream\nendobj\n59 0 obj\n1362\nendobj\n60 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 61 0 R>>stream\nxcd`ab`dddu\r21H3a!G&u?\n~*_PYQᬩ`hiiZXX(\'gT)8(t+t-(-I-ROI-c```4d`dbb`add?U|V3[+x>w?~foݨ{]M<1}r}߆_~Ѽ\'NC5je߾~QE}GS[kOjv/~ktn7Nm]WWw+G[_[~\r4)Y{ӏZ+ۻs<Uӻ9Rؗv>O/{Vw\\B\nۡ݇fvM	*3-iYNƾ|Փxxe`\0\0}Y\nendstream\nendobj\n61 0 obj\n434\nendobj\n62 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 63 0 R>>stream\nxWiTS!@%Գ7mmš*-UqE2 )ʐM\0dNa0  \"JjzZNj7Q{{sZ{%yD\r%$Vsjd#fc8dvkx͑8aA硔X$Zb˂ȨX\'\\̙4?<P=/i_lH`_C>2`{`ld2:1Nc;=(EliU@yEQ\"\"\n\\H$v\"c/yw&Ou6}{ZC-R);zZBMR(jLyR˩\r\nj&ZEQ\0j eO9PCa#%S#1G9PP4U& ҈$EbFNv8`#20iσU\rvkpXr08tq>gaaXoUo6CSXvˢ0o-[uC[UGhb!t\n-#͚Dn:=mIhWgA֨&(tf: @n8PD#w%RxD.^e\\#0U%q]ޭ\'/=[	UM̤lkUn!G|nv誡\nNjb*+_.xsGn69z\ZnY֘\\\Zw7\\H/?J;En7Q{44a&Mx__貸*}避mB(2AG\"&/O	f#8gh=wA;XTJeQTs[0z=602Pʑh!(|\nGQ8w`T(}\"6Ҩh2bP$Џe4+3Ӌ_h2މ7FVy!OX\"%3h%~@21|!*Pt,@|1P}\'4@kٻ Ԑ8s,j,sjĘ;ݳ_|(^SPi5Q5yuPkB[5o)ӵ4ˤ#R` T`df:Ba.Jͥ!!8h*79tcopek;k;tbG͞o\r=a+`p/?!	\">zड़4/%jO骠\Z:\'+z9	t-q\'k#χ)cgFc(.߫KߣN۫CƺnbO@42Z2i>M`\rz:w\"},n*:e0WIr12?@q-#cЅtb9]iK>nE#kf+q-qQ߶M?fq+(Bۮ߉qe,3\'fCj1LlI\\um)~âY^kr%r6]\r68b;Fjof?(n1{Kdr\'jyK?,śL.M\\0U|?J(!<cD®ＬRҏ6_Je_ROWc8\ZGwсFǩ4q)D\ZeuuZ_ॾɜ*Є}-*_ݪ@p9wݮ4\Z!\'q;WTkM||b4aIr~oJld\00ιlsdWv6+ƃel(3ҕ$TmI2L^Cci+)!Bi/\nqk|!Yp/\Z;6pja\ra:ȂR=R5?F[pxmxm!FKIt0xRp8,\'K;d\'8L}y\\)GuCrfn\r^ ?s!XO=`!:}s!6亦_wgNf?0^qJ>=>,C@bŵN{4\Z-+bON2Bz֘qc\',`6>m<*df&d$Zmy9Ӂ1At|hݶ\\\\Fzu}sZnMLi	c\n!BB2]\r)8U=\ZH(t}HIdI{2Nkmn*|o6hWr[CQ\n=͖̎gZf	lp@0y[̣ݜA\Zu8,dduLe[\"li<tɠ*2\r<~RF6tQd5E?3\n|꓃֮~oqz4z/8$VzLĕrfNF-ɐ)j.]=h!d-{Bze{,.f҄7DN۩<eͼI[\'7DQQhsPZ9B\Zo5BW..dRu쌶S~b\Zd\nSqҙ5r--1ϫr_1Z$Wp\\\\q}ddB\\3g|v\'l[SQS[[Yi}ͥw\01&Q	s` ޓ{}(\'\n;gD(6dbC\\LҒ3>OE\0\r(:[*iCQYV@rA78t?*\rB̵$-36WQzK*GDkHhܖ|$XV(̞nTU3	׬Ws/@VZ/Y^ϼBH;q.gtkOL`MӫFCcwO[n/FHw*WlV@_0O4ehƱlhhm͛K3gײp}bUMjzGZۦArjjeüP~r.eѓlp֛8g@|?\\lwEoYb`w_+#Ro<ta\0qŞ/h6&nr7z%3I	;mAIs+4FWVgR!&ʘ&!MfBӯ<$z91\"K,%1A(vp+/1LHrM\n[v- dqVd=n\r`Oii*P\'?9%ӁD\n])BpW1iY\rphppQKJXV\"r@믑]\ZX_nUqc(9\'*21\Z)s_Nv=NJai5\\䋗Y~=ˏ~Sk-rtWxe=v脯Gξ_3$\\fZSp>ЕY䙄FWBsz+a,QH.[H@&QШ/;],jtA£NU1}t*ŅI\Z2a\Z\n]TM3\'x_S}v\']B K%=Oq*r;(\\\'niOBfijШ;s{s*xPRh_(-bVsI8O>39s\n3F/dnL?3k\ZkzcI/H]|pIQG[䚽u*դj`7#S*s;*Ѵd<ymqOBt1Qdko\ZF{HqmlMn[Vd,9|Ļd8#LyD(}i?M[8D+!|ZqB\\fZ%a+M5	R{0,& ͚fqa|Xtq^|ߏx+b$}$\ZIu)FH~<{7v~\0c_:\nendstream\nendobj\n63 0 obj\n4035\nendobj\n20 0 obj\n<</BaseFont/YWRBPR+CMMI5/FontDescriptor 19 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 1036 1037 996 0 0 0 0 0 0 0 0 0 0 0 0\n875]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n18 0 obj\n<</BaseFont/SZBQCB+CMSY6/FontDescriptor 17 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n963 380 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1222]\n/Encoding 64 0 R/Subtype/Type1>>\nendobj\n64 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n16 0 obj\n<</BaseFont/MUQRQK+CMMI6/FontDescriptor 15 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 924 927 884 998 900 0 0 0 0 0 0 0 0 0 0\n780 0 0 757]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n14 0 obj\n<</BaseFont/EFYKBB+CMMI9/FontDescriptor 13 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 771 778 734 848 756 656 0 0 0 0 0 0 0 0 0\n0 0 0 628]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n12 0 obj\n<</BaseFont/SZBQCB+CMSY9/FontDescriptor 11 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n799 285 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1028]\n/Encoding 65 0 R/Subtype/Type1>>\nendobj\n65 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n10 0 obj\n<</BaseFont/YAUXEU+TeX-cmex9/FontDescriptor 9 0 R/Type/Font\n/FirstChar 16/LastChar 33/Widths[\n614 614 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n814 814]\n/Encoding 66 0 R/Subtype/Type1>>\nendobj\n66 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n16/quotedblleft/quotedblright]>>\nendobj\n8 0 obj\n<</BaseFont/GHNQRB+CMR9/FontDescriptor 7 0 R/Type/Font\n/FirstChar 12/LastChar 121/Widths[ 571 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 400 400 0 0 285 0 0 0\n514 514 514 514 514 514 514 514 514 514 0 0 0 799 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 642 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 514 571 457 571 457 0 514 571 285 0 0 285 856 571 514\n571 0 402 405 400 0 0 0 0 542]\n/Encoding 67 0 R/Subtype/Type1>>\nendobj\n67 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n12/fi]>>\nendobj\n38 0 obj\n<</BaseFont/GKKKKC+CMSY10/FontDescriptor 37 0 R/Type/Font\n/FirstChar 54/LastChar 54/Widths[ 0]\n/Encoding 68 0 R/Subtype/Type1>>\nendobj\n68 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n54/negationslash]>>\nendobj\n36 0 obj\n<</BaseFont/WSXSQF+CMMI7/FontDescriptor 35 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 859 863 819 934 839 725 0 0 0 0 0 0 0 0 0\n727]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n34 0 obj\n<</BaseFont/GCFFPC+CMMI10/FontDescriptor 33 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 750 759 715 828 738 643 0 0 0 0 0 0 0 0 0\n642 0 0 613]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n28 0 obj\n<</BaseFont/EMLRVG+CMR6/FontDescriptor 27 0 R/Type/Font\n/FirstChar 40/LastChar 49/Widths[ 481 481 0 0 0 0 0 0\n0 611]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n22 0 obj\n<</BaseFont/QYXKNE+CMR10/FontDescriptor 21 0 R/Type/Font\n/FirstChar 40/LastChar 121/Widths[ 389 389 0 0 278 333 278 0\n500 500 500 500 0 0 500 0 0 0 278 0 0 778 0 0\n0 0 0 0 764 681 0 785 0 0 0 0 0 0 750 0\n0 778 0 0 722 0 0 0 0 0 0 0 0 0 0 0\n0 500 556 444 556 444 306 500 556 278 306 0 278 833 556 500\n556 0 392 394 389 556 528 0 0 528]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n19 0 obj\n<</Type/FontDescriptor/FontName/YWRBPR+CMMI5/FontBBox[0 -22 975 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 146\n/MissingWidth 333\n/CharSet(/A/B/C/P)/FontFile3 40 0 R>>\nendobj\n17 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY6/FontBBox[0 0 1128 432]/Flags 4\n/Ascent 432\n/CapHeight 432\n/Descent 0\n/ItalicAngle 0\n/StemV 169\n/CharSet(/arrowright/minus/periodcentered)/FontFile3 42 0 R>>\nendobj\n15 0 obj\n<</Type/FontDescriptor/FontName/MUQRQK+CMMI6/FontBBox[0 -21 944 714]/Flags 4\n/Ascent 714\n/CapHeight 714\n/Descent -21\n/ItalicAngle 0\n/StemV 141\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/S)/FontFile3 44 0 R>>\nendobj\n13 0 obj\n<</Type/FontDescriptor/FontName/EFYKBB+CMMI9/FontBBox[0 -22 823 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 123\n/MissingWidth 333\n/CharSet(/A/B/C/D/E/F/S)/FontFile3 46 0 R>>\nendobj\n11 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY9/FontBBox[0 0 970 430]/Flags 4\n/Ascent 430\n/CapHeight 430\n/Descent 0\n/ItalicAngle 0\n/StemV 145\n/CharSet(/arrowright/minus/periodcentered)/FontFile3 48 0 R>>\nendobj\n9 0 obj\n<</Type/FontDescriptor/FontName/YAUXEU+TeX-cmex9/FontBBox[0 -2957 781 45]/Flags 4\n/Ascent 45\n/CapHeight 45\n/Descent -2957\n/ItalicAngle 0\n/StemV 117\n/MissingWidth 250\n/CharSet(/quotedblleft/quotedblright/exclam/space)/FontFile3 50 0 R>>\nendobj\n7 0 obj\n<</Type/FontDescriptor/FontName/GHNQRB+CMR9/FontBBox[0 -249 833 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -249\n/ItalicAngle 0\n/StemV 124\n/MissingWidth 342\n/CharSet(/L/y/n/c/parenleft/three/o/four/d/parenright/p/e/five/six/fi/r/g/comma/seven/s/h/eight/t/i/nine/zero/l/a/one/equal/m/b/two)/FontFile3 52 0 R>>\nendobj\n37 0 obj\n<</Type/FontDescriptor/FontName/GKKKKC+CMSY10/FontBBox[0 -216 638 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -216\n/ItalicAngle 0\n/StemV 95\n/CharSet(/negationslash)/FontFile3 54 0 R>>\nendobj\n35 0 obj\n<</Type/FontDescriptor/FontName/WSXSQF+CMMI7/FontBBox[0 -20 893 713]/Flags 4\n/Ascent 713\n/CapHeight 713\n/Descent -20\n/ItalicAngle 0\n/StemV 133\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F)/FontFile3 56 0 R>>\nendobj\n33 0 obj\n<</Type/FontDescriptor/FontName/GCFFPC+CMMI10/FontBBox[0 -22 804 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 120\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F/S)/FontFile3 58 0 R>>\nendobj\n27 0 obj\n<</Type/FontDescriptor/FontName/EMLRVG+CMR6/FontBBox[0 -250 505 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 75\n/MissingWidth 416\n/CharSet(/parenleft/parenright/one)/FontFile3 60 0 R>>\nendobj\n21 0 obj\n<</Type/FontDescriptor/FontName/QYXKNE+CMR10/FontBBox[-40 -250 813 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 121\n/MissingWidth 333\n/CharSet(/y/n/c/parenleft/three/o/d/parenright/N/p/e/D/f/E/six/r/g/comma/Q/s/h/hyphen/G/t/i/period/u/colon/j/T/v/zero/l/a/one/equal/m/b/two)/FontFile3 62 0 R>>\nendobj\n2 0 obj\n<</Producer(ESP Ghostscript 815.01)\n/CreationDate(D:20060627000431)\n/ModDate(D:20060627000431)\n/Creator(dvips\\(k\\) 5.95a Copyright 2005 Radical Eye Software)\n/Title(proof1.dvi)>>endobj\nxref\n0 69\n0000000000 65535 f \n0000006062 00000 n \n0000029628 00000 n \n0000005989 00000 n \n0000005533 00000 n \n0000000015 00000 n \n0000002468 00000 n \n0000028076 00000 n \n0000025016 00000 n \n0000027825 00000 n \n0000024720 00000 n \n0000027608 00000 n \n0000024390 00000 n \n0000027387 00000 n \n0000024188 00000 n \n0000027166 00000 n \n0000023986 00000 n \n0000026948 00000 n \n0000023656 00000 n \n0000026733 00000 n \n0000023464 00000 n \n0000029287 00000 n \n0000026340 00000 n \n0000006110 00000 n \n0000005684 00000 n \n0000002488 00000 n \n0000003823 00000 n \n0000029055 00000 n \n0000026165 00000 n \n0000006217 00000 n \n0000005837 00000 n \n0000003844 00000 n \n0000005512 00000 n \n0000028831 00000 n \n0000025960 00000 n \n0000028610 00000 n \n0000025764 00000 n \n0000028405 00000 n \n0000025525 00000 n \n0000006335 00000 n \n0000006400 00000 n \n0000007338 00000 n \n0000007358 00000 n \n0000007807 00000 n \n0000007827 00000 n \n0000009157 00000 n \n0000009178 00000 n \n0000010552 00000 n \n0000010573 00000 n \n0000011029 00000 n \n0000011049 00000 n \n0000011947 00000 n \n0000011967 00000 n \n0000015611 00000 n \n0000015632 00000 n \n0000015980 00000 n \n0000016000 00000 n \n0000017292 00000 n \n0000017313 00000 n \n0000018761 00000 n \n0000018782 00000 n \n0000019302 00000 n \n0000019322 00000 n \n0000023443 00000 n \n0000023871 00000 n \n0000024605 00000 n \n0000024908 00000 n \n0000025441 00000 n \n0000025669 00000 n \ntrailer\n<< /Size 69 /Root 1 0 R /Info 2 0 R\n/ID [(W^Ck_nzN)(W^Ck_nzN)]\n>>\nstartxref\n29821\n%%EOF\n','Proved','BZh91AY&SY̆\0\"߀c翧%j`	_ȃAHP\0\n42\Zi\0h&\048id4#&\r4ѦL\0 hpLiFL \Zh	L\0@IA\0\0ɡ\0\Z\0%&%62z\0\r\Z4\r@\nR\0AOSCFyC@UW#%UKIF)U.\Z)a1K&ʖ-)`C1b`LYLQ&1,h\ZM	m֊~g\n_Hk=dp>:pܬ߲\Z5Cw7\r2ܝSʿ&\ng=5\r)uvݚQs3lΌoq.REUc\n@OB=ϵZ4gUlW1bPCY=0EFD%yf0\rg(Ε>%_\"/T}t-|>}=-#b?li]OɵSjFPl$ە,L,.X0m2bclʋUIK\Z21dҴhSIWJ:.{:YfExpEQ&xļ;<OM͑;O:ٰm\\#[ݶ͊p\\ȩW\rZkKmZ]ll\r͊.*id\0isb8>ѽU݋\0Ԫ\'(\n%UMLiH&RU-ѫEumb1c1l\ZZE(`Bbb1TRD\Z),cJ#$  Ha-LBK,,TX*Y-J!1DK\08@ɖ%DdKfx	ubR)b]3:fJ,K$S,̣&u1ƖRP7{ޤ}OWǵCM6+J@C\07~dar^k,7QQ[][A\0~ tՏaR鶙_e+u.>ǜz_YV\n:cYVkv<cEWj5m9z؞ݬC-K,ti%^W{qe\\w.sTͱAFAFz[\0f.c`t4hKgG&(ΗVc^\nSfg\"Ju=e̫VTJF(0#	txaWCMVS,::Ei2\ZI!5\Z)p:ѹJ4Fru]V˺S9QYdc	2Y1Twffq*ӱю٩*{MQ:\0zJXۺSwp\Z#k7a##\'$XU6RCNk6Ɍʆ`F12lMҞƦ6NS><8\\|;Sɹ%;iKJ^akХO1s}aWwkVoG4.fFYK!Y2w$%7Z6T[ň`3Tԛ\"UfQQ\Z*އYʥxX뵥b,6۸\\.NE[t{ʴw;/R:o֥֥]M]|:\0MӃă\"\"Dl]BC2');
INSERT INTO `demonstrations` VALUES (29,'%% Example 3.15 of J.-Z. Zhang et. al., Automated production of \r\n%% traditional proofs\r\n%%\r\n%% Pedro Quaresma 24/3/2006\r\n%%\r\n%% Version - Drawer\r\ndim 120 120\r\narea 2 2 118 118 \r\n\r\npoint B 5 50 \r\npoint A 12 40 \r\npoint D 30 20 \r\npoint E 33 80 \r\npoint S 92 82\r\n\r\nonline C D S\r\n%point C 58 48\r\n%point F 50 60 \r\n\r\n% Point P\r\nline BA B A\r\nline DE D E\r\n\r\nintersec P BA DE\r\n\r\n% Point Q\r\nline BC B C\r\nline SP S P\r\n\r\nintersec Q BC SP\r\n\r\n% Point F\r\nline EQ E Q\r\nline AS A S\r\n\r\nintersec F EQ AS\r\n\r\n% Point S_1\r\nline BA B A\r\nline DF D F\r\n\r\nintersec S_1 DF BA\r\n\r\n% Point P_1\r\nline AC A C\r\nline DE D E\r\n\r\nintersec P_1 AC DE\r\n\r\n% Point Q_1\r\nline CF C F\r\nline BE B E\r\n\r\nintersec Q_1 CF BE\r\n\r\n% Point Z_1 \r\nline CF C F\r\nline S1P1 S_1 P_1\r\n\r\nintersec Z_1 CF S1P1\r\n\r\n% Point Z_2 \r\nline BE B E\r\n\r\nintersec Z_2 BE S1P1\r\n\r\n\r\n\r\ncmark_b A \r\ncmark_l B \r\ncmark_lt C\r\ncmark_rb D\r\ncmark_lt E\r\ncmark_t F\r\n\r\n\r\ncmark_b P \r\ncmark_rb Q \r\ncmark_t S\r\ncmark_rb P_1\r\ncmark_t Q_1\r\ncmark_lb S_1\r\n\r\n%point Q\r\ndrawsegment B Q\r\ndrawsegment E Q\r\n\r\n%point S\r\ndrawsegment D S\r\ndrawsegment A S\r\n\r\n% point P\r\ndrawsegment B P\r\ndrawsegment E P\r\n\r\n%point Ql\r\ndrawsegment B Q_1\r\ndrawsegment C Q_1\r\n\r\n%point Pl\r\ndrawsegment A C\r\ndrawsegment D E\r\n\r\n%point Sl\r\ndrawsegment B S_1\r\ndrawsegment F S_1\r\n\r\n\r\ndrawdashsegment S_1 Q_1\r\ndrawsegment S P\r\n\r\n\r\nprooflimit 100000\r\nprove { equal { mult { sratio S_1 Z_1 P_1 Z_1 } { sratio P_1 Z_2 S_1 Z_2 } } 1}','<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE figure SYSTEM \"GeoCons.dtd\">\n<?xml-stylesheet href=\"GeoConsNL.xsl\" type=\"text/xsl\"?>\n\n<figure>\n	<draw>\n		<dimensions width=\"120.000000\" height=\"120.000000\"></dimensions>\n		<area x1=\"2.000000\" y1=\"2.000000\" x2=\"118.000000\" y2=\"118.000000\"></area>\n	</draw>\n\n	<define>\n		<fixed_point x=\"5.000000\" y=\"50.000000\">B</fixed_point>\n		<fixed_point x=\"12.000000\" y=\"40.000000\">A</fixed_point>\n		<fixed_point x=\"30.000000\" y=\"20.000000\">D</fixed_point>\n		<fixed_point x=\"33.000000\" y=\"80.000000\">E</fixed_point>\n		<fixed_point x=\"92.000000\" y=\"82.000000\">S</fixed_point>\n	</define>\n\n	<construct>\n		<random_point_on_line><new_point>C</new_point><point>D</point><point>S</point></random_point_on_line>\n		<ruler><new_line>BA</new_line><point>B</point><point>A</point></ruler>\n		<ruler><new_line>DE</new_line><point>D</point><point>E</point></ruler>\n		<intersection><new_point>P</new_point><line>BA</line><line>DE</line></intersection>\n		<ruler><new_line>BC</new_line><point>B</point><point>C</point></ruler>\n		<ruler><new_line>SP</new_line><point>S</point><point>P</point></ruler>\n		<intersection><new_point>Q</new_point><line>BC</line><line>SP</line></intersection>\n		<ruler><new_line>EQ</new_line><point>E</point><point>Q</point></ruler>\n		<ruler><new_line>AS</new_line><point>A</point><point>S</point></ruler>\n		<intersection><new_point>F</new_point><line>EQ</line><line>AS</line></intersection>\n		<ruler><new_line>BA</new_line><point>B</point><point>A</point></ruler>\n		<ruler><new_line>DF</new_line><point>D</point><point>F</point></ruler>\n		<intersection><new_point>S_1</new_point><line>DF</line><line>BA</line></intersection>\n		<ruler><new_line>AC</new_line><point>A</point><point>C</point></ruler>\n		<ruler><new_line>DE</new_line><point>D</point><point>E</point></ruler>\n		<intersection><new_point>P_1</new_point><line>AC</line><line>DE</line></intersection>\n		<ruler><new_line>CF</new_line><point>C</point><point>F</point></ruler>\n		<ruler><new_line>BE</new_line><point>B</point><point>E</point></ruler>\n		<intersection><new_point>Q_1</new_point><line>CF</line><line>BE</line></intersection>\n		<ruler><new_line>CF</new_line><point>C</point><point>F</point></ruler>\n		<ruler><new_line>S1P1</new_line><point>S_1</point><point>P_1</point></ruler>\n		<intersection><new_point>Z_1</new_point><line>CF</line><line>S1P1</line></intersection>\n		<ruler><new_line>BE</new_line><point>B</point><point>E</point></ruler>\n		<intersection><new_point>Z_2</new_point><line>BE</line><line>S1P1</line></intersection>\n	</construct>\n\n	<labels>\n		<point_label direction=\"270\"><point>A</point></point_label>\n		<point_label direction=\"180\"><point>B</point></point_label>\n		<point_label direction=\"135\"><point>C</point></point_label>\n		<point_label direction=\"315\"><point>D</point></point_label>\n		<point_label direction=\"135\"><point>E</point></point_label>\n		<point_label direction=\"90\"><point>F</point></point_label>\n		<point_label direction=\"270\"><point>P</point></point_label>\n		<point_label direction=\"315\"><point>Q</point></point_label>\n		<point_label direction=\"90\"><point>S</point></point_label>\n		<point_label direction=\"315\"><point>P_1</point></point_label>\n		<point_label direction=\"90\"><point>Q_1</point></point_label>\n		<point_label direction=\"225\"><point>S_1</point></point_label>\n	</labels>\n\n	<draw>\n		<segment><point>B</point><point>Q</point></segment>\n		<segment><point>E</point><point>Q</point></segment>\n		<segment><point>D</point><point>S</point></segment>\n		<segment><point>A</point><point>S</point></segment>\n		<segment><point>B</point><point>P</point></segment>\n		<segment><point>E</point><point>P</point></segment>\n		<segment><point>B</point><point>Q_1</point></segment>\n		<segment><point>C</point><point>Q_1</point></segment>\n		<segment><point>A</point><point>C</point></segment>\n		<segment><point>D</point><point>E</point></segment>\n		<segment><point>B</point><point>S_1</point></segment>\n		<segment><point>F</point><point>S_1</point></segment>\n	</draw>\n\n	<draw dashed=\"yes\">\n		<segment><point>S_1</point><point>Q_1</point></segment>\n	</draw>\n\n	<draw>\n		<segment><point>S</point><point>P</point></segment>\n	</draw>\n\n	<conjecture>\n		<prove proof_level=\"1\" proof_limit=\"100000\">\n			<equality>\n				<expression>\n					<mult>\n						<expression>\n							<segment_ratio><segment><point>S_1</point><point>Z_1</point></segment><segment><point>P_1</point><point>Z_1</point></segment></segment_ratio>\n						</expression>\n						<expression>\n							<segment_ratio><segment><point>P_1</point><point>Z_2</point></segment><segment><point>S_1</point><point>Z_2</point></segment></segment_ratio>\n						</expression>\n					</mult>\n				</expression>\n				<expression>\n					<number>1.000000</number>\n				</expression>\n			</equality>\n		</prove>\n	</conjecture>\n\n</figure>','2006-04-07',2,1,'GEO0012','%PDF-1.2\n%쏢\n5 0 obj\n<</Length 6 0 R/Filter /FlateDecode>>\nstream\nxMu[#ERX\"$k#|@>6a$~?zwAP`G̬}H\Zu?_ڥ6jݛ\"˚&	;?IRX(-QsjmʶjoQθ~\rq\nuR7?.	bN 1#ڑdOx\'oR9	Ȩ߶_VX/#X׻7lr\Z?;Flѫǻiߗo_WOď{FWVZYA$tfWcn\n\rX+A0kV/uU?ړ \")|ߛ\\LO#Y\\Jhm\04Llp;i\"|};ɱ3z!fQ_8r.pasvvֈMÜ-|O\nho0]ڇǩs\n=utM\'!4:h1Ս%T~9[=j M9FkA9B>(	Sq9\r޴oX\ZV~K\\`{-5;{q/1RFҮ]&+*Y7w=%fy1ҵFvj/\rf9ZlgJ<3%3k]yfJdiL$SyI|\'v~ntT\'R`iy@Q]CyhAzEudIptYv&̤eLDR{&L\"\ruUGώ/#=~pJu~0X\'\r2./poq\0O}wu\rk4䵞2 z9L\"yöDَgnWJc.@a\ZH21WdIϋL=]#\n[K̥2,_0vͧ;S=;(KaxRY7VvXȩ.W\rƴ/32犳3=fSD6g;N1\r)Hh`px8+̝ju9u-\\Z~4Ak)\":qjpOP)禍ޜWD\ZZD~kOh1\rKuvUsk74\'אލ	\nvN4Xy{n<v!~r?!+>uy ?oGf06aeBtƄ0G!5MiZj^Vjhkgs\rxDuFӓԼ\Z{\Z`P%c CfK5<yׯ,az[+-ծf4rAaW3z^z]CQu|H?\r!:):,Q>mSȨ6l/,냰j	;!nO6w\ru#Uy`yIt$6\\X{V)VBHA𻒋;W/q1ҴcE9U\"\"C#{Rփ:,xNM9ϣFgWsc{\Z+:HU1\\QhU%r\0,\ZXJ\0xVڡeC.DEʁ|\r,Xh*5W8&67f		A?b\'X$gYht\rhjxNս>fx._`jbqَ\\ɃQ)͖:HsPrNVRS1]rulE\"${]SˊECYHyvm|h\"TPG`I!%KWVc)`1,Ļ)Gv4{7d$SI2_P	M<XM>R(q֬HHv2|,++x`8pI*H\npEn^jw*W%WǓW]g~MZ\'o\'m)0SXz(؎EJ9U;}X;?ޑX{.5|~Εy-+zl5¿-ZB2hɼ=ژQU%s9\")sfsx770BavsUN^#=S|HukE\"]TdlBjET,Jz}7\"Y(Y滋y`8\n+	}q#NM^bUuV#ZuNn%ƲMIpcڅx#*wTd[$94Qr+R؍EqzNI$s\\jLH so^6ܪr&	@n2u^dREɛ;S!?윧endstream\nendobj\n6 0 obj\n2383\nendobj\n25 0 obj\n<</Length 26 0 R/Filter /FlateDecode>>\nstream\nxKoEǝ|m#aVpN@=ޱw8 [tUw~Ue4)#?UU>*ROwU7uLLlJ:`\\\r~v^U/u!s㵥`Cq\rAD!hyΰھOE\"XpS	=ju9V{zC߉ñ+2_5FA_(Nώec\\ѣig\"iy9dujW56fxש6}Vm?Q411gk9\'ꢺQ堉U$!?9ϿU}xS:Z<?:,4Iu,;F%\Z\'\r<UYG[9,qm,ixo+ዤ8٬Ӄxŭv9+HzE۽23]ȴίK QH7*EYʐbh\'uOf	\"O֯Z$!׿t߼iX!Üplo7HڗH}	lC<jl=d||ِ.8uJ߻ףp3\"!j3E\rh3{C#AKT0ȁAI]-!<\"mrqA!.OHm\"lz\\^ .4+n6i,AYqy+K,H#MrPLEzʤ(MiRs{XkRXq\Zۏ}I{@L>(싾g#bϞZYT%;G+e>i|DhY>8\Zu]x]|pI7\\KG]x{q]΀\r`+Xa{.`-Sczܻ7?=J==6GF\n@Mp_GANH	A^#*;n5Ys7Y~żcw\Zbڥ_!\n\"$Șbd!>)hW|JY8kV*nZ<z[ehʅ}L^K+HA4n\'tvZ2e9+Ȓ#{]܀\"s%ڲ-Rr	捕v(pw;=l:Ɩ0kO_,kZע00[cw[\0Y\\(e늳`d#lRvQ\rU{endstream\nendobj\n26 0 obj\n1263\nendobj\n31 0 obj\n<</Length 32 0 R/Filter /FlateDecode>>\nstream\nxZn6BRѥə-@it>$}iޤ@3Vj]خ0`ks8̐\ZW[>}]ukWY0udR퀢II:T\'??|:~]u:_T\'h}v>\\V\0lr@y:hBiQ\nؘ֚H9nXbRG7֣\r3^3\\/՟[4,0%lmސip[?yⒷ<^dD!:6;/~|b{؜/v3C?V/60v)s8jC0J&}9*oc5]Sn-_vAa4!#e9섇[b,j|_vZM7s \n~W̾-yᲉ9հL\ngaG-z=L<i1)ِ&τؼ\\L1urA^X%3,v\ryc0!ʑOc4m6j2d͓9ʔgfS9SYs0AY/O21A}P$M2Q`6^<EGؿ+Y!؏)t=U\'G_8+;TT{5\'f%g͇5A|N̍NV8Pt\ZDe\ZVAv\"vHW-;cg;}W-9wnFכ(rښcIs\\L}T9`9͹H|Ys}¢;Fչik|\'$hQSIͱ^epkp;oyn!z\\VS̼iȄg܋9Bbőnc!$Y񺤶D9A	TR\Z!S)(kд.S!OK	<{{P%#Lhh%V˕N܋e	G|urdƶhcd(Re2<2\n̮.G5C-iH鿣3:c#g	Wș07\rGeN[HGDu??E;9Vѥ	\r>\'B\\yh.CZBszʷ<\\\"2g)~}d趥hq^GϿ[ہ|tEܟ_Vdh\':yߴ[&gPQ*`r}`פ}.E]T.3;::َVߤ+[\rU8cȻda$ް\\ٔM_F]V58U\0=cӄ̀4x:K0Rd3f7+hGt7}#lT *~4H7S0:\0\Z\r)\rM\nH\n)h{.\"kQ$j?b)2tct`aP.q߭_Au\Z/TiEY\"mP12k\0&Ŗ5lyeɉLv;\n endstream\nendobj\n32 0 obj\n1596\nendobj\n4 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 23 0 R\n>>\n/Contents 5 0 R\n>>\nendobj\n24 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 90/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 29 0 R\n>>\n/Contents 25 0 R\n>>\nendobj\n30 0 obj\n<</Type/Page/MediaBox [0 0 595 842]\n/Rotate 0/Parent 3 0 R\n/Resources<</ProcSet[/PDF /ImageB /Text]\n/Font 39 0 R\n>>\n/Contents 31 0 R\n>>\nendobj\n3 0 obj\n<< /Type /Pages /Kids [\n4 0 R\n24 0 R\n30 0 R\n] /Count 3\n>>\nendobj\n1 0 obj\n<</Type /Catalog /Pages 3 0 R\n>>\nendobj\n23 0 obj\n<</R20\n20 0 R/R18\n18 0 R/R16\n16 0 R/R14\n14 0 R/R12\n12 0 R/R10\n10 0 R/R8\n8 0 R/R22\n22 0 R>>\nendobj\n29 0 obj\n<</R20\n20 0 R/R18\n18 0 R/R16\n16 0 R/R14\n14 0 R/R12\n12 0 R/R10\n10 0 R/R8\n8 0 R/R28\n28 0 R/R22\n22 0 R>>\nendobj\n39 0 obj\n<</R38\n38 0 R/R36\n36 0 R/R34\n34 0 R/R22\n22 0 R>>\nendobj\n40 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 41 0 R>>stream\nxM_lSu@S2콈P,e6&aFc5nOGtsoe[Ww?keQ		iQ7ʣ	#ӻ_y+/?9!fa;{j$Si2UbO}}</>;0=Cz|R}{߾RrJ=AHRWbXri}nts<MvgnRg#dq1t~qEfve,Wr-V_bؔ!\Z	M#=cGd82L?hI4\r /4X(HZLԌX\\..<;(Y:d(9{¼0LNMI(؊!99XRymr2/_Wu`ʌ~M,*Ȁi<hb\0q\'6i9#k^Mj7RKEA\">_![Ne؆{WyV*4Lo	BXUAUO\Z1=v ZFe}szd͗Y\n̍Eey<dH$&&-GnЭ%:EE>VDr@3Aʡ]mu:b}\Z?|/\"&l̬\Z2\'&!*2p.Yu;^EfPY8a\rI6tЭ|c\r+{\rnԇ/\'r	/\0?%-#aPψ^UVjrG.܃Cm]\'Ůc.cc_\n,Gw66߰lXXX!_X\nendstream\nendobj\n41 0 obj\n852\nendobj\n42 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 43 0 R>>stream\nxcd`ab`ddds\r4~H3a!ֹ}nP;*9(3=DAYS\\17(391O7$#57QOL-SpQ(VJ-N-*KM霟[PZZZXT_6QaCcb&|}c^柛\\ҽtiQw_>ڢ%33V/`w}D,*(ZVfͲek`82sɰn樛1eForovvIӺ56ߟsi~g_]7GSCG]z/^~	oi^p\0\0.\nendstream\nendobj\n43 0 obj\n363\nendobj\n44 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 45 0 R>>stream\nx}{lSu]׻6Y{;Pyl#@D-c\n0^]>m}ۮۺWvcSd	8Nb@AfbC@No	2/M%&P4M3_\":8!t7L-9s1c6.Ch7viV(3yU*ujeaL+]*5UZʼJeQFYҨ:=jj*fJ]MQTR^~m)j	zzʤPDJ%Q\'MՄ2Jeb#HCAEca\Zu8K^^_0-nв^x;\npIp\Z3[{?`cyI~x;G@u]>w{`,tquf{%\něrOcQz|h<jʅ:ppY4K*p127cR0^{*I3\rFP{ \Z6hvaObmmyHlЖYd6Od\\ Bfp^dݾUd/i.:(Jߗ=9^wv[m\\H#~\"DCrQIXzob(v4z-\"$s3G\\;r3c8XT^bpK|BI($UPRiZ|kE> kyIM?SϰVń05dd93퇕RbuEe	w>QfpgZD!ޫeTh435~`-`t.=x| \0^+v vZ1K31ɩ2-)b-sIC	vp\\)mR6n9g(\\]kK%OW^L;]wԁ7tWhynOA\riS_{rɂ,xEQm	~۩ro<	\'?!wƪ+8zE6i(vJ,\\+g1iG6G 5P4N6]3AvuIAD|.nkv7pB,ݭ	Kqd/KL1rY[/wvn-:\\do-&\0I1tL= e]d2\'Buۑt&y<KN\n8MM?\0捙v\nendstream\nendobj\n45 0 obj\n1244\nendobj\n46 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 47 0 R>>stream\nxklSeiak&,9\r\n8	crpeˀ:;6kq[˹<]vۨl	q}@AE1#fAIhD	&OP$y{IL$IRo-MرL,=&/\'w\Z44\rr&)$ٚ_Y[՘_[4ϼb.o.,)Th6VKcyf.IQm.T[u==++jk,vsa}?Aik_`A&s,b1Aki>PפM(2xBn&&=$жغ&.!ܒGuw+:SVcVGQ(VŮ	\0nl:XMv^R`)8 :1.Bfxܮf\Z7>.0)|ݠ;q(5w}TL\ZQިuغ\ZŎZ2P,G}5\"`]nb\'{HW>t>3D3GEs;mS- C~@ǧԥorsc#;Z7QH.Hg~\'ce&%1hYj<r3Ey/K)${=\Z;p=20r];{4{C7AU1D/1[q.6G|CDW|sh?묂\\,%\nn?i꒤~KrnSʐ\rE8K\rTԣTlǋWfJ^߀u\Zz^	$hc}R#1gK?dE#3\Z1\nU;4jf$O_ak^|*vi#oP$BS+ټf]~wH+c\"CG40#3gDqAx`sq꣺抢d9J DFqIR\rbw2\rwWp\r2jz@t8?$ HJk8,;Uɪ/\0\0lDA_Y٨ux;Jh\'m\nMaViO\"Uq=;vM>q~z_--P\'\0_5kSDRaTsI~#T)oJRijDmuqlf˄\'4ld*<W\Z~~A	hɂ8XSZ8%fd<~o/Q&8~7~\n2\"mUPy[Q\'ң?\\e?^y3rR᧛ROp¥DLľH	u1\nendstream\nendobj\n47 0 obj\n1288\nendobj\n48 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 49 0 R>>stream\nxcd`ab`ddds\r~H3a!+o\n~7n(_PYQᬩ`hiiZXX(\'gT)8(t+t-(-I-ROI-K,*/d1J	+1>{VtW9V[]V:{<FZg`_tE⢼E+W.^B?QKn.74\\&퓦ϝ\"+O=_ygŪ\'6vs475(w[M9҅?Ⱦ|m3xx\0L\nendstream\nendobj\n49 0 obj\n370\nendobj\n50 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 51 0 R>>stream\nx=Q]lUcbX[hI!TO4&h@6<Mvi]hidw;33wghk)-b*Ә\Z@Hx Rドфxg5;99|(4	(6y%^:mbl+]yUŶ]CH4\rE|G|;;7|-cCA\ZZ{VBchFuː\ZZV]x<5364q7sߙ@6^lccsRt`dpx6dӲԔ-Yq,M[sivttwh\0H3%82	D8;ɻ;aWlaӡ/CK3ihLS4_V*1Jdd8r0\ZDi+vlxm/x:~x\Z..KsȸjF=g\Z<opb&K×Cm\0:pxRH\\muWu4?;c0%&\ZyzBśad*=[oqq}3ر󧣥X)eN\nd\\)?l\'P;/%>z}d\0-a+Ta+\'&ON(;qWT#:Uk+ޣ}LT짍װK|k\\?/0{	w|O&ǒIYfL%EQX)GuG3^p\n|jbjjr+	0N!`li/4_FG?f<чv¿68\nendstream\nendobj\n51 0 obj\n812\nendobj\n52 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 53 0 R>>stream\nxWyTSwH+jm^X7\".Ūk  YDV!		bY\\@YTTܰj]h`bca<j3;9g受s^<dC$ih}gc}_\0X՛j[05q@t[U\Z/	\n;Nu8%\\,E8zp!q,g;H$vGe3]1rC\Z E1n}|4 R,HD~S͜;o~hy)A\"&b	Fl&܉O5b-A$6[1N FxMcwK&(xAț6N6͂% r	BP\'\n\':oؽmgwwps?zh+M^B\"G\n\Z;yL5d>f[;|Ӓ\nV@r+X|L6\"Y`]T-TJI ITKKf5A&(3S2&1x*I/оSYzBy4\"P\'R\'\\]QcIiׂTe	g>op9-|ַM$\ZԅP0v%Ji͏B<Ii+n氎ک5jіgB+i|k̡_<y{#I/>9+y24fX	Llf\\\"DQJ!˕UGQ3p̼w\r/TJ	=msϠhKEgղ|ȇN7ݨ[`U\n;(<TFr`qb$?\ZըifhӧJB*DY^ @DKsg7}TSL(\n-ѻW۾h8\r3xhM2nfZթymwxP퍕Tn7F5F5/ahm<f8|p,J\\\0\ZPjA3M։fu2tPvb@LUFՆ^\Z\rF6h4ble{~ho#`ˬULsF4?Jzb_qe]4-#yeF?FnnQ<cϛ[m?kG2\rEC^We䦦ejI{䵡mKHg|4Q%QENjH;rc/@SPjMB2Dӑ=5E\"9y%s۵EY5<㨕`*~WEVG{֞h5cJm7Ikc-Py҃D2(4zWMP^N2R\ZT;F!_W4>aUT/3P=dJtU%ft20r,\\;kK˹҃׺rȃ~b5QiѺ9jHNbAssLJ⨊Vrd)T=L\n&C⤨?MfU5@\'BZ<GQ{ 07+-(ikVx94ݾ~2*,(ϥ8*getЇ+\Z#\"oLf%CzŐWɑ;xK6\ZLWG\r1҂ȿvfrNd$K\ZU!ob;[(IP;|W+~\"W=\"HdFkSme2KX)؃W<7N@)?m*>9G9\ZK6	w-mh8ig~B5U?3wzG]gxq=OvVI{*uMr4\\Uek~5Ч;PjzE{kp69s1#jYr;/R h-e]Z+wU{ZM4++_OPWЫ!Cb;Eҭ#<\">u\\Y?x7}xu?Xe)Yxg@tO	ۯ@9d6&8])ܭQ1a~bctCH,ONSG)@Oq*9yAv+95h\ZfgkC/y+&>3\'Xx]=+-8J棟F|l!&0?)4UV\r\0<!\nI]*32h6`ۈ<˶>3Ȟ~\\EVZ\0-e ffVGCg+.\"! XYYg*)b7;DFGwrO`#,5#-c1,MKZ>:>.s㓚_}\ZKM&\\6\"t\n龿ZVG3|v>)eS,~[<[,\'ޑIxVl%WLgaa8=z~è٪W/-W(VR))!=Ս\Z	kh\Z^҈y,ҹs7ejJkb\rh2Y㭫nۤe|qxVXG\n\"Jd⊉lB$LȪx /._>l\rg2},|h~G/uг=u\'/MtPZ.	a+/ڀ~PfGxLI|jZ\riIӀN:\0؁e^G\ZMb*?ʅ|G+sM]m;\ZC_/-(b*EsehBʂR	л+LM%ҿn_PLF5dH*g53@<;HR_.R$R&poʂ\\uкzKLYd4Ws\0\r9\Z,&}c<Qx\0_eAG]̊ :0AUg6՜o{qx$F4)Ac9ϰ\Zf<!%ZqR\0JD<+mlyފ@}ֵSY5~57KՍIPkԐr(zZQq$=dK 7җ;>=lőŶK$WmB%7ɏÆf\0N}H9Hfx˩VGHUNKXlkfW8_T{y1[]bm:;\'8QĶQ~@DjEVΜ29Og7yqq1=ͼ@i8~q~-\"~tiey4	/WAͣ^ٲjƝrv&1PuQSa^ϒV^ypԥ:gnx\'u?XP3UXSY-<>z\0ѕ:T}#$EFlm&ƣ\'3cMe,f>fxî(@/S#5\"X喝Rv+C\'nlBȎ^/7^poꠈ\rfJ`+ 0)bcP\r1.7C(@\n)]`n-S}W	\nendstream\nendobj\n53 0 obj\n3558\nendobj\n54 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 55 0 R>>stream\nxcd`ab`dddw\r44\01H3a!;%k\n~n._PYQᬩ`hiiZXX(\'gT)8(t+@lu-(-I-ROI-KMj+I,````4c`b`bdd|?ڙr8cRV?aZ:%[&͜:qr|/d-0}3n9.<g00\0\0fZ\nendstream\nendobj\n55 0 obj\n262\nendobj\n56 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 57 0 R>>stream\nx}{lSuw.0@uTGoyaC6!%lH\"\Z*{Ji7ڵz{}l]Q[h\0MF\"E20!cb<Q~|{~IO#ðE%%kxI%fǴ{C9uip*=ETS\"zS\nn~E˖u5S\nCVrm0n4_VWR{te=Pgf^+1LEֿQL2#ϑE$N!%dY|V6!}d#r_lq|+(1\rv\r5#~Çp.dowxa\0¡@{ xz`傣ezasDG0G+F#]v_*y%?=b[hl}@ZB#x4$_²+jg\\\0>X\Z,@5f2\'XWi8al11\0QW\0B7@]s	}wiX%O+\ru$wq +[Kd^[XI>ΌJ^O%ve32\n\Z*P\'t>s{}7!Eඉ&vEuz:tgx\rc&N/^mZOӍw U +9~[W͊|dфk173WXSOI=.Gg~k1;haeK)Cq4W͔icS9\rYxW\Zװs s}%:-9~h\\r.{RjzH1_<\0\\vJu^Adhwq8U6;YW\'q?$Gp5~V!$EI^K罽ꕲf^\rv6y	x$9QwwʁS4Yj;mҢ^n9:횞]w5}.ǫJߐL?d[.Cr$W\\7M7\'x$;XľD[$x8G;рV>_x5!W(Ի:=G/zu`\'S}u*Me|Y:G<i{Y4[:||n5|-FC0K2\'~?I;1]˚0\"/\nendstream\nendobj\n57 0 obj\n1206\nendobj\n58 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 59 0 R>>stream\nxT{Pu`YNv+C\'|`JR\"Sf	\'Rݻ(xc:eik1%98YǌnPk&鏝ٝ> Д+?\"=4\nY!;#YϢϠ9ь)SN)**[oE%$%Ksuنlؠ,f7lЭ(խЗK%\\}I!EQl)/Jͤi+ԫT5zKM\"tPj>*hTu1xOtoZ[IP&gqnZnd-Nk}\0vjI2	z46z%8X9G-X)T}\nzK\01Bm:4@lfŕi\Z\n#!Aw}R5\\anh瑟AQ\n{>L0fNp`*\'~;@lEjf:\r˚-+@4k{ykj@d	@~@̝3qOHO1>M_/(bIE5\n፸\Z\'0Lk:0ߺv*6а05#5s٦E}bt?$_?$b6G7zrS?P}8}?\nۦz#yryEţ`<3n{K\\k&aG#O*8/\\ 	O06U\'} \\Idߣ3\ZȠi/\rx|?NS#IJ9BnR%T+v\\<:;Pqjnż<~է4%|ֵ@ hd2+AsIXDn	^\'\rӟ 4;sKPg.E]\0:,&ŹA!.L<11dq_E1H0D[1U1=C:Q\n%U6U<>aqc[ƭ,ؠ<Cibeo̅ͅes5Bs(Aʢh[7۸wU2\'Q#YlB1/[\'sI\n0\"\0BGE$PK.T˱% L>rQEgU~Y5u]BF9Co\r9T͏1m\\B̌XՍlsn\\${YZE;fĕDis9%}sd_隣D~$`hʙVSSk6~bY8s[X8;͒eniap\'v).,x~g^Wx8E!\nendstream\nendobj\n59 0 obj\n1362\nendobj\n60 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 61 0 R>>stream\nxcd`ab`dddu\r21H3a!G&u?\n~*_PYQᬩ`hiiZXX(\'gT)8(t+t-(-I-ROI-c```4d`dbb`add?U|V3[+x>w?~foݨ{]M<1}r}߆_~Ѽ\'NC5je߾~QE}GS[kOjv/~ktn7Nm]WWw+G[_[~\r4)Y{ӏZ+ۻs<Uӻ9Rؗv>O/{Vw\\B\nۡ݇fvM	*3-iYNƾ|Փxxe`\0\0}Y\nendstream\nendobj\n61 0 obj\n434\nendobj\n62 0 obj\n<</Subtype/Type1C/Filter/FlateDecode/Length 63 0 R>>stream\nxWiTS!@%Գ7mmš*-UqE2 )ʐM\0dNa0  \"JjzZNj7Q{{sZ{%yD\r%$Vsjd#fc8dvkx͑8aA硔X$Zb˂ȨX\'\\̙4?<P=/i_lH`_C>2`{`ld2:1Nc;=(EliU@yEQ\"\"\n\\H$v\"c/yw&Ou6}{ZC-R);zZBMR(jLyR˩\r\nj&ZEQ\0j eO9PCa#%S#1G9PP4U& ҈$EbFNv8`#20iσU\rvkpXr08tq>gaaXoUo6CSXvˢ0o-[uC[UGhb!t\n-#͚Dn:=mIhWgA֨&(tf: @n8PD#w%RxD.^e\\#0U%q]ޭ\'/=[	UM̤lkUn!G|nv誡\nNjb*+_.xsGn69z\ZnY֘\\\Zw7\\H/?J;En7Q{44a&Mx__貸*}避mB(2AG\"&/O	f#8gh=wA;XTJeQTs[0z=602Pʑh!(|\nGQ8w`T(}\"6Ҩh2bP$Џe4+3Ӌ_h2މ7FVy!OX\"%3h%~@21|!*Pt,@|1P}\'4@kٻ Ԑ8s,j,sjĘ;ݳ_|(^SPi5Q5yuPkB[5o)ӵ4ˤ#R` T`df:Ba.Jͥ!!8h*79tcopek;k;tbG͞o\r=a+`p/?!	\">zड़4/%jO骠\Z:\'+z9	t-q\'k#χ)cgFc(.߫KߣN۫CƺnbO@42Z2i>M`\rz:w\"},n*:e0WIr12?@q-#cЅtb9]iK>nE#kf+q-qQ߶M?fq+(Bۮ߉qe,3\'fCj1LlI\\um)~âY^kr%r6]\r68b;Fjof?(n1{Kdr\'jyK?,śL.M\\0U|?J(!<cD®ＬRҏ6_Je_ROWc8\ZGwсFǩ4q)D\ZeuuZ_ॾɜ*Є}-*_ݪ@p9wݮ4\Z!\'q;WTkM||b4aIr~oJld\00ιlsdWv6+ƃel(3ҕ$TmI2L^Cci+)!Bi/\nqk|!Yp/\Z;6pja\ra:ȂR=R5?F[pxmxm!FKIt0xRp8,\'K;d\'8L}y\\)GuCrfn\r^ ?s!XO=`!:}s!6亦_wgNf?0^qJ>=>,C@bŵN{4\Z-+bON2Bz֘qc\',`6>m<*df&d$Zmy9Ӂ1At|hݶ\\\\Fzu}sZnMLi	c\n!BB2]\r)8U=\ZH(t}HIdI{2Nkmn*|o6hWr[CQ\n=͖̎gZf	lp@0y[̣ݜA\Zu8,dduLe[\"li<tɠ*2\r<~RF6tQd5E?3\n|꓃֮~oqz4z/8$VzLĕrfNF-ɐ)j.]=h!d-{Bze{,.f҄7DN۩<eͼI[\'7DQQhsPZ9B\Zo5BW..dRu쌶S~b\Zd\nSqҙ5r--1ϫr_1Z$Wp\\\\q}ddB\\3g|v\'l[SQS[[Yi}ͥw\01&Q	s` ޓ{}(\'\n;gD(6dbC\\LҒ3>OE\0\r(:[*iCQYV@rA78t?*\rB̵$-36WQzK*GDkHhܖ|$XV(̞nTU3	׬Ws/@VZ/Y^ϼBH;q.gtkOL`MӫFCcwO[n/FHw*WlV@_0O4ehƱlhhm͛K3gײp}bUMjzGZۦArjjeüP~r.eѓlp֛8g@|?\\lwEoYb`w_+#Ro<ta\0qŞ/h6&nr7z%3I	;mAIs+4FWVgR!&ʘ&!MfBӯ<$z91\"K,%1A(vp+/1LHrM\n[v- dqVd=n\r`Oii*P\'?9%ӁD\n])BpW1iY\rphppQKJXV\"r@믑]\ZX_nUqc(9\'*21\Z)s_Nv=NJai5\\䋗Y~=ˏ~Sk-rtWxe=v脯Gξ_3$\\fZSp>ЕY䙄FWBsz+a,QH.[H@&QШ/;],jtA£NU1}t*ŅI\Z2a\Z\n]TM3\'x_S}v\']B K%=Oq*r;(\\\'niOBfijШ;s{s*xPRh_(-bVsI8O>39s\n3F/dnL?3k\ZkzcI/H]|pIQG[䚽u*դj`7#S*s;*Ѵd<ymqOBt1Qdko\ZF{HqmlMn[Vd,9|Ļd8#LyD(}i?M[8D+!|ZqB\\fZ%a+M5	R{0,& ͚fqa|Xtq^|ߏx+b$}$\ZIu)FH~<{7v~\0c_:\nendstream\nendobj\n63 0 obj\n4035\nendobj\n20 0 obj\n<</BaseFont/YWRBPR+CMMI5/FontDescriptor 19 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 1036 1037 996 0 0 0 0 0 0 0 0 0 0 0 0\n875]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n18 0 obj\n<</BaseFont/SZBQCB+CMSY6/FontDescriptor 17 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n963 380 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1222]\n/Encoding 64 0 R/Subtype/Type1>>\nendobj\n64 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n16 0 obj\n<</BaseFont/MUQRQK+CMMI6/FontDescriptor 15 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 924 927 884 998 900 0 0 0 0 0 0 0 0 0 0\n780 0 0 757]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n14 0 obj\n<</BaseFont/EFYKBB+CMMI9/FontDescriptor 13 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 771 778 734 848 756 656 0 0 0 0 0 0 0 0 0\n0 0 0 628]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n12 0 obj\n<</BaseFont/SZBQCB+CMSY9/FontDescriptor 11 0 R/Type/Font\n/FirstChar 0/LastChar 33/Widths[\n799 285 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 1028]\n/Encoding 65 0 R/Subtype/Type1>>\nendobj\n65 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n0/minus/periodcentered\n33/arrowright]>>\nendobj\n10 0 obj\n<</BaseFont/YAUXEU+TeX-cmex9/FontDescriptor 9 0 R/Type/Font\n/FirstChar 16/LastChar 33/Widths[\n614 614 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n814 814]\n/Encoding 66 0 R/Subtype/Type1>>\nendobj\n66 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n16/quotedblleft/quotedblright]>>\nendobj\n8 0 obj\n<</BaseFont/GHNQRB+CMR9/FontDescriptor 7 0 R/Type/Font\n/FirstChar 12/LastChar 121/Widths[ 571 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 0 0 0 0 0 0 0 400 400 0 0 285 0 0 0\n514 514 514 514 514 514 514 514 514 514 0 0 0 799 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 642 0 0 0\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n0 514 571 457 571 457 0 514 571 285 0 0 285 856 571 514\n571 0 402 405 400 0 0 0 0 542]\n/Encoding 67 0 R/Subtype/Type1>>\nendobj\n67 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n12/fi]>>\nendobj\n38 0 obj\n<</BaseFont/GKKKKC+CMSY10/FontDescriptor 37 0 R/Type/Font\n/FirstChar 54/LastChar 54/Widths[ 0]\n/Encoding 68 0 R/Subtype/Type1>>\nendobj\n68 0 obj\n<</Type/Encoding/BaseEncoding/WinAnsiEncoding/Differences[\n54/negationslash]>>\nendobj\n36 0 obj\n<</BaseFont/WSXSQF+CMMI7/FontDescriptor 35 0 R/Type/Font\n/FirstChar 65/LastChar 80/Widths[ 859 863 819 934 839 725 0 0 0 0 0 0 0 0 0\n727]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n34 0 obj\n<</BaseFont/GCFFPC+CMMI10/FontDescriptor 33 0 R/Type/Font\n/FirstChar 65/LastChar 83/Widths[ 750 759 715 828 738 643 0 0 0 0 0 0 0 0 0\n642 0 0 613]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n28 0 obj\n<</BaseFont/EMLRVG+CMR6/FontDescriptor 27 0 R/Type/Font\n/FirstChar 40/LastChar 49/Widths[ 481 481 0 0 0 0 0 0\n0 611]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n22 0 obj\n<</BaseFont/QYXKNE+CMR10/FontDescriptor 21 0 R/Type/Font\n/FirstChar 40/LastChar 121/Widths[ 389 389 0 0 278 333 278 0\n500 500 500 500 0 0 500 0 0 0 278 0 0 778 0 0\n0 0 0 0 764 681 0 785 0 0 0 0 0 0 750 0\n0 778 0 0 722 0 0 0 0 0 0 0 0 0 0 0\n0 500 556 444 556 444 306 500 556 278 306 0 278 833 556 500\n556 0 392 394 389 556 528 0 0 528]\n/Encoding/WinAnsiEncoding/Subtype/Type1>>\nendobj\n19 0 obj\n<</Type/FontDescriptor/FontName/YWRBPR+CMMI5/FontBBox[0 -22 975 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 146\n/MissingWidth 333\n/CharSet(/A/B/C/P)/FontFile3 40 0 R>>\nendobj\n17 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY6/FontBBox[0 0 1128 432]/Flags 4\n/Ascent 432\n/CapHeight 432\n/Descent 0\n/ItalicAngle 0\n/StemV 169\n/CharSet(/arrowright/minus/periodcentered)/FontFile3 42 0 R>>\nendobj\n15 0 obj\n<</Type/FontDescriptor/FontName/MUQRQK+CMMI6/FontBBox[0 -21 944 714]/Flags 4\n/Ascent 714\n/CapHeight 714\n/Descent -21\n/ItalicAngle 0\n/StemV 141\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/S)/FontFile3 44 0 R>>\nendobj\n13 0 obj\n<</Type/FontDescriptor/FontName/EFYKBB+CMMI9/FontBBox[0 -22 823 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 123\n/MissingWidth 333\n/CharSet(/A/B/C/D/E/F/S)/FontFile3 46 0 R>>\nendobj\n11 0 obj\n<</Type/FontDescriptor/FontName/SZBQCB+CMSY9/FontBBox[0 0 970 430]/Flags 4\n/Ascent 430\n/CapHeight 430\n/Descent 0\n/ItalicAngle 0\n/StemV 145\n/CharSet(/arrowright/minus/periodcentered)/FontFile3 48 0 R>>\nendobj\n9 0 obj\n<</Type/FontDescriptor/FontName/YAUXEU+TeX-cmex9/FontBBox[0 -2957 781 45]/Flags 4\n/Ascent 45\n/CapHeight 45\n/Descent -2957\n/ItalicAngle 0\n/StemV 117\n/MissingWidth 250\n/CharSet(/quotedblleft/quotedblright/exclam/space)/FontFile3 50 0 R>>\nendobj\n7 0 obj\n<</Type/FontDescriptor/FontName/GHNQRB+CMR9/FontBBox[0 -249 833 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -249\n/ItalicAngle 0\n/StemV 124\n/MissingWidth 342\n/CharSet(/L/y/n/c/parenleft/three/o/four/d/parenright/p/e/five/six/fi/r/g/comma/seven/s/h/eight/t/i/nine/zero/l/a/one/equal/m/b/two)/FontFile3 52 0 R>>\nendobj\n37 0 obj\n<</Type/FontDescriptor/FontName/GKKKKC+CMSY10/FontBBox[0 -216 638 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -216\n/ItalicAngle 0\n/StemV 95\n/CharSet(/negationslash)/FontFile3 54 0 R>>\nendobj\n35 0 obj\n<</Type/FontDescriptor/FontName/WSXSQF+CMMI7/FontBBox[0 -20 893 713]/Flags 4\n/Ascent 713\n/CapHeight 713\n/Descent -20\n/ItalicAngle 0\n/StemV 133\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F)/FontFile3 56 0 R>>\nendobj\n33 0 obj\n<</Type/FontDescriptor/FontName/GCFFPC+CMMI10/FontBBox[0 -22 804 716]/Flags 4\n/Ascent 716\n/CapHeight 716\n/Descent -22\n/ItalicAngle 0\n/StemV 120\n/MissingWidth 333\n/CharSet(/A/B/C/D/P/E/F/S)/FontFile3 58 0 R>>\nendobj\n27 0 obj\n<</Type/FontDescriptor/FontName/EMLRVG+CMR6/FontBBox[0 -250 505 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 75\n/MissingWidth 416\n/CharSet(/parenleft/parenright/one)/FontFile3 60 0 R>>\nendobj\n21 0 obj\n<</Type/FontDescriptor/FontName/QYXKNE+CMR10/FontBBox[-40 -250 813 750]/Flags 4\n/Ascent 750\n/CapHeight 750\n/Descent -250\n/ItalicAngle 0\n/StemV 121\n/MissingWidth 333\n/CharSet(/y/n/c/parenleft/three/o/d/parenright/N/p/e/D/f/E/six/r/g/comma/Q/s/h/hyphen/G/t/i/period/u/colon/j/T/v/zero/l/a/one/equal/m/b/two)/FontFile3 62 0 R>>\nendobj\n2 0 obj\n<</Producer(ESP Ghostscript 815.01)\n/CreationDate(D:20060627001046)\n/ModDate(D:20060627001046)\n/Creator(dvips\\(k\\) 5.95a Copyright 2005 Radical Eye Software)\n/Title(proof1.dvi)>>endobj\nxref\n0 69\n0000000000 65535 f \n0000006062 00000 n \n0000029628 00000 n \n0000005989 00000 n \n0000005533 00000 n \n0000000015 00000 n \n0000002468 00000 n \n0000028076 00000 n \n0000025016 00000 n \n0000027825 00000 n \n0000024720 00000 n \n0000027608 00000 n \n0000024390 00000 n \n0000027387 00000 n \n0000024188 00000 n \n0000027166 00000 n \n0000023986 00000 n \n0000026948 00000 n \n0000023656 00000 n \n0000026733 00000 n \n0000023464 00000 n \n0000029287 00000 n \n0000026340 00000 n \n0000006110 00000 n \n0000005684 00000 n \n0000002488 00000 n \n0000003823 00000 n \n0000029055 00000 n \n0000026165 00000 n \n0000006217 00000 n \n0000005837 00000 n \n0000003844 00000 n \n0000005512 00000 n \n0000028831 00000 n \n0000025960 00000 n \n0000028610 00000 n \n0000025764 00000 n \n0000028405 00000 n \n0000025525 00000 n \n0000006335 00000 n \n0000006400 00000 n \n0000007338 00000 n \n0000007358 00000 n \n0000007807 00000 n \n0000007827 00000 n \n0000009157 00000 n \n0000009178 00000 n \n0000010552 00000 n \n0000010573 00000 n \n0000011029 00000 n \n0000011049 00000 n \n0000011947 00000 n \n0000011967 00000 n \n0000015611 00000 n \n0000015632 00000 n \n0000015980 00000 n \n0000016000 00000 n \n0000017292 00000 n \n0000017313 00000 n \n0000018761 00000 n \n0000018782 00000 n \n0000019302 00000 n \n0000019322 00000 n \n0000023443 00000 n \n0000023871 00000 n \n0000024605 00000 n \n0000024908 00000 n \n0000025441 00000 n \n0000025669 00000 n \ntrailer\n<< /Size 69 /Root 1 0 R /Info 2 0 R\n/ID [($Q/o|$#)($Q/o|$#)]\n>>\nstartxref\n29821\n%%EOF\n','Disproved','BZh91AY&SYUR7cǿ4j`-!P@\0\0\0\0\0*\"\n@\0\0\0\0\0\0\0		P\nJj$\Z\0\0\0\0\0=@\0\0\02i\0d\04\r\Zh\0\Z\09M# h@@̚hd\01@\r0@F\02$?\n=@( \0\Z\0\"ih\rM2`RRmDOO\ZUF=F@7HORFEa\ZL#\"U%Q0\rDjD-b)P~Ff(EF*9P/11x![\r?׵\re==X%2\'0H)!1B]E\0w},=_b6Fkfi#~GުuRG<HRG|$t_QJ~w2G~ͳcfٛMkmfٛL[}ԇW\n-T~*(=z=$TJyU|XYC/h;y\'Âq*p8((|	pT8$pߗW͸ÓWN\'C~9ggb*5ִ.s1k]G]%vj蚧IZj\'G1r:sǎW;Qjz:x\\dz^yW$KKqˤcԜpO	;vuthV#rOt<\'n5,M)rFS53EǦ\'d+nZ^jdF\ZZC֫YzZb\\RԬ9\rr\ZשjK%TՑ.]QZƵ\Z9Uq\'irӳ2!9n\'r%uE<뗝1]CZ\\qަLbtMGMreB\\P3T=+idvYFc-f4զ[#1e+XUm\r{9\'3QʬkK:Bl\nT15S&cheda\\Zһ+1MK\"eZ\ZOW-,3J:^Ֆų*60mN[Fj$iukҌ8XZ\'h$\\Z-Cq,iLFacXkIƪcf6M\r9Vh`sI܊t1]rԺt9.DEwӸ\\Nk].]\\.WW*hXۢuuuuCt)r,S.u\r\\GȹkG:Z9{´@26\rL[3M6rzcB?GJ9R:7;ϛ~/Sڈ!ACR/J*>	G$}	%!J}E_D}C_l+>}}}{=*{)OiD{)Q쒏j=ڄCHQG{U==/b==k=קO_`P^}t#]O_*b\ZZ\Z֨j/}}u.G>yVZL:o)KR-*Iiźte*䷪FԵ6Jm(G]˲vUwy=.K>{xOy|	{=Ɵ{_\'S]].\'|zz>S	NO.\'B7ճ.yo$ީoBޡTK\'=Sb5kjSTZMTJҁF[ٷL:L3oswSck+)˜SP_ϱRQW+zNg+Ql\rcf\'|?:_ԛ?dGPGL\\sIt\ZH8rkFl0ͭ535G?Κc2ZǸ&y뇪}k6c,kA2q9r-d1T=vmmD3UK3dOFt[%.3yE.\'6jmS5& 3#\r\rde15k&FXVF冷1mͤr#WK^Z˖rC<+)MVƲ֫CP,bL-e-k-SVJɔ3YG	\"S1m3m6SjFCY6ywu9+|RڜZYVZ\\o9F\Zĝɺ^yk#5sB-jcjU$FRmU,\\JW\\k&M(&mŲRt6Q]h.tʹhZnU&xs.jcUdY\ZY1lbW#Wr֨\r1sc:ˁ]Cj$2KDƕƺ<<;¦cMd,VWGjt\\bX2:QvhZK<<).K165L)xvNbk$٬hf4(m͵DѭJqVXLlMUO.1,LN\\K0K1k\Zuԯykj\'MTf#122K\rQIjȴTʪ;GUmbjW[a\ZZ8p5u\\b\\jǜwmݢ8j5T-&&F5MFխNjN6͹rƧ4dWrTj,(ha2<v2n5L\r\r)urg{pӃm;au8ںtZ.qQ$G;ο_¡_XG*_%AbILV$UeTVELMBSDhFU9-X	p+H5X\"e-Hj؏x*$Ob쀟ɠ}I*ON?O)/eH\">דJXUPseQ+<\\{?U>O;K65fcr8T_~_{¥WOj_*P_b#U\nԞ޼vʗ6C8ƿNACѥ]PC\\|]GW_/񇐏}Bs26hFZ\n\ZVE*0U1\n0*0$(SKJFjbʵ23G^D~*Nʇm3-1ck35}//|*P߷6flmlml}TR+\n(Z0#mkYiMb5S6U#MT6*ZiTeR@LhT`J+\ZIҊZC\ZS2IkIP!3R4\"̐bFЍsceIVP$(xWVbWvWêOħLL4#)M%FFFR*#$RU*T5	bFI\ZYF,REGJt*Pri)\naPjsU#(\\*;қ\n<}Ϭ#xBt*u~{Dt#P_RT{uvwÊGv#0aG|QJQJ$dHyꊊ;\ZTTQD#dCjRĨ0Z115֙+N1Ӿ~\0HERtWP?/#%K||=ϐ#	(sU\nכJ˞^eݴ1AY&SY&c>h\0``|R\0\nP*J\0\0Q(\n$T9FC&h`4h\r2d`\0!220CFiF i#\0iɂ\Z0#M\Z1L\0sLLф\Zhш\Zd\0A5)\nM\0ꧣP\Z\0\0RUe=)4=P2\04\ZK*I\'rT\ZSH+#Pdh*q$Ju;E_v)51TbGPrd$>Amk[[mG#h>xQ{T>	*JJC\n/$dOG~%ϭ>*__Y\n*SEEB|7J?1K#JWFH./\\\ns4ZVT˴kbF:VG*fR^#B\Z3Ӣ0TuWRUt;GyWu\\CKGN㼸Eⵦ<ȯvb8qu%)^B#]]QN9S\\9Bf 	Ye+%Ɣ\ZT\'+QaZV+FյoT;WD؋mܪ04%Pp+#UwHH;QbWZQqUmjiS1K!dM+1MUsS9#8;V24DiThX#Zԭ\rm䏩QR)p>yW_#LD{	TU{IP%Cȕ$B!Rȉy	<^RݞE\n^{ECT;jv}W{>0>\">!z=;uӫU|Hdw+$Gȧb;xƋKRC]ݢtR:\\J=|Gҏ.HK8\nT;z#^^WT</uπU9\\\\re:x$p:]\'J\nW{aO2!:[##G##*-IZ#2\rQr\ZKUh!)h֖6*YK[m3-hy\rwad2LrYQ)4V㊼8qaMDW)YF3##UZTv\\p).HU%tN+K*\rJGJ$<j\"]xWq)܅]UIU\n!W$*$*̪-q\nNPJu6hxuB#CTUd0dj5!J09Ud\'kVB*L22&FR2ʫBNbm6lFZk[TN*sIۥ-%q5\ZB4Y4؎Zdo7Z29ƐsiZe@fJ\0UwܘӶ;5JVt:kӦZZUɸ_܏H>Ը)>V%HZ(\Z%jT\Z\\E)-H*a!hAet	X9hU\')^u_+%{% D8S{\n:ؕH#^$GO?r?/|\"H2ҢFHCBIPĨi**%C!C%PUC*QQeL\ZL#$~#jfOI}yH#붶6tb]P+(+Q5T4f&5)VZj\"+2܏UZpJAJ \\R	S\\KCt0!V!VbPԨdjT2T42T0EP&ihM`K+$TP+)BG(K)tRK(UGr<ЪzKH#)J=%z+H@`(\"i*/E4\rT	iU2Rw/	]N4ҕ%x*Uud2WRJ<_dMf	r?>\0\0\0\0\0\0\0\0Riɂ\Z0#M\Z1L\0sLLф\Zhш\Zd\0Cdd2`&F@&F\0#!4a0F4b20\0)UI3Szjb S RR	=F=M\0\0\0@\Z\0\rڂTZ\nB\ZUS\"Jj*VURaR\"!ȴ\\\n;k~xGψ5fȅ*ŵU-yJFȴ¥|/{6ٵm={D_\"誔@`#>pG|B5*+]ؼK^-`DJ< GU\r VUOy>IJz*IU-*F\\\"4_E-!h(]`\".:W擠^\'hvȴVEӷ7)`r.C]uW\']ũȴ5S\\tKZ,냊~qx]E۞\"..I]拊]E/y\"\"p켉qKG\"WQr.EȻK]*<	Q٫4QxWp\"4Z-ޖSE\'ANv\"뜷jGDZȵ#R41\\ܥ]EQiG\"hH\"d\\E9*Y-A\Zf*i*	Uh8\'QrB]SPifj02-HhR0MPcUlK1͆.xD~]\\̋j-HkT\rP#Xj\ZFEjUVZVwEtt	t+XU\r VUUMc^\nY,,\")R,yxRqE\\Qor\',KJD[`$Qr%0`aG$rTŒ,2F4b16mU6̌)3S!&TQ,e[F#:G	,j`p,VHTbƁKÍu&beʸQwHU}ToEk:ϲ/l[HH)\ZUb4YIiG6ZjRZIj6[Q^)\n-T5L.Aȸ+TYQwb<-UjE\ZN.\"G\0Be$yWJҤXx\'*.Gp# 94\nXd!\ZK7\\P\'1l9֕C$a]-&h43]csRVS[!\\*-͒W[mQ\\W	hdZ\r,Ed(]E,VZ-%D0SN&j&T5,\nHHZ-n+E\"֑<E&f2*;Ϋ.qwSD]wîQ鋑{udZ-Q244ZBHJU,Q-JEԪ/D\\\"=1%l\rE)F%GB=(c5J)Ƚ]hz(G\nW:?`jT#B.\n#;12/\\cX닭)MB[--HȲH-\rD4\Z2`#@F\ZA2 aEeRbKd٢8r.յe1JzͶmC֋ڥу%*]Ԫa*h-XelXQMR|^\"E\"EAꎑq)OUzW*V0F0PFZUZjF\'e$=(B7))R܋Jc)Lh GNE3mEE=E*[RHThGTB[{Ћ8*CQR\ZB/HTpI\n,TQj\"Ж->\\R!z$[QhrD\\HqPf̩_\n2ͷk)#@?\0\0J RA\"\0R@T	\0HP\0\n(	U\08 \002d0FLC\0d\04ɓCCaM1&L#\ra40@#L04R)S\0h\0\0\0 \0\0\nJH&SM\rhMPꑣ&dOJ)-\"z!D&QL@&DąB&\'**_@?tU|~wS	U~:lXͳdfE//	pR1-L,\'6lI}G*?*>D)_lrݑЃ窕_aRi}CR>g\'?}+H~\ZzTt!yJD/2R?~Kv=ؽulbΘ&IvWjpX~4UhbKбj9Jŵ0knm3\ZuN\\5Mʝ54.%pXSKM;\\.EhSN`;.Zv.e4/e\ZZY2StXeelV\',Xx.)ŉw94z0q]z.tVK%;ţLfU\\qx#J;,txZ-c:EtˤӵuP\rSsO+\r[+\\IƗ%ݺqSt]Nɢ,V˹tXCp;WgG&Zru;.ʝL.]scم*v96Y:ҝ\Z$ɥFkZIQV^\" K--SBSUd4,[W`#)F-I.999Mjh40ΉKV\Z46ʴjk&YVdeN^r[\"BҬZLɓ3ueF+V.JdS5dhi\\T9LY\\sZepVGqZq\Z2&ѧUskjfaL\\ieiSS1ip\\I#PwSUY:XVĵFŋ1X5g m)rnrJ#Te,&,3\ZSLHҚiMFjXX\ZC-%G*>dj)>b}9QQQȥ{ڪ=H=*UTi=OWf9TjzB̥W栾|#z{}H{{^}{/.铲_:_%GZۣ/f}%>RvWJ.t^~rr^dySܨU<E<HxE<NyG^iWJx!⇂\'y)䗕KySJWxy`Byh(K]ѦxBx(|J|JzA/A{ETև@(zSK+U懜=%!x;zQRN|D^</W\'\'ONu\ZJXLQ2#pٳf5UjZ.32)tťe\nr,3Li34,R\"G꜆ŘkFZbtΜq̹:Yt98rw.SQ52d30ōV1he3LLZauEp$Aȥwd]:qɋ1bK]Ru4Yb̳O8XҚbKSJsbru̫0wjVBmQMIJdl;I6U(ҎN)ӳXd`%lA2hk֩&e4T-(P6.ΝUSBNDY&BNɨڙ0KRJ xҶ4hb+RU<v\rS\riffY4U5VKZDGlڕqs6J]1q]ԩƅ8\ZSօBYYRȒw]K&31Y2`2[4Cf͘3\"Ԙ&hvk0Q9MȵZ+Tșh,ĬuUrm4iLefhdٓ&fX2lmSeT.WcYL,d\ZDrc6l5ӂ1Nakf4+He[a߻h1aNыt}\'	I<IDbyPhP)OIJh@,@uH¥\0ҩh.\'*\nR/uP>و5)B{ǀ!y	zKz GOP!|cG @w\'\n T|ؘL&J\ZJʫQ\nҨ-HQUJҠbd P1eib UXH5E,4Zh!&Za}\":&f-Y `!Mlmz_\0!b詩iD1$L(Y ؑZJHlM0IdV%OOQI(:Tz/F-Ee@%\Z\Z\ZhAUJ4##U+M;UL<t]Q*P]ԽH	y@J^?p@Oj(	*Z)xƃZ@\'/O&jQZA|i֐*>!\Zd%+3Y1URbpOD|~<|RCT\'(T|e5hNO?SD\0\0\0 \0\0%UR\0B2h14@`M4\0a2dшbi4&&h\0dɣi0LM48ɓF!`i&SIOSOS=OP4\r4\0\0 )=4jP\0hM\ZyLGQ@\nUJ!2CPQJU}Bipy&SdNҕ]=)*U圎R.\nbWi|%HG>Ͷm|!ҫ*$a)Oi\n;QBy\n:PU#T\"uޞ>%]\0KAGPQ\n:QQQnP]%}r/!2,㥈r!N`CVC!`NR]CCCT)P!t\rĻ]!wNBhf\r;u;E9C;]QlmP<:;pvrÈ<Crگ0r\'^\'AA]ôHj`mIܜCt2Ck]0bƉFGU5U@)C@Z\Z\r+CTEȌQidƦm\n$h9\Z\Z8Y!49R9Uq\r4\Z\\.CHr\"H\\H\\E4kRj&*lT3fmCCCCAZ\Z\ZhmRhG!ttQJO_BH~C\n%VҠ)MPT(\n5BPUR5*FDҠԭM*\\\"KPPPPPxQ(ިKJәW2rܼsa}h>|aQ\n>t|OQ^\"^xC<UO	!xTOS+={CSڋ+Cؗ4^zHzUWu]*:Iקi`yE쇴<םy<t<Gp)H*^Q^EO(O!O(_>$z^<^|_DQz==/K҇e$hep.AAAq\rFpThhhr\Zp45L\Z4d6\\Z5̇TȆArC\rF#CQuU7)Xȝd.2,)4041W(,\\+	S%WQ%&+XEbhQ(D(U2bJQZK(\n0$s6qEbm![aJiEe*NEhj\"̲D,K0vl\'.\nV1V1D:SUhhaZ	.jUW1%hhTF52KEbZCx2^%d+\Z\Z\r(wt	`dZJu,Y.uuhyÐRPJRyBUiB9QCI)ER\"dBC \\JX^aQI)}JJ[~jH~yR\'IHW%#ԇkeHG/x<!CJGJ%wCQd1H2 	U(be\n1\n2B*+!+VPVBVK*De#Yh=9_M~ܩf}TCʟ%JɅH8%HjTV+2*MhJڤXk$+Jv!Z%>EJCJ^8Cm0X$Xd(!F\n0(QFB\n2bd(U(hMb(RךR:IJ+<JGHT!E(!?JQJ+J49T|I}5JzJ>&CXh ((.En\"]W\"SJ(ĬU[ZT4\":e%ԧP!T=*PC)%?dMd~gl	 D}\0P\0\0(\n!D U2h4MM\Zd&4&M	LѦAdɣC414i2042c4b\Zh`&&2bFFaL&E*0\0&LfF0\0\nJѪdB\0\Z=Mɠzy&G*&TEAC\0d2UUZhb*\\*ʸUv1E~d `[lbZT*\']\\TN!Ȭ%B=aff^bTS\n=D(PBdwG\"TWȤ}%}E/JomWR{0BG\n=Qڅ(\'m\nj}S_e#C(b2\Zjjq\Z2dZG0п.C2CU?$24;+u$U+:WD29(u[,.\Z#ht0YW(u(n*K8ғt#;CrX.:r42\ZC2Cvn0G6jC9QpF0v̣he.I8(s6.Bիg\'<\'g*0T%ͣeXFUrS\'HSIhbd2ZCD\Z\ZUJqBjK#FZZ$p\\Rd8C18#hq!\Z\ZC#D28\nqC-U48V\\,\\R8\\BPp)\Z\Z5&\Zٔ)Pdd5C!\r$jCU5|iC]:|$<8UuJWJu*QN(\n:UH:Dꫪu:Uy*ԝ¢(((((У;jxE]N\"Ja߼H}_DExC܇r{Iy茶<{|Gaԝrʔ%䇔:Cu.^\'{	x#<TK8#pO\n^cꇭ=h^=krr=}zׯB]w||]K؇Q旜W/8yCȋCCȗ=!r^^\'|+~{C~2I2\ZC(~xb.hd#qE\Z♔rCq!446#e쌇0Èq-`hj..S%EvKZ(䓩֦Ƃ42\Z)&TW#)4Q-VMIv\ZDMJ\'!G!KʊQ9\n9\n5-\n8\n8\n8\n5-\n8j#\n2\"\\\n9]v+*Na\ZiqĩΪ\'hiRiEv\r\r\rU\rCF\rN`FPMJV%CJQml]dڕLa+PȵrC\':spNbj\"uvi˫ژ.]pv5g.ri\\\\_|;È9Z/B&L$%(dJjLTI(PSδLT*ҁ?A*!BT#īH$?I*\'ܜG~\n_*zJ~BT#kCﮮ}#BJ=0CQd2B\Z(\0Q4\n4d(QAFB\Z\n4`Qd	jJX4(HbhŬ?R\nqaYk^.ĨGSI%B5d^ +9hblP+`lFYlM\ZҪօb<\'\\!)CD޹CHxk\'*!LУ(У\Z`BhQ\n0QTdI1h,2Z;*Qy%B9N`+:)zAW$8C>(IB%\ZC=^	P\nQ*~i\Z^\\\"JQ!ҋ5J1hM3;ʡdEx48CKz2!%.自Ĥڇ)mA?1$\0_0oR\0\0\0\0\0\0\0\0\0\n\02h14@`M4\0a2dшbi4&&h\0dɣi0LM48ɓF!`i&R@=A\0\0\0h\0\Z\04j6?TA2d\'P%%@24d*Udd#(*JZxn\Zԋ{DJU2=Umįɱkcb?*@@?*=+T\"=ߛmfo\\#|P	AdPJ++;RlH⏼~;Gۅ~pW	_BWR<Tm䮢nB~Y\ZC&F#LGꅊ8E:Q22G!b:]kUhθљmlMqދ;X&:FSRh7\0;#۽\\\'twG]w1wGntG;#1Nt8Fddʦ#Y7~##v#\'W+j)CfӢ2ruuiQ?OQȢu\n^Dv&F#A-+*ty21YdjLF###w&X-24LٌwWD5Z&#ʫ8GUʜ##8FSn)228#pFF##	̎##qp1qG28\n9NN	R(Mj5iMD͘#fͳlFFFT6#dU0GGD#*GQ5>R;={{C(=%	^	^	^JTTB^Op}Ώ^+%{pBWJ쨾Oq|\n>AWyHQR+ԏ>|_(<JxI>/%\'\"=ڔxGxIN=eOR=^zp*zzȽbzdyy#̓IKnv(x#G(/\"<#GO\n_Q_RGOhRy%<HJ_)SЪ<<c|ʫJeGGҏގ1K%1#H\\FLFFEGmȲ;##F[43db224$qHUN?؎:\\G9v#&25Y\ZLZm)\nܑUʢvb?:\'\'lC#؂D+VйK%v	X*L씵%XWA+IWR\Zt	X*LT%qTQQ8p%bĩ:8H[RJҊ;]FSƩ\'DdjdiE):M`w4.H6+pfMTԦiMEaCUԍ#nr\"w+(ab0uQt4Na1tt0Nti_J<#t)P/%*PUGQ0$r2\nd`IRhRQ:G8UO*58(.PT}\\:;#yJV_b֐I##DJRԭARkB$}5GGҏؕID|FRb,UCTAbI`J+V	X%b%`JԒHTd$b,ZJb2?iVGHիGyG>B#V{	R+:JdeT1J$e$idxOG̔0T]Ĩyj|(b`,J+J+J+JX%iEKDʋ\rRJQx#S*EtGyP*WJR#O^~R+H҉(;#p+R)\")[%JJ+! bXl\"+R)\"4]ʫFUYF*a6a\0̢TTpDgďG!TB=HIG1AY&SY*\n/S>H\0``\0\0\0\0\n\0\0\0\0\0*2h4MM\Zd&4&M	LѦAdɣC414i2042c4b\Zh`&&2bFFaLT\n\niꞠi\Z1h\0\0\Z*zjSMSh\Z{?J2%񪒠ҢF25!UVF21I@TT##U}?|}i%xj!U_U/FiHB~J?qRb=ʊD|Q?m#Dw(C!/t]%u+\"V%|t%w%xb%UBOxy\\Gּo\'}0TV+ĉ]hD\"%mDPT/T!>2H	Z2>2VIvF2V1s)<D:ODb:GqYFFb5ݶQ:UyGt쩹*ui<GQs#׭xGH=#zG#8ʮGI9u]#xdGdf#\"몙H:ur\nPQ5UG!ڪ_4!	&JBC##NUUddb5dddoUHp+P\Z&\ZHҭ`2Gi\n$pQ4aG\nGLZpV#q,HGȲ8#CGՄ჈N##GsE(9UKb5,SͶ#(RLDpB8\\~R2#\"1FPKJD+%a	XQ+%Qa\n`awpEL\"V+J%bVҢڡmUwS7yFض=#}}䨊#GȏѶّ|uSqn}QZҥ\ZU9d9b3PU2@22#!n\r5\Z#XkHTqYSY5S\\438{x3ňldb6\ZU3+:%G,7\r*\r(Z\rh6C`Sډ	GR/+29\Z-ZDt\0m/#F)jSHȍHѪdi5L8Fؙ2plTbjG\"4H**:8DyGs5LǩMFQE*P^vi]]STzOECcjS#YS)	+Tz+Iɔ\"W2%xR	XWQ+)RdJ):FuYJ\"W+JT%hJ%q&DPԥ\'TVRZVL!D[6zutVF5Q\'eV(ls`qW%Y\Z#Q5\nʚUBPL20zeO1#ΧFR&Tdd*.pWC<K\Zu۬8;y0;ywZs}G>q(C̥HSeJY(VCQMT&E5U,J{%#\'$)=0ΊD$n\ZQHrWGGF<!_WJ*D{H=vR#9G%GG؏Ȅ=Ȥu#He,FTF,K\ZMB,BXXXXXXXXZBV+!+\nJTa\r*,Q5YM0ّ~bqFm});\'ʊDa>2\"GRHPVjDZ\r5TYS?LjRFEK:G*#䌊\"VELY%dJȕ+\"VDY%hJҢЕ*,LM*QGۢNʨP{ʨdQRq#T\r)Q^H#m\"#O#tjHU!تCRQ~/D`\Z#B0aװ\r%DW{=Һ6\"3EK4!3R(+$k0m* t\03	\0\0\0RP@\0\nJE\0	2dшi4ɈM\Zi1L1\r40CF1#	M0&8ɓF!hbh& da4id2h4MM\Zd&4MT£\0\rFO=L \0hSC*zoTS d3H\0$4$VNXH@5\ZT2*5*UV)&H⊪\Z(\";tciIW\rTZ\0I\nb_:EW@㫥^ +5/})m͛{>\n>T>RJ%~	_A|5$|PޤS]Kڏ\r^;WW~/w++WE#)\"Gpxg~T\nV\nQt4W)YEӪ9G:ePqF*8#NQYUej?:eyFw⌣9Fx%9FUWNGw5(t(⎦\nQ໓(FyGtrtqyGyNG\Z+QGHQ(Fj62jŤwG\\RjFTv\'h.F98NDYI\'8r+(ZD)\nF(ʊړh5Q]EtFQj1IQ\Z(5j<RVEj!̣0̣*2ZYqGZ,,Q0RJrqFQr.\\rQ\Z,LӔr1\\rG\"9G(VP\'W+F+1ZM%\r\"l)!j5\ZV5\Z5Q2_UR>A*((zz!KЉ^J+su$stsO@^WzQ|H}+!+Tp\"Sܜ\"Q\\4Ț棳WGڣڣڣ裕VյF7.U.G\'+ټTjF[oJFhL+\"Y*TȲqqEo`NA#xoqIVhV2CA[-6	l(ҺU.GMK8n*V8\\)\\\nVqYȖaYRuIYPʨQYQYH+4U%u]WWvWRխj+WW+ģ\nQQ(S5\ZFc-(Z.\ZTjGr5UdS\\5FQj5YZCƣ%t«(QYGTa-FQEDȕNMF*ȭh!)D6bX*.+JT$E+IRdJVćTVRJv]BV1%uf\\U:`NJ5\ZF&<jlmUyґj&*iH˺6(5\Z8ClytS5\ZPeEeYQUW䮠Ҵ\n6*۪rʹRj2,)a5)xGVBx%XeKxgu:s\ZN]mjq)G(:\Zb b@!1HV*JD#RVJ&2EdGT|pJkU\0JJW+YQjGԤG/!lU_·@Rh\"?}Gڊ2T@UtyFQh\"F\"IK\ZCP+!K++++PJHĩ\nF	#*YRVJ,X+\rңNQ٬ͯqvDJW^xX1#\rOX*UMF\n*3RfRmDRV$̔ZȪ*b,ĭMQRQRGJ8-\rOT}`$2%`\"VDY%dJȕ+\"VYHTEhV2vGCԣRS%BQP\ni$1]]>XABhQAJ5H}H]AJ=QңH 2~(RGi(Fh1)zHeEBc++J3uybQ]q:\"g(HbD1_\n2ʢ))\"@?\0R)TP\0\0JI\0%IHL1M00&#M\0C4b` `M0F	\002h14@`M4\0a2dшbi4&&h\0	ISCO\0@\r4G\0H&OHD\0{D\0`\nO0(W)T\Z\0j2(2QQ,V\nJUR*A=O]8)^*M魛?%BRG<.DW\nM^G{f6lQT}G*>*>\n?rxD}>>=HR%}EUeG_kB|%WD~zHItySI{%U꒾b=j)z±]\"Gj59piS2sFTrsL&\'8ps૦Ժ\nW8?Σ]*;\"N8PrNGDӎ[Nб15bjcv杪:\'ؘ.IeK\n⇄qF\'r;KuG0QҌk)+RW6dWsGTrNxUiV&RtMd,a\\+\\9sAM44jeJ?q&QZMF)CUL&i10Bj5KDjFIffԬ͕0nʦ&\'%\Z8i9pY+0R&F\nȲ\\+8UWr\\5,Qt;(N()1V&Y4JQ5115B\Z>>	Q\nGG/(]]ʊUGu$wRGjHIGeIҔ;|g}O}HO)/%|GtHIi#((^\'/\'UGuO|={=zأGDꃪIī)zҾx/:wGrqU/*QEܝ/cУGzE藥:t*/E=*q븻KG/.ttUuQBt|S=Q<U^	x<QyG\'SIEʞauGC~G${=xx<|~j?E\n?=Fb\n½z+ʬ\ZLV+B²&W*\\KYkV#ˈʜ%h	JvQs\\j8N9Tj5\ZQ12NP QI;1L\'Qv&LI].ԌM\ZvJ蒱U&$EZj9$I\r@EdI#Hԑ%l(pIZX9pI\\WX+iCӤ#SQX̩sI˨\',RȨtNUa5\ZI3[]\nuJFҮΎR2VԩX\n%hE\\LLn.,pFNکdLR`VIh\ZD<z(:+%-W.\n^;,j:m5Fj5F&*$듃88Gaj2z۞8ӞsL8OGz8QRIN䡕R\0ȉ*\ZI#<DޱQ^ /ݬTCTGQ4!ڿRQTy(*#S)`PqPR9!JOyI\nW>tWE)HQe,F4+Q\nJ*2*ZI21$i$j4$dHHTEb٨J>bh3Xͧ¾3^{fm\"XkBuG \Z\0&i$jTjĕ*&ȋm@2.}J;OhWH%ZʄU$9\\/}$TBbJҒĕ+MI\Z5$jH#RFI(#QSIj*de%FǠs]|*#Br@GQ#j<ޣT~++uR)GqG`쒢<TQ̣/Ώi!\r$!L\n}ԊQR)GQJQQ1#Qfk_A*+ֻGW(GQܣJ<RHz(JQQ(+$k.`?\0PAU\0\0	T\0 	\0\0&M&Lbi!L1M00&#M\0C4b` `M0F	\002h14@`M4\0aԨ4m#ښA#MRRB \0h@b4SO!;T	UUH&U&14RRԲ@\"paB\\08Wߒ_zc0JAw8?~EG>fo~E{J++q?]?m;GI$xy\"JSB~ʿ5//\'=|exEW%:HhJb~:Ez\n>pV+F](Q9SVZ\r\'(GKQJ0.(TQ%t]	ҝ(j4WJQI#;+;N+	ҍF]rq]Xaj]qQa:Q;nm;ɗF(G	G;;u*p;]Lm4Ve1Nq۔\'Ti]%ha.;Q2e6#:QtVΉӣEZ+B	+@Qڐj12Uj0EuPwZ(\Z&RjK⑔+JXLFVŖ;j1N\ZQj2CqCWp-M(`QpN-GfY\\9GJK+5,bحc%eDVu);\\TWj4!,̫&li٬2M+Jd/fE%!^WmAڤ~>_#|\'?pNREtTWH*:GTH:GRH:QRJSQuWTvׄUDGQ#H$TR}}J%_x;WğJ\"|R|Q\'\"{{GC+GhTQ懚~E<yD<<yT*WC/(֏Z:^OP=TzSx❔vv;Bx$	G:5yEy\"y=BzQxQx)x$UQS\"wze%H<3\'ON\ZJLdF(\ZFQpVz\n\\\\deG(-FX[;ʫr8جV+R\Z`ʃƣQUp!e棥âwN\"j1;TPI\n\'z#$iUUEԹč@\\RVDĝI+TZ$p8I\"VL s\"NrJ5$eU<Td[Sh6s\\FR+j\'cQaT.SchcE̪VQV$+Ej2V`SmU[KjKK0\"-\nQ*L˻S3&i5L)hZ\"CQv;\\eۣ\r]V:te_Y<:\'^\nU$a	dT\'(H¤ʕLBʁT:\'rB4T^)Oy	;\'		OH${ˤUz(@ԂG>#ҐH	q>}dUDM	F2+%EhEUQQ#Q#Q#Q#F$I\ZI\Z\ZIdHIjRUdESUON1lH$y};{	1{dDSv\'(XDB$XH!-aB&5k\nLK\'R&:=CQFR-Pe(SD4H#D4H#DAZIXj\n,PL1R\n\ZA#@t\'x] B!Q\'b{\nUPW`(;|)`(O_tO2z\n(jC*VT_l)J=JQ\ZQFP`e)1}ĪҪy@O BUHyREWyTO1AY&SYu	<Le>H\0``\0|\0\0\0\0P\0@@8ɓF!hbh& da4id2h4MM\Zd&4&M	LѦAdɣC414i2042a5JOԁ=@?T\Z\ZU4&@\0\0%$M&\r4\0\Zb444%?DYH)\0HiQEUXRbh@t\"19 vt$QSGz*_+/[D$s#\'TX{D_6lf	OA>%z=HGH#Gn\"餺KtRuuK|$hHbGxHF%VU }4}	h!0M:9&&\'Dܝ	9%]b&tN5\\NpW@LBb~HQ;	L]*p.0V16뭻*\'br؝~uhM;DLU8}8Nuڎ%\\\'xvҌ߉8bv8l:2:u4U\'*\rWG8rrf6U9\\8s*X\"Z)u<;U&&J\ZM&&(諠10MI8jMCUed144ʮQ4214\ZEd\Z*&Im;N4Q18NN	iNJL\'*9198\'\'%\\9rSbqS9pNEMYNAY)t*wrrv#,X-ViImdmbh}D$\'	GS\'|D\'`KER*PH$j5	\ZTjZ&jZKsB&	\Z\Z4$hHت6--WV мx/ç]}4+r\\rK}-NT||+>=^=D\'\"y^ xx*QR{Oh\':\'E]uD{Rdj^/g7yrrI+wO\"Jy$^|I\'\'\'q>H$I|(z+ОyKJ. Tn\nOg>OP\">\nzzOG\'\'~0a10&*М&&bj8LU5S	befI11V&A\'6)\'jGp\'Di4B*8\\arX&#)4Кj0zIhU2FG#H)]ȌIX77FRH$n7	EF#pHĪ-rD\nҤVEIDMUQ:͐leߩЪjPԍBa;PIʚUki#]N9%0P\07Œm2풛\r;]KQ\r15I]ԺcW{U!cT]w\\rVInY˓kj];uc2*}dN<\'Ra\nX(\"NHRiKR PnN^*@|aRB$~q=΄H~?\'\'HD`)\"GOZ#B$Pq?Y>Uz*Q:\'ba0	X&EZ	+PLLFV@+*JҒb$b$b$d$d$d$d$ad$dVU,%5Ke2YYdىD˄lY#^{m}%\'{D1zX؝beBh)&+efUSLbS2\"&K\'bC}B	y*Q\n{ɩ%F	I0H#0HȑF	$`QFTF\"U4)4ih\rixB$t]]	Wt\'D\nwx	_xzzA*Qw*B$z*Q0I~d&\"+1ѧMEyT\"Q	UM(`҆S	2٦cQ\n<	=]>\"~<<yOO2\')oGw?$\0_0\nϟE%\0U\nURQ*RH(\nDdɣ@h`M\ZbF\00&M\ZFChb4@2h\Z4dhbF\08ɓFѦ##C4\0`SSj4~\0#M\0\Z4\04\0))2	OSdچU=\Za!jij{O\" WR_ԐZ*$J1-dmeі!bFKFQ\nH\rFMFV+!CߞguEz\'	I8\"+)S/Dg䨏<3R~qRp~o)S:򨌣|~O}6lm(j>G+UI=e*>$z#eEҁ{q~2 e/`s+/%Oh*}DG$~jQGA?(_WOUQaVkV\Z3W?w.D3F+9f-R5{J[۷McVefZq9q9KpuNswu&uZ٫ub43]4wmrY8:qweNQw,ecjԴ8p\rUSUgt3^VNꖇnIǍ-Fe`д&ÇNZKe\'w.YGgw(4KFrxsN亠5\r`ή\rԚ\ZK.ѨGw<WjxukXq㔻gv9.)Rr𓉦&Tn23Ex,]Nk!;n%wqỖLuhN3*↴-P-)b4H94fi3Zز./.f+C4\\.2YN!C#jOԳY\'!958丬V*-429r.G#FĜm\ZaK0G4,jZhs+Cb̣ULL+&ZYVQ+;՝3T8ÕZ\\ዎ.hUMr\\IF-k²r+8rУ\0\r\";+;*U1mx?GTZv}}>Oߺlǐy\'|T~uZQ%#(A\'TH*<JJ+*((zzOW֏}ғ\\*z=dIeI^OᠿG!AG^^)Ixx*Cx׏_)|_~O](j>|_0>tx̓|>r_/%I^@yR%O:Ϫ䗒GER/!>/x7=!OH)>^<yx+#ė^e|=*z*|*|J^WEG#)Gv^.v:/\'{U/(y|mwGr󻗱wQC!)Ayү4p{a{=AJub*ߊ*>֥}jGz~}/أ?MG\n=Y#JLh+Ivhjbb5kQZRe\rFeR˓8NN9G13Z[*˄9ki34fHIv.NTѫ&LvWqKF4LYZQ.G(CTvwXRu̓\',S\nQąCpRYu	\"fxG,5ArR\'$&.-X;W(26CbRt]GB3KHNY.˲j[Fɰm\"p㶙QZRc!e	\"tFJYjv⪋Vʎ(2U\'KRNu+vӚQk%5RtL&%ifֵtKmu\'kT\r#Hj\rBx%զ)ьMhc&R\\&Wk\nn$6hK)d&\n:cci;k\Z՛IhQV-hu!2G\r|3WheRnֶvmV!ۀ]+SpiV8%ɦr:LrlH9۵vwﾢEy_!JySBa(%*\"e$V\r\nҒ25RMJ(LЭm^]*edʗ\nJlWB?J8OB9T_G~hO%EtUG~qG	J(B?]{ס#}j?R(G*܊J2J²FjA2HRb\n,R	,VV)+I#BFF#VQ+DK%FJBȌ(¬PȘ$jbfl~)r_Zkm^=B2^Q)wG@\ZHl\n+d!Xq_6+dg\"UCd\npj]-/U>4dMT\ZJQ0T#J&1H#U#RFBȣMQL#PX4MQ`GKGET]N,QHG\n]zj枒*}hO~~5J^b[AHQ<!\'\'Ҿ$P)*>k(%Q΍T`+3ȔHWHW	{$eFʌah5&fffkM>CR	貎(	}~EECځ^Ҫ=<{E)QQ1AY&SY#q\'F%>\0j`>\0\0\0\0(\0\0\0\0\0T%@U8&&&L&!440hqLMLM2C@h\r2h`#L0d\Zd	1F142a4\r4ɡ@a5J\0C@\0\Z@\0\0\0T~3TjyGm\0y4\n?bUT\0<\0b4D1&XA1YLLV%c)MKcBԔ`@	JU#H\Z\"\Z\Z$hhq\"$9\r))_ں$_}8OԱ!٘DVOd o\"UaRJb=l٭Q:(p$V$2?Pd2x/:P/)^0͛6lp PB*%ҔRZTN*4QEF\ZwQ%WWNׄhVT%Zj+QJ])jz;*5GTxSU\ZUUVF%(J~_|0hpq BȝAt042L\"u!\"h8hv&]:E&°`Iw\r\ZS؝Jl,w+v\ZTEtGu\"p#tW	g]B)v9S&CIph9ˉ\ZҺj$GhؓCe-\rfEE#QWعJJS!8\Z`rC :	0h2\r\rA,2B4d:h(UqR\'9G\Z.p\"@`iSNa4)EȪ\\\' tt\n>pC`h>+/>}tk|77U{#Wd_:^h=zz=%*\'%=(/Bz+С^P^+  zEITz^H~X}\"~Q*.֊h֊9\nP_@WҁRB}h_\0U+x=z?5\nIy`Ox_P\"(\"C֋\'>/>0|o0PPy\'hR#A xtHOOy^^J(^ID=r/\Z%x+Rp+<%	\"x \0=I%sP<$/AQ_%<^ȇ딯!,\Zp9\Z2A\'!CC`rtA:\ra`	\ZP\"\'vb\'b&NCE\'Y۱CɄNMʘQS2v\'K	dI)EPa$)ED\nK\nBMP(W+jr\nBNCģ(.TL8@!:rh2ʋmUʮZb&A*!qyRlnBT!fFU]:n4Z;sI9ig#jttSʪtVɶSwÄ;-]f47l!.R&m&WPf-wqU]ꓫ8W|ܧzmVKݰg)ugnAB/rCԩr	%\n	\"Aa(T*BXTJU$E!,Do(Ii@ԊC)^KR*O!JWR*B~tT	ҕe+ECȇH~jECzyC#\"G!д\ZejU0U*)IdJdeA1TLEFQQ*0*2\nLR(SP2A4%V0K e\nU1gSP]Ԋmߎ(zR*jxIw40BخPOĸ*!{WHpZj\'4Dč0S2TX*0`ȨQQ\"S*YAj`\Ze+bM)5$Hu\"R)%ԩHqE$JUG)_R!^)%B]ȥQzѕqWJp~Jy1ECRB\"V(2#CB!j+`hj*2f3XkNUCQJ+d8=!EUPR#܇ڂ<$PVIjo	O\0/ژU\0\0$\0\0\0PB(qLMLM2C@h\r2h`#L0d\Zd	1F142a4\r4ɡ@c2bh2di2\Z@iC\0&jRjLiM?\'714ѐɣ@JM4QASj=CO&@\0➧ZBRS2E++X-Eea%Xd+L4j!iTF ZVJԣ+%8\nEVQ5*рIPdHUđDʄy2BE?$V+${ҏ%?jf`H>)ePzj~H\ZV!o\rsMj109WtWڢWt)}(ʪ?T8Bq)y҉A?D>O(AOaS)W_BG(|Dy.U*>}uUP?-IISB?wWTE0qy%\Z<-RG#Q+:44hhy\Z\ZEQrRdv\Z:T]\Z1.ԬKhJdv4h®9\\ĸ1.\nĻQ\\Njt.ܢ\\Wj1.<arE.KJёڸUiNSQqZU\\.d+\ZW#%ˑq\\Q+~qVrhĵSTԶµ	J[+CF#цQrhr14FGi<\ZKQKZ\\UV,r<W\n*UhhhjJZ)GR4jSƭ*xWKAC\"$YO\nxscy\nKUN=WWȣҏEJTW\n/UJzOR	ꊧ!ꂽESPtT\n\ntW<P#xQ\'	S!B^Rتzz\"8vUj=g35҅	m+m[UsUtr.e4AM\nHiVܕWe\\qM+#yMsUVVq+-S)N7UV[U̓4Vg©V[n)SpVhe&V[cfCs\n୊+!M,M-7*\nRq%lVʵծTpqa\\B+8vQZYOI^4RrW)\\9\Z\'i튧^|Q,*ѥcHh\rF8*ha\rv5#FZ<F%NRx?JQц\Z4iUah⪴qT.*;%4ʕR	+Z<TWr9ipkpvKF+ra\\\ZR;m6i.ЗĨ Uԉ$	v<A<5BA8q	Rr4daPV!]յxQjʕ,KQdh+)G\")@%a\0eTedTdBWWa/R*5\nU;dq^UK;r)U4P4iSIdkm\nxUYV8SLVܮ	Èx%Xk]^^f3\rU+\\xS*F@NEݸ.qZW-(vK#B+*&UPBE,M%UV-\nM)V\0Y*W#ޏ\nܰR?I!*ESlIR >%_W\r{)>BY\rTm)*C霊r+j#Ry;\ZFhQ,QKEJ*&Eb)h\nBJPHA1	IP+QTԔC*\n#\0L$EUY*%*aL¾%uEeWR:1sh*C+_T\"\Z\0Čw1!]#E-3)YFd1b !\n4XeEbIK 2	LdRMԪjV`5TU`0*%ZAD Ru|z<$%^/R)PFbDPQT+)_\"I\nօ	fUUTaYqfJܪ`$o+R\nT$s\0\n\0t䗺0Ja4j,54jjJT\nɂ4|ڪB4KIV\0OU?\n2x/) @?S\0UI\0\0H\0*\0UR\0 8&&&L&!440hqLMLM2C@h\r2h`#L0d\Zd	1F142a4\r4ɡ@a5)S\0=M\0~4oT\0=M\0\Z\0d&@hhd@60=EJ O!hJVZ\05b,LB,+0U\nZ1-Yjѣb\ZRiVUhJѠp\nZ5e*ъUh\r\ZP\n	U$ʿetzE|T)!C7ĬR=0=C\n`֕B\rhFՊI\n^Ea1y$IB+c0fyǱGOeH)}@RS䒥D\'U=OBDZJ=#h*Uz\"?RܐEER)>9Iꔞ\'Ȉ,+^ɣpV\'(K\Z:]UuG44:]GieWQ9Grr\'$MY:\nR:FR,;\\NFGKq5Y;Z\'YK\\e.5إ-\Z 2Xl)H*	ɱN]Gr4d*Z&sRrѣ%vԫFZr9W)Ě72kG9Uhh%Z4(KUj-Vj2\Z9B$++ɨ84\'*4\'$ѓG(w\'$䥣4h2&\'ɓDKhZNiM9Z\Z9f)j&UWa+i4MJ(iB9\n\Z\nUHW\nCjx\'^xO7%KuUO]}ҹ֥RꔺԋuGTyTʢO$O(u]J\nu:N\'T*+\nШ=\nШ=Ъ.\'	ByR@a/KTJW/<h讄:w{{jڬ˷[kRw%6y<җyDV؛Dږ]+]Wd\"p+X	sCsMPx*lR$[&ʗ\"vJsrEG%\'!Npy\')KQȨr)[o:ޮ*ҖRl$NtIR\\e\\%&7@t#\n^\n\\d5/U=_5RǞ8zWx:=ҾbWίZޣRY*ѡ2qr4bdɨ\'F&2w\ZRFRr:OtNQbh;L4h2p*IDw\nUP\nUbu\nUFTQfѓQBN%V3*\rh\r\nUeZga+4bZi(Q4VH*[lw\'pSJT;DHL!8BpE.G#F&LM\n\')TU0&P+,X;QTX!@4	1\rIY\r%.ZyI]\Z\0e$эef(4KUIDFd \Zn\\գʖNG.\\UmmЛYVj[\"Aae-\Z4uk].+SJSU4hkZz5WHkG)\\;]E\Z?y j4m7H(U*1$\Z*,TM(2)P]\n6HL![(QUIa[W#|!++n+ȒMU!^_譑$!]$r8ȪsʪE~6\\TP5VaXV)j4K\"e\n&0RBDLHL,U$	$&M!2TȓPQeQjIjQjjCI+AZU2Hj5FWWzhUxMI\r\\33N%mN$N!URwEZ1@Q<ƅjMJP;gS!ܬUUB\"VZBh)&BbSR-@Ȗ%,ZҕKAbEڡU.w$5DV+\nUQ`*a[ª6ҨBjWW$pRT[\"&+Ev$BЯ4$9@N\nq[X!t\"\'(	</5*XLbh5,&Uacccj\"[D+hVQ<}EnDvjo+]HD+!_dMg M(\0\0\0\0P\0U@\0\0$H(#2bh2di2\Z@iC\0&\ZddɄ d4&\0M24ɉɓ	@h\rM\0diA&L\ZL4RQT)6P4\0\0\r=M\0\04\0RyLSQ\Z\Zꦙz@\r4:dʒ֨\"JS2$c!Q00#	YZk$ʌ`X*,V%	!aDS%AX)J2GdSI2XTKVKPD4KE@MT4$+\'EOh.UbEPQ2ZVe.,¶a	`P?hdY\\C{H_g33/%B^j(CR#I%U?X>DT*ҡ\"%颏U_@S%ᗅ?)#~⪯R\"_r~ʔE)~Ri>bS)=iG%}\Z_H*0QS\'i>\'yN\r\ntO	^IɩY<zt&y\'IiM\'I+\'O/5%{&L+OzMNO}U^ɓWU^ZMUxUȰi<%tOmI6r{IY%+w<<pbN))NM\'NNj/Y\\*ɑ&+&L44=$\'*,\ZUj1VTREpUɤɤ:dtI2ddOrqdjLUdɓRpN<NL+IUyK.+*DO)4TUKԴ5bİYİZ$[0ـ`dQؤz_,C%6<JW;{Ro\r[JJwHeܗ%-jZ֑\ZU։-JRRH-ESTԩ5E\Z\ZZ5%I^Uz CT	Qj/JZԥx$\nSxGP%x\nx%.ʎګ]v;oKۻ9qY)E.2Nr&ob^:SƩ̷oK*7ҺԖC4wJPI.P8v%˒Z%ʛĳ;;6l2^>E|OS^A	\\\npSSD%\\*<R.%\n\\t	_^9x-S\n*_b+>T$\'>)𾟨}R}4}0}2yOR|T|i}/Ņ~9+G5sq8u/}B_ZXF0SRrddɤIʫI&L=M\'dʫ\'±Jp+kZʫt&\'&L0LVNH(K=	jM[\'f*$Ut4*vŉ\r\01\ZKM%%TWFO2^mLVX`2XIiKIJ	]=&UzT<O`ɩR%ʉ]$dWRzH쨺JS\'ХKHl!JZ<8DSRKNLLLU/\ZfdbK	ffa* iQeF%%{=^y)-\nRʐ6*\\ku=5B#jn*hK\"f@1H<h宕VE]H꒭<2RlU^m^-g\"e^&U7rS#dD{hUTꓕ<Re(K&)b{/)Ri;D+2i4ۤ-B^AdĮ&UºN\"ӓSL<HKTU&\n@@UE&JO<MWJ̪D?\n\nPJ5}?$ԡI pH>dUVp%ƪ>ӄ몡sK#ė\\K$\'dĲF£0%Jʂ(ed*2(I%\"IIQM	,E1 BPb0*aĔ\n)#FHaEV\")a,K[%s6P3injC&!J-%D	mKKy4K*K%ItMhI\\0q@,UVIY\0Ud!&B\nj&M4D	&SYAeJbA)LE1(2(VUV%(&ɽ/JC(j\"I+W|)M%/j\\(A2ZKĩGqw%8P`Dļ]2UB{NMSW&\"Ԛ,TaLJ0LJd1cȕyh\rؒ\Z!-U1-Kb/j[y%R#TA$tԗBICR)??\0_0	R\0\0\0\0\0\0$\0	\0( \02bh2di2\Z@iC\0&\ZddɄ d4&\0M24ɉɓ	@h\rM\0diA&L\ZL4RG\0Q\0Q\0\0\0\0%$ё&Ѧ\'7ꧩA=M<N̑1\"Q<$,K*aPe&\nXbʲ1b$55DM+b\\I!X¬YJe	JR,\\*<:	/>Ĉ?9PF?IR>t\'STLK:HuH]\n1z\\/hU/͛6K~ߊ/0A%*%T!U=BI~8 (aaC/R_|QIR\0/_/E{4ڀ/r\n{R%/\"%BdODAKXF#,X.tF.к#иX]$t/eXXZX\\eHtlFt]#Wg,X:*谸Xah\\..X.b:,.U1uDdvj&,dG#XSv#;NRXse:Fr\Z\ZML\\u촻SDm5+SũUȮrSS<V,*R5L-TbS$Tv ab.X\\..bGbŅbŋ8):.L\\bjWh:p]jl\n.rt\\,XXX,XY-H\\W*U\ZMMDFe20HJ]S%¥r \\]uu^5TqKԩNDN2q**~x/ ^@^UU\"Hʠ^TIy$P^E%y\"O%T:Qt:qsG8pK:$N٥S(|_KBH\n#R)/qWG_WOQw;S^5R^^{\"Jx/xz/\Z}^.;]/K\'}O9ywx{RnI	^.؎{(Exȼax<H/\ZS+ƪe<TyNC˹w(姉x.RxBvQxR<xB!xG/Yz^#qx=zHW{~za|}OGS|\"\'x//_Y}K~aX.,,X\nXXbŋat,XEbTGt_,..رbŋ.SW*t.FEv\"rRP؊⹶EZIŔRbYb승NѭMLlF\"ʪ.BEvMQT\n%vIpP\\pUKR\'$ԔLJ\\%.$BpXab&E,,Wa`SICUQX,8#-6TD%XF1ė*vdfU.ėNTfqUF.Fr5.ZU\nVLZIR]HZ:9N\"ŶdjtXٵ9XK#$rIƑW*vSZF4ڛ.L3BL]hTajq.vZ1HWJivr3jju/9p/:Pab)=Dh$\"	ZIZA-*R*S$)s*\n*a!]Uw	p1}/$!W:\"Q\n*/bx^!=bB{c/YwE$t]`F%)Uj$iªh$$EdJXTXJXAb`K	,,RZ0E\"M\0#**YE2//ht^v|[m=be(OPJyE*ŕ(&|t#IzN(FWXV@ԣZAM\"h)$MH!b1XPĖ	b$Z&)j#,QvJPN@!!t%V:\nJ, yGvtU^΅A=B#ԕ\\J.$UG_HC${/xE1!|$$yU$aT5ST\Zj\rM,c1gDiF\"^pUz.]|b(M)/Iw/J\n	xU~e5piFS@9*AQ( PBTPU(@G\ZddɄ d4&\0M24ɉɓ	@h\rM\0diA&L\ZL48&&&L&!440h&$Szi\0@P@2\04)*MQLS)SzO3OT?THHS\']*4*􂔧1I*X2!fM4BZ-LF*IJfT2S`j`aZ*KTji)-MD\rLjjJSW_}¢*_JZTO$:\r֦4ٴ\\~UP:\n=A4Z/-bzTO[}}\n{}U̒҅R@$z?\0|AKKK(/H\"2\nARR\'OOBa/	|몣\n/\n_)~`䠿<?@\'\"{Hr_)e4e51r.*^\\V.b.ZZ./Z,Z]Qt]EкQS9+SEJ)MM$2XvQv,XXT	r\\1N\nr\\A2\"h:Pt8%9bP0K\r(: +e9.c4IsLiMNeȸq\'TqUuq8\\-Դ.SE*Ŕ[hVUزdbp.,Z\\QS58RWh1aNJPŖC\'le\\rEr,Xr,]䜕Xhh-\"ŋ⫅iat])i!+Z9]j.hCENEԜSje22dS\n.$Q8&,ҖSiqƢG*%>	G(>\n|\n|*_=:]Ru {{~jy𒗄(<\nJ*yRTDy$Wy\nT)O$Cȉ>4о0_\Z>\")yuQ<ST;ȝzE*.AOA]kry(/9zgtENGWS؃Ie\ZuZiuԻiڧ/`=z:SvS.EGEj^:{;N;ܧ4Jw!T^/x!]v;Dv;Dh;Kp/\nxSNp%Nu#KPz=%=4Ӳ냮\ZxTSW\nz/D4z]>J|}ڧE/[x|^>ORON\n~2ETYUص-.	bŋ.Ţ,XL]Y$J\\-.bŋ-Qbʬ\\*pYQW\'\"Nj)\\YqLJpTC6fۘK:KL:TM,T(ESaIt\'eX&rTr.,X%\\J\Z2JXvN\nsLX0Sr(.H@)`K[TNT\\,Z,Z,X)bTUբW1LRK2,	-JJģPMPpv5d.--jrPTgDvȭҒjtX)v+tD]ZErdR&bm9An.Wh[hX4pF\\(E)N)ҚLTHhIV+\"8]T艹pS\",\\,ش+8R\\/]u_-.\"KI+	&*\Z%XZ%d*\ZR,L2&QI.V0%KܬC\n/ vrA^c>;(u)%J/]Ga\'\"E\\T^jAT?)S<יOM;isN)h2)0V\nb&\")V1IZ%L\nXD)`R)h)hXPY b+JV$XT0TV,Dҕi&-SU1|1zESol{(BV<\"NИDYqx^=qUbzpB=jT-BЖ-UFBT`\nX)`PZYR+Rh2E,*I5A\\NR_UtEXJiDy2ʝt<n*TPu;\n)e\"rS̔UJ=g|Pw%\nhg1`V*g$*HU.@ALj)j-Vk[kY\nj+R/)$U\"E;=(t^ҁJ%;\0BwW\"bLN%4\r\0J|O&~}T@(J	(\n@$PdiA&L\ZL48&&&L&!440hqLMLM2C@h\r2h`#L0d\Zd	0)ާ~ң@=FiRhAh\0\r\0\ZeOh\0zPLڞ	O*2+R= ԒdBEŒťɓS&&mDdXdɪJ5YY3%E02j*ɢLɤɅLU!	B7R}$5*BU*`W}DpGe;TdT}QQQ~t+I)G>ϫ6S	B~\nE{0TGD*SQ\'OuD𪟈~\nu\n*HU=>^ܺ{\0_)/)/)/BG)_}AO}~E| {JEjZb.!t\'Id	ԜLNtO&LL	vL&)Ү&LMN*\'Jd]&NĸNɓ&Q8N;)hʺLN!vvAp\\,s9$X\\ƮJUNq&IpS&NJX)8Sᓥq9\'SI\')\ZSH꩓&,.lL&\')d֧)&d98VGb~,\Z\ZZ&[DԲbv\'8&\'52p;\'IrU&&M&&&&DW$.ʱ4tĸ)KetdM)(ґ8LL\\ȢrL\ZU:4ddFGΟ(U/H=1zIzR?\rUU7|U=Rzz>tW\nOA=!=(OJ(Tz*R^΢O8rGJBD%D	GЫ>O B>Ф\nKФ(WRGRGZ\"xtIxN׏;>Ȣ0^/(E/*A**Ի{(Ȟ=p|jN$&SOu=y:S4<y=O4\'d쫴OhQt)t%D.T$yUy(yyD<I]*tK;\\ww]Nx	\'xUU\'xR*]N/^<n_\'\'ߨ||W_=O>\"ɂe]DddɉEjdɓSbu&MEҸ$8,S%-G\'TML2dș2*rL9)ځܓL\'\n.Ru*b,GdY;SS`MM%.\\,ԢINck5Wh8+uMm&L@;!G\0pT%.c)RHVD0E%IiiIpR\\)- N\'&&&L1Irp0GrUbb#\n281)$bSP&8slISJ&P\nZһ]TTT\ZLP܂`J,S+ș2JLZ͵U6FbTjuLLVMvۗ(N\"J1sUSɔmn.ZKJդjIr܄Wl+IsCM:J}ޜONbdjYdJPR,%L\"j@j(U\rB(>x(9S~>{(U>\"=گ)GRPΐo+Ɛwew<H\n(:Nɉbb&Hʖ$bV**KP)ZF)j,JMALL)-\n,)-)&P-$5)Z$eP**45jRb\rHM\rCKK^/\\(=_پN(5D]Y4RNrz_%|#	xZ^iXY,F(\"FIiIb),5+DR%aHȦ)M\"S+C *^{\n]*\0#Dv\'\"R)GKw)Nꤥ9(FN\'rJ>2|!A1>Z\'{HPe\nQ	E|*&a2TZ,%ĭ%Q13-DHE)Gx^\'OP%DH%H{	\n(=yH+̞APVIOU)B8	O\0/ژA\0\0\0\0\"*@\0\0\0\0E \0\0\nqLMLM2C@h\r2h`#L0d\Zd	1F142a4\r4ɡ@c2bh2di2\Z@iC\0&J$7izQ4~Iiꩁ\0L@))53Iধ\0\0\0\Z:TԒJL*E(XS0,#%&&L2EM,24Y5Y6Qdɓ1RY)&ME9JC&$bjMQTC&E2bHC/+PfWZP@|%+A)ɧ,L[6U~RtxX}#dzTB\'}O&;G7	Q|U\n)\'Ω$jIw(.mJ2*R^4QB$tޜRJ_\\/]Iw%)\0%^ Kyj:Nڠ3f2Ě2n*p\\N:+	LNn&&N	vJNj\'	2w\nWpdһbpFLv2iaN]*;*ʸ*GUKw(S.ܕҸNtʻJ詃\'dWr\'4N&\'8*]&L:\'㓉Iɉbdɘ\\2q9Jpɓdsb`dɁdɓ\'$MdɩrL#~8Y5M%VL$q*MUڥbdG	18#&&NӤ9Jɓ&&&&&(:LLGY8S&	s8M2u˒9\nI2FQbhXK*\\Q\'i1EҌbbe:6ҡACإsNjG4bn{ݭ]rnUQnLL7%<Ob¨Qb]`T\nIaI,)%`JV	K\n(L&JS||@I,RKAp)U*I.KMĭs\\ZŬZ8<<{ܟEQG+U|ʾr{	xW<IIdLZI^:g̯\"zz\'wWyΫ̞h螑4\'iڮOuK#TJz==FZJC\"VB2\'WOb{=S\'\n;y<<!l	MI4ƔЫDORz\'ОG+Nq6u\\\ZmzryΞO&*ȱ2`Wi852beQ\\MF2d1:&Eq28q4.	w\Z2dɓU2q8W)Sa8NST9$NJ6mMCT112%8ɕbdY;gtKRbiT8\nN1XdLNMv]LɈɉdi	r	vLvNEJ5$\'u\"]RK@&)%IrZ8L12dI\'yQ2LT+Jȫ	L#t%2*tmN(\nRآXp1#]⥸2%J`M*])U3!6FU)V&\Z):XN\'&	2LUR7|]n],5mTR\'i&U&uUVUrdN		rdU,&UbuKىJtwpy7ju&&*x\'%W\'PIHU\nJ4T)SE\nKNJh\ZB& N՚Uԩ!+EJqM(DRTH<OWB\'B\'	*d\'RH=FV \\w5&I*\r$\'R\'ibb&RQVU\Z0K*U*\nQA*bdʑe$YI,RK\"0ha*dbUK\nRY ȣRdSI\\N>J{{|O\nR\rj\":EU&>>W>R#	%\'\n|n^t/4ԩ5*`-JHhZHjIj%%%%-I,R1R4`ZJRVZ)aFZaFIR\'Ju\'WPE*$I<)(E\'B\':\'O*Ĕ\"]8B\'ORH$\'̟LU Jub				O\'W4R&a15#	jF&fc\Z3]\')4UJ/\"|lNN{>}|\"G^Ğ$\'DPVI|,Ɓ	O\0/ژ\0\0!\n\0\0\0\0\0\0\0P\08&&&L&!440hqLMLM2C@h\r2h`#L0d\Zd	1F142a4\r4ɡ@a5T?Q?T?SS&Aޥ?T)\0& RR)&i2\0\04=O਌Ey*OAj\"R%aI&T!lL3Y2Shhɉ@زedڢPɒl)2!IUɑL9U*d!~c#*!H* ZY8NK{SJDz)_!)sʂ#\'dGR\'~/;}?H\'UGIҤԣQUK	Noē$pJU*w)C9%IJ5(ޅ}K}.W\r*$	\'$UNꇁT9HSU.iF[**i\'	XY:N\'DV8\"蟍12bdN:UvNT8NɓK\'E]]\'DɕwRbv2d8]윰e]&\'ʻҥ؝NҜ)evNe]tU؎dʺ\'ts	99LdNFNpʮFLl9q2eG\'IN\'Vq2sr9Y9&FL5m\'bdɓ&&\'&M2dܣGFMj$tOȋ&	¬&2jM(e#RrRT1;\'	pLN\'ɓ\'	8Ndɉ&&&\'	&L\'qt&U.*qȮjcQl\'5JI12QFNhF&TRpXIuFj:,LSH`J%/-KLU#IZEiiֆFF.M&BV@Ud\nȡv+5-=\'Tz$D%^AR(%褗^)zWz!/BЊRK.uZZZZVU6Q&$I6S%cT1DcT1\"bTb+n[rt35,Ժo[MG=R\"/a=O=J*{|$\'\"yOb{	\'W\'x	\"UO2b{l/yKHK(ǽ=\'jO\nR\"*\'PjQXeʃ-C-JKi2\n>O4*{i^ҧT>r|U|ByiIW>r||EURnPK=K8Vt3}/w\'O>\"ɂe]&LL	\\LL2dbtLNbQW#\"?-F\'\'Idɓ&MTdʲr)jU\\UNQ;pʧrrN**;MQԪu*\\Md14Pj2,L:Mʝ&L&6ʩTW\nۨ\\LNwtNdY4A]UC*9\'dQtAjRI.آ褺)-@MI.RKIhq2bdɡ&((	qbeXRK[lJ.FdȠW#RR* )\\9HRWJrՕG)tM$g|rV\'TҖ%I\\NsSVͶT:nJ\ZꨲaJ\\T&.12m5+j䜊wa1B8QSbbjT&ɹ)+;йK@Ԋ#Th\ZURG(/=I=TUd$Q+P&HRVS,P	\n5IZObAW(Q<jD*)*x_\'O%H1?2AԺQ+/ܩv{(e<R>}gO4\'آ!$\';LLLa0V$e)d%DVEESTEIaIe$YR,I\n*UVTV\"),*Z	bC(Vʌ>7v|\r̞QH1]Hb^Y!ļ	\'Ȫ$a2NF^/4ʩX@Aa* $IjIbRKD@UF`JV,jԥ+A5F;\'GOE NDȠRID<(dR/UT\"{>{</(\'*\Z>$^B|lO{I\ZAB{HOROOQWC	YCQF&Ta1V5\ZZ[3muJ\'U4E(J<Nĝ%DI	*	zCĞDHOq=\"~z_\n2xt) @?S\0$\n\0\0\0\0!@\0\0\0\0)@PqLMLM2C@h\r2h`#L0d\Zd	1F142a4\r4ɡ@c2bh2di2\Z@iC\0&JLީi\Z?Td4\ZP4M=D&\0@4Di&STaUEr*I*&deIFZimQASU&\ZVmHTda20hѪM5UQɓ\nYB2hѥGɔL&\"1))(\rJ/uJފؤ#`Q]L^bIT*#\n>Z8N#v_TGQ\nTNZ\Z2z2{>߫Y>b|~\0	G$+\"Ch(IwT)%>aJe/\ZUW]#Nj5\'zU>\"G ؒ%ĖD/\0)^*^@QnjG\'2l*ӜN6\'b~j8Nd\\&DVLJ]I&L,;Np&Y8M)t,]rӠ;Nɥw)Čq0v2dԎ+K8N8Gu:8&\'b;u)vSGiN}Yu*vut\\*tNwUtsE3tN\\2ѓG\\NFNj98G9+ѣ\'6FGF#G#FdѣQdhɣSQIFF4j8hѣ&ѣR:\'d*d5\ZF&%G*RrT12bvNNW,&WiҸ.\nɓ&N.	jdԜUjM)fUsTp!sqVɥbr%\Z.&&Mc	L\\Nt#K25drUr)}?RAT;\'Q}4}/>)=>wORT\n=4(\n^6Na2&Bd4R\n,%$BQ#\"%QeQ2e7\'EIU7([.DnP[K)%݉,Z\Zj+R+PZUk#jmEiCO=j=<F^{W^ؽ/B$J	#ȼ)QO\n^	Or/bz<I⧺R{J#GO8Sy78e8q9(4Q$䏊GĎx<@iW\'=~r@rTx^4r>\n=bz֞	\\\nSJ4&#}7>/Jxz?	?2(G>/?)Q>S\'Y&L*0L2b`N\"f͓&L20&L6L,Le]\'桉h2dɓ&Mh2LsFL\0d+ZhSnQI8q6Att.j(\ZFSQڅ:q4h4k&\"S#1\Z1:(\r\ZSF&R9QhZ4PN#v\nDԥ\Z]FR.KURG\0&.:.:,$8LbdImD\\ZN\\eRqV&UbN)ҝ\Z15U2SJh8UKE+HDbeTX+	Ej4Z8pu)9S+Iu0L\'Ney5(%\Z;T9ˬtWRF\r\n9\ZHYGzG(TN\ZFB9WTjFH+:Ԍ]%9#Q\\hIʗ(E8\'U_L\'Jz\"Q,HVV1`)RXQq<TQ<AQ7⪣J_BATOPp^cTOA?=BAS쮄G+ʉv P}ǍH?\'y1=ip$\';LLLa0+dԑ+$X\Z$0\nj	`Ii$zJl\nIhR`\"F$)YQX%e)bQ`K)S*(Udt]$;Z\'	x޵%PNd¢R9=+$a5B^pDzo]իښU0TE- DhRKD,XB%!bQXb+TV	b+J,J-UZi\"H:utTMD\nO1\";\'IT/E(OTOq8ׂT.BIHLO1R>D$ĔXz\'jDWȒ))	\'Le,a4V(hZ\'\"HJ(zNNzo>1G/HU!=*\'TOdMe<<- P)P@\0\0\0\"	! \0\0\0\0RR8&&&L&!440hqLMLM2C@h\r2h`#L0d\Zd	1F142a4\r4ɡ@`*MM0T\rH<\Z\0\0IH\r2F(z\0Rzz\0O$7Bp)p(U)ASM2*&FTjK)YRRIdjFY\Z4hѢҚ0ҊM%\Z24jFhVT4hѢDJCF24&\Z2FU!Ph \\ݲy *UƢ}hyYi;UJUTzfUQUG$\Z0r0龜=$~gJRDl=EA%KK󀝐*i)^2E̠QJ|v|hO*p]_0/Ixe>r椮tA|5Q\\G#RrG#]\\#SuK\"9%tG\Z:T58d#r]HwIw:ѣ#YPU:ƍ\Z2#Z:G4r8\\#jXCKBwIwW\'HC,ڗ.9tr.Gqcu.sr4hѣFr0::K]F\\L\r.s4hr-\Z4dhddhF\Z:\Z24hF#F\Z0ѣr4h8#ђRҚ0\ZZ(uQ^+GpFGdz#r%4hѣFG)iG#R\'ZSrW.XҚ5TrhdU\\0uVԱ%.UE)cRZGQr֩Up*>uQ##}UUo#x[䷣WlUQjq֨䔵<Z5JԪֆ=rG05AH^tJ%4Ψ$%^`\'A*4y/5檏4T}\">\'>%KdPl@ت--iU|#)RGO|y<]G~OzP yK\'%Tx|`y ޥ#j=(x^W>4>*^$d{G/|e?<1XKW\ZV\ZJi+@EGB0QGQ\"=^%G$xG#<h<J;Ixxx^*|<#-|:;kR㥤uQhSDnWDё.uz|Uתu>2_|#ē|p̌24a\Zqhѣ#rSѣF)tFG##FRb4j]G䥑;\Z4hѪ\Z#-\Z1%rrKVGtG8NENF;\ntGfыENG*qJڝʧhѣ	tK9Q+h1\Z4;\\Gj\ZS]#uh\n\'WhȋQ(KhlQuv$U$;K\n-9I6WRTԲQQNRԲ2A.:wZr(PKmUĖlԥ6P-LBphVV*dq(.c*\"1%fX\Z1SmQS֨deUNE:H)DN,ۉ]PZVH:Fdi-PW*Pj29\rPbPYCR+N.Bdd.#/=1=4ѐ)Q=ITeT,(Q\Z	+\"H,+(.G:%HJ łI\nB_$AQOu줈9\'>{BIG椈=~UR=_$$G#HG$A^ ⏶^xG>{$\'w\ZFRbiDʃ*KR 5*J\ZSS%Qe$X,%%%QbIhJd\"#\0DU)bRP\"S(,T24%V#\\|n\"W˙zW$A/B:х$&h$zkI#KtE#x]YyByFBa\Z*d&Z*b HKXIjdKJI,҅	5%aUbE$YU\ZҫUF#A;(NR>JH$]	&T,\'z%#{zjގܿAP*r\nG#IGI>*HAB|,y#D\ZH_<H(OHI;RFUXFUYUa\Zb5CC#T31c3I>RHԐ=^GޏQ5)$zKb=Ԋ$I)z?\0_0\n)@ \0\0\0 JT\0\0\0\0\"\0\0diA&L\ZL48&&&L&!440hqLMLM2C@h\r2h`#L0d\Zd	0R%<=&I4=ShO?Q220QM=4є4\r\0\0\rhiQJR1$I5a\n5%,%XFR,*hD4hѣRhH22*Rdhх0aBjZ4)X\Z4h0V#JC(C!CUB][i*`Wa%Bٕ$1*U##Cdd]\n\nHzJ7Q%R0L#F;G#F**R#9G`5ƁJJJ|ȥJꊓ\"-.Dҡw	I*Et*KyJ#l݄sН/Dw^%,x\'y\nUҢ\n%Dr>}#а:::tju2A\rJ8\"ôWTƆ8haUc0;.\Z9pw!b:JGt}]I:pX.v#GaӤ\\GZ.ƪwZ:GuuNG#r4hѣF\'r4qt:FV#FUhhsZ;r9\Z4uNWѣ&ڍ\Z24hѣ#ѣF\Z4h9\Z8Q0ȜarؗCap8Cr.	0Åp`EmJqL:j&i+CJєRɃFCJR\\Eq5%0#+`dt20Q<4WG22Ka9N@֛k|d5k#YKЎ0ddeILK)Pe&R\"\"Y$K$dJ$2\n\"RYL!\rF&ʈD-%P&!*KjUOd^jOh{#<;G>^oG>!|yʾd|</(icbO5-i{2>!ƒBi4I9%;H4v.C/Tzz=a:G\Z h)hhʼʼQꏐ1ȯJIGhAOJ/JKG:#cK<ɚL=e=Q>^M1V|YWY+U\rRZ\Z#uGXE)O? GC0d	aa]t480hWr04hX80a;aVXpG#F$r,wKF#9\Z29Br4hёٷQ(mF\"vDq\Z\Z\nrK#Wtv:ѣFp.P!\\wQѡR;Pѥ4dDqCKD`-F\"]\'hDF\"\\NHTE5TwTIԡeJad0ԃ;62BĥK!,F+G#P8PjQE+QuFҩ֡Y#F6[mda&$ihTUuD8p\'TKF2i+5j1F:Q;pRhq#FF#E]gUdL#*Sdb!24qK22#GCE耚PZZbUF$UQJSuP\"xڢMJSAT~ժTPcJSE@̍״=u)Mh=SrޔiJziJf;R`UrݷChDcR\'`\rJ\ZJP%5EY%\ZT\ZSEIQihdhdj(DT,TM2Ha\nXUZU,QZUL,DbF|mS>EP5JBt&\ZPNCTU$`dAD{}էA\rBdFL4\0Db%XiKH(ZD҅LPj!V(2«Q,UYDd\'u%Bu}R:)*x(	cU)~*T\'\"P:<y*R!wR&{REP>)B{X>y@*֝Z4T	)ah+)jQdjff1tSERFJE)p1\r8-A5ERGT\\3B8E)Om)OdMf R\0\0\0\0 \0TH\0\0\0\0(E@\0\"8&&&L&!440hqLMLM2C@h\r2h`#L0d\Zd	1F142a4\r4ɡ@`Rd	=A=OҍM44OM= Jy(\0\0\04\04\',aIQnBUU%R41M\rPaDh,2&TIa5E0DVJe&HQTX\0aCJR\Z4#Bh*Hh5%T FRH^hA]`\'QWUJT\0jU0!\rlO\0JP6d-J9*F0a{U&x0wFĨqDA_=R	E<*xDI.PE;Ѓ(2RUwǊ5ơ8\'I9b/J%娗$T/U9/#J#RF9K#v8NeFGi##v<8#C^Qu+O$h@:ԝF\Z4#y4-CR;!<B.b;YK;3/r%둃x0\\C0<.vja\r880Ö0\npqh.#Ca0a00Á\r	i\Z0NIiMV%\r9R]#pF#t%4hѣr2249hы%Ĳ]F.h9a;pL\Z\r#	(Q122H0Qd`њ#S!TKJu$公0a\\z?HGAjīj\\uG\\ad\"2RCU\r&\Z\Z;H}CCR)X%$RKE	 P1TU AXrG@NDEȥDK\\IkT-jk5rk\n%4\ro# ec dR%}ѼAJHKvU%FZAG=#uzSЌУH[qG[GH>!D`DyK_BdZ hЖ%>q1ܺSz\'E@*zzA@a|9IAD]/G|#^-p=dq>B|)2ʎR;ʮL\ZjZBi;m\r\r˶*:8G#)iLFj\Z\Z4deC\Z4h8QFa~\ZY\Z4hѪ\Z+FHDn,Gx	phdTrpa0	50Bq$\Z2RW\n.er(ʂ]i^A\\a*(paI<*EAi%\Z]ʔDThTڤGbK*:#F#F^jGM,FY-\rK.W2&C!C\\P5IriK%:Ulq$Tfm\nVUk<\r@.m$®*8`kA4%8- C;T^r.*Bp:he``0ܐt#2`e0t000VX0N0\Z)cb?ٌeTORU%a	$U0%eJr>v\"Dv JҕGX~BfIglI#Gҩ6oIҶT#=/NTG#¡BoPvd#r7cڡy\ZFRdb*\ZBhA-h\nʪ5R\ZUSJ)QeHIeD$$*,	L&D*EYRYU-U&U\0X\rr;Mo%R\"?v}k5R%즌%!0GG긏$b0{l=A0I0&IQZjj%%DUFT, ʨ\rj*,JQiR\ZVEJG(ATDj(FJFjDmYjBiJF:Ѻ(^JE	#I꽢\"l{#1B\r/H7d*U\'u*\ZUX\ZU\Z,	@ff33:>TMl#26Ev֍;T)#lD#23nPݕII)Ex?\0_0\n_|\0\0\0\0\0@R\0\0\0\0\0\0HAF142a4\r4ɡ@c2bh2di2\Z@iC\0&\ZddɄ d4&\0M24ɉɓ	@h\rM\0*&槢IC=F\r?Rz~4\Z\044\nJ%MAާ\0\0\0\0b\0\ZhiGB((@L-\n4#ҬUVMaaDaRaҬaJEL`0jaL\ZJ0)0%*C*\"W.:_v)۾ʢJZT%>i*ʃ\r.\Z^l\0uzX>(JzQ`\Z=ma줠|TthѢp=;;Dpo.B]!w	ؔR@U/2Wlaw(BH^%\"^%BJ-@TA<+:_Xp8,|p:,:8t:,x+t8,< <G(0Þч0R]8,0p^8/.R\\`axB^SECx0^pqayLчrpaat`0qaX0aˁX`pa,90&0ч9803afFa\"t>ap,00-\\Qʪx%p88<ap`0.	`;MN5+0&\r).AK\r#UN\r+a`iX;VD@9tsW8=8vndChdmB&SlTCl\r30YY)f\"YjHY&e!Hg(2f3Tn7nn\nnF2%B[}ޤ7\rUT7ԭ#UpWxŐ: HZ`.8`1dB`YRe!C!`\Zư5P.11b\Z8ÌbkZS5^>====0^=V\"1C\ZS\Z,dOQOZ=Ha{ډ/h @CP5\rNGd=0\nHSMXt@;Edd),q9T#8,&0^0ap00p]0000>p`á0\n	pQt<x(#paaG0S#NP`0՛h0	<\nq W/3PR%yTaRWHr	0y	<	(...,R..p5	bETppa\"HZX	`VE	&iR!yBi9DphD8jeJq@Ҍ42\'mNQEUYCʹ+f<%Z\Z&p8#hJ8X^rH`6\ZND;a04aQE/29)ڕkKN(]iL*:\n~8?tz\0d0P|	aESQ\"bZHS(HBNꢄRIQݴ)I@Jڔ?zNjJ4zgB0ITT:qJ ؤzn%%dCG>G,,L	*,\naJIFJ,\"XD؉jR,,L-*F(M)R\ZT4(JPeJa8:>7x|z\riz$/D	(M\'aZ}W\rt8B>WOG0F\n0F\naFTF\"XK,DP!5!jHj%Y@ʥVeR+A05H*;|(۪2U>G>i=$eJ3;$.JÃIJI@9\Zl\rC:*	T!aXVaXS\nXSAkYS*#IRd:U\nFAiPJJ\n2() @?S\0\n\0\0\0\0!\0\0\0\0R@\nT24ɉɓ	@h\rM\0diA&L\ZL48&&&L&!440hqLMLM2C@h\r2h`MTmLAhz\0M=@h\0IHǦDК\02?R~4PzSԈ)Ҫ&P5-PR#ULUda`fRaZ,0aR0aL\ZA&aUѪ4aC(Pդ)UHjԆI(4Ȁ/-}rTl>%DPGĩY\n_iKZ8jO^;@I\n,L0aWJʿŌ]ú;Aߒ<*%ҋR*ĥ\'\0T8EWҪԪOȂ5U{gW{+Dȏ@	b%PRHW㪗R~H>\rS뫁`1ʺàꦪpjƨê`*8Ur0*iWeu]W0CWc0j\\×\'*Nnp`]u[TTU8Waҫj]8صLwe0abr9\\awv0Sr85cwjpr880á2\\Z0jsjaV805aUa-Xn0rNj9T5aZT`K)\\`)ڋUڸU`ʸv:0q9UFW*b5L\ZHfPf)`0jCU)6H8HNZa*`UE.REp5Tj$F`h`됬K|\"GQ8ꪺuT]BuUpvqQpZT\\Z\'O<1;)<\n/)<B^%^\'PUxUK©< <^CHJOq@!/K#bWPޔ=C ԫU/|{·ݺ[ʲ٣h\ZYR9㏚jb4+x[oRh ʯ)<=\'iO=zT:Ҫz(z/@z@zǬ={+\\B\ZhlثmKmM=Ohj-I0RP)y<yy=Q/h^Ob!%-A.r%\\jTMUmS8\rh+mV\n-rׯV7[Umv[(\'Jj\ZTj5XaW*9Vaat0p`VE\\TL\Z:a\rRTÊ8\ZpZT\\GrTP0êPua$pp5L,.QñdN\rL0TaU;. ]`aN0aȎCN\'a\"d%v	t)NW%!bYI\"IGUTN[I)Ԅ&j8ȡ]`MQu)m\\ғe!ӭRLVҬQ.Z%eN5Ք)EUSRԫl&Xb-Zr`E9U,6*W0!):\rV5KtT&)\rVI.rzX檕T.ܨh,:VFc3Tb2O!2LZURB5\n\n1AYz*Y5\Zb%GdJ(b\"|H(~u~y\nW y:)\'ڟx]|ezP>כo59SU(*\\`X,ATҫA%hh+\n-U#\ZRR!,BYBX(DY\n0DСCUA!aJȪʅRFU&dWWr]P>nRP3OS\"!w]@MGju|->W#t%b<fUt֡Z҆)1#\ZRd	d!,KJ,BeBCHL2P5JUKTJMU-&w\0D+㠠u*E\"ISDJD5T*q0_^sʄAJIAR!WE E|Z\n>K+瞵|U4\rvEUK(*YTU:c(YEjRX\ZVµKT5C3Z33A|E#\"I4jin<qѺE%Z\\i(.x墩TPVIj\0j	O\0/ژϠ\n\n%\0	 \0U\n!@\02bh2di2\Z@iC\0&\ZddɄ d4&\0M24ɉɓ	@h\rM\0diA&L\ZL4RTmOz4F\0\0\0\0\022&OQiIh =@SO#SJ$󈔯hQM#U(2CT[)IZjk\0\rIHU&L\r\r),aX&d0j0Պd4M)hJU	C0C\r)`0PaBP\nV//ꊕT바?%-}W(殺*TWiɆ\r\\0az͑骅PT>P\"}5Ia{a\"@x[=|&>Z_4U~2R~D\"%(%K*(GB??HTU_?(~d@O%K^%*\'?R\nI-I~nj=qGEc,uI=ftb5E9+pu:#WUva-vp+c\nT0.M+8ap]u4uGUt@vvuIԎ;Rv)naʮL\\KX0ð09S80\Z\'Cap]8N5Z880rXa:8-MF05Vam80`0a\Z5ratTZ+05S\nԗ$%#G\rv:#Xƌc8hчc#e]UTZVmRpSKN֩9pLrPS\Z54jqTN%Gi&\r:iZj`0e*~)֏xb|*_ {w_ú];{yBAyܥU^2RI^4xT*Ĕ(E^(%B^%B*\'xP<HW<JJ`>X	Џ^0K(#ބ{y\n\'U{iOd	Oø9p=~OGK;R/Hz++JBHE<z\"^^Q-c^;{*л]Bz\n^2zhzA5^sc]`=<\n%xK^R^	X`\nU;CU;.{wW9Ä=]z>Oد<=y;.xrNIO`xW}G.\n{e=5WOMW}J\">~ʴ*Ѫ4]R9J1Wcuʰ겹YXa bj]Z8a0ՑjjV1U8ʮIrh\r82ahA60a3a9`҅pIʬ.U-v:ajL\Zi\\K;Ua0+rB],0$Nv\Z	u..PK\nʤ$퀸*,EG+V+%0\\B\'Z\\Sȴh`UrU;J\'n!H\ZVڒE9U]A\Z\"T&4\n#ʥۄ:B2E9Gev;m\\taC60ʣk*ͶX2TcJ÷(\'0X24UӒ\'*@0Դ*R.Ta5KQv\\WA.X9tT0jr\'P4\"*.)5LBp.pI_\Z$O,0*hRLQe@EKQ%\Z\\ *	e4\"{D\"@ýD^y/hxED%Q֢.jU|=  }P>{<}JO[bVK#	iRԌXʩd\0D@bBԉhQd\"%KPK \n,BZT*F*&ePbP*MJZ	h+P4?h|	m8wOU	Zy=R.ê0Jv[O|*%#EE%纴@V@Y@j@j#A-h%Z	bLP!\ZB1\n\Z0+*TTvN(|$\"DXPYJ/$JT*D^>Ox)TAvU	$=\"z=5*=x^KRQJ{^J/ 21LS)V\"j¬3YDQ)wEp;é<τ>Q)hA(PVIN:;	O\0/ژϠ\n\n\0\0P\0@UPP\0\n\ZddɄ d4&\0M24ɉɓ	@h\rM\0diA&L\ZL48&&&L&!440h&(&M?T\0`#&&\0\0L\nJD4ѤM\Zj~IQ=C\0zm\Z>T*z*ƚbL\Z!YB\ZT\rI+UL`jJZMV\ZTfU\rVjSUJIUjVLD5j\0B\Z`0UHaQE\nPÀ@/$?\\@X)5\0\ZRzWZI`aT5:}RGbHG.G%5MXՆzW0\"<B~;UKQO:RЕIE!/y	~T~hK#D\'QĔ2J\nPJ?(~`?AK	~%>rC=E_B$)%_W(|}a~r,9\"p0sJX0%\":!Jҕ\nNC0%̱S:atar8UrTWB:*sGpGUrp,At]5tKUr8jƫEˑqS+Uj\rVSF8cUp\\\n`⦬2an\rV588pr10q\\\rXj5Z\ZAK`8()`ʘ4\\QQĔK80s.0`a`p,\r$9\rs9SPSBp!4g\"2X#\rL`dKI-BԭE]*4X]4\\Uh+\r*\'?T?X={U{J/m_%o>B;]svw@j.{C<AUxWRx JD^$%B^)JBxJxW%^%^#?pGJ{#Ax/%B^B!D=E^=WW{w}^꺫\\v%y(`i.\0%RUN^(wPQ8yp=!]*<%<Ph`=EOJ^=5]ø=#кJBWz}Gxw;5ZSG}]+ڠKvڻj];XzĺvDvA?Ozd>\rN;%r8OXv^``v=ϔ>P~_KWW\'^w<|?\\!}p,&0]0a*r`a\\`j~``ÚaaXaa\ZT\\p\n#WXXE\\XV:ⓕjhG\"W-S\r*K@ц-]PjVKE\\\\]U%\nƩjpq\"j0Q:\"(KuVB\\,!.\nZٵ✡-R-\r\"\'M$̡t6%a`Ї7\0	`h(pCNlaEhCm*\"\ZiTYNk)Vh\"\"׀ĂQS@¤PXeFSsk$UuEШÚ\Z1Fg8.t4,ƪ\Z&\Z&Bܕ\\-YUUFD9B0S\"a/ήS-R5&U)%K\ndBV&+Di	UO+J4ʕ;(WiBG(](_?>ڊ@Gع%=/HE }kЊ@\0%@i(vJU	r:0a```X\r`2R#H-BYIZ(2 TRi(	b	bȢДBH	I\r0J)Y%Xe\nԑbUb?xz.Hf/@yWr)2=C0	>0,*/3<ס.`0FSjSZ2BY	d%,	ІҕbEV*1C*-BUL\n:\09.a)-^DJ`^Z /PrpvB]JU	B=E ze*X>%4R@ޔRO*yBXVS	hjKP5%!kY*)\Z$^T!z8O5\0>;iUP_dMe;? PUT	PE\nQ@JP(@T\ZddɄ d4&\0M24ɉɓ	@h\rM\0diA&L\ZL48&&&L&!440h&(~G~\Z\0(~a@M\0))jmOI\Z\04!TѠ@\ZI~I(zjV)M-$аЌJ5+Ua1X4c*Tj2Z5cZT%VZ*UQjUhAPA\ZUrIE\rYjPjԨ9EV\0W\"*ώ@(>)kn#ƒƿ*Օ6O+C`5jիVl*U]ifjRt)}zJ}_npB_v_~O/`E_\"\"|Uv}{t=!O?@%0K/DOTU^*¤~	~8~G֪pZh]W0Yʮ-Ҹ`êu:W!*8\Z*vU1UڧU5epWhÝl\'CWu\rY@J;TtqL5\\;LЧu.v)̜T.Ⱥs֬uZ:lVtUv\Z\ZqM;á\rXj0e8uNW|%WCV\r+Uj8aWȰj]V\ZUʸ8ac\rW*a1h\\5XcXpZ\Zpr\n]#\Z\"`ƉёeM*$и2W)X9ZWEV5Xj9V,2Q.VJ:b:abQH#20FXbQ82)DɅ0Y+*j	VajjQjROJU_|puP Q>_\n?YR<>	JQx>_p* v<4<TB+ҨH=\n\"/DPOE(zPz)U4T<hxsCΕ^x*|bGƁ|A//B\'Ɣ?>*\nB落D=cޓ{QSWx\nCxR(ey\"GWGS}Hh;w»⼵vlvڮz⧈=_Lzʗ\ZG7q{E<<0yj_x=O:>px%^=ҏp⧹G;tNUEw!UwUS^ayO)p/%GRE䨼<EJ<Gxxr%pTG<^h\'l+O}CIUު.>c\ZSC\rXՅ\\a5vp]:\Z1Zb+\Zlt?285Z0ի)a%NR])S*rH1paCXj놳Q;Xaa.UaKG(`dVVR;9#rYTij:$X(BqQ*\'5]\'Ve\n4ՊW{jpKA]eT䊌	uSsQ&ab)Ӑ1IheHEpXbjiReNT&A\neR$PT̓\riJȡv.%t(iCXBKaQZ)0\\Y%*:VhtQrEAc\njZͥJa2)NG^UCU`\"VCF\ZIN܈!db)t\r\Z+ĮT2-IV9\"0ĖTWpr|aćET)bi*e%\n*RSD\Z\\>q)T\ZL/\nb+\"?:TEx p<_Wد/_t>W?D_D\\W+\">Ǖ@7ү\nW}#ĐDu]VV\"-CP1SUI+-*ME\",BYZZL-BL\rQJ@A)UK\"(HZ%je9]W] |دQ{/aQAw]T&GjjW*R1YJ/]Ҹ=oeՏ::\ZU4\n!Fh-@BZ	d4BCT&\Z1VЖ4UiAR5CHZ\ZH(D t.E;WQA|Q(DJ\"~yJ(/QAvH\"jxD_B8D_hW|@>DeId2\Zi,IkZֵIOehzq__!^HEA*UB</Т/1AY&SYaWqeء%>\0j`^ JB%\0J\0 @\02bh2di2\Z@iC\0&\ZddɄ d4&\0M24ɉɓ	@h\rM\0diA&L\ZL4RRGyB~G\0\04@\0\0\"0\Z\0z&\045<^KƠASL*hH,$DdF+U)S*PhcJhȔcTѪ5jMXlBV\ZaULYXhL1JL5\n(X`C\rTj2(a`DPjH_?S_]J*?cT+>+V}Jp\Zr1}lWt݂E.E*2\nGR?r%:ݐV1j^,pի<$]}ڇˡ{HOJ$_Τҕ\'\0K/_P~teH}(+O֒W>a=_=U~8*~DP/0%.\'~Q*U\nO%}\nCJ¸W\\+W 8cGUtjՒH\rUgquUuJ9\Zw)w%]ƫUp9r1UNa9VV\Zӑrr;u%c#EjT]#T]vEv䱮U]\rGg:w\Z4cg!r:U\\ı1d.Trr\\0hԮZajri8kjr.\Z\ZU+EÕ\\89F%8cFcU1VV7\"ʱT\' pڰ՚iZ\Z#Z(Iq\\+VU\\vuEj5Z8c\ZV+$.0N2,1Z%WMX*XᖒʵEUUãF4hьF#SR4I9QN\ZSTZPİėF1E֋s*a*_&RU_{vSUJ*^珸{{^NUKօ=S<*諡WJT)tJt]\0HH]	DtH芮*tI]\nWU|\0|\"$|.%	y/:B<ȏ:!*W%y$xxG#zU۪/;z$:\"R^T$<=t<k;z֫֏/yhCԣ*G<h{YrS+/^׀Ws1{%z$D{	^UO4yyY-E<O)O!JUWuvIESWzpq)EުsD))އ>(<ax%GU=tO(Qi.GlޮϢWKȏ%$O\"^Uw;ք_`G8Ji\Z1VSʸ\Zի\rXaW\n8\Z1Wur.\Z\Z*ԱR\Z0\rWQcU1\Z9\Z*EUU@㑕QUʕpь4c[nf5:hXh(eUGe+;1dV4aWj*v1WFU8MX0$qW*SKUpT;,Y\\ʪq\\-XbċՑԢQrJIadi(%r,0*,KRVJCAC*UNR`L\',\\E\"q)\'Wi1VslRtRơs+Ʌ5X,p(B85Q\Z5INGF֥c\Z5*vTh5Q\".F\Z1ame+B✣Ihq\'5rV#@eQʕF4\\\"ğhRd0TD&H@*`DdJ!]!QVHZw]rD(_x~}B/H~\"ud*ܟЄ_bp;$@H oC}¡@\"wc\rj\ZIa\ZiRS%jBQ*TRhQd\"K,\"%SIFT&\"1T2DjVA\ZPd)\"V)ZHX}8$@z$@֝i\n9Ta	Om{JJFEvܭ;wUZ2S\0#ELh,`KXX$-j#!\Zb#\nBTjT,TdPeZB\'+\"(\\@,.eCT9Y\nO\"x t .T:Dx{n\"@\"x|:`Ԉ\">:D!RUbYVĵKHb4&PYU5R\"\nJFQQlXr{JJGT:ð=TA;B/1AY&SYZ>S,%>\0j`|\0\0\0\"\0\0\n\0@R)\n(8&&&L&!440hqLMLM2C@h\r2h`#L0d\Zd	1F142a4\r4ɡ@a5(TyOMSM\Zi\0d4d@\Z)Rb&jbiiꦙz@PM7U]$Bs%M2--ƥJY0SIb\Z%j1U%hPeeJ%b\0dj\ZX¤cEL1VEZQ0ƭE)c*ZQjcQUX0I)c)4`c*cQQr\"OɨLv }$/d$T}QnX/RKUbMA1Y\'CkzTJ6%t-KjK5ZcU^S_kՌ%yU+W\n/B~EU?4|%R|HEUE x|D#$*ԪWJ}j++௎WR]JOI-Q|Q|QhPD=EC }UJDEwڢ=\"?r8?Xc1QӦv4h&KQ<Kv0Ñr1Uy/0$yq9\ZUc\"c1*u\\Qtr<x;Gu,h.UO⋵9GttO#<%*$Y:7kv<<ђݎQļUU!ʹO8t\ZcEw<0/*#r#K&a\Z1W\\5Z.KcF5XȸdZƍMV0chp1ƌpjaÕcUjXr8KƨKc\Z-VF&)2Uq(^ppr4r9*4c\Zhѣ1jLdiU]6$eXX1Rᥤ5E4cFF2Z4Z*rNTSUXLFE.֫\Zhd;ȹXTByU@{\n셮a;;(wܕd:[e:lJU:uu:O]J+ƭ\nVZQ-EU4\r\nUE-KAB(Q#BHT44U+A)V^q]+v\'m$v-(S\n|O>DN*uRN+C.%8^&]kejʵm[kU]$s*VʆpʩGEU#zzzV7JEʓmm+C#&=KbRSc|c>\\V6T8\\PqN1qBAN48B+\n\'	p={>8rKS%UzzQzƣҏC%q.G|[\Z$+U觧+rE>ҏQO?)Q#Ib/\rGc1pƌcKF:ch\'QGOƖ\Z1cʘc\Z81rKQW<Ur\r\Zc-\Zx#]4X:#arTpj.\Z<QV$\r^1j\Z<E9-VDE*;\\0)wJxULUy΂\nd\")£͵IqWAM\n\\8cQXpNS\"ĵ\ZWJ\Z5I]	qIKKQpJ+jI-T0P5Jmr\nVЖ@PeT\nRǜQ9rNJUʪ.Au*FVjʴf+&6ʪ\\+Yj.ME0ƔJaO1*D4$\ZV\"aW\n1,SJ8%2ZIr9\Z2+1N5!1*_H-$LPXd!3\"ibiI	W2Hk)T2-ĩGeJ[ܩ@j\r_rQx(OoEQE_Z 8Щ@{䯵خz^{)zxhђѤXI	Y e@ZVEU)Jh)4\ndJiTDZ\"*FQ##	#5R&0j`E\ZQeÚ\\j3ߜ:(\rezQITV0-FydjWQ\nbNrWz]j#,#V	bbJ*0)L\nj*`SV%,)ZIZYDdC*#jEWR}(B*E9SHH,-#b֭mDNU^5s+W	|D֒2VĤtEҮBIţX\"y\'8$M_ڬd,d,`,dc-ffv\"V	Y6QsZ\\xn}BxTFoWT\"t+_u_dMf+i*U O}T@\0\0HH\0((THQ%\n8&&&L&!440hqLMLM2C@h\r2h`#L0d\Zd	1F142a4\r4ɡ@a5)=STzU=@\0\0M4\r4RH5=IꇶSO\ZM?TG2ꦘy@O(7^#$BpU*+ib#EK%M%TYEj5!+JZJU*Qj\ZF2F2XѣU11RKXUZ1,RY,k\ZZjd%UcRV2F5hP	4	B6~檢>7hJ{\ZHEa\rM-.&dƌSI颩RR\ntQ%V?\r1{B*A>-yWh؉~\Z(qT*OwEUU̈_9\"yڨRUJT9TW+_\n*WR0/T_BZ_JDGQU*}tW_T<j}q,~Xc8rIu4}%\Z4t#wF9#;T\'r\\;hK:KWF8cwGFQ]K\Z9FKJ]v..Lr]v\'pu4ʮGitQ]Ʀ+\\UÑXcGcctvdSIĹ\ZXь1Sюr4c\ZK*\Z2FLjdٓ\Z8.ƍXMÜ8s.UcU4c\Z\\8c%R?j5-cQY&W*%q%vEGqÑ4pc¬cF1ƍ\Z8c\ZIьH4jZK%0QIKj\rhҖ1JthƌhK&K\"bɕZ@	,&Ftc-F,K%\\h1UyU@~z텺mԧi.rrrrqWa;*ʧdSSyGdW_\n[\n+dKj(*\n`ET[ET[\"ĉQC`Ce*RV¶WuJw	ʢT]];ĎފA_]#**^TE]|Q|5i/	Uƹ!@\'\\RqCG\Z/HH>$T{%>4{xKx*hS%Wd{DeOߏ=OXviy*	%^RO*O1O ъy%<GO\n*	%/\n^R3x8rKS֒쇪\'UK^A\\\n\\+}o7q.G{^{Wu\n	<W.48qJq%]n[<UQϴ\ZKhƨvj8c1Tp4c]F5\rєNF\Z1w22XFF5pG\n;v#idUU4hѩh،Uc%#Udb\n\'#%N\\cGiU*1)cF]ԗ\".**ƎTJKp\r-ŕKR;SU4	Z\nuK)\"5.AM%M\"+j1XR*KQUĴhх+HR+QJUJʆQpRU\'*JCD&8j1V@݌SHZ	1bDԪe*W[e!u\nQUXJ\ZHXV4)5)҃h«ZNFR5cF-I$Wj|Uj9:M%LFP1T݈Ƃ5%c%ʦJq.Tk*d%u%hȯ>\':>(*H$,0\"+TE&@Ti\\ը NvH!0RPUW )B*ҽJ*P_bꂯG <eu*P@}*^:C|HDk]hhZIjZUiIKVeUZZ-	MU)))))))E*eB%,U	IH	Y\"hBVZZj5F?{.U^],sΥJ88H-խ2+]d*FEZC՗=L#TaF-RH& X$b\nh)J\ni)e*aJRCV4*BQVn!5t+P\ZKVTX \\ʡ̪At9\"+@ulx_z%%S)**Rp)W]ԩ@{!rJ(@r9%J_\n~L|d15,2HeJdĦ+ack\\TT\\ZWWA]d*GHQtUHT\0_dMd\'l PJ@\0\0\0 \0\0J AF142a4\r4ɡ@c2bh2di2\Z@iC\0&\ZddɄ d4&\0M24ɉɓ	@h\rM\0	(hG \04\0iM\0\r2(xM4OҏP=OڔSLU\r2\0zl	R2V)K@օT1JjT$M\ZRFVI#\Z4d\ZiiM3%(c\Z4+J!M4j%BU1*Dƅ*4\'*RhƒU\"\"%UՊD*m!S>	X4rF>cZ2\\8ɦK䵲hW߂U\nx}d\ZcI1+	Ke}cxʯ9]¿WGS\0?Q)>EJUU!|JD򄏐$~p#=}\0/^^JW:_x(*/,/>ePJzIJ4dhǇF<c]G$1ǔxzjMz/#xy*:1GGQ=\Z8.C^{c\ZgU/2Kx4q2^UyT/\rjJUx%*Rz8=/Qd\Z8J8qi=%xzbNr]\ZhƏo4dƍ:qZi++F2YZ4iԱ骱GC\Z1&8Lti1ɍ1LhK1\'\0#эQĵɌMFTjQW*J\Z=::cUh5ѣG\Zƣj1щWJmUdU.KZKYTK\ZbXF\Z2<4cFZ1ʰ+Z2tNhU,UdLExyX2ZUyL=UGZWW^=K.ykڭ7pj_(<KIP\'P\"%دJY\n+(K*(ʥL ETY*UD2	*U,W}JQ;ȎʋT\\.tDs9ʇ05*U.5Ƈ\Z$.٦Uf\r]<BUfWUVZKH\Z0br)SG**\'T+b+b+a]5ҭurMUnVd|3WxO+K/Z뮺\\+D$V4p)p*\0.\\,pn+qFF䛫d8뮷Vj̓|-$[Է%]qֺ֓YZ4qN5Į*qY[`mSnW$9HrJrR.[uyiR:%cTd5c1TqWьcӒ1ǆ8эDqѣ%=cS,uFLi\"*qW=jZU8+&ODb#aቩhNM2RƏJ\Z1Md&*b)puX^M4zU81R{JW\'R]TRKȩU2	Y\nyUjz4eXUE.R\"8ƣ(\0a\"3%FRV),\'#\0a`J*ot{*Kإkd*5I\\P:*I-#C˪[JNEi2MbM1M%X%^U*tɚ:I:<1hUkB؆eYUZSF%L4hC@eLL*{%xkMF1K**򡔴ZW]&N-Pѓ\ni?0J,RJ+$4QX(Ҩ2q_\0թR}\n%xHj\\$`+ܭW	9$l{B^̯	n@|w%}֖m$p\"&zXV0$X$A0!,	,QX+UA0JLJEE44\nhJh\"ԕ1BJZVUXDІ0#V,W]Fj\\\\! :8cj7@bJZ+=V\"+Я2;,D\rH:W}\'_ >CFJKSR*B\n`S!MR1	\n##\n##JaJ*#B3\n넀P{9	`*aXҒ4\nJ]\r(Q_[P-TDZP	qWc|$LŅx[+@b$7@%VX+b*,hEZֵfm>%jj\ṋjtxWb%H5bUDDޭ%!/bL)&\0J|O(~E)\0\0\0\0@\0\0\0D T@#L0d\Zd	1F142a4\r4ɡ@c2bh2di2\Z@iC\0&\ZddɄ d4&\0MԔUHɣڦM\Z\0b\r10ѓЀ*P#\Z&U\0TyM@SOmKJ1\nQ)T3Q,HPhi,bbBVTRƊUY&3HKThmUKKFcjLmE#%2dVhƍ1BaaU5IU1%X0DUJjd4\r2@4,-\nTٿLI\"Jvu+I\ZTVwN%ѣS|VP*RQ($WI\nS64c\ZiqOBԿ=E-ŏKKRe/=\"$WT/@4_N\nRBZB\\E>U?%/I\'D<=P!}U_uK~W~¢%EbH=$~ԑB=u!>TfRWKNK/u<FrˉƧ[u4|fKh^SȼW\'яT=/M:/o&dt]\Z1EU\ZcUyFyW*^\'e-KyUu,d2^+$R^)xU{/jRxS<<שGQ%hc\Zhxe^<%xzd\'u.U=F)\Z1Lbh4qqeZjZF,zaG4cZ14h8ic\Z1cG\0)dƉԬ11e-)\\RWIW.5=.G\ZNzyWG*&2hє͵ƥJMJKUV-(cGHbXƣFRB<4eMjeYiV*i\"ꔝ!yOM+*ZL&I]c\Z-FUhbtRi/JB:(tJt]<׍Zz].m腺!CE+zYK2t4*g*4RfiQfu(Td$fC0bb1YREu:`.ET]JAuHRGX:ʫUԮU@ʎHR[v-	[ցE$\"[ֲA|Nbs)Σds[[W[ki6Tel+PȲC$|	T>	|wUwT9]󺻕j&8MrU.%\\hq1qqMZBdE%FJe[T\'wh8U8p¥yIʥ-ړi[kD%9W)\\T;}SqVooKx9!)Υ^;w$S&Z45/LN11i*ƞK&2i,<?-dǃƚj1XthUEʎy=xU죥\ZjZ 3ihѕcLio=xUlc)(&W:2Xʙ=S\Z=SG61cTl,hɠ{J]RJ&Q/2ر5U=*\"NrURJz,i\\z1*uUMA+!O\n2S)\"\nxJ(SI[*ExtƣMXjTʩjX	]*dщ+U%)j\njYD$(j\rUlwI+J\ZV-1UȽȧTEhL!2iS&*Ta16\ZxxiѪƘ$\r*)VLu-%M+&a2iUyJ;%ExljYXV]yA^*FK\nr+%M	4+B{Vš~l@h~R9aTUPUF+IEMTBWO<UF !$~6K&P\r\n%_XJ\ZBF~I{%jJd.M#{Zz{FؤE|W٩dXR1TJ\rRKQ))))))\"ЪdjJZV#T0\"1R$+\0@(X.Bҹ9\nvq<p\0jZj\rEcAxRU#HZK@H]C2Dҍ(ԥ2Y)eU4Z2\nj)SP%,*YIXJZD%Lj`Q4T\n\'dIU5(čbFT.*\"s\nKY) [mzR>E	\\%ȼ@<Hɂ8չ`\nxXD)6%-l!b`ZV*,jфffy*Kƒ%[KHv.xRU#$]#in.DY\nK)/bL\\Qf\0J|O(*Q\0\0JT\0@\0\0\nTB 2bh2di2\Z@iC\0&\ZddɄ d4&\0M24ɉɓ	@h\rM\0diA&L\ZL4RP~RG\0ު\0TC@d\0\ZRѪ=I)螡zz@SMl]\nTS`Q2RҲjRETj5\n+RZJƢ*F4JKThjjjh1TiHԱ\ZJȩ4cF4ȭMQ!`Q*1pEXjd$1U\n\")RJSQ^P/?C$>TȬaX,/r4hhƌڦ\'% nEv\"tE1cܜ1Ģ}`WbW^^_~E*(~%*}څ>\"ԅΊRƨJRԪ*>)O\nR*iQ|E򪋤BRR	>zU|T\n򻈏L/Yb]9NJSGJg)iӒgfv2j|i:y5FU+]*8S+.ST\'%r\Zi^Ty1٦`vvfS±^I.$Ҽ9\Z^TyIt֎NN<\\Ti.\Zlx5Nw%hcKr:v9LivbcLKxcW\ny88\Z4.U\Z\Z.F618\r%c%4Ʀ1-<1prLhюѣN1Ɍq1d4cK1P+d*p2iV0*I#!F.MFSN\')9Uie4ɩ)q491Z%*ƕXZ8\n44Ibʭ1ѩ$U٪iZҲaa5d,,BJʠMIRZ4d+\Z,M+%X,+Q/_L>_}j<=>Q=_(>OSzz*/^E{.tTJ{@*^t*AQtEҕE!tQ\'DTtT:\"U{@^GO)wDNGpQ|(S\nzSԤDWJW^^zO@zRО&=vkηY:\"w ^[C\'\nq9hG:G4Mhr\\%EYrfW0]bHв,KcZMrrTQȮP9صZպ]TuPlU6e6TLSehZЦ-\ZJ4Wp+>K)\Zk$*MIjIU壶+5f&egY#)vjj̫2p=S)NtqNu.j/ }g(°jcJbNM1iJp8iriSpMJQbɓNibZb\'F4$$¼9Js-UDpɍ4uɯ)Ny1ONF&KFJ+NFKMT&LcK\Z4h%.)qTN(/%ctcGx*\nyU+\nBe\\2XqUzAo`TǑO,\n켡M)M+ANHRK)]41%ERK(&MLY$N]*4YHpEo4Uy)rt[)M&V764X椹i84ʬhW*JVQcTeh%bJSEȧU*VPF9\'\n钘ƚE/4Jt%aV)JZjZ4c		5JUdrFV\rJAYRЪU9FK\nqR#\"8Yx1EDRXYV*HLR\\=iP\'[11U%IGbUQ_ڊVuRZ3eW+ڮ\n/(웄GڟKU%ҷ@4+Z(Ɗ9u:ƴh)5n<4hdYLJҚHċT L(IZBВJj45B1\ne%1\nh\"*j*Z)-T+J(aQ(BV +@ZA=j𢪯c8kE\0V0^Gۏ/伒*YsQZH	,bDK\0H`U5\njSPRB0%VY)XEeJRTb\rA`\n7QsĮ(⨝	4JUL\"71DJ\'5T%nWV\"(蒽\'^KZ(+5Vu°@<A)KO=^YLQaYK(+	Z2UkZֵQ?=(%d\'ٴr?\":W|(%|Д\\㨢&ҪK쪉(+$k)`T\0L\0JP@\0\0\0RHP\0@\0\0PJ\ZddɄ d4&\0M24ɉɓ	@h\rM\0diA&L\ZL48&&&L&!440h&4\0z\0m@\r44\nTITzU?=\'hh=?T3C\"\0\"naF%A8JIS`Z0LRRdEj\n&)Z(F0`bDZ+\ZhjiiZ5(iZVTcFj2F4҈M5\r4E9\"V5IQV2hE\\(pICPJ\\RڒB>\"XRmR.i]MLtjiqa\Z=tU jXBT(^4M?\rM2i>\"}QoǏ+Wު^zҩOIOߠ΂>%O\'G\n>TZ>W\n\n¿HWAGP_T_\"UQtH_2D*GzL~/zhGۨc%G%M%yWQ/#%5,yGѓzFgGяb=j)Wta109J=#T^ʞK\Z<%ԵS+-=RN<Z1U=zrZK=xoE{dΏN\"OcF\'JM<=t4F\\ttM4ɥbi]NU\\kcMNjd][LdL*i:t\Zc5X֫M51ǆNNMLitSS8N4ӓM4ɦiҴ馝NDWQQXc)X+RFD*W/Hhh:8ьj1FFKF<ț$ʞ&;KDvjcUuBXcLiѩ4\\xj1Z4deShZ\r\ZNETbKF`,$ȫM4e2tRһIȵ1+J\n%w}G|Isv]D Q>T_(TUAP|c#EEG\n}	#*$\nt\".QtE	tE\"tU#(	ER*RJ+\nh%}}S炟8)^	©\nB<T\nW*ZB-˽l-\\6sCeTxYk]CdQ|d(|a|\"_KƟս[ռ뚷-nJNDmu,&jYVK^^:\n=R|QGCO+qVM$ЭZTI4&RЦYгY3Tf54F]eY$\Z&+.1B^p+pչnQ[RdUʴCJ4)oU[ޜ\re]s(RsE̹iv:e$:\ZKhƨzj81c\Z1ǧR1ǆ8Ѧ$tdRƌxW1:cS\Z(^^^riZbtɦ4ɣMV=8<UU+jh]Du1Xе=S*^4M4KMLJ]\n,*԰,,KX\'ISM\r2Еj-rd,#(Qk,(-j(¨iBy44:/AM%MB+1Z	iUĩ1%Q^R4hѡ+Ή.JZU,UupJмSJ)eUJ[*F<5KMHbm9JZyN5CTj^[2YZUU宁aO*UeLSIy1ZihO-r\\TRUU8,iTʚփ+iU^%]R<2\rJ{tBhTJL`#\0u:q\\##Rc_%BZPXJeR*ZȊĊ4XDJaHeTǑ MP`T[JPnJ;pAWW[Qu+@gaB7%EJ%k3+J乫6+g^ToL4di-FF`1IdJQ,HJ*E5)MAMAM4$$RH(RHEFSA\n\n^uV%զ1%* ֪RL#Zj>4Ji\n}pX8\\kXdU\ZHU0JSESAM4SISJX0JRЕV*VR+\"5Jȍ֑5]J*U*,\n,kVTAu6\"\'2T]jԯY-D]R1YVH%}(-R90ӟZ\n(5B&uHDJ̭65\Z0TȬ+D+*a-Mjֵ^J!R0[IQphc_b*T^EܭJJܕ1AY&SY&=/I%>\0j`@H\0\0**(PB@\nEP$T#2bh2di2\Z@iC\0&\ZddɄ d4&\0M24ɉɓ	@h\rM\0diA&L\ZL4RQTU?Sڅ4P\0\0\0\0\0\0\ZheMSɩ\Z\0MK*C )))VL\"0,ThKd)\Z2TV,L&XX*i2Z\n1IZejՖ-Ųc M0Y)V1#LI)eđPJYp6R\'ATS9D\n>\nYDQdC,\Z_R⸲i8..VOKmWbO:k!G\n?mRSR-+MLc\'&2c\Z{UUx^Dgħ|SOEWJIJ/D/$ ?\ZU\n>SW_AQª%J/Ɣ^IQ\'UJ(P>T+\">˅~eet\\KF/j2].օK:.貫v\\,U]úN\n]tXҬ],-*,\\u.ˢ2;qbYTvGj]:Ŭ],]Hv]خkK\\Jq.єD麚tK\Z98Tc4dΜY.94M9\\9V8c&+:M5Lt8cRY18&hƕjiZaZu495ØюɣN9Lcc&1\ZnR⸩GEYbijZK!+Aڣe\\.]Yae.GUŢS*bW2R.II+TѦjjd-Z*8XXjȚbS(i+єWLi4fS2:8+ebʔ}$}bwI<|>K^a|ObۃE\nxRWQ~{^BJyJ(EWBJ/\"Q{Ty\n* QJO%*佫T{`jIEJ/rQ{=QG(=ܕ=ԫWzzNwz<tyyzZyy	J@_ztvC(z*b=ğ؇/9y/BK¼	SI^azzG\\^|=Iz=Rz^^yON惽#2b;Iv%څCKKWiWS.<iW/+\'OM+үEW	/B\\zgpK]xDR𗞽w||ȓ>^W֓O{Ob˂eʱeaqeYeXqe,r,,YqbՋN)p5b~bŗTv,,,Q\\Q؎ʎv\'%jeEpūj2V-r2Uj8+\"G.+Qԣu1c	i&(B+\"vV+Vu)Ȼ\nըj.+PptG+IvUS\"vrtMIM\n+H\"p]%@QGXYjJd]|G\\,XdqI5TILp5*`*mJBW] B-%+.H\Z8jW|łĒ)\"Cl@ lYclAX\\ZҦ,1#Qʋ4KX,҉qt,&,YVK+)kVTb$qY,15\rJY&).PtFK\"(ئ&A:IqYX/2gI9#HTi!h%VRքP+FTQUh#̺\"UD!=HQ©KU\0q^/:K/֪\0+$GRUJ\\/.\0Ҫ\0>y/\"<*D]X1b0(h-aVEVJLX(dUj4DXP((XZDYJ-*SQL$PVDVV)&$2dDVXJ\rFǽ/Qj%=*ǋĩvU)I#d/|$E踑C=J^`,b*YPi)SISH),MAX\ZP0#%MP5*SGb\'O|ڨ:]&*\'*=x /}(H\"yS=vx\"USB)KNO4I^ꧭU\0|J\"zؾ3^εP\0ϊDOEReR^b<ŒajM%,Y\"L[mfmP\"hyJ^,\\/>_{	U#D$KO\n{dNdMd9\0G R}􈢄\0A\0T*\0H*\"\0PPP\0\n\0IdiA&L\ZL48&&&L&!440hqLMLM2C@h\r2h`#L0d\Zd	0R4~Qz\'@d\0Ѧ@#L@\nJEDy5S)A4?L=bi\"ZAU4ʢBbSDmR4TjYHFAɦQ*Z+\Z1P1ZiRM4ҴM0Z*,eQ4YlZŖ\ZKSeQq@T4Z&\"2&Z!TPˊDTG:IĨ/Q̔UgqD~{&i\\.95ebͪ#*Q`QBEKLX2,W+-,xm	Tj}*z%ЩS򈧳Ј_yD`J}\"?\n~$$_о+AP/(#P\"~*{e%QG\"?A _J|/>qbtYt[tu#KbvEv].].w:,\\*8Z]Tw.],TK:.FX,0]ԻmSb\'eYعYw%erRqtX]cq:̘\Zjrrjriic:N5]#. VZ\\Ƨ&42ʮm51ӓM+dL99+\rU2i\ZcKLbɌqrnSLV46M5ˉqqrɖ\\ej-,qet_Y`,Y,\r)aXI¨rUvbŧk⬲ŖXYbŋåőJG@ˮ\"K%\\N(\"8ұ42Y5JƐ],-,Yj444YVbEN)&QVTSPīe5\ZZ,&+:rUʍLEEzSDڤ(Ej)y}\Zy_IR#xxx^!fC~R/iz(=\"Ҋ@Д^Qz)E^$%G*=GDz)蒽_:p_8/|G@_\ZQ|D/|RH\"zxI{<<;\');w%p\".GCGO8\0_Gxxx|SGzUG<r{Kn^pN{h{T_t^e]#܏pHE]һؓGh4N;S]]¼EO Ğ4=^KyvJIyy̾={^O\n^p^{I^+xxR}jOGRAySxz٧P,\',FU,GkEō4LiNCLik˥,T%.F.,YuGk,2ˁeūK,U\\Q.Lr\ZbR8ɓ+QVX]KV,\\\'Uj1dHbMNs\\K:rlc&iQc&(Ep[CVk,]\nJ*8\\P]őG\naHԢe.$vX`brZCBQ,q\"r\",UŋFLU$]b4QWx\\t%HW$Ĩ+W\0eG{jTJY`XXQ֊%e%Uq*I4!q*jKQֈc+&UTjY;I09)Һ,V2,j5Ź!ԕ8+I5 vT;B*GDpXҽkK%be\0|VLEM UDRQJR, 1A]UEQi1R(\"(*^O+eEEK/t\"<_}T:*\\/.@B\0O\'(_1~/b_Dx\'ŋ##$hZZ\nS\"PeI#QF-TK))%EQb\"Qb2!iBebTbTdbTi$`QHQYH2dJ%a`e8^(mOaz8Ǳ@]eee1p\"]G:cK`X,FJ5FZY(QdL!i\n%+HV%ʑD`-i+aiC/Е.JI,\"ʪ^#Dv^z$O/^GĈvJqz#ފ8%DO{<xPJD\"G&ԙFVZlֶΉ	!dT\\/>Wa|\nGI\"<ľPK(+$k<Tʀco\0L\nP\0H(\0(\0$\"(\0qLMLM2C@h\r2h`#L0d\Zd	1F142a4\r4ɡ@c2bh2di2\Z@iC\0&jRoE@P\0\0\0\0Q\'A44\0==M3MOBDFXB%VZ	dSTeTad#Bij$hYdjեŖYee*,ZjiiKS)YYi eVY&eQr T2VLVMWUɧ$^\"I(/(T*z+9GбbV,Y,X\\bGl]~e) uJI)Q~D+LVi}ɦYe\0z`Tk3o}}_\ZR*!hdT0\'EGEG	GΑB~b^ֽ(_څ\n?qE)E!~TIԣ\"\n?4 BUG,\\,]#..],]TtX1}+.-.Ӵt]$tU.+.»rK#p\\IYeN],,زt#.dv9FXGk`Wu.tS괺Tv]i]Wj]..wЮKdu]VXYr-,,qpYe,Ye2eڱv,&4ƜW&SLi͍M4rrir,m4\\\Z4iedM1jiiarr&4M1Ô9999998riM4\ZiYqqeQ~Jp5M45L\ZKJԭҩpiabb˵UXE,ZK\'K#A9-e%9+Yf\",UՅYabbbIadŖLCD4Sa\ZeV-HtYqiZA9rKu~U@_O2]	yyyO/^/(A^P{!=bQ<W<OOv2^qyBa4RIzSґOOH̉<Q抏1(H5@ W^k_zBh_(媇y(^IG*=GD{djCT!\'^x>}vנ%Ľ\"T^%Wad|5_\rS#U/aO%/Yz֯X^G^I>=+/d\n^	p{ObdGKGCأT~^%G<\'\"y#ʅ\n\\^E^O\0/G\'<^\\\\#ħa^%/<Dx_\Z\Z|:δ:Jx$);u5=_+%{{<GeBԾ~°dJbMSM1YeUŖYe:5M;&954.	KHŋ.e#.B˕,	.(##t,UGXɩY`YbNJʒphŖYek,Xأ	.RLvMSMN\ZjwU\"t#,p%#EJvZB	:NҋYQFJ.*;QʝR\\Ŗ,%:(BQQʮ-,Z*5\"eW&u9RP.TwNdTwRKZTEG\ZȨ]ܤ֨@:qJ*:\n1+,-8ЫS*VD鐸JWNAS!r*9GK(K,U0SRr)-;$²e554je\ZEqPqFj`ꮋK-A:jnCEd\",%J8G qzaWOPWZYJRUХdJ*U]HN\nS21\'RWҰ\"UW*^UP?i~}eK/T\0W:U#KKe x\0>ݪ\0~7_S֪GDOKF,E4-(d-\"TQd҈Ȇ*K\nSSQEEQb\"QjR!1dTdTiJ2*4R0b+**AdF%XX-_K|N\0f=׻\nvU*DLN|$\"N}\ZZB,(-U(-hEEZYaT\"M\Z(QF\n4FAi%Y\'OpDTt,NЕS(=5\"DREz@.TDˋВ*_|/\ZJ\'%^\0|J\'*T-=I^bYLKX%dIXLS[mftJ\Z*/u.>\'Hp+;H%//1AY&SY1<%>\0j`\n\n@\"(*!P	HT*\ZddɄ d4&\0M24ɉɓ	@h\rM\0diA&L\ZL48&&&L&!440h&$lzF oQ!M=C))Sʟ?Do*M\r?*<T1&G>ZdE)\n4j!YhLF%1 R0U#ʌZ-RlJUbdT4e#YeFĩYe*23)IbYeF%jj-&@jd ,JhcU!\0*QщQ)ю	\0}	EYQQXAiYbŖX˅ŋ,XŨ`ׂШG*KV/CŖFYeꤊzL\\8	>_\"?R\0U)?|\"(u(A}(G*`S_ݯM{uK\nj\'HQxP_\"}JGآ?9P*U_QKSZA::(Ю\r9c;]-;KuRAr;G)%SpDuһWIpc]tc1RZ:EvGPrMY\\0]]ui:WB;.0밺XXW\\r[8.,YaebˈS4pinNM2˥ˢ8qWYe,e,YeYW6Xˋ,#YdqqY-,YdeFX,ŖF],Yb.FYc&rrrr\'\'\'\'\'\'\'YeŖYeYeXˈˋ,\\)q\rK,#whaÑSXƌcI\Z5\\i2\nŊ4VEs%9%qXb\ndqeYabŅZe)ph֍-\ZblF\n-*ȋpK:U0*ŕYj*de,E9R+B>r}Ҟ/|g+t{{4r%)_%)j=q\'\'xȏ\Z<`)<P*/(T(/D*GR<BGx\"x_\n/_	\">4\"{ԥz%{P>%S*^ȯ\"yy(PONS]Wy@ ={H{T{jOjS%~9ޏxJ֓Gz^z*=B=J^=T>9/%i믈G^1xGzGƉîS\'=1TJxxR<	<^tyx$PU+OU%*/O`B^Wwwq.\'0%NuO</G>R}p^r{{{o=	?qI?|i-*ɍRbp44Ƣp\\1cq.F:9ɍ\Zdʓ9Z64	hU],r\'94ƦhLGjr\\FZH9Aɩav+&Ue*]\\GQ\\F,\\,\\tҪwYei554\'4$s&h]CMY\"rt#QvXB JUHXZNBuJ-\nmB%\Z](-\')EÆ4EKTESPJ⫉&)K$%b\r\nHU&K0s\ZG+Ie*9Ye*].HDbZ2`(dQpb1J\\Kt).VFR1	eZ,,+w\\wĜIe\\)tY\ZFYU]*UhY)@,#\"RNSS_A8~sZ\"\nb1\"\Z$MT\",5T%\\?Jy!U\'D~JtxPx	\0<W+WTȯxGS%J]@<\n@>褀}/jy\nI#	J^FKFbeKDVa4¥Ԥh)S(SDSDS*)TȉHHHH#aPV1(©0UꜮ{]@=g^Y餀fuCVB&}#D%<QI^{ueChMUR&ZDiZIY\njU5\nd)PZZ\"e#DM)R2ґQ*Xa`ʨWI	0\nd#Ȓ;W^eU%/mBO:=+w(BaR^~餀}Q^j֒|<DO(/,O*`0X,+EjSDe,T*IhV\"\njG#:+{#鏩G%ySI+;ǞJ^ГIPVINRb AY_	O\0/ژ?\0 \0\0\0\0J\0\0\0\0\"\0\08&&&L&!440hqLMLM2C@h\r2h`#L0d\Zd	1F142a4\r4ɡ@`UI6O~OPߪPM4{I2h\Z\0zIḨ)4\0\0\Z\'z OP=_xdR4bJZ3Ū+-ABiH%F	!,L5VQVYő,#Tŕ*KX,1&,,%S)bU0AYeC,ł)C,REC(qe?3�q$1?y\n8XAD}EYb/8X],bG3ev(}DR~$SYe^.YeR\0Tϥ~y~H/JqJx)U|!I^(qQrEE^BRw@NeJ=H򒇘󒧠*KEIU>YK\"Д\\ERy@LyG(}H*z\\/d}eaWedK#tuQbk,Y]e]+uŬ];..貖YtGdf+Ye\\˥GR]Qr;+Bq.;.tY.ieawFUb\\].]],]]T.\'N˅.ˋXYpX8pWJYeYeF\\].˅\\Ye\\-YaX,,YaeŖŖY\\GYb#,2ŖYe,2bpYdeXˋ,,,Yqqet_Y`V,,$e-TH;JvX:\\,Yv\\.,eFXip8ZF,ةքu.pX.,YJj2#,bńe5beŢ*E!p-̃daFXN]jYaeXXw: q}\'X,3S5,q;d{JToΓ5j,3*E-[XSSX	Qa*,B	I\na0J 0J\n-M*&FE(AII($h4@h4h..^^^K];.b.P]WA$(%T|.VEdYBd-Tj\'ȏ/Qy^B|(\nQAI$ڥZd-؍GKW=%z	z\\Kмȧ/\"W\"O /}qp4b;^r80#/x{ӥGWU6K\"j$e\\M7%7)nWmw\n}ňʱeaqeYeXŖYeYv.XYt8ūJIŖXV/ʎˋTeX2MŖYb*.#dn]RveeW,YŖ]b˵vԙerʲ1j9U.GGv,uJ]Yb,FXjU	Ĝe],$YU\\*,Eʸ2svYNj$T\\bN+QeB%HY]⒎Y`&dpGQ6FK bŋ4ةrUФ(i1J6Uʎ2ZGRah	UuIGNWu%сh\\-YEޑ9IH.(.rW:HbޭICUZ%KYe\n)\\@eYHQeXXXee,J&Ib8\\,,YdYVUXF%228G )_X/*SeJ0A\ZʕVR^	Tx0iR*QQ_HB+y/]%.U \rj:#\'HB\n˸!yԀ?\0s6oJnk,X,#\")ĆE,I\ZV\nLR,TZ*-JH%ETЅIT`F1(bb\"J#XX,t_\'u op/Τx@]eec|dE:.0֪&T&Ld#@QbEE-*,)4BL)4`&\ZJ2P# 2PS 0%L,ܡ\"tR\0EKPjTGHׄHPv_k9PEG%DL\n*^yԀ>y*\"z}\'{b5 \rnJ䨉BGdX,R`IFRLC333*_LR0Pxp|ω}J\"	\Z\"߀8\\*^Te5/S@Q\0@\0\0\0@\n	\0\0\0\0\0\0P\0\0\08&&&L&!440hqLMLM2C@h\r2h`#L0d\Zd	1F142a4\r4ɡ@`R{JdC=SjIP3$ɉا<M\0\0\Z&@m SM76 .UTeF-4PLZRҐ\nb5H&-TaI,L$bXVa*1e#YeFfJ*,X&,YeYKBe,Y`VY&2,T&)H\r1%CRD-u\"~?.THQL)*ϥ*GTEYb.GXe#͕GIaHE#+S,/,ڠVep\"\'ȧlRNPEƊ.DQl/*MH\'G?Sӊbp(D[|pEߊ//Hߕ\'-BsPO\0Q*OU\\hG*:ʮt8Y~Y:\\-N.G*u:Y:Ihb#.vɡi:N+v\\.)%\'ʩS:N֧DtYK,#WKN-2)v,iCv.P̌8:kr;)Ck.\Zjt#.j]\\].atv8[UԗE55t\\\'kdt.,Yae1eqeN-qeYeYptt\\.*,a.,eYaqYaeŖ\\515l#,Yde#,YeYbը˥,\\#eYb....,,,,YeeŖ\\.\"IZaeY&F#)i)!WtN&GS.Kښe2`5]NMV,	\\*)qKHTb9NeFYebŢ2)Ŗ,45SST	r\\95%QhjVFa-JŔ-P:ˋUeXqe,,*>\0J~E>5kYF-e>(Ҽ<xR_/GīKz)S)zH)UWBE(E^Rz\"\'BzG zUj1DEF ,E\"ERb1A0aT0@T=={/zyx]ԎSB࿦ =4*x|(|$|Oړڼ<)^\n{^쇰^=k/m)^PT\\/G#U{I>\n_^S,ugVu6ѷTK9YqKR)qpK^TȗUyJ<<^IGSrr1<;^t:^e)⧊^+i<W\"\\7Vh&ehܤ&ѣwke6)LFХq>\nd?=4M1MS-2L-4,ӹʝ,u2ũ\'qi-Od2*3&YbRG8l˹WjtGxeS\',5Q\\Eqbdb,U8k-,wQq-+#G\\,L]U+2YeD]ȜIʩ.T쌲ZBNj+,-Pr%v#,	]CT*F.d:,!jE\Z(PY-PZG\'&Z\Zj*hIr!djT)jjjj҉\\*LST9PTw\\TuP	uA4S#!s9RU%!tbG\\W3]Sj)\\Hi̠R,XU;[-.U2UŅYKRʗynt1MIh*t\\,,YdYVUXF%228G@9?u=r+&iT|*jV2*5QCTPX4UCXQG𴒊z=g)A_\"|\0<!Z\n+i@\"y\05\0}O=I<B=\'ɓCSA1MIH\ZLUYS%I2P((((dQi4!ed22\"j!2$b(CU, dQS`Om\0|wۼSy\0f^$.Ii(}59F&/p|Myỷ2Q1TZ&@Z(QhE-*MBiRj	\ZePF ePS0%L,Q\"tT\0uH+D\0YPRB;Oa zD+ڝ\'؞W  	NOR=O@!\"{>=j\05\0E$O!	 =tL0ZSjJjFRLY331҂T/XY8_+O>B|(|#؞	$O4 A_bLqI\0J|O*~\0\0D\0\0\0\0(U \0\0\0\0\n\0\ZddɄ d4&\0M24ɉɓ	@h\rM\0diA&L\ZL48&&&L&!440hQ=S)\0\0i\0\0\0\rU=O\nG\07=C?S\"$\0iKF*TFJ1jʠ*IPLFLF*	Fa\ZH`,b,FXXUVYő,#YQUX)RŖ,,I	TXUbLeYEJ*bLXXPT2,*\\UP_IH;6HUg*G\n|Yb.G..,b^[6WaD5TЩGR\"B_D)FYe#,*UU}\n:zjx%<ԧ]D=1Uz$%J/	((ԤU	(\')QG@}ȿx_zЅ?@/_((4\'BJUG̓Iq8~u8tXt\'KT\Zu\'s,Y]ap\'E]SeKw@#Et]]e-4u2Lb˓-u9Nt]hvGBMji0v.vSvZ\Zb\\Zvaqt8]r)t\\wML۝dt.,YaebˈZÊ,,],]˅\\Ye\\,e,YeX\\Lb..,eղ,.#,eFYb,Yteqp,2,Yeqqqqqqqqe\\YeYeYe,˅辡e9K)FXYVIZRr8vddӹp4-\r550hr.,Du*)pN&3TÅYadeXXh%9WS&S&Zb¬ad%\"10*ŪKX\\Z&UYK(Jާ*r9J9%9)r.Oq-cL	G\"uG(NQ.A\\>WQ}E/T))yy\'Uy)\'BJ/$J/4B*O!ʂyRDy <^WTxD	QxJ/BT\'	*<(	S\'N	*]MkY`%V-+H$UTȱPej%rMı)ЛlHEeS ܜ/.#R	oI]	90\negK5--5i5,*e#*L2dIY,QO	|_GGe/i7ajfٲzXrzzUffXTlIZ1N;J5NGJSKB+_bU4\ZX֩ŦZiYd!ɖZevSS.ZeIʎLSô˪2MXG85M;*NiN82+,#X2bNQeNฎUE#łwEpYe,E2ŋQ]8IqI:*aeSҬ**`ANqdeI\"贕8*]#P*tXҔqQF\\tNPX%\\Z`QS\"L#IGL\r&HNSSSSHMf)®6eeJSwBe)8jrd.MJsJ)eUqHiNLѨ*ӖŒ0Wz.G|*a\rb˘B,ŅX)[] 04i$V#,Ye,YK\"GIaNYUV*L,#\"b>\\_ں^e*LUM)aQ6\n*	 \Z\\_it*=\r@2BR\"dW)UW$+&J,I\n/R5)#hHV]RRMU|.%`[VKIsRִb\ZS@d$DHZT01I2bQbQbQbQjbQi5	02B`2h(Ta!#KbT*-敩pqk6izlUYcQUSԬU0v_p,|N Q\".)#:c)Zd,2\0#\n,EY(BRD-!1Rd(M\Ze 2S 0%L,RHݔPZ\"\")#Yl(E$N$o-EGEULdUT֤Hq}(+_(+ڤH{ֽEJ)UWu)\'B\"z	\nA覨iMQ2jJeFRLYK233:(W Q%HW.//@II!$MŒBi\nPVIvKw\0?	O\0/ژGR\0\0\0\0D \0H\0\0\0\0Q@\0\0\"24ɉɓ	@h\rM\0diA&L\ZL48&&&L&!440hqLMLM2C@h\r2h`)RziOSoU4M7=4i\0\0%\"Oz*~ʞ\0\0\0hQ\0MOݪFDCBŨ*2d#CTdUBʰ!	aQ!M4ʦZYbLV&*ɆMV,,ETYj)(,YiDRXX	,AP\nbeTIeQP*YrJcx|9)TJU	RªxL&p8Xrri,Y~R@ުFHG*KU&FX2,N,e_UK߿q.2j\nvJ.(^<U*>\nUNjNSQsRO\0@RĔ_PRs<h?T%R#*ЧhGR:˥tYtXY8.KAtZ/Yt.pb4;F,Wkp%vb19U;p,]*貖Yt.\\YeR-:Z\'eJqb;]]L.tL2]ZGe\\FUػN-5;\\\\],]*i8q8q;ZqbdYq.,,C-wYv1u+.\nM4e.,ee8ZkUYrb52ɅZYjeSM4іVNXZL4VZqqrr.N..N..N-2ˋM2,,2ӈˋ,\\J!e,4԰K*Tҝ,,].,].e,,Y-NF-(\\\\,+.p!4VQp*nM\r2Ue511ajJq,YLYeZ\r)ɪ2LU%Ȃ\0ŁjXVVT`,hе-\\dsbSRU^iTSEFQh[[[[]д\ZUZTTp\rEEr9b`^z[ꧼ)=S@{IT/rQ{ܔ^)=OqT{G7\nqܢer$S*,YJ,R\"E&@JFdFR(h{^^{k]N.)U@/2+\0||_5S^//Q=/W^t<z\'J@TQ>P(_*G_^k엪G=EG+֪zzT&E^e\'PJy<<׈xR/\\\\#\'q/@^z_myy/Z#*x\\G{OZ^Լ/	>)>({<x5s0q*lبKavam.Tu/jX#\nejYeYiU8,L˵ʝ,eŋSS)N$LL_ˋ]TeX2M9e£i]\\iNMFYRũ-0b&,\\sbQ\"E8XX\\,SCeW*iYe,UvpNRtY*aeSR*(!BiqdePuKT2]Q`SJ-US*(Eʂq(AeE\\Yde&!j	p\\,X`&I&&H2L@UĨw%.Te,ԩXEVBmQ8JQ,g*WSAbKT]HWK25ZeI]3NQ]W|U5\"\\%ɖbţQbY+q!)81\\$:-S&ZiYRSr++(ҚH#pXj^eȯ԰J:T)DLTdHA0K\0q|U\"\Z\n>FU/7ƈ?K/DtXT\\/.<DT@y/5GU=.,YYCU5AL\nЦFTTJiR4TRa\"BĢĢĢĢEES,()5*j*02*2ʈҒªF\"+/{>n>]_ADyJkYdD~a},}TE#<1L(SRLFI2#%@QdEY(aI4dFRZDhS%VEdSRH>Q\0tJӡT*b\nP2D\n~B>P¨ت\"eDaT=(>Ȫ\"{1}о+\0a #`\"z*FL\nL\ZS\neFLXffc_rTE*Kɋ.>~BکU#|[\\%A\"z_U/1AY&SYC%>\0j`?\0*\0DR	QHQE\n#2bh2di2\Z@iC\0&\ZddɄ d4&\0M24ɉɓ	@h\rM\0diA&L\ZL4R\'?RmOOQ4\0ޤ\02h\Z\0zzzO)P\0\0ߪi\0\0RJTd(^J	*1bC#,Bb+C*Bb1Tj&&)(V44,SLe,Z+CMdV1e#&ZiZ\Ze,RDKM4J0%LUVIFYe\\APh,X)HU*E\\pJkq%XTW$5\\R%FDe,\\.,Yeq2btɦ-fIUtWBjEeey.S,-4T\0z힛xOfOn{J~J~@~ة?t~E=yT҉{2~?`\\}/D$yOIA=(((ԓ?T}Q+*b/ΗeS̏W_pF]...Ҏ*}b:.Wspp\\$,.֧dtZYtGpfYew&\\Yt:b2:uU.TtXNUUaeԸu+wN2N.W\\&ZNC\\.]ܫrp\\M8]M89452,,M2XptrirbƘM4re-SN.LŨŖY,Zb#,VjeZe-VYtNN.\\F-228\\\\\\\\\\c.-4,LŦ\\-94˔*:/,\\U%iX4\\9)vabpepK,eFXjdpqdb:ңbN9ȮMTiT\\,g%*jp2-C#LŁ\\\rLJ)db,XT**G,MJCCHVZ#WER\Z\rLUŠ\n\r\0_hRwT=E=Qz>>_ =ez|H|үX^/PYYS\'kнT=%=TJ/e(T)=\'U(Gإ=/dOSĒWU<HxOT^*xW|hG>%/^^zO7wO:{ӪuP/= i!*_DKG{^_JbK+sx.\\#G{^/OG<CIW<^b^aha^h^51<b*SS{ܣί:}+^+yD!/(/$*ȧ>=ׇ^u<$Gz/0z½b흢	vx+¢O^bz\'|>:jV,YeYeqYeYek:Yaeˋ,*q\'Ydjb츱eҝF\\I&XTp!+v)-UJ8eFX4bKYeM0.\\`(J`ri2+,M4șibԎK,aebiKdEe+MZrDrJW&,A]`ʎj)l	Z9bGIbUҢ\"ҹJ,E;arYj7y̎HuPYm&Hบ\n;e0ZQC	!*ȗrm rUTdK0CUVZ!.	])G|T1MhW8W\0iSS(5B-ȗT#Te#)8-4I2ũiE\\\0bR%!-Q)S\"1\\E,.J\ZjXW(5FIbCҧ$5X8MLGuO:\'Y#SR:A^!hQj5)$%\"$UYA:Uj	IE}?vP\'uؠ#iT)P\'O@WDo@?:HS@\0~OMuUW*\'bő`eEV\n\"e\"QI\")EQe(e(*eAdb`T!ZXR1J5bR\rB1Jh)i2LKwUW}y/! tCMUQecp-I踪Gtǐ^K%2LMI2$I1FZ(b)QL*`T5I1Th)F*B2h\Z0hI_LUU]TtA2TuN@u$էE{WZ$J\\IKNN\"	ӻ\00)ymO\nd\05\0<+ׅIK%.=uҺ餵LȰX+\"\nҚ)UY*~pFJRb||Ϩ1|\n>jHeR>rSIK	\'1AY&SYGW%>\0j`\0B\0\0\0\0@	\0\0\0\0 %diA&L\ZL48&&&L&!440hqLMLM2C@h\r2h`#L0d\Zd	0A#j5?J)TzAi~#A\rM<M@US)C@\0\0L \r\0\0wĕJeRQEL1e*b0#$	hDi\r	(beYje,Y112Ŗ,ZeX1V&iMeL#djHXZiUVeYeJQ	U4Q\nHblB/Vؑ?eET_ҡ?a g	GԅhE5\ZXtrŖ\\YXr,Yd!\0HTʔ}$\'E2fde}v\ra0` $Waڼr{_Я\"Kވ?XI~ؕ<J|JyESA/\ZJ_~PdJ>!TtGr¯1+]W*Wq)Dj4툟r0y@d|j^u\'\'ݙ<O\'&&O&.\'ɓ<L0i<5=,Ojb9<t94%z4X]*zG\'jxGi{EӦiz,2j<Sz-W<T\'Iy<YYN)z\'/LZxdW{N)/IN^/Q	/S<LyN/Z.\\\\bˑL]591eW,ۗ,\'՗¹iʺeYreSN]1iYd2S,-9tZV,,YdieYe\Zi˩rt5LS,r˗.]:r喙r,,LZe˖Zu:JIi`5: u)#\'&\'\'M2iL4riɔ̋Y`2T8\'&:S,deZ,,ZC-(]dCU12-*dʚKtr`XV+HajiC`Dʱ:UY5\rUjeD+TJV]!t!tNkKUҎ+	^\Z:$t\n%]\n=4^)kKU-JZЭU\rQKXP%Mh։MhMh)$OQ>jQ>j|WS>\'P|\"|UGR/\"R/U\'DH	|>*%|T\'29bn|EbE-m\nJi&hQQdXc,ifR8*,Zu.\\dL2\\tJU*S(W)UHjdf3zгL곋4L3f2YC K**T*SXԳx}:r)b_ _!_)O?\'\'ןL8Mds:3ΥbXKJ%-)-(Z.|^*d	i:ii馚e{9O&y4ueœtɧ=iUN-4Gm\ZhzNQ\']\ZZR]Z`ы^V/i\ZW-b3lYjGSJ#KC%L{QpzYeeST^G	xU2ʽXYd<2rTH^\\4uHrxi)T$e\"iH2\n2rU1\\Y*:iQS*&j\'&L5\"jDԮU&0\'R&\ZQ\rJN+ݶЫx2!ZC\"V^r9\nUyejd\"]%xjVTWWRfK-LYJCTWzW*Q0^^,1a1ajbĵ1,U{uP򪚓Qe&TXY`5M+%ZCC%jPU:Ft#DCS*}O\'%i\r>ThTMJJJ)F]>yT}\r$ R}H z%2 \\\Z^cG_S\"V7{$RAeqAⴗ߾\\VK\"W\nTJ]Vddʱ2D­DT4*KJ&DVSU$EEEEEB\"*iAhb0bDDDԪ21j!FUS2J4,\\rp2v \"n[T`IH^kܟRbh\"^\'%#\Z	򚑨dMHʣ\"jUTFR,E)R-PYHT\"eRjD\"hQ0Q\ZJT1CI)m DH@H蕽KEu$r{%[qTJX-}(d^؂ZT̈́RK]RqXA\0@vҢRD	*1SRbLLIb,6GuJQ$ea--^x)iD>\"R\'ާ(O$Y$e5w0.GS@U$A@@\0J \n\0\n@(ABBUF142a4\r4ɡ@c2bh2di2\Z@iC\0&\ZddɄ d4&\0M24ɉɓ	@h\rM\0	T=?T&#T\0\Z\0i4\Z\0=Ch@U4B@M\r\0ߪOSFQ\Z\0\Zh2rՅU-ZV!Q0h5R5H&U-Uč&+BVej52Ŧ\r56)ɦMV,,+CjTjiXjiYaY,-CR\n,.\nEC,)\0T2,RT9*\\QS_?PT*H jzW/6ZZX&q28XqriXUDEv^\n	QZ-0eY{4ZiIQ>\'of{T*SO҃SP/BH)STT O~*?(H\"_x/z/?E$~ %/(T\'{WBJ~	H}K#.C,]#.St\\N%bE,t.Wi;Gʸ]Ev.\'S.NEWKs	8ICK.,դNV,\'iuHe2;.MSpG]v#\'Sv]8v\\#]\\N4rM.\'Ei)tNӋedӈ&e,M0eˉ\\YpKM4ӅM4rYeLL˓CS,qqYe\ZdeZYede]NS.)e,e\'),,M2S-9˅*:/,SYdiԵF#SpjN,,],].\'XՑ,Yq28gK,\\V5#h,+,SC)h*tYb&\r2Ue2bja\Zj]M+CZ,\Zb2eS&IXIr2Fh0`ZMQd0UaebhdbZ1V,Tꊏ!\0\Z|5:s֋+Rck;өNyꓼ#I#Uu]P9}̽ETU=BE=PU)=JJ/PE(/UI=P\'	ꊏPz_q\'SE$OA#^QzH/Jz=*JzEODWט\':^j$x)\'JT/lr \n]):(ԝ|Wxx\'^K^><>>UK/zޟiNtGƥ|j\'ЋG<b/00RxҞ2X0(^E^$xxʞ$0^2O3<\"yCȾqp\nľSH/0/j6xW+GWq/(y	^Ϥ}aSBS؏\')Q꟩Ib2Y`;ZYeZeN#,,rK,,XS8#SGeŋ.̰ejrje`鋴Sv)ɔC)+\\Y2Ŧ2jidPi];\\i2S\\SNCQGSuE4M52M5,ZQ+J\\B+vL&N\\d\ZiYh !B#G+,J%N4┌q4IkTSFċcPQETpQbaqqeTJW%]H-PJGŋ\"M%ʒb]`ňԸѕQt@VUqR8S	*:Z[j\\ETh.9+@eSEėU2iMEex$!UL&LLXj,ZI]QS	5))biVAV#)j&NCAq#C#Ő~\\_غ^Jr2)`ĩSJFU+4GqwZ5!^\"ԩJ@=T%Gͼ TӾ%Gu?Hz]_`TrxTTzR.˲)5(>k,X,ʦU,QLTh2HP((Q`T)\")iI4EQM\Z$0HR!,__UW=>\n@5yd .si&|Fq)׹\0%2LLe4XHEXQd\n,$5I5U	UQ#EFjS@2+EL,Q%..|$TqpJPv\"Wb%sBDIKJ=8O\nW}̊Q2QHW|U{D|bUUװE%/))vĪ{4LS*+Qb,5FTmR}@PJHWA|T\n=\"#/I槁*>2Te5	]P UwS@Y(P*\0\0\0)D@P\0\nRTDqLMLM2C@h\r2h`#L0d\Zd	1F142a4\r4ɡ@c2bh2di2\Z@iC\0&jF(?*FRz4\Z\0\0\0U1<Ba5&\0\0Q<1\0i`KTBeH`eJ1b	RVHZ	\ZI(4\r0eX,eZ4X1e#&i\n54*ɖ-ARd&eF`bA&i\'IPQ2be$T4-4UJ\"DɧS>Dq/	\ZR>\"WB$OdŖ,ZZqb.SUɓ,Y4ɪfUIPQR`CM4ǋS&,U.*O\nQoH޶\\WYvhꋶ)w\0z4UzTQ)S	NʥOz.Q?!>$}eU}Eމ;/){+UwQ^d%WUO|J|Su\'*\'ւ}{TIK~jq_d:\\..)-%%wMtK;.t+qt;].tNӤjtGTʙeiɦZeNˋ.GTv.p;C:Y&ZkŪpNR;K]pYjwN˥]pN9v	Y&ZNCN;v**8\\.MSNS\\L4e]M4M2CL]sE\\q8W&Ye;w:)LeZaiɦ-4r,LŦFX2ŖYi\r0ek8\'\'M2i\'\')reeiZi[ɦN)Q~irFMVX6XUҋ;vbbq52t&je54t`M2\ZVbi`%9Re*pFZe-22-P\\],#\r)bȚTİR-U`,5C$Y1UhʘF+E`ŐdtGݟzT}eߋIrU9K+ȗk;SH*䣥#%R+@}H_dyw%8s\\¯:Hb/2yR/0*O2yByGU^i)$R]Zµ։ZʩJkĦ	jJZkRV\Z-I5q\\W\ZBO[/=+ΩS榑v@xrMJ*\Z_|h)^m%Q	^{^ূ^^z=i^putU7RJAԋ//S.p\"[8*!p\'%SL+܋ܞT!O*CT<U<aG=Oz\'CK*{Q{J={S)+Է^+vxN{^ƫWioUoJ]XO/R|\'|=q?N)re&ZaNeYi,u7&\rMMI8L0eӡwM2`ӕ8Yji#N)X*u:0\ZqeiT+.M\r1e&jeŋLM+&L,)hLV%)\\L.!d&Zq:Ŗ2abŋ*0XQGr.JYddTv+IZh.(\'$!BWp`ŃIR!YXV	M,TPXUSEZ*NL4ЩW*TF%#rjjDD\\*MEք8S&)CsL:m9H5PhfPrQ1.5\nĺwV% ٙbU3eMҗh&ڌV.4,dpБjjdtMХt\\YiYjb-9UdqJUY,F2HQ&MLL\\\\tJe\ZSI2G,Դ+%d$C%:&а`JL\'rzMATS\"SB-Ri(\nZ$\r\">iҔTz01\n?(J?	H]\ntJ@i/	^Q*ʟQ?r	_	\\ON :ixӾRn|<TG\nHS&)b)bT&B4JTXPXZR,R-UJEI&&*&*&DLTM)F5RH2U49:%Uz}}\'zdeoށڶI&WiSÉH]\'xe\'iFdB,DbE-R,L*BX\"bʉ Q0L$b 0)R6D\'^*	]uT@7\nVJ.\nz^DN\'@xP [URŢ)%{\"UW=잟NO	UVU_#$O(RD )5F1&Tʋ\nYT,H1BWTiPzJӥz	\'TzԨ<J\'<#U#1AY&SYj%>\0j`*P\"\0\0QE\"*PUQRPqLMLM2C@h\r2h`#L0d\Zd	1F142a4\r4ɡ@c2bh2di2\Z@iC\0&jT(JiU\Z\0hi\rSOHSByTS54\0h=@U4 \0\rK)\Z4֬\Z44Ғ5Z LU`2$V*	TQHbZi)C&!Ja\r44ɪŖ4J6XaՋLɦTcSLZmHŦBFZeQpBT2Ș-0Zb\\$%,*\nkO~3*/ĄUgUI]M\n~Y2j}ɓM8,X94ɋ,Ym.?\0H}#A+$M\r5Ye^.NLZiGl>k<Q}z*^(UU}D\0=a)	O}O\"^q)|QD	ԑ%UQ=ڧ{=^WQ{%R\00D%>8~zR}TPO??A}\'W\'XF]NS\'EK\'9-NRrS)Yr].Ud貮].ӓܕq4t]EҮӥ]u2LWdӓNV`MWEPu2i8K\'r)ڣ&Sqr.pwW&Na:.tr.q\'ŉN#-1NM\\qr.,,Y;s.u\\YpNM4etrqjebr;-0qe&-V4|NY`qZi-VKM1LiY`CM:\'\').%&e-89N\'\'\'eŦeZiZi.,rGE4ZF41\ZK)ND\";-0tZw:e\\\\,55U`\\*D4T\\#ahaYhزbdʍ29:-VLhjMV&	ZLLDƆ&NTⓁV,BhY-$Ҭa+XL\r:QW@+K]J]j.:y7O\0+Y:֓ڨSQ֑]j/~yOR\'Uz\'OQB\n/P\n/UAzI(\"z\'=R\n+/UAG)z(@^Ҡ)I=\n\'I@Q;US+ΗxxEڧqOQUO/|N{<U2h|A|_:m;KvxKvO yI\'\"q>3_/b|Sثb|brӔӜIWI]\"|NtttD\rJs.juW58Sʉ\'<Kุ䯒ʤۇ\'<gx3CƫĞ3u:^p^3OGOOQ>O/>?_S=1eV&-5.Ը,)rei]))KNTre~Xvu\'tMML#NIKWpCNJ4iC8i,55r˅MM92wDһ6Xihj\'qNhbH\nhvw:NbꆚP]Uri2,SMLYģQKM5.X:tVYVYBp*]őG$G\'QvZSU$jtet(Ea)⢙UMPL`I\\-H2\"i)K	bP92TlN&hf\Z9T*]NU6$*jCā]PMIeT\'2i3fiSZ\n$jAeM4Ҧ2dVBq+jJ$rV5FLLXj,Z\nB,+I`\n.ENSuEw8KQ1*JpYlCTGDpX^Kŀ=RhI**\ZXJB8ȅ\ndD1+U\n?q? =T쪑߿?OTO:>x_]Χ=\r䧭{y/{IvbdUXULT\"M\")\0TȤ\"`HQePQh*eAee)5HQ0D\"`	RF bJBīE\Z//|݂k>^Uݡ@qjs@],D}1pAFp<]1,4SJ0E4&FjaEEPX%S)K,JY\"j	&I\ZiCI+(-S$;I@t	Y()+;/yQUOkª\'\n<tOe9vQ@]$<+̾©*IK׊`@<\nRT	_p QԙFbQaML\rk3nRye*	^,\\/yt_^}(tGU$/ JJe5/:!6WS@YJT\n\0T@@)DBHAH\nR G\ZddɄ d4&\0M24ɉɓ	@h\rM\0diA&L\ZL48&&&L&!440h&)%3mIJP\Z@\r4SS)GeOOSz@=@U=O\"\r\0\Zix{p#RMIAъJ1jeZ\0M(a\nԬj\rah#\ne(`,CS-,5EZLYbɖZ`*L­ajcK--2,a)S!,2M5KE$@YdVi$iaq\",|w~T~[/ĢUP#*>,b58e&N.,d&fث@:T#T4M>7,ee^jD(Gz&|DtO(!WQ+*b%D)SSESA/TJG%G֠>J~ER\"|?}\"O)䪟%=ؔSO$OD]\"}Ƒ~/jRV9?4Zu8:LNS\'ItVS̚tNv;-b:&w9;NN\'e.st:\'ivtGIӢ;u4M2bˋ.B:NjCu2:M2tWkŤ\\]\'K-S-N]&ܸ]	Su.iԹ+p0u1eʸM91q1aɦUɦiYhiidM8.&-MLeŋ-4cKM+NMrriœCLeUpraiZV2Ye,eZaLLN\'8.Qe\\\\.K92reeiZiYN\'Q}PZ-40f0eXrP9	ڇi&N&ΫK,KK.,8ˢ\r-DhjhY.p.#\'	)8ZiC#,bŨ2ɦ42,M,UZ\\%S,5KLZZV%e\rPȲVuL,,V#%diVL.h_A|\0һ|!|\"/}<=*OH#+C\'R\0*ܟ=OHGR\'\'E/DzTIBODz@z*STspuΒ</9\"/9\"P^j\'$O1Q@yO:\')xvڎ[wS^>_;ħqOP\"{\'u;H |tt^^=TOD]|}4={){|ʼ\'<S\'4Sz!Q<_<k֗evxTUڨDTʴNҝ*Ux<D<PUOg[]Ev/:YqrhyvR\"%#/)~_0GUꮴUWQԫN^«K\\üJ}${{{=Ox^=k|J8OLEL&NKL2\"rM4-4ӹ:aeqpbŁ\\*L0i92iҝV9C)#i;wW*;C9LeVBʲɖ&[j],]2]M2-TR;\\LV8%q0w;-\'Q2TtZZeXM0,2h)GpJ\\*NL]M2u):qZJE!qT8A+Tqa\\WBLN\n)#)TMDԑaTQS),P)aW\"0ʉ\\ieLRd	RP\\	0yGU*\rVe@dI.\'(tTw6\\%jC*	KZP0\ZbhrRTe\Zi54:`LĕuN-51j,1dA886#)JHMLLN\\:FLS`֦,VSNAR+I0sJSdv3BJL5GIL(X&5\nV)4HNU(j\reTWܱ*Q)>)x#x8^//K|:D%>\'J{*(G%%\"1</Qݽ/◍xĊD]NLZ\Z)h)dV+bI%\rQS)I)REE\"\"B\"*bI$IjjdiT1*2T#*SP2ba4	qt^z)D\rg[]*$?U=zСF&pDzQ>Y5\r	0Bb&@$e\"R-$YHjEZ	iI`K*K\nH£IM@j&vR\'O^r\ZA5^#DvP\n=ȩ^I}z>\nwIDRWxKi=i(-/a嗍w\"QzQ	H_:x*LF&IвMвS\n`S&J3:J\n4R6N\':O>\"{BzG>z)O_e5A`+S@Y*% \0@\nT(D@\0\0$\0J)@(P24ɉɓ	@h\rM\0diA&L\ZL48&&&L&!440hqLMLM2C@h\r2h`MJRT\ZmM꟩24ު=@@M4\0\0RR*\r2&4\0\02zi\r=M14R$!j(,D&Ɂ0A2dUʓC%U,jQFҍ4M4UT\Z`M\r(,ddLZ`ıJU2HK,+*0ajfPa)FYe\\EC-RbeeRʨJYr%EOA?)%=6W߲\r|TQ	xZZZZt˒ÒL4ˬ[+	rA{EWzBY,,\\\\ZYeYi\"@zUHOkoj{tyـ~~A0)r,(_T_z I>܊^U/A^J=5\"O5Kr~9>B~y%ʥKA^J@{Di~!J~\"8~5eb\'K\'b讋%]NSe]#].ˋ]\'sҮEt]NtZYt.\\Ye4ӥ;Y\'KUe2;.L\nAڮL&]Ej\n;U;*wWNjtKUIrbidӕrieɥ8,,2䴺#-&Zk.NM4aSM,92id84-&]92Ӌ,2KK,eZk&\ZeM5i,\Zj˹G\'&ZrkIM2ɦNM\\rrrrqri954M4M4&g*N\'!Q9S+QQʲ\\*Aveŗke,,9],1uțP.#U5&,)epM4iL5X40Ud2LCZLC4ҵ--29 \\ɕZIK,I11Uj+de411L5YVJɉT}!P|t*uRE...ٽקtu:S+U\'T!⫪BeSO^5<BBD)=PST/TQzEAzA=TԪPQ\0^2\'KvܗjK.ЗbUN)Jv$KT@Е\"rR(U藡{N=uM.퓉}P*^;R|Gȯ*//xQGW{EO yK\'.C;ʮUx\')S|A{)x*	WxS\'MF%)EG!O\"ȥ)\'I>qp:uWp^tW}(+޷K<aĞ3=(zQS9_<x_PJ\'ٔBI>STK}0J_p_V,XZWXiU8,L˵:Yae2jbS8#+,hXN,,)L(SihN9NM2\r(D0i&iKNNٵK-4RiʜNLG+mjN\'B\\NweYe,hN\"!A9DrҎܹUĚhjtRtt,RE.E\'!BitiS.)H]8U\"ŰژEH*ʑbbqqe)MJLU&FFE#bA2$\\L0X#&Q	UUiTK j2+U\r\n+E4MAV	ɨZ*8tK%-5#kmLK2-,)-!ʪCT,	9:-dK$ɉSJdʝ8qA)h(p,4ť%iS\' u)w\\%i%uRtM*tLҚ:Ud¿*/]/j2*q)2JTX(U\nЕ`غI֩\ne%U}e	^O%Uq^//U䯬Q	_XJwT@y*z ?Y%U}ȿ+_Q$vbň\ZJM	dK(5RAMQUU\"ȡ)))C$$H&PLeҔb5RbR\ra)2Re8_ڒޛ}\'{O5%Uf<^$Tt-HH;/^>Z/{=Ly&I$Ȗ+BZULQZZe\"ETZXiM$JPM)\Z`\ZUY\"_aIU]ӠJT%{*#QU=l\"|E| USĒ&\\^Ĥ|A+_CIU_4I\"|X=I$$үeI%/$I\"{@GL-)``SiMJbY!+PJbxA}/{\"#\'yW1AY&SYȰݝ%>\0j`\0\0\0\0\0\0\0T\0\0\0\0\0\0F142a4\r4ɡ@c2bh2di2\Z@iC\0&\ZddɄ d4&\0M24ɉɓ	@h\rM\0*dS(Oҧ?T\0\Z2i4\Z\046@UOS\"ODޓQ&OU$1\r14NaUEbPZ\nE2jFM5YRɩUԕFUhjBbdF(ҍ2fP4M54MQAɲ\r2Y4ɪŖZ`µ3	ɤ6&(,YiE52Eia,.QCMHɄRidT%qTR|RO	/h?y gtiNdɓN:dNM,Z:iZJ̩W?=$UYi:d	`XLʊs\"Oğ~1GRWO)UJIBf$_,Hq\"UݪJI߉\'$OJP}Jy\nW^vgjz;d>`ʨȎ쪟Dw$^<D$JDQU<Wp_)0ʚg\"yVNL&LS<Mi<2MWd2	e/gOSɧ\'U/Uy<OS{4Ujx^M:iZ4駓UzK=ڮ\'UijO&LNAob=tz\'x{Oji꼔\'\'.:z99beɧ#Z2u2i3,-4OOW/rLNiהCOW-LMU\ZhNZt&,ˑRLiM5-4&iiLhiӧHLiLŖtqi.]:rM2iYeeZt2\\\\RMUi&bLFSCq\'=M12{92ibt&jɓU\'U(yH`4ZNeL*N)ɪM2ViɉT4ɢdM*ښLҴŪbb ]UTʲbe-2iKEjj\rEG*jYVhdXNBzD\rbqIĩƋzRzirXŴ\'d\\b22/\'b|O5#%|O*JIDHDP_*>JI$$RUS|>\'C\'T|T$_|H/>(|DO(T)]oɾ[ooKysߥW3\'rr%*,Mh6P6pW	N\"].ɹ7&:1mU913*Ud]Վ3UeC:p3.e9IZU6MZAiP\Z&i\"Ҋ+\nRd($ȃ*I,CBN皦YŘ\Z,af4ëV1Lg0XŊk\ZU1:zhFhSB7*Clʟ\'$iOXXWyj\'*,a2{4]4ɓM0Niiy4ӪɓCmVW&TiiӨsɦ莩,Թ<y#5#g&i.*reLLY㓦MV2zZiiM4GJ:.,ZB:\\X=b<{:bid,dʧE%${:MKՅȽORK,-UN]%D/\".Y`P/KU)ȩHE^RNETҩ\ZHM-JHMV5*=%^H-P\'dI&4J&LC֚xԧQ<MH1m$e-(ꗘtKTq\0\00M䗱	cM5DژVE4-LRԗ)F\Zp*:-2iAi&hNF#V4ɦɉLEiCdJq84ɓLiY*b1,NrF\n8.,Zt}_ؘJIQEI*b2J*XT4QdJ\'W֕R>WTU^d\"JQl7U̟QUd^kDntpE^ajO5\"tWK&%EUpO;fe:DFR?ٓ&&U2TJ\Z%`K$L\ZJU)IBD	,T,$ZTR*ԒbjI4ĉ~LI(IFUS*a`~?[Ң߷rٕV,)TyB4OƟu0\"L8D}_}_O1\rC5T`QTF,UM$Xi\"ċ(,H)$M$2DēTDL2jiAUL,\rhDs&EUDUbJU2%_pDkMJU9dDUr\'2\r)TܒMj\"a5ME[ӃJD߂u7LV\nuUJDTNP}}Pj\Z)0XR3ZĊF*$/E_}O%} ER_P\'%H	(+$k-f<nI%\0LRR\0U(%* $RJ( )A	TG\ZddɄ d4&\0M24ɉɓ	@h\rM\0diA&L\ZL48&&&L&!440h&\"IA\0\0hh\0\0h@))%L\Zh\ZiO\"D\0GyQ}J)PIAddԑ+KD5VIb5*ʱ)J4		CJVX,LUJ2m\n-K&Y0dLj-iLRY2iHlJɦM4MV`d\"CKKB)RUi\'*PdYbeԒPӐJ$QD¢NQW\")^Q&~Z/ui.,bŧ&NLeɓMLd{[b*j(ԤzlR?u]OI\r4NNLZi/$7*{?ڟ2}}ȟĉu%}IR}!~yDDH/U\'ʒO̒OTOJ>OҔO?yO`~*OȩI$_Ay$$D}((J~KG\'5_Rr:Nөiu::h.ɓjUN\n;\'SNҗbpKNtNj\r4u4M5aiɧS]KNpKCK%vtiSrrWR»CܺCܮM#MN8Bӥ0˪qr\\&.K:,8ťjiY.M4M4CL˩bɗ\",NKri],YeZi98L˾%,YeK)Yi[i5i[M2M4L4).M4ᖋ-Ye\\\\\\\\.&rrrrqriM4M4M4-\Zri?Q4ʸLM\rM#RbeYP*%;@bdq2jt.,ˉu5Y4DڅjĴJlP	p%ZeX,,LXe0,\Z\ZKF)k*bd6M1a%NJ4-QXDdZM%jU0+ed2ZKLd¨R$\'^SީO_iSW/z{!R%{b8z\'C^ثJ~y\'\'QI^tI yI/4y$^eU\'I<ITO1((aS)y?\nP<*IT(HH<\'yJ\'(P<OO<`K;n˲zg:Oo㞉觯Kľ/b^U]hJzQzaz%OJ{؞|	T^>:O^\'w	N\'tܩ{O/O	W^/@\nKJEx*x\'zwKIޠ)wʝ;|<!\'+쏋RKxI.N;ܹW\'<iG<Od*\Z{=_OO\')\"(PRz=ƽ{ߟp2M0;LZZZe.,L˵ĺYjYt1bɦL]&)C,2W*Ō8ĴvvN։ڑ\Zrea)\\Z,ZdL%ɓ\\;(dFiiMvrZMU)#+v&\'R2ғ]&&i-4MJe&q\n+vIijYit)u\'rLMrHq8BH)ܜXe\"trTJ$HKa%:IM@	Z ILAhiSBLC aJܥZXe.*(L&Lj$§l#IBN)v%ʪ$*\0Eir\n\'H6eE.4DXJmW\n]\"#\rQ	V5-2i!iw*0CZUsB\']LŖ\ZKKE-KBt5&I2JSeKMQj1y.\nDRԹtLR0X5HtK{ȸZy?̵*ȑ\nK*SE2MQ,R!XPUZqz˪aIVU(TI {CB^֟Z{}%UOt?AWHz^$I ~/M?\'tZz蔉u;M-,45-R\ZRʩVHIF@2TRIIJI\"(-E&*$$P$ LTL%U,P4S@dSru<_IUxz\'rzk$xx\0As%I+|c|ABMB/WI;ǴOlXeU,+0U#-bE-$ZAi\"ʤLM$iDIFLdQP4&^RT:\ZC*WT׺*0/0.DNO@H>\'$\n%\"x|=s4H=U씉KR%/$Uj^bdK$Y&ZZlgD*\Z!zTwdzӥz~z#֞JN|P(+$k(} \r\0LP@\0*JT*HT\"()RP@IH\nH)%PG\ZddɄ d4&\0M24ɉɓ	@h\rM\0diA&L\ZL48&&&L&!440h&\"MO)J~4C44C1\04?E=MP\r4ߪOSLUOS6ڟ\"/X\n<#\r)Aj5DSH5 VaE,%UDȥ\Z#U\ZdJ\Ze\0jHPjAU,4&+&e5ZdɦLC4X5%d&iFj,BbPҚi,M$P\ZjFMR*D*H\"$ɧU)I\'MD`$)>\nyK*W\'dLbɓNLXӉdŖ[LdzYv}u@R<JGR?eB$CM4Ŧ4OR}\n\'{̟9>DJ)$I$$\'*J_@,3}>IJ //$_H/\'D$Dң?~K\'Pa˃Re䴺]\Z\'St4.w-.ƗRʮZSܺYvIt,5W*t2uI4Ө;\"iɦeˋNq;ʺу\'UjNK&9Ha;iSqqNU\\;SuڮM#-Np]U:\\\\egK&Z\\Y84է\nM4LKˢ.ˋGM94N\'.\'N\\ZYeN\r.ptLˋKCYjS,2MM6dLiYc,r\\\\\\ɦbiZdW%eɗ\'-1LM4M2iܫNM4qE\'M2E&MCHi2K\"\\Rv4dӴbriM5ZdɪӓdȣAԚ9)]eir*$%8XiYViTɤ4ȋM5,MVń&-J-,TB*B.\r&SJeTi2&R1UaWRe4)Y4VLXQUDRi|J|J|P{=+{UUOz^> \n^O!*}O=ܝHqRwRtwItw(.RwI;N wINKxxOHdHdAxĒx\'xGƊx^$Oa=;\'y!ҽ^{丗(A|ivU{x\n|!?jx\'x\'<yh{D*O!=Uy=RP|H|D=J/p̣I~/䗢eyG^UK̞Jee0<<^S҉zOD=<2^޸U=PQJU^=Kļ/.)x\\^WyJOZOZxO^ji/OOuT\n{=OSSUst?ReZ,a2v.M2dLrii	N\'*ɓRP&L]K.epZYbUr*i;q\'jGh\Zr40䋋UeZ---,0˥)̱i-2jGjidDrXwKʙ:NN윘iY4M02h %p\"r]U\\%SeR˲eKMr8	S;GaR.YP!bIY%:\'r%:ILA`%dJiŖiB%Ȫ`&Urd&Le.*(L&MIN̔⣢ILЁe%[*\0\ZThUӐG	t\nbW&m1\'$HVRRë$CrM4M1aMMQnq	Kl&RҮQN.Xjdʙ5S)W\"QL&Ia,FPC5%:UTaU9.KK	qz{A?Ze\nHKLJ[E`QK@]QDW¡H*?TKK̄OWƟ)ҟS_T9/tJ^RJy~E)v2jeX	jCD),`QIRIIIIJISQ-A-$$JFI&(L	0Qd	j__3.ʐ=w/k*@xTk4R&dq>I(QEtP+Hj\ZiIR4$ZEI,d%KA,Z2i$Q2Tj)\ZRSA]+KԩJ]\nYR#B;\'JO\nOjW:O=w*R)eJCBU_z)HOmO4RDJ^\"T*SȫȚ&PXM*j,)L2hc3PJIȨUdyy_\"}䒅ZyT#̞BRT?@\n2-KPiC) @?S\0JT	\0*R()J$I!UJ(\n\n(\"G\ZddɄ d4&\0M24ɉɓ	@h\rM\0diA&L\ZL48&&&L&!440h&$OO*yOԞ@P\0\0\0\0\0\0TfSOR=A6@M7?C\"4\Zi̒5BW%J@5\r@&QK*AZY\rR\n\Z-Ka&\"P-4Ube5U,-,4IUZZXɪ6!JɦM2,2e4Ґ2,eZIT40d\nYiB\nJEM8UJS;S$nI~OTPRYJ0<9dɓ\'&&M4j2rri&5^M.¯E:IGΒ?:_IjYaYeqrieeEٿ=}o|	(OR>E,<R}BE_*OOȒO )P\'ן~yϷCGQ?ċ/H/*ODI>uD%Q֥?L+\'~\'5_Jr\'Uid4jpNNjXTNҧdYWa԰u;..i؋j8EWSvR촺YeviɦjGbeɧSCK]tNLrө;ENLdu]&؜PvtW&#LNSەu);NNȹʸNN\')ӉN&LLkNIŖYeagKTӲZrrd4NM994Ӊ)MVYiXeۡjaZriɧLMM4ɦNMZdM2eɦiiea]%ᦜiɦ&iM98q4ӓM4LM4M4-Ŗ\\ԻipLʲ-	r8d\'SNөɦM2--,2+KDNW%dYNq	%6N(q4	I®SCM4ʰi12j\r5T\\Mi`hh0d̫K)ajYeZ8T.\"䴚\ZS,2SLJdZ,CJ*R\ni`ih\ZR?,%U)+̧/9|[ܽo.wy:<CSxP\ZC}IONwR;WyD ;Iܐq\"$];ēI;NTw;SN}p<bO0H\"^eI<Q<Q Rp2{\'zvWRe]\\/|.Wrz{ʟ\"|))OZ2/@	^뾗x%zz^/PwC$|^OU\"{I~O=u<.)\"%yyKO%SSSe/POPQ+JzOQy)|%=*zPJzd$^JJD{➙/ү\n^^Խt=dO^>>>b}/})J{=y{~}P~g\'LEL&NEɦLirM4M4ӴM14r1id+\\Yiib˥;,2.pd&qCiR#&5ZʤieUL\Zu5;(h&jLeĮCa#õ.˒账Ni\'Ӳi-4ɦiM2d9C)rTR)jYiutUvIiR.J\'UrJQN,2ÐU]*SQvM$+ESH))JbPJa%U0iI\'&M2j$ȓ\"RhɔPr2)l䣤ILҀIʗlqR$r\n]-Pur\\Q)dLKP\rUͬ*I4EW)NV,:ŭ:ZidM4L4v(N4\\Ѓ6L4Ld+M5ZS&&LJu-RдK	dɩVU\\ThiL%uUN &ĵZ#䴰\\_tZ	QQ%&%S%DR(dPEh&Z	ܺI%!	WH*?R7E^RĿڊ_~a*pq?;\"Q=ƗE޼nQU~7?k➩\0T2ddʱ1V$eKa+(\n2`QʡbBE	-,$Z\n )02I4I42I20$TAM V&OO{|Gޚ.ˤ\nDe=\r{\\OiT(8z~\'My	4\rCR4\rQ5#U#	0`$XbEXd%KPI-	2i$Ҩʉ\ZUJae)TЛWR%9tXwUJOGR܄NR\"NNO\"={*\"{2{$3UXX\"zR\'r]*Բ*2\"1\"дK	fmH{tRE*8	Խ>\'zAO%闊=He5m`gS@YJ\"\0E\0U\0ER\0EURJ R*$qLMLM2C@h\r2h`#L0d\Zd	1F142a4\r4ɡ@c2bh2di2\Z@iC\0&jRjf<\0\0\Z&M@PR`mH~4\0i=M3U4GQX\n;aX*+\Z@\ZT%2*ZPVAZ\ZҒA4\nYe\nie#MU4d&&dUhH5\ZiieAaK,U4,$RihiZ2-$i0ieYbT\n	94\"?G\'g)?fKj\"I^K\"\'}Kd\'&2dɖӓ&q5\\L:u4ɓLU(?Tu/}eYeo\'YaYwv|!ؽW>dD=HWBOPU\')廓(/J\'\'\"^\n~P\'֤sϢ}}1\'U#@_D_%x TJ$*(_\0OnRW>5uVL&]Lҝ2Ӫ:2s]itȻ:8N;U;N]&cNv&iN-:5]*NUWD`1jNLbQҫUISNFwNN489)u:Zj98\\N,M8ӕriS\'\"M4M5Zbu4anӓ\'	riɦNrq2pZrrdL-.*K˓NNM92jm\r2dMW\'&94ZhɦdRɦ4Ѧii%qi&r4M4ɧ\'&N&rrrrrriiii4˕iɦN*Q~riphd\Z)dX%!GjLLN&Lw:9iM4ɓ&\r:uʸbȴJZ)0MViM12bdʭ4Iru0dVUd0&ʱba4LiaYeSn!3%dZdɑ42SAhVb`NRIhVK\r-\rCKu\"+qQUz}d؞^Sҩ/ȟRz^\nz \0|eIJ>|<	\'J	<(RxRxQx/RxQ\'x*\'U\n*xU/w}@B	^JyJy*PKȤK(UyT/ TW/xUK=}N^NuSq8O**yS/4/:{ܞ{OhdaֺBtt%]|.NUI{?/Z^x)$yPO$y*^HX/	tDt#..N^^EwICB!)t+G={:oyOxzCWW/\nbjOeO:ٗ͗Ē_\"/-Uɦ\'sEɦLirM4-3LbteԸ4®,d\'UզtkLLZgT4ZdR(r,]mN	e\Z,r\\\"i&wu2j4dCEM4M2-2kCmUjbHƢj+2Ni\'+MZiM4L&L)\'(p*\\U\'i$E\'TGTqiKME\\	]^nH,8(gL9#h#jMF.vI9T(J)ʂJj-T,$RR\r$GɦL5d\\U&5FL)I$CE*K\ZIb\rP%V+(\ZŔYCU. HdMiKeɤZ´VV	mEFWT&)&ɥ:\n\nEr%XLLrCqKI4]%8LtMaUKzZuZ*˭%\nEȪaE\"ARCDAZT\'uAH*ՒCRU/BHtU\\/S\'$֟BT$$9//5Jҗpt@2^=j9I^BRLV&*j+ZiPV\n2*b2YHYDYDYDYDZ,,MX)1TDDd*Z,VBPa#\"eRiJ}n\n|.@ڻ{Du)R&Wi	c14^Γ{\'4\rCh\Z$\ZI-TDZEQ,Aj\"ҤDTj)dR%V-\njUjbZ~AUt*먐):J=\"U=o@y}uKJ;	H.RJYqsBWHxػP=hBR񴽪bZ@ل%.$UU&5!bEXK(nRԁ\n/ZIW\'ܝ+\'\'GT/b${ޞȡ)wKIdMdzм Wx|H(\0$\0JP\nHQUF142a4\r4ɡ@c2bh2di2\Z@iC\0&\ZddɄ d4&\0M24ɉɓ	@h\rM\0	JH<S	&LQ0d&41\0U5=Q<\0OjOP?SL<iEUHHeb2,VQEidaidT\r@+CJ,MC2U\Ze3	P4M2\Z1kM`Pid&&dU bi&0K-,,2KY2bJKL&Zip\ZjF,P!VZE)(riROJ)?܁%(OĐ3r䔰U	}s&8i&N\Z92iUɓL4ɪuv*\"+DE!-S,2,.WYaYxEPSTz>|~OHWQ\'(\'D/Ģ/D_$_HB})?Oߔ\'ZP}ʗ\'?O_`/R?\"%\n}BO>QOΩ}$GC횯9W讓tdຝLIh}VUԧi5]&UН&w9;NNNҝ\'sUħj\'ivj:Udnd]M94M$pW5jUvq]jNW3wt;*w1ri]\rCp&v]s\r2rr8\\8MZsGD.!rpq914w2iʹ4ɣNii0u4h\'\'&NM4ӓM8dˋK,iqpe2ˋ.-,,.,dɦd&dK,,-aCʸ\ZriLM14LrriiŗYeŖYeYeYe\\qe)Ttq4pVMCJbeY	r6\'!;*4d.M2iQɓCMNMVL$JrakU8L\"K@58DCM1Z4&&,UU\'S+&hXL,&	&M2ji5,,NJ\rRɓƕZ,TXBdX,,S)b0iiEB(i=;=Ol>g3؞>^ؼyyR/urW\'>t<	\'#JDRxD/\n\"/	\"$SI<U(SR\'(=>BI\0^)R))$(OuJ=ȪP!=)y/%^IR*OE]\'{\'iz	>TOL{W*Sw!y枤\'yq<^B{%^p]vQxC.xC<^O+	/9Oj#zQ5K%U/\Z0^02e/\\</:^brS\'EO|SrrJ];;w.^*bW_꺕؋;Zuòa伥UKʥ/jaW/U=._$>5/\'LEL&N拓L4\\iaʝV:&MJ8M2i2tq94áv֚eZdӀZ4ɦH9ȱW#\\Nu8WŖ+,S--SNh&ieLWe0HJjUtNiM4LiL2S8R\n(E\'U#NZET\\@q9]E\\5\\80T*i5uSE:YBV)N)Up]\nSP,BW\r1iNNt.Z4ɦM$3A]Ч|I*CtR@jQ9G%]kP:t),-ImCÕ\0ӻ\Z\ZhrHkd,-	fZjM,#)+EZXe(q\\2KReijS jUAh2CTLbiL4iLS@b\"е%rXiiieԲE\\dr\"5E\\%ia>E\\_t^Qet(W])-P-2Pȑ4EXXQVBqzA)Ȥ5J*G*P>9{m슠p_4/^HuP;iQJ$9/.|U\"zU=?<u;2aj\Z5RY%h*FDS\n\"QQ,-*I\"Ȓ)hbe\nA#\"@K	旃󺢨~;vKk;.JAu.eKKq>4F&p=/}_h&LU#$RS$ZES(,)5\nbI&MDTe	FPeKELLϊtTCHiJMW=y$.*$<%_]{TJAu%,Q%y	)}tTI_D|\'{PUZߪ	K%/\\$>\ZzzPԚ%4,ȲK	33E*E\Z%\n6N\'u/K؟>=\"M%䞤T.!	bLr\0J|O+	\0\0\0\0!\0\0\0\0\0D@HdiA&L\ZL48&&&L&!440hqLMLM2C@h\r2h`#L0d\Zd	0@Mz\n?@\Z\'ꆞ4<\nIEU2h4\0\0\r4Th\Z\0\0xԕqE%z)%3	\"J`PV\n0T`\nAX&S\"h&J0M1i4ƚkM4T\ZjcFFM4ɦQb bi&0bQY4ɦ1VDɴSdɥi-0RM$U\r2FMCM)RiPD:i^Lm	DUy¢>+M>LcFL:hFrj2d2d&W܊DG$R\'܉4Zei~\Z4+M2\nPx/<4Kzi+\">	}*D]yD_/_B\nO\nOת픣$p*}K	O*|^(TW~hQSԓ\'!>8\ntI`*\\HĴɣy<<\'M<^\'d5/4gOSɧGUOhy<OSbyKO){RiM4OTL*FVJ<^jO2y<	W{CҮOxi駢2I5^\'OjO\'8M2xNNOf:d飓&picMV3ɧEN2q4Nq\Zr{ӥӪӧLcLjiNV:4W4Zhɦ]:i0\Zd%\ZhM14M4eɧNtNiɦ&4SNiӎNM:iӧNtM:i4M4ƚiM::i\'EQ}ieZhdj\ZS*ȰKC=*4]4ɦG\'L5Zjy:jjAP1LO8.S\":&%J:4V-ZiY2a51V(y12iS+2k&həC&F5Y4ɪdihT꺭aa4\r4dȚd)YUdXdajZ,+U+İРB)zv*EN].]y5[Fj.ô]pWeJr*vBe)\"|$J*O\'!|D_*\"H/\')>B\'J>ITD|U_\'ĤU>(∾(B$O	|tY;1YΦrjZl2ik+BAe-QZ֑uS:S	wд$..},t\rʷT\"qqK\Z%ddG:\\sRT%EtUt$tE:PQ:J`aS.Y)*UeBʥ)A]d-\nrS***^QWq[UHC$6eS@гY2gR\\o\\/\Z^r\n/<*/\n/	wuhCؽR*d	٢Liu]4dpjp4dG*M5WM^lWLLr+F4DuY\'N5ejWM2eiʒL2iƫF4{E^M4\Zi`#rajh(ɪW2x\r2xrxti&i&L\'!Щt=OgJ\Zhd(SڽiU#OSQS#Q5)9O(Jj\"U0**GNdIS!=ȧ* `Ԓ:4Ʌ&LjC&)Cyԡ*ICTA\'\0hE&W.hPiVy	L5iM4UZx4\ZɪVIYT(\ZZuӲ^\'i+&B&tTҫE@iMFѨɓɊlWx*{ҝTMCE<dɣLa/rnP𥁪YBN&JCUUɓU=bпzҶ?ܰUal@iDU5TZ	U	KIC*QV}(}&*o$%~EG@K}eo@Mw/K.m*{\Zh*{B/-UJTB{0-^^qY/yT>\"}_\'&MVLa4+U4ҕ!FHEL&*D,,,,,(YDZH,&!M\nM\nL	2)4H*bd\"0T0%͡iYuBtݏ+9BbÍƉ -*a`(%^@*+M֙hwM\"K\00%aK\0,*+)\nS)E-DY\nbT!L)5I4I(L QL ,*b`T髾IiІ$A\nVoH-\0%.s|%pI $ZBRеJ΄3\nRx`T%,BRP[!X*ĘX5K\nj2ffxU`TV\"*lChiMI|%\nMo	n)eBUe50\"z_S@]P(JT(\0(EARBURPdiA&L\ZL48&&&L&!440hqLMLM2C@h\r2h`#L0d\Zd	0$!?*jzOCLh1UMMSƩ=M574M7T ڀ\Zize>d\"U$QiUVU,2VVVVVa2Z+QJ4\r	\rP4Ljbi5UdiZYjieXdfF2d&4Yd&i,IaZ1)YKF	Zir*UQeP*	\",\"_\')/Ѣ~\rD}\\GW\'2&M2ri92rh8&L&5^ػ\nR t>ŉ#I4ZeiYyqqeeR>^ϑ>R}ު>Y#WO?U\'$/$_HD_5 ,>HR~hR9}	QOI}>3}_b2)	GQ\"EySD} ~QOI~ByU,>Ip|t2]KNJu2tN.JUv;RKd;\\]˥p\\WK#SI:NTM\"蝉ˋ,.ˋqYaʝ,5]SGS\'A:ڝwC.V)a;5];\\M4u8W*\'SLv\\NÓӕv1ʸi\'\r5S:ii,eR\\❮Fiɧ\'\r1\'VNGS*ӓFcLm,2K...,rdɒ&4\'\r2i0\'&1M14M5Zh+qeZr4iƙjiɧ\'\'#\r98rrrrcM94Lii4Ѧ894ӉTtQ4pV0&*e%N]LLN&NriM:NL5Ycņ,YbZ09,H9)eK,bbɍ0M4SiKM04ɬM#FLJզ\ZYiaXD.))ʸXZ&i&i,*ʬԓiabj\Z]rHѤGݟ\"D!ا)>~r|JT/pTTA{^د_\nTܟ}>4NGyJ;Rw$.EHE pʉ܊;)ܒ\'y>U^e^qO8S̔y\"$^d\'(h΀rOI]xR>߉xK^.H/~^]H*%>(j=Ƚ^/uKܞ	җzRCԫ)+={\nOd#OSy1<i/4Wy%<ejO$x^1xҝ^(%O+ħ=99/jeSڕ{B{B{IT=IR<y!<yN/)@GxO^^׫\'OyO}+)==os\'>~ʴY4d04ɓ\ZeUŖ.e]..K,8/w.,2ːreɌbMYa.;\"Y#W2hREɪSY:Xщ&0VM4M1#YY4J8q2UvNZB亝,2eXѦii&rp]#ZN֥DWPRhK!ąN,8w-*!S	#.2Rp],ULU#.SSH&Z!d	rTI$rLdI;dB9C&pRuPCjPAUh&9\Zu46PBm%9I]&TK-$\02UM,EbVx*\\СԺ+MV62`Zdсtī\"e%KG&2jM-,J]&4Nedɣ\ZKQhAKIhLE])8LT8ɢ|qxП-J\n Y)0VU\ZDCH)\ZD\'R^:J%*Gb(WEP>izCRr/Oi΀eU\n!(%ܕKR}J_^Kھ#)R\'2ddiV`*%jҕKAMQF4JU&U,$XHhj2AjT4)0Rj0R`T\nH\ZT2eU,L&ÓhU힤!Um^^PRҙjHwO>>\'P14z:Nzz*ʴSdSE1(ЦbQbE$XiLAaIMRM(Rj(Pj)S*\n\'_{bP:](BX<*xUJ^)RE*\'IQ*H.	K./	)^!/|\nT}-/	zױjTD%/j!)x!2񇌴R2\ZaMJL)a-,mkEJ_aՓN|iOz rKJ_!)Z?\0_0\n|\0\0$\0\0\0\0\0D\0\0\0\0\0 qLMLM2C@h\r2h`#L0d\Zd	1F142a4\r4ɡ@c2bh2di2\Z@iC\0&jO2SʩU\ZI#4\04OP)%TʞFzi\rU5?HC44ɑ%`\"DIaJ)*Ȱ5YH&Q\ZEQ)VVV-CJR6JbFe&LYJ\ZiɦM2\ZeVVh2iULh+J\rF4i%4ĢM4MV24ZY2dZLc\ZiGUIT45\r4\ZhRUCRPI/<\'u)/a~AUI`W>ٓL4ɓ2tɦ1pɓM2a_[6/J_\" yIEGUjEcM>LV4RuH9]pêKީ}E%{Gު$ Kȋ$EԂ\0!I\"$J}z\"aO~_\nzΒBE~R~E@\n~%$U%󈯡*\"E<e~eHT>2x&Lɓ<M\'1xjL&U䧉:zM=9<95XJ{Cz\'MJxڗNiR{KN{W?/#٪Ѫy2j8t=SOEh\ZIzQ]24xrtKLQq#W:a\'&L\Z.4ƘM2{c<<t铑4NiɫQNVtѦi4cm9ZqiƝ8FUM0酦Lay::iM\ZicM4+\'Ntt]4\Ziɦ1Lt:ttiN:tƚci4ƚi4i+1G%Q94q422i\ZԲ-pJM12y92{M2iM2di5Y2CкjLZ+t.TiG@M$i4V1Z5Y4ɓ)d%ɉɍ4ZFk&&U	L5XiUƚi.)rhaiMLLZR1FicIaeXXVVO:WUZ5q?F.;vIvEIqq;)ڧ5UF\",)*T/]O|T|>JW)$*>Q䈾HD_%!O\nO$TP>JSQ|>\'||I>Ĕ|\0\"D_\n|)\'	>*Q |$^OLVYjEjj띺+U.|[J\\A&2NʥBzң˜T]/\"V\'f1%X%pΩfFp΢%-A[hiUI&*YK%2A2(,Ki\Z+x.lS:[q3+5*X\ZlRS!8eFT6-VԫZZԵ5sǗ?xu#TY._UH=Kֽe/XJd	٢Liu]4dpjtM4Qʺi&VSy+٦UM9VY4ѦH9CM2zCҮ\'Ldc+U%\\eiGUMF:diZii\ZԎхRQī+OD\r0)z5ZhM4c\Zi1MBⓠU.q\\&\Zdz-SL)utB/b\":\"0TTHȋ{Rt^\"-L#\".J\",L#M2iSROZDX	$u]2i\nM!P9+CjC&TrxP)&\r)9)1*^fҦ5%ouTm;ʗ&m1M4iPdVQuJ0dj5^JOUiULhɥO9Uy eLR\ZtFLMIQѣ$ъa J{ԜbWFM5T^#ʋJZ	WNFVuU-ح`\nz~pqiT(*Zd2QKTCJ1R)tJ(\ra**V$ KH2$ [ԽTS*>\nzA_[ ʗzBfV)>;v|Y/dW(m^̙5Y2LUЭT`,H#J4J4a*eT,Xb\"EH	S&B)0Rd`	*(ҩe@ҡSEYPVY-^m<eސ6 L*D?}}ODQx>xC똫*LUi(S\0dEYdEDZdE j)&	0(&5J2WTRqB\r mJ	@ުVRK%Jl\\P\\(-	KoH5HA\0W|.ka!W)e\0U K5LSPX2VjS$M\Z3333ĕ_i윟Ry/\'}$E?ПH*{jAPVI@ʹ@o_	O\0/ژoP\0\0\0\0J\0\n\n\0\0	%JH#L0d\Zd	1F142a4\r4ɡ@c2bh2di2\Z@iC\0&\ZddɄ d4&\0MԩB\'G~?I\0\0\04\0FRR*&E6=LThhhԧA@JU9 +޲L*\"5ZH&Q\ZIQ@5XRhamUB,hRJY5 Qi4iUФ2d2iU\ZdƖF2d-&cM4e&&\0X1)YKMCZiQ\nj`PD(9)Rz\n˔E/ϊ~-HoJXPLdɓ\'&NLiq0îSL4OͩjT w\n=,\\)|e|-FXe\\\\-,-ZJH<>|G}{>h#\">Cy)?	 \ZOD//_E|¤*}BJ̒Q~)Ϡ~/T}$<\"EQ_U	~%RJ~G>_dG\'aE\'CN\\WGSh_a+NƎvʺT2scĹN\'Uw*5)Үwc1	&\';]НMWH]SRjR9i.5F.s\'urj\Zdq8:]:u9W\'ȹ14u2iN82jZcLi4cUi\\M5\ZrpÄM8iɦ\ZjrrqZrpɍ4M2iLdXӇ&M\Z2iN\ZdԴɓM4Ɍ.MV4M4\ZiVNNM8W%ri&i&cFrrq9\Zrc\'cN\ZicLiɍ88iG%Tt>Sc&)ԙ\Zʥ ⫸]0aѸ8ƚ5\ZhՕudlRlCe\ZX-S*`R39Q\'\"MVibjMF&L2e,T:\Zie0LLL5Y4U\".@q,\"eKAee5SEi\rF4ZjVUedeU]kDG;yUO%\'O({=/B^UzbyRy)yH<QQO=txG<DxHxDRxD/\0xB/ĢIT$!<%?jΨ%<y^p΁yRy\'I<O9A%</4{OjڞOjW/l}ާQ螊u9;NӺ8\\!xUܻivQJhEģƇ>֏a=B{zg:IrE8<^itO%RB{Ob)J{RW]k:Ӭw.]`ĺRSE֤\rTKJA5:r).^{u+%GmI@DEt+Ҟ9Uo\rrNC9CK]eUWRx/;L}(~O+U=O^<]_̀W^V&&b4vj4ՌLa&2vp]M4ќ5iMP\\ɣU.ӓꫳ\\.%YZqK,iնv9QӹɈr	ɧNU&\Z\Zht:Lu2tw4ij-)8mhp,\Z\\e+FWt;NRhꆙ:tiɪEiM1D&\ZTUR)w\\+idcGHhLhK&	G]r.MV1qU]T(lT6EHЋE;N\"*dR2\"hX)\ZhR\\$u@	#MҤLC)ujIrCқE*N(I¤$Rp#E+DIjRj192SM\"ѡYiLIʥ-,сi&0 ZS$5TW\'M2dԙ15\Z2d2M@IMIXS.!´iiieb)\\\nbjRCN#+E8C+Ph~p\na1(EyE%I¨jBdU8zPӈQf ;Q+EQ$}%|u|^\"W) SRWTU) U甐z|$ƯUνrzBvaVK#)b2KDi)\ZT0&2i\"JS*Bȅ-B,YHY%L 4T	bj$0+%*%4UF#>ã .UyyI\\	NΤƈ(|\r{=Q)$z.ZBMH+QF%4B,ЋY`Zjj(*L%RK\"Bi)WjDIUUUa,UUw)+I]wEEb]{*`&8zU{GHy{=]YIRA=0TRE/$A_(FԬ4KAj,6۲{+*SUaS>\0TQGH^HzE@>2),8˿?\0_0\n\0\0\0\0\0UP\0@\0\0\0\0*@#L0d\Zd	1F142a4\r4ɡ@c2bh2di2\Z@iC\0&\ZddɄ d4&\0MR$M<TީS6LSd=MO\"2i6j$M=5\Z\r@\0?T\0\0)KRR0bUVI*- KDV*2jUJBYVe\n@Z5HFM4ʨdeCLi$ULiMVR!FM2`ZP&4M5YI0J\nVi	U\r2L\r5)*LUP\nP>IrK\ZE}T$})K?aƌhL0铦M4rdӦ2iUbUB,!^zE~qz\"Xa4tM5Zi)%^؁^|0^{{_~	B*%T\n)*ΩQ%报U/{/\"D\Z>>JvʩTB_ȉy%*\n\ZQ;)|JEWNtƞ\'iiy<2xE^j{-WʼȽ=<zy94bp\'{2x*N4ƙ4qW\'OUdxy2btG{*wN&<2/Pё=<^#EӪrt:biɧUL2rd֜tZii2<rqq\'tLLiM94+N2ii4+8ZtN:dLi:bѓM1MGLei\Ziijh㦜:rW\Zi\ZtcLM4&tӧNNLtӧN:tM:c\ZiiiM::i\'%Q}ir244a4\ZQhZQpzǓjqѦiIGhW&hjйIjRNtZiMM122a&hԒɥM4YLLLL&dœL4Ƙԅԥ10e4ML0-0b*FBx4tZ,EZ0EA^>Z>Pz+\n|>I\\+KĜ()ЇUe}U/E>B>P_|>~rWi]]UT*@|P_ED_E )TfRO*T9|_(9Hʩ_8ED_:O>eIOWBQ<)\\jG8].e,V#|cXՌ}brq?vT\'СU\\KD\\r	&YK%+p\\¥ȗ(cXժgS5,ĵu`KP\Z+ZMJZZ\\<wjl6\'qw%6J[bڍlI	Mm-ZҢңEgY2[\r][jVU$֡SZ\ZZ$YVrYc13f78b2teخ¼*]J:T]H^K^պFd(4ri<14ƙ2hGM\Z2q٦#N\Zd%Wc\ZacObzӍ!\\aUNZeidi#N=*zcƚiLU죊j`W&^&\r2yH=icIiM4I4ɓRuIrMLT{/b-4ZjE\'%A½MWJK½MIN\nTFȧ<+EhE^D^t\'La$*b	#F2Rd <҃j`xm#<HTjP\nN*MU=ԓ@^LJtꗒIZhS2&E%Y)yE\'`M;Uс12b-=ѺA&TWFɣ#RdɓJdҙ:*jLKTJRa&Ь#YVJM\nj\ZD9W\'+	`\'b/淬eG,*V\Z}bi2\"jP%Q\nZ\Z\ZP}\"h5GJH=2\Z]$K,/A=-ϊ zbsTH4A$Kgtd\n\'y=2ihҵ\Z+(ԖbSRHja%HLJMRTB,ZXb0\ndJd2LL*LM)&X4ȩaK	Z-+$۩tđYOg*D?%>˓ԑF&#_Sƾbju-(-iF)$Tґ-*\"ЋB,dEX4JjRiRbIPM$Pj	T&HywH7\rL\0}	#I@D* k-GmO\0z(t  q$	ueвXA$nQK\Z x%A4VM5)0MRl%@U1v.oN~^s(\0WD\nE.i=)HiT?\0_0\n|E(\0\0\0\0\n\0Q\0\0\0\0\n	\0%#2bh2di2\Z@iC\0&\ZddɄ d4&\0M24ɉɓ	@h\rM\0diA&L\ZL4U)g6R=HѠ\0@\0\r\0\ZRR*کT\0U\'ze4P\04ETV:1E\"UFVPQ\n1e%F ih&)!XMQ0&T5Q1$F\ZeVI!!1œM2iȴ*2d\ZTLcŔ,*U1VU+(Еi\'$PɨiQT4&(ri%J~G:R%]	>I/^)\\,%}Ri2iaL01q2d\Z2iUURQ(GB}ipᆚii(y2EyyG	zj^xQ}E@E?@JOO}tA$$\\OϝE_I.EW|*)^P/\"RR~$\'UGi/>w~[ĲVRa]NNbթ馝UНN.:NUpINF\\S&G%.ttIٓ*UvӓM4N1\n]GF.2vbrWqv&0cSI;\'*pʱʴ5NS:#924:1\\4ɓM4M14M899\'SLM992q\Zi&8cM;ӓ4hpXɦ1iL:985dr98rrdiiFirriUiew84ƙ1iG\'r8rrRƜi)F4ՓNN\Zrpq4\'NNNLi&c\ZiƚhMʹ94ӉȪ:OhLMY3U*ڬeZ\\iS4d&jjIb±jE9@U81cMZ,ZcMdʬ	rtebLb`1af\ZM\Z\rILddidpRʚLY+U\ZRNSLdMJa%Ĭ9u+_,D|wU\\]\'\'OT?{){zԞJH=}!S?a>)*<<<5Ryb/(EE<)<\'	Jy$xK)xS\"B/))<%\'I	AOͭm%is˚\\+OwvȎG\nO|K܃ОRzR^^Or{O]u:%:Yf*и\Z8%ƓR0hj5\ZxZ5Qk\rUj)RZKE4+BV4AKE\ZK53k~}\'\"RR |CW\Z]3ufL3fLg-ܵ6ҭV,jtCw+UrCK.R꺺{r?~Y~DʰidjiƘp+\'siөZ4i#i&VWiө»a4⬜M,1L@FM1dvp&-5Z\\reiƩraӆҴ]YiLc)Ur\\MSU	G&;8\'Ec\'T\'T.MV1hM4\Zdɔ\\9R;NcE\'T]TE.\0q89P]95Zj$q]TR#B.jRpB-*\"ErriMEMRLJ&&\"G*ɦ)5U\ZSIFU	CĤC$q)2P ITJM@e@j&%h#.&\nEL 5NM5,.uUFeeQ9+!022qU5eL֔+cMM&4d2NKNI,HTL0җn(tYQWdC%:&M\n[`O\n/d!_COQQMB\nL*)7- \"PօUR=k\nQJ<T\r.yQorix*Z_ܨJxBx@/\\Ԣ\r)tʈ<Vro,֋\nW=E.4ɓUYFZQd#(-U&F\ZM&,,Yd\"BET*)II$Ĥĉ$F@$\Z%2Ė*X9qnY-4^;L* ņvu%As,ĪM.SEPM{{eYIZJe&JiU2(ЋJZhE-JLE2Rdȓ%&\"MP0AXʫ%D%+%@R@o.zU=*DB\'IS^!TQ\neN-T\rtʈ;UĹ:eκaQ\'hE-()p.\rFIY&bI&dZ_\'eD%RP3d|Խ\'R(Q2{ڡD;DNh5@PVIeV	O\0/ژ\0\0T\0\0\0\0P\0\0\0\0D(D2bh2di2\Z@iC\0&\ZddɄ d4&\0M24ɉɓ	@h\rM\0diA&L\ZL4\nTFeL<M7cS h?P=D3B\Z6h\rOM?TM=\0Ug&`)EEdE\'v*UTh5KU(ɨFJY*Q*2Ri\Z)jFUT4F4LT#&Lj2DM4MVƌidZAƌ4ɥMF4$14MV	hThѢ`h%cB\Zd\Zh)UC)C*S)?cK𤟯T\r<C,?i?xyM2i2aN4ӆ.hFUڞ)(@6QG?9*Xc+>N11:J|vO{DGD{+ƒ~~iHƑO)>bR~Ғ~	U $@/O?y*_IڂQ/~\"E~~IRO2?ğH.q#瘫NI؛*\'i\'Sy2y/UVLi^Rz;L=N#<Lɧ\\M\Z./\'2xj=ɧM4\"{#N^Hjd<LDt/RWy\Zbi駂5G茞=\r4xrpdu#/\'N9:.21Ӧ\Z4cM-8X1i5]:xia\Ztӓti2tӎ0ƚi4LӎU4㌝1f+M\Z18-4dM2ettU4M4LiXœM::qi4&X:c4:qN48M4144c1\nId2[+Ta20M%](^nNObVM4iM<2Te-\ZK`gIT\\JcLh2d)hInLV\Z`j2bhh0a\Z4Ƙ\"*McU2Yi)44X+BV$xjT2U&+JȞB}%W֞rkCAk	MGii-j-J֪֡UQ]5ST5}{;\'uQD|QR||/|䔟%$Q |O/|ωj*_O*>(\"_OJO$UG$YZ}U>/_Qx#_vy>#GG# OdYW2Kr8Up\n¥77wГb6ReU,]T8OWЏH_IGUu Rx\nyzwIZU\\2M4+DЭ%M)-aXMiY9FdVtj)YThZy\'N菤W_@B_H]QHW],)2+eK*%eK)G\"rNҭ*4Fh7ܫrNxv\'G^$?8V&LM4M4iy4iL2ht&MV񧓕z4UɕL4dLVzmUt=NCt]1N\ZZe4{5dI᧫MSM4M4ıW\rSK\r*V\Z^0yCL<TpjEi0La	r\\H\"pbz`Ə<{W411\\èTy*:.Fu^ESبmR4\"F$\nISЋISQHLj*dI@DhHfզ)5*5CS\ZVCIF)2H2Ru@NJMP22d#\n$V5Rdt&2i/qCʌ$ɵ%WNQ4&1&1T@Xey+iVLM&F\r\ZΥ]$j-DJr\ZY4dƪdi5܎!/x\\+J2yTpi{Ob*\\8a?mMi&$16D)K@ʔR)bʈ\n}ʪ~ACJrE#T䒫Л$\\ORoIUs$YlDPUz$\'*UfN$3I*^	s&S9DB\'&MVLa4+UU5FIXEd*2jL\"YHYd\"ETTURdbRbR`ĤD$#JʒH1$XCdm:d2ʀU=EEPr~G\'JF&UxCbXbjTdZ\ZjZhE-d%&L)2dʨIbL+HyiIURٲJSUW4HU9jD&gv\nSz(:}HWZx2IURNM|IUIUqRLԅjJUmLP0SPʬSʭ	h\rmRbTԕVXNDܛ\'9\"P#roNE3U~(+$k\"{k`I)\0L\0\0\0\0)@$D\0\0\0\0\n\0\0\0\ZddɄ d4&\0M24ɉɓ	@h\rM\0diA&L\ZL48&&&L&!440h&TMF\0&4ɐ\0\0\0\nJE$̓IM1?T4\0zP7\0i&>HAy!#HZRāiPVLVJV(VЕeYLԊAQ-Q#T4M0e4ih\"\r,Ֆ\ZYeL\Z4d&ULi4KU04R\Z&XV$\0F0b*ccI G IOu$S_c_TʂH\nX~\0~8r14ri&L92rdN&G\'&2i+UҤzةH$ō-5ZiNNLiL|ТI?GۇCC/\\TKےւ*S*S%S*J.ШdJRʕw樞Kʮr>^ߊK$O*v)S]Ģ)E݂])|QS_Y?D~}/r~1豇QWVJNUá9#\\\\Uv:!NWztcН&SGjptGSCwNL.+;\'tNNL&:;pb9؎\'urj\Zdq8G@tΗn+u;:qNLM98iɧUriW#&M4M4UW#ƩL&4r94ӑ1GN+NNLic&4rc&\\9,rp91ɇ&ƘԱSM5\\ɩi&1\Z.G&2ƚi5ZjpӉqW\r4ƜaidӇ&N&94M914M4M4ɦNM4rJbp0ijFeZJ\\DRN0tadac5Æ,1GY\"ڧZu,\"spR8I9RpZ4&bjMS#&2jF%.M\Zi&442dɋHdʚhɋ&2b\ZcR\n)1144LZUebb-J0!GIG&*d4YUɕ`ie2BR}9Od>*|UOI}zY\'S/e/(\'+Q|d\Z?|=\0z*ҀzB BB/D\"H/D*z$SBRzB\'EOAKOC}GSQr$Q+*r\n)Ȫ($%D*}E/^x=OTꮣOQ8\'\"=vN^$=R!\"Q_\n#xG=s֧+KtΩ΅Ut+Uq#Ƈ0|/2/	TpiyǙ^p^e/0a:tK\\)p\0pAs99tu+]:j\\S\'Jq##G^y#\'WQ<GuixOex}pU_HAWЪ}\nOП}???!p?(hC̧cLb.Lia:18cFMƌ21˲]bac+&1Ir1+\Zvtv8d	94UVIɕFN%&F;юb1iiq0aȕIdꆙ:!ˆ,i4M2ibM2hC)pRv;U4w14ҧrZ%LqU\\N)A.iP亥d4Q\Z]J2IA:P*jz9+E6!9E#0ƩS*P-HHpc)C&Pj)QqS6E*ɘD8Ć\nj!H8RdU\"G&iL\Zb-\Z**M(&i\0tib4&4UM2dX$B\ZI)]1#RdɓJdҙUELKRa,sXjiX-\n8RʲVhUpSiS\ZD8ɔ18U/F=R&Y%2MBBTU$R\Z<UH4b@)Iā_\n* \\??8?,(tQ?@C(U~kUS?3yG*(0ņKCQd2!(0K-P)\ZeRA`EBE)!RTT))$RdhD0)ba1w\n*O?=Ot(y\")Sc(&N>w%E0zG>_qX0)LJĖ TT-T-PЋBZE4*b)U&M44!M4!Z*b`J\'O}QUH:$J\n#Dv=T=E:{_}\"<DRiQDH|QUE߇ah\Zɼ\n)pJT^ha2UZPZ\"-,>Hb%`=8#J=b(`@(+$k6\0W\0L\0T@\0\0\0\0UP@P($B\024ɉɓ	@h\rM\0diA&L\ZL48&&&L&!440hqLMLM2C@h\r2h`MJQI~z@4ALF@\Z2M\0RRJ&2SM?@\r\r?Tze4Pi=OׄD4dJVDRĪ@FX%F@Ţ*2\Z)a`Rb0%\ZZ2!&1h0Ƌ&4bتCFCƘţM2iдdɌ1SQIZ4ɦ1SDLYF+Qc(+M4NA@,*YjYhX\n\",U!%rOԢ\r\n)d+Oܙ4ɦ1d1\r.&L8cd{vU#H#S锚2M4ӻ1-4	*r\0O3OG(5CWAO*O(/\0A /U\'I\'P>S\"z^+҇SĽyIGS_\")II)\'\n~\'/jk2u&0r9WSbɃӪQ2v].pIv98vL\"]vN:M*tjNiF8hrTW`tGFUtL.Uv]\\:j1DeʣU;U:;\r0prXNS%؝v\\8988-Ӈ&ciKjӄƚiƖ\\N899W2iѦVѧ\'&Niɧ#1ۣN410GNeu9V99ӓ\'&iccM48*6iL4v\Zic\Ze1iii98q\\Ɍri#L1Zrpq4\'NNNM41c\ZiLqZritY4rFL,Id+WCvE4dNR,N.,4)D\nqS\"dNTIr1b01j\Z2a$\'F[2l10aaб&&2Z,-r*-eZY)5T jMF#HZjXIcʲ++UӒqF\n\"h><UI>/|J%/%yIWWB\Zy<<Z{Sܞty(t+\ny<y/0E怼S\ny%\'T0SQy>U|(\nOT\"U>\"^*xԋ	x^\"KQ>)5xbxxǢzBzNOD\'zQ|Tv<ʫx#ªEEE|^	Ob{\'3OQ\'Lϒw%ܕܢ\"wiWj]RdW/Z^ezy+ESWx%xBŊx	|wwzq;^WqqN\'PUړRxܝaܫK]]#8)	x(Od{<{G߃ު=w\'ր>8OҙV2ɦii9W\r2vUSMhGr-Qqt,Urdņ4i8U\ZY4F٣LvpZ`8ጘK.\ZZj1\\V21,.iM41j4rNKEKQN2tV0W`icM0aDJ8Rp;\'cpvdt]M4Yb\'( Ur*Kr:%YP)LTF+i$ZLp1\\*`rriLI2W -	5Zh$r-4JJ\"E\\\\!,NTK-A*4єLEQ.Z)u#m)uRLJըRɨ62c*4+P=\Z*	ۈCc%U14LeStħmP;HKQ[F4ёaF&LSPu\\(tĜE#U\':+&cQdajSVUSIXpZ)XAr\\*UX@V\n(UKdE`I2EZ*X)]%AG)(c \\E#`	*XIU?Z>ğ$t\"=\Z\0$\'$]%W\'=	;\"=iBu;,ZXij1YFȚ\nX(QFL*L,PX`EZ\"*d)R`)IRdbRjd	RʁCeEru<^`շ;{BJUJQi(]\'HIpDzcC5&bB-(bdQ,UL`X\"eU4\"KA-	5T	I\ZM j15*)N$\0T\"=GdªTQDȝ\'ܝ矰UJU*vJM9=<S{BJ(Q<Y=OdIU^Pw\n\'>dQh2DLЙ)dLgT晴FET;q=iҽO>H$/P=DEڝ1AY&SYCR#U%>\0j`?\0\0D\0\0\0\0\0B\n\0\0\0\0\0\0\0P\0F142a4\r4ɡ@c2bh2di2\Z@iC\0&\ZddɄ d4&\0M24ɉɓ	@h\rM\0*HOԁ2F6ID@TMQ꟨G\0\rRh\0zy\'GF\"Ra\nV MV(Ɂ\ZHUTa2Ej\nFFRe-Ih$a\ZiJF-2Zj4\rV%PѠ\Zi4h4cE\rF0&j1\nciIh̪Tҭ\Z5P-CJK!PƁ+UC\ZQ8RRpJ~wEURSPgB)e%h~YN8ƍ2iL2dɓM8\\a4&ɓ\\ҠΪFJr#JM,ZjcɓM2y^R[}Cd?\n_MI>P})~T.\\pME<R}T\'*s\'Bt0vE\'z#*wң^\Zx@uJrTS*<Ipv9)?C\':0:2p:0m:\Z5A:.v05]	ؗ+]t;	Nю4\'j4.v]Ҏwu4Ʌ;\'p:2etrcM)8#˱؎NwV&:8VGGFr.KÉ±Ä\'\r]Lt\\+&V914W#\'U\r:icF98ai8iN99ѣӇ\rM4M2rɦ\'%\'\'.4G#ƌiZdɌep-4ƙ1LTrijM4Lidɧ#\\iLq411ӓ98p4ᦚic\ZihƛrXpr1T4#E2r9Ta8cŎ8b4aY2-K$ԺԓaMjiUM2Y2dZ4EphUcLUL12ejVLdĴц\r0bcLiEI8s4V%4Th\rRZP2FF:LLjS Ɋʬ1::T~_>|껉-	4ln3\ZTQZUZUhFVR0_8(|9\'>zYTY%ROYPzeB*PHR(\nz\'z\'3\\XL%F*bXT,*,*S\n)Bb`f3jgS1vdꮇvN#JƩ\'>)t[_*R<>1,^yJU/0O2<y<<u\'TA=н=\'\'^W)Iʞ=\'yI^UU<O^5pp<+K4{>>Rx<k۫]Z֫Zq6ʯI=<	{ʺ6PnPQ6Tlnϴ~qьN18\\ó:1ю\Zhɣ(8.LicU9ec48ddF4r&5Y4NM8w-5K9+L4rK\r5XiàZ14ܦlc6iii4M,49\\\Z]q:MpuCL WpiM4ɦ1L5Tࣙj(+SvKiكunLd+i\\*,b]EʔTҢ5PeD]*R)#UJj*SRHcTL8\\1jaQ8Lbapr\ZjjD5E8HdN($5Urb+RFr\njR\rKJ3FY4,2K\"8ș\ZRa98ddjɍ2eSL0aR\rE:.+TWGI\Z12LdjU\\:)4L+I5%NJidɓMT1\'z(uBr+J29u	jpTUи80>p|EJeIeMH&Q-D\ZU@Ԅ5:)TkI#X W	_P$Ur=}ީHOҢ=au }U p$Uy$U}O\"_yb<\0O1aYE1I2KEKTFAL,-*JBS)))$)#\"&R\rbVP`c7ؑUz}׈A\"3IScB>D{QF\r/Ct2&d2JS*%FUBʪT-@j2)))S!LDS\Z1IbN*\nN@©*jʈTGc*J\'TCOISU%NLp)#HO1\"*(@J\'Rؽ*2AjĚ5\rT(x5P<Xpx|AQG(^DxxOyT*@e5-HS@c\0\0\0\0\0\0)\0( \0\0\0\0\0PqLMLM2C@h\r2h`#L0d\Zd	1F142a4\r4ɡ@c2bh2di2\Z@iC\0&J&DSBP\03F\' \0\r)%&OHdh\0\0\0\0iNRB\ZdɲMKhb\"4>-Uid*$,%QLF%(jFa\Zc(,jXƪaR2icLbɦ4hXB\ZѓiSCL\"VM2iciEMF`+M4O\nJi5\r4U\r2L*\nPO_U\'}ê%/R~Ro>I`W:1\'\'F0c2y1W&L1M2j<)\nGP\'2bƖi4KM4?\0?ɫ=$(Qzj{jjAI.䈳~D^\nAxQ)*B=RxҨ$(J/`NNUwu\"xExhYDT:<IG w\nOENOU\'ZdyLdp꼞dLY24=o*{d竇r#Oga\\\'2]Q{Kz\'O2\'{K1<Ӧi=#`OI{O=#=1z2#Sҽ*Ɠ^.4Opz#\r=,d1å\'\ZhO\'U9-:r4<1\\i&Ztiiii]2cɌ4iLiF4q+:h4эL9X㎚N1Ӧ4F,aM4tN4i0F0)4Lc4+c.Ki\ZpSMiM8Ntrc:qӧ11cM4M\ZcM4>i2jXMC	jUT3ɓ\'ii\ZtU*6)]VRѡjZD,LRb\Z-\r14\r\Z.ɡ\ZZF,Zb\rSYC4Bƌc&-L\ZdjZZda2LLVaFF\"x5V2C)YXd*?\",IU	(\'MU*tt/Uri%/:#	05C)Oa8hB\rIH4J@Q\"РSB4*DRhFAIEL禫4LtQU3DY,5JfLIRg*LYW$pR7|%|w>\'|#qUJ7d6EmTJr\\PJ779ӖrUrrLFNdb$bU1AGNsteVUeVٶ,2+(ʖTUP	rs/H|_\"*QINNyk\Zlc*Rī8Ea)X\n#֚YPH7t˩:ىUq:(	:P>eXZ42{5NiƘLΣ&ɧLhѣQ2靧y<ǳL4M5U]JM,8ǢxCUzqj;JKMS\ZLKV\Z\ZqX^S\'\Z1cUɒQī+ڏgN\\ryK8ō&1hM4ʭ2jT*{zq\\a{14m]/K4LS90=؝5Zj$qxSبlK2yUj$=X*FD\\JH.#ѲiS{&jtUQ0Ԓ9v-4LL#SQF+SIPr0#Dr4ʤAr2@+Bº)2U)45.2&ҦMTUjҨЙ\Z$U\\tci4S\Z0ʦL\rRb(WNƣF&\Z4d2MR&)jE)reabYY%r*ıF	\\+H&Ο<WAƊ}EBiҒ,bFUVJ.	(J#R\n%W7(6UIM\0\'*=ʀr}\"U|DJ;UsO9}\'&MVLVEe\ZRTʆd+RITHBHHH(\nQTJb1T&*)\" F,2!&JE\':y?JZJZ0U*TyQ2OO0QF&B>2,\"dY*dME\Z*bj(ȋSYdEZJeIS**E&U&FM iTbHELLzJ(}D(U@yiRL>F#bnU*T9E@>}OSOU*T\nJMS\\ڨ\n=^\"Us(\Zut1H_~(\"Q>%\0iMDjDҦ&2MDŔ<AE\ZP_}|Y<W}\'r҅B7&IO>JPVIm>}	O\0/ژJ\0H\0\0\0\0	\0\0\0\0\0\0\0\nH\024ɉɓ	@h\rM\0diA&L\ZL48&&&L&!440hqLMLM2C@h\r2h`MJOP\0Ѧ@4\Z4Ɉ\0h?IoL#o\'ALLM=}BQP\"4(Y\ZT0#CJ+ \ZPPJ-i,ɔR0iTReіVFM1cF1i-+jI\rF0&JcM4bLVTҭ\Z4MCX1DhdcJ1G*8c%J~w(+O1R>%D=_Cfr8d\'&2a\'&M4bNM2a1{;%RHrAM-\Z2cɓ1T*D_?~үUU]Q/u\n	{U>\Z>2*|T꒩֩Ӥ)JJ./~E$/?}SRWUT+|ׅN*}Te$_TQ}r)$\'?I?\"??򏺺]u]\rY:8.ёLt]Dahvdt9QNK1.u:wXwQȝTv2\'j4e8HҎE08u4ŪpG:M2ZigF]&I8#˴G\'Suiiʱ8qїNN\Z8Erq8q9+8rpӣF&0ɓ;бcLjsc\\0ӣM,d\'81\r9i[ѦӓӇ\rM4F9\ZdƗ\'%\'\'.4G#\ZcF42h2pLƙ1Lq94i4M4M-4rripM1Lq4ƣLcrrc\'#NLpÓ\r4LcLcF41)i\Z&FUq\0S;Fv\\1ec\\8b*b9.qKjZ&9WDWCK\ZiZi,L0Y2Eu:VZь4VZ1VU2Tbեi\rV\Za1,VVcJ,eUbhX,Ҍ:L\r5CT9ʜXj\'(G*?,>u]||p:O~{Ǳ=>t`H_Y\'U|4CD~=$= =RzJU\'AzҔ/Dz$EOBJz\"S\"	z)\'=\n}}*W.**q\n\"	TP.\"HOI>>O|%>/Oxz=C:WCӸ#}IS|}kJ<QNQrʹTr}u+ȫg=ObO8zQURUR<{=^}I!X<̼z<Ԟhiyǝ/4MVT<O#U@U<Px+£^cx\'yIv%$}\'O	^xC^x\'yG<yi{	^߃l?\rWʓ	\'\"~01óTcM4PL`óctqp&Arc+Ypt0\'\'\r2edb\\Ѧ]294WC:wW&pNJMV1bEħjaa\\+&;t;bii+\ZTQȪu0uCL:WtrjԴM4c	0W+Rvi;0c]ú11)UqpŌ\\9v5%9)LFT.d]*I#*%)Bʔ$pⱅSR&A`Hc,b)]BGPF&LeQ$EWtS	\rIҊjK2IUA8j]%]H|\\2(:tVI&\Z%jwuBBbM&T&FI4&4ѓT(8 X,P+iLM&#\r\Z\rQW|HuI2MRĚ\n*ɣ&,XZ+J0NrUGHc֨U}XTM\0)iLLʔiJK*%\rP4JpT[R3I#\Z\0W\n=A\nG= *^)$G\"D;U\n\n*_z~%نhi-CP%Z$&Q-\n*\r\"UI**Ri2i*bjH(X\"Q5ARL`c\'ǲUyB3	%NΉR&NV}D{<3ޗ2d%jhB*hBM\nP҅SH,Z(dEM\"A&AjIwJJ\'O}UD:\"\rTIS\"=R#Q\'%\"!cTISQ%NH}U%eB*_\'ߤJ\'\"Q=b j\rI\rI\r	F	fk[t	FD8=}>dJ\'x\"1AY&SYxot%>\0j`_\0\0\0\0\0\0\0@\"	I\0\0\0\0\0	\0\0\0qLMLM2C@h\r2h`#L0d\Zd	1F142a4\r4ɡ@c2bh2di2\Z@iC\0&JH7m=TIzIhz4\0OP))4\'S\Z)\0\0414DSF)xB\'aJ2RдQ(AdbQʥF#	04\nBcI\Z1jXƕb%2icLbɦ4i-Kh\rhɌ4L3Ji1YI5K&Y2iIR\ZiVCLI@M9DS!OI*_ۨ?QP7jRQr8100pdÆ0ɦMWثRG)#RGę64b-4O8aiinUlTrۑr+\"|JR|UUU];RHSߊGBO)E\'fw&zsOwTjUT,H/	Jx:J$)<.rw`C\'~j:L&YNU\\N&&Fcdbw1r:NA:LSsKib;N:L;M4\nB;#teuWHc8U;\r4in48#\'uvӲƃNWΦpp\'\"Ӈ&:1ci18M4M44[\'f.LLcL4ɓ1ɎGcV4hÊ\'&1ccKc-94\Zii0-.NLd4\Zh\Ze:88c4icƚc\ZZj9.RrcNi42\Zrpr\'NN1ii4N\')(?)4rFQa22TīA]v\'up4MVɪɡ%9-@rSB&\n1Z24tu1ea\ZcK!1,a!\r0LaLdœ%4ƒ.9VFJť1LdajUYU!N#\Z)b:\\dG)(%WO@vSҪzU=_O#+^z!CG+܅@(z)Ns\']1F$a#$V\nRa *``)\na*L%QIbi9bҋH(ҕM*PPZJSJ\niJM\nH&-	nrSq|\'<NQ#)zTi<Pz^\n5|EWb+8؛dNI5\Zԣp]ijQ8jl&ړhiNmS9Y՝\\\'	Lʙ̬4E.={y^ijARyyxIW>Yϵ9:dzT%,>E#į+<xG^{{VM}]\\G\r7[oI96;)Tz\'LLFFNSM41Hr4M2i4j\\4Ѧ