<?php

  //j.bos@bytewriters.nl
  //If I'm not mistaking all these examples of adding leading zeros 
  //will not really work with floats. Sometimes though one needs it to
  //have it working with floats as well. 

  //With the function below use 2, 3 or 5 parameters. Don't ask me why
  //4 don't work, the number_format() function seems to have problems
  //with that. At least my version of PHP has that "feature".

function leading_zero( $aNumber, $intPart, $floatPart=NULL, $dec_point=NULL, 
                       $thousands_sep=NULL) {
  //Note: The $thousands_sep has no real function because it will be
  //"disturbed" by plain leading zeros -> the main goal of the
  //function 
  $formattedNumber = $aNumber;
  if (!is_null($floatPart)) { 
    //without 3rd parameters the "float part" of the float shouldn't
    //be touched 
    $formattedNumber = number_format($formattedNumber, $floatPart, 
				     $dec_point, $thousands_sep); 
  }
  $formattedNumber = str_repeat("0",($intPart + -1 - 
				     floor(log10($formattedNumber)))).$formattedNumber;
  return $formattedNumber;
}

//echo leading_zero(21.12345678, 4, 5);    // Output: 0021.12346
//echo leading_zero(21.12345678, 4);    // Output: 0021.12345678
//echo leading_zero(21.12345678, 3, 0); // Output: 021
//echo leading_zero(21.12345678, 3, 5, ",", ""); // Output: 021,12346

//addition: Just like the number_format I haven't found a way *not* to
//round a number while changing the decimal point and the thousands
//seperator. 

?>