--- 73 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0073','70
','Geometry','\\begin{geothm}
 Given four points $A$, $B$, $C$ and $D$,
 points of intersections are formed: $L = AB \\cap CD$, 
 $K = AC \\cap BC$, $F = KL \\cap BD$ and $G = KL \\cap AC$.
 Show that segment $KL$ is harmonically divided by
 the points $F$ and $G$, ie:
 $\\frac{\\overline{LK}}{\\overline{KF}} = \\frac{\\overline{GL}}{\\overline{GF}}$.
\\end{geothm}','
',
        '
 Harmonic Points

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0073','3','
dim  130 100
point  A 52 20
point  B 72 20
point  C 66 40
point  D 56 36
cmark_b  A
cmark_b  B
cmark_r  C
cmark_lt  D
line  AB A B
line  CD C D
intersec  L AB CD
cmark_b  L
line  AD A D
line  BC B C
intersec  K AD BC
cmark_lt  K
line  BD B D
line  KL K L
intersec  F BD KL
cmark_lt  F
line  AC A C
intersec  G AC KL
cmark_lt  G
drawsegment  B L
drawsegment  C L
drawsegment  A K
drawsegment  B K
drawsegment  B F
drawsegment  A G
line  lkfg L K
drawdashline  lkfg

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0073','2','
point  A 52 20
point  B 72 20
point  C 66 40
point  D 56 36
line  AB A B
line  CD C D
intersec  L AB CD
line  AD A D
line  BC B C
intersec  K AD BC
line  BD B D
line  KL K L
intersec  F BD KL
line  AC A C
intersec  G AC KL
prove { harmonic L K F G }

','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 102

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('102','6','13','37',
                    '0.008000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 74 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0074','70
','Geometry','\\begin{geothm}
 Two lines, $AB$ and $CD$ intersect at a point $O$.
 If $AC \\parallel DB$, show that:
 $\\frac{\\overline{OA}}{\\overline{OB}} = 
 \\frac{\\overline{OC}}{\\overline{OD}}$
\\end{geothm}','
',
        '
 Thales  Theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0074','3','
dim  80 80
point  O 20 30 
point  A 60 30      
point  C 40 50  
point  B 35 30
line  a A C
line  c O C 
parallel  b B a
intersec  D c b 
drawline  O A 
drawline  O C 
drawline  A C
drawline  B D
cmark_t  O
cmark_t  A
cmark_t  B
cmark_t  C   
cmark_t  D   

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0074','2','
point  O 20 30 
point  A 60 30      
point  C 40 50  
online  B  O A
line  a A C
line  c O C 
parallel  b  B  a
intersec  D  c b 
prove { equal { sratio O A O B  } { sratio O C O D  } }

','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 103

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('103','6','18','34',
                    '0.004000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 75 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0075','70
','Geometry','\\begin{geothm}
 Given triangle $ABC$, let $p$ be line through $A$ parallel
 with $BC$, and let $q$ be line through $C$ parallel
 with $AB$. Let $p$ and $q$ intersects at $D$. Show that
 $\\overline{AB} = \\overline{DC}$.
\\end{geothm}','
',
        '
 Parallelogram Theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0075','3','
dim  130 70
point  A 20 20
point  B 80 20
point  C 103.40 55.10
line  ab A B
line  bc B C
parallel  p A bc
parallel  q C ab
intersec  D p q
cmark_b  A
cmark_b  B
cmark_t  C
cmark_t  D
drawsegment  A B
drawsegment  C B
drawsegment  A D
drawsegment  C D

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0075','2','
point  A 20 20
point  B 80 20
point  C 103.40 55.10
line  ab A B
line  bc B C
parallel  p A bc
parallel  q C ab
intersec  D p q
prove { equal { sratio A B D C } { 1 } }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 104

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('104','4','14','21',
                    '0.004000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 76 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0076','70
','Geometry','\\begin{geothm}
 Let $ABC$ be an equilateral triangle inscribed in a circle
 with center $O$, and let $P$ be any point on the circle.
 Then the Simson line of $P$ bisects the radius $OP$.
\\end{geothm}','
',
        '
 Example 35 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0076','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0076','3','
dim  130 110
point  A 30 30
point  B 100 30
circle  k1 A B
med  mc A B
intersec2  C C1 k1 mc
med  mb A C
intersec  O mc mb
circle  k O A
point  P 105.25 53.81
line  cb C B
line  ac A C
foot  D P cb
foot  E P ac
line  de D E
line  po P O
intersec  I po de
cmark_b  I
drawline  de
cmark_b  A
cmark_b  B
cmark_t  C
cmark_t  O
cmark_r  P
cmark_rt  D
cmark_l  E
drawdashsegment  P O
drawcircle  k
drawsegment  A B
drawsegment  A C
drawsegment  C B

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0076','2','
point  A 30 30
point  B 100 30
circle  k1 A B
med  mc A B
intersec2  C C1 k1 mc
med  mb A C
intersec  O mc mb
circle  k O A
oncircle  P  O A
line  cb C B
line  ac A C
foot  D P cb
foot  E P ac
line  de D E
line  po P O
intersec  I po de
prove { equal { sratio O I I P } { 1 } }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 105

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('105','90','330','4139',
                    '10.297000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 77 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0077','70
','Geometry','\\begin{geothm}
 Starting from five points $A$, $B$, $C$, $D$ and $E$
 with $A$, $B$, $C$ collinear, new lines and points
 of intersection are formed. $ED$, $IG$, $LK$ and $JH$
 are collinear.
\\end{geothm}','
',
        '
 Example 3 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0077','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0077','3','
dim  100 100
point  A 20 20
point  B 55 20
line  ab A B
point  C 50 20
point  D 40.20 47.20
point  E 53.30 37.50
line  ae A E
line  cd C D
line  ad A D
line  be B E
line  bd B D
line  ec E C
line  de D E
intersec  J ae cd
intersec  G ad be
intersec  K bd ec
intersec  I ae bd
intersec  L cd be
intersec  H ec ad
intersec  F de ab
line  jh J H
line  ig I G
intersec  O jh ig
cmark_rb  A
cmark_b  B
cmark_lb  C
cmark_t  D
cmark_rb  E
cmark_lb  J
cmark_lt  G
cmark_r  K
cmark_b  I
cmark_r  L
cmark_rb  H
cmark_b  F
cmark_r  O
line  oed O E
line  olk O L
drawline  oed
drawline  olk
drawdashline  ab
drawdashline  ae
drawdashline  cd
drawdashline  ad
drawdashline  ec
drawdashsegment  I G
drawdashsegment  J H

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0077','2','
point  A 20 20
point  B 55 20
line  ab A B
online  C  A B
point  D 40.20 47.20
point  E 53.30 37.50
line  ae A E
line  cd C D
line  ad A D
line  be B E
line  bd B D
line  ec E C
line  de D E
intersec  J ae cd
intersec  G ad be
intersec  K bd ec
intersec  I ae bd
intersec  L cd be
intersec  H ec ad
intersec  F de ab
line  jh J H
line  ig I G
intersec  O jh ig
prove { collinear O E D }
prove { collinear O L K }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 106

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('106','91','231','1699',
                    '0.840000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 78 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0078','70
','Geometry','\\begin{geothm}
 In a cyclic quadrilateral having perpendicular 
 diagonals, the perpendicular to a side from 
 the point of intersection of the diagonals 
 always bisects the opposite side.
\\end{geothm}','
',
        '
 Brahmagupta s Theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0078','3','
dim  110 110
point  B 20 40
point  T 43 40
point  O 55 60
circle  k O B
line  bd B T
perp  ac T bd
perp  ob O bd
intersec  X ob bd
towards  D B X 2
intersec2  A C1 k ac
perp  oa O ac
intersec  Y oa ac
towards  C A Y 2
line  ad A D
line  bc B C
perp  tp T bc
intersec  P tp ad
intersec  Q tp bc
cmark_rt  P
cmark_t  Q
cmark_l  B
cmark_r  D
cmark_t  A
cmark_b  C
cmark_b  O
cmark_rb  T
cmark_b  X
cmark_l  Y
drawdashsegment  P Q
drawsegment  A B
drawsegment  C B
drawsegment  C D
drawsegment  A D
drawsegment  A C
drawsegment  D B
drawcircle  k

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0078','2','
point  B 20 40
point  T 43 40
point  O 55 60
circle  k O B
line  bd B T
perp  ac T bd
perp  ob O bd
intersec  X ob bd
towards  D B X 2
intersec2  A C1 k ac
perp  oa O ac
intersec  Y oa ac
towards  C A Y 2
line  ad A D
line  bc B C
perp  tp T bc
intersec  P tp ad
intersec  Q tp bc
prove { equal { sratio A P P D } { 1 } }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 107

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('107','633','1691','7677',
                    '74.129000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 79 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0079','70
','Geometry','\\begin{geothm}
 Triangle $ABC$ and point $O$ are given.
 Let $p$, $q$ and $r$ be lines through the point
 $O$ which are perpendicular with lines $OA$, $OB$ and
 $OC$ respectively. Let $D$, $E$, and $F$ be
 intersections of lines $p$, $q$ and $r$ with lines
 $BC$, $AC$ and $BC$ respectively. Show that
 $D$, $E$ and $F$ are collinear.
\\end{geothm}','
',
        '
 Dual Altitude Theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0079','3','
dim  100 80
point  A 20 20
point  B 80 20
point  C 40 60
point  O 75 45
line  bc B C
line  ca C A
line  ab A B
line  oa O A
perp  od O oa
intersec  D od bc
line  ob O B
perp  oe O ob
intersec  E oe ca
line  oc O C
perp  of O oc
intersec  F of ab
cmark_b  A
cmark_b  B
cmark_t  C
cmark_r  O
cmark_b  D
cmark_t  E
cmark_b  F
drawsegment  A B
drawsegment  D C
drawsegment  C A
drawsegment  O A
drawsegment  O B
drawsegment  O C
drawdashsegment  O E
drawdashsegment  O F
drawdashsegment  O D
line  def D E
drawdashline  def

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0079','2','
point  A 20 20
point  B 80 20
point  C 40 60
point  O 75 45
line  bc B C
line  ca C A
line  ab A B
line  oa O A
perp  od O oa
intersec  D od bc
line  ob O B
perp  oe O ob
intersec  E oe ca
line  oc O C
perp  of O oc
intersec  F of ab
line  def D E
prove { collinear D E F }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 108

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('108','9','16','81',
                    '0.004000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 80 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0080','70
','Geometry','\\begin{geothm}
 Given points $O$, $A$, $B$, $C$ and $O_1$
 new points are constructed as:
 $A_1 = O_1B \\cap OC$, $B_1 = OA \\cap O_1C$,
 $C_1 = OB \\cap O_1A$, $I = BB_1 \\cap AA_1$.
 Show that points $C$, $C_1$ and $I$ are collinear.
\\end{geothm}','
',
        '
 Pappus  Dual Theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0080','3','
dim  130 130
point  O 25.80 48.30
point  A 95.20 55.00
point  B 120.10 91.60
point  C 44.50 112.70
point  O_1 62.40 56.80
line  o1b O_1 B
line  oc O C
line  oa O A
line  o1c O_1 C
line  ob O B
line  o1a O_1 A
intersec  A_1 o1b oc
intersec  B_1 oa o1c
line  bb1 B B_1
line  aa1 A A_1
intersec  C_1 ob o1a
intersec  I bb1 aa1
line  cc1i C I
drawdashline  cc1i
cmark_b  A_1
cmark_rb  B_1
cmark_lt  C_1
cmark_rb  I
cmark_l  O
cmark_b  A
cmark_b  B
cmark_l  C
cmark_lt  O_1
drawsegment  A_1 C
drawsegment  O B
drawsegment  O A
drawsegment  A C_1
drawsegment  A_1 B
drawsegment  C B_1
drawdashsegment  A_1 A
drawdashsegment  I B

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0080','2','
point  O 25.80 48.30
point  A 95.20 55.00
point  B 120.10 91.60
point  C 44.50 112.70
point  O_1 62.40 56.80
line  o1b O_1 B
line  oc O C
line  oa O A
line  o1c O_1 C
line  ob O B
line  o1a O_1 A
intersec  A_1 o1b oc
intersec  B_1 oa o1c
line  bb1 B B_1
line  aa1 A A_1
intersec  C_1 ob o1a
intersec  I bb1 aa1
line  cc1i C I
prove { collinear C C_1 I }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 109

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('109','10','20','133',
                    '0.016000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 81 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0081','70
','Geometry','\\begin{geothm}
 Let $C$ and $F$ be any points on the respective
 sides $AE$ and $BD$ of a parallelogram $ABCD$.
 Let $M$ and $N$ denote the points of intersection
 of $CD$ and $FA$ and of $EF$ and $BC$. Let the line
 $MN$ meet $DA$ at $P$ and $EB$ at $Q$. Then $AP \\cong QB$.
\\end{geothm}','
',
        '
 Example 46 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0081','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0081','3','
dim  130 100
point  A 20 20
point  E 80 20
point  B 95 70
point  C 35 20
point  F 65 70
line  ae A E
parallel  bd B ae
line  be B E
parallel  ad A be
intersec  D bd ad
line  cd C D
line  af A F
intersec  M cd af
line  ef E F
line  bc B C
intersec  N ef bc
line  mn M N
intersec  P mn ad
intersec  Q mn be
line  pq P Q
cmark_b  A
cmark_b  E
cmark_t  B
cmark_t  D
cmark_b  C
cmark_t  F
cmark_rb  M
cmark_rb  N
cmark_lt  P
cmark_rb  Q
drawsegment  A E
drawsegment  E B
drawsegment  B D
drawsegment  D A
drawdashsegment  D C
drawdashsegment  A F
drawdashsegment  E F
drawdashsegment  C B
drawline  pq

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0081','2','
point  A 20 20
point  E 80 20
point  B 95 70
point  C 35 20
point  F 65 70
line  ae A E
parallel  bd B ae
line  be B E
parallel  ad A be
intersec  D bd ad
line  cd C D
line  af A F
intersec  M cd af
line  ef E F
line  bc B C
intersec  N ef bc
line  mn M N
intersec  P mn ad
intersec  Q mn be
line  pq P Q
prove { equal { sratio A P Q B } { 1 } }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 110

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('110','582','1330','8089',
                    '200.677000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 82 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0082','70
','Geometry','\\begin{geothm}
 Prove that the line joining the point of intersection
 of the extensions of the nonparallel sides of a trapezoid
 to the point of intersection of its diagonals bisects the base
 of the trapezoid.
\\end{geothm}','
',
        '
 Example 49 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0082','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0082','3','
dim  130 80
point  A 20 20
point  B 110 20
point  C 90 50
point  D 55 50
line  bc B C
line  ad A D
line  cd C D
line  ab A B
line  ac A C
line  bd B D
intersec  F ad bc
intersec  E ac bd
line  ef E F
intersec  G ab ef
cmark_b  A
cmark_b  B
cmark_rt  C
cmark_lt  D
cmark_rb  E
cmark_rt  F
cmark_b  G
drawsegment  A F
drawsegment  B F
drawsegment  G F
drawsegment  A B
drawsegment  C D
drawsegment  A C
drawsegment  B D

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0082','2','
point  A 20 20
point  B 110 20
point  C 90 50
point  D 55 50
line  bc B C
line  ad A D
line  cd C D
line  ab A B
line  ac A C
line  bd B D
intersec  F ad bc
intersec  E ac bd
line  ef E F
intersec  G ab ef
prove { equal { sratio A G G B } { 1 } }

','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 111

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('111','5','11','42',
                    '0.000000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 83 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0083','70
','Geometry','\\begin{geothm}
 Let $l$ be a line passing through the vertex
 of $M$ of a parallelogram $MNPQ$ and intersecting
 the lines $NP$, $PQ$, $NQ$ in points $R$, $S$, $T$.
 Show that $1/MR + 1/MS = 1/MT$.
\\end{geothm}','
',
        '
 Example 56 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0083','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0083','3','
dim  130 60
point  M 20 20
point  N 70 20
point  P 85 45
line  mn M N
line  np N P
parallel  pq P mn
parallel  mq M np
intersec  Q pq mq
point  S 120 45
line  ms M S
line  nq N Q
intersec  T ms nq
intersec  R np ms
cmark_b  M
cmark_b  N
cmark_b  S
cmark_b  Q
cmark_b  T
cmark_b  R
cmark_b  P
drawsegment  M N
drawsegment  Q S
drawsegment  M Q
drawsegment  N P
drawsegment  M S
drawsegment  M Q
drawsegment  N Q

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0083','2','
point  M 20 20
point  N 70 20
point  P 85 45
line  mn M N
line  np N P
parallel  pq P mn
parallel  mq M np
intersec  Q pq mq
point  S 120 45
line  ms M S
line  nq N Q
intersec  T ms nq
intersec  R np ms
prove { equal { sum { sratio M T M R } { sratio M T M S } } { 1 } } 

','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 112

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('112','22','52','190',
                    '0.024000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 84 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0084','70
','Geometry','\\begin{geothm}
 Let $A_1$, $B_1$, $C_1$ be points on the sides
 $BC$, $CA$, $AB$ of a triangle $ABC$ such that
 $BA_1/BC = CB_1/CA_1 = AC_1/AB = 1/3$. Show
 that the area of the triangle determined by lines
 $AA_1$, $BB_1$ and $CC_1$ is one seventh of the area
 of triangle $ABC$.
\\end{geothm}','
',
        '
 Example 58 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0084','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0084','3','
dim  130 100
point  A 20 20
point  B 90 20
towards  C_1 A B 0.333333333
point  C 70 80
towards  A_1 B C 0.333333333
towards  B_1 C A 0.333333333
line  aa1 A A_1
line  bb1 B B_1
line  cc1 C C_1
intersec  A_2 bb1 cc1
intersec  B_2 aa1 cc1
intersec  C_2 aa1 bb1
cmark_b  A
cmark_b  B
cmark_b  C_1
cmark_r  C
cmark_r  A_1
cmark_lt  B_1
cmark_b  C_2
cmark_rb  B_2
cmark_r  A_2
drawsegment  A B
drawsegment  A C
drawsegment  C B
drawsegment  C C_1
drawsegment  A A_1
drawsegment  B B_1

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0084','2','
point  A 20 20
point  B 90 20
towards  C_1 A B 0.333333333
point  C 70 80
towards  A_1 B C 0.333333333
towards  B_1 C A 0.333333333
line  aa1 A A_1
line  bb1 B B_1
line  cc1 C C_1
intersec  A_2 bb1 cc1
intersec  B_2 aa1 cc1
intersec  C_2 aa1 bb1
prove { equal { signed_area3 A B C } { mult { 7 } { signed_area3 A_2 B_2 C_2 } } }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 113

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('113','78','274','878',
                    '0.264000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 85 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0085','70
','Geometry','\\begin{geothm}
 Show that median $CM$ divides triangle
 $ABC$ into two triangles of the same
 area.
\\end{geothm}','
',
        '
 Triangle Area

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0085','3','
dim  100 70
point  A 20 20
point  B 80 20
point  C 65 45
midpoint  M A B
cmark_b  A
cmark_b  B
cmark_t  C
cmark_b  M
drawsegment  A B
drawsegment  B C
drawsegment  A C
drawsegment  C M

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0085','2','
point  A 20 20
point  B 80 20
point  C 65 45
midpoint  M A B
prove { equal { signed_area3 A M C } { signed_area3 M B C } }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 114

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('114','2','7','9',
                    '0.000000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 86 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0086','70
','Geometry','\\begin{geothm}
 Let $M$, $N$, $P$ be points on the sides $AB$, $BC$ and $AC$
 of a triangle $ABC$. Show that if $M_1$, $N_1$ and $P_1$
 are points on sides $AC$, $BA$ and $BC$ of a triangle
 $ABC$ such that $MM_1 \\parallel BC$, $NN_1 \\parallel CA$
 and $PP_1 \\parallel AB$, then triangles $MNP$ and
 $M_1N_1P_1$ have equal areas.
\\end{geothm}','
',
        '
 Example 55 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0086','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0086','3','
dim  130 110
point  A 20 20
point  B 110 20
point  C 80 90
point  M 88 20
line  ab A B
line  ac A C
line  bc B C
point  N 97.62 48.88
point  P 36.68 39.46
parallel  pp1 P ab
parallel  nn1 N ac
parallel  mm1 M bc
intersec  P_1 pp1 bc
intersec  M_1 mm1 ac
intersec  N_1 nn1 ab
cmark_b  A
cmark_b  B
cmark_t  C
cmark_rt  N
cmark_b  M
cmark_lt  P
cmark_rt  P_1
cmark_b  N_1
cmark_lt  M_1
drawsegment  A B
drawsegment  A C
drawsegment  C B
drawsegment  P P_1
drawsegment  M M_1
drawsegment  N N_1
drawdashsegment  M N
drawdashsegment  M P
drawdashsegment  P N
drawdashsegment  M_1 N_1
drawdashsegment  M_1 P_1
drawdashsegment  P_1 N_1

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0086','2','
point  A 20 20
point  B 110 20
point  C 80 90
point  M 88 20
line  ab A B
line  ac A C
line  bc B C
online  N  B C
online  P  A C
parallel  pp1 P ab
parallel  nn1 N ac
parallel  mm1 M bc
intersec  P_1 pp1 bc
intersec  M_1 mm1 ac
intersec  N_1 nn1 ab
prove { equal { signed_area3 M N P } { signed_area3 M_1 N_1 P_1 } }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 115

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('115','131','479','1456',
                    '1.632000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 87 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0087','70
','Geometry','\\begin{geothm}
 Let $A_1$, $B_1$, $C_1$, $D_1$ be points on the sides $CD$,
 $DA$, $AB$, $BC$ of a parallelogram $ABCD$ such that $CA_1/CD = DB_1/DA = AC_1/AB = BD_1/BC = 1/3$.
 Show that the area of the quadrilateral formed by the lines
 $AA_1$, $BB_1$, $CC_1$, $DD_1$ is one thirteenth of the area of
 parallelogram $ABCD$.
\\end{geothm}','
',
        '
 Example 57 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0087','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0087','3','
dim  130 100
point  A 20 20
point  B 90 20
point  C 110 80
line  ab A B
line  bc B C
parallel  ad A bc
parallel  cd C ab
intersec  D ad cd
towards  C_1 A B 0.333333333
towards  D_1 B C 0.333333333
towards  A_1 C D 0.333333333
towards  B_1 D A 0.333333333
line  aa1 A A_1
line  bb1 B B_1
line  cc1 C C_1
line  dd1 D D_1
intersec  A_2 aa1 bb1
intersec  B_2 bb1 cc1
intersec  C_2 dd1 cc1
intersec  D_2 aa1 dd1
cmark_b  A
cmark_b  B
cmark_b  C_1
cmark_t  C
cmark_t  A_1
cmark_lt  B_1
cmark_b  C_2
cmark_b  B_2
cmark_b  A_2
cmark_t  D
cmark_b  D_2
cmark_r  D_1
drawsegment  A B
drawsegment  B C
drawsegment  C D
drawsegment  A D
drawsegment  C C_1
drawsegment  A A_1
drawsegment  B B_1
drawsegment  D D_1

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0087','2','
point  A 20 20
point  B 90 20
point  C 110 80
line  ab A B
line  bc B C
parallel  ad A bc
parallel  cd C ab
intersec  D ad cd
towards  C_1 A B 0.333333333
towards  D_1 B C 0.333333333
towards  A_1 C D 0.333333333
towards  B_1 D A 0.333333333
line  aa1 A A_1
line  bb1 B B_1
line  cc1 C C_1
line  dd1 D D_1
intersec  A_2 aa1 bb1
intersec  B_2 bb1 cc1
intersec  C_2 dd1 cc1
intersec  D_2 aa1 dd1
prove { equal { signed_area4 A B C D } { mult { 13 } { signed_area4 A_2 B_2 C_2 D_2 } } }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 116

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('116','469','1150','8382',
                    '216.066000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 88 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0088','70
','Geometry','\\begin{geothm}
 Two doubly perspective triangles are in fact
 triply perspective.
\\end{geothm}','
',
        '
 Example 59 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0088','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0088','3','
dim  130 100
point  O 20 20
point  A 70 20
point  B 40.40 60.70
point  C 73.20 52.50
point  O_1 57.10 64.00
line  co1 C O_1
line  ao A O
line  ao1 A O_1
line  bo B O
line  bo1 B O_1
line  co C O
intersec  A_1 co1 ao
intersec  B_1 ao1 bo
intersec  C_1 bo1 co
line  ba1 B A_1
line  ac1 A C_1
intersec  O_2 ba1 ac1
cmark_b  O
cmark_b  A
cmark_l  B
cmark_r  B_1
cmark_lt  O_1
cmark_b  C
cmark_l  O_2
cmark_rb  C_1
cmark_b  A_1
drawsegment  O B_1
drawsegment  O A_1
drawsegment  O C_1
drawsegment  A B_1
drawsegment  B C_1
drawsegment  A C_1
drawsegment  B A_1
drawsegment  O_1 A_1
line  b1co2 B_1 C
drawdashline  b1co2

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0088','2','
point  O 20 20
point  A 70 20
point  B 40.40 60.70
point  C 73.20 52.50
point  O_1 57.10 64.00
line  co1 C O_1
line  ao A O
line  ao1 A O_1
line  bo B O
line  bo1 B O_1
line  co C O
intersec  A_1 co1 ao
intersec  B_1 ao1 bo
intersec  C_1 bo1 co
line  ba1 B A_1
line  ac1 A C_1
intersec  O_2 ba1 ac1
prove { collinear C B_1 O_2 }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 117

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('117','11','17','123',
                    '0.028000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 89 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0089','70
','Geometry','\\begin{geothm}
 The diagonals of a parallelogram and those
 of its inscribed parallelogram are concurrent.
\\end{geothm}','
',
        '
 Example 69 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0089','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0089','3','
dim  130 100
point  A 20 20
point  B 90 20
point  C 110 70
line  ab A B
line  bc B C
parallel  cd C ab
parallel  ad A bc
intersec  D cd ad
midpoint  A_1 A B
midpoint  B_1 B C
midpoint  C_1 C D
midpoint  D_1 D A
line  ac A C
line  bd B D
intersec  O ac bd
cmark_b  A
cmark_b  B
cmark_b  A_1
cmark_t  C
cmark_t  D
cmark_t  C_1
cmark_r  B_1
cmark_l  D_1
cmark_b  O
drawsegment  A B
drawsegment  B C
drawsegment  C D
drawsegment  D A
drawsegment  A_1 B_1
drawsegment  B_1 C_1
drawsegment  C_1 D_1
drawsegment  D_1 A_1
drawdashsegment  A C
drawdashsegment  B D
drawdashsegment  A_1 C_1
drawdashsegment  B_1 D_1

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0089','2','
point  A 20 20
point  B 90 20
point  C 110 70
line  ab A B
line  bc B C
parallel  cd C ab
parallel  ad A bc
intersec  D cd ad
midpoint  A_1 A B
midpoint  B_1 B C
midpoint  C_1 C D
midpoint  D_1 D A
line  ac A C
line  bd B D
intersec  O ac bd
prove { collinear A_1 C_1 O }
prove { collinear D_1 B_1 O }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 118

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('118','22','53','213',
                    '0.016000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 90 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0090','70
','Geometry','\\begin{geothm}
 Given four points $A$, $B$, $C$ and $D$,
 points of intersections are formed: $L = AB \\cap CD$, 
 $K = AC \\cap BC$, $F = KL \\cap BD$ and $G = KL \\cap AC$.
 Show that segment $KL$ is harmonically divided by
 the points $F$ and $G$, ie:
 $\\frac{\\overline{LK}}{\\overline{KF}} = \\frac{\\overline{GL}}{\\overline{GF}}$.
\\end{geothm}','
',
        '
 Harmonic Points 2

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0090','3','
dim  130 50
point  A 30 32
point  B 40 40
point  C 48 28
point  D 40 25
cmark_lt  A
cmark_t  B
cmark_rt  C
cmark_lb  D
line  AB A B
line  CD C D
intersec  L AB CD
cmark_b  L
line  AD A D
line  BC B C
intersec  K AD BC
cmark_b  K
line  BD B D
line  KL K L
intersec  F BD KL
cmark_b  F
line  AC A C
intersec  G AC KL
cmark_b  G
drawsegment  B L
drawsegment  C L
drawsegment  A K
drawsegment  B K
drawsegment  B F
drawsegment  A G
line  lkfg L K
drawdashline  lkfg

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0090','2','
point  A 30 32
point  B 40 40
point  C 48 28
point  D 40 25
line  AB A B
line  CD C D
intersec  L AB CD
line  AD A D
line  BC B C
intersec  K AD BC
line  BD B D
line  KL K L
intersec  F BD KL
line  AC A C
intersec  G AC KL
line  lkfg L K
prove { harmonic L K F G }

','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 119

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('119','6','13','37',
                    '0.004000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 91 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0091','70
','Geometry','\\begin{geothm}
 Let $D$ be a point on the circumscribed
 cirle $(O)$ of triangle $ABC$. From $D$, three
 perpendiculars are drawn to the three sides $BC$,
 $CA$ and $AB$ of triangle $ABC$. Let $E$, $F$ and $G$
 be the three feet respectively. Show that $E$, $F$ and $G$
 are collinear.
\\end{geothm}','
',
        '
 Simson s Theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0091','3','
dim  100 100
point  A 20 50
point  O 55 50
circle  k O A
point  B 79.50 25.40
point  C 49.50 84.50
point  D 30.80 24.70
line  ab A B
line  bc B C
line  ac A C
foot  E D bc
foot  F D ac
foot  G D ab
cmark_l  A
cmark_b  B
cmark_t  C
cmark_b  D
cmark_t  O
cmark_t  E
cmark_t  F
cmark_t  G
drawsegment  A B
drawsegment  F C
drawsegment  C B
drawcircle  k
drawdashsegment  E D
drawdashsegment  F D
drawdashsegment  G D
line  efg E F
drawdashline  efg

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0091','2','
point  A 20 50
point  O 55 50
circle  k O A
oncircle  B  O A
oncircle  C  O A
oncircle  D  O A
line  ab A B
line  bc B C
line  ac A C
foot  E D bc
foot  F D ac
foot  G D ab
line  efg E F
prove { collinear E F G }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 120

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('120','6','23','405',
                    '0.232000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 92 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0092','70
','Geometry','\\begin{geothm}
 The cross ratio of four points on a circles
 with respect to any points on the circle
 is constant.
\\end{geothm}','
',
        '
 Example 77 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0092','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0092','3','
dim  130 100
point  A 30 30
point  B 100 30
point  C 90 80
med  m1 A B
med  m2 B C
intersec  O m1 m2
circle  k O A
point  D 41.60 81.20
point  P 46.10 14.20
point  Q 84.90 14.70
line  ab A B
line  pd P D
line  pc P C
line  qd Q D
line  qc Q C
intersec  F pd ab
intersec  G pc ab
intersec  F_1 qd ab
intersec  G_1 qc ab
cmark_b  A
cmark_b  B
cmark_rt  C
cmark_lt  D
cmark_lb  P
cmark_rb  Q
cmark_r  O
cmark_lb  F
cmark_rb  G
cmark_lb  F_1
cmark_rb  G_1
drawsegment  A B
drawsegment  A D
drawsegment  A C
drawsegment  B D
drawsegment  B C
drawsegment  P D
drawsegment  P C
drawsegment  Q D
drawsegment  Q C
drawcircle  k

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0092','2','
point  A 30 30
point  B 100 30
point  C 90 80
med  m1 A B
med  m2 B C
intersec  O m1 m2
circle  k O A
oncircle  D  O A
oncircle  P  O A
oncircle  Q  O A
line  pd  P  D 
line  pc  P  C
line  qd  Q  D 
line  qc  Q  C
line  ab A B
intersec  F  pd  ab
intersec  G  pc  ab
intersec  F_1  qd  ab
intersec  G_1  qc  ab
prove { equal { mult { sratio G A G B } { sratio F B F A } } { mult { sratio G_1 A G_1 B } { sratio F_1 B F_1 A } } }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 121

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('121','4','8','19',
                    '0.004000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 93 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0093','70
','Geometry','\\begin{geothm}
 In triangle $ABC$, let $F$ the midpoint of the
 side $BC$, $D$ and $E$ the feet of the
 altitudes on $AB$ and $BC$, respectively.
 $FG$ is perpendicular to $DE$ at $G$. Show that
 $G$ is the midpoint of $DE$.
\\end{geothm}','
',
        '
 Example 82 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0093','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0093','3','
dim  110 100
point  A 20 20
point  B 90 20
point  C 70 70
midpoint  F A B
line  ab A B
line  ac A C
line  bc B C
foot  P A bc
foot  Q B ac
line  pq P Q
foot  G F pq
cmark_b  A
cmark_b  B
cmark_b  F
cmark_t  C
cmark_r  P
cmark_l  Q
cmark_t  G
drawsegment  A B
drawsegment  C B
drawsegment  A C
drawsegment  A P
drawsegment  Q B
drawsegment  P Q
drawsegment  F G

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0093','2','
point  A 20 20
point  B 90 20
point  C 70 70
midpoint  F A B
line  ab A B
line  ac A C
line  bc B C
foot  P A bc
foot  Q B ac
line  pq P Q
foot  G F pq
prove { equal { sratio Q G G P } { 1 } }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 122

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('122','361','2670','6970',
                    '57.836000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 94 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0094','70
','Geometry','\\begin{geothm}
 Let $P$ and $Q$ be two points on side $BC$
 and $AD$ of a parallelogram such that
 $PQ \\parallel AB$; $M = AP \\cap BQ$,
 $N = DP \\cap QC$. Show that $MN \\parallel AD$
 and $MN = AD/2$.
\\end{geothm}','
',
        '
 Example 85 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0094','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0094','3','
dim  130 100
point  A 20 20
point  B 80 20
point  C 110 70
line  ab A B
line  bc B C
parallel  ad A bc
parallel  cd C ab
intersec  D ad cd
point  P 85.45 29.09
parallel  pq P ab
intersec  Q pq ad
line  pd P D
line  qc Q C
intersec  N pd qc
line  pa P A
line  qb Q B
intersec  M pa qb
cmark_b  M
cmark_b  A
cmark_t  N
cmark_b  B
cmark_t  C
cmark_t  D
cmark_r  P
cmark_l  Q
drawsegment  P D
drawsegment  P A
drawsegment  Q C
drawsegment  B Q
drawsegment  P Q
drawsegment  A B
drawsegment  A D
drawsegment  C B
drawsegment  C D
drawdashsegment  M N

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0094','2','
point  A 20 20
point  B 80 20
point  C 110 70
line  ab A B
line  bc B C
parallel  ad A bc
parallel  cd C ab
intersec  D ad cd
online  P  B C
parallel  pq  P  ab
intersec  Q  pq  ad
line  pd  P  D
line  qc  Q  C
intersec  N  pd  qc 
line  pa  P  A
line  qb  Q  B
intersec  M  pa  qb 
prove { equal { sratio A D M N } { 2 } }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 123

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('123','409','1240','5136',
                    '17.161000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 95 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0095','70
','Geometry','\\begin{geothm}
 Show that the sum of distances of a point
 on the base of an isosceles triangle to its
 two sides is equal to the altitudes on the
 sides.
\\end{geothm}','
',
        '
 Example 88 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0095','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0095','3','
dim  110 80
point  A 20 20
point  B 90 20
point  C 33.17 60.88
point  D 23.73 31.58
line  ab A B
line  bc B C
foot  E D ab
foot  F D bc
foot  H C ab
cmark_b  A
cmark_b  B
cmark_t  C
cmark_l  D
cmark_b  H
cmark_b  E
cmark_rt  F
drawsegment  A B
drawsegment  A C
drawsegment  C B
drawsegment  C H
drawsegment  D E
drawsegment  D F

','2008/03/26','70
')

sqlUpdatefigure

--- 96 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0096','70
','Geometry','\\begin{geothm}
 Given quadrilateral $ABCD$, let $M_1$ and $M_2$ be
 midpoints of diagonals $AC$ and $BD$, and let $O$
 be point on line $M_1M_2$. Show that the sum of
 areas of triangles $ABO$ and $CDO$ equals the half of the
 area of quadrilateral $ABCD$.
\\end{geothm}','
',
        '
 Leon Anne s Theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0096','3','
dim  110 110
point  A 20 20
point  B 90 20
point  C 75 85 
point  D 40 65
midpoint  M_1 A C
midpoint  M_2 B D
line  m12 M_1 M_2
point  O 31.05 61.90
line  ac A C
line  bd B D
drawline  ac
drawline  bd
drawdashline  m12
cmark_b  M_1
cmark_b  M_2
cmark_t  O
cmark_b  A
cmark_b  B
cmark_t  C
cmark_t  D
drawsegment  A B
drawsegment  C B
drawsegment  C D
drawsegment  A D

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0096','2','
point  A 20 20
point  B 90 20
point  C 75 85 
point  D 40 65
midpoint  M_1 A C
midpoint  M_2 B D
line  m12 M_1 M_2
online  O  M_1 M_2
line  ac A C
line  bd B D
prove { equal { mult { 2 } { sum { signed_area3 A B O } { signed_area3
C D O } } } { signed_area4 A B C D } }

','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 124

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('124','8','11','58',
                    '0.004000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 97 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0097','70
','Geometry','\\begin{geothm}
 Of the three lines joining the vertices
 of an equilateral triangle to a point
 on its circumcircle, one is equal to the
 sum of the other two.
\\end{geothm}','
',
        '
 Example 119 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0097','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0097','3','
dim  110 100
point  A 20 30
point  B 90 30
circle  k A B
med  mc A B
intersec2  C C1 k mc
med  mb A C
intersec  O mc mb
circle  k1 O A
point  P 75.80 84.86
cmark_lb  A
cmark_rb  B
cmark_rt  P
cmark_b  O
cmark_t  C
drawsegment  A B
drawsegment  A C
drawsegment  C B
drawdashsegment  P A
drawdashsegment  P B
drawdashsegment  P C
drawcircle  k1

','2008/03/26','70
')

sqlUpdatefigure

--- 98 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0098','70
','Geometry','\\begin{geothm}
 Three parallel lines drawn through the vertices
 of a triangle $ABC$ meet the respective opposite
 sides in the points $X$, $Y$, $Z$. Show that area ratio 
 $P_{XYZ} : P_{ABC} = 2 : 1$.
\\end{geothm}','
',
        '
 Example 120 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0098','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0098','3','
dim  110 100
point  A 50 50
point  B 90 50
point  C 75 80
point  X 82 66
line  ab A B
line  bc B C
line  ac A C
line  ax A X
parallel  cz C ax
parallel  by B ax
intersec  Y by ac
intersec  Z cz ab
cmark_t  Z
cmark_b  Y
cmark_rt  X      
cmark_b  A
cmark_b  B
cmark_t  C
drawsegment  Z B
drawsegment  Y C
drawsegment  Z X
drawsegment  A X
drawsegment  Y Z
drawsegment  B C
drawsegment  C Z
drawsegment  Y B
drawsegment  X Y

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0098','2','
point  A 50 50
point  B 90 50
point  C 75 80
online  X  B C
line  ab A B
line  bc B C
line  ac A C
line  ax  A X 
parallel  cz  C ax 
parallel  by  B ax 
intersec  Y  by  ac
intersec  Z  cz  ab
prove { equal { mult { 2 } { signed_area3 B A C } } { signed_area3 X Y Z } }

','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 125

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('125','32','114','238',
                    '0.036000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 99 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0099','70
','Geometry','\\begin{geothm}
 Let $PT$ and $PB$ be two tangents to a circle,
 $AB$ the diameter through $B$, and $TH$
 the perpendicular from $T$ to $AB$. Then
 $AP$ bisects $TH$.
\\end{geothm}','
',
        '
 Example 37 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0099','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0099','3','
dim  130 110
point  A 30 50
point  B 90 50 
midpoint  O A B
circle  k O A
point  T 69.10 78.59
line  ab A B
perp  bp B ab
line  ot O T
perp  tp T ot
intersec  P bp tp
foot  H T ab
line  th T H
line  ap A P
intersec  I th ap
cmark_lb  A
cmark_b  H
cmark_b  O
cmark_rb  B
cmark_r  P
cmark_t  T
cmark_rb  I
drawsegment  A B
drawsegment  A P
drawsegment  T H
drawsegment  T O
drawsegment  P B
drawsegment  P T
drawcircle  k

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0099','2','
point  A 30 50
point  B 90 50 
midpoint  O A B
circle  k O A
oncircle  T  O A
line  ab A B
perp  bp B ab
line  ot O T
perp  tp T ot
intersec  P bp tp
foot  H T ab
line  th T H
line  ap A P
intersec  I th ap
prove { equal { sratio T I I H } { 1 } }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 126

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('126','14','75','394',
                    '0.056000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 100 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0100','70
','Geometry','\\begin{geothm}
 If a quadrangle $ABCD$ has its opposite sides $AD$
 and $BC$ (extended) meeting at $W$, while $X$ and $Y$
 are the midpoints of the diagonals $AC$ and $BD$,
 then $(WXY) = 1/4(ABCD)$.
\\end{geothm}','
',
        '
 Example 42 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0100','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0100','3','
dim  110 90
point  A 20 20
point  B 60 20
point  C 50 50
point  D 35 65
line  ab A B
line  cd C D
intersec  W ab cd
midpoint  X A C
midpoint  Y B D
cmark_b  X
cmark_b  Y
cmark_b  W
cmark_b  A
cmark_b  B
cmark_t  C
cmark_t  D
drawsegment  A W
drawsegment  C B
drawsegment  D W
drawsegment  A D
drawdashsegment  B D
drawdashsegment  C A
drawsegment  X Y
drawsegment  X W
drawsegment  Y W

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0100','2','
point  A 20 20
point  B 60 20
point  C 50 50
point  D 35 65
line  ab A B
line  cd C D
intersec  W ab cd
midpoint  X A C
midpoint  Y B D
prove { equal { mult { 4 } { signed_area3 X W Y } } { signed_area4 A B C D } }

','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 127

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('127','6','21','63',
                    '0.004000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 101 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0101','70
','Geometry','\\begin{geothm}
 If lines $A_1B_1$, $A_2B_2$ and $A_3B_3$ are
 concurrent, show that intersections
 $A_1A_2 \\cap B_1B_2$, $A_1A_3 \\cap B_1B_3$
 and $A_2A_3 \\cap B_2B_3$ are collinear.
\\end{geothm}','
',
        '
 Desargues  theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0101','3','
dim  110 90
point  S 20 30
point  A_2 36.60 30
point  B_2 53.00 30
point  A_1 27.20 24.70
point  B_1 38.40 16.434
point  A_3 42.20 41.10 
point  B_3 56 48
line  a12 A_1 A_2
line  a13 A_1 A_3
line  a23 A_2 A_3
line  b12 B_1 B_2
line  b13 B_1 B_3
line  b23 B_2 B_3
intersec  P a12 b12
intersec  Q a13 b13
intersec  R a23 b23
line  pqr P Q
drawdashline  pqr
drawline  a12
drawline  a13
drawline  a23
drawline  b12
drawline  b13 
drawline  b23
cmark_t  P
cmark_l  Q
cmark_l  R
cmark_b  A_1
cmark_rb  A_2
cmark_rb  A_3
cmark_b  B_1
cmark_rb  B_2
cmark_rb  B_3
cmark_b  S
line  sa1 S A_1
line  sa2 S A_2
line  sa3 S A_3
drawline  sa1
drawline  sa2
drawline  sa3

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0101','2','
point  S 20 30
point  A_2 36.60 30
point  B_2 53.00 30
point  A_1 27.20 24.70
online  B_1  S A_1
point  A_3 42.20 41.10 
online  B_3  S A_3
line  a12 A_1 A_2
line  a13 A_1 A_3
line  a23 A_2 A_3
line  b12 B_1 B_2
line  b13 B_1 B_3
line  b23 B_2 B_3
intersec  P a12 b12
intersec  Q a13 b13
intersec  R a23 b23
prove { collinear P Q R }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 128

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('128','47','113','449',
                    '0.208000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 102 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0102','70
','Geometry','\\begin{geothm}
 Given triangle $ABC$, let $A_1$, $B_1$ and $C_1$
 endpoints of triangle altitudes. From each of
 points $A_1$, $B_1$ and $C_1$ feet are drawn upon
 triangle sides, those are: $A_2$, $A_3$, $B_2$,
 $B_3$, $C_2$ and $C_3$. Show that these six
 points lie on a circle.
\\end{geothm}','
',
        '
  Six Points Circle

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0102','3','
dim  130 100
point  A 20 20
point  B 90 20
point  C 70 70
line  ac A C
line  ab A B
line  bc B C
foot  A_1 A bc
foot  B_1 B ac
foot  C_1 C ab
foot  C_2 C_1 bc
foot  C_3 C_1 ac
foot  A_2 A_1 ac
foot  A_3 A_1 ab
foot  B_2 B_1 bc
foot  B_3 B_1 ab
med  p B_3 A_3
med  q B_3 C_3
intersec  O p q
circle  k O B_3
cmark_b  A
cmark_b  B
cmark_t  C
cmark_r  A_1
cmark_l  B_1
cmark_b  C_1
cmark_b  A_3
cmark_b  B_3
cmark_l  C_3
cmark_lt  A_2
cmark_r  C_2
cmark_rt  B_2
drawsegment  A B
drawsegment  A C
drawsegment  C B
drawdashsegment  A A_1
drawdashsegment  B B_1
drawdashsegment  C C_1
drawdashsegment  C_1 C_2
drawdashsegment  C_1 C_3
drawdashsegment  A_1 A_2
drawdashsegment  A_1 A_3
drawdashsegment  B_1 B_2
drawdashsegment  B_1 B_3
drawcircle  k

','2008/03/26','70
')

sqlUpdatefigure

--- 103 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0103','70
','Geometry','\\begin{geothm}
 If quadrilateral $ABCD$ is inscribed in circle,
 show that angles $\\angle ACB$ and $\\angle ADB$
 are equal.
\\end{geothm}','
',
        '
 Quadrilateral Inscribed in Circle

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0103','3','
dim  110 90
point  A 40 20
point  B 70 20
point  X 56 45
line  ax A X
med  m A B
intersec  O ax m
circle  k O A
drawcircle  k
point  C 33.76 61.42
point  D 69.32 67.30
drawsegment  C A
drawsegment  C B
drawsegment  D A
drawsegment  D B
cmark_lt  C
cmark_rt  D
cmark_lb  A
cmark_rb  B
drawsegment  A B

','2008/03/26','70
')

sqlUpdatefigure

--- 104 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0104','70
','Geometry','\\begin{geothm}
 Let $H$ and $O$ be the orthocenter
 and circumcenter of triangle $ABC$.
 Show
 $\\angle HAC = | \\angle B - \\angle C |$.
\\end{geothm}','
',
        '
 Example 30 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0104','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0104','3','
dim  130 110
point  C 20 30
point  B 110 30
point  A 90 95
line  ab A B
line  ac A C
line  bc B C
foot  D A bc
foot  B_1 B ac
line  ha A D
line  hb B B_1
intersec  H ha hb
med  ma A B
med  mb A C
intersec  O ma mb
circle  k O A
cmark_lb  C
cmark_rb  B
cmark_rt  A
cmark_r  H
cmark_l  O
cmark_b  D
drawsegment  A B
drawsegment  A C
drawsegment  B C
drawsegment  A D
drawcircle  k
drawsegment  O A
drawsegment  H A

','2008/03/26','70
')

sqlUpdatefigure

--- 105 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0105','70
','Geometry','\\begin{geothm}
 Hexagon $ABCDEF$ is incsibed in a circle with
 center $O$. Show that three points at which
 pairs of opposite sides meet, lie on a
 straight line.
\\end{geothm}','
',
        '
 Pascal s Theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0105','3','
dim  100 100
point  A 20.50 51.40
point  O 50 50
circle  k O A
point  B 60.40 77.60
point  C 72.30 69.20
point  D 21.40 42.10
point  E 51.30 20.60
point  F 78.20 41.90
line  ab A B
line  df D F
line  bc B C
line  fe F E
line  cd C D
line  ea E A
drawdashline  ab
drawdashline  df
drawdashline  bc
drawdashline  fe
drawdashline  cd
drawdashline  ea
intersec  P ab df
intersec  Q bc fe
intersec  S cd ea
cmark_lt  A
cmark_t  O
cmark_t  B
cmark_t  C
cmark_lb  D
cmark_t  E
cmark_lt  F
cmark_t  P
cmark_t  Q
cmark_t  S
drawcircle  k
line  pqs P Q
drawline  pqs

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0105','2','
point  A 20.50 51.40
point  O 50 50
circle  k O A
oncircle  B  O A
oncircle  C  O A
oncircle  D  O A
oncircle  E  O A
oncircle  F  O A
line  ab A B
line  df D F
line  bc B C
line  fe F E
line  cd C D
line  ea E A
intersec  P ab df
intersec  Q bc fe
intersec  S cd ea
line  pqs P Q
prove { collinear P Q S }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 129

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('129','6','8','49',
                    '0.008000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 106 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0106','70
','Geometry','\\begin{geothm}
 Let $ABC$ be a triangle with $\\angle B = 2\\angle C$,
 D the foot of the altitude on $CB$ and $M$ the
 midpoint of $B$ and $C$. Show that $AB = 2DM$.
\\end{geothm}','
',
        '
 Example 86 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0106','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0106','3','
dim  110 80
point  C 20 20
point  B 90 20
line  bc B C
med  m B C
point  A_1 80 60
line  ab A_1 B
intersec  F ab m
bis  ca B C F
intersec  A ca ab
intersec  M bc m
foot  D A bc
cmark_b  C
cmark_b  B
cmark_r  A
cmark_b  M
cmark_b  D
drawsegment  B C
drawsegment  A C
drawsegment  B A
drawsegment  D A
drawsegment  M A

','2008/03/26','70
')

sqlUpdatefigure

--- 107 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0107','70
','Geometry','\\begin{geothm}
 Given a triangle $ABC$ and a point $X$, the sum
 of the distances of the line $XG$, where $G$ is the
 centroid of $ABC$, to the two vertices of the triangle
 situated on the same side of the line is equal to the
 distance of the line from the third vertex.
\\end{geothm}','
',
        '
 Example 20 (Chou88)

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0107','3','
dim  110 100
point  A 20 20
point  C 65 80
point  T 55 45
towards  A_1 A T 1.5
towards  C_1 C T 1.5
line  bc C A_1
line  ab A C_1
intersec  B ab bc
point  X 95 45
line  gx T X
foot  D A gx
foot  E B gx
foot  F C gx
cmark_t  D
cmark_t  E
cmark_b  F
cmark_lt  T
cmark_b  A
cmark_b  B
cmark_t  C
cmark_t  X
drawline  gx
drawsegment  A B
drawsegment  A C
drawsegment  C B
drawsegment  A A_1
drawsegment  C C_1
drawdashsegment  A D
drawdashsegment  B E
drawdashsegment  C F

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0107','2','
point  A 20 20
point  C 65 80
point  T 55 45
towards  A_1 A T 1.5
towards  C_1 C T 1.5
line  bc C A_1
line  ab A C_1
intersec  B ab bc
point  X 95 45
line  gx T X
foot  D A gx
foot  E B gx
foot  F C gx
prove { equal { sum { sum { sratio A D A D } { sratio B E A D } } { sratio C F A D } } { 0 } }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 130

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('130','25','75','216',
                    '0.020000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 108 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0108','70
','Geometry','\\begin{geothm}
 Given a parallelogram $ABCD$, a point $N$,
 obtained by the intersection of a line parallel
 to $BD$ passing through $C$, and a line perpendicular
 to $BD$ passing through $A$, then the point $Q$,
 which is given by the intersection of $BN$ and $CD$,
 is the midpoint of $PC$, where $P$ is the intersection
 of $CD$ and $AN$,
\\end{geothm}','
',
        '
 Example 22 (Chou88)

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0108','3','
dim  110 90
point  A 20 20
point  B 70 20
point  C 85 60
line  ab A B
line  bc B C
parallel  ad A bc
parallel  cd C ab
intersec  D ad cd
line  bd B D
parallel  cn C bd
perp  an A bd
intersec  N cn an
line  bn B N
intersec  P cd an
intersec  Q bn cd
drawline  cn
drawline  an
drawsegment  A N
drawsegment  B N
drawsegment  B D
cmark_lt  P
cmark_lb  Q
cmark_t  N
cmark_b  A
cmark_b  B
cmark_t  C
cmark_t  D
drawsegment  A B
drawsegment  C B
drawsegment  C D
drawsegment  A D

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0108','2','
point  A 20 20
point  B 70 20
point  C 85 60
line  ab A B
line  bc B C
parallel  ad A bc
parallel  cd C ab
intersec  D ad cd
line  bd B D
parallel  cn C bd
perp  an A bd
intersec  N cn an
line  bn B N
intersec  P cd an
intersec  Q bn cd
prove { equal { sratio P Q Q C } { 1 } }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 131

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('131','501','936','8564',
                    '119.311000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 109 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0109','70
','Geometry','\\begin{geothm}
 Assume $S_1$, $S_2$, $S_3$ are the points of contact 
 of the incircle of $ABC$: $S_1$ on side $AC$, etc.
 Denote the intersection of $BC$ and $S_1S_3$ as $P$,
 that of $AC$ and $S_2S_3$ as $Q$, and let $R$ 
 be the intersection of $AB$ 
 and $S_1S_2$. Then points $P$, $Q$, and $R$ are collinear.
\\end{geothm}','
',
        '
 Nobbs  Theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0109','3','
dim  130 130
point  X 20 20
point  Y 25 20
point  S_3 65 20
point  O 65 32
line  ab X Y
circle  k O S_3
point  S_1 75.90 36.70
point  S_2 60.10 42.90
line  os2 O S_2
line  os1 O S_1
perp  as1 S_1 os1
perp  bs2 S_2 os2
intersec  A ab as1
intersec  B ab bs2
intersec  C as1 bs2
line  s13 S_1 S_3
intersec  P s13 bs2
line  s23 S_2 S_3
intersec  Q s23 as1
line  s12 S_1 S_2
intersec  R s12 ab
line  pqr P Q
drawcircle  k
drawline  pqr
drawdashline  s23
drawdashline  s13
drawdashline  s12
drawdashsegment  C P
drawdashsegment  C Q
drawdashsegment  A R
cmark_b  R
cmark_rt  Q
cmark_r  P
cmark_t  C
cmark_b  A
cmark_b  B
cmark_l  S_1
cmark_b  S_2
cmark_rb  S_3
drawsegment  A C
drawsegment  A B
drawsegment  B C

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0109','2','
point  X 20 20
point  Y 25 20
point  S_3 65 20
point  O 65 32
line  ab X Y
circle  k O S_3
oncircle  S_1  O S_3
oncircle  S_2  O S_3
line  os2 O S_2
line  os1 O S_1
perp  as1 S_1 os1
perp  bs2 S_2 os2
intersec  A ab as1
intersec  B ab bs2
intersec  C as1 bs2
line  s13 S_1 S_3
intersec  P s13 bs2
line  s23 S_2 S_3
intersec  Q s23 as1
line  s12 S_1 S_2
intersec  R s12 ab
line  pqr P Q
prove { collinear P Q R }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 132

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('132','10','40','295',
                    '0.064000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 110 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0110','70
','Geometry','\\begin{geothm}
 Line $p$ intersects lines $AB$, $AC$ and $BC$
 at points $F$, $E$ and $D$ respectively. Show that:
\\end{geothm}','
',
        '
 Menelaus s Theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0110','3','
dim  100 80
point  A 30 20
point  B 60 20
point  C 40 50
line  c A B
point  D 53.33 30
point  E 36.66 40
line  p D E 
intersec  F c p
drawsegment  A B
drawsegment  A C
drawsegment  B C
drawline  D E 
drawline  A B
cmark_b  A
cmark_b  B
cmark_t  C
cmark_rt  D
cmark_lt  E
cmark_rt  F

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0110','2','
point  A 30 20
point  B 60 20
point  C 40 50
line  c A B
online  D  B C 
online  E  A C 
line  p D E 
intersec  F c p
prove { equal { mult { mult { sratio A F F B } { sratio B D D C } } { sratio C E E A } } -1 }

','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 133

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('133','24','52','175',
                    '0.016000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 111 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0111','70
','Geometry','\\begin{geothm}
 A tranversal curs the sides $BC$, $CA$, $AB$
 of triangle $ABC$ in $D$, $E$, $F$. $P$, 
 $Q$, $R$ are the midpoints of $EF$, $FD$,
 $DE$ and $AP$, $BQ$, $CR$ intersec $BC$, $CA$,
 $AB$ in $X$, $Y$, $Z$. Show that $X$, $Y$, $Z$ are collinear.
\\end{geothm}','
',
        '
 Example 25 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0111','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0111','3','
dim  150 110
point  A 20 20
point  B 70 20
point  C 60 70
line  ab A B
line  bc B C
line  ac A C
point  F 63 20
point  D 66.06 39.70
line  fd F D
intersec  E fd ac
midpoint  P E F
midpoint  Q F D
midpoint  R D E
line  ap A P
line  bq B Q
line  cr C R
intersec  X ap bc
intersec  Y bq ac
intersec  Z cr ab
line  xyz X Y
drawdashline  xyz
cmark_lb  X
cmark_t  Y
cmark_b  Z
cmark_r  P
cmark_l  Q
cmark_r  R
cmark_t  E
cmark_b  F
cmark_r  D
cmark_b  A
cmark_b  B
cmark_t  C
drawsegment  A P
drawsegment  B Y
drawsegment  C Z
drawsegment  A Z
drawsegment  C B
drawsegment  A E
drawsegment  F E

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0111','2','
point  A 20 20
point  B 70 20
point  C 60 70
line  ab A B
line  bc B C
line  ac A C
online  F  A B
online  D  B C
line  fd F D
intersec  E fd ac
midpoint  P E F
midpoint  Q F D
midpoint  R D E
line  ap A P
line  bq B Q
line  cr C R
intersec  X ap bc
intersec  Y bq ac
intersec  Z cr ab
line  xyz X Y
prove { collinear X Y Z }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Failed to prove the conjecture'
                        WHERE demId = 134

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('134','','','',
                    '','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 112 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0112','70
','Geometry','\\begin{geothm}
 In a hexagon $AC_1BA_1CB_1$, $BB_1$, $C_1A$,
 $A_1C$ are concurrent and $CC_1$, $A_1B$, $B_1A$
 are concurrent. Prove that $AA_1$, $B_1C$, $C_1B$
 are also concurrent.
\\end{geothm}','
',
        '
 Example 28 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0112','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0112','3','
dim  110 90
point  A 30 20
point  C_1 58 20
point  B 20 37
point  A_1 37 50
point  C 60 35
line  ac1 A C_1
line  a1c A_1 C
intersec  O ac1 a1c
line  ba1 B A_1
line  cc1 C C_1
intersec  H ba1 cc1
line  ah A H
line  bo B O
intersec  B_1 bo ah
line  cb1 C B_1
line  bc1 B C_1
intersec  I cb1 bc1
cmark_rb  B_1
cmark_t  H
cmark_rb  A
cmark_b  C_1
cmark_lb  B
cmark_lt  A_1
cmark_rt  C
cmark_b  O
drawsegment  B H
drawsegment  A H
drawsegment  C_1 H
drawsegment  A O
drawsegment  B O
drawsegment  A_1 O
drawsegment  A B
drawsegment  B C
drawdashline  C B_1
drawdashline  B C_1
drawdashline  A A_1

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0112','2','
point  A 30 20
point  C_1 58 20
point  B 20 37
point  A_1 37 50
point  C 60 35
line  ac1 A C_1
line  a1c A_1 C
intersec  O ac1 a1c
line  ba1 B A_1
line  cc1 C C_1
intersec  H ba1 cc1
line  ah A H
line  bo B O
intersec  B_1 bo ah
line  cb1 C B_1
line  bc1 B C_1
intersec  I cb1 bc1
prove { collinear A A_1 I }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 135

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('135','8','15','85',
                    '0.004000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 113 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0113','70
','Geometry','\\begin{geothm}
 In a triangle $ABC$, let $p$ and $q$ be the radii of two
 circles through $A$, touching side $BC$ at $B$ and $C$,
 respectively. Then $pq = R^2$.
\\end{geothm}','
',
        '
 Example 29 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0113','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0113','3','
dim  90 90
point  B 20 20
point  C 70 20
point  A 55 60
med  ma B C
med  mb A C
intersec  O ma mb
line  bc B C
perp  p B bc
med  mc A B
intersec  P p mc
perp  q C bc
intersec  Q mb q
circle  k1 Q A
circle  k2 P A
drawcircle  k1
drawcircle  k2
cmark_t  P
cmark_t  Q
cmark_b  B
cmark_b  C
cmark_t  A
cmark_t  O
drawsegment  P B
drawsegment  P A
drawsegment  Q C
drawsegment  Q A
drawdashsegment  O B
drawdashsegment  O C
drawsegment  A B
drawsegment  C B
drawsegment  A C

','2008/03/26','70
')

sqlUpdatefigure

--- 114 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0114','70
','Geometry','\\begin{geothm}
 $OH^2 = 9R^2 - a^2 - b^2 - c^2$.
\\end{geothm}','
',
        '
 Example 31 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0114','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0114','3','
dim  90 90
point  A 20 20
point  B 70 20
point  C 55 70
med  ma B C
med  mc A B
intersec  O ma mc
line  ab A B
perp  ch C ab
line  ac A C
perp  bh B ac
intersec  H ch bh
intersec  D ch ab
circle  k O A
drawcircle  k
cmark_b  O
cmark_l  H
cmark_lb  A
cmark_rb  B
cmark_t  C
drawsegment  C D
drawsegment  C O
drawsegment  A O
drawsegment  A B
drawsegment  A C
drawsegment  C B

','2008/03/26','70
')

sqlUpdatefigure

--- 115 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0115','70
','Geometry','\\begin{geothm}
 The sum of distances of a point inside
 an equilateral triangle or on 
 one of its sides to the three triangle segments, 
 equals the 
 length of its altitude.
\\end{geothm}','
',
        '
 Viviani s Theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0115','3','
dim  110 100
point  A 20 20
point  B 90 20
point  P 65 40
circle  k A B
med  p A B
intersec2  C C1 k p
line  ab A B
intersec  D ab p
line  bc B C
line  ac A C
foot  G P ac
foot  F P bc
foot  E P ab
foot  H P p
cmark_b  D
cmark_b  A
cmark_b  B
cmark_t  C
cmark_t  P
cmark_l  H
cmark_lt  G
cmark_rt  F
cmark_b  E
drawsegment  A B
drawsegment  A C
drawsegment  C B
drawsegment  C D
drawsegment  P H
drawsegment  P G
drawsegment  P F
drawsegment  P E

','2008/03/26','70
')

sqlUpdatefigure

--- 116 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0116','70
','Geometry','\\begin{geothm}
 Show that every triangle has incenter.
\\end{geothm}','
',
        '
 Incenter Exists Theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0116','3','
dim  110 110
point  A 20 20
point  B 90 20
point  C 70 90
bis  sa B A C
bis  sc A C B
bis  sb C B A
intersec  S sa sb
line  ab A B
intersec  C1 sc ab
cmark_rb  S
drawdashline  sa
drawdashline  sb
drawdashline  sc
cmark_b  A
cmark_b  B
cmark_lt  C
drawsegment  A B
drawsegment  C B
drawsegment  A C

','2008/03/26','70
')

sqlUpdatefigure

--- 117 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0117','70
','Geometry','\\begin{geothm}
 The feet of the four perpendiculars
 dropped from a vertex of a triangle
 upon the four bisectors of the other
 two angles are collinear.
\\end{geothm}','
',
        '
 Example 152 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0117','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0117','3','
dim  120 110
point  A 30 30
point  B 100 30
point  C 50 88
bis  s1 B A C
bis  s2 A B C
perp  s3 A s1
perp  s4 B s2
foot  P C s1
foot  Q C s2
foot  R C s3
foot  S C s4
cmark_b  A
cmark_rb  B
cmark_t  C
cmark_b  P
cmark_lb  Q
cmark_lb  R
cmark_rb  S
line  p P Q
drawline  p
drawdashline  s1
drawdashline  s2
drawdashline  s3
drawdashline  s4
line  a A B
drawline  a
drawsegment  A C
drawsegment  C B
drawsegment  C P
drawsegment  C Q
drawsegment  C R
drawsegment  C S

','2008/03/26','70
')

sqlUpdatefigure

--- 118 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0118','70
','Geometry','\\begin{geothm}
 Isosceles right triangle $ABC$ with right angle
 at point $C$ is given. Let $E$ be a point on side $AC$
 of a triangle. Let $D$ be the intersection of a line
 passing through $E$ parallel with line $AB$ and a line.
 $BC$. Let $p$ and $q$ be lines perpendicular with
 line $BE$ passing through points $D$ and $C$, and
 let $K$ and $L$ be intersections of lines $p$ and $q$
 with hypotenuse $AB$. Show that $L$ is a midpoint
 of a segment $KA$.
\\end{geothm}','
',
        '
 Isosceles Right Triangle Problem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0118','3','
dim  110 110
point  C 20 20
point  A 90 20
circle  k C A
line  ac A C
perp  bc C ac
intersec2  B B1 bc k
point  E 47 20
line  ab A B
line  be B E
parallel  ed E ab
intersec  D ed bc
perp  cl C be
perp  dk D be
intersec  L cl ab
intersec  K dk ab
cmark_rt  K
cmark_rt  L
cmark_b  E
cmark_l  D
cmark_t  B
cmark_b  C
cmark_b  A
drawdashsegment  D E
drawsegment  E B
drawsegment  A C
drawsegment  A B
drawsegment  B C
drawsegment  D K
drawsegment  C L

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0118','2','
point  C 20 20
point  A 90 20
circle  k C A
line  ac A C
perp  bc C ac
intersec2  B B1 bc k
online  E  A C
line  ab A B
line  be B E
parallel  ed E ab
intersec  D ed bc
perp  cl C be
perp  dk D be
intersec  L cl ab
intersec  K dk ab
prove { equal { sratio K L L A } { 1 } }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 136

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('136','289','1278','8434',
                    '18.081000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 119 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0119','70
','Geometry','\\begin{geothm}
 $P_1$, $P_2$, $P_3$ and $P_4$ are four points on
 circle $k$ with a center $O$. 
 $M$ is the intersection of $P_1P_3$ and
 $P_2P_4$. Through $M$ draw a line $l$ perpendicular
 to $OM$, meeting $P_2P_3$ at $X$ and $P_1P_4$ at $Y$.
 Show that $MX \\cong MY$.
\\end{geothm}','
',
        '
 Butterfly theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0119','3','
dim  100 100
point  P_1 32 40
point  O 62 40
circle  k O P_1
point  P_2 35.80 25.50
point  P_3 62.80 69.90
point  P_4 77.80 14.80 
line  p1p3 P_1 P_3
line  p2p4 P_2 P_4
line  p1p4 P_1 P_4
line  p2p3 P_2 P_3
intersec  M p1p3 p2p4
line  om O M
perp  l M om
intersec  X l p2p3
intersec  Y l p1p4
cmark_l  P_1
cmark_l  P_2
cmark_lt  P_3
cmark_b  P_4
cmark_b  O
cmark_lt  M
cmark_l  X
cmark_t  Y
drawcircle  k
drawdashline  p1p3
drawdashline  p2p4
drawdashline  p1p4
drawdashline  p2p3
drawsegment  X Y

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0119','2','
point  P_1 32 40
point  O 62 40
circle  k O P_1
oncircle  P_2  O P_1
oncircle  P_3  O P_1
oncircle  P_4  O P_1
line  p1p3  P_1 P_3 
line  p2p4  P_2  P_4 
line  p1p4  P_1 P_4 
line  p2p3  P_2  P_3 
intersec  M  p1p3  p2p4 
line  om  O M 
perp  l  M  om 
intersec  X  l  p2p3 
intersec  Y  l  p1p4 
prove { equal { sratio X M M Y } { 1 } }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 137

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('137','29','81','597',
                    '0.264000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 120 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0120','70
','Geometry','\\begin{geothm}
 Prove that the angle over circle diameter is right angle.
\\end{geothm}','
',
        '
 Right Angle over Circle Diameter

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0120','3','
dim  110 110
point  A 20 55
point  B 90 55
midpoint  O A B
circle  k O A
point  C 76.49 82.62
cmark_t  C
drawsegment  A C
drawsegment  B C
drawcircle  k
cmark_l  A
cmark_r  B
drawsegment  A B

','2008/03/26','70
')

sqlUpdatefigure

--- 121 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0121','70
','Geometry','\\begin{geothm}
 Let a quadrilateral $ABCD$ be inscribed in a circle. 
 Then the sum of the products of the two pairs of 
 opposite sides equals the product of its 
 two diagonals. In other words,
 $AD \\cdot BC + AB \\cdot CD = AC \\cdot BD$.
\\end{geothm}','
',
        '
 Ptolemy s Theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0121','3','
dim  110 95
point  A 20 30
point  B 90 30
point  C 60 80
med  p A B
med  q B C      
intersec  O p q
circle  k O A
point  D 30.42 71.10
cmark_lb  A
cmark_rb  B
cmark_rt  C
cmark_lt  D
cmark_b  O
drawsegment  A B
drawsegment  A D
drawsegment  A D
drawsegment  C B
drawsegment  D B
drawsegment  C D
drawsegment  C A
drawcircle  k

','2008/03/26','70
')

sqlUpdatefigure

--- 122 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0122','70
','Geometry','\\begin{geothm}
 Given triangle $ABC$, let $p$ be line through $A$ parallel
 with $BC$, and let $q$ be line through $C$ parallel
 with $AB$. Let $p$ and $q$ intersects at $D$. 
 Let $BD$ intersect $AC$ at $E$. Show that:
 $\\overline{AE} = \\overline{EC}$.
\\end{geothm}','
',
        '
 Parallelogram Theorem 2

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0122','3','
dim  130 70
point  A 20 20
point  B 80 20
point  C 97.60 51.50
line  ab A B
line  bc B C
parallel  p A bc
parallel  q C ab
intersec  D p q
cmark_b  A
cmark_b  B
cmark_t  C
cmark_t  D
drawsegment  A B
drawsegment  C B
drawsegment  A D
drawsegment  C D
line  ac A C
line  bd B D
intersec  E ac bd
cmark_t  E
drawdashsegment  A C
drawdashsegment  B D

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0122','2','
point  A 20 20
point  B 80 20
point  C 97.60 51.50
line  ab A B
line  bc B C
parallel  p A bc
parallel  q C ab
intersec  D p q
line  ac A C
line  bd B D
intersec  E ac bd
prove { equal { sratio A E E C } { 1 } }
prove { same_length A E E C }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 138

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('138','48','109','375',
                    '0.036000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 123 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0123','70
','Geometry','\\begin{geothm}
 Show that each triangle has circumscribed circle.
\\end{geothm}','
',
        '
 Circumscribed Circle Exists Theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0123','3','
dim  95 95
point  A 30 20
point  B 70 20
point  C 60 80 
med  b A C 
med  a C B 
intersec  O a b 
midpoint  M A B
drawsegment  A B
drawsegment  A C
drawsegment  B C
drawsegment  A O
drawsegment  B O
drawsegment  C O
cmark_b  A
cmark_b  B
cmark_t  C
cmark_l  O
drawcircle  O A 
drawdashsegment  O M
cmark_b  M

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0123','2','
point  A 30 20
point  B 70 20
point  C 60 80 
med  b A C 
med  a C B 
intersec  O a b 
midpoint  M A B
prove { perpendicular O M A B }

','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 139

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('139','45','129','389',
                    '0.040000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 124 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0124','70
','Geometry','\\begin{geothm}
 If we draw line segments between the midpoints,
 in order, of any quadrilateral, we get a parallelogram 
 which has half the area of the original 
 quadrilateral.
\\end{geothm}','
',
        '
 Varignon s Theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0124','3','
dim  100 100
point  A 20 20
point  B 80 20
point  C 70 70
point  D 30 50
midpoint  P A B
midpoint  Q B C
midpoint  R C D
midpoint  S D A
cmark_b  A
cmark_b  B
cmark_t  C
cmark_t  D
cmark_b  P
cmark_r  Q
cmark_t  R
cmark_l  S
drawsegment  A B
drawsegment  C B
drawsegment  C D
drawsegment  A D
drawdashsegment  P Q
drawdashsegment  R Q
drawdashsegment  R S
drawdashsegment  P S

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0124','2','
point  A 20 20
point  B 80 20
point  C 70 70
point  D 30 50
midpoint  P A B
midpoint  Q B C
midpoint  R C D
midpoint  S D A
prove { parallel P Q R S }
prove { same_length P Q R S }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 140

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('140','12','29','106',
                    '0.004000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 125 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0125','70
','Geometry','\\begin{geothm}
 Quadrilateral $ABCD$ is given such that diagonals
 $AC$ and $BD$ intersect at right angle. Let $A_1$,
 $B_1$, $C_1$ and $D_1$ be midpoints of quadrilateral
 sides $AB$, $BC$, $CD$ and $DA$ respectively.
 Let $A_2$, $B_2$, $C_2$ and $D_2$ be feet from points
 $A_1$, $B_1$, $C_1$ and $D_1$ upon lines $CD$, $DA$,
 $AB$ and $BC$ respectively. Show that eight points
 $A_1$, $B_1$, $C_1$, $D_1$, $A_2$, $B_2$, $C_2$ and $D_2$
 lie on a circle.
\\end{geothm}','
',
        '
 Eight Points Circle

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0125','3','
dim  130 110
point  A 20 35
point  C 110 35
point  B 80 20
point  D 80 75
midpoint  A_1 A B
midpoint  B_1 B C
midpoint  C_1 C D
midpoint  D_1 D A
line  cd C D
line  da D A
line  ab A B
line  bc B C
foot  A_2 A_1 cd
foot  B_2 B_1 da
foot  C_2 C_1 ab
foot  D_2 D_1 bc
midpoint  O A_1 C_1
circle  k O A_1
drawcircle  k
drawsegment  A B
drawsegment  C B
drawsegment  A D
drawsegment  A C
drawsegment  D B
drawsegment  D C
drawdashsegment  A_1 A_2
drawdashsegment  B_1 B_2
drawdashsegment  C_1 C_2
drawdashsegment  D_1 D_2
drawdashsegment  B D_2
drawdashsegment  B C_2
cmark_b  A
cmark_b  B
cmark_b  C
cmark_t  D
cmark_b  A_1
cmark_rb  B_1
cmark_rt  C_1
cmark_lt  D_1
cmark_rt  A_2
cmark_lt  B_2
cmark_b  C_2
cmark_b  D_2

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0125','2','
point  A 20 35
point  C 110 35
point  B 80 20
point  D 80 75
midpoint  A_1 A B
midpoint  B_1 B C
midpoint  C_1 C D
midpoint  D_1 D A
line  cd C D
line  da D A
line  ab A B
line  bc B C
foot  A_2 A_1 cd
foot  B_2 B_1 da
foot  C_2 C_1 ab
foot  D_2 D_1 bc
midpoint  O A_1 C_1
circle  k O A_1
prove { perpendicular A_1 B_1 B_1 C_1 }
prove { perpendicular A_1 D_1 D_1 C_1 }
prove { perpendicular A_1 A_2 A_2 C_1 }

','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 141

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('141','10','40','128',
                    '0.004000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 126 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0126','70
','Geometry','\\begin{geothm}
 A line passing through the intersection $O$ of the
 diagonals of parallelogram $ABCD$ meets the four sides
 at $E$, $F$, $G$, $H$. Show that $EF \\cong GH$.
\\end{geothm}','
',
        '
 Example 84 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0126','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0126','3','
dim  130 110
point  A 30 30
point  B 110 30
point  C 90 80
line  ab A B
line  bc B C
parallel  cd C ab
parallel  ad A bc
intersec  D cd ad
point  H 79.97 105.07
line  bd B D
line  ac A C
intersec  O ac bd
line  oh O H
intersec  F oh cd
intersec  G oh ab
intersec  E oh ad
cmark_lb  A
cmark_b  B
cmark_r  C
cmark_t  D
cmark_lt  F
cmark_b  O
cmark_l  H
cmark_r  E
drawsegment  A B
drawsegment  H B
drawsegment  C D
drawsegment  E D
drawsegment  E H
drawsegment  A C
drawsegment  B D

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0126','2','
point  A 30 30
point  B 110 30
point  C 90 80
line  ab A B
line  bc B C
parallel  cd C ab
parallel  ad A bc
intersec  D cd ad
online  H  B C
line  bd B D
line  ac A C
intersec  O ac bd
line  oh O H
intersec  F oh cd
intersec  G oh ab
intersec  E oh ad
prove { equal { sratio E F G H } { 1 } }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 142

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('142','443','1127','6333',
                    '52.675000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 127 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0127','70
','Geometry','\\begin{geothm}
 Let $D$ be a point on the side $CB$ of a right triangle
 $ABC$ such that the circle ($O$) with diameter $CD$
 touches the hypotenuses $AB$ at $E$. Let
 $F = AC \\cap DE$. Show that $AF \\cong AE$
\\end{geothm}','
',
        '
 Example 91 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0127','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0127','3','
dim  130 110
point  C 20 30
point  D 70 30
line  cd C D
midpoint  O C D
circle  k O C
point  E 53.34 53.57
line  oe O E
perp  ab E oe
perp  ac C cd
intersec  A ac ab
intersec  B ab cd
line  de D E
intersec  F de ac
cmark_lb  C
cmark_b  O
cmark_rb  D
cmark_rt  E
cmark_l  A
cmark_b  B
cmark_l  F
drawcircle  k
drawsegment  C B
drawsegment  A B
drawsegment  C F
drawsegment  O E
drawsegment  D F

','2008/03/26','70
')

sqlUpdatefigure

--- 128 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0128','70
','Geometry','\\begin{geothm}
 Three equal squares are placed side by side,
 as it is shown on the picture. Show that:
 $\\angle D_1AD + \\angle D_1BD = \\angle D_1CD$.
\\end{geothm}','
',
        '
 Three squares

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0128','3','
dim  130 90
point  A 20 20
point  B 50 20
towards  C A B 2
towards  D A B 3
line  ab A B
perp  a A ab
circle  k A B
intersec2  A_1 A_2 k a
perp  ab1 A_1 a
perp  b B ab
perp  c C ab
perp  d D ab
intersec  B_1 ab1 b
intersec  C_1 ab1 c
intersec  D_1 ab1 d
cmark_t  A_1
cmark_b  A
cmark_b  B
cmark_b  C
cmark_b  D
cmark_t  D_1
drawsegment  A D
drawsegment  A_1 D_1
drawsegment  A A_1
drawsegment  B B_1
drawsegment  C C_1
drawsegment  D D_1
drawdashsegment  D_1 A
drawdashsegment  D_1 B
drawdashsegment  D_1 C

','2008/03/26','70
')

sqlUpdatefigure

--- 129 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0129','70
','Geometry','\\begin{geothm}
 From the ends $D$ and $C$ of a diameter of circle $(O)$
 perpendiculars are drawn to chort $AB$. Let $E$ and $F$
 be the feet of the perpendiculars. Show that
 $OE \\cong OF$.
\\end{geothm}','
',
        '
 Example 92 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0129','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0129','3','
dim  130 110
point  A 25 30
point  B 105 30
point  X 100 100
point  Y 92 90
line  xy X Y
med  m A B
intersec  O m xy
circle  k O A
point  Z 80 80
line  cd O Z
intersec2  D C k cd
line  ab A B
foot  E C ab
foot  F D ab
cmark_lb  A
cmark_rb  B
cmark_lt  O
cmark_lb  C
cmark_rt  D
cmark_t  E
cmark_b  F
drawcircle  k
drawdashsegment  O E
drawdashsegment  O F
drawsegment  A B
drawsegment  C D
drawsegment  C E
drawsegment  D F

','2008/03/26','70
')

sqlUpdatefigure

--- 130 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0130','70
','Geometry','\\begin{geothm}
 Through $P$ a tangent $PE$ and a secant
 $PAB$ of circle $(O)$ are drawn. The
 bisector of angle $APE$ meets $AE$ and
 $BE$ at $C$ and $D$. Show that
 $EC \\cong ED$.
\\end{geothm}','
',
        '
 Example 94 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0130','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0130','3','
dim  110 90
point  E 35 20
point  O 35 45
circle  k O E
point  A 17.71 63.06
point  B 58.58 36.68
line  ab A B
line  oe O E
perp  ep E oe
intersec  P ep ab
line  ae A E
line  be B E
bis  p E P A
intersec  C ae p
intersec  D be p
cmark_t  O
cmark_b  E
cmark_b  P
cmark_lt  A
cmark_r  B
cmark_lb  C
cmark_t  D
drawsegment  E P
drawsegment  E O
drawsegment  A P
drawsegment  A E
drawsegment  A B
drawcircle  k
drawdashline  p
drawsegment  E A
drawsegment  E B

','2008/03/26','70
')

sqlUpdatefigure

--- 131 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0131','70
','Geometry','\\begin{geothm}
 Assume the incircle of $\\triangle ABC$ touches the 
 sides $BC$, $AC$ and $AB$ in points 
 $D$, $E$ and $F$ respectively. 
 Show that lines $AD$, $BE$ and $CF$ meet at the Gergonne 
 point $G$ of the triangle. 
\\end{geothm}','
',
        '
 Gergonne point

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0131','3','
dim  100 100
point  A 20 20
point  B 80 20
point  C 70 70
bis  ba B A C
bis  bb C B A
bis  bc A C B
line  a B C
line  b A C
line  c A B
intersec  I ba bb
foot  D I a
foot  E I b
foot  F I c
circle  k I F
line  ad A D
line  be B E
line  cf C F
intersec  G ad be
cmark_b  A
cmark_b  B
cmark_t  C
cmark_b  F
cmark_lt  E
cmark_rt  D
cmark_lt  G
drawcircle  k
drawsegment  A B
drawsegment  C B
drawsegment  C A
drawdashsegment  A D
drawdashsegment  B E
drawdashsegment  C F

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0131','2','
point  A 20 20
point  B 80 20
point  C 70 70
bis  ba B A C
bis  bb C B A
bis  bc A C B
line  a B C
line  b A C
line  c A B
intersec  I ba bb
foot  D I a
foot  E I b
foot  F I c
line  ad A D
line  be B E
line  cf C F
intersec  G ad be
prove { collinear C F G }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 143

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('143','8','26','462',
                    '0.256000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 132 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0132','70
','Geometry','\\begin{geothm}
 Assume the incircle of $\\triangle ABC$ touches the 
 sides $BC$, $AC$ and $AB$ in points 
 $D$, $E$ and $F$ respectively. 
 The lines $AD$, $BE$ and $CF$ meet at the Gergonne 
 point $G$ of the triangle. $DEF$ is known as
 Gergonne triangle (and also contact triangle) of
 $\\triangle ABC$. Suppose three lines are drawn through
 $G$ parallel to the sides of the Gergonne triangle.
 These meet the sides of $\\triangle ABC$ in six points
 $P$, $Q$, $R$, $S$, $T$ and $U$. Show that six points
 are concyclic. Moreover, the circle they lie on is
 centered at the incenter.
\\end{geothm}','
',
        '
 Adams  Circle

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0132','3','
dim  130 130
point  A 20 20
point  B 110 20
point  C 95 105
bis  ba B A C
bis  bb C B A
bis  bc A C B
line  a B C
line  b A C
line  c A B
intersec  I ba bb
foot  D I a
foot  E I b
foot  F I c
circle  k I F
line  ad A D
line  be B E
line  cf C F
intersec  G ad be
line  de D E
line  df D F
line  ef E F
parallel  gpq G de
parallel  grs G df
parallel  gtu G ef
intersec  P gpq b
intersec  Q gpq a
intersec  R grs a
intersec  S grs c
intersec  T gtu c
intersec  U gtu b
cmark_l  I
cmark_b  A
cmark_b  B
cmark_t  C
cmark_b  F
cmark_lt  E
cmark_rt  D
cmark_rb  G
cmark_lt  P
cmark_r  Q
cmark_rt  R
cmark_b  S
cmark_b  T
cmark_lt  U
drawcircle  k
drawsegment  A B
drawsegment  C B
drawsegment  C A
drawsegment  A D
drawsegment  B E
drawsegment  C F
drawdashsegment  P Q
drawdashsegment  R S
drawdashsegment  T U
drawsegment  D E
drawsegment  D F
drawsegment  F E
circle  k1 I S
drawdashcircle  k1

','2008/03/26','70
')

sqlUpdatefigure

--- 133 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0133','70
','Geometry','\\begin{geothm}
 Let $ABCD$ be a square. $CG$ is parallel
 to the diagonal $BD$. Point $E$ is on
 $CG$ such that $BE \\cong BD$. $F$ is the
 intersection of $BE$ and $DC$. Show that
 $DF \\cong DE$.
\\end{geothm}','
Let ABCD be a square. CG is parallel to the diagonal BD. Point E is on CG such that BE = BD. F is the intersection of BE and DC. Then DF = DE (Chou88, pg 58)

',
        '
 Example 5.1 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0133','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0133','3','
dim  110 60
point  A 59 20
point  B 78 20
line  ab A B
perp  p A ab
circle  k A B
intersec2  D D_1 k p
perp  q D p
perp  r B ab
intersec  C q r
line  d B D
parallel  c C d
circle  k1 B D
intersec2  E E_1 k1 c
line  be B E
line  cd C D
intersec  F be cd
line  be1 B E_1
intersec  F_1 be1 cd
cmark_b  A
cmark_b  B
cmark_t  D
cmark_t  C
cmark_t  E
cmark_lb  F
cmark_rt  E_1
cmark_t  F_1
drawsegment  A B
drawsegment  A D
drawsegment  C B
drawsegment  F_1 C
drawsegment  B D
drawsegment  B E
drawsegment  E D
drawsegment  C E
drawsegment  E E_1
drawsegment  F_1 E_1
drawdashsegment  D E_1

','2008/03/26','70
')

sqlUpdatefigure

--- 134 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0134','70
','Geometry','\\begin{geothm}
 Let $M$ be the midpoint of the arc $AB$
 of circle $(O)$, $D$ be the midpoint of
 $AB$. he perpendicular through $M$ is drawn
 to the tangent of the circle at $A$
 meeting that tangent at $E$. Show $ME \\cong MD$.
\\end{geothm}','
',
        '
 Example 95 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0134','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0134','3','
dim  100 100
point  D 50 33
point  O 50 55
line  d O D
point  M 50 90
circle  k O M
perp  a D d
intersec2  B A k a
line  p A O
perp  q A p
parallel  r M p
intersec  E r q
cmark_t  E
cmark_lb  A
cmark_rb  B
cmark_r  O
cmark_b  D
cmark_t  M
drawcircle  k
drawsegment  A B
drawsegment  A O
drawsegment  M D
drawsegment  E M
drawsegment  A E

','2008/03/26','70
')

sqlUpdatefigure

--- 135 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0135','70
','Geometry','\\begin{geothm}
 Let $G$ be a point on the circle $(O)$ with
 diameter $BC$, $A$ be the midpoint of the arc
 $BG$. $AD \\perp BC$. $E = AD \\cap BG$ and
 $F = AC \\cap BG$. Show that
 $AE \\cong BE \\cong EF$.
\\end{geothm}','
',
        '
 Example 97 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0135','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0135','3','
dim  100 100
point  B 10 50
point  C 90 50
midpoint  O B C
circle  k O B
point  G 55.30 89.65
med  m B G
intersec2  A A_1 k m
line  b B C
perp  d A b
line  g B G
line  o A O
line  c A C
intersec  E d g
intersec  D d b
intersec  M g o
intersec  F g c 
cmark_rb  E
cmark_l  B
cmark_r  C
cmark_b  O
cmark_b  D
cmark_b  M
cmark_lt  A
cmark_rt  G
cmark_t  F
drawcircle  k
drawsegment  B C
drawsegment  B G
drawsegment  A D
drawsegment  A O
drawsegment  A C

','2008/03/26','70
')

sqlUpdatefigure

--- 136 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0136','70
','Geometry','\\begin{geothm}
 The two tangents to the circumcircle
 of $ABC$ at $A$ and $C$ meet at $E$.
 The mediator of $BC$ meet $AB$
 at $D$. Show that $DE \\parallel BC$.
\\end{geothm}','
',
        '
 Example 102 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0136','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0136','3','
dim  110 85
point  A 35 25
point  B 90 25
point  C 58 68
med  ma B C
med  mc A B
intersec  O ma mc
circle  k O A
line  a B C
intersec  H ma a
line  c A B
intersec  D ma c
line  ao A O
line  co C O
perp  pa A ao
perp  pc C co
intersec  E pa pc
cmark_t  E
cmark_b  D
cmark_rb  O
drawcircle  k
cmark_b  A
cmark_b  B
cmark_t  C
cmark_rt  H
drawsegment  A B
drawsegment  A C
drawsegment  C B
drawsegment  A O
drawsegment  C O
drawsegment  A E
drawsegment  C E
drawsegment  D H
drawdashsegment  D E

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0136','2','
point  A 35 25
point  B 90 25
point  C 58 68
med  ma B C
med  mc A B
intersec  O ma mc
line  a B C
intersec  H ma a
line  c A B
intersec  D ma c
line  ao A O
line  co C O
perp  pa A ao
perp  pc C co
intersec  E pa pc
prove { parallel D E B C }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 144

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('144','17','47','118',
                    '0.008000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 137 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0137','70
','Geometry','\\begin{geothm}
 The product of two sides of a triangle
 is equal to the altitude to the third side
 multiplied by the circumdiameter.
\\end{geothm}','
',
        '
 Example 140 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0137','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0137','3','
dim  110 110
point  A 20 30
point  B 90 30
point  C 73 85
line  c A B
med  mc B C
med  mb A C
intersec  O mc mb
circle  k O A
foot  F C c
cmark_b  F
cmark_lb  A
cmark_rb  B
cmark_t  C
cmark_t  O
drawsegment  A B
drawsegment  A C
drawsegment  C B
drawsegment  C F
drawsegment  A O
drawcircle  k

','2008/03/26','70
')

sqlUpdatefigure

--- 138 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0138','70
','Geometry','\\begin{geothm}
 The internal and external bisectors of an
 angle of a triangle pass through the ends
 of the circumdiameters which is a perpendicular
 to the side opposite the vertex considered.
\\end{geothm}','
',
        '
 Example 138 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0138','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0138','3','
dim  110 110
point  A 20 30
point  B 90 30
point  C 73 85
line  c A B
med  mc B C
med  mb A C
intersec  O mc mb
circle  k O A
perp  l O c
intersec2  L1 L l k
cmark_lb  A
cmark_rb  B
cmark_t  C
cmark_t  O
cmark_b  L
drawsegment  A B
drawsegment  A C
drawsegment  C B
drawsegment  O L
drawsegment  C L
drawcircle  k

','2008/03/26','70
')

sqlUpdatefigure

--- 139 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0139','70
','Geometry','\\begin{geothm}
 On the hypotenuse $AB$ of right triangle
 $ABC$ a square $ABFE$ is erected.
 Let $P$ be the intersection of the diagonals
 $AF$ and $BE$ of $ABFE$. Show that:
 $\\angle A C P = \\angle P C B$.
\\end{geothm}','
',
        '
 Example 101 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0139','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0139','3','
dim  110 110
point  C 40 30
point  B 65 30
point  A 40 65
line  c A B
perp  f B c
perp  e A c
circle  k A B
intersec2  E E_1 k e
perp  ef E e
intersec  F ef f
line  af A F
line  be B E
intersec  P af be
perp  ef1 E_1 e
intersec  F_1 ef1 f
line  af1 A F_1
line  be1 B E_1
intersec  P_1 af1 be1
cmark_lb  C
cmark_b  B
cmark_lt  A
cmark_t  E
cmark_rb  F
cmark_rb  P
cmark_t  E_1
cmark_rb  F_1
cmark_lb  P_1
drawsegment  A B
drawsegment  C B
drawsegment  A C
drawsegment  A E
drawsegment  A F
drawsegment  B F
drawsegment  E F
drawsegment  B E
drawsegment  C P
drawdashsegment  A E_1
drawdashsegment  A F_1
drawdashsegment  B F_1
drawdashsegment  E_1 F_1
drawdashsegment  B E_1
drawdashsegment  C P_1

','2008/03/26','70
')

sqlUpdatefigure

--- 140 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0140','70
','Geometry','\\begin{geothm}
 A line parallel to the base of trapezoid
 $ABCD$ meet ifs two sides and two diagonals
 at $H$, $G$, $F$ and $E$. Show that:
 $EF \\cong GH$.
\\end{geothm}','
',
        '
 Example 103 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0140','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0140','3','
dim  110 110
point  A 20 20
point  B 90 20
point  D 45 90
point  C 85 90
point  H 31.95 53.46
line  a A B
parallel  h H a
line  b B C
intersec  E h b
line  d B D
line  c C A
intersec  G c h
intersec  F d h
cmark_b  A
cmark_b  B
cmark_t  C
cmark_t  D
cmark_l  H
cmark_r  E
cmark_rb  G
cmark_lb  F
drawsegment  A B
drawsegment  C B
drawsegment  C D
drawsegment  A D
drawsegment  A C
drawsegment  B D
drawsegment  H E

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0140','2','
point  A 20 20
point  B 90 20
point  D 45 90
point  C 85 90
online  H  A D
line  a A B
parallel  h H a
line  b B C
intersec  E h b
line  d B D
line  c C A
intersec  G c h
intersec  F d h
prove { equal { sratio H G F E } { 1 } }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 145

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('145','67','191','599',
                    '0.156000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 141 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0141','70
','Geometry','\\begin{geothm}
 Let $D$ and $E$ be two points on two
 sides $AC$ and $BC$ of triangle $ABC$ such
 that $AD \\cong BE$. $F = DE \\cap AB$. Show that:
 $FD \\cdot AC = EF \\cdot BC$.
\\end{geothm}','
',
        '
 Example 110 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0141','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0141','3','
dim  120 110
point  A 20 40
point  B 85 40
point  C 70 90
point  D 40.26 60.26
line  b A C
parallel  b1 B b
line  c A B
parallel  c1 D c
intersec  D1 b1 c1
line  a B C
circle  k B D1
intersec2  E1 E k a
line  de D E
intersec  F de c
cmark_lb  A
cmark_rb  B
cmark_t  C
cmark_lt  D
cmark_b  E
cmark_lb  F
drawsegment  A B
drawsegment  C E
drawsegment  A C
drawdashsegment  B D1
drawdashsegment  D D1
drawsegment  D E

','2008/03/26','70
')

sqlUpdatefigure

--- 142 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0142','70
','Geometry','\\begin{geothm}
 Two parallel line $AE$, $BD$ through the vertices
 $A$, $B$ of the triangle $ABC$ meet a line through
 the vertex $C$ in the points $E$, $D$. If the
 parallel through $E$ to $BC$ meets $AB$ in $F$,
 show that $DF$ is parallel to $AC$.
\\end{geothm}','
',
        '
 Example 121 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0142','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0142','3','
dim  110 110
point  A 20 35
point  B 90 35
point  C 70 90
point  D 50 20
line  bd B D
parallel  ae A bd
line  cd C D
intersec  E ae cd
line  bc B C
parallel  ef E bc
line  ab A B
intersec  F ab ef
cmark_b  A
cmark_b  B
cmark_t  C
cmark_b  D
cmark_r  E
cmark_rb  F
drawsegment  A B
drawsegment  C D
drawsegment  C B
drawsegment  A E
drawsegment  E F
drawdashsegment  A C
drawdashsegment  D F

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0142','2','
point  A 20 35
point  B 90 35
point  C 70 90
point  D 50 20
line  bd B D
parallel  ae A bd
line  cd C D
intersec  E ae cd
line  bc B C
parallel  ef E bc
line  ab A B
intersec  F ab ef
prove { parallel A C D F }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 146

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('146','16','31','121',
                    '0.012000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 143 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0143','70
','Geometry','\\begin{geothm}
 Let $C$ be the midpoint of the arc $AB$
 of circle $(O)$. $D$ is a point on the circle.
 $E = AB \\cap CD$. Show that:
 $CA^2 = CE \\cdot CD$.
\\end{geothm}','
',
        '
 Example 108 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0143','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0143','3','
dim  110 110
point  A 20 30
point  B 90 30
point  X 25 34
line  ab A B
line  ax A X
med  c A B
intersec  O c ax
intersec  M c ab
circle  k O A
intersec2  C C1 k c
point  D 39.67 15.88
line  cd C D
intersec  E ab cd
cmark_lb  A
cmark_rb  B
cmark_t  C
cmark_r  O
cmark_b  M
cmark_lb  D
cmark_lt  E
drawcircle  k
drawsegment  A B
drawsegment  C B
drawsegment  A C
drawsegment  C M
drawsegment  C D

','2008/03/26','70
')

sqlUpdatefigure

--- 144 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0144','70
','Geometry','\\begin{geothm}
 Through point $F$ on the circle with
 diameter $AB$ a tangent to the circle
 is drawn meeting the two lines,
 perpendicular to $AB$ at $A$ and $B$,
 at $D$ and $E$. Show that:
 $OA^2 = DF \\cdot EF$.
\\end{geothm}','
',
        '
 Example 114 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0144','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0144','3','
dim  110 110
point  A 20 45
point  B 90 45
midpoint  O A B
circle  k O A
point  F 48.77 79.44
line  ab A B
line  f F O
perp  de F f
perp  ad A ab
perp  be B ab
intersec  D ad de
intersec  E be de
cmark_l  A
cmark_r  B
cmark_b  O
cmark_lt  F
cmark_t  D
cmark_t  E
drawsegment  A B
drawsegment  O F
drawsegment  D E
drawsegment  E B
drawsegment  A D
drawcircle  k

','2008/03/26','70
')

sqlUpdatefigure

--- 145 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0145','70
','Geometry','\\begin{geothm}
 From a point $A$ two lines are drawn tangent to
 circle $(O)$ at $B$ and $C$. From a point $P$ on
 the circle peprendiculars are drawn to $BC$, $AB$
 and $AC$. Let $D$, $F$, $E$ be the feet. Show that:
 $PD^2 = PE \\cdot PF$.
\\end{geothm}','
',
        '
 Example 117 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0145','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0145','3','
dim  110 90
point  A 20 20
point  B 70 20
line  ab A B
point  X 60 70
line  ac A X
bis  s B A X
perp  b B ab
intersec  O b s
foot  C O ac
circle  k O B
point  P 46.05 42.01
line  bc B C
foot  F P ab
foot  E P ac
foot  D P bc
cmark_b  A
cmark_b  B
cmark_rt  O
cmark_lt  C
cmark_rt  D
cmark_b  F
cmark_lt  E
cmark_lb  P
drawcircle  k
drawsegment  A B
drawsegment  A C
drawsegment  O B
drawsegment  O C
drawsegment  C B
drawsegment  P F
drawsegment  P E
drawsegment  P D

','2008/03/26','70
')

sqlUpdatefigure

--- 146 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0146','70
','Geometry','\\begin{geothm}
 Of $Q$, $R$ are the projections of a point $M$
 of the internal bisector $AM$ of the angle $A$
 of the triangle $ABC$ upon the sides $AC$, $AB$,
 show that the perpendicular $MP$ from $M$ upon
 $BC$ meets $QR$ in the point $N$ on the median
 $AA_1$ of $ABC$.
\\end{geothm}','
',
        '
 Example 127 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0146','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0146','3','
dim  150 110
point  A 65 20
point  B 120 20
point  C 50 90
line  a C B
bis  s B A C
intersec  X s a
point  M 102.91 66.89
line  b A C
line  c A B
foot  Q M b
foot  R M c
midpoint  A_1 B C
line  a1 A A_1
line  qr Q R
intersec  N qr a1
point  B1 10 20
bis  s1 B1 A C
point  M_1 48.20 33.60
foot  Q_1 M_1 b
foot  R_1 M_1 c
line  qr1 Q_1 R_1
intersec  N_1 qr1 a1
cmark_b  A
cmark_b  B
cmark_l  C
cmark_t  M
cmark_lb  Q
cmark_b  R
cmark_rt  A_1
cmark_t  N
cmark_lt  M_1
cmark_r  Q_1
cmark_b  R_1
cmark_t  N_1
drawsegment  R_1 B
drawsegment  C B
drawsegment  A C
drawsegment  A A_1
drawsegment  M N
drawsegment  M Q
drawsegment  A M
drawsegment  M R
drawdashsegment  Q R
drawdashsegment  M_1 N_1
drawdashsegment  M_1 Q_1
drawdashsegment  A M_1
drawdashsegment  M_1 R_1
drawdashsegment  N_1 R_1

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0146','2','
point  A 65 20
point  B 120 20
point  C 50 90
line  a C B
bis  s B A C
intersec  X s a
online  M  A X
line  b A C
line  c A B
foot  Q M b
foot  R M c
midpoint  A_1 B C
line  a1 A A_1
line  qr Q R
intersec  N qr a1
prove { perpendicular B C M N }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 147

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('147','50','221','2563',
                    '2.376000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 147 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0147','70
','Geometry','\\begin{geothm}
 If $M$, $N$ are points on the sides $AC$,
 $BC$ of a triangle $ABC$ and the lines
 $AN$, $BM$ intersect on the altitude $CD$,
 show that $CD$ is the bisector of the 
 angle $\\angle MDN$.
\\end{geothm}','
',
        '
 Example 133 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0147','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0147','3','
dim  110 110
point  A 20 20
point  B 90 20
point  C 70 80
line  c A B
line  a B C
line  b A C
foot  D C c
point  J 70 50
line  aj A J
line  bj B J
intersec  M bj b
intersec  N aj a
cmark_b  A
cmark_b  B
cmark_t  C
cmark_lt  M
cmark_rt  N
cmark_b  D
cmark_lb  J
drawsegment  A B
drawsegment  A C
drawsegment  C B
drawsegment  C D
drawsegment  M B
drawsegment  A N
drawsegment  D M
drawsegment  D N

','2008/03/26','70
')

sqlUpdatefigure

--- 148 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0148','70
','Geometry','\\begin{geothm}
 Show that the internal (or external) bisector of an
 angle of a triangle is divided harmonically by the
 feet of the perpendiculars dropped upon it from
 the two other vertices of the triangle.
\\end{geothm}','
',
        '
 Example 136 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0148','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0148','3','
dim  110 110
point  A 20 30
point  B 90 30
point  C 70 80
line  c A B
bis  s A C B
foot  K B s
foot  J A s
intersec  F c s
towards  A_1 A C 2
bis  s_1 A_1 C B
foot  K_1 B s_1
foot  J_1 A s_1
intersec  F_1 c s_1
cmark_b  A
cmark_b  B
cmark_t  C
cmark_rb  F
cmark_rb  J
cmark_l  K
cmark_rb  F_1
cmark_t  J_1
cmark_t  K_1
drawsegment  A B
drawsegment  A C
drawsegment  C B
drawsegment  C J
drawsegment  B K
drawsegment  A J
drawdashsegment  F_1 J_1
drawdashsegment  B K_1
drawdashsegment  A J_1
drawdashsegment  C A_1

','2008/03/26','70
')

sqlUpdatefigure

--- 149 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0149','70
','Geometry','\\begin{geothm}
 The angle between the circumdiameter and the
 altitude issued from the same vertex of a
 triangle is bisected by the bisector of angle
 of the triangle at the same vertex considered.
\\end{geothm}','
',
        '
 Example 137 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0149','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0149','3','
dim  110 110
point  A 20 30
point  B 90 30
point  C 73 85
line  c A B
med  mc B C
med  mb A C
intersec  O mc mb
bis  s A C B
intersec  F s c
foot  D C c
circle  k O A
towards  A_1 A C 2
bis  s1 A_1 C B
drawdashline  s1
towards  O_1 O C 2
drawdashsegment  C O_1
cmark_lb  A
cmark_rb  B
cmark_t  C
cmark_b  F
cmark_b  D
cmark_b  O
drawsegment  A B
drawsegment  A C
drawsegment  C B
drawsegment  C D
drawsegment  C F
drawsegment  C O
drawcircle  k

','2008/03/26','70
')

sqlUpdatefigure

--- 150 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0150','70
','Geometry','\\begin{geothm}
 The area of a triangle is equal to the product
 of its three sides divided by the double
 circumdiameter of the triangle.
\\end{geothm}','
',
        '
 Example 141 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0150','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0150','3','
dim  110 110
point  A 20 30
point  B 90 30
point  C 73 85
line  c A B
med  mc B C
med  mb A C
intersec  O mc mb
circle  k O A
cmark_lb  A
cmark_rb  B
cmark_t  C
cmark_t  O
drawsegment  A B
drawsegment  A C
drawsegment  C B
drawsegment  A O
drawcircle  k

','2008/03/26','70
')

sqlUpdatefigure

--- 151 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0151','70
','Geometry','\\begin{geothm}
 Let $M$ be the midpoint of chord $AB$ of a circle
 with center $O$. On $OM$ as diameter draw another
 circle, and at any point $T$ of this circle
 draw a tangent to it meeting the outer circle in $E$.
 Prove that:
 $AE^2 + BE^2 = 4ET^2$.
\\end{geothm}','
',
        '
 Example 132 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0151','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0151','3','
dim  110 110
point  A 30 30
point  B 80 30
med  m A B
point  X 35 34
line  ax A X
intersec  O ax m
line  ab A B
intersec  M m ab
circle  k O A
midpoint  N O M
circle  k1 N M
point  T 45.46 37.01
line  tn T N
perp  t T tn
intersec2  E E1 t k
cmark_lb  A
cmark_rb  B
cmark_lt  O
cmark_b  M
cmark_r  N
cmark_lb  T
cmark_lt  E
drawsegment  A B
drawsegment  A E
drawsegment  E B
drawsegment  O M
drawsegment  T E
drawsegment  T N
drawcircle  k
drawcircle  k1

','2008/03/26','70
')

sqlUpdatefigure

--- 152 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0152','70
','Geometry','\\begin{geothm}
 Line $p$ intersects lines $AB$, $BC$, $CD$ and $DA$
 at points $A_1$, $B_1$, $C_1$ and $D_1$ respectively.
 Show that:
 $\\frac{\\overline{AA_1}}{\\overline{A_1B}} \\cdot
 \\frac{\\overline{BB_1}}{\\overline{B_1C}} \\cdot
 \\frac{\\overline{CC_1}}{\\overline{C_1D}} \\cdot
 \\frac{\\overline{DD_1}}{\\overline{D_1A}} \\cdot
 = 1$
\\end{geothm}','
',
        '
 General Menelaus s Theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0152','3','
dim  100 100
point  A 20 20
point  B 80 20
point  C 70 60
point  D 37 74
line  ab A B
line  bc B C
line  da D A
line  cd C D
point  A_1 85 20
point  B_1 77.5 32.5
line  a1b1 A_1 B_1
intersec  C_1 a1b1 cd
intersec  D_1 a1b1 da
cmark_rb  A
cmark_b  B
cmark_r  C
cmark_l  D
cmark_rt  A_1
cmark_r  B_1
cmark_rt  C_1
cmark_r  D_1
drawsegment  A B
drawsegment  C B
drawsegment  C D
drawsegment  A D
drawdashline  a1b1
drawline  da
drawline  ab

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0152','2','
point  A 20 20
point  B 80 20
point  C 70 60
point  D 37 74
line  ab A B
line  bc B C
line  da D A
line  cd C D
online  A_1  A B
online  B_1  B C
line  a1b1  A_1  B_1 
intersec  C_1  a1b1  cd
intersec  D_1  a1b1  da
prove { equal { mult { mult { mult { sratio A A_1 A_1 B } { sratio B B_1 B_1 C } } { sratio C C_1 C_1 D } } { sratio D D_1 D_1 A } } 1 }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 148

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('148','32','73','231',
                    '0.020000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 153 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0153','70
','Geometry','\\begin{geothm}
 Let $ABC$ and $A_1B_1C_1$ be two lines such that
 $AB_1 \\parallel BA_1$ and $BC_1 \\parallel CB_1$.
 Show that $AC_1 \\parallel CA_1$.
\\end{geothm}','
',
        '
 Pappus  Theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0153','3','
dim  100 100
point  A 20 10
point  B 90 10
point  C 50 10
cmark_b  A
cmark_b  B
cmark_b  C
point  A_1 55 50
point  A_2 45 43
line  A_1A_2 A_1 A_2
line  A_1B A_1 B
parallel  AB_1 A A_1B
intersec  B_1 A_1A_2 AB_1
line  CB_1 C B_1
parallel  BC_1 B CB_1
intersec  C_1 A_1A_2 BC_1
cmark_lt  A_1
cmark_lt  B_1
cmark_lt  C_1
drawline  A C
drawline  A_1 C_1
drawsegment  A B_1
drawsegment  B A_1
drawsegment  B C_1
drawsegment  C B_1
drawsegment  A C_1
drawsegment  C A_1

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0153','2','
point  A 20 10
point  B 90 10
online  C  A B 
point  A_1 55 50
point  A_2 45 43
line  A_1A_2 A_1 A_2
line  A_1B A_1 B
parallel  AB_1 A A_1B
intersec  B_1 A_1A_2 AB_1
line  CB_1  C  B_1
parallel  BC_1  B CB_1 
intersec  C_1  A_1A_2 BC_1 
prove { parallel A_1 C A C_1 }

','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 149

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('149','32','86','319',
                    '0.084000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 154 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0154','70
','Geometry','\\begin{geothm}
 Let $ABC$ and $A_1B_1C_1$ be two lines and
 $P = AB_1 \\cap A_1B$, $Q = AC_1 \\cap A_1C$,
 $S = BC_1 \\cap B_1C$. Then $P$, $Q$ and $S$
 are collinear.
\\end{geothm}','
',
        '
 Pappus  Theorem (second version)

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0154','3','
dim  100 100
point  A 20 20
point  B 50 20
point  C 77 20
point  A_1 25 50
point  B_1 52 60
point  C_1 65.50 65.00
line  ab1 A B_1
line  ba1 B A_1
intersec  P ab1 ba1
line  ac1 A C_1
line  ca1 C A_1
intersec  Q ac1 ca1
line  bc1 B C_1
line  cb1 C B_1
intersec  S bc1 cb1
line  p A B
line  q A_1 B_1
line  r P Q   
cmark_b  A
cmark_b  B
cmark_b  C
cmark_t  A_1
cmark_t  B_1
cmark_t  C_1
cmark_b  P
cmark_b  Q
cmark_r  S
drawline  p
drawline  q
drawdashline  r
drawsegment  A B_1
drawsegment  A_1 B
drawsegment  A C_1
drawsegment  A_1 C
drawsegment  C B_1
drawsegment  C_1 B

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0154','2','
point  A 20 20
point  B 50 20
point  C 77 20
point  A_1 25 50
point  B_1 52 60
online  C_1  A_1 B_1
line  ab1 A B_1
line  ba1 B A_1
intersec  P ab1 ba1
line  ac1 A C_1
line  ca1 C A_1
intersec  Q ac1 ca1
line  bc1 B C_1
line  cb1 C B_1
intersec  S bc1 cb1
line  p A B
line  q A_1 B_1
line  r P Q   
prove { collinear P Q S }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 150

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('150','17','40','184',
                    '0.032000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 155 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0155','70
','Geometry','\\begin{geothm}
 Show that the distance of a point on a
 median of triangle from the sides including
 the median are inversely proportional to these
 sides, ie:
 $NK : NJ = BC : AC$.
\\end{geothm}','
',
        '
 Example 145 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0155','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0155','3','
dim  110 110
point  A 20 30
point  B 90 30
point  C 40 88
midpoint  F A B
line  a B C
line  b A C
point  N 49.18 52.51
foot  K N b
foot  J N a
cmark_lb  A
cmark_rb  B
cmark_t  C
cmark_b  F
cmark_lt  K
cmark_rt  J
cmark_lb  N
drawsegment  A B
drawsegment  A C
drawsegment  C B
drawsegment  C F
drawsegment  N K
drawsegment  N J

','2008/03/26','70
')

sqlUpdatefigure

--- 156 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0156','70
','Geometry','\\begin{geothm}
 If $G$ is a centroid of triangle $ABC$,
 show that for any given point $M$:
 $3 \\cdot MG^2 + AG^2 + BG^2 + CG^2 = AM^2 + BM^2 + CM^2$.
\\end{geothm}','
',
        '
 Example 150 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0156','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0156','3','
dim  110 110
point  A 20 30
point  B 90 30
point  C 40 88
point  M 93 90
midpoint  F A B
midpoint  E A C
midpoint  D B C
line  cf C F
line  ad A D
intersec  G ad cf
cmark_lb  A
cmark_rb  B
cmark_t  C
cmark_t  M
cmark_lt  G
cmark_b  F
cmark_lt  E
cmark_rt  D
drawsegment  A B
drawsegment  A C
drawsegment  C B
drawsegment  M B
drawsegment  C M
drawsegment  C F
drawsegment  A D
drawsegment  B E
drawsegment  G M

','2008/03/26','70
')

sqlUpdatefigure

--- 157 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0157','70
','Geometry','\\begin{geothm}
 Two tritangent centers divide the bisector
 on which they are located, harmonically
 (ie, points $C$, $D$, $I$ and $I_c$
 are harmonic).
\\end{geothm}','
',
        '
 Example 155 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0157','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0157','3','
dim  120 110
point  A 20 63
point  B 85 63
point  C 28 98
bis  sc A C B
bis  sa B A C
perp  sa_1 A sa
line  c A B
intersec  I sa sc
intersec  I_c sa_1 sc
intersec  D sc c
foot  X I c
foot  Y I_c c
circle  k I X
circle  k1 I_c Y
towards  A1 C A 10
towards  B1 C B 10
drawdashsegment  A A1
drawdashsegment  B B1
drawdashcircle  k
drawdashcircle  k1
cmark_lt  A
cmark_rt  B
cmark_t  C
cmark_rt  I
cmark_lb  D
cmark_rt  I_c
drawsegment  A C
drawsegment  C B
drawsegment  A B
drawsegment  C I_c
drawsegment  A I
drawsegment  B I
drawsegment  A I_c

','2008/03/26','70
')

sqlUpdatefigure

--- 158 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0158','70
','Geometry','\\begin{geothm}
 Show that in any given triangle the ratio
 between one triangle side and a diameter of
 circumscribed circle is equal to the sine
 of opposite angle, ie:
 $\\frac{a}{2R} = \\sin \\alpha$
\\end{geothm}','
',
        '
 Sine Theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0158','3','
dim  110 110
point  A 20 30
point  B 90 30
point  C 70 90
med  mc A B
med  mb A C
intersec  O mc mb
circle  k O A
line  c A B
foot  D C c
cmark_b  A
cmark_b  B
cmark_t  C
cmark_b  O
drawcircle  k
cmark_b  D
drawsegment  O C
drawsegment  C D
drawsegment  A B
drawsegment  C B
drawsegment  A C
point  a 83.00 58.40
printat  a { a }
point  b 42.40 61.00
printat  b { b }
point  c 57.90 28.20
printat  c { c }
point  al 30.00 34.10
printat  al { \\alpha }
point  r 60.00 70.90
printat  r { R }
point  x 40 30
drawarc  A x 50
point  xx 41 30
drawarc  A xx 50

','2008/03/26','70
')

sqlUpdatefigure

--- 159 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0159','70
','Geometry','\\begin{geothm}
 $c^2 + b^2 - 2bc \\cos \\alpha = a^2$
\\end{geothm}','
',
        '
 The Law of Cosine

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0159','3','
dim  110 110
point  A 20 30
point  B 90 30
point  C 70 90
line  c A B
foot  D C c
cmark_b  A
cmark_b  B
cmark_b  D
cmark_t  C
drawsegment  C D
drawsegment  A B
drawsegment  C B
drawsegment  A C
point  a 83.00 58.40
printat  a { a }
point  b 42.40 61.00
printat  b { b }
point  c 57.90 28.20
printat  c { c }
point  al 30.00 34.10
printat  al { \\alpha }
point  x 40 30
drawarc  A x 50
point  xx 41 30
drawarc  A xx 50

','2008/03/26','70
')

sqlUpdatefigure

--- 160 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0160','70
','Geometry','\\begin{geothm}
 If $R$ and $r$ are half diameters of circumscribed
 and inscribed circles of a trougle and $d$ is a
 distance between them, show that:
 $d^2 = R(R - 2r)$.
\\end{geothm}','
',
        '
 Euler s Formula

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0160','3','
dim  105 90
point  A 20 33
point  B 85 33
point  C 68 75
bis  sc A C B
bis  sa B A C
intersec  I sa sc
med  mc A B
med  mb A C
intersec  O mc mb
circle  k O A
line  c A B
foot  D I c
circle  k1 I D
drawcircle  k1
drawcircle  k
cmark_b  O
cmark_lb  A
cmark_rb  B
cmark_t  C
cmark_rt  I
cmark_b  D
drawsegment  A O
drawsegment  I D
drawsegment  A C
drawsegment  C B
drawsegment  A B
drawdashsegment  I O
point  x 56.00 48.00
printat  x { d }
point  y 38.90 41.50
printat  y { R }
point  z 63.30 41.30
printat  z { r }

','2008/03/26','70
')

sqlUpdatefigure

--- 161 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0161','70
','Geometry','\\begin{geothm}
 Show that the area of a right triangle is equal
 to the product of the two segments into
 which the hypothenuse is divided by its point
 of contact with incircle.
\\end{geothm}','
',
        '
 Example 172 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0161','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0161','3','
dim  90 90
point  A 20 20
point  B 70 20
line  c A B
point  X 30 65
line  x B X
perp  b A c
intersec  C x b
bis  sa B A C
bis  sb A B C
intersec  I sa sb
line  a B C
foot  D I a
circle  k I D
drawcircle  k
cmark_rt  D
cmark_lt  I
cmark_b  A
cmark_b  B
cmark_t  C
drawsegment  A C
drawsegment  C B
drawsegment  A B
foot  E I c
foot  F I b
drawdashsegment  I E
drawdashsegment  I F
drawdashsegment  I D

','2008/03/26','70
')

sqlUpdatefigure

--- 162 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0162','70
','Geometry','\\begin{geothm}
 The segment of the altitude extended
 between the orthocenter and the second
 point of intersection with the circumcircle
 is bisected by the corresponding side of the triangle.
\\end{geothm}','
',
        '
 Example 174 (Chou88) 
','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0162','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0162','3','
dim  110 110
point  A 20 30
point  K 90 30
point  D 70 30
line  a A K
perp  c D a
med  o A K
point  X 24 33
line  x A X
intersec  O o x
circle  k O A
intersec2  C B c k
line  b A B
foot  E C b
line  hc C E
intersec  H hc a
cmark_lt  H
drawsegment  C E
cmark_b  E
cmark_rt  C
drawcircle  k
cmark_b  O
cmark_lb  A
cmark_b  B
cmark_rb  D
cmark_rb  K
drawsegment  A K
drawsegment  A B
drawsegment  A C
drawsegment  C B

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0162','2','
point  A 20 30
point  K 90 30
point  D 70 30
line  a A K
perp  c D a
med  o A K
point  X 24 33
line  x A X
intersec  O o x
circle  k O A
intersec2  C B c k
line  b A B
foot  E C b
line  hc C E
intersec  H hc a
prove { equal { sratio H D D K } { 1 } }

','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 151

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('151','4','19','67',
                    '0.012000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 163 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0163','70
','Geometry','\\begin{geothm}
 Show that the mediator of the bisector $CU$ of the
 triangle $ABC$, the perpendicular to $AB$ at $U$,
 and the circumdiameter of $ABC$ passing through $C$
 are concurrent.
\\end{geothm}','
',
        '
 Example 219 (Chou88)

','2008/03/26')

INSERT INTO bibtheorem
       (teoId,bibrefId)
      VALUES 
       ('GEO0163','chou88')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0163','3','
dim  110 100
point  A 20 30
point  B 90 30
point  C 75 85
med  mc A B
med  mb A C
intersec  O mc mb
circle  k O A
bis  s_c A C B
line  c A B
intersec  U s_c c
line  p C O
med  m C U
intersec  P p m
drawdashline  m
drawcircle  k
cmark_lt  P
cmark_b  U
cmark_l  O
cmark_lb  A
cmark_rb  B
cmark_t  C
drawdashsegment  P U
drawsegment  C O
drawsegment  C U
drawsegment  A B
drawsegment  A C
drawsegment  C B

','2008/03/26','70
')

sqlUpdatefigure

--- 164 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0164','70
','Geometry','\\begin{geothm}
 Let $A_1$ and $B_1$ be midpoints of segments
 $AC$ and $BC$ in triangle $ABC$.
 Show that $A_1B_1$ is parallel to $AB$
 and half of that segment.
\\end{geothm}','
',
        '
 Triangle median line

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0164','3','
dim  80 50
point  A 20 10
point  B 70 10
point  C 35 40
drawsegment  A B
drawsegment  A C
drawsegment  B C
midpoint  B_1 B C
midpoint  A_1 A C
drawsegment  A_1 B_1
midpoint  M A B
cmark_b  M
drawdashsegment  A_1 M
drawdashsegment  B_1 M
cmark_b  A
cmark_b  B
cmark_t  C
cmark_lt  A_1
cmark_rt  B_1

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0164','2','
point  A 20 10
point  B 70 10
point  C 35 40
midpoint  B_1 B C
midpoint  A_1 A C
prove { parallel A_1 B_1 A B }

','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 152

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('152','2','6','8',
                    '0.000000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 165 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0165','70
','Geometry','\\begin{geothm}
 Cross ratio of four points $A$, $B$, $C$ and $D$
 is same after central projection from point $O$
 onto line $p$.
\\end{geothm}','
',
        '
 Projection Keeps Cross Ratio

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0165','3','
dim  130 85
point  A 20 20
point  C 40 20
point  D 55 20
point  B 90 20
point  O 80 70
line  ao A O
line  bo B O
line  co C O
line  do D O
point  A_1 32 30
point  B_1 84 50
line  ab1 A_1 B_1
intersec  C_1 ab1 co
intersec  D_1 ab1 do
cmark_b  A
cmark_b  B
cmark_b  C
cmark_b  D
cmark_r  O
cmark_rb  A_1
cmark_rb  C_1
cmark_rb  D_1
cmark_rb  B_1
drawsegment  A B
drawsegment  A O
drawsegment  B O
drawsegment  C O
drawsegment  D O
drawdashline  ab1

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0165','2','
point  A 20 20
point  C 40 20
point  D 55 20
point  B 90 20
point  O 80 70
line  ao A O
line  bo B O
line  co C O
line  do D O
online  A_1  A O
online  B_1  B O
line  ab1  A_1  B_1 
intersec  C_1  ab1  co
intersec  D_1  ab1  do
prove { equal { mult { sratio C A C B } { sratio D B D A } } { mult { sratio C_1 A_1 C_1 B_1 } { sratio D_1 B_1 D_1 A_1 } } }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 153

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('153','8','15','61',
                    '0.008000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 166 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0166','70
','Geometry','\\begin{geothm}
 Let $A$, $B$ and $C$ be three points on the
 line $p$, and let $A_1$, $B_1$ and $C_1$ be
 three points on the line $q$. Following intersections are created:
 $P = AB_1 \\cap A_1B$, $Q = AC_1 \\cap A_1C$ and
 $R = BC_1 \\cap B_1C$. Show that points
 $P$, $Q$ and $R$ are collinear.
\\end{geothm}','
',
        '
 Pappus Hexagon Theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0166','3','
dim  110 90
point  A 40 10
point  B 90 10 
point  C 14.10 10
point  A_1 35.20 38.20
point  B_1 76.80 64.60
point  C_1 48.30 46.39
line  A_1B_1 A_1 B_1 
line  AB_1 A B_1
line  AC_1 A C_1
line  BA_1 B A_1
line  BC_1 B C_1
line  CA_1 C A_1
line  CB_1 C B_1
intersec  P AB_1 BA_1
intersec  Q AC_1 CA_1
intersec  S BC_1 CB_1
cmark_b  A
cmark_b  B
cmark_b  C
cmark_lt  A_1
cmark_rb  B_1
cmark_l  C_1
cmark_rb  P
cmark_r  Q
cmark_r  S
drawdashline  P S
drawsegment  A B_1
drawsegment  A Q
drawsegment  B A_1
drawsegment  B C_1
drawsegment  C Q
drawsegment  C B_1
drawline  A_1 C_1
drawline  A C

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0166','2','
point  A 40 10
point  B 90 10 
online  C  A B
point  A_1 35.20 38.20
point  B_1 76.80 64.60
online  C_1  A_1 B_1
line  A_1B_1 A_1 B_1 
line  AB_1 A B_1
line  AC_1  A C_1 
line  BA_1 B A_1
line  BC_1  B C_1 
line  CA_1  C  A_1
line  CB_1  C  B_1
intersec  P AB_1 BA_1
intersec  Q  AC_1  CA_1 
intersec  S  BC_1  CB_1 
prove { collinear P Q S }

','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 154

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('154','24','65','269',
                    '0.036000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 167 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0167','70
','Geometry','\\begin{geothm}
 Show that in any triangle, the orthocenter,
 the centroid and the center of circumscribed
 circle are collinear.
\\end{geothm}','
',
        '
 Euler Line Theorem

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0167','3','
dim  110 110
point  A 20 20
point  B 90 20
point  C 70 80
midpoint  C_1 A B
midpoint  A_1 B C
line  at A A_1
line  ct C C_1
intersec  T at ct
med  a B C
med  c A B
intersec  O a c
line  ab A B
line  bc B C
foot  C_2 C ab
foot  A_2 A bc
line  ah A A_2
line  ch C C_2
intersec  H ah ch
line  oth O T
drawline  oth
drawdashsegment  A A_2
drawdashsegment  C C_2
drawdashsegment  O A_1
drawdashsegment  O C_1
drawdashsegment  A A_1
drawdashsegment  C C_1
cmark_rb  H
cmark_t  O
cmark_rb  T
cmark_b  A
cmark_b  B
cmark_t  C
cmark_b  C_1
cmark_b  C_2
cmark_rt  A_1
cmark_rt  A_2
drawsegment  A B
drawsegment  A C
drawsegment  C B

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0167','2','
point  A 20 20
point  B 90 20
point  C 70 80
midpoint  C_1 A B
midpoint  A_1 B C
line  at A A_1
line  ct C C_1
intersec  T at ct
med  a B C
med  c A B
intersec  O a c
line  ab A B
line  bc B C
foot  C_2 C ab
foot  A_2 A bc
line  ah A A_2
line  ch C C_2
intersec  H ah ch
line  oth O T
prove { equal { sratio H T T O } { 2 } }
','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Proved'
                        WHERE demId = 155

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('155','386','876','5944',
                    '11.981000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 168 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0168','70
','Geometry','\\begin{geothm}
 Prove that in any triangle midpoints of each side,
 feet of each altitude and midpoints of the segments
 of each altitude from its vertex to the orthocenter
 lie on circle.
\\end{geothm}','
',
        '
 Nine Points Circle

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0168','3','
dim  110 110
point  A 20 20
point  B 90 20
point  C 80 100
line  ab A B
line  ac A C
line  bc B C
foot  D A bc
foot  E B ac
foot  F C ab
midpoint  G A B
midpoint  J B C
midpoint  I C A
line  ad A D
line  be B E
intersec  H ad be
midpoint  K A H
midpoint  L B H
midpoint  M C H
line  kj K J
line  gm G M
intersec  O kj gm
circle  k O G
drawcircle  k
drawdashline  kj
drawdashline  gm
cmark_b  A
cmark_b  B
cmark_t  C
cmark_r  D
cmark_l  E
cmark_b  F
cmark_b  G
cmark_lb  H
cmark_t  I
cmark_r  J
cmark_lb  M
cmark_b  K
cmark_t  L
cmark_t  O
drawsegment  A B
drawsegment  A C
drawsegment  B C
drawsegment  A D
drawsegment  B E
drawsegment  C F

','2008/03/26','70
')

sqlUpdatefigure

INSERT INTO demonstrations
                   (teoId,proverId,code,dateSubmission,userId)
            VALUES ('GEO0168','2','
point  A 20 20
point  B 90 20
point  C 80 100
line  ab A B
line  ac A C
line  bc B C
foot  D A bc
foot  E B ac
foot  F C ab
midpoint  G A B
midpoint  J B C
midpoint  I C A
line  ad A D
line  be B E
intersec  H ad be
midpoint  K A H
midpoint  L B H
midpoint  M C H
line  kj K J
line  gm G M
intersec  O kj gm
circle  k O G
prove { perpendicular G M G E }

','2008/03/26','70
')

sqlUpdateProof

UPDATE demonstrations
                          SET status = 'Disproved'
                        WHERE demId = 156

INSERT INTO measures
                   (measuresId,elimSteps,geoSteps,algSteps,timeCPU,
                    computerSpecs)
             VALUES
                   ('156','44','341','7587',
                    '10.661000','Intel(R) Pentium(R) 4, 3GHz, 2GB')

--- 169 ---

INSERT INTO theorems
       (teoId,userId,category,description,shortDescription,teoName,dateSubmission)
      VALUES 
       ('GEO0169','70
','Geometry','\\begin{geothm}
 Segment $AB$ is given. Let $m$ be median of $AB$
 and let circle $k$ be circle with center $A$ and
 half-diameter $B$. If $C$ is the intersection of
 circle $k$ and median $m$, show that triangle
 $ABC$ is isosceles.
\\end{geothm}','
',
        '
 The Construction of Isosceles Triangle

','2008/03/26')

INSERT INTO figures
       (teoId,drawerId,code,dateSubmission,userId)
      VALUES 
       ('GEO0169','3','
dim  110 110
point  A 20 20
point  B 90 20
med  c A B
circle  k A B
intersec2  C C_1 k c
cmark_b  A
cmark_rb  B
cmark_rt  C
drawsegment  A B
drawsegment  A C
drawsegment  C B
drawline  c
drawcircle  k

','2008/03/26','70
')

sqlUpdatefigure

--- 170 ---

