<?php
session_start();
/*
 * Figures/iInserFigure.php
 * 
 * Copyright 2009, 2017 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

require_once("../servidor.php");

$pTipoUtilizador = $_SESSION['tipoUtilizador'];
if ($pTipoUtilizador=="anonymous" || $pTipoUtilizador=="regular") { // separa por tipo de utilizador
  require($entradaFILE.'headerUsers.php');
  require($entradaFILE.'menuUsers.php');
  echo "<meta http-equiv='refresh' content='0; url=".$entradaFILE."users.php' />";
  exit;  // os anonimos no tem acesso a esta pgina
}
else {
  require($entradaFILE.'headerAdmins.php');
  require($entradaFILE.'menuAdmins.php');
}
?>


<center>
<h3 class="maketitle">Geometric theorems - Insert a Figure</h3>
</center>

<hr/>



<?php

require($entradaFILE.'loginDBMS.php');


// No caso de erros quer-se voltar ao formulrio, ponto de entrada neste ficheiro
$URLerros = addslashes($_SERVER['HTTP_REFERER']);

// No caso de sucesso quer-se voltar ao endereo do ficheiro de
// chamada (do formulrio) para se poder voltar a esse ponto de
// chamada

$pThmId            = $_POST['TeoId'];
$pDrwIdNameVersion = $_POST['DrwIdNameVersion'];
$pCode             = $_POST['Code'];
$pDateSubmission   = $_POST['DateSubmission'];
$pUserInfo         = $_POST['UserInfo'];
$pBibref           = $_POST['Bibref'];

print_r($_POST);

echo "<br/>".htmlspecialchars($pCode)."<br/>";

// Obter a Identificao do Desenhador de Figuras Geomtricas
preg_match("([0-9]+) --([A-Za-z0-9 _.]+) --([A-Za-z0-9 _\.]*)", $pDrwIdNameVersion,$matches);

$pDrwId   = $matches[1];

// Obter a Identificao do Utilizador que est a submeter a informao
preg_match("([A-Za-z0-9 _.]+) -- ([A-Za-z0-9 _.]+) -- ([A-Za-z0-9 _.]+)",$pUserInfo,$matches);

$pUserId = $matches[1];
//$pUserName = $matches[2];
//$pUserEmail = $matches[3];

echo "<br/>$pUserId - $pDrwId <br/>";


// Antes de introduzir o que quer eu seja na base de dados vai tentar
// criar a figura (JEG) e s se esta no contiver erros  que faz a
// insero de um novo elemento na base de dados


// Vai criar o ficheiro jpeg com a figura para guardar na base de dados.

// Escreve o ficheiro "txt" referente ao cdigo
// comea por apagar os ficheiros anteriores
// 
// Para que vrios utilizadores possam, simultaneamente, actualizar
// diferentes figuras adicionou-se ao nome do ficheiro a identificao
// do utilizador que o est a pedir.

$vNameCode = 'figure'.$pUserId.'.code';
$vNamePIC = 'figure'.$pUserId.'.pic';
$vNameErr = 'figure'.$pUserId.'.err';
$vNameErrors = 'figure'.$pUserId.'.errors';

ob_start();
print $pCode."\n";
$texfile=fopen($vNameCode,"w");
fwrite($texfile,ob_get_contents()); 
fclose($texfile); 
ob_end_clean(); 

// Vai processar o cdigo com o programa de desenho
// Consoante o programa de desenho
// 2 - Eukleides - 1.0.2
// 3 - GCLC
ob_start();
if ($pDrwId==2) 
  system("/usr/local/bin/eukleides $vNameCode > $vNamePIC 2> $vNameErr");
elseif ($pDrwId==3) {
  system("gclc $vNameCode $vNamePIC > $vNameErrors");
  system("grep Syntax $vNameErrors > $vNameErr");
}

ob_end_clean(); 

//$filename = 'figure.err';

// Vai verificar se houve erros ou no
if  (file_exists($vNameErr) and filesize($vNameErr)>0) { // h erros 
  $file = fopen ($vNameErr, "r");
  $contents = fread ($file, filesize ($vNameErr));
  echo $contents;
  //system("rm figure.err");
  echo "<center>\n";
  echo "<br>There are errors in the figure's code. The figure was not inserted in the database</b>\n";
  echo "</center>\n";
  echo "<meta http-equiv='refresh' content='2; url=$URLerros' />";
  exit;
 }
 else { // Caso no haja erros 
  // Comea por inserir alguns valores do tipo texto.
  // Formata os valores para posterior insero na Tabela


  if (!get_magic_quotes_gpc()){ 
//	$pThmId          = addslashes('$pThmId');
//      $pDrwId          = addslashes('$pDrwId');
      $pCode           = addslashes($pCode);
//      $pDateSubmission = addslashes('$pDateSubmission');
//      $pBibref         = addslashes('Bibref');
//      $pUserId         = addslashes('$pUserId');
    }

	echo "<br/>$pThmId<br/>";
  $sqlInsertFigure = 
    "INSERT INTO figures
        (teoId,drawerId,code,dateSubmission,userId)
     VALUES 
       ('$pThmId','$pDrwId','$pCode','$pDateSubmission','$pUserId')";


  $resultadoInsertFigure = mysqli_query($ligacao,$sqlInsertFigure);

  // caso haja erros na insero no chega sequer a tentar inserir a ref. bib.
  if (!$resultadoInsertFigure) { 
    echo 'Error - Figure not inserted! Generic data (L134)';
    echo "<meta http-equiv='refresh' content='2; url=$URLerros' />";
    exit;
  }
  
  // Obtm o valor do figId
  $sqlLastInsert = "SELECT LAST_INSERT_ID()";
  $resultadoLastInsert = mysqli_query($ligacao,$sqlLastInsert);
  $linhaLastInsert = mysqli_fetch_assoc($resultadoLastInsert);
  $pFigId=$linhaLastInsert['LAST_INSERT_ID()'];
  


  // vai agora inserir a referncia bibliogrfica. No caso "noref" no
  // se procede a nenhuma insero
  
  if ($pBibref != 'noref') {
    $sqlInsertFigureBibRef =
      "INSERT INTO bibfigure (bibrefId,figureId)
            VALUES ('$pBibref','$pFigId')";
   
  
    $resultadoInsertFigureBibRef = mysqli_query($ligacao,$sqlInsertFigureBibRef);
    
    // caso haja erros na insero no chega sequer a tentar inserir a ref. bib.
    if (!$resultadoInsertFigureBibRef) { 
      echo 'Error - Figure not inserted! Bibliographic data (L160)';
      echo "<meta http-equiv='refresh' content='2; url=$URLerros' />";
      exit;
    }
  }

  // vai processar a figura

  echo "<h3>Processing, please wait</h3>";
  flush();
  
  $vNameLaTeX = 'figure'.$pUserId.'.tex';
  $vNameDVI = 'figure'.$pUserId.'.dvi';
  $vNamePS = 'figure'.$pUserId.'.ps';
  $vNameEPSI = 'figure'.$pUserId.'.epsi';
  $vNameJPG = 'figure'.$pUserId.'.jpg';  

  $texfile=fopen($vNameLaTeX,"w");
  fwrite($texfile,ob_get_contents()); 
  fclose($texfile);  
  // Vai produzir o texto LaTeX referente  Figura
  ob_start();
  print "\documentclass[11pt]{article}\n";
  if ($pDrwId==2)
    print "\usepackage{pstricks}\n";
  elseif ($pDrwId==3) 
    print "\usepackage{gclc}\n";
  print "\pagestyle{empty}\n";
  print "\begin{document}\n";
  print "\input{ $vNamePIC }\n";
  print "\end{document}\n";
  
  $texfile=fopen($vNameLaTeX,"w");
  fwrite($texfile,ob_get_contents()); 
  fclose($texfile); 
  
  
  system("latex $vNameLaTeX"); 
  system("dvips $vNameDVI -o $vNamePS"); 
  system("ps2epsi $vNamePS $vNameEPSI");
  system("convert $vNameEPSI $vNameJPG");
  ob_end_clean(); 
  
  // Agora vai produzir os ficheiros XML e SVG  - para j s para o GCLC
  
  $vNameXML = 'figure'.$pUserId.'.xml';
  $vNameXMLaux = 'fig'.$pUserId.'.xml';
  
  $vNameSVG = 'figure'.$pUserId.'.svg';

  ob_start();   
  if ($pDrwId==2) { // No caso do Eukleides deixa o ficheiro XML em branco 
    system("rm $vNameXML");
    system("cat ' ' > $vNameXML");
    system("rm $vNameSVG"); 
    system("cat ' ' > $vNameSVG"); 
    // ainda tenho de resolver os problemas com o eps2svg
    // system("eps2svg $vNameEPSI");
  }
  elseif ($pDrwId==3) {
    // primeiro cria o XML correspondente ao GCLC
    system("gclc $vNameCode $vNameXMLaux -xml");
    // depois faz o "rendering" do XML em linguagem natural
    // modifica o estilo de sada para a Natural Language
    system("sed -e 's/GeoConsHTML.xsl/GeoConsNL.xsl/g' $vNameXMLaux > $vNameXML"); 
    // agora cria o SVG correspondente ao GCLC
    system("gclc $vNameCode $vNameSVG -svg");    
  }
  ob_end_clean(); 
  
  
  
  // e agora a escrita do ficheiro referente  imagem
  $fpJPG   = fopen($vNameJPG, 'r');
  $contentJPG = fread($fpJPG, filesize($vNameJPG));
  $contentJPG = addslashes($contentJPG);
  fclose($fpJPG);
  
  // e do ficheiro XML
  $fpXML = fopen($vNameXMLaux,'r');
  $contentXML = fread($fpXML,filesize($vNameXMLaux));
  $contentXML = addslashes($contentXML);
  fclose($fpXML);
  
  // e do ficheiro SVG
  $fpSVG = fopen($vNameSVG,'r');
  $contentSVG = fread($fpSVG,filesize($vNameSVG));
  $contentSVG = addslashes($contentSVG);
  fclose($fpSVG);
  
  // e agora a insero dos trs
  $sqlLastInsert = "SELECT LAST_INSERT_ID()";
  $resultadoLastInsert = mysqli_query($ligacao,$sqlLastInsert);
  $linha = mysqli_fetch_assoc($resultadoLastInsert);
  $pFigureIdLast = $linha['LAST_INSERT_ID()'];
  
  $sqlfigure = "UPDATE figures
                    SET codeXML = '$contentXML',
                        figure = '$contentJPG',
                        figureSVG = '$contentSVG'
                  WHERE figureId = $pFigureIdLast";
  
  $resultadofigure = mysqli_query($ligacao,$sqlfigure);
  
  if (!$resultadofigure) {
    echo "Error - figure XML+JPG+SVG not inserted (L265)";
    echo "<meta http-equiv='refresh' content='2; url=$URLerros' />";
    exit;
  }
 }


echo "<h3>Figure sucessefull inserted</h3>";

echo "<meta http-equiv='refresh' content='2; url=../Geothms/updateGeoThm.php?argumento=$pThmId' />";


?>

<hr/>

<p>&nbsp;</p>

<?php
  require($entradaFILE.'footer.php');
?>
