<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/">
	<xsl:for-each select="figure">			
		<xsl:text>
% </xsl:text>
		<xsl:text>   
</xsl:text>	
		<xsl:text>% Description of construction: 
</xsl:text>		
		<xsl:text>   
</xsl:text>	
		<xsl:text>% </xsl:text>
		<xsl:text>   
</xsl:text>	
		<xsl:text>   
</xsl:text>	
		<xsl:apply-templates />
	</xsl:for-each>

	
</xsl:template>

<!--**************introducing points**************-->

<xsl:template match="define">
	<xsl:apply-templates /> 		
	<xsl:text>   
</xsl:text>	
</xsl:template>


<xsl:template match="fixed_point">
	<xsl:value-of select="."/> 
	<xsl:text> = point (</xsl:text>
	<xsl:value-of select="@x"/>, <xsl:value-of select="@y"/>)	
</xsl:template>

<!--**************objects**************-->

<xsl:template match="dimensions">
	<xsl:text>frame(0,0,</xsl:text>
	<xsl:value-of select="@width"/>,<xsl:value-of select="@height"/>)    	
</xsl:template>


<xsl:template match="coefficient">
	<xsl:text>  </xsl:text>
	<xsl:value-of select="."/>  	
</xsl:template>

<xsl:template match="angle">
	<xsl:text> </xsl:text>
	<xsl:value-of select="."/>  	
</xsl:template>


<xsl:template match="point">
	<xsl:text> </xsl:text>
	<xsl:value-of select="."/> 
</xsl:template>

<xsl:template match="center">
	<xsl:text> </xsl:text>
	<xsl:value-of select="."/>  	
</xsl:template>


<xsl:template match="segment">
draw (segment(<xsl:value-of select="point[1]"/>, <xsl:value-of select="point[2]"/>)<xsl:choose>
<xsl:when test="../@dashed='yes'">,dashed)</xsl:when>
<xsl:otherwise>)</xsl:otherwise>
</xsl:choose>	
</xsl:template>

<xsl:template match="vector">
	<xsl:text>drawvector </xsl:text>
	<xsl:value-of select="point[1]"/> 
	<xsl:text> </xsl:text>
 	<xsl:value-of select="point[2]"/>	
	<xsl:text>   
</xsl:text>
</xsl:template>
	

<xsl:template match="line_pp">
draw (line(<xsl:value-of select="point[1]"/>, <xsl:value-of select="point[2]"/><xsl:choose>
<xsl:when test="../@dashed='yes'">,dashed)</xsl:when>
<xsl:otherwise>)</xsl:otherwise>
</xsl:choose></xsl:template>


<xsl:template match="line">
draw (<xsl:value-of select="."/><xsl:choose>
<xsl:when test="../@dashed='yes'">,dashed)</xsl:when>
<xsl:otherwise>)</xsl:otherwise>
</xsl:choose></xsl:template>

<xsl:template match="circle">
	draw (<xsl:value-of select="."/><xsl:choose>
	<xsl:when test="../@dashed='yes'">,dashed)	
	</xsl:when>
	<xsl:otherwise>)</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template match="circle_cp">
draw (circle(<xsl:value-of select="center"/>, <xsl:value-of select="point"/>)<xsl:choose>
<xsl:when test="../@dashed='yes'">,dashed)</xsl:when>
<xsl:otherwise>)</xsl:otherwise>
</xsl:choose>	
</xsl:template>

<xsl:template match="arc">
	<xsl:choose>
	<xsl:when test="../@dashed='yes'">
	<xsl:text>drawdasharc </xsl:text>
	</xsl:when>
	<xsl:otherwise>
	<xsl:text>drawarc </xsl:text>
</xsl:otherwise>
</xsl:choose>

	<xsl:apply-templates /> 
	<xsl:text>   
</xsl:text>

</xsl:template>


<!--**************constructions**************-->

<xsl:template match="construct">
	<xsl:text> </xsl:text>
	<xsl:text>   
</xsl:text>
	<xsl:apply-templates /> 						
	<xsl:text>   
</xsl:text>
	
</xsl:template>


<xsl:template match="new_point">
	<xsl:text> </xsl:text>
	<xsl:value-of select="."/> 
</xsl:template>

<xsl:template match="intersection">
	<xsl:value-of select="new_point"/> = intersection (<xsl:value-of select="line[1]"/>, <xsl:value-of select="line[2]"/>)
</xsl:template>

<xsl:template match="intersection_cc">
	<xsl:value-of select="new_point[1]"/><xsl:text> </xsl:text><xsl:value-of select="new_point[2]"/> intersection (<xsl:value-of select="circle[1]"/>, <xsl:value-of select="circle[2]"/>)
</xsl:template>

<xsl:template match="intersection_cl">
	<xsl:value-of select="new_point[1]"/><xsl:text> </xsl:text><xsl:value-of select="new_point[2]"/> intersection (<xsl:value-of select="circle"/>, <xsl:value-of select="line"/>)
</xsl:template>

<xsl:template match="midpoint">
<xsl:value-of select="new_point"/> = midpoint (<xsl:value-of select="point[1]"/>, <xsl:value-of select="point[2]"/>)
</xsl:template>

<xsl:template match="foot">
	<xsl:text>foot </xsl:text>
	<xsl:value-of select="new_point"/><xsl:text> </xsl:text>
	<xsl:value-of select="point"/><xsl:text> </xsl:text>
	<xsl:value-of select="line"/>	
	<xsl:text>   
</xsl:text>
</xsl:template>

<xsl:template match="random_point_on_line ">
	<xsl:text>online </xsl:text>
	<xsl:value-of select="new_point"/><xsl:text> </xsl:text>
	<xsl:value-of select="point[1]"/><xsl:text> </xsl:text>
	<xsl:value-of select="point[2]"/>	
	<xsl:text>   
</xsl:text>		
</xsl:template>

<xsl:template match="translate">
	<xsl:value-of select="new_point"/> = translation (<xsl:value-of select="point"/>, vector(<xsl:value-of select="vector/point[1]"/>, <xsl:value-of select="vector/point[2]"/>))		
</xsl:template>

<xsl:template match="towards">
	<xsl:text>towards </xsl:text>
	<xsl:value-of select="new_point"/><xsl:text> </xsl:text>
	<xsl:value-of select="vector/point[1]"/><xsl:text> </xsl:text>
	<xsl:value-of select="vector/point[2]"/><xsl:text> </xsl:text>
	<xsl:value-of select="coefficient"/>		
	<xsl:text>   
</xsl:text>
	
</xsl:template>

<xsl:template match="rotate ">
	<xsl:text>rotate </xsl:text>
	<xsl:value-of select="new_point"/><xsl:text> </xsl:text>
	<xsl:value-of select="center"/><xsl:text> </xsl:text>
	<xsl:value-of select="angle"/>"/><xsl:text> </xsl:text>
	<xsl:value-of select="point"/>			
	<xsl:text>   
</xsl:text>	
</xsl:template>

<xsl:template match="half_turn ">
<xsl:value-of select="new_point"/> = rotation (<xsl:value-of select="center"/>, <xsl:value-of select="point"/>)		
</xsl:template>

<xsl:template match="line_reflection ">
<xsl:value-of select="new_point"/> = reflection (<xsl:value-of select="point"/>, <xsl:value-of select="line"/>)		
</xsl:template>

<xsl:template match="inversion ">
	<xsl:text>sim </xsl:text>
	<xsl:value-of select="new_point"/><xsl:text> </xsl:text>
	<xsl:value-of select="circle"/><xsl:text> </xsl:text>
	<xsl:value-of select="point"/>	
	<xsl:text>   
</xsl:text>		
</xsl:template>


<xsl:template match="new_line">
	<xsl:text> </xsl:text>
	<xsl:value-of select="."/> 	
</xsl:template>

<xsl:template match="ruler ">
<xsl:value-of select="new_line"/> = line (<xsl:value-of select="point[1]"/>, <xsl:value-of select="point[2]"/>)		
</xsl:template>

<xsl:template match="parallel ">
	<xsl:text>parallel </xsl:text>
	<xsl:text> </xsl:text>
	<xsl:value-of select="new_point"/>
	<xsl:text> </xsl:text>
	<xsl:value-of select="point"/>
	<xsl:text> </xsl:text>
	<xsl:value-of select="line"/>	
	<xsl:text>   
</xsl:text>
	
</xsl:template>

<xsl:template match="perpendicular">
<xsl:value-of select="new_line"/> = perpendicular (<xsl:value-of select="line"/>, <xsl:value-of select="point"/>)		
</xsl:template>

<xsl:template match="segment_bisector ">
	<xsl:value-of select="new_line"/> = median (<xsl:value-of select="point[1]"/>, <xsl:value-of select="point[2]"/>)
</xsl:template>

<xsl:template match="angle_bisector">
	<xsl:value-of select="new_line"/> = bisector (<xsl:value-of select="point[1]"/>, <xsl:value-of select="point[2]"/>, <xsl:value-of select="point[3]"/>)
</xsl:template>


<xsl:template match="new_circle">
	<xsl:text> </xsl:text>
	<xsl:value-of select="."/> 	
</xsl:template>

<xsl:template match="compass ">
	<xsl:value-of select="new_circle"/> = circle (<xsl:value-of select="center"/>, <xsl:value-of select="point"/>)
</xsl:template>


<!--**************drawing**************-->

<xsl:template match="draw">			
	<xsl:text> </xsl:text>
	<xsl:text>   
</xsl:text>	
	<xsl:apply-templates /> 						
	<xsl:text>   
</xsl:text>

</xsl:template>


<xsl:template match="draw[@dashed='no']">			
	<xsl:text> </xsl:text>
	<xsl:text>   
</xsl:text>

	<xsl:apply-templates /> 						
	<xsl:text>   
</xsl:text>
</xsl:template>


<xsl:template match="draw[@dashed='yes']">			
	<xsl:text> </xsl:text>
	<xsl:text>   
</xsl:text>
	<xsl:apply-templates /> 						
	<xsl:text>   
</xsl:text>	
</xsl:template>

<xsl:template match="area">
	<xsl:text>area </xsl:text>
<xsl:value-of select="@x1"/> <xsl:text> </xsl:text>
 <xsl:value-of select="@y1"/> <xsl:text> </xsl:text>
<xsl:value-of select="@x2"/> <xsl:text> </xsl:text>
<xsl:value-of select="@y2"/> <xsl:text> </xsl:text>
	<xsl:text>   
</xsl:text>	
</xsl:template>



<!--**************labeling**************-->


<xsl:template match="labels">
	<xsl:text> </xsl:text>
	<xsl:text>   
</xsl:text>	
	<xsl:apply-templates /> 						
	<xsl:text>   
</xsl:text>	
</xsl:template>

<xsl:template match="point_label">
<xsl:text>label(</xsl:text>
<xsl:value-of select="point"/>,<xsl:value-of select="@direction"/>) 
</xsl:template>


<xsl:template match="text_label">
<xsl:text>label(</xsl:text>
<xsl:value-of select="point"/>,<xsl:value-of select="@direction"/>) 
</xsl:template>

<xsl:template match="text">
	<xsl:text> {</xsl:text>
	<xsl:value-of select="."/> 
	<xsl:text>} </xsl:text>	
</xsl:template>

</xsl:stylesheet>