<?php 
session_start();
/*
 * BibRefs/listingBibrefs.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

require_once('../servidor.php');

$pUtilizador = $_SESSION['utilizador'];
$pSenha = $_SESSION['senha'];
$pTipoUtilizador = $_SESSION['tipoUtilizador'];
if ($pTipoUtilizador=="anonymous" || $pTipoUtilizador=="regular") {// separa por tipo de utilizador
  require($entradaFILE.'headerUsers.php');
  require($entradaFILE.'menuUsers.php');
} 
else {
  require($entradaFILE.'headerAdmins.php');
  require($entradaFILE.'menuAdmins.php');
}
?>



<?php
require($entradaFILE.'dbLogin.php');

// Condicional que controla se é a primeira vez ou se já é uma
// re-entrada e a consequente fixação dos valores das variáveis que
// depois vão controlar o funcionar do restante programa.
if (!isset($_POST['Nrows'])) { // Inicialização
  $modulo        = 10;
  $nPagina       = 1;
  $valorPesquisa = ''; 
  $numPaginas    = 1; // Valor que não sei se é relevante... se não for é
		   // porque é alterado mais à frente
  // por omissão seleccionam-se todos os problemas
  $consultaSQL = "SELECT bibrefId,bibtexEntry
                    FROM bibrefs
                   WHERE NOT(bibrefId='noref')";
}
else {
  // senão, começa por inicializar as variáveis 
  $modulo        = $_POST['Nrows'];
  $nPagina       = $_POST['nPagina'];
  $numPaginas    = $_POST['numPaginas'];
  $valorPesquisa = $_POST['ValueSearch'];
  $consultaSQL   = $_POST['ConsultaSQL'];

  if (isset($_POST['GoTo'])) { // Vai modificar o valor da página corrente
    $auxGoto = $_POST['GoTo'];
    if ($auxGoto=='Home')
      $nPagina= 1;
    if ($auxGoto=='PgUp')
      if ($nPagina>1)
	$nPagina= $nPagina-1;
    if ($auxGoto=='PgDn')
      if ($nPagina<$numPaginas & $numPaginas>1 )
	$nPagina = $nPagina+1;
    if ($auxGoto=='End')
      $nPagina = $numPaginas;
  }

  // cria uma pesquisa, que: ou se mantém, ou foi alterada por invocação
  // da consulta apropriada para o efeito
  $consultaSQL=cria_pesquisa($valorPesquisa);
  // vai colocar em sql uma pesquisa válida
  
}
  

// vai colocar em sql uma pesquisa válida
if ($consultaSQL!="") {
  $sql = $consultaSQL;
}
else {
  $sql = "SELECT bibrefId,bibtexEntry
            FROM bibrefs
           WHERE NOT(bibrefId='noref')";
}

$resultado = mysqli_query($ligacao,$sql);


// O números de campos obtidos
$ncampos =mysqli_num_fields($resultado);
// O números de linhas obtidos
$nlinhas =mysqli_num_rows($resultado);

     
// Vai (eventualmente) modificar o número de páginas
if ($nlinhas<$modulo) {
  $nPagina = 1;
  $numPaginas = 1;
}
else {
  // calcula o divisor (inteiro) de nlinhas por módulo
  $numPaginas = ceil($nlinhas/$modulo);  
  // verifica se a página corrente não é maior do que o número de páginas
  // total
  if ($nPagina>$numPaginas) { // nesse caso coloca na última página
    $nPagina=$numPaginas;
  }
}

echo "<hr>";

echo "<center>";
echo "<table border=1 width=90%>\n";
print "<tr>\n"; 
print "<form action='listingBibrefs.php' method='post'>";
print "<th><input type='submit' value='N. rows'</th>";
print "<th><SELECT NAME='Nrows'>";
if ($modulo==10) {
  print "<option selected>10</option>";
}
else {
  print "<option>10</option>";
}
if ($modulo==20) {
  print "<option selected>20</option>";
}
else {
  print "<option>20</option>";
}
if ($modulo==50) {
  print "<option selected>50</option>";
}
else {
  print "<option>50</option>";
}
if ($modulo==$nlinhas) {
  print "<option selected>$nlinhas</option>";
}
else {
  print "<option>$nlinhas</option>";
}
print "</SELECT></th>"; 
// todos os outro valores têm de ser passados como escondidos (6/7)
print "<input type='hidden' name='nPagina' value='$nPagina'>";
print "<input type='hidden' name='numPaginas' value='$numPaginas'>";
print "<input type='hidden' name='ValueSearch' value='$valorPesquisa'>";
print "<input type='hidden' name='ConsultaSQL' value='$consultaSQL'>";
print "</form>"; 
print "<th>";
print "<table width='100%' border='1'>";
print "<tr>\n";
print "<th>Page $nPagina of $numPaginas</th>"; 
print "</tr>\n";
print "<tr>\n";
print "<th><font size=-1>$nlinhas Bibliographic References</font></th>\n";
print "</tr>\n";
print "</table>";
print "</th>";
print "<form action='listingBibrefs.php' method='post'>"; 
print "<input type='hidden' name='GoTo' value='Home'>";
print "<th><input type='submit' value='Home'></th>"; 
// todos os outros valores têm de ser passados como um valores escondidos
passa_todos_escondidos($modulo,$nPagina,$numPaginas,$valorPesquisa,$consultaSQL);
print "</form>"; 
print "<form action='listingBibrefs.php' method='post'>"; 
print "<input type='hidden' name='GoTo' value='PgUp'>";
print "<th><input type='submit' value='Pg Up'></th>"; 
// todos os outros valores têm de ser passados como um valores escondidos
passa_todos_escondidos($modulo,$nPagina,$numPaginas,$valorPesquisa,$consultaSQL); 
print "</form>"; 
print "<form action='listingBibrefs.php' method='post'>"; 
print "<input type='hidden' name='GoTo' value='PgDn'>";
print "<th><input type='submit' value='Pg Dn'></th>"; 
// todos os outros valores têm de ser passados como um valores escondidos
passa_todos_escondidos($modulo,$nPagina,$numPaginas,$valorPesquisa,$consultaSQL); 
print "</form>"; 
print "<form action='listingBibrefs.php' method='post'>"; 
print "<input type='hidden' name='GoTo' value='End'>";
print "<th><input type='submit' value='End'></th>"; 
// todos os outros valores têm de ser passados como um valores escondidos
passa_todos_escondidos($modulo,$nPagina,$numPaginas,$valorPesquisa,$consultaSQL); 
print "</form>"; 
print " <th>";
print "<table width='100%'>";
print "<tr>"; 
print " <th> 
         Search
        </th>";
print " <th>";
print "<form action='listingBibrefs.php' method='post'>";
// a pesquisa é, para já, só feita em termos de nomes dos teoremas
print " <th colspan='2' width='100%'> 
         <input type='text' name='ValueSearch' size='20' value='$valorPesquisa'>
        </th>";
print "</tr>"; 
print "</table>";
// todos os outro valores têem de ser passados como escondidos
print "<input type='hidden' name='Nrows' value='$modulo'>";
print "<input type='hidden' name='nPagina' value='$nPagina'>";
print "<input type='hidden' name='numPaginas' value='$numPaginas'>";
print "<input type='hidden' name='ConsultaSQL' value='$consultaSQL'>";
print "</form>"; 
print "</th>";
print "</tr>\n\n";
// um último formúlario para re-inicializar valores
print "<tr>\n";
print "<form action='listingBibrefs.php' method='post'>\n";
print "<th colspan='10' align='left'>\n";
print "<input type='submit' value='reset'>\n";
print "</th>\n";
// Nenhum dos valores do formulário é passado 
print "</form>"; 
print "</table>";
echo "</center>";

/*
 Começo da construção da tabela das referências bibliográficas
*/

if ($nlinhas==0) { // Não há resultados para mostrar
  if ($pTipoUtilizador=="administrator") {// separa por tipo de utilizador
    echo "<table border=1 width=90%>\n";
    echo "<tr>\n";
    echo " <td colspan=6 STYLE='background:#efefef' align=right>
            <a href=validateInsertGeoThm.php>Insert a new Geometric Bibliographic Reference</a>
           </td>\n";
    echo "</tr>\n\n";
    echo "<tr>\n";  
    echo "</table>\n";
  }
  print("<h2>".gettext("There are no results to show")."</h2>");
}
else {
  print "<center>";
  print "<table border=1 width=90%>\n";
  if ($pTipoUtilizador=="administrator") {// separa por tipo de utilizador
    print "<tr>\n";
    print " <td colspan=6 STYLE='background:#efefef' align='right'>
           <a href=insertBibref.php>Insert a new Geometric Bibliographic Reference</a>
          </td>\n";
    print "</tr>\n\n";
  }
  print "<tr>\n";
  echo "<th>Key</th>
        <th>Title</th>
        <th>Select</th>
        <th>&nbsp;</th>
        <th>&nbsp;</th>\n";
  if ($pTipoUtilizador=="administrator") {// separa por tipo de utilizador
    echo "<th>&nbsp;</th>";
  }
  print "</tr>\n\n";


  $inicio = 1+($nPagina-1)*$modulo;
  $fim = $nPagina*$modulo;
  if ($fim>$nlinhas) $fim=$nlinhas;
  $iaux = $inicio; 
  // Coloca o ponteiro $resultado a apontar para a 1a linha a obter (começa no 0)
  mysqli_data_seek($resultado, $iaux-1);
  echo "<form action='Forms/bibfile.php' method='post'>";
  /*
   *  Uma linha da tabela por referência bibliográfica
   */  

  while ($iaux<=$fim) {
    $linha = mysqli_fetch_assoc($resultado);
    echo "<tr>\n";
    $pBibRefId = $linha['bibrefId'];
    $bibTeXEntry = $linha['bibtexEntry'];

    // retira todas as mudanças de linha, espaçamentos tabulares e símbolos {}
    $mudancasLinha = array("\n","\t","\f","\r","{","}");
    $bibtexentry = str_replace($mudancasLinha,"",$bibTeXEntry);

    // vai obter o título da publicação
    preg_match("@[, ]+title[ \t=]+([A-Za-z0-9' _,.+:()?-]+)[,]+@",$bibtexentry,$matches);

    $bibtitle = $matches[1];

    echo "<td align='center'>
           $pBibRefId 
          </td>
	  <td align='left'>
	   $bibtitle
          </td>
          <td align='center'>
           <INPUT TYPE='checkbox' NAME='$pBibRefId'>
          </td>
          <td>
           &nbsp;
          </td>
          <td align='center'>
             <a href=seedetailsBibref.php?argumento=$pBibRefId>See details</a>
          </td>\n";
    /*
     Permitir actualizar a informação
    */
    if ($pTipoUtilizador=="administrator") {// separa por tipo de utilizador
      print "<td align='center'>
               <a href=updateBibref.php?argumento=$pBibRefId>update</a>
             </td>\n";
    }
    print"</tr>";
    $iaux=$iaux+1;
  }

  echo "<tr>\n";
  echo "<td colspan='6' align='left'>
         <input type='submit' value='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create BiBfile for the Selected References &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'>
        </td>";
  echo "</tr>\n";
  echo "</form>";
  echo "<form action='Forms/bibfileAll.php' method='post'>";
  echo "<tr>\n";
  echo "<td colspan='6' align='left'><input type='submit' value='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create BiBfile with all the references&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'></td>";
  echo "<tr>\n";
  echo "</form>";
  print "</table>\n";
  print "</center>";
  print "<p>&nbsp;</p>";
}
?>

<?php
function passa_todos_escondidos($modulo,$nPagina,$numPaginas,$valorPesquisa,$consultaSQL) {
  // todos os valores têem de ser passados como escondidos (7)
  print "<input type='hidden' name='Nrows' value='$modulo'>";
  print "<input type='hidden' name='nPagina' value='$nPagina'>";
  print "<input type='hidden' name='numPaginas' value='$numPaginas'>";
  print "<input type='hidden' name='ValueSearch' value='$valorPesquisa'>";
  print "<input type='hidden' name='ConsultaSQL' value='$consultaSQL'>";
}


function mostra_valores($modulo,$nPagina,$numPaginas,$valorPesquisa,$consultaSQL) {
  print "<p>Show -- $auxShow</p>";
  print "<p>Nrows -- $modulo</p>";
  print "<p>nPagina -- $nPagina</p>";
  print "<p>numPaginas -- $numPaginas</p>";
  print "<p>Search -- $auxSearch</p>";
  print "<p>ValueSearch -- $valorPesquisa</p>";
  print "<p>ConsultaSQL -- $consultaSQL</p>";
}


// --> $auxShow,$valorPesquisa,$auxSearch
// <-- $consultaSQL
function cria_pesquisa($valorPesquisa) {

  $selectSQL = "DISTINCT theorems.teoId,teoName,shortDescription";
  $orderbySQL = "teoName";

  $whereSQL = $whereSQL." AND teoName LIKE '%$valorPesquisa%'";

  if ($valorPesquisa!="") {
    $consultaSQL = "SELECT bibrefId,bibtexEntry
                      FROM bibrefs
                     WHERE NOT(bibrefId='noref')
                       AND bibtexEntry LIKE '%$valorPesquisa%'";

  }
  else {
    $consultaSQL = "SELECT bibrefId,bibtexEntry
                      FROM bibrefs
                     WHERE NOT(bibrefId='noref')";
  }
  return($consultaSQL);
}

?>

<?php
require($entradaFILE.'footer.php');
?>
