<?php 
session_start();
/*
 * BibRefs/Forms/bibfile.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

require_once('../../servidor.php');

$pUtilizador = $_SESSION['utilizador'];
$pSenha = $_SESSION['senha'];
$pTipoUtilizador = $_SESSION['tipoUtilizador'];
if ($pTipoUtilizador=="anonymous" || $pTipoUtilizador=="regular") {// separa por tipo de utilizador
  require($entradaFILE.'headerUsers.php');
  require($entradaFILE.'menuUsers.php');
} 
else {
  require($entradaFILE.'headerAdmins.php');
  require($entradaFILE.'menuAdmins.php');
}

?>



<center>
<h3 class="maketitle">Geometric References listing</h3>
</center>



<?php
require($entradaFILE.'dbLogin.php');
?>

<?php

// cria uma pesquisa
$sql = "SELECT bibrefId,bibtexEntry
          FROM bibrefs
         WHERE NOT(bibrefId='noref')";


$resultado = mysqli_query($ligacao,$sql);

$ncampos =mysqli_num_fields($resultado);
$nlinhas =mysqli_num_rows($resultado);

echo "<center>";
echo "<h4 class='maketitle'>BiBTeX - Geometric References</h4>";
echo "</center>";

// Vai produzir o ficheiro geothmsSelected.bib das referências bibliográficas
ob_start();
print "@PREAMBLE{ {\\newcommand{\\noopsort}[1]{} \\newcommand{\singleletter}[1]{#1} } }\n";
print "@STRING{ ADW = {Addison-Wesley} }\n";
print "@STRING{ AMS = {American Mathematical Society} }\n\n";

while ($linha = mysqli_fetch_assoc($resultado)){
  $vBibRefId    = trim($linha['bibrefId']);
  $vBiBTeXEntry = trim($linha['bibtexEntry']);
  $vBibRef      = $_POST[$vBibRefId];
  if ($vBibRef =='on') {
    print "$vBiBTeXEntry\n\n"; 
  }
 }
$texfile=fopen("geothmsSelected.bib","w");
fwrite($texfile,ob_get_contents()); 
fclose($texfile); 
ob_end_clean(); 

print "<br>\n";
print "<hr>\n";
print "<br>\n";
print "<a href='geothmsSelected.bib'>geothmsSelected.bib</a>";
print "<br>\n";
print "<hr>\n";
print "<br>\n";

// E agora despeja para o ecrã
// repete a pesquisa
$resultado = mysqli_query($ligacao,$sql);

print "<pre>@PREAMBLE{ {\\newcommand{\\noopsort}[1]{} \\newcommand{\singleletter}[1]{#1} } }</pre>";
print "<pre>@STRING{ ADW = {Addison-Wesley} }</pre>";
print "<pre>@STRING{ AMS = {American Mathematical Society} }</pre>";

print "<p>&nbsp;</p>";
while ($linha = mysqli_fetch_assoc($resultado)){
  $vBibRefId    = trim($linha['bibrefId']);
  $vBiBTeXEntry = trim($linha['bibtexEntry']);
  $vBibRef      = $_POST[$vBibRefId];
  if ($vBibRef =='on') {
    print "<pre> $vBiBTeXEntry</pre>\n"; 
  }
 }

?>




<?php
  require($entradaFILE.'footer.php');
?>
