<?php 
session_start();
/*
 * Administation/lastLogsPerUser.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

require_once("../servidor.php");

$pTipoUtilizador = $_SESSION['tipoUtilizador'];
if ($pTipoUtilizador=="anonymous" || $pTipoUtilizador=="regular") { // separa por tipo de utilizador
  require($entradaFILE.'headerUsers.php');
  require($entradaFILE.'menuAdmins.php');
  echo "<meta http-equiv='refresh' content='0; url=".$entradaURL."users.php' />";
  exit;  // os anonimos não têem acesso a esta página
}
else {
  require($entradaFILE.'headerAdmins.php');
  require($entradaFILE.'menuAdmins.php');
}

// coloca o valor para a página de ajuda apropriada
$_SESSION['helpsection']='logs';

require_once($entradaFILE.'dbLogin.php');

?>

<center>
<h2 class="maketitle">GeoThms - Geometry Framework</h2>
</center>

<?php

$userId=$_GET['userId'];
$username=$_GET['username'];

echo "<center>\n";
echo "<h3>$userId - $username</h3>\n";
echo "</center>\n";


$sqlTimes = "SELECT timeLogin,timeLogout,loginLogout 
               FROM logs 
              WHERE userId=$userId
                AND websystem='GeoThms'
           ORDER BY timeLogin DESC";

$resultadoTimes = mysqli_query( $ligacao,$sqlTimes); 
$nlinhas = mysqli_num_rows($resultadoTimes); 

if ($nlinhas==0) { // ainda não chegou a entrar
  echo "<p>No records since 2007/6/12</p>";
 }
 else {
   // Tabela com valores
   echo "<center>\n";
   echo "<table border='1' width='90%'>\n";
   echo "<tr>\n";
   echo "<th>Login</th>
         <th>Logout</th>
         <th>Duration</th>";
   echo "</tr>\n";

   while($linhaTimes = mysqli_fetch_assoc($resultadoTimes)) {
     echo "<tr>\n";
     //  echo "$sqlTimes";
     
     $timeLogin = trim($linhaTimes['timeLogin']);
     $timeLogout = trim($linhaTimes['timeLogout']);
     $loginLogout = trim($linhaTimes['loginLogout']);
     
     if ($timeLogout!=0) { // caso em se fez o registo da sua saída
       //  setlocale(LC_TIME, "pt_PT");
       setlocale(LC_ALL,"pt_PT");
       $timeLogin=strftime("%Y/%m/%e %R:%M",$timeLogin);
       $timeLogout=strftime("%Y/%m/%e %R:%M",$timeLogout);
       $loginLogout=strftime("%M",$loginLogout);
       
       echo "<td>$timeLogin</td>
             <td>$timeLogout</td>
             <td>$loginLogout min</td>\n";
     }
     else { // não se fez o registo da saída
       $timeLogin=strftime("%Y/%m/%e %R:%M",$timeLogin);
       echo "<td colspan='3'>$timeLogin</td>";
     }      
     echo "</tr>\n";
   }
   echo "</table>";
   echo "</center>\n";
 }
?>

<p>&nbsp;</p>

<hr>


<?php
  require($entradaFILE.'footer.php');
?>
