<?php 
session_start();
/*
 * Administation/lastLogsPerUser.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

require_once("../servidor.php");

$pTipoUtilizador = $_SESSION['tipoUtilizador'];
if ($pTipoUtilizador=="anonymous" || $pTipoUtilizador=="regular") { // separa por tipo de utilizador
  require($entradaFILE.'headerUsers.php');
  require($entradaFILE.'menuAdmins.php');
  echo "<meta http-equiv='refresh' content='0; url=".$entradaURL."users.php' />";
  exit;  // os anonimos não têem acesso a esta página
}
else {
  require($entradaFILE.'headerAdmins.php');
  require($entradaFILE.'menuAdmins.php');
}

// coloca o valor para a página de ajuda apropriada
$_SESSION['helpsection']='logs';

require_once($entradaFILE.'dbLogin.php');

?>

<center>
<h2 class="maketitle">GeoThms - Geometry Framework</h2>
</center>

<?php

$sqlUsersIds   = "SELECT userId,username
                    FROM users";

$resultadoUsersIds = mysqli_query($ligacao,$sqlUsersIds); 


// Tabela com valores
echo "<center>\n";
echo "<table border='1' width='90%'>\n";
echo "<tr>\n";
echo "<th>Id.</th>
      <th>User name</th>
      <th>Last login</th>
      <th>Logout</th>
      <th>Duração</th>
      <th>Records</th>\n";
while ($linhaUsersIds = mysqli_fetch_assoc($resultadoUsersIds)) {
  $userId = trim($linhaUsersIds['userId']);
  $userName = trim($linhaUsersIds['username']);

  echo "<tr>\n";
  echo "<td align='center'>$userId</td>
        <td>$userName</td>\n";

  $sqlMaxTimeLogin = "SELECT MAX(timeLogin) 
                        FROM logs 
                       WHERE userId=$userId
                         AND websystem='GeoThms'";


  $resultadoMaxTimeLogin = mysqli_query($ligacao,$sqlMaxTimeLogin); 
  $linhaMaxTimeLogin = mysqli_fetch_assoc($resultadoMaxTimeLogin);

  $maxTimeLogin = trim($linhaMaxTimeLogin['MAX(timeLogin)']);


  if ($maxTimeLogin!=0) { // caso em que o utilizador já entrou pelo menos 
    // uma vez, após se começar a fazer os registos 
    $sqlTimes = "SELECT timeLogin,timeLogout,loginLogout
                   FROM logs 
                  WHERE userId=$userId
                    AND timeLogin=$maxTimeLogin
                    AND websystem='GeoThms'";


    //  echo "$sqlTimes";
    
    $resultadoTimes = mysqli_query($ligacao,$sqlTimes); 
    $linhaTimes = mysqli_fetch_assoc($resultadoTimes);
    
    $timeLogin = trim($linhaTimes['timeLogin']);
    $timeLogout = trim($linhaTimes['timeLogout']);
    $loginLogout = trim($linhaTimes['loginLogout']);
    
    if ($timeLogout!=0) { // caso em se fez o registo da sua saída
      //  setlocale(LC_TIME, "pt_PT");
      setlocale(LC_ALL,"pt_PT");
      $maxTimeLogin=strftime("%Y/%m/%e %R:%M",$maxTimeLogin);
      $timeLogout=strftime("%Y/%m/%e %R:%M",$timeLogout);
      $loginLogout=strftime("%M",$loginLogout);
      
      echo "<td>$maxTimeLogin</td>
            <td>$timeLogout</td>
            <td>$loginLogout min</td>
            <td align='center'>
              <a href='userlog.php?userId=$userId&username=$userName'>login records</a>
            </td>\n";
    }
    else {
      $maxTimeLogin=strftime("%Y/%m/%e %R:%M",$maxTimeLogin);
      echo "<td colspan='3'>$maxTimeLogin</td>
            <td align='center'>
              <a href='userlog.php?userId=$userId&username=$userName'>login records</a>
            </td>\n";
    }      
  }
  else {
    echo "<td colspan='4'>No records since  2007/6/12</td>\n";
  }
  echo "</tr>\n";
 }
echo "</table>";
echo "</center>\n";
?>

<p>&nbsp;</p>

<hr>


<?php
  require($entradaFILE.'footer.php');
?>
