<?php 
session_start();
/*
 * Administation/lastLogsPerUser.php
 * 
 * Copyright 2009, 2018 Pedro Quaresma <pedro@mat.uc.pt>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

require_once("../servidor.php");

$pTipoUtilizador = $_SESSION['tipoUtilizador'];
if ($pTipoUtilizador=="anonymous" || $pTipoUtilizador=="regular") { // separa por tipo de utilizador
  require($entradaFILE.'headerUsers.php');
  require($entradaFILE.'menuAdmins.php');
  echo "<meta http-equiv='refresh' content='0; url=".$entradaURL."users.php' />";
  exit;  // os anonimos não têem acesso a esta página
}
else {
  require($entradaFILE.'headerAdmins.php');
  require($entradaFILE.'menuAdmins.php');
}

// coloca o valor para a página de ajuda apropriada
$_SESSION['helpsection']='logs';

require_once($entradaFILE.'dbLogin.php');

?>

<center>
<h2 class="maketitle">GeoThms - Geometry Framework</h2>
</center>

<hr/>

<?php


$sqlTimes = "SELECT userId,timeLogin,timeLogout,loginLogout
               FROM logs 
              WHERE websystem='GeoThms'
           ORDER BY timeLogin DESC
              LIMIT  0,10";

$resultadoTimes = mysqli_query( $ligacao,$sqlTimes); 



// Tabela com valores
echo "<center>\n";
echo "<table border='1' width='90%'>\n";
echo "<tr>\n";
echo "<th>Id.</th>
      <th>User name</th>
      <th>Login</th>
      <th>Logout</th>
      <th>Duration</th>
      <th>Records</th>\n";
echo "</tr>\n";
while ($linhaTimes = mysqli_fetch_assoc($resultadoTimes)) {
  echo "<tr>\n";
  $userId = trim($linhaTimes['userId']);
  $timeLogin = trim($linhaTimes['timeLogin']);
  $timeLogout = trim($linhaTimes['timeLogout']);
  $loginLogout = trim($linhaTimes['loginLogout']);

  $sqlUsersIds   = "SELECT userId,username
                      FROM users
                     WHERE userId=$userId";

  $resultadoUsersIds = mysqli_query( $ligacao,$sqlUsersIds); 
  $linhaUsersIds = mysqli_fetch_assoc($resultadoUsersIds);
  $userName = trim($linhaUsersIds['username']);

  $timeLoginFormated   = strftime("%Y/%m/%e %R:%M",$timeLogin);
  $timeLogoutFormated  = strftime("%Y/%m/%e %R:%M",$timeLogout);
  $loginLogoutFormated = strftime("%M",$loginLogout);

  echo "<td>$userId</td>
        <td>$userName</td>
        <td>$timeLoginFormated</td>\n";
  if ($timeLogout==0)
    echo "<td>&nbsp;</td>\n";
  else
    echo "<td>$timeLogoutFormated</td>\n";
  if ($timeLogout==0 && $loginLogout==0)
    echo "<td>&nbsp;</td>\n";
  else
    echo "<td>$loginLogoutFormated min</td>\n";
  echo "<td align='center'>
         <a href='userlog.php?userId=$userId&username=$userName'>login records</a>
        </td>\n";  
  echo "</tr>\n";
 }
echo "</table>";
echo "</center>\n";
?>

<hr>
<p>&nbsp;</p>





<?php
  require($entradaFILE.'footer.php');
?>
