<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/">
<html>
	<head>
		<style> 
			font.name		{font: italic;}			
		</style>
	</head>

	<body>

	<xsl:for-each select="figure">
		<br/>	
		<font color="#0000ff">
		<xsl:text>Description of construction: </xsl:text>
		</font>
		<br/>	
		<br/>	
		<hr/>
		<br/>	
		<xsl:apply-templates />
		<hr/>
		<font color="#0000ff">
		<xsl:text>Transformed by GCLC-XML package (2006)</xsl:text>
		</font>
	</xsl:for-each>

	</body>
</html>
</xsl:template>

<!--**************introducing points**************-->

<xsl:template match="define">
	<font color="#DD0000">
	<xsl:text> Let us define the following fixed points: </xsl:text>
	</font>
	<br/>	
	<ul>
	<xsl:apply-templates /> 		
	</ul>
	<br/>	
</xsl:template>


<xsl:template match="fixed_point">
	<li>Let 
	<font class="name"><xsl:value-of select="."/></font>
	<xsl:text> be a point with Cartesian coordinates (</xsl:text>	
	<xsl:value-of select="@x"/>,
	<xsl:value-of select="@y"/>).	
	<br/>	</li>
</xsl:template>


<!--**************objects**************-->


<xsl:template match="segment">
	<li>The segment with endpoints 
	<font class="name"><xsl:value-of select="point[1]"/></font> and <font class="name"><xsl:value-of select="point[2]"/></font>. 
	<br/></li>
</xsl:template>

<xsl:template match="vector">
	<li>A vector determined by the points (
	<font class="name"><xsl:value-of select="point[1]"/></font> and <font class="name"><xsl:value-of select="point[2]"/></font>). 
	<br/>	</li>
</xsl:template>

<xsl:template match="line">
	<li>Line with the name 
	<font class="name"><xsl:value-of select="."/>.</font>
	<br/>	</li>
</xsl:template>

<xsl:template match="line_pp">
	<li>A line determined by the points 
	<font class="name"><xsl:value-of select="point[1]"/></font>, <font class="name"><xsl:value-of select="point[2]"/></font>. 
	<br/>	</li>
</xsl:template>


<xsl:template match="circle_cp">
	<li>A circle determined by the center 
	<font class="name"><xsl:value-of select="center"/></font> and the point <font class="name"><xsl:value-of select="point"/></font>). 
	<br/>	</li>
</xsl:template>

<xsl:template match="arc">
	<li>(
	<font class="name"><xsl:value-of select="center"/></font>, <font class="name"><xsl:value-of select="point"/></font>, 
<font class="name"><xsl:value-of select="angle"/></font>).
	<br/></li>
</xsl:template>


<!--**************constructions**************-->

<xsl:template match="construct">
	<font color="#00AAAA">
	<xsl:text>Let us construct the following objects:</xsl:text>
	</font>
	<br/>	
	<ul>
	<xsl:apply-templates /> 
	</ul>						
	<br/>	
</xsl:template>


<xsl:template match="new_point">
	<xsl:text>   new_point: </xsl:text>
	<font class="name"><xsl:value-of select="."/></font> 
</xsl:template>

<xsl:template match="intersection">
	<li>A point 
	<font class="name"><xsl:value-of select="new_point"/></font> 
	<xsl:text> such that it is a intersection of the lines </xsl:text>
	<font class="name"><xsl:value-of select="line[1]"/></font> and <font class="name"><xsl:value-of select="line[2]"/></font>. 
	<br/>	</li>
</xsl:template>

<xsl:template match="intersection_cc">
	<li>A points 
	<font class="name"><xsl:value-of select="new_point[1]"/></font> and <font class="name"><xsl:value-of select="new_point[2]"/></font>)  
	<xsl:text> such that they are a intersection of the circles </xsl:text>
	<font class="name"><xsl:value-of select="circle[1]"/></font>, <font class="name"><xsl:value-of select="circle[2]"/></font>. 
	<br/>	</li>
</xsl:template>

<xsl:template match="intersection_cl">
	<li>A points 
	<font class="name"><xsl:value-of select="new_point[1]"/></font> and <font class="name"><xsl:value-of select="new_point[2]"/></font>  
	<xsl:text> such that they are a intersection of the circle </xsl:text>
	<font class="name"><xsl:value-of select="circle"/></font> and the line <font class="name"><xsl:value-of select="line"/></font>.
	<br/>	</li>
</xsl:template>

<xsl:template match="midpoint">
	<li>A point 
	<font class="name"><xsl:value-of select="new_point"/></font>  
	such that it is a midpoint of the segment 
	<font class="name"><xsl:value-of select="point[1]"/></font><font class="name"><xsl:value-of select="point[2]"/></font>. 
	<br/>	</li>
</xsl:template>

<xsl:template match="foot">
	<li>
	<font class="name"><xsl:value-of select="new_point"/></font>  
	<xsl:text> = foot (</xsl:text>
	<font class="name"><xsl:value-of select="point"/></font>, <font class="name"><xsl:value-of select="line"/></font>). 
	<br/>	</li>
</xsl:template>

<xsl:template match="random_point_on_line ">
	<li>A point 
	<font class="name"><xsl:value-of select="new_point"/></font>  
	<xsl:text> such that it is a random point on line determined by points </xsl:text>
	<font class="name"><xsl:value-of select="point[1]"/></font> and <font class="name"><xsl:value-of select="point[2]"/></font>. 
	<br/>	</li>
</xsl:template>

<xsl:template match="translate">
	<li>A point 
	<font class="name"><xsl:value-of select="new_point"/></font>  
	such that it is a translated point <font class="name"><xsl:value-of select="point"/></font>
	by vector determined by the points <font class="name"><xsl:value-of select="vector/point[1]"/></font>
     and
	<font class="name"><xsl:value-of select="vector/point[2]"/></font>). 
	<br/>	</li>
</xsl:template>

<xsl:template match="towards">
	<li>A point
	<font class="name"><xsl:value-of select="new_point"/></font>  
	<xsl:text> = towards (</xsl:text>
	<xsl:text>vector (</xsl:text><font class="name"><xsl:value-of select="vector/point[1]"/></font>,
	<font class="name"><xsl:value-of select="vector/point[2]"/></font>), <font class="name"><xsl:value-of select="coefficient"/></font>). 
	<br/>	</li>
</xsl:template>

<xsl:template match="rotate ">
	<li> 
	<font class="name"><xsl:value-of select="new_point"/></font>  
	<xsl:text> = rotate (</xsl:text>
	<font class="name"><xsl:value-of select="center"/></font>, <font class="name"><xsl:value-of select="angle"/></font>, 
	<font class="name"><xsl:value-of select="point"/></font>).	
	<br/>	</li>
</xsl:template>

<xsl:template match="half_turn ">
	<li>A point 
	<font class="name"><xsl:value-of select="new_point"/></font>  
	such that it is an image of the point <font class="name"><xsl:value-of select="point"/></font>
	in the half-turn with the center <font class="name"><xsl:value-of select="center"/></font>.
	<br/>	</li>
</xsl:template>

<xsl:template match="line_reflection ">
	<li> 
	<font class="name"><xsl:value-of select="new_point"/></font>  
	<xsl:text> = line_reflection (</xsl:text>
	<font class="name"><xsl:value-of select="line"/></font>, <font class="name"><xsl:value-of select="point"/></font>).	
	<br/>	</li>
</xsl:template>

<xsl:template match="inversion ">
	<li> 
	<font class="name"><xsl:value-of select="new_point"/></font>  
	<xsl:text> = inversion (</xsl:text>
	<font class="name"><xsl:value-of select="circle"/></font>, <font class="name"><xsl:value-of select="point"/></font>).
	<br/>	</li>
</xsl:template>


<xsl:template match="new_line">
	<xsl:text>   new_line: </xsl:text>
	<font class="name"><xsl:value-of select="."/></font> 	
</xsl:template>

<xsl:template match="ruler ">
	<li>A line 
	<font class="name"><xsl:value-of select="new_line"/></font> determined by the points
	<font class="name"><xsl:value-of select="point[1]"/></font> and <font class="name"><xsl:value-of select="point[2]"/></font>.		
	<br/>	</li>
</xsl:template>

<xsl:template match="paralel">
	<li>A line 
	<font class="name"><xsl:value-of select="new_line"/></font>  
	such that is parallel with a line <font class="name"><xsl:value-of select="line"/></font>
      and conteins a point
	<font class="name"><xsl:value-of select="point"/></font>.
	<br/>	</li>
</xsl:template>

<xsl:template match="perpendicular ">
	<li> 
	<font class="name"><xsl:value-of select="new_line"/></font>  
	<xsl:text> = perpendicular (</xsl:text>
	<font class="name"><xsl:value-of select="point"/></font>, <font class="name"><xsl:value-of select="line"/></font>).
	<br/>	</li>
</xsl:template>

<xsl:template match="segment_bisector ">
	<li>A line 
	<font class="name"><xsl:value-of select="new_line"/></font>  
	such that it is a bisector of the segment
	<font class="name"><xsl:value-of select="point"/></font><font class="name"><xsl:value-of select="point"/></font>.
	<br/>	</li>
</xsl:template>

<xsl:template match="angle_bisector ">
	<li>A line 
	<font class="name"><xsl:value-of select="new_line"/></font>  
	such that it is a bisector of the angle determined by the points 
	<font class="name"><xsl:value-of select="point[1]"/></font>, <font class="name"><xsl:value-of select="point[2]"/></font> and 
	 <font class="name"><xsl:value-of select="point[3]"/></font>.
	<br/>	</li>
</xsl:template>


<xsl:template match="new_circle">
	<xsl:text>   new_circle: </xsl:text>
	<font class="name"><xsl:value-of select="."/></font> 	
</xsl:template>

<xsl:template match="compass ">
	<li>
	<font class="name"><xsl:value-of select="new_circle"/></font>  
	<xsl:text> = circle (</xsl:text>
	<font class="name"><xsl:value-of select="center"/></font>, <font class="name"><xsl:value-of select="point"/></font>).
	<br/>	</li>
</xsl:template>


<!--**************drawing**************-->



<xsl:template match="draw[@dashed='no']">			
	<font color="#0000DD">
	<xsl:text>Let us draw the following objects: </xsl:text>
	</font>
	<br/>
	<ul>
	<xsl:apply-templates /> 
	</ul>						
	<br/>
</xsl:template>


<xsl:template match="draw[@dashed='yes']">			
	<font color="#0000DD">
	<xsl:text>Let us draw (using dashed style) the following objects: </xsl:text>
	</font>
	<br/>
	<ul>
	<xsl:apply-templates /> 
	</ul>
	<br/>	
</xsl:template>

<xsl:template match="area">
	<li>Visible area: 
	left-bottom corner (<xsl:value-of select="@x1"/>,<xsl:value-of select="@y1"/>),
	right-top corner (<xsl:value-of select="@x2"/>, <xsl:value-of select="@y2"/>).
	<br/>	</li>
</xsl:template>



<!--**************labeling**************-->


<xsl:template match="labels">
	<font color="#DD00DD">
	<xsl:text>Let us denote the following points:</xsl:text>
	</font>
	<br/>	
	<ul>
	<xsl:apply-templates /> 						
	</ul>
	<br/>	
</xsl:template>

<xsl:template match="point_label">
	<li>The point
	<font class="name"><xsl:value-of select="point"/></font> in
	<xsl:value-of select="@direction"/> direction.
	<br/></li>
</xsl:template>

<xsl:template match="text_label">
	<li>The point 
	<font class="name"><xsl:value-of select="point"/></font>, by the text  
	<xsl:value-of select="text"/>, in 
	<xsl:value-of select="@direction"/> direction.
	<br/></li>
</xsl:template>

</xsl:stylesheet>